/*
 * Decompiled with CFR 0.152.
 */
package gradle_clojure.plugin.tasks;

import gradle_clojure.plugin.internal.ClojureWorkerExecutor;
import gradle_clojure.plugin.tasks.ClojureCompileOptions;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.process.JavaForkOptions;
import org.gradle.workers.WorkerExecutor;

public class ClojureCompile
extends AbstractCompile {
    private static final Logger logger = Logging.getLogger(ClojureCompile.class);
    private final ClojureWorkerExecutor workerExecutor;
    private final ClojureCompileOptions options;
    private List<String> namespaces = Collections.emptyList();
    private static final Map<Character, String> CHAR_MAP = new HashMap<Character, String>();
    private static final Map<String, Character> DEMUNGE_MAP;
    private static final Pattern DEMUNGE_PATTERN;

    @Inject
    public ClojureCompile(WorkerExecutor workerExecutor) {
        this.workerExecutor = new ClojureWorkerExecutor(this.getProject(), workerExecutor);
        this.options = new ClojureCompileOptions();
    }

    @Nested
    public ClojureCompileOptions getOptions() {
        return this.options;
    }

    public void options(Action<? super ClojureCompileOptions> configureAction) {
        configureAction.execute((Object)this.options);
    }

    @Input
    public List<String> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(List<String> namespaces) {
        this.namespaces = namespaces;
    }

    @TaskAction
    public void compile() {
        if (!this.getProject().delete(new Object[]{this.getDestinationDir()})) {
            throw new GradleException("Cannot clean destination directory: " + this.getDestinationDir().getAbsolutePath());
        }
        if (!this.getDestinationDir().mkdirs()) {
            throw new GradleException("Cannot create destination directory: " + this.getDestinationDir().getAbsolutePath());
        }
        if (this.options.isCopySourceSetToOutput()) {
            this.getProject().copy(spec -> {
                spec.from(new Object[]{this.getSource()});
                spec.into((Object)this.getDestinationDir());
            });
            return;
        }
        if (this.options.isAotCompile()) {
            List<String> namespaces = this.getNamespaces();
            if (namespaces.isEmpty()) {
                logger.warn("No Clojure namespaces defined, skipping {}", (Object)this.getName());
                return;
            }
            logger.info("Compiling {}", (Object)String.join((CharSequence)", ", namespaces));
            FileCollection classpath = this.getClasspath().plus((FileCollection)this.getProject().files(new Object[]{this.getSourceRootsFiles()})).plus((FileCollection)this.getProject().files(new Object[]{this.getDestinationDir()}));
            this.workerExecutor.submit((Action<ClojureWorkerExecutor.ClojureWorkerConfiguration>)((Action)config -> {
                config.setClasspath(classpath);
                config.setNamespace("gradle-clojure.tools.clojure-compiler");
                config.setFunction("compiler");
                config.setArgs(this.getSourceRoots(), this.getDestinationDir(), this.getOptions(), namespaces);
                config.forkOptions((Action<JavaForkOptions>)((Action)fork -> {
                    fork.setJvmArgs(this.options.getForkOptions().getJvmArgs());
                    fork.setMinHeapSize(this.options.getForkOptions().getMemoryInitialSize());
                    fork.setMaxHeapSize(this.options.getForkOptions().getMemoryMaximumSize());
                    fork.setDefaultCharacterEncoding(StandardCharsets.UTF_8.name());
                }));
            }));
        }
    }

    public List<String> findNamespaces() {
        Set<String> roots = this.getSourceRoots();
        return StreamSupport.stream(this.getSource().spliterator(), false).filter(it -> it.getName().endsWith(".clj") || it.getName().endsWith(".cljc")).map(it -> this.findNamespace((File)it, roots)).collect(Collectors.toList());
    }

    private String findNamespace(File file, Set<String> roots) {
        try {
            String namespace = ClojureCompile.demunge(file.getName().substring(0, file.getName().lastIndexOf(46)));
            for (File current = file.getParentFile(); current != null; current = current.getParentFile()) {
                if (roots.contains(current.getCanonicalPath())) {
                    return namespace;
                }
                namespace = ClojureCompile.demunge(current.getName()) + "." + namespace;
            }
            throw new RuntimeException("No source root found for " + file.getCanonicalPath());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Internal
    private Set<String> getSourceRoots() {
        return this.getSourceRootsFiles().stream().map(it -> {
            try {
                return it.getCanonicalPath();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).collect(Collectors.toSet());
    }

    @Internal
    private List<File> getSourceRootsFiles() {
        return this.source.stream().filter(it -> it instanceof SourceDirectorySet).flatMap(it -> ((SourceDirectorySet)it).getSrcDirs().stream()).collect(Collectors.toList());
    }

    private static String munge(String name) {
        StringBuilder sb = new StringBuilder();
        name.chars().forEach(c -> {
            if (CHAR_MAP.containsKey(c)) {
                sb.append(CHAR_MAP.get(c));
            } else {
                sb.append(c);
            }
        });
        return sb.toString();
    }

    private static String demunge(String mungedName) {
        StringBuilder sb = new StringBuilder();
        Matcher m = DEMUNGE_PATTERN.matcher(mungedName);
        int lastMatchEnd = 0;
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            sb.append(mungedName.substring(lastMatchEnd, start));
            lastMatchEnd = end;
            char origCh = DEMUNGE_MAP.get(m.group()).charValue();
            sb.append(origCh);
        }
        sb.append(mungedName.substring(lastMatchEnd));
        return sb.toString();
    }

    static {
        CHAR_MAP.put(Character.valueOf('-'), "_");
        CHAR_MAP.put(Character.valueOf(':'), "_COLON_");
        CHAR_MAP.put(Character.valueOf('+'), "_PLUS_");
        CHAR_MAP.put(Character.valueOf('>'), "_GT_");
        CHAR_MAP.put(Character.valueOf('<'), "_LT_");
        CHAR_MAP.put(Character.valueOf('='), "_EQ_");
        CHAR_MAP.put(Character.valueOf('~'), "_TILDE_");
        CHAR_MAP.put(Character.valueOf('!'), "_BANG_");
        CHAR_MAP.put(Character.valueOf('@'), "_CIRCA_");
        CHAR_MAP.put(Character.valueOf('#'), "_SHARP_");
        CHAR_MAP.put(Character.valueOf('\''), "_SINGLEQUOTE_");
        CHAR_MAP.put(Character.valueOf('\"'), "_DOUBLEQUOTE_");
        CHAR_MAP.put(Character.valueOf('%'), "_PERCENT_");
        CHAR_MAP.put(Character.valueOf('^'), "_CARET_");
        CHAR_MAP.put(Character.valueOf('&'), "_AMPERSAND_");
        CHAR_MAP.put(Character.valueOf('*'), "_STAR_");
        CHAR_MAP.put(Character.valueOf('|'), "_BAR_");
        CHAR_MAP.put(Character.valueOf('{'), "_LBRACE_");
        CHAR_MAP.put(Character.valueOf('}'), "_RBRACE_");
        CHAR_MAP.put(Character.valueOf('['), "_LBRACK_");
        CHAR_MAP.put(Character.valueOf(']'), "_RBRACK_");
        CHAR_MAP.put(Character.valueOf('/'), "_SLASH_");
        CHAR_MAP.put(Character.valueOf('\\'), "_BSLASH_");
        CHAR_MAP.put(Character.valueOf('?'), "_QMARK_");
        DEMUNGE_MAP = CHAR_MAP.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        DEMUNGE_PATTERN = Pattern.compile(DEMUNGE_MAP.keySet().stream().sorted(Comparator.comparingInt(String::length).reversed()).map(it -> "\\Q" + it + "\\E").collect(Collectors.joining("|")));
    }
}

