/*
 * Decompiled with CFR 0.152.
 */
package gradle_clojure.plugin.internal;

import gradle_clojure.plugin.internal.ClojureWorker;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.process.JavaForkOptions;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.WorkerConfiguration;
import org.gradle.workers.WorkerExecutor;

public class ClojureWorkerExecutor {
    private static final String SHIMDANDY_VERSION = "1.2.0";
    private static final String NREPL_VERSION = "0.2.12";
    private static final String GRADLE_CLOJURE_VERSION = ClojureWorkerExecutor.getVersion();
    private final Project project;
    private final WorkerExecutor workerExecutor;

    public ClojureWorkerExecutor(Project project, WorkerExecutor workerExecutor) {
        this.project = project;
        this.workerExecutor = workerExecutor;
    }

    public void await() {
        this.workerExecutor.await();
    }

    public void submit(Action<ClojureWorkerConfiguration> action) {
        ClojureWorkerConfiguration config = new ClojureWorkerConfiguration();
        action.execute((Object)config);
        FileCollection realClasspath = config.getClasspath().plus(this.resolveShim());
        this.workerExecutor.submit(ClojureWorker.class, worker -> {
            worker.setIsolationMode(IsolationMode.PROCESS);
            worker.params(new Object[]{config.getNamespace(), config.getFunction(), config.getArgs()});
            config.getConfigureFork().forEach(arg_0 -> ((WorkerConfiguration)worker).forkOptions(arg_0));
            worker.forkOptions(fork -> {
                fork.systemProperty("shim.classpath", (Object)realClasspath.getAsPath());
                String logLevel = Optional.ofNullable(this.project.findProperty("gradle-clojure.tools.logger.level")).map(Object::toString).orElseGet(this::getGradleLogLevel);
                fork.systemProperty("gradle-clojure.tools.logger.level", (Object)logLevel);
            });
            worker.classpath((Iterable)this.resolveWorker());
        });
    }

    private FileCollection resolveWorker() {
        Dependency shim = this.project.getDependencies().create((Object)"org.projectodd.shimdandy:shimdandy-api:1.2.0");
        return this.project.getConfigurations().detachedConfiguration(new Dependency[]{shim});
    }

    private FileCollection resolveShim() {
        Dependency shimImpl = this.project.getDependencies().create((Object)"org.projectodd.shimdandy:shimdandy-impl:1.2.0");
        Dependency tools = this.project.getDependencies().create((Object)("io.github.gradle-clojure:gradle-clojure-tools:" + GRADLE_CLOJURE_VERSION));
        Dependency nrepl = this.project.getDependencies().create((Object)"org.clojure:tools.nrepl:0.2.12");
        return this.project.getConfigurations().detachedConfiguration(new Dependency[]{shimImpl, tools, nrepl}).setTransitive(false);
    }

    private String getGradleLogLevel() {
        return Stream.of(LogLevel.DEBUG, LogLevel.INFO, LogLevel.LIFECYCLE, LogLevel.WARN, LogLevel.QUIET, LogLevel.ERROR).filter(arg_0 -> ((Logger)this.project.getLogger()).isEnabled(arg_0)).map(Enum::toString).map(String::toLowerCase).findFirst().orElse("info");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getVersion() {
        try (InputStream stream = ClojureWorkerExecutor.class.getResourceAsStream("/gradle-clojure.properties");){
            Properties props = new Properties();
            props.load(stream);
            String string = props.getProperty("version");
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static class ClojureWorkerConfiguration {
        private FileCollection classpath;
        private String namespace;
        private String function;
        private Object[] args = new Object[0];
        private List<Action<JavaForkOptions>> configureFork = new ArrayList<Action<JavaForkOptions>>();

        public FileCollection getClasspath() {
            return this.classpath;
        }

        public void setClasspath(FileCollection classpath) {
            this.classpath = classpath;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public String getFunction() {
            return this.function;
        }

        public void setFunction(String function) {
            this.function = function;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public void setArgs(Object ... args) {
            this.args = args;
        }

        public List<Action<JavaForkOptions>> getConfigureFork() {
            return this.configureFork;
        }

        public void forkOptions(Action<JavaForkOptions> configureFork) {
            this.configureFork.add(configureFork);
        }
    }
}

