(ns fourteatoo.familee.log
  (:require
   [unilog.config :refer [start-logging!]]
   [clojure.tools.logging :as log]
   [mount.core :as mount]
   [fourteatoo.familee.conf :refer [conf]]))


(defn setup-logging [& [config]]
  (let [default-config {:level "info" :console true}]
    (start-logging! (merge default-config config))))

(mount/defstate logging-service
  :start (setup-logging (conf :logging)))

(defmacro log [& args]
  `(log/log ~@args))

(defmacro trace [& args]
  `(log/trace ~@args))

(defmacro debug [& args]
  `(log/debug ~@args))

(defmacro info [& args]
  `(log/info ~@args))

(defmacro warn [& args]
  `(log/warn ~@args))

(defmacro error [& args]
  `(log/error ~@args))

(defmacro fatal [& args]
  `(log/fatal ~@args))

