/*
 * Decompiled with CFR 0.152.
 */
package io.github.erdos.stencil.impl;

import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class LifecycleLock
implements AutoCloseable {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final AtomicBoolean alive = new AtomicBoolean(true);
    private final Runnable cleanup;

    public LifecycleLock(Runnable runnable) {
        this.cleanup = Objects.requireNonNull(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T execute(List<LifecycleLock> list, Callable<T> callable) throws Exception {
        if (list.isEmpty()) {
            return callable.call();
        }
        ListIterator<LifecycleLock> listIterator = list.listIterator();
        try {
            while (listIterator.hasNext()) {
                listIterator.next().acquireReadLockAndCheck();
            }
            T t = callable.call();
            return t;
        }
        finally {
            while (listIterator.hasPrevious()) {
                listIterator.previous().lock.readLock().unlock();
            }
        }
    }

    private void acquireReadLockAndCheck() {
        this.lock.readLock().lock();
        if (!this.alive.get()) {
            throw new IllegalStateException("Component has already been closed.");
        }
    }

    @Override
    public void close() throws Exception {
        if (this.alive.get()) {
            this.lock.writeLock().lock();
            try {
                if (this.alive.getAndSet(false)) {
                    this.cleanup.run();
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }
}

