/*
 * Decompiled with CFR 0.152.
 */
package io.github.erdos.stencil.impl;

import io.github.erdos.stencil.PrepareOptions;
import io.github.erdos.stencil.PreparedFragment;
import io.github.erdos.stencil.PreparedTemplate;
import io.github.erdos.stencil.TemplateDocumentFormats;
import io.github.erdos.stencil.TemplateFactory;
import io.github.erdos.stencil.exceptions.ParsingException;
import io.github.erdos.stencil.impl.ClojureHelper;
import java.io.File;
import java.util.Optional;

public final class NativeTemplateFactory
implements TemplateFactory {
    @Override
    public PreparedTemplate prepareTemplateFile(File file, PrepareOptions prepareOptions) {
        Optional<TemplateDocumentFormats> optional = TemplateDocumentFormats.ofExtension(file.getName());
        if (!optional.isPresent()) {
            throw new IllegalArgumentException("Unexpected type of file: " + file.getName());
        }
        if (prepareOptions == null) {
            throw new IllegalArgumentException("Template preparation options are missing!");
        }
        try {
            return (PreparedTemplate)ClojureHelper.findFunction("prepare-template").invoke((Object)file, (Object)prepareOptions);
        }
        catch (ParsingException parsingException) {
            throw parsingException;
        }
        catch (Exception exception) {
            throw ParsingException.wrapping("Could not parse template file!", exception);
        }
    }

    public PreparedFragment prepareFragmentFile(File file, PrepareOptions prepareOptions) {
        if (file == null) {
            throw new IllegalArgumentException("Fragment file parameter is null!");
        }
        if (prepareOptions == null) {
            throw new IllegalArgumentException("Template preparation options are missing!");
        }
        try {
            return (PreparedFragment)ClojureHelper.findFunction("prepare-fragment").invoke((Object)file, (Object)prepareOptions);
        }
        catch (ParsingException parsingException) {
            throw parsingException;
        }
        catch (Exception exception) {
            throw ParsingException.wrapping("Could not parse fragment template file!", exception);
        }
    }
}

