/*
 * Decompiled with CFR 0.152.
 */
package io.github.erdos.stencil.impl;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;

public final class InputStreamExceptionPropagation
extends FilterInputStream {
    private final AtomicReference<Throwable> exception = new AtomicReference<Object>(null);
    private final CountDownLatch complete = new CountDownLatch(1);

    public InputStreamExceptionPropagation(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public void close() throws IOException {
        try {
            this.complete.await();
            Throwable throwable = this.exception.get();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable != null) {
                throw new IOException("Exception while writing", throwable);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted!", interruptedException);
        }
        finally {
            this.in.close();
        }
    }

    public void fail(Throwable throwable) {
        this.exception.set(Objects.requireNonNull(throwable));
    }

    public void finish() {
        this.complete.countDown();
    }
}

