/*
 * Decompiled with CFR 0.152.
 */
package io.github.erdos.stencil.standalone;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class ArgsParser {
    private final Set<ParamMarker<?>> markers = new HashSet();
    private static final Set<String> YES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("yes", "y", "true", "t", "1")));
    private static final Set<String> NO = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("no", "n", "false", "f", "0")));
    private static final Function<String, Boolean> PARSE_BOOLEAN = string -> {
        if (YES.contains(string.toLowerCase())) {
            return true;
        }
        if (NO.contains(string.toLowerCase())) {
            return false;
        }
        throw new IllegalArgumentException("Could not parse argument value as boolean: " + string);
    };

    public <T> ParamMarker<T> addParam(char c, String string, String string2, Function<String, T> function) {
        ParamMarker paramMarker = new ParamMarker(function, c, string, string2, false);
        this.markers.add(paramMarker);
        return paramMarker;
    }

    public ParseResult parse(String ... stringArray) {
        HashMap hashMap = new HashMap();
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if ("--".equals(string)) {
                ++i;
                while (i < stringArray.length) {
                    arrayList.add(stringArray[i]);
                    ++i;
                }
                continue;
            }
            if (string.startsWith("-")) {
                Map.Entry<ParamMarker<?>, String> entry;
                Object object;
                if (string.contains("=")) {
                    object = string.split("=", 2);
                    entry = object[0];
                    String string2 = object[1];
                    Map.Entry<ParamMarker<?>, String> entry2 = this.parsePair((String)((Object)entry), string2);
                    hashMap.put(entry2.getKey(), entry2.getValue());
                    continue;
                }
                if (string.startsWith("--no-")) {
                    if (this.markerForLong(string.substring(5)).orElseThrow(() -> new IllegalArgumentException("Unexpected option: " + string)).isFlag()) {
                        object = this.parsePair(string, null);
                        hashMap.put((ParamMarker)object.getKey(), (String)object.getValue());
                        continue;
                    }
                } else if (string.startsWith("--")) {
                    if (this.markerForLong(string.substring(2)).orElseThrow(() -> new IllegalArgumentException("Unexpected option: " + string)).isFlag()) {
                        object = this.parsePair(string, null);
                        hashMap.put((ParamMarker)object.getKey(), (String)object.getValue());
                        continue;
                    }
                } else if (this.markerForShort(string.charAt(1)).orElseThrow(() -> new IllegalArgumentException("Unexpected option: " + string)).isFlag()) {
                    object = this.parsePair(string, null);
                    hashMap.put((ParamMarker)object.getKey(), (String)object.getValue());
                    continue;
                }
                Object object2 = object = i + 1 < stringArray.length ? stringArray[i + 1] : null;
                if (object == null || ((String)object).startsWith("-")) {
                    entry = this.parsePair(string, null);
                    hashMap.put((ParamMarker)entry.getKey(), entry.getValue());
                    continue;
                }
                entry = this.parsePair(string, (String)object);
                hashMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            while (i < stringArray.length) {
                arrayList.add(stringArray[i]);
                ++i;
            }
        }
        return new ParseResult(hashMap, arrayList);
    }

    private Map.Entry<ParamMarker<?>, String> parsePair(String string, String string2) {
        if (string.startsWith("--no-") && string2 == null) {
            String string3 = string.substring(5);
            ParamMarker<?> paramMarker = this.markerForLong(string3).get();
            return new AbstractMap.SimpleImmutableEntry(paramMarker, "false");
        }
        if (string.startsWith("--")) {
            String string4 = string.substring(2);
            ParamMarker<?> paramMarker = this.markerForLong(string4).get();
            if (string2 == null) {
                return new AbstractMap.SimpleImmutableEntry(paramMarker, "true");
            }
            return new AbstractMap.SimpleImmutableEntry(paramMarker, string2);
        }
        if (string.startsWith("-") && string.length() == 2 && string2 == null) {
            ParamMarker<?> paramMarker = this.markerForShort(string.charAt(1)).get();
            return new AbstractMap.SimpleImmutableEntry(paramMarker, "true");
        }
        throw new IllegalArgumentException("Unexpected key, not a parameter: " + string);
    }

    private Optional<ParamMarker<?>> markerForLong(String string) {
        return this.markers.stream().filter(paramMarker -> paramMarker.getLongName().equals(string)).findAny();
    }

    private Optional<ParamMarker<?>> markerForShort(char c) {
        return this.markers.stream().filter(paramMarker -> paramMarker.getShortForm() == c).findAny();
    }

    public ParamMarker<Boolean> addFlagOption(char c, String string, String string2) {
        ParamMarker<Boolean> paramMarker = new ParamMarker<Boolean>(PARSE_BOOLEAN, c, string, string2, true);
        this.markers.add(paramMarker);
        return paramMarker;
    }

    public static final class ParamMarker<T> {
        private final Function<String, T> parse;
        private final char shortForm;
        private final String longName;
        private final String description;
        private final boolean flag;

        private ParamMarker(Function<String, T> function, char c, String string, String string2, boolean bl) {
            this.parse = function;
            this.shortForm = c;
            this.longName = string;
            this.description = string2;
            this.flag = bl;
        }

        char getShortForm() {
            return this.shortForm;
        }

        T parse(String string) {
            return this.parse.apply(string);
        }

        public String getLongName() {
            return this.longName;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isFlag() {
            return this.flag;
        }
    }

    public static final class ParseResult {
        private final Map<ParamMarker<?>, String> args;
        private final List<String> varargs;

        private ParseResult(Map<ParamMarker<?>, String> map, List<String> list) {
            this.args = Collections.unmodifiableMap(map);
            this.varargs = Collections.unmodifiableList(list);
        }

        public List<String> getRestArgs() {
            return this.varargs;
        }

        public <T> Optional<T> getParamValue(ParamMarker<T> paramMarker) {
            if (this.args.containsKey(paramMarker)) {
                String string = this.args.get(paramMarker);
                return Optional.of(paramMarker.parse(string));
            }
            return Optional.empty();
        }
    }
}

