/*
 * Decompiled with CFR 0.152.
 */
package io.github.erdos.stencil.standalone;

import clojure.lang.RT;
import clojure.lang.Symbol;
import io.github.erdos.stencil.API;
import io.github.erdos.stencil.EvaluatedDocument;
import io.github.erdos.stencil.PrepareOptions;
import io.github.erdos.stencil.PreparedTemplate;
import io.github.erdos.stencil.TemplateData;
import io.github.erdos.stencil.impl.FileHelper;
import io.github.erdos.stencil.standalone.ArgsParser;
import io.github.erdos.stencil.standalone.Parser;
import io.github.erdos.stencil.standalone.StencilArgsParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Scanner;
import java.util.stream.Stream;

public class StandaloneApplication {
    private final ArgsParser.ParseResult parsed;
    private final File outputDir;
    private final boolean overwriteOutput;
    private final PrepareOptions prepareOptions;

    public StandaloneApplication(ArgsParser.ParseResult parseResult) {
        this.parsed = parseResult;
        this.outputDir = StencilArgsParser.getOutputDirectory(parseResult);
        this.overwriteOutput = StencilArgsParser.getOutputOverwritten(parseResult);
        this.prepareOptions = StencilArgsParser.getOnlyIncludes(parseResult) != false ? PrepareOptions.options().withOnlyIncludes() : PrepareOptions.options();
    }

    private void checkRestFilesExist() {
        for (String string : this.parsed.getRestArgs()) {
            if (new File(string).exists()) continue;
            throw new IllegalArgumentException("File does not exist: " + string);
        }
    }

    public void run() throws IOException {
        this.checkRestFilesExist();
        Iterator<String> iterator = this.jobsIterator();
        if (this.parsed.getParamValue(StencilArgsParser.SHOW_VERSION).orElse(false).booleanValue()) {
            this.displayVersionInfo();
        } else if (!iterator.hasNext() || this.parsed.getParamValue(StencilArgsParser.SHOW_HELP).orElse(false).booleanValue()) {
            this.displayHelpInfo();
        } else {
            try {
                this.processJobs(iterator);
            }
            catch (EndOfFilesException endOfFilesException) {
                // empty catch block
            }
        }
    }

    private void processJobs(Iterator<String> iterator) throws IOException {
        while (iterator.hasNext()) {
            File file = new File(iterator.next()).getAbsoluteFile();
            PreparedTemplate preparedTemplate = API.prepare(file, this.prepareOptions);
            while (iterator.hasNext()) {
                File file2 = new File(iterator.next()).getAbsoluteFile();
                Optional<Parser.DataFileFormat> optional = Parser.maybeDataFileFormat(file2);
                if (!optional.isPresent()) {
                    throw new IllegalArgumentException("Unknown extension, only JSON and EDN are supported: " + file2);
                }
                Object object = optional.get().parse(file2);
                if (!(object instanceof Map)) {
                    throw new IllegalArgumentException("Template data is not a map in file: " + file2 + " of " + object.getClass());
                }
                TemplateData templateData = TemplateData.fromMap((Map)object);
                EvaluatedDocument evaluatedDocument = API.render(preparedTemplate, templateData);
                File file3 = StandaloneApplication.targetFile(this.outputDir, file, file2);
                if (file3.exists() && this.overwriteOutput) {
                    FileHelper.forceDelete(file3);
                }
                evaluatedDocument.writeToFile(file3);
            }
        }
    }

    private Iterator<String> jobsIterator() {
        Optional<File> optional = this.parsed.getParamValue(StencilArgsParser.JOBS_FILE);
        Optional<Boolean> optional2 = this.parsed.getParamValue(StencilArgsParser.JOBS_FROM_STDIN);
        if (optional2.isPresent() && optional.isPresent()) {
            throw new IllegalArgumentException("Can not specify both the --stdin and --jobs parameters!");
        }
        if (optional.isPresent()) {
            if (!this.parsed.getRestArgs().isEmpty()) {
                throw new IllegalArgumentException("Can not specify both --jobs and template parameters!");
            }
            try {
                return Files.lines(optional.get().toPath()).iterator();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        if (optional2.isPresent()) {
            if (!this.parsed.getRestArgs().isEmpty()) {
                throw new IllegalArgumentException("Can not specify both --stdin and template parameters!");
            }
            return Stream.generate(() -> {
                try {
                    return new Scanner(System.in).nextLine();
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw new EndOfFilesException();
                }
            }).iterator();
        }
        return this.parsed.getRestArgs().iterator();
    }

    private static File targetFile(File file, File file2, File file3) {
        String string = FileHelper.removeExtension(file2);
        String string2 = FileHelper.removeExtension(file3);
        String string3 = FileHelper.extension(file2);
        return new File(file, string + "-" + string2 + "." + string3);
    }

    private void displayHelpInfo() throws IOException {
        URL uRL = this.getClass().getResource("help.txt");
        if (uRL == null) {
            throw new IllegalStateException("Missing help.txt file!");
        }
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                System.out.println(string);
            }
        }
    }

    private void displayVersionInfo() {
        RT.var((String)"clojure.core", (String)"require").invoke((Object)Symbol.intern((String)"stencil.api"));
        System.out.println(RT.var((String)"stencil.api", (String)"version").deref().toString());
    }

    private static final class EndOfFilesException
    extends RuntimeException {
        private EndOfFilesException() {
        }
    }
}

