/*
 * Decompiled with CFR 0.152.
 */
package io.github.erdos.stencil.impl;

import io.github.erdos.stencil.impl.FileHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class ZipHelper {
    private ZipHelper() {
    }

    public static void unzipStreamIntoDirectory(InputStream inputStream, File file) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("zip file stream is null!");
        }
        if (file == null) {
            throw new IllegalArgumentException("target directory is null!");
        }
        if (file.exists()) {
            throw new IllegalStateException("unzip target dir already exists: " + file);
        }
        FileHelper.forceMkdir(file);
        byte[] byArray = new byte[1024];
        try (ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                File file2 = new File(file, zipEntry.getName());
                FileHelper.forceMkdir(file2.getParentFile());
                try (FileOutputStream fileOutputStream = new FileOutputStream(file2);){
                    int n;
                    while ((n = zipInputStream.read(byArray)) > 0) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                }
                zipEntry = zipInputStream.getNextEntry();
            }
            zipInputStream.closeEntry();
        }
        inputStream.close();
    }
}

