/*
 * Decompiled with CFR 0.152.
 */
package io.github.erdos.stencil.functions;

import io.github.erdos.stencil.functions.BasicFunctions;
import io.github.erdos.stencil.functions.DateFunctions;
import io.github.erdos.stencil.functions.Function;
import io.github.erdos.stencil.functions.LocaleFunctions;
import io.github.erdos.stencil.functions.NumberFunctions;
import io.github.erdos.stencil.functions.StringFunctions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class FunctionEvaluator {
    private final Map<String, Function> functions = new HashMap<String, Function>();

    public FunctionEvaluator() {
        this.registerFunctions(BasicFunctions.values());
        this.registerFunctions(StringFunctions.values());
        this.registerFunctions(NumberFunctions.values());
        this.registerFunctions(DateFunctions.values());
        this.registerFunctions(LocaleFunctions.values());
    }

    private void registerFunction(Function function) {
        if (function == null) {
            throw new IllegalArgumentException("Registered function must not be null.");
        }
        this.functions.put(function.getName().toLowerCase(), function);
    }

    public void registerFunctions(Function ... functionArray) {
        for (Function function : functionArray) {
            this.registerFunction(function);
        }
    }

    public Object call(String string, Object ... objectArray) {
        if (string == null) {
            throw new IllegalArgumentException("Function name is missing");
        }
        Function function = this.functions.get(string.toLowerCase());
        if (function == null) {
            throw new IllegalArgumentException("Did not find function for name " + string);
        }
        return function.call(objectArray);
    }

    public Iterable<Function> listFunctions() {
        return new ArrayList<Function>(this.functions.values());
    }
}

