/*
 * Decompiled with CFR 0.152.
 */
package io.github.erdos.stencil;

import io.github.erdos.stencil.EvaluatedDocument;
import io.github.erdos.stencil.PrepareOptions;
import io.github.erdos.stencil.PreparedFragment;
import io.github.erdos.stencil.PreparedTemplate;
import io.github.erdos.stencil.TemplateData;
import io.github.erdos.stencil.functions.Function;
import io.github.erdos.stencil.functions.FunctionEvaluator;
import io.github.erdos.stencil.impl.NativeTemplateFactory;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public final class API {
    private API() {
    }

    public static PreparedTemplate prepare(File file) throws IOException {
        return API.prepare(file, PrepareOptions.options());
    }

    public static PreparedTemplate prepare(File file, PrepareOptions prepareOptions) throws IOException {
        return new NativeTemplateFactory().prepareTemplateFile(file, prepareOptions);
    }

    public static PreparedFragment fragment(File file, PrepareOptions prepareOptions) throws IOException {
        return new NativeTemplateFactory().prepareFragmentFile(file, prepareOptions);
    }

    public static PreparedFragment fragment(File file) throws IOException {
        return API.fragment(file, PrepareOptions.options());
    }

    public static EvaluatedDocument render(PreparedTemplate preparedTemplate, TemplateData templateData) {
        return API.render(preparedTemplate, Collections.emptyMap(), templateData, Collections.emptyList());
    }

    public static EvaluatedDocument render(PreparedTemplate preparedTemplate, Map<String, PreparedFragment> map, TemplateData templateData) {
        return API.render(preparedTemplate, map, templateData, Collections.emptyList());
    }

    public static EvaluatedDocument render(PreparedTemplate preparedTemplate, Map<String, PreparedFragment> map, TemplateData templateData, Collection<Function> collection) {
        FunctionEvaluator functionEvaluator = new FunctionEvaluator();
        if (collection != null) {
            functionEvaluator.registerFunctions(collection.toArray(new Function[0]));
        }
        return preparedTemplate.render(map, functionEvaluator, templateData);
    }
}

