(ns convertible.empty)


(defmacro cond$->
  ([value] value)
  ([value cond body & clauses]
   (assert (even? (count clauses)))
   `(cond$-> (let [~'$ ~value]
               (if ~cond (-> ~'$ ~body) ~'$))
             ~@clauses)))


(let [params {:a 1 :b 1 :c nil :d nil}]
  (cond$-> params
           (:a $)       (update :b inc)
           (= (:b $) 2) (assoc :c "here")
           (:c $)       (assoc :d "here")))


(defmacro cond-as->
  ([value sym] value)
  ([value sym cond body & clauses]
   (assert (even? (count clauses)))
   `(cond-as-> (let [~sym ~value]
                 (if ~cond ~body ~sym))
               ~sym
               ~@clauses)))


(let [params {:a 1 :b 1 :c nil :d nil}]
  (cond-as-> params $
             (:a $)       (update $ :b inc)
             (= (:b $) 2) (assoc $ :c "here")
             (:c $)       (assoc $ :d "here")))
