/*
 * Decompiled with CFR 0.152.
 */
package storm.starter;

import backtype.storm.Config;
import backtype.storm.LocalCluster;
import backtype.storm.StormSubmitter;
import backtype.storm.generated.StormTopology;
import backtype.storm.task.ShellBolt;
import backtype.storm.topology.BasicOutputCollector;
import backtype.storm.topology.IBasicBolt;
import backtype.storm.topology.IRichBolt;
import backtype.storm.topology.IRichSpout;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.TopologyBuilder;
import backtype.storm.topology.base.BaseBasicBolt;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import backtype.storm.tuple.Values;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import storm.starter.spout.RandomSentenceSpout;

public class WordCountTopology {
    public static void main(String[] args) throws Exception {
        TopologyBuilder builder = new TopologyBuilder();
        builder.setSpout("spout", (IRichSpout)new RandomSentenceSpout(), (Number)5);
        builder.setBolt("split", (IRichBolt)new SplitSentence(), (Number)8).shuffleGrouping("spout");
        builder.setBolt("count", (IBasicBolt)new WordCount(), (Number)12).fieldsGrouping("split", new Fields(new String[]{"word"}));
        Config conf = new Config();
        conf.setDebug(true);
        if (args != null && args.length > 0) {
            conf.setNumWorkers(3);
            StormSubmitter.submitTopologyWithProgressBar((String)args[0], (Map)conf, (StormTopology)builder.createTopology());
        } else {
            conf.setMaxTaskParallelism(3);
            LocalCluster cluster = new LocalCluster();
            cluster.submitTopology("word-count", (Map)conf, builder.createTopology());
            Thread.sleep(10000L);
            cluster.shutdown();
        }
    }

    public static class WordCount
    extends BaseBasicBolt {
        Map<String, Integer> counts = new HashMap<String, Integer>();

        public void execute(Tuple tuple, BasicOutputCollector collector) {
            String word = tuple.getString(0);
            Integer count = this.counts.get(word);
            if (count == null) {
                count = 0;
            }
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            this.counts.put(word, count);
            collector.emit((List)new Values(new Object[]{word, count}));
        }

        public void declareOutputFields(OutputFieldsDeclarer declarer) {
            declarer.declare(new Fields(new String[]{"word", "count"}));
        }
    }

    public static class SplitSentence
    extends ShellBolt
    implements IRichBolt {
        public SplitSentence() {
            super(new String[]{"python", "splitsentence.py"});
        }

        public void declareOutputFields(OutputFieldsDeclarer declarer) {
            declarer.declare(new Fields(new String[]{"word"}));
        }

        public Map<String, Object> getComponentConfiguration() {
            return null;
        }
    }
}

