/*
 * Decompiled with CFR 0.152.
 */
package storm.starter;

import backtype.storm.Config;
import backtype.storm.testing.TestWordSpout;
import backtype.storm.topology.IBasicBolt;
import backtype.storm.topology.IRichBolt;
import backtype.storm.topology.IRichSpout;
import backtype.storm.topology.TopologyBuilder;
import backtype.storm.tuple.Fields;
import org.apache.log4j.Logger;
import storm.starter.bolt.IntermediateRankingsBolt;
import storm.starter.bolt.RollingCountBolt;
import storm.starter.bolt.TotalRankingsBolt;
import storm.starter.util.StormRunner;

public class RollingTopWords {
    private static final Logger LOG = Logger.getLogger(RollingTopWords.class);
    private static final int DEFAULT_RUNTIME_IN_SECONDS = 60;
    private static final int TOP_N = 5;
    private final TopologyBuilder builder = new TopologyBuilder();
    private final String topologyName;
    private final Config topologyConfig;
    private final int runtimeInSeconds;

    public RollingTopWords(String topologyName) throws InterruptedException {
        this.topologyName = topologyName;
        this.topologyConfig = RollingTopWords.createTopologyConfiguration();
        this.runtimeInSeconds = 60;
        this.wireTopology();
    }

    private static Config createTopologyConfiguration() {
        Config conf = new Config();
        conf.setDebug(true);
        return conf;
    }

    private void wireTopology() throws InterruptedException {
        String spoutId = "wordGenerator";
        String counterId = "counter";
        String intermediateRankerId = "intermediateRanker";
        String totalRankerId = "finalRanker";
        this.builder.setSpout(spoutId, (IRichSpout)new TestWordSpout(), (Number)5);
        this.builder.setBolt(counterId, (IRichBolt)new RollingCountBolt(9, 3), (Number)4).fieldsGrouping(spoutId, new Fields(new String[]{"word"}));
        this.builder.setBolt(intermediateRankerId, (IBasicBolt)new IntermediateRankingsBolt(5), (Number)4).fieldsGrouping(counterId, new Fields(new String[]{"obj"}));
        this.builder.setBolt(totalRankerId, (IBasicBolt)new TotalRankingsBolt(5)).globalGrouping(intermediateRankerId);
    }

    public void runLocally() throws InterruptedException {
        StormRunner.runTopologyLocally(this.builder.createTopology(), this.topologyName, this.topologyConfig, this.runtimeInSeconds);
    }

    public void runRemotely() throws Exception {
        StormRunner.runTopologyRemotely(this.builder.createTopology(), this.topologyName, this.topologyConfig);
    }

    public static void main(String[] args) throws Exception {
        String topologyName = "slidingWindowCounts";
        if (args.length >= 1) {
            topologyName = args[0];
        }
        boolean runLocally = true;
        if (args.length >= 2 && args[1].equalsIgnoreCase("remote")) {
            runLocally = false;
        }
        LOG.info((Object)("Topology name: " + topologyName));
        RollingTopWords rtw = new RollingTopWords(topologyName);
        if (runLocally) {
            LOG.info((Object)"Running in local mode");
            rtw.runLocally();
        } else {
            LOG.info((Object)"Running in remote (cluster) mode");
            rtw.runRemotely();
        }
    }
}

