/*
 * Decompiled with CFR 0.152.
 */
package storm.starter;

import backtype.storm.Config;
import backtype.storm.ILocalDRPC;
import backtype.storm.LocalCluster;
import backtype.storm.LocalDRPC;
import backtype.storm.StormSubmitter;
import backtype.storm.coordination.BatchOutputCollector;
import backtype.storm.coordination.IBatchBolt;
import backtype.storm.drpc.LinearDRPCTopologyBuilder;
import backtype.storm.generated.StormTopology;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.BasicOutputCollector;
import backtype.storm.topology.IBasicBolt;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.base.BaseBasicBolt;
import backtype.storm.topology.base.BaseBatchBolt;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import backtype.storm.tuple.Values;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReachTopology {
    public static Map<String, List<String>> TWEETERS_DB = new HashMap<String, List<String>>(){
        {
            this.put("foo.com/blog/1", Arrays.asList("sally", "bob", "tim", "george", "nathan"));
            this.put("engineering.twitter.com/blog/5", Arrays.asList("adam", "david", "sally", "nathan"));
            this.put("tech.backtype.com/blog/123", Arrays.asList("tim", "mike", "john"));
        }
    };
    public static Map<String, List<String>> FOLLOWERS_DB = new HashMap<String, List<String>>(){
        {
            this.put("sally", Arrays.asList("bob", "tim", "alice", "adam", "jim", "chris", "jai"));
            this.put("bob", Arrays.asList("sally", "nathan", "jim", "mary", "david", "vivian"));
            this.put("tim", Arrays.asList("alex"));
            this.put("nathan", Arrays.asList("sally", "bob", "adam", "harry", "chris", "vivian", "emily", "jordan"));
            this.put("adam", Arrays.asList("david", "carissa"));
            this.put("mike", Arrays.asList("john", "bob"));
            this.put("john", Arrays.asList("alice", "nathan", "jim", "mike", "bob"));
        }
    };

    public static LinearDRPCTopologyBuilder construct() {
        LinearDRPCTopologyBuilder builder = new LinearDRPCTopologyBuilder("reach");
        builder.addBolt((IBasicBolt)new GetTweeters(), (Number)4);
        builder.addBolt((IBasicBolt)new GetFollowers(), (Number)12).shuffleGrouping();
        builder.addBolt((IBatchBolt)new PartialUniquer(), (Number)6).fieldsGrouping(new Fields(new String[]{"id", "follower"}));
        builder.addBolt((IBatchBolt)new CountAggregator(), (Number)3).fieldsGrouping(new Fields(new String[]{"id"}));
        return builder;
    }

    public static void main(String[] args) throws Exception {
        LinearDRPCTopologyBuilder builder = ReachTopology.construct();
        Config conf = new Config();
        if (args == null || args.length == 0) {
            String[] urlsToTry;
            conf.setMaxTaskParallelism(3);
            LocalDRPC drpc = new LocalDRPC();
            LocalCluster cluster = new LocalCluster();
            cluster.submitTopology("reach-drpc", (Map)conf, builder.createLocalTopology((ILocalDRPC)drpc));
            for (String url : urlsToTry = new String[]{"foo.com/blog/1", "engineering.twitter.com/blog/5", "notaurl.com"}) {
                System.out.println("Reach of " + url + ": " + drpc.execute("reach", url));
            }
            cluster.shutdown();
            drpc.shutdown();
        } else {
            conf.setNumWorkers(6);
            StormSubmitter.submitTopologyWithProgressBar((String)args[0], (Map)conf, (StormTopology)builder.createRemoteTopology());
        }
    }

    public static class CountAggregator
    extends BaseBatchBolt {
        BatchOutputCollector _collector;
        Object _id;
        int _count = 0;

        public void prepare(Map conf, TopologyContext context, BatchOutputCollector collector, Object id) {
            this._collector = collector;
            this._id = id;
        }

        public void execute(Tuple tuple) {
            this._count += tuple.getInteger(1).intValue();
        }

        public void finishBatch() {
            this._collector.emit((List)new Values(new Object[]{this._id, this._count}));
        }

        public void declareOutputFields(OutputFieldsDeclarer declarer) {
            declarer.declare(new Fields(new String[]{"id", "reach"}));
        }
    }

    public static class PartialUniquer
    extends BaseBatchBolt {
        BatchOutputCollector _collector;
        Object _id;
        Set<String> _followers = new HashSet<String>();

        public void prepare(Map conf, TopologyContext context, BatchOutputCollector collector, Object id) {
            this._collector = collector;
            this._id = id;
        }

        public void execute(Tuple tuple) {
            this._followers.add(tuple.getString(1));
        }

        public void finishBatch() {
            this._collector.emit((List)new Values(new Object[]{this._id, this._followers.size()}));
        }

        public void declareOutputFields(OutputFieldsDeclarer declarer) {
            declarer.declare(new Fields(new String[]{"id", "partial-count"}));
        }
    }

    public static class GetFollowers
    extends BaseBasicBolt {
        public void execute(Tuple tuple, BasicOutputCollector collector) {
            Object id = tuple.getValue(0);
            String tweeter = tuple.getString(1);
            List<String> followers = FOLLOWERS_DB.get(tweeter);
            if (followers != null) {
                for (String follower : followers) {
                    collector.emit((List)new Values(new Object[]{id, follower}));
                }
            }
        }

        public void declareOutputFields(OutputFieldsDeclarer declarer) {
            declarer.declare(new Fields(new String[]{"id", "follower"}));
        }
    }

    public static class GetTweeters
    extends BaseBasicBolt {
        public void execute(Tuple tuple, BasicOutputCollector collector) {
            Object id = tuple.getValue(0);
            String url = tuple.getString(1);
            List<String> tweeters = TWEETERS_DB.get(url);
            if (tweeters != null) {
                for (String tweeter : tweeters) {
                    collector.emit((List)new Values(new Object[]{id, tweeter}));
                }
            }
        }

        public void declareOutputFields(OutputFieldsDeclarer declarer) {
            declarer.declare(new Fields(new String[]{"id", "tweeter"}));
        }
    }
}

