/*
 * Decompiled with CFR 0.152.
 */
package storm.kafka;

import backtype.storm.metric.api.CombinedMetric;
import backtype.storm.metric.api.CountMetric;
import backtype.storm.metric.api.ICombiner;
import backtype.storm.metric.api.IReducer;
import backtype.storm.metric.api.MeanReducer;
import backtype.storm.metric.api.ReducedMetric;
import backtype.storm.spout.SpoutOutputCollector;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import kafka.javaapi.consumer.SimpleConsumer;
import kafka.javaapi.message.ByteBufferMessageSet;
import kafka.message.MessageAndOffset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import storm.kafka.DynamicPartitionConnections;
import storm.kafka.KafkaSpout;
import storm.kafka.KafkaUtils;
import storm.kafka.Partition;
import storm.kafka.SpoutConfig;
import storm.kafka.ZkState;
import storm.kafka.trident.MaxMetric;

public class PartitionManager {
    public static final Logger LOG = LoggerFactory.getLogger(PartitionManager.class);
    private final CombinedMetric _fetchAPILatencyMax;
    private final ReducedMetric _fetchAPILatencyMean;
    private final CountMetric _fetchAPICallCount;
    private final CountMetric _fetchAPIMessageCount;
    Long _emittedToOffset;
    SortedSet<Long> _pending = new TreeSet<Long>();
    SortedSet<Long> failed = new TreeSet<Long>();
    Long _committedTo;
    LinkedList<KafkaSpout.MessageAndRealOffset> _waitingToEmit = new LinkedList();
    Partition _partition;
    SpoutConfig _spoutConfig;
    String _topologyInstanceId;
    SimpleConsumer _consumer;
    DynamicPartitionConnections _connections;
    ZkState _state;
    Map _stormConf;
    long numberFailed;
    long numberAcked;

    public PartitionManager(DynamicPartitionConnections connections, String topologyInstanceId, ZkState state, Map stormConf, SpoutConfig spoutConfig, Partition id) {
        this._partition = id;
        this._connections = connections;
        this._spoutConfig = spoutConfig;
        this._topologyInstanceId = topologyInstanceId;
        this._consumer = connections.register(id.host, id.partition);
        this._state = state;
        this._stormConf = stormConf;
        this.numberFailed = 0L;
        this.numberAcked = 0L;
        String jsonTopologyId = null;
        Long jsonOffset = null;
        String path = this.committedPath();
        try {
            Map<Object, Object> json = this._state.readJSON(path);
            LOG.info("Read partition information from: " + path + "  --> " + json);
            if (json != null) {
                jsonTopologyId = (String)((Map)json.get("topology")).get("id");
                jsonOffset = (Long)json.get("offset");
            }
        }
        catch (Throwable e) {
            LOG.warn("Error reading and/or parsing at ZkNode: " + path, e);
        }
        Long currentOffset = KafkaUtils.getOffset(this._consumer, spoutConfig.topic, id.partition, spoutConfig);
        if (jsonTopologyId == null || jsonOffset == null) {
            this._committedTo = currentOffset;
            LOG.info("No partition information found, using configuration to determine offset");
        } else if (!topologyInstanceId.equals(jsonTopologyId) && spoutConfig.forceFromStart) {
            this._committedTo = KafkaUtils.getOffset(this._consumer, spoutConfig.topic, id.partition, spoutConfig.startOffsetTime);
            LOG.info("Topology change detected and reset from start forced, using configuration to determine offset");
        } else {
            this._committedTo = jsonOffset;
            LOG.info("Read last commit offset from zookeeper: " + this._committedTo + "; old topology_id: " + jsonTopologyId + " - new topology_id: " + topologyInstanceId);
        }
        if (currentOffset - this._committedTo > spoutConfig.maxOffsetBehind || this._committedTo <= 0L) {
            LOG.info("Last commit offset from zookeeper: " + this._committedTo);
            this._committedTo = currentOffset;
            LOG.info("Commit offset " + this._committedTo + " is more than " + spoutConfig.maxOffsetBehind + " behind, resetting to startOffsetTime=" + spoutConfig.startOffsetTime);
        }
        LOG.info("Starting Kafka " + this._consumer.host() + ":" + id.partition + " from offset " + this._committedTo);
        this._emittedToOffset = this._committedTo;
        this._fetchAPILatencyMax = new CombinedMetric((ICombiner)new MaxMetric());
        this._fetchAPILatencyMean = new ReducedMetric((IReducer)new MeanReducer());
        this._fetchAPICallCount = new CountMetric();
        this._fetchAPIMessageCount = new CountMetric();
    }

    public Map getMetricsDataMap() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put(this._partition + "/fetchAPILatencyMax", this._fetchAPILatencyMax.getValueAndReset());
        ret.put(this._partition + "/fetchAPILatencyMean", this._fetchAPILatencyMean.getValueAndReset());
        ret.put(this._partition + "/fetchAPICallCount", this._fetchAPICallCount.getValueAndReset());
        ret.put(this._partition + "/fetchAPIMessageCount", this._fetchAPIMessageCount.getValueAndReset());
        return ret;
    }

    public KafkaSpout.EmitState next(SpoutOutputCollector collector) {
        if (this._waitingToEmit.isEmpty()) {
            this.fill();
        }
        while (true) {
            KafkaSpout.MessageAndRealOffset toEmit;
            if ((toEmit = this._waitingToEmit.pollFirst()) == null) {
                return KafkaSpout.EmitState.NO_EMITTED;
            }
            Iterable<List<Object>> tups = KafkaUtils.generateTuples(this._spoutConfig, toEmit.msg);
            if (tups != null) {
                for (List<Object> tup : tups) {
                    collector.emit(tup, (Object)new KafkaMessageId(this._partition, toEmit.offset));
                }
                break;
            }
            this.ack(toEmit.offset);
        }
        if (!this._waitingToEmit.isEmpty()) {
            return KafkaSpout.EmitState.EMITTED_MORE_LEFT;
        }
        return KafkaSpout.EmitState.EMITTED_END;
    }

    private void fill() {
        long start = System.nanoTime();
        boolean had_failed = !this.failed.isEmpty();
        long offset = had_failed ? this.failed.first().longValue() : this._emittedToOffset.longValue();
        ByteBufferMessageSet msgs = KafkaUtils.fetchMessages(this._spoutConfig, this._consumer, this._partition, offset);
        long end = System.nanoTime();
        long millis = (end - start) / 1000000L;
        this._fetchAPILatencyMax.update((Object)millis);
        this._fetchAPILatencyMean.update((Object)millis);
        this._fetchAPICallCount.incr();
        if (msgs != null) {
            int numMessages = 0;
            for (MessageAndOffset msg : msgs) {
                Long cur_offset = msg.offset();
                if (cur_offset < offset || had_failed && !this.failed.contains(cur_offset)) continue;
                ++numMessages;
                this._pending.add(cur_offset);
                this._waitingToEmit.add(new KafkaSpout.MessageAndRealOffset(msg.message(), cur_offset));
                this._emittedToOffset = Math.max(msg.nextOffset(), this._emittedToOffset);
                if (!had_failed) continue;
                this.failed.remove(cur_offset);
            }
            this._fetchAPIMessageCount.incrBy((long)numMessages);
        }
    }

    public void ack(Long offset) {
        if (!this._pending.isEmpty() && this._pending.first() < offset - this._spoutConfig.maxOffsetBehind) {
            this._pending.headSet(offset - this._spoutConfig.maxOffsetBehind).clear();
        }
        this._pending.remove(offset);
        ++this.numberAcked;
    }

    public void fail(Long offset) {
        if (offset < this._emittedToOffset - this._spoutConfig.maxOffsetBehind) {
            LOG.info("Skipping failed tuple at offset=" + offset + " because it's more than maxOffsetBehind=" + this._spoutConfig.maxOffsetBehind + " behind _emittedToOffset=" + this._emittedToOffset);
        } else {
            LOG.debug("failing at offset=" + offset + " with _pending.size()=" + this._pending.size() + " pending and _emittedToOffset=" + this._emittedToOffset);
            this.failed.add(offset);
            ++this.numberFailed;
            if (this.numberAcked == 0L && this.numberFailed > this._spoutConfig.maxOffsetBehind) {
                throw new RuntimeException("Too many tuple failures");
            }
        }
    }

    public void commit() {
        long lastCompletedOffset = this.lastCompletedOffset();
        if (this._committedTo != lastCompletedOffset) {
            LOG.debug("Writing last completed offset (" + lastCompletedOffset + ") to ZK for " + this._partition + " for topology: " + this._topologyInstanceId);
            ImmutableMap data = ImmutableMap.builder().put((Object)"topology", (Object)ImmutableMap.of((Object)"id", (Object)this._topologyInstanceId, (Object)"name", this._stormConf.get("topology.name"))).put((Object)"offset", (Object)lastCompletedOffset).put((Object)"partition", (Object)this._partition.partition).put((Object)"broker", (Object)ImmutableMap.of((Object)"host", (Object)this._partition.host.host, (Object)"port", (Object)this._partition.host.port)).put((Object)"topic", (Object)this._spoutConfig.topic).build();
            this._state.writeJSON(this.committedPath(), (Map<Object, Object>)data);
            this._committedTo = lastCompletedOffset;
            LOG.debug("Wrote last completed offset (" + lastCompletedOffset + ") to ZK for " + this._partition + " for topology: " + this._topologyInstanceId);
        } else {
            LOG.debug("No new offset for " + this._partition + " for topology: " + this._topologyInstanceId);
        }
    }

    private String committedPath() {
        return this._spoutConfig.zkRoot + "/" + this._spoutConfig.id + "/" + this._partition.getId();
    }

    public long lastCompletedOffset() {
        if (this._pending.isEmpty()) {
            return this._emittedToOffset;
        }
        return this._pending.first();
    }

    public Partition getPartition() {
        return this._partition;
    }

    public void close() {
        this._connections.unregister(this._partition.host, this._partition.partition);
    }

    static class KafkaMessageId {
        public Partition partition;
        public long offset;

        public KafkaMessageId(Partition partition, long offset) {
            this.partition = partition;
            this.offset = offset;
        }
    }
}

