/*
 * Decompiled with CFR 0.152.
 */
package net.wonsi.proxy.request;

import com.google.common.base.Joiner;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.wonsi.api.request.InsertRequest;
import net.wonsi.util.ExecutorUtil;
import net.wonsi.util.StringUtil;

public class RealInsertRequest<T>
implements InsertRequest<T> {
    private final Connection connection;
    private final String tableName;
    private String condition;
    private int limit;
    private boolean fixDuplicate;
    private Map<String, Object> data;
    private final String primaryKeyName;

    public RealInsertRequest(Connection connection, String tableName, String primaryKeyName) {
        this.connection = connection;
        this.tableName = tableName;
        this.primaryKeyName = primaryKeyName;
        this.condition = "1";
        this.limit = 10;
    }

    @Override
    public InsertRequest<T> data(Consumer<Map<String, Object>> insertData) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        insertData.accept(map);
        this.data = map;
        return this;
    }

    @Override
    public InsertRequest<T> updateOnDuplicate() {
        this.fixDuplicate = true;
        return this;
    }

    @Override
    public InsertRequest<T> limit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public CompletableFuture<Void> async() {
        return CompletableFuture.runAsync(this::sync);
    }

    @Override
    public void sync() {
        try {
            HashMap<String, Object> mapWithoutPrimary = new HashMap<String, Object>(this.data);
            if (this.fixDuplicate) {
                mapWithoutPrimary.remove(this.primaryKeyName);
            }
            String end = this.fixDuplicate ? " ON DUPLICATE KEY UPDATE " + Joiner.on((String)"= ?,").join(mapWithoutPrimary.keySet()) + " = ?" : "";
            String query = "INSERT INTO " + this.tableName + " (" + Joiner.on((String)",").join(this.data.keySet()) + ") VALUES (" + StringUtil.repeat(",?", this.data.size()).replaceFirst(",", "") + ")" + end;
            PreparedStatement statement = this.connection.prepareStatement(query);
            int currentArgument = 1;
            for (Object o : this.data.values()) {
                statement.setObject(currentArgument, o);
                ++currentArgument;
            }
            if (this.fixDuplicate) {
                for (Object o : mapWithoutPrimary.values()) {
                    statement.setObject(currentArgument, o);
                    ++currentArgument;
                }
            }
            ExecutorUtil.execute(statement, this.connection);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

