/*
 * Decompiled with CFR 0.152.
 */
package net.wonsi.proxy.repository;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Optional;
import lombok.NonNull;
import net.wonsi.api.mapping.WonsiColumn;
import net.wonsi.api.repository.BaseRepository;
import net.wonsi.api.table.WonsiTable;
import net.wonsi.util.Condition;

public class SimpleRepository<MappingType, Identifier>
implements BaseRepository<MappingType, Identifier> {
    private final WonsiTable<MappingType> wrappedTable;
    private final String idColumnName;

    @Override
    public Collection<MappingType> findAll() {
        return this.wrappedTable.select().where(Condition.alwaysTrue()).sync().getAll();
    }

    @Override
    public Optional<MappingType> findByIdentifier(@NonNull Identifier identifier) {
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        return this.wrappedTable.select().where(Condition.is(this.idColumnName, identifier)).sync().findFirst();
    }

    @Override
    public Collection<MappingType> findByCondition(@NonNull Condition condition) {
        if (condition == null) {
            throw new NullPointerException("condition is marked non-null but is null");
        }
        return this.wrappedTable.select().where(condition).sync().getAll();
    }

    @Override
    public void deleteByIdentifier(@NonNull Identifier identifier) {
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        this.wrappedTable.delete().where(Condition.is(this.idColumnName, identifier)).limit(1).sync();
    }

    @Override
    public void save(@NonNull MappingType mappingType) {
        if (mappingType == null) {
            throw new NullPointerException("mappingType is marked non-null but is null");
        }
        this.wrappedTable.insert().updateOnDuplicate().data(map -> {
            for (Field field : mappingType.getClass().getDeclaredFields()) {
                WonsiColumn column = field.getAnnotation(WonsiColumn.class);
                String name = column.name().equals("null_wonsidv") ? field.getName() : column.name();
                field.trySetAccessible();
                try {
                    map.put(name, field.get(mappingType));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }).sync();
    }

    @Override
    public WonsiTable<MappingType> getWrappedTable() {
        return this.wrappedTable;
    }

    public String getIdColumnName() {
        return this.idColumnName;
    }

    public SimpleRepository(WonsiTable<MappingType> wrappedTable, String idColumnName) {
        this.wrappedTable = wrappedTable;
        this.idColumnName = idColumnName;
    }
}

