/*
 * Decompiled with CFR 0.152.
 */
package net.wonsi.proxy.result;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import lombok.NonNull;
import net.wonsi.api.result.ExecutedReturningAction;

public class RealExecutedReturningAction<T>
implements ExecutedReturningAction<T> {
    private final Collection<T> response;

    public RealExecutedReturningAction(@NonNull ResultSet resultSet, @NonNull Function<ResultSet, T> deserializer) {
        if (resultSet == null) {
            throw new NullPointerException("resultSet is marked non-null but is null");
        }
        if (deserializer == null) {
            throw new NullPointerException("deserializer is marked non-null but is null");
        }
        this.response = new ArrayList<T>();
        try {
            while (resultSet.next()) {
                this.response.add(deserializer.apply(resultSet));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public Collection<T> getAll() {
        return this.response;
    }

    @Override
    public Optional<T> findFirst() {
        return this.response.stream().findFirst();
    }

    @Override
    public boolean isEmpty() {
        return this.response.isEmpty();
    }
}

