/*
 * Decompiled with CFR 0.152.
 */
package net.wonsi.proxy.table;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import lombok.NonNull;
import net.wonsi.api.mapping.WonsiColumn;
import net.wonsi.api.mapping.WonsiPrimary;
import net.wonsi.api.request.DeleteRequest;
import net.wonsi.api.request.InsertRequest;
import net.wonsi.api.request.Request;
import net.wonsi.api.request.SelectRequest;
import net.wonsi.api.request.UpdateRequest;
import net.wonsi.api.result.ExecutedReturningAction;
import net.wonsi.api.table.WonsiTable;
import net.wonsi.column.ColumnUtil;
import net.wonsi.proxy.request.RealDeleteRequest;
import net.wonsi.proxy.request.RealInsertRequest;
import net.wonsi.proxy.request.RealSelectRequest;
import net.wonsi.proxy.request.RealUpdateRequest;
import net.wonsi.proxy.result.RealExecutedReturningAction;
import net.wonsi.util.ExecutorUtil;

public class RealWonsiTable<T>
implements WonsiTable<T> {
    private Connection connection;
    private Function<ResultSet, T> deserializer;
    private String tableName;

    @Override
    public SelectRequest<T> select() {
        return new RealSelectRequest<T>(this.connection, this.tableName, this.deserializer);
    }

    @Override
    public InsertRequest<T> insert() {
        return new RealInsertRequest(this.connection, this.tableName);
    }

    @Override
    public DeleteRequest delete() {
        return new RealDeleteRequest(this.connection, this.tableName);
    }

    @Override
    public UpdateRequest update() {
        return new RealUpdateRequest(this.connection, this.tableName);
    }

    @Override
    public ExecutedReturningAction<T> customSelect(@NonNull String query) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        return new RealExecutedReturningAction<T>(ExecutorUtil.getResult(query, this.connection), this.deserializer);
    }

    @Override
    public Request customQuery(final @NonNull String query) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        return new Request(){

            @Override
            public CompletableFuture<Void> async() {
                return CompletableFuture.runAsync(this::sync);
            }

            @Override
            public void sync() {
                ExecutorUtil.execute(query, RealWonsiTable.this.connection);
            }
        };
    }

    @Override
    public void createIfNotExits(Class<T> tclass) {
        ArrayList<String> arguments = new ArrayList<String>();
        for (Field field : tclass.getDeclaredFields()) {
            WonsiColumn column = field.getAnnotation(WonsiColumn.class);
            arguments.add(column.name() + ' ' + ColumnUtil.get(field.getType()).convertToString(column.length()) + (field.getAnnotation(WonsiPrimary.class) != null ? " PRIMARY KEY" : ""));
        }
        StringBuilder query = new StringBuilder("CREATE TABLE IF NOT EXISTS `");
        query.append(this.tableName).append('`').append(" (");
        for (int i = 0; i < arguments.size(); ++i) {
            query.append((String)arguments.get(i));
            if (arguments.size() == i + 1) continue;
            query.append(", ");
        }
        query.append(')');
        ExecutorUtil.execute(query.toString(), this.connection);
    }

    public RealWonsiTable(Connection connection, Function<ResultSet, T> deserializer, String tableName) {
        this.connection = connection;
        this.deserializer = deserializer;
        this.tableName = tableName;
    }
}

