(ns kubernetes-api.encoders
  (:require [martian.encoders :as encoders]))

(defn kubernetes-api-encoders []
  (let [default-encoders (encoders/default-encoders)
        json-decoder (get default-encoders "application/json")]
    (merge
      {"application/json-patch+json"            json-decoder
       "application/merge-patch+json"           json-decoder
       "application/strategic-merge-patch+json" json-decoder}
      default-encoders)))
