(ns cdk.api.services.ec2
  "Functions that represent AWS CDK enums and builders in the software.amazon.awscdk.services.ec2 package. "
  (:require [cdk.api :refer [asset-hash-type
                             ignore-mode
                             removal-policy
                             symlink-follow-mode]]
            [cdk.support :refer [lookup-entry]])
  (:import [java.util Map]
           [software.amazon.awscdk.services.ec2 AclCidrConfig$Builder
                                                AclIcmp$Builder
                                                AclPortRange$Builder
                                                AclTrafficConfig$Builder
                                                Action
                                                AddRouteOptions$Builder
                                                AddressFamily
                                                AllocateCidrRequest$Builder
                                                AllocateIpv6CidrRequest$Builder
                                                AllocateVpcIpv6CidrRequest$Builder
                                                AllocatedSubnet$Builder
                                                AmazonLinux2022ImageSsmParameter$Builder
                                                AmazonLinux2022ImageSsmParameterProps$Builder
                                                AmazonLinux2023ImageSsmParameter$Builder
                                                AmazonLinux2023ImageSsmParameterProps$Builder
                                                AmazonLinux2ImageSsmParameter$Builder
                                                AmazonLinux2ImageSsmParameterProps$Builder
                                                AmazonLinuxCpuType
                                                AmazonLinuxEdition
                                                AmazonLinuxGeneration
                                                AmazonLinuxImage$Builder
                                                AmazonLinuxImageProps$Builder
                                                AmazonLinuxImageSsmParameterBaseOptions$Builder
                                                AmazonLinuxImageSsmParameterBaseProps$Builder
                                                AmazonLinuxImageSsmParameterCommonOptions$Builder
                                                AmazonLinuxKernel
                                                AmazonLinuxStorage
                                                AmazonLinuxVirt
                                                ApplyCloudFormationInitOptions$Builder
                                                AttachInitOptions$Builder
                                                AwsIpamProps$Builder
                                                BastionHostLinux$Builder
                                                BastionHostLinuxProps$Builder
                                                BlockDevice$Builder
                                                CfnCapacityReservation$Builder
                                                CfnCapacityReservation$TagSpecificationProperty$Builder
                                                CfnCapacityReservationFleet$Builder
                                                CfnCapacityReservationFleet$InstanceTypeSpecificationProperty$Builder
                                                CfnCapacityReservationFleet$TagSpecificationProperty$Builder
                                                CfnCapacityReservationFleetProps$Builder
                                                CfnCapacityReservationProps$Builder
                                                CfnCarrierGateway$Builder
                                                CfnCarrierGatewayProps$Builder
                                                CfnClientVpnAuthorizationRule$Builder
                                                CfnClientVpnAuthorizationRuleProps$Builder
                                                CfnClientVpnEndpoint$Builder
                                                CfnClientVpnEndpoint$CertificateAuthenticationRequestProperty$Builder
                                                CfnClientVpnEndpoint$ClientAuthenticationRequestProperty$Builder
                                                CfnClientVpnEndpoint$ClientConnectOptionsProperty$Builder
                                                CfnClientVpnEndpoint$ClientLoginBannerOptionsProperty$Builder
                                                CfnClientVpnEndpoint$ConnectionLogOptionsProperty$Builder
                                                CfnClientVpnEndpoint$DirectoryServiceAuthenticationRequestProperty$Builder
                                                CfnClientVpnEndpoint$FederatedAuthenticationRequestProperty$Builder
                                                CfnClientVpnEndpoint$TagSpecificationProperty$Builder
                                                CfnClientVpnEndpointProps$Builder
                                                CfnClientVpnRoute$Builder
                                                CfnClientVpnRouteProps$Builder
                                                CfnClientVpnTargetNetworkAssociation$Builder
                                                CfnClientVpnTargetNetworkAssociationProps$Builder
                                                CfnCustomerGateway$Builder
                                                CfnCustomerGatewayProps$Builder
                                                CfnDHCPOptions$Builder
                                                CfnDHCPOptionsProps$Builder
                                                CfnEC2Fleet$AcceleratorCountRequestProperty$Builder
                                                CfnEC2Fleet$AcceleratorTotalMemoryMiBRequestProperty$Builder
                                                CfnEC2Fleet$BaselineEbsBandwidthMbpsRequestProperty$Builder
                                                CfnEC2Fleet$Builder
                                                CfnEC2Fleet$CapacityRebalanceProperty$Builder
                                                CfnEC2Fleet$CapacityReservationOptionsRequestProperty$Builder
                                                CfnEC2Fleet$FleetLaunchTemplateConfigRequestProperty$Builder
                                                CfnEC2Fleet$FleetLaunchTemplateOverridesRequestProperty$Builder
                                                CfnEC2Fleet$FleetLaunchTemplateSpecificationRequestProperty$Builder
                                                CfnEC2Fleet$InstanceRequirementsRequestProperty$Builder
                                                CfnEC2Fleet$MaintenanceStrategiesProperty$Builder
                                                CfnEC2Fleet$MemoryGiBPerVCpuRequestProperty$Builder
                                                CfnEC2Fleet$MemoryMiBRequestProperty$Builder
                                                CfnEC2Fleet$NetworkBandwidthGbpsRequestProperty$Builder
                                                CfnEC2Fleet$NetworkInterfaceCountRequestProperty$Builder
                                                CfnEC2Fleet$OnDemandOptionsRequestProperty$Builder
                                                CfnEC2Fleet$PlacementProperty$Builder
                                                CfnEC2Fleet$SpotOptionsRequestProperty$Builder
                                                CfnEC2Fleet$TagSpecificationProperty$Builder
                                                CfnEC2Fleet$TargetCapacitySpecificationRequestProperty$Builder
                                                CfnEC2Fleet$TotalLocalStorageGBRequestProperty$Builder
                                                CfnEC2Fleet$VCpuCountRangeRequestProperty$Builder
                                                CfnEC2FleetProps$Builder
                                                CfnEIP$Builder
                                                CfnEIPAssociation$Builder
                                                CfnEIPAssociationProps$Builder
                                                CfnEIPProps$Builder
                                                CfnEgressOnlyInternetGateway$Builder
                                                CfnEgressOnlyInternetGatewayProps$Builder
                                                CfnEnclaveCertificateIamRoleAssociation$Builder
                                                CfnEnclaveCertificateIamRoleAssociationProps$Builder
                                                CfnFlowLog$Builder
                                                CfnFlowLog$DestinationOptionsProperty$Builder
                                                CfnFlowLogProps$Builder
                                                CfnGatewayRouteTableAssociation$Builder
                                                CfnGatewayRouteTableAssociationProps$Builder
                                                CfnHost$Builder
                                                CfnHostProps$Builder
                                                CfnIPAM$Builder
                                                CfnIPAM$IpamOperatingRegionProperty$Builder
                                                CfnIPAMAllocation$Builder
                                                CfnIPAMAllocationProps$Builder
                                                CfnIPAMPool$Builder
                                                CfnIPAMPool$ProvisionedCidrProperty$Builder
                                                CfnIPAMPool$SourceResourceProperty$Builder
                                                CfnIPAMPoolCidr$Builder
                                                CfnIPAMPoolCidrProps$Builder
                                                CfnIPAMPoolProps$Builder
                                                CfnIPAMProps$Builder
                                                CfnIPAMResourceDiscovery$Builder
                                                CfnIPAMResourceDiscovery$IpamOperatingRegionProperty$Builder
                                                CfnIPAMResourceDiscoveryAssociation$Builder
                                                CfnIPAMResourceDiscoveryAssociationProps$Builder
                                                CfnIPAMResourceDiscoveryProps$Builder
                                                CfnIPAMScope$Builder
                                                CfnIPAMScopeProps$Builder
                                                CfnInstance$AssociationParameterProperty$Builder
                                                CfnInstance$BlockDeviceMappingProperty$Builder
                                                CfnInstance$Builder
                                                CfnInstance$CpuOptionsProperty$Builder
                                                CfnInstance$CreditSpecificationProperty$Builder
                                                CfnInstance$EbsProperty$Builder
                                                CfnInstance$ElasticGpuSpecificationProperty$Builder
                                                CfnInstance$ElasticInferenceAcceleratorProperty$Builder
                                                CfnInstance$EnclaveOptionsProperty$Builder
                                                CfnInstance$HibernationOptionsProperty$Builder
                                                CfnInstance$InstanceIpv6AddressProperty$Builder
                                                CfnInstance$LaunchTemplateSpecificationProperty$Builder
                                                CfnInstance$LicenseSpecificationProperty$Builder
                                                CfnInstance$NetworkInterfaceProperty$Builder
                                                CfnInstance$NoDeviceProperty$Builder
                                                CfnInstance$PrivateDnsNameOptionsProperty$Builder
                                                CfnInstance$PrivateIpAddressSpecificationProperty$Builder
                                                CfnInstance$SsmAssociationProperty$Builder
                                                CfnInstance$StateProperty$Builder
                                                CfnInstance$VolumeProperty$Builder
                                                CfnInstanceConnectEndpoint$Builder
                                                CfnInstanceConnectEndpointProps$Builder
                                                CfnInstanceProps$Builder
                                                CfnInternetGateway$Builder
                                                CfnInternetGatewayProps$Builder
                                                CfnKeyPair$Builder
                                                CfnKeyPairProps$Builder
                                                CfnLaunchTemplate$AcceleratorCountProperty$Builder
                                                CfnLaunchTemplate$AcceleratorTotalMemoryMiBProperty$Builder
                                                CfnLaunchTemplate$BaselineEbsBandwidthMbpsProperty$Builder
                                                CfnLaunchTemplate$BlockDeviceMappingProperty$Builder
                                                CfnLaunchTemplate$Builder
                                                CfnLaunchTemplate$CapacityReservationSpecificationProperty$Builder
                                                CfnLaunchTemplate$CapacityReservationTargetProperty$Builder
                                                CfnLaunchTemplate$ConnectionTrackingSpecificationProperty$Builder
                                                CfnLaunchTemplate$CpuOptionsProperty$Builder
                                                CfnLaunchTemplate$CreditSpecificationProperty$Builder
                                                CfnLaunchTemplate$EbsProperty$Builder
                                                CfnLaunchTemplate$ElasticGpuSpecificationProperty$Builder
                                                CfnLaunchTemplate$EnaSrdSpecificationProperty$Builder
                                                CfnLaunchTemplate$EnaSrdUdpSpecificationProperty$Builder
                                                CfnLaunchTemplate$EnclaveOptionsProperty$Builder
                                                CfnLaunchTemplate$HibernationOptionsProperty$Builder
                                                CfnLaunchTemplate$IamInstanceProfileProperty$Builder
                                                CfnLaunchTemplate$InstanceMarketOptionsProperty$Builder
                                                CfnLaunchTemplate$InstanceRequirementsProperty$Builder
                                                CfnLaunchTemplate$Ipv4PrefixSpecificationProperty$Builder
                                                CfnLaunchTemplate$Ipv6AddProperty$Builder
                                                CfnLaunchTemplate$Ipv6PrefixSpecificationProperty$Builder
                                                CfnLaunchTemplate$LaunchTemplateDataProperty$Builder
                                                CfnLaunchTemplate$LaunchTemplateElasticInferenceAcceleratorProperty$Builder
                                                CfnLaunchTemplate$LaunchTemplateTagSpecificationProperty$Builder
                                                CfnLaunchTemplate$LicenseSpecificationProperty$Builder
                                                CfnLaunchTemplate$MaintenanceOptionsProperty$Builder
                                                CfnLaunchTemplate$MemoryGiBPerVCpuProperty$Builder
                                                CfnLaunchTemplate$MemoryMiBProperty$Builder
                                                CfnLaunchTemplate$MetadataOptionsProperty$Builder
                                                CfnLaunchTemplate$MonitoringProperty$Builder
                                                CfnLaunchTemplate$NetworkBandwidthGbpsProperty$Builder
                                                CfnLaunchTemplate$NetworkInterfaceCountProperty$Builder
                                                CfnLaunchTemplate$NetworkInterfaceProperty$Builder
                                                CfnLaunchTemplate$PlacementProperty$Builder
                                                CfnLaunchTemplate$PrivateDnsNameOptionsProperty$Builder
                                                CfnLaunchTemplate$PrivateIpAddProperty$Builder
                                                CfnLaunchTemplate$SpotOptionsProperty$Builder
                                                CfnLaunchTemplate$TagSpecificationProperty$Builder
                                                CfnLaunchTemplate$TotalLocalStorageGBProperty$Builder
                                                CfnLaunchTemplate$VCpuCountProperty$Builder
                                                CfnLaunchTemplateProps$Builder
                                                CfnLocalGatewayRoute$Builder
                                                CfnLocalGatewayRouteProps$Builder
                                                CfnLocalGatewayRouteTable$Builder
                                                CfnLocalGatewayRouteTableProps$Builder
                                                CfnLocalGatewayRouteTableVPCAssociation$Builder
                                                CfnLocalGatewayRouteTableVPCAssociationProps$Builder
                                                CfnLocalGatewayRouteTableVirtualInterfaceGroupAssociation$Builder
                                                CfnLocalGatewayRouteTableVirtualInterfaceGroupAssociationProps$Builder
                                                CfnNatGateway$Builder
                                                CfnNatGatewayProps$Builder
                                                CfnNetworkAcl$Builder
                                                CfnNetworkAclEntry$Builder
                                                CfnNetworkAclEntry$IcmpProperty$Builder
                                                CfnNetworkAclEntry$PortRangeProperty$Builder
                                                CfnNetworkAclEntryProps$Builder
                                                CfnNetworkAclProps$Builder
                                                CfnNetworkInsightsAccessScope$AccessScopePathRequestProperty$Builder
                                                CfnNetworkInsightsAccessScope$Builder
                                                CfnNetworkInsightsAccessScope$PacketHeaderStatementRequestProperty$Builder
                                                CfnNetworkInsightsAccessScope$PathStatementRequestProperty$Builder
                                                CfnNetworkInsightsAccessScope$ResourceStatementRequestProperty$Builder
                                                CfnNetworkInsightsAccessScope$ThroughResourcesStatementRequestProperty$Builder
                                                CfnNetworkInsightsAccessScopeAnalysis$Builder
                                                CfnNetworkInsightsAccessScopeAnalysisProps$Builder
                                                CfnNetworkInsightsAccessScopeProps$Builder
                                                CfnNetworkInsightsAnalysis$AdditionalDetailProperty$Builder
                                                CfnNetworkInsightsAnalysis$AlternatePathHintProperty$Builder
                                                CfnNetworkInsightsAnalysis$AnalysisAclRuleProperty$Builder
                                                CfnNetworkInsightsAnalysis$AnalysisComponentProperty$Builder
                                                CfnNetworkInsightsAnalysis$AnalysisLoadBalancerListenerProperty$Builder
                                                CfnNetworkInsightsAnalysis$AnalysisLoadBalancerTargetProperty$Builder
                                                CfnNetworkInsightsAnalysis$AnalysisPacketHeaderProperty$Builder
                                                CfnNetworkInsightsAnalysis$AnalysisRouteTableRouteProperty$Builder
                                                CfnNetworkInsightsAnalysis$AnalysisSecurityGroupRuleProperty$Builder
                                                CfnNetworkInsightsAnalysis$Builder
                                                CfnNetworkInsightsAnalysis$ExplanationProperty$Builder
                                                CfnNetworkInsightsAnalysis$PathComponentProperty$Builder
                                                CfnNetworkInsightsAnalysis$PortRangeProperty$Builder
                                                CfnNetworkInsightsAnalysis$TransitGatewayRouteTableRouteProperty$Builder
                                                CfnNetworkInsightsAnalysisProps$Builder
                                                CfnNetworkInsightsPath$Builder
                                                CfnNetworkInsightsPath$FilterPortRangeProperty$Builder
                                                CfnNetworkInsightsPath$PathFilterProperty$Builder
                                                CfnNetworkInsightsPathProps$Builder
                                                CfnNetworkInterface$Builder
                                                CfnNetworkInterface$ConnectionTrackingSpecificationProperty$Builder
                                                CfnNetworkInterface$InstanceIpv6AddressProperty$Builder
                                                CfnNetworkInterface$Ipv4PrefixSpecificationProperty$Builder
                                                CfnNetworkInterface$Ipv6PrefixSpecificationProperty$Builder
                                                CfnNetworkInterface$PrivateIpAddressSpecificationProperty$Builder
                                                CfnNetworkInterfaceAttachment$Builder
                                                CfnNetworkInterfaceAttachment$EnaSrdSpecificationProperty$Builder
                                                CfnNetworkInterfaceAttachment$EnaSrdUdpSpecificationProperty$Builder
                                                CfnNetworkInterfaceAttachmentProps$Builder
                                                CfnNetworkInterfacePermission$Builder
                                                CfnNetworkInterfacePermissionProps$Builder
                                                CfnNetworkInterfaceProps$Builder
                                                CfnNetworkPerformanceMetricSubscription$Builder
                                                CfnNetworkPerformanceMetricSubscriptionProps$Builder
                                                CfnPlacementGroup$Builder
                                                CfnPlacementGroupProps$Builder
                                                CfnPrefixList$Builder
                                                CfnPrefixList$EntryProperty$Builder
                                                CfnPrefixListProps$Builder
                                                CfnRoute$Builder
                                                CfnRouteProps$Builder
                                                CfnRouteTable$Builder
                                                CfnRouteTableProps$Builder
                                                CfnSecurityGroup$Builder
                                                CfnSecurityGroup$EgressProperty$Builder
                                                CfnSecurityGroup$IngressProperty$Builder
                                                CfnSecurityGroupEgress$Builder
                                                CfnSecurityGroupEgressProps$Builder
                                                CfnSecurityGroupIngress$Builder
                                                CfnSecurityGroupIngressProps$Builder
                                                CfnSecurityGroupProps$Builder
                                                CfnSnapshotBlockPublicAccess$Builder
                                                CfnSnapshotBlockPublicAccessProps$Builder
                                                CfnSpotFleet$AcceleratorCountRequestProperty$Builder
                                                CfnSpotFleet$AcceleratorTotalMemoryMiBRequestProperty$Builder
                                                CfnSpotFleet$BaselineEbsBandwidthMbpsRequestProperty$Builder
                                                CfnSpotFleet$BlockDeviceMappingProperty$Builder
                                                CfnSpotFleet$Builder
                                                CfnSpotFleet$ClassicLoadBalancerProperty$Builder
                                                CfnSpotFleet$ClassicLoadBalancersConfigProperty$Builder
                                                CfnSpotFleet$EbsBlockDeviceProperty$Builder
                                                CfnSpotFleet$FleetLaunchTemplateSpecificationProperty$Builder
                                                CfnSpotFleet$GroupIdentifierProperty$Builder
                                                CfnSpotFleet$IamInstanceProfileSpecificationProperty$Builder
                                                CfnSpotFleet$InstanceIpv6AddressProperty$Builder
                                                CfnSpotFleet$InstanceNetworkInterfaceSpecificationProperty$Builder
                                                CfnSpotFleet$InstanceRequirementsRequestProperty$Builder
                                                CfnSpotFleet$LaunchTemplateConfigProperty$Builder
                                                CfnSpotFleet$LaunchTemplateOverridesProperty$Builder
                                                CfnSpotFleet$LoadBalancersConfigProperty$Builder
                                                CfnSpotFleet$MemoryGiBPerVCpuRequestProperty$Builder
                                                CfnSpotFleet$MemoryMiBRequestProperty$Builder
                                                CfnSpotFleet$NetworkBandwidthGbpsRequestProperty$Builder
                                                CfnSpotFleet$NetworkInterfaceCountRequestProperty$Builder
                                                CfnSpotFleet$PrivateIpAddressSpecificationProperty$Builder
                                                CfnSpotFleet$SpotCapacityRebalanceProperty$Builder
                                                CfnSpotFleet$SpotFleetLaunchSpecificationProperty$Builder
                                                CfnSpotFleet$SpotFleetMonitoringProperty$Builder
                                                CfnSpotFleet$SpotFleetRequestConfigDataProperty$Builder
                                                CfnSpotFleet$SpotFleetTagSpecificationProperty$Builder
                                                CfnSpotFleet$SpotMaintenanceStrategiesProperty$Builder
                                                CfnSpotFleet$SpotPlacementProperty$Builder
                                                CfnSpotFleet$TargetGroupProperty$Builder
                                                CfnSpotFleet$TargetGroupsConfigProperty$Builder
                                                CfnSpotFleet$TotalLocalStorageGBRequestProperty$Builder
                                                CfnSpotFleet$VCpuCountRangeRequestProperty$Builder
                                                CfnSpotFleetProps$Builder
                                                CfnSubnet$Builder
                                                CfnSubnet$PrivateDnsNameOptionsOnLaunchProperty$Builder
                                                CfnSubnetCidrBlock$Builder
                                                CfnSubnetCidrBlockProps$Builder
                                                CfnSubnetNetworkAclAssociation$Builder
                                                CfnSubnetNetworkAclAssociationProps$Builder
                                                CfnSubnetProps$Builder
                                                CfnSubnetRouteTableAssociation$Builder
                                                CfnSubnetRouteTableAssociationProps$Builder
                                                CfnTrafficMirrorFilter$Builder
                                                CfnTrafficMirrorFilterProps$Builder
                                                CfnTrafficMirrorFilterRule$Builder
                                                CfnTrafficMirrorFilterRule$TrafficMirrorPortRangeProperty$Builder
                                                CfnTrafficMirrorFilterRuleProps$Builder
                                                CfnTrafficMirrorSession$Builder
                                                CfnTrafficMirrorSessionProps$Builder
                                                CfnTrafficMirrorTarget$Builder
                                                CfnTrafficMirrorTargetProps$Builder
                                                CfnTransitGateway$Builder
                                                CfnTransitGatewayAttachment$Builder
                                                CfnTransitGatewayAttachment$OptionsProperty$Builder
                                                CfnTransitGatewayAttachmentProps$Builder
                                                CfnTransitGatewayConnect$Builder
                                                CfnTransitGatewayConnect$TransitGatewayConnectOptionsProperty$Builder
                                                CfnTransitGatewayConnectProps$Builder
                                                CfnTransitGatewayMulticastDomain$Builder
                                                CfnTransitGatewayMulticastDomain$OptionsProperty$Builder
                                                CfnTransitGatewayMulticastDomainAssociation$Builder
                                                CfnTransitGatewayMulticastDomainAssociationProps$Builder
                                                CfnTransitGatewayMulticastDomainProps$Builder
                                                CfnTransitGatewayMulticastGroupMember$Builder
                                                CfnTransitGatewayMulticastGroupMemberProps$Builder
                                                CfnTransitGatewayMulticastGroupSource$Builder
                                                CfnTransitGatewayMulticastGroupSourceProps$Builder
                                                CfnTransitGatewayPeeringAttachment$Builder
                                                CfnTransitGatewayPeeringAttachment$PeeringAttachmentStatusProperty$Builder
                                                CfnTransitGatewayPeeringAttachmentProps$Builder
                                                CfnTransitGatewayProps$Builder
                                                CfnTransitGatewayRoute$Builder
                                                CfnTransitGatewayRouteProps$Builder
                                                CfnTransitGatewayRouteTable$Builder
                                                CfnTransitGatewayRouteTableAssociation$Builder
                                                CfnTransitGatewayRouteTableAssociationProps$Builder
                                                CfnTransitGatewayRouteTablePropagation$Builder
                                                CfnTransitGatewayRouteTablePropagationProps$Builder
                                                CfnTransitGatewayRouteTableProps$Builder
                                                CfnTransitGatewayVpcAttachment$Builder
                                                CfnTransitGatewayVpcAttachment$OptionsProperty$Builder
                                                CfnTransitGatewayVpcAttachmentProps$Builder
                                                CfnVPC$Builder
                                                CfnVPCCidrBlock$Builder
                                                CfnVPCCidrBlockProps$Builder
                                                CfnVPCDHCPOptionsAssociation$Builder
                                                CfnVPCDHCPOptionsAssociationProps$Builder
                                                CfnVPCEndpoint$Builder
                                                CfnVPCEndpointConnectionNotification$Builder
                                                CfnVPCEndpointConnectionNotificationProps$Builder
                                                CfnVPCEndpointProps$Builder
                                                CfnVPCEndpointService$Builder
                                                CfnVPCEndpointServicePermissions$Builder
                                                CfnVPCEndpointServicePermissionsProps$Builder
                                                CfnVPCEndpointServiceProps$Builder
                                                CfnVPCGatewayAttachment$Builder
                                                CfnVPCGatewayAttachmentProps$Builder
                                                CfnVPCPeeringConnection$Builder
                                                CfnVPCPeeringConnectionProps$Builder
                                                CfnVPCProps$Builder
                                                CfnVPNConnection$Builder
                                                CfnVPNConnection$VpnTunnelOptionsSpecificationProperty$Builder
                                                CfnVPNConnectionProps$Builder
                                                CfnVPNConnectionRoute$Builder
                                                CfnVPNConnectionRouteProps$Builder
                                                CfnVPNGateway$Builder
                                                CfnVPNGatewayProps$Builder
                                                CfnVPNGatewayRoutePropagation$Builder
                                                CfnVPNGatewayRoutePropagationProps$Builder
                                                CfnVerifiedAccessEndpoint$Builder
                                                CfnVerifiedAccessEndpoint$LoadBalancerOptionsProperty$Builder
                                                CfnVerifiedAccessEndpoint$NetworkInterfaceOptionsProperty$Builder
                                                CfnVerifiedAccessEndpoint$SseSpecificationProperty$Builder
                                                CfnVerifiedAccessEndpointProps$Builder
                                                CfnVerifiedAccessGroup$Builder
                                                CfnVerifiedAccessGroup$SseSpecificationProperty$Builder
                                                CfnVerifiedAccessGroupProps$Builder
                                                CfnVerifiedAccessInstance$Builder
                                                CfnVerifiedAccessInstance$CloudWatchLogsProperty$Builder
                                                CfnVerifiedAccessInstance$KinesisDataFirehoseProperty$Builder
                                                CfnVerifiedAccessInstance$S3Property$Builder
                                                CfnVerifiedAccessInstance$VerifiedAccessLogsProperty$Builder
                                                CfnVerifiedAccessInstance$VerifiedAccessTrustProviderProperty$Builder
                                                CfnVerifiedAccessInstanceProps$Builder
                                                CfnVerifiedAccessTrustProvider$Builder
                                                CfnVerifiedAccessTrustProvider$DeviceOptionsProperty$Builder
                                                CfnVerifiedAccessTrustProvider$OidcOptionsProperty$Builder
                                                CfnVerifiedAccessTrustProvider$SseSpecificationProperty$Builder
                                                CfnVerifiedAccessTrustProviderProps$Builder
                                                CfnVolume$Builder
                                                CfnVolumeAttachment$Builder
                                                CfnVolumeAttachmentProps$Builder
                                                CfnVolumeProps$Builder
                                                ClientVpnAuthorizationRule$Builder
                                                ClientVpnAuthorizationRuleOptions$Builder
                                                ClientVpnAuthorizationRuleProps$Builder
                                                ClientVpnEndpoint$Builder
                                                ClientVpnEndpointAttributes$Builder
                                                ClientVpnEndpointOptions$Builder
                                                ClientVpnEndpointProps$Builder
                                                ClientVpnRoute$Builder
                                                ClientVpnRouteOptions$Builder
                                                ClientVpnRouteProps$Builder
                                                ClientVpnSessionTimeout
                                                CommonNetworkAclEntryOptions$Builder
                                                ConfigSetProps$Builder
                                                ConfigureNatOptions$Builder
                                                ConnectionRule$Builder
                                                Connections$Builder
                                                ConnectionsProps$Builder
                                                CpuCredits
                                                CreateIpv6CidrBlocksRequest$Builder
                                                DefaultInstanceTenancy
                                                DestinationOptions$Builder
                                                EbsDeviceOptions$Builder
                                                EbsDeviceOptionsBase$Builder
                                                EbsDeviceProps$Builder
                                                EbsDeviceSnapshotOptions$Builder
                                                EbsDeviceVolumeType
                                                EnableVpnGatewayOptions$Builder
                                                ExecuteFileOptions$Builder
                                                FlowLog$Builder
                                                FlowLogDestinationConfig$Builder
                                                FlowLogDestinationType
                                                FlowLogFileFormat
                                                FlowLogMaxAggregationInterval
                                                FlowLogOptions$Builder
                                                FlowLogProps$Builder
                                                FlowLogTrafficType
                                                GatewayConfig$Builder
                                                GatewayVpcEndpoint$Builder
                                                GatewayVpcEndpointOptions$Builder
                                                GatewayVpcEndpointProps$Builder
                                                GenericLinuxImage$Builder
                                                GenericLinuxImageProps$Builder
                                                GenericWindowsImage$Builder
                                                GenericWindowsImageProps$Builder
                                                InitCommandOptions$Builder
                                                InitFileAssetOptions$Builder
                                                InitFileOptions$Builder
                                                InitServiceOptions$Builder
                                                InitSourceAssetOptions$Builder
                                                InitSourceOptions$Builder
                                                InitUserOptions$Builder
                                                Instance$Builder
                                                InstanceArchitecture
                                                InstanceClass
                                                InstanceInitiatedShutdownBehavior
                                                InstanceProps$Builder
                                                InstanceRequireImdsv2Aspect$Builder
                                                InstanceRequireImdsv2AspectProps$Builder
                                                InstanceSize
                                                InterfaceVpcEndpoint$Builder
                                                InterfaceVpcEndpointAttributes$Builder
                                                InterfaceVpcEndpointAwsService$Builder
                                                InterfaceVpcEndpointAwsServiceProps$Builder
                                                InterfaceVpcEndpointOptions$Builder
                                                InterfaceVpcEndpointProps$Builder
                                                IpProtocol
                                                KeyPair$Builder
                                                KeyPairAttributes$Builder
                                                KeyPairFormat
                                                KeyPairProps$Builder
                                                KeyPairType
                                                LaunchTemplate$Builder
                                                LaunchTemplateAttributes$Builder
                                                LaunchTemplateHttpTokens
                                                LaunchTemplateProps$Builder
                                                LaunchTemplateRequireImdsv2Aspect$Builder
                                                LaunchTemplateRequireImdsv2AspectProps$Builder
                                                LaunchTemplateSpotOptions$Builder
                                                LinuxUserDataOptions$Builder
                                                LocationPackageOptions$Builder
                                                LookupMachineImage$Builder
                                                LookupMachineImageProps$Builder
                                                MachineImageConfig$Builder
                                                MultipartBodyOptions$Builder
                                                MultipartUserData$Builder
                                                MultipartUserDataOptions$Builder
                                                NamedPackageOptions$Builder
                                                NatGatewayProps$Builder
                                                NatInstanceProps$Builder
                                                NatInstanceProviderV2$Builder
                                                NatTrafficDirection
                                                NetworkAcl$Builder
                                                NetworkAclEntry$Builder
                                                NetworkAclEntryProps$Builder
                                                NetworkAclProps$Builder
                                                OperatingSystemType
                                                PlacementGroup$Builder
                                                PlacementGroupProps$Builder
                                                PlacementGroupSpreadLevel
                                                PlacementGroupStrategy
                                                Port$Builder
                                                PortProps$Builder
                                                PrefixList$Builder
                                                PrefixListOptions$Builder
                                                PrefixListProps$Builder
                                                PrivateSubnet$Builder
                                                PrivateSubnetAttributes$Builder
                                                PrivateSubnetProps$Builder
                                                Protocol
                                                PublicSubnet$Builder
                                                PublicSubnetAttributes$Builder
                                                PublicSubnetProps$Builder
                                                RequestedSubnet$Builder
                                                ResolveSsmParameterAtLaunchImage$Builder
                                                RouterType
                                                RuleScope$Builder
                                                S3DestinationOptions$Builder
                                                S3DownloadOptions$Builder
                                                SecurityGroup$Builder
                                                SecurityGroupImportOptions$Builder
                                                SecurityGroupProps$Builder
                                                SelectedSubnets$Builder
                                                ServiceManager
                                                SpotInstanceInterruption
                                                SpotRequestType
                                                SsmParameterImageOptions$Builder
                                                Subnet$Builder
                                                SubnetAttributes$Builder
                                                SubnetConfiguration$Builder
                                                SubnetIpamOptions$Builder
                                                SubnetNetworkAclAssociation$Builder
                                                SubnetNetworkAclAssociationProps$Builder
                                                SubnetProps$Builder
                                                SubnetSelection$Builder
                                                SubnetType
                                                SystemdConfigFileOptions$Builder
                                                TrafficDirection
                                                TransportProtocol
                                                Volume$Builder
                                                VolumeAttributes$Builder
                                                VolumeProps$Builder
                                                Vpc$Builder
                                                VpcAttributes$Builder
                                                VpcEndpointService$Builder
                                                VpcEndpointServiceProps$Builder
                                                VpcEndpointType
                                                VpcIpamOptions$Builder
                                                VpcLookupOptions$Builder
                                                VpcProps$Builder
                                                VpnConnection$Builder
                                                VpnConnectionAttributes$Builder
                                                VpnConnectionOptions$Builder
                                                VpnConnectionProps$Builder
                                                VpnConnectionType
                                                VpnGateway$Builder
                                                VpnGatewayProps$Builder
                                                VpnPort
                                                VpnTunnelOption$Builder
                                                WindowsImage$Builder
                                                WindowsImageProps$Builder
                                                WindowsUserDataOptions$Builder
                                                WindowsVersion]))


(defn action
  "The `action` function data interprets values in the provided config data into a 
`Action` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `Action` - the value is returned.
* is `:deny` - `Action/DENY` is returned
* is `:allow` - `Action/ALLOW` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? Action data) data
      (= :deny data) Action/DENY
      (= :allow data) Action/ALLOW)))


(defn address-family
  "The `address-family` function data interprets values in the provided config data into a 
`AddressFamily` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `AddressFamily` - the value is returned.
* is `:ip-v4` - `AddressFamily/IP_V4` is returned
* is `:ip-v6` - `AddressFamily/IP_V6` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? AddressFamily data) data
      (= :ip-v4 data) AddressFamily/IP_V4
      (= :ip-v6 data) AddressFamily/IP_V6)))


(defn amazon-linux-cpu-type
  "The `amazon-linux-cpu-type` function data interprets values in the provided config data into a 
`AmazonLinuxCpuType` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `AmazonLinuxCpuType` - the value is returned.
* is `:arm-64` - `AmazonLinuxCpuType/ARM_64` is returned
* is `:x86-64` - `AmazonLinuxCpuType/X86_64` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? AmazonLinuxCpuType data) data
      (= :arm-64 data) AmazonLinuxCpuType/ARM_64
      (= :x86-64 data) AmazonLinuxCpuType/X86_64)))


(defn amazon-linux-edition
  "The `amazon-linux-edition` function data interprets values in the provided config data into a 
`AmazonLinuxEdition` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `AmazonLinuxEdition` - the value is returned.
* is `:minimal` - `AmazonLinuxEdition/MINIMAL` is returned
* is `:standard` - `AmazonLinuxEdition/STANDARD` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? AmazonLinuxEdition data) data
      (= :minimal data) AmazonLinuxEdition/MINIMAL
      (= :standard data) AmazonLinuxEdition/STANDARD)))


(defn amazon-linux-generation
  "The `amazon-linux-generation` function data interprets values in the provided config data into a 
`AmazonLinuxGeneration` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `AmazonLinuxGeneration` - the value is returned.
* is `:amazon-linux-2` - `AmazonLinuxGeneration/AMAZON_LINUX_2` is returned
* is `:amazon-linux` - `AmazonLinuxGeneration/AMAZON_LINUX` is returned
* is `:amazon-linux-2022` - `AmazonLinuxGeneration/AMAZON_LINUX_2022` is returned
* is `:amazon-linux-2023` - `AmazonLinuxGeneration/AMAZON_LINUX_2023` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? AmazonLinuxGeneration data) data
      (= :amazon-linux-2 data) AmazonLinuxGeneration/AMAZON_LINUX_2
      (= :amazon-linux data) AmazonLinuxGeneration/AMAZON_LINUX
      (= :amazon-linux-2022 data) AmazonLinuxGeneration/AMAZON_LINUX_2022
      (= :amazon-linux-2023 data) AmazonLinuxGeneration/AMAZON_LINUX_2023)))


(defn amazon-linux-kernel
  "The `amazon-linux-kernel` function data interprets values in the provided config data into a 
`AmazonLinuxKernel` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `AmazonLinuxKernel` - the value is returned.
* is `:kernel6-1` - `AmazonLinuxKernel/KERNEL6_1` is returned
* is `:kernel5-x` - `AmazonLinuxKernel/KERNEL5_X` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? AmazonLinuxKernel data) data
      (= :kernel6-1 data) AmazonLinuxKernel/KERNEL6_1
      (= :kernel5-x data) AmazonLinuxKernel/KERNEL5_X)))


(defn amazon-linux-storage
  "The `amazon-linux-storage` function data interprets values in the provided config data into a 
`AmazonLinuxStorage` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `AmazonLinuxStorage` - the value is returned.
* is `:ebs` - `AmazonLinuxStorage/EBS` is returned
* is `:s3` - `AmazonLinuxStorage/S3` is returned
* is `:general-purpose` - `AmazonLinuxStorage/GENERAL_PURPOSE` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? AmazonLinuxStorage data) data
      (= :ebs data) AmazonLinuxStorage/EBS
      (= :s3 data) AmazonLinuxStorage/S3
      (= :general-purpose data) AmazonLinuxStorage/GENERAL_PURPOSE)))


(defn amazon-linux-virt
  "The `amazon-linux-virt` function data interprets values in the provided config data into a 
`AmazonLinuxVirt` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `AmazonLinuxVirt` - the value is returned.
* is `:pv` - `AmazonLinuxVirt/PV` is returned
* is `:hvm` - `AmazonLinuxVirt/HVM` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? AmazonLinuxVirt data) data
      (= :pv data) AmazonLinuxVirt/PV
      (= :hvm data) AmazonLinuxVirt/HVM)))


(defn client-vpn-session-timeout
  "The `client-vpn-session-timeout` function data interprets values in the provided config data into a 
`ClientVpnSessionTimeout` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `ClientVpnSessionTimeout` - the value is returned.
* is `:eight-hours` - `ClientVpnSessionTimeout/EIGHT_HOURS` is returned
* is `:twenty-four-hours` - `ClientVpnSessionTimeout/TWENTY_FOUR_HOURS` is returned
* is `:twelve-hours` - `ClientVpnSessionTimeout/TWELVE_HOURS` is returned
* is `:ten-hours` - `ClientVpnSessionTimeout/TEN_HOURS` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? ClientVpnSessionTimeout data) data
      (= :eight-hours data) ClientVpnSessionTimeout/EIGHT_HOURS
      (= :twenty-four-hours data) ClientVpnSessionTimeout/TWENTY_FOUR_HOURS
      (= :twelve-hours data) ClientVpnSessionTimeout/TWELVE_HOURS
      (= :ten-hours data) ClientVpnSessionTimeout/TEN_HOURS)))


(defn cpu-credits
  "The `cpu-credits` function data interprets values in the provided config data into a 
`CpuCredits` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `CpuCredits` - the value is returned.
* is `:unlimited` - `CpuCredits/UNLIMITED` is returned
* is `:standard` - `CpuCredits/STANDARD` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? CpuCredits data) data
      (= :unlimited data) CpuCredits/UNLIMITED
      (= :standard data) CpuCredits/STANDARD)))


(defn default-instance-tenancy
  "The `default-instance-tenancy` function data interprets values in the provided config data into a 
`DefaultInstanceTenancy` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `DefaultInstanceTenancy` - the value is returned.
* is `:dedicated` - `DefaultInstanceTenancy/DEDICATED` is returned
* is `:default` - `DefaultInstanceTenancy/DEFAULT` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? DefaultInstanceTenancy data) data
      (= :dedicated data) DefaultInstanceTenancy/DEDICATED
      (= :default data) DefaultInstanceTenancy/DEFAULT)))


(defn ebs-device-volume-type
  "The `ebs-device-volume-type` function data interprets values in the provided config data into a 
`EbsDeviceVolumeType` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `EbsDeviceVolumeType` - the value is returned.
* is `:io1` - `EbsDeviceVolumeType/IO1` is returned
* is `:gp2` - `EbsDeviceVolumeType/GP2` is returned
* is `:sc1` - `EbsDeviceVolumeType/SC1` is returned
* is `:gp3` - `EbsDeviceVolumeType/GP3` is returned
* is `:standard` - `EbsDeviceVolumeType/STANDARD` is returned
* is `:st1` - `EbsDeviceVolumeType/ST1` is returned
* is `:io2` - `EbsDeviceVolumeType/IO2` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? EbsDeviceVolumeType data) data
      (= :io1 data) EbsDeviceVolumeType/IO1
      (= :gp2 data) EbsDeviceVolumeType/GP2
      (= :sc1 data) EbsDeviceVolumeType/SC1
      (= :gp3 data) EbsDeviceVolumeType/GP3
      (= :standard data) EbsDeviceVolumeType/STANDARD
      (= :st1 data) EbsDeviceVolumeType/ST1
      (= :io2 data) EbsDeviceVolumeType/IO2)))


(defn flow-log-destination-type
  "The `flow-log-destination-type` function data interprets values in the provided config data into a 
`FlowLogDestinationType` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `FlowLogDestinationType` - the value is returned.
* is `:s3` - `FlowLogDestinationType/S3` is returned
* is `:cloud-watch-logs` - `FlowLogDestinationType/CLOUD_WATCH_LOGS` is returned
* is `:kinesis-data-firehose` - `FlowLogDestinationType/KINESIS_DATA_FIREHOSE` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? FlowLogDestinationType data) data
      (= :s3 data) FlowLogDestinationType/S3
      (= :cloud-watch-logs data) FlowLogDestinationType/CLOUD_WATCH_LOGS
      (= :kinesis-data-firehose data) FlowLogDestinationType/KINESIS_DATA_FIREHOSE)))


(defn flow-log-file-format
  "The `flow-log-file-format` function data interprets values in the provided config data into a 
`FlowLogFileFormat` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `FlowLogFileFormat` - the value is returned.
* is `:parquet` - `FlowLogFileFormat/PARQUET` is returned
* is `:plain-text` - `FlowLogFileFormat/PLAIN_TEXT` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? FlowLogFileFormat data) data
      (= :parquet data) FlowLogFileFormat/PARQUET
      (= :plain-text data) FlowLogFileFormat/PLAIN_TEXT)))


(defn flow-log-max-aggregation-interval
  "The `flow-log-max-aggregation-interval` function data interprets values in the provided config data into a 
`FlowLogMaxAggregationInterval` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `FlowLogMaxAggregationInterval` - the value is returned.
* is `:ten-minutes` - `FlowLogMaxAggregationInterval/TEN_MINUTES` is returned
* is `:one-minute` - `FlowLogMaxAggregationInterval/ONE_MINUTE` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? FlowLogMaxAggregationInterval data) data
      (= :ten-minutes data) FlowLogMaxAggregationInterval/TEN_MINUTES
      (= :one-minute data) FlowLogMaxAggregationInterval/ONE_MINUTE)))


(defn flow-log-traffic-type
  "The `flow-log-traffic-type` function data interprets values in the provided config data into a 
`FlowLogTrafficType` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `FlowLogTrafficType` - the value is returned.
* is `:all` - `FlowLogTrafficType/ALL` is returned
* is `:reject` - `FlowLogTrafficType/REJECT` is returned
* is `:accept` - `FlowLogTrafficType/ACCEPT` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? FlowLogTrafficType data) data
      (= :all data) FlowLogTrafficType/ALL
      (= :reject data) FlowLogTrafficType/REJECT
      (= :accept data) FlowLogTrafficType/ACCEPT)))


(defn instance-architecture
  "The `instance-architecture` function data interprets values in the provided config data into a 
`InstanceArchitecture` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `InstanceArchitecture` - the value is returned.
* is `:x86-64` - `InstanceArchitecture/X86_64` is returned
* is `:arm-64` - `InstanceArchitecture/ARM_64` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? InstanceArchitecture data) data
      (= :x86-64 data) InstanceArchitecture/X86_64
      (= :arm-64 data) InstanceArchitecture/ARM_64)))


(defn instance-class
  "The `instance-class` function data interprets values in the provided config data into a 
`InstanceClass` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `InstanceClass` - the value is returned.
* is `:c5d` - `InstanceClass/C5D` is returned
* is `:standard7-amd` - `InstanceClass/STANDARD7_AMD` is returned
* is `:fpga1` - `InstanceClass/FPGA1` is returned
* is `:standard7-graviton` - `InstanceClass/STANDARD7_GRAVITON` is returned
* is `:r4` - `InstanceClass/R4` is returned
* is `:p3dn` - `InstanceClass/P3DN` is returned
* is `:memory5-amd` - `InstanceClass/MEMORY5_AMD` is returned
* is `:memory-intensive-2-graviton2-nvme-drive` - `InstanceClass/MEMORY_INTENSIVE_2_GRAVITON2_NVME_DRIVE` is returned
* is `:standard5` - `InstanceClass/STANDARD5` is returned
* is `:memory5-high-performance` - `InstanceClass/MEMORY5_HIGH_PERFORMANCE` is returned
* is `:standard6-amd` - `InstanceClass/STANDARD6_AMD` is returned
* is `:standard5-high-compute` - `InstanceClass/STANDARD5_HIGH_COMPUTE` is returned
* is `:memory6-intel-nvme-drive` - `InstanceClass/MEMORY6_INTEL_NVME_DRIVE` is returned
* is `:high-memory-24tb-1` - `InstanceClass/HIGH_MEMORY_24TB_1` is returned
* is `:i4g` - `InstanceClass/I4G` is returned
* is `:m5n` - `InstanceClass/M5N` is returned
* is `:c6i` - `InstanceClass/C6I` is returned
* is `:dl1` - `InstanceClass/DL1` is returned
* is `:memory5-ebs-optimized` - `InstanceClass/MEMORY5_EBS_OPTIMIZED` is returned
* is `:compute5-amd` - `InstanceClass/COMPUTE5_AMD` is returned
* is `:compute5` - `InstanceClass/COMPUTE5` is returned
* is `:parallel2` - `InstanceClass/PARALLEL2` is returned
* is `:m6in` - `InstanceClass/M6IN` is returned
* is `:hpc6id` - `InstanceClass/HPC6ID` is returned
* is `:r7g` - `InstanceClass/R7G` is returned
* is `:trn1` - `InstanceClass/TRN1` is returned
* is `:compute5-amd-nvme-drive` - `InstanceClass/COMPUTE5_AMD_NVME_DRIVE` is returned
* is `:standard5-high-performance` - `InstanceClass/STANDARD5_HIGH_PERFORMANCE` is returned
* is `:i4i` - `InstanceClass/I4I` is returned
* is `:a1` - `InstanceClass/A1` is returned
* is `:c6gn` - `InstanceClass/C6GN` is returned
* is `:graphics4-nvme-drive-high-performance` - `InstanceClass/GRAPHICS4_NVME_DRIVE_HIGH_PERFORMANCE` is returned
* is `:storage3` - `InstanceClass/STORAGE3` is returned
* is `:storage4-graviton-network-storage-optimized` - `InstanceClass/STORAGE4_GRAVITON_NETWORK_STORAGE_OPTIMIZED` is returned
* is `:c7g` - `InstanceClass/C7G` is returned
* is `:high-memory-6tb-1` - `InstanceClass/HIGH_MEMORY_6TB_1` is returned
* is `:compute6-intel-nvme-drive` - `InstanceClass/COMPUTE6_INTEL_NVME_DRIVE` is returned
* is `:r5dn` - `InstanceClass/R5DN` is returned
* is `:t3a` - `InstanceClass/T3A` is returned
* is `:u-6tb1` - `InstanceClass/U_6TB1` is returned
* is `:mac2-m2pro` - `InstanceClass/MAC2_M2PRO` is returned
* is `:memory6-graviton2-nvme-drive` - `InstanceClass/MEMORY6_GRAVITON2_NVME_DRIVE` is returned
* is `:x2iedn` - `InstanceClass/X2IEDN` is returned
* is `:inference1` - `InstanceClass/INFERENCE1` is returned
* is `:high-compute-memory1` - `InstanceClass/HIGH_COMPUTE_MEMORY1` is returned
* is `:m6id` - `InstanceClass/M6ID` is returned
* is `:memory7-intel` - `InstanceClass/MEMORY7_INTEL` is returned
* is `:graphics5-graviton2` - `InstanceClass/GRAPHICS5_GRAVITON2` is returned
* is `:parallel3` - `InstanceClass/PARALLEL3` is returned
* is `:memory5-amd-nvme-drive` - `InstanceClass/MEMORY5_AMD_NVME_DRIVE` is returned
* is `:r5a` - `InstanceClass/R5A` is returned
* is `:m5d` - `InstanceClass/M5D` is returned
* is `:m6gd` - `InstanceClass/M6GD` is returned
* is `:r5d` - `InstanceClass/R5D` is returned
* is `:trn1n` - `InstanceClass/TRN1N` is returned
* is `:hpc7g` - `InstanceClass/HPC7G` is returned
* is `:r7iz` - `InstanceClass/R7IZ` is returned
* is `:compute7-graviton3` - `InstanceClass/COMPUTE7_GRAVITON3` is returned
* is `:c7a` - `InstanceClass/C7A` is returned
* is `:m3` - `InstanceClass/M3` is returned
* is `:m5a` - `InstanceClass/M5A` is returned
* is `:compute5-nvme-drive` - `InstanceClass/COMPUTE5_NVME_DRIVE` is returned
* is `:memory7-intel-base` - `InstanceClass/MEMORY7_INTEL_BASE` is returned
* is `:training-accelerator1-enhanced-network` - `InstanceClass/TRAINING_ACCELERATOR1_ENHANCED_NETWORK` is returned
* is `:standard5-amd` - `InstanceClass/STANDARD5_AMD` is returned
* is `:r6i` - `InstanceClass/R6I` is returned
* is `:u-18tb1` - `InstanceClass/U_18TB1` is returned
* is `:m7i` - `InstanceClass/M7I` is returned
* is `:c6g` - `InstanceClass/C6G` is returned
* is `:r6in` - `InstanceClass/R6IN` is returned
* is `:parallel3-nvme-drive-high-performance` - `InstanceClass/PARALLEL3_NVME_DRIVE_HIGH_PERFORMANCE` is returned
* is `:high-memory-12tb-1` - `InstanceClass/HIGH_MEMORY_12TB_1` is returned
* is `:memory6-amd` - `InstanceClass/MEMORY6_AMD` is returned
* is `:r6a` - `InstanceClass/R6A` is returned
* is `:m4` - `InstanceClass/M4` is returned
* is `:graphics3` - `InstanceClass/GRAPHICS3` is returned
* is `:g5` - `InstanceClass/G5` is returned
* is `:high-memory-18tb-1` - `InstanceClass/HIGH_MEMORY_18TB_1` is returned
* is `:c5` - `InstanceClass/C5` is returned
* is `:training-accelerator1` - `InstanceClass/TRAINING_ACCELERATOR1` is returned
* is `:x1` - `InstanceClass/X1` is returned
* is `:x2iezn` - `InstanceClass/X2IEZN` is returned
* is `:i3en` - `InstanceClass/I3EN` is returned
* is `:memory3` - `InstanceClass/MEMORY3` is returned
* is `:m7gd` - `InstanceClass/M7GD` is returned
* is `:x2g` - `InstanceClass/X2G` is returned
* is `:io3-dense-nvme-drive` - `InstanceClass/IO3_DENSE_NVME_DRIVE` is returned
* is `:standard6-intel-high-performance` - `InstanceClass/STANDARD6_INTEL_HIGH_PERFORMANCE` is returned
* is `:r6gd` - `InstanceClass/R6GD` is returned
* is `:video-transcoding1` - `InstanceClass/VIDEO_TRANSCODING1` is returned
* is `:macintosh2-m1` - `InstanceClass/MACINTOSH2_M1` is returned
* is `:m5dn` - `InstanceClass/M5DN` is returned
* is `:storage4-graviton-network-optimized` - `InstanceClass/STORAGE4_GRAVITON_NETWORK_OPTIMIZED` is returned
* is `:r5` - `InstanceClass/R5` is returned
* is `:x2gd` - `InstanceClass/X2GD` is returned
* is `:memory-intensive-1-extended` - `InstanceClass/MEMORY_INTENSIVE_1_EXTENDED` is returned
* is `:c5ad` - `InstanceClass/C5AD` is returned
* is `:parallel4` - `InstanceClass/PARALLEL4` is returned
* is `:parallel4-nvme-drive-extended` - `InstanceClass/PARALLEL4_NVME_DRIVE_EXTENDED` is returned
* is `:c6id` - `InstanceClass/C6ID` is returned
* is `:m5ad` - `InstanceClass/M5AD` is returned
* is `:c5n` - `InstanceClass/C5N` is returned
* is `:macintosh1-intel` - `InstanceClass/MACINTOSH1_INTEL` is returned
* is `:standard6-intel` - `InstanceClass/STANDARD6_INTEL` is returned
* is `:memory-intensive-2-graviton2` - `InstanceClass/MEMORY_INTENSIVE_2_GRAVITON2` is returned
* is `:inference2` - `InstanceClass/INFERENCE2` is returned
* is `:compute6-intel-high-performance` - `InstanceClass/COMPUTE6_INTEL_HIGH_PERFORMANCE` is returned
* is `:vt1` - `InstanceClass/VT1` is returned
* is `:memory5-nvme-drive-high-performance` - `InstanceClass/MEMORY5_NVME_DRIVE_HIGH_PERFORMANCE` is returned
* is `:standard6-intel-nvme-drive-high-performance` - `InstanceClass/STANDARD6_INTEL_NVME_DRIVE_HIGH_PERFORMANCE` is returned
* is `:storage2` - `InstanceClass/STORAGE2` is returned
* is `:high-performance-computing6-amd` - `InstanceClass/HIGH_PERFORMANCE_COMPUTING6_AMD` is returned
* is `:arm1` - `InstanceClass/ARM1` is returned
* is `:x1e` - `InstanceClass/X1E` is returned
* is `:inf1` - `InstanceClass/INF1` is returned
* is `:hpc6a` - `InstanceClass/HPC6A` is returned
* is `:memory6-graviton` - `InstanceClass/MEMORY6_GRAVITON` is returned
* is `:c3` - `InstanceClass/C3` is returned
* is `:macintosh2-m2-pro` - `InstanceClass/MACINTOSH2_M2_PRO` is returned
* is `:c6in` - `InstanceClass/C6IN` is returned
* is `:high-memory-3tb-1` - `InstanceClass/HIGH_MEMORY_3TB_1` is returned
* is `:graphics4-amd-nvme-drive` - `InstanceClass/GRAPHICS4_AMD_NVME_DRIVE` is returned
* is `:mac1` - `InstanceClass/MAC1` is returned
* is `:standard5-nvme-drive` - `InstanceClass/STANDARD5_NVME_DRIVE` is returned
* is `:memory6-intel-high-performance` - `InstanceClass/MEMORY6_INTEL_HIGH_PERFORMANCE` is returned
* is `:m7g` - `InstanceClass/M7G` is returned
* is `:hpc7a` - `InstanceClass/HPC7A` is returned
* is `:compute7-graviton3-high-network-bandwidth` - `InstanceClass/COMPUTE7_GRAVITON3_HIGH_NETWORK_BANDWIDTH` is returned
* is `:h1` - `InstanceClass/H1` is returned
* is `:inf2` - `InstanceClass/INF2` is returned
* is `:u-24tb1` - `InstanceClass/U_24TB1` is returned
* is `:im4gn` - `InstanceClass/IM4GN` is returned
* is `:m6idn` - `InstanceClass/M6IDN` is returned
* is `:memory5` - `InstanceClass/MEMORY5` is returned
* is `:standard5-nvme-drive-high-performance` - `InstanceClass/STANDARD5_NVME_DRIVE_HIGH_PERFORMANCE` is returned
* is `:standard4` - `InstanceClass/STANDARD4` is returned
* is `:r7gd` - `InstanceClass/R7GD` is returned
* is `:r5ad` - `InstanceClass/R5AD` is returned
* is `:c7gn` - `InstanceClass/C7GN` is returned
* is `:p4d` - `InstanceClass/P4D` is returned
* is `:f1` - `InstanceClass/F1` is returned
* is `:io3` - `InstanceClass/IO3` is returned
* is `:m7a` - `InstanceClass/M7A` is returned
* is `:m6a` - `InstanceClass/M6A` is returned
* is `:compute6-graviton2-nvme-drive` - `InstanceClass/COMPUTE6_GRAVITON2_NVME_DRIVE` is returned
* is `:u-9tb1` - `InstanceClass/U_9TB1` is returned
* is `:memory-intensive-1` - `InstanceClass/MEMORY_INTENSIVE_1` is returned
* is `:storage4-graviton` - `InstanceClass/STORAGE4_GRAVITON` is returned
* is `:standard6-graviton` - `InstanceClass/STANDARD6_GRAVITON` is returned
* is `:m5` - `InstanceClass/M5` is returned
* is `:standard6-intel-nvme-drive` - `InstanceClass/STANDARD6_INTEL_NVME_DRIVE` is returned
* is `:i3` - `InstanceClass/I3` is returned
* is `:burstable3` - `InstanceClass/BURSTABLE3` is returned
* is `:r5n` - `InstanceClass/R5N` is returned
* is `:storage-compute-1` - `InstanceClass/STORAGE_COMPUTE_1` is returned
* is `:d3en` - `InstanceClass/D3EN` is returned
* is `:standard7-graviton3-nvme-drive` - `InstanceClass/STANDARD7_GRAVITON3_NVME_DRIVE` is returned
* is `:g5g` - `InstanceClass/G5G` is returned
* is `:high-performance-computing6-intel-nvme-drive` - `InstanceClass/HIGH_PERFORMANCE_COMPUTING6_INTEL_NVME_DRIVE` is returned
* is `:compute4` - `InstanceClass/COMPUTE4` is returned
* is `:p3` - `InstanceClass/P3` is returned
* is `:standard6-graviton2-nvme-drive` - `InstanceClass/STANDARD6_GRAVITON2_NVME_DRIVE` is returned
* is `:g4ad` - `InstanceClass/G4AD` is returned
* is `:p4de` - `InstanceClass/P4DE` is returned
* is `:memory4` - `InstanceClass/MEMORY4` is returned
* is `:parallel5` - `InstanceClass/PARALLEL5` is returned
* is `:mac2` - `InstanceClass/MAC2` is returned
* is `:t4g` - `InstanceClass/T4G` is returned
* is `:compute7-amd` - `InstanceClass/COMPUTE7_AMD` is returned
* is `:t2` - `InstanceClass/T2` is returned
* is `:r6id` - `InstanceClass/R6ID` is returned
* is `:c6a` - `InstanceClass/C6A` is returned
* is `:u-3tb1` - `InstanceClass/U_3TB1` is returned
* is `:deep-learning2-qualcomm` - `InstanceClass/DEEP_LEARNING2_QUALCOMM` is returned
* is `:compute6-graviton2` - `InstanceClass/COMPUTE6_GRAVITON2` is returned
* is `:standard7-intel-flex` - `InstanceClass/STANDARD7_INTEL_FLEX` is returned
* is `:compute5-high-performance` - `InstanceClass/COMPUTE5_HIGH_PERFORMANCE` is returned
* is `:mac2-m2` - `InstanceClass/MAC2_M2` is returned
* is `:compute7-graviton3-nvme-drive` - `InstanceClass/COMPUTE7_GRAVITON3_NVME_DRIVE` is returned
* is `:m6g` - `InstanceClass/M6G` is returned
* is `:r5b` - `InstanceClass/R5B` is returned
* is `:memory-intensive-2-intel` - `InstanceClass/MEMORY_INTENSIVE_2_INTEL` is returned
* is `:burstable4-graviton` - `InstanceClass/BURSTABLE4_GRAVITON` is returned
* is `:memory7-amd` - `InstanceClass/MEMORY7_AMD` is returned
* is `:r3` - `InstanceClass/R3` is returned
* is `:deep-learning1` - `InstanceClass/DEEP_LEARNING1` is returned
* is `:m6i` - `InstanceClass/M6I` is returned
* is `:standard5-amd-nvme-drive` - `InstanceClass/STANDARD5_AMD_NVME_DRIVE` is returned
* is `:compute3` - `InstanceClass/COMPUTE3` is returned
* is `:standard7-intel` - `InstanceClass/STANDARD7_INTEL` is returned
* is `:c6gd` - `InstanceClass/C6GD` is returned
* is `:memory-intensive-2-xt-intel` - `InstanceClass/MEMORY_INTENSIVE_2_XT_INTEL` is returned
* is `:d2` - `InstanceClass/D2` is returned
* is `:c7i` - `InstanceClass/C7I` is returned
* is `:graphics5` - `InstanceClass/GRAPHICS5` is returned
* is `:compute6-intel` - `InstanceClass/COMPUTE6_INTEL` is returned
* is `:memory-intensive-2-xtz-intel` - `InstanceClass/MEMORY_INTENSIVE_2_XTZ_INTEL` is returned
* is `:t3` - `InstanceClass/T3` is returned
* is `:compute6-graviton2-high-network-bandwidth` - `InstanceClass/COMPUTE6_GRAVITON2_HIGH_NETWORK_BANDWIDTH` is returned
* is `:storage3-enhanced-network` - `InstanceClass/STORAGE3_ENHANCED_NETWORK` is returned
* is `:c7gd` - `InstanceClass/C7GD` is returned
* is `:x2idn` - `InstanceClass/X2IDN` is returned
* is `:c5a` - `InstanceClass/C5A` is returned
* is `:memory6-intel-nvme-drive-high-performance` - `InstanceClass/MEMORY6_INTEL_NVME_DRIVE_HIGH_PERFORMANCE` is returned
* is `:high-performance-computing7-graviton` - `InstanceClass/HIGH_PERFORMANCE_COMPUTING7_GRAVITON` is returned
* is `:graphics3-small` - `InstanceClass/GRAPHICS3_SMALL` is returned
* is `:c4` - `InstanceClass/C4` is returned
* is `:memory5-nvme-drive` - `InstanceClass/MEMORY5_NVME_DRIVE` is returned
* is `:u-12tb1` - `InstanceClass/U_12TB1` is returned
* is `:burstable2` - `InstanceClass/BURSTABLE2` is returned
* is `:r6idn` - `InstanceClass/R6IDN` is returned
* is `:m7i-flex` - `InstanceClass/M7I_FLEX` is returned
* is `:high-performance-computing7-amd` - `InstanceClass/HIGH_PERFORMANCE_COMPUTING7_AMD` is returned
* is `:burstable3-amd` - `InstanceClass/BURSTABLE3_AMD` is returned
* is `:g3s` - `InstanceClass/G3S` is returned
* is `:memory7-graviton` - `InstanceClass/MEMORY7_GRAVITON` is returned
* is `:d3` - `InstanceClass/D3` is returned
* is `:compute7-intel` - `InstanceClass/COMPUTE7_INTEL` is returned
* is `:memory6-intel` - `InstanceClass/MEMORY6_INTEL` is returned
* is `:g3` - `InstanceClass/G3` is returned
* is `:m5zn` - `InstanceClass/M5ZN` is returned
* is `:p5` - `InstanceClass/P5` is returned
* is `:g4dn` - `InstanceClass/G4DN` is returned
* is `:z1d` - `InstanceClass/Z1D` is returned
* is `:r6g` - `InstanceClass/R6G` is returned
* is `:r7a` - `InstanceClass/R7A` is returned
* is `:memory7-graviton3-nvme-drive` - `InstanceClass/MEMORY7_GRAVITON3_NVME_DRIVE` is returned
* is `:io4-intel` - `InstanceClass/IO4_INTEL` is returned
* is `:is4gen` - `InstanceClass/IS4GEN` is returned
* is `:compute6-amd` - `InstanceClass/COMPUTE6_AMD` is returned
* is `:dl2q` - `InstanceClass/DL2Q` is returned
* is `:macintosh2-m2` - `InstanceClass/MACINTOSH2_M2` is returned
* is `:standard3` - `InstanceClass/STANDARD3` is returned
* is `:r7i` - `InstanceClass/R7I` is returned
* is `:p2` - `InstanceClass/P2` is returned
* is `:high-memory-9tb-1` - `InstanceClass/HIGH_MEMORY_9TB_1` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? InstanceClass data) data
      (= :c5d data) InstanceClass/C5D
      (= :standard7-amd data) InstanceClass/STANDARD7_AMD
      (= :fpga1 data) InstanceClass/FPGA1
      (= :standard7-graviton data) InstanceClass/STANDARD7_GRAVITON
      (= :r4 data) InstanceClass/R4
      (= :p3dn data) InstanceClass/P3DN
      (= :memory5-amd data) InstanceClass/MEMORY5_AMD
      (= :memory-intensive-2-graviton2-nvme-drive data) InstanceClass/MEMORY_INTENSIVE_2_GRAVITON2_NVME_DRIVE
      (= :standard5 data) InstanceClass/STANDARD5
      (= :memory5-high-performance data) InstanceClass/MEMORY5_HIGH_PERFORMANCE
      (= :standard6-amd data) InstanceClass/STANDARD6_AMD
      (= :standard5-high-compute data) InstanceClass/STANDARD5_HIGH_COMPUTE
      (= :memory6-intel-nvme-drive data) InstanceClass/MEMORY6_INTEL_NVME_DRIVE
      (= :high-memory-24tb-1 data) InstanceClass/HIGH_MEMORY_24TB_1
      (= :i4g data) InstanceClass/I4G
      (= :m5n data) InstanceClass/M5N
      (= :c6i data) InstanceClass/C6I
      (= :dl1 data) InstanceClass/DL1
      (= :memory5-ebs-optimized data) InstanceClass/MEMORY5_EBS_OPTIMIZED
      (= :compute5-amd data) InstanceClass/COMPUTE5_AMD
      (= :compute5 data) InstanceClass/COMPUTE5
      (= :parallel2 data) InstanceClass/PARALLEL2
      (= :m6in data) InstanceClass/M6IN
      (= :hpc6id data) InstanceClass/HPC6ID
      (= :r7g data) InstanceClass/R7G
      (= :trn1 data) InstanceClass/TRN1
      (= :compute5-amd-nvme-drive data) InstanceClass/COMPUTE5_AMD_NVME_DRIVE
      (= :standard5-high-performance data) InstanceClass/STANDARD5_HIGH_PERFORMANCE
      (= :i4i data) InstanceClass/I4I
      (= :a1 data) InstanceClass/A1
      (= :c6gn data) InstanceClass/C6GN
      (= :graphics4-nvme-drive-high-performance data) InstanceClass/GRAPHICS4_NVME_DRIVE_HIGH_PERFORMANCE
      (= :storage3 data) InstanceClass/STORAGE3
      (= :storage4-graviton-network-storage-optimized data) InstanceClass/STORAGE4_GRAVITON_NETWORK_STORAGE_OPTIMIZED
      (= :c7g data) InstanceClass/C7G
      (= :high-memory-6tb-1 data) InstanceClass/HIGH_MEMORY_6TB_1
      (= :compute6-intel-nvme-drive data) InstanceClass/COMPUTE6_INTEL_NVME_DRIVE
      (= :r5dn data) InstanceClass/R5DN
      (= :t3a data) InstanceClass/T3A
      (= :u-6tb1 data) InstanceClass/U_6TB1
      (= :mac2-m2pro data) InstanceClass/MAC2_M2PRO
      (= :memory6-graviton2-nvme-drive data) InstanceClass/MEMORY6_GRAVITON2_NVME_DRIVE
      (= :x2iedn data) InstanceClass/X2IEDN
      (= :inference1 data) InstanceClass/INFERENCE1
      (= :high-compute-memory1 data) InstanceClass/HIGH_COMPUTE_MEMORY1
      (= :m6id data) InstanceClass/M6ID
      (= :memory7-intel data) InstanceClass/MEMORY7_INTEL
      (= :graphics5-graviton2 data) InstanceClass/GRAPHICS5_GRAVITON2
      (= :parallel3 data) InstanceClass/PARALLEL3
      (= :memory5-amd-nvme-drive data) InstanceClass/MEMORY5_AMD_NVME_DRIVE
      (= :r5a data) InstanceClass/R5A
      (= :m5d data) InstanceClass/M5D
      (= :m6gd data) InstanceClass/M6GD
      (= :r5d data) InstanceClass/R5D
      (= :trn1n data) InstanceClass/TRN1N
      (= :hpc7g data) InstanceClass/HPC7G
      (= :r7iz data) InstanceClass/R7IZ
      (= :compute7-graviton3 data) InstanceClass/COMPUTE7_GRAVITON3
      (= :c7a data) InstanceClass/C7A
      (= :m3 data) InstanceClass/M3
      (= :m5a data) InstanceClass/M5A
      (= :compute5-nvme-drive data) InstanceClass/COMPUTE5_NVME_DRIVE
      (= :memory7-intel-base data) InstanceClass/MEMORY7_INTEL_BASE
      (= :training-accelerator1-enhanced-network data) InstanceClass/TRAINING_ACCELERATOR1_ENHANCED_NETWORK
      (= :standard5-amd data) InstanceClass/STANDARD5_AMD
      (= :r6i data) InstanceClass/R6I
      (= :u-18tb1 data) InstanceClass/U_18TB1
      (= :m7i data) InstanceClass/M7I
      (= :c6g data) InstanceClass/C6G
      (= :r6in data) InstanceClass/R6IN
      (= :parallel3-nvme-drive-high-performance data) InstanceClass/PARALLEL3_NVME_DRIVE_HIGH_PERFORMANCE
      (= :high-memory-12tb-1 data) InstanceClass/HIGH_MEMORY_12TB_1
      (= :memory6-amd data) InstanceClass/MEMORY6_AMD
      (= :r6a data) InstanceClass/R6A
      (= :m4 data) InstanceClass/M4
      (= :graphics3 data) InstanceClass/GRAPHICS3
      (= :g5 data) InstanceClass/G5
      (= :high-memory-18tb-1 data) InstanceClass/HIGH_MEMORY_18TB_1
      (= :c5 data) InstanceClass/C5
      (= :training-accelerator1 data) InstanceClass/TRAINING_ACCELERATOR1
      (= :x1 data) InstanceClass/X1
      (= :x2iezn data) InstanceClass/X2IEZN
      (= :i3en data) InstanceClass/I3EN
      (= :memory3 data) InstanceClass/MEMORY3
      (= :m7gd data) InstanceClass/M7GD
      (= :x2g data) InstanceClass/X2G
      (= :io3-dense-nvme-drive data) InstanceClass/IO3_DENSE_NVME_DRIVE
      (= :standard6-intel-high-performance data) InstanceClass/STANDARD6_INTEL_HIGH_PERFORMANCE
      (= :r6gd data) InstanceClass/R6GD
      (= :video-transcoding1 data) InstanceClass/VIDEO_TRANSCODING1
      (= :macintosh2-m1 data) InstanceClass/MACINTOSH2_M1
      (= :m5dn data) InstanceClass/M5DN
      (= :storage4-graviton-network-optimized data) InstanceClass/STORAGE4_GRAVITON_NETWORK_OPTIMIZED
      (= :r5 data) InstanceClass/R5
      (= :x2gd data) InstanceClass/X2GD
      (= :memory-intensive-1-extended data) InstanceClass/MEMORY_INTENSIVE_1_EXTENDED
      (= :c5ad data) InstanceClass/C5AD
      (= :parallel4 data) InstanceClass/PARALLEL4
      (= :parallel4-nvme-drive-extended data) InstanceClass/PARALLEL4_NVME_DRIVE_EXTENDED
      (= :c6id data) InstanceClass/C6ID
      (= :m5ad data) InstanceClass/M5AD
      (= :c5n data) InstanceClass/C5N
      (= :macintosh1-intel data) InstanceClass/MACINTOSH1_INTEL
      (= :standard6-intel data) InstanceClass/STANDARD6_INTEL
      (= :memory-intensive-2-graviton2 data) InstanceClass/MEMORY_INTENSIVE_2_GRAVITON2
      (= :inference2 data) InstanceClass/INFERENCE2
      (= :compute6-intel-high-performance data) InstanceClass/COMPUTE6_INTEL_HIGH_PERFORMANCE
      (= :vt1 data) InstanceClass/VT1
      (= :memory5-nvme-drive-high-performance data) InstanceClass/MEMORY5_NVME_DRIVE_HIGH_PERFORMANCE
      (= :standard6-intel-nvme-drive-high-performance data) InstanceClass/STANDARD6_INTEL_NVME_DRIVE_HIGH_PERFORMANCE
      (= :storage2 data) InstanceClass/STORAGE2
      (= :high-performance-computing6-amd data) InstanceClass/HIGH_PERFORMANCE_COMPUTING6_AMD
      (= :arm1 data) InstanceClass/ARM1
      (= :x1e data) InstanceClass/X1E
      (= :inf1 data) InstanceClass/INF1
      (= :hpc6a data) InstanceClass/HPC6A
      (= :memory6-graviton data) InstanceClass/MEMORY6_GRAVITON
      (= :c3 data) InstanceClass/C3
      (= :macintosh2-m2-pro data) InstanceClass/MACINTOSH2_M2_PRO
      (= :c6in data) InstanceClass/C6IN
      (= :high-memory-3tb-1 data) InstanceClass/HIGH_MEMORY_3TB_1
      (= :graphics4-amd-nvme-drive data) InstanceClass/GRAPHICS4_AMD_NVME_DRIVE
      (= :mac1 data) InstanceClass/MAC1
      (= :standard5-nvme-drive data) InstanceClass/STANDARD5_NVME_DRIVE
      (= :memory6-intel-high-performance data) InstanceClass/MEMORY6_INTEL_HIGH_PERFORMANCE
      (= :m7g data) InstanceClass/M7G
      (= :hpc7a data) InstanceClass/HPC7A
      (= :compute7-graviton3-high-network-bandwidth data) InstanceClass/COMPUTE7_GRAVITON3_HIGH_NETWORK_BANDWIDTH
      (= :h1 data) InstanceClass/H1
      (= :inf2 data) InstanceClass/INF2
      (= :u-24tb1 data) InstanceClass/U_24TB1
      (= :im4gn data) InstanceClass/IM4GN
      (= :m6idn data) InstanceClass/M6IDN
      (= :memory5 data) InstanceClass/MEMORY5
      (= :standard5-nvme-drive-high-performance data) InstanceClass/STANDARD5_NVME_DRIVE_HIGH_PERFORMANCE
      (= :standard4 data) InstanceClass/STANDARD4
      (= :r7gd data) InstanceClass/R7GD
      (= :r5ad data) InstanceClass/R5AD
      (= :c7gn data) InstanceClass/C7GN
      (= :p4d data) InstanceClass/P4D
      (= :f1 data) InstanceClass/F1
      (= :io3 data) InstanceClass/IO3
      (= :m7a data) InstanceClass/M7A
      (= :m6a data) InstanceClass/M6A
      (= :compute6-graviton2-nvme-drive data) InstanceClass/COMPUTE6_GRAVITON2_NVME_DRIVE
      (= :u-9tb1 data) InstanceClass/U_9TB1
      (= :memory-intensive-1 data) InstanceClass/MEMORY_INTENSIVE_1
      (= :storage4-graviton data) InstanceClass/STORAGE4_GRAVITON
      (= :standard6-graviton data) InstanceClass/STANDARD6_GRAVITON
      (= :m5 data) InstanceClass/M5
      (= :standard6-intel-nvme-drive data) InstanceClass/STANDARD6_INTEL_NVME_DRIVE
      (= :i3 data) InstanceClass/I3
      (= :burstable3 data) InstanceClass/BURSTABLE3
      (= :r5n data) InstanceClass/R5N
      (= :storage-compute-1 data) InstanceClass/STORAGE_COMPUTE_1
      (= :d3en data) InstanceClass/D3EN
      (= :standard7-graviton3-nvme-drive data) InstanceClass/STANDARD7_GRAVITON3_NVME_DRIVE
      (= :g5g data) InstanceClass/G5G
      (= :high-performance-computing6-intel-nvme-drive data) InstanceClass/HIGH_PERFORMANCE_COMPUTING6_INTEL_NVME_DRIVE
      (= :compute4 data) InstanceClass/COMPUTE4
      (= :p3 data) InstanceClass/P3
      (= :standard6-graviton2-nvme-drive data) InstanceClass/STANDARD6_GRAVITON2_NVME_DRIVE
      (= :g4ad data) InstanceClass/G4AD
      (= :p4de data) InstanceClass/P4DE
      (= :memory4 data) InstanceClass/MEMORY4
      (= :parallel5 data) InstanceClass/PARALLEL5
      (= :mac2 data) InstanceClass/MAC2
      (= :t4g data) InstanceClass/T4G
      (= :compute7-amd data) InstanceClass/COMPUTE7_AMD
      (= :t2 data) InstanceClass/T2
      (= :r6id data) InstanceClass/R6ID
      (= :c6a data) InstanceClass/C6A
      (= :u-3tb1 data) InstanceClass/U_3TB1
      (= :deep-learning2-qualcomm data) InstanceClass/DEEP_LEARNING2_QUALCOMM
      (= :compute6-graviton2 data) InstanceClass/COMPUTE6_GRAVITON2
      (= :standard7-intel-flex data) InstanceClass/STANDARD7_INTEL_FLEX
      (= :compute5-high-performance data) InstanceClass/COMPUTE5_HIGH_PERFORMANCE
      (= :mac2-m2 data) InstanceClass/MAC2_M2
      (= :compute7-graviton3-nvme-drive data) InstanceClass/COMPUTE7_GRAVITON3_NVME_DRIVE
      (= :m6g data) InstanceClass/M6G
      (= :r5b data) InstanceClass/R5B
      (= :memory-intensive-2-intel data) InstanceClass/MEMORY_INTENSIVE_2_INTEL
      (= :burstable4-graviton data) InstanceClass/BURSTABLE4_GRAVITON
      (= :memory7-amd data) InstanceClass/MEMORY7_AMD
      (= :r3 data) InstanceClass/R3
      (= :deep-learning1 data) InstanceClass/DEEP_LEARNING1
      (= :m6i data) InstanceClass/M6I
      (= :standard5-amd-nvme-drive data) InstanceClass/STANDARD5_AMD_NVME_DRIVE
      (= :compute3 data) InstanceClass/COMPUTE3
      (= :standard7-intel data) InstanceClass/STANDARD7_INTEL
      (= :c6gd data) InstanceClass/C6GD
      (= :memory-intensive-2-xt-intel data) InstanceClass/MEMORY_INTENSIVE_2_XT_INTEL
      (= :d2 data) InstanceClass/D2
      (= :c7i data) InstanceClass/C7I
      (= :graphics5 data) InstanceClass/GRAPHICS5
      (= :compute6-intel data) InstanceClass/COMPUTE6_INTEL
      (= :memory-intensive-2-xtz-intel data) InstanceClass/MEMORY_INTENSIVE_2_XTZ_INTEL
      (= :t3 data) InstanceClass/T3
      (= :compute6-graviton2-high-network-bandwidth data) InstanceClass/COMPUTE6_GRAVITON2_HIGH_NETWORK_BANDWIDTH
      (= :storage3-enhanced-network data) InstanceClass/STORAGE3_ENHANCED_NETWORK
      (= :c7gd data) InstanceClass/C7GD
      (= :x2idn data) InstanceClass/X2IDN
      (= :c5a data) InstanceClass/C5A
      (= :memory6-intel-nvme-drive-high-performance data) InstanceClass/MEMORY6_INTEL_NVME_DRIVE_HIGH_PERFORMANCE
      (= :high-performance-computing7-graviton data) InstanceClass/HIGH_PERFORMANCE_COMPUTING7_GRAVITON
      (= :graphics3-small data) InstanceClass/GRAPHICS3_SMALL
      (= :c4 data) InstanceClass/C4
      (= :memory5-nvme-drive data) InstanceClass/MEMORY5_NVME_DRIVE
      (= :u-12tb1 data) InstanceClass/U_12TB1
      (= :burstable2 data) InstanceClass/BURSTABLE2
      (= :r6idn data) InstanceClass/R6IDN
      (= :m7i-flex data) InstanceClass/M7I_FLEX
      (= :high-performance-computing7-amd data) InstanceClass/HIGH_PERFORMANCE_COMPUTING7_AMD
      (= :burstable3-amd data) InstanceClass/BURSTABLE3_AMD
      (= :g3s data) InstanceClass/G3S
      (= :memory7-graviton data) InstanceClass/MEMORY7_GRAVITON
      (= :d3 data) InstanceClass/D3
      (= :compute7-intel data) InstanceClass/COMPUTE7_INTEL
      (= :memory6-intel data) InstanceClass/MEMORY6_INTEL
      (= :g3 data) InstanceClass/G3
      (= :m5zn data) InstanceClass/M5ZN
      (= :p5 data) InstanceClass/P5
      (= :g4dn data) InstanceClass/G4DN
      (= :z1d data) InstanceClass/Z1D
      (= :r6g data) InstanceClass/R6G
      (= :r7a data) InstanceClass/R7A
      (= :memory7-graviton3-nvme-drive data) InstanceClass/MEMORY7_GRAVITON3_NVME_DRIVE
      (= :io4-intel data) InstanceClass/IO4_INTEL
      (= :is4gen data) InstanceClass/IS4GEN
      (= :compute6-amd data) InstanceClass/COMPUTE6_AMD
      (= :dl2q data) InstanceClass/DL2Q
      (= :macintosh2-m2 data) InstanceClass/MACINTOSH2_M2
      (= :standard3 data) InstanceClass/STANDARD3
      (= :r7i data) InstanceClass/R7I
      (= :p2 data) InstanceClass/P2
      (= :high-memory-9tb-1 data) InstanceClass/HIGH_MEMORY_9TB_1)))


(defn instance-initiated-shutdown-behavior
  "The `instance-initiated-shutdown-behavior` function data interprets values in the provided config data into a 
`InstanceInitiatedShutdownBehavior` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `InstanceInitiatedShutdownBehavior` - the value is returned.
* is `:stop` - `InstanceInitiatedShutdownBehavior/STOP` is returned
* is `:terminate` - `InstanceInitiatedShutdownBehavior/TERMINATE` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? InstanceInitiatedShutdownBehavior data) data
      (= :stop data) InstanceInitiatedShutdownBehavior/STOP
      (= :terminate data) InstanceInitiatedShutdownBehavior/TERMINATE)))


(defn instance-size
  "The `instance-size` function data interprets values in the provided config data into a 
`InstanceSize` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `InstanceSize` - the value is returned.
* is `:small` - `InstanceSize/SMALL` is returned
* is `:xlarge6` - `InstanceSize/XLARGE6` is returned
* is `:large` - `InstanceSize/LARGE` is returned
* is `:metal` - `InstanceSize/METAL` is returned
* is `:xlarge48` - `InstanceSize/XLARGE48` is returned
* is `:xlarge9` - `InstanceSize/XLARGE9` is returned
* is `:xlarge24metal` - `InstanceSize/XLARGE24METAL` is returned
* is `:xlarge48metal` - `InstanceSize/XLARGE48METAL` is returned
* is `:xlarge112` - `InstanceSize/XLARGE112` is returned
* is `:xlarge16metal` - `InstanceSize/XLARGE16METAL` is returned
* is `:xlarge18` - `InstanceSize/XLARGE18` is returned
* is `:xlarge8` - `InstanceSize/XLARGE8` is returned
* is `:medium` - `InstanceSize/MEDIUM` is returned
* is `:nano` - `InstanceSize/NANO` is returned
* is `:xlarge16` - `InstanceSize/XLARGE16` is returned
* is `:xlarge12` - `InstanceSize/XLARGE12` is returned
* is `:xlarge3` - `InstanceSize/XLARGE3` is returned
* is `:micro` - `InstanceSize/MICRO` is returned
* is `:xlarge32` - `InstanceSize/XLARGE32` is returned
* is `:xlarge10` - `InstanceSize/XLARGE10` is returned
* is `:xlarge24` - `InstanceSize/XLARGE24` is returned
* is `:xlarge56` - `InstanceSize/XLARGE56` is returned
* is `:xlarge4` - `InstanceSize/XLARGE4` is returned
* is `:xlarge32metal` - `InstanceSize/XLARGE32METAL` is returned
* is `:xlarge2` - `InstanceSize/XLARGE2` is returned
* is `:xlarge` - `InstanceSize/XLARGE` is returned
* is `:xlarge96` - `InstanceSize/XLARGE96` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? InstanceSize data) data
      (= :small data) InstanceSize/SMALL
      (= :xlarge6 data) InstanceSize/XLARGE6
      (= :large data) InstanceSize/LARGE
      (= :metal data) InstanceSize/METAL
      (= :xlarge48 data) InstanceSize/XLARGE48
      (= :xlarge9 data) InstanceSize/XLARGE9
      (= :xlarge24metal data) InstanceSize/XLARGE24METAL
      (= :xlarge48metal data) InstanceSize/XLARGE48METAL
      (= :xlarge112 data) InstanceSize/XLARGE112
      (= :xlarge16metal data) InstanceSize/XLARGE16METAL
      (= :xlarge18 data) InstanceSize/XLARGE18
      (= :xlarge8 data) InstanceSize/XLARGE8
      (= :medium data) InstanceSize/MEDIUM
      (= :nano data) InstanceSize/NANO
      (= :xlarge16 data) InstanceSize/XLARGE16
      (= :xlarge12 data) InstanceSize/XLARGE12
      (= :xlarge3 data) InstanceSize/XLARGE3
      (= :micro data) InstanceSize/MICRO
      (= :xlarge32 data) InstanceSize/XLARGE32
      (= :xlarge10 data) InstanceSize/XLARGE10
      (= :xlarge24 data) InstanceSize/XLARGE24
      (= :xlarge56 data) InstanceSize/XLARGE56
      (= :xlarge4 data) InstanceSize/XLARGE4
      (= :xlarge32metal data) InstanceSize/XLARGE32METAL
      (= :xlarge2 data) InstanceSize/XLARGE2
      (= :xlarge data) InstanceSize/XLARGE
      (= :xlarge96 data) InstanceSize/XLARGE96)))


(defn ip-protocol
  "The `ip-protocol` function data interprets values in the provided config data into a 
`IpProtocol` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `IpProtocol` - the value is returned.
* is `:ipv4-only` - `IpProtocol/IPV4_ONLY` is returned
* is `:dual-stack` - `IpProtocol/DUAL_STACK` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? IpProtocol data) data
      (= :ipv4-only data) IpProtocol/IPV4_ONLY
      (= :dual-stack data) IpProtocol/DUAL_STACK)))


(defn key-pair-format
  "The `key-pair-format` function data interprets values in the provided config data into a 
`KeyPairFormat` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `KeyPairFormat` - the value is returned.
* is `:ppk` - `KeyPairFormat/PPK` is returned
* is `:pem` - `KeyPairFormat/PEM` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? KeyPairFormat data) data
      (= :ppk data) KeyPairFormat/PPK
      (= :pem data) KeyPairFormat/PEM)))


(defn key-pair-type
  "The `key-pair-type` function data interprets values in the provided config data into a 
`KeyPairType` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `KeyPairType` - the value is returned.
* is `:ed25519` - `KeyPairType/ED25519` is returned
* is `:rsa` - `KeyPairType/RSA` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? KeyPairType data) data
      (= :ed25519 data) KeyPairType/ED25519
      (= :rsa data) KeyPairType/RSA)))


(defn launch-template-http-tokens
  "The `launch-template-http-tokens` function data interprets values in the provided config data into a 
`LaunchTemplateHttpTokens` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `LaunchTemplateHttpTokens` - the value is returned.
* is `:optional` - `LaunchTemplateHttpTokens/OPTIONAL` is returned
* is `:required` - `LaunchTemplateHttpTokens/REQUIRED` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? LaunchTemplateHttpTokens data) data
      (= :optional data) LaunchTemplateHttpTokens/OPTIONAL
      (= :required data) LaunchTemplateHttpTokens/REQUIRED)))


(defn nat-traffic-direction
  "The `nat-traffic-direction` function data interprets values in the provided config data into a 
`NatTrafficDirection` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `NatTrafficDirection` - the value is returned.
* is `:outbound-only` - `NatTrafficDirection/OUTBOUND_ONLY` is returned
* is `:inbound-and-outbound` - `NatTrafficDirection/INBOUND_AND_OUTBOUND` is returned
* is `:none` - `NatTrafficDirection/NONE` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? NatTrafficDirection data) data
      (= :outbound-only data) NatTrafficDirection/OUTBOUND_ONLY
      (= :inbound-and-outbound data) NatTrafficDirection/INBOUND_AND_OUTBOUND
      (= :none data) NatTrafficDirection/NONE)))


(defn operating-system-type
  "The `operating-system-type` function data interprets values in the provided config data into a 
`OperatingSystemType` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `OperatingSystemType` - the value is returned.
* is `:windows` - `OperatingSystemType/WINDOWS` is returned
* is `:linux` - `OperatingSystemType/LINUX` is returned
* is `:unknown` - `OperatingSystemType/UNKNOWN` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? OperatingSystemType data) data
      (= :windows data) OperatingSystemType/WINDOWS
      (= :linux data) OperatingSystemType/LINUX
      (= :unknown data) OperatingSystemType/UNKNOWN)))


(defn placement-group-spread-level
  "The `placement-group-spread-level` function data interprets values in the provided config data into a 
`PlacementGroupSpreadLevel` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `PlacementGroupSpreadLevel` - the value is returned.
* is `:rack` - `PlacementGroupSpreadLevel/RACK` is returned
* is `:host` - `PlacementGroupSpreadLevel/HOST` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? PlacementGroupSpreadLevel data) data
      (= :rack data) PlacementGroupSpreadLevel/RACK
      (= :host data) PlacementGroupSpreadLevel/HOST)))


(defn placement-group-strategy
  "The `placement-group-strategy` function data interprets values in the provided config data into a 
`PlacementGroupStrategy` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `PlacementGroupStrategy` - the value is returned.
* is `:partition` - `PlacementGroupStrategy/PARTITION` is returned
* is `:spread` - `PlacementGroupStrategy/SPREAD` is returned
* is `:cluster` - `PlacementGroupStrategy/CLUSTER` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? PlacementGroupStrategy data) data
      (= :partition data) PlacementGroupStrategy/PARTITION
      (= :spread data) PlacementGroupStrategy/SPREAD
      (= :cluster data) PlacementGroupStrategy/CLUSTER)))


(defn protocol
  "The `protocol` function data interprets values in the provided config data into a 
`Protocol` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `Protocol` - the value is returned.
* is `:tpplusplus` - `Protocol/TPPLUSPLUS` is returned
* is `:netblt` - `Protocol/NETBLT` is returned
* is `:ipv6-frag` - `Protocol/IPV6_FRAG` is returned
* is `:sscopmce` - `Protocol/SSCOPMCE` is returned
* is `:pup` - `Protocol/PUP` is returned
* is `:tcf` - `Protocol/TCF` is returned
* is `:ggp` - `Protocol/GGP` is returned
* is `:mobile` - `Protocol/MOBILE` is returned
* is `:iptm` - `Protocol/IPTM` is returned
* is `:igp` - `Protocol/IGP` is returned
* is `:cftp` - `Protocol/CFTP` is returned
* is `:snp` - `Protocol/SNP` is returned
* is `:qnx` - `Protocol/QNX` is returned
* is `:sps` - `Protocol/SPS` is returned
* is `:wb-mon` - `Protocol/WB_MON` is returned
* is `:ttp` - `Protocol/TTP` is returned
* is `:smp` - `Protocol/SMP` is returned
* is `:uti` - `Protocol/UTI` is returned
* is `:narp` - `Protocol/NARP` is returned
* is `:fc` - `Protocol/FC` is returned
* is `:chaos` - `Protocol/CHAOS` is returned
* is `:ifmp` - `Protocol/IFMP` is returned
* is `:tcp` - `Protocol/TCP` is returned
* is `:ipv6-route` - `Protocol/IPV6_ROUTE` is returned
* is `:experiment-2` - `Protocol/EXPERIMENT_2` is returned
* is `:srp` - `Protocol/SRP` is returned
* is `:ipv6` - `Protocol/IPV6` is returned
* is `:micp` - `Protocol/MICP` is returned
* is `:stp` - `Protocol/STP` is returned
* is `:i-nlsp` - `Protocol/I_NLSP` is returned
* is `:mfe-nsp` - `Protocol/MFE_NSP` is returned
* is `:sat-mon` - `Protocol/SAT_MON` is returned
* is `:il` - `Protocol/IL` is returned
* is `:l2-t-p` - `Protocol/L2_T_P` is returned
* is `:reserved` - `Protocol/RESERVED` is returned
* is `:gre` - `Protocol/GRE` is returned
* is `:experiment-1` - `Protocol/EXPERIMENT_1` is returned
* is `:trunk-1` - `Protocol/TRUNK_1` is returned
* is `:icmp` - `Protocol/ICMP` is returned
* is `:gmtp` - `Protocol/GMTP` is returned
* is `:aris` - `Protocol/ARIS` is returned
* is `:swipe` - `Protocol/SWIPE` is returned
* is `:emcon` - `Protocol/EMCON` is returned
* is `:eigrp` - `Protocol/EIGRP` is returned
* is `:merit-inp` - `Protocol/MERIT_INP` is returned
* is `:etherip` - `Protocol/ETHERIP` is returned
* is `:ddx` - `Protocol/DDX` is returned
* is `:vines` - `Protocol/VINES` is returned
* is `:fire` - `Protocol/FIRE` is returned
* is `:wb-expak` - `Protocol/WB_EXPAK` is returned
* is `:idpr-cmtp` - `Protocol/IDPR_CMTP` is returned
* is `:ipv6-opts` - `Protocol/IPV6_OPTS` is returned
* is `:iso-ip` - `Protocol/ISO_IP` is returned
* is `:vmtp` - `Protocol/VMTP` is returned
* is `:any-dfs` - `Protocol/ANY_DFS` is returned
* is `:st` - `Protocol/ST` is returned
* is `:encap` - `Protocol/ENCAP` is returned
* is `:bna` - `Protocol/BNA` is returned
* is `:iplt` - `Protocol/IPLT` is returned
* is `:any-0-hop` - `Protocol/ANY_0_HOP` is returned
* is `:sm` - `Protocol/SM` is returned
* is `:pgm` - `Protocol/PGM` is returned
* is `:ptp` - `Protocol/PTP` is returned
* is `:tlsp` - `Protocol/TLSP` is returned
* is `:iso-tp4` - `Protocol/ISO_TP4` is returned
* is `:crtp` - `Protocol/CRTP` is returned
* is `:udp` - `Protocol/UDP` is returned
* is `:trunk-2` - `Protocol/TRUNK_2` is returned
* is `:sun-nd` - `Protocol/SUN_ND` is returned
* is `:ipv6-nonxt` - `Protocol/IPV6_NONXT` is returned
* is `:dccp` - `Protocol/DCCP` is returned
* is `:nvp-ii` - `Protocol/NVP_II` is returned
* is `:dcn-meas` - `Protocol/DCN_MEAS` is returned
* is `:rdp` - `Protocol/RDP` is returned
* is `:xnet` - `Protocol/XNET` is returned
* is `:ipx-in-ip` - `Protocol/IPX_IN_IP` is returned
* is `:esp` - `Protocol/ESP` is returned
* is `:crudp` - `Protocol/CRUDP` is returned
* is `:shim6` - `Protocol/SHIM6` is returned
* is `:br-sat-mon` - `Protocol/BR_SAT_MON` is returned
* is `:hip` - `Protocol/HIP` is returned
* is `:sdrp` - `Protocol/SDRP` is returned
* is `:larp` - `Protocol/LARP` is returned
* is `:rsvp` - `Protocol/RSVP` is returned
* is `:ah` - `Protocol/AH` is returned
* is `:hopopt` - `Protocol/HOPOPT` is returned
* is `:isis-ipv4` - `Protocol/ISIS_IPV4` is returned
* is `:rohc` - `Protocol/ROHC` is returned
* is `:mtp` - `Protocol/MTP` is returned
* is `:nsfnet-igp` - `Protocol/NSFNET_IGP` is returned
* is `:vrrp` - `Protocol/VRRP` is returned
* is `:a-n` - `Protocol/A_N` is returned
* is `:rsvp-e2e-ignore` - `Protocol/RSVP_E2E_IGNORE` is returned
* is `:sctp` - `Protocol/SCTP` is returned
* is `:kryptolan` - `Protocol/KRYPTOLAN` is returned
* is `:ethernet` - `Protocol/ETHERNET` is returned
* is `:mpls-in-ip` - `Protocol/MPLS_IN_IP` is returned
* is `:ippc` - `Protocol/IPPC` is returned
* is `:ipv4` - `Protocol/IPV4` is returned
* is `:any-enc` - `Protocol/ANY_ENC` is returned
* is `:xtp` - `Protocol/XTP` is returned
* is `:scc-sp` - `Protocol/SCC_SP` is returned
* is `:manet` - `Protocol/MANET` is returned
* is `:pnni` - `Protocol/PNNI` is returned
* is `:pim` - `Protocol/PIM` is returned
* is `:igmp` - `Protocol/IGMP` is returned
* is `:cbt` - `Protocol/CBT` is returned
* is `:ipcomp` - `Protocol/IPCOMP` is returned
* is `:prm` - `Protocol/PRM` is returned
* is `:irtp` - `Protocol/IRTP` is returned
* is `:pvp` - `Protocol/PVP` is returned
* is `:sat-expak` - `Protocol/SAT_EXPAK` is returned
* is `:mobility-header` - `Protocol/MOBILITY_HEADER` is returned
* is `:icmpv6` - `Protocol/ICMPV6` is returned
* is `:leaf-2` - `Protocol/LEAF_2` is returned
* is `:compaq-peer` - `Protocol/COMPAQ_PEER` is returned
* is `:cphb` - `Protocol/CPHB` is returned
* is `:cpnx` - `Protocol/CPNX` is returned
* is `:egp` - `Protocol/EGP` is returned
* is `:xns-idp` - `Protocol/XNS_IDP` is returned
* is `:mux` - `Protocol/MUX` is returned
* is `:bbn-rcc-mon` - `Protocol/BBN_RCC_MON` is returned
* is `:dsr` - `Protocol/DSR` is returned
* is `:udplite` - `Protocol/UDPLITE` is returned
* is `:dgp` - `Protocol/DGP` is returned
* is `:secure-vmtp` - `Protocol/SECURE_VMTP` is returned
* is `:idrp` - `Protocol/IDRP` is returned
* is `:ipcv` - `Protocol/IPCV` is returned
* is `:leaf-1` - `Protocol/LEAF_1` is returned
* is `:idpr` - `Protocol/IDPR` is returned
* is `:ipip` - `Protocol/IPIP` is returned
* is `:rvd` - `Protocol/RVD` is returned
* is `:hmp` - `Protocol/HMP` is returned
* is `:iatp` - `Protocol/IATP` is returned
* is `:skip` - `Protocol/SKIP` is returned
* is `:threepc` - `Protocol/THREEPC` is returned
* is `:scps` - `Protocol/SCPS` is returned
* is `:sprite-rpc` - `Protocol/SPRITE_RPC` is returned
* is `:visa` - `Protocol/VISA` is returned
* is `:ax-25` - `Protocol/AX_25` is returned
* is `:ospfigp` - `Protocol/OSPFIGP` is returned
* is `:wsn` - `Protocol/WSN` is returned
* is `:pipe` - `Protocol/PIPE` is returned
* is `:ddp` - `Protocol/DDP` is returned
* is `:wesp` - `Protocol/WESP` is returned
* is `:all` - `Protocol/ALL` is returned
* is `:any-local` - `Protocol/ANY_LOCAL` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? Protocol data) data
      (= :tpplusplus data) Protocol/TPPLUSPLUS
      (= :netblt data) Protocol/NETBLT
      (= :ipv6-frag data) Protocol/IPV6_FRAG
      (= :sscopmce data) Protocol/SSCOPMCE
      (= :pup data) Protocol/PUP
      (= :tcf data) Protocol/TCF
      (= :ggp data) Protocol/GGP
      (= :mobile data) Protocol/MOBILE
      (= :iptm data) Protocol/IPTM
      (= :igp data) Protocol/IGP
      (= :cftp data) Protocol/CFTP
      (= :snp data) Protocol/SNP
      (= :qnx data) Protocol/QNX
      (= :sps data) Protocol/SPS
      (= :wb-mon data) Protocol/WB_MON
      (= :ttp data) Protocol/TTP
      (= :smp data) Protocol/SMP
      (= :uti data) Protocol/UTI
      (= :narp data) Protocol/NARP
      (= :fc data) Protocol/FC
      (= :chaos data) Protocol/CHAOS
      (= :ifmp data) Protocol/IFMP
      (= :tcp data) Protocol/TCP
      (= :ipv6-route data) Protocol/IPV6_ROUTE
      (= :experiment-2 data) Protocol/EXPERIMENT_2
      (= :srp data) Protocol/SRP
      (= :ipv6 data) Protocol/IPV6
      (= :micp data) Protocol/MICP
      (= :stp data) Protocol/STP
      (= :i-nlsp data) Protocol/I_NLSP
      (= :mfe-nsp data) Protocol/MFE_NSP
      (= :sat-mon data) Protocol/SAT_MON
      (= :il data) Protocol/IL
      (= :l2-t-p data) Protocol/L2_T_P
      (= :reserved data) Protocol/RESERVED
      (= :gre data) Protocol/GRE
      (= :experiment-1 data) Protocol/EXPERIMENT_1
      (= :trunk-1 data) Protocol/TRUNK_1
      (= :icmp data) Protocol/ICMP
      (= :gmtp data) Protocol/GMTP
      (= :aris data) Protocol/ARIS
      (= :swipe data) Protocol/SWIPE
      (= :emcon data) Protocol/EMCON
      (= :eigrp data) Protocol/EIGRP
      (= :merit-inp data) Protocol/MERIT_INP
      (= :etherip data) Protocol/ETHERIP
      (= :ddx data) Protocol/DDX
      (= :vines data) Protocol/VINES
      (= :fire data) Protocol/FIRE
      (= :wb-expak data) Protocol/WB_EXPAK
      (= :idpr-cmtp data) Protocol/IDPR_CMTP
      (= :ipv6-opts data) Protocol/IPV6_OPTS
      (= :iso-ip data) Protocol/ISO_IP
      (= :vmtp data) Protocol/VMTP
      (= :any-dfs data) Protocol/ANY_DFS
      (= :st data) Protocol/ST
      (= :encap data) Protocol/ENCAP
      (= :bna data) Protocol/BNA
      (= :iplt data) Protocol/IPLT
      (= :any-0-hop data) Protocol/ANY_0_HOP
      (= :sm data) Protocol/SM
      (= :pgm data) Protocol/PGM
      (= :ptp data) Protocol/PTP
      (= :tlsp data) Protocol/TLSP
      (= :iso-tp4 data) Protocol/ISO_TP4
      (= :crtp data) Protocol/CRTP
      (= :udp data) Protocol/UDP
      (= :trunk-2 data) Protocol/TRUNK_2
      (= :sun-nd data) Protocol/SUN_ND
      (= :ipv6-nonxt data) Protocol/IPV6_NONXT
      (= :dccp data) Protocol/DCCP
      (= :nvp-ii data) Protocol/NVP_II
      (= :dcn-meas data) Protocol/DCN_MEAS
      (= :rdp data) Protocol/RDP
      (= :xnet data) Protocol/XNET
      (= :ipx-in-ip data) Protocol/IPX_IN_IP
      (= :esp data) Protocol/ESP
      (= :crudp data) Protocol/CRUDP
      (= :shim6 data) Protocol/SHIM6
      (= :br-sat-mon data) Protocol/BR_SAT_MON
      (= :hip data) Protocol/HIP
      (= :sdrp data) Protocol/SDRP
      (= :larp data) Protocol/LARP
      (= :rsvp data) Protocol/RSVP
      (= :ah data) Protocol/AH
      (= :hopopt data) Protocol/HOPOPT
      (= :isis-ipv4 data) Protocol/ISIS_IPV4
      (= :rohc data) Protocol/ROHC
      (= :mtp data) Protocol/MTP
      (= :nsfnet-igp data) Protocol/NSFNET_IGP
      (= :vrrp data) Protocol/VRRP
      (= :a-n data) Protocol/A_N
      (= :rsvp-e2e-ignore data) Protocol/RSVP_E2E_IGNORE
      (= :sctp data) Protocol/SCTP
      (= :kryptolan data) Protocol/KRYPTOLAN
      (= :ethernet data) Protocol/ETHERNET
      (= :mpls-in-ip data) Protocol/MPLS_IN_IP
      (= :ippc data) Protocol/IPPC
      (= :ipv4 data) Protocol/IPV4
      (= :any-enc data) Protocol/ANY_ENC
      (= :xtp data) Protocol/XTP
      (= :scc-sp data) Protocol/SCC_SP
      (= :manet data) Protocol/MANET
      (= :pnni data) Protocol/PNNI
      (= :pim data) Protocol/PIM
      (= :igmp data) Protocol/IGMP
      (= :cbt data) Protocol/CBT
      (= :ipcomp data) Protocol/IPCOMP
      (= :prm data) Protocol/PRM
      (= :irtp data) Protocol/IRTP
      (= :pvp data) Protocol/PVP
      (= :sat-expak data) Protocol/SAT_EXPAK
      (= :mobility-header data) Protocol/MOBILITY_HEADER
      (= :icmpv6 data) Protocol/ICMPV6
      (= :leaf-2 data) Protocol/LEAF_2
      (= :compaq-peer data) Protocol/COMPAQ_PEER
      (= :cphb data) Protocol/CPHB
      (= :cpnx data) Protocol/CPNX
      (= :egp data) Protocol/EGP
      (= :xns-idp data) Protocol/XNS_IDP
      (= :mux data) Protocol/MUX
      (= :bbn-rcc-mon data) Protocol/BBN_RCC_MON
      (= :dsr data) Protocol/DSR
      (= :udplite data) Protocol/UDPLITE
      (= :dgp data) Protocol/DGP
      (= :secure-vmtp data) Protocol/SECURE_VMTP
      (= :idrp data) Protocol/IDRP
      (= :ipcv data) Protocol/IPCV
      (= :leaf-1 data) Protocol/LEAF_1
      (= :idpr data) Protocol/IDPR
      (= :ipip data) Protocol/IPIP
      (= :rvd data) Protocol/RVD
      (= :hmp data) Protocol/HMP
      (= :iatp data) Protocol/IATP
      (= :skip data) Protocol/SKIP
      (= :threepc data) Protocol/THREEPC
      (= :scps data) Protocol/SCPS
      (= :sprite-rpc data) Protocol/SPRITE_RPC
      (= :visa data) Protocol/VISA
      (= :ax-25 data) Protocol/AX_25
      (= :ospfigp data) Protocol/OSPFIGP
      (= :wsn data) Protocol/WSN
      (= :pipe data) Protocol/PIPE
      (= :ddp data) Protocol/DDP
      (= :wesp data) Protocol/WESP
      (= :all data) Protocol/ALL
      (= :any-local data) Protocol/ANY_LOCAL)))


(defn router-type
  "The `router-type` function data interprets values in the provided config data into a 
`RouterType` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `RouterType` - the value is returned.
* is `:nat-gateway` - `RouterType/NAT_GATEWAY` is returned
* is `:carrier-gateway` - `RouterType/CARRIER_GATEWAY` is returned
* is `:transit-gateway` - `RouterType/TRANSIT_GATEWAY` is returned
* is `:network-interface` - `RouterType/NETWORK_INTERFACE` is returned
* is `:egress-only-internet-gateway` - `RouterType/EGRESS_ONLY_INTERNET_GATEWAY` is returned
* is `:instance` - `RouterType/INSTANCE` is returned
* is `:gateway` - `RouterType/GATEWAY` is returned
* is `:vpc-peering-connection` - `RouterType/VPC_PEERING_CONNECTION` is returned
* is `:vpc-endpoint` - `RouterType/VPC_ENDPOINT` is returned
* is `:local-gateway` - `RouterType/LOCAL_GATEWAY` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? RouterType data) data
      (= :nat-gateway data) RouterType/NAT_GATEWAY
      (= :carrier-gateway data) RouterType/CARRIER_GATEWAY
      (= :transit-gateway data) RouterType/TRANSIT_GATEWAY
      (= :network-interface data) RouterType/NETWORK_INTERFACE
      (= :egress-only-internet-gateway data) RouterType/EGRESS_ONLY_INTERNET_GATEWAY
      (= :instance data) RouterType/INSTANCE
      (= :gateway data) RouterType/GATEWAY
      (= :vpc-peering-connection data) RouterType/VPC_PEERING_CONNECTION
      (= :vpc-endpoint data) RouterType/VPC_ENDPOINT
      (= :local-gateway data) RouterType/LOCAL_GATEWAY)))


(defn service-manager
  "The `service-manager` function data interprets values in the provided config data into a 
`ServiceManager` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `ServiceManager` - the value is returned.
* is `:sysvinit` - `ServiceManager/SYSVINIT` is returned
* is `:windows` - `ServiceManager/WINDOWS` is returned
* is `:systemd` - `ServiceManager/SYSTEMD` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? ServiceManager data) data
      (= :sysvinit data) ServiceManager/SYSVINIT
      (= :windows data) ServiceManager/WINDOWS
      (= :systemd data) ServiceManager/SYSTEMD)))


(defn spot-instance-interruption
  "The `spot-instance-interruption` function data interprets values in the provided config data into a 
`SpotInstanceInterruption` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `SpotInstanceInterruption` - the value is returned.
* is `:terminate` - `SpotInstanceInterruption/TERMINATE` is returned
* is `:hibernate` - `SpotInstanceInterruption/HIBERNATE` is returned
* is `:stop` - `SpotInstanceInterruption/STOP` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? SpotInstanceInterruption data) data
      (= :terminate data) SpotInstanceInterruption/TERMINATE
      (= :hibernate data) SpotInstanceInterruption/HIBERNATE
      (= :stop data) SpotInstanceInterruption/STOP)))


(defn spot-request-type
  "The `spot-request-type` function data interprets values in the provided config data into a 
`SpotRequestType` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `SpotRequestType` - the value is returned.
* is `:one-time` - `SpotRequestType/ONE_TIME` is returned
* is `:persistent` - `SpotRequestType/PERSISTENT` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? SpotRequestType data) data
      (= :one-time data) SpotRequestType/ONE_TIME
      (= :persistent data) SpotRequestType/PERSISTENT)))


(defn subnet-type
  "The `subnet-type` function data interprets values in the provided config data into a 
`SubnetType` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `SubnetType` - the value is returned.
* is `:private-with-egress` - `SubnetType/PRIVATE_WITH_EGRESS` is returned
* is `:public` - `SubnetType/PUBLIC` is returned
* is `:private-isolated` - `SubnetType/PRIVATE_ISOLATED` is returned
* is `:private-with-nat` - `SubnetType/PRIVATE_WITH_NAT` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? SubnetType data) data
      (= :private-with-egress data) SubnetType/PRIVATE_WITH_EGRESS
      (= :public data) SubnetType/PUBLIC
      (= :private-isolated data) SubnetType/PRIVATE_ISOLATED
      (= :private-with-nat data) SubnetType/PRIVATE_WITH_NAT)))


(defn traffic-direction
  "The `traffic-direction` function data interprets values in the provided config data into a 
`TrafficDirection` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `TrafficDirection` - the value is returned.
* is `:egress` - `TrafficDirection/EGRESS` is returned
* is `:ingress` - `TrafficDirection/INGRESS` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? TrafficDirection data) data
      (= :egress data) TrafficDirection/EGRESS
      (= :ingress data) TrafficDirection/INGRESS)))


(defn transport-protocol
  "The `transport-protocol` function data interprets values in the provided config data into a 
`TransportProtocol` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `TransportProtocol` - the value is returned.
* is `:udp` - `TransportProtocol/UDP` is returned
* is `:tcp` - `TransportProtocol/TCP` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? TransportProtocol data) data
      (= :udp data) TransportProtocol/UDP
      (= :tcp data) TransportProtocol/TCP)))


(defn vpc-endpoint-type
  "The `vpc-endpoint-type` function data interprets values in the provided config data into a 
`VpcEndpointType` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `VpcEndpointType` - the value is returned.
* is `:gateway` - `VpcEndpointType/GATEWAY` is returned
* is `:interface` - `VpcEndpointType/INTERFACE` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? VpcEndpointType data) data
      (= :gateway data) VpcEndpointType/GATEWAY
      (= :interface data) VpcEndpointType/INTERFACE)))


(defn vpn-connection-type
  "The `vpn-connection-type` function data interprets values in the provided config data into a 
`VpnConnectionType` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `VpnConnectionType` - the value is returned.
* is `:dummy` - `VpnConnectionType/DUMMY` is returned
* is `:ipsec-1` - `VpnConnectionType/IPSEC_1` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? VpnConnectionType data) data
      (= :dummy data) VpnConnectionType/DUMMY
      (= :ipsec-1 data) VpnConnectionType/IPSEC_1)))


(defn vpn-port
  "The `vpn-port` function data interprets values in the provided config data into a 
`VpnPort` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `VpnPort` - the value is returned.
* is `:openvpn` - `VpnPort/OPENVPN` is returned
* is `:https` - `VpnPort/HTTPS` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? VpnPort data) data
      (= :openvpn data) VpnPort/OPENVPN
      (= :https data) VpnPort/HTTPS)))


(defn windows-version
  "The `windows-version` function data interprets values in the provided config data into a 
`WindowsVersion` instance.  This simplifies the use of keywords in place of actual enum values in 
the configuration provided to builders.  The value is found using the `cdk.support/lookup-entry` 
function on the data with the provided namespace id and item-key.  The found value is interpretted as follows: 

* instance of `WindowsVersion` - the value is returned.
* is `:windows-server-2019-english-full-hyperv` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_HYPERV` is returned
* is `:windows-server-2022-english-full-eks-optimized-1-25` - `WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_EKS_OPTIMIZED_1_25` is returned
* is `:windows-server-2016-czech-full-base` - `WindowsVersion/WINDOWS_SERVER_2016_CZECH_FULL_BASE` is returned
* is `:windows-server-2016-english-full-sql-2016-sp2-web` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2016_SP2_WEB` is returned
* is `:windows-server-2019-chinese-traditional-full-base` - `WindowsVersion/WINDOWS_SERVER_2019_CHINESE_TRADITIONAL_FULL_BASE` is returned
* is `:windows-server-2016-english-full-sql-2017-web` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2017_WEB` is returned
* is `:windows-server-2012-r2-rtm-english-64bit-sql-2016-sp3-express` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2016_SP3_EXPRESS` is returned
* is `:windows-server-2016-english-full-containers` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_CONTAINERS` is returned
* is `:windows-server-2019-japanese-full-sql-2017-web` - `WindowsVersion/WINDOWS_SERVER_2019_JAPANESE_FULL_SQL_2017_WEB` is returned
* is `:windows-server-2019-japanese-full-sql-2019-standard` - `WindowsVersion/WINDOWS_SERVER_2019_JAPANESE_FULL_SQL_2019_STANDARD` is returned
* is `:windows-server-2012-r2-rtm-german-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_GERMAN_64BIT_BASE` is returned
* is `:windows-server-2016-chinese-simplified-full-base` - `WindowsVersion/WINDOWS_SERVER_2016_CHINESE_SIMPLIFIED_FULL_BASE` is returned
* is `:windows-server-2016-turkish-full-base` - `WindowsVersion/WINDOWS_SERVER_2016_TURKISH_FULL_BASE` is returned
* is `:windows-server-2012-rtm-japanese-64bit-sql-2014-sp2-web` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_JAPANESE_64BIT_SQL_2014_SP2_WEB` is returned
* is `:windows-server-2016-japanese-full-sql-2017-web` - `WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2017_WEB` is returned
* is `:windows-server-2012-rtm-japanese-64bit-sql-2014-sp2-standard` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_JAPANESE_64BIT_SQL_2014_SP2_STANDARD` is returned
* is `:windows-server-2016-polish-full-base` - `WindowsVersion/WINDOWS_SERVER_2016_POLISH_FULL_BASE` is returned
* is `:windows-server-2016-japanese-full-sql-2016-sp2-standard` - `WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2016_SP2_STANDARD` is returned
* is `:windows-server-2008-r2-sp1-korean-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_KOREAN_64BIT_BASE` is returned
* is `:windows-server-2019-english-stig-core` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_STIG_CORE` is returned
* is `:windows-server-2012-rtm-english-full-base` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_ENGLISH_FULL_BASE` is returned
* is `:windows-server-2019-english-full-sql-2016-sp2-web` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2016_SP2_WEB` is returned
* is `:windows-server-2022-japanese-full-sql-2019-web` - `WindowsVersion/WINDOWS_SERVER_2022_JAPANESE_FULL_SQL_2019_WEB` is returned
* is `:windows-server-2012-rtm-portuguese-brazil-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_PORTUGUESE_BRAZIL_64BIT_BASE` is returned
* is `:windows-server-2016-japanese-full-sql-2016-sp1-standard` - `WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2016_SP1_STANDARD` is returned
* is `:windows-server-2022-english-full-sql-2019-standard` - `WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_SQL_2019_STANDARD` is returned
* is `:windows-server-2022-czech-full-base` - `WindowsVersion/WINDOWS_SERVER_2022_CZECH_FULL_BASE` is returned
* is `:windows-server-2022-english-full-sql-2019-express` - `WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_SQL_2019_EXPRESS` is returned
* is `:windows-server-2008-r2-sp1-portuguese-brazil-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_PORTUGUESE_BRAZIL_64BIT_BASE` is returned
* is `:windows-server-2016-japanese-full-sql-2019-enterprise` - `WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2019_ENTERPRISE` is returned
* is `:windows-server-2019-english-full-sql-2016-sp2-standard` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2016_SP2_STANDARD` is returned
* is `:windows-server-2012-r2-rtm-italian-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ITALIAN_64BIT_BASE` is returned
* is `:windows-server-2016-swedish-full-base` - `WindowsVersion/WINDOWS_SERVER_2016_SWEDISH_FULL_BASE` is returned
* is `:windows-server-2016-english-core-sql-2016-sp2-enterprise` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_CORE_SQL_2016_SP2_ENTERPRISE` is returned
* is `:windows-server-2022-hungarian-full-base` - `WindowsVersion/WINDOWS_SERVER_2022_HUNGARIAN_FULL_BASE` is returned
* is `:windows-server-2016-english-full-sql-2019-standard` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2019_STANDARD` is returned
* is `:windows-server-2012-r2-rtm-english-64bit-sql-2016-sp2-standard` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2016_SP2_STANDARD` is returned
* is `:windows-server-2016-english-full-sql-2016-sp2-enterprise` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2016_SP2_ENTERPRISE` is returned
* is `:windows-server-2019-english-core-ecs-optimized` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_CORE_ECS_OPTIMIZED` is returned
* is `:windows-server-2008-sp2-english-64bit-sql-2008-sp4-express` - `WindowsVersion/WINDOWS_SERVER_2008_SP2_ENGLISH_64BIT_SQL_2008_SP4_EXPRESS` is returned
* is `:windows-server-2003-r2-sp2-english-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2003_R2_SP2_ENGLISH_64BIT_BASE` is returned
* is `:windows-server-2022-japanese-full-sql-2022-standard` - `WindowsVersion/WINDOWS_SERVER_2022_JAPANESE_FULL_SQL_2022_STANDARD` is returned
* is `:windows-server-2008-r2-sp1-english-64bit-sql-2012-sp4-web` - `WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_ENGLISH_64BIT_SQL_2012_SP4_WEB` is returned
* is `:windows-server-2016-portuguese-portugal-full-base` - `WindowsVersion/WINDOWS_SERVER_2016_PORTUGUESE_PORTUGAL_FULL_BASE` is returned
* is `:windows-server-2008-r2-sp1-japanese-64bit-sql-2008-r2-sp3-web` - `WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_JAPANESE_64BIT_SQL_2008_R2_SP3_WEB` is returned
* is `:windows-server-2012-rtm-portuguese-portugal-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_PORTUGUESE_PORTUGAL_64BIT_BASE` is returned
* is `:windows-server-2012-rtm-english-64bit-sql-2014-sp3-express` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_ENGLISH_64BIT_SQL_2014_SP3_EXPRESS` is returned
* is `:windows-server-2012-rtm-french-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_FRENCH_64BIT_BASE` is returned
* is `:windows-server-2012-r2-rtm-japanese-64bit-sql-2016-sp2-standard` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_JAPANESE_64BIT_SQL_2016_SP2_STANDARD` is returned
* is `:windows-server-2016-english-core-sql-2016-sp2-standard` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_CORE_SQL_2016_SP2_STANDARD` is returned
* is `:windows-server-2016-english-full-sql-2016-sp1-web` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2016_SP1_WEB` is returned
* is `:windows-server-2012-r2-rtm-french-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_FRENCH_64BIT_BASE` is returned
* is `:windows-server-2019-english-full-sql-2016-sp3-enterprise` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2016_SP3_ENTERPRISE` is returned
* is `:windows-server-2012-rtm-english-64bit-sql-2008-r2-sp3-express` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_ENGLISH_64BIT_SQL_2008_R2_SP3_EXPRESS` is returned
* is `:windows-server-2022-dutch-full-base` - `WindowsVersion/WINDOWS_SERVER_2022_DUTCH_FULL_BASE` is returned
* is `:windows-server-2022-english-full-eks-optimized-1-28` - `WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_EKS_OPTIMIZED_1_28` is returned
* is `:windows-server-2016-japanese-full-base` - `WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_BASE` is returned
* is `:windows-server-1809-english-core-base` - `WindowsVersion/WINDOWS_SERVER_1809_ENGLISH_CORE_BASE` is returned
* is `:windows-server-2012-rtm-russian-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_RUSSIAN_64BIT_BASE` is returned
* is `:windows-server-2012-r2-rtm-japanese-64bit-sql-2016-sp3-express` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_JAPANESE_64BIT_SQL_2016_SP3_EXPRESS` is returned
* is `:windows-server-2012-r2-rtm-english-64bit-sql-2014-sp2-standard` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2014_SP2_STANDARD` is returned
* is `:windows-server-2016-italian-full-base` - `WindowsVersion/WINDOWS_SERVER_2016_ITALIAN_FULL_BASE` is returned
* is `:windows-server-2003-r2-sp2-language-packs-64bit-sql-2005-sp4-standard` - `WindowsVersion/WINDOWS_SERVER_2003_R2_SP2_LANGUAGE_PACKS_64BIT_SQL_2005_SP4_STANDARD` is returned
* is `:windows-server-2012-rtm-english-64bit-sql-2012-sp4-standard` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_ENGLISH_64BIT_SQL_2012_SP4_STANDARD` is returned
* is `:windows-server-2022-french-full-base` - `WindowsVersion/WINDOWS_SERVER_2022_FRENCH_FULL_BASE` is returned
* is `:windows-server-2016-english-full-sql-2016-sp3-express` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2016_SP3_EXPRESS` is returned
* is `:windows-server-2019-portuguese-portugal-full-base` - `WindowsVersion/WINDOWS_SERVER_2019_PORTUGUESE_PORTUGAL_FULL_BASE` is returned
* is `:windows-server-2008-r2-sp1-english-64bit-core` - `WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_ENGLISH_64BIT_CORE` is returned
* is `:windows-server-2012-rtm-italian-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_ITALIAN_64BIT_BASE` is returned
* is `:windows-server-2008-sp2-english-32bit-base` - `WindowsVersion/WINDOWS_SERVER_2008_SP2_ENGLISH_32BIT_BASE` is returned
* is `:windows-server-2012-r2-rtm-english-64bit-sql-2016-sp3-web` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2016_SP3_WEB` is returned
* is `:windows-server-2012-rtm-japanese-64bit-sql-2008-r2-sp3-express` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_JAPANESE_64BIT_SQL_2008_R2_SP3_EXPRESS` is returned
* is `:windows-server-2016-japanese-full-sql-2016-sp3-enterprise` - `WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2016_SP3_ENTERPRISE` is returned
* is `:windows-server-2016-english-full-sql-2016-sp3-standard` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2016_SP3_STANDARD` is returned
* is `:windows-server-2012-r2-rtm-japanese-64bit-sql-2016-sp2-web` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_JAPANESE_64BIT_SQL_2016_SP2_WEB` is returned
* is `:windows-server-2012-r2-rtm-english-p3` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_P3` is returned
* is `:windows-server-2008-r2-sp1-english-64bit-sql-2008-r2-sp3-express` - `WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_ENGLISH_64BIT_SQL_2008_R2_SP3_EXPRESS` is returned
* is `:windows-server-2012-r2-rtm-japanese-64bit-sql-2016-sp3-web` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_JAPANESE_64BIT_SQL_2016_SP3_WEB` is returned
* is `:windows-server-2019-english-core-eks-optimized-1-27` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_CORE_EKS_OPTIMIZED_1_27` is returned
* is `:windows-server-2012-r2-rtm-english-64bit-sql-2016-sp1-enterprise` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2016_SP1_ENTERPRISE` is returned
* is `:windows-server-2012-r2-rtm-english-64bit-sql-2014-sp3-standard` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2014_SP3_STANDARD` is returned
* is `:windows-server-2016-japanese-full-sql-2019-standard` - `WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2019_STANDARD` is returned
* is `:windows-server-2003-r2-sp2-language-packs-64bit-sql-2005-sp4-express` - `WindowsVersion/WINDOWS_SERVER_2003_R2_SP2_LANGUAGE_PACKS_64BIT_SQL_2005_SP4_EXPRESS` is returned
* is `:windows-server-2016-english-core-sql-2016-sp1-enterprise` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_CORE_SQL_2016_SP1_ENTERPRISE` is returned
* is `:windows-server-2022-english-full-sql-2019-enterprise` - `WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_SQL_2019_ENTERPRISE` is returned
* is `:windows-server-2016-portuguese-brazil-full-base` - `WindowsVersion/WINDOWS_SERVER_2016_PORTUGUESE_BRAZIL_FULL_BASE` is returned
* is `:windows-server-2019-english-full-sql-2019-express` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2019_EXPRESS` is returned
* is `:windows-server-2012-r2-rtm-japanese-64bit-sql-2016-sp1-enterprise` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_JAPANESE_64BIT_SQL_2016_SP1_ENTERPRISE` is returned
* is `:windows-server-2012-rtm-chinese-traditional-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_CHINESE_TRADITIONAL_64BIT_BASE` is returned
* is `:windows-server-2016-english-full-sql-2016-sp3-enterprise` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2016_SP3_ENTERPRISE` is returned
* is `:windows-server-2012-rtm-czech-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_CZECH_64BIT_BASE` is returned
* is `:windows-server-2022-german-full-base` - `WindowsVersion/WINDOWS_SERVER_2022_GERMAN_FULL_BASE` is returned
* is `:windows-server-1709-english-core-base` - `WindowsVersion/WINDOWS_SERVER_1709_ENGLISH_CORE_BASE` is returned
* is `:windows-server-2012-rtm-chinese-simplified-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_CHINESE_SIMPLIFIED_64BIT_BASE` is returned
* is `:windows-server-2012-rtm-english-64bit-sql-2014-sp2-express` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_ENGLISH_64BIT_SQL_2014_SP2_EXPRESS` is returned
* is `:windows-server-2016-english-core-sql-2016-sp3-express` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_CORE_SQL_2016_SP3_EXPRESS` is returned
* is `:windows-server-2022-turkish-full-base` - `WindowsVersion/WINDOWS_SERVER_2022_TURKISH_FULL_BASE` is returned
* is `:windows-server-2012-rtm-english-64bit-2014-sp3-web` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_ENGLISH_64BIT_2014_SP3_WEB` is returned
* is `:windows-server-2012-r2-rtm-english-64bit-sql-2016-sp2-web` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2016_SP2_WEB` is returned
* is `:windows-server-2022-english-full-containerslatest` - `WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_CONTAINERSLATEST` is returned
* is `:windows-server-2007-r2-sp1-language-packs-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2007_R2_SP1_LANGUAGE_PACKS_64BIT_BASE` is returned
* is `:windows-server-2012-rtm-english-64bit-sql-2012-sp4-web` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_ENGLISH_64BIT_SQL_2012_SP4_WEB` is returned
* is `:windows-server-1709-english-core-containerslatest` - `WindowsVersion/WINDOWS_SERVER_1709_ENGLISH_CORE_CONTAINERSLATEST` is returned
* is `:windows-server-2012-rtm-english-64bit-sql-2014-sp3-standard` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_ENGLISH_64BIT_SQL_2014_SP3_STANDARD` is returned
* is `:windows-server-2016-english-full-sql-2016-sp1-enterprise` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2016_SP1_ENTERPRISE` is returned
* is `:windows-server-2022-english-full-eks-optimized-1-24` - `WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_EKS_OPTIMIZED_1_24` is returned
* is `:windows-server-2019-japanese-full-sql-2019-enterprise` - `WindowsVersion/WINDOWS_SERVER_2019_JAPANESE_FULL_SQL_2019_ENTERPRISE` is returned
* is `:windows-server-2008-r2-sp1-english-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_ENGLISH_64BIT_BASE` is returned
* is `:windows-server-2016-japanese-full-sql-2016-sp2-enterprise` - `WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2016_SP2_ENTERPRISE` is returned
* is `:windows-server-2008-r2-sp1-japanese-64bit-sql-2008-r2-sp3-standard` - `WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_JAPANESE_64BIT_SQL_2008_R2_SP3_STANDARD` is returned
* is `:windows-server-2022-chinese-simplified-full-base` - `WindowsVersion/WINDOWS_SERVER_2022_CHINESE_SIMPLIFIED_FULL_BASE` is returned
* is `:windows-server-2022-english-full-sql-2019-web` - `WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_SQL_2019_WEB` is returned
* is `:windows-server-2012-r2-rtm-portuguese-portugal-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_PORTUGUESE_PORTUGAL_64BIT_BASE` is returned
* is `:windows-server-2022-english-full-eks-optimized-1-23` - `WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_EKS_OPTIMIZED_1_23` is returned
* is `:windows-server-2012-rtm-english-64bit-sql-2012-sp4-express` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_ENGLISH_64BIT_SQL_2012_SP4_EXPRESS` is returned
* is `:windows-server-2022-italian-full-base` - `WindowsVersion/WINDOWS_SERVER_2022_ITALIAN_FULL_BASE` is returned
* is `:windows-server-2022-portuguese-portugal-full-base` - `WindowsVersion/WINDOWS_SERVER_2022_PORTUGUESE_PORTUGAL_FULL_BASE` is returned
* is `:windows-server-2008-r2-sp1-japanese-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_JAPANESE_64BIT_BASE` is returned
* is `:windows-server-2016-english-deep-learning` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_DEEP_LEARNING` is returned
* is `:windows-server-2019-english-full-containerslatest` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_CONTAINERSLATEST` is returned
* is `:windows-server-2022-english-core-base` - `WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_CORE_BASE` is returned
* is `:windows-server-2022-english-full-sql-2017-standard` - `WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_SQL_2017_STANDARD` is returned
* is `:windows-server-2012-rtm-english-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_ENGLISH_64BIT_BASE` is returned
* is `:windows-server-2016-japanese-full-sql-2017-enterprise` - `WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2017_ENTERPRISE` is returned
* is `:windows-server-2019-japanese-full-base` - `WindowsVersion/WINDOWS_SERVER_2019_JAPANESE_FULL_BASE` is returned
* is `:windows-server-2019-english-core-eks-optimized-1-25` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_CORE_EKS_OPTIMIZED_1_25` is returned
* is `:windows-server-2008-r2-sp1-english-64bit-core-sql-2012-sp4-standard` - `WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_ENGLISH_64BIT_CORE_SQL_2012_SP4_STANDARD` is returned
* is `:windows-server-2019-czech-full-base` - `WindowsVersion/WINDOWS_SERVER_2019_CZECH_FULL_BASE` is returned
* is `:windows-server-2012-r2-rtm-japanese-64bit-sql-2014-sp3-standard` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_JAPANESE_64BIT_SQL_2014_SP3_STANDARD` is returned
* is `:windows-server-2016-russian-full-base` - `WindowsVersion/WINDOWS_SERVER_2016_RUSSIAN_FULL_BASE` is returned
* is `:windows-server-2019-german-full-base` - `WindowsVersion/WINDOWS_SERVER_2019_GERMAN_FULL_BASE` is returned
* is `:windows-server-2012-r2-rtm-english-64bit-sql-2014-sp3-express` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2014_SP3_EXPRESS` is returned
* is `:windows-server-2016-english-core-sql-2016-sp3-enterprise` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_CORE_SQL_2016_SP3_ENTERPRISE` is returned
* is `:windows-server-2016-english-tesla` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_TESLA` is returned
* is `:windows-server-2008-r2-sp1-english-61bit-sql-2012-rtm-sp2-enterprise` - `WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_ENGLISH_61BIT_SQL_2012_RTM_SP2_ENTERPRISE` is returned
* is `:windows-server-2019-english-full-sql-2022-enterprise` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2022_ENTERPRISE` is returned
* is `:windows-server-2016-english-core-sql-2016-sp1-web` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_CORE_SQL_2016_SP1_WEB` is returned
* is `:windows-server-2022-japanese-full-sql-2022-enterprise` - `WindowsVersion/WINDOWS_SERVER_2022_JAPANESE_FULL_SQL_2022_ENTERPRISE` is returned
* is `:windows-server-2022-english-stig-full` - `WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_STIG_FULL` is returned
* is `:windows-server-2019-english-full-eks-optimized-1-24` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_EKS_OPTIMIZED_1_24` is returned
* is `:windows-server-2022-russian-full-base` - `WindowsVersion/WINDOWS_SERVER_2022_RUSSIAN_FULL_BASE` is returned
* is `:windows-server-1809-english-core-containerslatest` - `WindowsVersion/WINDOWS_SERVER_1809_ENGLISH_CORE_CONTAINERSLATEST` is returned
* is `:windows-server-2019-english-full-sql-2016-sp2-express` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2016_SP2_EXPRESS` is returned
* is `:windows-server-2003-r2-sp2-language-packs-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2003_R2_SP2_LANGUAGE_PACKS_64BIT_BASE` is returned
* is `:windows-server-2012-r2-rtm-russian-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_RUSSIAN_64BIT_BASE` is returned
* is `:windows-server-2022-chinese-traditional-full-base` - `WindowsVersion/WINDOWS_SERVER_2022_CHINESE_TRADITIONAL_FULL_BASE` is returned
* is `:windows-server-2016-japanese-full-fql-2016-sp2-web` - `WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_FQL_2016_SP2_WEB` is returned
* is `:windows-server-2016-english-full-sql-2017-enterprise` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2017_ENTERPRISE` is returned
* is `:windows-server-2012-rtm-japanese-64bit-sql-2008-r2-sp3-standard` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_JAPANESE_64BIT_SQL_2008_R2_SP3_STANDARD` is returned
* is `:windows-server-2019-english-full-sql-2016-sp3-standard` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2016_SP3_STANDARD` is returned
* is `:windows-server-2016-english-core-sql-2016-sp1-standard` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_CORE_SQL_2016_SP1_STANDARD` is returned
* is `:windows-server-2016-english-core-sql-2016-sp3-standard` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_CORE_SQL_2016_SP3_STANDARD` is returned
* is `:windows-server-2008-sp2-english-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2008_SP2_ENGLISH_64BIT_BASE` is returned
* is `:windows-server-2019-japanese-full-sql-2017-standard` - `WindowsVersion/WINDOWS_SERVER_2019_JAPANESE_FULL_SQL_2017_STANDARD` is returned
* is `:windows-server-2022-korean-full-base` - `WindowsVersion/WINDOWS_SERVER_2022_KOREAN_FULL_BASE` is returned
* is `:windows-server-2003-r2-sp2-english-32bit-base` - `WindowsVersion/WINDOWS_SERVER_2003_R2_SP2_ENGLISH_32BIT_BASE` is returned
* is `:windows-server-2019-english-full-base` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_BASE` is returned
* is `:windows-server-2012-r2-rtm-english-64bit-sql-2014-sp2-enterprise` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2014_SP2_ENTERPRISE` is returned
* is `:windows-server-2008-r2-sp1-japanese-64bit-sql-2012-sp4-express` - `WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_JAPANESE_64BIT_SQL_2012_SP4_EXPRESS` is returned
* is `:windows-server-2016-english-full-sql-2014-sp3-standard` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2014_SP3_STANDARD` is returned
* is `:windows-server-2012-rtm-turkish-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_TURKISH_64BIT_BASE` is returned
* is `:windows-server-2022-portuguese-brazil-full-base` - `WindowsVersion/WINDOWS_SERVER_2022_PORTUGUESE_BRAZIL_FULL_BASE` is returned
* is `:windows-server-2022-japanese-full-sql-2022-web` - `WindowsVersion/WINDOWS_SERVER_2022_JAPANESE_FULL_SQL_2022_WEB` is returned
* is `:windows-server-2022-english-full-base` - `WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_BASE` is returned
* is `:windows-server-2022-english-full-sql-2017-enterprise` - `WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_SQL_2017_ENTERPRISE` is returned
* is `:windows-server-2016-english-full-sql-2016-sp1-standard` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2016_SP1_STANDARD` is returned
* is `:windows-server-2022-english-stig-core` - `WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_STIG_CORE` is returned
* is `:windows-server-2003-r2-sp2-english-64bit-sql-2005-sp4-express` - `WindowsVersion/WINDOWS_SERVER_2003_R2_SP2_ENGLISH_64BIT_SQL_2005_SP4_EXPRESS` is returned
* is `:windows-server-2012-r2-rtm-czech-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_CZECH_64BIT_BASE` is returned
* is `:windows-server-2016-english-core-containers` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_CORE_CONTAINERS` is returned
* is `:windows-server-2012-rtm-polish-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_POLISH_64BIT_BASE` is returned
* is `:windows-server-2008-r2-sp1-chinese-prc-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_CHINESE_PRC_64BIT_BASE` is returned
* is `:windows-server-2019-japanese-full-sql-2022-standard` - `WindowsVersion/WINDOWS_SERVER_2019_JAPANESE_FULL_SQL_2022_STANDARD` is returned
* is `:windows-server-2012-rtm-dutch-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_DUTCH_64BIT_BASE` is returned
* is `:windows-server-2016-english-full-sql-2019-enterprise` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2019_ENTERPRISE` is returned
* is `:windows-server-2019-english-full-sql-2022-standard` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2022_STANDARD` is returned
* is `:windows-server-2019-japanese-full-sql-2022-web` - `WindowsVersion/WINDOWS_SERVER_2019_JAPANESE_FULL_SQL_2022_WEB` is returned
* is `:windows-server-2016-english-full-hyperv` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_HYPERV` is returned
* is `:windows-server-2019-english-full-eks-optimized-1-27` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_EKS_OPTIMIZED_1_27` is returned
* is `:windows-server-2012-r2-rtm-english-64bit-sql-2014-sp3-enterprise` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2014_SP3_ENTERPRISE` is returned
* is `:windows-server-2016-spanish-full-base` - `WindowsVersion/WINDOWS_SERVER_2016_SPANISH_FULL_BASE` is returned
* is `:windows-server-2019-chinese-simplified-full-base` - `WindowsVersion/WINDOWS_SERVER_2019_CHINESE_SIMPLIFIED_FULL_BASE` is returned
* is `:windows-server-2022-japanese-full-sql-2017-standard` - `WindowsVersion/WINDOWS_SERVER_2022_JAPANESE_FULL_SQL_2017_STANDARD` is returned
* is `:windows-server-2019-hungarian-full-base` - `WindowsVersion/WINDOWS_SERVER_2019_HUNGARIAN_FULL_BASE` is returned
* is `:windows-server-2012-r2-sp1-portuguese-brazil-64bit-core` - `WindowsVersion/WINDOWS_SERVER_2012_R2_SP1_PORTUGUESE_BRAZIL_64BIT_CORE` is returned
* is `:windows-server-2016-french-full-base` - `WindowsVersion/WINDOWS_SERVER_2016_FRENCH_FULL_BASE` is returned
* is `:windows-server-2012-rtm-japanese-64bit-sql-2014-sp3-web` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_JAPANESE_64BIT_SQL_2014_SP3_WEB` is returned
* is `:windows-server-2016-korean-full-sql-2016-sp1-standard` - `WindowsVersion/WINDOWS_SERVER_2016_KOREAN_FULL_SQL_2016_SP1_STANDARD` is returned
* is `:windows-server-2012-r2-rtm-english-64bit-sql-2016-sp1-express` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2016_SP1_EXPRESS` is returned
* is `:windows-server-2019-dutch-full-base` - `WindowsVersion/WINDOWS_SERVER_2019_DUTCH_FULL_BASE` is returned
* is `:windows-server-2016-japanese-full-sql-2016-sp1-enterprise` - `WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2016_SP1_ENTERPRISE` is returned
* is `:windows-server-2016-hungarian-full-base` - `WindowsVersion/WINDOWS_SERVER_2016_HUNGARIAN_FULL_BASE` is returned
* is `:windows-server-2019-english-core-eks-optimized-1-26` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_CORE_EKS_OPTIMIZED_1_26` is returned
* is `:windows-server-2022-english-core-eks-optimized-1-28` - `WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_CORE_EKS_OPTIMIZED_1_28` is returned
* is `:windows-server-2016-english-full-base` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_BASE` is returned
* is `:windows-server-2012-rtm-japanese-64bit-sql-2012-sp4-express` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_JAPANESE_64BIT_SQL_2012_SP4_EXPRESS` is returned
* is `:windows-server-2016-english-full-sql-2016-sp2-standard` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2016_SP2_STANDARD` is returned
* is `:windows-server-2019-polish-full-base` - `WindowsVersion/WINDOWS_SERVER_2019_POLISH_FULL_BASE` is returned
* is `:windows-server-2022-japanese-full-base` - `WindowsVersion/WINDOWS_SERVER_2022_JAPANESE_FULL_BASE` is returned
* is `:windows-server-2022-english-full-sql-2017-express` - `WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_SQL_2017_EXPRESS` is returned
* is `:windows-server-2008-sp2-english-64bit-sql-2008-sp4-standard` - `WindowsVersion/WINDOWS_SERVER_2008_SP2_ENGLISH_64BIT_SQL_2008_SP4_STANDARD` is returned
* is `:windows-server-2019-english-deep-learning` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_DEEP_LEARNING` is returned
* is `:windows-server-2016-english-full-sql-2017-express` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2017_EXPRESS` is returned
* is `:windows-server-2022-polish-full-base` - `WindowsVersion/WINDOWS_SERVER_2022_POLISH_FULL_BASE` is returned
* is `:windows-server-2019-english-full-sql-2017-standard` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2017_STANDARD` is returned
* is `:windows-server-2008-r2-sp1-language-packs-64bit-sql-2008-r2-sp3-express` - `WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_LANGUAGE_PACKS_64BIT_SQL_2008_R2_SP3_EXPRESS` is returned
* is `:windows-server-2012-rtm-japanese-64bit-sql-2014-sp3-express` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_JAPANESE_64BIT_SQL_2014_SP3_EXPRESS` is returned
* is `:windows-server-2012-r2-rtm-english-64bit-sql-2014-sp2-web` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2014_SP2_WEB` is returned
* is `:windows-server-1803-english-core-base` - `WindowsVersion/WINDOWS_SERVER_1803_ENGLISH_CORE_BASE` is returned
* is `:windows-server-2012-r2-rtm-english-64bit-sql-2016-sp2-express` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2016_SP2_EXPRESS` is returned
* is `:windows-server-2022-english-full-sql-2022-standard` - `WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_SQL_2022_STANDARD` is returned
* is `:windows-server-2012-r2-rtm-polish-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_POLISH_64BIT_BASE` is returned
* is `:windows-server-2022-swedish-full-base` - `WindowsVersion/WINDOWS_SERVER_2022_SWEDISH_FULL_BASE` is returned
* is `:windows-server-2016-japanese-full-sql-2016-sp3-standard` - `WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2016_SP3_STANDARD` is returned
* is `:windows-server-2016-chinese-traditional-full-base` - `WindowsVersion/WINDOWS_SERVER_2016_CHINESE_TRADITIONAL_FULL_BASE` is returned
* is `:windows-server-2022-spanish-full-base` - `WindowsVersion/WINDOWS_SERVER_2022_SPANISH_FULL_BASE` is returned
* is `:windows-server-2022-english-full-sql-2017-web` - `WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_SQL_2017_WEB` is returned
* is `:windows-server-2019-english-core-eks-optimized-1-28` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_CORE_EKS_OPTIMIZED_1_28` is returned
* is `:windows-server-2019-japanese-full-sql-2019-web` - `WindowsVersion/WINDOWS_SERVER_2019_JAPANESE_FULL_SQL_2019_WEB` is returned
* is `:windows-server-2022-english-full-sql-2022-express` - `WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_SQL_2022_EXPRESS` is returned
* is `:windows-server-2012-r2-rtm-english-64bit-sql-2016-sp3-standard` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2016_SP3_STANDARD` is returned
* is `:windows-server-2016-english-core-sql-2016-sp2-express` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_CORE_SQL_2016_SP2_EXPRESS` is returned
* is `:windows-server-2022-english-core-eks-optimized-1-24` - `WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_CORE_EKS_OPTIMIZED_1_24` is returned
* is `:windows-server-2012-rtm-english-64bit-sql-2007-r2-sp3-web` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_ENGLISH_64BIT_SQL_2007_R2_SP3_WEB` is returned
* is `:windows-server-2019-italian-full-base` - `WindowsVersion/WINDOWS_SERVER_2019_ITALIAN_FULL_BASE` is returned
* is `:windows-server-2022-english-core-eks-optimized-1-25` - `WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_CORE_EKS_OPTIMIZED_1_25` is returned
* is `:windows-server-2019-english-full-sql-2019-standard` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2019_STANDARD` is returned
* is `:windows-server-2019-english-full-eks-optimized-1-25` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_EKS_OPTIMIZED_1_25` is returned
* is `:windows-server-2022-english-full-eks-optimized-1-26` - `WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_EKS_OPTIMIZED_1_26` is returned
* is `:windows-server-2016-english-full-ecs-optimized` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_ECS_OPTIMIZED` is returned
* is `:windows-server-2012-r2-rtm-japanese-64bit-sql-2016-sp2-enterprise` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_JAPANESE_64BIT_SQL_2016_SP2_ENTERPRISE` is returned
* is `:windows-server-2008-r2-sp1-japanese-64bit-sql-2012-sp4-standard` - `WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_JAPANESE_64BIT_SQL_2012_SP4_STANDARD` is returned
* is `:windows-server-2022-japanese-full-sql-2019-standard` - `WindowsVersion/WINDOWS_SERVER_2022_JAPANESE_FULL_SQL_2019_STANDARD` is returned
* is `:windows-server-2012-r2-rtm-english-64bit-sql-2014-sp3-web` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2014_SP3_WEB` is returned
* is `:windows-server-2016-japanese-full-sql-2017-standard` - `WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2017_STANDARD` is returned
* is `:windows-server-2016-english-full-sql-2014-sp3-enterprise` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2014_SP3_ENTERPRISE` is returned
* is `:windows-server-2019-russian-full-base` - `WindowsVersion/WINDOWS_SERVER_2019_RUSSIAN_FULL_BASE` is returned
* is `:windows-server-2012-rtm-hungarian-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_HUNGARIAN_64BIT_BASE` is returned
* is `:windows-server-2016-english-full-sql-2019-express` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2019_EXPRESS` is returned
* is `:windows-server-2019-english-core-containerslatest` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_CORE_CONTAINERSLATEST` is returned
* is `:windows-server-2008-sp2-portuguese-brazil-32bit-base` - `WindowsVersion/WINDOWS_SERVER_2008_SP2_PORTUGUESE_BRAZIL_32BIT_BASE` is returned
* is `:windows-server-2022-english-core-containerslatest` - `WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_CORE_CONTAINERSLATEST` is returned
* is `:windows-server-2019-japanese-full-sql-2022-enterprise` - `WindowsVersion/WINDOWS_SERVER_2019_JAPANESE_FULL_SQL_2022_ENTERPRISE` is returned
* is `:windows-server-2016-japanese-full-sql-2016-sp3-web` - `WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2016_SP3_WEB` is returned
* is `:windows-server-2019-english-full-sql-2016-sp3-express` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2016_SP3_EXPRESS` is returned
* is `:windows-server-2019-english-full-sql-2022-web` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2022_WEB` is returned
* is `:windows-server-2012-r2-rtm-japanese-64bit-sql-2016-sp1-web` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_JAPANESE_64BIT_SQL_2016_SP1_WEB` is returned
* is `:windows-server-2022-english-full-sql-2022-enterprise` - `WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_SQL_2022_ENTERPRISE` is returned
* is `:windows-server-2019-english-full-ecs-optimized` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_ECS_OPTIMIZED` is returned
* is `:windows-server-2019-portuguese-brazil-full-base` - `WindowsVersion/WINDOWS_SERVER_2019_PORTUGUESE_BRAZIL_FULL_BASE` is returned
* is `:windows-server-2012-r2-rtm-english-64bit-sql-2016-sp2-enterprise` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2016_SP2_ENTERPRISE` is returned
* is `:windows-server-2019-turkish-full-base` - `WindowsVersion/WINDOWS_SERVER_2019_TURKISH_FULL_BASE` is returned
* is `:windows-server-2012-r2-rtm-english-deep-learning` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_DEEP_LEARNING` is returned
* is `:windows-server-2016-english-full-sql-2017-standard` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2017_STANDARD` is returned
* is `:windows-server-2019-english-full-eks-optimized-1-28` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_EKS_OPTIMIZED_1_28` is returned
* is `:windows-server-2012-r2-rtm-chinese-traditional-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_CHINESE_TRADITIONAL_64BIT_BASE` is returned
* is `:windows-server-2022-english-full-eks-optimized-1-27` - `WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_EKS_OPTIMIZED_1_27` is returned
* is `:windows-server-2022-english-core-eks-optimized-1-27` - `WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_CORE_EKS_OPTIMIZED_1_27` is returned
* is `:windows-server-2019-english-full-eks-optimized-1-23` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_EKS_OPTIMIZED_1_23` is returned
* is `:windows-server-2012-r2-rtm-swedish-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_SWEDISH_64BIT_BASE` is returned
* is `:windows-server-2012-rtm-chinese-traditional-hong-kong-sar-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_CHINESE_TRADITIONAL_HONG_KONG_SAR_64BIT_BASE` is returned
* is `:windows-server-2012-r2-rtm-english-64bit-sql-2014-sp2-express` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2014_SP2_EXPRESS` is returned
* is `:windows-server-2019-english-full-sql-2016-sp2-enterprise` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2016_SP2_ENTERPRISE` is returned
* is `:windows-server-2016-japanese-full-sql-2019-web` - `WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2019_WEB` is returned
* is `:windows-server-2019-english-core-base` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_CORE_BASE` is returned
* is `:windows-server-2019-swedish-full-base` - `WindowsVersion/WINDOWS_SERVER_2019_SWEDISH_FULL_BASE` is returned
* is `:windows-server-2016-dutch-full-base` - `WindowsVersion/WINDOWS_SERVER_2016_DUTCH_FULL_BASE` is returned
* is `:windows-server-2012-r2-rtm-portuguese-brazil-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_PORTUGUESE_BRAZIL_64BIT_BASE` is returned
* is `:windows-server-2012-r2-rtm-english-64bit-hyperv` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_HYPERV` is returned
* is `:windows-server-2008-r2-sp1-language-packs-64bit-sql-2008-r2-sp3-standard` - `WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_LANGUAGE_PACKS_64BIT_SQL_2008_R2_SP3_STANDARD` is returned
* is `:windows-server-2016-english-core-sql-2016-sp3-web` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_CORE_SQL_2016_SP3_WEB` is returned
* is `:windows-server-2016-english-64bit-sql-2012-sp4-enterprise` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_64BIT_SQL_2012_SP4_ENTERPRISE` is returned
* is `:windows-server-2012-r2-rtm-japanese-64bit-sql-2014-sp3-express` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_JAPANESE_64BIT_SQL_2014_SP3_EXPRESS` is returned
* is `:windows-server-2012-r2-rtm-turkish-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_TURKISH_64BIT_BASE` is returned
* is `:windows-server-2016-english-core-base` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_CORE_BASE` is returned
* is `:windows-server-2019-english-core-eks-optimized-1-22` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_CORE_EKS_OPTIMIZED_1_22` is returned
* is `:windows-server-2012-r2-rtm-english-full-base` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_FULL_BASE` is returned
* is `:windows-server-2012-rtm-english-64bit-sql-2008-r2-sp3-standard` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_ENGLISH_64BIT_SQL_2008_R2_SP3_STANDARD` is returned
* is `:windows-server-2012-r2-rtm-japanese-64bit-sql-2014-sp2-express` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_JAPANESE_64BIT_SQL_2014_SP2_EXPRESS` is returned
* is `:windows-server-2019-english-full-sql-2019-web` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2019_WEB` is returned
* is `:windows-server-2022-japanese-full-sql-2019-enterprise` - `WindowsVersion/WINDOWS_SERVER_2022_JAPANESE_FULL_SQL_2019_ENTERPRISE` is returned
* is `:windows-server-2019-english-stig-full` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_STIG_FULL` is returned
* is `:windows-server-2012-sp2-portuguese-brazil-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_SP2_PORTUGUESE_BRAZIL_64BIT_BASE` is returned
* is `:windows-server-2012-rtm-japanese-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_JAPANESE_64BIT_BASE` is returned
* is `:windows-server-2012-rtm-japanese-64bit-sql-2016-sp2-express` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_JAPANESE_64BIT_SQL_2016_SP2_EXPRESS` is returned
* is `:windows-server-2012-r2-rtm-korean-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_KOREAN_64BIT_BASE` is returned
* is `:windows-server-2016-korean-full-sql-2016-sp3-standard` - `WindowsVersion/WINDOWS_SERVER_2016_KOREAN_FULL_SQL_2016_SP3_STANDARD` is returned
* is `:windows-server-2019-english-core-eks-optimized-1-24` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_CORE_EKS_OPTIMIZED_1_24` is returned
* is `:windows-server-2008-r2-sp1-english-64bit-sharepoint-2010-sp2-foundation` - `WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_ENGLISH_64BIT_SHAREPOINT_2010_SP2_FOUNDATION` is returned
* is `:windows-server-1803-english-core-containerslatest` - `WindowsVersion/WINDOWS_SERVER_1803_ENGLISH_CORE_CONTAINERSLATEST` is returned
* is `:windows-server-2022-english-full-ecs-optimized` - `WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_ECS_OPTIMIZED` is returned
* is `:windows-server-2012-r2-rtm-english-64bit-sql-2012-sp4-enterprise` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2012_SP4_ENTERPRISE` is returned
* is `:windows-server-2016-english-full-sql-2016-sp2-express` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2016_SP2_EXPRESS` is returned
* is `:windows-server-2019-spanish-full-base` - `WindowsVersion/WINDOWS_SERVER_2019_SPANISH_FULL_BASE` is returned
* is `:windows-server-2012-r2-english-stig-full` - `WindowsVersion/WINDOWS_SERVER_2012_R2_ENGLISH_STIG_FULL` is returned
* is `:windows-server-2012-r2-rtm-dutch-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_DUTCH_64BIT_BASE` is returned
* is `:windows-server-2012-r2-rtm-hungarian-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_HUNGARIAN_64BIT_BASE` is returned
* is `:windows-server-2022-japanese-full-sql-2017-web` - `WindowsVersion/WINDOWS_SERVER_2022_JAPANESE_FULL_SQL_2017_WEB` is returned
* is `:windows-server-2016-english-full-sql-2016-sp1-express` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2016_SP1_EXPRESS` is returned
* is `:windows-server-2016-english-core-sql-2016-sp1-express` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_CORE_SQL_2016_SP1_EXPRESS` is returned
* is `:windows-server-2016-japanese-full-sql-2016-sp3-express` - `WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2016_SP3_EXPRESS` is returned
* is `:windows-server-2016-english-full-sql-2019-web` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2019_WEB` is returned
* is `:windows-server-2019-english-core-eks-optimized-1-23` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_CORE_EKS_OPTIMIZED_1_23` is returned
* is `:windows-server-2019-english-full-sql-2016-sp3-web` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2016_SP3_WEB` is returned
* is `:windows-server-2016-english-stig-core` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_STIG_CORE` is returned
* is `:windows-server-2008-r2-sp1-english-64bit-sql-2008-r2-sp3-web` - `WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_ENGLISH_64BIT_SQL_2008_R2_SP3_WEB` is returned
* is `:windows-server-2016-korean-full-sql-2016-sp2-standard` - `WindowsVersion/WINDOWS_SERVER_2016_KOREAN_FULL_SQL_2016_SP2_STANDARD` is returned
* is `:windows-server-2012-r2-rtm-japanese-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_JAPANESE_64BIT_BASE` is returned
* is `:windows-server-2016-japanese-full-sql-2016-sp1-web` - `WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2016_SP1_WEB` is returned
* is `:windows-server-2019-english-full-sql-2022-express` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2022_EXPRESS` is returned
* is `:windows-server-2003-r2-sp2-english-64bit-sql-2005-sp4-standard` - `WindowsVersion/WINDOWS_SERVER_2003_R2_SP2_ENGLISH_64BIT_SQL_2005_SP4_STANDARD` is returned
* is `:windows-server-2012-r2-rtm-japanese-64bit-sql-2016-sp1-express` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_JAPANESE_64BIT_SQL_2016_SP1_EXPRESS` is returned
* is `:windows-server-2012-rtm-japanese-64bit-sql-2014-sp3-standard` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_JAPANESE_64BIT_SQL_2014_SP3_STANDARD` is returned
* is `:windows-server-2016-english-core-sql-2016-sp2-web` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_CORE_SQL_2016_SP2_WEB` is returned
* is `:windows-server-2012-rtm-japanese-64bit-sql-2012-sp4-web` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_JAPANESE_64BIT_SQL_2012_SP4_WEB` is returned
* is `:windows-server-2022-english-core-eks-optimized-1-26` - `WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_CORE_EKS_OPTIMIZED_1_26` is returned
* is `:windows-server-2012-r2-rtm-chinese-traditional-hong-kong-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_CHINESE_TRADITIONAL_HONG_KONG_64BIT_BASE` is returned
* is `:windows-server-2012-r2-rtm-english-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_BASE` is returned
* is `:windows-server-2012-rtm-spanish-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_SPANISH_64BIT_BASE` is returned
* is `:windows-server-2003-r2-sp2-language-packs-32bit-base` - `WindowsVersion/WINDOWS_SERVER_2003_R2_SP2_LANGUAGE_PACKS_32BIT_BASE` is returned
* is `:windows-server-2019-english-full-sql-2017-web` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2017_WEB` is returned
* is `:windows-server-2022-english-full-sql-2022-web` - `WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_SQL_2022_WEB` is returned
* is `:windows-server-2012-rtm-german-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_GERMAN_64BIT_BASE` is returned
* is `:windows-server-2008-r2-sp1-english-64bit-sql-2008-r2-sp3-standard` - `WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_ENGLISH_64BIT_SQL_2008_R2_SP3_STANDARD` is returned
* is `:windows-server-2016-english-stig-full` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_STIG_FULL` is returned
* is `:windows-server-2012-r2-rtm-japanese-64bit-sql-2016-sp1-standard` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_JAPANESE_64BIT_SQL_2016_SP1_STANDARD` is returned
* is `:windows-server-2012-r2-rtm-chinese-simplified-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_CHINESE_SIMPLIFIED_64BIT_BASE` is returned
* is `:windows-server-2019-french-full-base` - `WindowsVersion/WINDOWS_SERVER_2019_FRENCH_FULL_BASE` is returned
* is `:windows-server-2012-r2-rtm-spanish-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_SPANISH_64BIT_BASE` is returned
* is `:windows-server-2012-r2-english-stig-core` - `WindowsVersion/WINDOWS_SERVER_2012_R2_ENGLISH_STIG_CORE` is returned
* is `:windows-server-2012-r2-rtm-english-64bit-sql-2016-sp3-enterprise` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2016_SP3_ENTERPRISE` is returned
* is `:windows-server-2008-r2-sp1-english-64bit-sql-2012-sp4-express` - `WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_ENGLISH_64BIT_SQL_2012_SP4_EXPRESS` is returned
* is `:windows-server-2019-english-full-eks-optimized-1-22` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_EKS_OPTIMIZED_1_22` is returned
* is `:windows-server-2012-r2-rtm-english-64bit-core` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_CORE` is returned
* is `:windows-server-2012-r2-rtm-english-64bit-sql-2016-sp1-web` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2016_SP1_WEB` is returned
* is `:windows-server-2008-r2-sp1-english-64bit-sql-2012-sp4-standard` - `WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_ENGLISH_64BIT_SQL_2012_SP4_STANDARD` is returned
* is `:windows-server-2016-english-full-sql-2016-sp3-web` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2016_SP3_WEB` is returned
* is `:windows-server-2008-r2-sp1-english-64bit-sql-2012-sp4-enterprise` - `WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_ENGLISH_64BIT_SQL_2012_SP4_ENTERPRISE` is returned
* is `:windows-server-2019-english-full-sql-2019-enterprise` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2019_ENTERPRISE` is returned
* is `:windows-server-2008-r2-sp1-japanese-64bit-sql-2008-r2-sp3-express` - `WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_JAPANESE_64BIT_SQL_2008_R2_SP3_EXPRESS` is returned
* is `:windows-server-2022-english-core-eks-optimized-1-23` - `WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_CORE_EKS_OPTIMIZED_1_23` is returned
* is `:windows-server-2012-rtm-english-64bit-sql-2014-sp2-web` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_ENGLISH_64BIT_SQL_2014_SP2_WEB` is returned
* is `:windows-server-2016-japanese-full-sql-2016-sp2-express` - `WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2016_SP2_EXPRESS` is returned
* is `:windows-server-2016-english-p3` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_P3` is returned
* is `:windows-server-2012-rtm-swedish-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_SWEDISH_64BIT_BASE` is returned
* is `:windows-server-2019-japanese-full-sql-2017-enterprise` - `WindowsVersion/WINDOWS_SERVER_2019_JAPANESE_FULL_SQL_2017_ENTERPRISE` is returned
* is `:windows-server-2022-japanese-full-sql-2017-enterprise` - `WindowsVersion/WINDOWS_SERVER_2022_JAPANESE_FULL_SQL_2017_ENTERPRISE` is returned
* is `:windows-server-2016-english-core-containerslatest` - `WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_CORE_CONTAINERSLATEST` is returned
* is `:windows-server-2012-rtm-english-64bit-sql-2014-sp2-standard` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_ENGLISH_64BIT_SQL_2014_SP2_STANDARD` is returned
* is `:windows-server-2012-r2-rtm-japanese-64bit-sql-2016-sp3-enterprise` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_JAPANESE_64BIT_SQL_2016_SP3_ENTERPRISE` is returned
* is `:windows-server-2008-r2-sp1-chinese-hong-kong-sar-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_CHINESE_HONG_KONG_SAR_64BIT_BASE` is returned
* is `:windows-server-2019-korean-full-base` - `WindowsVersion/WINDOWS_SERVER_2019_KOREAN_FULL_BASE` is returned
* is `:windows-server-2012-r2-rtm-japanese-64bit-sql-2016-sp3-standard` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_JAPANESE_64BIT_SQL_2016_SP3_STANDARD` is returned
* is `:windows-server-2019-english-full-sql-2017-express` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2017_EXPRESS` is returned
* is `:windows-server-2019-english-tesla` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_TESLA` is returned
* is `:windows-server-2019-english-full-sql-2017-enterprise` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2017_ENTERPRISE` is returned
* is `:windows-server-2016-german-full-base` - `WindowsVersion/WINDOWS_SERVER_2016_GERMAN_FULL_BASE` is returned
* is `:windows-server-2012-rtm-korean-64bit-base` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_KOREAN_64BIT_BASE` is returned
* is `:windows-server-2012-r2-rtm-english-64bit-sql-2016-sp1-standard` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2016_SP1_STANDARD` is returned
* is `:windows-server-2019-english-full-eks-optimized-1-26` - `WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_EKS_OPTIMIZED_1_26` is returned
* is `:windows-server-2016-japanese-full-sql-2016-sp1-express` - `WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2016_SP1_EXPRESS` is returned
* is `:windows-server-2022-english-core-ecs-optimized` - `WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_CORE_ECS_OPTIMIZED` is returned
* is `:windows-server-2012-rtm-japanese-64bit-2012-sp4-standard` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_JAPANESE_64BIT_2012_SP4_STANDARD` is returned
* is `:windows-server-2016-korean-full-base` - `WindowsVersion/WINDOWS_SERVER_2016_KOREAN_FULL_BASE` is returned
* is `:windows-server-2012-r2-rtm-japanese-64bit-sql-2014-sp2-standard` - `WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_JAPANESE_64BIT_SQL_2014_SP2_STANDARD` is returned
* is `:windows-server-2012-rtm-japanese-64bit-sql-2014-sp2-express` - `WindowsVersion/WINDOWS_SERVER_2012_RTM_JAPANESE_64BIT_SQL_2014_SP2_EXPRESS` is returned

 If a value is not found or matches the above criteria, nil is returned."
  [config id item-key]
  (let [data (lookup-entry config id item-key)]
    (cond
      (instance? WindowsVersion data) data
      (= :windows-server-2019-english-full-hyperv data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_HYPERV
      (= :windows-server-2022-english-full-eks-optimized-1-25 data) WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_EKS_OPTIMIZED_1_25
      (= :windows-server-2016-czech-full-base data) WindowsVersion/WINDOWS_SERVER_2016_CZECH_FULL_BASE
      (= :windows-server-2016-english-full-sql-2016-sp2-web data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2016_SP2_WEB
      (= :windows-server-2019-chinese-traditional-full-base data) WindowsVersion/WINDOWS_SERVER_2019_CHINESE_TRADITIONAL_FULL_BASE
      (= :windows-server-2016-english-full-sql-2017-web data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2017_WEB
      (= :windows-server-2012-r2-rtm-english-64bit-sql-2016-sp3-express data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2016_SP3_EXPRESS
      (= :windows-server-2016-english-full-containers data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_CONTAINERS
      (= :windows-server-2019-japanese-full-sql-2017-web data) WindowsVersion/WINDOWS_SERVER_2019_JAPANESE_FULL_SQL_2017_WEB
      (= :windows-server-2019-japanese-full-sql-2019-standard data) WindowsVersion/WINDOWS_SERVER_2019_JAPANESE_FULL_SQL_2019_STANDARD
      (= :windows-server-2012-r2-rtm-german-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_GERMAN_64BIT_BASE
      (= :windows-server-2016-chinese-simplified-full-base data) WindowsVersion/WINDOWS_SERVER_2016_CHINESE_SIMPLIFIED_FULL_BASE
      (= :windows-server-2016-turkish-full-base data) WindowsVersion/WINDOWS_SERVER_2016_TURKISH_FULL_BASE
      (= :windows-server-2012-rtm-japanese-64bit-sql-2014-sp2-web data) WindowsVersion/WINDOWS_SERVER_2012_RTM_JAPANESE_64BIT_SQL_2014_SP2_WEB
      (= :windows-server-2016-japanese-full-sql-2017-web data) WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2017_WEB
      (= :windows-server-2012-rtm-japanese-64bit-sql-2014-sp2-standard data) WindowsVersion/WINDOWS_SERVER_2012_RTM_JAPANESE_64BIT_SQL_2014_SP2_STANDARD
      (= :windows-server-2016-polish-full-base data) WindowsVersion/WINDOWS_SERVER_2016_POLISH_FULL_BASE
      (= :windows-server-2016-japanese-full-sql-2016-sp2-standard data) WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2016_SP2_STANDARD
      (= :windows-server-2008-r2-sp1-korean-64bit-base data) WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_KOREAN_64BIT_BASE
      (= :windows-server-2019-english-stig-core data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_STIG_CORE
      (= :windows-server-2012-rtm-english-full-base data) WindowsVersion/WINDOWS_SERVER_2012_RTM_ENGLISH_FULL_BASE
      (= :windows-server-2019-english-full-sql-2016-sp2-web data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2016_SP2_WEB
      (= :windows-server-2022-japanese-full-sql-2019-web data) WindowsVersion/WINDOWS_SERVER_2022_JAPANESE_FULL_SQL_2019_WEB
      (= :windows-server-2012-rtm-portuguese-brazil-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_RTM_PORTUGUESE_BRAZIL_64BIT_BASE
      (= :windows-server-2016-japanese-full-sql-2016-sp1-standard data) WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2016_SP1_STANDARD
      (= :windows-server-2022-english-full-sql-2019-standard data) WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_SQL_2019_STANDARD
      (= :windows-server-2022-czech-full-base data) WindowsVersion/WINDOWS_SERVER_2022_CZECH_FULL_BASE
      (= :windows-server-2022-english-full-sql-2019-express data) WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_SQL_2019_EXPRESS
      (= :windows-server-2008-r2-sp1-portuguese-brazil-64bit-base data) WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_PORTUGUESE_BRAZIL_64BIT_BASE
      (= :windows-server-2016-japanese-full-sql-2019-enterprise data) WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2019_ENTERPRISE
      (= :windows-server-2019-english-full-sql-2016-sp2-standard data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2016_SP2_STANDARD
      (= :windows-server-2012-r2-rtm-italian-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ITALIAN_64BIT_BASE
      (= :windows-server-2016-swedish-full-base data) WindowsVersion/WINDOWS_SERVER_2016_SWEDISH_FULL_BASE
      (= :windows-server-2016-english-core-sql-2016-sp2-enterprise data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_CORE_SQL_2016_SP2_ENTERPRISE
      (= :windows-server-2022-hungarian-full-base data) WindowsVersion/WINDOWS_SERVER_2022_HUNGARIAN_FULL_BASE
      (= :windows-server-2016-english-full-sql-2019-standard data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2019_STANDARD
      (= :windows-server-2012-r2-rtm-english-64bit-sql-2016-sp2-standard data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2016_SP2_STANDARD
      (= :windows-server-2016-english-full-sql-2016-sp2-enterprise data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2016_SP2_ENTERPRISE
      (= :windows-server-2019-english-core-ecs-optimized data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_CORE_ECS_OPTIMIZED
      (= :windows-server-2008-sp2-english-64bit-sql-2008-sp4-express data) WindowsVersion/WINDOWS_SERVER_2008_SP2_ENGLISH_64BIT_SQL_2008_SP4_EXPRESS
      (= :windows-server-2003-r2-sp2-english-64bit-base data) WindowsVersion/WINDOWS_SERVER_2003_R2_SP2_ENGLISH_64BIT_BASE
      (= :windows-server-2022-japanese-full-sql-2022-standard data) WindowsVersion/WINDOWS_SERVER_2022_JAPANESE_FULL_SQL_2022_STANDARD
      (= :windows-server-2008-r2-sp1-english-64bit-sql-2012-sp4-web data) WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_ENGLISH_64BIT_SQL_2012_SP4_WEB
      (= :windows-server-2016-portuguese-portugal-full-base data) WindowsVersion/WINDOWS_SERVER_2016_PORTUGUESE_PORTUGAL_FULL_BASE
      (= :windows-server-2008-r2-sp1-japanese-64bit-sql-2008-r2-sp3-web data) WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_JAPANESE_64BIT_SQL_2008_R2_SP3_WEB
      (= :windows-server-2012-rtm-portuguese-portugal-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_RTM_PORTUGUESE_PORTUGAL_64BIT_BASE
      (= :windows-server-2012-rtm-english-64bit-sql-2014-sp3-express data) WindowsVersion/WINDOWS_SERVER_2012_RTM_ENGLISH_64BIT_SQL_2014_SP3_EXPRESS
      (= :windows-server-2012-rtm-french-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_RTM_FRENCH_64BIT_BASE
      (= :windows-server-2012-r2-rtm-japanese-64bit-sql-2016-sp2-standard data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_JAPANESE_64BIT_SQL_2016_SP2_STANDARD
      (= :windows-server-2016-english-core-sql-2016-sp2-standard data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_CORE_SQL_2016_SP2_STANDARD
      (= :windows-server-2016-english-full-sql-2016-sp1-web data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2016_SP1_WEB
      (= :windows-server-2012-r2-rtm-french-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_FRENCH_64BIT_BASE
      (= :windows-server-2019-english-full-sql-2016-sp3-enterprise data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2016_SP3_ENTERPRISE
      (= :windows-server-2012-rtm-english-64bit-sql-2008-r2-sp3-express data) WindowsVersion/WINDOWS_SERVER_2012_RTM_ENGLISH_64BIT_SQL_2008_R2_SP3_EXPRESS
      (= :windows-server-2022-dutch-full-base data) WindowsVersion/WINDOWS_SERVER_2022_DUTCH_FULL_BASE
      (= :windows-server-2022-english-full-eks-optimized-1-28 data) WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_EKS_OPTIMIZED_1_28
      (= :windows-server-2016-japanese-full-base data) WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_BASE
      (= :windows-server-1809-english-core-base data) WindowsVersion/WINDOWS_SERVER_1809_ENGLISH_CORE_BASE
      (= :windows-server-2012-rtm-russian-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_RTM_RUSSIAN_64BIT_BASE
      (= :windows-server-2012-r2-rtm-japanese-64bit-sql-2016-sp3-express data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_JAPANESE_64BIT_SQL_2016_SP3_EXPRESS
      (= :windows-server-2012-r2-rtm-english-64bit-sql-2014-sp2-standard data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2014_SP2_STANDARD
      (= :windows-server-2016-italian-full-base data) WindowsVersion/WINDOWS_SERVER_2016_ITALIAN_FULL_BASE
      (= :windows-server-2003-r2-sp2-language-packs-64bit-sql-2005-sp4-standard data) WindowsVersion/WINDOWS_SERVER_2003_R2_SP2_LANGUAGE_PACKS_64BIT_SQL_2005_SP4_STANDARD
      (= :windows-server-2012-rtm-english-64bit-sql-2012-sp4-standard data) WindowsVersion/WINDOWS_SERVER_2012_RTM_ENGLISH_64BIT_SQL_2012_SP4_STANDARD
      (= :windows-server-2022-french-full-base data) WindowsVersion/WINDOWS_SERVER_2022_FRENCH_FULL_BASE
      (= :windows-server-2016-english-full-sql-2016-sp3-express data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2016_SP3_EXPRESS
      (= :windows-server-2019-portuguese-portugal-full-base data) WindowsVersion/WINDOWS_SERVER_2019_PORTUGUESE_PORTUGAL_FULL_BASE
      (= :windows-server-2008-r2-sp1-english-64bit-core data) WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_ENGLISH_64BIT_CORE
      (= :windows-server-2012-rtm-italian-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_RTM_ITALIAN_64BIT_BASE
      (= :windows-server-2008-sp2-english-32bit-base data) WindowsVersion/WINDOWS_SERVER_2008_SP2_ENGLISH_32BIT_BASE
      (= :windows-server-2012-r2-rtm-english-64bit-sql-2016-sp3-web data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2016_SP3_WEB
      (= :windows-server-2012-rtm-japanese-64bit-sql-2008-r2-sp3-express data) WindowsVersion/WINDOWS_SERVER_2012_RTM_JAPANESE_64BIT_SQL_2008_R2_SP3_EXPRESS
      (= :windows-server-2016-japanese-full-sql-2016-sp3-enterprise data) WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2016_SP3_ENTERPRISE
      (= :windows-server-2016-english-full-sql-2016-sp3-standard data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2016_SP3_STANDARD
      (= :windows-server-2012-r2-rtm-japanese-64bit-sql-2016-sp2-web data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_JAPANESE_64BIT_SQL_2016_SP2_WEB
      (= :windows-server-2012-r2-rtm-english-p3 data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_P3
      (= :windows-server-2008-r2-sp1-english-64bit-sql-2008-r2-sp3-express data) WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_ENGLISH_64BIT_SQL_2008_R2_SP3_EXPRESS
      (= :windows-server-2012-r2-rtm-japanese-64bit-sql-2016-sp3-web data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_JAPANESE_64BIT_SQL_2016_SP3_WEB
      (= :windows-server-2019-english-core-eks-optimized-1-27 data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_CORE_EKS_OPTIMIZED_1_27
      (= :windows-server-2012-r2-rtm-english-64bit-sql-2016-sp1-enterprise data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2016_SP1_ENTERPRISE
      (= :windows-server-2012-r2-rtm-english-64bit-sql-2014-sp3-standard data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2014_SP3_STANDARD
      (= :windows-server-2016-japanese-full-sql-2019-standard data) WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2019_STANDARD
      (= :windows-server-2003-r2-sp2-language-packs-64bit-sql-2005-sp4-express data) WindowsVersion/WINDOWS_SERVER_2003_R2_SP2_LANGUAGE_PACKS_64BIT_SQL_2005_SP4_EXPRESS
      (= :windows-server-2016-english-core-sql-2016-sp1-enterprise data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_CORE_SQL_2016_SP1_ENTERPRISE
      (= :windows-server-2022-english-full-sql-2019-enterprise data) WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_SQL_2019_ENTERPRISE
      (= :windows-server-2016-portuguese-brazil-full-base data) WindowsVersion/WINDOWS_SERVER_2016_PORTUGUESE_BRAZIL_FULL_BASE
      (= :windows-server-2019-english-full-sql-2019-express data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2019_EXPRESS
      (= :windows-server-2012-r2-rtm-japanese-64bit-sql-2016-sp1-enterprise data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_JAPANESE_64BIT_SQL_2016_SP1_ENTERPRISE
      (= :windows-server-2012-rtm-chinese-traditional-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_RTM_CHINESE_TRADITIONAL_64BIT_BASE
      (= :windows-server-2016-english-full-sql-2016-sp3-enterprise data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2016_SP3_ENTERPRISE
      (= :windows-server-2012-rtm-czech-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_RTM_CZECH_64BIT_BASE
      (= :windows-server-2022-german-full-base data) WindowsVersion/WINDOWS_SERVER_2022_GERMAN_FULL_BASE
      (= :windows-server-1709-english-core-base data) WindowsVersion/WINDOWS_SERVER_1709_ENGLISH_CORE_BASE
      (= :windows-server-2012-rtm-chinese-simplified-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_RTM_CHINESE_SIMPLIFIED_64BIT_BASE
      (= :windows-server-2012-rtm-english-64bit-sql-2014-sp2-express data) WindowsVersion/WINDOWS_SERVER_2012_RTM_ENGLISH_64BIT_SQL_2014_SP2_EXPRESS
      (= :windows-server-2016-english-core-sql-2016-sp3-express data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_CORE_SQL_2016_SP3_EXPRESS
      (= :windows-server-2022-turkish-full-base data) WindowsVersion/WINDOWS_SERVER_2022_TURKISH_FULL_BASE
      (= :windows-server-2012-rtm-english-64bit-2014-sp3-web data) WindowsVersion/WINDOWS_SERVER_2012_RTM_ENGLISH_64BIT_2014_SP3_WEB
      (= :windows-server-2012-r2-rtm-english-64bit-sql-2016-sp2-web data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2016_SP2_WEB
      (= :windows-server-2022-english-full-containerslatest data) WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_CONTAINERSLATEST
      (= :windows-server-2007-r2-sp1-language-packs-64bit-base data) WindowsVersion/WINDOWS_SERVER_2007_R2_SP1_LANGUAGE_PACKS_64BIT_BASE
      (= :windows-server-2012-rtm-english-64bit-sql-2012-sp4-web data) WindowsVersion/WINDOWS_SERVER_2012_RTM_ENGLISH_64BIT_SQL_2012_SP4_WEB
      (= :windows-server-1709-english-core-containerslatest data) WindowsVersion/WINDOWS_SERVER_1709_ENGLISH_CORE_CONTAINERSLATEST
      (= :windows-server-2012-rtm-english-64bit-sql-2014-sp3-standard data) WindowsVersion/WINDOWS_SERVER_2012_RTM_ENGLISH_64BIT_SQL_2014_SP3_STANDARD
      (= :windows-server-2016-english-full-sql-2016-sp1-enterprise data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2016_SP1_ENTERPRISE
      (= :windows-server-2022-english-full-eks-optimized-1-24 data) WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_EKS_OPTIMIZED_1_24
      (= :windows-server-2019-japanese-full-sql-2019-enterprise data) WindowsVersion/WINDOWS_SERVER_2019_JAPANESE_FULL_SQL_2019_ENTERPRISE
      (= :windows-server-2008-r2-sp1-english-64bit-base data) WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_ENGLISH_64BIT_BASE
      (= :windows-server-2016-japanese-full-sql-2016-sp2-enterprise data) WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2016_SP2_ENTERPRISE
      (= :windows-server-2008-r2-sp1-japanese-64bit-sql-2008-r2-sp3-standard data) WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_JAPANESE_64BIT_SQL_2008_R2_SP3_STANDARD
      (= :windows-server-2022-chinese-simplified-full-base data) WindowsVersion/WINDOWS_SERVER_2022_CHINESE_SIMPLIFIED_FULL_BASE
      (= :windows-server-2022-english-full-sql-2019-web data) WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_SQL_2019_WEB
      (= :windows-server-2012-r2-rtm-portuguese-portugal-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_PORTUGUESE_PORTUGAL_64BIT_BASE
      (= :windows-server-2022-english-full-eks-optimized-1-23 data) WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_EKS_OPTIMIZED_1_23
      (= :windows-server-2012-rtm-english-64bit-sql-2012-sp4-express data) WindowsVersion/WINDOWS_SERVER_2012_RTM_ENGLISH_64BIT_SQL_2012_SP4_EXPRESS
      (= :windows-server-2022-italian-full-base data) WindowsVersion/WINDOWS_SERVER_2022_ITALIAN_FULL_BASE
      (= :windows-server-2022-portuguese-portugal-full-base data) WindowsVersion/WINDOWS_SERVER_2022_PORTUGUESE_PORTUGAL_FULL_BASE
      (= :windows-server-2008-r2-sp1-japanese-64bit-base data) WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_JAPANESE_64BIT_BASE
      (= :windows-server-2016-english-deep-learning data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_DEEP_LEARNING
      (= :windows-server-2019-english-full-containerslatest data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_CONTAINERSLATEST
      (= :windows-server-2022-english-core-base data) WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_CORE_BASE
      (= :windows-server-2022-english-full-sql-2017-standard data) WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_SQL_2017_STANDARD
      (= :windows-server-2012-rtm-english-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_RTM_ENGLISH_64BIT_BASE
      (= :windows-server-2016-japanese-full-sql-2017-enterprise data) WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2017_ENTERPRISE
      (= :windows-server-2019-japanese-full-base data) WindowsVersion/WINDOWS_SERVER_2019_JAPANESE_FULL_BASE
      (= :windows-server-2019-english-core-eks-optimized-1-25 data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_CORE_EKS_OPTIMIZED_1_25
      (= :windows-server-2008-r2-sp1-english-64bit-core-sql-2012-sp4-standard data) WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_ENGLISH_64BIT_CORE_SQL_2012_SP4_STANDARD
      (= :windows-server-2019-czech-full-base data) WindowsVersion/WINDOWS_SERVER_2019_CZECH_FULL_BASE
      (= :windows-server-2012-r2-rtm-japanese-64bit-sql-2014-sp3-standard data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_JAPANESE_64BIT_SQL_2014_SP3_STANDARD
      (= :windows-server-2016-russian-full-base data) WindowsVersion/WINDOWS_SERVER_2016_RUSSIAN_FULL_BASE
      (= :windows-server-2019-german-full-base data) WindowsVersion/WINDOWS_SERVER_2019_GERMAN_FULL_BASE
      (= :windows-server-2012-r2-rtm-english-64bit-sql-2014-sp3-express data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2014_SP3_EXPRESS
      (= :windows-server-2016-english-core-sql-2016-sp3-enterprise data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_CORE_SQL_2016_SP3_ENTERPRISE
      (= :windows-server-2016-english-tesla data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_TESLA
      (= :windows-server-2008-r2-sp1-english-61bit-sql-2012-rtm-sp2-enterprise data) WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_ENGLISH_61BIT_SQL_2012_RTM_SP2_ENTERPRISE
      (= :windows-server-2019-english-full-sql-2022-enterprise data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2022_ENTERPRISE
      (= :windows-server-2016-english-core-sql-2016-sp1-web data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_CORE_SQL_2016_SP1_WEB
      (= :windows-server-2022-japanese-full-sql-2022-enterprise data) WindowsVersion/WINDOWS_SERVER_2022_JAPANESE_FULL_SQL_2022_ENTERPRISE
      (= :windows-server-2022-english-stig-full data) WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_STIG_FULL
      (= :windows-server-2019-english-full-eks-optimized-1-24 data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_EKS_OPTIMIZED_1_24
      (= :windows-server-2022-russian-full-base data) WindowsVersion/WINDOWS_SERVER_2022_RUSSIAN_FULL_BASE
      (= :windows-server-1809-english-core-containerslatest data) WindowsVersion/WINDOWS_SERVER_1809_ENGLISH_CORE_CONTAINERSLATEST
      (= :windows-server-2019-english-full-sql-2016-sp2-express data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2016_SP2_EXPRESS
      (= :windows-server-2003-r2-sp2-language-packs-64bit-base data) WindowsVersion/WINDOWS_SERVER_2003_R2_SP2_LANGUAGE_PACKS_64BIT_BASE
      (= :windows-server-2012-r2-rtm-russian-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_RUSSIAN_64BIT_BASE
      (= :windows-server-2022-chinese-traditional-full-base data) WindowsVersion/WINDOWS_SERVER_2022_CHINESE_TRADITIONAL_FULL_BASE
      (= :windows-server-2016-japanese-full-fql-2016-sp2-web data) WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_FQL_2016_SP2_WEB
      (= :windows-server-2016-english-full-sql-2017-enterprise data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2017_ENTERPRISE
      (= :windows-server-2012-rtm-japanese-64bit-sql-2008-r2-sp3-standard data) WindowsVersion/WINDOWS_SERVER_2012_RTM_JAPANESE_64BIT_SQL_2008_R2_SP3_STANDARD
      (= :windows-server-2019-english-full-sql-2016-sp3-standard data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2016_SP3_STANDARD
      (= :windows-server-2016-english-core-sql-2016-sp1-standard data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_CORE_SQL_2016_SP1_STANDARD
      (= :windows-server-2016-english-core-sql-2016-sp3-standard data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_CORE_SQL_2016_SP3_STANDARD
      (= :windows-server-2008-sp2-english-64bit-base data) WindowsVersion/WINDOWS_SERVER_2008_SP2_ENGLISH_64BIT_BASE
      (= :windows-server-2019-japanese-full-sql-2017-standard data) WindowsVersion/WINDOWS_SERVER_2019_JAPANESE_FULL_SQL_2017_STANDARD
      (= :windows-server-2022-korean-full-base data) WindowsVersion/WINDOWS_SERVER_2022_KOREAN_FULL_BASE
      (= :windows-server-2003-r2-sp2-english-32bit-base data) WindowsVersion/WINDOWS_SERVER_2003_R2_SP2_ENGLISH_32BIT_BASE
      (= :windows-server-2019-english-full-base data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_BASE
      (= :windows-server-2012-r2-rtm-english-64bit-sql-2014-sp2-enterprise data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2014_SP2_ENTERPRISE
      (= :windows-server-2008-r2-sp1-japanese-64bit-sql-2012-sp4-express data) WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_JAPANESE_64BIT_SQL_2012_SP4_EXPRESS
      (= :windows-server-2016-english-full-sql-2014-sp3-standard data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2014_SP3_STANDARD
      (= :windows-server-2012-rtm-turkish-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_RTM_TURKISH_64BIT_BASE
      (= :windows-server-2022-portuguese-brazil-full-base data) WindowsVersion/WINDOWS_SERVER_2022_PORTUGUESE_BRAZIL_FULL_BASE
      (= :windows-server-2022-japanese-full-sql-2022-web data) WindowsVersion/WINDOWS_SERVER_2022_JAPANESE_FULL_SQL_2022_WEB
      (= :windows-server-2022-english-full-base data) WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_BASE
      (= :windows-server-2022-english-full-sql-2017-enterprise data) WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_SQL_2017_ENTERPRISE
      (= :windows-server-2016-english-full-sql-2016-sp1-standard data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2016_SP1_STANDARD
      (= :windows-server-2022-english-stig-core data) WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_STIG_CORE
      (= :windows-server-2003-r2-sp2-english-64bit-sql-2005-sp4-express data) WindowsVersion/WINDOWS_SERVER_2003_R2_SP2_ENGLISH_64BIT_SQL_2005_SP4_EXPRESS
      (= :windows-server-2012-r2-rtm-czech-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_CZECH_64BIT_BASE
      (= :windows-server-2016-english-core-containers data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_CORE_CONTAINERS
      (= :windows-server-2012-rtm-polish-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_RTM_POLISH_64BIT_BASE
      (= :windows-server-2008-r2-sp1-chinese-prc-64bit-base data) WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_CHINESE_PRC_64BIT_BASE
      (= :windows-server-2019-japanese-full-sql-2022-standard data) WindowsVersion/WINDOWS_SERVER_2019_JAPANESE_FULL_SQL_2022_STANDARD
      (= :windows-server-2012-rtm-dutch-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_RTM_DUTCH_64BIT_BASE
      (= :windows-server-2016-english-full-sql-2019-enterprise data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2019_ENTERPRISE
      (= :windows-server-2019-english-full-sql-2022-standard data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2022_STANDARD
      (= :windows-server-2019-japanese-full-sql-2022-web data) WindowsVersion/WINDOWS_SERVER_2019_JAPANESE_FULL_SQL_2022_WEB
      (= :windows-server-2016-english-full-hyperv data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_HYPERV
      (= :windows-server-2019-english-full-eks-optimized-1-27 data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_EKS_OPTIMIZED_1_27
      (= :windows-server-2012-r2-rtm-english-64bit-sql-2014-sp3-enterprise data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2014_SP3_ENTERPRISE
      (= :windows-server-2016-spanish-full-base data) WindowsVersion/WINDOWS_SERVER_2016_SPANISH_FULL_BASE
      (= :windows-server-2019-chinese-simplified-full-base data) WindowsVersion/WINDOWS_SERVER_2019_CHINESE_SIMPLIFIED_FULL_BASE
      (= :windows-server-2022-japanese-full-sql-2017-standard data) WindowsVersion/WINDOWS_SERVER_2022_JAPANESE_FULL_SQL_2017_STANDARD
      (= :windows-server-2019-hungarian-full-base data) WindowsVersion/WINDOWS_SERVER_2019_HUNGARIAN_FULL_BASE
      (= :windows-server-2012-r2-sp1-portuguese-brazil-64bit-core data) WindowsVersion/WINDOWS_SERVER_2012_R2_SP1_PORTUGUESE_BRAZIL_64BIT_CORE
      (= :windows-server-2016-french-full-base data) WindowsVersion/WINDOWS_SERVER_2016_FRENCH_FULL_BASE
      (= :windows-server-2012-rtm-japanese-64bit-sql-2014-sp3-web data) WindowsVersion/WINDOWS_SERVER_2012_RTM_JAPANESE_64BIT_SQL_2014_SP3_WEB
      (= :windows-server-2016-korean-full-sql-2016-sp1-standard data) WindowsVersion/WINDOWS_SERVER_2016_KOREAN_FULL_SQL_2016_SP1_STANDARD
      (= :windows-server-2012-r2-rtm-english-64bit-sql-2016-sp1-express data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2016_SP1_EXPRESS
      (= :windows-server-2019-dutch-full-base data) WindowsVersion/WINDOWS_SERVER_2019_DUTCH_FULL_BASE
      (= :windows-server-2016-japanese-full-sql-2016-sp1-enterprise data) WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2016_SP1_ENTERPRISE
      (= :windows-server-2016-hungarian-full-base data) WindowsVersion/WINDOWS_SERVER_2016_HUNGARIAN_FULL_BASE
      (= :windows-server-2019-english-core-eks-optimized-1-26 data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_CORE_EKS_OPTIMIZED_1_26
      (= :windows-server-2022-english-core-eks-optimized-1-28 data) WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_CORE_EKS_OPTIMIZED_1_28
      (= :windows-server-2016-english-full-base data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_BASE
      (= :windows-server-2012-rtm-japanese-64bit-sql-2012-sp4-express data) WindowsVersion/WINDOWS_SERVER_2012_RTM_JAPANESE_64BIT_SQL_2012_SP4_EXPRESS
      (= :windows-server-2016-english-full-sql-2016-sp2-standard data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2016_SP2_STANDARD
      (= :windows-server-2019-polish-full-base data) WindowsVersion/WINDOWS_SERVER_2019_POLISH_FULL_BASE
      (= :windows-server-2022-japanese-full-base data) WindowsVersion/WINDOWS_SERVER_2022_JAPANESE_FULL_BASE
      (= :windows-server-2022-english-full-sql-2017-express data) WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_SQL_2017_EXPRESS
      (= :windows-server-2008-sp2-english-64bit-sql-2008-sp4-standard data) WindowsVersion/WINDOWS_SERVER_2008_SP2_ENGLISH_64BIT_SQL_2008_SP4_STANDARD
      (= :windows-server-2019-english-deep-learning data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_DEEP_LEARNING
      (= :windows-server-2016-english-full-sql-2017-express data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2017_EXPRESS
      (= :windows-server-2022-polish-full-base data) WindowsVersion/WINDOWS_SERVER_2022_POLISH_FULL_BASE
      (= :windows-server-2019-english-full-sql-2017-standard data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2017_STANDARD
      (= :windows-server-2008-r2-sp1-language-packs-64bit-sql-2008-r2-sp3-express data) WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_LANGUAGE_PACKS_64BIT_SQL_2008_R2_SP3_EXPRESS
      (= :windows-server-2012-rtm-japanese-64bit-sql-2014-sp3-express data) WindowsVersion/WINDOWS_SERVER_2012_RTM_JAPANESE_64BIT_SQL_2014_SP3_EXPRESS
      (= :windows-server-2012-r2-rtm-english-64bit-sql-2014-sp2-web data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2014_SP2_WEB
      (= :windows-server-1803-english-core-base data) WindowsVersion/WINDOWS_SERVER_1803_ENGLISH_CORE_BASE
      (= :windows-server-2012-r2-rtm-english-64bit-sql-2016-sp2-express data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2016_SP2_EXPRESS
      (= :windows-server-2022-english-full-sql-2022-standard data) WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_SQL_2022_STANDARD
      (= :windows-server-2012-r2-rtm-polish-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_POLISH_64BIT_BASE
      (= :windows-server-2022-swedish-full-base data) WindowsVersion/WINDOWS_SERVER_2022_SWEDISH_FULL_BASE
      (= :windows-server-2016-japanese-full-sql-2016-sp3-standard data) WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2016_SP3_STANDARD
      (= :windows-server-2016-chinese-traditional-full-base data) WindowsVersion/WINDOWS_SERVER_2016_CHINESE_TRADITIONAL_FULL_BASE
      (= :windows-server-2022-spanish-full-base data) WindowsVersion/WINDOWS_SERVER_2022_SPANISH_FULL_BASE
      (= :windows-server-2022-english-full-sql-2017-web data) WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_SQL_2017_WEB
      (= :windows-server-2019-english-core-eks-optimized-1-28 data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_CORE_EKS_OPTIMIZED_1_28
      (= :windows-server-2019-japanese-full-sql-2019-web data) WindowsVersion/WINDOWS_SERVER_2019_JAPANESE_FULL_SQL_2019_WEB
      (= :windows-server-2022-english-full-sql-2022-express data) WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_SQL_2022_EXPRESS
      (= :windows-server-2012-r2-rtm-english-64bit-sql-2016-sp3-standard data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2016_SP3_STANDARD
      (= :windows-server-2016-english-core-sql-2016-sp2-express data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_CORE_SQL_2016_SP2_EXPRESS
      (= :windows-server-2022-english-core-eks-optimized-1-24 data) WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_CORE_EKS_OPTIMIZED_1_24
      (= :windows-server-2012-rtm-english-64bit-sql-2007-r2-sp3-web data) WindowsVersion/WINDOWS_SERVER_2012_RTM_ENGLISH_64BIT_SQL_2007_R2_SP3_WEB
      (= :windows-server-2019-italian-full-base data) WindowsVersion/WINDOWS_SERVER_2019_ITALIAN_FULL_BASE
      (= :windows-server-2022-english-core-eks-optimized-1-25 data) WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_CORE_EKS_OPTIMIZED_1_25
      (= :windows-server-2019-english-full-sql-2019-standard data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2019_STANDARD
      (= :windows-server-2019-english-full-eks-optimized-1-25 data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_EKS_OPTIMIZED_1_25
      (= :windows-server-2022-english-full-eks-optimized-1-26 data) WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_EKS_OPTIMIZED_1_26
      (= :windows-server-2016-english-full-ecs-optimized data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_ECS_OPTIMIZED
      (= :windows-server-2012-r2-rtm-japanese-64bit-sql-2016-sp2-enterprise data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_JAPANESE_64BIT_SQL_2016_SP2_ENTERPRISE
      (= :windows-server-2008-r2-sp1-japanese-64bit-sql-2012-sp4-standard data) WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_JAPANESE_64BIT_SQL_2012_SP4_STANDARD
      (= :windows-server-2022-japanese-full-sql-2019-standard data) WindowsVersion/WINDOWS_SERVER_2022_JAPANESE_FULL_SQL_2019_STANDARD
      (= :windows-server-2012-r2-rtm-english-64bit-sql-2014-sp3-web data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2014_SP3_WEB
      (= :windows-server-2016-japanese-full-sql-2017-standard data) WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2017_STANDARD
      (= :windows-server-2016-english-full-sql-2014-sp3-enterprise data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2014_SP3_ENTERPRISE
      (= :windows-server-2019-russian-full-base data) WindowsVersion/WINDOWS_SERVER_2019_RUSSIAN_FULL_BASE
      (= :windows-server-2012-rtm-hungarian-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_RTM_HUNGARIAN_64BIT_BASE
      (= :windows-server-2016-english-full-sql-2019-express data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2019_EXPRESS
      (= :windows-server-2019-english-core-containerslatest data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_CORE_CONTAINERSLATEST
      (= :windows-server-2008-sp2-portuguese-brazil-32bit-base data) WindowsVersion/WINDOWS_SERVER_2008_SP2_PORTUGUESE_BRAZIL_32BIT_BASE
      (= :windows-server-2022-english-core-containerslatest data) WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_CORE_CONTAINERSLATEST
      (= :windows-server-2019-japanese-full-sql-2022-enterprise data) WindowsVersion/WINDOWS_SERVER_2019_JAPANESE_FULL_SQL_2022_ENTERPRISE
      (= :windows-server-2016-japanese-full-sql-2016-sp3-web data) WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2016_SP3_WEB
      (= :windows-server-2019-english-full-sql-2016-sp3-express data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2016_SP3_EXPRESS
      (= :windows-server-2019-english-full-sql-2022-web data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2022_WEB
      (= :windows-server-2012-r2-rtm-japanese-64bit-sql-2016-sp1-web data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_JAPANESE_64BIT_SQL_2016_SP1_WEB
      (= :windows-server-2022-english-full-sql-2022-enterprise data) WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_SQL_2022_ENTERPRISE
      (= :windows-server-2019-english-full-ecs-optimized data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_ECS_OPTIMIZED
      (= :windows-server-2019-portuguese-brazil-full-base data) WindowsVersion/WINDOWS_SERVER_2019_PORTUGUESE_BRAZIL_FULL_BASE
      (= :windows-server-2012-r2-rtm-english-64bit-sql-2016-sp2-enterprise data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2016_SP2_ENTERPRISE
      (= :windows-server-2019-turkish-full-base data) WindowsVersion/WINDOWS_SERVER_2019_TURKISH_FULL_BASE
      (= :windows-server-2012-r2-rtm-english-deep-learning data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_DEEP_LEARNING
      (= :windows-server-2016-english-full-sql-2017-standard data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2017_STANDARD
      (= :windows-server-2019-english-full-eks-optimized-1-28 data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_EKS_OPTIMIZED_1_28
      (= :windows-server-2012-r2-rtm-chinese-traditional-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_CHINESE_TRADITIONAL_64BIT_BASE
      (= :windows-server-2022-english-full-eks-optimized-1-27 data) WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_EKS_OPTIMIZED_1_27
      (= :windows-server-2022-english-core-eks-optimized-1-27 data) WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_CORE_EKS_OPTIMIZED_1_27
      (= :windows-server-2019-english-full-eks-optimized-1-23 data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_EKS_OPTIMIZED_1_23
      (= :windows-server-2012-r2-rtm-swedish-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_SWEDISH_64BIT_BASE
      (= :windows-server-2012-rtm-chinese-traditional-hong-kong-sar-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_RTM_CHINESE_TRADITIONAL_HONG_KONG_SAR_64BIT_BASE
      (= :windows-server-2012-r2-rtm-english-64bit-sql-2014-sp2-express data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2014_SP2_EXPRESS
      (= :windows-server-2019-english-full-sql-2016-sp2-enterprise data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2016_SP2_ENTERPRISE
      (= :windows-server-2016-japanese-full-sql-2019-web data) WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2019_WEB
      (= :windows-server-2019-english-core-base data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_CORE_BASE
      (= :windows-server-2019-swedish-full-base data) WindowsVersion/WINDOWS_SERVER_2019_SWEDISH_FULL_BASE
      (= :windows-server-2016-dutch-full-base data) WindowsVersion/WINDOWS_SERVER_2016_DUTCH_FULL_BASE
      (= :windows-server-2012-r2-rtm-portuguese-brazil-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_PORTUGUESE_BRAZIL_64BIT_BASE
      (= :windows-server-2012-r2-rtm-english-64bit-hyperv data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_HYPERV
      (= :windows-server-2008-r2-sp1-language-packs-64bit-sql-2008-r2-sp3-standard data) WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_LANGUAGE_PACKS_64BIT_SQL_2008_R2_SP3_STANDARD
      (= :windows-server-2016-english-core-sql-2016-sp3-web data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_CORE_SQL_2016_SP3_WEB
      (= :windows-server-2016-english-64bit-sql-2012-sp4-enterprise data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_64BIT_SQL_2012_SP4_ENTERPRISE
      (= :windows-server-2012-r2-rtm-japanese-64bit-sql-2014-sp3-express data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_JAPANESE_64BIT_SQL_2014_SP3_EXPRESS
      (= :windows-server-2012-r2-rtm-turkish-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_TURKISH_64BIT_BASE
      (= :windows-server-2016-english-core-base data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_CORE_BASE
      (= :windows-server-2019-english-core-eks-optimized-1-22 data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_CORE_EKS_OPTIMIZED_1_22
      (= :windows-server-2012-r2-rtm-english-full-base data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_FULL_BASE
      (= :windows-server-2012-rtm-english-64bit-sql-2008-r2-sp3-standard data) WindowsVersion/WINDOWS_SERVER_2012_RTM_ENGLISH_64BIT_SQL_2008_R2_SP3_STANDARD
      (= :windows-server-2012-r2-rtm-japanese-64bit-sql-2014-sp2-express data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_JAPANESE_64BIT_SQL_2014_SP2_EXPRESS
      (= :windows-server-2019-english-full-sql-2019-web data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2019_WEB
      (= :windows-server-2022-japanese-full-sql-2019-enterprise data) WindowsVersion/WINDOWS_SERVER_2022_JAPANESE_FULL_SQL_2019_ENTERPRISE
      (= :windows-server-2019-english-stig-full data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_STIG_FULL
      (= :windows-server-2012-sp2-portuguese-brazil-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_SP2_PORTUGUESE_BRAZIL_64BIT_BASE
      (= :windows-server-2012-rtm-japanese-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_RTM_JAPANESE_64BIT_BASE
      (= :windows-server-2012-rtm-japanese-64bit-sql-2016-sp2-express data) WindowsVersion/WINDOWS_SERVER_2012_RTM_JAPANESE_64BIT_SQL_2016_SP2_EXPRESS
      (= :windows-server-2012-r2-rtm-korean-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_KOREAN_64BIT_BASE
      (= :windows-server-2016-korean-full-sql-2016-sp3-standard data) WindowsVersion/WINDOWS_SERVER_2016_KOREAN_FULL_SQL_2016_SP3_STANDARD
      (= :windows-server-2019-english-core-eks-optimized-1-24 data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_CORE_EKS_OPTIMIZED_1_24
      (= :windows-server-2008-r2-sp1-english-64bit-sharepoint-2010-sp2-foundation data) WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_ENGLISH_64BIT_SHAREPOINT_2010_SP2_FOUNDATION
      (= :windows-server-1803-english-core-containerslatest data) WindowsVersion/WINDOWS_SERVER_1803_ENGLISH_CORE_CONTAINERSLATEST
      (= :windows-server-2022-english-full-ecs-optimized data) WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_ECS_OPTIMIZED
      (= :windows-server-2012-r2-rtm-english-64bit-sql-2012-sp4-enterprise data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2012_SP4_ENTERPRISE
      (= :windows-server-2016-english-full-sql-2016-sp2-express data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2016_SP2_EXPRESS
      (= :windows-server-2019-spanish-full-base data) WindowsVersion/WINDOWS_SERVER_2019_SPANISH_FULL_BASE
      (= :windows-server-2012-r2-english-stig-full data) WindowsVersion/WINDOWS_SERVER_2012_R2_ENGLISH_STIG_FULL
      (= :windows-server-2012-r2-rtm-dutch-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_DUTCH_64BIT_BASE
      (= :windows-server-2012-r2-rtm-hungarian-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_HUNGARIAN_64BIT_BASE
      (= :windows-server-2022-japanese-full-sql-2017-web data) WindowsVersion/WINDOWS_SERVER_2022_JAPANESE_FULL_SQL_2017_WEB
      (= :windows-server-2016-english-full-sql-2016-sp1-express data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2016_SP1_EXPRESS
      (= :windows-server-2016-english-core-sql-2016-sp1-express data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_CORE_SQL_2016_SP1_EXPRESS
      (= :windows-server-2016-japanese-full-sql-2016-sp3-express data) WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2016_SP3_EXPRESS
      (= :windows-server-2016-english-full-sql-2019-web data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2019_WEB
      (= :windows-server-2019-english-core-eks-optimized-1-23 data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_CORE_EKS_OPTIMIZED_1_23
      (= :windows-server-2019-english-full-sql-2016-sp3-web data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2016_SP3_WEB
      (= :windows-server-2016-english-stig-core data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_STIG_CORE
      (= :windows-server-2008-r2-sp1-english-64bit-sql-2008-r2-sp3-web data) WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_ENGLISH_64BIT_SQL_2008_R2_SP3_WEB
      (= :windows-server-2016-korean-full-sql-2016-sp2-standard data) WindowsVersion/WINDOWS_SERVER_2016_KOREAN_FULL_SQL_2016_SP2_STANDARD
      (= :windows-server-2012-r2-rtm-japanese-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_JAPANESE_64BIT_BASE
      (= :windows-server-2016-japanese-full-sql-2016-sp1-web data) WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2016_SP1_WEB
      (= :windows-server-2019-english-full-sql-2022-express data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2022_EXPRESS
      (= :windows-server-2003-r2-sp2-english-64bit-sql-2005-sp4-standard data) WindowsVersion/WINDOWS_SERVER_2003_R2_SP2_ENGLISH_64BIT_SQL_2005_SP4_STANDARD
      (= :windows-server-2012-r2-rtm-japanese-64bit-sql-2016-sp1-express data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_JAPANESE_64BIT_SQL_2016_SP1_EXPRESS
      (= :windows-server-2012-rtm-japanese-64bit-sql-2014-sp3-standard data) WindowsVersion/WINDOWS_SERVER_2012_RTM_JAPANESE_64BIT_SQL_2014_SP3_STANDARD
      (= :windows-server-2016-english-core-sql-2016-sp2-web data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_CORE_SQL_2016_SP2_WEB
      (= :windows-server-2012-rtm-japanese-64bit-sql-2012-sp4-web data) WindowsVersion/WINDOWS_SERVER_2012_RTM_JAPANESE_64BIT_SQL_2012_SP4_WEB
      (= :windows-server-2022-english-core-eks-optimized-1-26 data) WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_CORE_EKS_OPTIMIZED_1_26
      (= :windows-server-2012-r2-rtm-chinese-traditional-hong-kong-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_CHINESE_TRADITIONAL_HONG_KONG_64BIT_BASE
      (= :windows-server-2012-r2-rtm-english-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_BASE
      (= :windows-server-2012-rtm-spanish-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_RTM_SPANISH_64BIT_BASE
      (= :windows-server-2003-r2-sp2-language-packs-32bit-base data) WindowsVersion/WINDOWS_SERVER_2003_R2_SP2_LANGUAGE_PACKS_32BIT_BASE
      (= :windows-server-2019-english-full-sql-2017-web data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2017_WEB
      (= :windows-server-2022-english-full-sql-2022-web data) WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_FULL_SQL_2022_WEB
      (= :windows-server-2012-rtm-german-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_RTM_GERMAN_64BIT_BASE
      (= :windows-server-2008-r2-sp1-english-64bit-sql-2008-r2-sp3-standard data) WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_ENGLISH_64BIT_SQL_2008_R2_SP3_STANDARD
      (= :windows-server-2016-english-stig-full data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_STIG_FULL
      (= :windows-server-2012-r2-rtm-japanese-64bit-sql-2016-sp1-standard data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_JAPANESE_64BIT_SQL_2016_SP1_STANDARD
      (= :windows-server-2012-r2-rtm-chinese-simplified-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_CHINESE_SIMPLIFIED_64BIT_BASE
      (= :windows-server-2019-french-full-base data) WindowsVersion/WINDOWS_SERVER_2019_FRENCH_FULL_BASE
      (= :windows-server-2012-r2-rtm-spanish-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_SPANISH_64BIT_BASE
      (= :windows-server-2012-r2-english-stig-core data) WindowsVersion/WINDOWS_SERVER_2012_R2_ENGLISH_STIG_CORE
      (= :windows-server-2012-r2-rtm-english-64bit-sql-2016-sp3-enterprise data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2016_SP3_ENTERPRISE
      (= :windows-server-2008-r2-sp1-english-64bit-sql-2012-sp4-express data) WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_ENGLISH_64BIT_SQL_2012_SP4_EXPRESS
      (= :windows-server-2019-english-full-eks-optimized-1-22 data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_EKS_OPTIMIZED_1_22
      (= :windows-server-2012-r2-rtm-english-64bit-core data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_CORE
      (= :windows-server-2012-r2-rtm-english-64bit-sql-2016-sp1-web data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2016_SP1_WEB
      (= :windows-server-2008-r2-sp1-english-64bit-sql-2012-sp4-standard data) WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_ENGLISH_64BIT_SQL_2012_SP4_STANDARD
      (= :windows-server-2016-english-full-sql-2016-sp3-web data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_FULL_SQL_2016_SP3_WEB
      (= :windows-server-2008-r2-sp1-english-64bit-sql-2012-sp4-enterprise data) WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_ENGLISH_64BIT_SQL_2012_SP4_ENTERPRISE
      (= :windows-server-2019-english-full-sql-2019-enterprise data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2019_ENTERPRISE
      (= :windows-server-2008-r2-sp1-japanese-64bit-sql-2008-r2-sp3-express data) WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_JAPANESE_64BIT_SQL_2008_R2_SP3_EXPRESS
      (= :windows-server-2022-english-core-eks-optimized-1-23 data) WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_CORE_EKS_OPTIMIZED_1_23
      (= :windows-server-2012-rtm-english-64bit-sql-2014-sp2-web data) WindowsVersion/WINDOWS_SERVER_2012_RTM_ENGLISH_64BIT_SQL_2014_SP2_WEB
      (= :windows-server-2016-japanese-full-sql-2016-sp2-express data) WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2016_SP2_EXPRESS
      (= :windows-server-2016-english-p3 data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_P3
      (= :windows-server-2012-rtm-swedish-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_RTM_SWEDISH_64BIT_BASE
      (= :windows-server-2019-japanese-full-sql-2017-enterprise data) WindowsVersion/WINDOWS_SERVER_2019_JAPANESE_FULL_SQL_2017_ENTERPRISE
      (= :windows-server-2022-japanese-full-sql-2017-enterprise data) WindowsVersion/WINDOWS_SERVER_2022_JAPANESE_FULL_SQL_2017_ENTERPRISE
      (= :windows-server-2016-english-core-containerslatest data) WindowsVersion/WINDOWS_SERVER_2016_ENGLISH_CORE_CONTAINERSLATEST
      (= :windows-server-2012-rtm-english-64bit-sql-2014-sp2-standard data) WindowsVersion/WINDOWS_SERVER_2012_RTM_ENGLISH_64BIT_SQL_2014_SP2_STANDARD
      (= :windows-server-2012-r2-rtm-japanese-64bit-sql-2016-sp3-enterprise data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_JAPANESE_64BIT_SQL_2016_SP3_ENTERPRISE
      (= :windows-server-2008-r2-sp1-chinese-hong-kong-sar-64bit-base data) WindowsVersion/WINDOWS_SERVER_2008_R2_SP1_CHINESE_HONG_KONG_SAR_64BIT_BASE
      (= :windows-server-2019-korean-full-base data) WindowsVersion/WINDOWS_SERVER_2019_KOREAN_FULL_BASE
      (= :windows-server-2012-r2-rtm-japanese-64bit-sql-2016-sp3-standard data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_JAPANESE_64BIT_SQL_2016_SP3_STANDARD
      (= :windows-server-2019-english-full-sql-2017-express data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2017_EXPRESS
      (= :windows-server-2019-english-tesla data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_TESLA
      (= :windows-server-2019-english-full-sql-2017-enterprise data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_SQL_2017_ENTERPRISE
      (= :windows-server-2016-german-full-base data) WindowsVersion/WINDOWS_SERVER_2016_GERMAN_FULL_BASE
      (= :windows-server-2012-rtm-korean-64bit-base data) WindowsVersion/WINDOWS_SERVER_2012_RTM_KOREAN_64BIT_BASE
      (= :windows-server-2012-r2-rtm-english-64bit-sql-2016-sp1-standard data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_ENGLISH_64BIT_SQL_2016_SP1_STANDARD
      (= :windows-server-2019-english-full-eks-optimized-1-26 data) WindowsVersion/WINDOWS_SERVER_2019_ENGLISH_FULL_EKS_OPTIMIZED_1_26
      (= :windows-server-2016-japanese-full-sql-2016-sp1-express data) WindowsVersion/WINDOWS_SERVER_2016_JAPANESE_FULL_SQL_2016_SP1_EXPRESS
      (= :windows-server-2022-english-core-ecs-optimized data) WindowsVersion/WINDOWS_SERVER_2022_ENGLISH_CORE_ECS_OPTIMIZED
      (= :windows-server-2012-rtm-japanese-64bit-2012-sp4-standard data) WindowsVersion/WINDOWS_SERVER_2012_RTM_JAPANESE_64BIT_2012_SP4_STANDARD
      (= :windows-server-2016-korean-full-base data) WindowsVersion/WINDOWS_SERVER_2016_KOREAN_FULL_BASE
      (= :windows-server-2012-r2-rtm-japanese-64bit-sql-2014-sp2-standard data) WindowsVersion/WINDOWS_SERVER_2012_R2_RTM_JAPANESE_64BIT_SQL_2014_SP2_STANDARD
      (= :windows-server-2012-rtm-japanese-64bit-sql-2014-sp2-express data) WindowsVersion/WINDOWS_SERVER_2012_RTM_JAPANESE_64BIT_SQL_2014_SP2_EXPRESS)))


(defn build-acl-cidr-config-builder
  "The build-acl-cidr-config-builder function updates a AclCidrConfig$Builder instance using the provided configuration.
  The function takes the AclCidrConfig$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `cidrBlock` | java.lang.String | [[cdk.support/lookup-entry]] | `:cidr-block` |
| `ipv6CidrBlock` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipv6-cidr-block` |
"
  [^AclCidrConfig$Builder builder id config]
  (when-let [data (lookup-entry config id :cidr-block)]
    (. builder cidrBlock data))
  (when-let [data (lookup-entry config id :ipv6-cidr-block)]
    (. builder ipv6CidrBlock data))
  (.build builder))


(defn acl-cidr-config-builder
  "Creates a  `AclCidrConfig$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-acl-cidr-config-builder (new AclCidrConfig$Builder) id config))


(defn build-acl-icmp-builder
  "The build-acl-icmp-builder function updates a AclIcmp$Builder instance using the provided configuration.
  The function takes the AclIcmp$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `code` | java.lang.Number | [[cdk.support/lookup-entry]] | `:code` |
| `type` | java.lang.Number | [[cdk.support/lookup-entry]] | `:type` |
"
  [^AclIcmp$Builder builder id config]
  (when-let [data (lookup-entry config id :code)]
    (. builder code data))
  (when-let [data (lookup-entry config id :type)]
    (. builder type data))
  (.build builder))


(defn acl-icmp-builder
  "Creates a  `AclIcmp$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-acl-icmp-builder (new AclIcmp$Builder) id config))


(defn build-acl-port-range-builder
  "The build-acl-port-range-builder function updates a AclPortRange$Builder instance using the provided configuration.
  The function takes the AclPortRange$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `from` | java.lang.Number | [[cdk.support/lookup-entry]] | `:from` |
| `to` | java.lang.Number | [[cdk.support/lookup-entry]] | `:to` |
"
  [^AclPortRange$Builder builder id config]
  (when-let [data (lookup-entry config id :from)]
    (. builder from data))
  (when-let [data (lookup-entry config id :to)]
    (. builder to data))
  (.build builder))


(defn acl-port-range-builder
  "Creates a  `AclPortRange$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-acl-port-range-builder (new AclPortRange$Builder) id config))


(defn build-acl-traffic-config-builder
  "The build-acl-traffic-config-builder function updates a AclTrafficConfig$Builder instance using the provided configuration.
  The function takes the AclTrafficConfig$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `icmp` | software.amazon.awscdk.services.ec2.AclIcmp | [[cdk.support/lookup-entry]] | `:icmp` |
| `portRange` | software.amazon.awscdk.services.ec2.AclPortRange | [[cdk.support/lookup-entry]] | `:port-range` |
| `protocol` | java.lang.Number | [[cdk.support/lookup-entry]] | `:protocol` |
"
  [^AclTrafficConfig$Builder builder id config]
  (when-let [data (lookup-entry config id :icmp)]
    (. builder icmp data))
  (when-let [data (lookup-entry config id :port-range)]
    (. builder portRange data))
  (when-let [data (lookup-entry config id :protocol)]
    (. builder protocol data))
  (.build builder))


(defn acl-traffic-config-builder
  "Creates a  `AclTrafficConfig$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-acl-traffic-config-builder (new AclTrafficConfig$Builder) id config))


(defn build-add-route-options-builder
  "The build-add-route-options-builder function updates a AddRouteOptions$Builder instance using the provided configuration.
  The function takes the AddRouteOptions$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `destinationCidrBlock` | java.lang.String | [[cdk.support/lookup-entry]] | `:destination-cidr-block` |
| `destinationIpv6CidrBlock` | java.lang.String | [[cdk.support/lookup-entry]] | `:destination-ipv6-cidr-block` |
| `enablesInternetConnectivity` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:enables-internet-connectivity` |
| `routerId` | java.lang.String | [[cdk.support/lookup-entry]] | `:router-id` |
| `routerType` | software.amazon.awscdk.services.ec2.RouterType | [[cdk.api.services.ec2/router-type]] | `:router-type` |
"
  [^AddRouteOptions$Builder builder id config]
  (when-let [data (lookup-entry config id :destination-cidr-block)]
    (. builder destinationCidrBlock data))
  (when-let [data (lookup-entry config id :destination-ipv6-cidr-block)]
    (. builder destinationIpv6CidrBlock data))
  (when-let [data (lookup-entry config id :enables-internet-connectivity)]
    (. builder enablesInternetConnectivity data))
  (when-let [data (lookup-entry config id :router-id)]
    (. builder routerId data))
  (when-let [data (router-type config id :router-type)]
    (. builder routerType data))
  (.build builder))


(defn add-route-options-builder
  "Creates a  `AddRouteOptions$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-add-route-options-builder (new AddRouteOptions$Builder) id config))


(defn build-allocate-cidr-request-builder
  "The build-allocate-cidr-request-builder function updates a AllocateCidrRequest$Builder instance using the provided configuration.
  The function takes the AllocateCidrRequest$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `requestedSubnets` | java.util.List | [[cdk.support/lookup-entry]] | `:requested-subnets` |
| `vpcCidr` | java.lang.String | [[cdk.support/lookup-entry]] | `:vpc-cidr` |
"
  [^AllocateCidrRequest$Builder builder id config]
  (when-let [data (lookup-entry config id :requested-subnets)]
    (. builder requestedSubnets data))
  (when-let [data (lookup-entry config id :vpc-cidr)]
    (. builder vpcCidr data))
  (.build builder))


(defn allocate-cidr-request-builder
  "Creates a  `AllocateCidrRequest$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-allocate-cidr-request-builder (new AllocateCidrRequest$Builder) id config))


(defn build-allocate-ipv6-cidr-request-builder
  "The build-allocate-ipv6-cidr-request-builder function updates a AllocateIpv6CidrRequest$Builder instance using the provided configuration.
  The function takes the AllocateIpv6CidrRequest$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `allocatedSubnets` | java.util.List | [[cdk.support/lookup-entry]] | `:allocated-subnets` |
| `ipv6Cidrs` | java.util.List | [[cdk.support/lookup-entry]] | `:ipv6-cidrs` |
"
  [^AllocateIpv6CidrRequest$Builder builder id config]
  (when-let [data (lookup-entry config id :allocated-subnets)]
    (. builder allocatedSubnets data))
  (when-let [data (lookup-entry config id :ipv6-cidrs)]
    (. builder ipv6Cidrs data))
  (.build builder))


(defn allocate-ipv6-cidr-request-builder
  "Creates a  `AllocateIpv6CidrRequest$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-allocate-ipv6-cidr-request-builder (new AllocateIpv6CidrRequest$Builder) id config))


(defn build-allocate-vpc-ipv6-cidr-request-builder
  "The build-allocate-vpc-ipv6-cidr-request-builder function updates a AllocateVpcIpv6CidrRequest$Builder instance using the provided configuration.
  The function takes the AllocateVpcIpv6CidrRequest$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `scope` | software.constructs.Construct | [[cdk.support/lookup-entry]] | `:scope` |
| `vpcId` | java.lang.String | [[cdk.support/lookup-entry]] | `:vpc-id` |
"
  [^AllocateVpcIpv6CidrRequest$Builder builder id config]
  (when-let [data (lookup-entry config id :scope)]
    (. builder scope data))
  (when-let [data (lookup-entry config id :vpc-id)]
    (. builder vpcId data))
  (.build builder))


(defn allocate-vpc-ipv6-cidr-request-builder
  "Creates a  `AllocateVpcIpv6CidrRequest$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-allocate-vpc-ipv6-cidr-request-builder (new AllocateVpcIpv6CidrRequest$Builder) id config))


(defn build-allocated-subnet-builder
  "The build-allocated-subnet-builder function updates a AllocatedSubnet$Builder instance using the provided configuration.
  The function takes the AllocatedSubnet$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `cidr` | java.lang.String | [[cdk.support/lookup-entry]] | `:cidr` |
| `ipv6Cidr` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipv6-cidr` |
"
  [^AllocatedSubnet$Builder builder id config]
  (when-let [data (lookup-entry config id :cidr)]
    (. builder cidr data))
  (when-let [data (lookup-entry config id :ipv6-cidr)]
    (. builder ipv6Cidr data))
  (.build builder))


(defn allocated-subnet-builder
  "Creates a  `AllocatedSubnet$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-allocated-subnet-builder (new AllocatedSubnet$Builder) id config))


(defn build-amazon-linux-image-builder
  "The build-amazon-linux-image-builder function updates a AmazonLinuxImage$Builder instance using the provided configuration.
  The function takes the AmazonLinuxImage$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `cachedInContext` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:cached-in-context` |
| `cpuType` | software.amazon.awscdk.services.ec2.AmazonLinuxCpuType | [[cdk.api.services.ec2/amazon-linux-cpu-type]] | `:cpu-type` |
| `edition` | software.amazon.awscdk.services.ec2.AmazonLinuxEdition | [[cdk.api.services.ec2/amazon-linux-edition]] | `:edition` |
| `generation` | software.amazon.awscdk.services.ec2.AmazonLinuxGeneration | [[cdk.api.services.ec2/amazon-linux-generation]] | `:generation` |
| `kernel` | software.amazon.awscdk.services.ec2.AmazonLinuxKernel | [[cdk.api.services.ec2/amazon-linux-kernel]] | `:kernel` |
| `storage` | software.amazon.awscdk.services.ec2.AmazonLinuxStorage | [[cdk.api.services.ec2/amazon-linux-storage]] | `:storage` |
| `userData` | software.amazon.awscdk.services.ec2.UserData | [[cdk.support/lookup-entry]] | `:user-data` |
| `virtualization` | software.amazon.awscdk.services.ec2.AmazonLinuxVirt | [[cdk.api.services.ec2/amazon-linux-virt]] | `:virtualization` |
"
  [^AmazonLinuxImage$Builder builder id config]
  (when-let [data (lookup-entry config id :cached-in-context)]
    (. builder cachedInContext data))
  (when-let [data (amazon-linux-cpu-type config id :cpu-type)]
    (. builder cpuType data))
  (when-let [data (amazon-linux-edition config id :edition)]
    (. builder edition data))
  (when-let [data (amazon-linux-generation config id :generation)]
    (. builder generation data))
  (when-let [data (amazon-linux-kernel config id :kernel)]
    (. builder kernel data))
  (when-let [data (amazon-linux-storage config id :storage)]
    (. builder storage data))
  (when-let [data (lookup-entry config id :user-data)]
    (. builder userData data))
  (when-let [data (amazon-linux-virt config id :virtualization)]
    (. builder virtualization data))
  (.build builder))


(defn amazon-linux-image-builder
  "Creates a  `AmazonLinuxImage$Builder` instance using a no-argument create, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-amazon-linux-image-builder (AmazonLinuxImage$Builder/create) id config))


(defn build-amazon-linux-image-props-builder
  "The build-amazon-linux-image-props-builder function updates a AmazonLinuxImageProps$Builder instance using the provided configuration.
  The function takes the AmazonLinuxImageProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `cachedInContext` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:cached-in-context` |
| `cpuType` | software.amazon.awscdk.services.ec2.AmazonLinuxCpuType | [[cdk.api.services.ec2/amazon-linux-cpu-type]] | `:cpu-type` |
| `edition` | software.amazon.awscdk.services.ec2.AmazonLinuxEdition | [[cdk.api.services.ec2/amazon-linux-edition]] | `:edition` |
| `generation` | software.amazon.awscdk.services.ec2.AmazonLinuxGeneration | [[cdk.api.services.ec2/amazon-linux-generation]] | `:generation` |
| `kernel` | software.amazon.awscdk.services.ec2.AmazonLinuxKernel | [[cdk.api.services.ec2/amazon-linux-kernel]] | `:kernel` |
| `storage` | software.amazon.awscdk.services.ec2.AmazonLinuxStorage | [[cdk.api.services.ec2/amazon-linux-storage]] | `:storage` |
| `userData` | software.amazon.awscdk.services.ec2.UserData | [[cdk.support/lookup-entry]] | `:user-data` |
| `virtualization` | software.amazon.awscdk.services.ec2.AmazonLinuxVirt | [[cdk.api.services.ec2/amazon-linux-virt]] | `:virtualization` |
"
  [^AmazonLinuxImageProps$Builder builder id config]
  (when-let [data (lookup-entry config id :cached-in-context)]
    (. builder cachedInContext data))
  (when-let [data (amazon-linux-cpu-type config id :cpu-type)]
    (. builder cpuType data))
  (when-let [data (amazon-linux-edition config id :edition)]
    (. builder edition data))
  (when-let [data (amazon-linux-generation config id :generation)]
    (. builder generation data))
  (when-let [data (amazon-linux-kernel config id :kernel)]
    (. builder kernel data))
  (when-let [data (amazon-linux-storage config id :storage)]
    (. builder storage data))
  (when-let [data (lookup-entry config id :user-data)]
    (. builder userData data))
  (when-let [data (amazon-linux-virt config id :virtualization)]
    (. builder virtualization data))
  (.build builder))


(defn amazon-linux-image-props-builder
  "Creates a  `AmazonLinuxImageProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-amazon-linux-image-props-builder (new AmazonLinuxImageProps$Builder) id config))


(defn build-amazon-linux-image-ssm-parameter-base-options-builder
  "The build-amazon-linux-image-ssm-parameter-base-options-builder function updates a AmazonLinuxImageSsmParameterBaseOptions$Builder instance using the provided configuration.
  The function takes the AmazonLinuxImageSsmParameterBaseOptions$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `cachedInContext` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:cached-in-context` |
| `userData` | software.amazon.awscdk.services.ec2.UserData | [[cdk.support/lookup-entry]] | `:user-data` |
"
  [^AmazonLinuxImageSsmParameterBaseOptions$Builder builder id config]
  (when-let [data (lookup-entry config id :cached-in-context)]
    (. builder cachedInContext data))
  (when-let [data (lookup-entry config id :user-data)]
    (. builder userData data))
  (.build builder))


(defn amazon-linux-image-ssm-parameter-base-options-builder
  "Creates a  `AmazonLinuxImageSsmParameterBaseOptions$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-amazon-linux-image-ssm-parameter-base-options-builder (new AmazonLinuxImageSsmParameterBaseOptions$Builder) id config))


(defn build-amazon-linux-image-ssm-parameter-base-props-builder
  "The build-amazon-linux-image-ssm-parameter-base-props-builder function updates a AmazonLinuxImageSsmParameterBaseProps$Builder instance using the provided configuration.
  The function takes the AmazonLinuxImageSsmParameterBaseProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `cachedInContext` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:cached-in-context` |
| `parameterName` | java.lang.String | [[cdk.support/lookup-entry]] | `:parameter-name` |
| `userData` | software.amazon.awscdk.services.ec2.UserData | [[cdk.support/lookup-entry]] | `:user-data` |
"
  [^AmazonLinuxImageSsmParameterBaseProps$Builder builder id config]
  (when-let [data (lookup-entry config id :cached-in-context)]
    (. builder cachedInContext data))
  (when-let [data (lookup-entry config id :parameter-name)]
    (. builder parameterName data))
  (when-let [data (lookup-entry config id :user-data)]
    (. builder userData data))
  (.build builder))


(defn amazon-linux-image-ssm-parameter-base-props-builder
  "Creates a  `AmazonLinuxImageSsmParameterBaseProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-amazon-linux-image-ssm-parameter-base-props-builder (new AmazonLinuxImageSsmParameterBaseProps$Builder) id config))


(defn build-amazon-linux-image-ssm-parameter-common-options-builder
  "The build-amazon-linux-image-ssm-parameter-common-options-builder function updates a AmazonLinuxImageSsmParameterCommonOptions$Builder instance using the provided configuration.
  The function takes the AmazonLinuxImageSsmParameterCommonOptions$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `cachedInContext` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:cached-in-context` |
| `cpuType` | software.amazon.awscdk.services.ec2.AmazonLinuxCpuType | [[cdk.api.services.ec2/amazon-linux-cpu-type]] | `:cpu-type` |
| `edition` | software.amazon.awscdk.services.ec2.AmazonLinuxEdition | [[cdk.api.services.ec2/amazon-linux-edition]] | `:edition` |
| `userData` | software.amazon.awscdk.services.ec2.UserData | [[cdk.support/lookup-entry]] | `:user-data` |
"
  [^AmazonLinuxImageSsmParameterCommonOptions$Builder builder id config]
  (when-let [data (lookup-entry config id :cached-in-context)]
    (. builder cachedInContext data))
  (when-let [data (amazon-linux-cpu-type config id :cpu-type)]
    (. builder cpuType data))
  (when-let [data (amazon-linux-edition config id :edition)]
    (. builder edition data))
  (when-let [data (lookup-entry config id :user-data)]
    (. builder userData data))
  (.build builder))


(defn amazon-linux-image-ssm-parameter-common-options-builder
  "Creates a  `AmazonLinuxImageSsmParameterCommonOptions$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-amazon-linux-image-ssm-parameter-common-options-builder (new AmazonLinuxImageSsmParameterCommonOptions$Builder) id config))


(defn build-amazon-linux2-image-ssm-parameter-builder
  "The build-amazon-linux2-image-ssm-parameter-builder function updates a AmazonLinux2ImageSsmParameter$Builder instance using the provided configuration.
  The function takes the AmazonLinux2ImageSsmParameter$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `cachedInContext` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:cached-in-context` |
| `cpuType` | software.amazon.awscdk.services.ec2.AmazonLinuxCpuType | [[cdk.api.services.ec2/amazon-linux-cpu-type]] | `:cpu-type` |
| `edition` | software.amazon.awscdk.services.ec2.AmazonLinuxEdition | [[cdk.api.services.ec2/amazon-linux-edition]] | `:edition` |
| `kernel` | software.amazon.awscdk.services.ec2.AmazonLinux2Kernel | [[cdk.support/lookup-entry]] | `:kernel` |
| `storage` | software.amazon.awscdk.services.ec2.AmazonLinuxStorage | [[cdk.api.services.ec2/amazon-linux-storage]] | `:storage` |
| `userData` | software.amazon.awscdk.services.ec2.UserData | [[cdk.support/lookup-entry]] | `:user-data` |
| `virtualization` | software.amazon.awscdk.services.ec2.AmazonLinuxVirt | [[cdk.api.services.ec2/amazon-linux-virt]] | `:virtualization` |
"
  [^AmazonLinux2ImageSsmParameter$Builder builder id config]
  (when-let [data (lookup-entry config id :cached-in-context)]
    (. builder cachedInContext data))
  (when-let [data (amazon-linux-cpu-type config id :cpu-type)]
    (. builder cpuType data))
  (when-let [data (amazon-linux-edition config id :edition)]
    (. builder edition data))
  (when-let [data (lookup-entry config id :kernel)]
    (. builder kernel data))
  (when-let [data (amazon-linux-storage config id :storage)]
    (. builder storage data))
  (when-let [data (lookup-entry config id :user-data)]
    (. builder userData data))
  (when-let [data (amazon-linux-virt config id :virtualization)]
    (. builder virtualization data))
  (.build builder))


(defn amazon-linux2-image-ssm-parameter-builder
  "Creates a  `AmazonLinux2ImageSsmParameter$Builder` instance using a no-argument create, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-amazon-linux2-image-ssm-parameter-builder (AmazonLinux2ImageSsmParameter$Builder/create) id config))


(defn build-amazon-linux2-image-ssm-parameter-props-builder
  "The build-amazon-linux2-image-ssm-parameter-props-builder function updates a AmazonLinux2ImageSsmParameterProps$Builder instance using the provided configuration.
  The function takes the AmazonLinux2ImageSsmParameterProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `cachedInContext` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:cached-in-context` |
| `cpuType` | software.amazon.awscdk.services.ec2.AmazonLinuxCpuType | [[cdk.api.services.ec2/amazon-linux-cpu-type]] | `:cpu-type` |
| `edition` | software.amazon.awscdk.services.ec2.AmazonLinuxEdition | [[cdk.api.services.ec2/amazon-linux-edition]] | `:edition` |
| `kernel` | software.amazon.awscdk.services.ec2.AmazonLinux2Kernel | [[cdk.support/lookup-entry]] | `:kernel` |
| `storage` | software.amazon.awscdk.services.ec2.AmazonLinuxStorage | [[cdk.api.services.ec2/amazon-linux-storage]] | `:storage` |
| `userData` | software.amazon.awscdk.services.ec2.UserData | [[cdk.support/lookup-entry]] | `:user-data` |
| `virtualization` | software.amazon.awscdk.services.ec2.AmazonLinuxVirt | [[cdk.api.services.ec2/amazon-linux-virt]] | `:virtualization` |
"
  [^AmazonLinux2ImageSsmParameterProps$Builder builder id config]
  (when-let [data (lookup-entry config id :cached-in-context)]
    (. builder cachedInContext data))
  (when-let [data (amazon-linux-cpu-type config id :cpu-type)]
    (. builder cpuType data))
  (when-let [data (amazon-linux-edition config id :edition)]
    (. builder edition data))
  (when-let [data (lookup-entry config id :kernel)]
    (. builder kernel data))
  (when-let [data (amazon-linux-storage config id :storage)]
    (. builder storage data))
  (when-let [data (lookup-entry config id :user-data)]
    (. builder userData data))
  (when-let [data (amazon-linux-virt config id :virtualization)]
    (. builder virtualization data))
  (.build builder))


(defn amazon-linux2-image-ssm-parameter-props-builder
  "Creates a  `AmazonLinux2ImageSsmParameterProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-amazon-linux2-image-ssm-parameter-props-builder (new AmazonLinux2ImageSsmParameterProps$Builder) id config))


(defn build-amazon-linux2022-image-ssm-parameter-builder
  "The build-amazon-linux2022-image-ssm-parameter-builder function updates a AmazonLinux2022ImageSsmParameter$Builder instance using the provided configuration.
  The function takes the AmazonLinux2022ImageSsmParameter$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `cachedInContext` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:cached-in-context` |
| `cpuType` | software.amazon.awscdk.services.ec2.AmazonLinuxCpuType | [[cdk.api.services.ec2/amazon-linux-cpu-type]] | `:cpu-type` |
| `edition` | software.amazon.awscdk.services.ec2.AmazonLinuxEdition | [[cdk.api.services.ec2/amazon-linux-edition]] | `:edition` |
| `kernel` | software.amazon.awscdk.services.ec2.AmazonLinux2022Kernel | [[cdk.support/lookup-entry]] | `:kernel` |
| `userData` | software.amazon.awscdk.services.ec2.UserData | [[cdk.support/lookup-entry]] | `:user-data` |
"
  [^AmazonLinux2022ImageSsmParameter$Builder builder id config]
  (when-let [data (lookup-entry config id :cached-in-context)]
    (. builder cachedInContext data))
  (when-let [data (amazon-linux-cpu-type config id :cpu-type)]
    (. builder cpuType data))
  (when-let [data (amazon-linux-edition config id :edition)]
    (. builder edition data))
  (when-let [data (lookup-entry config id :kernel)]
    (. builder kernel data))
  (when-let [data (lookup-entry config id :user-data)]
    (. builder userData data))
  (.build builder))


(defn amazon-linux2022-image-ssm-parameter-builder
  "Creates a  `AmazonLinux2022ImageSsmParameter$Builder` instance using a no-argument create, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-amazon-linux2022-image-ssm-parameter-builder (AmazonLinux2022ImageSsmParameter$Builder/create) id config))


(defn build-amazon-linux2022-image-ssm-parameter-props-builder
  "The build-amazon-linux2022-image-ssm-parameter-props-builder function updates a AmazonLinux2022ImageSsmParameterProps$Builder instance using the provided configuration.
  The function takes the AmazonLinux2022ImageSsmParameterProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `cachedInContext` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:cached-in-context` |
| `cpuType` | software.amazon.awscdk.services.ec2.AmazonLinuxCpuType | [[cdk.api.services.ec2/amazon-linux-cpu-type]] | `:cpu-type` |
| `edition` | software.amazon.awscdk.services.ec2.AmazonLinuxEdition | [[cdk.api.services.ec2/amazon-linux-edition]] | `:edition` |
| `kernel` | software.amazon.awscdk.services.ec2.AmazonLinux2022Kernel | [[cdk.support/lookup-entry]] | `:kernel` |
| `userData` | software.amazon.awscdk.services.ec2.UserData | [[cdk.support/lookup-entry]] | `:user-data` |
"
  [^AmazonLinux2022ImageSsmParameterProps$Builder builder id config]
  (when-let [data (lookup-entry config id :cached-in-context)]
    (. builder cachedInContext data))
  (when-let [data (amazon-linux-cpu-type config id :cpu-type)]
    (. builder cpuType data))
  (when-let [data (amazon-linux-edition config id :edition)]
    (. builder edition data))
  (when-let [data (lookup-entry config id :kernel)]
    (. builder kernel data))
  (when-let [data (lookup-entry config id :user-data)]
    (. builder userData data))
  (.build builder))


(defn amazon-linux2022-image-ssm-parameter-props-builder
  "Creates a  `AmazonLinux2022ImageSsmParameterProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-amazon-linux2022-image-ssm-parameter-props-builder (new AmazonLinux2022ImageSsmParameterProps$Builder) id config))


(defn build-amazon-linux2023-image-ssm-parameter-builder
  "The build-amazon-linux2023-image-ssm-parameter-builder function updates a AmazonLinux2023ImageSsmParameter$Builder instance using the provided configuration.
  The function takes the AmazonLinux2023ImageSsmParameter$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `cachedInContext` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:cached-in-context` |
| `cpuType` | software.amazon.awscdk.services.ec2.AmazonLinuxCpuType | [[cdk.api.services.ec2/amazon-linux-cpu-type]] | `:cpu-type` |
| `edition` | software.amazon.awscdk.services.ec2.AmazonLinuxEdition | [[cdk.api.services.ec2/amazon-linux-edition]] | `:edition` |
| `kernel` | software.amazon.awscdk.services.ec2.AmazonLinux2023Kernel | [[cdk.support/lookup-entry]] | `:kernel` |
| `userData` | software.amazon.awscdk.services.ec2.UserData | [[cdk.support/lookup-entry]] | `:user-data` |
"
  [^AmazonLinux2023ImageSsmParameter$Builder builder id config]
  (when-let [data (lookup-entry config id :cached-in-context)]
    (. builder cachedInContext data))
  (when-let [data (amazon-linux-cpu-type config id :cpu-type)]
    (. builder cpuType data))
  (when-let [data (amazon-linux-edition config id :edition)]
    (. builder edition data))
  (when-let [data (lookup-entry config id :kernel)]
    (. builder kernel data))
  (when-let [data (lookup-entry config id :user-data)]
    (. builder userData data))
  (.build builder))


(defn amazon-linux2023-image-ssm-parameter-builder
  "Creates a  `AmazonLinux2023ImageSsmParameter$Builder` instance using a no-argument create, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-amazon-linux2023-image-ssm-parameter-builder (AmazonLinux2023ImageSsmParameter$Builder/create) id config))


(defn build-amazon-linux2023-image-ssm-parameter-props-builder
  "The build-amazon-linux2023-image-ssm-parameter-props-builder function updates a AmazonLinux2023ImageSsmParameterProps$Builder instance using the provided configuration.
  The function takes the AmazonLinux2023ImageSsmParameterProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `cachedInContext` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:cached-in-context` |
| `cpuType` | software.amazon.awscdk.services.ec2.AmazonLinuxCpuType | [[cdk.api.services.ec2/amazon-linux-cpu-type]] | `:cpu-type` |
| `edition` | software.amazon.awscdk.services.ec2.AmazonLinuxEdition | [[cdk.api.services.ec2/amazon-linux-edition]] | `:edition` |
| `kernel` | software.amazon.awscdk.services.ec2.AmazonLinux2023Kernel | [[cdk.support/lookup-entry]] | `:kernel` |
| `userData` | software.amazon.awscdk.services.ec2.UserData | [[cdk.support/lookup-entry]] | `:user-data` |
"
  [^AmazonLinux2023ImageSsmParameterProps$Builder builder id config]
  (when-let [data (lookup-entry config id :cached-in-context)]
    (. builder cachedInContext data))
  (when-let [data (amazon-linux-cpu-type config id :cpu-type)]
    (. builder cpuType data))
  (when-let [data (amazon-linux-edition config id :edition)]
    (. builder edition data))
  (when-let [data (lookup-entry config id :kernel)]
    (. builder kernel data))
  (when-let [data (lookup-entry config id :user-data)]
    (. builder userData data))
  (.build builder))


(defn amazon-linux2023-image-ssm-parameter-props-builder
  "Creates a  `AmazonLinux2023ImageSsmParameterProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-amazon-linux2023-image-ssm-parameter-props-builder (new AmazonLinux2023ImageSsmParameterProps$Builder) id config))


(defn build-apply-cloud-formation-init-options-builder
  "The build-apply-cloud-formation-init-options-builder function updates a ApplyCloudFormationInitOptions$Builder instance using the provided configuration.
  The function takes the ApplyCloudFormationInitOptions$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `configSets` | java.util.List | [[cdk.support/lookup-entry]] | `:config-sets` |
| `embedFingerprint` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:embed-fingerprint` |
| `ignoreFailures` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:ignore-failures` |
| `includeRole` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:include-role` |
| `includeUrl` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:include-url` |
| `printLog` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:print-log` |
| `timeout` | software.amazon.awscdk.Duration | [[cdk.support/lookup-entry]] | `:timeout` |
"
  [^ApplyCloudFormationInitOptions$Builder builder id config]
  (when-let [data (lookup-entry config id :config-sets)]
    (. builder configSets data))
  (when-let [data (lookup-entry config id :embed-fingerprint)]
    (. builder embedFingerprint data))
  (when-let [data (lookup-entry config id :ignore-failures)]
    (. builder ignoreFailures data))
  (when-let [data (lookup-entry config id :include-role)]
    (. builder includeRole data))
  (when-let [data (lookup-entry config id :include-url)]
    (. builder includeUrl data))
  (when-let [data (lookup-entry config id :print-log)]
    (. builder printLog data))
  (when-let [data (lookup-entry config id :timeout)]
    (. builder timeout data))
  (.build builder))


(defn apply-cloud-formation-init-options-builder
  "Creates a  `ApplyCloudFormationInitOptions$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-apply-cloud-formation-init-options-builder (new ApplyCloudFormationInitOptions$Builder) id config))


(defn build-attach-init-options-builder
  "The build-attach-init-options-builder function updates a AttachInitOptions$Builder instance using the provided configuration.
  The function takes the AttachInitOptions$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `configSets` | java.util.List | [[cdk.support/lookup-entry]] | `:config-sets` |
| `embedFingerprint` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:embed-fingerprint` |
| `ignoreFailures` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:ignore-failures` |
| `includeRole` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:include-role` |
| `includeUrl` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:include-url` |
| `instanceRole` | software.amazon.awscdk.services.iam.IRole | [[cdk.support/lookup-entry]] | `:instance-role` |
| `platform` | software.amazon.awscdk.services.ec2.OperatingSystemType | [[cdk.api.services.ec2/operating-system-type]] | `:platform` |
| `printLog` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:print-log` |
| `signalResource` | software.amazon.awscdk.CfnResource | [[cdk.support/lookup-entry]] | `:signal-resource` |
| `userData` | software.amazon.awscdk.services.ec2.UserData | [[cdk.support/lookup-entry]] | `:user-data` |
"
  [^AttachInitOptions$Builder builder id config]
  (when-let [data (lookup-entry config id :config-sets)]
    (. builder configSets data))
  (when-let [data (lookup-entry config id :embed-fingerprint)]
    (. builder embedFingerprint data))
  (when-let [data (lookup-entry config id :ignore-failures)]
    (. builder ignoreFailures data))
  (when-let [data (lookup-entry config id :include-role)]
    (. builder includeRole data))
  (when-let [data (lookup-entry config id :include-url)]
    (. builder includeUrl data))
  (when-let [data (lookup-entry config id :instance-role)]
    (. builder instanceRole data))
  (when-let [data (operating-system-type config id :platform)]
    (. builder platform data))
  (when-let [data (lookup-entry config id :print-log)]
    (. builder printLog data))
  (when-let [data (lookup-entry config id :signal-resource)]
    (. builder signalResource data))
  (when-let [data (lookup-entry config id :user-data)]
    (. builder userData data))
  (.build builder))


(defn attach-init-options-builder
  "Creates a  `AttachInitOptions$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-attach-init-options-builder (new AttachInitOptions$Builder) id config))


(defn build-aws-ipam-props-builder
  "The build-aws-ipam-props-builder function updates a AwsIpamProps$Builder instance using the provided configuration.
  The function takes the AwsIpamProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `defaultSubnetIpv4NetmaskLength` | java.lang.Number | [[cdk.support/lookup-entry]] | `:default-subnet-ipv4-netmask-length` |
| `ipv4IpamPoolId` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipv4-ipam-pool-id` |
| `ipv4NetmaskLength` | java.lang.Number | [[cdk.support/lookup-entry]] | `:ipv4-netmask-length` |
"
  [^AwsIpamProps$Builder builder id config]
  (when-let [data (lookup-entry config id :default-subnet-ipv4-netmask-length)]
    (. builder defaultSubnetIpv4NetmaskLength data))
  (when-let [data (lookup-entry config id :ipv4-ipam-pool-id)]
    (. builder ipv4IpamPoolId data))
  (when-let [data (lookup-entry config id :ipv4-netmask-length)]
    (. builder ipv4NetmaskLength data))
  (.build builder))


(defn aws-ipam-props-builder
  "Creates a  `AwsIpamProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-aws-ipam-props-builder (new AwsIpamProps$Builder) id config))


(defn build-bastion-host-linux-builder
  "The build-bastion-host-linux-builder function updates a BastionHostLinux$Builder instance using the provided configuration.
  The function takes the BastionHostLinux$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `availabilityZone` | java.lang.String | [[cdk.support/lookup-entry]] | `:availability-zone` |
| `blockDevices` | java.util.List | [[cdk.support/lookup-entry]] | `:block-devices` |
| `init` | software.amazon.awscdk.services.ec2.CloudFormationInit | [[cdk.support/lookup-entry]] | `:init` |
| `initOptions` | software.amazon.awscdk.services.ec2.ApplyCloudFormationInitOptions | [[cdk.support/lookup-entry]] | `:init-options` |
| `instanceName` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-name` |
| `instanceType` | software.amazon.awscdk.services.ec2.InstanceType | [[cdk.support/lookup-entry]] | `:instance-type` |
| `machineImage` | software.amazon.awscdk.services.ec2.IMachineImage | [[cdk.support/lookup-entry]] | `:machine-image` |
| `requireImdsv2` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:require-imdsv2` |
| `securityGroup` | software.amazon.awscdk.services.ec2.ISecurityGroup | [[cdk.support/lookup-entry]] | `:security-group` |
| `subnetSelection` | software.amazon.awscdk.services.ec2.SubnetSelection | [[cdk.support/lookup-entry]] | `:subnet-selection` |
| `vpc` | software.amazon.awscdk.services.ec2.IVpc | [[cdk.support/lookup-entry]] | `:vpc` |
"
  [^BastionHostLinux$Builder builder id config]
  (when-let [data (lookup-entry config id :availability-zone)]
    (. builder availabilityZone data))
  (when-let [data (lookup-entry config id :block-devices)]
    (. builder blockDevices data))
  (when-let [data (lookup-entry config id :init)]
    (. builder init data))
  (when-let [data (lookup-entry config id :init-options)]
    (. builder initOptions data))
  (when-let [data (lookup-entry config id :instance-name)]
    (. builder instanceName data))
  (when-let [data (lookup-entry config id :instance-type)]
    (. builder instanceType data))
  (when-let [data (lookup-entry config id :machine-image)]
    (. builder machineImage data))
  (when-let [data (lookup-entry config id :require-imdsv2)]
    (. builder requireImdsv2 data))
  (when-let [data (lookup-entry config id :security-group)]
    (. builder securityGroup data))
  (when-let [data (lookup-entry config id :subnet-selection)]
    (. builder subnetSelection data))
  (when-let [data (lookup-entry config id :vpc)]
    (. builder vpc data))
  (.build builder))


(defn bastion-host-linux-builder
  "Creates a  `BastionHostLinux$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-bastion-host-linux-builder (BastionHostLinux$Builder/create scope (name id)) id config))


(defn build-bastion-host-linux-props-builder
  "The build-bastion-host-linux-props-builder function updates a BastionHostLinuxProps$Builder instance using the provided configuration.
  The function takes the BastionHostLinuxProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `availabilityZone` | java.lang.String | [[cdk.support/lookup-entry]] | `:availability-zone` |
| `blockDevices` | java.util.List | [[cdk.support/lookup-entry]] | `:block-devices` |
| `init` | software.amazon.awscdk.services.ec2.CloudFormationInit | [[cdk.support/lookup-entry]] | `:init` |
| `initOptions` | software.amazon.awscdk.services.ec2.ApplyCloudFormationInitOptions | [[cdk.support/lookup-entry]] | `:init-options` |
| `instanceName` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-name` |
| `instanceType` | software.amazon.awscdk.services.ec2.InstanceType | [[cdk.support/lookup-entry]] | `:instance-type` |
| `machineImage` | software.amazon.awscdk.services.ec2.IMachineImage | [[cdk.support/lookup-entry]] | `:machine-image` |
| `requireImdsv2` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:require-imdsv2` |
| `securityGroup` | software.amazon.awscdk.services.ec2.ISecurityGroup | [[cdk.support/lookup-entry]] | `:security-group` |
| `subnetSelection` | software.amazon.awscdk.services.ec2.SubnetSelection | [[cdk.support/lookup-entry]] | `:subnet-selection` |
| `vpc` | software.amazon.awscdk.services.ec2.IVpc | [[cdk.support/lookup-entry]] | `:vpc` |
"
  [^BastionHostLinuxProps$Builder builder id config]
  (when-let [data (lookup-entry config id :availability-zone)]
    (. builder availabilityZone data))
  (when-let [data (lookup-entry config id :block-devices)]
    (. builder blockDevices data))
  (when-let [data (lookup-entry config id :init)]
    (. builder init data))
  (when-let [data (lookup-entry config id :init-options)]
    (. builder initOptions data))
  (when-let [data (lookup-entry config id :instance-name)]
    (. builder instanceName data))
  (when-let [data (lookup-entry config id :instance-type)]
    (. builder instanceType data))
  (when-let [data (lookup-entry config id :machine-image)]
    (. builder machineImage data))
  (when-let [data (lookup-entry config id :require-imdsv2)]
    (. builder requireImdsv2 data))
  (when-let [data (lookup-entry config id :security-group)]
    (. builder securityGroup data))
  (when-let [data (lookup-entry config id :subnet-selection)]
    (. builder subnetSelection data))
  (when-let [data (lookup-entry config id :vpc)]
    (. builder vpc data))
  (.build builder))


(defn bastion-host-linux-props-builder
  "Creates a  `BastionHostLinuxProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-bastion-host-linux-props-builder (new BastionHostLinuxProps$Builder) id config))


(defn build-block-device-builder
  "The build-block-device-builder function updates a BlockDevice$Builder instance using the provided configuration.
  The function takes the BlockDevice$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `deviceName` | java.lang.String | [[cdk.support/lookup-entry]] | `:device-name` |
| `mappingEnabled` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:mapping-enabled` |
| `volume` | software.amazon.awscdk.services.ec2.BlockDeviceVolume | [[cdk.support/lookup-entry]] | `:volume` |
"
  [^BlockDevice$Builder builder id config]
  (when-let [data (lookup-entry config id :device-name)]
    (. builder deviceName data))
  (when-let [data (lookup-entry config id :mapping-enabled)]
    (. builder mappingEnabled data))
  (when-let [data (lookup-entry config id :volume)]
    (. builder volume data))
  (.build builder))


(defn block-device-builder
  "Creates a  `BlockDevice$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-block-device-builder (new BlockDevice$Builder) id config))


(defn build-cfn-capacity-reservation-builder
  "The build-cfn-capacity-reservation-builder function updates a CfnCapacityReservation$Builder instance using the provided configuration.
  The function takes the CfnCapacityReservation$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `availabilityZone` | java.lang.String | [[cdk.support/lookup-entry]] | `:availability-zone` |
| `ebsOptimized` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:ebs-optimized` |
| `endDate` | java.lang.String | [[cdk.support/lookup-entry]] | `:end-date` |
| `endDateType` | java.lang.String | [[cdk.support/lookup-entry]] | `:end-date-type` |
| `ephemeralStorage` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:ephemeral-storage` |
| `instanceCount` | java.lang.Number | [[cdk.support/lookup-entry]] | `:instance-count` |
| `instanceMatchCriteria` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-match-criteria` |
| `instancePlatform` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-platform` |
| `instanceType` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-type` |
| `outPostArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:out-post-arn` |
| `placementGroupArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:placement-group-arn` |
| `tagSpecifications` | java.util.List | [[cdk.support/lookup-entry]] | `:tag-specifications` |
| `tenancy` | java.lang.String | [[cdk.support/lookup-entry]] | `:tenancy` |
"
  [^CfnCapacityReservation$Builder builder id config]
  (when-let [data (lookup-entry config id :availability-zone)]
    (. builder availabilityZone data))
  (when-let [data (lookup-entry config id :ebs-optimized)]
    (. builder ebsOptimized data))
  (when-let [data (lookup-entry config id :end-date)]
    (. builder endDate data))
  (when-let [data (lookup-entry config id :end-date-type)]
    (. builder endDateType data))
  (when-let [data (lookup-entry config id :ephemeral-storage)]
    (. builder ephemeralStorage data))
  (when-let [data (lookup-entry config id :instance-count)]
    (. builder instanceCount data))
  (when-let [data (lookup-entry config id :instance-match-criteria)]
    (. builder instanceMatchCriteria data))
  (when-let [data (lookup-entry config id :instance-platform)]
    (. builder instancePlatform data))
  (when-let [data (lookup-entry config id :instance-type)]
    (. builder instanceType data))
  (when-let [data (lookup-entry config id :out-post-arn)]
    (. builder outPostArn data))
  (when-let [data (lookup-entry config id :placement-group-arn)]
    (. builder placementGroupArn data))
  (when-let [data (lookup-entry config id :tag-specifications)]
    (. builder tagSpecifications data))
  (when-let [data (lookup-entry config id :tenancy)]
    (. builder tenancy data))
  (.build builder))


(defn cfn-capacity-reservation-builder
  "Creates a  `CfnCapacityReservation$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-capacity-reservation-builder (CfnCapacityReservation$Builder/create scope (name id)) id config))


(defn build-cfn-capacity-reservation-fleet-builder
  "The build-cfn-capacity-reservation-fleet-builder function updates a CfnCapacityReservationFleet$Builder instance using the provided configuration.
  The function takes the CfnCapacityReservationFleet$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `allocationStrategy` | java.lang.String | [[cdk.support/lookup-entry]] | `:allocation-strategy` |
| `endDate` | java.lang.String | [[cdk.support/lookup-entry]] | `:end-date` |
| `instanceMatchCriteria` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-match-criteria` |
| `instanceTypeSpecifications` | java.util.List | [[cdk.support/lookup-entry]] | `:instance-type-specifications` |
| `noRemoveEndDate` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:no-remove-end-date` |
| `removeEndDate` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:remove-end-date` |
| `tagSpecifications` | java.util.List | [[cdk.support/lookup-entry]] | `:tag-specifications` |
| `tenancy` | java.lang.String | [[cdk.support/lookup-entry]] | `:tenancy` |
| `totalTargetCapacity` | java.lang.Number | [[cdk.support/lookup-entry]] | `:total-target-capacity` |
"
  [^CfnCapacityReservationFleet$Builder builder id config]
  (when-let [data (lookup-entry config id :allocation-strategy)]
    (. builder allocationStrategy data))
  (when-let [data (lookup-entry config id :end-date)]
    (. builder endDate data))
  (when-let [data (lookup-entry config id :instance-match-criteria)]
    (. builder instanceMatchCriteria data))
  (when-let [data (lookup-entry config id :instance-type-specifications)]
    (. builder instanceTypeSpecifications data))
  (when-let [data (lookup-entry config id :no-remove-end-date)]
    (. builder noRemoveEndDate data))
  (when-let [data (lookup-entry config id :remove-end-date)]
    (. builder removeEndDate data))
  (when-let [data (lookup-entry config id :tag-specifications)]
    (. builder tagSpecifications data))
  (when-let [data (lookup-entry config id :tenancy)]
    (. builder tenancy data))
  (when-let [data (lookup-entry config id :total-target-capacity)]
    (. builder totalTargetCapacity data))
  (.build builder))


(defn cfn-capacity-reservation-fleet-builder
  "Creates a  `CfnCapacityReservationFleet$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-capacity-reservation-fleet-builder (CfnCapacityReservationFleet$Builder/create scope (name id)) id config))


(defn build-cfn-capacity-reservation-fleet-instance-type-specification-property-builder
  "The build-cfn-capacity-reservation-fleet-instance-type-specification-property-builder function updates a CfnCapacityReservationFleet$InstanceTypeSpecificationProperty$Builder instance using the provided configuration.
  The function takes the CfnCapacityReservationFleet$InstanceTypeSpecificationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `availabilityZone` | java.lang.String | [[cdk.support/lookup-entry]] | `:availability-zone` |
| `availabilityZoneId` | java.lang.String | [[cdk.support/lookup-entry]] | `:availability-zone-id` |
| `ebsOptimized` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:ebs-optimized` |
| `instancePlatform` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-platform` |
| `instanceType` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-type` |
| `priority` | java.lang.Number | [[cdk.support/lookup-entry]] | `:priority` |
| `weight` | java.lang.Number | [[cdk.support/lookup-entry]] | `:weight` |
"
  [^CfnCapacityReservationFleet$InstanceTypeSpecificationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :availability-zone)]
    (. builder availabilityZone data))
  (when-let [data (lookup-entry config id :availability-zone-id)]
    (. builder availabilityZoneId data))
  (when-let [data (lookup-entry config id :ebs-optimized)]
    (. builder ebsOptimized data))
  (when-let [data (lookup-entry config id :instance-platform)]
    (. builder instancePlatform data))
  (when-let [data (lookup-entry config id :instance-type)]
    (. builder instanceType data))
  (when-let [data (lookup-entry config id :priority)]
    (. builder priority data))
  (when-let [data (lookup-entry config id :weight)]
    (. builder weight data))
  (.build builder))


(defn cfn-capacity-reservation-fleet-instance-type-specification-property-builder
  "Creates a  `CfnCapacityReservationFleet$InstanceTypeSpecificationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-capacity-reservation-fleet-instance-type-specification-property-builder (new CfnCapacityReservationFleet$InstanceTypeSpecificationProperty$Builder) id config))


(defn build-cfn-capacity-reservation-fleet-props-builder
  "The build-cfn-capacity-reservation-fleet-props-builder function updates a CfnCapacityReservationFleetProps$Builder instance using the provided configuration.
  The function takes the CfnCapacityReservationFleetProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `allocationStrategy` | java.lang.String | [[cdk.support/lookup-entry]] | `:allocation-strategy` |
| `endDate` | java.lang.String | [[cdk.support/lookup-entry]] | `:end-date` |
| `instanceMatchCriteria` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-match-criteria` |
| `instanceTypeSpecifications` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:instance-type-specifications` |
| `noRemoveEndDate` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:no-remove-end-date` |
| `removeEndDate` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:remove-end-date` |
| `tagSpecifications` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:tag-specifications` |
| `tenancy` | java.lang.String | [[cdk.support/lookup-entry]] | `:tenancy` |
| `totalTargetCapacity` | java.lang.Number | [[cdk.support/lookup-entry]] | `:total-target-capacity` |
"
  [^CfnCapacityReservationFleetProps$Builder builder id config]
  (when-let [data (lookup-entry config id :allocation-strategy)]
    (. builder allocationStrategy data))
  (when-let [data (lookup-entry config id :end-date)]
    (. builder endDate data))
  (when-let [data (lookup-entry config id :instance-match-criteria)]
    (. builder instanceMatchCriteria data))
  (when-let [data (lookup-entry config id :instance-type-specifications)]
    (. builder instanceTypeSpecifications data))
  (when-let [data (lookup-entry config id :no-remove-end-date)]
    (. builder noRemoveEndDate data))
  (when-let [data (lookup-entry config id :remove-end-date)]
    (. builder removeEndDate data))
  (when-let [data (lookup-entry config id :tag-specifications)]
    (. builder tagSpecifications data))
  (when-let [data (lookup-entry config id :tenancy)]
    (. builder tenancy data))
  (when-let [data (lookup-entry config id :total-target-capacity)]
    (. builder totalTargetCapacity data))
  (.build builder))


(defn cfn-capacity-reservation-fleet-props-builder
  "Creates a  `CfnCapacityReservationFleetProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-capacity-reservation-fleet-props-builder (new CfnCapacityReservationFleetProps$Builder) id config))


(defn build-cfn-capacity-reservation-fleet-tag-specification-property-builder
  "The build-cfn-capacity-reservation-fleet-tag-specification-property-builder function updates a CfnCapacityReservationFleet$TagSpecificationProperty$Builder instance using the provided configuration.
  The function takes the CfnCapacityReservationFleet$TagSpecificationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `resourceType` | java.lang.String | [[cdk.support/lookup-entry]] | `:resource-type` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnCapacityReservationFleet$TagSpecificationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :resource-type)]
    (. builder resourceType data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-capacity-reservation-fleet-tag-specification-property-builder
  "Creates a  `CfnCapacityReservationFleet$TagSpecificationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-capacity-reservation-fleet-tag-specification-property-builder (new CfnCapacityReservationFleet$TagSpecificationProperty$Builder) id config))


(defn build-cfn-capacity-reservation-props-builder
  "The build-cfn-capacity-reservation-props-builder function updates a CfnCapacityReservationProps$Builder instance using the provided configuration.
  The function takes the CfnCapacityReservationProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `availabilityZone` | java.lang.String | [[cdk.support/lookup-entry]] | `:availability-zone` |
| `ebsOptimized` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:ebs-optimized` |
| `endDate` | java.lang.String | [[cdk.support/lookup-entry]] | `:end-date` |
| `endDateType` | java.lang.String | [[cdk.support/lookup-entry]] | `:end-date-type` |
| `ephemeralStorage` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:ephemeral-storage` |
| `instanceCount` | java.lang.Number | [[cdk.support/lookup-entry]] | `:instance-count` |
| `instanceMatchCriteria` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-match-criteria` |
| `instancePlatform` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-platform` |
| `instanceType` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-type` |
| `outPostArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:out-post-arn` |
| `placementGroupArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:placement-group-arn` |
| `tagSpecifications` | java.util.List | [[cdk.support/lookup-entry]] | `:tag-specifications` |
| `tenancy` | java.lang.String | [[cdk.support/lookup-entry]] | `:tenancy` |
"
  [^CfnCapacityReservationProps$Builder builder id config]
  (when-let [data (lookup-entry config id :availability-zone)]
    (. builder availabilityZone data))
  (when-let [data (lookup-entry config id :ebs-optimized)]
    (. builder ebsOptimized data))
  (when-let [data (lookup-entry config id :end-date)]
    (. builder endDate data))
  (when-let [data (lookup-entry config id :end-date-type)]
    (. builder endDateType data))
  (when-let [data (lookup-entry config id :ephemeral-storage)]
    (. builder ephemeralStorage data))
  (when-let [data (lookup-entry config id :instance-count)]
    (. builder instanceCount data))
  (when-let [data (lookup-entry config id :instance-match-criteria)]
    (. builder instanceMatchCriteria data))
  (when-let [data (lookup-entry config id :instance-platform)]
    (. builder instancePlatform data))
  (when-let [data (lookup-entry config id :instance-type)]
    (. builder instanceType data))
  (when-let [data (lookup-entry config id :out-post-arn)]
    (. builder outPostArn data))
  (when-let [data (lookup-entry config id :placement-group-arn)]
    (. builder placementGroupArn data))
  (when-let [data (lookup-entry config id :tag-specifications)]
    (. builder tagSpecifications data))
  (when-let [data (lookup-entry config id :tenancy)]
    (. builder tenancy data))
  (.build builder))


(defn cfn-capacity-reservation-props-builder
  "Creates a  `CfnCapacityReservationProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-capacity-reservation-props-builder (new CfnCapacityReservationProps$Builder) id config))


(defn build-cfn-capacity-reservation-tag-specification-property-builder
  "The build-cfn-capacity-reservation-tag-specification-property-builder function updates a CfnCapacityReservation$TagSpecificationProperty$Builder instance using the provided configuration.
  The function takes the CfnCapacityReservation$TagSpecificationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `resourceType` | java.lang.String | [[cdk.support/lookup-entry]] | `:resource-type` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnCapacityReservation$TagSpecificationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :resource-type)]
    (. builder resourceType data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-capacity-reservation-tag-specification-property-builder
  "Creates a  `CfnCapacityReservation$TagSpecificationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-capacity-reservation-tag-specification-property-builder (new CfnCapacityReservation$TagSpecificationProperty$Builder) id config))


(defn build-cfn-carrier-gateway-builder
  "The build-cfn-carrier-gateway-builder function updates a CfnCarrierGateway$Builder instance using the provided configuration.
  The function takes the CfnCarrierGateway$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `vpcId` | java.lang.String | [[cdk.support/lookup-entry]] | `:vpc-id` |
"
  [^CfnCarrierGateway$Builder builder id config]
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :vpc-id)]
    (. builder vpcId data))
  (.build builder))


(defn cfn-carrier-gateway-builder
  "Creates a  `CfnCarrierGateway$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-carrier-gateway-builder (CfnCarrierGateway$Builder/create scope (name id)) id config))


(defn build-cfn-carrier-gateway-props-builder
  "The build-cfn-carrier-gateway-props-builder function updates a CfnCarrierGatewayProps$Builder instance using the provided configuration.
  The function takes the CfnCarrierGatewayProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `vpcId` | java.lang.String | [[cdk.support/lookup-entry]] | `:vpc-id` |
"
  [^CfnCarrierGatewayProps$Builder builder id config]
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :vpc-id)]
    (. builder vpcId data))
  (.build builder))


(defn cfn-carrier-gateway-props-builder
  "Creates a  `CfnCarrierGatewayProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-carrier-gateway-props-builder (new CfnCarrierGatewayProps$Builder) id config))


(defn build-cfn-client-vpn-authorization-rule-builder
  "The build-cfn-client-vpn-authorization-rule-builder function updates a CfnClientVpnAuthorizationRule$Builder instance using the provided configuration.
  The function takes the CfnClientVpnAuthorizationRule$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `accessGroupId` | java.lang.String | [[cdk.support/lookup-entry]] | `:access-group-id` |
| `authorizeAllGroups` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:authorize-all-groups` |
| `clientVpnEndpointId` | java.lang.String | [[cdk.support/lookup-entry]] | `:client-vpn-endpoint-id` |
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `targetNetworkCidr` | java.lang.String | [[cdk.support/lookup-entry]] | `:target-network-cidr` |
"
  [^CfnClientVpnAuthorizationRule$Builder builder id config]
  (when-let [data (lookup-entry config id :access-group-id)]
    (. builder accessGroupId data))
  (when-let [data (lookup-entry config id :authorize-all-groups)]
    (. builder authorizeAllGroups data))
  (when-let [data (lookup-entry config id :client-vpn-endpoint-id)]
    (. builder clientVpnEndpointId data))
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :target-network-cidr)]
    (. builder targetNetworkCidr data))
  (.build builder))


(defn cfn-client-vpn-authorization-rule-builder
  "Creates a  `CfnClientVpnAuthorizationRule$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-client-vpn-authorization-rule-builder (CfnClientVpnAuthorizationRule$Builder/create scope (name id)) id config))


(defn build-cfn-client-vpn-authorization-rule-props-builder
  "The build-cfn-client-vpn-authorization-rule-props-builder function updates a CfnClientVpnAuthorizationRuleProps$Builder instance using the provided configuration.
  The function takes the CfnClientVpnAuthorizationRuleProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `accessGroupId` | java.lang.String | [[cdk.support/lookup-entry]] | `:access-group-id` |
| `authorizeAllGroups` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:authorize-all-groups` |
| `clientVpnEndpointId` | java.lang.String | [[cdk.support/lookup-entry]] | `:client-vpn-endpoint-id` |
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `targetNetworkCidr` | java.lang.String | [[cdk.support/lookup-entry]] | `:target-network-cidr` |
"
  [^CfnClientVpnAuthorizationRuleProps$Builder builder id config]
  (when-let [data (lookup-entry config id :access-group-id)]
    (. builder accessGroupId data))
  (when-let [data (lookup-entry config id :authorize-all-groups)]
    (. builder authorizeAllGroups data))
  (when-let [data (lookup-entry config id :client-vpn-endpoint-id)]
    (. builder clientVpnEndpointId data))
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :target-network-cidr)]
    (. builder targetNetworkCidr data))
  (.build builder))


(defn cfn-client-vpn-authorization-rule-props-builder
  "Creates a  `CfnClientVpnAuthorizationRuleProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-client-vpn-authorization-rule-props-builder (new CfnClientVpnAuthorizationRuleProps$Builder) id config))


(defn build-cfn-client-vpn-endpoint-builder
  "The build-cfn-client-vpn-endpoint-builder function updates a CfnClientVpnEndpoint$Builder instance using the provided configuration.
  The function takes the CfnClientVpnEndpoint$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `authenticationOptions` | java.util.List | [[cdk.support/lookup-entry]] | `:authentication-options` |
| `clientCidrBlock` | java.lang.String | [[cdk.support/lookup-entry]] | `:client-cidr-block` |
| `clientConnectOptions` | software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint$ClientConnectOptionsProperty | [[cdk.support/lookup-entry]] | `:client-connect-options` |
| `clientLoginBannerOptions` | software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint$ClientLoginBannerOptionsProperty | [[cdk.support/lookup-entry]] | `:client-login-banner-options` |
| `connectionLogOptions` | software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint$ConnectionLogOptionsProperty | [[cdk.support/lookup-entry]] | `:connection-log-options` |
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `dnsServers` | java.util.List | [[cdk.support/lookup-entry]] | `:dns-servers` |
| `securityGroupIds` | java.util.List | [[cdk.support/lookup-entry]] | `:security-group-ids` |
| `selfServicePortal` | java.lang.String | [[cdk.support/lookup-entry]] | `:self-service-portal` |
| `serverCertificateArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:server-certificate-arn` |
| `sessionTimeoutHours` | java.lang.Number | [[cdk.support/lookup-entry]] | `:session-timeout-hours` |
| `splitTunnel` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:split-tunnel` |
| `tagSpecifications` | java.util.List | [[cdk.support/lookup-entry]] | `:tag-specifications` |
| `transportProtocol` | java.lang.String | [[cdk.support/lookup-entry]] | `:transport-protocol` |
| `vpcId` | java.lang.String | [[cdk.support/lookup-entry]] | `:vpc-id` |
| `vpnPort` | java.lang.Number | [[cdk.support/lookup-entry]] | `:vpn-port` |
"
  [^CfnClientVpnEndpoint$Builder builder id config]
  (when-let [data (lookup-entry config id :authentication-options)]
    (. builder authenticationOptions data))
  (when-let [data (lookup-entry config id :client-cidr-block)]
    (. builder clientCidrBlock data))
  (when-let [data (lookup-entry config id :client-connect-options)]
    (. builder clientConnectOptions data))
  (when-let [data (lookup-entry config id :client-login-banner-options)]
    (. builder clientLoginBannerOptions data))
  (when-let [data (lookup-entry config id :connection-log-options)]
    (. builder connectionLogOptions data))
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :dns-servers)]
    (. builder dnsServers data))
  (when-let [data (lookup-entry config id :security-group-ids)]
    (. builder securityGroupIds data))
  (when-let [data (lookup-entry config id :self-service-portal)]
    (. builder selfServicePortal data))
  (when-let [data (lookup-entry config id :server-certificate-arn)]
    (. builder serverCertificateArn data))
  (when-let [data (lookup-entry config id :session-timeout-hours)]
    (. builder sessionTimeoutHours data))
  (when-let [data (lookup-entry config id :split-tunnel)]
    (. builder splitTunnel data))
  (when-let [data (lookup-entry config id :tag-specifications)]
    (. builder tagSpecifications data))
  (when-let [data (lookup-entry config id :transport-protocol)]
    (. builder transportProtocol data))
  (when-let [data (lookup-entry config id :vpc-id)]
    (. builder vpcId data))
  (when-let [data (lookup-entry config id :vpn-port)]
    (. builder vpnPort data))
  (.build builder))


(defn cfn-client-vpn-endpoint-builder
  "Creates a  `CfnClientVpnEndpoint$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-client-vpn-endpoint-builder (CfnClientVpnEndpoint$Builder/create scope (name id)) id config))


(defn build-cfn-client-vpn-endpoint-certificate-authentication-request-property-builder
  "The build-cfn-client-vpn-endpoint-certificate-authentication-request-property-builder function updates a CfnClientVpnEndpoint$CertificateAuthenticationRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnClientVpnEndpoint$CertificateAuthenticationRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `clientRootCertificateChainArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:client-root-certificate-chain-arn` |
"
  [^CfnClientVpnEndpoint$CertificateAuthenticationRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :client-root-certificate-chain-arn)]
    (. builder clientRootCertificateChainArn data))
  (.build builder))


(defn cfn-client-vpn-endpoint-certificate-authentication-request-property-builder
  "Creates a  `CfnClientVpnEndpoint$CertificateAuthenticationRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-client-vpn-endpoint-certificate-authentication-request-property-builder (new CfnClientVpnEndpoint$CertificateAuthenticationRequestProperty$Builder) id config))


(defn build-cfn-client-vpn-endpoint-client-authentication-request-property-builder
  "The build-cfn-client-vpn-endpoint-client-authentication-request-property-builder function updates a CfnClientVpnEndpoint$ClientAuthenticationRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnClientVpnEndpoint$ClientAuthenticationRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `activeDirectory` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:active-directory` |
| `federatedAuthentication` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:federated-authentication` |
| `mutualAuthentication` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:mutual-authentication` |
| `type` | java.lang.String | [[cdk.support/lookup-entry]] | `:type` |
"
  [^CfnClientVpnEndpoint$ClientAuthenticationRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :active-directory)]
    (. builder activeDirectory data))
  (when-let [data (lookup-entry config id :federated-authentication)]
    (. builder federatedAuthentication data))
  (when-let [data (lookup-entry config id :mutual-authentication)]
    (. builder mutualAuthentication data))
  (when-let [data (lookup-entry config id :type)]
    (. builder type data))
  (.build builder))


(defn cfn-client-vpn-endpoint-client-authentication-request-property-builder
  "Creates a  `CfnClientVpnEndpoint$ClientAuthenticationRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-client-vpn-endpoint-client-authentication-request-property-builder (new CfnClientVpnEndpoint$ClientAuthenticationRequestProperty$Builder) id config))


(defn build-cfn-client-vpn-endpoint-client-connect-options-property-builder
  "The build-cfn-client-vpn-endpoint-client-connect-options-property-builder function updates a CfnClientVpnEndpoint$ClientConnectOptionsProperty$Builder instance using the provided configuration.
  The function takes the CfnClientVpnEndpoint$ClientConnectOptionsProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `enabled` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:enabled` |
| `lambdaFunctionArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:lambda-function-arn` |
"
  [^CfnClientVpnEndpoint$ClientConnectOptionsProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :enabled)]
    (. builder enabled data))
  (when-let [data (lookup-entry config id :lambda-function-arn)]
    (. builder lambdaFunctionArn data))
  (.build builder))


(defn cfn-client-vpn-endpoint-client-connect-options-property-builder
  "Creates a  `CfnClientVpnEndpoint$ClientConnectOptionsProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-client-vpn-endpoint-client-connect-options-property-builder (new CfnClientVpnEndpoint$ClientConnectOptionsProperty$Builder) id config))


(defn build-cfn-client-vpn-endpoint-client-login-banner-options-property-builder
  "The build-cfn-client-vpn-endpoint-client-login-banner-options-property-builder function updates a CfnClientVpnEndpoint$ClientLoginBannerOptionsProperty$Builder instance using the provided configuration.
  The function takes the CfnClientVpnEndpoint$ClientLoginBannerOptionsProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `bannerText` | java.lang.String | [[cdk.support/lookup-entry]] | `:banner-text` |
| `enabled` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:enabled` |
"
  [^CfnClientVpnEndpoint$ClientLoginBannerOptionsProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :banner-text)]
    (. builder bannerText data))
  (when-let [data (lookup-entry config id :enabled)]
    (. builder enabled data))
  (.build builder))


(defn cfn-client-vpn-endpoint-client-login-banner-options-property-builder
  "Creates a  `CfnClientVpnEndpoint$ClientLoginBannerOptionsProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-client-vpn-endpoint-client-login-banner-options-property-builder (new CfnClientVpnEndpoint$ClientLoginBannerOptionsProperty$Builder) id config))


(defn build-cfn-client-vpn-endpoint-connection-log-options-property-builder
  "The build-cfn-client-vpn-endpoint-connection-log-options-property-builder function updates a CfnClientVpnEndpoint$ConnectionLogOptionsProperty$Builder instance using the provided configuration.
  The function takes the CfnClientVpnEndpoint$ConnectionLogOptionsProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `cloudwatchLogGroup` | java.lang.String | [[cdk.support/lookup-entry]] | `:cloudwatch-log-group` |
| `cloudwatchLogStream` | java.lang.String | [[cdk.support/lookup-entry]] | `:cloudwatch-log-stream` |
| `enabled` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:enabled` |
"
  [^CfnClientVpnEndpoint$ConnectionLogOptionsProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :cloudwatch-log-group)]
    (. builder cloudwatchLogGroup data))
  (when-let [data (lookup-entry config id :cloudwatch-log-stream)]
    (. builder cloudwatchLogStream data))
  (when-let [data (lookup-entry config id :enabled)]
    (. builder enabled data))
  (.build builder))


(defn cfn-client-vpn-endpoint-connection-log-options-property-builder
  "Creates a  `CfnClientVpnEndpoint$ConnectionLogOptionsProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-client-vpn-endpoint-connection-log-options-property-builder (new CfnClientVpnEndpoint$ConnectionLogOptionsProperty$Builder) id config))


(defn build-cfn-client-vpn-endpoint-directory-service-authentication-request-property-builder
  "The build-cfn-client-vpn-endpoint-directory-service-authentication-request-property-builder function updates a CfnClientVpnEndpoint$DirectoryServiceAuthenticationRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnClientVpnEndpoint$DirectoryServiceAuthenticationRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `directoryId` | java.lang.String | [[cdk.support/lookup-entry]] | `:directory-id` |
"
  [^CfnClientVpnEndpoint$DirectoryServiceAuthenticationRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :directory-id)]
    (. builder directoryId data))
  (.build builder))


(defn cfn-client-vpn-endpoint-directory-service-authentication-request-property-builder
  "Creates a  `CfnClientVpnEndpoint$DirectoryServiceAuthenticationRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-client-vpn-endpoint-directory-service-authentication-request-property-builder (new CfnClientVpnEndpoint$DirectoryServiceAuthenticationRequestProperty$Builder) id config))


(defn build-cfn-client-vpn-endpoint-federated-authentication-request-property-builder
  "The build-cfn-client-vpn-endpoint-federated-authentication-request-property-builder function updates a CfnClientVpnEndpoint$FederatedAuthenticationRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnClientVpnEndpoint$FederatedAuthenticationRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `samlProviderArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:saml-provider-arn` |
| `selfServiceSamlProviderArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:self-service-saml-provider-arn` |
"
  [^CfnClientVpnEndpoint$FederatedAuthenticationRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :saml-provider-arn)]
    (. builder samlProviderArn data))
  (when-let [data (lookup-entry config id :self-service-saml-provider-arn)]
    (. builder selfServiceSamlProviderArn data))
  (.build builder))


(defn cfn-client-vpn-endpoint-federated-authentication-request-property-builder
  "Creates a  `CfnClientVpnEndpoint$FederatedAuthenticationRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-client-vpn-endpoint-federated-authentication-request-property-builder (new CfnClientVpnEndpoint$FederatedAuthenticationRequestProperty$Builder) id config))


(defn build-cfn-client-vpn-endpoint-props-builder
  "The build-cfn-client-vpn-endpoint-props-builder function updates a CfnClientVpnEndpointProps$Builder instance using the provided configuration.
  The function takes the CfnClientVpnEndpointProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `authenticationOptions` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:authentication-options` |
| `clientCidrBlock` | java.lang.String | [[cdk.support/lookup-entry]] | `:client-cidr-block` |
| `clientConnectOptions` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:client-connect-options` |
| `clientLoginBannerOptions` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:client-login-banner-options` |
| `connectionLogOptions` | software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint$ConnectionLogOptionsProperty | [[cdk.support/lookup-entry]] | `:connection-log-options` |
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `dnsServers` | java.util.List | [[cdk.support/lookup-entry]] | `:dns-servers` |
| `securityGroupIds` | java.util.List | [[cdk.support/lookup-entry]] | `:security-group-ids` |
| `selfServicePortal` | java.lang.String | [[cdk.support/lookup-entry]] | `:self-service-portal` |
| `serverCertificateArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:server-certificate-arn` |
| `sessionTimeoutHours` | java.lang.Number | [[cdk.support/lookup-entry]] | `:session-timeout-hours` |
| `splitTunnel` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:split-tunnel` |
| `tagSpecifications` | java.util.List | [[cdk.support/lookup-entry]] | `:tag-specifications` |
| `transportProtocol` | java.lang.String | [[cdk.support/lookup-entry]] | `:transport-protocol` |
| `vpcId` | java.lang.String | [[cdk.support/lookup-entry]] | `:vpc-id` |
| `vpnPort` | java.lang.Number | [[cdk.support/lookup-entry]] | `:vpn-port` |
"
  [^CfnClientVpnEndpointProps$Builder builder id config]
  (when-let [data (lookup-entry config id :authentication-options)]
    (. builder authenticationOptions data))
  (when-let [data (lookup-entry config id :client-cidr-block)]
    (. builder clientCidrBlock data))
  (when-let [data (lookup-entry config id :client-connect-options)]
    (. builder clientConnectOptions data))
  (when-let [data (lookup-entry config id :client-login-banner-options)]
    (. builder clientLoginBannerOptions data))
  (when-let [data (lookup-entry config id :connection-log-options)]
    (. builder connectionLogOptions data))
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :dns-servers)]
    (. builder dnsServers data))
  (when-let [data (lookup-entry config id :security-group-ids)]
    (. builder securityGroupIds data))
  (when-let [data (lookup-entry config id :self-service-portal)]
    (. builder selfServicePortal data))
  (when-let [data (lookup-entry config id :server-certificate-arn)]
    (. builder serverCertificateArn data))
  (when-let [data (lookup-entry config id :session-timeout-hours)]
    (. builder sessionTimeoutHours data))
  (when-let [data (lookup-entry config id :split-tunnel)]
    (. builder splitTunnel data))
  (when-let [data (lookup-entry config id :tag-specifications)]
    (. builder tagSpecifications data))
  (when-let [data (lookup-entry config id :transport-protocol)]
    (. builder transportProtocol data))
  (when-let [data (lookup-entry config id :vpc-id)]
    (. builder vpcId data))
  (when-let [data (lookup-entry config id :vpn-port)]
    (. builder vpnPort data))
  (.build builder))


(defn cfn-client-vpn-endpoint-props-builder
  "Creates a  `CfnClientVpnEndpointProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-client-vpn-endpoint-props-builder (new CfnClientVpnEndpointProps$Builder) id config))


(defn build-cfn-client-vpn-endpoint-tag-specification-property-builder
  "The build-cfn-client-vpn-endpoint-tag-specification-property-builder function updates a CfnClientVpnEndpoint$TagSpecificationProperty$Builder instance using the provided configuration.
  The function takes the CfnClientVpnEndpoint$TagSpecificationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `resourceType` | java.lang.String | [[cdk.support/lookup-entry]] | `:resource-type` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnClientVpnEndpoint$TagSpecificationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :resource-type)]
    (. builder resourceType data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-client-vpn-endpoint-tag-specification-property-builder
  "Creates a  `CfnClientVpnEndpoint$TagSpecificationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-client-vpn-endpoint-tag-specification-property-builder (new CfnClientVpnEndpoint$TagSpecificationProperty$Builder) id config))


(defn build-cfn-client-vpn-route-builder
  "The build-cfn-client-vpn-route-builder function updates a CfnClientVpnRoute$Builder instance using the provided configuration.
  The function takes the CfnClientVpnRoute$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `clientVpnEndpointId` | java.lang.String | [[cdk.support/lookup-entry]] | `:client-vpn-endpoint-id` |
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `destinationCidrBlock` | java.lang.String | [[cdk.support/lookup-entry]] | `:destination-cidr-block` |
| `targetVpcSubnetId` | java.lang.String | [[cdk.support/lookup-entry]] | `:target-vpc-subnet-id` |
"
  [^CfnClientVpnRoute$Builder builder id config]
  (when-let [data (lookup-entry config id :client-vpn-endpoint-id)]
    (. builder clientVpnEndpointId data))
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :destination-cidr-block)]
    (. builder destinationCidrBlock data))
  (when-let [data (lookup-entry config id :target-vpc-subnet-id)]
    (. builder targetVpcSubnetId data))
  (.build builder))


(defn cfn-client-vpn-route-builder
  "Creates a  `CfnClientVpnRoute$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-client-vpn-route-builder (CfnClientVpnRoute$Builder/create scope (name id)) id config))


(defn build-cfn-client-vpn-route-props-builder
  "The build-cfn-client-vpn-route-props-builder function updates a CfnClientVpnRouteProps$Builder instance using the provided configuration.
  The function takes the CfnClientVpnRouteProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `clientVpnEndpointId` | java.lang.String | [[cdk.support/lookup-entry]] | `:client-vpn-endpoint-id` |
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `destinationCidrBlock` | java.lang.String | [[cdk.support/lookup-entry]] | `:destination-cidr-block` |
| `targetVpcSubnetId` | java.lang.String | [[cdk.support/lookup-entry]] | `:target-vpc-subnet-id` |
"
  [^CfnClientVpnRouteProps$Builder builder id config]
  (when-let [data (lookup-entry config id :client-vpn-endpoint-id)]
    (. builder clientVpnEndpointId data))
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :destination-cidr-block)]
    (. builder destinationCidrBlock data))
  (when-let [data (lookup-entry config id :target-vpc-subnet-id)]
    (. builder targetVpcSubnetId data))
  (.build builder))


(defn cfn-client-vpn-route-props-builder
  "Creates a  `CfnClientVpnRouteProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-client-vpn-route-props-builder (new CfnClientVpnRouteProps$Builder) id config))


(defn build-cfn-client-vpn-target-network-association-builder
  "The build-cfn-client-vpn-target-network-association-builder function updates a CfnClientVpnTargetNetworkAssociation$Builder instance using the provided configuration.
  The function takes the CfnClientVpnTargetNetworkAssociation$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `clientVpnEndpointId` | java.lang.String | [[cdk.support/lookup-entry]] | `:client-vpn-endpoint-id` |
| `subnetId` | java.lang.String | [[cdk.support/lookup-entry]] | `:subnet-id` |
"
  [^CfnClientVpnTargetNetworkAssociation$Builder builder id config]
  (when-let [data (lookup-entry config id :client-vpn-endpoint-id)]
    (. builder clientVpnEndpointId data))
  (when-let [data (lookup-entry config id :subnet-id)]
    (. builder subnetId data))
  (.build builder))


(defn cfn-client-vpn-target-network-association-builder
  "Creates a  `CfnClientVpnTargetNetworkAssociation$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-client-vpn-target-network-association-builder (CfnClientVpnTargetNetworkAssociation$Builder/create scope (name id)) id config))


(defn build-cfn-client-vpn-target-network-association-props-builder
  "The build-cfn-client-vpn-target-network-association-props-builder function updates a CfnClientVpnTargetNetworkAssociationProps$Builder instance using the provided configuration.
  The function takes the CfnClientVpnTargetNetworkAssociationProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `clientVpnEndpointId` | java.lang.String | [[cdk.support/lookup-entry]] | `:client-vpn-endpoint-id` |
| `subnetId` | java.lang.String | [[cdk.support/lookup-entry]] | `:subnet-id` |
"
  [^CfnClientVpnTargetNetworkAssociationProps$Builder builder id config]
  (when-let [data (lookup-entry config id :client-vpn-endpoint-id)]
    (. builder clientVpnEndpointId data))
  (when-let [data (lookup-entry config id :subnet-id)]
    (. builder subnetId data))
  (.build builder))


(defn cfn-client-vpn-target-network-association-props-builder
  "Creates a  `CfnClientVpnTargetNetworkAssociationProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-client-vpn-target-network-association-props-builder (new CfnClientVpnTargetNetworkAssociationProps$Builder) id config))


(defn build-cfn-customer-gateway-builder
  "The build-cfn-customer-gateway-builder function updates a CfnCustomerGateway$Builder instance using the provided configuration.
  The function takes the CfnCustomerGateway$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `bgpAsn` | java.lang.Number | [[cdk.support/lookup-entry]] | `:bgp-asn` |
| `certificateArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:certificate-arn` |
| `deviceName` | java.lang.String | [[cdk.support/lookup-entry]] | `:device-name` |
| `ipAddress` | java.lang.String | [[cdk.support/lookup-entry]] | `:ip-address` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `type` | java.lang.String | [[cdk.support/lookup-entry]] | `:type` |
"
  [^CfnCustomerGateway$Builder builder id config]
  (when-let [data (lookup-entry config id :bgp-asn)]
    (. builder bgpAsn data))
  (when-let [data (lookup-entry config id :certificate-arn)]
    (. builder certificateArn data))
  (when-let [data (lookup-entry config id :device-name)]
    (. builder deviceName data))
  (when-let [data (lookup-entry config id :ip-address)]
    (. builder ipAddress data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :type)]
    (. builder type data))
  (.build builder))


(defn cfn-customer-gateway-builder
  "Creates a  `CfnCustomerGateway$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-customer-gateway-builder (CfnCustomerGateway$Builder/create scope (name id)) id config))


(defn build-cfn-customer-gateway-props-builder
  "The build-cfn-customer-gateway-props-builder function updates a CfnCustomerGatewayProps$Builder instance using the provided configuration.
  The function takes the CfnCustomerGatewayProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `bgpAsn` | java.lang.Number | [[cdk.support/lookup-entry]] | `:bgp-asn` |
| `certificateArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:certificate-arn` |
| `deviceName` | java.lang.String | [[cdk.support/lookup-entry]] | `:device-name` |
| `ipAddress` | java.lang.String | [[cdk.support/lookup-entry]] | `:ip-address` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `type` | java.lang.String | [[cdk.support/lookup-entry]] | `:type` |
"
  [^CfnCustomerGatewayProps$Builder builder id config]
  (when-let [data (lookup-entry config id :bgp-asn)]
    (. builder bgpAsn data))
  (when-let [data (lookup-entry config id :certificate-arn)]
    (. builder certificateArn data))
  (when-let [data (lookup-entry config id :device-name)]
    (. builder deviceName data))
  (when-let [data (lookup-entry config id :ip-address)]
    (. builder ipAddress data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :type)]
    (. builder type data))
  (.build builder))


(defn cfn-customer-gateway-props-builder
  "Creates a  `CfnCustomerGatewayProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-customer-gateway-props-builder (new CfnCustomerGatewayProps$Builder) id config))


(defn build-cfn-dhcp-options-builder
  "The build-cfn-dhcp-options-builder function updates a CfnDHCPOptions$Builder instance using the provided configuration.
  The function takes the CfnDHCPOptions$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `domainName` | java.lang.String | [[cdk.support/lookup-entry]] | `:domain-name` |
| `domainNameServers` | java.util.List | [[cdk.support/lookup-entry]] | `:domain-name-servers` |
| `ipv6AddressPreferredLeaseTime` | java.lang.Number | [[cdk.support/lookup-entry]] | `:ipv6-address-preferred-lease-time` |
| `netbiosNameServers` | java.util.List | [[cdk.support/lookup-entry]] | `:netbios-name-servers` |
| `netbiosNodeType` | java.lang.Number | [[cdk.support/lookup-entry]] | `:netbios-node-type` |
| `ntpServers` | java.util.List | [[cdk.support/lookup-entry]] | `:ntp-servers` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnDHCPOptions$Builder builder id config]
  (when-let [data (lookup-entry config id :domain-name)]
    (. builder domainName data))
  (when-let [data (lookup-entry config id :domain-name-servers)]
    (. builder domainNameServers data))
  (when-let [data (lookup-entry config id :ipv6-address-preferred-lease-time)]
    (. builder ipv6AddressPreferredLeaseTime data))
  (when-let [data (lookup-entry config id :netbios-name-servers)]
    (. builder netbiosNameServers data))
  (when-let [data (lookup-entry config id :netbios-node-type)]
    (. builder netbiosNodeType data))
  (when-let [data (lookup-entry config id :ntp-servers)]
    (. builder ntpServers data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-dhcp-options-builder
  "Creates a  `CfnDHCPOptions$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-dhcp-options-builder (CfnDHCPOptions$Builder/create scope (name id)) id config))


(defn build-cfn-dhcp-options-props-builder
  "The build-cfn-dhcp-options-props-builder function updates a CfnDHCPOptionsProps$Builder instance using the provided configuration.
  The function takes the CfnDHCPOptionsProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `domainName` | java.lang.String | [[cdk.support/lookup-entry]] | `:domain-name` |
| `domainNameServers` | java.util.List | [[cdk.support/lookup-entry]] | `:domain-name-servers` |
| `ipv6AddressPreferredLeaseTime` | java.lang.Number | [[cdk.support/lookup-entry]] | `:ipv6-address-preferred-lease-time` |
| `netbiosNameServers` | java.util.List | [[cdk.support/lookup-entry]] | `:netbios-name-servers` |
| `netbiosNodeType` | java.lang.Number | [[cdk.support/lookup-entry]] | `:netbios-node-type` |
| `ntpServers` | java.util.List | [[cdk.support/lookup-entry]] | `:ntp-servers` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnDHCPOptionsProps$Builder builder id config]
  (when-let [data (lookup-entry config id :domain-name)]
    (. builder domainName data))
  (when-let [data (lookup-entry config id :domain-name-servers)]
    (. builder domainNameServers data))
  (when-let [data (lookup-entry config id :ipv6-address-preferred-lease-time)]
    (. builder ipv6AddressPreferredLeaseTime data))
  (when-let [data (lookup-entry config id :netbios-name-servers)]
    (. builder netbiosNameServers data))
  (when-let [data (lookup-entry config id :netbios-node-type)]
    (. builder netbiosNodeType data))
  (when-let [data (lookup-entry config id :ntp-servers)]
    (. builder ntpServers data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-dhcp-options-props-builder
  "Creates a  `CfnDHCPOptionsProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-dhcp-options-props-builder (new CfnDHCPOptionsProps$Builder) id config))


(defn build-cfn-ec2-fleet-accelerator-count-request-property-builder
  "The build-cfn-ec2-fleet-accelerator-count-request-property-builder function updates a CfnEC2Fleet$AcceleratorCountRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnEC2Fleet$AcceleratorCountRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `max` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max` |
| `min` | java.lang.Number | [[cdk.support/lookup-entry]] | `:min` |
"
  [^CfnEC2Fleet$AcceleratorCountRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :max)]
    (. builder max data))
  (when-let [data (lookup-entry config id :min)]
    (. builder min data))
  (.build builder))


(defn cfn-ec2-fleet-accelerator-count-request-property-builder
  "Creates a  `CfnEC2Fleet$AcceleratorCountRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-ec2-fleet-accelerator-count-request-property-builder (new CfnEC2Fleet$AcceleratorCountRequestProperty$Builder) id config))


(defn build-cfn-ec2-fleet-accelerator-total-memory-mi-b-request-property-builder
  "The build-cfn-ec2-fleet-accelerator-total-memory-mi-b-request-property-builder function updates a CfnEC2Fleet$AcceleratorTotalMemoryMiBRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnEC2Fleet$AcceleratorTotalMemoryMiBRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `max` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max` |
| `min` | java.lang.Number | [[cdk.support/lookup-entry]] | `:min` |
"
  [^CfnEC2Fleet$AcceleratorTotalMemoryMiBRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :max)]
    (. builder max data))
  (when-let [data (lookup-entry config id :min)]
    (. builder min data))
  (.build builder))


(defn cfn-ec2-fleet-accelerator-total-memory-mi-b-request-property-builder
  "Creates a  `CfnEC2Fleet$AcceleratorTotalMemoryMiBRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-ec2-fleet-accelerator-total-memory-mi-b-request-property-builder (new CfnEC2Fleet$AcceleratorTotalMemoryMiBRequestProperty$Builder) id config))


(defn build-cfn-ec2-fleet-baseline-ebs-bandwidth-mbps-request-property-builder
  "The build-cfn-ec2-fleet-baseline-ebs-bandwidth-mbps-request-property-builder function updates a CfnEC2Fleet$BaselineEbsBandwidthMbpsRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnEC2Fleet$BaselineEbsBandwidthMbpsRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `max` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max` |
| `min` | java.lang.Number | [[cdk.support/lookup-entry]] | `:min` |
"
  [^CfnEC2Fleet$BaselineEbsBandwidthMbpsRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :max)]
    (. builder max data))
  (when-let [data (lookup-entry config id :min)]
    (. builder min data))
  (.build builder))


(defn cfn-ec2-fleet-baseline-ebs-bandwidth-mbps-request-property-builder
  "Creates a  `CfnEC2Fleet$BaselineEbsBandwidthMbpsRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-ec2-fleet-baseline-ebs-bandwidth-mbps-request-property-builder (new CfnEC2Fleet$BaselineEbsBandwidthMbpsRequestProperty$Builder) id config))


(defn build-cfn-ec2-fleet-builder
  "The build-cfn-ec2-fleet-builder function updates a CfnEC2Fleet$Builder instance using the provided configuration.
  The function takes the CfnEC2Fleet$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `context` | java.lang.String | [[cdk.support/lookup-entry]] | `:context` |
| `excessCapacityTerminationPolicy` | java.lang.String | [[cdk.support/lookup-entry]] | `:excess-capacity-termination-policy` |
| `launchTemplateConfigs` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:launch-template-configs` |
| `onDemandOptions` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:on-demand-options` |
| `replaceUnhealthyInstances` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:replace-unhealthy-instances` |
| `spotOptions` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:spot-options` |
| `tagSpecifications` | java.util.List | [[cdk.support/lookup-entry]] | `:tag-specifications` |
| `targetCapacitySpecification` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:target-capacity-specification` |
| `terminateInstancesWithExpiration` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:terminate-instances-with-expiration` |
| `type` | java.lang.String | [[cdk.support/lookup-entry]] | `:type` |
| `validFrom` | java.lang.String | [[cdk.support/lookup-entry]] | `:valid-from` |
| `validUntil` | java.lang.String | [[cdk.support/lookup-entry]] | `:valid-until` |
"
  [^CfnEC2Fleet$Builder builder id config]
  (when-let [data (lookup-entry config id :context)]
    (. builder context data))
  (when-let [data (lookup-entry config id :excess-capacity-termination-policy)]
    (. builder excessCapacityTerminationPolicy data))
  (when-let [data (lookup-entry config id :launch-template-configs)]
    (. builder launchTemplateConfigs data))
  (when-let [data (lookup-entry config id :on-demand-options)]
    (. builder onDemandOptions data))
  (when-let [data (lookup-entry config id :replace-unhealthy-instances)]
    (. builder replaceUnhealthyInstances data))
  (when-let [data (lookup-entry config id :spot-options)]
    (. builder spotOptions data))
  (when-let [data (lookup-entry config id :tag-specifications)]
    (. builder tagSpecifications data))
  (when-let [data (lookup-entry config id :target-capacity-specification)]
    (. builder targetCapacitySpecification data))
  (when-let [data (lookup-entry config id :terminate-instances-with-expiration)]
    (. builder terminateInstancesWithExpiration data))
  (when-let [data (lookup-entry config id :type)]
    (. builder type data))
  (when-let [data (lookup-entry config id :valid-from)]
    (. builder validFrom data))
  (when-let [data (lookup-entry config id :valid-until)]
    (. builder validUntil data))
  (.build builder))


(defn cfn-ec2-fleet-builder
  "Creates a  `CfnEC2Fleet$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-ec2-fleet-builder (CfnEC2Fleet$Builder/create scope (name id)) id config))


(defn build-cfn-ec2-fleet-capacity-rebalance-property-builder
  "The build-cfn-ec2-fleet-capacity-rebalance-property-builder function updates a CfnEC2Fleet$CapacityRebalanceProperty$Builder instance using the provided configuration.
  The function takes the CfnEC2Fleet$CapacityRebalanceProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `replacementStrategy` | java.lang.String | [[cdk.support/lookup-entry]] | `:replacement-strategy` |
| `terminationDelay` | java.lang.Number | [[cdk.support/lookup-entry]] | `:termination-delay` |
"
  [^CfnEC2Fleet$CapacityRebalanceProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :replacement-strategy)]
    (. builder replacementStrategy data))
  (when-let [data (lookup-entry config id :termination-delay)]
    (. builder terminationDelay data))
  (.build builder))


(defn cfn-ec2-fleet-capacity-rebalance-property-builder
  "Creates a  `CfnEC2Fleet$CapacityRebalanceProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-ec2-fleet-capacity-rebalance-property-builder (new CfnEC2Fleet$CapacityRebalanceProperty$Builder) id config))


(defn build-cfn-ec2-fleet-capacity-reservation-options-request-property-builder
  "The build-cfn-ec2-fleet-capacity-reservation-options-request-property-builder function updates a CfnEC2Fleet$CapacityReservationOptionsRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnEC2Fleet$CapacityReservationOptionsRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `usageStrategy` | java.lang.String | [[cdk.support/lookup-entry]] | `:usage-strategy` |
"
  [^CfnEC2Fleet$CapacityReservationOptionsRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :usage-strategy)]
    (. builder usageStrategy data))
  (.build builder))


(defn cfn-ec2-fleet-capacity-reservation-options-request-property-builder
  "Creates a  `CfnEC2Fleet$CapacityReservationOptionsRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-ec2-fleet-capacity-reservation-options-request-property-builder (new CfnEC2Fleet$CapacityReservationOptionsRequestProperty$Builder) id config))


(defn build-cfn-ec2-fleet-fleet-launch-template-config-request-property-builder
  "The build-cfn-ec2-fleet-fleet-launch-template-config-request-property-builder function updates a CfnEC2Fleet$FleetLaunchTemplateConfigRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnEC2Fleet$FleetLaunchTemplateConfigRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `launchTemplateSpecification` | software.amazon.awscdk.services.ec2.CfnEC2Fleet$FleetLaunchTemplateSpecificationRequestProperty | [[cdk.support/lookup-entry]] | `:launch-template-specification` |
| `overrides` | java.util.List | [[cdk.support/lookup-entry]] | `:overrides` |
"
  [^CfnEC2Fleet$FleetLaunchTemplateConfigRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :launch-template-specification)]
    (. builder launchTemplateSpecification data))
  (when-let [data (lookup-entry config id :overrides)]
    (. builder overrides data))
  (.build builder))


(defn cfn-ec2-fleet-fleet-launch-template-config-request-property-builder
  "Creates a  `CfnEC2Fleet$FleetLaunchTemplateConfigRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-ec2-fleet-fleet-launch-template-config-request-property-builder (new CfnEC2Fleet$FleetLaunchTemplateConfigRequestProperty$Builder) id config))


(defn build-cfn-ec2-fleet-fleet-launch-template-overrides-request-property-builder
  "The build-cfn-ec2-fleet-fleet-launch-template-overrides-request-property-builder function updates a CfnEC2Fleet$FleetLaunchTemplateOverridesRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnEC2Fleet$FleetLaunchTemplateOverridesRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `availabilityZone` | java.lang.String | [[cdk.support/lookup-entry]] | `:availability-zone` |
| `instanceRequirements` | software.amazon.awscdk.services.ec2.CfnEC2Fleet$InstanceRequirementsRequestProperty | [[cdk.support/lookup-entry]] | `:instance-requirements` |
| `instanceType` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-type` |
| `maxPrice` | java.lang.String | [[cdk.support/lookup-entry]] | `:max-price` |
| `placement` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:placement` |
| `priority` | java.lang.Number | [[cdk.support/lookup-entry]] | `:priority` |
| `subnetId` | java.lang.String | [[cdk.support/lookup-entry]] | `:subnet-id` |
| `weightedCapacity` | java.lang.Number | [[cdk.support/lookup-entry]] | `:weighted-capacity` |
"
  [^CfnEC2Fleet$FleetLaunchTemplateOverridesRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :availability-zone)]
    (. builder availabilityZone data))
  (when-let [data (lookup-entry config id :instance-requirements)]
    (. builder instanceRequirements data))
  (when-let [data (lookup-entry config id :instance-type)]
    (. builder instanceType data))
  (when-let [data (lookup-entry config id :max-price)]
    (. builder maxPrice data))
  (when-let [data (lookup-entry config id :placement)]
    (. builder placement data))
  (when-let [data (lookup-entry config id :priority)]
    (. builder priority data))
  (when-let [data (lookup-entry config id :subnet-id)]
    (. builder subnetId data))
  (when-let [data (lookup-entry config id :weighted-capacity)]
    (. builder weightedCapacity data))
  (.build builder))


(defn cfn-ec2-fleet-fleet-launch-template-overrides-request-property-builder
  "Creates a  `CfnEC2Fleet$FleetLaunchTemplateOverridesRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-ec2-fleet-fleet-launch-template-overrides-request-property-builder (new CfnEC2Fleet$FleetLaunchTemplateOverridesRequestProperty$Builder) id config))


(defn build-cfn-ec2-fleet-fleet-launch-template-specification-request-property-builder
  "The build-cfn-ec2-fleet-fleet-launch-template-specification-request-property-builder function updates a CfnEC2Fleet$FleetLaunchTemplateSpecificationRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnEC2Fleet$FleetLaunchTemplateSpecificationRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `launchTemplateId` | java.lang.String | [[cdk.support/lookup-entry]] | `:launch-template-id` |
| `launchTemplateName` | java.lang.String | [[cdk.support/lookup-entry]] | `:launch-template-name` |
| `version` | java.lang.String | [[cdk.support/lookup-entry]] | `:version` |
"
  [^CfnEC2Fleet$FleetLaunchTemplateSpecificationRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :launch-template-id)]
    (. builder launchTemplateId data))
  (when-let [data (lookup-entry config id :launch-template-name)]
    (. builder launchTemplateName data))
  (when-let [data (lookup-entry config id :version)]
    (. builder version data))
  (.build builder))


(defn cfn-ec2-fleet-fleet-launch-template-specification-request-property-builder
  "Creates a  `CfnEC2Fleet$FleetLaunchTemplateSpecificationRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-ec2-fleet-fleet-launch-template-specification-request-property-builder (new CfnEC2Fleet$FleetLaunchTemplateSpecificationRequestProperty$Builder) id config))


(defn build-cfn-ec2-fleet-instance-requirements-request-property-builder
  "The build-cfn-ec2-fleet-instance-requirements-request-property-builder function updates a CfnEC2Fleet$InstanceRequirementsRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnEC2Fleet$InstanceRequirementsRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `acceleratorCount` | software.amazon.awscdk.services.ec2.CfnEC2Fleet$AcceleratorCountRequestProperty | [[cdk.support/lookup-entry]] | `:accelerator-count` |
| `acceleratorManufacturers` | java.util.List | [[cdk.support/lookup-entry]] | `:accelerator-manufacturers` |
| `acceleratorNames` | java.util.List | [[cdk.support/lookup-entry]] | `:accelerator-names` |
| `acceleratorTotalMemoryMiB` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:accelerator-total-memory-mi-b` |
| `acceleratorTypes` | java.util.List | [[cdk.support/lookup-entry]] | `:accelerator-types` |
| `allowedInstanceTypes` | java.util.List | [[cdk.support/lookup-entry]] | `:allowed-instance-types` |
| `bareMetal` | java.lang.String | [[cdk.support/lookup-entry]] | `:bare-metal` |
| `baselineEbsBandwidthMbps` | software.amazon.awscdk.services.ec2.CfnEC2Fleet$BaselineEbsBandwidthMbpsRequestProperty | [[cdk.support/lookup-entry]] | `:baseline-ebs-bandwidth-mbps` |
| `burstablePerformance` | java.lang.String | [[cdk.support/lookup-entry]] | `:burstable-performance` |
| `cpuManufacturers` | java.util.List | [[cdk.support/lookup-entry]] | `:cpu-manufacturers` |
| `excludedInstanceTypes` | java.util.List | [[cdk.support/lookup-entry]] | `:excluded-instance-types` |
| `instanceGenerations` | java.util.List | [[cdk.support/lookup-entry]] | `:instance-generations` |
| `localStorage` | java.lang.String | [[cdk.support/lookup-entry]] | `:local-storage` |
| `localStorageTypes` | java.util.List | [[cdk.support/lookup-entry]] | `:local-storage-types` |
| `maxSpotPriceAsPercentageOfOptimalOnDemandPrice` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max-spot-price-as-percentage-of-optimal-on-demand-price` |
| `memoryGiBPerVCpu` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:memory-gi-b-per-v-cpu` |
| `memoryMiB` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:memory-mi-b` |
| `networkBandwidthGbps` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:network-bandwidth-gbps` |
| `networkInterfaceCount` | software.amazon.awscdk.services.ec2.CfnEC2Fleet$NetworkInterfaceCountRequestProperty | [[cdk.support/lookup-entry]] | `:network-interface-count` |
| `onDemandMaxPricePercentageOverLowestPrice` | java.lang.Number | [[cdk.support/lookup-entry]] | `:on-demand-max-price-percentage-over-lowest-price` |
| `requireHibernateSupport` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:require-hibernate-support` |
| `spotMaxPricePercentageOverLowestPrice` | java.lang.Number | [[cdk.support/lookup-entry]] | `:spot-max-price-percentage-over-lowest-price` |
| `totalLocalStorageGb` | software.amazon.awscdk.services.ec2.CfnEC2Fleet$TotalLocalStorageGBRequestProperty | [[cdk.support/lookup-entry]] | `:total-local-storage-gb` |
| `vCpuCount` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:v-cpu-count` |
"
  [^CfnEC2Fleet$InstanceRequirementsRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :accelerator-count)]
    (. builder acceleratorCount data))
  (when-let [data (lookup-entry config id :accelerator-manufacturers)]
    (. builder acceleratorManufacturers data))
  (when-let [data (lookup-entry config id :accelerator-names)]
    (. builder acceleratorNames data))
  (when-let [data (lookup-entry config id :accelerator-total-memory-mi-b)]
    (. builder acceleratorTotalMemoryMiB data))
  (when-let [data (lookup-entry config id :accelerator-types)]
    (. builder acceleratorTypes data))
  (when-let [data (lookup-entry config id :allowed-instance-types)]
    (. builder allowedInstanceTypes data))
  (when-let [data (lookup-entry config id :bare-metal)]
    (. builder bareMetal data))
  (when-let [data (lookup-entry config id :baseline-ebs-bandwidth-mbps)]
    (. builder baselineEbsBandwidthMbps data))
  (when-let [data (lookup-entry config id :burstable-performance)]
    (. builder burstablePerformance data))
  (when-let [data (lookup-entry config id :cpu-manufacturers)]
    (. builder cpuManufacturers data))
  (when-let [data (lookup-entry config id :excluded-instance-types)]
    (. builder excludedInstanceTypes data))
  (when-let [data (lookup-entry config id :instance-generations)]
    (. builder instanceGenerations data))
  (when-let [data (lookup-entry config id :local-storage)]
    (. builder localStorage data))
  (when-let [data (lookup-entry config id :local-storage-types)]
    (. builder localStorageTypes data))
  (when-let [data (lookup-entry config id :max-spot-price-as-percentage-of-optimal-on-demand-price)]
    (. builder maxSpotPriceAsPercentageOfOptimalOnDemandPrice data))
  (when-let [data (lookup-entry config id :memory-gi-b-per-v-cpu)]
    (. builder memoryGiBPerVCpu data))
  (when-let [data (lookup-entry config id :memory-mi-b)]
    (. builder memoryMiB data))
  (when-let [data (lookup-entry config id :network-bandwidth-gbps)]
    (. builder networkBandwidthGbps data))
  (when-let [data (lookup-entry config id :network-interface-count)]
    (. builder networkInterfaceCount data))
  (when-let [data (lookup-entry config id :on-demand-max-price-percentage-over-lowest-price)]
    (. builder onDemandMaxPricePercentageOverLowestPrice data))
  (when-let [data (lookup-entry config id :require-hibernate-support)]
    (. builder requireHibernateSupport data))
  (when-let [data (lookup-entry config id :spot-max-price-percentage-over-lowest-price)]
    (. builder spotMaxPricePercentageOverLowestPrice data))
  (when-let [data (lookup-entry config id :total-local-storage-gb)]
    (. builder totalLocalStorageGb data))
  (when-let [data (lookup-entry config id :v-cpu-count)]
    (. builder vCpuCount data))
  (.build builder))


(defn cfn-ec2-fleet-instance-requirements-request-property-builder
  "Creates a  `CfnEC2Fleet$InstanceRequirementsRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-ec2-fleet-instance-requirements-request-property-builder (new CfnEC2Fleet$InstanceRequirementsRequestProperty$Builder) id config))


(defn build-cfn-ec2-fleet-maintenance-strategies-property-builder
  "The build-cfn-ec2-fleet-maintenance-strategies-property-builder function updates a CfnEC2Fleet$MaintenanceStrategiesProperty$Builder instance using the provided configuration.
  The function takes the CfnEC2Fleet$MaintenanceStrategiesProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `capacityRebalance` | software.amazon.awscdk.services.ec2.CfnEC2Fleet$CapacityRebalanceProperty | [[cdk.support/lookup-entry]] | `:capacity-rebalance` |
"
  [^CfnEC2Fleet$MaintenanceStrategiesProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :capacity-rebalance)]
    (. builder capacityRebalance data))
  (.build builder))


(defn cfn-ec2-fleet-maintenance-strategies-property-builder
  "Creates a  `CfnEC2Fleet$MaintenanceStrategiesProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-ec2-fleet-maintenance-strategies-property-builder (new CfnEC2Fleet$MaintenanceStrategiesProperty$Builder) id config))


(defn build-cfn-ec2-fleet-memory-gi-b-per-v-cpu-request-property-builder
  "The build-cfn-ec2-fleet-memory-gi-b-per-v-cpu-request-property-builder function updates a CfnEC2Fleet$MemoryGiBPerVCpuRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnEC2Fleet$MemoryGiBPerVCpuRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `max` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max` |
| `min` | java.lang.Number | [[cdk.support/lookup-entry]] | `:min` |
"
  [^CfnEC2Fleet$MemoryGiBPerVCpuRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :max)]
    (. builder max data))
  (when-let [data (lookup-entry config id :min)]
    (. builder min data))
  (.build builder))


(defn cfn-ec2-fleet-memory-gi-b-per-v-cpu-request-property-builder
  "Creates a  `CfnEC2Fleet$MemoryGiBPerVCpuRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-ec2-fleet-memory-gi-b-per-v-cpu-request-property-builder (new CfnEC2Fleet$MemoryGiBPerVCpuRequestProperty$Builder) id config))


(defn build-cfn-ec2-fleet-memory-mi-b-request-property-builder
  "The build-cfn-ec2-fleet-memory-mi-b-request-property-builder function updates a CfnEC2Fleet$MemoryMiBRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnEC2Fleet$MemoryMiBRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `max` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max` |
| `min` | java.lang.Number | [[cdk.support/lookup-entry]] | `:min` |
"
  [^CfnEC2Fleet$MemoryMiBRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :max)]
    (. builder max data))
  (when-let [data (lookup-entry config id :min)]
    (. builder min data))
  (.build builder))


(defn cfn-ec2-fleet-memory-mi-b-request-property-builder
  "Creates a  `CfnEC2Fleet$MemoryMiBRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-ec2-fleet-memory-mi-b-request-property-builder (new CfnEC2Fleet$MemoryMiBRequestProperty$Builder) id config))


(defn build-cfn-ec2-fleet-network-bandwidth-gbps-request-property-builder
  "The build-cfn-ec2-fleet-network-bandwidth-gbps-request-property-builder function updates a CfnEC2Fleet$NetworkBandwidthGbpsRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnEC2Fleet$NetworkBandwidthGbpsRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `max` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max` |
| `min` | java.lang.Number | [[cdk.support/lookup-entry]] | `:min` |
"
  [^CfnEC2Fleet$NetworkBandwidthGbpsRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :max)]
    (. builder max data))
  (when-let [data (lookup-entry config id :min)]
    (. builder min data))
  (.build builder))


(defn cfn-ec2-fleet-network-bandwidth-gbps-request-property-builder
  "Creates a  `CfnEC2Fleet$NetworkBandwidthGbpsRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-ec2-fleet-network-bandwidth-gbps-request-property-builder (new CfnEC2Fleet$NetworkBandwidthGbpsRequestProperty$Builder) id config))


(defn build-cfn-ec2-fleet-network-interface-count-request-property-builder
  "The build-cfn-ec2-fleet-network-interface-count-request-property-builder function updates a CfnEC2Fleet$NetworkInterfaceCountRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnEC2Fleet$NetworkInterfaceCountRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `max` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max` |
| `min` | java.lang.Number | [[cdk.support/lookup-entry]] | `:min` |
"
  [^CfnEC2Fleet$NetworkInterfaceCountRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :max)]
    (. builder max data))
  (when-let [data (lookup-entry config id :min)]
    (. builder min data))
  (.build builder))


(defn cfn-ec2-fleet-network-interface-count-request-property-builder
  "Creates a  `CfnEC2Fleet$NetworkInterfaceCountRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-ec2-fleet-network-interface-count-request-property-builder (new CfnEC2Fleet$NetworkInterfaceCountRequestProperty$Builder) id config))


(defn build-cfn-ec2-fleet-on-demand-options-request-property-builder
  "The build-cfn-ec2-fleet-on-demand-options-request-property-builder function updates a CfnEC2Fleet$OnDemandOptionsRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnEC2Fleet$OnDemandOptionsRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `allocationStrategy` | java.lang.String | [[cdk.support/lookup-entry]] | `:allocation-strategy` |
| `capacityReservationOptions` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:capacity-reservation-options` |
| `maxTotalPrice` | java.lang.String | [[cdk.support/lookup-entry]] | `:max-total-price` |
| `minTargetCapacity` | java.lang.Number | [[cdk.support/lookup-entry]] | `:min-target-capacity` |
| `singleAvailabilityZone` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:single-availability-zone` |
| `singleInstanceType` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:single-instance-type` |
"
  [^CfnEC2Fleet$OnDemandOptionsRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :allocation-strategy)]
    (. builder allocationStrategy data))
  (when-let [data (lookup-entry config id :capacity-reservation-options)]
    (. builder capacityReservationOptions data))
  (when-let [data (lookup-entry config id :max-total-price)]
    (. builder maxTotalPrice data))
  (when-let [data (lookup-entry config id :min-target-capacity)]
    (. builder minTargetCapacity data))
  (when-let [data (lookup-entry config id :single-availability-zone)]
    (. builder singleAvailabilityZone data))
  (when-let [data (lookup-entry config id :single-instance-type)]
    (. builder singleInstanceType data))
  (.build builder))


(defn cfn-ec2-fleet-on-demand-options-request-property-builder
  "Creates a  `CfnEC2Fleet$OnDemandOptionsRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-ec2-fleet-on-demand-options-request-property-builder (new CfnEC2Fleet$OnDemandOptionsRequestProperty$Builder) id config))


(defn build-cfn-ec2-fleet-placement-property-builder
  "The build-cfn-ec2-fleet-placement-property-builder function updates a CfnEC2Fleet$PlacementProperty$Builder instance using the provided configuration.
  The function takes the CfnEC2Fleet$PlacementProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `affinity` | java.lang.String | [[cdk.support/lookup-entry]] | `:affinity` |
| `availabilityZone` | java.lang.String | [[cdk.support/lookup-entry]] | `:availability-zone` |
| `groupName` | java.lang.String | [[cdk.support/lookup-entry]] | `:group-name` |
| `hostId` | java.lang.String | [[cdk.support/lookup-entry]] | `:host-id` |
| `hostResourceGroupArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:host-resource-group-arn` |
| `partitionNumber` | java.lang.Number | [[cdk.support/lookup-entry]] | `:partition-number` |
| `spreadDomain` | java.lang.String | [[cdk.support/lookup-entry]] | `:spread-domain` |
| `tenancy` | java.lang.String | [[cdk.support/lookup-entry]] | `:tenancy` |
"
  [^CfnEC2Fleet$PlacementProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :affinity)]
    (. builder affinity data))
  (when-let [data (lookup-entry config id :availability-zone)]
    (. builder availabilityZone data))
  (when-let [data (lookup-entry config id :group-name)]
    (. builder groupName data))
  (when-let [data (lookup-entry config id :host-id)]
    (. builder hostId data))
  (when-let [data (lookup-entry config id :host-resource-group-arn)]
    (. builder hostResourceGroupArn data))
  (when-let [data (lookup-entry config id :partition-number)]
    (. builder partitionNumber data))
  (when-let [data (lookup-entry config id :spread-domain)]
    (. builder spreadDomain data))
  (when-let [data (lookup-entry config id :tenancy)]
    (. builder tenancy data))
  (.build builder))


(defn cfn-ec2-fleet-placement-property-builder
  "Creates a  `CfnEC2Fleet$PlacementProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-ec2-fleet-placement-property-builder (new CfnEC2Fleet$PlacementProperty$Builder) id config))


(defn build-cfn-ec2-fleet-props-builder
  "The build-cfn-ec2-fleet-props-builder function updates a CfnEC2FleetProps$Builder instance using the provided configuration.
  The function takes the CfnEC2FleetProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `context` | java.lang.String | [[cdk.support/lookup-entry]] | `:context` |
| `excessCapacityTerminationPolicy` | java.lang.String | [[cdk.support/lookup-entry]] | `:excess-capacity-termination-policy` |
| `launchTemplateConfigs` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:launch-template-configs` |
| `onDemandOptions` | software.amazon.awscdk.services.ec2.CfnEC2Fleet$OnDemandOptionsRequestProperty | [[cdk.support/lookup-entry]] | `:on-demand-options` |
| `replaceUnhealthyInstances` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:replace-unhealthy-instances` |
| `spotOptions` | software.amazon.awscdk.services.ec2.CfnEC2Fleet$SpotOptionsRequestProperty | [[cdk.support/lookup-entry]] | `:spot-options` |
| `tagSpecifications` | java.util.List | [[cdk.support/lookup-entry]] | `:tag-specifications` |
| `targetCapacitySpecification` | software.amazon.awscdk.services.ec2.CfnEC2Fleet$TargetCapacitySpecificationRequestProperty | [[cdk.support/lookup-entry]] | `:target-capacity-specification` |
| `terminateInstancesWithExpiration` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:terminate-instances-with-expiration` |
| `type` | java.lang.String | [[cdk.support/lookup-entry]] | `:type` |
| `validFrom` | java.lang.String | [[cdk.support/lookup-entry]] | `:valid-from` |
| `validUntil` | java.lang.String | [[cdk.support/lookup-entry]] | `:valid-until` |
"
  [^CfnEC2FleetProps$Builder builder id config]
  (when-let [data (lookup-entry config id :context)]
    (. builder context data))
  (when-let [data (lookup-entry config id :excess-capacity-termination-policy)]
    (. builder excessCapacityTerminationPolicy data))
  (when-let [data (lookup-entry config id :launch-template-configs)]
    (. builder launchTemplateConfigs data))
  (when-let [data (lookup-entry config id :on-demand-options)]
    (. builder onDemandOptions data))
  (when-let [data (lookup-entry config id :replace-unhealthy-instances)]
    (. builder replaceUnhealthyInstances data))
  (when-let [data (lookup-entry config id :spot-options)]
    (. builder spotOptions data))
  (when-let [data (lookup-entry config id :tag-specifications)]
    (. builder tagSpecifications data))
  (when-let [data (lookup-entry config id :target-capacity-specification)]
    (. builder targetCapacitySpecification data))
  (when-let [data (lookup-entry config id :terminate-instances-with-expiration)]
    (. builder terminateInstancesWithExpiration data))
  (when-let [data (lookup-entry config id :type)]
    (. builder type data))
  (when-let [data (lookup-entry config id :valid-from)]
    (. builder validFrom data))
  (when-let [data (lookup-entry config id :valid-until)]
    (. builder validUntil data))
  (.build builder))


(defn cfn-ec2-fleet-props-builder
  "Creates a  `CfnEC2FleetProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-ec2-fleet-props-builder (new CfnEC2FleetProps$Builder) id config))


(defn build-cfn-ec2-fleet-spot-options-request-property-builder
  "The build-cfn-ec2-fleet-spot-options-request-property-builder function updates a CfnEC2Fleet$SpotOptionsRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnEC2Fleet$SpotOptionsRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `allocationStrategy` | java.lang.String | [[cdk.support/lookup-entry]] | `:allocation-strategy` |
| `instanceInterruptionBehavior` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-interruption-behavior` |
| `instancePoolsToUseCount` | java.lang.Number | [[cdk.support/lookup-entry]] | `:instance-pools-to-use-count` |
| `maintenanceStrategies` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:maintenance-strategies` |
| `maxTotalPrice` | java.lang.String | [[cdk.support/lookup-entry]] | `:max-total-price` |
| `minTargetCapacity` | java.lang.Number | [[cdk.support/lookup-entry]] | `:min-target-capacity` |
| `singleAvailabilityZone` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:single-availability-zone` |
| `singleInstanceType` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:single-instance-type` |
"
  [^CfnEC2Fleet$SpotOptionsRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :allocation-strategy)]
    (. builder allocationStrategy data))
  (when-let [data (lookup-entry config id :instance-interruption-behavior)]
    (. builder instanceInterruptionBehavior data))
  (when-let [data (lookup-entry config id :instance-pools-to-use-count)]
    (. builder instancePoolsToUseCount data))
  (when-let [data (lookup-entry config id :maintenance-strategies)]
    (. builder maintenanceStrategies data))
  (when-let [data (lookup-entry config id :max-total-price)]
    (. builder maxTotalPrice data))
  (when-let [data (lookup-entry config id :min-target-capacity)]
    (. builder minTargetCapacity data))
  (when-let [data (lookup-entry config id :single-availability-zone)]
    (. builder singleAvailabilityZone data))
  (when-let [data (lookup-entry config id :single-instance-type)]
    (. builder singleInstanceType data))
  (.build builder))


(defn cfn-ec2-fleet-spot-options-request-property-builder
  "Creates a  `CfnEC2Fleet$SpotOptionsRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-ec2-fleet-spot-options-request-property-builder (new CfnEC2Fleet$SpotOptionsRequestProperty$Builder) id config))


(defn build-cfn-ec2-fleet-tag-specification-property-builder
  "The build-cfn-ec2-fleet-tag-specification-property-builder function updates a CfnEC2Fleet$TagSpecificationProperty$Builder instance using the provided configuration.
  The function takes the CfnEC2Fleet$TagSpecificationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `resourceType` | java.lang.String | [[cdk.support/lookup-entry]] | `:resource-type` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnEC2Fleet$TagSpecificationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :resource-type)]
    (. builder resourceType data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-ec2-fleet-tag-specification-property-builder
  "Creates a  `CfnEC2Fleet$TagSpecificationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-ec2-fleet-tag-specification-property-builder (new CfnEC2Fleet$TagSpecificationProperty$Builder) id config))


(defn build-cfn-ec2-fleet-target-capacity-specification-request-property-builder
  "The build-cfn-ec2-fleet-target-capacity-specification-request-property-builder function updates a CfnEC2Fleet$TargetCapacitySpecificationRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnEC2Fleet$TargetCapacitySpecificationRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `defaultTargetCapacityType` | java.lang.String | [[cdk.support/lookup-entry]] | `:default-target-capacity-type` |
| `onDemandTargetCapacity` | java.lang.Number | [[cdk.support/lookup-entry]] | `:on-demand-target-capacity` |
| `spotTargetCapacity` | java.lang.Number | [[cdk.support/lookup-entry]] | `:spot-target-capacity` |
| `targetCapacityUnitType` | java.lang.String | [[cdk.support/lookup-entry]] | `:target-capacity-unit-type` |
| `totalTargetCapacity` | java.lang.Number | [[cdk.support/lookup-entry]] | `:total-target-capacity` |
"
  [^CfnEC2Fleet$TargetCapacitySpecificationRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :default-target-capacity-type)]
    (. builder defaultTargetCapacityType data))
  (when-let [data (lookup-entry config id :on-demand-target-capacity)]
    (. builder onDemandTargetCapacity data))
  (when-let [data (lookup-entry config id :spot-target-capacity)]
    (. builder spotTargetCapacity data))
  (when-let [data (lookup-entry config id :target-capacity-unit-type)]
    (. builder targetCapacityUnitType data))
  (when-let [data (lookup-entry config id :total-target-capacity)]
    (. builder totalTargetCapacity data))
  (.build builder))


(defn cfn-ec2-fleet-target-capacity-specification-request-property-builder
  "Creates a  `CfnEC2Fleet$TargetCapacitySpecificationRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-ec2-fleet-target-capacity-specification-request-property-builder (new CfnEC2Fleet$TargetCapacitySpecificationRequestProperty$Builder) id config))


(defn build-cfn-ec2-fleet-total-local-storage-gb-request-property-builder
  "The build-cfn-ec2-fleet-total-local-storage-gb-request-property-builder function updates a CfnEC2Fleet$TotalLocalStorageGBRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnEC2Fleet$TotalLocalStorageGBRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `max` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max` |
| `min` | java.lang.Number | [[cdk.support/lookup-entry]] | `:min` |
"
  [^CfnEC2Fleet$TotalLocalStorageGBRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :max)]
    (. builder max data))
  (when-let [data (lookup-entry config id :min)]
    (. builder min data))
  (.build builder))


(defn cfn-ec2-fleet-total-local-storage-gb-request-property-builder
  "Creates a  `CfnEC2Fleet$TotalLocalStorageGBRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-ec2-fleet-total-local-storage-gb-request-property-builder (new CfnEC2Fleet$TotalLocalStorageGBRequestProperty$Builder) id config))


(defn build-cfn-ec2-fleet-v-cpu-count-range-request-property-builder
  "The build-cfn-ec2-fleet-v-cpu-count-range-request-property-builder function updates a CfnEC2Fleet$VCpuCountRangeRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnEC2Fleet$VCpuCountRangeRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `max` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max` |
| `min` | java.lang.Number | [[cdk.support/lookup-entry]] | `:min` |
"
  [^CfnEC2Fleet$VCpuCountRangeRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :max)]
    (. builder max data))
  (when-let [data (lookup-entry config id :min)]
    (. builder min data))
  (.build builder))


(defn cfn-ec2-fleet-v-cpu-count-range-request-property-builder
  "Creates a  `CfnEC2Fleet$VCpuCountRangeRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-ec2-fleet-v-cpu-count-range-request-property-builder (new CfnEC2Fleet$VCpuCountRangeRequestProperty$Builder) id config))


(defn build-cfn-egress-only-internet-gateway-builder
  "The build-cfn-egress-only-internet-gateway-builder function updates a CfnEgressOnlyInternetGateway$Builder instance using the provided configuration.
  The function takes the CfnEgressOnlyInternetGateway$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `vpcId` | java.lang.String | [[cdk.support/lookup-entry]] | `:vpc-id` |
"
  [^CfnEgressOnlyInternetGateway$Builder builder id config]
  (when-let [data (lookup-entry config id :vpc-id)]
    (. builder vpcId data))
  (.build builder))


(defn cfn-egress-only-internet-gateway-builder
  "Creates a  `CfnEgressOnlyInternetGateway$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-egress-only-internet-gateway-builder (CfnEgressOnlyInternetGateway$Builder/create scope (name id)) id config))


(defn build-cfn-egress-only-internet-gateway-props-builder
  "The build-cfn-egress-only-internet-gateway-props-builder function updates a CfnEgressOnlyInternetGatewayProps$Builder instance using the provided configuration.
  The function takes the CfnEgressOnlyInternetGatewayProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `vpcId` | java.lang.String | [[cdk.support/lookup-entry]] | `:vpc-id` |
"
  [^CfnEgressOnlyInternetGatewayProps$Builder builder id config]
  (when-let [data (lookup-entry config id :vpc-id)]
    (. builder vpcId data))
  (.build builder))


(defn cfn-egress-only-internet-gateway-props-builder
  "Creates a  `CfnEgressOnlyInternetGatewayProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-egress-only-internet-gateway-props-builder (new CfnEgressOnlyInternetGatewayProps$Builder) id config))


(defn build-cfn-eip-association-builder
  "The build-cfn-eip-association-builder function updates a CfnEIPAssociation$Builder instance using the provided configuration.
  The function takes the CfnEIPAssociation$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `allocationId` | java.lang.String | [[cdk.support/lookup-entry]] | `:allocation-id` |
| `eip` | java.lang.String | [[cdk.support/lookup-entry]] | `:eip` |
| `instanceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-id` |
| `networkInterfaceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-interface-id` |
| `privateIpAddress` | java.lang.String | [[cdk.support/lookup-entry]] | `:private-ip-address` |
"
  [^CfnEIPAssociation$Builder builder id config]
  (when-let [data (lookup-entry config id :allocation-id)]
    (. builder allocationId data))
  (when-let [data (lookup-entry config id :eip)]
    (. builder eip data))
  (when-let [data (lookup-entry config id :instance-id)]
    (. builder instanceId data))
  (when-let [data (lookup-entry config id :network-interface-id)]
    (. builder networkInterfaceId data))
  (when-let [data (lookup-entry config id :private-ip-address)]
    (. builder privateIpAddress data))
  (.build builder))


(defn cfn-eip-association-builder
  "Creates a  `CfnEIPAssociation$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-eip-association-builder (CfnEIPAssociation$Builder/create scope (name id)) id config))


(defn build-cfn-eip-association-props-builder
  "The build-cfn-eip-association-props-builder function updates a CfnEIPAssociationProps$Builder instance using the provided configuration.
  The function takes the CfnEIPAssociationProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `allocationId` | java.lang.String | [[cdk.support/lookup-entry]] | `:allocation-id` |
| `eip` | java.lang.String | [[cdk.support/lookup-entry]] | `:eip` |
| `instanceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-id` |
| `networkInterfaceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-interface-id` |
| `privateIpAddress` | java.lang.String | [[cdk.support/lookup-entry]] | `:private-ip-address` |
"
  [^CfnEIPAssociationProps$Builder builder id config]
  (when-let [data (lookup-entry config id :allocation-id)]
    (. builder allocationId data))
  (when-let [data (lookup-entry config id :eip)]
    (. builder eip data))
  (when-let [data (lookup-entry config id :instance-id)]
    (. builder instanceId data))
  (when-let [data (lookup-entry config id :network-interface-id)]
    (. builder networkInterfaceId data))
  (when-let [data (lookup-entry config id :private-ip-address)]
    (. builder privateIpAddress data))
  (.build builder))


(defn cfn-eip-association-props-builder
  "Creates a  `CfnEIPAssociationProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-eip-association-props-builder (new CfnEIPAssociationProps$Builder) id config))


(defn build-cfn-eip-builder
  "The build-cfn-eip-builder function updates a CfnEIP$Builder instance using the provided configuration.
  The function takes the CfnEIP$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `domain` | java.lang.String | [[cdk.support/lookup-entry]] | `:domain` |
| `instanceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-id` |
| `networkBorderGroup` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-border-group` |
| `publicIpv4Pool` | java.lang.String | [[cdk.support/lookup-entry]] | `:public-ipv4-pool` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `transferAddress` | java.lang.String | [[cdk.support/lookup-entry]] | `:transfer-address` |
"
  [^CfnEIP$Builder builder id config]
  (when-let [data (lookup-entry config id :domain)]
    (. builder domain data))
  (when-let [data (lookup-entry config id :instance-id)]
    (. builder instanceId data))
  (when-let [data (lookup-entry config id :network-border-group)]
    (. builder networkBorderGroup data))
  (when-let [data (lookup-entry config id :public-ipv4-pool)]
    (. builder publicIpv4Pool data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :transfer-address)]
    (. builder transferAddress data))
  (.build builder))


(defn cfn-eip-builder
  "Creates a  `CfnEIP$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-eip-builder (CfnEIP$Builder/create scope (name id)) id config))


(defn build-cfn-eip-props-builder
  "The build-cfn-eip-props-builder function updates a CfnEIPProps$Builder instance using the provided configuration.
  The function takes the CfnEIPProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `domain` | java.lang.String | [[cdk.support/lookup-entry]] | `:domain` |
| `instanceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-id` |
| `networkBorderGroup` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-border-group` |
| `publicIpv4Pool` | java.lang.String | [[cdk.support/lookup-entry]] | `:public-ipv4-pool` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `transferAddress` | java.lang.String | [[cdk.support/lookup-entry]] | `:transfer-address` |
"
  [^CfnEIPProps$Builder builder id config]
  (when-let [data (lookup-entry config id :domain)]
    (. builder domain data))
  (when-let [data (lookup-entry config id :instance-id)]
    (. builder instanceId data))
  (when-let [data (lookup-entry config id :network-border-group)]
    (. builder networkBorderGroup data))
  (when-let [data (lookup-entry config id :public-ipv4-pool)]
    (. builder publicIpv4Pool data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :transfer-address)]
    (. builder transferAddress data))
  (.build builder))


(defn cfn-eip-props-builder
  "Creates a  `CfnEIPProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-eip-props-builder (new CfnEIPProps$Builder) id config))


(defn build-cfn-enclave-certificate-iam-role-association-builder
  "The build-cfn-enclave-certificate-iam-role-association-builder function updates a CfnEnclaveCertificateIamRoleAssociation$Builder instance using the provided configuration.
  The function takes the CfnEnclaveCertificateIamRoleAssociation$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `certificateArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:certificate-arn` |
| `roleArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:role-arn` |
"
  [^CfnEnclaveCertificateIamRoleAssociation$Builder builder id config]
  (when-let [data (lookup-entry config id :certificate-arn)]
    (. builder certificateArn data))
  (when-let [data (lookup-entry config id :role-arn)]
    (. builder roleArn data))
  (.build builder))


(defn cfn-enclave-certificate-iam-role-association-builder
  "Creates a  `CfnEnclaveCertificateIamRoleAssociation$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-enclave-certificate-iam-role-association-builder (CfnEnclaveCertificateIamRoleAssociation$Builder/create scope (name id)) id config))


(defn build-cfn-enclave-certificate-iam-role-association-props-builder
  "The build-cfn-enclave-certificate-iam-role-association-props-builder function updates a CfnEnclaveCertificateIamRoleAssociationProps$Builder instance using the provided configuration.
  The function takes the CfnEnclaveCertificateIamRoleAssociationProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `certificateArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:certificate-arn` |
| `roleArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:role-arn` |
"
  [^CfnEnclaveCertificateIamRoleAssociationProps$Builder builder id config]
  (when-let [data (lookup-entry config id :certificate-arn)]
    (. builder certificateArn data))
  (when-let [data (lookup-entry config id :role-arn)]
    (. builder roleArn data))
  (.build builder))


(defn cfn-enclave-certificate-iam-role-association-props-builder
  "Creates a  `CfnEnclaveCertificateIamRoleAssociationProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-enclave-certificate-iam-role-association-props-builder (new CfnEnclaveCertificateIamRoleAssociationProps$Builder) id config))


(defn build-cfn-flow-log-builder
  "The build-cfn-flow-log-builder function updates a CfnFlowLog$Builder instance using the provided configuration.
  The function takes the CfnFlowLog$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `deliverCrossAccountRole` | java.lang.String | [[cdk.support/lookup-entry]] | `:deliver-cross-account-role` |
| `deliverLogsPermissionArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:deliver-logs-permission-arn` |
| `destinationOptions` | java.lang.Object | [[cdk.support/lookup-entry]] | `:destination-options` |
| `logDestination` | java.lang.String | [[cdk.support/lookup-entry]] | `:log-destination` |
| `logDestinationType` | java.lang.String | [[cdk.support/lookup-entry]] | `:log-destination-type` |
| `logFormat` | java.lang.String | [[cdk.support/lookup-entry]] | `:log-format` |
| `logGroupName` | java.lang.String | [[cdk.support/lookup-entry]] | `:log-group-name` |
| `maxAggregationInterval` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max-aggregation-interval` |
| `resourceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:resource-id` |
| `resourceType` | java.lang.String | [[cdk.support/lookup-entry]] | `:resource-type` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `trafficType` | java.lang.String | [[cdk.support/lookup-entry]] | `:traffic-type` |
"
  [^CfnFlowLog$Builder builder id config]
  (when-let [data (lookup-entry config id :deliver-cross-account-role)]
    (. builder deliverCrossAccountRole data))
  (when-let [data (lookup-entry config id :deliver-logs-permission-arn)]
    (. builder deliverLogsPermissionArn data))
  (when-let [data (lookup-entry config id :destination-options)]
    (. builder destinationOptions data))
  (when-let [data (lookup-entry config id :log-destination)]
    (. builder logDestination data))
  (when-let [data (lookup-entry config id :log-destination-type)]
    (. builder logDestinationType data))
  (when-let [data (lookup-entry config id :log-format)]
    (. builder logFormat data))
  (when-let [data (lookup-entry config id :log-group-name)]
    (. builder logGroupName data))
  (when-let [data (lookup-entry config id :max-aggregation-interval)]
    (. builder maxAggregationInterval data))
  (when-let [data (lookup-entry config id :resource-id)]
    (. builder resourceId data))
  (when-let [data (lookup-entry config id :resource-type)]
    (. builder resourceType data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :traffic-type)]
    (. builder trafficType data))
  (.build builder))


(defn cfn-flow-log-builder
  "Creates a  `CfnFlowLog$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-flow-log-builder (CfnFlowLog$Builder/create scope (name id)) id config))


(defn build-cfn-flow-log-destination-options-property-builder
  "The build-cfn-flow-log-destination-options-property-builder function updates a CfnFlowLog$DestinationOptionsProperty$Builder instance using the provided configuration.
  The function takes the CfnFlowLog$DestinationOptionsProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `fileFormat` | java.lang.String | [[cdk.support/lookup-entry]] | `:file-format` |
| `hiveCompatiblePartitions` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:hive-compatible-partitions` |
| `perHourPartition` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:per-hour-partition` |
"
  [^CfnFlowLog$DestinationOptionsProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :file-format)]
    (. builder fileFormat data))
  (when-let [data (lookup-entry config id :hive-compatible-partitions)]
    (. builder hiveCompatiblePartitions data))
  (when-let [data (lookup-entry config id :per-hour-partition)]
    (. builder perHourPartition data))
  (.build builder))


(defn cfn-flow-log-destination-options-property-builder
  "Creates a  `CfnFlowLog$DestinationOptionsProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-flow-log-destination-options-property-builder (new CfnFlowLog$DestinationOptionsProperty$Builder) id config))


(defn build-cfn-flow-log-props-builder
  "The build-cfn-flow-log-props-builder function updates a CfnFlowLogProps$Builder instance using the provided configuration.
  The function takes the CfnFlowLogProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `deliverCrossAccountRole` | java.lang.String | [[cdk.support/lookup-entry]] | `:deliver-cross-account-role` |
| `deliverLogsPermissionArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:deliver-logs-permission-arn` |
| `destinationOptions` | java.lang.Object | [[cdk.support/lookup-entry]] | `:destination-options` |
| `logDestination` | java.lang.String | [[cdk.support/lookup-entry]] | `:log-destination` |
| `logDestinationType` | java.lang.String | [[cdk.support/lookup-entry]] | `:log-destination-type` |
| `logFormat` | java.lang.String | [[cdk.support/lookup-entry]] | `:log-format` |
| `logGroupName` | java.lang.String | [[cdk.support/lookup-entry]] | `:log-group-name` |
| `maxAggregationInterval` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max-aggregation-interval` |
| `resourceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:resource-id` |
| `resourceType` | java.lang.String | [[cdk.support/lookup-entry]] | `:resource-type` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `trafficType` | java.lang.String | [[cdk.support/lookup-entry]] | `:traffic-type` |
"
  [^CfnFlowLogProps$Builder builder id config]
  (when-let [data (lookup-entry config id :deliver-cross-account-role)]
    (. builder deliverCrossAccountRole data))
  (when-let [data (lookup-entry config id :deliver-logs-permission-arn)]
    (. builder deliverLogsPermissionArn data))
  (when-let [data (lookup-entry config id :destination-options)]
    (. builder destinationOptions data))
  (when-let [data (lookup-entry config id :log-destination)]
    (. builder logDestination data))
  (when-let [data (lookup-entry config id :log-destination-type)]
    (. builder logDestinationType data))
  (when-let [data (lookup-entry config id :log-format)]
    (. builder logFormat data))
  (when-let [data (lookup-entry config id :log-group-name)]
    (. builder logGroupName data))
  (when-let [data (lookup-entry config id :max-aggregation-interval)]
    (. builder maxAggregationInterval data))
  (when-let [data (lookup-entry config id :resource-id)]
    (. builder resourceId data))
  (when-let [data (lookup-entry config id :resource-type)]
    (. builder resourceType data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :traffic-type)]
    (. builder trafficType data))
  (.build builder))


(defn cfn-flow-log-props-builder
  "Creates a  `CfnFlowLogProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-flow-log-props-builder (new CfnFlowLogProps$Builder) id config))


(defn build-cfn-gateway-route-table-association-builder
  "The build-cfn-gateway-route-table-association-builder function updates a CfnGatewayRouteTableAssociation$Builder instance using the provided configuration.
  The function takes the CfnGatewayRouteTableAssociation$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `gatewayId` | java.lang.String | [[cdk.support/lookup-entry]] | `:gateway-id` |
| `routeTableId` | java.lang.String | [[cdk.support/lookup-entry]] | `:route-table-id` |
"
  [^CfnGatewayRouteTableAssociation$Builder builder id config]
  (when-let [data (lookup-entry config id :gateway-id)]
    (. builder gatewayId data))
  (when-let [data (lookup-entry config id :route-table-id)]
    (. builder routeTableId data))
  (.build builder))


(defn cfn-gateway-route-table-association-builder
  "Creates a  `CfnGatewayRouteTableAssociation$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-gateway-route-table-association-builder (CfnGatewayRouteTableAssociation$Builder/create scope (name id)) id config))


(defn build-cfn-gateway-route-table-association-props-builder
  "The build-cfn-gateway-route-table-association-props-builder function updates a CfnGatewayRouteTableAssociationProps$Builder instance using the provided configuration.
  The function takes the CfnGatewayRouteTableAssociationProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `gatewayId` | java.lang.String | [[cdk.support/lookup-entry]] | `:gateway-id` |
| `routeTableId` | java.lang.String | [[cdk.support/lookup-entry]] | `:route-table-id` |
"
  [^CfnGatewayRouteTableAssociationProps$Builder builder id config]
  (when-let [data (lookup-entry config id :gateway-id)]
    (. builder gatewayId data))
  (when-let [data (lookup-entry config id :route-table-id)]
    (. builder routeTableId data))
  (.build builder))


(defn cfn-gateway-route-table-association-props-builder
  "Creates a  `CfnGatewayRouteTableAssociationProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-gateway-route-table-association-props-builder (new CfnGatewayRouteTableAssociationProps$Builder) id config))


(defn build-cfn-host-builder
  "The build-cfn-host-builder function updates a CfnHost$Builder instance using the provided configuration.
  The function takes the CfnHost$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `assetId` | java.lang.String | [[cdk.support/lookup-entry]] | `:asset-id` |
| `autoPlacement` | java.lang.String | [[cdk.support/lookup-entry]] | `:auto-placement` |
| `availabilityZone` | java.lang.String | [[cdk.support/lookup-entry]] | `:availability-zone` |
| `hostMaintenance` | java.lang.String | [[cdk.support/lookup-entry]] | `:host-maintenance` |
| `hostRecovery` | java.lang.String | [[cdk.support/lookup-entry]] | `:host-recovery` |
| `instanceFamily` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-family` |
| `instanceType` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-type` |
| `outpostArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:outpost-arn` |
"
  [^CfnHost$Builder builder id config]
  (when-let [data (lookup-entry config id :asset-id)]
    (. builder assetId data))
  (when-let [data (lookup-entry config id :auto-placement)]
    (. builder autoPlacement data))
  (when-let [data (lookup-entry config id :availability-zone)]
    (. builder availabilityZone data))
  (when-let [data (lookup-entry config id :host-maintenance)]
    (. builder hostMaintenance data))
  (when-let [data (lookup-entry config id :host-recovery)]
    (. builder hostRecovery data))
  (when-let [data (lookup-entry config id :instance-family)]
    (. builder instanceFamily data))
  (when-let [data (lookup-entry config id :instance-type)]
    (. builder instanceType data))
  (when-let [data (lookup-entry config id :outpost-arn)]
    (. builder outpostArn data))
  (.build builder))


(defn cfn-host-builder
  "Creates a  `CfnHost$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-host-builder (CfnHost$Builder/create scope (name id)) id config))


(defn build-cfn-host-props-builder
  "The build-cfn-host-props-builder function updates a CfnHostProps$Builder instance using the provided configuration.
  The function takes the CfnHostProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `assetId` | java.lang.String | [[cdk.support/lookup-entry]] | `:asset-id` |
| `autoPlacement` | java.lang.String | [[cdk.support/lookup-entry]] | `:auto-placement` |
| `availabilityZone` | java.lang.String | [[cdk.support/lookup-entry]] | `:availability-zone` |
| `hostMaintenance` | java.lang.String | [[cdk.support/lookup-entry]] | `:host-maintenance` |
| `hostRecovery` | java.lang.String | [[cdk.support/lookup-entry]] | `:host-recovery` |
| `instanceFamily` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-family` |
| `instanceType` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-type` |
| `outpostArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:outpost-arn` |
"
  [^CfnHostProps$Builder builder id config]
  (when-let [data (lookup-entry config id :asset-id)]
    (. builder assetId data))
  (when-let [data (lookup-entry config id :auto-placement)]
    (. builder autoPlacement data))
  (when-let [data (lookup-entry config id :availability-zone)]
    (. builder availabilityZone data))
  (when-let [data (lookup-entry config id :host-maintenance)]
    (. builder hostMaintenance data))
  (when-let [data (lookup-entry config id :host-recovery)]
    (. builder hostRecovery data))
  (when-let [data (lookup-entry config id :instance-family)]
    (. builder instanceFamily data))
  (when-let [data (lookup-entry config id :instance-type)]
    (. builder instanceType data))
  (when-let [data (lookup-entry config id :outpost-arn)]
    (. builder outpostArn data))
  (.build builder))


(defn cfn-host-props-builder
  "Creates a  `CfnHostProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-host-props-builder (new CfnHostProps$Builder) id config))


(defn build-cfn-instance-association-parameter-property-builder
  "The build-cfn-instance-association-parameter-property-builder function updates a CfnInstance$AssociationParameterProperty$Builder instance using the provided configuration.
  The function takes the CfnInstance$AssociationParameterProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `key` | java.lang.String | [[cdk.support/lookup-entry]] | `:key` |
| `value` | java.util.List | [[cdk.support/lookup-entry]] | `:value` |
"
  [^CfnInstance$AssociationParameterProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :key)]
    (. builder key data))
  (when-let [data (lookup-entry config id :value)]
    (. builder value data))
  (.build builder))


(defn cfn-instance-association-parameter-property-builder
  "Creates a  `CfnInstance$AssociationParameterProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-instance-association-parameter-property-builder (new CfnInstance$AssociationParameterProperty$Builder) id config))


(defn build-cfn-instance-block-device-mapping-property-builder
  "The build-cfn-instance-block-device-mapping-property-builder function updates a CfnInstance$BlockDeviceMappingProperty$Builder instance using the provided configuration.
  The function takes the CfnInstance$BlockDeviceMappingProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `deviceName` | java.lang.String | [[cdk.support/lookup-entry]] | `:device-name` |
| `ebs` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:ebs` |
| `noDevice` | software.amazon.awscdk.services.ec2.CfnInstance$NoDeviceProperty | [[cdk.support/lookup-entry]] | `:no-device` |
| `virtualName` | java.lang.String | [[cdk.support/lookup-entry]] | `:virtual-name` |
"
  [^CfnInstance$BlockDeviceMappingProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :device-name)]
    (. builder deviceName data))
  (when-let [data (lookup-entry config id :ebs)]
    (. builder ebs data))
  (when-let [data (lookup-entry config id :no-device)]
    (. builder noDevice data))
  (when-let [data (lookup-entry config id :virtual-name)]
    (. builder virtualName data))
  (.build builder))


(defn cfn-instance-block-device-mapping-property-builder
  "Creates a  `CfnInstance$BlockDeviceMappingProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-instance-block-device-mapping-property-builder (new CfnInstance$BlockDeviceMappingProperty$Builder) id config))


(defn build-cfn-instance-builder
  "The build-cfn-instance-builder function updates a CfnInstance$Builder instance using the provided configuration.
  The function takes the CfnInstance$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `additionalInfo` | java.lang.String | [[cdk.support/lookup-entry]] | `:additional-info` |
| `affinity` | java.lang.String | [[cdk.support/lookup-entry]] | `:affinity` |
| `availabilityZone` | java.lang.String | [[cdk.support/lookup-entry]] | `:availability-zone` |
| `blockDeviceMappings` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:block-device-mappings` |
| `cpuOptions` | software.amazon.awscdk.services.ec2.CfnInstance$CpuOptionsProperty | [[cdk.support/lookup-entry]] | `:cpu-options` |
| `creditSpecification` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:credit-specification` |
| `disableApiTermination` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:disable-api-termination` |
| `ebsOptimized` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:ebs-optimized` |
| `elasticGpuSpecifications` | java.util.List | [[cdk.support/lookup-entry]] | `:elastic-gpu-specifications` |
| `elasticInferenceAccelerators` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:elastic-inference-accelerators` |
| `enclaveOptions` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:enclave-options` |
| `hibernationOptions` | software.amazon.awscdk.services.ec2.CfnInstance$HibernationOptionsProperty | [[cdk.support/lookup-entry]] | `:hibernation-options` |
| `hostId` | java.lang.String | [[cdk.support/lookup-entry]] | `:host-id` |
| `hostResourceGroupArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:host-resource-group-arn` |
| `iamInstanceProfile` | java.lang.String | [[cdk.support/lookup-entry]] | `:iam-instance-profile` |
| `imageId` | java.lang.String | [[cdk.support/lookup-entry]] | `:image-id` |
| `instanceInitiatedShutdownBehavior` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-initiated-shutdown-behavior` |
| `instanceType` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-type` |
| `ipv6AddressCount` | java.lang.Number | [[cdk.support/lookup-entry]] | `:ipv6-address-count` |
| `ipv6Addresses` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:ipv6-addresses` |
| `kernelId` | java.lang.String | [[cdk.support/lookup-entry]] | `:kernel-id` |
| `keyName` | java.lang.String | [[cdk.support/lookup-entry]] | `:key-name` |
| `launchTemplate` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:launch-template` |
| `licenseSpecifications` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:license-specifications` |
| `monitoring` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:monitoring` |
| `networkInterfaces` | java.util.List | [[cdk.support/lookup-entry]] | `:network-interfaces` |
| `placementGroupName` | java.lang.String | [[cdk.support/lookup-entry]] | `:placement-group-name` |
| `privateDnsNameOptions` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:private-dns-name-options` |
| `privateIpAddress` | java.lang.String | [[cdk.support/lookup-entry]] | `:private-ip-address` |
| `propagateTagsToVolumeOnCreation` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:propagate-tags-to-volume-on-creation` |
| `ramdiskId` | java.lang.String | [[cdk.support/lookup-entry]] | `:ramdisk-id` |
| `securityGroupIds` | java.util.List | [[cdk.support/lookup-entry]] | `:security-group-ids` |
| `securityGroups` | java.util.List | [[cdk.support/lookup-entry]] | `:security-groups` |
| `sourceDestCheck` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:source-dest-check` |
| `ssmAssociations` | java.util.List | [[cdk.support/lookup-entry]] | `:ssm-associations` |
| `subnetId` | java.lang.String | [[cdk.support/lookup-entry]] | `:subnet-id` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `tenancy` | java.lang.String | [[cdk.support/lookup-entry]] | `:tenancy` |
| `userData` | java.lang.String | [[cdk.support/lookup-entry]] | `:user-data` |
| `volumes` | java.util.List | [[cdk.support/lookup-entry]] | `:volumes` |
"
  [^CfnInstance$Builder builder id config]
  (when-let [data (lookup-entry config id :additional-info)]
    (. builder additionalInfo data))
  (when-let [data (lookup-entry config id :affinity)]
    (. builder affinity data))
  (when-let [data (lookup-entry config id :availability-zone)]
    (. builder availabilityZone data))
  (when-let [data (lookup-entry config id :block-device-mappings)]
    (. builder blockDeviceMappings data))
  (when-let [data (lookup-entry config id :cpu-options)]
    (. builder cpuOptions data))
  (when-let [data (lookup-entry config id :credit-specification)]
    (. builder creditSpecification data))
  (when-let [data (lookup-entry config id :disable-api-termination)]
    (. builder disableApiTermination data))
  (when-let [data (lookup-entry config id :ebs-optimized)]
    (. builder ebsOptimized data))
  (when-let [data (lookup-entry config id :elastic-gpu-specifications)]
    (. builder elasticGpuSpecifications data))
  (when-let [data (lookup-entry config id :elastic-inference-accelerators)]
    (. builder elasticInferenceAccelerators data))
  (when-let [data (lookup-entry config id :enclave-options)]
    (. builder enclaveOptions data))
  (when-let [data (lookup-entry config id :hibernation-options)]
    (. builder hibernationOptions data))
  (when-let [data (lookup-entry config id :host-id)]
    (. builder hostId data))
  (when-let [data (lookup-entry config id :host-resource-group-arn)]
    (. builder hostResourceGroupArn data))
  (when-let [data (lookup-entry config id :iam-instance-profile)]
    (. builder iamInstanceProfile data))
  (when-let [data (lookup-entry config id :image-id)]
    (. builder imageId data))
  (when-let [data (lookup-entry config id :instance-initiated-shutdown-behavior)]
    (. builder instanceInitiatedShutdownBehavior data))
  (when-let [data (lookup-entry config id :instance-type)]
    (. builder instanceType data))
  (when-let [data (lookup-entry config id :ipv6-address-count)]
    (. builder ipv6AddressCount data))
  (when-let [data (lookup-entry config id :ipv6-addresses)]
    (. builder ipv6Addresses data))
  (when-let [data (lookup-entry config id :kernel-id)]
    (. builder kernelId data))
  (when-let [data (lookup-entry config id :key-name)]
    (. builder keyName data))
  (when-let [data (lookup-entry config id :launch-template)]
    (. builder launchTemplate data))
  (when-let [data (lookup-entry config id :license-specifications)]
    (. builder licenseSpecifications data))
  (when-let [data (lookup-entry config id :monitoring)]
    (. builder monitoring data))
  (when-let [data (lookup-entry config id :network-interfaces)]
    (. builder networkInterfaces data))
  (when-let [data (lookup-entry config id :placement-group-name)]
    (. builder placementGroupName data))
  (when-let [data (lookup-entry config id :private-dns-name-options)]
    (. builder privateDnsNameOptions data))
  (when-let [data (lookup-entry config id :private-ip-address)]
    (. builder privateIpAddress data))
  (when-let [data (lookup-entry config id :propagate-tags-to-volume-on-creation)]
    (. builder propagateTagsToVolumeOnCreation data))
  (when-let [data (lookup-entry config id :ramdisk-id)]
    (. builder ramdiskId data))
  (when-let [data (lookup-entry config id :security-group-ids)]
    (. builder securityGroupIds data))
  (when-let [data (lookup-entry config id :security-groups)]
    (. builder securityGroups data))
  (when-let [data (lookup-entry config id :source-dest-check)]
    (. builder sourceDestCheck data))
  (when-let [data (lookup-entry config id :ssm-associations)]
    (. builder ssmAssociations data))
  (when-let [data (lookup-entry config id :subnet-id)]
    (. builder subnetId data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :tenancy)]
    (. builder tenancy data))
  (when-let [data (lookup-entry config id :user-data)]
    (. builder userData data))
  (when-let [data (lookup-entry config id :volumes)]
    (. builder volumes data))
  (.build builder))


(defn cfn-instance-builder
  "Creates a  `CfnInstance$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-instance-builder (CfnInstance$Builder/create scope (name id)) id config))


(defn build-cfn-instance-connect-endpoint-builder
  "The build-cfn-instance-connect-endpoint-builder function updates a CfnInstanceConnectEndpoint$Builder instance using the provided configuration.
  The function takes the CfnInstanceConnectEndpoint$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `clientToken` | java.lang.String | [[cdk.support/lookup-entry]] | `:client-token` |
| `preserveClientIp` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:preserve-client-ip` |
| `securityGroupIds` | java.util.List | [[cdk.support/lookup-entry]] | `:security-group-ids` |
| `subnetId` | java.lang.String | [[cdk.support/lookup-entry]] | `:subnet-id` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnInstanceConnectEndpoint$Builder builder id config]
  (when-let [data (lookup-entry config id :client-token)]
    (. builder clientToken data))
  (when-let [data (lookup-entry config id :preserve-client-ip)]
    (. builder preserveClientIp data))
  (when-let [data (lookup-entry config id :security-group-ids)]
    (. builder securityGroupIds data))
  (when-let [data (lookup-entry config id :subnet-id)]
    (. builder subnetId data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-instance-connect-endpoint-builder
  "Creates a  `CfnInstanceConnectEndpoint$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-instance-connect-endpoint-builder (CfnInstanceConnectEndpoint$Builder/create scope (name id)) id config))


(defn build-cfn-instance-connect-endpoint-props-builder
  "The build-cfn-instance-connect-endpoint-props-builder function updates a CfnInstanceConnectEndpointProps$Builder instance using the provided configuration.
  The function takes the CfnInstanceConnectEndpointProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `clientToken` | java.lang.String | [[cdk.support/lookup-entry]] | `:client-token` |
| `preserveClientIp` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:preserve-client-ip` |
| `securityGroupIds` | java.util.List | [[cdk.support/lookup-entry]] | `:security-group-ids` |
| `subnetId` | java.lang.String | [[cdk.support/lookup-entry]] | `:subnet-id` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnInstanceConnectEndpointProps$Builder builder id config]
  (when-let [data (lookup-entry config id :client-token)]
    (. builder clientToken data))
  (when-let [data (lookup-entry config id :preserve-client-ip)]
    (. builder preserveClientIp data))
  (when-let [data (lookup-entry config id :security-group-ids)]
    (. builder securityGroupIds data))
  (when-let [data (lookup-entry config id :subnet-id)]
    (. builder subnetId data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-instance-connect-endpoint-props-builder
  "Creates a  `CfnInstanceConnectEndpointProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-instance-connect-endpoint-props-builder (new CfnInstanceConnectEndpointProps$Builder) id config))


(defn build-cfn-instance-cpu-options-property-builder
  "The build-cfn-instance-cpu-options-property-builder function updates a CfnInstance$CpuOptionsProperty$Builder instance using the provided configuration.
  The function takes the CfnInstance$CpuOptionsProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `coreCount` | java.lang.Number | [[cdk.support/lookup-entry]] | `:core-count` |
| `threadsPerCore` | java.lang.Number | [[cdk.support/lookup-entry]] | `:threads-per-core` |
"
  [^CfnInstance$CpuOptionsProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :core-count)]
    (. builder coreCount data))
  (when-let [data (lookup-entry config id :threads-per-core)]
    (. builder threadsPerCore data))
  (.build builder))


(defn cfn-instance-cpu-options-property-builder
  "Creates a  `CfnInstance$CpuOptionsProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-instance-cpu-options-property-builder (new CfnInstance$CpuOptionsProperty$Builder) id config))


(defn build-cfn-instance-credit-specification-property-builder
  "The build-cfn-instance-credit-specification-property-builder function updates a CfnInstance$CreditSpecificationProperty$Builder instance using the provided configuration.
  The function takes the CfnInstance$CreditSpecificationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `cpuCredits` | java.lang.String | [[cdk.support/lookup-entry]] | `:cpu-credits` |
"
  [^CfnInstance$CreditSpecificationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :cpu-credits)]
    (. builder cpuCredits data))
  (.build builder))


(defn cfn-instance-credit-specification-property-builder
  "Creates a  `CfnInstance$CreditSpecificationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-instance-credit-specification-property-builder (new CfnInstance$CreditSpecificationProperty$Builder) id config))


(defn build-cfn-instance-ebs-property-builder
  "The build-cfn-instance-ebs-property-builder function updates a CfnInstance$EbsProperty$Builder instance using the provided configuration.
  The function takes the CfnInstance$EbsProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `deleteOnTermination` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:delete-on-termination` |
| `encrypted` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:encrypted` |
| `iops` | java.lang.Number | [[cdk.support/lookup-entry]] | `:iops` |
| `kmsKeyId` | java.lang.String | [[cdk.support/lookup-entry]] | `:kms-key-id` |
| `snapshotId` | java.lang.String | [[cdk.support/lookup-entry]] | `:snapshot-id` |
| `volumeSize` | java.lang.Number | [[cdk.support/lookup-entry]] | `:volume-size` |
| `volumeType` | java.lang.String | [[cdk.support/lookup-entry]] | `:volume-type` |
"
  [^CfnInstance$EbsProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :delete-on-termination)]
    (. builder deleteOnTermination data))
  (when-let [data (lookup-entry config id :encrypted)]
    (. builder encrypted data))
  (when-let [data (lookup-entry config id :iops)]
    (. builder iops data))
  (when-let [data (lookup-entry config id :kms-key-id)]
    (. builder kmsKeyId data))
  (when-let [data (lookup-entry config id :snapshot-id)]
    (. builder snapshotId data))
  (when-let [data (lookup-entry config id :volume-size)]
    (. builder volumeSize data))
  (when-let [data (lookup-entry config id :volume-type)]
    (. builder volumeType data))
  (.build builder))


(defn cfn-instance-ebs-property-builder
  "Creates a  `CfnInstance$EbsProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-instance-ebs-property-builder (new CfnInstance$EbsProperty$Builder) id config))


(defn build-cfn-instance-elastic-gpu-specification-property-builder
  "The build-cfn-instance-elastic-gpu-specification-property-builder function updates a CfnInstance$ElasticGpuSpecificationProperty$Builder instance using the provided configuration.
  The function takes the CfnInstance$ElasticGpuSpecificationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `type` | java.lang.String | [[cdk.support/lookup-entry]] | `:type` |
"
  [^CfnInstance$ElasticGpuSpecificationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :type)]
    (. builder type data))
  (.build builder))


(defn cfn-instance-elastic-gpu-specification-property-builder
  "Creates a  `CfnInstance$ElasticGpuSpecificationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-instance-elastic-gpu-specification-property-builder (new CfnInstance$ElasticGpuSpecificationProperty$Builder) id config))


(defn build-cfn-instance-elastic-inference-accelerator-property-builder
  "The build-cfn-instance-elastic-inference-accelerator-property-builder function updates a CfnInstance$ElasticInferenceAcceleratorProperty$Builder instance using the provided configuration.
  The function takes the CfnInstance$ElasticInferenceAcceleratorProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `count` | java.lang.Number | [[cdk.support/lookup-entry]] | `:count` |
| `type` | java.lang.String | [[cdk.support/lookup-entry]] | `:type` |
"
  [^CfnInstance$ElasticInferenceAcceleratorProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :count)]
    (. builder count data))
  (when-let [data (lookup-entry config id :type)]
    (. builder type data))
  (.build builder))


(defn cfn-instance-elastic-inference-accelerator-property-builder
  "Creates a  `CfnInstance$ElasticInferenceAcceleratorProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-instance-elastic-inference-accelerator-property-builder (new CfnInstance$ElasticInferenceAcceleratorProperty$Builder) id config))


(defn build-cfn-instance-enclave-options-property-builder
  "The build-cfn-instance-enclave-options-property-builder function updates a CfnInstance$EnclaveOptionsProperty$Builder instance using the provided configuration.
  The function takes the CfnInstance$EnclaveOptionsProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `enabled` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:enabled` |
"
  [^CfnInstance$EnclaveOptionsProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :enabled)]
    (. builder enabled data))
  (.build builder))


(defn cfn-instance-enclave-options-property-builder
  "Creates a  `CfnInstance$EnclaveOptionsProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-instance-enclave-options-property-builder (new CfnInstance$EnclaveOptionsProperty$Builder) id config))


(defn build-cfn-instance-hibernation-options-property-builder
  "The build-cfn-instance-hibernation-options-property-builder function updates a CfnInstance$HibernationOptionsProperty$Builder instance using the provided configuration.
  The function takes the CfnInstance$HibernationOptionsProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `configured` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:configured` |
"
  [^CfnInstance$HibernationOptionsProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :configured)]
    (. builder configured data))
  (.build builder))


(defn cfn-instance-hibernation-options-property-builder
  "Creates a  `CfnInstance$HibernationOptionsProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-instance-hibernation-options-property-builder (new CfnInstance$HibernationOptionsProperty$Builder) id config))


(defn build-cfn-instance-instance-ipv6-address-property-builder
  "The build-cfn-instance-instance-ipv6-address-property-builder function updates a CfnInstance$InstanceIpv6AddressProperty$Builder instance using the provided configuration.
  The function takes the CfnInstance$InstanceIpv6AddressProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `ipv6Address` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipv6-address` |
"
  [^CfnInstance$InstanceIpv6AddressProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :ipv6-address)]
    (. builder ipv6Address data))
  (.build builder))


(defn cfn-instance-instance-ipv6-address-property-builder
  "Creates a  `CfnInstance$InstanceIpv6AddressProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-instance-instance-ipv6-address-property-builder (new CfnInstance$InstanceIpv6AddressProperty$Builder) id config))


(defn build-cfn-instance-launch-template-specification-property-builder
  "The build-cfn-instance-launch-template-specification-property-builder function updates a CfnInstance$LaunchTemplateSpecificationProperty$Builder instance using the provided configuration.
  The function takes the CfnInstance$LaunchTemplateSpecificationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `launchTemplateId` | java.lang.String | [[cdk.support/lookup-entry]] | `:launch-template-id` |
| `launchTemplateName` | java.lang.String | [[cdk.support/lookup-entry]] | `:launch-template-name` |
| `version` | java.lang.String | [[cdk.support/lookup-entry]] | `:version` |
"
  [^CfnInstance$LaunchTemplateSpecificationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :launch-template-id)]
    (. builder launchTemplateId data))
  (when-let [data (lookup-entry config id :launch-template-name)]
    (. builder launchTemplateName data))
  (when-let [data (lookup-entry config id :version)]
    (. builder version data))
  (.build builder))


(defn cfn-instance-launch-template-specification-property-builder
  "Creates a  `CfnInstance$LaunchTemplateSpecificationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-instance-launch-template-specification-property-builder (new CfnInstance$LaunchTemplateSpecificationProperty$Builder) id config))


(defn build-cfn-instance-license-specification-property-builder
  "The build-cfn-instance-license-specification-property-builder function updates a CfnInstance$LicenseSpecificationProperty$Builder instance using the provided configuration.
  The function takes the CfnInstance$LicenseSpecificationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `licenseConfigurationArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:license-configuration-arn` |
"
  [^CfnInstance$LicenseSpecificationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :license-configuration-arn)]
    (. builder licenseConfigurationArn data))
  (.build builder))


(defn cfn-instance-license-specification-property-builder
  "Creates a  `CfnInstance$LicenseSpecificationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-instance-license-specification-property-builder (new CfnInstance$LicenseSpecificationProperty$Builder) id config))


(defn build-cfn-instance-network-interface-property-builder
  "The build-cfn-instance-network-interface-property-builder function updates a CfnInstance$NetworkInterfaceProperty$Builder instance using the provided configuration.
  The function takes the CfnInstance$NetworkInterfaceProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `associateCarrierIpAddress` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:associate-carrier-ip-address` |
| `associatePublicIpAddress` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:associate-public-ip-address` |
| `deleteOnTermination` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:delete-on-termination` |
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `deviceIndex` | java.lang.String | [[cdk.support/lookup-entry]] | `:device-index` |
| `groupSet` | java.util.List | [[cdk.support/lookup-entry]] | `:group-set` |
| `ipv6AddressCount` | java.lang.Number | [[cdk.support/lookup-entry]] | `:ipv6-address-count` |
| `ipv6Addresses` | java.util.List | [[cdk.support/lookup-entry]] | `:ipv6-addresses` |
| `networkInterfaceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-interface-id` |
| `privateIpAddress` | java.lang.String | [[cdk.support/lookup-entry]] | `:private-ip-address` |
| `privateIpAddresses` | java.util.List | [[cdk.support/lookup-entry]] | `:private-ip-addresses` |
| `secondaryPrivateIpAddressCount` | java.lang.Number | [[cdk.support/lookup-entry]] | `:secondary-private-ip-address-count` |
| `subnetId` | java.lang.String | [[cdk.support/lookup-entry]] | `:subnet-id` |
"
  [^CfnInstance$NetworkInterfaceProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :associate-carrier-ip-address)]
    (. builder associateCarrierIpAddress data))
  (when-let [data (lookup-entry config id :associate-public-ip-address)]
    (. builder associatePublicIpAddress data))
  (when-let [data (lookup-entry config id :delete-on-termination)]
    (. builder deleteOnTermination data))
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :device-index)]
    (. builder deviceIndex data))
  (when-let [data (lookup-entry config id :group-set)]
    (. builder groupSet data))
  (when-let [data (lookup-entry config id :ipv6-address-count)]
    (. builder ipv6AddressCount data))
  (when-let [data (lookup-entry config id :ipv6-addresses)]
    (. builder ipv6Addresses data))
  (when-let [data (lookup-entry config id :network-interface-id)]
    (. builder networkInterfaceId data))
  (when-let [data (lookup-entry config id :private-ip-address)]
    (. builder privateIpAddress data))
  (when-let [data (lookup-entry config id :private-ip-addresses)]
    (. builder privateIpAddresses data))
  (when-let [data (lookup-entry config id :secondary-private-ip-address-count)]
    (. builder secondaryPrivateIpAddressCount data))
  (when-let [data (lookup-entry config id :subnet-id)]
    (. builder subnetId data))
  (.build builder))


(defn cfn-instance-network-interface-property-builder
  "Creates a  `CfnInstance$NetworkInterfaceProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-instance-network-interface-property-builder (new CfnInstance$NetworkInterfaceProperty$Builder) id config))


(defn cfn-instance-no-device-property-builder
  "Creates a  `CfnInstance$NoDeviceProperty$Builder` instance using a no-argument construct,then builds it."
  []
  (.build (new CfnInstance$NoDeviceProperty$Builder)))


(defn build-cfn-instance-private-dns-name-options-property-builder
  "The build-cfn-instance-private-dns-name-options-property-builder function updates a CfnInstance$PrivateDnsNameOptionsProperty$Builder instance using the provided configuration.
  The function takes the CfnInstance$PrivateDnsNameOptionsProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `enableResourceNameDnsARecord` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:enable-resource-name-dns-a-record` |
| `enableResourceNameDnsAaaaRecord` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:enable-resource-name-dns-aaaa-record` |
| `hostnameType` | java.lang.String | [[cdk.support/lookup-entry]] | `:hostname-type` |
"
  [^CfnInstance$PrivateDnsNameOptionsProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :enable-resource-name-dns-a-record)]
    (. builder enableResourceNameDnsARecord data))
  (when-let [data (lookup-entry config id :enable-resource-name-dns-aaaa-record)]
    (. builder enableResourceNameDnsAaaaRecord data))
  (when-let [data (lookup-entry config id :hostname-type)]
    (. builder hostnameType data))
  (.build builder))


(defn cfn-instance-private-dns-name-options-property-builder
  "Creates a  `CfnInstance$PrivateDnsNameOptionsProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-instance-private-dns-name-options-property-builder (new CfnInstance$PrivateDnsNameOptionsProperty$Builder) id config))


(defn build-cfn-instance-private-ip-address-specification-property-builder
  "The build-cfn-instance-private-ip-address-specification-property-builder function updates a CfnInstance$PrivateIpAddressSpecificationProperty$Builder instance using the provided configuration.
  The function takes the CfnInstance$PrivateIpAddressSpecificationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `primary` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:primary` |
| `privateIpAddress` | java.lang.String | [[cdk.support/lookup-entry]] | `:private-ip-address` |
"
  [^CfnInstance$PrivateIpAddressSpecificationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :primary)]
    (. builder primary data))
  (when-let [data (lookup-entry config id :private-ip-address)]
    (. builder privateIpAddress data))
  (.build builder))


(defn cfn-instance-private-ip-address-specification-property-builder
  "Creates a  `CfnInstance$PrivateIpAddressSpecificationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-instance-private-ip-address-specification-property-builder (new CfnInstance$PrivateIpAddressSpecificationProperty$Builder) id config))


(defn build-cfn-instance-props-builder
  "The build-cfn-instance-props-builder function updates a CfnInstanceProps$Builder instance using the provided configuration.
  The function takes the CfnInstanceProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `additionalInfo` | java.lang.String | [[cdk.support/lookup-entry]] | `:additional-info` |
| `affinity` | java.lang.String | [[cdk.support/lookup-entry]] | `:affinity` |
| `availabilityZone` | java.lang.String | [[cdk.support/lookup-entry]] | `:availability-zone` |
| `blockDeviceMappings` | java.util.List | [[cdk.support/lookup-entry]] | `:block-device-mappings` |
| `cpuOptions` | software.amazon.awscdk.services.ec2.CfnInstance$CpuOptionsProperty | [[cdk.support/lookup-entry]] | `:cpu-options` |
| `creditSpecification` | software.amazon.awscdk.services.ec2.CfnInstance$CreditSpecificationProperty | [[cdk.support/lookup-entry]] | `:credit-specification` |
| `disableApiTermination` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:disable-api-termination` |
| `ebsOptimized` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:ebs-optimized` |
| `elasticGpuSpecifications` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:elastic-gpu-specifications` |
| `elasticInferenceAccelerators` | java.util.List | [[cdk.support/lookup-entry]] | `:elastic-inference-accelerators` |
| `enclaveOptions` | software.amazon.awscdk.services.ec2.CfnInstance$EnclaveOptionsProperty | [[cdk.support/lookup-entry]] | `:enclave-options` |
| `hibernationOptions` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:hibernation-options` |
| `hostId` | java.lang.String | [[cdk.support/lookup-entry]] | `:host-id` |
| `hostResourceGroupArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:host-resource-group-arn` |
| `iamInstanceProfile` | java.lang.String | [[cdk.support/lookup-entry]] | `:iam-instance-profile` |
| `imageId` | java.lang.String | [[cdk.support/lookup-entry]] | `:image-id` |
| `instanceInitiatedShutdownBehavior` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-initiated-shutdown-behavior` |
| `instanceType` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-type` |
| `ipv6AddressCount` | java.lang.Number | [[cdk.support/lookup-entry]] | `:ipv6-address-count` |
| `ipv6Addresses` | java.util.List | [[cdk.support/lookup-entry]] | `:ipv6-addresses` |
| `kernelId` | java.lang.String | [[cdk.support/lookup-entry]] | `:kernel-id` |
| `keyName` | java.lang.String | [[cdk.support/lookup-entry]] | `:key-name` |
| `launchTemplate` | software.amazon.awscdk.services.ec2.CfnInstance$LaunchTemplateSpecificationProperty | [[cdk.support/lookup-entry]] | `:launch-template` |
| `licenseSpecifications` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:license-specifications` |
| `monitoring` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:monitoring` |
| `networkInterfaces` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:network-interfaces` |
| `placementGroupName` | java.lang.String | [[cdk.support/lookup-entry]] | `:placement-group-name` |
| `privateDnsNameOptions` | software.amazon.awscdk.services.ec2.CfnInstance$PrivateDnsNameOptionsProperty | [[cdk.support/lookup-entry]] | `:private-dns-name-options` |
| `privateIpAddress` | java.lang.String | [[cdk.support/lookup-entry]] | `:private-ip-address` |
| `propagateTagsToVolumeOnCreation` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:propagate-tags-to-volume-on-creation` |
| `ramdiskId` | java.lang.String | [[cdk.support/lookup-entry]] | `:ramdisk-id` |
| `securityGroupIds` | java.util.List | [[cdk.support/lookup-entry]] | `:security-group-ids` |
| `securityGroups` | java.util.List | [[cdk.support/lookup-entry]] | `:security-groups` |
| `sourceDestCheck` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:source-dest-check` |
| `ssmAssociations` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:ssm-associations` |
| `subnetId` | java.lang.String | [[cdk.support/lookup-entry]] | `:subnet-id` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `tenancy` | java.lang.String | [[cdk.support/lookup-entry]] | `:tenancy` |
| `userData` | java.lang.String | [[cdk.support/lookup-entry]] | `:user-data` |
| `volumes` | java.util.List | [[cdk.support/lookup-entry]] | `:volumes` |
"
  [^CfnInstanceProps$Builder builder id config]
  (when-let [data (lookup-entry config id :additional-info)]
    (. builder additionalInfo data))
  (when-let [data (lookup-entry config id :affinity)]
    (. builder affinity data))
  (when-let [data (lookup-entry config id :availability-zone)]
    (. builder availabilityZone data))
  (when-let [data (lookup-entry config id :block-device-mappings)]
    (. builder blockDeviceMappings data))
  (when-let [data (lookup-entry config id :cpu-options)]
    (. builder cpuOptions data))
  (when-let [data (lookup-entry config id :credit-specification)]
    (. builder creditSpecification data))
  (when-let [data (lookup-entry config id :disable-api-termination)]
    (. builder disableApiTermination data))
  (when-let [data (lookup-entry config id :ebs-optimized)]
    (. builder ebsOptimized data))
  (when-let [data (lookup-entry config id :elastic-gpu-specifications)]
    (. builder elasticGpuSpecifications data))
  (when-let [data (lookup-entry config id :elastic-inference-accelerators)]
    (. builder elasticInferenceAccelerators data))
  (when-let [data (lookup-entry config id :enclave-options)]
    (. builder enclaveOptions data))
  (when-let [data (lookup-entry config id :hibernation-options)]
    (. builder hibernationOptions data))
  (when-let [data (lookup-entry config id :host-id)]
    (. builder hostId data))
  (when-let [data (lookup-entry config id :host-resource-group-arn)]
    (. builder hostResourceGroupArn data))
  (when-let [data (lookup-entry config id :iam-instance-profile)]
    (. builder iamInstanceProfile data))
  (when-let [data (lookup-entry config id :image-id)]
    (. builder imageId data))
  (when-let [data (lookup-entry config id :instance-initiated-shutdown-behavior)]
    (. builder instanceInitiatedShutdownBehavior data))
  (when-let [data (lookup-entry config id :instance-type)]
    (. builder instanceType data))
  (when-let [data (lookup-entry config id :ipv6-address-count)]
    (. builder ipv6AddressCount data))
  (when-let [data (lookup-entry config id :ipv6-addresses)]
    (. builder ipv6Addresses data))
  (when-let [data (lookup-entry config id :kernel-id)]
    (. builder kernelId data))
  (when-let [data (lookup-entry config id :key-name)]
    (. builder keyName data))
  (when-let [data (lookup-entry config id :launch-template)]
    (. builder launchTemplate data))
  (when-let [data (lookup-entry config id :license-specifications)]
    (. builder licenseSpecifications data))
  (when-let [data (lookup-entry config id :monitoring)]
    (. builder monitoring data))
  (when-let [data (lookup-entry config id :network-interfaces)]
    (. builder networkInterfaces data))
  (when-let [data (lookup-entry config id :placement-group-name)]
    (. builder placementGroupName data))
  (when-let [data (lookup-entry config id :private-dns-name-options)]
    (. builder privateDnsNameOptions data))
  (when-let [data (lookup-entry config id :private-ip-address)]
    (. builder privateIpAddress data))
  (when-let [data (lookup-entry config id :propagate-tags-to-volume-on-creation)]
    (. builder propagateTagsToVolumeOnCreation data))
  (when-let [data (lookup-entry config id :ramdisk-id)]
    (. builder ramdiskId data))
  (when-let [data (lookup-entry config id :security-group-ids)]
    (. builder securityGroupIds data))
  (when-let [data (lookup-entry config id :security-groups)]
    (. builder securityGroups data))
  (when-let [data (lookup-entry config id :source-dest-check)]
    (. builder sourceDestCheck data))
  (when-let [data (lookup-entry config id :ssm-associations)]
    (. builder ssmAssociations data))
  (when-let [data (lookup-entry config id :subnet-id)]
    (. builder subnetId data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :tenancy)]
    (. builder tenancy data))
  (when-let [data (lookup-entry config id :user-data)]
    (. builder userData data))
  (when-let [data (lookup-entry config id :volumes)]
    (. builder volumes data))
  (.build builder))


(defn cfn-instance-props-builder
  "Creates a  `CfnInstanceProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-instance-props-builder (new CfnInstanceProps$Builder) id config))


(defn build-cfn-instance-ssm-association-property-builder
  "The build-cfn-instance-ssm-association-property-builder function updates a CfnInstance$SsmAssociationProperty$Builder instance using the provided configuration.
  The function takes the CfnInstance$SsmAssociationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `associationParameters` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:association-parameters` |
| `documentName` | java.lang.String | [[cdk.support/lookup-entry]] | `:document-name` |
"
  [^CfnInstance$SsmAssociationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :association-parameters)]
    (. builder associationParameters data))
  (when-let [data (lookup-entry config id :document-name)]
    (. builder documentName data))
  (.build builder))


(defn cfn-instance-ssm-association-property-builder
  "Creates a  `CfnInstance$SsmAssociationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-instance-ssm-association-property-builder (new CfnInstance$SsmAssociationProperty$Builder) id config))


(defn build-cfn-instance-state-property-builder
  "The build-cfn-instance-state-property-builder function updates a CfnInstance$StateProperty$Builder instance using the provided configuration.
  The function takes the CfnInstance$StateProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `code` | java.lang.String | [[cdk.support/lookup-entry]] | `:code` |
| `name` | java.lang.String | [[cdk.support/lookup-entry]] | `:name` |
"
  [^CfnInstance$StateProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :code)]
    (. builder code data))
  (when-let [data (lookup-entry config id :name)]
    (. builder name data))
  (.build builder))


(defn cfn-instance-state-property-builder
  "Creates a  `CfnInstance$StateProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-instance-state-property-builder (new CfnInstance$StateProperty$Builder) id config))


(defn build-cfn-instance-volume-property-builder
  "The build-cfn-instance-volume-property-builder function updates a CfnInstance$VolumeProperty$Builder instance using the provided configuration.
  The function takes the CfnInstance$VolumeProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `device` | java.lang.String | [[cdk.support/lookup-entry]] | `:device` |
| `volumeId` | java.lang.String | [[cdk.support/lookup-entry]] | `:volume-id` |
"
  [^CfnInstance$VolumeProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :device)]
    (. builder device data))
  (when-let [data (lookup-entry config id :volume-id)]
    (. builder volumeId data))
  (.build builder))


(defn cfn-instance-volume-property-builder
  "Creates a  `CfnInstance$VolumeProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-instance-volume-property-builder (new CfnInstance$VolumeProperty$Builder) id config))


(defn build-cfn-internet-gateway-builder
  "The build-cfn-internet-gateway-builder function updates a CfnInternetGateway$Builder instance using the provided configuration.
  The function takes the CfnInternetGateway$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnInternetGateway$Builder builder id config]
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-internet-gateway-builder
  "Creates a  `CfnInternetGateway$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-internet-gateway-builder (CfnInternetGateway$Builder/create scope (name id)) id config))


(defn build-cfn-internet-gateway-props-builder
  "The build-cfn-internet-gateway-props-builder function updates a CfnInternetGatewayProps$Builder instance using the provided configuration.
  The function takes the CfnInternetGatewayProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnInternetGatewayProps$Builder builder id config]
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-internet-gateway-props-builder
  "Creates a  `CfnInternetGatewayProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-internet-gateway-props-builder (new CfnInternetGatewayProps$Builder) id config))


(defn build-cfn-ipam-allocation-builder
  "The build-cfn-ipam-allocation-builder function updates a CfnIPAMAllocation$Builder instance using the provided configuration.
  The function takes the CfnIPAMAllocation$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `cidr` | java.lang.String | [[cdk.support/lookup-entry]] | `:cidr` |
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `ipamPoolId` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipam-pool-id` |
| `netmaskLength` | java.lang.Number | [[cdk.support/lookup-entry]] | `:netmask-length` |
"
  [^CfnIPAMAllocation$Builder builder id config]
  (when-let [data (lookup-entry config id :cidr)]
    (. builder cidr data))
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :ipam-pool-id)]
    (. builder ipamPoolId data))
  (when-let [data (lookup-entry config id :netmask-length)]
    (. builder netmaskLength data))
  (.build builder))


(defn cfn-ipam-allocation-builder
  "Creates a  `CfnIPAMAllocation$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-ipam-allocation-builder (CfnIPAMAllocation$Builder/create scope (name id)) id config))


(defn build-cfn-ipam-allocation-props-builder
  "The build-cfn-ipam-allocation-props-builder function updates a CfnIPAMAllocationProps$Builder instance using the provided configuration.
  The function takes the CfnIPAMAllocationProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `cidr` | java.lang.String | [[cdk.support/lookup-entry]] | `:cidr` |
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `ipamPoolId` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipam-pool-id` |
| `netmaskLength` | java.lang.Number | [[cdk.support/lookup-entry]] | `:netmask-length` |
"
  [^CfnIPAMAllocationProps$Builder builder id config]
  (when-let [data (lookup-entry config id :cidr)]
    (. builder cidr data))
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :ipam-pool-id)]
    (. builder ipamPoolId data))
  (when-let [data (lookup-entry config id :netmask-length)]
    (. builder netmaskLength data))
  (.build builder))


(defn cfn-ipam-allocation-props-builder
  "Creates a  `CfnIPAMAllocationProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-ipam-allocation-props-builder (new CfnIPAMAllocationProps$Builder) id config))


(defn build-cfn-ipam-builder
  "The build-cfn-ipam-builder function updates a CfnIPAM$Builder instance using the provided configuration.
  The function takes the CfnIPAM$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `operatingRegions` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:operating-regions` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `tier` | java.lang.String | [[cdk.support/lookup-entry]] | `:tier` |
"
  [^CfnIPAM$Builder builder id config]
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :operating-regions)]
    (. builder operatingRegions data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :tier)]
    (. builder tier data))
  (.build builder))


(defn cfn-ipam-builder
  "Creates a  `CfnIPAM$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-ipam-builder (CfnIPAM$Builder/create scope (name id)) id config))


(defn build-cfn-ipam-ipam-operating-region-property-builder
  "The build-cfn-ipam-ipam-operating-region-property-builder function updates a CfnIPAM$IpamOperatingRegionProperty$Builder instance using the provided configuration.
  The function takes the CfnIPAM$IpamOperatingRegionProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `regionName` | java.lang.String | [[cdk.support/lookup-entry]] | `:region-name` |
"
  [^CfnIPAM$IpamOperatingRegionProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :region-name)]
    (. builder regionName data))
  (.build builder))


(defn cfn-ipam-ipam-operating-region-property-builder
  "Creates a  `CfnIPAM$IpamOperatingRegionProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-ipam-ipam-operating-region-property-builder (new CfnIPAM$IpamOperatingRegionProperty$Builder) id config))


(defn build-cfn-ipam-pool-builder
  "The build-cfn-ipam-pool-builder function updates a CfnIPAMPool$Builder instance using the provided configuration.
  The function takes the CfnIPAMPool$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `addressFamily` | java.lang.String | [[cdk.support/lookup-entry]] | `:address-family` |
| `allocationDefaultNetmaskLength` | java.lang.Number | [[cdk.support/lookup-entry]] | `:allocation-default-netmask-length` |
| `allocationMaxNetmaskLength` | java.lang.Number | [[cdk.support/lookup-entry]] | `:allocation-max-netmask-length` |
| `allocationMinNetmaskLength` | java.lang.Number | [[cdk.support/lookup-entry]] | `:allocation-min-netmask-length` |
| `allocationResourceTags` | java.util.List | [[cdk.support/lookup-entry]] | `:allocation-resource-tags` |
| `autoImport` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:auto-import` |
| `awsService` | java.lang.String | [[cdk.support/lookup-entry]] | `:aws-service` |
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `ipamScopeId` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipam-scope-id` |
| `locale` | java.lang.String | [[cdk.support/lookup-entry]] | `:locale` |
| `provisionedCidrs` | java.util.List | [[cdk.support/lookup-entry]] | `:provisioned-cidrs` |
| `publicIpSource` | java.lang.String | [[cdk.support/lookup-entry]] | `:public-ip-source` |
| `publiclyAdvertisable` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:publicly-advertisable` |
| `sourceIpamPoolId` | java.lang.String | [[cdk.support/lookup-entry]] | `:source-ipam-pool-id` |
| `sourceResource` | software.amazon.awscdk.services.ec2.CfnIPAMPool$SourceResourceProperty | [[cdk.support/lookup-entry]] | `:source-resource` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnIPAMPool$Builder builder id config]
  (when-let [data (lookup-entry config id :address-family)]
    (. builder addressFamily data))
  (when-let [data (lookup-entry config id :allocation-default-netmask-length)]
    (. builder allocationDefaultNetmaskLength data))
  (when-let [data (lookup-entry config id :allocation-max-netmask-length)]
    (. builder allocationMaxNetmaskLength data))
  (when-let [data (lookup-entry config id :allocation-min-netmask-length)]
    (. builder allocationMinNetmaskLength data))
  (when-let [data (lookup-entry config id :allocation-resource-tags)]
    (. builder allocationResourceTags data))
  (when-let [data (lookup-entry config id :auto-import)]
    (. builder autoImport data))
  (when-let [data (lookup-entry config id :aws-service)]
    (. builder awsService data))
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :ipam-scope-id)]
    (. builder ipamScopeId data))
  (when-let [data (lookup-entry config id :locale)]
    (. builder locale data))
  (when-let [data (lookup-entry config id :provisioned-cidrs)]
    (. builder provisionedCidrs data))
  (when-let [data (lookup-entry config id :public-ip-source)]
    (. builder publicIpSource data))
  (when-let [data (lookup-entry config id :publicly-advertisable)]
    (. builder publiclyAdvertisable data))
  (when-let [data (lookup-entry config id :source-ipam-pool-id)]
    (. builder sourceIpamPoolId data))
  (when-let [data (lookup-entry config id :source-resource)]
    (. builder sourceResource data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-ipam-pool-builder
  "Creates a  `CfnIPAMPool$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-ipam-pool-builder (CfnIPAMPool$Builder/create scope (name id)) id config))


(defn build-cfn-ipam-pool-cidr-builder
  "The build-cfn-ipam-pool-cidr-builder function updates a CfnIPAMPoolCidr$Builder instance using the provided configuration.
  The function takes the CfnIPAMPoolCidr$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `cidr` | java.lang.String | [[cdk.support/lookup-entry]] | `:cidr` |
| `ipamPoolId` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipam-pool-id` |
| `netmaskLength` | java.lang.Number | [[cdk.support/lookup-entry]] | `:netmask-length` |
"
  [^CfnIPAMPoolCidr$Builder builder id config]
  (when-let [data (lookup-entry config id :cidr)]
    (. builder cidr data))
  (when-let [data (lookup-entry config id :ipam-pool-id)]
    (. builder ipamPoolId data))
  (when-let [data (lookup-entry config id :netmask-length)]
    (. builder netmaskLength data))
  (.build builder))


(defn cfn-ipam-pool-cidr-builder
  "Creates a  `CfnIPAMPoolCidr$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-ipam-pool-cidr-builder (CfnIPAMPoolCidr$Builder/create scope (name id)) id config))


(defn build-cfn-ipam-pool-cidr-props-builder
  "The build-cfn-ipam-pool-cidr-props-builder function updates a CfnIPAMPoolCidrProps$Builder instance using the provided configuration.
  The function takes the CfnIPAMPoolCidrProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `cidr` | java.lang.String | [[cdk.support/lookup-entry]] | `:cidr` |
| `ipamPoolId` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipam-pool-id` |
| `netmaskLength` | java.lang.Number | [[cdk.support/lookup-entry]] | `:netmask-length` |
"
  [^CfnIPAMPoolCidrProps$Builder builder id config]
  (when-let [data (lookup-entry config id :cidr)]
    (. builder cidr data))
  (when-let [data (lookup-entry config id :ipam-pool-id)]
    (. builder ipamPoolId data))
  (when-let [data (lookup-entry config id :netmask-length)]
    (. builder netmaskLength data))
  (.build builder))


(defn cfn-ipam-pool-cidr-props-builder
  "Creates a  `CfnIPAMPoolCidrProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-ipam-pool-cidr-props-builder (new CfnIPAMPoolCidrProps$Builder) id config))


(defn build-cfn-ipam-pool-props-builder
  "The build-cfn-ipam-pool-props-builder function updates a CfnIPAMPoolProps$Builder instance using the provided configuration.
  The function takes the CfnIPAMPoolProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `addressFamily` | java.lang.String | [[cdk.support/lookup-entry]] | `:address-family` |
| `allocationDefaultNetmaskLength` | java.lang.Number | [[cdk.support/lookup-entry]] | `:allocation-default-netmask-length` |
| `allocationMaxNetmaskLength` | java.lang.Number | [[cdk.support/lookup-entry]] | `:allocation-max-netmask-length` |
| `allocationMinNetmaskLength` | java.lang.Number | [[cdk.support/lookup-entry]] | `:allocation-min-netmask-length` |
| `allocationResourceTags` | java.util.List | [[cdk.support/lookup-entry]] | `:allocation-resource-tags` |
| `autoImport` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:auto-import` |
| `awsService` | java.lang.String | [[cdk.support/lookup-entry]] | `:aws-service` |
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `ipamScopeId` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipam-scope-id` |
| `locale` | java.lang.String | [[cdk.support/lookup-entry]] | `:locale` |
| `provisionedCidrs` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:provisioned-cidrs` |
| `publicIpSource` | java.lang.String | [[cdk.support/lookup-entry]] | `:public-ip-source` |
| `publiclyAdvertisable` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:publicly-advertisable` |
| `sourceIpamPoolId` | java.lang.String | [[cdk.support/lookup-entry]] | `:source-ipam-pool-id` |
| `sourceResource` | software.amazon.awscdk.services.ec2.CfnIPAMPool$SourceResourceProperty | [[cdk.support/lookup-entry]] | `:source-resource` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnIPAMPoolProps$Builder builder id config]
  (when-let [data (lookup-entry config id :address-family)]
    (. builder addressFamily data))
  (when-let [data (lookup-entry config id :allocation-default-netmask-length)]
    (. builder allocationDefaultNetmaskLength data))
  (when-let [data (lookup-entry config id :allocation-max-netmask-length)]
    (. builder allocationMaxNetmaskLength data))
  (when-let [data (lookup-entry config id :allocation-min-netmask-length)]
    (. builder allocationMinNetmaskLength data))
  (when-let [data (lookup-entry config id :allocation-resource-tags)]
    (. builder allocationResourceTags data))
  (when-let [data (lookup-entry config id :auto-import)]
    (. builder autoImport data))
  (when-let [data (lookup-entry config id :aws-service)]
    (. builder awsService data))
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :ipam-scope-id)]
    (. builder ipamScopeId data))
  (when-let [data (lookup-entry config id :locale)]
    (. builder locale data))
  (when-let [data (lookup-entry config id :provisioned-cidrs)]
    (. builder provisionedCidrs data))
  (when-let [data (lookup-entry config id :public-ip-source)]
    (. builder publicIpSource data))
  (when-let [data (lookup-entry config id :publicly-advertisable)]
    (. builder publiclyAdvertisable data))
  (when-let [data (lookup-entry config id :source-ipam-pool-id)]
    (. builder sourceIpamPoolId data))
  (when-let [data (lookup-entry config id :source-resource)]
    (. builder sourceResource data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-ipam-pool-props-builder
  "Creates a  `CfnIPAMPoolProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-ipam-pool-props-builder (new CfnIPAMPoolProps$Builder) id config))


(defn build-cfn-ipam-pool-provisioned-cidr-property-builder
  "The build-cfn-ipam-pool-provisioned-cidr-property-builder function updates a CfnIPAMPool$ProvisionedCidrProperty$Builder instance using the provided configuration.
  The function takes the CfnIPAMPool$ProvisionedCidrProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `cidr` | java.lang.String | [[cdk.support/lookup-entry]] | `:cidr` |
"
  [^CfnIPAMPool$ProvisionedCidrProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :cidr)]
    (. builder cidr data))
  (.build builder))


(defn cfn-ipam-pool-provisioned-cidr-property-builder
  "Creates a  `CfnIPAMPool$ProvisionedCidrProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-ipam-pool-provisioned-cidr-property-builder (new CfnIPAMPool$ProvisionedCidrProperty$Builder) id config))


(defn build-cfn-ipam-pool-source-resource-property-builder
  "The build-cfn-ipam-pool-source-resource-property-builder function updates a CfnIPAMPool$SourceResourceProperty$Builder instance using the provided configuration.
  The function takes the CfnIPAMPool$SourceResourceProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `resourceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:resource-id` |
| `resourceOwner` | java.lang.String | [[cdk.support/lookup-entry]] | `:resource-owner` |
| `resourceRegion` | java.lang.String | [[cdk.support/lookup-entry]] | `:resource-region` |
| `resourceType` | java.lang.String | [[cdk.support/lookup-entry]] | `:resource-type` |
"
  [^CfnIPAMPool$SourceResourceProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :resource-id)]
    (. builder resourceId data))
  (when-let [data (lookup-entry config id :resource-owner)]
    (. builder resourceOwner data))
  (when-let [data (lookup-entry config id :resource-region)]
    (. builder resourceRegion data))
  (when-let [data (lookup-entry config id :resource-type)]
    (. builder resourceType data))
  (.build builder))


(defn cfn-ipam-pool-source-resource-property-builder
  "Creates a  `CfnIPAMPool$SourceResourceProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-ipam-pool-source-resource-property-builder (new CfnIPAMPool$SourceResourceProperty$Builder) id config))


(defn build-cfn-ipam-props-builder
  "The build-cfn-ipam-props-builder function updates a CfnIPAMProps$Builder instance using the provided configuration.
  The function takes the CfnIPAMProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `operatingRegions` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:operating-regions` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `tier` | java.lang.String | [[cdk.support/lookup-entry]] | `:tier` |
"
  [^CfnIPAMProps$Builder builder id config]
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :operating-regions)]
    (. builder operatingRegions data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :tier)]
    (. builder tier data))
  (.build builder))


(defn cfn-ipam-props-builder
  "Creates a  `CfnIPAMProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-ipam-props-builder (new CfnIPAMProps$Builder) id config))


(defn build-cfn-ipam-resource-discovery-association-builder
  "The build-cfn-ipam-resource-discovery-association-builder function updates a CfnIPAMResourceDiscoveryAssociation$Builder instance using the provided configuration.
  The function takes the CfnIPAMResourceDiscoveryAssociation$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `ipamId` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipam-id` |
| `ipamResourceDiscoveryId` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipam-resource-discovery-id` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnIPAMResourceDiscoveryAssociation$Builder builder id config]
  (when-let [data (lookup-entry config id :ipam-id)]
    (. builder ipamId data))
  (when-let [data (lookup-entry config id :ipam-resource-discovery-id)]
    (. builder ipamResourceDiscoveryId data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-ipam-resource-discovery-association-builder
  "Creates a  `CfnIPAMResourceDiscoveryAssociation$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-ipam-resource-discovery-association-builder (CfnIPAMResourceDiscoveryAssociation$Builder/create scope (name id)) id config))


(defn build-cfn-ipam-resource-discovery-association-props-builder
  "The build-cfn-ipam-resource-discovery-association-props-builder function updates a CfnIPAMResourceDiscoveryAssociationProps$Builder instance using the provided configuration.
  The function takes the CfnIPAMResourceDiscoveryAssociationProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `ipamId` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipam-id` |
| `ipamResourceDiscoveryId` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipam-resource-discovery-id` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnIPAMResourceDiscoveryAssociationProps$Builder builder id config]
  (when-let [data (lookup-entry config id :ipam-id)]
    (. builder ipamId data))
  (when-let [data (lookup-entry config id :ipam-resource-discovery-id)]
    (. builder ipamResourceDiscoveryId data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-ipam-resource-discovery-association-props-builder
  "Creates a  `CfnIPAMResourceDiscoveryAssociationProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-ipam-resource-discovery-association-props-builder (new CfnIPAMResourceDiscoveryAssociationProps$Builder) id config))


(defn build-cfn-ipam-resource-discovery-builder
  "The build-cfn-ipam-resource-discovery-builder function updates a CfnIPAMResourceDiscovery$Builder instance using the provided configuration.
  The function takes the CfnIPAMResourceDiscovery$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `operatingRegions` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:operating-regions` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnIPAMResourceDiscovery$Builder builder id config]
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :operating-regions)]
    (. builder operatingRegions data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-ipam-resource-discovery-builder
  "Creates a  `CfnIPAMResourceDiscovery$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-ipam-resource-discovery-builder (CfnIPAMResourceDiscovery$Builder/create scope (name id)) id config))


(defn build-cfn-ipam-resource-discovery-ipam-operating-region-property-builder
  "The build-cfn-ipam-resource-discovery-ipam-operating-region-property-builder function updates a CfnIPAMResourceDiscovery$IpamOperatingRegionProperty$Builder instance using the provided configuration.
  The function takes the CfnIPAMResourceDiscovery$IpamOperatingRegionProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `regionName` | java.lang.String | [[cdk.support/lookup-entry]] | `:region-name` |
"
  [^CfnIPAMResourceDiscovery$IpamOperatingRegionProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :region-name)]
    (. builder regionName data))
  (.build builder))


(defn cfn-ipam-resource-discovery-ipam-operating-region-property-builder
  "Creates a  `CfnIPAMResourceDiscovery$IpamOperatingRegionProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-ipam-resource-discovery-ipam-operating-region-property-builder (new CfnIPAMResourceDiscovery$IpamOperatingRegionProperty$Builder) id config))


(defn build-cfn-ipam-resource-discovery-props-builder
  "The build-cfn-ipam-resource-discovery-props-builder function updates a CfnIPAMResourceDiscoveryProps$Builder instance using the provided configuration.
  The function takes the CfnIPAMResourceDiscoveryProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `operatingRegions` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:operating-regions` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnIPAMResourceDiscoveryProps$Builder builder id config]
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :operating-regions)]
    (. builder operatingRegions data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-ipam-resource-discovery-props-builder
  "Creates a  `CfnIPAMResourceDiscoveryProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-ipam-resource-discovery-props-builder (new CfnIPAMResourceDiscoveryProps$Builder) id config))


(defn build-cfn-ipam-scope-builder
  "The build-cfn-ipam-scope-builder function updates a CfnIPAMScope$Builder instance using the provided configuration.
  The function takes the CfnIPAMScope$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `ipamId` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipam-id` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnIPAMScope$Builder builder id config]
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :ipam-id)]
    (. builder ipamId data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-ipam-scope-builder
  "Creates a  `CfnIPAMScope$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-ipam-scope-builder (CfnIPAMScope$Builder/create scope (name id)) id config))


(defn build-cfn-ipam-scope-props-builder
  "The build-cfn-ipam-scope-props-builder function updates a CfnIPAMScopeProps$Builder instance using the provided configuration.
  The function takes the CfnIPAMScopeProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `ipamId` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipam-id` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnIPAMScopeProps$Builder builder id config]
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :ipam-id)]
    (. builder ipamId data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-ipam-scope-props-builder
  "Creates a  `CfnIPAMScopeProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-ipam-scope-props-builder (new CfnIPAMScopeProps$Builder) id config))


(defn build-cfn-key-pair-builder
  "The build-cfn-key-pair-builder function updates a CfnKeyPair$Builder instance using the provided configuration.
  The function takes the CfnKeyPair$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `keyFormat` | java.lang.String | [[cdk.support/lookup-entry]] | `:key-format` |
| `keyName` | java.lang.String | [[cdk.support/lookup-entry]] | `:key-name` |
| `keyType` | java.lang.String | [[cdk.support/lookup-entry]] | `:key-type` |
| `publicKeyMaterial` | java.lang.String | [[cdk.support/lookup-entry]] | `:public-key-material` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnKeyPair$Builder builder id config]
  (when-let [data (lookup-entry config id :key-format)]
    (. builder keyFormat data))
  (when-let [data (lookup-entry config id :key-name)]
    (. builder keyName data))
  (when-let [data (lookup-entry config id :key-type)]
    (. builder keyType data))
  (when-let [data (lookup-entry config id :public-key-material)]
    (. builder publicKeyMaterial data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-key-pair-builder
  "Creates a  `CfnKeyPair$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-key-pair-builder (CfnKeyPair$Builder/create scope (name id)) id config))


(defn build-cfn-key-pair-props-builder
  "The build-cfn-key-pair-props-builder function updates a CfnKeyPairProps$Builder instance using the provided configuration.
  The function takes the CfnKeyPairProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `keyFormat` | java.lang.String | [[cdk.support/lookup-entry]] | `:key-format` |
| `keyName` | java.lang.String | [[cdk.support/lookup-entry]] | `:key-name` |
| `keyType` | java.lang.String | [[cdk.support/lookup-entry]] | `:key-type` |
| `publicKeyMaterial` | java.lang.String | [[cdk.support/lookup-entry]] | `:public-key-material` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnKeyPairProps$Builder builder id config]
  (when-let [data (lookup-entry config id :key-format)]
    (. builder keyFormat data))
  (when-let [data (lookup-entry config id :key-name)]
    (. builder keyName data))
  (when-let [data (lookup-entry config id :key-type)]
    (. builder keyType data))
  (when-let [data (lookup-entry config id :public-key-material)]
    (. builder publicKeyMaterial data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-key-pair-props-builder
  "Creates a  `CfnKeyPairProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-key-pair-props-builder (new CfnKeyPairProps$Builder) id config))


(defn build-cfn-launch-template-accelerator-count-property-builder
  "The build-cfn-launch-template-accelerator-count-property-builder function updates a CfnLaunchTemplate$AcceleratorCountProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$AcceleratorCountProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `max` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max` |
| `min` | java.lang.Number | [[cdk.support/lookup-entry]] | `:min` |
"
  [^CfnLaunchTemplate$AcceleratorCountProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :max)]
    (. builder max data))
  (when-let [data (lookup-entry config id :min)]
    (. builder min data))
  (.build builder))


(defn cfn-launch-template-accelerator-count-property-builder
  "Creates a  `CfnLaunchTemplate$AcceleratorCountProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-accelerator-count-property-builder (new CfnLaunchTemplate$AcceleratorCountProperty$Builder) id config))


(defn build-cfn-launch-template-accelerator-total-memory-mi-b-property-builder
  "The build-cfn-launch-template-accelerator-total-memory-mi-b-property-builder function updates a CfnLaunchTemplate$AcceleratorTotalMemoryMiBProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$AcceleratorTotalMemoryMiBProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `max` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max` |
| `min` | java.lang.Number | [[cdk.support/lookup-entry]] | `:min` |
"
  [^CfnLaunchTemplate$AcceleratorTotalMemoryMiBProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :max)]
    (. builder max data))
  (when-let [data (lookup-entry config id :min)]
    (. builder min data))
  (.build builder))


(defn cfn-launch-template-accelerator-total-memory-mi-b-property-builder
  "Creates a  `CfnLaunchTemplate$AcceleratorTotalMemoryMiBProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-accelerator-total-memory-mi-b-property-builder (new CfnLaunchTemplate$AcceleratorTotalMemoryMiBProperty$Builder) id config))


(defn build-cfn-launch-template-baseline-ebs-bandwidth-mbps-property-builder
  "The build-cfn-launch-template-baseline-ebs-bandwidth-mbps-property-builder function updates a CfnLaunchTemplate$BaselineEbsBandwidthMbpsProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$BaselineEbsBandwidthMbpsProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `max` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max` |
| `min` | java.lang.Number | [[cdk.support/lookup-entry]] | `:min` |
"
  [^CfnLaunchTemplate$BaselineEbsBandwidthMbpsProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :max)]
    (. builder max data))
  (when-let [data (lookup-entry config id :min)]
    (. builder min data))
  (.build builder))


(defn cfn-launch-template-baseline-ebs-bandwidth-mbps-property-builder
  "Creates a  `CfnLaunchTemplate$BaselineEbsBandwidthMbpsProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-baseline-ebs-bandwidth-mbps-property-builder (new CfnLaunchTemplate$BaselineEbsBandwidthMbpsProperty$Builder) id config))


(defn build-cfn-launch-template-block-device-mapping-property-builder
  "The build-cfn-launch-template-block-device-mapping-property-builder function updates a CfnLaunchTemplate$BlockDeviceMappingProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$BlockDeviceMappingProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `deviceName` | java.lang.String | [[cdk.support/lookup-entry]] | `:device-name` |
| `ebs` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:ebs` |
| `noDevice` | java.lang.String | [[cdk.support/lookup-entry]] | `:no-device` |
| `virtualName` | java.lang.String | [[cdk.support/lookup-entry]] | `:virtual-name` |
"
  [^CfnLaunchTemplate$BlockDeviceMappingProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :device-name)]
    (. builder deviceName data))
  (when-let [data (lookup-entry config id :ebs)]
    (. builder ebs data))
  (when-let [data (lookup-entry config id :no-device)]
    (. builder noDevice data))
  (when-let [data (lookup-entry config id :virtual-name)]
    (. builder virtualName data))
  (.build builder))


(defn cfn-launch-template-block-device-mapping-property-builder
  "Creates a  `CfnLaunchTemplate$BlockDeviceMappingProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-block-device-mapping-property-builder (new CfnLaunchTemplate$BlockDeviceMappingProperty$Builder) id config))


(defn build-cfn-launch-template-builder
  "The build-cfn-launch-template-builder function updates a CfnLaunchTemplate$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `launchTemplateData` | software.amazon.awscdk.services.ec2.CfnLaunchTemplate$LaunchTemplateDataProperty | [[cdk.support/lookup-entry]] | `:launch-template-data` |
| `launchTemplateName` | java.lang.String | [[cdk.support/lookup-entry]] | `:launch-template-name` |
| `tagSpecifications` | java.util.List | [[cdk.support/lookup-entry]] | `:tag-specifications` |
| `versionDescription` | java.lang.String | [[cdk.support/lookup-entry]] | `:version-description` |
"
  [^CfnLaunchTemplate$Builder builder id config]
  (when-let [data (lookup-entry config id :launch-template-data)]
    (. builder launchTemplateData data))
  (when-let [data (lookup-entry config id :launch-template-name)]
    (. builder launchTemplateName data))
  (when-let [data (lookup-entry config id :tag-specifications)]
    (. builder tagSpecifications data))
  (when-let [data (lookup-entry config id :version-description)]
    (. builder versionDescription data))
  (.build builder))


(defn cfn-launch-template-builder
  "Creates a  `CfnLaunchTemplate$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-launch-template-builder (CfnLaunchTemplate$Builder/create scope (name id)) id config))


(defn build-cfn-launch-template-capacity-reservation-specification-property-builder
  "The build-cfn-launch-template-capacity-reservation-specification-property-builder function updates a CfnLaunchTemplate$CapacityReservationSpecificationProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$CapacityReservationSpecificationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `capacityReservationPreference` | java.lang.String | [[cdk.support/lookup-entry]] | `:capacity-reservation-preference` |
| `capacityReservationTarget` | software.amazon.awscdk.services.ec2.CfnLaunchTemplate$CapacityReservationTargetProperty | [[cdk.support/lookup-entry]] | `:capacity-reservation-target` |
"
  [^CfnLaunchTemplate$CapacityReservationSpecificationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :capacity-reservation-preference)]
    (. builder capacityReservationPreference data))
  (when-let [data (lookup-entry config id :capacity-reservation-target)]
    (. builder capacityReservationTarget data))
  (.build builder))


(defn cfn-launch-template-capacity-reservation-specification-property-builder
  "Creates a  `CfnLaunchTemplate$CapacityReservationSpecificationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-capacity-reservation-specification-property-builder (new CfnLaunchTemplate$CapacityReservationSpecificationProperty$Builder) id config))


(defn build-cfn-launch-template-capacity-reservation-target-property-builder
  "The build-cfn-launch-template-capacity-reservation-target-property-builder function updates a CfnLaunchTemplate$CapacityReservationTargetProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$CapacityReservationTargetProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `capacityReservationId` | java.lang.String | [[cdk.support/lookup-entry]] | `:capacity-reservation-id` |
| `capacityReservationResourceGroupArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:capacity-reservation-resource-group-arn` |
"
  [^CfnLaunchTemplate$CapacityReservationTargetProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :capacity-reservation-id)]
    (. builder capacityReservationId data))
  (when-let [data (lookup-entry config id :capacity-reservation-resource-group-arn)]
    (. builder capacityReservationResourceGroupArn data))
  (.build builder))


(defn cfn-launch-template-capacity-reservation-target-property-builder
  "Creates a  `CfnLaunchTemplate$CapacityReservationTargetProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-capacity-reservation-target-property-builder (new CfnLaunchTemplate$CapacityReservationTargetProperty$Builder) id config))


(defn build-cfn-launch-template-connection-tracking-specification-property-builder
  "The build-cfn-launch-template-connection-tracking-specification-property-builder function updates a CfnLaunchTemplate$ConnectionTrackingSpecificationProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$ConnectionTrackingSpecificationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `tcpEstablishedTimeout` | java.lang.Number | [[cdk.support/lookup-entry]] | `:tcp-established-timeout` |
| `udpStreamTimeout` | java.lang.Number | [[cdk.support/lookup-entry]] | `:udp-stream-timeout` |
| `udpTimeout` | java.lang.Number | [[cdk.support/lookup-entry]] | `:udp-timeout` |
"
  [^CfnLaunchTemplate$ConnectionTrackingSpecificationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :tcp-established-timeout)]
    (. builder tcpEstablishedTimeout data))
  (when-let [data (lookup-entry config id :udp-stream-timeout)]
    (. builder udpStreamTimeout data))
  (when-let [data (lookup-entry config id :udp-timeout)]
    (. builder udpTimeout data))
  (.build builder))


(defn cfn-launch-template-connection-tracking-specification-property-builder
  "Creates a  `CfnLaunchTemplate$ConnectionTrackingSpecificationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-connection-tracking-specification-property-builder (new CfnLaunchTemplate$ConnectionTrackingSpecificationProperty$Builder) id config))


(defn build-cfn-launch-template-cpu-options-property-builder
  "The build-cfn-launch-template-cpu-options-property-builder function updates a CfnLaunchTemplate$CpuOptionsProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$CpuOptionsProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `amdSevSnp` | java.lang.String | [[cdk.support/lookup-entry]] | `:amd-sev-snp` |
| `coreCount` | java.lang.Number | [[cdk.support/lookup-entry]] | `:core-count` |
| `threadsPerCore` | java.lang.Number | [[cdk.support/lookup-entry]] | `:threads-per-core` |
"
  [^CfnLaunchTemplate$CpuOptionsProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :amd-sev-snp)]
    (. builder amdSevSnp data))
  (when-let [data (lookup-entry config id :core-count)]
    (. builder coreCount data))
  (when-let [data (lookup-entry config id :threads-per-core)]
    (. builder threadsPerCore data))
  (.build builder))


(defn cfn-launch-template-cpu-options-property-builder
  "Creates a  `CfnLaunchTemplate$CpuOptionsProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-cpu-options-property-builder (new CfnLaunchTemplate$CpuOptionsProperty$Builder) id config))


(defn build-cfn-launch-template-credit-specification-property-builder
  "The build-cfn-launch-template-credit-specification-property-builder function updates a CfnLaunchTemplate$CreditSpecificationProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$CreditSpecificationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `cpuCredits` | java.lang.String | [[cdk.support/lookup-entry]] | `:cpu-credits` |
"
  [^CfnLaunchTemplate$CreditSpecificationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :cpu-credits)]
    (. builder cpuCredits data))
  (.build builder))


(defn cfn-launch-template-credit-specification-property-builder
  "Creates a  `CfnLaunchTemplate$CreditSpecificationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-credit-specification-property-builder (new CfnLaunchTemplate$CreditSpecificationProperty$Builder) id config))


(defn build-cfn-launch-template-ebs-property-builder
  "The build-cfn-launch-template-ebs-property-builder function updates a CfnLaunchTemplate$EbsProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$EbsProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `deleteOnTermination` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:delete-on-termination` |
| `encrypted` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:encrypted` |
| `iops` | java.lang.Number | [[cdk.support/lookup-entry]] | `:iops` |
| `kmsKeyId` | java.lang.String | [[cdk.support/lookup-entry]] | `:kms-key-id` |
| `snapshotId` | java.lang.String | [[cdk.support/lookup-entry]] | `:snapshot-id` |
| `throughput` | java.lang.Number | [[cdk.support/lookup-entry]] | `:throughput` |
| `volumeSize` | java.lang.Number | [[cdk.support/lookup-entry]] | `:volume-size` |
| `volumeType` | java.lang.String | [[cdk.support/lookup-entry]] | `:volume-type` |
"
  [^CfnLaunchTemplate$EbsProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :delete-on-termination)]
    (. builder deleteOnTermination data))
  (when-let [data (lookup-entry config id :encrypted)]
    (. builder encrypted data))
  (when-let [data (lookup-entry config id :iops)]
    (. builder iops data))
  (when-let [data (lookup-entry config id :kms-key-id)]
    (. builder kmsKeyId data))
  (when-let [data (lookup-entry config id :snapshot-id)]
    (. builder snapshotId data))
  (when-let [data (lookup-entry config id :throughput)]
    (. builder throughput data))
  (when-let [data (lookup-entry config id :volume-size)]
    (. builder volumeSize data))
  (when-let [data (lookup-entry config id :volume-type)]
    (. builder volumeType data))
  (.build builder))


(defn cfn-launch-template-ebs-property-builder
  "Creates a  `CfnLaunchTemplate$EbsProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-ebs-property-builder (new CfnLaunchTemplate$EbsProperty$Builder) id config))


(defn build-cfn-launch-template-elastic-gpu-specification-property-builder
  "The build-cfn-launch-template-elastic-gpu-specification-property-builder function updates a CfnLaunchTemplate$ElasticGpuSpecificationProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$ElasticGpuSpecificationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `type` | java.lang.String | [[cdk.support/lookup-entry]] | `:type` |
"
  [^CfnLaunchTemplate$ElasticGpuSpecificationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :type)]
    (. builder type data))
  (.build builder))


(defn cfn-launch-template-elastic-gpu-specification-property-builder
  "Creates a  `CfnLaunchTemplate$ElasticGpuSpecificationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-elastic-gpu-specification-property-builder (new CfnLaunchTemplate$ElasticGpuSpecificationProperty$Builder) id config))


(defn build-cfn-launch-template-ena-srd-specification-property-builder
  "The build-cfn-launch-template-ena-srd-specification-property-builder function updates a CfnLaunchTemplate$EnaSrdSpecificationProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$EnaSrdSpecificationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `enaSrdEnabled` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:ena-srd-enabled` |
| `enaSrdUdpSpecification` | software.amazon.awscdk.services.ec2.CfnLaunchTemplate$EnaSrdUdpSpecificationProperty | [[cdk.support/lookup-entry]] | `:ena-srd-udp-specification` |
"
  [^CfnLaunchTemplate$EnaSrdSpecificationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :ena-srd-enabled)]
    (. builder enaSrdEnabled data))
  (when-let [data (lookup-entry config id :ena-srd-udp-specification)]
    (. builder enaSrdUdpSpecification data))
  (.build builder))


(defn cfn-launch-template-ena-srd-specification-property-builder
  "Creates a  `CfnLaunchTemplate$EnaSrdSpecificationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-ena-srd-specification-property-builder (new CfnLaunchTemplate$EnaSrdSpecificationProperty$Builder) id config))


(defn build-cfn-launch-template-ena-srd-udp-specification-property-builder
  "The build-cfn-launch-template-ena-srd-udp-specification-property-builder function updates a CfnLaunchTemplate$EnaSrdUdpSpecificationProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$EnaSrdUdpSpecificationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `enaSrdUdpEnabled` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:ena-srd-udp-enabled` |
"
  [^CfnLaunchTemplate$EnaSrdUdpSpecificationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :ena-srd-udp-enabled)]
    (. builder enaSrdUdpEnabled data))
  (.build builder))


(defn cfn-launch-template-ena-srd-udp-specification-property-builder
  "Creates a  `CfnLaunchTemplate$EnaSrdUdpSpecificationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-ena-srd-udp-specification-property-builder (new CfnLaunchTemplate$EnaSrdUdpSpecificationProperty$Builder) id config))


(defn build-cfn-launch-template-enclave-options-property-builder
  "The build-cfn-launch-template-enclave-options-property-builder function updates a CfnLaunchTemplate$EnclaveOptionsProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$EnclaveOptionsProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `enabled` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:enabled` |
"
  [^CfnLaunchTemplate$EnclaveOptionsProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :enabled)]
    (. builder enabled data))
  (.build builder))


(defn cfn-launch-template-enclave-options-property-builder
  "Creates a  `CfnLaunchTemplate$EnclaveOptionsProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-enclave-options-property-builder (new CfnLaunchTemplate$EnclaveOptionsProperty$Builder) id config))


(defn build-cfn-launch-template-hibernation-options-property-builder
  "The build-cfn-launch-template-hibernation-options-property-builder function updates a CfnLaunchTemplate$HibernationOptionsProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$HibernationOptionsProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `configured` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:configured` |
"
  [^CfnLaunchTemplate$HibernationOptionsProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :configured)]
    (. builder configured data))
  (.build builder))


(defn cfn-launch-template-hibernation-options-property-builder
  "Creates a  `CfnLaunchTemplate$HibernationOptionsProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-hibernation-options-property-builder (new CfnLaunchTemplate$HibernationOptionsProperty$Builder) id config))


(defn build-cfn-launch-template-iam-instance-profile-property-builder
  "The build-cfn-launch-template-iam-instance-profile-property-builder function updates a CfnLaunchTemplate$IamInstanceProfileProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$IamInstanceProfileProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `arn` | java.lang.String | [[cdk.support/lookup-entry]] | `:arn` |
| `name` | java.lang.String | [[cdk.support/lookup-entry]] | `:name` |
"
  [^CfnLaunchTemplate$IamInstanceProfileProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :arn)]
    (. builder arn data))
  (when-let [data (lookup-entry config id :name)]
    (. builder name data))
  (.build builder))


(defn cfn-launch-template-iam-instance-profile-property-builder
  "Creates a  `CfnLaunchTemplate$IamInstanceProfileProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-iam-instance-profile-property-builder (new CfnLaunchTemplate$IamInstanceProfileProperty$Builder) id config))


(defn build-cfn-launch-template-instance-market-options-property-builder
  "The build-cfn-launch-template-instance-market-options-property-builder function updates a CfnLaunchTemplate$InstanceMarketOptionsProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$InstanceMarketOptionsProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `marketType` | java.lang.String | [[cdk.support/lookup-entry]] | `:market-type` |
| `spotOptions` | software.amazon.awscdk.services.ec2.CfnLaunchTemplate$SpotOptionsProperty | [[cdk.support/lookup-entry]] | `:spot-options` |
"
  [^CfnLaunchTemplate$InstanceMarketOptionsProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :market-type)]
    (. builder marketType data))
  (when-let [data (lookup-entry config id :spot-options)]
    (. builder spotOptions data))
  (.build builder))


(defn cfn-launch-template-instance-market-options-property-builder
  "Creates a  `CfnLaunchTemplate$InstanceMarketOptionsProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-instance-market-options-property-builder (new CfnLaunchTemplate$InstanceMarketOptionsProperty$Builder) id config))


(defn build-cfn-launch-template-instance-requirements-property-builder
  "The build-cfn-launch-template-instance-requirements-property-builder function updates a CfnLaunchTemplate$InstanceRequirementsProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$InstanceRequirementsProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `acceleratorCount` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:accelerator-count` |
| `acceleratorManufacturers` | java.util.List | [[cdk.support/lookup-entry]] | `:accelerator-manufacturers` |
| `acceleratorNames` | java.util.List | [[cdk.support/lookup-entry]] | `:accelerator-names` |
| `acceleratorTotalMemoryMiB` | software.amazon.awscdk.services.ec2.CfnLaunchTemplate$AcceleratorTotalMemoryMiBProperty | [[cdk.support/lookup-entry]] | `:accelerator-total-memory-mi-b` |
| `acceleratorTypes` | java.util.List | [[cdk.support/lookup-entry]] | `:accelerator-types` |
| `allowedInstanceTypes` | java.util.List | [[cdk.support/lookup-entry]] | `:allowed-instance-types` |
| `bareMetal` | java.lang.String | [[cdk.support/lookup-entry]] | `:bare-metal` |
| `baselineEbsBandwidthMbps` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:baseline-ebs-bandwidth-mbps` |
| `burstablePerformance` | java.lang.String | [[cdk.support/lookup-entry]] | `:burstable-performance` |
| `cpuManufacturers` | java.util.List | [[cdk.support/lookup-entry]] | `:cpu-manufacturers` |
| `excludedInstanceTypes` | java.util.List | [[cdk.support/lookup-entry]] | `:excluded-instance-types` |
| `instanceGenerations` | java.util.List | [[cdk.support/lookup-entry]] | `:instance-generations` |
| `localStorage` | java.lang.String | [[cdk.support/lookup-entry]] | `:local-storage` |
| `localStorageTypes` | java.util.List | [[cdk.support/lookup-entry]] | `:local-storage-types` |
| `maxSpotPriceAsPercentageOfOptimalOnDemandPrice` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max-spot-price-as-percentage-of-optimal-on-demand-price` |
| `memoryGiBPerVCpu` | software.amazon.awscdk.services.ec2.CfnLaunchTemplate$MemoryGiBPerVCpuProperty | [[cdk.support/lookup-entry]] | `:memory-gi-b-per-v-cpu` |
| `memoryMiB` | software.amazon.awscdk.services.ec2.CfnLaunchTemplate$MemoryMiBProperty | [[cdk.support/lookup-entry]] | `:memory-mi-b` |
| `networkBandwidthGbps` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:network-bandwidth-gbps` |
| `networkInterfaceCount` | software.amazon.awscdk.services.ec2.CfnLaunchTemplate$NetworkInterfaceCountProperty | [[cdk.support/lookup-entry]] | `:network-interface-count` |
| `onDemandMaxPricePercentageOverLowestPrice` | java.lang.Number | [[cdk.support/lookup-entry]] | `:on-demand-max-price-percentage-over-lowest-price` |
| `requireHibernateSupport` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:require-hibernate-support` |
| `spotMaxPricePercentageOverLowestPrice` | java.lang.Number | [[cdk.support/lookup-entry]] | `:spot-max-price-percentage-over-lowest-price` |
| `totalLocalStorageGb` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:total-local-storage-gb` |
| `vCpuCount` | software.amazon.awscdk.services.ec2.CfnLaunchTemplate$VCpuCountProperty | [[cdk.support/lookup-entry]] | `:v-cpu-count` |
"
  [^CfnLaunchTemplate$InstanceRequirementsProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :accelerator-count)]
    (. builder acceleratorCount data))
  (when-let [data (lookup-entry config id :accelerator-manufacturers)]
    (. builder acceleratorManufacturers data))
  (when-let [data (lookup-entry config id :accelerator-names)]
    (. builder acceleratorNames data))
  (when-let [data (lookup-entry config id :accelerator-total-memory-mi-b)]
    (. builder acceleratorTotalMemoryMiB data))
  (when-let [data (lookup-entry config id :accelerator-types)]
    (. builder acceleratorTypes data))
  (when-let [data (lookup-entry config id :allowed-instance-types)]
    (. builder allowedInstanceTypes data))
  (when-let [data (lookup-entry config id :bare-metal)]
    (. builder bareMetal data))
  (when-let [data (lookup-entry config id :baseline-ebs-bandwidth-mbps)]
    (. builder baselineEbsBandwidthMbps data))
  (when-let [data (lookup-entry config id :burstable-performance)]
    (. builder burstablePerformance data))
  (when-let [data (lookup-entry config id :cpu-manufacturers)]
    (. builder cpuManufacturers data))
  (when-let [data (lookup-entry config id :excluded-instance-types)]
    (. builder excludedInstanceTypes data))
  (when-let [data (lookup-entry config id :instance-generations)]
    (. builder instanceGenerations data))
  (when-let [data (lookup-entry config id :local-storage)]
    (. builder localStorage data))
  (when-let [data (lookup-entry config id :local-storage-types)]
    (. builder localStorageTypes data))
  (when-let [data (lookup-entry config id :max-spot-price-as-percentage-of-optimal-on-demand-price)]
    (. builder maxSpotPriceAsPercentageOfOptimalOnDemandPrice data))
  (when-let [data (lookup-entry config id :memory-gi-b-per-v-cpu)]
    (. builder memoryGiBPerVCpu data))
  (when-let [data (lookup-entry config id :memory-mi-b)]
    (. builder memoryMiB data))
  (when-let [data (lookup-entry config id :network-bandwidth-gbps)]
    (. builder networkBandwidthGbps data))
  (when-let [data (lookup-entry config id :network-interface-count)]
    (. builder networkInterfaceCount data))
  (when-let [data (lookup-entry config id :on-demand-max-price-percentage-over-lowest-price)]
    (. builder onDemandMaxPricePercentageOverLowestPrice data))
  (when-let [data (lookup-entry config id :require-hibernate-support)]
    (. builder requireHibernateSupport data))
  (when-let [data (lookup-entry config id :spot-max-price-percentage-over-lowest-price)]
    (. builder spotMaxPricePercentageOverLowestPrice data))
  (when-let [data (lookup-entry config id :total-local-storage-gb)]
    (. builder totalLocalStorageGb data))
  (when-let [data (lookup-entry config id :v-cpu-count)]
    (. builder vCpuCount data))
  (.build builder))


(defn cfn-launch-template-instance-requirements-property-builder
  "Creates a  `CfnLaunchTemplate$InstanceRequirementsProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-instance-requirements-property-builder (new CfnLaunchTemplate$InstanceRequirementsProperty$Builder) id config))


(defn build-cfn-launch-template-ipv4-prefix-specification-property-builder
  "The build-cfn-launch-template-ipv4-prefix-specification-property-builder function updates a CfnLaunchTemplate$Ipv4PrefixSpecificationProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$Ipv4PrefixSpecificationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `ipv4Prefix` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipv4-prefix` |
"
  [^CfnLaunchTemplate$Ipv4PrefixSpecificationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :ipv4-prefix)]
    (. builder ipv4Prefix data))
  (.build builder))


(defn cfn-launch-template-ipv4-prefix-specification-property-builder
  "Creates a  `CfnLaunchTemplate$Ipv4PrefixSpecificationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-ipv4-prefix-specification-property-builder (new CfnLaunchTemplate$Ipv4PrefixSpecificationProperty$Builder) id config))


(defn build-cfn-launch-template-ipv6-add-property-builder
  "The build-cfn-launch-template-ipv6-add-property-builder function updates a CfnLaunchTemplate$Ipv6AddProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$Ipv6AddProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `ipv6Address` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipv6-address` |
"
  [^CfnLaunchTemplate$Ipv6AddProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :ipv6-address)]
    (. builder ipv6Address data))
  (.build builder))


(defn cfn-launch-template-ipv6-add-property-builder
  "Creates a  `CfnLaunchTemplate$Ipv6AddProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-ipv6-add-property-builder (new CfnLaunchTemplate$Ipv6AddProperty$Builder) id config))


(defn build-cfn-launch-template-ipv6-prefix-specification-property-builder
  "The build-cfn-launch-template-ipv6-prefix-specification-property-builder function updates a CfnLaunchTemplate$Ipv6PrefixSpecificationProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$Ipv6PrefixSpecificationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `ipv6Prefix` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipv6-prefix` |
"
  [^CfnLaunchTemplate$Ipv6PrefixSpecificationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :ipv6-prefix)]
    (. builder ipv6Prefix data))
  (.build builder))


(defn cfn-launch-template-ipv6-prefix-specification-property-builder
  "Creates a  `CfnLaunchTemplate$Ipv6PrefixSpecificationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-ipv6-prefix-specification-property-builder (new CfnLaunchTemplate$Ipv6PrefixSpecificationProperty$Builder) id config))


(defn build-cfn-launch-template-launch-template-data-property-builder
  "The build-cfn-launch-template-launch-template-data-property-builder function updates a CfnLaunchTemplate$LaunchTemplateDataProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$LaunchTemplateDataProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `blockDeviceMappings` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:block-device-mappings` |
| `capacityReservationSpecification` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:capacity-reservation-specification` |
| `cpuOptions` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:cpu-options` |
| `creditSpecification` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:credit-specification` |
| `disableApiStop` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:disable-api-stop` |
| `disableApiTermination` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:disable-api-termination` |
| `ebsOptimized` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:ebs-optimized` |
| `elasticGpuSpecifications` | java.util.List | [[cdk.support/lookup-entry]] | `:elastic-gpu-specifications` |
| `elasticInferenceAccelerators` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:elastic-inference-accelerators` |
| `enclaveOptions` | software.amazon.awscdk.services.ec2.CfnLaunchTemplate$EnclaveOptionsProperty | [[cdk.support/lookup-entry]] | `:enclave-options` |
| `hibernationOptions` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:hibernation-options` |
| `iamInstanceProfile` | software.amazon.awscdk.services.ec2.CfnLaunchTemplate$IamInstanceProfileProperty | [[cdk.support/lookup-entry]] | `:iam-instance-profile` |
| `imageId` | java.lang.String | [[cdk.support/lookup-entry]] | `:image-id` |
| `instanceInitiatedShutdownBehavior` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-initiated-shutdown-behavior` |
| `instanceMarketOptions` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:instance-market-options` |
| `instanceRequirements` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:instance-requirements` |
| `instanceType` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-type` |
| `kernelId` | java.lang.String | [[cdk.support/lookup-entry]] | `:kernel-id` |
| `keyName` | java.lang.String | [[cdk.support/lookup-entry]] | `:key-name` |
| `licenseSpecifications` | java.util.List | [[cdk.support/lookup-entry]] | `:license-specifications` |
| `maintenanceOptions` | software.amazon.awscdk.services.ec2.CfnLaunchTemplate$MaintenanceOptionsProperty | [[cdk.support/lookup-entry]] | `:maintenance-options` |
| `metadataOptions` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:metadata-options` |
| `monitoring` | software.amazon.awscdk.services.ec2.CfnLaunchTemplate$MonitoringProperty | [[cdk.support/lookup-entry]] | `:monitoring` |
| `networkInterfaces` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:network-interfaces` |
| `placement` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:placement` |
| `privateDnsNameOptions` | software.amazon.awscdk.services.ec2.CfnLaunchTemplate$PrivateDnsNameOptionsProperty | [[cdk.support/lookup-entry]] | `:private-dns-name-options` |
| `ramDiskId` | java.lang.String | [[cdk.support/lookup-entry]] | `:ram-disk-id` |
| `securityGroupIds` | java.util.List | [[cdk.support/lookup-entry]] | `:security-group-ids` |
| `securityGroups` | java.util.List | [[cdk.support/lookup-entry]] | `:security-groups` |
| `tagSpecifications` | java.util.List | [[cdk.support/lookup-entry]] | `:tag-specifications` |
| `userData` | java.lang.String | [[cdk.support/lookup-entry]] | `:user-data` |
"
  [^CfnLaunchTemplate$LaunchTemplateDataProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :block-device-mappings)]
    (. builder blockDeviceMappings data))
  (when-let [data (lookup-entry config id :capacity-reservation-specification)]
    (. builder capacityReservationSpecification data))
  (when-let [data (lookup-entry config id :cpu-options)]
    (. builder cpuOptions data))
  (when-let [data (lookup-entry config id :credit-specification)]
    (. builder creditSpecification data))
  (when-let [data (lookup-entry config id :disable-api-stop)]
    (. builder disableApiStop data))
  (when-let [data (lookup-entry config id :disable-api-termination)]
    (. builder disableApiTermination data))
  (when-let [data (lookup-entry config id :ebs-optimized)]
    (. builder ebsOptimized data))
  (when-let [data (lookup-entry config id :elastic-gpu-specifications)]
    (. builder elasticGpuSpecifications data))
  (when-let [data (lookup-entry config id :elastic-inference-accelerators)]
    (. builder elasticInferenceAccelerators data))
  (when-let [data (lookup-entry config id :enclave-options)]
    (. builder enclaveOptions data))
  (when-let [data (lookup-entry config id :hibernation-options)]
    (. builder hibernationOptions data))
  (when-let [data (lookup-entry config id :iam-instance-profile)]
    (. builder iamInstanceProfile data))
  (when-let [data (lookup-entry config id :image-id)]
    (. builder imageId data))
  (when-let [data (lookup-entry config id :instance-initiated-shutdown-behavior)]
    (. builder instanceInitiatedShutdownBehavior data))
  (when-let [data (lookup-entry config id :instance-market-options)]
    (. builder instanceMarketOptions data))
  (when-let [data (lookup-entry config id :instance-requirements)]
    (. builder instanceRequirements data))
  (when-let [data (lookup-entry config id :instance-type)]
    (. builder instanceType data))
  (when-let [data (lookup-entry config id :kernel-id)]
    (. builder kernelId data))
  (when-let [data (lookup-entry config id :key-name)]
    (. builder keyName data))
  (when-let [data (lookup-entry config id :license-specifications)]
    (. builder licenseSpecifications data))
  (when-let [data (lookup-entry config id :maintenance-options)]
    (. builder maintenanceOptions data))
  (when-let [data (lookup-entry config id :metadata-options)]
    (. builder metadataOptions data))
  (when-let [data (lookup-entry config id :monitoring)]
    (. builder monitoring data))
  (when-let [data (lookup-entry config id :network-interfaces)]
    (. builder networkInterfaces data))
  (when-let [data (lookup-entry config id :placement)]
    (. builder placement data))
  (when-let [data (lookup-entry config id :private-dns-name-options)]
    (. builder privateDnsNameOptions data))
  (when-let [data (lookup-entry config id :ram-disk-id)]
    (. builder ramDiskId data))
  (when-let [data (lookup-entry config id :security-group-ids)]
    (. builder securityGroupIds data))
  (when-let [data (lookup-entry config id :security-groups)]
    (. builder securityGroups data))
  (when-let [data (lookup-entry config id :tag-specifications)]
    (. builder tagSpecifications data))
  (when-let [data (lookup-entry config id :user-data)]
    (. builder userData data))
  (.build builder))


(defn cfn-launch-template-launch-template-data-property-builder
  "Creates a  `CfnLaunchTemplate$LaunchTemplateDataProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-launch-template-data-property-builder (new CfnLaunchTemplate$LaunchTemplateDataProperty$Builder) id config))


(defn build-cfn-launch-template-launch-template-elastic-inference-accelerator-property-builder
  "The build-cfn-launch-template-launch-template-elastic-inference-accelerator-property-builder function updates a CfnLaunchTemplate$LaunchTemplateElasticInferenceAcceleratorProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$LaunchTemplateElasticInferenceAcceleratorProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `count` | java.lang.Number | [[cdk.support/lookup-entry]] | `:count` |
| `type` | java.lang.String | [[cdk.support/lookup-entry]] | `:type` |
"
  [^CfnLaunchTemplate$LaunchTemplateElasticInferenceAcceleratorProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :count)]
    (. builder count data))
  (when-let [data (lookup-entry config id :type)]
    (. builder type data))
  (.build builder))


(defn cfn-launch-template-launch-template-elastic-inference-accelerator-property-builder
  "Creates a  `CfnLaunchTemplate$LaunchTemplateElasticInferenceAcceleratorProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-launch-template-elastic-inference-accelerator-property-builder (new CfnLaunchTemplate$LaunchTemplateElasticInferenceAcceleratorProperty$Builder) id config))


(defn build-cfn-launch-template-launch-template-tag-specification-property-builder
  "The build-cfn-launch-template-launch-template-tag-specification-property-builder function updates a CfnLaunchTemplate$LaunchTemplateTagSpecificationProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$LaunchTemplateTagSpecificationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `resourceType` | java.lang.String | [[cdk.support/lookup-entry]] | `:resource-type` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnLaunchTemplate$LaunchTemplateTagSpecificationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :resource-type)]
    (. builder resourceType data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-launch-template-launch-template-tag-specification-property-builder
  "Creates a  `CfnLaunchTemplate$LaunchTemplateTagSpecificationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-launch-template-tag-specification-property-builder (new CfnLaunchTemplate$LaunchTemplateTagSpecificationProperty$Builder) id config))


(defn build-cfn-launch-template-license-specification-property-builder
  "The build-cfn-launch-template-license-specification-property-builder function updates a CfnLaunchTemplate$LicenseSpecificationProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$LicenseSpecificationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `licenseConfigurationArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:license-configuration-arn` |
"
  [^CfnLaunchTemplate$LicenseSpecificationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :license-configuration-arn)]
    (. builder licenseConfigurationArn data))
  (.build builder))


(defn cfn-launch-template-license-specification-property-builder
  "Creates a  `CfnLaunchTemplate$LicenseSpecificationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-license-specification-property-builder (new CfnLaunchTemplate$LicenseSpecificationProperty$Builder) id config))


(defn build-cfn-launch-template-maintenance-options-property-builder
  "The build-cfn-launch-template-maintenance-options-property-builder function updates a CfnLaunchTemplate$MaintenanceOptionsProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$MaintenanceOptionsProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `autoRecovery` | java.lang.String | [[cdk.support/lookup-entry]] | `:auto-recovery` |
"
  [^CfnLaunchTemplate$MaintenanceOptionsProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :auto-recovery)]
    (. builder autoRecovery data))
  (.build builder))


(defn cfn-launch-template-maintenance-options-property-builder
  "Creates a  `CfnLaunchTemplate$MaintenanceOptionsProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-maintenance-options-property-builder (new CfnLaunchTemplate$MaintenanceOptionsProperty$Builder) id config))


(defn build-cfn-launch-template-memory-gi-b-per-v-cpu-property-builder
  "The build-cfn-launch-template-memory-gi-b-per-v-cpu-property-builder function updates a CfnLaunchTemplate$MemoryGiBPerVCpuProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$MemoryGiBPerVCpuProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `max` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max` |
| `min` | java.lang.Number | [[cdk.support/lookup-entry]] | `:min` |
"
  [^CfnLaunchTemplate$MemoryGiBPerVCpuProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :max)]
    (. builder max data))
  (when-let [data (lookup-entry config id :min)]
    (. builder min data))
  (.build builder))


(defn cfn-launch-template-memory-gi-b-per-v-cpu-property-builder
  "Creates a  `CfnLaunchTemplate$MemoryGiBPerVCpuProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-memory-gi-b-per-v-cpu-property-builder (new CfnLaunchTemplate$MemoryGiBPerVCpuProperty$Builder) id config))


(defn build-cfn-launch-template-memory-mi-b-property-builder
  "The build-cfn-launch-template-memory-mi-b-property-builder function updates a CfnLaunchTemplate$MemoryMiBProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$MemoryMiBProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `max` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max` |
| `min` | java.lang.Number | [[cdk.support/lookup-entry]] | `:min` |
"
  [^CfnLaunchTemplate$MemoryMiBProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :max)]
    (. builder max data))
  (when-let [data (lookup-entry config id :min)]
    (. builder min data))
  (.build builder))


(defn cfn-launch-template-memory-mi-b-property-builder
  "Creates a  `CfnLaunchTemplate$MemoryMiBProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-memory-mi-b-property-builder (new CfnLaunchTemplate$MemoryMiBProperty$Builder) id config))


(defn build-cfn-launch-template-metadata-options-property-builder
  "The build-cfn-launch-template-metadata-options-property-builder function updates a CfnLaunchTemplate$MetadataOptionsProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$MetadataOptionsProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `httpEndpoint` | java.lang.String | [[cdk.support/lookup-entry]] | `:http-endpoint` |
| `httpProtocolIpv6` | java.lang.String | [[cdk.support/lookup-entry]] | `:http-protocol-ipv6` |
| `httpPutResponseHopLimit` | java.lang.Number | [[cdk.support/lookup-entry]] | `:http-put-response-hop-limit` |
| `httpTokens` | java.lang.String | [[cdk.support/lookup-entry]] | `:http-tokens` |
| `instanceMetadataTags` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-metadata-tags` |
"
  [^CfnLaunchTemplate$MetadataOptionsProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :http-endpoint)]
    (. builder httpEndpoint data))
  (when-let [data (lookup-entry config id :http-protocol-ipv6)]
    (. builder httpProtocolIpv6 data))
  (when-let [data (lookup-entry config id :http-put-response-hop-limit)]
    (. builder httpPutResponseHopLimit data))
  (when-let [data (lookup-entry config id :http-tokens)]
    (. builder httpTokens data))
  (when-let [data (lookup-entry config id :instance-metadata-tags)]
    (. builder instanceMetadataTags data))
  (.build builder))


(defn cfn-launch-template-metadata-options-property-builder
  "Creates a  `CfnLaunchTemplate$MetadataOptionsProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-metadata-options-property-builder (new CfnLaunchTemplate$MetadataOptionsProperty$Builder) id config))


(defn build-cfn-launch-template-monitoring-property-builder
  "The build-cfn-launch-template-monitoring-property-builder function updates a CfnLaunchTemplate$MonitoringProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$MonitoringProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `enabled` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:enabled` |
"
  [^CfnLaunchTemplate$MonitoringProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :enabled)]
    (. builder enabled data))
  (.build builder))


(defn cfn-launch-template-monitoring-property-builder
  "Creates a  `CfnLaunchTemplate$MonitoringProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-monitoring-property-builder (new CfnLaunchTemplate$MonitoringProperty$Builder) id config))


(defn build-cfn-launch-template-network-bandwidth-gbps-property-builder
  "The build-cfn-launch-template-network-bandwidth-gbps-property-builder function updates a CfnLaunchTemplate$NetworkBandwidthGbpsProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$NetworkBandwidthGbpsProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `max` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max` |
| `min` | java.lang.Number | [[cdk.support/lookup-entry]] | `:min` |
"
  [^CfnLaunchTemplate$NetworkBandwidthGbpsProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :max)]
    (. builder max data))
  (when-let [data (lookup-entry config id :min)]
    (. builder min data))
  (.build builder))


(defn cfn-launch-template-network-bandwidth-gbps-property-builder
  "Creates a  `CfnLaunchTemplate$NetworkBandwidthGbpsProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-network-bandwidth-gbps-property-builder (new CfnLaunchTemplate$NetworkBandwidthGbpsProperty$Builder) id config))


(defn build-cfn-launch-template-network-interface-count-property-builder
  "The build-cfn-launch-template-network-interface-count-property-builder function updates a CfnLaunchTemplate$NetworkInterfaceCountProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$NetworkInterfaceCountProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `max` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max` |
| `min` | java.lang.Number | [[cdk.support/lookup-entry]] | `:min` |
"
  [^CfnLaunchTemplate$NetworkInterfaceCountProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :max)]
    (. builder max data))
  (when-let [data (lookup-entry config id :min)]
    (. builder min data))
  (.build builder))


(defn cfn-launch-template-network-interface-count-property-builder
  "Creates a  `CfnLaunchTemplate$NetworkInterfaceCountProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-network-interface-count-property-builder (new CfnLaunchTemplate$NetworkInterfaceCountProperty$Builder) id config))


(defn build-cfn-launch-template-network-interface-property-builder
  "The build-cfn-launch-template-network-interface-property-builder function updates a CfnLaunchTemplate$NetworkInterfaceProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$NetworkInterfaceProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `associateCarrierIpAddress` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:associate-carrier-ip-address` |
| `associatePublicIpAddress` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:associate-public-ip-address` |
| `connectionTrackingSpecification` | software.amazon.awscdk.services.ec2.CfnLaunchTemplate$ConnectionTrackingSpecificationProperty | [[cdk.support/lookup-entry]] | `:connection-tracking-specification` |
| `deleteOnTermination` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:delete-on-termination` |
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `deviceIndex` | java.lang.Number | [[cdk.support/lookup-entry]] | `:device-index` |
| `enaSrdSpecification` | software.amazon.awscdk.services.ec2.CfnLaunchTemplate$EnaSrdSpecificationProperty | [[cdk.support/lookup-entry]] | `:ena-srd-specification` |
| `groups` | java.util.List | [[cdk.support/lookup-entry]] | `:groups` |
| `interfaceType` | java.lang.String | [[cdk.support/lookup-entry]] | `:interface-type` |
| `ipv4PrefixCount` | java.lang.Number | [[cdk.support/lookup-entry]] | `:ipv4-prefix-count` |
| `ipv4Prefixes` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:ipv4-prefixes` |
| `ipv6AddressCount` | java.lang.Number | [[cdk.support/lookup-entry]] | `:ipv6-address-count` |
| `ipv6Addresses` | java.util.List | [[cdk.support/lookup-entry]] | `:ipv6-addresses` |
| `ipv6PrefixCount` | java.lang.Number | [[cdk.support/lookup-entry]] | `:ipv6-prefix-count` |
| `ipv6Prefixes` | java.util.List | [[cdk.support/lookup-entry]] | `:ipv6-prefixes` |
| `networkCardIndex` | java.lang.Number | [[cdk.support/lookup-entry]] | `:network-card-index` |
| `networkInterfaceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-interface-id` |
| `primaryIpv6` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:primary-ipv6` |
| `privateIpAddress` | java.lang.String | [[cdk.support/lookup-entry]] | `:private-ip-address` |
| `privateIpAddresses` | java.util.List | [[cdk.support/lookup-entry]] | `:private-ip-addresses` |
| `secondaryPrivateIpAddressCount` | java.lang.Number | [[cdk.support/lookup-entry]] | `:secondary-private-ip-address-count` |
| `subnetId` | java.lang.String | [[cdk.support/lookup-entry]] | `:subnet-id` |
"
  [^CfnLaunchTemplate$NetworkInterfaceProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :associate-carrier-ip-address)]
    (. builder associateCarrierIpAddress data))
  (when-let [data (lookup-entry config id :associate-public-ip-address)]
    (. builder associatePublicIpAddress data))
  (when-let [data (lookup-entry config id :connection-tracking-specification)]
    (. builder connectionTrackingSpecification data))
  (when-let [data (lookup-entry config id :delete-on-termination)]
    (. builder deleteOnTermination data))
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :device-index)]
    (. builder deviceIndex data))
  (when-let [data (lookup-entry config id :ena-srd-specification)]
    (. builder enaSrdSpecification data))
  (when-let [data (lookup-entry config id :groups)]
    (. builder groups data))
  (when-let [data (lookup-entry config id :interface-type)]
    (. builder interfaceType data))
  (when-let [data (lookup-entry config id :ipv4-prefix-count)]
    (. builder ipv4PrefixCount data))
  (when-let [data (lookup-entry config id :ipv4-prefixes)]
    (. builder ipv4Prefixes data))
  (when-let [data (lookup-entry config id :ipv6-address-count)]
    (. builder ipv6AddressCount data))
  (when-let [data (lookup-entry config id :ipv6-addresses)]
    (. builder ipv6Addresses data))
  (when-let [data (lookup-entry config id :ipv6-prefix-count)]
    (. builder ipv6PrefixCount data))
  (when-let [data (lookup-entry config id :ipv6-prefixes)]
    (. builder ipv6Prefixes data))
  (when-let [data (lookup-entry config id :network-card-index)]
    (. builder networkCardIndex data))
  (when-let [data (lookup-entry config id :network-interface-id)]
    (. builder networkInterfaceId data))
  (when-let [data (lookup-entry config id :primary-ipv6)]
    (. builder primaryIpv6 data))
  (when-let [data (lookup-entry config id :private-ip-address)]
    (. builder privateIpAddress data))
  (when-let [data (lookup-entry config id :private-ip-addresses)]
    (. builder privateIpAddresses data))
  (when-let [data (lookup-entry config id :secondary-private-ip-address-count)]
    (. builder secondaryPrivateIpAddressCount data))
  (when-let [data (lookup-entry config id :subnet-id)]
    (. builder subnetId data))
  (.build builder))


(defn cfn-launch-template-network-interface-property-builder
  "Creates a  `CfnLaunchTemplate$NetworkInterfaceProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-network-interface-property-builder (new CfnLaunchTemplate$NetworkInterfaceProperty$Builder) id config))


(defn build-cfn-launch-template-placement-property-builder
  "The build-cfn-launch-template-placement-property-builder function updates a CfnLaunchTemplate$PlacementProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$PlacementProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `affinity` | java.lang.String | [[cdk.support/lookup-entry]] | `:affinity` |
| `availabilityZone` | java.lang.String | [[cdk.support/lookup-entry]] | `:availability-zone` |
| `groupId` | java.lang.String | [[cdk.support/lookup-entry]] | `:group-id` |
| `groupName` | java.lang.String | [[cdk.support/lookup-entry]] | `:group-name` |
| `hostId` | java.lang.String | [[cdk.support/lookup-entry]] | `:host-id` |
| `hostResourceGroupArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:host-resource-group-arn` |
| `partitionNumber` | java.lang.Number | [[cdk.support/lookup-entry]] | `:partition-number` |
| `spreadDomain` | java.lang.String | [[cdk.support/lookup-entry]] | `:spread-domain` |
| `tenancy` | java.lang.String | [[cdk.support/lookup-entry]] | `:tenancy` |
"
  [^CfnLaunchTemplate$PlacementProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :affinity)]
    (. builder affinity data))
  (when-let [data (lookup-entry config id :availability-zone)]
    (. builder availabilityZone data))
  (when-let [data (lookup-entry config id :group-id)]
    (. builder groupId data))
  (when-let [data (lookup-entry config id :group-name)]
    (. builder groupName data))
  (when-let [data (lookup-entry config id :host-id)]
    (. builder hostId data))
  (when-let [data (lookup-entry config id :host-resource-group-arn)]
    (. builder hostResourceGroupArn data))
  (when-let [data (lookup-entry config id :partition-number)]
    (. builder partitionNumber data))
  (when-let [data (lookup-entry config id :spread-domain)]
    (. builder spreadDomain data))
  (when-let [data (lookup-entry config id :tenancy)]
    (. builder tenancy data))
  (.build builder))


(defn cfn-launch-template-placement-property-builder
  "Creates a  `CfnLaunchTemplate$PlacementProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-placement-property-builder (new CfnLaunchTemplate$PlacementProperty$Builder) id config))


(defn build-cfn-launch-template-private-dns-name-options-property-builder
  "The build-cfn-launch-template-private-dns-name-options-property-builder function updates a CfnLaunchTemplate$PrivateDnsNameOptionsProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$PrivateDnsNameOptionsProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `enableResourceNameDnsARecord` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:enable-resource-name-dns-a-record` |
| `enableResourceNameDnsAaaaRecord` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:enable-resource-name-dns-aaaa-record` |
| `hostnameType` | java.lang.String | [[cdk.support/lookup-entry]] | `:hostname-type` |
"
  [^CfnLaunchTemplate$PrivateDnsNameOptionsProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :enable-resource-name-dns-a-record)]
    (. builder enableResourceNameDnsARecord data))
  (when-let [data (lookup-entry config id :enable-resource-name-dns-aaaa-record)]
    (. builder enableResourceNameDnsAaaaRecord data))
  (when-let [data (lookup-entry config id :hostname-type)]
    (. builder hostnameType data))
  (.build builder))


(defn cfn-launch-template-private-dns-name-options-property-builder
  "Creates a  `CfnLaunchTemplate$PrivateDnsNameOptionsProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-private-dns-name-options-property-builder (new CfnLaunchTemplate$PrivateDnsNameOptionsProperty$Builder) id config))


(defn build-cfn-launch-template-private-ip-add-property-builder
  "The build-cfn-launch-template-private-ip-add-property-builder function updates a CfnLaunchTemplate$PrivateIpAddProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$PrivateIpAddProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `primary` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:primary` |
| `privateIpAddress` | java.lang.String | [[cdk.support/lookup-entry]] | `:private-ip-address` |
"
  [^CfnLaunchTemplate$PrivateIpAddProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :primary)]
    (. builder primary data))
  (when-let [data (lookup-entry config id :private-ip-address)]
    (. builder privateIpAddress data))
  (.build builder))


(defn cfn-launch-template-private-ip-add-property-builder
  "Creates a  `CfnLaunchTemplate$PrivateIpAddProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-private-ip-add-property-builder (new CfnLaunchTemplate$PrivateIpAddProperty$Builder) id config))


(defn build-cfn-launch-template-props-builder
  "The build-cfn-launch-template-props-builder function updates a CfnLaunchTemplateProps$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplateProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `launchTemplateData` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:launch-template-data` |
| `launchTemplateName` | java.lang.String | [[cdk.support/lookup-entry]] | `:launch-template-name` |
| `tagSpecifications` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:tag-specifications` |
| `versionDescription` | java.lang.String | [[cdk.support/lookup-entry]] | `:version-description` |
"
  [^CfnLaunchTemplateProps$Builder builder id config]
  (when-let [data (lookup-entry config id :launch-template-data)]
    (. builder launchTemplateData data))
  (when-let [data (lookup-entry config id :launch-template-name)]
    (. builder launchTemplateName data))
  (when-let [data (lookup-entry config id :tag-specifications)]
    (. builder tagSpecifications data))
  (when-let [data (lookup-entry config id :version-description)]
    (. builder versionDescription data))
  (.build builder))


(defn cfn-launch-template-props-builder
  "Creates a  `CfnLaunchTemplateProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-props-builder (new CfnLaunchTemplateProps$Builder) id config))


(defn build-cfn-launch-template-spot-options-property-builder
  "The build-cfn-launch-template-spot-options-property-builder function updates a CfnLaunchTemplate$SpotOptionsProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$SpotOptionsProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `blockDurationMinutes` | java.lang.Number | [[cdk.support/lookup-entry]] | `:block-duration-minutes` |
| `instanceInterruptionBehavior` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-interruption-behavior` |
| `maxPrice` | java.lang.String | [[cdk.support/lookup-entry]] | `:max-price` |
| `spotInstanceType` | java.lang.String | [[cdk.support/lookup-entry]] | `:spot-instance-type` |
| `validUntil` | java.lang.String | [[cdk.support/lookup-entry]] | `:valid-until` |
"
  [^CfnLaunchTemplate$SpotOptionsProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :block-duration-minutes)]
    (. builder blockDurationMinutes data))
  (when-let [data (lookup-entry config id :instance-interruption-behavior)]
    (. builder instanceInterruptionBehavior data))
  (when-let [data (lookup-entry config id :max-price)]
    (. builder maxPrice data))
  (when-let [data (lookup-entry config id :spot-instance-type)]
    (. builder spotInstanceType data))
  (when-let [data (lookup-entry config id :valid-until)]
    (. builder validUntil data))
  (.build builder))


(defn cfn-launch-template-spot-options-property-builder
  "Creates a  `CfnLaunchTemplate$SpotOptionsProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-spot-options-property-builder (new CfnLaunchTemplate$SpotOptionsProperty$Builder) id config))


(defn build-cfn-launch-template-tag-specification-property-builder
  "The build-cfn-launch-template-tag-specification-property-builder function updates a CfnLaunchTemplate$TagSpecificationProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$TagSpecificationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `resourceType` | java.lang.String | [[cdk.support/lookup-entry]] | `:resource-type` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnLaunchTemplate$TagSpecificationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :resource-type)]
    (. builder resourceType data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-launch-template-tag-specification-property-builder
  "Creates a  `CfnLaunchTemplate$TagSpecificationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-tag-specification-property-builder (new CfnLaunchTemplate$TagSpecificationProperty$Builder) id config))


(defn build-cfn-launch-template-total-local-storage-gb-property-builder
  "The build-cfn-launch-template-total-local-storage-gb-property-builder function updates a CfnLaunchTemplate$TotalLocalStorageGBProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$TotalLocalStorageGBProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `max` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max` |
| `min` | java.lang.Number | [[cdk.support/lookup-entry]] | `:min` |
"
  [^CfnLaunchTemplate$TotalLocalStorageGBProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :max)]
    (. builder max data))
  (when-let [data (lookup-entry config id :min)]
    (. builder min data))
  (.build builder))


(defn cfn-launch-template-total-local-storage-gb-property-builder
  "Creates a  `CfnLaunchTemplate$TotalLocalStorageGBProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-total-local-storage-gb-property-builder (new CfnLaunchTemplate$TotalLocalStorageGBProperty$Builder) id config))


(defn build-cfn-launch-template-v-cpu-count-property-builder
  "The build-cfn-launch-template-v-cpu-count-property-builder function updates a CfnLaunchTemplate$VCpuCountProperty$Builder instance using the provided configuration.
  The function takes the CfnLaunchTemplate$VCpuCountProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `max` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max` |
| `min` | java.lang.Number | [[cdk.support/lookup-entry]] | `:min` |
"
  [^CfnLaunchTemplate$VCpuCountProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :max)]
    (. builder max data))
  (when-let [data (lookup-entry config id :min)]
    (. builder min data))
  (.build builder))


(defn cfn-launch-template-v-cpu-count-property-builder
  "Creates a  `CfnLaunchTemplate$VCpuCountProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-launch-template-v-cpu-count-property-builder (new CfnLaunchTemplate$VCpuCountProperty$Builder) id config))


(defn build-cfn-local-gateway-route-builder
  "The build-cfn-local-gateway-route-builder function updates a CfnLocalGatewayRoute$Builder instance using the provided configuration.
  The function takes the CfnLocalGatewayRoute$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `destinationCidrBlock` | java.lang.String | [[cdk.support/lookup-entry]] | `:destination-cidr-block` |
| `localGatewayRouteTableId` | java.lang.String | [[cdk.support/lookup-entry]] | `:local-gateway-route-table-id` |
| `localGatewayVirtualInterfaceGroupId` | java.lang.String | [[cdk.support/lookup-entry]] | `:local-gateway-virtual-interface-group-id` |
| `networkInterfaceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-interface-id` |
"
  [^CfnLocalGatewayRoute$Builder builder id config]
  (when-let [data (lookup-entry config id :destination-cidr-block)]
    (. builder destinationCidrBlock data))
  (when-let [data (lookup-entry config id :local-gateway-route-table-id)]
    (. builder localGatewayRouteTableId data))
  (when-let [data (lookup-entry config id :local-gateway-virtual-interface-group-id)]
    (. builder localGatewayVirtualInterfaceGroupId data))
  (when-let [data (lookup-entry config id :network-interface-id)]
    (. builder networkInterfaceId data))
  (.build builder))


(defn cfn-local-gateway-route-builder
  "Creates a  `CfnLocalGatewayRoute$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-local-gateway-route-builder (CfnLocalGatewayRoute$Builder/create scope (name id)) id config))


(defn build-cfn-local-gateway-route-props-builder
  "The build-cfn-local-gateway-route-props-builder function updates a CfnLocalGatewayRouteProps$Builder instance using the provided configuration.
  The function takes the CfnLocalGatewayRouteProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `destinationCidrBlock` | java.lang.String | [[cdk.support/lookup-entry]] | `:destination-cidr-block` |
| `localGatewayRouteTableId` | java.lang.String | [[cdk.support/lookup-entry]] | `:local-gateway-route-table-id` |
| `localGatewayVirtualInterfaceGroupId` | java.lang.String | [[cdk.support/lookup-entry]] | `:local-gateway-virtual-interface-group-id` |
| `networkInterfaceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-interface-id` |
"
  [^CfnLocalGatewayRouteProps$Builder builder id config]
  (when-let [data (lookup-entry config id :destination-cidr-block)]
    (. builder destinationCidrBlock data))
  (when-let [data (lookup-entry config id :local-gateway-route-table-id)]
    (. builder localGatewayRouteTableId data))
  (when-let [data (lookup-entry config id :local-gateway-virtual-interface-group-id)]
    (. builder localGatewayVirtualInterfaceGroupId data))
  (when-let [data (lookup-entry config id :network-interface-id)]
    (. builder networkInterfaceId data))
  (.build builder))


(defn cfn-local-gateway-route-props-builder
  "Creates a  `CfnLocalGatewayRouteProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-local-gateway-route-props-builder (new CfnLocalGatewayRouteProps$Builder) id config))


(defn build-cfn-local-gateway-route-table-builder
  "The build-cfn-local-gateway-route-table-builder function updates a CfnLocalGatewayRouteTable$Builder instance using the provided configuration.
  The function takes the CfnLocalGatewayRouteTable$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `localGatewayId` | java.lang.String | [[cdk.support/lookup-entry]] | `:local-gateway-id` |
| `mode` | java.lang.String | [[cdk.support/lookup-entry]] | `:mode` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnLocalGatewayRouteTable$Builder builder id config]
  (when-let [data (lookup-entry config id :local-gateway-id)]
    (. builder localGatewayId data))
  (when-let [data (lookup-entry config id :mode)]
    (. builder mode data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-local-gateway-route-table-builder
  "Creates a  `CfnLocalGatewayRouteTable$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-local-gateway-route-table-builder (CfnLocalGatewayRouteTable$Builder/create scope (name id)) id config))


(defn build-cfn-local-gateway-route-table-props-builder
  "The build-cfn-local-gateway-route-table-props-builder function updates a CfnLocalGatewayRouteTableProps$Builder instance using the provided configuration.
  The function takes the CfnLocalGatewayRouteTableProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `localGatewayId` | java.lang.String | [[cdk.support/lookup-entry]] | `:local-gateway-id` |
| `mode` | java.lang.String | [[cdk.support/lookup-entry]] | `:mode` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnLocalGatewayRouteTableProps$Builder builder id config]
  (when-let [data (lookup-entry config id :local-gateway-id)]
    (. builder localGatewayId data))
  (when-let [data (lookup-entry config id :mode)]
    (. builder mode data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-local-gateway-route-table-props-builder
  "Creates a  `CfnLocalGatewayRouteTableProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-local-gateway-route-table-props-builder (new CfnLocalGatewayRouteTableProps$Builder) id config))


(defn build-cfn-local-gateway-route-table-virtual-interface-group-association-builder
  "The build-cfn-local-gateway-route-table-virtual-interface-group-association-builder function updates a CfnLocalGatewayRouteTableVirtualInterfaceGroupAssociation$Builder instance using the provided configuration.
  The function takes the CfnLocalGatewayRouteTableVirtualInterfaceGroupAssociation$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `localGatewayRouteTableId` | java.lang.String | [[cdk.support/lookup-entry]] | `:local-gateway-route-table-id` |
| `localGatewayVirtualInterfaceGroupId` | java.lang.String | [[cdk.support/lookup-entry]] | `:local-gateway-virtual-interface-group-id` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnLocalGatewayRouteTableVirtualInterfaceGroupAssociation$Builder builder id config]
  (when-let [data (lookup-entry config id :local-gateway-route-table-id)]
    (. builder localGatewayRouteTableId data))
  (when-let [data (lookup-entry config id :local-gateway-virtual-interface-group-id)]
    (. builder localGatewayVirtualInterfaceGroupId data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-local-gateway-route-table-virtual-interface-group-association-builder
  "Creates a  `CfnLocalGatewayRouteTableVirtualInterfaceGroupAssociation$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-local-gateway-route-table-virtual-interface-group-association-builder (CfnLocalGatewayRouteTableVirtualInterfaceGroupAssociation$Builder/create scope (name id)) id config))


(defn build-cfn-local-gateway-route-table-virtual-interface-group-association-props-builder
  "The build-cfn-local-gateway-route-table-virtual-interface-group-association-props-builder function updates a CfnLocalGatewayRouteTableVirtualInterfaceGroupAssociationProps$Builder instance using the provided configuration.
  The function takes the CfnLocalGatewayRouteTableVirtualInterfaceGroupAssociationProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `localGatewayRouteTableId` | java.lang.String | [[cdk.support/lookup-entry]] | `:local-gateway-route-table-id` |
| `localGatewayVirtualInterfaceGroupId` | java.lang.String | [[cdk.support/lookup-entry]] | `:local-gateway-virtual-interface-group-id` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnLocalGatewayRouteTableVirtualInterfaceGroupAssociationProps$Builder builder id config]
  (when-let [data (lookup-entry config id :local-gateway-route-table-id)]
    (. builder localGatewayRouteTableId data))
  (when-let [data (lookup-entry config id :local-gateway-virtual-interface-group-id)]
    (. builder localGatewayVirtualInterfaceGroupId data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-local-gateway-route-table-virtual-interface-group-association-props-builder
  "Creates a  `CfnLocalGatewayRouteTableVirtualInterfaceGroupAssociationProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-local-gateway-route-table-virtual-interface-group-association-props-builder (new CfnLocalGatewayRouteTableVirtualInterfaceGroupAssociationProps$Builder) id config))


(defn build-cfn-local-gateway-route-table-vpc-association-builder
  "The build-cfn-local-gateway-route-table-vpc-association-builder function updates a CfnLocalGatewayRouteTableVPCAssociation$Builder instance using the provided configuration.
  The function takes the CfnLocalGatewayRouteTableVPCAssociation$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `localGatewayRouteTableId` | java.lang.String | [[cdk.support/lookup-entry]] | `:local-gateway-route-table-id` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `vpcId` | java.lang.String | [[cdk.support/lookup-entry]] | `:vpc-id` |
"
  [^CfnLocalGatewayRouteTableVPCAssociation$Builder builder id config]
  (when-let [data (lookup-entry config id :local-gateway-route-table-id)]
    (. builder localGatewayRouteTableId data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :vpc-id)]
    (. builder vpcId data))
  (.build builder))


(defn cfn-local-gateway-route-table-vpc-association-builder
  "Creates a  `CfnLocalGatewayRouteTableVPCAssociation$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-local-gateway-route-table-vpc-association-builder (CfnLocalGatewayRouteTableVPCAssociation$Builder/create scope (name id)) id config))


(defn build-cfn-local-gateway-route-table-vpc-association-props-builder
  "The build-cfn-local-gateway-route-table-vpc-association-props-builder function updates a CfnLocalGatewayRouteTableVPCAssociationProps$Builder instance using the provided configuration.
  The function takes the CfnLocalGatewayRouteTableVPCAssociationProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `localGatewayRouteTableId` | java.lang.String | [[cdk.support/lookup-entry]] | `:local-gateway-route-table-id` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `vpcId` | java.lang.String | [[cdk.support/lookup-entry]] | `:vpc-id` |
"
  [^CfnLocalGatewayRouteTableVPCAssociationProps$Builder builder id config]
  (when-let [data (lookup-entry config id :local-gateway-route-table-id)]
    (. builder localGatewayRouteTableId data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :vpc-id)]
    (. builder vpcId data))
  (.build builder))


(defn cfn-local-gateway-route-table-vpc-association-props-builder
  "Creates a  `CfnLocalGatewayRouteTableVPCAssociationProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-local-gateway-route-table-vpc-association-props-builder (new CfnLocalGatewayRouteTableVPCAssociationProps$Builder) id config))


(defn build-cfn-nat-gateway-builder
  "The build-cfn-nat-gateway-builder function updates a CfnNatGateway$Builder instance using the provided configuration.
  The function takes the CfnNatGateway$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `allocationId` | java.lang.String | [[cdk.support/lookup-entry]] | `:allocation-id` |
| `connectivityType` | java.lang.String | [[cdk.support/lookup-entry]] | `:connectivity-type` |
| `maxDrainDurationSeconds` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max-drain-duration-seconds` |
| `privateIpAddress` | java.lang.String | [[cdk.support/lookup-entry]] | `:private-ip-address` |
| `secondaryAllocationIds` | java.util.List | [[cdk.support/lookup-entry]] | `:secondary-allocation-ids` |
| `secondaryPrivateIpAddressCount` | java.lang.Number | [[cdk.support/lookup-entry]] | `:secondary-private-ip-address-count` |
| `secondaryPrivateIpAddresses` | java.util.List | [[cdk.support/lookup-entry]] | `:secondary-private-ip-addresses` |
| `subnetId` | java.lang.String | [[cdk.support/lookup-entry]] | `:subnet-id` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnNatGateway$Builder builder id config]
  (when-let [data (lookup-entry config id :allocation-id)]
    (. builder allocationId data))
  (when-let [data (lookup-entry config id :connectivity-type)]
    (. builder connectivityType data))
  (when-let [data (lookup-entry config id :max-drain-duration-seconds)]
    (. builder maxDrainDurationSeconds data))
  (when-let [data (lookup-entry config id :private-ip-address)]
    (. builder privateIpAddress data))
  (when-let [data (lookup-entry config id :secondary-allocation-ids)]
    (. builder secondaryAllocationIds data))
  (when-let [data (lookup-entry config id :secondary-private-ip-address-count)]
    (. builder secondaryPrivateIpAddressCount data))
  (when-let [data (lookup-entry config id :secondary-private-ip-addresses)]
    (. builder secondaryPrivateIpAddresses data))
  (when-let [data (lookup-entry config id :subnet-id)]
    (. builder subnetId data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-nat-gateway-builder
  "Creates a  `CfnNatGateway$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-nat-gateway-builder (CfnNatGateway$Builder/create scope (name id)) id config))


(defn build-cfn-nat-gateway-props-builder
  "The build-cfn-nat-gateway-props-builder function updates a CfnNatGatewayProps$Builder instance using the provided configuration.
  The function takes the CfnNatGatewayProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `allocationId` | java.lang.String | [[cdk.support/lookup-entry]] | `:allocation-id` |
| `connectivityType` | java.lang.String | [[cdk.support/lookup-entry]] | `:connectivity-type` |
| `maxDrainDurationSeconds` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max-drain-duration-seconds` |
| `privateIpAddress` | java.lang.String | [[cdk.support/lookup-entry]] | `:private-ip-address` |
| `secondaryAllocationIds` | java.util.List | [[cdk.support/lookup-entry]] | `:secondary-allocation-ids` |
| `secondaryPrivateIpAddressCount` | java.lang.Number | [[cdk.support/lookup-entry]] | `:secondary-private-ip-address-count` |
| `secondaryPrivateIpAddresses` | java.util.List | [[cdk.support/lookup-entry]] | `:secondary-private-ip-addresses` |
| `subnetId` | java.lang.String | [[cdk.support/lookup-entry]] | `:subnet-id` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnNatGatewayProps$Builder builder id config]
  (when-let [data (lookup-entry config id :allocation-id)]
    (. builder allocationId data))
  (when-let [data (lookup-entry config id :connectivity-type)]
    (. builder connectivityType data))
  (when-let [data (lookup-entry config id :max-drain-duration-seconds)]
    (. builder maxDrainDurationSeconds data))
  (when-let [data (lookup-entry config id :private-ip-address)]
    (. builder privateIpAddress data))
  (when-let [data (lookup-entry config id :secondary-allocation-ids)]
    (. builder secondaryAllocationIds data))
  (when-let [data (lookup-entry config id :secondary-private-ip-address-count)]
    (. builder secondaryPrivateIpAddressCount data))
  (when-let [data (lookup-entry config id :secondary-private-ip-addresses)]
    (. builder secondaryPrivateIpAddresses data))
  (when-let [data (lookup-entry config id :subnet-id)]
    (. builder subnetId data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-nat-gateway-props-builder
  "Creates a  `CfnNatGatewayProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-nat-gateway-props-builder (new CfnNatGatewayProps$Builder) id config))


(defn build-cfn-network-acl-builder
  "The build-cfn-network-acl-builder function updates a CfnNetworkAcl$Builder instance using the provided configuration.
  The function takes the CfnNetworkAcl$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `vpcId` | java.lang.String | [[cdk.support/lookup-entry]] | `:vpc-id` |
"
  [^CfnNetworkAcl$Builder builder id config]
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :vpc-id)]
    (. builder vpcId data))
  (.build builder))


(defn cfn-network-acl-builder
  "Creates a  `CfnNetworkAcl$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-network-acl-builder (CfnNetworkAcl$Builder/create scope (name id)) id config))


(defn build-cfn-network-acl-entry-builder
  "The build-cfn-network-acl-entry-builder function updates a CfnNetworkAclEntry$Builder instance using the provided configuration.
  The function takes the CfnNetworkAclEntry$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `cidrBlock` | java.lang.String | [[cdk.support/lookup-entry]] | `:cidr-block` |
| `egress` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:egress` |
| `icmp` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:icmp` |
| `ipv6CidrBlock` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipv6-cidr-block` |
| `networkAclId` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-acl-id` |
| `portRange` | software.amazon.awscdk.services.ec2.CfnNetworkAclEntry$PortRangeProperty | [[cdk.support/lookup-entry]] | `:port-range` |
| `protocol` | java.lang.Number | [[cdk.support/lookup-entry]] | `:protocol` |
| `ruleAction` | java.lang.String | [[cdk.support/lookup-entry]] | `:rule-action` |
| `ruleNumber` | java.lang.Number | [[cdk.support/lookup-entry]] | `:rule-number` |
"
  [^CfnNetworkAclEntry$Builder builder id config]
  (when-let [data (lookup-entry config id :cidr-block)]
    (. builder cidrBlock data))
  (when-let [data (lookup-entry config id :egress)]
    (. builder egress data))
  (when-let [data (lookup-entry config id :icmp)]
    (. builder icmp data))
  (when-let [data (lookup-entry config id :ipv6-cidr-block)]
    (. builder ipv6CidrBlock data))
  (when-let [data (lookup-entry config id :network-acl-id)]
    (. builder networkAclId data))
  (when-let [data (lookup-entry config id :port-range)]
    (. builder portRange data))
  (when-let [data (lookup-entry config id :protocol)]
    (. builder protocol data))
  (when-let [data (lookup-entry config id :rule-action)]
    (. builder ruleAction data))
  (when-let [data (lookup-entry config id :rule-number)]
    (. builder ruleNumber data))
  (.build builder))


(defn cfn-network-acl-entry-builder
  "Creates a  `CfnNetworkAclEntry$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-network-acl-entry-builder (CfnNetworkAclEntry$Builder/create scope (name id)) id config))


(defn build-cfn-network-acl-entry-icmp-property-builder
  "The build-cfn-network-acl-entry-icmp-property-builder function updates a CfnNetworkAclEntry$IcmpProperty$Builder instance using the provided configuration.
  The function takes the CfnNetworkAclEntry$IcmpProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `code` | java.lang.Number | [[cdk.support/lookup-entry]] | `:code` |
| `type` | java.lang.Number | [[cdk.support/lookup-entry]] | `:type` |
"
  [^CfnNetworkAclEntry$IcmpProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :code)]
    (. builder code data))
  (when-let [data (lookup-entry config id :type)]
    (. builder type data))
  (.build builder))


(defn cfn-network-acl-entry-icmp-property-builder
  "Creates a  `CfnNetworkAclEntry$IcmpProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-acl-entry-icmp-property-builder (new CfnNetworkAclEntry$IcmpProperty$Builder) id config))


(defn build-cfn-network-acl-entry-port-range-property-builder
  "The build-cfn-network-acl-entry-port-range-property-builder function updates a CfnNetworkAclEntry$PortRangeProperty$Builder instance using the provided configuration.
  The function takes the CfnNetworkAclEntry$PortRangeProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `from` | java.lang.Number | [[cdk.support/lookup-entry]] | `:from` |
| `to` | java.lang.Number | [[cdk.support/lookup-entry]] | `:to` |
"
  [^CfnNetworkAclEntry$PortRangeProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :from)]
    (. builder from data))
  (when-let [data (lookup-entry config id :to)]
    (. builder to data))
  (.build builder))


(defn cfn-network-acl-entry-port-range-property-builder
  "Creates a  `CfnNetworkAclEntry$PortRangeProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-acl-entry-port-range-property-builder (new CfnNetworkAclEntry$PortRangeProperty$Builder) id config))


(defn build-cfn-network-acl-entry-props-builder
  "The build-cfn-network-acl-entry-props-builder function updates a CfnNetworkAclEntryProps$Builder instance using the provided configuration.
  The function takes the CfnNetworkAclEntryProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `cidrBlock` | java.lang.String | [[cdk.support/lookup-entry]] | `:cidr-block` |
| `egress` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:egress` |
| `icmp` | software.amazon.awscdk.services.ec2.CfnNetworkAclEntry$IcmpProperty | [[cdk.support/lookup-entry]] | `:icmp` |
| `ipv6CidrBlock` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipv6-cidr-block` |
| `networkAclId` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-acl-id` |
| `portRange` | software.amazon.awscdk.services.ec2.CfnNetworkAclEntry$PortRangeProperty | [[cdk.support/lookup-entry]] | `:port-range` |
| `protocol` | java.lang.Number | [[cdk.support/lookup-entry]] | `:protocol` |
| `ruleAction` | java.lang.String | [[cdk.support/lookup-entry]] | `:rule-action` |
| `ruleNumber` | java.lang.Number | [[cdk.support/lookup-entry]] | `:rule-number` |
"
  [^CfnNetworkAclEntryProps$Builder builder id config]
  (when-let [data (lookup-entry config id :cidr-block)]
    (. builder cidrBlock data))
  (when-let [data (lookup-entry config id :egress)]
    (. builder egress data))
  (when-let [data (lookup-entry config id :icmp)]
    (. builder icmp data))
  (when-let [data (lookup-entry config id :ipv6-cidr-block)]
    (. builder ipv6CidrBlock data))
  (when-let [data (lookup-entry config id :network-acl-id)]
    (. builder networkAclId data))
  (when-let [data (lookup-entry config id :port-range)]
    (. builder portRange data))
  (when-let [data (lookup-entry config id :protocol)]
    (. builder protocol data))
  (when-let [data (lookup-entry config id :rule-action)]
    (. builder ruleAction data))
  (when-let [data (lookup-entry config id :rule-number)]
    (. builder ruleNumber data))
  (.build builder))


(defn cfn-network-acl-entry-props-builder
  "Creates a  `CfnNetworkAclEntryProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-acl-entry-props-builder (new CfnNetworkAclEntryProps$Builder) id config))


(defn build-cfn-network-acl-props-builder
  "The build-cfn-network-acl-props-builder function updates a CfnNetworkAclProps$Builder instance using the provided configuration.
  The function takes the CfnNetworkAclProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `vpcId` | java.lang.String | [[cdk.support/lookup-entry]] | `:vpc-id` |
"
  [^CfnNetworkAclProps$Builder builder id config]
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :vpc-id)]
    (. builder vpcId data))
  (.build builder))


(defn cfn-network-acl-props-builder
  "Creates a  `CfnNetworkAclProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-acl-props-builder (new CfnNetworkAclProps$Builder) id config))


(defn build-cfn-network-insights-access-scope-access-scope-path-request-property-builder
  "The build-cfn-network-insights-access-scope-access-scope-path-request-property-builder function updates a CfnNetworkInsightsAccessScope$AccessScopePathRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnNetworkInsightsAccessScope$AccessScopePathRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `destination` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsAccessScope$PathStatementRequestProperty | [[cdk.support/lookup-entry]] | `:destination` |
| `source` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:source` |
| `throughResources` | java.util.List | [[cdk.support/lookup-entry]] | `:through-resources` |
"
  [^CfnNetworkInsightsAccessScope$AccessScopePathRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :destination)]
    (. builder destination data))
  (when-let [data (lookup-entry config id :source)]
    (. builder source data))
  (when-let [data (lookup-entry config id :through-resources)]
    (. builder throughResources data))
  (.build builder))


(defn cfn-network-insights-access-scope-access-scope-path-request-property-builder
  "Creates a  `CfnNetworkInsightsAccessScope$AccessScopePathRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-insights-access-scope-access-scope-path-request-property-builder (new CfnNetworkInsightsAccessScope$AccessScopePathRequestProperty$Builder) id config))


(defn build-cfn-network-insights-access-scope-analysis-builder
  "The build-cfn-network-insights-access-scope-analysis-builder function updates a CfnNetworkInsightsAccessScopeAnalysis$Builder instance using the provided configuration.
  The function takes the CfnNetworkInsightsAccessScopeAnalysis$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `networkInsightsAccessScopeId` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-insights-access-scope-id` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnNetworkInsightsAccessScopeAnalysis$Builder builder id config]
  (when-let [data (lookup-entry config id :network-insights-access-scope-id)]
    (. builder networkInsightsAccessScopeId data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-network-insights-access-scope-analysis-builder
  "Creates a  `CfnNetworkInsightsAccessScopeAnalysis$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-network-insights-access-scope-analysis-builder (CfnNetworkInsightsAccessScopeAnalysis$Builder/create scope (name id)) id config))


(defn build-cfn-network-insights-access-scope-analysis-props-builder
  "The build-cfn-network-insights-access-scope-analysis-props-builder function updates a CfnNetworkInsightsAccessScopeAnalysisProps$Builder instance using the provided configuration.
  The function takes the CfnNetworkInsightsAccessScopeAnalysisProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `networkInsightsAccessScopeId` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-insights-access-scope-id` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnNetworkInsightsAccessScopeAnalysisProps$Builder builder id config]
  (when-let [data (lookup-entry config id :network-insights-access-scope-id)]
    (. builder networkInsightsAccessScopeId data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-network-insights-access-scope-analysis-props-builder
  "Creates a  `CfnNetworkInsightsAccessScopeAnalysisProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-insights-access-scope-analysis-props-builder (new CfnNetworkInsightsAccessScopeAnalysisProps$Builder) id config))


(defn build-cfn-network-insights-access-scope-builder
  "The build-cfn-network-insights-access-scope-builder function updates a CfnNetworkInsightsAccessScope$Builder instance using the provided configuration.
  The function takes the CfnNetworkInsightsAccessScope$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `excludePaths` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:exclude-paths` |
| `matchPaths` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:match-paths` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnNetworkInsightsAccessScope$Builder builder id config]
  (when-let [data (lookup-entry config id :exclude-paths)]
    (. builder excludePaths data))
  (when-let [data (lookup-entry config id :match-paths)]
    (. builder matchPaths data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-network-insights-access-scope-builder
  "Creates a  `CfnNetworkInsightsAccessScope$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-network-insights-access-scope-builder (CfnNetworkInsightsAccessScope$Builder/create scope (name id)) id config))


(defn build-cfn-network-insights-access-scope-packet-header-statement-request-property-builder
  "The build-cfn-network-insights-access-scope-packet-header-statement-request-property-builder function updates a CfnNetworkInsightsAccessScope$PacketHeaderStatementRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnNetworkInsightsAccessScope$PacketHeaderStatementRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `destinationAddresses` | java.util.List | [[cdk.support/lookup-entry]] | `:destination-addresses` |
| `destinationPorts` | java.util.List | [[cdk.support/lookup-entry]] | `:destination-ports` |
| `destinationPrefixLists` | java.util.List | [[cdk.support/lookup-entry]] | `:destination-prefix-lists` |
| `protocols` | java.util.List | [[cdk.support/lookup-entry]] | `:protocols` |
| `sourceAddresses` | java.util.List | [[cdk.support/lookup-entry]] | `:source-addresses` |
| `sourcePorts` | java.util.List | [[cdk.support/lookup-entry]] | `:source-ports` |
| `sourcePrefixLists` | java.util.List | [[cdk.support/lookup-entry]] | `:source-prefix-lists` |
"
  [^CfnNetworkInsightsAccessScope$PacketHeaderStatementRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :destination-addresses)]
    (. builder destinationAddresses data))
  (when-let [data (lookup-entry config id :destination-ports)]
    (. builder destinationPorts data))
  (when-let [data (lookup-entry config id :destination-prefix-lists)]
    (. builder destinationPrefixLists data))
  (when-let [data (lookup-entry config id :protocols)]
    (. builder protocols data))
  (when-let [data (lookup-entry config id :source-addresses)]
    (. builder sourceAddresses data))
  (when-let [data (lookup-entry config id :source-ports)]
    (. builder sourcePorts data))
  (when-let [data (lookup-entry config id :source-prefix-lists)]
    (. builder sourcePrefixLists data))
  (.build builder))


(defn cfn-network-insights-access-scope-packet-header-statement-request-property-builder
  "Creates a  `CfnNetworkInsightsAccessScope$PacketHeaderStatementRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-insights-access-scope-packet-header-statement-request-property-builder (new CfnNetworkInsightsAccessScope$PacketHeaderStatementRequestProperty$Builder) id config))


(defn build-cfn-network-insights-access-scope-path-statement-request-property-builder
  "The build-cfn-network-insights-access-scope-path-statement-request-property-builder function updates a CfnNetworkInsightsAccessScope$PathStatementRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnNetworkInsightsAccessScope$PathStatementRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `packetHeaderStatement` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsAccessScope$PacketHeaderStatementRequestProperty | [[cdk.support/lookup-entry]] | `:packet-header-statement` |
| `resourceStatement` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsAccessScope$ResourceStatementRequestProperty | [[cdk.support/lookup-entry]] | `:resource-statement` |
"
  [^CfnNetworkInsightsAccessScope$PathStatementRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :packet-header-statement)]
    (. builder packetHeaderStatement data))
  (when-let [data (lookup-entry config id :resource-statement)]
    (. builder resourceStatement data))
  (.build builder))


(defn cfn-network-insights-access-scope-path-statement-request-property-builder
  "Creates a  `CfnNetworkInsightsAccessScope$PathStatementRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-insights-access-scope-path-statement-request-property-builder (new CfnNetworkInsightsAccessScope$PathStatementRequestProperty$Builder) id config))


(defn build-cfn-network-insights-access-scope-props-builder
  "The build-cfn-network-insights-access-scope-props-builder function updates a CfnNetworkInsightsAccessScopeProps$Builder instance using the provided configuration.
  The function takes the CfnNetworkInsightsAccessScopeProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `excludePaths` | java.util.List | [[cdk.support/lookup-entry]] | `:exclude-paths` |
| `matchPaths` | java.util.List | [[cdk.support/lookup-entry]] | `:match-paths` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnNetworkInsightsAccessScopeProps$Builder builder id config]
  (when-let [data (lookup-entry config id :exclude-paths)]
    (. builder excludePaths data))
  (when-let [data (lookup-entry config id :match-paths)]
    (. builder matchPaths data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-network-insights-access-scope-props-builder
  "Creates a  `CfnNetworkInsightsAccessScopeProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-insights-access-scope-props-builder (new CfnNetworkInsightsAccessScopeProps$Builder) id config))


(defn build-cfn-network-insights-access-scope-resource-statement-request-property-builder
  "The build-cfn-network-insights-access-scope-resource-statement-request-property-builder function updates a CfnNetworkInsightsAccessScope$ResourceStatementRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnNetworkInsightsAccessScope$ResourceStatementRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `resourceTypes` | java.util.List | [[cdk.support/lookup-entry]] | `:resource-types` |
| `resources` | java.util.List | [[cdk.support/lookup-entry]] | `:resources` |
"
  [^CfnNetworkInsightsAccessScope$ResourceStatementRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :resource-types)]
    (. builder resourceTypes data))
  (when-let [data (lookup-entry config id :resources)]
    (. builder resources data))
  (.build builder))


(defn cfn-network-insights-access-scope-resource-statement-request-property-builder
  "Creates a  `CfnNetworkInsightsAccessScope$ResourceStatementRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-insights-access-scope-resource-statement-request-property-builder (new CfnNetworkInsightsAccessScope$ResourceStatementRequestProperty$Builder) id config))


(defn build-cfn-network-insights-access-scope-through-resources-statement-request-property-builder
  "The build-cfn-network-insights-access-scope-through-resources-statement-request-property-builder function updates a CfnNetworkInsightsAccessScope$ThroughResourcesStatementRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnNetworkInsightsAccessScope$ThroughResourcesStatementRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `resourceStatement` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:resource-statement` |
"
  [^CfnNetworkInsightsAccessScope$ThroughResourcesStatementRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :resource-statement)]
    (. builder resourceStatement data))
  (.build builder))


(defn cfn-network-insights-access-scope-through-resources-statement-request-property-builder
  "Creates a  `CfnNetworkInsightsAccessScope$ThroughResourcesStatementRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-insights-access-scope-through-resources-statement-request-property-builder (new CfnNetworkInsightsAccessScope$ThroughResourcesStatementRequestProperty$Builder) id config))


(defn build-cfn-network-insights-analysis-additional-detail-property-builder
  "The build-cfn-network-insights-analysis-additional-detail-property-builder function updates a CfnNetworkInsightsAnalysis$AdditionalDetailProperty$Builder instance using the provided configuration.
  The function takes the CfnNetworkInsightsAnalysis$AdditionalDetailProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `additionalDetailType` | java.lang.String | [[cdk.support/lookup-entry]] | `:additional-detail-type` |
| `component` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:component` |
| `loadBalancers` | java.util.List | [[cdk.support/lookup-entry]] | `:load-balancers` |
| `serviceName` | java.lang.String | [[cdk.support/lookup-entry]] | `:service-name` |
"
  [^CfnNetworkInsightsAnalysis$AdditionalDetailProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :additional-detail-type)]
    (. builder additionalDetailType data))
  (when-let [data (lookup-entry config id :component)]
    (. builder component data))
  (when-let [data (lookup-entry config id :load-balancers)]
    (. builder loadBalancers data))
  (when-let [data (lookup-entry config id :service-name)]
    (. builder serviceName data))
  (.build builder))


(defn cfn-network-insights-analysis-additional-detail-property-builder
  "Creates a  `CfnNetworkInsightsAnalysis$AdditionalDetailProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-insights-analysis-additional-detail-property-builder (new CfnNetworkInsightsAnalysis$AdditionalDetailProperty$Builder) id config))


(defn build-cfn-network-insights-analysis-alternate-path-hint-property-builder
  "The build-cfn-network-insights-analysis-alternate-path-hint-property-builder function updates a CfnNetworkInsightsAnalysis$AlternatePathHintProperty$Builder instance using the provided configuration.
  The function takes the CfnNetworkInsightsAnalysis$AlternatePathHintProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `componentArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:component-arn` |
| `componentId` | java.lang.String | [[cdk.support/lookup-entry]] | `:component-id` |
"
  [^CfnNetworkInsightsAnalysis$AlternatePathHintProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :component-arn)]
    (. builder componentArn data))
  (when-let [data (lookup-entry config id :component-id)]
    (. builder componentId data))
  (.build builder))


(defn cfn-network-insights-analysis-alternate-path-hint-property-builder
  "Creates a  `CfnNetworkInsightsAnalysis$AlternatePathHintProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-insights-analysis-alternate-path-hint-property-builder (new CfnNetworkInsightsAnalysis$AlternatePathHintProperty$Builder) id config))


(defn build-cfn-network-insights-analysis-analysis-acl-rule-property-builder
  "The build-cfn-network-insights-analysis-analysis-acl-rule-property-builder function updates a CfnNetworkInsightsAnalysis$AnalysisAclRuleProperty$Builder instance using the provided configuration.
  The function takes the CfnNetworkInsightsAnalysis$AnalysisAclRuleProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `cidr` | java.lang.String | [[cdk.support/lookup-entry]] | `:cidr` |
| `egress` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:egress` |
| `portRange` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis$PortRangeProperty | [[cdk.support/lookup-entry]] | `:port-range` |
| `protocol` | java.lang.String | [[cdk.support/lookup-entry]] | `:protocol` |
| `ruleAction` | java.lang.String | [[cdk.support/lookup-entry]] | `:rule-action` |
| `ruleNumber` | java.lang.Number | [[cdk.support/lookup-entry]] | `:rule-number` |
"
  [^CfnNetworkInsightsAnalysis$AnalysisAclRuleProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :cidr)]
    (. builder cidr data))
  (when-let [data (lookup-entry config id :egress)]
    (. builder egress data))
  (when-let [data (lookup-entry config id :port-range)]
    (. builder portRange data))
  (when-let [data (lookup-entry config id :protocol)]
    (. builder protocol data))
  (when-let [data (lookup-entry config id :rule-action)]
    (. builder ruleAction data))
  (when-let [data (lookup-entry config id :rule-number)]
    (. builder ruleNumber data))
  (.build builder))


(defn cfn-network-insights-analysis-analysis-acl-rule-property-builder
  "Creates a  `CfnNetworkInsightsAnalysis$AnalysisAclRuleProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-insights-analysis-analysis-acl-rule-property-builder (new CfnNetworkInsightsAnalysis$AnalysisAclRuleProperty$Builder) id config))


(defn build-cfn-network-insights-analysis-analysis-component-property-builder
  "The build-cfn-network-insights-analysis-analysis-component-property-builder function updates a CfnNetworkInsightsAnalysis$AnalysisComponentProperty$Builder instance using the provided configuration.
  The function takes the CfnNetworkInsightsAnalysis$AnalysisComponentProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `arn` | java.lang.String | [[cdk.support/lookup-entry]] | `:arn` |
| `id` | java.lang.String | [[cdk.support/lookup-entry]] | `:id` |
"
  [^CfnNetworkInsightsAnalysis$AnalysisComponentProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :arn)]
    (. builder arn data))
  (when-let [data (lookup-entry config id :id)]
    (. builder id data))
  (.build builder))


(defn cfn-network-insights-analysis-analysis-component-property-builder
  "Creates a  `CfnNetworkInsightsAnalysis$AnalysisComponentProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-insights-analysis-analysis-component-property-builder (new CfnNetworkInsightsAnalysis$AnalysisComponentProperty$Builder) id config))


(defn build-cfn-network-insights-analysis-analysis-load-balancer-listener-property-builder
  "The build-cfn-network-insights-analysis-analysis-load-balancer-listener-property-builder function updates a CfnNetworkInsightsAnalysis$AnalysisLoadBalancerListenerProperty$Builder instance using the provided configuration.
  The function takes the CfnNetworkInsightsAnalysis$AnalysisLoadBalancerListenerProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `instancePort` | java.lang.Number | [[cdk.support/lookup-entry]] | `:instance-port` |
| `loadBalancerPort` | java.lang.Number | [[cdk.support/lookup-entry]] | `:load-balancer-port` |
"
  [^CfnNetworkInsightsAnalysis$AnalysisLoadBalancerListenerProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :instance-port)]
    (. builder instancePort data))
  (when-let [data (lookup-entry config id :load-balancer-port)]
    (. builder loadBalancerPort data))
  (.build builder))


(defn cfn-network-insights-analysis-analysis-load-balancer-listener-property-builder
  "Creates a  `CfnNetworkInsightsAnalysis$AnalysisLoadBalancerListenerProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-insights-analysis-analysis-load-balancer-listener-property-builder (new CfnNetworkInsightsAnalysis$AnalysisLoadBalancerListenerProperty$Builder) id config))


(defn build-cfn-network-insights-analysis-analysis-load-balancer-target-property-builder
  "The build-cfn-network-insights-analysis-analysis-load-balancer-target-property-builder function updates a CfnNetworkInsightsAnalysis$AnalysisLoadBalancerTargetProperty$Builder instance using the provided configuration.
  The function takes the CfnNetworkInsightsAnalysis$AnalysisLoadBalancerTargetProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `address` | java.lang.String | [[cdk.support/lookup-entry]] | `:address` |
| `availabilityZone` | java.lang.String | [[cdk.support/lookup-entry]] | `:availability-zone` |
| `instance` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:instance` |
| `port` | java.lang.Number | [[cdk.support/lookup-entry]] | `:port` |
"
  [^CfnNetworkInsightsAnalysis$AnalysisLoadBalancerTargetProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :address)]
    (. builder address data))
  (when-let [data (lookup-entry config id :availability-zone)]
    (. builder availabilityZone data))
  (when-let [data (lookup-entry config id :instance)]
    (. builder instance data))
  (when-let [data (lookup-entry config id :port)]
    (. builder port data))
  (.build builder))


(defn cfn-network-insights-analysis-analysis-load-balancer-target-property-builder
  "Creates a  `CfnNetworkInsightsAnalysis$AnalysisLoadBalancerTargetProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-insights-analysis-analysis-load-balancer-target-property-builder (new CfnNetworkInsightsAnalysis$AnalysisLoadBalancerTargetProperty$Builder) id config))


(defn build-cfn-network-insights-analysis-analysis-packet-header-property-builder
  "The build-cfn-network-insights-analysis-analysis-packet-header-property-builder function updates a CfnNetworkInsightsAnalysis$AnalysisPacketHeaderProperty$Builder instance using the provided configuration.
  The function takes the CfnNetworkInsightsAnalysis$AnalysisPacketHeaderProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `destinationAddresses` | java.util.List | [[cdk.support/lookup-entry]] | `:destination-addresses` |
| `destinationPortRanges` | java.util.List | [[cdk.support/lookup-entry]] | `:destination-port-ranges` |
| `protocol` | java.lang.String | [[cdk.support/lookup-entry]] | `:protocol` |
| `sourceAddresses` | java.util.List | [[cdk.support/lookup-entry]] | `:source-addresses` |
| `sourcePortRanges` | java.util.List | [[cdk.support/lookup-entry]] | `:source-port-ranges` |
"
  [^CfnNetworkInsightsAnalysis$AnalysisPacketHeaderProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :destination-addresses)]
    (. builder destinationAddresses data))
  (when-let [data (lookup-entry config id :destination-port-ranges)]
    (. builder destinationPortRanges data))
  (when-let [data (lookup-entry config id :protocol)]
    (. builder protocol data))
  (when-let [data (lookup-entry config id :source-addresses)]
    (. builder sourceAddresses data))
  (when-let [data (lookup-entry config id :source-port-ranges)]
    (. builder sourcePortRanges data))
  (.build builder))


(defn cfn-network-insights-analysis-analysis-packet-header-property-builder
  "Creates a  `CfnNetworkInsightsAnalysis$AnalysisPacketHeaderProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-insights-analysis-analysis-packet-header-property-builder (new CfnNetworkInsightsAnalysis$AnalysisPacketHeaderProperty$Builder) id config))


(defn build-cfn-network-insights-analysis-analysis-route-table-route-property-builder
  "The build-cfn-network-insights-analysis-analysis-route-table-route-property-builder function updates a CfnNetworkInsightsAnalysis$AnalysisRouteTableRouteProperty$Builder instance using the provided configuration.
  The function takes the CfnNetworkInsightsAnalysis$AnalysisRouteTableRouteProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `destinationCidr` | java.lang.String | [[cdk.support/lookup-entry]] | `:destination-cidr` |
| `destinationPrefixListId` | java.lang.String | [[cdk.support/lookup-entry]] | `:destination-prefix-list-id` |
| `egressOnlyInternetGatewayId` | java.lang.String | [[cdk.support/lookup-entry]] | `:egress-only-internet-gateway-id` |
| `gatewayId` | java.lang.String | [[cdk.support/lookup-entry]] | `:gateway-id` |
| `instanceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-id` |
| `natGatewayId` | java.lang.String | [[cdk.support/lookup-entry]] | `:nat-gateway-id` |
| `networkInterfaceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-interface-id` |
| `origin` | java.lang.String | [[cdk.support/lookup-entry]] | `:origin` |
| `state` | java.lang.String | [[cdk.support/lookup-entry]] | `:state` |
| `transitGatewayId` | java.lang.String | [[cdk.support/lookup-entry]] | `:transit-gateway-id` |
| `vpcPeeringConnectionId` | java.lang.String | [[cdk.support/lookup-entry]] | `:vpc-peering-connection-id` |
"
  [^CfnNetworkInsightsAnalysis$AnalysisRouteTableRouteProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :destination-cidr)]
    (. builder destinationCidr data))
  (when-let [data (lookup-entry config id :destination-prefix-list-id)]
    (. builder destinationPrefixListId data))
  (when-let [data (lookup-entry config id :egress-only-internet-gateway-id)]
    (. builder egressOnlyInternetGatewayId data))
  (when-let [data (lookup-entry config id :gateway-id)]
    (. builder gatewayId data))
  (when-let [data (lookup-entry config id :instance-id)]
    (. builder instanceId data))
  (when-let [data (lookup-entry config id :nat-gateway-id)]
    (. builder natGatewayId data))
  (when-let [data (lookup-entry config id :network-interface-id)]
    (. builder networkInterfaceId data))
  (when-let [data (lookup-entry config id :origin)]
    (. builder origin data))
  (when-let [data (lookup-entry config id :state)]
    (. builder state data))
  (when-let [data (lookup-entry config id :transit-gateway-id)]
    (. builder transitGatewayId data))
  (when-let [data (lookup-entry config id :vpc-peering-connection-id)]
    (. builder vpcPeeringConnectionId data))
  (.build builder))


(defn cfn-network-insights-analysis-analysis-route-table-route-property-builder
  "Creates a  `CfnNetworkInsightsAnalysis$AnalysisRouteTableRouteProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-insights-analysis-analysis-route-table-route-property-builder (new CfnNetworkInsightsAnalysis$AnalysisRouteTableRouteProperty$Builder) id config))


(defn build-cfn-network-insights-analysis-analysis-security-group-rule-property-builder
  "The build-cfn-network-insights-analysis-analysis-security-group-rule-property-builder function updates a CfnNetworkInsightsAnalysis$AnalysisSecurityGroupRuleProperty$Builder instance using the provided configuration.
  The function takes the CfnNetworkInsightsAnalysis$AnalysisSecurityGroupRuleProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `cidr` | java.lang.String | [[cdk.support/lookup-entry]] | `:cidr` |
| `direction` | java.lang.String | [[cdk.support/lookup-entry]] | `:direction` |
| `portRange` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis$PortRangeProperty | [[cdk.support/lookup-entry]] | `:port-range` |
| `prefixListId` | java.lang.String | [[cdk.support/lookup-entry]] | `:prefix-list-id` |
| `protocol` | java.lang.String | [[cdk.support/lookup-entry]] | `:protocol` |
| `securityGroupId` | java.lang.String | [[cdk.support/lookup-entry]] | `:security-group-id` |
"
  [^CfnNetworkInsightsAnalysis$AnalysisSecurityGroupRuleProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :cidr)]
    (. builder cidr data))
  (when-let [data (lookup-entry config id :direction)]
    (. builder direction data))
  (when-let [data (lookup-entry config id :port-range)]
    (. builder portRange data))
  (when-let [data (lookup-entry config id :prefix-list-id)]
    (. builder prefixListId data))
  (when-let [data (lookup-entry config id :protocol)]
    (. builder protocol data))
  (when-let [data (lookup-entry config id :security-group-id)]
    (. builder securityGroupId data))
  (.build builder))


(defn cfn-network-insights-analysis-analysis-security-group-rule-property-builder
  "Creates a  `CfnNetworkInsightsAnalysis$AnalysisSecurityGroupRuleProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-insights-analysis-analysis-security-group-rule-property-builder (new CfnNetworkInsightsAnalysis$AnalysisSecurityGroupRuleProperty$Builder) id config))


(defn build-cfn-network-insights-analysis-builder
  "The build-cfn-network-insights-analysis-builder function updates a CfnNetworkInsightsAnalysis$Builder instance using the provided configuration.
  The function takes the CfnNetworkInsightsAnalysis$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `additionalAccounts` | java.util.List | [[cdk.support/lookup-entry]] | `:additional-accounts` |
| `filterInArns` | java.util.List | [[cdk.support/lookup-entry]] | `:filter-in-arns` |
| `networkInsightsPathId` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-insights-path-id` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnNetworkInsightsAnalysis$Builder builder id config]
  (when-let [data (lookup-entry config id :additional-accounts)]
    (. builder additionalAccounts data))
  (when-let [data (lookup-entry config id :filter-in-arns)]
    (. builder filterInArns data))
  (when-let [data (lookup-entry config id :network-insights-path-id)]
    (. builder networkInsightsPathId data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-network-insights-analysis-builder
  "Creates a  `CfnNetworkInsightsAnalysis$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-network-insights-analysis-builder (CfnNetworkInsightsAnalysis$Builder/create scope (name id)) id config))


(defn build-cfn-network-insights-analysis-explanation-property-builder
  "The build-cfn-network-insights-analysis-explanation-property-builder function updates a CfnNetworkInsightsAnalysis$ExplanationProperty$Builder instance using the provided configuration.
  The function takes the CfnNetworkInsightsAnalysis$ExplanationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `acl` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis$AnalysisComponentProperty | [[cdk.support/lookup-entry]] | `:acl` |
| `aclRule` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:acl-rule` |
| `address` | java.lang.String | [[cdk.support/lookup-entry]] | `:address` |
| `addresses` | java.util.List | [[cdk.support/lookup-entry]] | `:addresses` |
| `attachedTo` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:attached-to` |
| `availabilityZones` | java.util.List | [[cdk.support/lookup-entry]] | `:availability-zones` |
| `cidrs` | java.util.List | [[cdk.support/lookup-entry]] | `:cidrs` |
| `classicLoadBalancerListener` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis$AnalysisLoadBalancerListenerProperty | [[cdk.support/lookup-entry]] | `:classic-load-balancer-listener` |
| `component` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis$AnalysisComponentProperty | [[cdk.support/lookup-entry]] | `:component` |
| `componentAccount` | java.lang.String | [[cdk.support/lookup-entry]] | `:component-account` |
| `componentRegion` | java.lang.String | [[cdk.support/lookup-entry]] | `:component-region` |
| `customerGateway` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:customer-gateway` |
| `destination` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis$AnalysisComponentProperty | [[cdk.support/lookup-entry]] | `:destination` |
| `destinationVpc` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis$AnalysisComponentProperty | [[cdk.support/lookup-entry]] | `:destination-vpc` |
| `direction` | java.lang.String | [[cdk.support/lookup-entry]] | `:direction` |
| `elasticLoadBalancerListener` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:elastic-load-balancer-listener` |
| `explanationCode` | java.lang.String | [[cdk.support/lookup-entry]] | `:explanation-code` |
| `ingressRouteTable` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:ingress-route-table` |
| `internetGateway` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:internet-gateway` |
| `loadBalancerArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:load-balancer-arn` |
| `loadBalancerListenerPort` | java.lang.Number | [[cdk.support/lookup-entry]] | `:load-balancer-listener-port` |
| `loadBalancerTarget` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:load-balancer-target` |
| `loadBalancerTargetGroup` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis$AnalysisComponentProperty | [[cdk.support/lookup-entry]] | `:load-balancer-target-group` |
| `loadBalancerTargetGroups` | java.util.List | [[cdk.support/lookup-entry]] | `:load-balancer-target-groups` |
| `loadBalancerTargetPort` | java.lang.Number | [[cdk.support/lookup-entry]] | `:load-balancer-target-port` |
| `missingComponent` | java.lang.String | [[cdk.support/lookup-entry]] | `:missing-component` |
| `natGateway` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis$AnalysisComponentProperty | [[cdk.support/lookup-entry]] | `:nat-gateway` |
| `networkInterface` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:network-interface` |
| `packetField` | java.lang.String | [[cdk.support/lookup-entry]] | `:packet-field` |
| `port` | java.lang.Number | [[cdk.support/lookup-entry]] | `:port` |
| `portRanges` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:port-ranges` |
| `prefixList` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis$AnalysisComponentProperty | [[cdk.support/lookup-entry]] | `:prefix-list` |
| `protocols` | java.util.List | [[cdk.support/lookup-entry]] | `:protocols` |
| `routeTable` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis$AnalysisComponentProperty | [[cdk.support/lookup-entry]] | `:route-table` |
| `routeTableRoute` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis$AnalysisRouteTableRouteProperty | [[cdk.support/lookup-entry]] | `:route-table-route` |
| `securityGroup` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis$AnalysisComponentProperty | [[cdk.support/lookup-entry]] | `:security-group` |
| `securityGroupRule` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:security-group-rule` |
| `securityGroups` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:security-groups` |
| `sourceVpc` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis$AnalysisComponentProperty | [[cdk.support/lookup-entry]] | `:source-vpc` |
| `state` | java.lang.String | [[cdk.support/lookup-entry]] | `:state` |
| `subnet` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis$AnalysisComponentProperty | [[cdk.support/lookup-entry]] | `:subnet` |
| `subnetRouteTable` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis$AnalysisComponentProperty | [[cdk.support/lookup-entry]] | `:subnet-route-table` |
| `transitGateway` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis$AnalysisComponentProperty | [[cdk.support/lookup-entry]] | `:transit-gateway` |
| `transitGatewayAttachment` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis$AnalysisComponentProperty | [[cdk.support/lookup-entry]] | `:transit-gateway-attachment` |
| `transitGatewayRouteTable` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis$AnalysisComponentProperty | [[cdk.support/lookup-entry]] | `:transit-gateway-route-table` |
| `transitGatewayRouteTableRoute` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis$TransitGatewayRouteTableRouteProperty | [[cdk.support/lookup-entry]] | `:transit-gateway-route-table-route` |
| `vpc` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis$AnalysisComponentProperty | [[cdk.support/lookup-entry]] | `:vpc` |
| `vpcEndpoint` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis$AnalysisComponentProperty | [[cdk.support/lookup-entry]] | `:vpc-endpoint` |
| `vpcPeeringConnection` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis$AnalysisComponentProperty | [[cdk.support/lookup-entry]] | `:vpc-peering-connection` |
| `vpnConnection` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:vpn-connection` |
| `vpnGateway` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis$AnalysisComponentProperty | [[cdk.support/lookup-entry]] | `:vpn-gateway` |
"
  [^CfnNetworkInsightsAnalysis$ExplanationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :acl)]
    (. builder acl data))
  (when-let [data (lookup-entry config id :acl-rule)]
    (. builder aclRule data))
  (when-let [data (lookup-entry config id :address)]
    (. builder address data))
  (when-let [data (lookup-entry config id :addresses)]
    (. builder addresses data))
  (when-let [data (lookup-entry config id :attached-to)]
    (. builder attachedTo data))
  (when-let [data (lookup-entry config id :availability-zones)]
    (. builder availabilityZones data))
  (when-let [data (lookup-entry config id :cidrs)]
    (. builder cidrs data))
  (when-let [data (lookup-entry config id :classic-load-balancer-listener)]
    (. builder classicLoadBalancerListener data))
  (when-let [data (lookup-entry config id :component)]
    (. builder component data))
  (when-let [data (lookup-entry config id :component-account)]
    (. builder componentAccount data))
  (when-let [data (lookup-entry config id :component-region)]
    (. builder componentRegion data))
  (when-let [data (lookup-entry config id :customer-gateway)]
    (. builder customerGateway data))
  (when-let [data (lookup-entry config id :destination)]
    (. builder destination data))
  (when-let [data (lookup-entry config id :destination-vpc)]
    (. builder destinationVpc data))
  (when-let [data (lookup-entry config id :direction)]
    (. builder direction data))
  (when-let [data (lookup-entry config id :elastic-load-balancer-listener)]
    (. builder elasticLoadBalancerListener data))
  (when-let [data (lookup-entry config id :explanation-code)]
    (. builder explanationCode data))
  (when-let [data (lookup-entry config id :ingress-route-table)]
    (. builder ingressRouteTable data))
  (when-let [data (lookup-entry config id :internet-gateway)]
    (. builder internetGateway data))
  (when-let [data (lookup-entry config id :load-balancer-arn)]
    (. builder loadBalancerArn data))
  (when-let [data (lookup-entry config id :load-balancer-listener-port)]
    (. builder loadBalancerListenerPort data))
  (when-let [data (lookup-entry config id :load-balancer-target)]
    (. builder loadBalancerTarget data))
  (when-let [data (lookup-entry config id :load-balancer-target-group)]
    (. builder loadBalancerTargetGroup data))
  (when-let [data (lookup-entry config id :load-balancer-target-groups)]
    (. builder loadBalancerTargetGroups data))
  (when-let [data (lookup-entry config id :load-balancer-target-port)]
    (. builder loadBalancerTargetPort data))
  (when-let [data (lookup-entry config id :missing-component)]
    (. builder missingComponent data))
  (when-let [data (lookup-entry config id :nat-gateway)]
    (. builder natGateway data))
  (when-let [data (lookup-entry config id :network-interface)]
    (. builder networkInterface data))
  (when-let [data (lookup-entry config id :packet-field)]
    (. builder packetField data))
  (when-let [data (lookup-entry config id :port)]
    (. builder port data))
  (when-let [data (lookup-entry config id :port-ranges)]
    (. builder portRanges data))
  (when-let [data (lookup-entry config id :prefix-list)]
    (. builder prefixList data))
  (when-let [data (lookup-entry config id :protocols)]
    (. builder protocols data))
  (when-let [data (lookup-entry config id :route-table)]
    (. builder routeTable data))
  (when-let [data (lookup-entry config id :route-table-route)]
    (. builder routeTableRoute data))
  (when-let [data (lookup-entry config id :security-group)]
    (. builder securityGroup data))
  (when-let [data (lookup-entry config id :security-group-rule)]
    (. builder securityGroupRule data))
  (when-let [data (lookup-entry config id :security-groups)]
    (. builder securityGroups data))
  (when-let [data (lookup-entry config id :source-vpc)]
    (. builder sourceVpc data))
  (when-let [data (lookup-entry config id :state)]
    (. builder state data))
  (when-let [data (lookup-entry config id :subnet)]
    (. builder subnet data))
  (when-let [data (lookup-entry config id :subnet-route-table)]
    (. builder subnetRouteTable data))
  (when-let [data (lookup-entry config id :transit-gateway)]
    (. builder transitGateway data))
  (when-let [data (lookup-entry config id :transit-gateway-attachment)]
    (. builder transitGatewayAttachment data))
  (when-let [data (lookup-entry config id :transit-gateway-route-table)]
    (. builder transitGatewayRouteTable data))
  (when-let [data (lookup-entry config id :transit-gateway-route-table-route)]
    (. builder transitGatewayRouteTableRoute data))
  (when-let [data (lookup-entry config id :vpc)]
    (. builder vpc data))
  (when-let [data (lookup-entry config id :vpc-endpoint)]
    (. builder vpcEndpoint data))
  (when-let [data (lookup-entry config id :vpc-peering-connection)]
    (. builder vpcPeeringConnection data))
  (when-let [data (lookup-entry config id :vpn-connection)]
    (. builder vpnConnection data))
  (when-let [data (lookup-entry config id :vpn-gateway)]
    (. builder vpnGateway data))
  (.build builder))


(defn cfn-network-insights-analysis-explanation-property-builder
  "Creates a  `CfnNetworkInsightsAnalysis$ExplanationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-insights-analysis-explanation-property-builder (new CfnNetworkInsightsAnalysis$ExplanationProperty$Builder) id config))


(defn build-cfn-network-insights-analysis-path-component-property-builder
  "The build-cfn-network-insights-analysis-path-component-property-builder function updates a CfnNetworkInsightsAnalysis$PathComponentProperty$Builder instance using the provided configuration.
  The function takes the CfnNetworkInsightsAnalysis$PathComponentProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `aclRule` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:acl-rule` |
| `additionalDetails` | java.util.List | [[cdk.support/lookup-entry]] | `:additional-details` |
| `component` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis$AnalysisComponentProperty | [[cdk.support/lookup-entry]] | `:component` |
| `destinationVpc` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:destination-vpc` |
| `elasticLoadBalancerListener` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis$AnalysisComponentProperty | [[cdk.support/lookup-entry]] | `:elastic-load-balancer-listener` |
| `explanations` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:explanations` |
| `inboundHeader` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:inbound-header` |
| `outboundHeader` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:outbound-header` |
| `routeTableRoute` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:route-table-route` |
| `securityGroupRule` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis$AnalysisSecurityGroupRuleProperty | [[cdk.support/lookup-entry]] | `:security-group-rule` |
| `sequenceNumber` | java.lang.Number | [[cdk.support/lookup-entry]] | `:sequence-number` |
| `serviceName` | java.lang.String | [[cdk.support/lookup-entry]] | `:service-name` |
| `sourceVpc` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis$AnalysisComponentProperty | [[cdk.support/lookup-entry]] | `:source-vpc` |
| `subnet` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:subnet` |
| `transitGateway` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:transit-gateway` |
| `transitGatewayRouteTableRoute` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis$TransitGatewayRouteTableRouteProperty | [[cdk.support/lookup-entry]] | `:transit-gateway-route-table-route` |
| `vpc` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:vpc` |
"
  [^CfnNetworkInsightsAnalysis$PathComponentProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :acl-rule)]
    (. builder aclRule data))
  (when-let [data (lookup-entry config id :additional-details)]
    (. builder additionalDetails data))
  (when-let [data (lookup-entry config id :component)]
    (. builder component data))
  (when-let [data (lookup-entry config id :destination-vpc)]
    (. builder destinationVpc data))
  (when-let [data (lookup-entry config id :elastic-load-balancer-listener)]
    (. builder elasticLoadBalancerListener data))
  (when-let [data (lookup-entry config id :explanations)]
    (. builder explanations data))
  (when-let [data (lookup-entry config id :inbound-header)]
    (. builder inboundHeader data))
  (when-let [data (lookup-entry config id :outbound-header)]
    (. builder outboundHeader data))
  (when-let [data (lookup-entry config id :route-table-route)]
    (. builder routeTableRoute data))
  (when-let [data (lookup-entry config id :security-group-rule)]
    (. builder securityGroupRule data))
  (when-let [data (lookup-entry config id :sequence-number)]
    (. builder sequenceNumber data))
  (when-let [data (lookup-entry config id :service-name)]
    (. builder serviceName data))
  (when-let [data (lookup-entry config id :source-vpc)]
    (. builder sourceVpc data))
  (when-let [data (lookup-entry config id :subnet)]
    (. builder subnet data))
  (when-let [data (lookup-entry config id :transit-gateway)]
    (. builder transitGateway data))
  (when-let [data (lookup-entry config id :transit-gateway-route-table-route)]
    (. builder transitGatewayRouteTableRoute data))
  (when-let [data (lookup-entry config id :vpc)]
    (. builder vpc data))
  (.build builder))


(defn cfn-network-insights-analysis-path-component-property-builder
  "Creates a  `CfnNetworkInsightsAnalysis$PathComponentProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-insights-analysis-path-component-property-builder (new CfnNetworkInsightsAnalysis$PathComponentProperty$Builder) id config))


(defn build-cfn-network-insights-analysis-port-range-property-builder
  "The build-cfn-network-insights-analysis-port-range-property-builder function updates a CfnNetworkInsightsAnalysis$PortRangeProperty$Builder instance using the provided configuration.
  The function takes the CfnNetworkInsightsAnalysis$PortRangeProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `from` | java.lang.Number | [[cdk.support/lookup-entry]] | `:from` |
| `to` | java.lang.Number | [[cdk.support/lookup-entry]] | `:to` |
"
  [^CfnNetworkInsightsAnalysis$PortRangeProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :from)]
    (. builder from data))
  (when-let [data (lookup-entry config id :to)]
    (. builder to data))
  (.build builder))


(defn cfn-network-insights-analysis-port-range-property-builder
  "Creates a  `CfnNetworkInsightsAnalysis$PortRangeProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-insights-analysis-port-range-property-builder (new CfnNetworkInsightsAnalysis$PortRangeProperty$Builder) id config))


(defn build-cfn-network-insights-analysis-props-builder
  "The build-cfn-network-insights-analysis-props-builder function updates a CfnNetworkInsightsAnalysisProps$Builder instance using the provided configuration.
  The function takes the CfnNetworkInsightsAnalysisProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `additionalAccounts` | java.util.List | [[cdk.support/lookup-entry]] | `:additional-accounts` |
| `filterInArns` | java.util.List | [[cdk.support/lookup-entry]] | `:filter-in-arns` |
| `networkInsightsPathId` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-insights-path-id` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnNetworkInsightsAnalysisProps$Builder builder id config]
  (when-let [data (lookup-entry config id :additional-accounts)]
    (. builder additionalAccounts data))
  (when-let [data (lookup-entry config id :filter-in-arns)]
    (. builder filterInArns data))
  (when-let [data (lookup-entry config id :network-insights-path-id)]
    (. builder networkInsightsPathId data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-network-insights-analysis-props-builder
  "Creates a  `CfnNetworkInsightsAnalysisProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-insights-analysis-props-builder (new CfnNetworkInsightsAnalysisProps$Builder) id config))


(defn build-cfn-network-insights-analysis-transit-gateway-route-table-route-property-builder
  "The build-cfn-network-insights-analysis-transit-gateway-route-table-route-property-builder function updates a CfnNetworkInsightsAnalysis$TransitGatewayRouteTableRouteProperty$Builder instance using the provided configuration.
  The function takes the CfnNetworkInsightsAnalysis$TransitGatewayRouteTableRouteProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `attachmentId` | java.lang.String | [[cdk.support/lookup-entry]] | `:attachment-id` |
| `destinationCidr` | java.lang.String | [[cdk.support/lookup-entry]] | `:destination-cidr` |
| `prefixListId` | java.lang.String | [[cdk.support/lookup-entry]] | `:prefix-list-id` |
| `resourceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:resource-id` |
| `resourceType` | java.lang.String | [[cdk.support/lookup-entry]] | `:resource-type` |
| `routeOrigin` | java.lang.String | [[cdk.support/lookup-entry]] | `:route-origin` |
| `state` | java.lang.String | [[cdk.support/lookup-entry]] | `:state` |
"
  [^CfnNetworkInsightsAnalysis$TransitGatewayRouteTableRouteProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :attachment-id)]
    (. builder attachmentId data))
  (when-let [data (lookup-entry config id :destination-cidr)]
    (. builder destinationCidr data))
  (when-let [data (lookup-entry config id :prefix-list-id)]
    (. builder prefixListId data))
  (when-let [data (lookup-entry config id :resource-id)]
    (. builder resourceId data))
  (when-let [data (lookup-entry config id :resource-type)]
    (. builder resourceType data))
  (when-let [data (lookup-entry config id :route-origin)]
    (. builder routeOrigin data))
  (when-let [data (lookup-entry config id :state)]
    (. builder state data))
  (.build builder))


(defn cfn-network-insights-analysis-transit-gateway-route-table-route-property-builder
  "Creates a  `CfnNetworkInsightsAnalysis$TransitGatewayRouteTableRouteProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-insights-analysis-transit-gateway-route-table-route-property-builder (new CfnNetworkInsightsAnalysis$TransitGatewayRouteTableRouteProperty$Builder) id config))


(defn build-cfn-network-insights-path-builder
  "The build-cfn-network-insights-path-builder function updates a CfnNetworkInsightsPath$Builder instance using the provided configuration.
  The function takes the CfnNetworkInsightsPath$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `destination` | java.lang.String | [[cdk.support/lookup-entry]] | `:destination` |
| `destinationIp` | java.lang.String | [[cdk.support/lookup-entry]] | `:destination-ip` |
| `destinationPort` | java.lang.Number | [[cdk.support/lookup-entry]] | `:destination-port` |
| `filterAtDestination` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:filter-at-destination` |
| `filterAtSource` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:filter-at-source` |
| `protocol` | java.lang.String | [[cdk.support/lookup-entry]] | `:protocol` |
| `source` | java.lang.String | [[cdk.support/lookup-entry]] | `:source` |
| `sourceIp` | java.lang.String | [[cdk.support/lookup-entry]] | `:source-ip` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnNetworkInsightsPath$Builder builder id config]
  (when-let [data (lookup-entry config id :destination)]
    (. builder destination data))
  (when-let [data (lookup-entry config id :destination-ip)]
    (. builder destinationIp data))
  (when-let [data (lookup-entry config id :destination-port)]
    (. builder destinationPort data))
  (when-let [data (lookup-entry config id :filter-at-destination)]
    (. builder filterAtDestination data))
  (when-let [data (lookup-entry config id :filter-at-source)]
    (. builder filterAtSource data))
  (when-let [data (lookup-entry config id :protocol)]
    (. builder protocol data))
  (when-let [data (lookup-entry config id :source)]
    (. builder source data))
  (when-let [data (lookup-entry config id :source-ip)]
    (. builder sourceIp data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-network-insights-path-builder
  "Creates a  `CfnNetworkInsightsPath$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-network-insights-path-builder (CfnNetworkInsightsPath$Builder/create scope (name id)) id config))


(defn build-cfn-network-insights-path-filter-port-range-property-builder
  "The build-cfn-network-insights-path-filter-port-range-property-builder function updates a CfnNetworkInsightsPath$FilterPortRangeProperty$Builder instance using the provided configuration.
  The function takes the CfnNetworkInsightsPath$FilterPortRangeProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `fromPort` | java.lang.Number | [[cdk.support/lookup-entry]] | `:from-port` |
| `toPort` | java.lang.Number | [[cdk.support/lookup-entry]] | `:to-port` |
"
  [^CfnNetworkInsightsPath$FilterPortRangeProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :from-port)]
    (. builder fromPort data))
  (when-let [data (lookup-entry config id :to-port)]
    (. builder toPort data))
  (.build builder))


(defn cfn-network-insights-path-filter-port-range-property-builder
  "Creates a  `CfnNetworkInsightsPath$FilterPortRangeProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-insights-path-filter-port-range-property-builder (new CfnNetworkInsightsPath$FilterPortRangeProperty$Builder) id config))


(defn build-cfn-network-insights-path-path-filter-property-builder
  "The build-cfn-network-insights-path-path-filter-property-builder function updates a CfnNetworkInsightsPath$PathFilterProperty$Builder instance using the provided configuration.
  The function takes the CfnNetworkInsightsPath$PathFilterProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `destinationAddress` | java.lang.String | [[cdk.support/lookup-entry]] | `:destination-address` |
| `destinationPortRange` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsPath$FilterPortRangeProperty | [[cdk.support/lookup-entry]] | `:destination-port-range` |
| `sourceAddress` | java.lang.String | [[cdk.support/lookup-entry]] | `:source-address` |
| `sourcePortRange` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsPath$FilterPortRangeProperty | [[cdk.support/lookup-entry]] | `:source-port-range` |
"
  [^CfnNetworkInsightsPath$PathFilterProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :destination-address)]
    (. builder destinationAddress data))
  (when-let [data (lookup-entry config id :destination-port-range)]
    (. builder destinationPortRange data))
  (when-let [data (lookup-entry config id :source-address)]
    (. builder sourceAddress data))
  (when-let [data (lookup-entry config id :source-port-range)]
    (. builder sourcePortRange data))
  (.build builder))


(defn cfn-network-insights-path-path-filter-property-builder
  "Creates a  `CfnNetworkInsightsPath$PathFilterProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-insights-path-path-filter-property-builder (new CfnNetworkInsightsPath$PathFilterProperty$Builder) id config))


(defn build-cfn-network-insights-path-props-builder
  "The build-cfn-network-insights-path-props-builder function updates a CfnNetworkInsightsPathProps$Builder instance using the provided configuration.
  The function takes the CfnNetworkInsightsPathProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `destination` | java.lang.String | [[cdk.support/lookup-entry]] | `:destination` |
| `destinationIp` | java.lang.String | [[cdk.support/lookup-entry]] | `:destination-ip` |
| `destinationPort` | java.lang.Number | [[cdk.support/lookup-entry]] | `:destination-port` |
| `filterAtDestination` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:filter-at-destination` |
| `filterAtSource` | software.amazon.awscdk.services.ec2.CfnNetworkInsightsPath$PathFilterProperty | [[cdk.support/lookup-entry]] | `:filter-at-source` |
| `protocol` | java.lang.String | [[cdk.support/lookup-entry]] | `:protocol` |
| `source` | java.lang.String | [[cdk.support/lookup-entry]] | `:source` |
| `sourceIp` | java.lang.String | [[cdk.support/lookup-entry]] | `:source-ip` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnNetworkInsightsPathProps$Builder builder id config]
  (when-let [data (lookup-entry config id :destination)]
    (. builder destination data))
  (when-let [data (lookup-entry config id :destination-ip)]
    (. builder destinationIp data))
  (when-let [data (lookup-entry config id :destination-port)]
    (. builder destinationPort data))
  (when-let [data (lookup-entry config id :filter-at-destination)]
    (. builder filterAtDestination data))
  (when-let [data (lookup-entry config id :filter-at-source)]
    (. builder filterAtSource data))
  (when-let [data (lookup-entry config id :protocol)]
    (. builder protocol data))
  (when-let [data (lookup-entry config id :source)]
    (. builder source data))
  (when-let [data (lookup-entry config id :source-ip)]
    (. builder sourceIp data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-network-insights-path-props-builder
  "Creates a  `CfnNetworkInsightsPathProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-insights-path-props-builder (new CfnNetworkInsightsPathProps$Builder) id config))


(defn build-cfn-network-interface-attachment-builder
  "The build-cfn-network-interface-attachment-builder function updates a CfnNetworkInterfaceAttachment$Builder instance using the provided configuration.
  The function takes the CfnNetworkInterfaceAttachment$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `deleteOnTermination` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:delete-on-termination` |
| `deviceIndex` | java.lang.String | [[cdk.support/lookup-entry]] | `:device-index` |
| `enaSrdSpecification` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:ena-srd-specification` |
| `instanceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-id` |
| `networkInterfaceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-interface-id` |
"
  [^CfnNetworkInterfaceAttachment$Builder builder id config]
  (when-let [data (lookup-entry config id :delete-on-termination)]
    (. builder deleteOnTermination data))
  (when-let [data (lookup-entry config id :device-index)]
    (. builder deviceIndex data))
  (when-let [data (lookup-entry config id :ena-srd-specification)]
    (. builder enaSrdSpecification data))
  (when-let [data (lookup-entry config id :instance-id)]
    (. builder instanceId data))
  (when-let [data (lookup-entry config id :network-interface-id)]
    (. builder networkInterfaceId data))
  (.build builder))


(defn cfn-network-interface-attachment-builder
  "Creates a  `CfnNetworkInterfaceAttachment$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-network-interface-attachment-builder (CfnNetworkInterfaceAttachment$Builder/create scope (name id)) id config))


(defn build-cfn-network-interface-attachment-ena-srd-specification-property-builder
  "The build-cfn-network-interface-attachment-ena-srd-specification-property-builder function updates a CfnNetworkInterfaceAttachment$EnaSrdSpecificationProperty$Builder instance using the provided configuration.
  The function takes the CfnNetworkInterfaceAttachment$EnaSrdSpecificationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `enaSrdEnabled` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:ena-srd-enabled` |
| `enaSrdUdpSpecification` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:ena-srd-udp-specification` |
"
  [^CfnNetworkInterfaceAttachment$EnaSrdSpecificationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :ena-srd-enabled)]
    (. builder enaSrdEnabled data))
  (when-let [data (lookup-entry config id :ena-srd-udp-specification)]
    (. builder enaSrdUdpSpecification data))
  (.build builder))


(defn cfn-network-interface-attachment-ena-srd-specification-property-builder
  "Creates a  `CfnNetworkInterfaceAttachment$EnaSrdSpecificationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-interface-attachment-ena-srd-specification-property-builder (new CfnNetworkInterfaceAttachment$EnaSrdSpecificationProperty$Builder) id config))


(defn build-cfn-network-interface-attachment-ena-srd-udp-specification-property-builder
  "The build-cfn-network-interface-attachment-ena-srd-udp-specification-property-builder function updates a CfnNetworkInterfaceAttachment$EnaSrdUdpSpecificationProperty$Builder instance using the provided configuration.
  The function takes the CfnNetworkInterfaceAttachment$EnaSrdUdpSpecificationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `enaSrdUdpEnabled` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:ena-srd-udp-enabled` |
"
  [^CfnNetworkInterfaceAttachment$EnaSrdUdpSpecificationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :ena-srd-udp-enabled)]
    (. builder enaSrdUdpEnabled data))
  (.build builder))


(defn cfn-network-interface-attachment-ena-srd-udp-specification-property-builder
  "Creates a  `CfnNetworkInterfaceAttachment$EnaSrdUdpSpecificationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-interface-attachment-ena-srd-udp-specification-property-builder (new CfnNetworkInterfaceAttachment$EnaSrdUdpSpecificationProperty$Builder) id config))


(defn build-cfn-network-interface-attachment-props-builder
  "The build-cfn-network-interface-attachment-props-builder function updates a CfnNetworkInterfaceAttachmentProps$Builder instance using the provided configuration.
  The function takes the CfnNetworkInterfaceAttachmentProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `deleteOnTermination` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:delete-on-termination` |
| `deviceIndex` | java.lang.String | [[cdk.support/lookup-entry]] | `:device-index` |
| `enaSrdSpecification` | software.amazon.awscdk.services.ec2.CfnNetworkInterfaceAttachment$EnaSrdSpecificationProperty | [[cdk.support/lookup-entry]] | `:ena-srd-specification` |
| `instanceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-id` |
| `networkInterfaceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-interface-id` |
"
  [^CfnNetworkInterfaceAttachmentProps$Builder builder id config]
  (when-let [data (lookup-entry config id :delete-on-termination)]
    (. builder deleteOnTermination data))
  (when-let [data (lookup-entry config id :device-index)]
    (. builder deviceIndex data))
  (when-let [data (lookup-entry config id :ena-srd-specification)]
    (. builder enaSrdSpecification data))
  (when-let [data (lookup-entry config id :instance-id)]
    (. builder instanceId data))
  (when-let [data (lookup-entry config id :network-interface-id)]
    (. builder networkInterfaceId data))
  (.build builder))


(defn cfn-network-interface-attachment-props-builder
  "Creates a  `CfnNetworkInterfaceAttachmentProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-interface-attachment-props-builder (new CfnNetworkInterfaceAttachmentProps$Builder) id config))


(defn build-cfn-network-interface-builder
  "The build-cfn-network-interface-builder function updates a CfnNetworkInterface$Builder instance using the provided configuration.
  The function takes the CfnNetworkInterface$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `connectionTrackingSpecification` | software.amazon.awscdk.services.ec2.CfnNetworkInterface$ConnectionTrackingSpecificationProperty | [[cdk.support/lookup-entry]] | `:connection-tracking-specification` |
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `enablePrimaryIpv6` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:enable-primary-ipv6` |
| `groupSet` | java.util.List | [[cdk.support/lookup-entry]] | `:group-set` |
| `interfaceType` | java.lang.String | [[cdk.support/lookup-entry]] | `:interface-type` |
| `ipv4PrefixCount` | java.lang.Number | [[cdk.support/lookup-entry]] | `:ipv4-prefix-count` |
| `ipv4Prefixes` | java.util.List | [[cdk.support/lookup-entry]] | `:ipv4-prefixes` |
| `ipv6AddressCount` | java.lang.Number | [[cdk.support/lookup-entry]] | `:ipv6-address-count` |
| `ipv6Addresses` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:ipv6-addresses` |
| `ipv6PrefixCount` | java.lang.Number | [[cdk.support/lookup-entry]] | `:ipv6-prefix-count` |
| `ipv6Prefixes` | java.util.List | [[cdk.support/lookup-entry]] | `:ipv6-prefixes` |
| `privateIpAddress` | java.lang.String | [[cdk.support/lookup-entry]] | `:private-ip-address` |
| `privateIpAddresses` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:private-ip-addresses` |
| `secondaryPrivateIpAddressCount` | java.lang.Number | [[cdk.support/lookup-entry]] | `:secondary-private-ip-address-count` |
| `sourceDestCheck` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:source-dest-check` |
| `subnetId` | java.lang.String | [[cdk.support/lookup-entry]] | `:subnet-id` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnNetworkInterface$Builder builder id config]
  (when-let [data (lookup-entry config id :connection-tracking-specification)]
    (. builder connectionTrackingSpecification data))
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :enable-primary-ipv6)]
    (. builder enablePrimaryIpv6 data))
  (when-let [data (lookup-entry config id :group-set)]
    (. builder groupSet data))
  (when-let [data (lookup-entry config id :interface-type)]
    (. builder interfaceType data))
  (when-let [data (lookup-entry config id :ipv4-prefix-count)]
    (. builder ipv4PrefixCount data))
  (when-let [data (lookup-entry config id :ipv4-prefixes)]
    (. builder ipv4Prefixes data))
  (when-let [data (lookup-entry config id :ipv6-address-count)]
    (. builder ipv6AddressCount data))
  (when-let [data (lookup-entry config id :ipv6-addresses)]
    (. builder ipv6Addresses data))
  (when-let [data (lookup-entry config id :ipv6-prefix-count)]
    (. builder ipv6PrefixCount data))
  (when-let [data (lookup-entry config id :ipv6-prefixes)]
    (. builder ipv6Prefixes data))
  (when-let [data (lookup-entry config id :private-ip-address)]
    (. builder privateIpAddress data))
  (when-let [data (lookup-entry config id :private-ip-addresses)]
    (. builder privateIpAddresses data))
  (when-let [data (lookup-entry config id :secondary-private-ip-address-count)]
    (. builder secondaryPrivateIpAddressCount data))
  (when-let [data (lookup-entry config id :source-dest-check)]
    (. builder sourceDestCheck data))
  (when-let [data (lookup-entry config id :subnet-id)]
    (. builder subnetId data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-network-interface-builder
  "Creates a  `CfnNetworkInterface$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-network-interface-builder (CfnNetworkInterface$Builder/create scope (name id)) id config))


(defn build-cfn-network-interface-connection-tracking-specification-property-builder
  "The build-cfn-network-interface-connection-tracking-specification-property-builder function updates a CfnNetworkInterface$ConnectionTrackingSpecificationProperty$Builder instance using the provided configuration.
  The function takes the CfnNetworkInterface$ConnectionTrackingSpecificationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `tcpEstablishedTimeout` | java.lang.Number | [[cdk.support/lookup-entry]] | `:tcp-established-timeout` |
| `udpStreamTimeout` | java.lang.Number | [[cdk.support/lookup-entry]] | `:udp-stream-timeout` |
| `udpTimeout` | java.lang.Number | [[cdk.support/lookup-entry]] | `:udp-timeout` |
"
  [^CfnNetworkInterface$ConnectionTrackingSpecificationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :tcp-established-timeout)]
    (. builder tcpEstablishedTimeout data))
  (when-let [data (lookup-entry config id :udp-stream-timeout)]
    (. builder udpStreamTimeout data))
  (when-let [data (lookup-entry config id :udp-timeout)]
    (. builder udpTimeout data))
  (.build builder))


(defn cfn-network-interface-connection-tracking-specification-property-builder
  "Creates a  `CfnNetworkInterface$ConnectionTrackingSpecificationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-interface-connection-tracking-specification-property-builder (new CfnNetworkInterface$ConnectionTrackingSpecificationProperty$Builder) id config))


(defn build-cfn-network-interface-instance-ipv6-address-property-builder
  "The build-cfn-network-interface-instance-ipv6-address-property-builder function updates a CfnNetworkInterface$InstanceIpv6AddressProperty$Builder instance using the provided configuration.
  The function takes the CfnNetworkInterface$InstanceIpv6AddressProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `ipv6Address` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipv6-address` |
"
  [^CfnNetworkInterface$InstanceIpv6AddressProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :ipv6-address)]
    (. builder ipv6Address data))
  (.build builder))


(defn cfn-network-interface-instance-ipv6-address-property-builder
  "Creates a  `CfnNetworkInterface$InstanceIpv6AddressProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-interface-instance-ipv6-address-property-builder (new CfnNetworkInterface$InstanceIpv6AddressProperty$Builder) id config))


(defn build-cfn-network-interface-ipv4-prefix-specification-property-builder
  "The build-cfn-network-interface-ipv4-prefix-specification-property-builder function updates a CfnNetworkInterface$Ipv4PrefixSpecificationProperty$Builder instance using the provided configuration.
  The function takes the CfnNetworkInterface$Ipv4PrefixSpecificationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `ipv4Prefix` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipv4-prefix` |
"
  [^CfnNetworkInterface$Ipv4PrefixSpecificationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :ipv4-prefix)]
    (. builder ipv4Prefix data))
  (.build builder))


(defn cfn-network-interface-ipv4-prefix-specification-property-builder
  "Creates a  `CfnNetworkInterface$Ipv4PrefixSpecificationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-interface-ipv4-prefix-specification-property-builder (new CfnNetworkInterface$Ipv4PrefixSpecificationProperty$Builder) id config))


(defn build-cfn-network-interface-ipv6-prefix-specification-property-builder
  "The build-cfn-network-interface-ipv6-prefix-specification-property-builder function updates a CfnNetworkInterface$Ipv6PrefixSpecificationProperty$Builder instance using the provided configuration.
  The function takes the CfnNetworkInterface$Ipv6PrefixSpecificationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `ipv6Prefix` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipv6-prefix` |
"
  [^CfnNetworkInterface$Ipv6PrefixSpecificationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :ipv6-prefix)]
    (. builder ipv6Prefix data))
  (.build builder))


(defn cfn-network-interface-ipv6-prefix-specification-property-builder
  "Creates a  `CfnNetworkInterface$Ipv6PrefixSpecificationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-interface-ipv6-prefix-specification-property-builder (new CfnNetworkInterface$Ipv6PrefixSpecificationProperty$Builder) id config))


(defn build-cfn-network-interface-permission-builder
  "The build-cfn-network-interface-permission-builder function updates a CfnNetworkInterfacePermission$Builder instance using the provided configuration.
  The function takes the CfnNetworkInterfacePermission$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `awsAccountId` | java.lang.String | [[cdk.support/lookup-entry]] | `:aws-account-id` |
| `networkInterfaceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-interface-id` |
| `permission` | java.lang.String | [[cdk.support/lookup-entry]] | `:permission` |
"
  [^CfnNetworkInterfacePermission$Builder builder id config]
  (when-let [data (lookup-entry config id :aws-account-id)]
    (. builder awsAccountId data))
  (when-let [data (lookup-entry config id :network-interface-id)]
    (. builder networkInterfaceId data))
  (when-let [data (lookup-entry config id :permission)]
    (. builder permission data))
  (.build builder))


(defn cfn-network-interface-permission-builder
  "Creates a  `CfnNetworkInterfacePermission$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-network-interface-permission-builder (CfnNetworkInterfacePermission$Builder/create scope (name id)) id config))


(defn build-cfn-network-interface-permission-props-builder
  "The build-cfn-network-interface-permission-props-builder function updates a CfnNetworkInterfacePermissionProps$Builder instance using the provided configuration.
  The function takes the CfnNetworkInterfacePermissionProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `awsAccountId` | java.lang.String | [[cdk.support/lookup-entry]] | `:aws-account-id` |
| `networkInterfaceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-interface-id` |
| `permission` | java.lang.String | [[cdk.support/lookup-entry]] | `:permission` |
"
  [^CfnNetworkInterfacePermissionProps$Builder builder id config]
  (when-let [data (lookup-entry config id :aws-account-id)]
    (. builder awsAccountId data))
  (when-let [data (lookup-entry config id :network-interface-id)]
    (. builder networkInterfaceId data))
  (when-let [data (lookup-entry config id :permission)]
    (. builder permission data))
  (.build builder))


(defn cfn-network-interface-permission-props-builder
  "Creates a  `CfnNetworkInterfacePermissionProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-interface-permission-props-builder (new CfnNetworkInterfacePermissionProps$Builder) id config))


(defn build-cfn-network-interface-private-ip-address-specification-property-builder
  "The build-cfn-network-interface-private-ip-address-specification-property-builder function updates a CfnNetworkInterface$PrivateIpAddressSpecificationProperty$Builder instance using the provided configuration.
  The function takes the CfnNetworkInterface$PrivateIpAddressSpecificationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `primary` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:primary` |
| `privateIpAddress` | java.lang.String | [[cdk.support/lookup-entry]] | `:private-ip-address` |
"
  [^CfnNetworkInterface$PrivateIpAddressSpecificationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :primary)]
    (. builder primary data))
  (when-let [data (lookup-entry config id :private-ip-address)]
    (. builder privateIpAddress data))
  (.build builder))


(defn cfn-network-interface-private-ip-address-specification-property-builder
  "Creates a  `CfnNetworkInterface$PrivateIpAddressSpecificationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-interface-private-ip-address-specification-property-builder (new CfnNetworkInterface$PrivateIpAddressSpecificationProperty$Builder) id config))


(defn build-cfn-network-interface-props-builder
  "The build-cfn-network-interface-props-builder function updates a CfnNetworkInterfaceProps$Builder instance using the provided configuration.
  The function takes the CfnNetworkInterfaceProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `connectionTrackingSpecification` | software.amazon.awscdk.services.ec2.CfnNetworkInterface$ConnectionTrackingSpecificationProperty | [[cdk.support/lookup-entry]] | `:connection-tracking-specification` |
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `enablePrimaryIpv6` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:enable-primary-ipv6` |
| `groupSet` | java.util.List | [[cdk.support/lookup-entry]] | `:group-set` |
| `interfaceType` | java.lang.String | [[cdk.support/lookup-entry]] | `:interface-type` |
| `ipv4PrefixCount` | java.lang.Number | [[cdk.support/lookup-entry]] | `:ipv4-prefix-count` |
| `ipv4Prefixes` | java.util.List | [[cdk.support/lookup-entry]] | `:ipv4-prefixes` |
| `ipv6AddressCount` | java.lang.Number | [[cdk.support/lookup-entry]] | `:ipv6-address-count` |
| `ipv6Addresses` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:ipv6-addresses` |
| `ipv6PrefixCount` | java.lang.Number | [[cdk.support/lookup-entry]] | `:ipv6-prefix-count` |
| `ipv6Prefixes` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:ipv6-prefixes` |
| `privateIpAddress` | java.lang.String | [[cdk.support/lookup-entry]] | `:private-ip-address` |
| `privateIpAddresses` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:private-ip-addresses` |
| `secondaryPrivateIpAddressCount` | java.lang.Number | [[cdk.support/lookup-entry]] | `:secondary-private-ip-address-count` |
| `sourceDestCheck` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:source-dest-check` |
| `subnetId` | java.lang.String | [[cdk.support/lookup-entry]] | `:subnet-id` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnNetworkInterfaceProps$Builder builder id config]
  (when-let [data (lookup-entry config id :connection-tracking-specification)]
    (. builder connectionTrackingSpecification data))
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :enable-primary-ipv6)]
    (. builder enablePrimaryIpv6 data))
  (when-let [data (lookup-entry config id :group-set)]
    (. builder groupSet data))
  (when-let [data (lookup-entry config id :interface-type)]
    (. builder interfaceType data))
  (when-let [data (lookup-entry config id :ipv4-prefix-count)]
    (. builder ipv4PrefixCount data))
  (when-let [data (lookup-entry config id :ipv4-prefixes)]
    (. builder ipv4Prefixes data))
  (when-let [data (lookup-entry config id :ipv6-address-count)]
    (. builder ipv6AddressCount data))
  (when-let [data (lookup-entry config id :ipv6-addresses)]
    (. builder ipv6Addresses data))
  (when-let [data (lookup-entry config id :ipv6-prefix-count)]
    (. builder ipv6PrefixCount data))
  (when-let [data (lookup-entry config id :ipv6-prefixes)]
    (. builder ipv6Prefixes data))
  (when-let [data (lookup-entry config id :private-ip-address)]
    (. builder privateIpAddress data))
  (when-let [data (lookup-entry config id :private-ip-addresses)]
    (. builder privateIpAddresses data))
  (when-let [data (lookup-entry config id :secondary-private-ip-address-count)]
    (. builder secondaryPrivateIpAddressCount data))
  (when-let [data (lookup-entry config id :source-dest-check)]
    (. builder sourceDestCheck data))
  (when-let [data (lookup-entry config id :subnet-id)]
    (. builder subnetId data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-network-interface-props-builder
  "Creates a  `CfnNetworkInterfaceProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-interface-props-builder (new CfnNetworkInterfaceProps$Builder) id config))


(defn build-cfn-network-performance-metric-subscription-builder
  "The build-cfn-network-performance-metric-subscription-builder function updates a CfnNetworkPerformanceMetricSubscription$Builder instance using the provided configuration.
  The function takes the CfnNetworkPerformanceMetricSubscription$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `destination` | java.lang.String | [[cdk.support/lookup-entry]] | `:destination` |
| `metric` | java.lang.String | [[cdk.support/lookup-entry]] | `:metric` |
| `source` | java.lang.String | [[cdk.support/lookup-entry]] | `:source` |
| `statistic` | java.lang.String | [[cdk.support/lookup-entry]] | `:statistic` |
"
  [^CfnNetworkPerformanceMetricSubscription$Builder builder id config]
  (when-let [data (lookup-entry config id :destination)]
    (. builder destination data))
  (when-let [data (lookup-entry config id :metric)]
    (. builder metric data))
  (when-let [data (lookup-entry config id :source)]
    (. builder source data))
  (when-let [data (lookup-entry config id :statistic)]
    (. builder statistic data))
  (.build builder))


(defn cfn-network-performance-metric-subscription-builder
  "Creates a  `CfnNetworkPerformanceMetricSubscription$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-network-performance-metric-subscription-builder (CfnNetworkPerformanceMetricSubscription$Builder/create scope (name id)) id config))


(defn build-cfn-network-performance-metric-subscription-props-builder
  "The build-cfn-network-performance-metric-subscription-props-builder function updates a CfnNetworkPerformanceMetricSubscriptionProps$Builder instance using the provided configuration.
  The function takes the CfnNetworkPerformanceMetricSubscriptionProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `destination` | java.lang.String | [[cdk.support/lookup-entry]] | `:destination` |
| `metric` | java.lang.String | [[cdk.support/lookup-entry]] | `:metric` |
| `source` | java.lang.String | [[cdk.support/lookup-entry]] | `:source` |
| `statistic` | java.lang.String | [[cdk.support/lookup-entry]] | `:statistic` |
"
  [^CfnNetworkPerformanceMetricSubscriptionProps$Builder builder id config]
  (when-let [data (lookup-entry config id :destination)]
    (. builder destination data))
  (when-let [data (lookup-entry config id :metric)]
    (. builder metric data))
  (when-let [data (lookup-entry config id :source)]
    (. builder source data))
  (when-let [data (lookup-entry config id :statistic)]
    (. builder statistic data))
  (.build builder))


(defn cfn-network-performance-metric-subscription-props-builder
  "Creates a  `CfnNetworkPerformanceMetricSubscriptionProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-network-performance-metric-subscription-props-builder (new CfnNetworkPerformanceMetricSubscriptionProps$Builder) id config))


(defn build-cfn-placement-group-builder
  "The build-cfn-placement-group-builder function updates a CfnPlacementGroup$Builder instance using the provided configuration.
  The function takes the CfnPlacementGroup$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `partitionCount` | java.lang.Number | [[cdk.support/lookup-entry]] | `:partition-count` |
| `spreadLevel` | java.lang.String | [[cdk.support/lookup-entry]] | `:spread-level` |
| `strategy` | java.lang.String | [[cdk.support/lookup-entry]] | `:strategy` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnPlacementGroup$Builder builder id config]
  (when-let [data (lookup-entry config id :partition-count)]
    (. builder partitionCount data))
  (when-let [data (lookup-entry config id :spread-level)]
    (. builder spreadLevel data))
  (when-let [data (lookup-entry config id :strategy)]
    (. builder strategy data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-placement-group-builder
  "Creates a  `CfnPlacementGroup$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-placement-group-builder (CfnPlacementGroup$Builder/create scope (name id)) id config))


(defn build-cfn-placement-group-props-builder
  "The build-cfn-placement-group-props-builder function updates a CfnPlacementGroupProps$Builder instance using the provided configuration.
  The function takes the CfnPlacementGroupProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `partitionCount` | java.lang.Number | [[cdk.support/lookup-entry]] | `:partition-count` |
| `spreadLevel` | java.lang.String | [[cdk.support/lookup-entry]] | `:spread-level` |
| `strategy` | java.lang.String | [[cdk.support/lookup-entry]] | `:strategy` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnPlacementGroupProps$Builder builder id config]
  (when-let [data (lookup-entry config id :partition-count)]
    (. builder partitionCount data))
  (when-let [data (lookup-entry config id :spread-level)]
    (. builder spreadLevel data))
  (when-let [data (lookup-entry config id :strategy)]
    (. builder strategy data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-placement-group-props-builder
  "Creates a  `CfnPlacementGroupProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-placement-group-props-builder (new CfnPlacementGroupProps$Builder) id config))


(defn build-cfn-prefix-list-builder
  "The build-cfn-prefix-list-builder function updates a CfnPrefixList$Builder instance using the provided configuration.
  The function takes the CfnPrefixList$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `addressFamily` | java.lang.String | [[cdk.support/lookup-entry]] | `:address-family` |
| `entries` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:entries` |
| `maxEntries` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max-entries` |
| `prefixListName` | java.lang.String | [[cdk.support/lookup-entry]] | `:prefix-list-name` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnPrefixList$Builder builder id config]
  (when-let [data (lookup-entry config id :address-family)]
    (. builder addressFamily data))
  (when-let [data (lookup-entry config id :entries)]
    (. builder entries data))
  (when-let [data (lookup-entry config id :max-entries)]
    (. builder maxEntries data))
  (when-let [data (lookup-entry config id :prefix-list-name)]
    (. builder prefixListName data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-prefix-list-builder
  "Creates a  `CfnPrefixList$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-prefix-list-builder (CfnPrefixList$Builder/create scope (name id)) id config))


(defn build-cfn-prefix-list-entry-property-builder
  "The build-cfn-prefix-list-entry-property-builder function updates a CfnPrefixList$EntryProperty$Builder instance using the provided configuration.
  The function takes the CfnPrefixList$EntryProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `cidr` | java.lang.String | [[cdk.support/lookup-entry]] | `:cidr` |
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
"
  [^CfnPrefixList$EntryProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :cidr)]
    (. builder cidr data))
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (.build builder))


(defn cfn-prefix-list-entry-property-builder
  "Creates a  `CfnPrefixList$EntryProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-prefix-list-entry-property-builder (new CfnPrefixList$EntryProperty$Builder) id config))


(defn build-cfn-prefix-list-props-builder
  "The build-cfn-prefix-list-props-builder function updates a CfnPrefixListProps$Builder instance using the provided configuration.
  The function takes the CfnPrefixListProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `addressFamily` | java.lang.String | [[cdk.support/lookup-entry]] | `:address-family` |
| `entries` | java.util.List | [[cdk.support/lookup-entry]] | `:entries` |
| `maxEntries` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max-entries` |
| `prefixListName` | java.lang.String | [[cdk.support/lookup-entry]] | `:prefix-list-name` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnPrefixListProps$Builder builder id config]
  (when-let [data (lookup-entry config id :address-family)]
    (. builder addressFamily data))
  (when-let [data (lookup-entry config id :entries)]
    (. builder entries data))
  (when-let [data (lookup-entry config id :max-entries)]
    (. builder maxEntries data))
  (when-let [data (lookup-entry config id :prefix-list-name)]
    (. builder prefixListName data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-prefix-list-props-builder
  "Creates a  `CfnPrefixListProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-prefix-list-props-builder (new CfnPrefixListProps$Builder) id config))


(defn build-cfn-route-builder
  "The build-cfn-route-builder function updates a CfnRoute$Builder instance using the provided configuration.
  The function takes the CfnRoute$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `carrierGatewayId` | java.lang.String | [[cdk.support/lookup-entry]] | `:carrier-gateway-id` |
| `coreNetworkArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:core-network-arn` |
| `destinationCidrBlock` | java.lang.String | [[cdk.support/lookup-entry]] | `:destination-cidr-block` |
| `destinationIpv6CidrBlock` | java.lang.String | [[cdk.support/lookup-entry]] | `:destination-ipv6-cidr-block` |
| `destinationPrefixListId` | java.lang.String | [[cdk.support/lookup-entry]] | `:destination-prefix-list-id` |
| `egressOnlyInternetGatewayId` | java.lang.String | [[cdk.support/lookup-entry]] | `:egress-only-internet-gateway-id` |
| `gatewayId` | java.lang.String | [[cdk.support/lookup-entry]] | `:gateway-id` |
| `instanceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-id` |
| `localGatewayId` | java.lang.String | [[cdk.support/lookup-entry]] | `:local-gateway-id` |
| `natGatewayId` | java.lang.String | [[cdk.support/lookup-entry]] | `:nat-gateway-id` |
| `networkInterfaceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-interface-id` |
| `routeTableId` | java.lang.String | [[cdk.support/lookup-entry]] | `:route-table-id` |
| `transitGatewayId` | java.lang.String | [[cdk.support/lookup-entry]] | `:transit-gateway-id` |
| `vpcEndpointId` | java.lang.String | [[cdk.support/lookup-entry]] | `:vpc-endpoint-id` |
| `vpcPeeringConnectionId` | java.lang.String | [[cdk.support/lookup-entry]] | `:vpc-peering-connection-id` |
"
  [^CfnRoute$Builder builder id config]
  (when-let [data (lookup-entry config id :carrier-gateway-id)]
    (. builder carrierGatewayId data))
  (when-let [data (lookup-entry config id :core-network-arn)]
    (. builder coreNetworkArn data))
  (when-let [data (lookup-entry config id :destination-cidr-block)]
    (. builder destinationCidrBlock data))
  (when-let [data (lookup-entry config id :destination-ipv6-cidr-block)]
    (. builder destinationIpv6CidrBlock data))
  (when-let [data (lookup-entry config id :destination-prefix-list-id)]
    (. builder destinationPrefixListId data))
  (when-let [data (lookup-entry config id :egress-only-internet-gateway-id)]
    (. builder egressOnlyInternetGatewayId data))
  (when-let [data (lookup-entry config id :gateway-id)]
    (. builder gatewayId data))
  (when-let [data (lookup-entry config id :instance-id)]
    (. builder instanceId data))
  (when-let [data (lookup-entry config id :local-gateway-id)]
    (. builder localGatewayId data))
  (when-let [data (lookup-entry config id :nat-gateway-id)]
    (. builder natGatewayId data))
  (when-let [data (lookup-entry config id :network-interface-id)]
    (. builder networkInterfaceId data))
  (when-let [data (lookup-entry config id :route-table-id)]
    (. builder routeTableId data))
  (when-let [data (lookup-entry config id :transit-gateway-id)]
    (. builder transitGatewayId data))
  (when-let [data (lookup-entry config id :vpc-endpoint-id)]
    (. builder vpcEndpointId data))
  (when-let [data (lookup-entry config id :vpc-peering-connection-id)]
    (. builder vpcPeeringConnectionId data))
  (.build builder))


(defn cfn-route-builder
  "Creates a  `CfnRoute$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-route-builder (CfnRoute$Builder/create scope (name id)) id config))


(defn build-cfn-route-props-builder
  "The build-cfn-route-props-builder function updates a CfnRouteProps$Builder instance using the provided configuration.
  The function takes the CfnRouteProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `carrierGatewayId` | java.lang.String | [[cdk.support/lookup-entry]] | `:carrier-gateway-id` |
| `coreNetworkArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:core-network-arn` |
| `destinationCidrBlock` | java.lang.String | [[cdk.support/lookup-entry]] | `:destination-cidr-block` |
| `destinationIpv6CidrBlock` | java.lang.String | [[cdk.support/lookup-entry]] | `:destination-ipv6-cidr-block` |
| `destinationPrefixListId` | java.lang.String | [[cdk.support/lookup-entry]] | `:destination-prefix-list-id` |
| `egressOnlyInternetGatewayId` | java.lang.String | [[cdk.support/lookup-entry]] | `:egress-only-internet-gateway-id` |
| `gatewayId` | java.lang.String | [[cdk.support/lookup-entry]] | `:gateway-id` |
| `instanceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-id` |
| `localGatewayId` | java.lang.String | [[cdk.support/lookup-entry]] | `:local-gateway-id` |
| `natGatewayId` | java.lang.String | [[cdk.support/lookup-entry]] | `:nat-gateway-id` |
| `networkInterfaceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-interface-id` |
| `routeTableId` | java.lang.String | [[cdk.support/lookup-entry]] | `:route-table-id` |
| `transitGatewayId` | java.lang.String | [[cdk.support/lookup-entry]] | `:transit-gateway-id` |
| `vpcEndpointId` | java.lang.String | [[cdk.support/lookup-entry]] | `:vpc-endpoint-id` |
| `vpcPeeringConnectionId` | java.lang.String | [[cdk.support/lookup-entry]] | `:vpc-peering-connection-id` |
"
  [^CfnRouteProps$Builder builder id config]
  (when-let [data (lookup-entry config id :carrier-gateway-id)]
    (. builder carrierGatewayId data))
  (when-let [data (lookup-entry config id :core-network-arn)]
    (. builder coreNetworkArn data))
  (when-let [data (lookup-entry config id :destination-cidr-block)]
    (. builder destinationCidrBlock data))
  (when-let [data (lookup-entry config id :destination-ipv6-cidr-block)]
    (. builder destinationIpv6CidrBlock data))
  (when-let [data (lookup-entry config id :destination-prefix-list-id)]
    (. builder destinationPrefixListId data))
  (when-let [data (lookup-entry config id :egress-only-internet-gateway-id)]
    (. builder egressOnlyInternetGatewayId data))
  (when-let [data (lookup-entry config id :gateway-id)]
    (. builder gatewayId data))
  (when-let [data (lookup-entry config id :instance-id)]
    (. builder instanceId data))
  (when-let [data (lookup-entry config id :local-gateway-id)]
    (. builder localGatewayId data))
  (when-let [data (lookup-entry config id :nat-gateway-id)]
    (. builder natGatewayId data))
  (when-let [data (lookup-entry config id :network-interface-id)]
    (. builder networkInterfaceId data))
  (when-let [data (lookup-entry config id :route-table-id)]
    (. builder routeTableId data))
  (when-let [data (lookup-entry config id :transit-gateway-id)]
    (. builder transitGatewayId data))
  (when-let [data (lookup-entry config id :vpc-endpoint-id)]
    (. builder vpcEndpointId data))
  (when-let [data (lookup-entry config id :vpc-peering-connection-id)]
    (. builder vpcPeeringConnectionId data))
  (.build builder))


(defn cfn-route-props-builder
  "Creates a  `CfnRouteProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-route-props-builder (new CfnRouteProps$Builder) id config))


(defn build-cfn-route-table-builder
  "The build-cfn-route-table-builder function updates a CfnRouteTable$Builder instance using the provided configuration.
  The function takes the CfnRouteTable$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `vpcId` | java.lang.String | [[cdk.support/lookup-entry]] | `:vpc-id` |
"
  [^CfnRouteTable$Builder builder id config]
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :vpc-id)]
    (. builder vpcId data))
  (.build builder))


(defn cfn-route-table-builder
  "Creates a  `CfnRouteTable$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-route-table-builder (CfnRouteTable$Builder/create scope (name id)) id config))


(defn build-cfn-route-table-props-builder
  "The build-cfn-route-table-props-builder function updates a CfnRouteTableProps$Builder instance using the provided configuration.
  The function takes the CfnRouteTableProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `vpcId` | java.lang.String | [[cdk.support/lookup-entry]] | `:vpc-id` |
"
  [^CfnRouteTableProps$Builder builder id config]
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :vpc-id)]
    (. builder vpcId data))
  (.build builder))


(defn cfn-route-table-props-builder
  "Creates a  `CfnRouteTableProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-route-table-props-builder (new CfnRouteTableProps$Builder) id config))


(defn build-cfn-security-group-builder
  "The build-cfn-security-group-builder function updates a CfnSecurityGroup$Builder instance using the provided configuration.
  The function takes the CfnSecurityGroup$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `groupDescription` | java.lang.String | [[cdk.support/lookup-entry]] | `:group-description` |
| `groupName` | java.lang.String | [[cdk.support/lookup-entry]] | `:group-name` |
| `securityGroupEgress` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:security-group-egress` |
| `securityGroupIngress` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:security-group-ingress` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `vpcId` | java.lang.String | [[cdk.support/lookup-entry]] | `:vpc-id` |
"
  [^CfnSecurityGroup$Builder builder id config]
  (when-let [data (lookup-entry config id :group-description)]
    (. builder groupDescription data))
  (when-let [data (lookup-entry config id :group-name)]
    (. builder groupName data))
  (when-let [data (lookup-entry config id :security-group-egress)]
    (. builder securityGroupEgress data))
  (when-let [data (lookup-entry config id :security-group-ingress)]
    (. builder securityGroupIngress data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :vpc-id)]
    (. builder vpcId data))
  (.build builder))


(defn cfn-security-group-builder
  "Creates a  `CfnSecurityGroup$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-security-group-builder (CfnSecurityGroup$Builder/create scope (name id)) id config))


(defn build-cfn-security-group-egress-builder
  "The build-cfn-security-group-egress-builder function updates a CfnSecurityGroupEgress$Builder instance using the provided configuration.
  The function takes the CfnSecurityGroupEgress$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `cidrIp` | java.lang.String | [[cdk.support/lookup-entry]] | `:cidr-ip` |
| `cidrIpv6` | java.lang.String | [[cdk.support/lookup-entry]] | `:cidr-ipv6` |
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `destinationPrefixListId` | java.lang.String | [[cdk.support/lookup-entry]] | `:destination-prefix-list-id` |
| `destinationSecurityGroupId` | java.lang.String | [[cdk.support/lookup-entry]] | `:destination-security-group-id` |
| `fromPort` | java.lang.Number | [[cdk.support/lookup-entry]] | `:from-port` |
| `groupId` | java.lang.String | [[cdk.support/lookup-entry]] | `:group-id` |
| `ipProtocol` | java.lang.String | [[cdk.support/lookup-entry]] | `:ip-protocol` |
| `toPort` | java.lang.Number | [[cdk.support/lookup-entry]] | `:to-port` |
"
  [^CfnSecurityGroupEgress$Builder builder id config]
  (when-let [data (lookup-entry config id :cidr-ip)]
    (. builder cidrIp data))
  (when-let [data (lookup-entry config id :cidr-ipv6)]
    (. builder cidrIpv6 data))
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :destination-prefix-list-id)]
    (. builder destinationPrefixListId data))
  (when-let [data (lookup-entry config id :destination-security-group-id)]
    (. builder destinationSecurityGroupId data))
  (when-let [data (lookup-entry config id :from-port)]
    (. builder fromPort data))
  (when-let [data (lookup-entry config id :group-id)]
    (. builder groupId data))
  (when-let [data (lookup-entry config id :ip-protocol)]
    (. builder ipProtocol data))
  (when-let [data (lookup-entry config id :to-port)]
    (. builder toPort data))
  (.build builder))


(defn cfn-security-group-egress-builder
  "Creates a  `CfnSecurityGroupEgress$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-security-group-egress-builder (CfnSecurityGroupEgress$Builder/create scope (name id)) id config))


(defn build-cfn-security-group-egress-property-builder
  "The build-cfn-security-group-egress-property-builder function updates a CfnSecurityGroup$EgressProperty$Builder instance using the provided configuration.
  The function takes the CfnSecurityGroup$EgressProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `cidrIp` | java.lang.String | [[cdk.support/lookup-entry]] | `:cidr-ip` |
| `cidrIpv6` | java.lang.String | [[cdk.support/lookup-entry]] | `:cidr-ipv6` |
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `destinationPrefixListId` | java.lang.String | [[cdk.support/lookup-entry]] | `:destination-prefix-list-id` |
| `destinationSecurityGroupId` | java.lang.String | [[cdk.support/lookup-entry]] | `:destination-security-group-id` |
| `fromPort` | java.lang.Number | [[cdk.support/lookup-entry]] | `:from-port` |
| `ipProtocol` | java.lang.String | [[cdk.support/lookup-entry]] | `:ip-protocol` |
| `toPort` | java.lang.Number | [[cdk.support/lookup-entry]] | `:to-port` |
"
  [^CfnSecurityGroup$EgressProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :cidr-ip)]
    (. builder cidrIp data))
  (when-let [data (lookup-entry config id :cidr-ipv6)]
    (. builder cidrIpv6 data))
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :destination-prefix-list-id)]
    (. builder destinationPrefixListId data))
  (when-let [data (lookup-entry config id :destination-security-group-id)]
    (. builder destinationSecurityGroupId data))
  (when-let [data (lookup-entry config id :from-port)]
    (. builder fromPort data))
  (when-let [data (lookup-entry config id :ip-protocol)]
    (. builder ipProtocol data))
  (when-let [data (lookup-entry config id :to-port)]
    (. builder toPort data))
  (.build builder))


(defn cfn-security-group-egress-property-builder
  "Creates a  `CfnSecurityGroup$EgressProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-security-group-egress-property-builder (new CfnSecurityGroup$EgressProperty$Builder) id config))


(defn build-cfn-security-group-egress-props-builder
  "The build-cfn-security-group-egress-props-builder function updates a CfnSecurityGroupEgressProps$Builder instance using the provided configuration.
  The function takes the CfnSecurityGroupEgressProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `cidrIp` | java.lang.String | [[cdk.support/lookup-entry]] | `:cidr-ip` |
| `cidrIpv6` | java.lang.String | [[cdk.support/lookup-entry]] | `:cidr-ipv6` |
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `destinationPrefixListId` | java.lang.String | [[cdk.support/lookup-entry]] | `:destination-prefix-list-id` |
| `destinationSecurityGroupId` | java.lang.String | [[cdk.support/lookup-entry]] | `:destination-security-group-id` |
| `fromPort` | java.lang.Number | [[cdk.support/lookup-entry]] | `:from-port` |
| `groupId` | java.lang.String | [[cdk.support/lookup-entry]] | `:group-id` |
| `ipProtocol` | java.lang.String | [[cdk.support/lookup-entry]] | `:ip-protocol` |
| `toPort` | java.lang.Number | [[cdk.support/lookup-entry]] | `:to-port` |
"
  [^CfnSecurityGroupEgressProps$Builder builder id config]
  (when-let [data (lookup-entry config id :cidr-ip)]
    (. builder cidrIp data))
  (when-let [data (lookup-entry config id :cidr-ipv6)]
    (. builder cidrIpv6 data))
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :destination-prefix-list-id)]
    (. builder destinationPrefixListId data))
  (when-let [data (lookup-entry config id :destination-security-group-id)]
    (. builder destinationSecurityGroupId data))
  (when-let [data (lookup-entry config id :from-port)]
    (. builder fromPort data))
  (when-let [data (lookup-entry config id :group-id)]
    (. builder groupId data))
  (when-let [data (lookup-entry config id :ip-protocol)]
    (. builder ipProtocol data))
  (when-let [data (lookup-entry config id :to-port)]
    (. builder toPort data))
  (.build builder))


(defn cfn-security-group-egress-props-builder
  "Creates a  `CfnSecurityGroupEgressProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-security-group-egress-props-builder (new CfnSecurityGroupEgressProps$Builder) id config))


(defn build-cfn-security-group-ingress-builder
  "The build-cfn-security-group-ingress-builder function updates a CfnSecurityGroupIngress$Builder instance using the provided configuration.
  The function takes the CfnSecurityGroupIngress$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `cidrIp` | java.lang.String | [[cdk.support/lookup-entry]] | `:cidr-ip` |
| `cidrIpv6` | java.lang.String | [[cdk.support/lookup-entry]] | `:cidr-ipv6` |
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `fromPort` | java.lang.Number | [[cdk.support/lookup-entry]] | `:from-port` |
| `groupId` | java.lang.String | [[cdk.support/lookup-entry]] | `:group-id` |
| `groupName` | java.lang.String | [[cdk.support/lookup-entry]] | `:group-name` |
| `ipProtocol` | java.lang.String | [[cdk.support/lookup-entry]] | `:ip-protocol` |
| `sourcePrefixListId` | java.lang.String | [[cdk.support/lookup-entry]] | `:source-prefix-list-id` |
| `sourceSecurityGroupId` | java.lang.String | [[cdk.support/lookup-entry]] | `:source-security-group-id` |
| `sourceSecurityGroupName` | java.lang.String | [[cdk.support/lookup-entry]] | `:source-security-group-name` |
| `sourceSecurityGroupOwnerId` | java.lang.String | [[cdk.support/lookup-entry]] | `:source-security-group-owner-id` |
| `toPort` | java.lang.Number | [[cdk.support/lookup-entry]] | `:to-port` |
"
  [^CfnSecurityGroupIngress$Builder builder id config]
  (when-let [data (lookup-entry config id :cidr-ip)]
    (. builder cidrIp data))
  (when-let [data (lookup-entry config id :cidr-ipv6)]
    (. builder cidrIpv6 data))
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :from-port)]
    (. builder fromPort data))
  (when-let [data (lookup-entry config id :group-id)]
    (. builder groupId data))
  (when-let [data (lookup-entry config id :group-name)]
    (. builder groupName data))
  (when-let [data (lookup-entry config id :ip-protocol)]
    (. builder ipProtocol data))
  (when-let [data (lookup-entry config id :source-prefix-list-id)]
    (. builder sourcePrefixListId data))
  (when-let [data (lookup-entry config id :source-security-group-id)]
    (. builder sourceSecurityGroupId data))
  (when-let [data (lookup-entry config id :source-security-group-name)]
    (. builder sourceSecurityGroupName data))
  (when-let [data (lookup-entry config id :source-security-group-owner-id)]
    (. builder sourceSecurityGroupOwnerId data))
  (when-let [data (lookup-entry config id :to-port)]
    (. builder toPort data))
  (.build builder))


(defn cfn-security-group-ingress-builder
  "Creates a  `CfnSecurityGroupIngress$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-security-group-ingress-builder (CfnSecurityGroupIngress$Builder/create scope (name id)) id config))


(defn build-cfn-security-group-ingress-property-builder
  "The build-cfn-security-group-ingress-property-builder function updates a CfnSecurityGroup$IngressProperty$Builder instance using the provided configuration.
  The function takes the CfnSecurityGroup$IngressProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `cidrIp` | java.lang.String | [[cdk.support/lookup-entry]] | `:cidr-ip` |
| `cidrIpv6` | java.lang.String | [[cdk.support/lookup-entry]] | `:cidr-ipv6` |
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `fromPort` | java.lang.Number | [[cdk.support/lookup-entry]] | `:from-port` |
| `ipProtocol` | java.lang.String | [[cdk.support/lookup-entry]] | `:ip-protocol` |
| `sourcePrefixListId` | java.lang.String | [[cdk.support/lookup-entry]] | `:source-prefix-list-id` |
| `sourceSecurityGroupId` | java.lang.String | [[cdk.support/lookup-entry]] | `:source-security-group-id` |
| `sourceSecurityGroupName` | java.lang.String | [[cdk.support/lookup-entry]] | `:source-security-group-name` |
| `sourceSecurityGroupOwnerId` | java.lang.String | [[cdk.support/lookup-entry]] | `:source-security-group-owner-id` |
| `toPort` | java.lang.Number | [[cdk.support/lookup-entry]] | `:to-port` |
"
  [^CfnSecurityGroup$IngressProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :cidr-ip)]
    (. builder cidrIp data))
  (when-let [data (lookup-entry config id :cidr-ipv6)]
    (. builder cidrIpv6 data))
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :from-port)]
    (. builder fromPort data))
  (when-let [data (lookup-entry config id :ip-protocol)]
    (. builder ipProtocol data))
  (when-let [data (lookup-entry config id :source-prefix-list-id)]
    (. builder sourcePrefixListId data))
  (when-let [data (lookup-entry config id :source-security-group-id)]
    (. builder sourceSecurityGroupId data))
  (when-let [data (lookup-entry config id :source-security-group-name)]
    (. builder sourceSecurityGroupName data))
  (when-let [data (lookup-entry config id :source-security-group-owner-id)]
    (. builder sourceSecurityGroupOwnerId data))
  (when-let [data (lookup-entry config id :to-port)]
    (. builder toPort data))
  (.build builder))


(defn cfn-security-group-ingress-property-builder
  "Creates a  `CfnSecurityGroup$IngressProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-security-group-ingress-property-builder (new CfnSecurityGroup$IngressProperty$Builder) id config))


(defn build-cfn-security-group-ingress-props-builder
  "The build-cfn-security-group-ingress-props-builder function updates a CfnSecurityGroupIngressProps$Builder instance using the provided configuration.
  The function takes the CfnSecurityGroupIngressProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `cidrIp` | java.lang.String | [[cdk.support/lookup-entry]] | `:cidr-ip` |
| `cidrIpv6` | java.lang.String | [[cdk.support/lookup-entry]] | `:cidr-ipv6` |
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `fromPort` | java.lang.Number | [[cdk.support/lookup-entry]] | `:from-port` |
| `groupId` | java.lang.String | [[cdk.support/lookup-entry]] | `:group-id` |
| `groupName` | java.lang.String | [[cdk.support/lookup-entry]] | `:group-name` |
| `ipProtocol` | java.lang.String | [[cdk.support/lookup-entry]] | `:ip-protocol` |
| `sourcePrefixListId` | java.lang.String | [[cdk.support/lookup-entry]] | `:source-prefix-list-id` |
| `sourceSecurityGroupId` | java.lang.String | [[cdk.support/lookup-entry]] | `:source-security-group-id` |
| `sourceSecurityGroupName` | java.lang.String | [[cdk.support/lookup-entry]] | `:source-security-group-name` |
| `sourceSecurityGroupOwnerId` | java.lang.String | [[cdk.support/lookup-entry]] | `:source-security-group-owner-id` |
| `toPort` | java.lang.Number | [[cdk.support/lookup-entry]] | `:to-port` |
"
  [^CfnSecurityGroupIngressProps$Builder builder id config]
  (when-let [data (lookup-entry config id :cidr-ip)]
    (. builder cidrIp data))
  (when-let [data (lookup-entry config id :cidr-ipv6)]
    (. builder cidrIpv6 data))
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :from-port)]
    (. builder fromPort data))
  (when-let [data (lookup-entry config id :group-id)]
    (. builder groupId data))
  (when-let [data (lookup-entry config id :group-name)]
    (. builder groupName data))
  (when-let [data (lookup-entry config id :ip-protocol)]
    (. builder ipProtocol data))
  (when-let [data (lookup-entry config id :source-prefix-list-id)]
    (. builder sourcePrefixListId data))
  (when-let [data (lookup-entry config id :source-security-group-id)]
    (. builder sourceSecurityGroupId data))
  (when-let [data (lookup-entry config id :source-security-group-name)]
    (. builder sourceSecurityGroupName data))
  (when-let [data (lookup-entry config id :source-security-group-owner-id)]
    (. builder sourceSecurityGroupOwnerId data))
  (when-let [data (lookup-entry config id :to-port)]
    (. builder toPort data))
  (.build builder))


(defn cfn-security-group-ingress-props-builder
  "Creates a  `CfnSecurityGroupIngressProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-security-group-ingress-props-builder (new CfnSecurityGroupIngressProps$Builder) id config))


(defn build-cfn-security-group-props-builder
  "The build-cfn-security-group-props-builder function updates a CfnSecurityGroupProps$Builder instance using the provided configuration.
  The function takes the CfnSecurityGroupProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `groupDescription` | java.lang.String | [[cdk.support/lookup-entry]] | `:group-description` |
| `groupName` | java.lang.String | [[cdk.support/lookup-entry]] | `:group-name` |
| `securityGroupEgress` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:security-group-egress` |
| `securityGroupIngress` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:security-group-ingress` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `vpcId` | java.lang.String | [[cdk.support/lookup-entry]] | `:vpc-id` |
"
  [^CfnSecurityGroupProps$Builder builder id config]
  (when-let [data (lookup-entry config id :group-description)]
    (. builder groupDescription data))
  (when-let [data (lookup-entry config id :group-name)]
    (. builder groupName data))
  (when-let [data (lookup-entry config id :security-group-egress)]
    (. builder securityGroupEgress data))
  (when-let [data (lookup-entry config id :security-group-ingress)]
    (. builder securityGroupIngress data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :vpc-id)]
    (. builder vpcId data))
  (.build builder))


(defn cfn-security-group-props-builder
  "Creates a  `CfnSecurityGroupProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-security-group-props-builder (new CfnSecurityGroupProps$Builder) id config))


(defn build-cfn-snapshot-block-public-access-builder
  "The build-cfn-snapshot-block-public-access-builder function updates a CfnSnapshotBlockPublicAccess$Builder instance using the provided configuration.
  The function takes the CfnSnapshotBlockPublicAccess$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `state` | java.lang.String | [[cdk.support/lookup-entry]] | `:state` |
"
  [^CfnSnapshotBlockPublicAccess$Builder builder id config]
  (when-let [data (lookup-entry config id :state)]
    (. builder state data))
  (.build builder))


(defn cfn-snapshot-block-public-access-builder
  "Creates a  `CfnSnapshotBlockPublicAccess$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-snapshot-block-public-access-builder (CfnSnapshotBlockPublicAccess$Builder/create scope (name id)) id config))


(defn build-cfn-snapshot-block-public-access-props-builder
  "The build-cfn-snapshot-block-public-access-props-builder function updates a CfnSnapshotBlockPublicAccessProps$Builder instance using the provided configuration.
  The function takes the CfnSnapshotBlockPublicAccessProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `state` | java.lang.String | [[cdk.support/lookup-entry]] | `:state` |
"
  [^CfnSnapshotBlockPublicAccessProps$Builder builder id config]
  (when-let [data (lookup-entry config id :state)]
    (. builder state data))
  (.build builder))


(defn cfn-snapshot-block-public-access-props-builder
  "Creates a  `CfnSnapshotBlockPublicAccessProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-snapshot-block-public-access-props-builder (new CfnSnapshotBlockPublicAccessProps$Builder) id config))


(defn build-cfn-spot-fleet-accelerator-count-request-property-builder
  "The build-cfn-spot-fleet-accelerator-count-request-property-builder function updates a CfnSpotFleet$AcceleratorCountRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnSpotFleet$AcceleratorCountRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `max` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max` |
| `min` | java.lang.Number | [[cdk.support/lookup-entry]] | `:min` |
"
  [^CfnSpotFleet$AcceleratorCountRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :max)]
    (. builder max data))
  (when-let [data (lookup-entry config id :min)]
    (. builder min data))
  (.build builder))


(defn cfn-spot-fleet-accelerator-count-request-property-builder
  "Creates a  `CfnSpotFleet$AcceleratorCountRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-spot-fleet-accelerator-count-request-property-builder (new CfnSpotFleet$AcceleratorCountRequestProperty$Builder) id config))


(defn build-cfn-spot-fleet-accelerator-total-memory-mi-b-request-property-builder
  "The build-cfn-spot-fleet-accelerator-total-memory-mi-b-request-property-builder function updates a CfnSpotFleet$AcceleratorTotalMemoryMiBRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnSpotFleet$AcceleratorTotalMemoryMiBRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `max` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max` |
| `min` | java.lang.Number | [[cdk.support/lookup-entry]] | `:min` |
"
  [^CfnSpotFleet$AcceleratorTotalMemoryMiBRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :max)]
    (. builder max data))
  (when-let [data (lookup-entry config id :min)]
    (. builder min data))
  (.build builder))


(defn cfn-spot-fleet-accelerator-total-memory-mi-b-request-property-builder
  "Creates a  `CfnSpotFleet$AcceleratorTotalMemoryMiBRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-spot-fleet-accelerator-total-memory-mi-b-request-property-builder (new CfnSpotFleet$AcceleratorTotalMemoryMiBRequestProperty$Builder) id config))


(defn build-cfn-spot-fleet-baseline-ebs-bandwidth-mbps-request-property-builder
  "The build-cfn-spot-fleet-baseline-ebs-bandwidth-mbps-request-property-builder function updates a CfnSpotFleet$BaselineEbsBandwidthMbpsRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnSpotFleet$BaselineEbsBandwidthMbpsRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `max` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max` |
| `min` | java.lang.Number | [[cdk.support/lookup-entry]] | `:min` |
"
  [^CfnSpotFleet$BaselineEbsBandwidthMbpsRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :max)]
    (. builder max data))
  (when-let [data (lookup-entry config id :min)]
    (. builder min data))
  (.build builder))


(defn cfn-spot-fleet-baseline-ebs-bandwidth-mbps-request-property-builder
  "Creates a  `CfnSpotFleet$BaselineEbsBandwidthMbpsRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-spot-fleet-baseline-ebs-bandwidth-mbps-request-property-builder (new CfnSpotFleet$BaselineEbsBandwidthMbpsRequestProperty$Builder) id config))


(defn build-cfn-spot-fleet-block-device-mapping-property-builder
  "The build-cfn-spot-fleet-block-device-mapping-property-builder function updates a CfnSpotFleet$BlockDeviceMappingProperty$Builder instance using the provided configuration.
  The function takes the CfnSpotFleet$BlockDeviceMappingProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `deviceName` | java.lang.String | [[cdk.support/lookup-entry]] | `:device-name` |
| `ebs` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:ebs` |
| `noDevice` | java.lang.String | [[cdk.support/lookup-entry]] | `:no-device` |
| `virtualName` | java.lang.String | [[cdk.support/lookup-entry]] | `:virtual-name` |
"
  [^CfnSpotFleet$BlockDeviceMappingProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :device-name)]
    (. builder deviceName data))
  (when-let [data (lookup-entry config id :ebs)]
    (. builder ebs data))
  (when-let [data (lookup-entry config id :no-device)]
    (. builder noDevice data))
  (when-let [data (lookup-entry config id :virtual-name)]
    (. builder virtualName data))
  (.build builder))


(defn cfn-spot-fleet-block-device-mapping-property-builder
  "Creates a  `CfnSpotFleet$BlockDeviceMappingProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-spot-fleet-block-device-mapping-property-builder (new CfnSpotFleet$BlockDeviceMappingProperty$Builder) id config))


(defn build-cfn-spot-fleet-builder
  "The build-cfn-spot-fleet-builder function updates a CfnSpotFleet$Builder instance using the provided configuration.
  The function takes the CfnSpotFleet$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `spotFleetRequestConfigData` | software.amazon.awscdk.services.ec2.CfnSpotFleet$SpotFleetRequestConfigDataProperty | [[cdk.support/lookup-entry]] | `:spot-fleet-request-config-data` |
"
  [^CfnSpotFleet$Builder builder id config]
  (when-let [data (lookup-entry config id :spot-fleet-request-config-data)]
    (. builder spotFleetRequestConfigData data))
  (.build builder))


(defn cfn-spot-fleet-builder
  "Creates a  `CfnSpotFleet$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-spot-fleet-builder (CfnSpotFleet$Builder/create scope (name id)) id config))


(defn build-cfn-spot-fleet-classic-load-balancer-property-builder
  "The build-cfn-spot-fleet-classic-load-balancer-property-builder function updates a CfnSpotFleet$ClassicLoadBalancerProperty$Builder instance using the provided configuration.
  The function takes the CfnSpotFleet$ClassicLoadBalancerProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `name` | java.lang.String | [[cdk.support/lookup-entry]] | `:name` |
"
  [^CfnSpotFleet$ClassicLoadBalancerProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :name)]
    (. builder name data))
  (.build builder))


(defn cfn-spot-fleet-classic-load-balancer-property-builder
  "Creates a  `CfnSpotFleet$ClassicLoadBalancerProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-spot-fleet-classic-load-balancer-property-builder (new CfnSpotFleet$ClassicLoadBalancerProperty$Builder) id config))


(defn build-cfn-spot-fleet-classic-load-balancers-config-property-builder
  "The build-cfn-spot-fleet-classic-load-balancers-config-property-builder function updates a CfnSpotFleet$ClassicLoadBalancersConfigProperty$Builder instance using the provided configuration.
  The function takes the CfnSpotFleet$ClassicLoadBalancersConfigProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `classicLoadBalancers` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:classic-load-balancers` |
"
  [^CfnSpotFleet$ClassicLoadBalancersConfigProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :classic-load-balancers)]
    (. builder classicLoadBalancers data))
  (.build builder))


(defn cfn-spot-fleet-classic-load-balancers-config-property-builder
  "Creates a  `CfnSpotFleet$ClassicLoadBalancersConfigProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-spot-fleet-classic-load-balancers-config-property-builder (new CfnSpotFleet$ClassicLoadBalancersConfigProperty$Builder) id config))


(defn build-cfn-spot-fleet-ebs-block-device-property-builder
  "The build-cfn-spot-fleet-ebs-block-device-property-builder function updates a CfnSpotFleet$EbsBlockDeviceProperty$Builder instance using the provided configuration.
  The function takes the CfnSpotFleet$EbsBlockDeviceProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `deleteOnTermination` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:delete-on-termination` |
| `encrypted` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:encrypted` |
| `iops` | java.lang.Number | [[cdk.support/lookup-entry]] | `:iops` |
| `snapshotId` | java.lang.String | [[cdk.support/lookup-entry]] | `:snapshot-id` |
| `volumeSize` | java.lang.Number | [[cdk.support/lookup-entry]] | `:volume-size` |
| `volumeType` | java.lang.String | [[cdk.support/lookup-entry]] | `:volume-type` |
"
  [^CfnSpotFleet$EbsBlockDeviceProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :delete-on-termination)]
    (. builder deleteOnTermination data))
  (when-let [data (lookup-entry config id :encrypted)]
    (. builder encrypted data))
  (when-let [data (lookup-entry config id :iops)]
    (. builder iops data))
  (when-let [data (lookup-entry config id :snapshot-id)]
    (. builder snapshotId data))
  (when-let [data (lookup-entry config id :volume-size)]
    (. builder volumeSize data))
  (when-let [data (lookup-entry config id :volume-type)]
    (. builder volumeType data))
  (.build builder))


(defn cfn-spot-fleet-ebs-block-device-property-builder
  "Creates a  `CfnSpotFleet$EbsBlockDeviceProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-spot-fleet-ebs-block-device-property-builder (new CfnSpotFleet$EbsBlockDeviceProperty$Builder) id config))


(defn build-cfn-spot-fleet-fleet-launch-template-specification-property-builder
  "The build-cfn-spot-fleet-fleet-launch-template-specification-property-builder function updates a CfnSpotFleet$FleetLaunchTemplateSpecificationProperty$Builder instance using the provided configuration.
  The function takes the CfnSpotFleet$FleetLaunchTemplateSpecificationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `launchTemplateId` | java.lang.String | [[cdk.support/lookup-entry]] | `:launch-template-id` |
| `launchTemplateName` | java.lang.String | [[cdk.support/lookup-entry]] | `:launch-template-name` |
| `version` | java.lang.String | [[cdk.support/lookup-entry]] | `:version` |
"
  [^CfnSpotFleet$FleetLaunchTemplateSpecificationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :launch-template-id)]
    (. builder launchTemplateId data))
  (when-let [data (lookup-entry config id :launch-template-name)]
    (. builder launchTemplateName data))
  (when-let [data (lookup-entry config id :version)]
    (. builder version data))
  (.build builder))


(defn cfn-spot-fleet-fleet-launch-template-specification-property-builder
  "Creates a  `CfnSpotFleet$FleetLaunchTemplateSpecificationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-spot-fleet-fleet-launch-template-specification-property-builder (new CfnSpotFleet$FleetLaunchTemplateSpecificationProperty$Builder) id config))


(defn build-cfn-spot-fleet-group-identifier-property-builder
  "The build-cfn-spot-fleet-group-identifier-property-builder function updates a CfnSpotFleet$GroupIdentifierProperty$Builder instance using the provided configuration.
  The function takes the CfnSpotFleet$GroupIdentifierProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `groupId` | java.lang.String | [[cdk.support/lookup-entry]] | `:group-id` |
"
  [^CfnSpotFleet$GroupIdentifierProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :group-id)]
    (. builder groupId data))
  (.build builder))


(defn cfn-spot-fleet-group-identifier-property-builder
  "Creates a  `CfnSpotFleet$GroupIdentifierProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-spot-fleet-group-identifier-property-builder (new CfnSpotFleet$GroupIdentifierProperty$Builder) id config))


(defn build-cfn-spot-fleet-iam-instance-profile-specification-property-builder
  "The build-cfn-spot-fleet-iam-instance-profile-specification-property-builder function updates a CfnSpotFleet$IamInstanceProfileSpecificationProperty$Builder instance using the provided configuration.
  The function takes the CfnSpotFleet$IamInstanceProfileSpecificationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `arn` | java.lang.String | [[cdk.support/lookup-entry]] | `:arn` |
"
  [^CfnSpotFleet$IamInstanceProfileSpecificationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :arn)]
    (. builder arn data))
  (.build builder))


(defn cfn-spot-fleet-iam-instance-profile-specification-property-builder
  "Creates a  `CfnSpotFleet$IamInstanceProfileSpecificationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-spot-fleet-iam-instance-profile-specification-property-builder (new CfnSpotFleet$IamInstanceProfileSpecificationProperty$Builder) id config))


(defn build-cfn-spot-fleet-instance-ipv6-address-property-builder
  "The build-cfn-spot-fleet-instance-ipv6-address-property-builder function updates a CfnSpotFleet$InstanceIpv6AddressProperty$Builder instance using the provided configuration.
  The function takes the CfnSpotFleet$InstanceIpv6AddressProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `ipv6Address` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipv6-address` |
"
  [^CfnSpotFleet$InstanceIpv6AddressProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :ipv6-address)]
    (. builder ipv6Address data))
  (.build builder))


(defn cfn-spot-fleet-instance-ipv6-address-property-builder
  "Creates a  `CfnSpotFleet$InstanceIpv6AddressProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-spot-fleet-instance-ipv6-address-property-builder (new CfnSpotFleet$InstanceIpv6AddressProperty$Builder) id config))


(defn build-cfn-spot-fleet-instance-network-interface-specification-property-builder
  "The build-cfn-spot-fleet-instance-network-interface-specification-property-builder function updates a CfnSpotFleet$InstanceNetworkInterfaceSpecificationProperty$Builder instance using the provided configuration.
  The function takes the CfnSpotFleet$InstanceNetworkInterfaceSpecificationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `associatePublicIpAddress` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:associate-public-ip-address` |
| `deleteOnTermination` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:delete-on-termination` |
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `deviceIndex` | java.lang.Number | [[cdk.support/lookup-entry]] | `:device-index` |
| `groups` | java.util.List | [[cdk.support/lookup-entry]] | `:groups` |
| `ipv6AddressCount` | java.lang.Number | [[cdk.support/lookup-entry]] | `:ipv6-address-count` |
| `ipv6Addresses` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:ipv6-addresses` |
| `networkInterfaceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-interface-id` |
| `privateIpAddresses` | java.util.List | [[cdk.support/lookup-entry]] | `:private-ip-addresses` |
| `secondaryPrivateIpAddressCount` | java.lang.Number | [[cdk.support/lookup-entry]] | `:secondary-private-ip-address-count` |
| `subnetId` | java.lang.String | [[cdk.support/lookup-entry]] | `:subnet-id` |
"
  [^CfnSpotFleet$InstanceNetworkInterfaceSpecificationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :associate-public-ip-address)]
    (. builder associatePublicIpAddress data))
  (when-let [data (lookup-entry config id :delete-on-termination)]
    (. builder deleteOnTermination data))
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :device-index)]
    (. builder deviceIndex data))
  (when-let [data (lookup-entry config id :groups)]
    (. builder groups data))
  (when-let [data (lookup-entry config id :ipv6-address-count)]
    (. builder ipv6AddressCount data))
  (when-let [data (lookup-entry config id :ipv6-addresses)]
    (. builder ipv6Addresses data))
  (when-let [data (lookup-entry config id :network-interface-id)]
    (. builder networkInterfaceId data))
  (when-let [data (lookup-entry config id :private-ip-addresses)]
    (. builder privateIpAddresses data))
  (when-let [data (lookup-entry config id :secondary-private-ip-address-count)]
    (. builder secondaryPrivateIpAddressCount data))
  (when-let [data (lookup-entry config id :subnet-id)]
    (. builder subnetId data))
  (.build builder))


(defn cfn-spot-fleet-instance-network-interface-specification-property-builder
  "Creates a  `CfnSpotFleet$InstanceNetworkInterfaceSpecificationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-spot-fleet-instance-network-interface-specification-property-builder (new CfnSpotFleet$InstanceNetworkInterfaceSpecificationProperty$Builder) id config))


(defn build-cfn-spot-fleet-instance-requirements-request-property-builder
  "The build-cfn-spot-fleet-instance-requirements-request-property-builder function updates a CfnSpotFleet$InstanceRequirementsRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnSpotFleet$InstanceRequirementsRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `acceleratorCount` | software.amazon.awscdk.services.ec2.CfnSpotFleet$AcceleratorCountRequestProperty | [[cdk.support/lookup-entry]] | `:accelerator-count` |
| `acceleratorManufacturers` | java.util.List | [[cdk.support/lookup-entry]] | `:accelerator-manufacturers` |
| `acceleratorNames` | java.util.List | [[cdk.support/lookup-entry]] | `:accelerator-names` |
| `acceleratorTotalMemoryMiB` | software.amazon.awscdk.services.ec2.CfnSpotFleet$AcceleratorTotalMemoryMiBRequestProperty | [[cdk.support/lookup-entry]] | `:accelerator-total-memory-mi-b` |
| `acceleratorTypes` | java.util.List | [[cdk.support/lookup-entry]] | `:accelerator-types` |
| `allowedInstanceTypes` | java.util.List | [[cdk.support/lookup-entry]] | `:allowed-instance-types` |
| `bareMetal` | java.lang.String | [[cdk.support/lookup-entry]] | `:bare-metal` |
| `baselineEbsBandwidthMbps` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:baseline-ebs-bandwidth-mbps` |
| `burstablePerformance` | java.lang.String | [[cdk.support/lookup-entry]] | `:burstable-performance` |
| `cpuManufacturers` | java.util.List | [[cdk.support/lookup-entry]] | `:cpu-manufacturers` |
| `excludedInstanceTypes` | java.util.List | [[cdk.support/lookup-entry]] | `:excluded-instance-types` |
| `instanceGenerations` | java.util.List | [[cdk.support/lookup-entry]] | `:instance-generations` |
| `localStorage` | java.lang.String | [[cdk.support/lookup-entry]] | `:local-storage` |
| `localStorageTypes` | java.util.List | [[cdk.support/lookup-entry]] | `:local-storage-types` |
| `maxSpotPriceAsPercentageOfOptimalOnDemandPrice` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max-spot-price-as-percentage-of-optimal-on-demand-price` |
| `memoryGiBPerVCpu` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:memory-gi-b-per-v-cpu` |
| `memoryMiB` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:memory-mi-b` |
| `networkBandwidthGbps` | software.amazon.awscdk.services.ec2.CfnSpotFleet$NetworkBandwidthGbpsRequestProperty | [[cdk.support/lookup-entry]] | `:network-bandwidth-gbps` |
| `networkInterfaceCount` | software.amazon.awscdk.services.ec2.CfnSpotFleet$NetworkInterfaceCountRequestProperty | [[cdk.support/lookup-entry]] | `:network-interface-count` |
| `onDemandMaxPricePercentageOverLowestPrice` | java.lang.Number | [[cdk.support/lookup-entry]] | `:on-demand-max-price-percentage-over-lowest-price` |
| `requireHibernateSupport` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:require-hibernate-support` |
| `spotMaxPricePercentageOverLowestPrice` | java.lang.Number | [[cdk.support/lookup-entry]] | `:spot-max-price-percentage-over-lowest-price` |
| `totalLocalStorageGb` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:total-local-storage-gb` |
| `vCpuCount` | software.amazon.awscdk.services.ec2.CfnSpotFleet$VCpuCountRangeRequestProperty | [[cdk.support/lookup-entry]] | `:v-cpu-count` |
"
  [^CfnSpotFleet$InstanceRequirementsRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :accelerator-count)]
    (. builder acceleratorCount data))
  (when-let [data (lookup-entry config id :accelerator-manufacturers)]
    (. builder acceleratorManufacturers data))
  (when-let [data (lookup-entry config id :accelerator-names)]
    (. builder acceleratorNames data))
  (when-let [data (lookup-entry config id :accelerator-total-memory-mi-b)]
    (. builder acceleratorTotalMemoryMiB data))
  (when-let [data (lookup-entry config id :accelerator-types)]
    (. builder acceleratorTypes data))
  (when-let [data (lookup-entry config id :allowed-instance-types)]
    (. builder allowedInstanceTypes data))
  (when-let [data (lookup-entry config id :bare-metal)]
    (. builder bareMetal data))
  (when-let [data (lookup-entry config id :baseline-ebs-bandwidth-mbps)]
    (. builder baselineEbsBandwidthMbps data))
  (when-let [data (lookup-entry config id :burstable-performance)]
    (. builder burstablePerformance data))
  (when-let [data (lookup-entry config id :cpu-manufacturers)]
    (. builder cpuManufacturers data))
  (when-let [data (lookup-entry config id :excluded-instance-types)]
    (. builder excludedInstanceTypes data))
  (when-let [data (lookup-entry config id :instance-generations)]
    (. builder instanceGenerations data))
  (when-let [data (lookup-entry config id :local-storage)]
    (. builder localStorage data))
  (when-let [data (lookup-entry config id :local-storage-types)]
    (. builder localStorageTypes data))
  (when-let [data (lookup-entry config id :max-spot-price-as-percentage-of-optimal-on-demand-price)]
    (. builder maxSpotPriceAsPercentageOfOptimalOnDemandPrice data))
  (when-let [data (lookup-entry config id :memory-gi-b-per-v-cpu)]
    (. builder memoryGiBPerVCpu data))
  (when-let [data (lookup-entry config id :memory-mi-b)]
    (. builder memoryMiB data))
  (when-let [data (lookup-entry config id :network-bandwidth-gbps)]
    (. builder networkBandwidthGbps data))
  (when-let [data (lookup-entry config id :network-interface-count)]
    (. builder networkInterfaceCount data))
  (when-let [data (lookup-entry config id :on-demand-max-price-percentage-over-lowest-price)]
    (. builder onDemandMaxPricePercentageOverLowestPrice data))
  (when-let [data (lookup-entry config id :require-hibernate-support)]
    (. builder requireHibernateSupport data))
  (when-let [data (lookup-entry config id :spot-max-price-percentage-over-lowest-price)]
    (. builder spotMaxPricePercentageOverLowestPrice data))
  (when-let [data (lookup-entry config id :total-local-storage-gb)]
    (. builder totalLocalStorageGb data))
  (when-let [data (lookup-entry config id :v-cpu-count)]
    (. builder vCpuCount data))
  (.build builder))


(defn cfn-spot-fleet-instance-requirements-request-property-builder
  "Creates a  `CfnSpotFleet$InstanceRequirementsRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-spot-fleet-instance-requirements-request-property-builder (new CfnSpotFleet$InstanceRequirementsRequestProperty$Builder) id config))


(defn build-cfn-spot-fleet-launch-template-config-property-builder
  "The build-cfn-spot-fleet-launch-template-config-property-builder function updates a CfnSpotFleet$LaunchTemplateConfigProperty$Builder instance using the provided configuration.
  The function takes the CfnSpotFleet$LaunchTemplateConfigProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `launchTemplateSpecification` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:launch-template-specification` |
| `overrides` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:overrides` |
"
  [^CfnSpotFleet$LaunchTemplateConfigProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :launch-template-specification)]
    (. builder launchTemplateSpecification data))
  (when-let [data (lookup-entry config id :overrides)]
    (. builder overrides data))
  (.build builder))


(defn cfn-spot-fleet-launch-template-config-property-builder
  "Creates a  `CfnSpotFleet$LaunchTemplateConfigProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-spot-fleet-launch-template-config-property-builder (new CfnSpotFleet$LaunchTemplateConfigProperty$Builder) id config))


(defn build-cfn-spot-fleet-launch-template-overrides-property-builder
  "The build-cfn-spot-fleet-launch-template-overrides-property-builder function updates a CfnSpotFleet$LaunchTemplateOverridesProperty$Builder instance using the provided configuration.
  The function takes the CfnSpotFleet$LaunchTemplateOverridesProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `availabilityZone` | java.lang.String | [[cdk.support/lookup-entry]] | `:availability-zone` |
| `instanceRequirements` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:instance-requirements` |
| `instanceType` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-type` |
| `priority` | java.lang.Number | [[cdk.support/lookup-entry]] | `:priority` |
| `spotPrice` | java.lang.String | [[cdk.support/lookup-entry]] | `:spot-price` |
| `subnetId` | java.lang.String | [[cdk.support/lookup-entry]] | `:subnet-id` |
| `weightedCapacity` | java.lang.Number | [[cdk.support/lookup-entry]] | `:weighted-capacity` |
"
  [^CfnSpotFleet$LaunchTemplateOverridesProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :availability-zone)]
    (. builder availabilityZone data))
  (when-let [data (lookup-entry config id :instance-requirements)]
    (. builder instanceRequirements data))
  (when-let [data (lookup-entry config id :instance-type)]
    (. builder instanceType data))
  (when-let [data (lookup-entry config id :priority)]
    (. builder priority data))
  (when-let [data (lookup-entry config id :spot-price)]
    (. builder spotPrice data))
  (when-let [data (lookup-entry config id :subnet-id)]
    (. builder subnetId data))
  (when-let [data (lookup-entry config id :weighted-capacity)]
    (. builder weightedCapacity data))
  (.build builder))


(defn cfn-spot-fleet-launch-template-overrides-property-builder
  "Creates a  `CfnSpotFleet$LaunchTemplateOverridesProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-spot-fleet-launch-template-overrides-property-builder (new CfnSpotFleet$LaunchTemplateOverridesProperty$Builder) id config))


(defn build-cfn-spot-fleet-load-balancers-config-property-builder
  "The build-cfn-spot-fleet-load-balancers-config-property-builder function updates a CfnSpotFleet$LoadBalancersConfigProperty$Builder instance using the provided configuration.
  The function takes the CfnSpotFleet$LoadBalancersConfigProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `classicLoadBalancersConfig` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:classic-load-balancers-config` |
| `targetGroupsConfig` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:target-groups-config` |
"
  [^CfnSpotFleet$LoadBalancersConfigProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :classic-load-balancers-config)]
    (. builder classicLoadBalancersConfig data))
  (when-let [data (lookup-entry config id :target-groups-config)]
    (. builder targetGroupsConfig data))
  (.build builder))


(defn cfn-spot-fleet-load-balancers-config-property-builder
  "Creates a  `CfnSpotFleet$LoadBalancersConfigProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-spot-fleet-load-balancers-config-property-builder (new CfnSpotFleet$LoadBalancersConfigProperty$Builder) id config))


(defn build-cfn-spot-fleet-memory-gi-b-per-v-cpu-request-property-builder
  "The build-cfn-spot-fleet-memory-gi-b-per-v-cpu-request-property-builder function updates a CfnSpotFleet$MemoryGiBPerVCpuRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnSpotFleet$MemoryGiBPerVCpuRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `max` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max` |
| `min` | java.lang.Number | [[cdk.support/lookup-entry]] | `:min` |
"
  [^CfnSpotFleet$MemoryGiBPerVCpuRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :max)]
    (. builder max data))
  (when-let [data (lookup-entry config id :min)]
    (. builder min data))
  (.build builder))


(defn cfn-spot-fleet-memory-gi-b-per-v-cpu-request-property-builder
  "Creates a  `CfnSpotFleet$MemoryGiBPerVCpuRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-spot-fleet-memory-gi-b-per-v-cpu-request-property-builder (new CfnSpotFleet$MemoryGiBPerVCpuRequestProperty$Builder) id config))


(defn build-cfn-spot-fleet-memory-mi-b-request-property-builder
  "The build-cfn-spot-fleet-memory-mi-b-request-property-builder function updates a CfnSpotFleet$MemoryMiBRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnSpotFleet$MemoryMiBRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `max` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max` |
| `min` | java.lang.Number | [[cdk.support/lookup-entry]] | `:min` |
"
  [^CfnSpotFleet$MemoryMiBRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :max)]
    (. builder max data))
  (when-let [data (lookup-entry config id :min)]
    (. builder min data))
  (.build builder))


(defn cfn-spot-fleet-memory-mi-b-request-property-builder
  "Creates a  `CfnSpotFleet$MemoryMiBRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-spot-fleet-memory-mi-b-request-property-builder (new CfnSpotFleet$MemoryMiBRequestProperty$Builder) id config))


(defn build-cfn-spot-fleet-network-bandwidth-gbps-request-property-builder
  "The build-cfn-spot-fleet-network-bandwidth-gbps-request-property-builder function updates a CfnSpotFleet$NetworkBandwidthGbpsRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnSpotFleet$NetworkBandwidthGbpsRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `max` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max` |
| `min` | java.lang.Number | [[cdk.support/lookup-entry]] | `:min` |
"
  [^CfnSpotFleet$NetworkBandwidthGbpsRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :max)]
    (. builder max data))
  (when-let [data (lookup-entry config id :min)]
    (. builder min data))
  (.build builder))


(defn cfn-spot-fleet-network-bandwidth-gbps-request-property-builder
  "Creates a  `CfnSpotFleet$NetworkBandwidthGbpsRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-spot-fleet-network-bandwidth-gbps-request-property-builder (new CfnSpotFleet$NetworkBandwidthGbpsRequestProperty$Builder) id config))


(defn build-cfn-spot-fleet-network-interface-count-request-property-builder
  "The build-cfn-spot-fleet-network-interface-count-request-property-builder function updates a CfnSpotFleet$NetworkInterfaceCountRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnSpotFleet$NetworkInterfaceCountRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `max` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max` |
| `min` | java.lang.Number | [[cdk.support/lookup-entry]] | `:min` |
"
  [^CfnSpotFleet$NetworkInterfaceCountRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :max)]
    (. builder max data))
  (when-let [data (lookup-entry config id :min)]
    (. builder min data))
  (.build builder))


(defn cfn-spot-fleet-network-interface-count-request-property-builder
  "Creates a  `CfnSpotFleet$NetworkInterfaceCountRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-spot-fleet-network-interface-count-request-property-builder (new CfnSpotFleet$NetworkInterfaceCountRequestProperty$Builder) id config))


(defn build-cfn-spot-fleet-private-ip-address-specification-property-builder
  "The build-cfn-spot-fleet-private-ip-address-specification-property-builder function updates a CfnSpotFleet$PrivateIpAddressSpecificationProperty$Builder instance using the provided configuration.
  The function takes the CfnSpotFleet$PrivateIpAddressSpecificationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `primary` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:primary` |
| `privateIpAddress` | java.lang.String | [[cdk.support/lookup-entry]] | `:private-ip-address` |
"
  [^CfnSpotFleet$PrivateIpAddressSpecificationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :primary)]
    (. builder primary data))
  (when-let [data (lookup-entry config id :private-ip-address)]
    (. builder privateIpAddress data))
  (.build builder))


(defn cfn-spot-fleet-private-ip-address-specification-property-builder
  "Creates a  `CfnSpotFleet$PrivateIpAddressSpecificationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-spot-fleet-private-ip-address-specification-property-builder (new CfnSpotFleet$PrivateIpAddressSpecificationProperty$Builder) id config))


(defn build-cfn-spot-fleet-props-builder
  "The build-cfn-spot-fleet-props-builder function updates a CfnSpotFleetProps$Builder instance using the provided configuration.
  The function takes the CfnSpotFleetProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `spotFleetRequestConfigData` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:spot-fleet-request-config-data` |
"
  [^CfnSpotFleetProps$Builder builder id config]
  (when-let [data (lookup-entry config id :spot-fleet-request-config-data)]
    (. builder spotFleetRequestConfigData data))
  (.build builder))


(defn cfn-spot-fleet-props-builder
  "Creates a  `CfnSpotFleetProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-spot-fleet-props-builder (new CfnSpotFleetProps$Builder) id config))


(defn build-cfn-spot-fleet-spot-capacity-rebalance-property-builder
  "The build-cfn-spot-fleet-spot-capacity-rebalance-property-builder function updates a CfnSpotFleet$SpotCapacityRebalanceProperty$Builder instance using the provided configuration.
  The function takes the CfnSpotFleet$SpotCapacityRebalanceProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `replacementStrategy` | java.lang.String | [[cdk.support/lookup-entry]] | `:replacement-strategy` |
| `terminationDelay` | java.lang.Number | [[cdk.support/lookup-entry]] | `:termination-delay` |
"
  [^CfnSpotFleet$SpotCapacityRebalanceProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :replacement-strategy)]
    (. builder replacementStrategy data))
  (when-let [data (lookup-entry config id :termination-delay)]
    (. builder terminationDelay data))
  (.build builder))


(defn cfn-spot-fleet-spot-capacity-rebalance-property-builder
  "Creates a  `CfnSpotFleet$SpotCapacityRebalanceProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-spot-fleet-spot-capacity-rebalance-property-builder (new CfnSpotFleet$SpotCapacityRebalanceProperty$Builder) id config))


(defn build-cfn-spot-fleet-spot-fleet-launch-specification-property-builder
  "The build-cfn-spot-fleet-spot-fleet-launch-specification-property-builder function updates a CfnSpotFleet$SpotFleetLaunchSpecificationProperty$Builder instance using the provided configuration.
  The function takes the CfnSpotFleet$SpotFleetLaunchSpecificationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `blockDeviceMappings` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:block-device-mappings` |
| `ebsOptimized` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:ebs-optimized` |
| `iamInstanceProfile` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:iam-instance-profile` |
| `imageId` | java.lang.String | [[cdk.support/lookup-entry]] | `:image-id` |
| `instanceRequirements` | software.amazon.awscdk.services.ec2.CfnSpotFleet$InstanceRequirementsRequestProperty | [[cdk.support/lookup-entry]] | `:instance-requirements` |
| `instanceType` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-type` |
| `kernelId` | java.lang.String | [[cdk.support/lookup-entry]] | `:kernel-id` |
| `keyName` | java.lang.String | [[cdk.support/lookup-entry]] | `:key-name` |
| `monitoring` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:monitoring` |
| `networkInterfaces` | java.util.List | [[cdk.support/lookup-entry]] | `:network-interfaces` |
| `placement` | software.amazon.awscdk.services.ec2.CfnSpotFleet$SpotPlacementProperty | [[cdk.support/lookup-entry]] | `:placement` |
| `ramdiskId` | java.lang.String | [[cdk.support/lookup-entry]] | `:ramdisk-id` |
| `securityGroups` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:security-groups` |
| `spotPrice` | java.lang.String | [[cdk.support/lookup-entry]] | `:spot-price` |
| `subnetId` | java.lang.String | [[cdk.support/lookup-entry]] | `:subnet-id` |
| `tagSpecifications` | java.util.List | [[cdk.support/lookup-entry]] | `:tag-specifications` |
| `userData` | java.lang.String | [[cdk.support/lookup-entry]] | `:user-data` |
| `weightedCapacity` | java.lang.Number | [[cdk.support/lookup-entry]] | `:weighted-capacity` |
"
  [^CfnSpotFleet$SpotFleetLaunchSpecificationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :block-device-mappings)]
    (. builder blockDeviceMappings data))
  (when-let [data (lookup-entry config id :ebs-optimized)]
    (. builder ebsOptimized data))
  (when-let [data (lookup-entry config id :iam-instance-profile)]
    (. builder iamInstanceProfile data))
  (when-let [data (lookup-entry config id :image-id)]
    (. builder imageId data))
  (when-let [data (lookup-entry config id :instance-requirements)]
    (. builder instanceRequirements data))
  (when-let [data (lookup-entry config id :instance-type)]
    (. builder instanceType data))
  (when-let [data (lookup-entry config id :kernel-id)]
    (. builder kernelId data))
  (when-let [data (lookup-entry config id :key-name)]
    (. builder keyName data))
  (when-let [data (lookup-entry config id :monitoring)]
    (. builder monitoring data))
  (when-let [data (lookup-entry config id :network-interfaces)]
    (. builder networkInterfaces data))
  (when-let [data (lookup-entry config id :placement)]
    (. builder placement data))
  (when-let [data (lookup-entry config id :ramdisk-id)]
    (. builder ramdiskId data))
  (when-let [data (lookup-entry config id :security-groups)]
    (. builder securityGroups data))
  (when-let [data (lookup-entry config id :spot-price)]
    (. builder spotPrice data))
  (when-let [data (lookup-entry config id :subnet-id)]
    (. builder subnetId data))
  (when-let [data (lookup-entry config id :tag-specifications)]
    (. builder tagSpecifications data))
  (when-let [data (lookup-entry config id :user-data)]
    (. builder userData data))
  (when-let [data (lookup-entry config id :weighted-capacity)]
    (. builder weightedCapacity data))
  (.build builder))


(defn cfn-spot-fleet-spot-fleet-launch-specification-property-builder
  "Creates a  `CfnSpotFleet$SpotFleetLaunchSpecificationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-spot-fleet-spot-fleet-launch-specification-property-builder (new CfnSpotFleet$SpotFleetLaunchSpecificationProperty$Builder) id config))


(defn build-cfn-spot-fleet-spot-fleet-monitoring-property-builder
  "The build-cfn-spot-fleet-spot-fleet-monitoring-property-builder function updates a CfnSpotFleet$SpotFleetMonitoringProperty$Builder instance using the provided configuration.
  The function takes the CfnSpotFleet$SpotFleetMonitoringProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `enabled` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:enabled` |
"
  [^CfnSpotFleet$SpotFleetMonitoringProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :enabled)]
    (. builder enabled data))
  (.build builder))


(defn cfn-spot-fleet-spot-fleet-monitoring-property-builder
  "Creates a  `CfnSpotFleet$SpotFleetMonitoringProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-spot-fleet-spot-fleet-monitoring-property-builder (new CfnSpotFleet$SpotFleetMonitoringProperty$Builder) id config))


(defn build-cfn-spot-fleet-spot-fleet-request-config-data-property-builder
  "The build-cfn-spot-fleet-spot-fleet-request-config-data-property-builder function updates a CfnSpotFleet$SpotFleetRequestConfigDataProperty$Builder instance using the provided configuration.
  The function takes the CfnSpotFleet$SpotFleetRequestConfigDataProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `allocationStrategy` | java.lang.String | [[cdk.support/lookup-entry]] | `:allocation-strategy` |
| `context` | java.lang.String | [[cdk.support/lookup-entry]] | `:context` |
| `excessCapacityTerminationPolicy` | java.lang.String | [[cdk.support/lookup-entry]] | `:excess-capacity-termination-policy` |
| `iamFleetRole` | java.lang.String | [[cdk.support/lookup-entry]] | `:iam-fleet-role` |
| `instanceInterruptionBehavior` | java.lang.String | [[cdk.support/lookup-entry]] | `:instance-interruption-behavior` |
| `instancePoolsToUseCount` | java.lang.Number | [[cdk.support/lookup-entry]] | `:instance-pools-to-use-count` |
| `launchSpecifications` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:launch-specifications` |
| `launchTemplateConfigs` | java.util.List | [[cdk.support/lookup-entry]] | `:launch-template-configs` |
| `loadBalancersConfig` | software.amazon.awscdk.services.ec2.CfnSpotFleet$LoadBalancersConfigProperty | [[cdk.support/lookup-entry]] | `:load-balancers-config` |
| `onDemandAllocationStrategy` | java.lang.String | [[cdk.support/lookup-entry]] | `:on-demand-allocation-strategy` |
| `onDemandMaxTotalPrice` | java.lang.String | [[cdk.support/lookup-entry]] | `:on-demand-max-total-price` |
| `onDemandTargetCapacity` | java.lang.Number | [[cdk.support/lookup-entry]] | `:on-demand-target-capacity` |
| `replaceUnhealthyInstances` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:replace-unhealthy-instances` |
| `spotMaintenanceStrategies` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:spot-maintenance-strategies` |
| `spotMaxTotalPrice` | java.lang.String | [[cdk.support/lookup-entry]] | `:spot-max-total-price` |
| `spotPrice` | java.lang.String | [[cdk.support/lookup-entry]] | `:spot-price` |
| `tagSpecifications` | java.util.List | [[cdk.support/lookup-entry]] | `:tag-specifications` |
| `targetCapacity` | java.lang.Number | [[cdk.support/lookup-entry]] | `:target-capacity` |
| `targetCapacityUnitType` | java.lang.String | [[cdk.support/lookup-entry]] | `:target-capacity-unit-type` |
| `terminateInstancesWithExpiration` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:terminate-instances-with-expiration` |
| `type` | java.lang.String | [[cdk.support/lookup-entry]] | `:type` |
| `validFrom` | java.lang.String | [[cdk.support/lookup-entry]] | `:valid-from` |
| `validUntil` | java.lang.String | [[cdk.support/lookup-entry]] | `:valid-until` |
"
  [^CfnSpotFleet$SpotFleetRequestConfigDataProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :allocation-strategy)]
    (. builder allocationStrategy data))
  (when-let [data (lookup-entry config id :context)]
    (. builder context data))
  (when-let [data (lookup-entry config id :excess-capacity-termination-policy)]
    (. builder excessCapacityTerminationPolicy data))
  (when-let [data (lookup-entry config id :iam-fleet-role)]
    (. builder iamFleetRole data))
  (when-let [data (lookup-entry config id :instance-interruption-behavior)]
    (. builder instanceInterruptionBehavior data))
  (when-let [data (lookup-entry config id :instance-pools-to-use-count)]
    (. builder instancePoolsToUseCount data))
  (when-let [data (lookup-entry config id :launch-specifications)]
    (. builder launchSpecifications data))
  (when-let [data (lookup-entry config id :launch-template-configs)]
    (. builder launchTemplateConfigs data))
  (when-let [data (lookup-entry config id :load-balancers-config)]
    (. builder loadBalancersConfig data))
  (when-let [data (lookup-entry config id :on-demand-allocation-strategy)]
    (. builder onDemandAllocationStrategy data))
  (when-let [data (lookup-entry config id :on-demand-max-total-price)]
    (. builder onDemandMaxTotalPrice data))
  (when-let [data (lookup-entry config id :on-demand-target-capacity)]
    (. builder onDemandTargetCapacity data))
  (when-let [data (lookup-entry config id :replace-unhealthy-instances)]
    (. builder replaceUnhealthyInstances data))
  (when-let [data (lookup-entry config id :spot-maintenance-strategies)]
    (. builder spotMaintenanceStrategies data))
  (when-let [data (lookup-entry config id :spot-max-total-price)]
    (. builder spotMaxTotalPrice data))
  (when-let [data (lookup-entry config id :spot-price)]
    (. builder spotPrice data))
  (when-let [data (lookup-entry config id :tag-specifications)]
    (. builder tagSpecifications data))
  (when-let [data (lookup-entry config id :target-capacity)]
    (. builder targetCapacity data))
  (when-let [data (lookup-entry config id :target-capacity-unit-type)]
    (. builder targetCapacityUnitType data))
  (when-let [data (lookup-entry config id :terminate-instances-with-expiration)]
    (. builder terminateInstancesWithExpiration data))
  (when-let [data (lookup-entry config id :type)]
    (. builder type data))
  (when-let [data (lookup-entry config id :valid-from)]
    (. builder validFrom data))
  (when-let [data (lookup-entry config id :valid-until)]
    (. builder validUntil data))
  (.build builder))


(defn cfn-spot-fleet-spot-fleet-request-config-data-property-builder
  "Creates a  `CfnSpotFleet$SpotFleetRequestConfigDataProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-spot-fleet-spot-fleet-request-config-data-property-builder (new CfnSpotFleet$SpotFleetRequestConfigDataProperty$Builder) id config))


(defn build-cfn-spot-fleet-spot-fleet-tag-specification-property-builder
  "The build-cfn-spot-fleet-spot-fleet-tag-specification-property-builder function updates a CfnSpotFleet$SpotFleetTagSpecificationProperty$Builder instance using the provided configuration.
  The function takes the CfnSpotFleet$SpotFleetTagSpecificationProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `resourceType` | java.lang.String | [[cdk.support/lookup-entry]] | `:resource-type` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnSpotFleet$SpotFleetTagSpecificationProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :resource-type)]
    (. builder resourceType data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-spot-fleet-spot-fleet-tag-specification-property-builder
  "Creates a  `CfnSpotFleet$SpotFleetTagSpecificationProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-spot-fleet-spot-fleet-tag-specification-property-builder (new CfnSpotFleet$SpotFleetTagSpecificationProperty$Builder) id config))


(defn build-cfn-spot-fleet-spot-maintenance-strategies-property-builder
  "The build-cfn-spot-fleet-spot-maintenance-strategies-property-builder function updates a CfnSpotFleet$SpotMaintenanceStrategiesProperty$Builder instance using the provided configuration.
  The function takes the CfnSpotFleet$SpotMaintenanceStrategiesProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `capacityRebalance` | software.amazon.awscdk.services.ec2.CfnSpotFleet$SpotCapacityRebalanceProperty | [[cdk.support/lookup-entry]] | `:capacity-rebalance` |
"
  [^CfnSpotFleet$SpotMaintenanceStrategiesProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :capacity-rebalance)]
    (. builder capacityRebalance data))
  (.build builder))


(defn cfn-spot-fleet-spot-maintenance-strategies-property-builder
  "Creates a  `CfnSpotFleet$SpotMaintenanceStrategiesProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-spot-fleet-spot-maintenance-strategies-property-builder (new CfnSpotFleet$SpotMaintenanceStrategiesProperty$Builder) id config))


(defn build-cfn-spot-fleet-spot-placement-property-builder
  "The build-cfn-spot-fleet-spot-placement-property-builder function updates a CfnSpotFleet$SpotPlacementProperty$Builder instance using the provided configuration.
  The function takes the CfnSpotFleet$SpotPlacementProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `availabilityZone` | java.lang.String | [[cdk.support/lookup-entry]] | `:availability-zone` |
| `groupName` | java.lang.String | [[cdk.support/lookup-entry]] | `:group-name` |
| `tenancy` | java.lang.String | [[cdk.support/lookup-entry]] | `:tenancy` |
"
  [^CfnSpotFleet$SpotPlacementProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :availability-zone)]
    (. builder availabilityZone data))
  (when-let [data (lookup-entry config id :group-name)]
    (. builder groupName data))
  (when-let [data (lookup-entry config id :tenancy)]
    (. builder tenancy data))
  (.build builder))


(defn cfn-spot-fleet-spot-placement-property-builder
  "Creates a  `CfnSpotFleet$SpotPlacementProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-spot-fleet-spot-placement-property-builder (new CfnSpotFleet$SpotPlacementProperty$Builder) id config))


(defn build-cfn-spot-fleet-target-group-property-builder
  "The build-cfn-spot-fleet-target-group-property-builder function updates a CfnSpotFleet$TargetGroupProperty$Builder instance using the provided configuration.
  The function takes the CfnSpotFleet$TargetGroupProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `arn` | java.lang.String | [[cdk.support/lookup-entry]] | `:arn` |
"
  [^CfnSpotFleet$TargetGroupProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :arn)]
    (. builder arn data))
  (.build builder))


(defn cfn-spot-fleet-target-group-property-builder
  "Creates a  `CfnSpotFleet$TargetGroupProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-spot-fleet-target-group-property-builder (new CfnSpotFleet$TargetGroupProperty$Builder) id config))


(defn build-cfn-spot-fleet-target-groups-config-property-builder
  "The build-cfn-spot-fleet-target-groups-config-property-builder function updates a CfnSpotFleet$TargetGroupsConfigProperty$Builder instance using the provided configuration.
  The function takes the CfnSpotFleet$TargetGroupsConfigProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `targetGroups` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:target-groups` |
"
  [^CfnSpotFleet$TargetGroupsConfigProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :target-groups)]
    (. builder targetGroups data))
  (.build builder))


(defn cfn-spot-fleet-target-groups-config-property-builder
  "Creates a  `CfnSpotFleet$TargetGroupsConfigProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-spot-fleet-target-groups-config-property-builder (new CfnSpotFleet$TargetGroupsConfigProperty$Builder) id config))


(defn build-cfn-spot-fleet-total-local-storage-gb-request-property-builder
  "The build-cfn-spot-fleet-total-local-storage-gb-request-property-builder function updates a CfnSpotFleet$TotalLocalStorageGBRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnSpotFleet$TotalLocalStorageGBRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `max` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max` |
| `min` | java.lang.Number | [[cdk.support/lookup-entry]] | `:min` |
"
  [^CfnSpotFleet$TotalLocalStorageGBRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :max)]
    (. builder max data))
  (when-let [data (lookup-entry config id :min)]
    (. builder min data))
  (.build builder))


(defn cfn-spot-fleet-total-local-storage-gb-request-property-builder
  "Creates a  `CfnSpotFleet$TotalLocalStorageGBRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-spot-fleet-total-local-storage-gb-request-property-builder (new CfnSpotFleet$TotalLocalStorageGBRequestProperty$Builder) id config))


(defn build-cfn-spot-fleet-v-cpu-count-range-request-property-builder
  "The build-cfn-spot-fleet-v-cpu-count-range-request-property-builder function updates a CfnSpotFleet$VCpuCountRangeRequestProperty$Builder instance using the provided configuration.
  The function takes the CfnSpotFleet$VCpuCountRangeRequestProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `max` | java.lang.Number | [[cdk.support/lookup-entry]] | `:max` |
| `min` | java.lang.Number | [[cdk.support/lookup-entry]] | `:min` |
"
  [^CfnSpotFleet$VCpuCountRangeRequestProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :max)]
    (. builder max data))
  (when-let [data (lookup-entry config id :min)]
    (. builder min data))
  (.build builder))


(defn cfn-spot-fleet-v-cpu-count-range-request-property-builder
  "Creates a  `CfnSpotFleet$VCpuCountRangeRequestProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-spot-fleet-v-cpu-count-range-request-property-builder (new CfnSpotFleet$VCpuCountRangeRequestProperty$Builder) id config))


(defn build-cfn-subnet-builder
  "The build-cfn-subnet-builder function updates a CfnSubnet$Builder instance using the provided configuration.
  The function takes the CfnSubnet$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `assignIpv6AddressOnCreation` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:assign-ipv6-address-on-creation` |
| `availabilityZone` | java.lang.String | [[cdk.support/lookup-entry]] | `:availability-zone` |
| `availabilityZoneId` | java.lang.String | [[cdk.support/lookup-entry]] | `:availability-zone-id` |
| `cidrBlock` | java.lang.String | [[cdk.support/lookup-entry]] | `:cidr-block` |
| `enableDns64` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:enable-dns64` |
| `enableLniAtDeviceIndex` | java.lang.Number | [[cdk.support/lookup-entry]] | `:enable-lni-at-device-index` |
| `ipv4IpamPoolId` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipv4-ipam-pool-id` |
| `ipv4NetmaskLength` | java.lang.Number | [[cdk.support/lookup-entry]] | `:ipv4-netmask-length` |
| `ipv6CidrBlock` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipv6-cidr-block` |
| `ipv6CidrBlocks` | java.util.List | [[cdk.support/lookup-entry]] | `:ipv6-cidr-blocks` |
| `ipv6IpamPoolId` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipv6-ipam-pool-id` |
| `ipv6Native` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:ipv6-native` |
| `ipv6NetmaskLength` | java.lang.Number | [[cdk.support/lookup-entry]] | `:ipv6-netmask-length` |
| `mapPublicIpOnLaunch` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:map-public-ip-on-launch` |
| `outpostArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:outpost-arn` |
| `privateDnsNameOptionsOnLaunch` | java.lang.Object | [[cdk.support/lookup-entry]] | `:private-dns-name-options-on-launch` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `vpcId` | java.lang.String | [[cdk.support/lookup-entry]] | `:vpc-id` |
"
  [^CfnSubnet$Builder builder id config]
  (when-let [data (lookup-entry config id :assign-ipv6-address-on-creation)]
    (. builder assignIpv6AddressOnCreation data))
  (when-let [data (lookup-entry config id :availability-zone)]
    (. builder availabilityZone data))
  (when-let [data (lookup-entry config id :availability-zone-id)]
    (. builder availabilityZoneId data))
  (when-let [data (lookup-entry config id :cidr-block)]
    (. builder cidrBlock data))
  (when-let [data (lookup-entry config id :enable-dns64)]
    (. builder enableDns64 data))
  (when-let [data (lookup-entry config id :enable-lni-at-device-index)]
    (. builder enableLniAtDeviceIndex data))
  (when-let [data (lookup-entry config id :ipv4-ipam-pool-id)]
    (. builder ipv4IpamPoolId data))
  (when-let [data (lookup-entry config id :ipv4-netmask-length)]
    (. builder ipv4NetmaskLength data))
  (when-let [data (lookup-entry config id :ipv6-cidr-block)]
    (. builder ipv6CidrBlock data))
  (when-let [data (lookup-entry config id :ipv6-cidr-blocks)]
    (. builder ipv6CidrBlocks data))
  (when-let [data (lookup-entry config id :ipv6-ipam-pool-id)]
    (. builder ipv6IpamPoolId data))
  (when-let [data (lookup-entry config id :ipv6-native)]
    (. builder ipv6Native data))
  (when-let [data (lookup-entry config id :ipv6-netmask-length)]
    (. builder ipv6NetmaskLength data))
  (when-let [data (lookup-entry config id :map-public-ip-on-launch)]
    (. builder mapPublicIpOnLaunch data))
  (when-let [data (lookup-entry config id :outpost-arn)]
    (. builder outpostArn data))
  (when-let [data (lookup-entry config id :private-dns-name-options-on-launch)]
    (. builder privateDnsNameOptionsOnLaunch data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :vpc-id)]
    (. builder vpcId data))
  (.build builder))


(defn cfn-subnet-builder
  "Creates a  `CfnSubnet$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-subnet-builder (CfnSubnet$Builder/create scope (name id)) id config))


(defn build-cfn-subnet-cidr-block-builder
  "The build-cfn-subnet-cidr-block-builder function updates a CfnSubnetCidrBlock$Builder instance using the provided configuration.
  The function takes the CfnSubnetCidrBlock$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `ipv6CidrBlock` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipv6-cidr-block` |
| `ipv6IpamPoolId` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipv6-ipam-pool-id` |
| `ipv6NetmaskLength` | java.lang.Number | [[cdk.support/lookup-entry]] | `:ipv6-netmask-length` |
| `subnetId` | java.lang.String | [[cdk.support/lookup-entry]] | `:subnet-id` |
"
  [^CfnSubnetCidrBlock$Builder builder id config]
  (when-let [data (lookup-entry config id :ipv6-cidr-block)]
    (. builder ipv6CidrBlock data))
  (when-let [data (lookup-entry config id :ipv6-ipam-pool-id)]
    (. builder ipv6IpamPoolId data))
  (when-let [data (lookup-entry config id :ipv6-netmask-length)]
    (. builder ipv6NetmaskLength data))
  (when-let [data (lookup-entry config id :subnet-id)]
    (. builder subnetId data))
  (.build builder))


(defn cfn-subnet-cidr-block-builder
  "Creates a  `CfnSubnetCidrBlock$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-subnet-cidr-block-builder (CfnSubnetCidrBlock$Builder/create scope (name id)) id config))


(defn build-cfn-subnet-cidr-block-props-builder
  "The build-cfn-subnet-cidr-block-props-builder function updates a CfnSubnetCidrBlockProps$Builder instance using the provided configuration.
  The function takes the CfnSubnetCidrBlockProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `ipv6CidrBlock` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipv6-cidr-block` |
| `ipv6IpamPoolId` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipv6-ipam-pool-id` |
| `ipv6NetmaskLength` | java.lang.Number | [[cdk.support/lookup-entry]] | `:ipv6-netmask-length` |
| `subnetId` | java.lang.String | [[cdk.support/lookup-entry]] | `:subnet-id` |
"
  [^CfnSubnetCidrBlockProps$Builder builder id config]
  (when-let [data (lookup-entry config id :ipv6-cidr-block)]
    (. builder ipv6CidrBlock data))
  (when-let [data (lookup-entry config id :ipv6-ipam-pool-id)]
    (. builder ipv6IpamPoolId data))
  (when-let [data (lookup-entry config id :ipv6-netmask-length)]
    (. builder ipv6NetmaskLength data))
  (when-let [data (lookup-entry config id :subnet-id)]
    (. builder subnetId data))
  (.build builder))


(defn cfn-subnet-cidr-block-props-builder
  "Creates a  `CfnSubnetCidrBlockProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-subnet-cidr-block-props-builder (new CfnSubnetCidrBlockProps$Builder) id config))


(defn build-cfn-subnet-network-acl-association-builder
  "The build-cfn-subnet-network-acl-association-builder function updates a CfnSubnetNetworkAclAssociation$Builder instance using the provided configuration.
  The function takes the CfnSubnetNetworkAclAssociation$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `networkAclId` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-acl-id` |
| `subnetId` | java.lang.String | [[cdk.support/lookup-entry]] | `:subnet-id` |
"
  [^CfnSubnetNetworkAclAssociation$Builder builder id config]
  (when-let [data (lookup-entry config id :network-acl-id)]
    (. builder networkAclId data))
  (when-let [data (lookup-entry config id :subnet-id)]
    (. builder subnetId data))
  (.build builder))


(defn cfn-subnet-network-acl-association-builder
  "Creates a  `CfnSubnetNetworkAclAssociation$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-subnet-network-acl-association-builder (CfnSubnetNetworkAclAssociation$Builder/create scope (name id)) id config))


(defn build-cfn-subnet-network-acl-association-props-builder
  "The build-cfn-subnet-network-acl-association-props-builder function updates a CfnSubnetNetworkAclAssociationProps$Builder instance using the provided configuration.
  The function takes the CfnSubnetNetworkAclAssociationProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `networkAclId` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-acl-id` |
| `subnetId` | java.lang.String | [[cdk.support/lookup-entry]] | `:subnet-id` |
"
  [^CfnSubnetNetworkAclAssociationProps$Builder builder id config]
  (when-let [data (lookup-entry config id :network-acl-id)]
    (. builder networkAclId data))
  (when-let [data (lookup-entry config id :subnet-id)]
    (. builder subnetId data))
  (.build builder))


(defn cfn-subnet-network-acl-association-props-builder
  "Creates a  `CfnSubnetNetworkAclAssociationProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-subnet-network-acl-association-props-builder (new CfnSubnetNetworkAclAssociationProps$Builder) id config))


(defn build-cfn-subnet-private-dns-name-options-on-launch-property-builder
  "The build-cfn-subnet-private-dns-name-options-on-launch-property-builder function updates a CfnSubnet$PrivateDnsNameOptionsOnLaunchProperty$Builder instance using the provided configuration.
  The function takes the CfnSubnet$PrivateDnsNameOptionsOnLaunchProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `enableResourceNameDnsARecord` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:enable-resource-name-dns-a-record` |
| `enableResourceNameDnsAaaaRecord` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:enable-resource-name-dns-aaaa-record` |
| `hostnameType` | java.lang.String | [[cdk.support/lookup-entry]] | `:hostname-type` |
"
  [^CfnSubnet$PrivateDnsNameOptionsOnLaunchProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :enable-resource-name-dns-a-record)]
    (. builder enableResourceNameDnsARecord data))
  (when-let [data (lookup-entry config id :enable-resource-name-dns-aaaa-record)]
    (. builder enableResourceNameDnsAaaaRecord data))
  (when-let [data (lookup-entry config id :hostname-type)]
    (. builder hostnameType data))
  (.build builder))


(defn cfn-subnet-private-dns-name-options-on-launch-property-builder
  "Creates a  `CfnSubnet$PrivateDnsNameOptionsOnLaunchProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-subnet-private-dns-name-options-on-launch-property-builder (new CfnSubnet$PrivateDnsNameOptionsOnLaunchProperty$Builder) id config))


(defn build-cfn-subnet-props-builder
  "The build-cfn-subnet-props-builder function updates a CfnSubnetProps$Builder instance using the provided configuration.
  The function takes the CfnSubnetProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `assignIpv6AddressOnCreation` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:assign-ipv6-address-on-creation` |
| `availabilityZone` | java.lang.String | [[cdk.support/lookup-entry]] | `:availability-zone` |
| `availabilityZoneId` | java.lang.String | [[cdk.support/lookup-entry]] | `:availability-zone-id` |
| `cidrBlock` | java.lang.String | [[cdk.support/lookup-entry]] | `:cidr-block` |
| `enableDns64` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:enable-dns64` |
| `enableLniAtDeviceIndex` | java.lang.Number | [[cdk.support/lookup-entry]] | `:enable-lni-at-device-index` |
| `ipv4IpamPoolId` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipv4-ipam-pool-id` |
| `ipv4NetmaskLength` | java.lang.Number | [[cdk.support/lookup-entry]] | `:ipv4-netmask-length` |
| `ipv6CidrBlock` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipv6-cidr-block` |
| `ipv6CidrBlocks` | java.util.List | [[cdk.support/lookup-entry]] | `:ipv6-cidr-blocks` |
| `ipv6IpamPoolId` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipv6-ipam-pool-id` |
| `ipv6Native` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:ipv6-native` |
| `ipv6NetmaskLength` | java.lang.Number | [[cdk.support/lookup-entry]] | `:ipv6-netmask-length` |
| `mapPublicIpOnLaunch` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:map-public-ip-on-launch` |
| `outpostArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:outpost-arn` |
| `privateDnsNameOptionsOnLaunch` | java.lang.Object | [[cdk.support/lookup-entry]] | `:private-dns-name-options-on-launch` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `vpcId` | java.lang.String | [[cdk.support/lookup-entry]] | `:vpc-id` |
"
  [^CfnSubnetProps$Builder builder id config]
  (when-let [data (lookup-entry config id :assign-ipv6-address-on-creation)]
    (. builder assignIpv6AddressOnCreation data))
  (when-let [data (lookup-entry config id :availability-zone)]
    (. builder availabilityZone data))
  (when-let [data (lookup-entry config id :availability-zone-id)]
    (. builder availabilityZoneId data))
  (when-let [data (lookup-entry config id :cidr-block)]
    (. builder cidrBlock data))
  (when-let [data (lookup-entry config id :enable-dns64)]
    (. builder enableDns64 data))
  (when-let [data (lookup-entry config id :enable-lni-at-device-index)]
    (. builder enableLniAtDeviceIndex data))
  (when-let [data (lookup-entry config id :ipv4-ipam-pool-id)]
    (. builder ipv4IpamPoolId data))
  (when-let [data (lookup-entry config id :ipv4-netmask-length)]
    (. builder ipv4NetmaskLength data))
  (when-let [data (lookup-entry config id :ipv6-cidr-block)]
    (. builder ipv6CidrBlock data))
  (when-let [data (lookup-entry config id :ipv6-cidr-blocks)]
    (. builder ipv6CidrBlocks data))
  (when-let [data (lookup-entry config id :ipv6-ipam-pool-id)]
    (. builder ipv6IpamPoolId data))
  (when-let [data (lookup-entry config id :ipv6-native)]
    (. builder ipv6Native data))
  (when-let [data (lookup-entry config id :ipv6-netmask-length)]
    (. builder ipv6NetmaskLength data))
  (when-let [data (lookup-entry config id :map-public-ip-on-launch)]
    (. builder mapPublicIpOnLaunch data))
  (when-let [data (lookup-entry config id :outpost-arn)]
    (. builder outpostArn data))
  (when-let [data (lookup-entry config id :private-dns-name-options-on-launch)]
    (. builder privateDnsNameOptionsOnLaunch data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :vpc-id)]
    (. builder vpcId data))
  (.build builder))


(defn cfn-subnet-props-builder
  "Creates a  `CfnSubnetProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-subnet-props-builder (new CfnSubnetProps$Builder) id config))


(defn build-cfn-subnet-route-table-association-builder
  "The build-cfn-subnet-route-table-association-builder function updates a CfnSubnetRouteTableAssociation$Builder instance using the provided configuration.
  The function takes the CfnSubnetRouteTableAssociation$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `routeTableId` | java.lang.String | [[cdk.support/lookup-entry]] | `:route-table-id` |
| `subnetId` | java.lang.String | [[cdk.support/lookup-entry]] | `:subnet-id` |
"
  [^CfnSubnetRouteTableAssociation$Builder builder id config]
  (when-let [data (lookup-entry config id :route-table-id)]
    (. builder routeTableId data))
  (when-let [data (lookup-entry config id :subnet-id)]
    (. builder subnetId data))
  (.build builder))


(defn cfn-subnet-route-table-association-builder
  "Creates a  `CfnSubnetRouteTableAssociation$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-subnet-route-table-association-builder (CfnSubnetRouteTableAssociation$Builder/create scope (name id)) id config))


(defn build-cfn-subnet-route-table-association-props-builder
  "The build-cfn-subnet-route-table-association-props-builder function updates a CfnSubnetRouteTableAssociationProps$Builder instance using the provided configuration.
  The function takes the CfnSubnetRouteTableAssociationProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `routeTableId` | java.lang.String | [[cdk.support/lookup-entry]] | `:route-table-id` |
| `subnetId` | java.lang.String | [[cdk.support/lookup-entry]] | `:subnet-id` |
"
  [^CfnSubnetRouteTableAssociationProps$Builder builder id config]
  (when-let [data (lookup-entry config id :route-table-id)]
    (. builder routeTableId data))
  (when-let [data (lookup-entry config id :subnet-id)]
    (. builder subnetId data))
  (.build builder))


(defn cfn-subnet-route-table-association-props-builder
  "Creates a  `CfnSubnetRouteTableAssociationProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-subnet-route-table-association-props-builder (new CfnSubnetRouteTableAssociationProps$Builder) id config))


(defn build-cfn-traffic-mirror-filter-builder
  "The build-cfn-traffic-mirror-filter-builder function updates a CfnTrafficMirrorFilter$Builder instance using the provided configuration.
  The function takes the CfnTrafficMirrorFilter$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `networkServices` | java.util.List | [[cdk.support/lookup-entry]] | `:network-services` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnTrafficMirrorFilter$Builder builder id config]
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :network-services)]
    (. builder networkServices data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-traffic-mirror-filter-builder
  "Creates a  `CfnTrafficMirrorFilter$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-traffic-mirror-filter-builder (CfnTrafficMirrorFilter$Builder/create scope (name id)) id config))


(defn build-cfn-traffic-mirror-filter-props-builder
  "The build-cfn-traffic-mirror-filter-props-builder function updates a CfnTrafficMirrorFilterProps$Builder instance using the provided configuration.
  The function takes the CfnTrafficMirrorFilterProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `networkServices` | java.util.List | [[cdk.support/lookup-entry]] | `:network-services` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnTrafficMirrorFilterProps$Builder builder id config]
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :network-services)]
    (. builder networkServices data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-traffic-mirror-filter-props-builder
  "Creates a  `CfnTrafficMirrorFilterProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-traffic-mirror-filter-props-builder (new CfnTrafficMirrorFilterProps$Builder) id config))


(defn build-cfn-traffic-mirror-filter-rule-builder
  "The build-cfn-traffic-mirror-filter-rule-builder function updates a CfnTrafficMirrorFilterRule$Builder instance using the provided configuration.
  The function takes the CfnTrafficMirrorFilterRule$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `destinationCidrBlock` | java.lang.String | [[cdk.support/lookup-entry]] | `:destination-cidr-block` |
| `destinationPortRange` | software.amazon.awscdk.services.ec2.CfnTrafficMirrorFilterRule$TrafficMirrorPortRangeProperty | [[cdk.support/lookup-entry]] | `:destination-port-range` |
| `protocol` | java.lang.Number | [[cdk.support/lookup-entry]] | `:protocol` |
| `ruleAction` | java.lang.String | [[cdk.support/lookup-entry]] | `:rule-action` |
| `ruleNumber` | java.lang.Number | [[cdk.support/lookup-entry]] | `:rule-number` |
| `sourceCidrBlock` | java.lang.String | [[cdk.support/lookup-entry]] | `:source-cidr-block` |
| `sourcePortRange` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:source-port-range` |
| `trafficDirection` | java.lang.String | [[cdk.support/lookup-entry]] | `:traffic-direction` |
| `trafficMirrorFilterId` | java.lang.String | [[cdk.support/lookup-entry]] | `:traffic-mirror-filter-id` |
"
  [^CfnTrafficMirrorFilterRule$Builder builder id config]
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :destination-cidr-block)]
    (. builder destinationCidrBlock data))
  (when-let [data (lookup-entry config id :destination-port-range)]
    (. builder destinationPortRange data))
  (when-let [data (lookup-entry config id :protocol)]
    (. builder protocol data))
  (when-let [data (lookup-entry config id :rule-action)]
    (. builder ruleAction data))
  (when-let [data (lookup-entry config id :rule-number)]
    (. builder ruleNumber data))
  (when-let [data (lookup-entry config id :source-cidr-block)]
    (. builder sourceCidrBlock data))
  (when-let [data (lookup-entry config id :source-port-range)]
    (. builder sourcePortRange data))
  (when-let [data (lookup-entry config id :traffic-direction)]
    (. builder trafficDirection data))
  (when-let [data (lookup-entry config id :traffic-mirror-filter-id)]
    (. builder trafficMirrorFilterId data))
  (.build builder))


(defn cfn-traffic-mirror-filter-rule-builder
  "Creates a  `CfnTrafficMirrorFilterRule$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-traffic-mirror-filter-rule-builder (CfnTrafficMirrorFilterRule$Builder/create scope (name id)) id config))


(defn build-cfn-traffic-mirror-filter-rule-props-builder
  "The build-cfn-traffic-mirror-filter-rule-props-builder function updates a CfnTrafficMirrorFilterRuleProps$Builder instance using the provided configuration.
  The function takes the CfnTrafficMirrorFilterRuleProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `destinationCidrBlock` | java.lang.String | [[cdk.support/lookup-entry]] | `:destination-cidr-block` |
| `destinationPortRange` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:destination-port-range` |
| `protocol` | java.lang.Number | [[cdk.support/lookup-entry]] | `:protocol` |
| `ruleAction` | java.lang.String | [[cdk.support/lookup-entry]] | `:rule-action` |
| `ruleNumber` | java.lang.Number | [[cdk.support/lookup-entry]] | `:rule-number` |
| `sourceCidrBlock` | java.lang.String | [[cdk.support/lookup-entry]] | `:source-cidr-block` |
| `sourcePortRange` | software.amazon.awscdk.services.ec2.CfnTrafficMirrorFilterRule$TrafficMirrorPortRangeProperty | [[cdk.support/lookup-entry]] | `:source-port-range` |
| `trafficDirection` | java.lang.String | [[cdk.support/lookup-entry]] | `:traffic-direction` |
| `trafficMirrorFilterId` | java.lang.String | [[cdk.support/lookup-entry]] | `:traffic-mirror-filter-id` |
"
  [^CfnTrafficMirrorFilterRuleProps$Builder builder id config]
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :destination-cidr-block)]
    (. builder destinationCidrBlock data))
  (when-let [data (lookup-entry config id :destination-port-range)]
    (. builder destinationPortRange data))
  (when-let [data (lookup-entry config id :protocol)]
    (. builder protocol data))
  (when-let [data (lookup-entry config id :rule-action)]
    (. builder ruleAction data))
  (when-let [data (lookup-entry config id :rule-number)]
    (. builder ruleNumber data))
  (when-let [data (lookup-entry config id :source-cidr-block)]
    (. builder sourceCidrBlock data))
  (when-let [data (lookup-entry config id :source-port-range)]
    (. builder sourcePortRange data))
  (when-let [data (lookup-entry config id :traffic-direction)]
    (. builder trafficDirection data))
  (when-let [data (lookup-entry config id :traffic-mirror-filter-id)]
    (. builder trafficMirrorFilterId data))
  (.build builder))


(defn cfn-traffic-mirror-filter-rule-props-builder
  "Creates a  `CfnTrafficMirrorFilterRuleProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-traffic-mirror-filter-rule-props-builder (new CfnTrafficMirrorFilterRuleProps$Builder) id config))


(defn build-cfn-traffic-mirror-filter-rule-traffic-mirror-port-range-property-builder
  "The build-cfn-traffic-mirror-filter-rule-traffic-mirror-port-range-property-builder function updates a CfnTrafficMirrorFilterRule$TrafficMirrorPortRangeProperty$Builder instance using the provided configuration.
  The function takes the CfnTrafficMirrorFilterRule$TrafficMirrorPortRangeProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `fromPort` | java.lang.Number | [[cdk.support/lookup-entry]] | `:from-port` |
| `toPort` | java.lang.Number | [[cdk.support/lookup-entry]] | `:to-port` |
"
  [^CfnTrafficMirrorFilterRule$TrafficMirrorPortRangeProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :from-port)]
    (. builder fromPort data))
  (when-let [data (lookup-entry config id :to-port)]
    (. builder toPort data))
  (.build builder))


(defn cfn-traffic-mirror-filter-rule-traffic-mirror-port-range-property-builder
  "Creates a  `CfnTrafficMirrorFilterRule$TrafficMirrorPortRangeProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-traffic-mirror-filter-rule-traffic-mirror-port-range-property-builder (new CfnTrafficMirrorFilterRule$TrafficMirrorPortRangeProperty$Builder) id config))


(defn build-cfn-traffic-mirror-session-builder
  "The build-cfn-traffic-mirror-session-builder function updates a CfnTrafficMirrorSession$Builder instance using the provided configuration.
  The function takes the CfnTrafficMirrorSession$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `networkInterfaceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-interface-id` |
| `packetLength` | java.lang.Number | [[cdk.support/lookup-entry]] | `:packet-length` |
| `sessionNumber` | java.lang.Number | [[cdk.support/lookup-entry]] | `:session-number` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `trafficMirrorFilterId` | java.lang.String | [[cdk.support/lookup-entry]] | `:traffic-mirror-filter-id` |
| `trafficMirrorTargetId` | java.lang.String | [[cdk.support/lookup-entry]] | `:traffic-mirror-target-id` |
| `virtualNetworkId` | java.lang.Number | [[cdk.support/lookup-entry]] | `:virtual-network-id` |
"
  [^CfnTrafficMirrorSession$Builder builder id config]
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :network-interface-id)]
    (. builder networkInterfaceId data))
  (when-let [data (lookup-entry config id :packet-length)]
    (. builder packetLength data))
  (when-let [data (lookup-entry config id :session-number)]
    (. builder sessionNumber data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :traffic-mirror-filter-id)]
    (. builder trafficMirrorFilterId data))
  (when-let [data (lookup-entry config id :traffic-mirror-target-id)]
    (. builder trafficMirrorTargetId data))
  (when-let [data (lookup-entry config id :virtual-network-id)]
    (. builder virtualNetworkId data))
  (.build builder))


(defn cfn-traffic-mirror-session-builder
  "Creates a  `CfnTrafficMirrorSession$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-traffic-mirror-session-builder (CfnTrafficMirrorSession$Builder/create scope (name id)) id config))


(defn build-cfn-traffic-mirror-session-props-builder
  "The build-cfn-traffic-mirror-session-props-builder function updates a CfnTrafficMirrorSessionProps$Builder instance using the provided configuration.
  The function takes the CfnTrafficMirrorSessionProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `networkInterfaceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-interface-id` |
| `packetLength` | java.lang.Number | [[cdk.support/lookup-entry]] | `:packet-length` |
| `sessionNumber` | java.lang.Number | [[cdk.support/lookup-entry]] | `:session-number` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `trafficMirrorFilterId` | java.lang.String | [[cdk.support/lookup-entry]] | `:traffic-mirror-filter-id` |
| `trafficMirrorTargetId` | java.lang.String | [[cdk.support/lookup-entry]] | `:traffic-mirror-target-id` |
| `virtualNetworkId` | java.lang.Number | [[cdk.support/lookup-entry]] | `:virtual-network-id` |
"
  [^CfnTrafficMirrorSessionProps$Builder builder id config]
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :network-interface-id)]
    (. builder networkInterfaceId data))
  (when-let [data (lookup-entry config id :packet-length)]
    (. builder packetLength data))
  (when-let [data (lookup-entry config id :session-number)]
    (. builder sessionNumber data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :traffic-mirror-filter-id)]
    (. builder trafficMirrorFilterId data))
  (when-let [data (lookup-entry config id :traffic-mirror-target-id)]
    (. builder trafficMirrorTargetId data))
  (when-let [data (lookup-entry config id :virtual-network-id)]
    (. builder virtualNetworkId data))
  (.build builder))


(defn cfn-traffic-mirror-session-props-builder
  "Creates a  `CfnTrafficMirrorSessionProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-traffic-mirror-session-props-builder (new CfnTrafficMirrorSessionProps$Builder) id config))


(defn build-cfn-traffic-mirror-target-builder
  "The build-cfn-traffic-mirror-target-builder function updates a CfnTrafficMirrorTarget$Builder instance using the provided configuration.
  The function takes the CfnTrafficMirrorTarget$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `gatewayLoadBalancerEndpointId` | java.lang.String | [[cdk.support/lookup-entry]] | `:gateway-load-balancer-endpoint-id` |
| `networkInterfaceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-interface-id` |
| `networkLoadBalancerArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-load-balancer-arn` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnTrafficMirrorTarget$Builder builder id config]
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :gateway-load-balancer-endpoint-id)]
    (. builder gatewayLoadBalancerEndpointId data))
  (when-let [data (lookup-entry config id :network-interface-id)]
    (. builder networkInterfaceId data))
  (when-let [data (lookup-entry config id :network-load-balancer-arn)]
    (. builder networkLoadBalancerArn data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-traffic-mirror-target-builder
  "Creates a  `CfnTrafficMirrorTarget$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-traffic-mirror-target-builder (CfnTrafficMirrorTarget$Builder/create scope (name id)) id config))


(defn build-cfn-traffic-mirror-target-props-builder
  "The build-cfn-traffic-mirror-target-props-builder function updates a CfnTrafficMirrorTargetProps$Builder instance using the provided configuration.
  The function takes the CfnTrafficMirrorTargetProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `gatewayLoadBalancerEndpointId` | java.lang.String | [[cdk.support/lookup-entry]] | `:gateway-load-balancer-endpoint-id` |
| `networkInterfaceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-interface-id` |
| `networkLoadBalancerArn` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-load-balancer-arn` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
"
  [^CfnTrafficMirrorTargetProps$Builder builder id config]
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :gateway-load-balancer-endpoint-id)]
    (. builder gatewayLoadBalancerEndpointId data))
  (when-let [data (lookup-entry config id :network-interface-id)]
    (. builder networkInterfaceId data))
  (when-let [data (lookup-entry config id :network-load-balancer-arn)]
    (. builder networkLoadBalancerArn data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (.build builder))


(defn cfn-traffic-mirror-target-props-builder
  "Creates a  `CfnTrafficMirrorTargetProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-traffic-mirror-target-props-builder (new CfnTrafficMirrorTargetProps$Builder) id config))


(defn build-cfn-transit-gateway-attachment-builder
  "The build-cfn-transit-gateway-attachment-builder function updates a CfnTransitGatewayAttachment$Builder instance using the provided configuration.
  The function takes the CfnTransitGatewayAttachment$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `options` | java.lang.Object | [[cdk.support/lookup-entry]] | `:options` |
| `subnetIds` | java.util.List | [[cdk.support/lookup-entry]] | `:subnet-ids` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `transitGatewayId` | java.lang.String | [[cdk.support/lookup-entry]] | `:transit-gateway-id` |
| `vpcId` | java.lang.String | [[cdk.support/lookup-entry]] | `:vpc-id` |
"
  [^CfnTransitGatewayAttachment$Builder builder id config]
  (when-let [data (lookup-entry config id :options)]
    (. builder options data))
  (when-let [data (lookup-entry config id :subnet-ids)]
    (. builder subnetIds data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :transit-gateway-id)]
    (. builder transitGatewayId data))
  (when-let [data (lookup-entry config id :vpc-id)]
    (. builder vpcId data))
  (.build builder))


(defn cfn-transit-gateway-attachment-builder
  "Creates a  `CfnTransitGatewayAttachment$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-transit-gateway-attachment-builder (CfnTransitGatewayAttachment$Builder/create scope (name id)) id config))


(defn build-cfn-transit-gateway-attachment-options-property-builder
  "The build-cfn-transit-gateway-attachment-options-property-builder function updates a CfnTransitGatewayAttachment$OptionsProperty$Builder instance using the provided configuration.
  The function takes the CfnTransitGatewayAttachment$OptionsProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `applianceModeSupport` | java.lang.String | [[cdk.support/lookup-entry]] | `:appliance-mode-support` |
| `dnsSupport` | java.lang.String | [[cdk.support/lookup-entry]] | `:dns-support` |
| `ipv6Support` | java.lang.String | [[cdk.support/lookup-entry]] | `:ipv6-support` |
| `securityGroupReferencingSupport` | java.lang.String | [[cdk.support/lookup-entry]] | `:security-group-referencing-support` |
"
  [^CfnTransitGatewayAttachment$OptionsProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :appliance-mode-support)]
    (. builder applianceModeSupport data))
  (when-let [data (lookup-entry config id :dns-support)]
    (. builder dnsSupport data))
  (when-let [data (lookup-entry config id :ipv6-support)]
    (. builder ipv6Support data))
  (when-let [data (lookup-entry config id :security-group-referencing-support)]
    (. builder securityGroupReferencingSupport data))
  (.build builder))


(defn cfn-transit-gateway-attachment-options-property-builder
  "Creates a  `CfnTransitGatewayAttachment$OptionsProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-transit-gateway-attachment-options-property-builder (new CfnTransitGatewayAttachment$OptionsProperty$Builder) id config))


(defn build-cfn-transit-gateway-attachment-props-builder
  "The build-cfn-transit-gateway-attachment-props-builder function updates a CfnTransitGatewayAttachmentProps$Builder instance using the provided configuration.
  The function takes the CfnTransitGatewayAttachmentProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `options` | java.lang.Object | [[cdk.support/lookup-entry]] | `:options` |
| `subnetIds` | java.util.List | [[cdk.support/lookup-entry]] | `:subnet-ids` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `transitGatewayId` | java.lang.String | [[cdk.support/lookup-entry]] | `:transit-gateway-id` |
| `vpcId` | java.lang.String | [[cdk.support/lookup-entry]] | `:vpc-id` |
"
  [^CfnTransitGatewayAttachmentProps$Builder builder id config]
  (when-let [data (lookup-entry config id :options)]
    (. builder options data))
  (when-let [data (lookup-entry config id :subnet-ids)]
    (. builder subnetIds data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :transit-gateway-id)]
    (. builder transitGatewayId data))
  (when-let [data (lookup-entry config id :vpc-id)]
    (. builder vpcId data))
  (.build builder))


(defn cfn-transit-gateway-attachment-props-builder
  "Creates a  `CfnTransitGatewayAttachmentProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-transit-gateway-attachment-props-builder (new CfnTransitGatewayAttachmentProps$Builder) id config))


(defn build-cfn-transit-gateway-builder
  "The build-cfn-transit-gateway-builder function updates a CfnTransitGateway$Builder instance using the provided configuration.
  The function takes the CfnTransitGateway$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `amazonSideAsn` | java.lang.Number | [[cdk.support/lookup-entry]] | `:amazon-side-asn` |
| `associationDefaultRouteTableId` | java.lang.String | [[cdk.support/lookup-entry]] | `:association-default-route-table-id` |
| `autoAcceptSharedAttachments` | java.lang.String | [[cdk.support/lookup-entry]] | `:auto-accept-shared-attachments` |
| `defaultRouteTableAssociation` | java.lang.String | [[cdk.support/lookup-entry]] | `:default-route-table-association` |
| `defaultRouteTablePropagation` | java.lang.String | [[cdk.support/lookup-entry]] | `:default-route-table-propagation` |
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `dnsSupport` | java.lang.String | [[cdk.support/lookup-entry]] | `:dns-support` |
| `multicastSupport` | java.lang.String | [[cdk.support/lookup-entry]] | `:multicast-support` |
| `propagationDefaultRouteTableId` | java.lang.String | [[cdk.support/lookup-entry]] | `:propagation-default-route-table-id` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `transitGatewayCidrBlocks` | java.util.List | [[cdk.support/lookup-entry]] | `:transit-gateway-cidr-blocks` |
| `vpnEcmpSupport` | java.lang.String | [[cdk.support/lookup-entry]] | `:vpn-ecmp-support` |
"
  [^CfnTransitGateway$Builder builder id config]
  (when-let [data (lookup-entry config id :amazon-side-asn)]
    (. builder amazonSideAsn data))
  (when-let [data (lookup-entry config id :association-default-route-table-id)]
    (. builder associationDefaultRouteTableId data))
  (when-let [data (lookup-entry config id :auto-accept-shared-attachments)]
    (. builder autoAcceptSharedAttachments data))
  (when-let [data (lookup-entry config id :default-route-table-association)]
    (. builder defaultRouteTableAssociation data))
  (when-let [data (lookup-entry config id :default-route-table-propagation)]
    (. builder defaultRouteTablePropagation data))
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :dns-support)]
    (. builder dnsSupport data))
  (when-let [data (lookup-entry config id :multicast-support)]
    (. builder multicastSupport data))
  (when-let [data (lookup-entry config id :propagation-default-route-table-id)]
    (. builder propagationDefaultRouteTableId data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :transit-gateway-cidr-blocks)]
    (. builder transitGatewayCidrBlocks data))
  (when-let [data (lookup-entry config id :vpn-ecmp-support)]
    (. builder vpnEcmpSupport data))
  (.build builder))


(defn cfn-transit-gateway-builder
  "Creates a  `CfnTransitGateway$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-transit-gateway-builder (CfnTransitGateway$Builder/create scope (name id)) id config))


(defn build-cfn-transit-gateway-connect-builder
  "The build-cfn-transit-gateway-connect-builder function updates a CfnTransitGatewayConnect$Builder instance using the provided configuration.
  The function takes the CfnTransitGatewayConnect$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `options` | software.amazon.awscdk.services.ec2.CfnTransitGatewayConnect$TransitGatewayConnectOptionsProperty | [[cdk.support/lookup-entry]] | `:options` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `transportTransitGatewayAttachmentId` | java.lang.String | [[cdk.support/lookup-entry]] | `:transport-transit-gateway-attachment-id` |
"
  [^CfnTransitGatewayConnect$Builder builder id config]
  (when-let [data (lookup-entry config id :options)]
    (. builder options data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :transport-transit-gateway-attachment-id)]
    (. builder transportTransitGatewayAttachmentId data))
  (.build builder))


(defn cfn-transit-gateway-connect-builder
  "Creates a  `CfnTransitGatewayConnect$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-transit-gateway-connect-builder (CfnTransitGatewayConnect$Builder/create scope (name id)) id config))


(defn build-cfn-transit-gateway-connect-props-builder
  "The build-cfn-transit-gateway-connect-props-builder function updates a CfnTransitGatewayConnectProps$Builder instance using the provided configuration.
  The function takes the CfnTransitGatewayConnectProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `options` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:options` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `transportTransitGatewayAttachmentId` | java.lang.String | [[cdk.support/lookup-entry]] | `:transport-transit-gateway-attachment-id` |
"
  [^CfnTransitGatewayConnectProps$Builder builder id config]
  (when-let [data (lookup-entry config id :options)]
    (. builder options data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :transport-transit-gateway-attachment-id)]
    (. builder transportTransitGatewayAttachmentId data))
  (.build builder))


(defn cfn-transit-gateway-connect-props-builder
  "Creates a  `CfnTransitGatewayConnectProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-transit-gateway-connect-props-builder (new CfnTransitGatewayConnectProps$Builder) id config))


(defn build-cfn-transit-gateway-connect-transit-gateway-connect-options-property-builder
  "The build-cfn-transit-gateway-connect-transit-gateway-connect-options-property-builder function updates a CfnTransitGatewayConnect$TransitGatewayConnectOptionsProperty$Builder instance using the provided configuration.
  The function takes the CfnTransitGatewayConnect$TransitGatewayConnectOptionsProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `protocol` | java.lang.String | [[cdk.support/lookup-entry]] | `:protocol` |
"
  [^CfnTransitGatewayConnect$TransitGatewayConnectOptionsProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :protocol)]
    (. builder protocol data))
  (.build builder))


(defn cfn-transit-gateway-connect-transit-gateway-connect-options-property-builder
  "Creates a  `CfnTransitGatewayConnect$TransitGatewayConnectOptionsProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-transit-gateway-connect-transit-gateway-connect-options-property-builder (new CfnTransitGatewayConnect$TransitGatewayConnectOptionsProperty$Builder) id config))


(defn build-cfn-transit-gateway-multicast-domain-association-builder
  "The build-cfn-transit-gateway-multicast-domain-association-builder function updates a CfnTransitGatewayMulticastDomainAssociation$Builder instance using the provided configuration.
  The function takes the CfnTransitGatewayMulticastDomainAssociation$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `subnetId` | java.lang.String | [[cdk.support/lookup-entry]] | `:subnet-id` |
| `transitGatewayAttachmentId` | java.lang.String | [[cdk.support/lookup-entry]] | `:transit-gateway-attachment-id` |
| `transitGatewayMulticastDomainId` | java.lang.String | [[cdk.support/lookup-entry]] | `:transit-gateway-multicast-domain-id` |
"
  [^CfnTransitGatewayMulticastDomainAssociation$Builder builder id config]
  (when-let [data (lookup-entry config id :subnet-id)]
    (. builder subnetId data))
  (when-let [data (lookup-entry config id :transit-gateway-attachment-id)]
    (. builder transitGatewayAttachmentId data))
  (when-let [data (lookup-entry config id :transit-gateway-multicast-domain-id)]
    (. builder transitGatewayMulticastDomainId data))
  (.build builder))


(defn cfn-transit-gateway-multicast-domain-association-builder
  "Creates a  `CfnTransitGatewayMulticastDomainAssociation$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-transit-gateway-multicast-domain-association-builder (CfnTransitGatewayMulticastDomainAssociation$Builder/create scope (name id)) id config))


(defn build-cfn-transit-gateway-multicast-domain-association-props-builder
  "The build-cfn-transit-gateway-multicast-domain-association-props-builder function updates a CfnTransitGatewayMulticastDomainAssociationProps$Builder instance using the provided configuration.
  The function takes the CfnTransitGatewayMulticastDomainAssociationProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `subnetId` | java.lang.String | [[cdk.support/lookup-entry]] | `:subnet-id` |
| `transitGatewayAttachmentId` | java.lang.String | [[cdk.support/lookup-entry]] | `:transit-gateway-attachment-id` |
| `transitGatewayMulticastDomainId` | java.lang.String | [[cdk.support/lookup-entry]] | `:transit-gateway-multicast-domain-id` |
"
  [^CfnTransitGatewayMulticastDomainAssociationProps$Builder builder id config]
  (when-let [data (lookup-entry config id :subnet-id)]
    (. builder subnetId data))
  (when-let [data (lookup-entry config id :transit-gateway-attachment-id)]
    (. builder transitGatewayAttachmentId data))
  (when-let [data (lookup-entry config id :transit-gateway-multicast-domain-id)]
    (. builder transitGatewayMulticastDomainId data))
  (.build builder))


(defn cfn-transit-gateway-multicast-domain-association-props-builder
  "Creates a  `CfnTransitGatewayMulticastDomainAssociationProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-transit-gateway-multicast-domain-association-props-builder (new CfnTransitGatewayMulticastDomainAssociationProps$Builder) id config))


(defn build-cfn-transit-gateway-multicast-domain-builder
  "The build-cfn-transit-gateway-multicast-domain-builder function updates a CfnTransitGatewayMulticastDomain$Builder instance using the provided configuration.
  The function takes the CfnTransitGatewayMulticastDomain$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `options` | java.lang.Object | [[cdk.support/lookup-entry]] | `:options` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `transitGatewayId` | java.lang.String | [[cdk.support/lookup-entry]] | `:transit-gateway-id` |
"
  [^CfnTransitGatewayMulticastDomain$Builder builder id config]
  (when-let [data (lookup-entry config id :options)]
    (. builder options data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :transit-gateway-id)]
    (. builder transitGatewayId data))
  (.build builder))


(defn cfn-transit-gateway-multicast-domain-builder
  "Creates a  `CfnTransitGatewayMulticastDomain$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-transit-gateway-multicast-domain-builder (CfnTransitGatewayMulticastDomain$Builder/create scope (name id)) id config))


(defn build-cfn-transit-gateway-multicast-domain-options-property-builder
  "The build-cfn-transit-gateway-multicast-domain-options-property-builder function updates a CfnTransitGatewayMulticastDomain$OptionsProperty$Builder instance using the provided configuration.
  The function takes the CfnTransitGatewayMulticastDomain$OptionsProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `autoAcceptSharedAssociations` | java.lang.String | [[cdk.support/lookup-entry]] | `:auto-accept-shared-associations` |
| `igmpv2Support` | java.lang.String | [[cdk.support/lookup-entry]] | `:igmpv2-support` |
| `staticSourcesSupport` | java.lang.String | [[cdk.support/lookup-entry]] | `:static-sources-support` |
"
  [^CfnTransitGatewayMulticastDomain$OptionsProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :auto-accept-shared-associations)]
    (. builder autoAcceptSharedAssociations data))
  (when-let [data (lookup-entry config id :igmpv2-support)]
    (. builder igmpv2Support data))
  (when-let [data (lookup-entry config id :static-sources-support)]
    (. builder staticSourcesSupport data))
  (.build builder))


(defn cfn-transit-gateway-multicast-domain-options-property-builder
  "Creates a  `CfnTransitGatewayMulticastDomain$OptionsProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-transit-gateway-multicast-domain-options-property-builder (new CfnTransitGatewayMulticastDomain$OptionsProperty$Builder) id config))


(defn build-cfn-transit-gateway-multicast-domain-props-builder
  "The build-cfn-transit-gateway-multicast-domain-props-builder function updates a CfnTransitGatewayMulticastDomainProps$Builder instance using the provided configuration.
  The function takes the CfnTransitGatewayMulticastDomainProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `options` | java.lang.Object | [[cdk.support/lookup-entry]] | `:options` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `transitGatewayId` | java.lang.String | [[cdk.support/lookup-entry]] | `:transit-gateway-id` |
"
  [^CfnTransitGatewayMulticastDomainProps$Builder builder id config]
  (when-let [data (lookup-entry config id :options)]
    (. builder options data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :transit-gateway-id)]
    (. builder transitGatewayId data))
  (.build builder))


(defn cfn-transit-gateway-multicast-domain-props-builder
  "Creates a  `CfnTransitGatewayMulticastDomainProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-transit-gateway-multicast-domain-props-builder (new CfnTransitGatewayMulticastDomainProps$Builder) id config))


(defn build-cfn-transit-gateway-multicast-group-member-builder
  "The build-cfn-transit-gateway-multicast-group-member-builder function updates a CfnTransitGatewayMulticastGroupMember$Builder instance using the provided configuration.
  The function takes the CfnTransitGatewayMulticastGroupMember$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `groupIpAddress` | java.lang.String | [[cdk.support/lookup-entry]] | `:group-ip-address` |
| `networkInterfaceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-interface-id` |
| `transitGatewayMulticastDomainId` | java.lang.String | [[cdk.support/lookup-entry]] | `:transit-gateway-multicast-domain-id` |
"
  [^CfnTransitGatewayMulticastGroupMember$Builder builder id config]
  (when-let [data (lookup-entry config id :group-ip-address)]
    (. builder groupIpAddress data))
  (when-let [data (lookup-entry config id :network-interface-id)]
    (. builder networkInterfaceId data))
  (when-let [data (lookup-entry config id :transit-gateway-multicast-domain-id)]
    (. builder transitGatewayMulticastDomainId data))
  (.build builder))


(defn cfn-transit-gateway-multicast-group-member-builder
  "Creates a  `CfnTransitGatewayMulticastGroupMember$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-transit-gateway-multicast-group-member-builder (CfnTransitGatewayMulticastGroupMember$Builder/create scope (name id)) id config))


(defn build-cfn-transit-gateway-multicast-group-member-props-builder
  "The build-cfn-transit-gateway-multicast-group-member-props-builder function updates a CfnTransitGatewayMulticastGroupMemberProps$Builder instance using the provided configuration.
  The function takes the CfnTransitGatewayMulticastGroupMemberProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `groupIpAddress` | java.lang.String | [[cdk.support/lookup-entry]] | `:group-ip-address` |
| `networkInterfaceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-interface-id` |
| `transitGatewayMulticastDomainId` | java.lang.String | [[cdk.support/lookup-entry]] | `:transit-gateway-multicast-domain-id` |
"
  [^CfnTransitGatewayMulticastGroupMemberProps$Builder builder id config]
  (when-let [data (lookup-entry config id :group-ip-address)]
    (. builder groupIpAddress data))
  (when-let [data (lookup-entry config id :network-interface-id)]
    (. builder networkInterfaceId data))
  (when-let [data (lookup-entry config id :transit-gateway-multicast-domain-id)]
    (. builder transitGatewayMulticastDomainId data))
  (.build builder))


(defn cfn-transit-gateway-multicast-group-member-props-builder
  "Creates a  `CfnTransitGatewayMulticastGroupMemberProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-transit-gateway-multicast-group-member-props-builder (new CfnTransitGatewayMulticastGroupMemberProps$Builder) id config))


(defn build-cfn-transit-gateway-multicast-group-source-builder
  "The build-cfn-transit-gateway-multicast-group-source-builder function updates a CfnTransitGatewayMulticastGroupSource$Builder instance using the provided configuration.
  The function takes the CfnTransitGatewayMulticastGroupSource$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `groupIpAddress` | java.lang.String | [[cdk.support/lookup-entry]] | `:group-ip-address` |
| `networkInterfaceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-interface-id` |
| `transitGatewayMulticastDomainId` | java.lang.String | [[cdk.support/lookup-entry]] | `:transit-gateway-multicast-domain-id` |
"
  [^CfnTransitGatewayMulticastGroupSource$Builder builder id config]
  (when-let [data (lookup-entry config id :group-ip-address)]
    (. builder groupIpAddress data))
  (when-let [data (lookup-entry config id :network-interface-id)]
    (. builder networkInterfaceId data))
  (when-let [data (lookup-entry config id :transit-gateway-multicast-domain-id)]
    (. builder transitGatewayMulticastDomainId data))
  (.build builder))


(defn cfn-transit-gateway-multicast-group-source-builder
  "Creates a  `CfnTransitGatewayMulticastGroupSource$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-transit-gateway-multicast-group-source-builder (CfnTransitGatewayMulticastGroupSource$Builder/create scope (name id)) id config))


(defn build-cfn-transit-gateway-multicast-group-source-props-builder
  "The build-cfn-transit-gateway-multicast-group-source-props-builder function updates a CfnTransitGatewayMulticastGroupSourceProps$Builder instance using the provided configuration.
  The function takes the CfnTransitGatewayMulticastGroupSourceProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `groupIpAddress` | java.lang.String | [[cdk.support/lookup-entry]] | `:group-ip-address` |
| `networkInterfaceId` | java.lang.String | [[cdk.support/lookup-entry]] | `:network-interface-id` |
| `transitGatewayMulticastDomainId` | java.lang.String | [[cdk.support/lookup-entry]] | `:transit-gateway-multicast-domain-id` |
"
  [^CfnTransitGatewayMulticastGroupSourceProps$Builder builder id config]
  (when-let [data (lookup-entry config id :group-ip-address)]
    (. builder groupIpAddress data))
  (when-let [data (lookup-entry config id :network-interface-id)]
    (. builder networkInterfaceId data))
  (when-let [data (lookup-entry config id :transit-gateway-multicast-domain-id)]
    (. builder transitGatewayMulticastDomainId data))
  (.build builder))


(defn cfn-transit-gateway-multicast-group-source-props-builder
  "Creates a  `CfnTransitGatewayMulticastGroupSourceProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-transit-gateway-multicast-group-source-props-builder (new CfnTransitGatewayMulticastGroupSourceProps$Builder) id config))


(defn build-cfn-transit-gateway-peering-attachment-builder
  "The build-cfn-transit-gateway-peering-attachment-builder function updates a CfnTransitGatewayPeeringAttachment$Builder instance using the provided configuration.
  The function takes the CfnTransitGatewayPeeringAttachment$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `peerAccountId` | java.lang.String | [[cdk.support/lookup-entry]] | `:peer-account-id` |
| `peerRegion` | java.lang.String | [[cdk.support/lookup-entry]] | `:peer-region` |
| `peerTransitGatewayId` | java.lang.String | [[cdk.support/lookup-entry]] | `:peer-transit-gateway-id` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `transitGatewayId` | java.lang.String | [[cdk.support/lookup-entry]] | `:transit-gateway-id` |
"
  [^CfnTransitGatewayPeeringAttachment$Builder builder id config]
  (when-let [data (lookup-entry config id :peer-account-id)]
    (. builder peerAccountId data))
  (when-let [data (lookup-entry config id :peer-region)]
    (. builder peerRegion data))
  (when-let [data (lookup-entry config id :peer-transit-gateway-id)]
    (. builder peerTransitGatewayId data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :transit-gateway-id)]
    (. builder transitGatewayId data))
  (.build builder))


(defn cfn-transit-gateway-peering-attachment-builder
  "Creates a  `CfnTransitGatewayPeeringAttachment$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-transit-gateway-peering-attachment-builder (CfnTransitGatewayPeeringAttachment$Builder/create scope (name id)) id config))


(defn build-cfn-transit-gateway-peering-attachment-peering-attachment-status-property-builder
  "The build-cfn-transit-gateway-peering-attachment-peering-attachment-status-property-builder function updates a CfnTransitGatewayPeeringAttachment$PeeringAttachmentStatusProperty$Builder instance using the provided configuration.
  The function takes the CfnTransitGatewayPeeringAttachment$PeeringAttachmentStatusProperty$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `code` | java.lang.String | [[cdk.support/lookup-entry]] | `:code` |
| `message` | java.lang.String | [[cdk.support/lookup-entry]] | `:message` |
"
  [^CfnTransitGatewayPeeringAttachment$PeeringAttachmentStatusProperty$Builder builder id config]
  (when-let [data (lookup-entry config id :code)]
    (. builder code data))
  (when-let [data (lookup-entry config id :message)]
    (. builder message data))
  (.build builder))


(defn cfn-transit-gateway-peering-attachment-peering-attachment-status-property-builder
  "Creates a  `CfnTransitGatewayPeeringAttachment$PeeringAttachmentStatusProperty$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-transit-gateway-peering-attachment-peering-attachment-status-property-builder (new CfnTransitGatewayPeeringAttachment$PeeringAttachmentStatusProperty$Builder) id config))


(defn build-cfn-transit-gateway-peering-attachment-props-builder
  "The build-cfn-transit-gateway-peering-attachment-props-builder function updates a CfnTransitGatewayPeeringAttachmentProps$Builder instance using the provided configuration.
  The function takes the CfnTransitGatewayPeeringAttachmentProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `peerAccountId` | java.lang.String | [[cdk.support/lookup-entry]] | `:peer-account-id` |
| `peerRegion` | java.lang.String | [[cdk.support/lookup-entry]] | `:peer-region` |
| `peerTransitGatewayId` | java.lang.String | [[cdk.support/lookup-entry]] | `:peer-transit-gateway-id` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `transitGatewayId` | java.lang.String | [[cdk.support/lookup-entry]] | `:transit-gateway-id` |
"
  [^CfnTransitGatewayPeeringAttachmentProps$Builder builder id config]
  (when-let [data (lookup-entry config id :peer-account-id)]
    (. builder peerAccountId data))
  (when-let [data (lookup-entry config id :peer-region)]
    (. builder peerRegion data))
  (when-let [data (lookup-entry config id :peer-transit-gateway-id)]
    (. builder peerTransitGatewayId data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :transit-gateway-id)]
    (. builder transitGatewayId data))
  (.build builder))


(defn cfn-transit-gateway-peering-attachment-props-builder
  "Creates a  `CfnTransitGatewayPeeringAttachmentProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-transit-gateway-peering-attachment-props-builder (new CfnTransitGatewayPeeringAttachmentProps$Builder) id config))


(defn build-cfn-transit-gateway-props-builder
  "The build-cfn-transit-gateway-props-builder function updates a CfnTransitGatewayProps$Builder instance using the provided configuration.
  The function takes the CfnTransitGatewayProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `amazonSideAsn` | java.lang.Number | [[cdk.support/lookup-entry]] | `:amazon-side-asn` |
| `associationDefaultRouteTableId` | java.lang.String | [[cdk.support/lookup-entry]] | `:association-default-route-table-id` |
| `autoAcceptSharedAttachments` | java.lang.String | [[cdk.support/lookup-entry]] | `:auto-accept-shared-attachments` |
| `defaultRouteTableAssociation` | java.lang.String | [[cdk.support/lookup-entry]] | `:default-route-table-association` |
| `defaultRouteTablePropagation` | java.lang.String | [[cdk.support/lookup-entry]] | `:default-route-table-propagation` |
| `description` | java.lang.String | [[cdk.support/lookup-entry]] | `:description` |
| `dnsSupport` | java.lang.String | [[cdk.support/lookup-entry]] | `:dns-support` |
| `multicastSupport` | java.lang.String | [[cdk.support/lookup-entry]] | `:multicast-support` |
| `propagationDefaultRouteTableId` | java.lang.String | [[cdk.support/lookup-entry]] | `:propagation-default-route-table-id` |
| `tags` | java.util.List | [[cdk.support/lookup-entry]] | `:tags` |
| `transitGatewayCidrBlocks` | java.util.List | [[cdk.support/lookup-entry]] | `:transit-gateway-cidr-blocks` |
| `vpnEcmpSupport` | java.lang.String | [[cdk.support/lookup-entry]] | `:vpn-ecmp-support` |
"
  [^CfnTransitGatewayProps$Builder builder id config]
  (when-let [data (lookup-entry config id :amazon-side-asn)]
    (. builder amazonSideAsn data))
  (when-let [data (lookup-entry config id :association-default-route-table-id)]
    (. builder associationDefaultRouteTableId data))
  (when-let [data (lookup-entry config id :auto-accept-shared-attachments)]
    (. builder autoAcceptSharedAttachments data))
  (when-let [data (lookup-entry config id :default-route-table-association)]
    (. builder defaultRouteTableAssociation data))
  (when-let [data (lookup-entry config id :default-route-table-propagation)]
    (. builder defaultRouteTablePropagation data))
  (when-let [data (lookup-entry config id :description)]
    (. builder description data))
  (when-let [data (lookup-entry config id :dns-support)]
    (. builder dnsSupport data))
  (when-let [data (lookup-entry config id :multicast-support)]
    (. builder multicastSupport data))
  (when-let [data (lookup-entry config id :propagation-default-route-table-id)]
    (. builder propagationDefaultRouteTableId data))
  (when-let [data (lookup-entry config id :tags)]
    (. builder tags data))
  (when-let [data (lookup-entry config id :transit-gateway-cidr-blocks)]
    (. builder transitGatewayCidrBlocks data))
  (when-let [data (lookup-entry config id :vpn-ecmp-support)]
    (. builder vpnEcmpSupport data))
  (.build builder))


(defn cfn-transit-gateway-props-builder
  "Creates a  `CfnTransitGatewayProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-transit-gateway-props-builder (new CfnTransitGatewayProps$Builder) id config))


(defn build-cfn-transit-gateway-route-builder
  "The build-cfn-transit-gateway-route-builder function updates a CfnTransitGatewayRoute$Builder instance using the provided configuration.
  The function takes the CfnTransitGatewayRoute$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `blackhole` | java.lang.Boolean | [[cdk.support/lookup-entry]] | `:blackhole` |
| `destinationCidrBlock` | java.lang.String | [[cdk.support/lookup-entry]] | `:destination-cidr-block` |
| `transitGatewayAttachmentId` | java.lang.String | [[cdk.support/lookup-entry]] | `:transit-gateway-attachment-id` |
| `transitGatewayRouteTableId` | java.lang.String | [[cdk.support/lookup-entry]] | `:transit-gateway-route-table-id` |
"
  [^CfnTransitGatewayRoute$Builder builder id config]
  (when-let [data (lookup-entry config id :blackhole)]
    (. builder blackhole data))
  (when-let [data (lookup-entry config id :destination-cidr-block)]
    (. builder destinationCidrBlock data))
  (when-let [data (lookup-entry config id :transit-gateway-attachment-id)]
    (. builder transitGatewayAttachmentId data))
  (when-let [data (lookup-entry config id :transit-gateway-route-table-id)]
    (. builder transitGatewayRouteTableId data))
  (.build builder))


(defn cfn-transit-gateway-route-builder
  "Creates a  `CfnTransitGatewayRoute$Builder` instance using a scope and ID, applies the data configuration, then builds it.  Takes the following arguments: 
| Argument | DataType | Description |
|---|---|---|
| scope | software.constructs.Construct | The parent scope construct of the object being built. |
| id | String or Keyword or Symbol | Value to use as both the ID of the object being build and the namespace when looking up configuration values. |
| config | map | Data configuration |"
  [^software.constructs.Construct scope id config]
  (build-cfn-transit-gateway-route-builder (CfnTransitGatewayRoute$Builder/create scope (name id)) id config))


(defn build-cfn-transit-gateway-route-props-builder
  "The build-cfn-transit-gateway-route-props-builder function updates a CfnTransitGatewayRouteProps$Builder instance using the provided configuration.
  The function takes the CfnTransitGatewayRouteProps$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are populated by looking up their respective data key, where the namespaced value takes precendence over the non-namespaced value:

| Field | DataType | Lookup Function | Data Key |
|---|---|---|---|
| `blackhole` | software.amazon.awscdk.IResolvable | [[cdk.support/lookup-entry]] | `:blackhole` |
| `destinationCidrBlock` | java.lang.String | [[cdk.support/lookup-entry]] | `:destination-cidr-block` |
| `transitGatewayAttachmentId` | java.lang.String | [[cdk.support/lookup-entry]] | `:transit-gateway-attachment-id` |
| `transitGatewayRouteTableId` | java.lang.String | [[cdk.support/lookup-entry]] | `:transit-gateway-route-table-id` |
"
  [^CfnTransitGatewayRouteProps$Builder builder id config]
  (when-let [data (lookup-entry config id :blackhole)]
    (. builder blackhole data))
  (when-let [data (lookup-entry config id :destination-cidr-block)]
    (. builder destinationCidrBlock data))
  (when-let [data (lookup-entry config id :transit-gateway-attachment-id)]
    (. builder transitGatewayAttachmentId data))
  (when-let [data (lookup-entry config id :transit-gateway-route-table-id)]
    (. builder transitGatewayRouteTableId data))
  (.build builder))


(defn cfn-transit-gateway-route-props-builder
  "Creates a  `CfnTransitGatewayRouteProps$Builder` instance using a no-argument constructor, applies the data configuration, then builds it.  Takes the following arguments: 

| Argument | DataType | Description |
|---|---|---|
| id | String or Keyword or Symbol | Value to use as namespace when looking up configuration values. |
| config | map | Data configuration |"
  [id config]
  (build-cfn-transit-gateway-route-props-builder (new CfnTransitGatewayRouteProps$Builder) id config))


(defn build-cfn-transit-gateway-route-table-association-builder
  "The build-cfn-transit-gateway-route-table-association-builder function updates a CfnTransitGatewayRouteTableAssociation$Builder instance using the provided configuration.
  The function takes the CfnTransitGatewayRouteTableAssociation$Builder instance, an optional namespace to use when looking up a value in the configuration,
  and the configuration itself.

  Fields on the builder are p