(ns ui.events
  (:refer-clojure :exclude [drop])
  (:require [ui.internal.reflectivity :refer [swt-event-methods]]))

(defn- def-event [kw]
  (let [event-name (symbol kw)]
    `(def ~event-name ~kw)))

(comment
  "This will regenerate this file's contents into events2.clj"
  (spit "events2.clj"
        (with-out-str
          (doall
           (->> swt-event-methods
                distinct
                (map def-event)
                (map println)))))

  :eoc)

(def add-selection :add-selection)
(def authenticate :authenticate)
(def caret-moved :caret-moved)
(def changed :changed)
(def changing :changing)
(def close :close)
(def completed :completed)
(def control-moved :control-moved)
(def control-resized :control-resized)
(def copy-text :copy-text)
(def cut-text :cut-text)
(def deselect-column :deselect-column)
(def deselect-row :deselect-row)
(def do-action :do-action)
(def drag-detected :drag-detected)
(def drag-enter :drag-enter)
(def drag-finished :drag-finished)
(def drag-leave :drag-leave)
(def drag-operation-changed :drag-operation-changed)
(def drag-over :drag-over)
(def drag-set-data :drag-set-data)
(def drag-start :drag-start)
(def drop :drop)
(def drop-accept :drop-accept)
(def focus-gained :focus-gained)
(def focus-lost :focus-lost)
(def gesture :gesture)
(def get-action-count :get-action-count)
(def get-anchor :get-anchor)
(def get-anchor-target :get-anchor-target)
(def get-attributes :get-attributes)
(def get-caption :get-caption)
(def get-caret-offset :get-caret-offset)
(def get-cell :get-cell)
(def get-character-count :get-character-count)
(def get-child :get-child)
(def get-child-at-point :get-child-at-point)
(def get-child-count :get-child-count)
(def get-children :get-children)
(def get-column :get-column)
(def get-column-count :get-column-count)
(def get-column-description :get-column-description)
(def get-column-header :get-column-header)
(def get-column-header-cells :get-column-header-cells)
(def get-column-headers :get-column-headers)
(def get-column-index :get-column-index)
(def get-column-span :get-column-span)
(def get-columns :get-columns)
(def get-current-value :get-current-value)
(def get-default-action :get-default-action)
(def get-description :get-description)
(def get-end-index :get-end-index)
(def get-focus :get-focus)
(def get-help :get-help)
(def get-hyperlink :get-hyperlink)
(def get-hyperlink-count :get-hyperlink-count)
(def get-hyperlink-index :get-hyperlink-index)
(def get-key-binding :get-key-binding)
(def get-keyboard-shortcut :get-keyboard-shortcut)
(def get-location :get-location)
(def get-maximum-value :get-maximum-value)
(def get-minimum-value :get-minimum-value)
(def get-name :get-name)
(def get-next-offset :get-next-offset)
(def get-offset-at-point :get-offset-at-point)
(def get-previous-offset :get-previous-offset)
(def get-ranges :get-ranges)
(def get-role :get-role)
(def get-row :get-row)
(def get-row-count :get-row-count)
(def get-row-description :get-row-description)
(def get-row-header :get-row-header)
(def get-row-header-cells :get-row-header-cells)
(def get-row-headers :get-row-headers)
(def get-row-index :get-row-index)
(def get-row-span :get-row-span)
(def get-rows :get-rows)
(def get-segments :get-segments)
(def get-selected-cell-count :get-selected-cell-count)
(def get-selected-cells :get-selected-cells)
(def get-selected-column-count :get-selected-column-count)
(def get-selected-columns :get-selected-columns)
(def get-selected-row-count :get-selected-row-count)
(def get-selected-rows :get-selected-rows)
(def get-selection :get-selection)
(def get-selection-count :get-selection-count)
(def get-selection-range :get-selection-range)
(def get-start-index :get-start-index)
(def get-state :get-state)
(def get-summary :get-summary)
(def get-table :get-table)
(def get-text :get-text)
(def get-text-attributes :get-text-attributes)
(def get-text-bounds :get-text-bounds)
(def get-value :get-value)
(def get-visible-columns :get-visible-columns)
(def get-visible-ranges :get-visible-ranges)
(def get-visible-rows :get-visible-rows)
(def help-requested :help-requested)
(def hide :hide)
(def image-data-loaded :image-data-loaded)
(def is-column-selected :is-column-selected)
(def is-row-selected :is-row-selected)
(def is-selected :is-selected)
(def item-closed :item-closed)
(def item-collapsed :item-collapsed)
(def item-expanded :item-expanded)
(def items-count :items-count)
(def key-pressed :key-pressed)
(def key-released :key-released)
(def key-traversed :key-traversed)
(def line-get-background :line-get-background)
(def line-get-segments :line-get-segments)
(def line-get-style :line-get-style)
(def maximize :maximize)
(def menu-detected :menu-detected)
(def menu-hidden :menu-hidden)
(def menu-shown :menu-shown)
(def minimize :minimize)
(def modify-text :modify-text)
(def mouse-double-click :mouse-double-click)
(def mouse-down :mouse-down)
(def mouse-enter :mouse-enter)
(def mouse-exit :mouse-exit)
(def mouse-hover :mouse-hover)
(def mouse-move :mouse-move)
(def mouse-scrolled :mouse-scrolled)
(def mouse-up :mouse-up)
(def open :open)
(def paint-control :paint-control)
(def paint-object :paint-object)
(def paste-text :paste-text)
(def remove-selection :remove-selection)
(def replace-text :replace-text)
(def restore :restore)
(def scroll-text :scroll-text)
(def select-column :select-column)
(def select-row :select-row)
(def set-caret-offset :set-caret-offset)
(def set-current-value :set-current-value)
(def set-selected-column :set-selected-column)
(def set-selected-row :set-selected-row)
(def set-selection :set-selection)
(def set-text-attributes :set-text-attributes)
(def shell-activated :shell-activated)
(def shell-closed :shell-closed)
(def shell-deactivated :shell-deactivated)
(def shell-deiconified :shell-deiconified)
(def shell-iconified :shell-iconified)
(def show :show)
(def show-list :show-list)
(def text-changed :text-changed)
(def text-changing :text-changing)
(def text-set :text-set)
(def touch :touch)
(def tree-collapsed :tree-collapsed)
(def tree-expanded :tree-expanded)
(def verify-key :verify-key)
(def verify-text :verify-text)
(def widget-armed :widget-armed)
(def widget-default-selected :widget-default-selected)
(def widget-disposed :widget-disposed)
(def widget-selected :widget-selected)
