/**
 * ol-ext - A set of cool extensions for OpenLayers (ol) in node modules structure
 * @description ol3,openlayers,popup,menu,symbol,renderer,filter,canvas,interaction,split,statistic,charts,pie,LayerSwitcher,toolbar,animation
 * @version v3.2.28
 * @author Jean-Marc Viglino
 * @see https://github.com/Viglino/ol-ext#,
 * @license BSD-3-Clause
 */
function projectVectorOnVector(t,e){var o=(t[0]*e[0]+t[1]*e[1])/(e[0]*e[0]+e[1]*e[1]);return[e[0]*o,e[1]*o]}function countVector(t,e){return[e[0]-t[0],e[1]-t[1]]}function movePoint(t,e){return[t[0]+e[0],t[1]+e[1]]}window.ol&&!ol.ext&&(ol.ext={}),ol.ext.inherits=function(t,e){t.prototype=Object.create(e.prototype),t.prototype.constructor=t},window.ol&&(ol.inherits||(ol.inherits=ol.ext.inherits)),window.NodeList&&!NodeList.prototype.forEach&&(NodeList.prototype.forEach=Array.prototype.forEach),window.Element&&!Element.prototype.remove&&(Element.prototype.remove=function(){this.parentNode&&this.parentNode.removeChild(this)}),ol.ext.Ajax=function(t){t=t||{},ol.Object.call(this),this._auth=t.auth,this.set("dataType",t.dataType||"JSON")},ol.ext.inherits(ol.ext.Ajax,ol.Object),ol.ext.Ajax.get=function(t){var e=new ol.ext.Ajax(t);t.success&&e.on("success",function(e){t.success(e.response,e)}),t.error&&e.on("error",function(e){t.error(e)}),e.send(t.url,t.data,t.options)},ol.ext.Ajax.getCORS=function(t,e){var o=new XMLHttpRequest;o.open("GET",t,!0),o.send(),o.onreadystatechange=function(){this.readyState==this.HEADERS_RECEIVED&&e(o.getResponseHeader("Access-Control-Allow-Origin"))}},ol.ext.Ajax.prototype.send=function(t,e,o){var i=this,n=!1!==(o=o||{}).encode;n&&(t=encodeURI(t));var r="";for(var s in e)e.hasOwnProperty(s)&&void 0!==e[s]&&(r+=(r?"&":"?")+s+"="+(n?encodeURIComponent(e[s]):e[s]));this._request&&!1!==o.abort&&this._request.abort();var a=this._request=new XMLHttpRequest;a.open("GET",t+r,!0),o.timeout&&(a.timeout=o.timeout),this._auth&&a.setRequestHeader("Authorization","Basic "+this._auth),this.dispatchEvent({type:"loadstart"}),a.onload=function(){if(i._request=null,i.dispatchEvent({type:"loadend"}),this.status>=200&&this.status<400){var t;try{switch(i.get("dataType")){case"JSON":t=JSON.parse(this.response);break;default:t=this.response}}catch(t){return void i.dispatchEvent({type:"error",status:0,statusText:"parsererror",error:t,options:o,jqXHR:this})}i.dispatchEvent({type:"success",response:t,status:this.status,statusText:this.statusText,options:o,jqXHR:this})}else i.dispatchEvent({type:"error",status:this.status,statusText:this.statusText,options:o,jqXHR:this})},a.ontimeout=function(){i._request=null,i.dispatchEvent({type:"loadend"}),i.dispatchEvent({type:"error",status:this.status,statusText:"Timeout",options:o,jqXHR:this})},a.onerror=function(){i._request=null,i.dispatchEvent({type:"loadend"}),i.dispatchEvent({type:"error",status:this.status,statusText:this.statusText,options:o,jqXHR:this})},a.send()},ol.ext.SVGFilter=function(t){t=t||{},ol.Object.call(this),ol.ext.SVGFilter.prototype.svg||(ol.ext.SVGFilter.prototype.svg=document.createElementNS(this.NS,"svg"),ol.ext.SVGFilter.prototype.svg.setAttribute("version","1.1"),ol.ext.SVGFilter.prototype.svg.setAttribute("width",0),ol.ext.SVGFilter.prototype.svg.setAttribute("height",0),ol.ext.SVGFilter.prototype.svg.style.position="absolute",document.body.appendChild(ol.ext.SVGFilter.prototype.svg)),this.element=document.createElementNS(this.NS,"filter"),this._id=t.id||"_ol_SVGFilter_"+ol.ext.SVGFilter.prototype._id++,this.element.setAttribute("id",this._id),t.color&&this.element.setAttribute("color-interpolation-filters",t.color),t.operation&&this.addOperation(t.operation),ol.ext.SVGFilter.prototype.svg.appendChild(this.element)},ol.ext.inherits(ol.ext.SVGFilter,ol.Object),ol.ext.SVGFilter.prototype.NS="http://www.w3.org/2000/svg",ol.ext.SVGFilter.prototype.svg=null,ol.ext.SVGFilter.prototype._id=0,ol.ext.SVGFilter.prototype.getId=function(){return this._id},ol.ext.SVGFilter.prototype.remove=function(){this.element.remove()},ol.ext.SVGFilter.prototype.addOperation=function(t){t instanceof Array?t.forEach(function(t){this.addOperation(t)}.bind(this)):(t instanceof ol.ext.SVGOperation||(t=new ol.ext.SVGOperation(t)),this.element.appendChild(t.geElement()))},ol.ext.SVGFilter.prototype.grayscale=function(t){this.addOperation({feoperation:"feColorMatrix",type:"saturate",values:t||0})},ol.ext.SVGFilter.prototype.luminanceToAlpha=function(t){t=t||{},this.addOperation({feoperation:"feColorMatrix",type:"luminanceToAlpha"}),t.gamma&&this.addOperation({feoperation:"feComponentTransfer",operations:[{feoperation:"feFuncA",type:"gamma",amplitude:t.gamma,exponent:1,offset:0}]})},ol.ext.SVGFilter.prototype.applyTo=function(t){var e=document.createElement("CANVAS");return e.width=t.naturalWidth||t.width,e.height=t.naturalHeight||t.height,e.getContext("2d").filter="url(#"+this.getId()+")",e.getContext("2d").drawImage(t,0,0),e},ol.ext.SVGOperation=function(t){"string"==typeof t&&(t={feoperation:t}),t&&t.feoperation?(ol.Object.call(this),this._name=t.feoperation,this.element=document.createElementNS(this.NS,this._name),this.setProperties(t),t.operations instanceof Array&&this.appendChild(t.operations)):console.error("[SVGOperation]: no operation defined.")},ol.ext.inherits(ol.ext.SVGOperation,ol.Object),ol.ext.SVGOperation.prototype.NS="http://www.w3.org/2000/svg",ol.ext.SVGOperation.prototype.getName=function(){return this._name},ol.ext.SVGOperation.prototype.set=function(t,e){/^feoperation$|^operations$/.test(t)||(ol.Object.prototype.set.call(this,t,e),this.element.setAttribute(t,e))},ol.ext.SVGOperation.prototype.setProperties=function(t){for(var e in t=t||{})this.set(e,t[e])},ol.ext.SVGOperation.prototype.geElement=function(){return this.element},ol.ext.SVGOperation.prototype.appendChild=function(t){t instanceof Array?t.forEach(function(t){this.appendChild(t)}.bind(this)):(t instanceof ol.ext.SVGOperation||(t=new ol.ext.SVGOperation(t)),this.element.appendChild(t.geElement()))},ol.View.prototype.flyTo&&console.warn("[OL-EXT] ol/View~View.flyTo redefinition"),ol.View.prototype.flyTo=function(t,e){t=t||{},this.cancelAnimations();var o="function"==typeof e?e:function(){},i=t.duration||2e3,n=t.zoomAt||Math.min(t.zoom||100,this.getZoom())-2,r=t.zoom||this.getZoom(),s=t.center||this.getCenter();this.animate({center:s,duration:i,easing:t.easing,anchor:t.anchor,rotation:t.rotation}),this.animate({zoom:n,duration:i/2,easing:t.easing,anchor:t.anchor},{zoom:r,duration:i/2,easing:t.easing,anchor:t.anchor},o)},ol.View.prototype.takeTour=function(t,e){e=e||{};var o=-1,i=function(n){if(n){var r=t[++o];if("function"==typeof e.step&&e.step(o,t),r){r instanceof Array&&(r={center:[r[0],r[1]],zoom:r[2],type:r[3]});var s=0===o?0:e.delay||750;r.easing||(r.easing=e.easing),r.type||(r.type=e.type),setTimeout(function(){switch(r.type){case"moveTo":this.animate(r,i);break;case"flightTo":default:this.flyTo(r,i)}}.bind(this),s)}else"function"==typeof e.done&&e.done(!0)}else"function"==typeof e.done&&e.done(!1)}.bind(this);i(!0)},ol.color.toHSL=function(t,e){void 0===e&&(e=100),Array.isArray(t)||(t=ol.color.asArray(t));var o,i,n=t[0]/255,r=t[1]/255,s=t[2]/255,a=Math.max(n,r,s),l=Math.min(n,r,s),c=(a+l)/2;if(a===l)o=i=0;else{var h=a-l;switch(i=c>.5?h/(2-a-l):h/(a+l),a){case n:o=(r-s)/h+(r<s?6:0);break;case r:o=(s-n)/h+2;break;case s:o=(n-r)/h+4}}var p=[Math.round(60*o*e)/e,Math.round(100*i*e)/e,Math.round(100*c*e)/e];return t.length>3&&(p[3]=t[3]),p},ol.color.fromHSL=function(t,e){void 0===e&&(e=1e3);var o,i,n,r=t[0]/360,s=t[1]/100,a=t[2]/100;if(0==s)o=i=n=a;else{var l=function(t,e,o){return o<0&&(o+=1),o>1&&(o-=1),o<1/6?t+6*(e-t)*o:o<.5?e:o<2/3?t+(e-t)*(2/3-o)*6:t},c=a<.5?a*(1+s):a+s-a*s,h=2*a-c;o=l(h,c,r+1/3),i=l(h,c,r),n=l(h,c,r-1/3)}var p=[Math.round(255*o*e)/e,Math.round(255*i*e)/e,Math.round(255*n*e)/e];return t.length>3&&(p[3]=t[3]),p},ol.color.toHSV=function(t,e){void 0===e&&(e=100),Array.isArray(t)||(t=ol.color.asArray(t));var o,i,n=t[0]/255,r=t[1]/255,s=t[2]/255,a=Math.max(n,r,s),l=Math.min(n,r,s),c=a,h=a-l;if(i=0==a?0:h/a,a==l)o=0;else switch(a){case n:o=(r-s)/h+(r<s?6:0);break;case r:o=(s-n)/h+2;break;case s:o=(n-r)/h+4}var p=[Math.round(60*o*e)/e,Math.round(100*i*e)/e,Math.round(100*c*e)/e];return t.length>3&&(p[3]=t[3]),p},ol.color.fromHSV=function(t,e){void 0===e&&(e=1e3);var o,i,n,r=t[0]/360,s=t[1]/100,a=t[2]/100,l=Math.floor(6*r),c=6*r-l,h=a*(1-s),p=a*(1-c*s),u=a*(1-(1-c)*s);switch(l%6){case 0:o=a,i=u,n=h;break;case 1:o=p,i=a,n=h;break;case 2:o=h,i=a,n=u;break;case 3:o=h,i=p,n=a;break;case 4:o=u,i=h,n=a;break;case 5:o=a,i=h,n=p}var g=[Math.round(255*o*e)/e,Math.round(255*i*e)/e,Math.round(255*n*e)/e];return t.length>3&&(g[3]=t[3]),g},ol.color.toHexa=function(t){return"#"+((1<<24)+(t[0]<<16)+(t[1]<<8)+t[2]).toString(16).slice(1)},ol.ext.element={},ol.ext.element.create=function(t,e){var o;if(e=e||{},"TEXT"===t)o=document.createTextNode(e.html||""),e.parent&&e.parent.appendChild(o);else for(var i in o=document.createElement(t),/button/i.test(t)&&o.setAttribute("type","button"),e)switch(i){case"className":e.className&&e.className.trim&&o.setAttribute("class",e.className.trim());break;case"text":o.innerText=e.text;break;case"html":e.html instanceof Element?o.appendChild(e.html):void 0!==e.html&&(o.innerHTML=e.html);break;case"parent":e.parent&&e.parent.appendChild(o);break;case"options":if(/select/i.test(t))for(var n in e.options)ol.ext.element.create("OPTION",{html:n,value:e.options[n],parent:o});break;case"style":ol.ext.element.setStyle(o,e.style);break;case"change":case"click":ol.ext.element.addListener(o,i,e[i]);break;case"on":for(var r in e.on)ol.ext.element.addListener(o,r,e.on[r]);break;case"checked":o.checked=!!e.checked;break;default:o.setAttribute(i,e[i])}return o},ol.ext.element.createSwitch=function(t){var e=ol.ext.element.create("INPUT",{type:"checkbox",on:t.on,click:t.click,change:t.change,parent:t.parent}),o=Object.assign({input:e},t||{});return new ol.ext.input.Switch(o),e},ol.ext.element.createCheck=function(t){var e=ol.ext.element.create("INPUT",{name:t.name,type:"radio"===t.type?"radio":"checkbox",on:t.on,parent:t.parent}),o=Object.assign({input:e},t||{});return"radio"===t.type?new ol.ext.input.Radio(o):new ol.ext.input.Checkbox(o),e},ol.ext.element.setHTML=function(t,e){e instanceof Element?t.appendChild(e):void 0!==e&&(t.innerHTML=e)},ol.ext.element.appendText=function(t,e){t.appendChild(document.createTextNode(e||""))},ol.ext.element.addListener=function(t,e,o,i){"string"==typeof e&&(e=e.split(" ")),e.forEach(function(e){t.addEventListener(e,o,i)})},ol.ext.element.removeListener=function(t,e,o){"string"==typeof e&&(e=e.split(" ")),e.forEach(function(e){t.removeEventListener(e,o)})},ol.ext.element.show=function(t){t.style.display=""},ol.ext.element.hide=function(t){t.style.display="none"},ol.ext.element.hidden=function(t){return"none"===ol.ext.element.getStyle(t,"display")},ol.ext.element.toggle=function(t){t.style.display="none"===t.style.display?"":"none"},ol.ext.element.setStyle=function(t,e){for(var o in e)switch(o){case"top":case"left":case"bottom":case"right":case"minWidth":case"maxWidth":case"width":case"height":"number"==typeof e[o]?t.style[o]=e[o]+"px":t.style[o]=e[o];break;default:t.style[o]=e[o]}},ol.ext.element.getStyle=function(t,e){var o,i=(t.ownerDocument||document).defaultView;if(i&&i.getComputedStyle)e=e.replace(/([A-Z])/g,"-$1").toLowerCase(),o=i.getComputedStyle(t,null).getPropertyValue(e);else if(t.currentStyle&&(e=e.replace(/-(\w)/g,function(t,e){return e.toUpperCase()}),o=t.currentStyle[e],/^\d+(em|pt|%|ex)?$/i.test(o)))return function(e){var o=t.style.left,i=t.runtimeStyle.left;return t.runtimeStyle.left=t.currentStyle.left,t.style.left=e||0,e=t.style.pixelLeft+"px",t.style.left=o,t.runtimeStyle.left=i,e}(o);return/px$/.test(o)?parseInt(o):o},ol.ext.element.outerHeight=function(t){return t.offsetHeight+ol.ext.element.getStyle(t,"marginBottom")},ol.ext.element.outerWidth=function(t){return t.offsetWidth+ol.ext.element.getStyle(t,"marginLeft")},ol.ext.element.offsetRect=function(t){var e=t.getBoundingClientRect();return{top:e.top+(window.pageYOffset||document.documentElement.scrollTop||document.body.scrollTop||0),left:e.left+(window.pageXOffset||document.documentElement.scrollLeft||document.body.scrollLeft||0),height:e.height||e.bottom-e.top,width:e.width||e.right-e.left}},ol.ext.element.getFixedOffset=function(t){var e={left:0,top:0},o=function(t){if(!t)return e;if("absolute"===ol.ext.element.getStyle(t,"position")&&"none"!==ol.ext.element.getStyle(t,"transform")){var i=t.getBoundingClientRect();return e.left+=i.left,e.top+=i.top,e}return o(t.offsetParent)};return o(t.offsetParent)},ol.ext.element.positionRect=function(t,e){var o=0,i=0,n=function(r){if(r)return o+=r.offsetLeft,i+=r.offsetTop,n(r.offsetParent);var s={top:t.offsetTop+i,left:t.offsetLeft+o};return e&&(s.top-=window.pageYOffset||document.documentElement.scrollTop||document.body.scrollTop||0,s.left-=window.pageXOffset||document.documentElement.scrollLeft||document.body.scrollLeft||0),s.bottom=s.top+t.offsetHeight,s.right=s.top+t.offsetWidth,s};return n(t.offsetParent)},ol.ext.element.scrollDiv=function(t,e){var o,i,n,r,s,a=!1,l=0,c=0,h="function"==typeof(e=e||{}).onmove?e.onmove:function(){},p=e.vertical?"screenY":"screenX",u=e.vertical?"scrollTop":"scrollLeft",g=!1,d=0,m=function(){s&&(d++,setTimeout(f))},f=function(){if(s){if(--d)return;var e=t.clientHeight,o=t.scrollHeight;i=e/o,s.style.height=100*i+"%",s.style.top=t.scrollTop/o*100+"%",r.style.height=e+"px",e>o-.5?r.classList.add("ol-100pc"):r.classList.remove("ol-100pc")}},y=function(e){e.target.classList.contains("ol-noscroll")||(g=!1,a=e[p],c=new Date,t.classList.add("ol-move"),e.preventDefault(),window.addEventListener("pointermove",v),ol.ext.element.addListener(window,["pointerup","pointercancel"],b))},v=function(e){if(g=!0,!1!==a){var r=(n?-1/i:1)*(a-e[p]);t[u]+=r,(o=new Date)-c&&(l=(l+r/(o-c))/2),a=e[p],c=o,r&&h(!0)}},_=function(e){var o=e>0?Math.min(100,e/2):Math.max(-100,e/2);e-=o,t[u]+=o,-1<e&&e<1?(g?setTimeout(function(){t.classList.remove("ol-move")}):t.classList.remove("ol-move"),g=!1,h(!1)):setTimeout(function(){_(e)},40)};if(e.vertical&&e.minibar){var x=function(o){t.removeEventListener("pointermove",x),t.parentNode.classList.add("ol-miniscroll"),s=ol.ext.element.create("DIV"),r=ol.ext.element.create("DIV",{className:"ol-scroll",html:s}),t.parentNode.insertBefore(r,t),s.addEventListener("pointerdown",function(t){n=!0,y(t)}),e.mousewheel&&(ol.ext.element.addListener(r,["mousewheel","DOMMouseScroll","onmousewheel"],function(t){w(t)}),ol.ext.element.addListener(s,["mousewheel","DOMMouseScroll","onmousewheel"],function(t){w(t)})),t.parentNode.addEventListener("pointerenter",m),window.addEventListener("resize",m),!1!==o&&m()};t.parentNode?x(!1):t.addEventListener("pointermove",x),t.addEventListener("scroll",function(){m()})}t.style["touch-action"]="none",t.style.overflow="hidden",t.classList.add("ol-scrolldiv"),ol.ext.element.addListener(t,["pointerdown"],function(t){n=!1,y(t)}),t.addEventListener("click",function(e){t.classList.contains("ol-move")&&(e.preventDefault(),e.stopPropagation())},!0);var b=function(o){(c=new Date-c)>100||n?l=0:c>0&&(l=((l||0)+(a-o[p])/c)/2),_(!1===e.animate?0:200*l),a=!1,l=0,c=0,t.classList.contains("ol-move")?t.classList.remove("ol-hasClick"):(t.classList.add("ol-hasClick"),setTimeout(function(){t.classList.remove("ol-hasClick")},500)),n=!1,window.removeEventListener("pointermove",v),ol.ext.element.removeListener(window,["pointerup","pointercancel"],b)},w=function(e){var o=Math.max(-1,Math.min(1,e.wheelDelta||-e.detail));return t.classList.add("ol-move"),t[u]-=30*o,t.classList.remove("ol-move"),!1};return e.mousewheel&&ol.ext.element.addListener(t,["mousewheel","DOMMouseScroll","onmousewheel"],w),{refresh:m}},ol.ext.element.dispatchEvent=function(t,e){var o;try{o=new CustomEvent(t)}catch(e){(o=document.createEvent("CustomEvent")).initCustomEvent(t,!0,!0,{})}e.dispatchEvent(o)},ol.ext.getMapCanvas=function(t){if(!t)return null;var e=t.getViewport().getElementsByClassName("ol-fixedoverlay")[0];return e||(t.getViewport().querySelector(".ol-layers")?((e=document.createElement("canvas")).className="ol-fixedoverlay",t.getViewport().querySelector(".ol-layers").after(e),t.on("precompose",function(o){e.width=t.getSize()[0]*o.frameState.pixelRatio,e.height=t.getSize()[1]*o.frameState.pixelRatio})):e=t.getViewport().querySelector("canvas")),e},window.ol&&(ol.util?ol.util.VERSION||(ol.util.VERSION=ol.VERSION||"6.1.0"):ol.util={VERSION:ol.VERSION||"5.3.0"}),ol.ext.olVersion=ol.util.VERSION.split("."),ol.ext.olVersion=100*parseInt(ol.ext.olVersion[0])+parseInt(ol.ext.olVersion[1]),ol.ext.getVectorContextStyle=function(t,e){var o=t.frameState.pixelRatio;if(ol.ext.olVersion>605&&1!==o&&e.getImage()instanceof ol.style.Icon){var i=(e=e.clone()).getImage();i.setScale(i.getScale()*o);var n=i.getAnchor();if(i.setDisplacement){var r=i.getDisplacement();r&&(r[0]-=n[0]/o,r[1]+=n[1]/o,i.setAnchor([0,0]))}else n&&(n[0]/=o,n[1]/=o)}return e},window.ol&&(window.ol.ext.imageLoader={}),ol.ext.imageLoader.loadBILImage=function(t,e,o){var i=[parseInt(t.replace(/.*WIDTH=(\d*).*/i,"$1")),parseInt(t.replace(/.*HEIGHT=(\d*).*/i,"$1"))],n=new XMLHttpRequest;n.responseType="blob",n.addEventListener("loadend",function(){var t=this.response;if(void 0!==t){var n=new FileReader;n.addEventListener("loadend",t=>{var o=new Float32Array(t.target.result);e(o,i)}),n.readAsArrayBuffer(t)}else o()}),n.addEventListener("error",function(){o()}),n.open("GET",t),n.send()},ol.ext.imageLoader.loadImage=function(t,e,o){var i=new XMLHttpRequest;i.responseType="blob",i.addEventListener("loadend",function(){var t=this.response;if(void 0!==t){var i=new Image;i.onload=function(){e(i,[i.naturalWidth,i.naturalHeight])},i.src=URL.createObjectURL(t)}else o()}),i.addEventListener("error",function(){o()}),i.open("GET",t),i.send()},ol.ext.imageLoader.pixelTransform=function(t){return function(e,o){ol.ext.imageLoader.loadImage(o,function(o,i){var n=document.createElement("canvas");n.width=i[0],n.height=i[1];var r=n.getContext("2d");r.drawImage(o,0,0);for(var s=r.getImageData(0,0,i[0],i[1]),a=s.data,l=0;l<a.length;l+=4)t(a,l,i);r.putImageData(s,0,0),e.setImage(n)},function(){e.setState(3)})}},ol.ext.imageLoader.grayscale=function(){return ol.ext.imageLoader.pixelTransform(function(t,e){t[e]=t[e+1]=t[e+2]=parseInt(3*t[e]+4*t[e+1]+t[e+2]>>>3)})},ol.ext.imageLoader.transparent=function(t){var e,o;t instanceof Array&&(e=t[0],o=t[1]);var i=e=ol.color.asArray(e);return o?(o=ol.color.asArray(o),i=[Math.min(e[0],o[0]),Math.min(e[1],o[1]),Math.min(e[2],o[2])],o=[Math.max(e[0],o[0]),Math.max(e[1],o[1]),Math.max(e[2],o[2])],ol.ext.imageLoader.pixelTransform(function(t,n){t[n]>=e[0]&&t[n]<=o[0]&&t[n+1]>=i[1]&&t[n+1]<=o[1]&&t[n+2]>=i[2]&&t[n+2]<=o[2]&&(t[n+3]=0)})):ol.ext.imageLoader.pixelTransform(function(t,e){t[e]===i[0]&&t[e+1]===i[1]&&t[e+2]===i[2]&&(t[e+3]=0)})},ol.ext.imageLoader.seaLevelMap=function(t,e){e=e||{};var o=Math.max(t+.01,.01),i=e.color?ol.color.asArray(e.color):[135,203,249],n="number"==typeof e.minValue?e.minValue:-1/0,r=!1!==e.opacity;return ol.ext.imageLoader.elevationMap(function(t){return t<o&&t>n?[i[0],i[1],i[2],r?255*(o-t)/o:255]:[0,0,0,0]})},ol.ext.imageLoader.shadedRelief=function(){var t=Math.PI/4,e=2*Math.PI-Math.PI/4;return function(o,i){ol.ext.imageLoader.loadBILImage(i,function(i,n){var r=document.createElement("canvas"),s=r.getContext("2d"),a=r.width=n[0],l=r.height=n[1],c=s.getImageData(0,0,a,l),h=c.data;function p(t,e){return t+e*a}for(var u=0;u<a;u++)for(var g=0;g<l;g++){var d=p(u,Math.max(0,g-1)),m=p(Math.max(0,u-1),g),f=p(Math.min(a-1,u+1),g),y=p(u,Math.min(l,g+1)),v=i[d],_=i[m],x=(i[f]-_)/3,b=(i[y]-v)/3,w=Math.sqrt(x*x+b*b),S=Math.acos(x/w);0==w&&(S=0);var C=0;x>0?b>0?C=S+1.5*Math.PI:b<0?C=1.5*Math.PI-S:S=1.5*Math.PI:x<0?C=b<0?S+.5*Math.PI:b>0?.5*Math.PI-S:.5*Math.PI:b<0?C=Math.PI:b>0&&(C=0);var M=Math.cos(C-e)*Math.cos(.5*Math.PI-Math.atan(w))*Math.cos(t)+Math.sin(.5*Math.PI-Math.atan(w))*Math.sin(t);M<0&&(M=0),M=Math.sqrt(.8*M+.5);var E=4*p(u,g);h[E]=h[E+1]=h[E+2]=0,h[E+3]=255-255*M}s.putImageData(c,0,0),o.setImage(r)},function(){o.setState(3)})}},ol.ext.imageLoader.elevationMap=function(t){return"function"!=typeof t&&(t=ol.ext.getPixelFromElevation),function(e,o){ol.ext.imageLoader.loadBILImage(o,function(o,i){var n=document.createElement("canvas"),r=n.getContext("2d");n.width=i[0],n.height=i[1];for(var s=r.getImageData(0,0,i[0],i[1]),a=s.data,l=0;l<o.length;l++){var c=t(o[l]);a[4*l]=c[0],a[4*l+1]=c[1],a[4*l+2]=c[2],a[4*l+3]=c[3]}r.putImageData(s,0,0),e.setImage(n)},function(){e.setState(3)})}},ol.ext.getPixelFromElevation=function(t){var e=Math.round(100*t+12e5);return[e>>16,e%65536>>8,e%256,255]},ol.ext.getElevationFromPixel=function(t){return.01*((t[0]<<16)+(t[1]<<8)+t[2])-12e3},ol.matrix3D={},ol.matrix3D.getTransform=function(t){var e,o,i=window.getComputedStyle(t,null),n=(i.getPropertyValue("-webkit-transform")||i.getPropertyValue("-moz-transform")||i.getPropertyValue("-ms-transform")||i.getPropertyValue("-o-transform")||i.getPropertyValue("transform")).split("(")[1].split(")")[0].split(","),r=[[1,0,0,0],[0,1,0,0],[0,0,1,0],[0,0,0,1]];if(16===n.length)for(e=0;e<4;++e)for(o=0;o<4;++o)r[o][e]=+n[4*e+o];else for(e=0;e<3;++e)for(o=0;o<2;++o)r[o][e]=+n[2*e+o];return r},ol.matrix3D.getTransformOrigin=function(t){for(var e=window.getComputedStyle(t,null),o=(e.getPropertyValue("-webkit-transform-origin")||e.getPropertyValue("-moz-transform-origin")||e.getPropertyValue("-ms-transform-origin")||e.getPropertyValue("-o-transform-origin")||e.getPropertyValue("transform-origin")).split(" "),i=[0,0,0,1],n=0;n<o.length;++n)i[n]=parseInt(o[n]);return i},ol.matrix3D.translateMatrix=function(t,e,o){return[[1,0,0,t],[0,1,0,e],[0,0,1,o],[0,0,0,1]]},ol.matrix3D.identity=function(){return[[1,0,0,0],[0,1,0,0],[0,0,1,0],[0,0,0,1]]},ol.matrix3D.roundTo=function(t,e){e||(e=1e-10);for(var o=[[],[],[],[]],i=0;i<4;i++)for(var n=0;n<4;n++)o[i][n]=Math.round(t[i][n]/e)*e;return o},ol.matrix3D.multiply=function(t,e){for(var o=[[],[],[],[]],i=0;i<4;++i)for(var n=0;n<4;++n){for(var r=0,s=0;s<4;++s)r+=t[s][i]*e[n][s];o[n][i]=r}return o},ol.matrix3D.computeTransformMatrix=function(t,e){var o=ol.matrix3D.translateMatrix(-e[0],-e[1],-e[2]),i=ol.matrix3D.translateMatrix(e[0],e[1],e[2]),n=ol.matrix3D.multiply(o,t);return ol.matrix3D.multiply(n,i)},ol.matrix3D.transformVertex=function(t,e){for(var o=[e[0],e[1],0,1],i=[],n=0;n<4;++n){i[n]=0;for(var r=0;r<4;++r)i[n]+=+t[n][r]*o[r]}return i},ol.matrix3D.projectVertex=function(t){for(var e=[],o=0;o<4;++o)e[o]=t[o]/t[3];return e},ol.matrix3D.inverse=function(t){var e=t[0][0]*t[1][1]-t[1][0]*t[0][1],o=t[0][0]*t[1][2]-t[1][0]*t[0][2],i=t[0][0]*t[1][3]-t[1][0]*t[0][3],n=t[0][1]*t[1][2]-t[1][1]*t[0][2],r=t[0][1]*t[1][3]-t[1][1]*t[0][3],s=t[0][2]*t[1][3]-t[1][2]*t[0][3],a=t[2][2]*t[3][3]-t[3][2]*t[2][3],l=t[2][1]*t[3][3]-t[3][1]*t[2][3],c=t[2][1]*t[3][2]-t[3][1]*t[2][2],h=t[2][0]*t[3][3]-t[3][0]*t[2][3],p=t[2][0]*t[3][2]-t[3][0]*t[2][2],u=t[2][0]*t[3][1]-t[3][0]*t[2][1],g=1/(e*a-o*l+i*c+n*h-r*p+s*u);if(isNaN(g)||g===1/0)throw new Error("Inverse determinant attempted to divide by zero.");return[[(t[1][1]*a-t[1][2]*l+t[1][3]*c)*g,(-t[0][1]*a+t[0][2]*l-t[0][3]*c)*g,(t[3][1]*s-t[3][2]*r+t[3][3]*n)*g,(-t[2][1]*s+t[2][2]*r-t[2][3]*n)*g],[(-t[1][0]*a+t[1][2]*h-t[1][3]*p)*g,(t[0][0]*a-t[0][2]*h+t[0][3]*p)*g,(-t[3][0]*s+t[3][2]*i-t[3][3]*o)*g,(t[2][0]*s-t[2][2]*i+t[2][3]*o)*g],[(t[1][0]*l-t[1][1]*h+t[1][3]*u)*g,(-t[0][0]*l+t[0][1]*h-t[0][3]*u)*g,(t[3][0]*r-t[3][1]*i+t[3][3]*e)*g,(-t[2][0]*r+t[2][1]*i-t[2][3]*e)*g],[(-t[1][0]*c+t[1][1]*p-t[1][2]*u)*g,(t[0][0]*c-t[0][1]*p+t[0][2]*u)*g,(-t[3][0]*n+t[3][1]*o-t[3][2]*e)*g,(t[2][0]*n-t[2][1]*o+t[2][2]*e)*g]]},window.ol&&!ol.sphere&&(ol.sphere={},ol.sphere.getDistance=function(t,e,o){return new ol.Sphere(o||6371008.8).haversineDistance(t,e)},ol.sphere.getArea=ol.Sphere.getArea,ol.sphere.getLength=ol.Sphere.getLength),ol.ext.SVGFilter.Laplacian=function(t){t=t||{},ol.ext.SVGFilter.call(this,{id:t.id});var e={feoperation:"feConvolveMatrix",in:"SourceGraphic",preserveAlpha:!0,result:"C1"};4===t.neighbours?e.kernelMatrix=[0,-1,0,-1,4,-1,0,-1,0]:e.kernelMatrix=[-1,-1,-1,-1,8,-1,-1,-1,-1],this.addOperation(e),t.grayscale?this.grayscale():t.alpha&&this.luminanceToAlpha({gamma:t.gamma})},ol.ext.inherits(ol.ext.SVGFilter.Laplacian,ol.ext.SVGFilter),ol.ext.SVGFilter.Paper=function(t){t=t||{},ol.ext.SVGFilter.call(this,{id:t.id}),this.addOperation({feoperation:"feTurbulence",numOctaves:4,seed:0,type:"fractalNoise",baseFrequency:.2/(t.scale||1)}),this.addOperation({feoperation:"feDiffuseLighting","lighting-color":"rgb(255,255,255)",surfaceScale:1.5,kernelUnitLength:.01,diffuseConstant:1.1,result:"paper",operations:[{feoperation:"feDistantLight",elevation:t.light||50,azimuth:75}]}),this.addOperation({feoperation:"feBlend",in:"SourceGraphic",in2:"paper",mode:"multiply"})},ol.ext.inherits(ol.ext.SVGFilter.Paper,ol.ext.SVGFilter),ol.ext.SVGFilter.Paper.prototype.setLight=function(t){this.element.querySelector("feDistantLight").setAttribute("elevation",t)},ol.ext.SVGFilter.Prewitt=function(t){t=t||{},ol.ext.SVGFilter.call(this,{id:t.id,color:"sRGB"});var e={feoperation:"feConvolveMatrix",in:"SourceGraphic",preserveAlpha:!0,order:3,kernelMatrix:[-1,-1,-1,0,0,0,1,1,1],result:"V1"};this.addOperation(e),e.kernelMatrix=[1,1,1,0,0,0,-1,-1,-1],e.result="V2",this.addOperation(e),e.kernelMatrix=[-1,0,1,-1,0,1,-1,0,1],e.result="H1",this.addOperation(e),e.kernelMatrix=[1,-0,-1,1,0,-1,1,0,-1],e.result="H2",this.addOperation(e),this.addOperation({feoperation:"feComposite",operator:"arithmetic",in:"V1",in2:"V2",k2:1,k3:1,result:"V"}),this.addOperation({feoperation:"feComposite",operator:"arithmetic",in:"H1",in2:"H2",k2:1,k3:1,result:"H"}),this.addOperation({feoperation:"feBlend",mode:"lighten",in:"H",in2:"V"}),t.grayscale?this.grayscale():t.alpha&&this.luminanceToAlpha()},ol.ext.inherits(ol.ext.SVGFilter.Prewitt,ol.ext.SVGFilter),ol.ext.SVGFilter.Roberts=function(t){t=t||{},ol.ext.SVGFilter.call(this,{id:t.id,color:"sRGB"});var e={feoperation:"feConvolveMatrix",in:"SourceGraphic",preserveAlpha:!0,order:3,kernelMatrix:[-1,0,0,0,0,0,0,0,1],result:"V1"};this.addOperation(e),e.kernelMatrix=[1,0,0,0,0,0,0,0,-1],e.result="V2",this.addOperation(e),e.kernelMatrix=[0,0,1,0,0,0,-1,0,0],e.result="H1",this.addOperation(e),e.kernelMatrix=[0,-0,-1,0,0,0,1,0,0],e.result="H2",this.addOperation(e),this.addOperation({feoperation:"feComposite",operator:"arithmetic",in:"V1",in2:"V2",k2:1,k3:1,result:"V"}),this.addOperation({feoperation:"feComposite",operator:"arithmetic",in:"H1",in2:"H2",k2:1,k3:1,result:"H"}),this.addOperation({feoperation:"feBlend",mode:"lighten",in:"H",in2:"V"}),t.grayscale?this.grayscale():t.alpha&&this.luminanceToAlpha()},ol.ext.inherits(ol.ext.SVGFilter.Roberts,ol.ext.SVGFilter),ol.ext.SVGFilter.Sobel=function(t){t=t||{},ol.ext.SVGFilter.call(this,{id:t.id,color:"sRGB"});var e={feoperation:"feConvolveMatrix",in:"SourceGraphic",preserveAlpha:!0,order:3,kernelMatrix:[-1,-2,-1,0,0,0,1,2,1],result:"V1"};this.addOperation(e),e.kernelMatrix=[1,2,1,0,0,0,-1,-2,-1],e.result="V2",this.addOperation(e),e.kernelMatrix=[-1,0,1,-2,0,2,-1,0,1],e.result="H1",this.addOperation(e),e.kernelMatrix=[1,-0,-1,2,0,-2,1,0,-1],e.result="H2",this.addOperation(e),this.addOperation({feoperation:"feComposite",operator:"arithmetic",in:"V1",in2:"V2",k2:1,k3:1,result:"V"}),this.addOperation({feoperation:"feComposite",operator:"arithmetic",in:"H1",in2:"H2",k2:1,k3:1,result:"H"}),this.addOperation({feoperation:"feBlend",mode:"lighten",in:"H",in2:"V"}),t.grayscale?this.grayscale():t.alpha&&this.luminanceToAlpha({gamma:t.gamma})},ol.ext.inherits(ol.ext.SVGFilter.Sobel,ol.ext.SVGFilter),window.ol&&(ol.ext.input={}),ol.ext.input.Base=function(t){t=t||{},ol.Object.call(this);var e,o=this.input=t.input;o||(o=this.input=document.createElement("INPUT"),t.type&&o.setAttribute("type",t.type),void 0!==t.min&&o.setAttribute("min",t.min),void 0!==t.max&&o.setAttribute("max",t.max),void 0!==t.step&&o.setAttribute("step",t.step),t.parent&&t.parent.appendChild(o)),t.disabled&&(o.disabled=!0),void 0!==t.checked&&(o.checked=!!t.checked),void 0!==t.val&&(o.value=t.val),t.hidden&&(o.style.display="none"),o.addEventListener("focus",function(){this.element&&this.element.classList.add("ol-focus")}.bind(this)),o.addEventListener("focusout",function(){this.element&&(e&&clearTimeout(e),e=setTimeout(function(){this.element.classList.remove("ol-focus")}.bind(this),0))}.bind(this))},ol.ext.inherits(ol.ext.input.Base,ol.Object),ol.ext.input.Base.prototype._listenDrag=function(t,e){var o=function(o){this.moving=!0,this.element.classList.add("ol-moving");var i=function(o){"pointerup"===o.type&&(document.removeEventListener("pointermove",i),document.removeEventListener("pointerup",i),document.removeEventListener("pointercancel",i),setTimeout(function(){this.moving=!1,this.element.classList.remove("ol-moving")}.bind(this))),o.target===t&&e(o),o.stopPropagation(),o.preventDefault()}.bind(this);document.addEventListener("pointermove",i,!1),document.addEventListener("pointerup",i,!1),document.addEventListener("pointercancel",i,!1),o.stopPropagation(),o.preventDefault()}.bind(this);t.addEventListener("mousedown",o,!1),t.addEventListener("touchstart",o,!1)},ol.ext.input.Base.prototype.setValue=function(t){void 0!==t&&(this.input.value=t),this.input.dispatchEvent(new Event("change"))},ol.ext.input.Base.prototype.getValue=function(){return this.input.value},ol.ext.input.Base.prototype.getInputElement=function(){return this.input},ol.ext.input.Slider=function(t){t=t||{},ol.ext.input.Base.call(this,t),this.set("overflow",!!t.overflow),this.element=ol.ext.element.create("DIV",{className:"ol-input-slider"+(!1!==t.hover?" ol-hover":"")+(t.type?" ol-"+t.type:"")+(t.className?" "+t.className:"")}),t.fixed&&this.element.classList.add("ol-fixed");var e=this.input;e.parentNode&&e.parentNode.insertBefore(this.element,e),this.element.appendChild(e),"right"===t.align&&this.element.classList.add("ol-right");var o=ol.ext.element.create("DIV",{className:"ol-popup",parent:this.element});t.before&&ol.ext.element.create("DIV",{className:"ol-before",html:t.before,parent:o});var i=this.slider=ol.ext.element.create("DIV",{className:"ol-slider",parent:o});ol.ext.element.create("DIV",{className:"ol-back",parent:this.slider});var n=ol.ext.element.create("DIV",{className:"ol-cursor",parent:i});t.after&&ol.ext.element.create("DIV",{className:"ol-after",html:t.after,parent:o});var r=void 0!==t.min?t.min:parseFloat(e.min)||0,s=void 0!==t.max?t.max:parseFloat(e.max)||1,a=1/(void 0!==t.step?t.step:parseFloat(e.step)||1);this._listenDrag(i,function(t){var o=Math.max(0,Math.min(t.offsetX/i.clientWidth,1));n.style.left=Math.max(0,Math.min(100,Math.round(100*o)))+"%";var l=e.value=Math.round((o*(s-r)+r)*a)/a;this.dispatchEvent({type:"change:value",value:l})}.bind(this));var l=function(){var t=parseFloat(e.value)||0;this.get("overflow")||(t=Math.max(r,Math.min(s,t))),t!=e.value&&(e.value=t);var o=(t-r)/(s-r);n.style.left=Math.max(0,Math.min(100,Math.round(100*o)))+"%",this.dispatchEvent({type:"change:value",value:t})}.bind(this);e.addEventListener("change",l),l()},ol.ext.inherits(ol.ext.input.Slider,ol.ext.input.Base),ol.ext.input.PopupBase=function(t){switch((t=t||{}).hidden=!1!==t.hidden,ol.ext.input.Base.call(this,t),this.set("autoClose",!1!==t.autoClose),this.element=ol.ext.element.create("DIV",{className:("ol-ext-popup-input "+(t.className||"")).trim()}),t.position){case"inline":break;case"static":case"fixed":this.element.classList.add("ol-popup"),this.element.classList.add("ol-popup-fixed"),this._fixed="fixed"===t.position;break;default:this.element.classList.add("ol-popup")}var e=this.input;e.parentNode&&e.parentNode.insertBefore(this.element,e),this.element.addEventListener("click",function(){this.isCollapsed()&&setTimeout(function(){this.collapse(!1)}.bind(this))}.bind(this)),this._elt={},this._elt.popup=ol.ext.element.create("DIV",{className:"ol-popup",parent:this.element}),this._elt.popup.addEventListener("click",function(t){t.stopPropagation()});var o=!1;this._elt.popup.addEventListener("pointerdown",function(){o=!0}),this._elt.popup.addEventListener("click",function(){o=!1}),document.addEventListener("click",function(){this.moving||o||this.collapse(!0),o=!1}.bind(this)),window.addEventListener("resize",function(){this.collapse(!0)}.bind(this))},ol.ext.inherits(ol.ext.input.PopupBase,ol.ext.input.Base),ol.ext.input.PopupBase.prototype.collapse=function(t){if(t!=this.isCollapsed()&&this.dispatchEvent({type:"change:visible",visible:!this.isCollapsed()}),this.dispatchEvent({type:"collapse",visible:!t}),t)this._elt.popup.classList.remove("ol-visible");else if(this._elt.popup.classList.add("ol-visible"),this._fixed){var e=this.element.getBoundingClientRect(),o=ol.ext.element.getFixedOffset(this.element);(e={bottom:e.bottom-o.top,left:e.left-o.left}).bottom+this._elt.popup.offsetHeight+o.top>document.documentElement.clientHeight?this._elt.popup.style.top=Math.max(document.documentElement.clientHeight-this._elt.popup.offsetHeight-o.top,0)+"px":this._elt.popup.style.top=e.bottom+"px",e.left+this._elt.popup.offsetWidth+o.left>document.documentElement.clientWidth?this._elt.popup.style.left=Math.max(document.documentElement.clientWidth-this._elt.popup.offsetWidth-o.left,0)+"px":this._elt.popup.style.left=e.left+"px"}},ol.ext.input.PopupBase.prototype.isCollapsed=function(){return!this._elt.popup.classList.contains("ol-visible")},ol.ext.input.PopupBase.prototype.toggle=function(){this.collapse(!this.isCollapsed())},ol.ext.input.Checkbox=function(t){t=t||{},ol.ext.input.Base.call(this,t);var e=this.element=document.createElement("LABEL");t.html instanceof Element?e.appendChild(t.html):void 0!==t.html&&(e.innerHTML=t.html),e.className=("ol-ext-check ol-ext-checkbox "+(t.className||"")).trim(),this.input.parentNode&&this.input.parentNode.insertBefore(e,this.input),e.appendChild(this.input),e.appendChild(document.createElement("SPAN")),t.after&&e.appendChild(document.createTextNode(t.after)),this.input.addEventListener("change",function(){this.dispatchEvent({type:"check",checked:this.input.checked,value:this.input.value})}.bind(this))},ol.ext.inherits(ol.ext.input.Checkbox,ol.ext.input.Base),ol.ext.input.Checkbox.prototype.isChecked=function(){return this.input.checked},ol.ext.input.Collection=function(t){ol.Object.call(this),this.element=ol.ext.element.create("UL",{className:("ol-collection-list "+(t.className||"")).trim(),parent:t.target}),this.collection=t.collection,this._title="function"==typeof t.getTitle?t.getTitle:function(t){return t.title},this.refresh(),this.collection.on("change:length",function(){if(!this._reorder){this.refresh();var t=this.getSelectPosition();t<0?this.dispatchEvent({type:"item:select",position:-1,item:null}):this.dispatchEvent({type:"item:order",position:t,item:this._currentItem})}}.bind(this))},ol.ext.inherits(ol.ext.input.Collection,ol.Object),ol.ext.input.Collection.prototype.select=function(t){if(t!==this._currentItem){var e=-1;this._listElt.forEach(function(o,i){o.item!==t?o.li.classList.remove("ol-select"):(o.li.classList.add("ol-select"),e=i)}),this._currentItem=e>=0?t:null,this.dispatchEvent({type:"item:select",position:e,item:this._currentItem})}},ol.ext.input.Collection.prototype.selectAt=function(t){this.select(this.collection.item(t))},ol.ext.input.Collection.prototype.getSelect=function(){return this._currentItem},ol.ext.input.Collection.prototype.getSelectPosition=function(){return this.collection.getArray().indexOf(this._currentItem)},ol.ext.input.Collection.prototype.refresh=function(){this.element.innerHTML="",this._listElt=[],this.collection.forEach((t,e)=>{var o=ol.ext.element.create("LI",{html:this._title(t),className:this._currentItem===t?"ol-select":"","data-position":e,on:{click:function(){this.select(t)}.bind(this),dblclick:function(){this.dispatchEvent({type:"item:dblclick",position:e,item:t})}.bind(this)},parent:this.element});this._listElt.push({li:o,item:t});var i=ol.ext.element.create("DIV",{className:"ol-noscroll ol-order",parent:o}),n=e,r=function(t){for(var e="touch"===t.pointerType?document.elementFromPoint(t.clientX,t.clientY):t.target;e&&e.parentNode!==this.element;)e=e.parentNode;if(e&&e!==o){var i=parseInt(e.getAttribute("data-position"));e.getAttribute("data-position")<n?(e.insertAdjacentElement("beforebegin",o),n=i):(e.insertAdjacentElement("afterend",o),n=i+1)}}.bind(this),s=function(){document.removeEventListener("pointermove",r),document.removeEventListener("pointerup",s),document.removeEventListener("pointercancel",s),n!==e&&(this._reorder=!0,this.collection.removeAt(e),this.collection.insertAt(n>e?n-1:n,t),this._reorder=!1,this.dispatchEvent({type:"item:order",position:n>e?n-1:n,oldPosition:e,item:t}),this.refresh())}.bind(this);i.addEventListener("pointerdown",function(){this.select(t),document.addEventListener("pointermove",r),document.addEventListener("pointerup",s),document.addEventListener("pointercancel",s)}.bind(this))})},ol.ext.input.Color=function(t){(t=t||{}).hidden=!1!==t.hidden,t.className=("ol-ext-colorpicker "+(t.hastab?"ol-tab ":"")+(t.className||"")).trim(),ol.ext.input.PopupBase.call(this,t),!1===t.opacity&&this.element.classList.add("ol-nopacity"),this._cursor={};var e=this._hsv={};this._elt.vignet=ol.ext.element.create("DIV",{className:"ol-vignet",parent:this.element});var o=ol.ext.element.create("DIV",{className:"ol-tabbar",parent:this._elt.popup});ol.ext.element.create("DIV",{className:"ol-tab",html:t.paletteLabel||"palette",click:function(){this.element.classList.remove("ol-picker-tab")}.bind(this),parent:o}),ol.ext.element.create("DIV",{className:"ol-tab",html:t.pickerLabel||"picker",click:function(){this.element.classList.add("ol-picker-tab")}.bind(this),parent:o});var i=ol.ext.element.create("DIV",{className:"ol-container",parent:this._elt.popup}),n=this._elt.picker=ol.ext.element.create("DIV",{className:"ol-picker",parent:i}),r=this._cursor.picker=ol.ext.element.create("DIV",{className:"ol-cursor",parent:n});this._listenDrag(n,function(t){var o=Math.max(0,Math.min(t.offsetX/n.clientWidth,1)),i=Math.max(0,Math.min(t.offsetY/n.clientHeight,1));r.style.left=Math.round(100*o)+"%",r.style.top=Math.round(100*i)+"%",e.s=100*o,e.v=100-100*i,this.setColor()}.bind(this));var s=ol.ext.element.create("DIV",{className:"ol-slider",parent:i});this._elt.slider=ol.ext.element.create("DIV",{parent:s});var a=this._cursor.slide=ol.ext.element.create("DIV",{className:"ol-cursor",parent:s});this._listenDrag(s,function(t){var o=Math.max(0,Math.min(t.offsetX/s.clientWidth,1));e.a=100*o,a.style.left=Math.round(100*o)+"%",this.setColor()}.bind(this));var l=ol.ext.element.create("DIV",{className:"ol-tint",parent:i}),c=this._cursor.tint=ol.ext.element.create("DIV",{className:"ol-cursor",parent:l});this._listenDrag(l,function(t){var o=Math.max(0,Math.min(t.offsetY/l.clientHeight,1));e.h=360*o,c.style.top=Math.round(100*o)+"%",this.setColor()}.bind(this)),ol.ext.element.create("DIV",{className:"ol-clear",click:function(){this.setColor([0,0,0,0])}.bind(this),parent:i});var h,p=ol.ext.element.create("DIV",{className:"ol-rgb",parent:i}),u=function(){var t=Math.max(0,Math.min(255,parseInt(this._elt.r.value))),e=Math.max(0,Math.min(255,parseInt(this._elt.g.value))),o=Math.max(0,Math.min(255,parseInt(this._elt.b.value))),i=Math.max(0,Math.min(1,parseFloat(this._elt.a.value)));this.setColor([t,e,o,i])}.bind(this);for(this._elt.r=ol.ext.element.create("INPUT",{type:"number",lang:"en-GB",change:u,min:0,max:255,parent:p}),this._elt.g=ol.ext.element.create("INPUT",{type:"number",lang:"en-GB",change:u,min:0,max:255,parent:p}),this._elt.b=ol.ext.element.create("INPUT",{type:"number",lang:"en-GB",change:u,min:0,max:255,parent:p}),this._elt.a=ol.ext.element.create("INPUT",{type:"number",lang:"en-GB",change:u,min:0,max:1,step:.1,parent:p}),this._elt.txtColor=ol.ext.element.create("INPUT",{type:"text",className:"ol-txt-color",change:function(){var t;this._elt.txtColor.classList.remove("ol-error");try{t=ol.color.asArray(this._elt.txtColor.value)}catch(t){this._elt.txtColor.classList.add("ol-error")}t&&this.setColor(t)}.bind(this),parent:i}),ol.ext.element.create("BUTTON",{html:"OK",click:function(){this._addCustomColor(this.getColor()),this.collapse(!0)}.bind(this),parent:i}),this._paletteColor={},this._elt.palette=ol.ext.element.create("DIV",{className:"ol-palette",parent:this._elt.popup}),h=0;h<8;h++){var g=Math.round(255-255*h/7);this.addPaletteColor([g,g,g],g)}var d=["#f00","#f90","#ff0","#0f0","#0ff","#48e","#00f","#f0f"];for(d.forEach(function(t){this.addPaletteColor(t,ol.color.toHexa(ol.color.asArray(t)))}.bind(this)),h=0;h<5;h++)d.forEach(function(t){t=[(t=ol.color.toHSV(ol.color.asArray(t)))[0],h/4*80+20,100-h/4*60],t=ol.color.fromHSV(t,1),this.addPaletteColor(t,ol.color.toHexa(t))}.bind(this));(ol.ext.element.create("HR",{parent:this._elt.palette}),ol.ext.input.Color.customColorList)||(ol.ext.input.Color.customColorList=new ol.Collection,JSON.parse(localStorage.getItem("ol-ext@colorpicker")||"[]").forEach(function(t){ol.ext.input.Color.customColorList.push(t)}),ol.ext.input.Color.customColorList.on(["add","remove"],function(){localStorage.setItem("ol-ext@colorpicker",JSON.stringify(ol.ext.input.Color.customColorList.getArray()))}));ol.ext.input.Color.customColorList.on("add",function(t){this.addPaletteColor(this.getColorFromID(t.element))}.bind(this)),ol.ext.input.Color.customColorList.on("remove",function(t){this._paletteColor[t.element]&&this._paletteColor[t.element].element.remove(),delete this._paletteColor[t.element]}.bind(this)),ol.ext.input.Color.customColorList.forEach(function(t){this._addCustomColor(this.getColorFromID(t))}.bind(this)),this.setColor(t.color||[0,0,0,0]),this._currentColor=this.getColorID(this.getColor()),this.on("color",function(){this._addCustomColor(this.getColor()),this._currentColor=this.getColorID(this.getColor()),this.setColor()}.bind(this)),this.on("collapse",function(t){if(t.visible)this._currentColor=this.getColorID(this.getColor());else{var e=this.getColor();this._currentColor!==this.getColorID(e)&&this.dispatchEvent({type:"color",color:e})}}.bind(this))},ol.ext.inherits(ol.ext.input.Color,ol.ext.input.PopupBase),ol.ext.input.Color.customColorList=null,ol.ext.input.Color.prototype.addPaletteColor=function(t,e,o){try{t=ol.color.asArray(t)}catch(t){return}var i=this.getColorID(t);!this._paletteColor[i]&&t[3]&&(this._paletteColor[i]={color:t,element:ol.ext.element.create("DIV",{title:e||"",className:t[3]<1?"ol-alpha":"",style:{color:"rgb("+t.join(",")+")"},click:function(){this.setColor(t),this.get("autoClose")&&this.collapse(!0)}.bind(this),parent:this._elt.palette})}),o&&this._selectPalette(t)},ol.ext.input.Color.prototype.showTab=function(t){"palette"===t?this.element.classList.remove("ol-picker-tab"):this.element.classList.add("ol-picker-tab")},ol.ext.input.Color.prototype.getTab=function(){return this.element.classList.contains("ol-picker-tab")?"picker":"palette"},ol.ext.input.Color.prototype._selectPalette=function(t){var e=this.getColorID(t);Object.keys(this._paletteColor).forEach(function(t){this._paletteColor[t].element.classList.remove("ol-select")}.bind(this)),this._paletteColor[e]&&this._paletteColor[e].element.classList.add("ol-select")},ol.ext.input.Color.prototype.setColor=function(t){var e=this._hsv;if(t){t=ol.color.asArray(t);var o=ol.color.toHSV(t);e.h=o[0],e.s=o[1],e.v=o[2],o.length>3?e.a=100*o[3]:e.a=100,this._cursor.picker.style.left=e.s+"%",this._cursor.picker.style.top=100-e.v+"%",this._cursor.tint.style.top=e.h/360*100+"%",this._cursor.slide.style.left=e.a+"%",this.isCollapsed()&&this.dispatchEvent({type:"color",color:t})}else e.a=Math.round(e.a),t=this.getColor();var i="rgba("+t.join(", ")+")";this._elt.picker.style.color="hsl("+e.h+", 100%, 50%)",this._elt.slider.style.backgroundImage="linear-gradient(45deg, transparent, rgba("+this.getColor(!1).join(",")+"))",this._elt.vignet.style.color=i,this._elt.r.value=t[0],this._elt.g.value=t[1],this._elt.b.value=t[2],this._elt.a.value=t[3],this._elt.txtColor.classList.remove("ol-error"),1===t[3]?this._elt.txtColor.value=ol.color.toHexa(t):this._elt.txtColor.value=i,this._selectPalette(t),this.input.value!==i&&(this.input.value=i,this.input.dispatchEvent(new Event("change")))},ol.ext.input.Color.prototype.getColor=function(t){return ol.color.fromHSV([this._hsv.h,this._hsv.s,this._hsv.v,!1!==t?this._hsv.a/100:1],1)},ol.ext.input.Color.prototype._addCustomColor=function(t){var e=this.getColorID(t);this._paletteColor[e]||t[3]&&(ol.ext.input.Color.customColorList.getArray().indexOf(e)<0&&(ol.ext.input.Color.customColorList.push(e),ol.ext.input.Color.customColorList.getLength()>24&&ol.ext.input.Color.customColorList.removeAt(0)),this.addPaletteColor(t))},ol.ext.input.Color.prototype.clearCustomColor=function(){ol.ext.input.Color.customColorList.clear()},ol.ext.input.Color.prototype.getColorID=function(t){return void 0===(t=ol.color.asArray(t))[3]&&(t[3]=1),t.join("-")},ol.ext.input.Color.prototype.getColorFromID=function(t){var e=t.split("-");return[parseFloat(e[0]),parseFloat(e[1]),parseFloat(e[2]),parseFloat(e[3])]},ol.ext.input.List=function(t){switch(t=t||{},ol.ext.input.Base.call(this,t),this._content=ol.ext.element.create("DIV"),(t.hidden||t.disabled)&&(t.hover=!0),this.element=ol.ext.element.create("DIV",{html:this._content,className:"ol-input-popup"+(t.hover?" ol-hover":"")}),this.set("hideOnClick",!1!==t.hideOnClick),t.className&&this.element.classList.add(t.className),t.fixed&&(this.element.classList.add("ol-fixed"),this.set("hideOnClick",!1)),t.align){case"middle":this.set("hideOnClick",!1);case"rigth":this.element.classList.add("ol-"+t.align)}var e=this.input;e.parentNode&&e.parentNode.insertBefore(this.element,e),this.element.appendChild(e);var o=this.popup=ol.ext.element.create("UL",{className:"ol-popup",parent:this.element}),i=[];t.options.forEach(t=>{i.push({value:t.value,element:ol.ext.element.create("LI",{html:t.html,title:t.title||t.value,className:"ol-option",on:{pointerdown:function(){this.setValue(t.value),this.get("hideOnClick")&&(o.style.display="none",setTimeout(function(){o.style.display=""},200))}.bind(this)},parent:this.popup})})}),this.input.addEventListener("change",function(){var t,e=this.input.value;i.forEach(function(o){o.value==e?(o.element.classList.add("ol-selected"),t=o.element):o.element.classList.remove("ol-selected")}),this.dispatchEvent({type:"change:value",value:this.getValue()}),this._content.innerHTML=t?t.innerHTML:""}.bind(this));var n=new Event("change");setTimeout(function(){this.input.dispatchEvent(n)}.bind(this))},ol.ext.inherits(ol.ext.input.List,ol.ext.input.Base),ol.ext.input.Radio=function(t){t=t||{},ol.ext.input.Checkbox.call(this,t),this.element.className=("ol-ext-check ol-ext-radio "+(t.className||"")).trim()},ol.ext.inherits(ol.ext.input.Radio,ol.ext.input.Checkbox),ol.ext.input.Range=function(t){t=t||{},ol.ext.input.Base.call(this,t),this.set("overflow",!!t.overflow),this.element=ol.ext.element.create("DIV",{className:"ol-input-slider ol-input-range"+(t.className?" "+t.className:"")});var e=this.input;e.parentNode&&e.parentNode.insertBefore(this.element,e),this.element.appendChild(e);var o=this.slider=ol.ext.element.create("DIV",{className:"ol-slider",parent:this.element}),i=ol.ext.element.create("DIV",{className:"ol-back",parent:this.slider}),n=this.input2=t.input2;n&&this.element.appendChild(n);var r=ol.ext.element.create("DIV",{className:"ol-cursor",parent:o}),s=ol.ext.element.create("DIV",{className:"ol-cursor",parent:n?o:void 0}),a=r;function l(t){a=t.target}r.addEventListener("mousedown",l,!1),r.addEventListener("touchstart",l,!1),s.addEventListener("mousedown",l,!1),s.addEventListener("touchstart",l,!1);var c=void 0!==t.min?t.min:parseFloat(e.min)||0,h=void 0!==t.max?t.max:parseFloat(e.max)||1,p=1/(void 0!==t.step?t.step:parseFloat(e.step)||1);function u(){if(n){var t=parseFloat(r.style.left)||0,e=parseFloat(s.style.left)||0;i.style.left=Math.min(t,e)+"%",i.style.right=100-Math.max(t,e)+"%"}else i.style.left=0,i.style.right=(100-parseFloat(r.style.left)||0)+"%"}function g(){if(n&&parseFloat(e.value)>parseFloat(n.value)){var t=e.value;e.value=n.value,n.value=t,d({target:e}),n&&d({target:n})}}this._listenDrag(o,function(t){var i=a===r?e:n,s=Math.max(0,Math.min(t.offsetX/o.clientWidth,1));a.style.left=Math.max(0,Math.min(100,Math.round(100*s)))+"%";var l=i.value=Math.round((s*(h-c)+c)*p)/p;u(),this.dispatchEvent({type:"change:value",value:l}),"pointerup"===t.type&&g()}.bind(this));var d=function(t){var o=t.target,i=o===e?r:s,n=parseFloat(o.value)||0;this.get("overflow")||(n=Math.max(c,Math.min(h,n))),n!=o.value&&(o.value=n);var a=(n-c)/(h-c);i.style.left=Math.max(0,Math.min(100,Math.round(100*a)))+"%",u(),this.dispatchEvent({type:"change:value",value:n}),g()}.bind(this);e.addEventListener("change",d),n&&n.addEventListener("change",d),d({target:e}),n&&d({target:n})},ol.ext.inherits(ol.ext.input.Range,ol.ext.input.Base),ol.ext.input.Range.prototype.setValue2=function(t){this.input2&&(void 0!==t&&(this.input2.value=t),this.input2.dispatchEvent(new Event("change")))},ol.ext.input.Range.prototype.getValue2=function(){return this.input2?this.input2.value:null},ol.ext.input.Range.prototype.getMin=function(){return parseFloat(this.getValue())},ol.ext.input.Range.prototype.getMax=function(){return parseFloat(this.getValue2())},ol.ext.input.Size=function(t){(t=t||{}).options=[],(t.size||[0,2,3,5,8,13,21,34,55]).forEach(function(e){t.options.push({value:e,html:ol.ext.element.create("DIV",{className:"ol-option-"+e,style:{fontSize:e?e+"px":void 0}})})}),ol.ext.input.List.call(this,t),this._content.remove(),this.element.classList.add("ol-size")},ol.ext.inherits(ol.ext.input.Size,ol.ext.input.List),ol.ext.input.Size.prototype.getValue=function(){return parseFloat(ol.ext.input.List.prototype.getValue.call(this))},ol.ext.input.Switch=function(t){t=t||{},ol.ext.input.Checkbox.call(this,t),this.element.className=("ol-ext-toggle-switch "+(t.className||"")).trim()},ol.ext.inherits(ol.ext.input.Switch,ol.ext.input.Checkbox),ol.ext.input.Width=function(t){(t=t||{}).options=[],(t.size||[0,1,2,3,5,10,15,20]).forEach(function(e){t.options.push({value:e,html:ol.ext.element.create("DIV",{className:"ol-option-"+e,style:{height:e||void 0}})})}),ol.ext.input.List.call(this,t),this._content.remove(),this.element.classList.add("ol-width")},ol.ext.inherits(ol.ext.input.Width,ol.ext.input.List),ol.ext.input.Width.prototype.getValue=function(){return parseFloat(ol.ext.input.List.prototype.getValue.call(this))},window.ol&&!ol.legend&&(ol.legend={}),ol.legend.Legend=function(t){t=t||{},ol.Object.call(this),this._items=new ol.Collection;var e,o=[];this._items.on("add",function(t){o.push({item:t.element,on:t.element.on("change",function(){this.refresh()}.bind(this))}),e&&(clearTimeout(e),e=null),e=setTimeout(function(){this.refresh()}.bind(this),0)}.bind(this)),this._items.on("remove",function(t){for(var i=0;i<o;i++)if(t.element===o[i].item){ol.Observable.unByKey(o[i].on),o.splice(i,1);break}e&&(clearTimeout(e),e=null),e=setTimeout(function(){this.refresh()}.bind(this),0)}.bind(this)),this._listElement=ol.ext.element.create("UL",{className:"ol-legend"}),this._canvas=document.createElement("canvas"),this.set("size",t.size||[40,25],!0),this.set("margin",0===t.margin?0:t.margin||10,!0),this._textStyle=t.textStyle||new ol.style.Text({font:"16px sans-serif",fill:new ol.style.Fill({color:"#333"}),backgroundFill:new ol.style.Fill({color:"rgba(255,255,255,.8)"})}),this._title=new ol.legend.Item({title:t.title||"",className:"ol-title"}),t.titleStyle?this._titleStyle=t.titleStyle:(this._titleStyle=this._textStyle.clone(),this._titleStyle.setFont("bold "+this._titleStyle.getFont())),this.setStyle(t.style),t.items instanceof Array&&t.items.forEach(function(t){this.addItem(t)}.bind(this)),this.refresh()},ol.ext.inherits(ol.legend.Legend,ol.Object),ol.legend.Legend.prototype.setTitle=function(t){this._title.setTitle(t),this.refresh()},ol.legend.Legend.prototype.getTitle=function(){return this._title.get("title")},ol.legend.Legend.prototype.getTextStyle=function(){return this._textStyle},ol.legend.Legend.prototype.set=function(t,e,o){ol.Object.prototype.set.call(this,t,e,o),o||this.refresh()},ol.legend.Legend.prototype.getListElement=function(){return this._listElement},ol.legend.Legend.prototype.getCanvas=function(){return this._canvas},ol.legend.Legend.prototype.setStyle=function(t){this._style=t,this.refresh()},ol.legend.Legend.prototype.addItem=function(t){t instanceof ol.legend.Item?this._items.push(t):this._items.push(new ol.legend.Item(t))},ol.legend.Legend.prototype.getItems=function(){return this._items},ol.legend.Legend.prototype._drawText=function(t,e,o,i){t.save(),t.scale(ol.has.DEVICE_PIXEL_RATIO,ol.has.DEVICE_PIXEL_RATIO);var n=(e=e||"").split("\n");1===n.length?t.fillText(e,o,i):(t.textBaseline="bottom",t.fillText(n[0],o,i),t.textBaseline="top",t.fillText(n[1],o,i)),t.restore()},ol.legend.Legend.prototype._measureText=function(t,e){var o=(e||"").split("\n");if(1===o.length)return t.measureText(e);var i=t.measureText(o[0]),n=t.measureText(o[1]);return{width:Math.max(i.width,n.width),height:i.height+n.height}},ol.legend.Legend.prototype.refresh=function(){var t=this._listElement;t.innerHTML="";var e=this.get("margin"),o=this.get("size")[0]+2*e,i=this.get("lineHeight")||this.get("size")[1]+2*e,n=this.getCanvas(),r=n.getContext("2d");r.textAlign="left",r.textBaseline="middle";var s=ol.has.DEVICE_PIXEL_RATIO;r.font=this._titleStyle.getFont();var a=this._measureText(r,this.getTitle("title")).width;this._items.forEach(function(t){t.get("feature")||t.get("typeGeom")?(r.font=t.get("textStyle")?t.get("textStyle").getFont():this._textStyle.getFont(),a=Math.max(a,this._measureText(r,t.get("title")).width+o)):(r.font=t.get("textStyle")?t.get("textStyle").getFont():this._titleStyle.getFont(),a=Math.max(a,this._measureText(r,t.get("title")).width))}.bind(this)),n.width=(a+2*e)*s,n.height=(this._items.getLength()+1)*i*s,n.style.height=(this._items.getLength()+1)*i+"px",r.textBaseline="middle",r.fillStyle=ol.color.asString(this._textStyle.getFill().getColor()),this.getTitle()&&(t.appendChild(this._title.getElement([o,i],function(t){this.dispatchEvent({type:"select",index:-1,symbol:t,item:this._title})}.bind(this))),r.font=this._titleStyle.getFont(),r.textAlign="center",this._drawText(r,this.getTitle(),n.width/s/2,i/2)),this._items.forEach(function(a,l){var c=l+(this.getTitle()?1:0);t.appendChild(a.getElement([o,i],function(t){this.dispatchEvent({type:"select",index:l,symbol:t,item:a})}.bind(this)));var h=a.getProperties();r.textAlign="left",h.feature||h.typeGeom?(n=this.getLegendImage(h,n,c),r.font=a.get("textStyle")?a.get("textStyle").getFont():this._textStyle.getFont(),this._drawText(r,a.get("title"),o+e,(l+1.5)*i)):(r.font=a.get("textStyle")?a.get("textStyle").getFont():this._titleStyle.getFont(),/\bcenter\b/.test(h.className)?(r.textAlign="center",this._drawText(r,a.get("title"),n.width/s/2,(l+1.5)*i)):this._drawText(r,a.get("title"),e,(l+1.5)*i))}.bind(this)),this.dispatchEvent({type:"refresh",width:o,height:(this._items.length+1)*i})},ol.legend.Legend.prototype.getLegendImage=function(t,e,o){return t=t||{},ol.legend.Legend.getLegendImage({className:t.className,feature:t.feature,typeGeom:t.typeGeom,style:t.style||this._style,properties:t.properties,margin:t.margin||this.get("margin"),size:t.size||this.get("size"),lineHeight:t.lineHeight||this.get("lineHeight"),onload:function(){this.refresh()}.bind(this)},e,o)},ol.legend.Legend.getLegendImage=function(t,e,o){void 0===(t=t||{}).margin&&(t.margin=10);var i=t.size||[40,25];t.onload=t.onload||function(){setTimeout(function(){ol.legend.Legend.getLegendImage(t,e,o)},100)};var n=i[0]+2*t.margin,r=t.lineHeight||i[1]+2*t.margin,s=t.pixelratio||ol.has.DEVICE_PIXEL_RATIO;e||(o=0,(e=document.createElement("canvas")).width=n*s,e.height=r*s);var a=e.getContext("2d");a.save();var l,c=ol.render.toContext(a,{pixelRatio:s}),h=t.typeGeom,p=t.feature;!p&&h&&(p=/Point/.test(h)?new ol.Feature(new ol.geom.Point([0,0])):/LineString/.test(h)?new ol.Feature(new ol.geom.LineString([0,0])):new ol.Feature(new ol.geom.Polygon([[0,0]])),t.properties&&p.setProperties(t.properties)),p?("function"==typeof(l=p.getStyle())&&(l=l(p)),l||(l="function"==typeof t.style?t.style(p):t.style||[]),h=p.getGeometry().getType()):l=[],l instanceof Array||(l=[l]);var u,g,d=n/2,m=r/2,f=i[0]/2,y=i[1]/2;if("Point"===h){var v=null;for(u=0;g=l[u];u++){var _=g.getImage();if(_){var x=_.getImage();if(x&&x.complete&&!x.naturalWidth&&("function"==typeof t.onload&&x.addEventListener("load",function(){setTimeout(function(){t.onload()},100)}),_.load()),_.getAnchor){var b=_.getAnchor();if(b){var w=_.getSize(),S=b[0]-w[0],C=b[1]-w[1];v?ol.extent.extend(v,[S,C,S+w[0],C+w[1]]):v=[S,C,S+w[0],C+w[1]]}}}}v&&(d+=(v[2]+v[0])/2,m+=(v[3]+v[1])/2)}for(m+=o*r||0,u=0;g=l[u];u++){var M;switch(c.setStyle(g),a.save(),h){case ol.geom.Point:case"Point":case"MultiPoint":M=new ol.geom.Point([d,m]);break;case ol.geom.LineString:case"LineString":case"MultiLineString":a.rect(t.margin*s,0,i[0]*s,e.height),a.clip(),M=new ol.geom.LineString([[d-f,m],[d+f,m]]);break;case ol.geom.Polygon:case"Polygon":case"MultiPolygon":M=new ol.geom.Polygon([[[d-f,m-y],[d+f,m-y],[d+f,m+y],[d-f,m+y],[d-f,m-y]]])}g.getGeometryFunction()?(M=g.getGeometryFunction()(new ol.Feature(M)),a.restore(),c.drawGeometry(M)):(c.drawGeometry(M),a.restore())}return a.restore(),e},ol.legend.Item=function(t){t=t||{},ol.Object.call(this,t),t.feature&&this.set("feature",t.feature.clone())},ol.ext.inherits(ol.legend.Item,ol.Object),ol.legend.Item.prototype.setTitle=function(t){this.set("title",t||""),this.changed()},ol.legend.Item.prototype.getElement=function(t,e){var o=ol.ext.element.create("LI",{className:this.get("className"),click:function(t){e(!1),t.stopPropagation()},style:{height:t[1]+"px"},"aria-label":this.get("title")});return ol.ext.element.create("DIV",{click:function(t){e(!0),t.stopPropagation()},style:{width:t[0]+"px",height:t[1]+"px"},parent:o}),o},ol.control.CanvasBase=function(t){t||(t={}),this.setStyle(t.style),ol.control.Control.call(this,t)},ol.ext.inherits(ol.control.CanvasBase,ol.control.Control),ol.control.CanvasBase.prototype.setMap=function(t){this.getCanvas(t);var e=this.getMap();if(this._listener&&(ol.Observable.unByKey(this._listener),this._listener=null),ol.control.Control.prototype.setMap.call(this,t),e)try{e.renderSync()}catch(t){}t&&(this._listener=t.on("postcompose",this._draw.bind(this)))},ol.control.CanvasBase.prototype.getCanvas=function(t){return ol.ext.getMapCanvas(t)},ol.control.CanvasBase.prototype.getContext=function(t){var e=t.context;if(!e&&this.getMap()){var o=this.getMap().getViewport().getElementsByClassName("ol-fixedoverlay")[0];e=o?o.getContext("2d"):null}return e},ol.control.CanvasBase.prototype.setStyle=function(t){this._style=t||new ol.style.Style({})},ol.control.CanvasBase.prototype.getStyle=function(){return this._style},ol.control.CanvasBase.prototype.getStroke=function(){return this._style.getStroke()||this._style.setStroke(new ol.style.Stroke({color:"#000",width:1.25})),this._style.getStroke()},ol.control.CanvasBase.prototype.getFill=function(){return this._style.getFill()||this._style.setFill(new ol.style.Fill({color:"#fff"})),this._style.getFill()},ol.control.CanvasBase.prototype.getTextStroke=function(){var t=this._style.getText();return t||(t=new ol.style.Text({})),t.getStroke()||t.setStroke(new ol.style.Stroke({color:"#fff",width:3})),t.getStroke()},ol.control.CanvasBase.prototype.getTextFill=function(){var t=this._style.getText();return t||(t=new ol.style.Text({})),t.getFill()||t.setFill(new ol.style.Fill({color:"#fff"})),t.getFill()},ol.control.CanvasBase.prototype.getTextFont=function(){var t=this._style.getText();return t||(t=new ol.style.Text({})),t.getFont()||t.setFont("12px sans-serif"),t.getFont()},ol.control.CanvasBase.prototype._draw=function(){console.warn("[CanvasBase] draw function not implemented.")},ol.control.SelectBase=function(t){var e;t||(t={}),this._features=this.setFeatures(t.features),t.target?e=document.createElement("div"):((e=document.createElement("div")).className="ol-select ol-unselectable ol-control ol-collapsed",ol.ext.element.create("BUTTON",{type:"button",on:{"click touchstart":function(t){e.classList.toggle("ol-collapsed"),t.preventDefault()}},parent:e})),t.className&&e.classList.add(t.className);var o=t.content||ol.ext.element.create("DIV");e.appendChild(o),ol.ext.element.create("BUTTON",{html:t.btInfo||"OK",className:"ol-ok",on:{click:this.doSelect.bind(this)},parent:o}),ol.control.Control.call(this,{element:e,target:t.target}),this.setSources(t.source)},ol.ext.inherits(ol.control.SelectBase,ol.control.Control),ol.control.SelectBase.prototype.setSources=function(t){t?this.set("source",t instanceof Array?t:[t]):this.unset("source")},ol.control.SelectBase.prototype.setFeatures=function(t){t instanceof ol.Collection?this._features=t:this._features=null},ol.control.SelectBase.prototype.getFeatures=function(){return this._features},ol.control.SelectBase.prototype.operationsList={"=":"=","!=":"≠","<":"<","<=":"≤",">=":"≥",">":">",contain:"⊂","!contain":"⊄",regexp:"≃","!regexp":"≄"},ol.control.SelectBase.prototype._escape=function(t){return t.replace(/[.*+?^${}()|[\]\\]/g,"\\$&")},ol.control.SelectBase.prototype._checkCondition=function(t,e,o){if(!e.attr)return!0;var i=t.get(e.attr),n=Number(i)==i&&Number(e.val)==e.val;switch(n&&(i=Number(i)),e.op){case"=":return n?i==e.val:new RegExp("^"+this._escape(e.val)+"$",o?"":"i").test(i);case"!=":return n?i!=e.val:!new RegExp("^"+this._escape(e.val)+"$",o?"":"i").test(i);case"<":return i<e.val;case"<=":return i<=e.val;case">":return i>e.val;case">=":return i>=e.val;case"contain":return new RegExp(this._escape(e.val),o?"":"i").test(i);case"!contain":return!new RegExp(this._escape(e.val),o?"":"i").test(i);case"regexp":return new RegExp(e.val,o?"":"i").test(i);case"!regexp":return!new RegExp(e.val,o?"":"i").test(i);default:return!1}},ol.control.SelectBase.prototype._selectFeatures=function(t,e,o,i,n){var r;o=o||[];for(var s=e.length-1;r=e[s];s--){for(var a,l=i,c=0;a=o[c];c++)a.attr&&(l=i?l&&this._checkCondition(r,a,n):l||this._checkCondition(r,a,n));l?t.push(r):this._features&&this._features.removeAt(s)}return t},ol.control.SelectBase.prototype.getSources=function(){if(this.get("source"))return this.get("source");var t=[];return this.getMap()&&function e(o){o.forEach(function(o){o.getLayers?e(o.getLayers()):o.getSource&&o.getSource()instanceof ol.source.Vector&&t.push(o.getSource())})}(this.getMap().getLayers()),t},ol.control.SelectBase.prototype.doSelect=function(t){var e=[];if((t=t||{}).features)this._selectFeatures(e,t.features,t.conditions,t.matchAll,t.useCase);else if(this._features)this._selectFeatures(e,this._features.getArray(),t.conditions,t.matchAll,t.useCase);else{(t.sources||this.getSources()).forEach(function(o){this._selectFeatures(e,o.getFeatures(),t.conditions,t.matchAll,t.useCase)}.bind(this))}return this.dispatchEvent({type:"select",features:e}),e},ol.control.Button=function(t){t=t||{};var e=document.createElement("div");e.className=(t.className||"")+" ol-button ol-unselectable ol-control";var o=this,i=this.button_=document.createElement(/ol-text-button/.test(t.className)?"div":"button");i.type="button",t.title&&(i.title=t.title),t.name&&(i.name=t.name),t.html instanceof Element?i.appendChild(t.html):i.innerHTML=t.html||"";i.addEventListener("click",function(e){e&&e.preventDefault&&(e.preventDefault(),e.stopPropagation()),t.handleClick&&t.handleClick.call(o,e)}),e.appendChild(i),!t.title&&i.firstElementChild&&(i.title=i.firstElementChild.title),ol.control.Control.call(this,{element:e,target:t.target}),t.title&&this.set("title",t.title),t.title&&this.set("title",t.title),t.name&&this.set("name",t.name)},ol.ext.inherits(ol.control.Button,ol.control.Control),ol.control.Button.prototype.setVisible=function(t){t?ol.ext.element.show(this.element):ol.ext.element.hide(this.element)},ol.control.Button.prototype.setTitle=function(t){this.button_.setAttribute("title",t)},ol.control.Button.prototype.setHtml=function(t){ol.ext.element.setHTML(this.button_,t)},ol.control.Button.prototype.getButtonElement=function(){return this.button_},ol.control.Toggle=function(t){t=t||{};var e=this;this.interaction_=t.interaction,this.interaction_&&(this.interaction_.setActive(t.active),this.interaction_.on("change:active",function(){e.setActive(e.interaction_.getActive())})),t.toggleFn&&(t.onToggle=t.toggleFn),t.handleClick=function(){e.toggle(),t.onToggle&&t.onToggle.call(e,e.getActive())},t.className=(t.className||"")+" ol-toggle",ol.control.Button.call(this,t),this.set("title",t.title),this.set("autoActivate",t.autoActivate),t.bar&&this.setSubBar(t.bar),this.setActive(t.active),this.setDisable(t.disable)},ol.ext.inherits(ol.control.Toggle,ol.control.Button),ol.control.Toggle.prototype.setMap=function(t){!t&&this.getMap()&&(this.interaction_&&this.getMap().removeInteraction(this.interaction_),this.subbar_&&this.getMap().removeControl(this.subbar_)),ol.control.Button.prototype.setMap.call(this,t),t&&(this.interaction_&&t.addInteraction(this.interaction_),this.subbar_&&t.addControl(this.subbar_))},ol.control.Toggle.prototype.getSubBar=function(){return this.subbar_},ol.control.Toggle.prototype.setSubBar=function(t){var e=this.getMap();e&&this.subbar_&&e.removeControl(this.subbar_),this.subbar_=t,t&&(this.subbar_.setTarget(this.element),this.subbar_.element.classList.add("ol-option-bar"),e&&e.addControl(this.subbar_))},ol.control.Toggle.prototype.getDisable=function(){var t=this.element.querySelector("button");return t&&t.disabled},ol.control.Toggle.prototype.setDisable=function(t){this.getDisable()!=t&&(this.element.querySelector("button").disabled=t,t&&this.getActive()&&this.setActive(!1),this.dispatchEvent({type:"change:disable",key:"disable",oldValue:!t,disable:t}))},ol.control.Toggle.prototype.getActive=function(){return this.element.classList.contains("ol-active")},ol.control.Toggle.prototype.toggle=function(){this.getActive()?this.setActive(!1):this.setActive(!0)},ol.control.Toggle.prototype.setActive=function(t){this.interaction_&&this.interaction_.setActive(t),this.subbar_&&this.subbar_.setActive(t),this.getActive()!==t&&(t?this.element.classList.add("ol-active"):this.element.classList.remove("ol-active"),this.dispatchEvent({type:"change:active",key:"active",oldValue:!t,active:t}))},ol.control.Toggle.prototype.setInteraction=function(t){this.interaction_=t},ol.control.Toggle.prototype.getInteraction=function(){return this.interaction_},ol.control.Search=function(t){var e=this;t||(t={}),null==t.typing&&(t.typing=300),this._classname=t.className||"search";var o=(t.className||"")+" ol-search"+(t.target?"":" ol-unselectable ol-control"),i=ol.ext.element.create("DIV",{className:o});if(!1!==t.collapsed&&i.classList.add("ol-collapsed"),t.target||(this.button=document.createElement("BUTTON"),this.button.setAttribute("type","button"),this.button.setAttribute("title",t.title||t.label||"Search"),this.button.addEventListener("click",function(){if(i.classList.toggle("ol-collapsed"),!i.classList.contains("ol-collapsed")){i.querySelector("input.search").focus();for(var t=i.querySelectorAll("li"),o=0;o<t.length;o++)t[o].classList.remove("select");a.value||e.drawList_()}}),i.appendChild(this.button)),t.inputLabel){var n=document.createElement("LABEL");n.innerText=t.inputLabel,i.appendChild(n)}var r,s="",a=this._input=document.createElement("INPUT");a.setAttribute("type","search"),a.setAttribute("class","search"),a.setAttribute("autocomplete","off"),a.setAttribute("placeholder",t.placeholder||"Search..."),a.addEventListener("change",function(t){e.dispatchEvent({type:"change:input",input:t,value:a.value})});var l=function(o){var n=i.querySelector("ul.autocomplete li.select"),l=a.value;if("ArrowDown"==o.key||"ArrowUp"==o.key||"Down"==o.key||"Up"==o.key)n?(n.classList.remove("select"),(n=/Down/.test(o.key)?n.nextElementSibling:n.previousElementSibling)&&n.classList.add("select")):i.querySelector("ul.autocomplete li").classList.add("select");else if("input"!=o.type||l)if(!n||"search"!=o.type&&"Enter"!=o.key)if("search"==o.type||"Enter"==o.key||s!=l&&t.typing>=0)if(s=l){r&&clearTimeout(r);var c=e.get("minLength");r=setTimeout(function(){if(s.length>=c){var t=e.autocomplete(s,function(t){e.drawList_(t)});t&&e.drawList_(t)}else e.drawList_()},t.typing)}else e.drawList_();else(n=i.querySelector("ul.autocomplete li"))&&n.classList.remove("select");else i.classList.contains("ol-control")&&a.blur(),n.classList.remove("select"),s=l,e._handleSelect(e._list[n.getAttribute("data-search")]);else setTimeout(function(){e.drawList_()},200)};if(a.addEventListener("keyup",l),a.addEventListener("search",l),a.addEventListener("cut",l),a.addEventListener("paste",l),a.addEventListener("input",l),t.noCollapse||(a.addEventListener("blur",function(){setTimeout(function(){a!==document.activeElement&&(i.classList.add("ol-collapsed"),this.set("reverse",!1),i.classList.remove("ol-revers"))}.bind(this),200)}.bind(this)),a.addEventListener("focus",function(){this.get("reverse")||(i.classList.remove("ol-collapsed"),i.classList.remove("ol-revers"))}.bind(this))),i.appendChild(a),t.reverse){var c=ol.ext.element.create("BUTTON",{type:"button",class:"ol-revers",title:t.reverseTitle||"click on the map",click:function(){this.get("reverse")?this.set("reverse",!1):(this.set("reverse",!this.get("reverse")),a.focus(),i.classList.add("ol-revers"))}.bind(this)});i.appendChild(c)}var h=document.createElement("UL");h.classList.add("autocomplete"),i.appendChild(h),ol.control.Control.call(this,{element:i,target:t.target}),"function"==typeof t.getTitle&&(this.getTitle=t.getTitle),"function"==typeof t.autocomplete&&(this.autocomplete=t.autocomplete),this.set("copy",t.copy),this.set("minLength",t.minLength||1),this.set("maxItems",t.maxItems||10),this.set("maxHistory",t.maxHistory||t.maxItems||10),t.onselect&&this.on("select",t.onselect),t.centerOnSelect&&this.on("select",function(t){var e=this.getMap();e&&e.getView().setCenter(t.coordinate)}.bind(this)),t.zoomOnSelect&&this.on("select",function(e){var o=this.getMap();o&&(o.getView().setCenter(e.coordinate),o.getView().getZoom()<t.zoomOnSelect&&o.getView().setZoom(t.zoomOnSelect))}.bind(this)),this.restoreHistory(),this.drawList_()},ol.ext.inherits(ol.control.Search,ol.control.Control),ol.control.Search.prototype.setMap=function(t){this._listener&&ol.Observable.unByKey(this._listener),this._listener=null,ol.control.Control.prototype.setMap.call(this,t),t&&(this._listener=t.on("click",this._handleClick.bind(this)))},ol.control.Search.prototype.collapse=function(t){!1===t?this.element.classList.remove("ol-collapsed"):this.element.classList.add("ol-collapsed")},ol.control.Search.prototype.getInputField=function(){return this._input},ol.control.Search.prototype.getTitle=function(t){return t.name||"No title"},ol.control.Search.prototype._getTitleTxt=function(t){return ol.ext.element.create("DIV",{html:this.getTitle(t)}).innerText},ol.control.Search.prototype.search=function(){var t=this.element.querySelector("input.search");this._triggerCustomEvent("search",t)},ol.control.Search.prototype._handleClick=function(t){this.get("reverse")&&(document.activeElement.blur(),this.reverseGeocode(t.coordinate))},ol.control.Search.prototype.reverseGeocode=function(){},ol.control.Search.prototype._triggerCustomEvent=function(t,e){ol.ext.element.dispatchEvent(t,e)},ol.control.Search.prototype.setInput=function(t,e){var o=this.element.querySelector("input.search");o.value=t,e&&this._triggerCustomEvent("keyup",o)},ol.control.Search.prototype.select=function(t,e,o,i){var n={type:"select",search:t,reverse:!!e,coordinate:o};if(i)for(var r in i)n[r]=i[r];this.dispatchEvent(n)},ol.control.Search.prototype._handleSelect=function(t,e,o){if(t){var i,n=this.get("history");try{var r=JSON.stringify(t);for(i=n.length-1;i>=0;i--)n[i]&&JSON.stringify(n[i])!==r||n.splice(i,1)}catch(e){for(i=n.length-1;i>=0;i--)n[i]===t&&n.splice(i,1)}n.unshift(t);for(var s=Math.max(0,this.get("maxHistory")||10)||0;n.length>s;)n.pop();this.saveHistory(),this.select(t,e,null,o),e&&(this.setInput(this._getTitleTxt(t)),this.drawList_(),setTimeout(function(){this.collapse(!1)}.bind(this),300))}},ol.control.Search.prototype._history={},ol.control.Search.prototype.saveHistory=function(){try{this.get("maxHistory")>=0?localStorage["ol@search-"+this._classname]=JSON.stringify(this.get("history")):localStorage.removeItem("ol@search-"+this._classname)}catch(t){console.warn("Failed to access localStorage...")}},ol.control.Search.prototype.restoreHistory=function(){if(this._history[this._classname])this.set("history",this._history[this._classname]);else try{this._history[this._classname]=JSON.parse(localStorage["ol@search-"+this._classname]),this.set("history",this._history[this._classname])}catch(t){this.set("history",[])}},ol.control.Search.prototype.clearHistory=function(){this.set("history",[]),this.saveHistory(),this.drawList_()},ol.control.Search.prototype.getHistory=function(){return this.get("history")},ol.control.Search.prototype.autocomplete=function(t,e){return e([]),!1},ol.control.Search.prototype.drawList_=function(t){var e=this,o=this.element.querySelector("ul.autocomplete");if(o.innerHTML="",this._list=[],t)o.setAttribute("class","autocomplete");else{if(this.element.querySelector("input.search").value)return;t=this.get("history"),o.setAttribute("class","autocomplete history")}for(var i,n=Math.min(e.get("maxItems"),t.length),r=0;r<n;r++)if(t[r]&&(!r||!e.equalFeatures(t[r],t[r-1]))){(i=document.createElement("LI")).setAttribute("data-search",this._list.length),this._list.push(t[r]),i.addEventListener("click",function(t){e._handleSelect(e._list[t.currentTarget.getAttribute("data-search")])});var s=e.getTitle(t[r]);s instanceof Element?i.appendChild(s):i.innerHTML=s,o.appendChild(i)}n&&this.get("copy")&&((i=document.createElement("LI")).classList.add("copy"),i.innerHTML=this.get("copy"),o.appendChild(i))},ol.control.Search.prototype.equalFeatures=function(){return!1},ol.control.SearchJSON=function(t){(t=t||{}).className=t.className||"JSON",delete t.autocomplete,t.minLength=t.minLength||3,t.typing=t.typing||800,ol.control.Search.call(this,t);var e=t.url||"";if("https:"===window.location.protocol){var o=document.createElement("a");o.href=e,o.protocol=window.location.protocol,e=o.href}this.set("url",e),this._ajax=new ol.ext.Ajax({dataType:"JSON",auth:t.authentication}),this._ajax.on("success",function(t){t.status>=200&&t.status<400?"function"==typeof this._callback&&this._callback(t.response):("function"==typeof this._callback&&this._callback(!1,"error"),console.log("AJAX ERROR",arguments))}.bind(this)),this._ajax.on("error",function(){"function"==typeof this._callback&&this._callback(!1,"error"),console.log("AJAX ERROR",arguments)}.bind(this)),this._ajax.on("loadstart",function(){this.element.classList.add("searching")}.bind(this)),this._ajax.on("loadend",function(){this.element.classList.remove("searching")}.bind(this)),"function"==typeof t.handleResponse&&(this.handleResponse=t.handleResponse)},ol.ext.inherits(ol.control.SearchJSON,ol.control.Search),ol.control.SearchJSON.prototype.ajax=function(t,e,o,i){i=i||{},this._callback=o,this._ajax.set("dataType",i.dataType||"JSON"),this._ajax.send(t,e,i)},ol.control.SearchJSON.prototype.autocomplete=function(t,e){var o=this.requestData(t),i=encodeURI(this.get("url"));this.ajax(i,o,function(t){"function"==typeof e&&e(this.handleResponse(t))})},ol.control.SearchJSON.prototype.requestData=function(t){return{q:t}},ol.control.SearchJSON.prototype.handleResponse=function(t){return t},ol.control.SearchPhoton=function(t){(t=t||{}).className=t.className||"photon",t.url=t.url||"https://photon.komoot.io/api/",t.copy=t.copy||'<a href="http://www.openstreetmap.org/copyright" target="new">&copy; OpenStreetMap contributors</a>',ol.control.SearchJSON.call(this,t),this.set("lang",t.lang),this.set("position",t.position)},ol.ext.inherits(ol.control.SearchPhoton,ol.control.SearchJSON),ol.control.SearchPhoton.prototype.getTitle=function(t){var e=t.properties;return(e.housenumber||"")+" "+(e.street||e.name||"")+"<i> "+(e.postcode||"")+" "+(e.city||"")+" ("+e.country+")</i>"},ol.control.SearchPhoton.prototype.requestData=function(t){var e={q:t,lang:this.get("lang"),limit:this.get("maxItems")};if(this.get("position")){var o=this.getMap().getView(),i=new ol.geom.Point(o.getCenter());i=i.transform(o.getProjection(),"EPSG:4326").getCoordinates(),e.lon=i[0],e.lat=i[1]}return e},ol.control.SearchPhoton.prototype.handleResponse=function(t){return t.features},ol.control.SearchPhoton.prototype.equalFeatures=function(t,e){return this.getTitle(t)===this.getTitle(e)&&t.geometry.coordinates[0]===e.geometry.coordinates[0]&&t.geometry.coordinates[1]===e.geometry.coordinates[1]},ol.control.SearchPhoton.prototype.select=function(t){var e=t.geometry.coordinates;try{e=ol.proj.transform(t.geometry.coordinates,"EPSG:4326",this.getMap().getView().getProjection())}catch(t){}this.dispatchEvent({type:"select",search:t,coordinate:e})},ol.control.SearchPhoton.prototype.reverseData=function(t){var e=ol.proj.transform(t,this.getMap().getView().getProjection(),"EPSG:4326");return{lon:e[0],lat:e[1]}},ol.control.SearchPhoton.prototype.reverseGeocode=function(t,e){this.ajax(this.get("url").replace("/api/","/reverse/").replace("/search/","/reverse/"),this.reverseData(t),function(t){t.features&&(t=t.features),t instanceof Array||(t=[t]),e?e.call(this,t):this._handleSelect(t[0],!0)}.bind(this))},ol.control.SearchGeoportail=function(t){(t=t||{}).className=t.className||"IGNF",t.typing=t.typing||500,t.url="https://wxs.ign.fr/"+(t.apiKey||"essentiels")+"/ols/apis/completion",t.copy='<a href="https://www.geoportail.gouv.fr/" target="new">&copy; IGN-Géoportail</a>',ol.control.SearchJSON.call(this,t),this.set("type",t.type||"StreetAddress,PositionOfInterest"),this.set("timeout",t.timeout||2e3)},ol.ext.inherits(ol.control.SearchGeoportail,ol.control.SearchJSON),ol.control.SearchGeoportail.prototype.reverseGeocode=function(t,e){var o=ol.proj.transform(t,this.getMap().getView().getProjection(),"EPSG:4326");this._handleSelect({x:o[0],y:o[1],fulltext:o[0].toFixed(6)+","+o[1].toFixed(6)},!0,e);var i="Commune"===this.get("type")?"PositionOfInterest":this.get("type")||"StreetAddress";/,/.test(i)&&(i="StreetAddress");var n='<?xml version="1.0" encoding="UTF-8"?><XLS xmlns:xls="http://www.opengis.net/xls" xmlns:gml="http://www.opengis.net/gml" xmlns="http://www.opengis.net/xls" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.2" xsi:schemaLocation="http://www.opengis.net/xls http://schemas.opengis.net/ols/1.2/olsAll.xsd"> <Request requestID="1" version="1.2" methodName="ReverseGeocodeRequest" maximumResponses="1" >  <ReverseGeocodeRequest>   <ReverseGeocodePreference>'+i+"</ReverseGeocodePreference>   <Position>    <gml:Point><gml:pos>"+o[1]+" "+o[0]+"</gml:pos></gml:Point>   </Position>  </ReverseGeocodeRequest> </Request></XLS>";this.ajax(this.get("url").replace("ols/apis/completion","geoportail/ols"),{xls:n},function(t){var i={};if(t){var n=(t=t.replace(/\n|\r/g,"")).replace(/.*<gml:pos>(.*)<\/gml:pos>.*/,"$1").split(" ");if(Number(n[1])||Number(n[0]))if(i.x=o[0],i.y=o[1],i.city=t.replace(/.*<Place type="Municipality">([^<]*)<\/Place>.*/,"$1"),i.insee=t.replace(/.*<Place type="INSEE">([^<]*)<\/Place>.*/,"$1"),i.zipcode=t.replace(/.*<PostalCode>([^<]*)<\/PostalCode>.*/,"$1"),/<Street>/.test(t)){i.kind="",i.country="StreetAddress",i.street=t.replace(/.*<Street>([^<]*)<\/Street>.*/,"$1");var r=t.replace(/.*<Building number="([^"]*).*/,"$1");i.fulltext=r+" "+i.street+", "+i.zipcode+" "+i.city}else i.kind=t.replace(/.*<Place type="Nature">([^<]*)<\/Place>.*/,"$1"),i.country="PositionOfInterest",i.street="",i.fulltext=i.zipcode+" "+i.city;else i={x:o[0],y:o[1],fulltext:o[0].toFixed(6)+","+o[1].toFixed(6)}}else i={x:o[0],y:o[1],fulltext:o[0].toFixed(6)+","+o[1].toFixed(6)};"function"==typeof e?e.call(this,[i]):(this.getHistory().shift(),this._handleSelect(i,!0,e))}.bind(this),{timeout:this.get("timeout"),dataType:"XML"})},ol.control.SearchGeoportail.prototype.getTitle=function(t){return t.fulltext},ol.control.SearchGeoportail.prototype.requestData=function(t){return{text:t,type:"Commune"===this.get("type")?"PositionOfInterest":this.get("type")||"StreetAddress,PositionOfInterest",maximumResponses:this.get("maxItems")}},ol.control.SearchGeoportail.prototype.handleResponse=function(t){var e=t.results;if("Commune"===this.get("type"))for(var o=e.length-1;o>=0;o--)e[o].kind&&(e[o].classification>5||"Département"==e[o].kind)&&e.splice(o,1);return e},ol.control.SearchGeoportail.prototype.select=function(t,e,o,i){if(t.x||t.y){var n=[Number(t.x),Number(t.y)];try{n=ol.proj.transform(n,"EPSG:4326",this.getMap().getView().getProjection())}catch(t){}"Commune"===this.get("type")?this.searchCommune(t,function(){ol.control.Search.prototype.select.call(this,t,e,n,i)}):ol.control.Search.prototype.select.call(this,t,e,n,i)}else this.searchCommune(t)},ol.control.SearchGeoportail.prototype.searchCommune=function(t,e){var o='<?xml version="1.0" encoding="UTF-8"?><XLS xmlns:xls="http://www.opengis.net/xls" xmlns:gml="http://www.opengis.net/gml" xmlns="http://www.opengis.net/xls" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.2" xsi:schemaLocation="http://www.opengis.net/xls http://schemas.opengis.net/ols/1.2/olsAll.xsd"><RequestHeader/><Request requestID="1" version="1.2" methodName="LocationUtilityService"><GeocodeRequest returnFreeForm="false"><Address countryCode="PositionOfInterest"><freeFormAddress>'+t.zipcode+" "+t.city+"+</freeFormAddress></Address></GeocodeRequest></Request></XLS>";this.ajax(this.get("url").replace("ols/apis/completion","geoportail/ols"),{xls:o},function(o){if(o){var i=(new DOMParser).parseFromString(o,"text/xml").getElementsByTagName("GeocodedAddress")[0],n=i.getElementsByTagName("gml:Point")[0].textContent.trim().split(" ");t.x=Number(n[1]),t.y=Number(n[0]);for(var r=i.getElementsByTagName("Place"),s=0;s<r.length;s++)switch(r[s].attributes.type.value){case"Nature":t.kind=r[s].textContent;break;case"INSEE":t.insee=r[s].textContent}(t.x||t.y)&&(e?e.call(this,[t]):this._handleSelect(t))}}.bind(this),{dataType:"XML"})},ol.control.LayerSwitcher=function(t){t=t||{};var e,o=this;this.dcount=0,this.show_progress=t.show_progress,this.oninfo="function"==typeof t.oninfo?t.oninfo:null,this.onextent="function"==typeof t.onextent?t.onextent:null,this.hasextent=t.extent||t.onextent,this.hastrash=t.trash,this.reordering=!1!==t.reordering,this._layers=[],this._layerGroup=t.layerGroup&&t.layerGroup.getLayers?t.layerGroup:null,this.onchangeCheck="function"==typeof t.onchangeCheck?t.onchangeCheck:null,"function"==typeof t.displayInLayerSwitcher&&(this.displayInLayerSwitcher=t.displayInLayerSwitcher),t.target?e=ol.ext.element.create("DIV",{className:t.switcherClass||"ol-layerswitcher"}):(e=ol.ext.element.create("DIV",{className:(t.switcherClass||"ol-layerswitcher")+" ol-unselectable ol-control"}),!1!==t.collapsed?e.classList.add("ol-collapsed"):e.classList.add("ol-forceopen"),this.button=ol.ext.element.create("BUTTON",{type:"button",parent:e}),this.button.addEventListener("touchstart",function(t){e.classList.toggle("ol-forceopen"),e.classList.add("ol-collapsed"),o.dispatchEvent({type:"toggle",collapsed:e.classList.contains("ol-collapsed")}),t.preventDefault(),o.overflow()}),this.button.addEventListener("click",function(){e.classList.toggle("ol-forceopen"),e.classList.add("ol-collapsed"),o.dispatchEvent({type:"toggle",collapsed:!e.classList.contains("ol-forceopen")}),o.overflow()}),t.mouseover&&(e.addEventListener("mouseleave",function(){e.classList.add("ol-collapsed"),o.dispatchEvent({type:"toggle",collapsed:!0})}),e.addEventListener("mouseover",function(){e.classList.remove("ol-collapsed"),o.dispatchEvent({type:"toggle",collapsed:!1})})),t.minibar&&(t.noScroll=!0),t.noScroll||(this.topv=ol.ext.element.create("DIV",{className:"ol-switchertopdiv",parent:e,click:function(){o.overflow("+50%")}}),this.botv=ol.ext.element.create("DIV",{className:"ol-switcherbottomdiv",parent:e,click:function(){o.overflow("-50%")}})),this._noScroll=t.noScroll),this.panel_=ol.ext.element.create("UL",{className:"panel"}),this.panelContainer_=ol.ext.element.create("DIV",{className:"panel-container",html:this.panel_,parent:e}),t.target||t.noScroll||ol.ext.element.addListener(this.panel_,"mousewheel DOMMouseScroll onmousewheel",function(t){o.overflow(Math.max(-1,Math.min(1,t.wheelDelta||-t.detail)))&&(t.stopPropagation(),t.preventDefault())}),this.header_=ol.ext.element.create("LI",{className:"ol-header",parent:this.panel_}),ol.control.Control.call(this,{element:e,target:t.target}),this.set("drawDelay",t.drawDelay||0),this.set("selection",t.selection),t.minibar&&setTimeout(function(){var t=ol.ext.element.scrollDiv(this.panelContainer_,{mousewheel:!0,vertical:!0,minibar:!0});this.on(["drawlist","toggle"],function(){t.refresh()})}.bind(this))},ol.ext.inherits(ol.control.LayerSwitcher,ol.control.Control),ol.control.LayerSwitcher.prototype.tip={up:"up/down",down:"down",info:"informations...",extent:"zoom to extent",trash:"remove layer",plus:"expand/shrink"},ol.control.LayerSwitcher.prototype.displayInLayerSwitcher=function(t){return!1!==t.get("displayInLayerSwitcher")},ol.control.LayerSwitcher.prototype.setMap=function(t){if(ol.control.Control.prototype.setMap.call(this,t),this.drawPanel(),this._listener)for(var e in this._listener)ol.Observable.unByKey(this._listener[e]);this._listener=null,t&&(this._listener={moveend:t.on("moveend",this.viewChange.bind(this)),size:t.on("change:size",this.overflow.bind(this))},this._layerGroup?this._listener.change=this._layerGroup.getLayers().on("change:length",this.drawPanel.bind(this)):this._listener.change=t.getLayerGroup().getLayers().on("change:length",this.drawPanel.bind(this)))},ol.control.LayerSwitcher.prototype.show=function(){this.element.classList.add("ol-forceopen"),this.overflow(),self.dispatchEvent({type:"toggle",collapsed:!1})},ol.control.LayerSwitcher.prototype.hide=function(){this.element.classList.remove("ol-forceopen"),this.overflow(),self.dispatchEvent({type:"toggle",collapsed:!0})},ol.control.LayerSwitcher.prototype.toggle=function(){this.element.classList.toggle("ol-forceopen"),this.overflow()},ol.control.LayerSwitcher.prototype.isOpen=function(){return this.element.classList.contains("ol-forceopen")},ol.control.LayerSwitcher.prototype.setHeader=function(t){ol.ext.element.setHTML(this.header_,t)},ol.control.LayerSwitcher.prototype.overflow=function(t){if(this.button&&!this._noScroll){if(ol.ext.element.hidden(this.panel_))return void ol.ext.element.setStyle(this.element,{height:"auto"});var e=ol.ext.element.outerHeight(this.element),o=ol.ext.element.outerHeight(this.panel_),i=this.button.offsetTop+ol.ext.element.outerHeight(this.button),n=this.panel_.offsetTop-i;if(o>e-i){ol.ext.element.setStyle(this.element,{height:"100%"});var r=this.panel_.querySelectorAll("li.visible .li-content")[0],s=r?2*ol.ext.element.getStyle(r,"height"):0;switch(t){case 1:n+=s;break;case-1:n-=s;break;case"+50%":n+=Math.round(e/2);break;case"-50%":n-=Math.round(e/2)}return n+o<=e-3*i/2?(n=e-3*i/2-o,ol.ext.element.hide(this.botv)):ol.ext.element.show(this.botv),n>=0?(n=0,ol.ext.element.hide(this.topv)):ol.ext.element.show(this.topv),ol.ext.element.setStyle(this.panel_,{top:n+"px"}),!0}return ol.ext.element.setStyle(this.element,{height:"auto"}),ol.ext.element.setStyle(this.panel_,{top:0}),ol.ext.element.hide(this.botv),ol.ext.element.hide(this.topv),!1}return!1},ol.control.LayerSwitcher.prototype._setLayerForLI=function(t,e){var o=[];e.getLayers&&o.push(e.getLayers().on("change:length",this.drawPanel.bind(this))),t&&(o.push(e.on("change:opacity",function(){this.setLayerOpacity(e,t)}.bind(this))),o.push(e.on("change:visible",function(){this.setLayerVisibility(e,t)}.bind(this)))),o.push(e.on("propertychange",function(t){"displayInLayerSwitcher"!==t.key&&"openInLayerSwitcher"!==t.key||this.drawPanel(t)}.bind(this))),this._layers.push({li:t,layer:e,listeners:o})},ol.control.LayerSwitcher.prototype.setLayerOpacity=function(t,e){var o=e.querySelector(".layerswitcher-opacity-cursor");o&&(o.style.left=100*t.getOpacity()+"%"),this.dispatchEvent({type:"layer:opacity",layer:t})},ol.control.LayerSwitcher.prototype.setLayerVisibility=function(t,e){var o=e.querySelector(".ol-visibility");o&&(o.checked=t.getVisible()),t.getVisible()?e.classList.add("ol-visible"):e.classList.remove("ol-visible"),this.dispatchEvent({type:"layer:visible",layer:t})},ol.control.LayerSwitcher.prototype._clearLayerForLI=function(){this._layers.forEach(function(t){t.listeners.forEach(function(t){ol.Observable.unByKey(t)})}),this._layers=[]},ol.control.LayerSwitcher.prototype._getLayerForLI=function(t){for(var e,o=0;e=this._layers[o];o++)if(e.li===t)return e.layer;return null},ol.control.LayerSwitcher.prototype.viewChange=function(){this.panel_.querySelectorAll("li").forEach(function(t){var e=this._getLayerForLI(t);e&&(this.testLayerVisibility(e)?t.classList.remove("ol-layer-hidden"):t.classList.add("ol-layer-hidden"))}.bind(this))},ol.control.LayerSwitcher.prototype.getPanel=function(){return this.panelContainer_},ol.control.LayerSwitcher.prototype.drawPanel=function(){if(this.getMap()){var t=this;this.dcount++,setTimeout(function(){t.drawPanel_()},this.get("drawDelay")||0)}},ol.control.LayerSwitcher.prototype.drawPanel_=function(){if(!--this.dcount&&!this.dragging_){var t=this.panelContainer_.scrollTop;this._clearLayerForLI(),this.panel_.querySelectorAll("li").forEach(function(t){t.classList.contains("ol-header")||t.remove()}.bind(this)),this._layerGroup?this.drawList(this.panel_,this._layerGroup.getLayers()):this.getMap()&&this.drawList(this.panel_,this.getMap().getLayers()),this.panelContainer_.scrollTop=t}},ol.control.LayerSwitcher.prototype.switchLayerVisibility=function(t,e){t.get("baseLayer")?(t.getVisible()||t.setVisible(!0),e.forEach(function(e){t!==e&&e.get("baseLayer")&&e.getVisible()&&e.setVisible(!1)})):t.setVisible(!t.getVisible())},ol.control.LayerSwitcher.prototype.testLayerVisibility=function(t){if(!this.getMap())return!0;var e=this.getMap().getView().getResolution(),o=this.getMap().getView().getZoom();if(t.getMaxResolution()<=e||t.getMinResolution()>=e)return!1;if(t.getMinZoom&&(t.getMinZoom()>=o||t.getMaxZoom()<o))return!1;var i=t.getExtent();if(i){var n=this.getMap().getView().calculateExtent(this.getMap().getSize());return ol.extent.intersects(n,i)}return!0},ol.control.LayerSwitcher.prototype.dragOrdering_=function(t){t.stopPropagation(),t.preventDefault();var e,o,i,n,r,s=this,a=t.currentTarget.parentNode.parentNode,l=!0,c=this.panel_,h=t.pageY||t.touches&&t.touches.length&&t.touches[0].pageY||t.changedTouches&&t.changedTouches.length&&t.changedTouches[0].pageY;function p(t){if(e=t.pageY||t.touches&&t.touches.length&&t.touches[0].pageY||t.changedTouches&&t.changedTouches.length&&t.changedTouches[0].pageY,l&&Math.abs(h-e)>2&&(l=!1,a.classList.add("drag"),n=s._getLayerForLI(a),o=!1,r=s._getLayerForLI(a.parentNode.parentNode),i=ol.ext.element.create("LI",{className:"ol-dragover",html:a.innerHTML,style:{position:"absolute","z-index":1e4,left:a.offsetLeft,opacity:.5,width:ol.ext.element.outerWidth(a),height:ol.ext.element.getStyle(a,"height")},parent:c}),s.element.classList.add("drag"),s.dispatchEvent({type:"reorder-start",layer:n,group:r})),!l){var p;for(t.preventDefault(),t.stopPropagation(),ol.ext.element.setStyle(i,{top:e-ol.ext.element.offsetRect(c).top+c.scrollTop+5}),(p=t.touches?document.elementFromPoint(t.touches[0].clientX,t.touches[0].clientY):t.target).classList.contains("ol-switcherbottomdiv")?s.overflow(-1):p.classList.contains("ol-switchertopdiv")&&s.overflow(1);p&&"LI"!==p.tagName;)p=p.parentNode;p&&p.classList.contains("dropover")||a.parentNode.querySelectorAll("li").forEach(function(t){t.classList.remove("dropover"),t.classList.remove("dropover-after"),t.classList.remove("dropover-before")}),p&&p.parentNode.classList.contains("drag")&&p!==a?((o=s._getLayerForLI(p))&&!o.get("allwaysOnTop")==!n.get("allwaysOnTop")?(p.classList.add("dropover"),p.classList.add(a.offsetTop<p.offsetTop?"dropover-after":"dropover-before")):o=!1,ol.ext.element.show(i)):(o=!1,p===a?ol.ext.element.hide(i):ol.ext.element.show(i)),o?i.classList.remove("forbidden"):i.classList.add("forbidden")}}a.parentNode.classList.add("drag"),ol.ext.element.addListener(document,"mousemove touchmove",p),ol.ext.element.addListener(document,"mouseup touchend touchcancel",function t(){if(o){var e=n,l=s.getSelection()===e;if(e&&o){for(var c,h=(c=r?r.getLayers():s._layerGroup?s._layerGroup.getLayers():s.getMap().getLayers()).getArray(),u=0;u<h.length;u++)if(h[u]==e){c.removeAt(u);break}for(var g=0;g<h.length;g++)if(h[g]===o){u>g?c.insertAt(g,e):c.insertAt(g+1,e);break}}l&&s.selectLayer(e),s.dispatchEvent({type:"reorder-end",layer:e,group:r})}a.parentNode.querySelectorAll("li").forEach(function(t){t.classList.remove("dropover"),t.classList.remove("dropover-after"),t.classList.remove("dropover-before")}),a.classList.remove("drag"),a.parentNode.classList.remove("drag"),s.element.classList.remove("drag"),i&&i.remove(),ol.ext.element.removeListener(document,"mousemove touchmove",p),ol.ext.element.removeListener(document,"mouseup touchend touchcancel",t)})},ol.control.LayerSwitcher.prototype.dragOpacity_=function(t){t.stopPropagation(),t.preventDefault();var e=this,o=t.target,i=this._getLayerForLI(o.parentNode.parentNode.parentNode);if(i){var n=t.pageX||t.touches&&t.touches.length&&t.touches[0].pageX||t.changedTouches&&t.changedTouches.length&&t.changedTouches[0].pageX,r=ol.ext.element.getStyle(o,"left")-n;e.dragging_=!0,ol.ext.element.addListener(document,"mouseup touchend touchcancel",function t(){ol.ext.element.removeListener(document,"mouseup touchend touchcancel",t),ol.ext.element.removeListener(document,"mousemove touchmove",s),e.dragging_=!1}),ol.ext.element.addListener(document,"mousemove touchmove",s)}function s(t){var e=t.pageX||t.touches&&t.touches.length&&t.touches[0].pageX||t.changedTouches&&t.changedTouches.length&&t.changedTouches[0].pageX,n=(r+e)/ol.ext.element.getStyle(o.parentNode,"width"),s=Math.max(0,Math.min(1,n));ol.ext.element.setStyle(o,{left:100*s+"%"}),o.parentNode.nextElementSibling.innerHTML=Math.round(100*s),i.setOpacity(s)}},ol.control.LayerSwitcher.prototype.drawList=function(t,e){var o=this,i=e.getArray(),n=function(t){t.stopPropagation(),t.preventDefault();var i=o._getLayerForLI(this.parentNode.parentNode);o.switchLayerVisibility(i,e),o.get("selection")&&i.getVisible()&&o.selectLayer(i),o.onchangeCheck&&o.onchangeCheck(i)};function r(t){t.stopPropagation(),t.preventDefault();var e=o._getLayerForLI(this.parentNode.parentNode);o.oninfo(e),o.dispatchEvent({type:"info",layer:e})}function s(t){t.stopPropagation(),t.preventDefault();var e=o._getLayerForLI(this.parentNode.parentNode);o.onextent?o.onextent(e):o.getMap().getView().fit(e.getExtent(),o.getMap().getSize()),o.dispatchEvent({type:"extent",layer:e})}function a(t){t.stopPropagation(),t.preventDefault();var e,i=this.parentNode.parentNode.parentNode.parentNode,n=o._getLayerForLI(i);n?(e=o._getLayerForLI(this.parentNode.parentNode),n.getLayers().remove(e),0!=n.getLayers().getLength()||n.get("noSwitcherDelete")||a.call(i.querySelectorAll(".layerTrash")[0],t)):(i=this.parentNode.parentNode,o.getMap().removeLayer(o._getLayerForLI(i)))}function l(e){if(this.displayInLayerSwitcher(e)){var l=ol.ext.element.create("LI",{className:(e.getVisible()?"visible ":" ")+(e.get("baseLayer")?"baselayer":""),parent:t});this._setLayerForLI(l,e),this._selectedLayer===e&&l.classList.add("ol-layer-select");var h=ol.ext.element.create("DIV",{className:"ol-layerswitcher-buttons",parent:l}),p=ol.ext.element.create("DIV",{className:"li-content",parent:l});ol.ext.element.create("INPUT",{type:e.get("baseLayer")?"radio":"checkbox",className:"ol-visibility",checked:e.getVisible(),click:n,parent:p});var u=ol.ext.element.create("LABEL",{title:e.get("title")||e.get("name"),click:n,unselectable:"on",style:{userSelect:"none"},parent:p});if(u.addEventListener("selectstart",function(){return!1}),ol.ext.element.create("SPAN",{html:e.get("title")||e.get("name"),click:function(t){this.get("selection")&&(t.stopPropagation(),this.selectLayer(e))}.bind(this),parent:u}),this.reordering&&(c<i.length-1&&(e.get("allwaysOnTop")||!i[c+1].get("allwaysOnTop"))||c>0&&(!e.get("allwaysOnTop")||i[c-1].get("allwaysOnTop")))&&ol.ext.element.create("DIV",{className:"layerup ol-noscroll",title:this.tip.up,on:{"mousedown touchstart":function(t){o.dragOrdering_(t)}},parent:h}),e.getLayers){var g=0;e.getLayers().forEach(function(t){o.displayInLayerSwitcher(t)&&g++}),g&&ol.ext.element.create("DIV",{className:e.get("openInLayerSwitcher")?"collapse-layers":"expend-layers",title:this.tip.plus,click:function(){var t=o._getLayerForLI(this.parentNode.parentNode);t.set("openInLayerSwitcher",!t.get("openInLayerSwitcher"))},parent:h})}if(this.oninfo&&ol.ext.element.create("DIV",{className:"layerInfo",title:this.tip.info,click:r,parent:h}),this.hastrash&&!e.get("noSwitcherDelete")&&ol.ext.element.create("DIV",{className:"layerTrash",title:this.tip.trash,click:a,parent:h}),this.hasextent&&i[c].getExtent()){var d=i[c].getExtent();4==d.length&&d[0]<d[2]&&d[1]<d[3]&&ol.ext.element.create("DIV",{className:"layerExtent",title:this.tip.extent,click:s,parent:h})}if(this.show_progress&&e instanceof ol.layer.Tile){var m=ol.ext.element.create("DIV",{className:"layerswitcher-progress",parent:p});this.setprogress_(e),e.layerswitcher_progress=ol.ext.element.create("DIV",{parent:m})}var f=ol.ext.element.create("DIV",{className:"layerswitcher-opacity",click:function(t){if(t.target===this){t.stopPropagation(),t.preventDefault();var e=Math.max(0,Math.min(1,t.offsetX/ol.ext.element.getStyle(this,"width")));o._getLayerForLI(this.parentNode.parentNode).setOpacity(e)}},parent:p});if(ol.ext.element.create("DIV",{className:"layerswitcher-opacity-cursor ol-noscroll",style:{left:100*e.getOpacity()+"%"},on:{"mousedown touchstart":function(t){o.dragOpacity_(t)}},parent:f}),ol.ext.element.create("DIV",{className:"layerswitcher-opacity-label",html:Math.round(100*e.getOpacity()),parent:p}),e.getLayers&&(l.classList.add("ol-layer-group"),!0===e.get("openInLayerSwitcher"))){var y=ol.ext.element.create("UL",{parent:l});this.drawList(y,e.getLayers())}l.classList.add(this.getLayerClass(e)),this.dispatchEvent({type:"drawlist",layer:e,li:l})}else this._setLayerForLI(null,e)}for(var c=i.length-1;c>=0;c--)l.call(this,i[c]);this.viewChange(),t===this.panel_&&this.overflow()},ol.control.LayerSwitcher.prototype.getLayerClass=function(t){return t?t.getLayers?"ol-layer-group":t instanceof ol.layer.Vector?"ol-layer-vector":t instanceof ol.layer.VectorTile?"ol-layer-vectortile":t instanceof ol.layer.Tile?"ol-layer-tile":t instanceof ol.layer.Image?"ol-layer-image":t instanceof ol.layer.Heatmap?"ol-layer-heatmap":t.getFeatures?"ol-layer-vectorimage":"unknown":"none"},ol.control.LayerSwitcher.prototype.selectLayer=function(t,e){if(!t){if(!this.getMap())return;t=this.getMap().getLayers().item(this.getMap().getLayers().getLength()-1)}this._selectedLayer=t,this.drawPanel(),e||this.dispatchEvent({type:"select",layer:t})},ol.control.LayerSwitcher.prototype.getSelection=function(){return this._selectedLayer},ol.control.LayerSwitcher.prototype.setprogress_=function(t){if(!t.layerswitcher_progress){var e=0,o=0,i=function(){o===e?(o=e=0,ol.ext.element.setStyle(t.layerswitcher_progress,{width:0})):ol.ext.element.setStyle(t.layerswitcher_progress,{width:(e/o*100).toFixed(1)+"%"})};t.getSource().on("tileloadstart",function(){o++,i()}),t.getSource().on("tileloadend",function(){e++,i()}),t.getSource().on("tileloaderror",function(){e++,i()})}},ol.control.Bar=function(t){t||(t={});var e=document.createElement("div");if(e.classList.add("ol-unselectable","ol-control","ol-bar"),t.className){var o=t.className.split(" ").filter(function(t){return t.length>0});e.classList.add.apply(e.classList,o)}if(t.group&&e.classList.add("ol-group"),ol.control.Control.call(this,{element:e,target:t.target}),this.set("toggleOne",t.toggleOne),this.set("autoDeactivate",t.autoDeactivate),this.controls_=[],t.controls instanceof Array)for(var i=0;i<t.controls.length;i++)this.addControl(t.controls[i])},ol.ext.inherits(ol.control.Bar,ol.control.Control),ol.control.Bar.prototype.setVisible=function(t){this.element.style.display=t?"":"none"},ol.control.Bar.prototype.getVisible=function(){return"none"!=this.element.style.display},ol.control.Bar.prototype.setMap=function(t){ol.control.Control.prototype.setMap.call(this,t);for(var e=0;e<this.controls_.length;e++){this.controls_[e].setMap(t)}},ol.control.Bar.prototype.getControls=function(){return this.controls_},ol.control.Bar.prototype.setPosition=function(t){this.element.classList.remove("ol-left","ol-top","ol-bottom","ol-right"),t=t.split("-");for(var e=0;e<t.length;e++)switch(t[e]){case"top":case"left":case"bottom":case"right":this.element.classList.add("ol-"+t[e])}},ol.control.Bar.prototype.addControl=function(t){this.controls_.push(t),t.setTarget(this.element),this.getMap()&&this.getMap().addControl(t),t.on("change:active",function(e){this.onActivateControl_(e,t)}.bind(this)),t.getActive&&this.onActivateControl_({target:t,active:t.getActive()},t)},ol.control.Bar.prototype.deactivateControls=function(t){for(var e=0;e<this.controls_.length;e++)this.controls_[e]!==t&&this.controls_[e].setActive&&this.controls_[e].setActive(!1)},ol.control.Bar.prototype.getActiveControls=function(){for(var t,e=[],o=0;t=this.controls_[o];o++)t.getActive&&t.getActive()&&e.push(t);return e},ol.control.Bar.prototype.setActive=function(t){if(!t&&this.get("autoDeactivate")&&this.deactivateControls(),t)for(var e,o=this.getControls(),i=0;e=o[i];i++)e.get("autoActivate")&&e.setActive(!0)},ol.control.Bar.prototype.onActivateControl_=function(t,e){if(this.get("toggleOne"))if(t.active){var o;for(o=0;o<this.controls_.length&&this.controls_[o]!==e;o++);if(o==this.controls_.length)return;this.deactivateControls(this.controls_[o])}else if(!this.getActiveControls().length)for(var i,n=0;i=this.controls_[n];n++)if(i.get("autoActivate")){i.setActive(!0);break}},ol.control.Bar.prototype.getControlsByName=function(t){return this.getControls().filter(function(e){return e.get("name")===t})},ol.control.CanvasAttribution=function(t){t||(t={}),ol.control.Attribution.call(this,t),this.element.classList.add("ol-canvas-control"),this.setCanvas(!!t.canvas),t||(t={}),t.style||(t.style=new ol.style.Style),this.setStyle(t.style)},ol.ext.inherits(ol.control.CanvasAttribution,ol.control.Attribution),ol.control.CanvasAttribution.prototype.setCanvas=function(t){if(this.isCanvas_=t,t&&this.setCollapsed(!1),this.element.style.visibility=t?"hidden":"visible",this.getMap())try{this.getMap().renderSync()}catch(t){}},ol.control.CanvasAttribution.prototype.getContext=ol.control.CanvasBase.prototype.getContext,ol.control.CanvasAttribution.prototype.setStyle=function(t){var e=t.getText();this.font_=e?e.getFont():"10px sans-serif";var o=e?e.getStroke():null,i=e?e.getFill():null;this.fontStrokeStyle_=o?ol.color.asString(o.getColor()):"#fff",this.fontFillStyle_=i?ol.color.asString(i.getColor()):"#000",this.fontStrokeWidth_=o?o.getWidth():3,this.getMap()&&this.getMap().render()},ol.control.CanvasAttribution.prototype.setMap=function(t){ol.control.CanvasBase.prototype.getCanvas.call(this,t);var e=this.getMap();if(this._listener&&ol.Observable.unByKey(this._listener),this._listener=null,ol.control.Attribution.prototype.setMap.call(this,t),e)try{e.renderSync()}catch(t){}t&&(this._listener=t.on("postcompose",this.drawAttribution_.bind(this))),this.setCanvas(this.isCanvas_)},ol.control.CanvasAttribution.prototype.drawAttribution_=function(t){if(this.isCanvas_){var e=this.getContext(t);if(e){var o="";Array.prototype.slice.call(this.element.querySelectorAll("li")).filter(function(t){return"none"!==t.style.display}).map(function(t){o+=(o?" - ":"")+t.textContent});var i=t.frameState.pixelRatio;e.save(),e.scale(i,i);var n=this.element.getBoundingClientRect(),r=this.getMap().getViewport().getBoundingClientRect(),s=this.getMap().getSize()[0]/r.width;e.translate((n.left-r.left)*s,(n.top-r.top)*s);var a,l=this.element.clientHeight,c=this.element.clientWidth,h=ol.ext.element.getStyle(this.element,"textAlign")||"center";switch(h){case"left":a=0;break;case"right":a=c;break;default:a=c/2}e.beginPath(),e.strokeStyle=this.fontStrokeStyle_,e.fillStyle=this.fontFillStyle_,e.lineWidth=this.fontStrokeWidth_,e.textAlign=h,e.textBaseline="middle",e.font=this.font_,e.strokeText(o,a,l/2),e.fillText(o,a,l/2),e.closePath(),e.restore()}}},ol.control.CanvasScaleLine=function(t){ol.control.ScaleLine.call(this,t),this.element.classList.add("ol-canvas-control"),this.scaleHeight_=6,t||(t={}),t.style||(t.style=new ol.style.Style),this.setStyle(t.style)},ol.ext.inherits(ol.control.CanvasScaleLine,ol.control.ScaleLine),ol.control.CanvasScaleLine.prototype.getContext=ol.control.CanvasBase.prototype.getContext,ol.control.CanvasScaleLine.prototype.setMap=function(t){ol.control.CanvasBase.prototype.getCanvas.call(this,t);var e=this.getMap();if(this._listener&&ol.Observable.unByKey(this._listener),this._listener=null,ol.control.ScaleLine.prototype.setMap.call(this,t),e)try{e.renderSync()}catch(t){}t&&(this._listener=t.on("postcompose",this.drawScale_.bind(this))),this.element.style.visibility="hidden",this.olscale=this.element.querySelector(".ol-scale-line-inner")},ol.control.CanvasScaleLine.prototype.setStyle=function(t){var e=t.getStroke();this.strokeStyle_=e?ol.color.asString(e.getColor()):"#000",this.strokeWidth_=e?e.getWidth():2;var o=t.getFill();this.fillStyle_=o?ol.color.asString(o.getColor()):"#fff";var i=t.getText();this.font_=i?i.getFont():"10px Arial",e=i?i.getStroke():null,o=i?i.getFill():null,this.fontStrokeStyle_=e?ol.color.asString(e.getColor()):this.fillStyle_,this.fontStrokeWidth_=e?e.getWidth():3,this.fontFillStyle_=o?ol.color.asString(o.getColor()):this.strokeStyle_,this.getMap()&&this.getMap().render()},ol.control.CanvasScaleLine.prototype.drawScale_=function(t){if("hidden"===this.element.style.visibility&&"none"!==ol.ext.element.getStyle(this.element,"display")){var e=this.getContext(t);if(e){var o=parseInt(this.olscale.style.width);if(o){var i=this.olscale.textContent,n={left:this.element.offsetLeft,top:this.element.offsetTop},r=t.frameState.pixelRatio;e.save(),e.scale(r,r),n.top+=this.element.clientHeight-this.scaleHeight_,e.beginPath(),e.strokeStyle=this.fontStrokeStyle_,e.fillStyle=this.fontFillStyle_,e.lineWidth=this.fontStrokeWidth_,e.textAlign="center",e.textBaseline="bottom",e.font=this.font_,e.strokeText(i,n.left+o/2,n.top),e.fillText(i,n.left+o/2,n.top),e.closePath(),n.top+=2,e.lineWidth=this.strokeWidth_,e.strokeStyle=this.strokeStyle_;for(var s=4,a=parseInt(i);a%10==0;)a/=10;a%5==0&&(s=5);for(var l=0;l<s;l++)e.beginPath(),e.fillStyle=l%2?this.fillStyle_:this.strokeStyle_,e.rect(n.left+l*o/s,n.top,o/s,this.scaleHeight_),e.stroke(),e.fill(),e.closePath();e.restore()}}}},ol.control.CanvasTitle=function(t){t||(t={});var e=ol.ext.element.create("DIV",{className:(t.className||"")+" ol-control-title ol-unselectable",style:{display:"block",visibility:"hidden"}});ol.control.CanvasBase.call(this,{element:e,style:t.style}),this.setTitle(t.title||""),this.setVisible(t.visible),this.element.style.font=this.getTextFont()},ol.ext.inherits(ol.control.CanvasTitle,ol.control.CanvasBase),ol.control.CanvasTitle.prototype.setStyle=function(t){ol.control.CanvasBase.prototype.setStyle.call(this,t),this.element&&(this.element.style.font=this.getTextFont()),this.getMap()&&this.getMap().render()},ol.control.CanvasTitle.prototype.setTitle=function(t){if(this.element.textContent=t,this.set("title",t),this.getMap())try{this.getMap().renderSync()}catch(t){}},ol.control.CanvasTitle.prototype.getTitle=function(){return this.get("title")},ol.control.CanvasTitle.prototype.setVisible=function(t){if(this.element.style.display=t?"block":"none",this.getMap())try{this.getMap().renderSync()}catch(t){}},ol.control.CanvasTitle.prototype.getVisible=function(){return"none"!==this.element.style.display},ol.control.CanvasTitle.prototype._draw=function(t){if(this.getVisible()){var e=this.getContext(t);if(e){var o=t.frameState.pixelRatio;e.save(),e.scale(o,o);var i=this.element.getBoundingClientRect(),n=this.getMap().getViewport().getBoundingClientRect(),r=this.getMap().getSize()[0]/n.width;e.translate(Math.round((i.left-n.left)*r),Math.round((i.top-n.top)*r));var s=this.element.clientHeight,a=this.element.clientWidth,l=a/2;e.beginPath(),e.fillStyle=ol.color.asString(this.getFill().getColor()),e.rect(0,0,a,s),e.fill(),e.closePath(),e.beginPath(),e.fillStyle=ol.color.asString(this.getTextFill().getColor()),e.strokeStyle=ol.color.asString(this.getTextStroke().getColor()),e.lineWidth=this.getTextStroke().getWidth(),e.textAlign="center",e.textBaseline="middle",e.font=this.getTextFont(),e.lineWidth&&e.strokeText(this.getTitle(),l,s/2),e.fillText(this.getTitle(),l,s/2),e.closePath(),e.restore()}}},ol.control.CenterPosition=function(t){t||(t={});var e=ol.ext.element.create("DIV",{className:(t.className||"")+" ol-center-position ol-unselectable",style:{display:"block",visibility:"hidden"}});ol.control.CanvasBase.call(this,{element:e,style:t.style}),this.element.style.font=this.getTextFont(),this.set("projection",t.projection),this.setCanvas(t.canvas),this._format="function"==typeof t.coordinateFormat?t.coordinateFormat:ol.coordinate.toStringXY},ol.ext.inherits(ol.control.CenterPosition,ol.control.CanvasBase),ol.control.CenterPosition.prototype.setStyle=function(t){ol.control.CanvasBase.prototype.setStyle.call(this,t),this.element&&(this.element.style.font=this.getTextFont()),this.getMap()&&this.getMap().render()},ol.control.CenterPosition.prototype.setCanvas=function(t){if(this.set("canvas",t),this.element.style.visibility=t?"hidden":"visible",this.getMap())try{this.getMap().renderSync()}catch(t){}},ol.control.CenterPosition.prototype.setVisible=function(t){if(this.element.style.display=t?"":"none",this.getMap())try{this.getMap().renderSync()}catch(t){}},ol.control.CenterPosition.prototype.getVisible=function(){return"none"!==this.element.style.display},ol.control.CenterPosition.prototype._draw=function(t){if(this.getVisible()&&this.getMap()){var e=this.getMap().getView().getCenter();if(this.get("projection")&&(e=ol.proj.transform(e,this.getMap().getView().getProjection(),this.get("projection"))),e=this._format(e),this.element.textContent=e,this.get("canvas")){var o=this.getContext(t);if(o){var i=t.frameState.pixelRatio;o.save(),o.scale(i,i);var n=this.element.getBoundingClientRect(),r=this.getMap().getViewport().getBoundingClientRect(),s=this.getMap().getSize()[0]/r.width;o.translate((n.left-r.left)*s,(n.top-r.top)*s);var a=this.element.clientHeight,l=this.element.clientWidth;o.beginPath(),o.fillStyle=ol.color.asString(this.getTextFill().getColor()),o.strokeStyle=ol.color.asString(this.getTextStroke().getColor()),o.lineWidth=this.getTextStroke().getWidth(),o.textAlign="center",o.textBaseline="middle",o.font=this.getTextFont(),o.lineWidth&&o.strokeText(e,l/2,a/2),o.fillText(e,l/2,a/2),o.closePath(),o.restore()}}}},ol.control.Compass=function(t){t||(t={});var e=document.createElement("div");e.className="ol-control ol-compassctrl ol-unselectable ol-hidden"+(t.className?" "+t.className:""),e.style.position="absolute",e.style.visibility="hidden";var o=t.style instanceof ol.style.Stroke?new ol.style.Style({stroke:t.style}):t.style;t.style||(o=new ol.style.Style({stroke:new ol.style.Stroke({width:0})})),ol.control.CanvasBase.call(this,{element:e,style:o}),this.set("rotateVithView",!1!==t.rotateWithView),this.setVisible(!1!==t.visible),this.setImage(t.image||t.src)},ol.ext.inherits(ol.control.Compass,ol.control.CanvasBase),ol.control.Compass.prototype.setImage=function(t){if(t instanceof Image)this.img_=t,this.img_.onload=function(){if(this.getMap())try{this.getMap().renderSync()}catch(t){}}.bind(this);else if("string"==typeof t)switch(t){case"compact":this.img_=this.compactCompass_(this.element.clientWidth,this.getStroke().getColor());break;case"default":this.img_=this.defaultCompass_(this.element.clientWidth,this.getStroke().getColor());break;default:this.img_=new Image,this.img_.onload=function(){if(this.getMap())try{this.getMap().renderSync()}catch(t){}}.bind(this),this.img_.src=t}else this.img_=this.defaultCompass_(this.element.clientWidth,this.getStroke().getColor())},ol.control.Compass.prototype.compactCompass_=function(t,e){var o=document.createElement("canvas"),i=o.getContext("2d"),n=(t=o.width=o.height=t||150)/2;return i.translate(n,n),i.fillStyle=e||"#963",i.lineWidth=5,i.lineJoin=i.lineCap="round",i.font="bold "+.4*n+"px sans-serif",i.textBaseline="bottom",i.textAlign="center",i.strokeStyle="#fff",i.globalAlpha=.75,i.strokeText("N",0,-n/2),i.globalAlpha=1,i.fillText("N",0,-n/2),i.beginPath(),i.moveTo(0,n/4),i.lineTo(n/3,n/2),i.lineTo(0,-n/2),i.lineTo(-n/3,n/2),i.lineTo(0,n/4),i.lineWidth=12,i.fillStyle="#fff",i.globalAlpha=.75,i.fill(),i.stroke(),i.globalAlpha=1,i.fillStyle=i.strokeStyle=e||"#963",i.lineWidth=5,i.beginPath(),i.moveTo(0,n/4),i.lineTo(0,-n/2),i.lineTo(n/3,n/2),i.lineTo(0,n/4),i.fill(),i.stroke(),i.beginPath(),i.moveTo(0,n/4),i.lineTo(0,-n/2),i.lineTo(-n/3,n/2),i.lineTo(0,n/4),i.stroke(),o},ol.control.Compass.prototype.defaultCompass_=function(t,e){var o=document.createElement("canvas"),i=o.getContext("2d"),n=(t=o.width=o.height=t||150)/2,r=.22*n;function s(t,o){i.fillStyle=e||"#963",i.beginPath(),i.moveTo(0,0),i.lineTo(t,0),i.lineTo(o,o),i.moveTo(0,0),i.lineTo(-t,0),i.lineTo(-o,-o),i.moveTo(0,0),i.lineTo(0,t),i.lineTo(-o,o),i.moveTo(0,0),i.lineTo(0,-t),i.lineTo(o,-o),i.moveTo(0,0),i.fill(),i.stroke()}function a(t,e){i.globalCompositeOperation="destination-out",i.fillStyle="#fff",i.beginPath(),i.moveTo(0,0),i.lineTo(t,0),i.lineTo(e,-e),i.moveTo(0,0),i.lineTo(-t,0),i.lineTo(-e,e),i.moveTo(0,0),i.lineTo(0,t),i.lineTo(e,e),i.moveTo(0,0),i.lineTo(0,-t),i.lineTo(-e,-e),i.moveTo(0,0),i.fill(),i.globalCompositeOperation="source-over",i.beginPath(),i.moveTo(0,0),i.lineTo(t,0),i.lineTo(e,-e),i.moveTo(0,0),i.lineTo(-t,0),i.lineTo(-e,e),i.moveTo(0,0),i.lineTo(0,t),i.lineTo(e,e),i.moveTo(0,0),i.lineTo(0,-t),i.lineTo(-e,-e),i.moveTo(0,0),i.stroke()}return i.translate(n,n),i.strokeStyle=e||"#963",i.lineWidth=1.5,i.beginPath(),i.arc(0,0,.41*t,0,2*Math.PI),i.arc(0,0,.44*t,0,2*Math.PI),i.stroke(),i.rotate(Math.PI/4),s(.9*n,.8*r),a(.9*n,.8*r),i.rotate(-Math.PI/4),s(n,r),a(n,r),o},ol.control.Compass.prototype.getVisible=function(){return"block"===ol.ext.element.getStyle(this.element,"display")},ol.control.Compass.prototype.setVisible=function(t){t?this.element.classList.add("ol-visible"):this.element.classList.remove("ol-visible"),this.getMap()&&this.getMap().render()},ol.control.Compass.prototype._draw=function(t){var e=this.getContext(t);if(e&&this.getVisible()){var o,i=e.canvas,n=[];for(o=0;o<8;o++)n[o]=[Math.cos(Math.PI*o/8),Math.sin(Math.PI*o/8)];var r=t.frameState.pixelRatio;e.save(),e.scale(r,r);var s=this.element.clientWidth,a=this.element.clientHeight,l=this.element.offsetLeft,c=this.element.offsetTop,h=this.img_,p=t.frameState.viewState.rotation;if(e.beginPath(),e.translate(l+s/2,c+a/2),this.get("rotateVithView")&&e.rotate(p),this.getStroke().getWidth()){e.beginPath(),e.strokeStyle=this.getStroke().getColor(),e.lineWidth=this.getStroke().getWidth();var u=Math.max(i.width,i.height);for(o=0;o<8;o++)e.moveTo(-n[o][0]*u,-n[o][1]*u),e.lineTo(n[o][0]*u,n[o][1]*u);e.stroke()}h.width&&e.drawImage(h,-s/2,-a/2,s,a),e.closePath(),e.restore()}},ol.control.Dialog=function(t){(t=t||{}).fullscreen&&(t.target=document.body);var e=ol.ext.element.create("DIV",{className:((t.className||"")+(t.zoom?" ol-zoom":"")+" ol-ext-dialog").trim(),click:function(t){this.get("hideOnBack")&&t.target===e&&this.close(),this.get("hideOnClick")&&this.close()}.bind(this)}),o=ol.ext.element.create("FORM",{on:{submit:this._onButton("submit")},parent:e});ol.ext.element.create("H2",{parent:o}),ol.ext.element.create("DIV",{className:"ol-closebox",click:this._onButton("cancel"),parent:o}),ol.ext.element.create("DIV",{className:"ol-content",parent:o}),this._progress=ol.ext.element.create("DIV",{style:{display:"none"},parent:o});var i=ol.ext.element.create("DIV",{className:"ol-progress-bar",parent:this._progress});this._progressbar=ol.ext.element.create("DIV",{parent:i}),this._progressMessage=ol.ext.element.create("DIV",{className:"ol-progress-message",parent:this._progress}),ol.ext.element.create("DIV",{className:"ol-buttons",parent:o}),ol.control.Control.call(this,{element:e,target:t.target}),this.set("closeBox",!1!==t.closeBox),this.set("zoom",!!t.zoom),this.set("hideOnClick",!!t.hideOnClick),this.set("hideOnBack",!!t.hideOnBack),this.set("className",e.className),this.set("closeOnSubmit",t.closeOnSubmit),this.set("buttons",t.buttons),this.setContent(t)},ol.ext.inherits(ol.control.Dialog,ol.control.Control),ol.control.Dialog.prototype.show=function(t){t&&((t instanceof Element||"string"==typeof t)&&(t={content:t}),this.setContent(t)),this.element.classList.add("ol-visible");var e=this.element.querySelector('input[type="text"],input[type="search"],input[type="number"]');if(e&&e.focus(),this.dispatchEvent({type:"show"}),t){if(t.autoclose){var o=setTimeout(function(){this.hide()}.bind(this),t.autoclose);this.once("hide",function(){clearTimeout(o)})}if(t.hideOnBack){var i=this.get("hideOnBack");this.set("hideOnBack",!0),this.once("hide",function(){this.set("hideOnBack",i)}.bind(this))}}},ol.control.Dialog.prototype.open=function(){this.show()},ol.control.Dialog.prototype.setContentMessage=function(t){if(void 0!==t){var e=this.getContentElement();t instanceof Element&&ol.ext.element.setHTML(e,""),ol.ext.element.setHTML(e,t||"")}},ol.control.Dialog.prototype.setTitle=function(t){var e=this.element.querySelector("form");e.querySelector("h2").innerText=t||"",t?e.classList.add("ol-title"):e.classList.remove("ol-title")},ol.control.Dialog.prototype.setContent=function(t){if(t){this.element.className=this.get("className"),"string"==typeof t&&(t={content:t}),t=t||{},this.setProgress(!1),t.max&&this.setProgress(0,t.max),void 0!==t.progress&&this.setProgress(t.progress),this.get("zoom")?this.element.classList.add("ol-zoom"):this.element.classList.remove("ol-zoom"),t.className&&t.className.split(" ").forEach(function(t){this.element.classList.add(t)}.bind(this));var e=this.element.querySelector("form");void 0!==t.content&&(t.content instanceof Element&&ol.ext.element.setHTML(e.querySelector(".ol-content"),""),ol.ext.element.setHTML(e.querySelector(".ol-content"),t.content||"")),this.setTitle(t.title),t.closeBox||this.get("closeBox")&&!1!==t.closeBox?e.classList.add("ol-closebox"):e.classList.remove("ol-closebox");var o=this.element.querySelector(".ol-buttons");o.innerHTML="";var i=t.buttons||this.get("buttons");if(i)for(var n in e.classList.add("ol-button"),i)ol.ext.element.create("INPUT",{type:"submit"===n?"submit":"button",value:i[n],click:this._onButton(n,t.onButton),parent:o});else e.classList.remove("ol-button")}},ol.control.Dialog.prototype.getContentElement=function(){return this.element.querySelector("form .ol-content")},ol.control.Dialog.prototype.setProgress=function(t,e,o){if(!1!==t){if(e>0?this.set("max",Number(e)):e=this.get("max"),e){var i=Math.round(t/e*100);ol.ext.element.setStyle(this._progress,{display:""}),this._progressbar.className=i?"":"notransition",ol.ext.element.setStyle(this._progressbar,{width:i+"%"})}else ol.ext.element.setStyle(this._progress,{display:"none"});this._progressMessage.innerHTML="",ol.ext.element.setHTML(this._progressMessage,o||"")}else ol.ext.element.setStyle(this._progress,{display:"none"})},ol.control.Dialog.prototype._onButton=function(t,e){return function(o){o.preventDefault(),"submit"===t&&!1===this.get("closeOnSubmit")||this.hide();var i=this.getInputs();this.dispatchEvent({type:"button",button:t,inputs:i}),"function"==typeof e&&e(t,i)}.bind(this)},ol.control.Dialog.prototype.getInputs=function(){var t={};return["input","textarea","select"].forEach(function(e){this.element.querySelectorAll("form "+e).forEach(function(e){e.className&&e.className.split(" ").forEach(function(o){t[o]=e})})}.bind(this)),t},ol.control.Dialog.prototype.hide=function(){this.element.classList.remove("ol-visible"),this.dispatchEvent({type:"hide"})},ol.control.Dialog.prototype.close=ol.control.Dialog.prototype.hide,ol.control.Dialog.prototype.isOpen=function(){return this.element.classList.contains("ol-visible")},ol.control.Disable=function(t){t=t||{};var e=document.createElement("div");e.className=(t.className||" ol-disable ol-unselectable ol-control").trim();var o={top:"0px",left:"0px",right:"0px",bottom:"0px",zIndex:1e4,background:"none",display:"none"};Object.keys(o).forEach(function(t){e.style[t]=o[t]}),ol.control.Control.call(this,{element:e})},ol.ext.inherits(ol.control.Disable,ol.control.Control),ol.control.Disable.prototype.isOn=function(){return this.element.classList.contains("ol-disable")},ol.control.Disable.prototype.disableMap=function(t){t?this.element.classList.add("ol-enable").show():this.element.classList.remove("ol-enable").hide()},ol.control.EditBar=function(t){(t=t||{}).interactions=t.interactions||{},ol.control.Bar.call(this,{className:(t.className?t.className+" ":"")+"ol-editbar",toggleOne:!0,target:t.target}),this._source=t.source,this._interactions={},this._setSelectInteraction(t),!1!==t.edition&&this._setEditInteraction(t),this._setModifyInteraction(t)},ol.ext.inherits(ol.control.EditBar,ol.control.Bar),ol.control.EditBar.prototype.setMap=function(t){this.getMap()&&(this._interactions.Delete&&this.getMap().removeInteraction(this._interactions.Delete),this._interactions.ModifySelect&&this.getMap().removeInteraction(this._interactions.ModifySelect)),ol.control.Bar.prototype.setMap.call(this,t),this.getMap()&&(this._interactions.Delete&&this.getMap().addInteraction(this._interactions.Delete),this._interactions.ModifySelect&&this.getMap().addInteraction(this._interactions.ModifySelect))},ol.control.EditBar.prototype.getInteraction=function(t){return this._interactions[t]},ol.control.EditBar.prototype._getTitle=function(t){if(t)return t.get?t.get("title"):"string"==typeof t?t:t.title},ol.control.EditBar.prototype._setSelectInteraction=function(t){var e,o=this,i=new ol.control.Bar;if(!1!==t.interactions.Delete){t.interactions.Delete instanceof ol.interaction.Delete?this._interactions.Delete=t.interactions.Delete:this._interactions.Delete=new ol.interaction.Delete;var n=this._interactions.Delete;n.setActive(!1),this.getMap()&&this.getMap().addInteraction(n),i.addControl(new ol.control.Button({className:"ol-delete",title:this._getTitle(t.interactions.Delete)||"Delete",name:"Delete",handleClick:function(t){n.delete(e.getInteraction().getFeatures());var o={type:"select",selected:[],deselected:e.getInteraction().getFeatures().getArray().slice(),mapBrowserEvent:t.mapBrowserEvent};e.getInteraction().getFeatures().clear(),e.getInteraction().dispatchEvent(o)}}))}if(!1!==t.interactions.Info&&i.addControl(new ol.control.Button({className:"ol-info",name:"Info",title:this._getTitle(t.interactions.Info)||"Show informations",handleClick:function(){o.dispatchEvent({type:"info",features:e.getInteraction().getFeatures()})}})),!1!==t.interactions.Select){t.interactions.Select instanceof ol.interaction.Select?this._interactions.Select=t.interactions.Select:this._interactions.Select=new ol.interaction.Select({condition:ol.events.condition.click});var r=this._interactions.Select;e=new ol.control.Toggle({className:"ol-selection",name:"Select",title:this._getTitle(t.interactions.Select)||"Select",interaction:r,bar:i.getControls().length?i:void 0,autoActivate:!0,active:!0}),this.addControl(e),r.on("change:active",function(){r.getFeatures().clear()})}},ol.control.EditBar.prototype._setEditInteraction=function(t){if(!1!==t.interactions.DrawPoint){t.interactions.DrawPoint instanceof ol.interaction.Draw?this._interactions.DrawPoint=t.interactions.DrawPoint:this._interactions.DrawPoint=new ol.interaction.Draw({type:"Point",source:this._source});var e=new ol.control.Toggle({className:"ol-drawpoint",name:"DrawPoint",title:this._getTitle(t.interactions.DrawPoint)||"Point",interaction:this._interactions.DrawPoint});this.addControl(e)}if(!1!==t.interactions.DrawLine){t.interactions.DrawLine instanceof ol.interaction.Draw?this._interactions.DrawLine=t.interactions.DrawLine:this._interactions.DrawLine=new ol.interaction.Draw({type:"LineString",source:this._source,geometryFunction:function(t,e){return e?e.setCoordinates(t):e=new ol.geom.LineString(t),this.nbpts=e.getCoordinates().length,e}});var o=new ol.control.Toggle({className:"ol-drawline",title:this._getTitle(t.interactions.DrawLine)||"LineString",name:"DrawLine",interaction:this._interactions.DrawLine,bar:new ol.control.Bar({controls:[new ol.control.TextButton({html:this._getTitle(t.interactions.UndoDraw)||"undo",title:this._getTitle(t.interactions.UndoDraw)||"delete last point",handleClick:function(){o.getInteraction().nbpts>1&&o.getInteraction().removeLastPoint()}}),new ol.control.TextButton({html:this._getTitle(t.interactions.FinishDraw)||"finish",title:this._getTitle(t.interactions.FinishDraw)||"finish",handleClick:function(){o.getInteraction().nbpts>2&&o.getInteraction().finishDrawing()}})]})});this.addControl(o)}if(!1!==t.interactions.DrawPolygon&&(t.interactions.DrawPolygon instanceof ol.interaction.Draw?this._interactions.DrawPolygon=t.interactions.DrawPolygon:this._interactions.DrawPolygon=new ol.interaction.Draw({type:"Polygon",source:this._source,geometryFunction:function(t,e){return this.nbpts=t[0].length,e?e.setCoordinates([t[0].concat([t[0][0]])]):e=new ol.geom.Polygon(t),e}}),this._setDrawPolygon("ol-drawpolygon",this._interactions.DrawPolygon,this._getTitle(t.interactions.DrawPolygon)||"Polygon","DrawPolygon",t)),!1!==t.interactions.DrawHole&&(t.interactions.DrawHole instanceof ol.interaction.DrawHole?this._interactions.DrawHole=t.interactions.DrawHole:this._interactions.DrawHole=new ol.interaction.DrawHole,this._setDrawPolygon("ol-drawhole",this._interactions.DrawHole,this._getTitle(t.interactions.DrawHole)||"Hole","DrawHole",t)),!1!==t.interactions.DrawRegular){var i={pts:"pts",circle:"circle"};t.interactions.DrawRegular instanceof ol.interaction.DrawRegular?(this._interactions.DrawRegular=t.interactions.DrawRegular,i.pts=this._interactions.DrawRegular.get("ptsLabel")||i.pts,i.circle=this._interactions.DrawRegular.get("circleLabel")||i.circle):(this._interactions.DrawRegular=new ol.interaction.DrawRegular({source:this._source,sides:4}),t.interactions.DrawRegular&&(i.pts=t.interactions.DrawRegular.ptsLabel||i.pts,i.circle=t.interactions.DrawRegular.circleLabel||i.circle));var n=this._interactions.DrawRegular,r=document.createElement("DIV"),s=ol.ext.element.create("DIV",{parent:r});ol.ext.element.addListener(s,["click","touchstart"],function(){var t=n.getSides()-1;t<2&&(t=2),n.setSides(t),a.textContent=t>2?t+" "+i.pts:i.circle}.bind(this));var a=ol.ext.element.create("TEXT",{html:"4 "+i.pts,parent:r}),l=ol.ext.element.create("DIV",{parent:r});ol.ext.element.addListener(l,["click","touchstart"],function(){var t=n.getSides()+1;t<3&&(t=3),n.setSides(t),a.textContent=t+" "+i.pts}.bind(this));var c=new ol.control.Toggle({className:"ol-drawregular",title:this._getTitle(t.interactions.DrawRegular)||"Regular",name:"DrawRegular",interaction:this._interactions.DrawRegular,bar:new ol.control.Bar({controls:[new ol.control.TextButton({html:r})]})});this.addControl(c)}},ol.control.EditBar.prototype._setDrawPolygon=function(t,e,o,i,n){var r=new ol.control.Toggle({className:t,name:i,title:o,interaction:e,bar:new ol.control.Bar({controls:[new ol.control.TextButton({html:this._getTitle(n.interactions.UndoDraw)||"undo",title:this._getTitle(n.interactions.UndoDraw)||"undo last point",handleClick:function(){r.getInteraction().nbpts>1&&r.getInteraction().removeLastPoint()}}),new ol.control.TextButton({html:this._getTitle(n.interactions.FinishDraw)||"finish",title:this._getTitle(n.interactions.FinishDraw)||"finish",handleClick:function(){r.getInteraction().nbpts>3&&r.getInteraction().finishDrawing()}})]})});return this.addControl(r),r},ol.control.EditBar.prototype._setModifyInteraction=function(t){if(!1!==t.interactions.ModifySelect&&!1!==t.interactions.Select&&(t.interactions.ModifySelect instanceof ol.interaction.ModifyFeature?this._interactions.ModifySelect=t.interactions.ModifySelect:this._interactions.ModifySelect=new ol.interaction.ModifyFeature({features:this.getInteraction("Select").getFeatures()}),this.getMap()&&this.getMap().addInteraction(this._interactions.ModifySelect),this._interactions.ModifySelect.setActive(this._interactions.Select.getActive()),this._interactions.Select.on("change:active",function(){this._interactions.ModifySelect.setActive(this._interactions.Select.getActive())}.bind(this))),!1!==t.interactions.Transform){t.interactions.Transform instanceof ol.interaction.Transform?this._interactions.Transform=t.interactions.Transform:this._interactions.Transform=new ol.interaction.Transform({addCondition:ol.events.condition.shiftKeyOnly});var e=new ol.control.Toggle({html:"<i></i>",className:"ol-transform",title:this._getTitle(t.interactions.Transform)||"Transform",name:"Transform",interaction:this._interactions.Transform});this.addControl(e)}if(!1!==t.interactions.Split){t.interactions.Split instanceof ol.interaction.Split?this._interactions.Split=t.interactions.Split:this._interactions.Split=new ol.interaction.Split({sources:this._source});var o=new ol.control.Toggle({className:"ol-split",title:this._getTitle(t.interactions.Split)||"Split",name:"Split",interaction:this._interactions.Split});this.addControl(o)}if(!1!==t.interactions.Offset){t.interactions.Offset instanceof ol.interaction.Offset?this._interactions.Offset=t.interactions.Offset:this._interactions.Offset=new ol.interaction.Offset({source:this._source});var i=new ol.control.Toggle({html:"<i></i>",className:"ol-offset",title:this._getTitle(t.interactions.Offset)||"Offset",name:"Offset",interaction:this._interactions.Offset});this.addControl(i)}},ol.control.Gauge=function(t){t=t||{};var e=ol.ext.element.create("DIV",{className:((t.className||"")+" ol-gauge ol-unselectable ol-control").trim()});this.title_=ol.ext.element.create("SPAN",{parent:e});var o=ol.ext.element.create("DIV",{parent:e});this.gauge_=ol.ext.element.create("BUTTON",{type:"button",style:{width:"0px"},parent:o}),ol.control.Control.call(this,{element:e,target:t.target}),this.setTitle(t.title),this.set("max",t.max||100),this.val(t.val)},ol.ext.inherits(ol.control.Gauge,ol.control.Control),ol.control.Gauge.prototype.setTitle=function(t){this.title_.innerHTML=t||"",this.title_.display=t?"":"none"},ol.control.Gauge.prototype.val=function(t){return void 0!==t&&(this.val_=t,this.gauge_.style.width=t/this.get("max")*100+"%"),this.val_},ol.control.GeoBookmark=function(t){t=t||{};var e=this,o=document.createElement("div");t.target?o.className=t.className||"ol-bookmark":(o.className=(t.className||"ol-bookmark")+" ol-unselectable ol-control ol-collapsed",o.addEventListener("mouseleave",function(){r!==document.activeElement&&(i.style.display="none")}),this.button=ol.ext.element.create("BUTTON",{type:"button",title:t.title||"Geobookmarks",click:function(){var t=""===i.style.display||"none"===i.style.display;i.style.display=t?"block":"none",t&&this.setBookmarks()}.bind(this)}),o.appendChild(this.button));var i=document.createElement("div");o.appendChild(i);var n=document.createElement("ul");i.appendChild(n);var r=document.createElement("input");r.setAttribute("placeholder",t.placeholder||"Add a new geomark..."),r.addEventListener("keydown",function(t){if(t.stopPropagation(),13===t.keyCode){t.preventDefault();var o=this.value;o&&(e.addBookmark(o),this.value="",e.dispatchEvent({type:"add",name:o})),i.style.display="none"}}),r.addEventListener("blur",function(){i.style.display="none"}),i.appendChild(r),ol.control.Control.call(this,{element:o,target:t.target}),this.on("propertychange",function(t){"editable"===t.key&&(o.className=o.className.replace(" ol-editable",""),this.get("editable")&&(o.className+=" ol-editable"))}.bind(this)),this.set("namespace",t.namespace||"ol"),this.set("editable",!1!==t.editable),this.set("deleteTitle",t.deleteTitle||"Suppr.");var s={};try{localStorage[this.get("namespace")+"@bookmark"]&&(s=JSON.parse(localStorage[this.get("namespace")+"@bookmark"]))}catch(t){console.warn("Failed to access localStorage...")}if(t.marks)for(var a in t.marks)s[a]=t.marks[a];this.setBookmarks(s)},ol.ext.inherits(ol.control.GeoBookmark,ol.control.Control),ol.control.GeoBookmark.prototype.setBookmarks=function(t){if(!t){t={};try{t=JSON.parse(localStorage[this.get("namespace")+"@bookmark"]||"{}")}catch(t){console.warn("Failed to access localStorage...")}}var e=this.get("editable"),o=this.element.querySelector("ul"),i=this.element.querySelector("div"),n=this;for(var r in o.innerHTML="",t){var s=document.createElement("li");if(s.textContent=r,s.setAttribute("data-bookmark",JSON.stringify(t[r])),s.setAttribute("data-name",r),s.addEventListener("click",function(){var t=JSON.parse(this.getAttribute("data-bookmark"));n.getMap().getView().setCenter(t.pos),n.getMap().getView().setZoom(t.zoom),n.getMap().getView().setRotation(t.rot||0),i.style.display="none",n.dispatchEvent({type:"select",name:this.getAttribute("data-name"),bookmark:t})}),o.appendChild(s),e&&!t[r].permanent){var a=document.createElement("button");a.setAttribute("data-name",r),a.setAttribute("type","button"),a.setAttribute("title",this.get("deleteTitle")||"Suppr."),a.addEventListener("click",function(t){n.removeBookmark(this.getAttribute("data-name")),n.dispatchEvent({type:"remove",name:this.getAttribute("data-name")}),t.stopPropagation()}),s.appendChild(a)}}try{localStorage[this.get("namespace")+"@bookmark"]=JSON.stringify(t)}catch(t){console.warn("Failed to access localStorage...")}},ol.control.GeoBookmark.prototype.getBookmarks=function(){var t={};try{t=JSON.parse(localStorage[this.get("namespace")+"@bookmark"]||"{}")}catch(t){console.warn("Failed to access localStorage...")}return t},ol.control.GeoBookmark.prototype.removeBookmark=function(t){if(t){var e=this.getBookmarks();delete e[t],this.setBookmarks(e)}},ol.control.GeoBookmark.prototype.addBookmark=function(t,e,o,i){if(t){var n,r=e;r&&r.position?(o=r.zoom,i=r.permanent,n=r.rotation,e=r.position):n=this.getMap().getView().getRotation();var s=this.getBookmarks();s[t]&&s[t].permanent||(s[t]={pos:e||this.getMap().getView().getCenter(),zoom:o||this.getMap().getView().getZoom(),permanent:!!i},n&&(s[t].rot=n),this.setBookmarks(s))}},ol.control.GeolocationBar=function(t){t||(t={}),t.className=t.className||"ol-geobar",ol.control.Bar.call(this,t),this.setPosition(t.position||"bottom-right");var e=this.element,o=new ol.interaction.GeolocationDraw({source:t.source,zoom:t.zoom,minZoom:t.minZoom,tolerance:t.tolerance,followTrack:t.followTrack,minAccuracy:t.minAccuracy||1e4});this._geolocBt=new ol.control.Toggle({className:"geolocBt",interaction:o,onToggle:function(){o.pause(!0),o.setFollowTrack(t.followTrack),e.classList.remove("pauseTrack")}}),this.addControl(this._geolocBt),this._geolocBt.setActive(!1);var i=new ol.control.Bar;this.addControl(i);var n=new ol.control.TextButton({className:"centerBt",html:t.centerLabel||"center",handleClick:function(){o.setFollowTrack("auto")}});i.addControl(n);var r=new ol.control.Button({className:"startBt",handleClick:function(){o.pause(!1),o.setFollowTrack("auto"),e.classList.add("pauseTrack")}});i.addControl(r);var s=new ol.control.Button({className:"pauseBt",handleClick:function(){o.pause(!0),o.setFollowTrack("auto"),e.classList.remove("pauseTrack")}});i.addControl(s),o.on("follow",function(t){t.following?e.classList.remove("centerTrack"):e.classList.add("centerTrack")}),this._geolocBt.on("change:active",function(t){t.active?e.classList.add("ol-active"):e.classList.remove("ol-active")})},ol.ext.inherits(ol.control.GeolocationBar,ol.control.Bar),ol.control.GeolocationBar.prototype.setMap=function(t){this._listener&&ol.Observable.unByKey(this._listener),this._listener=null,ol.control.Bar.prototype.setMap.call(this,t),t&&(this._listener=t.on("moveend",function(){var e=this.getInteraction();e.getActive()&&"auto"===e.get("followTrack")&&e.path_.length&&e.path_[e.path_.length-1][0]!==t.getView().getCenter()[0]&&this.element.classList.add("centerTrack")}.bind(this)))},ol.control.GeolocationBar.prototype.getInteraction=function(){return this._geolocBt.getInteraction()},ol.control.GeolocationButton=function(t){t||(t={}),t.followTrack=t.followTrack||"auto",t.zoom=t.zoom||16;var e,o=new ol.interaction.GeolocationDraw(t);ol.control.Toggle.call(this,{className:t.className=((t.className||"")+" ol-geobt").trim(),interaction:o,title:t.title||"Geolocation",onToggle:function(){o.pause(!0),o.setFollowTrack(t.followTrack||"auto")}}),this.setActive(!1),o.on("tracking",function(t){this.dispatchEvent({type:"position",coordinate:t.geolocation.getPosition()})}.bind(this)),o.on("change:active",function(){this.dispatchEvent({type:"position"}),e&&(clearTimeout(e),e=null),o.getActive()&&(e=setTimeout(function(){o.setActive(!1),e=null}.bind(this),t.delay||3e3))}.bind(this))},ol.ext.inherits(ol.control.GeolocationButton,ol.control.Toggle),ol.control.Globe=function(t){var e,o=t||{},i=this;o.target?(e=document.createElement("div"),this.panel_=o.target):((e=document.createElement("div")).classList.add("ol-globe","ol-unselectable","ol-control"),/top/.test(o.align)&&e.classList.add("ol-control-top"),/right/.test(o.align)&&e.classList.add("ol-control-right"),this.panel_=document.createElement("div"),this.panel_.classList.add("panel"),e.appendChild(this.panel_),this.pointer_=document.createElement("div"),this.pointer_.classList.add("ol-pointer"),e.appendChild(this.pointer_)),ol.control.Control.call(this,{element:e,target:o.target}),this.ovmap_=new ol.Map({controls:new ol.Collection,interactions:new ol.Collection,target:this.panel_,view:new ol.View({zoom:0,center:[0,0]}),layers:o.layers}),setTimeout(function(){i.ovmap_.updateSize()},0),this.set("follow",o.follow||!1),this.extentLayer=new ol.layer.Vector({name:"Cache extent",source:new ol.source.Vector,style:o.style||[new ol.style.Style({image:new ol.style.Circle({fill:new ol.style.Fill({color:"rgba(255,0,0, 1)"}),stroke:new ol.style.Stroke({width:7,color:"rgba(255,0,0, 0.8)"}),radius:5})})]}),this.ovmap_.addLayer(this.extentLayer)},ol.ext.inherits(ol.control.Globe,ol.control.Control),ol.control.Globe.prototype.setMap=function(t){this._listener&&ol.Observable.unByKey(this._listener),this._listener=null,ol.control.Control.prototype.setMap.call(this,t),t&&(this._listener=t.getView().on("propertychange",this.setView.bind(this)),this.setView())},ol.control.Globe.prototype.setView=function(){this.getMap()&&this.get("follow")&&this.setCenter(this.getMap().getView().getCenter())},ol.control.Globe.prototype.getGlobe=function(){return this.ovmap_},ol.control.Globe.prototype.show=function(t){!1!==t?this.element.classList.remove("ol-collapsed"):this.element.classList.add("ol-collapsed"),this.ovmap_.updateSize()},ol.control.Globe.prototype.setPosition=function(t){/top/.test(t)?this.element.classList.add("ol-control-top"):this.element.classList.remove("ol-control-top"),/right/.test(t)?this.element.classList.add("ol-control-right"):this.element.classList.remove("ol-control-right")},ol.control.Globe.prototype.setCenter=function(t,e){var o=this;if(this.pointer_.classList.add("hidden"),t){var i=this.ovmap_,n=i.getPixelFromCoordinate(t);if(n){if(!1!==e){var r=this.element.clientHeight;setTimeout(function(){o.pointer_.style.top=String(Math.min(Math.max(n[1],0),r))+"px",o.pointer_.style.left="50%",o.pointer_.classList.remove("hidden")},800)}i.getView().animate({center:[t[0],0]})}}},ol.control.Graticule=function(t){t||(t={});var e=document.createElement("div");e.className="ol-graticule ol-unselectable ol-hidden",ol.control.CanvasBase.call(this,{element:e}),this.set("projection",t.projection||"EPSG:4326");var o=new ol.proj.Projection({code:this.get("projection")}).getMetersPerUnit();for(this.fac=1;o/this.fac>10;)this.fac*=10;this.fac=1e4/this.fac,this.set("maxResolution",t.maxResolution||1/0),this.set("step",t.step||.1),this.set("stepCoord",t.stepCoord||1),this.set("spacing",t.spacing||40),this.set("margin",t.margin||0),this.set("borderWidth",t.borderWidth||5),this.set("stroke",!1!==t.stroke),this.formatCoord=t.formatCoord||function(t){return t},t.style instanceof ol.style.Style?this.setStyle(t.style):this.setStyle(new ol.style.Style({stroke:new ol.style.Stroke({color:"#000",width:1}),fill:new ol.style.Fill({color:"#fff"}),text:new ol.style.Text({stroke:new ol.style.Stroke({color:"#fff",width:2}),fill:new ol.style.Fill({color:"#000"})})}))},ol.ext.inherits(ol.control.Graticule,ol.control.CanvasBase),ol.control.Graticule.prototype.setStyle=function(t){this._style=t},ol.control.Graticule.prototype._draw=function(t){if(!(this.get("maxResolution")<t.frameState.viewState.resolution)){for(var e,o=this.getContext(t),i=o.canvas,n=t.frameState.pixelRatio,r=i.width/n,s=i.height/n,a=this.get("projection"),l=this.getMap(),c=[l.getCoordinateFromPixel([0,0]),l.getCoordinateFromPixel([r,0]),l.getCoordinateFromPixel([r,s]),l.getCoordinateFromPixel([0,s])],h=-1/0,p=1/0,u=-1/0,g=1/0,d=0;e=c[d];d++)c[d]=ol.proj.transform(e,l.getView().getProjection(),a),h=Math.max(h,c[d][0]),p=Math.min(p,c[d][0]),u=Math.max(u,c[d][1]),g=Math.min(g,c[d][1]);var m=this.get("spacing"),f=this.get("step"),y=this.get("stepCoord"),v=this.get("borderWidth"),_=this.get("margin");if((h-p)/f*m>r)(f*=Math.round((h-p)/r*m/f))>this.fac&&(f=Math.round(f/this.fac)*this.fac);p=Math.floor(p/f)*f-f,g=Math.floor(g/f)*f-f,h=Math.floor(h/f)*f+2*f,u=Math.floor(u/f)*f+2*f;var x=ol.proj.get(a).getExtent();x&&(p<x[0]&&(p=x[0]),g<x[1]&&(g=x[1]),h>x[2]&&(h=x[2]+f),u>x[3]&&(u=x[3]+f));var b=this.getStyle().getStroke()&&this.get("stroke"),w=this.getStyle().getText(),S=this.getStyle().getFill();o.save(),o.scale(n,n),o.beginPath(),o.rect(_,_,r-2*_,s-2*_),o.clip(),o.beginPath();var C,M,E,T,L,P={top:[],left:[],bottom:[],right:[]};for(C=p;C<h;C+=f)for(T=ol.proj.transform([C,g],a,l.getView().getProjection()),T=l.getPixelFromCoordinate(T),b&&o.moveTo(T[0],T[1]),E=T,M=g+f;M<=u;M+=f)L=ol.proj.transform([C,M],a,l.getView().getProjection()),L=l.getPixelFromCoordinate(L),b&&o.lineTo(L[0],L[1]),E[1]>0&&L[1]<0&&P.top.push([C,E]),E[1]>s&&L[1]<s&&P.bottom.push([C,E]),E=L;for(M=g;M<u;M+=f)for(T=ol.proj.transform([p,M],a,l.getView().getProjection()),T=l.getPixelFromCoordinate(T),b&&o.moveTo(T[0],T[1]),E=T,C=p+f;C<=h;C+=f)L=ol.proj.transform([C,M],a,l.getView().getProjection()),L=l.getPixelFromCoordinate(L),b&&o.lineTo(L[0],L[1]),E[0]<0&&L[0]>0&&P.left.push([M,E]),E[0]<r&&L[0]>r&&P.right.push([M,E]),E=L;if(b&&(o.strokeStyle=this.getStyle().getStroke().getColor(),o.lineWidth=this.getStyle().getStroke().getWidth(),o.stroke()),w){var k,A;o.fillStyle=this.getStyle().getText().getFill().getColor(),o.strokeStyle=this.getStyle().getText().getStroke().getColor(),o.lineWidth=this.getStyle().getText().getStroke().getWidth(),o.font=this.getStyle().getText().getFont(),o.textAlign="center",o.textBaseline="hanging";var I=(S?v:0)+_+2;for(d=0;k=P.top[d];d++)Math.round(k[0]/this.get("step"))%y||(A=this.formatCoord(k[0],"top"),o.strokeText(A,k[1][0],I),o.fillText(A,k[1][0],I));for(o.textBaseline="alphabetic",d=0;k=P.bottom[d];d++)Math.round(k[0]/this.get("step"))%y||(A=this.formatCoord(k[0],"bottom"),o.strokeText(A,k[1][0],s-I),o.fillText(A,k[1][0],s-I));for(o.textBaseline="middle",o.textAlign="left",d=0;k=P.left[d];d++)Math.round(k[0]/this.get("step"))%y||(A=this.formatCoord(k[0],"left"),o.strokeText(A,I,k[1][1]),o.fillText(A,I,k[1][1]));for(o.textAlign="right",d=0;k=P.right[d];d++)Math.round(k[0]/this.get("step"))%y||(A=this.formatCoord(k[0],"right"),o.strokeText(A,r-I,k[1][1]),o.fillText(A,r-I,k[1][1]))}if(S){var F,N,D=this.getStyle().getFill().getColor();for((N=this.getStyle().getStroke())?F=this.getStyle().getStroke().getColor():(F=D,D="#fff"),o.strokeStyle=F,o.lineWidth=N?N.getWidth():1,d=1;d<P.top.length;d++)o.beginPath(),o.rect(P.top[d-1][1][0],_,P.top[d][1][0]-P.top[d-1][1][0],v),o.fillStyle=Math.round(P.top[d][0]/f)%2?F:D,o.fill(),o.stroke();for(d=1;d<P.bottom.length;d++)o.beginPath(),o.rect(P.bottom[d-1][1][0],s-v-_,P.bottom[d][1][0]-P.bottom[d-1][1][0],v),o.fillStyle=Math.round(P.bottom[d][0]/f)%2?F:D,o.fill(),o.stroke();for(d=1;d<P.left.length;d++)o.beginPath(),o.rect(_,P.left[d-1][1][1],v,P.left[d][1][1]-P.left[d-1][1][1]),o.fillStyle=Math.round(P.left[d][0]/f)%2?F:D,o.fill(),o.stroke();for(d=1;d<P.right.length;d++)o.beginPath(),o.rect(r-v-_,P.right[d-1][1][1],v,P.right[d][1][1]-P.right[d-1][1][1]),o.fillStyle=Math.round(P.right[d][0]/f)%2?F:D,o.fill(),o.stroke();o.beginPath(),o.fillStyle=F,o.rect(_,_,v,v),o.rect(_,s-v-_,v,v),o.rect(r-v-_,_,v,v),o.rect(r-v-_,s-v-_,v,v),o.fill()}o.restore()}},ol.control.GridReference=function(t){t||(t={});var e=document.createElement("div");e.className=(t.target?"":"ol-control ")+"ol-gridreference ol-unselectable "+(t.className||""),t.style=t.style||new ol.style.Style({stroke:new ol.style.Stroke({color:"#000",width:1}),text:new ol.style.Text({font:"bold 14px Arial",stroke:new ol.style.Stroke({color:"#fff",width:2}),fill:new ol.style.Fill({color:"#000"})})}),ol.control.CanvasBase.call(this,{element:e,target:t.target,style:t.style}),"function"==typeof t.property&&(this.getFeatureName=t.property),"function"==typeof t.sortFeatures&&(this.sortFeatures=t.sortFeatures),"function"==typeof t.indexTitle&&(this.indexTitle=t.indexTitle),this.source_=t.source,t.source&&(this.setIndex(t.source.getFeatures(),t),t.source.once("change",function(){"ready"===t.source.getState()&&this.setIndex(t.source.getFeatures(),t)}.bind(this))),this.set("maxResolution",t.maxResolution||1/0),this.set("extent",t.extent),this.set("size",t.size),this.set("margin",t.margin||0),this.set("property",t.property||"name"),this.set("filterLabel",t.filterLabel||"filter")},ol.ext.inherits(ol.control.GridReference,ol.control.CanvasBase),ol.control.GridReference.prototype.setMap=function(t){ol.control.CanvasBase.prototype.setMap.call(this,t),this.setIndex(this.source_.getFeatures())},ol.control.GridReference.prototype.getFeatureName=function(t){return t.get(this.get("property")||"name")},ol.control.GridReference.prototype.sortFeatures=function(t,e){return this.getFeatureName(t)==this.getFeatureName(e)?0:this.getFeatureName(t)<this.getFeatureName(e)?-1:1},ol.control.GridReference.prototype.indexTitle=function(t){return this.getFeatureName(t).charAt(0)},ol.control.GridReference.prototype.setIndex=function(t){if(this.getMap()){var e=this;t.getArray&&(t=t.getArray()),t.sort(function(t,o){return e.sortFeatures(t,o)}),this.element.innerHTML="";var o=this.element,i=document.createElement("input");i.setAttribute("type","search"),i.setAttribute("placeholder",this.get("filterLabel")||"filter");var n=function(){var t=this.value.replace(/^\*/,""),e=new RegExp(t,"i"),o=a.querySelectorAll("li");Array.prototype.forEach.call(o,function(t){t.classList.contains("ol-title")?t.style.display="":e.test(t.querySelector(".ol-name").textContent)?t.style.display="":t.style.display="none"}),Array.prototype.forEach.call(a.querySelectorAll("li.ol-title"),function(t){for(var e,i=!1,n=0;n<o.length;n++){if(i){if(o[n].classList.contains("ol-title"))break;if(!o[n].style.display){e=o[n];break}}o[n]===t&&(i=!0)}t.style.display=e?"":"none"})};i.addEventListener("search",n),i.addEventListener("keyup",n),o.appendChild(i);var r,s,a=document.createElement("ul");o.appendChild(a),t.forEach(function(t){if(r=this.getReference(t.getGeometry().getFirstCoordinate())){var e=this.getFeatureName(t),o=this.indexTitle(t);if(o!=s){var i=document.createElement("li");i.classList.add("ol-title"),i.textContent=o,a.appendChild(i)}s=o;var n=document.createElement("li"),l=document.createElement("span");l.classList.add("ol-name"),l.textContent=e,n.appendChild(l);var c=document.createElement("span");c.classList.add("ol-ref"),c.textContent=r,n.appendChild(c);var h=t;n.addEventListener("click",function(){this.dispatchEvent({type:"select",feature:h})}.bind(this)),a.appendChild(n)}}.bind(this))}},ol.control.GridReference.prototype.getReference=function(t){if(this.getMap()){var e=this.get("extent"),o=this.get("size"),i=Math.floor((t[0]-e[0])/(e[2]-e[0])*o[0]);if(i<0||i>=o[0])return"";var n=Math.floor((e[3]-t[1])/(e[3]-e[1])*o[1]);return n<0||n>=o[1]?"":this.getHIndex(i)+this.getVIndex(n)}},ol.control.GridReference.prototype.getVIndex=function(t){return t},ol.control.GridReference.prototype.getHIndex=function(t){return String.fromCharCode(65+t)},ol.control.GridReference.prototype._draw=function(t){if(!(this.get("maxResolution")<t.frameState.viewState.resolution)){var e=this.getContext(t),o=e.canvas,i=t.frameState.pixelRatio,n=o.width/i,r=o.height/i,s=this.get("extent"),a=this.get("size"),l=this.getMap(),c=ol.extent.boundingExtent([l.getPixelFromCoordinate([s[0],s[1]]),l.getPixelFromCoordinate([s[2],s[3]])]),h=[c[0],c[1]],p=[c[2],c[3]],u=(p[0]-h[0])/a[0],g=(p[1]-h[1])/a[1];e.save();var d,m=this.get("margin");for(e.scale(i,i),e.strokeStyle=this.getStroke().getColor(),e.lineWidth=this.getStroke().getWidth(),e.beginPath(),d=0;d<=a[0];d++)e.moveTo(h[0]+d*u,h[1]),e.lineTo(h[0]+d*u,p[1]);for(d=0;d<=a[1];d++)e.moveTo(h[0],h[1]+d*g),e.lineTo(p[0],h[1]+d*g);e.stroke(),e.font=this.getTextFont(),e.fillStyle=this.getTextFill().getColor(),e.strokeStyle=this.getTextStroke().getColor();var f,y,v,_=m+(e.lineWidth=this.getTextStroke().getWidth());for(e.textAlign="center",d=0;d<a[0];d++)f=this.getHIndex(d),y=h[0]+d*u+u/2,(v=h[1]-_)<0?(v=_,e.textBaseline="hanging"):e.textBaseline="alphabetic",e.strokeText(f,y,v),e.fillText(f,y,v),(v=p[1]+_)>r?(v=r-_,e.textBaseline="alphabetic"):e.textBaseline="hanging",e.strokeText(f,y,v),e.fillText(f,y,v);for(e.textBaseline="middle",d=0;d<a[1];d++)f=this.getVIndex(d),v=h[1]+d*g+g/2,e.textAlign="right",(y=h[0]-_)<0?(y=_,e.textAlign="left"):e.textAlign="right",e.strokeText(f,y,v),e.fillText(f,y,v),(y=p[0]+_)>n?(y=n-_,e.textAlign="right"):e.textAlign="left",e.strokeText(f,y,v),e.fillText(f,y,v);e.restore()}},ol.control.Imageline=function(t){var e=ol.ext.element.create("DIV",{className:(t.className||"")+" ol-imageline"+(t.target?"":" ol-unselectable ol-control")+(t.collapsed&&t.collapsible?"ol-collapsed":"")});!t.target&&t.collapsible&&ol.ext.element.create("BUTTON",{type:"button",click:function(){this.toggle()}.bind(this),parent:e}),t.source&&(this._sources=t.source.forEach?t.source:[t.source]),t.layers&&this.setLayers(t.layers),ol.control.Control.call(this,{element:e,target:t.target}),this._setScrolling(),this._scrolldiv.addEventListener("scroll",function(){this.getMap()&&this.getMap().render()}.bind(this)),"function"==typeof t.getImage&&(this._getImage=t.getImage),"function"==typeof t.getTitle&&(this._getTitle=t.getTitle),this.set("maxFeatures",t.maxFeatures||100),this.set("linkColor",t.linkColor||!1),this.set("hover",t.hover||!1),this.set("useExtent",t.useExtent||!1),this.refresh()},ol.ext.inherits(ol.control.Imageline,ol.control.Control),ol.control.Imageline.prototype.setMap=function(t){this._listener&&this._listener.forEach(function(t){ol.Observable.unByKey(t)}.bind(this)),this._listener=null,ol.control.Control.prototype.setMap.call(this,t),t&&(this._listener=[t.on("postcompose",this._drawLink.bind(this)),t.on("moveend",function(){this.get("useExtent")&&this.refresh()}.bind(this))],this.refresh())},ol.control.Imageline.prototype.setLayers=function(t){this._sources=this._getSources(t)},ol.control.Imageline.prototype._getSources=function(t){var e=[];return t.forEach(function(t){t.getVisible()&&(t.getSource()&&t.getSource().getFeatures?e.push(t.getSource()):t.getLayers&&this._getSources(t.getLayers()))}.bind(this)),e},ol.control.Imageline.prototype.useExtent=function(t){this.set("useExtent",t),this.refresh()},ol.control.Imageline.prototype.isCollapsed=function(){return this.element.classList.contains("ol-collapsed")},ol.control.Imageline.prototype.collapse=function(t){t?this.element.classList.add("ol-collapsed"):this.element.classList.remove("ol-collapsed"),this.getMap()&&setTimeout(function(){this.getMap().render()}.bind(this),this.isCollapsed()?0:250),this.dispatchEvent({type:"collapse",collapsed:this.isCollapsed()})},ol.control.Imageline.prototype.toggle=function(){this.element.classList.toggle("ol-collapsed"),this.getMap()&&setTimeout(function(){this.getMap().render()}.bind(this),this.isCollapsed()?0:250),this.dispatchEvent({type:"collapse",collapsed:this.isCollapsed()})},ol.control.Imageline.prototype._getImage=function(t){return t.get("img")},ol.control.Imageline.prototype._getTitle=function(){return""},ol.control.Imageline.prototype.getFeatures=function(){var t=this.getMap();if(!t)return[];var e=[];return(this._sources||this._getSources(t.getLayers())).forEach(function(o){if(e.length<this.get("maxFeatures"))if(this.get("useExtent")&&t){var i=t.getView().calculateExtent(t.getSize());e.push(o.getFeaturesInExtent(i))}else e.push(o.getFeatures())}.bind(this)),e},ol.control.Imageline.prototype._setScrolling=function(){var t=this._scrolldiv=ol.ext.element.create("DIV",{parent:this.element});ol.ext.element.scrollDiv(t,{onmove:function(t){this._moving=t}.bind(this)}),t.addEventListener("scroll",this._updateScrollBounds.bind(this)),this._updateScrollBounds()},ol.control.Imageline.prototype._updateScrollBounds=function(){var t=this._scrolldiv;t.scrollLeft<5?this.element.classList.add("ol-scroll0"):this.element.classList.remove("ol-scroll0"),t.scrollWidth-t.scrollLeft-t.offsetWidth<5?this.element.classList.add("ol-scroll1"):this.element.classList.remove("ol-scroll1")},ol.control.Imageline.prototype.refresh=function(){this._scrolldiv.innerHTML="";var t=this.getFeatures(),e=this._select?this._select.feature:null;this._select&&(this._select.elt=null),this._iline=[],this.getMap()&&this.getMap().render();var o=function(t){if(this._getImage(t)){var o=ol.ext.element.create("DIV",{className:"ol-image",parent:this._scrolldiv});ol.ext.element.create("IMG",{src:this._getImage(t),parent:o}).addEventListener("load",function(){this.classList.add("ol-loaded")}),ol.ext.element.create("SPAN",{html:this._getTitle(t),parent:o});var i={elt:o,feature:t};o.addEventListener("click",function(){this._moving||(this.dispatchEvent({type:"select",feature:t}),this._scrolldiv.scrollLeft=o.offsetLeft+ol.ext.element.getStyle(o,"width")/2-ol.ext.element.getStyle(this.element,"width")/2,this._select&&this._select.elt.classList.remove("select"),this._select=i,this._select.elt.classList.add("select"))}.bind(this)),o.addEventListener("mouseover",function(t){this.get("hover")&&(this._select&&this._select.elt.classList.remove("select"),this._select=i,this._select.elt.classList.add("select"),this.getMap().render(),t.stopPropagation())}.bind(this)),o.addEventListener("mouseout",function(t){this.get("hover")&&(this._select&&this._select.elt.classList.remove("select"),this._select=!1,this.getMap().render(),t.stopPropagation())}.bind(this)),o.ondragstart=function(){return!1},this._iline.push(i),e===t&&(this._select=i,i.elt.classList.add("select"))}}.bind(this),i=this.get("maxFeatures");t.forEach(function(t){for(var e,n=0;(e=t[n])&&!(i--<0);n++)o(e)}.bind(this)),this._select&&this._select.feature&&!this._select.elt&&o(this._select.feature),this._updateScrollBounds()},ol.control.Imageline.prototype.select=function(t,e){this._select=!1,this._iline.forEach(function(o){o.feature===t?(o.elt.classList.add("select"),this._select=o,!1!==e&&(this._scrolldiv.scrollLeft=o.elt.offsetLeft+ol.ext.element.getStyle(o.elt,"width")/2-ol.ext.element.getStyle(this.element,"width")/2)):o.elt.classList.remove("select")}.bind(this))},ol.control.Imageline.prototype._drawLink=function(t){if(!(!this.get("linkColor")|this.isCollapsed())&&(this.getMap()&&this._select&&this._select.elt)){var e=t.context||ol.ext.getMapCanvas(this.getMap()).getContext("2d"),o=t.frameState.pixelRatio,i=[this._select.elt.offsetLeft-this._scrolldiv.scrollLeft+ol.ext.element.getStyle(this._select.elt,"width")/2,parseFloat(ol.ext.element.getStyle(this.element,"top"))||this.getMap().getSize()[1]],n=this._select.feature.getGeometry().getFirstCoordinate();n=this.getMap().getPixelFromCoordinate(n),e.save(),e.fillStyle=this.get("linkColor"),e.beginPath(),n[0]>i[0]?(e.moveTo((i[0]-5)*o,i[1]*o),e.lineTo((i[0]+5)*o,(i[1]+5)*o)):(e.moveTo((i[0]-5)*o,(i[1]+5)*o),e.lineTo((i[0]+5)*o,i[1]*o)),e.lineTo(n[0]*o,n[1]*o),e.fill(),e.restore()}},ol.control.IsochroneGeoportail=function(t){var e=this;t||(t={}),null==t.typing&&(t.typing=300);var o=(t.className?t.className:"")+" ol-isochrone ol-routing";t.target||(o+=" ol-unselectable ol-control");var i=ol.ext.element.create("DIV",{className:o});t.target||ol.ext.element.create("BUTTON",{parent:i}).addEventListener("click",function(){i.classList.toggle("ol-collapsed")});ol.control.Control.call(this,{element:i,target:t.target}),this.set("iter",1);var n=ol.ext.element.create("DIV",{className:"content",parent:i});this._addSearchCtrl(n,t),ol.ext.element.create("BUTTON",{className:"ol-button ol-method-time selected",title:"isochrone",parent:n}).addEventListener("click",function(){this.setMethod("time")}.bind(this)),ol.ext.element.create("I",{className:"ol-button ol-method-distance",title:"isodistance",parent:n}).addEventListener("click",function(){this.setMethod("distance")}.bind(this)),ol.ext.element.create("I",{className:"ol-button ol-car selected",title:"by car",parent:n}).addEventListener("click",function(){this.setMode("car")}.bind(this)),ol.ext.element.create("I",{className:"ol-button ol-pedestrian",title:"by foot",parent:n}).addEventListener("click",function(){this.setMode("pedestrian")}.bind(this)),ol.ext.element.create("I",{className:"ol-button ol-direction-direct selected",title:"direct",parent:n}).addEventListener("click",function(){this.setDirection("direct")}.bind(this)),ol.ext.element.create("I",{className:"ol-button ol-direction-reverse",title:"reverse",parent:n}).addEventListener("click",function(){this.setDirection("reverse")}.bind(this));var r=ol.ext.element.create("DIV",{className:"ol-time",parent:n});ol.ext.element.create("DIV",{html:"isochrone:",parent:r}),ol.ext.element.create("INPUT",{type:"number",parent:r,min:0}).addEventListener("change",function(){e.set("hour",Number(this.value))}),ol.ext.element.create("TEXT",{parent:r,html:"h"}),ol.ext.element.create("INPUT",{type:"number",parent:r,min:0}).addEventListener("change",function(){e.set("minute",Number(this.value))}),ol.ext.element.create("TEXT",{parent:r,html:"mn"}),r=ol.ext.element.create("DIV",{className:"ol-distance",parent:n}),ol.ext.element.create("DIV",{html:"isodistance:",parent:r}),ol.ext.element.create("INPUT",{type:"number",step:"any",parent:r,min:0}).addEventListener("change",function(){e.set("distance",Number(this.value))}),ol.ext.element.create("TEXT",{parent:r,html:"km"}),r=ol.ext.element.create("DIV",{className:"ol-iter",parent:n}),ol.ext.element.create("DIV",{html:"Iteration:",parent:r}),ol.ext.element.create("INPUT",{type:"number",parent:r,value:1,min:1}).addEventListener("change",function(){e.set("iter",Number(this.value))}),ol.ext.element.create("I",{className:"ol-ok",html:"ok",parent:n}).addEventListener("click",function(){var t=0;switch(this.get("method")){case"distance":t=1e3*this.get("distance");break;default:t=3600*(this.get("hour")||0)+60*(this.get("minute")||0)}t&&this.get("coordinate")&&this.search(this.get("coordinate"),t)}.bind(this)),this.set("url","https://wxs.ign.fr/"+(t.apiKey||"essentiels")+"/isochrone/isochrone.json"),this._ajax=new ol.ext.Ajax({dataType:"JSON",auth:t.auth}),this._ajax.on("success",this._success.bind(this)),this._ajax.on("error",this._error.bind(this)),this._ajax.on("loadstart",function(){this.element.classList.add("ol-searching")}.bind(this)),this._ajax.on("loadend",function(){this.element.classList.remove("ol-searching")}.bind(this)),this.setMethod(t.method)},ol.ext.inherits(ol.control.IsochroneGeoportail,ol.control.Control),ol.control.IsochroneGeoportail.prototype.setMap=function(t){ol.control.Control.prototype.setMap.call(this,t),this._search.setMap(t)},ol.control.IsochroneGeoportail.prototype._addSearchCtrl=function(t,e){var o=ol.ext.element.create("DIV",{parent:t}),i=this._search=new ol.control.SearchGeoportail({className:"IGNF ol-collapsed",apiKey:e.apiKey,target:o});i.on("select",function(t){i.setInput(t.search.fulltext),this.set("coordinate",t.coordinate)}.bind(this)),i.on("change:input",function(){this.set("coordinate",!1)}.bind(this))},ol.control.IsochroneGeoportail.prototype.setMethod=function(t){t=/distance/.test(t)?"distance":"time",this.element.querySelector(".ol-method-time").classList.remove("selected"),this.element.querySelector(".ol-method-distance").classList.remove("selected"),this.element.querySelector(".ol-method-"+t).classList.add("selected"),this.element.querySelector("div.ol-time").classList.remove("selected"),this.element.querySelector("div.ol-distance").classList.remove("selected"),this.element.querySelector("div.ol-"+t).classList.add("selected"),this.set("method",t)},ol.control.IsochroneGeoportail.prototype.setMode=function(t){this.set("mode",t),this.element.querySelector(".ol-car").classList.remove("selected"),this.element.querySelector(".ol-pedestrian").classList.remove("selected"),this.element.querySelector(".ol-"+t).classList.add("selected")},ol.control.IsochroneGeoportail.prototype.setDirection=function(t){this.set("direction",t),this.element.querySelector(".ol-direction-direct").classList.remove("selected"),this.element.querySelector(".ol-direction-reverse").classList.remove("selected"),this.element.querySelector(".ol-direction-"+t).classList.add("selected")},ol.control.IsochroneGeoportail.prototype.search=function(t,e,o){var i=this.getMap()?this.getMap().getView().getProjection():"EPSG:3857",n=/distance/.test(this.get("method"))?"distance":"time";if("string"==typeof e){var r=e.replace(/([0-9|.]*)([a-z]*)$/,"$2");switch(n="time",e=parseFloat(e),r){case"mn":e*=60;break;case"h":e*=3600;break;case"m":n="distance";break;case"km":n="distance",e*=1e3}}var s=Math.round(e*(this.get("iter")-(o||0))/this.get("iter"));if("number"==typeof e){var a={"gp-access-lib":"2.1.0",location:ol.proj.toLonLat(t,i),graphName:"pedestrian"===this.get("mode")?"Pieton":"Voiture",exclusions:this.get("exclusions")||void 0,method:n,time:"time"===n?s:void 0,distance:"distance"===n?s:void 0,reverse:"reverse"===this.get("direction"),smoothing:this.get("smoothing")||!0,holes:this.get("holes")||!1};this._ajax.send(this.get("url"),a,{coord:t,option:e,data:a,iteration:(o||0)+1})}},ol.control.IsochroneGeoportail.prototype._success=function(t){var e=this.getMap()?this.getMap().getView().getProjection():"EPSG:3857",o=new ol.format.WKT,i=t.response;i.feature=o.readFeature(i.wktGeometry,{dataProjection:"EPSG:4326",featureProjection:e}),i.feature.set("iteration",t.options.iteration),i.feature.set("method",t.options.data.method),i.feature.set(t.options.data.method,t.options.data[t.options.data.method]),delete i.wktGeometry,i.type="isochrone",i.iteration=t.options.iteration-1,this.dispatchEvent(i),t.options.iteration<this.get("iter")&&this.search(t.options.coord,t.options.option,t.options.iteration)},ol.control.IsochroneGeoportail.prototype._error=function(){this.dispatchEvent({type:"error"})},ol.control.LayerPopup=function(t){(t=t||{}).switcherClass="ol-layerswitcher-popup"+(t.switcherClass?" "+t.switcherClass:""),!1!==t.mouseover&&(t.mouseover=!0),ol.control.LayerSwitcher.call(this,t)},ol.ext.inherits(ol.control.LayerPopup,ol.control.LayerSwitcher),ol.control.LayerPopup.prototype.overflow=function(){},ol.control.LayerPopup.prototype.drawList=function(t,e){var o=this,i=function(t){t.preventDefault();var i=o._getLayerForLI(this);o.switchLayerVisibility(i,e),"touchstart"===t.type&&o.element.classList.add("ol-collapsed")};e.forEach(function(e){if(o.displayInLayerSwitcher(e)){var n=ol.ext.element.create("LI",{html:e.get("title")||e.get("name"),on:{"click touchstart":i},parent:t});o._setLayerForLI(n,e),o.testLayerVisibility(e)&&n.classList.add("ol-layer-hidden"),e.getVisible()&&n.classList.add("ol-visible")}})},ol.control.LayerShop=function(t){(t=t||{}).selection=!0,t.noScroll=!0,ol.control.LayerSwitcher.call(this,t),this.element.classList.add("ol-layer-shop");var e=this.element.insertBefore(ol.ext.element.create("DIV",{className:"ol-title-bar"}),this.getPanel());this.on("select",function(t){e.innerText=t.layer?t.layer.get("title"):"",this.element.setAttribute("data-layerClass",this.getLayerClass(t.layer))}.bind(this)),this._topbar=this.element.insertBefore(ol.ext.element.create("DIV",{className:"ol-bar ol-top-bar"}),this.getPanel()),this._bottombar=ol.ext.element.create("DIV",{className:"ol-bar ol-bottom-bar",parent:this.element}),this._controls=[]},ol.ext.inherits(ol.control.LayerShop,ol.control.LayerSwitcher),ol.control.LayerShop.prototype.setMap=function(t){this.getMap()&&this._controls.forEach(function(t){this.getMap().removeControl(t)}.bind(this)),ol.control.LayerSwitcher.prototype.setMap.call(this,t),t&&(this.selectLayer(),this._listener.removeLayer=t.getLayers().on("remove",function(t){t.element===this.getSelection()&&this.selectLayer()}.bind(this)),this._controls.forEach(function(t){this.getMap().addControl(t)}.bind(this)))},ol.control.LayerShop.prototype.getBarElement=function(t){return"bottom"===t?this._bottombar:this._topbar},ol.control.LayerShop.prototype.addControl=function(t,e){this._controls.push(t),t.setTarget("bottom"===e?this._bottombar:this._topbar),this.getMap()&&this.getMap().addControl(t)},ol.control.LayerSwitcherImage=function(t){(t=t||{}).switcherClass="ol-layerswitcher-image",!1!==t.mouseover&&(t.mouseover=!0),ol.control.LayerSwitcher.call(this,t)},ol.ext.inherits(ol.control.LayerSwitcherImage,ol.control.LayerSwitcher),ol.control.LayerSwitcherImage.prototype.drawList=function(t,e){var o=this,i=function(t){t.preventDefault();var i=o._getLayerForLI(this);o.switchLayerVisibility(i,e),"touchstart"==t.type&&o.element.classList.add("ol-collapsed")};ol.ext.element.setStyle(t,{height:"auto"}),e.forEach(function(e){if(o.displayInLayerSwitcher(e)){var n=e.getPreview?e.getPreview():["none"],r=ol.ext.element.create("LI",{className:"ol-imgcontainer"+(e.getVisible()?" ol-visible":""),on:{"touchstart click":i},parent:t});o._setLayerForLI(r,e),n.forEach(function(t){ol.ext.element.create("IMG",{src:t,parent:r})}),ol.ext.element.create("p",{html:e.get("title")||e.get("name"),parent:r}),o.testLayerVisibility(e)&&r.classList.add("ol-layer-hidden")}})},ol.control.LayerSwitcherImage.prototype.overflow=function(){},ol.control.Legend=function(t){t=t||{};var e=document.createElement("div");if(t.target)e.className=t.className||"ol-legend";else{e.className=(t.className||"ol-legend")+" ol-unselectable ol-control"+(!1===t.collapsible?" ol-uncollapsible":" ol-collapsed");var o=document.createElement("button");o.setAttribute("type","button"),o.addEventListener("click",function(){this.toggle()}.bind(this)),e.appendChild(o),(o=document.createElement("button")).setAttribute("type","button"),o.className="ol-closebox",o.addEventListener("click",function(){this.toggle()}.bind(this)),e.appendChild(o)}ol.control.CanvasBase.call(this,{element:e,target:t.target}),this._legend=t.legend,this._legend.getCanvas().className="ol-legendImg",e.appendChild(this._legend.getCanvas()),e.appendChild(this._legend.getListElement()),!1!==t.collapsible&&!1===t.collapsed&&this.show(),this._legend.on("select",function(t){this.dispatchEvent(t)}.bind(this)),this._legend.on("refresh",function(){if(this._onCanvas&&this.getMap())try{this.getMap().renderSync()}catch(t){}}.bind(this))},ol.ext.inherits(ol.control.Legend,ol.control.CanvasBase),ol.control.Legend.prototype.getLegend=function(){return this._legend},ol.control.Legend.prototype.setCanvas=function(t){if(this._onCanvas=t,this.element.style.visibility=t?"hidden":"visible",this.getMap())try{this.getMap().renderSync()}catch(t){}},ol.control.Legend.prototype.onCanvas=function(){return!!this._onCanvas},ol.control.Legend.prototype._draw=function(t){if(this._onCanvas&&!this.element.classList.contains("ol-collapsed")){var e=this._legend.getCanvas(),o=this.getContext(t),i=o.canvas.height-e.height;o.save(),o.rect(0,i,e.width,e.height);var n="#fff";this._legend.getTextStyle().getBackgroundFill()&&(n=ol.color.asString(this._legend.getTextStyle().getBackgroundFill().getColor())),o.fillStyle=o.strokeStyle=n,o.lineWidth=10,o.lineJoin="round",o.stroke(),o.clearRect(0,i,e.width,e.height),o.fill(),o.drawImage(e,0,i),o.restore()}},ol.control.Legend.prototype.show=function(){if(this.element.classList.contains("ol-collapsed")&&(this.element.classList.remove("ol-collapsed"),this.dispatchEvent({type:"change:collapse",collapsed:!1}),this.getMap()))try{this.getMap().renderSync()}catch(t){}},ol.control.Legend.prototype.hide=function(){if(!this.element.classList.contains("ol-collapsed")&&(this.element.classList.add("ol-collapsed"),this.dispatchEvent({type:"change:collapse",collapsed:!0}),this.getMap()))try{this.getMap().renderSync()}catch(t){}},ol.control.Legend.prototype.collapse=function(t){!1===t?this.show():this.hide()},ol.control.Legend.prototype.isCollapsed=function(){return this.element.classList.contains("ol-collapsed")},ol.control.Legend.prototype.toggle=function(){if(this.element.classList.toggle("ol-collapsed"),this.dispatchEvent({type:"change:collapse",collapsed:this.element.classList.contains("ol-collapsed")}),this.getMap())try{this.getMap().renderSync()}catch(t){}},ol.control.MapZone=function(t){t||(t={});var e=document.createElement("div");if(t.target)e=ol.ext.element.create("DIV",{className:t.className||"ol-mapzone"});else{e=ol.ext.element.create("DIV",{className:(t.className||"ol-mapzone")+" ol-unselectable ol-control ol-collapsed"});var o=ol.ext.element.create("BUTTON",{type:"button",on:{click:function(){e.classList.toggle("ol-collapsed"),i.forEach(function(t){t.updateSize()})}.bind(this)},parent:e});ol.ext.element.create("I",{parent:o})}ol.control.Control.call(this,{element:e,target:t.target}),this.set("centerOnClick",t.centerOnClick);var i=this._maps=[];this._projection=t.projection,this._layer=t.layer,t.zones.forEach(this.addZone.bind(this)),setTimeout(function(){i.forEach(function(t){t.updateSize()})})},ol.ext.inherits(ol.control.MapZone,ol.control.Control),ol.control.MapZone.prototype.setCollapsed=function(t){t?(this.element.classList.remove("ol-collapsed"),this.getMaps().forEach(function(t){t.updateSize()})):this.element.classList.add("ol-collapsed")},ol.control.MapZone.prototype.getCollapsed=function(){return this.element.classList.contains("ol-collapsed")},ol.control.MapZone.prototype.setVisible=ol.control.MapZone.prototype.setCollapsed,ol.control.MapZone.prototype.getMaps=function(){return this._maps},ol.control.MapZone.prototype.getLength=function(){return this._maps.length},ol.control.MapZone.prototype.addZone=function(t){var e,o=new ol.View({zoom:6,center:[0,0],projection:this._projection});e=t.map?ol.proj.transformExtent(t.map.getView().calculateExtent(),t.map.getView().getProjection(),o.getProjection()):ol.proj.transformExtent(t.extent,"EPSG:4326",o.getProjection());var i,n=ol.ext.element.create("DIV",{className:"ol-mapzonezone",parent:this.element,click:function(){var o=-1;this._maps.forEach(function(e,i){e.get("zone")===t&&(o=i)}),this.dispatchEvent({type:"select",zone:t,index:o,coordinate:ol.extent.getCenter(e),extent:e}),!1!==this.get("centerOnClick")&&this.getMap().getView().fit(e),this.setVisible(!1)}.bind(this)});i=t.layer?t.layer:"function"==typeof this._layer?this._layer(t):new this._layer.constructor({source:this._layer.getSource()});var r=new ol.Map({target:n,view:o,controls:[],interactions:[],layers:[i]});r.set("zone",t),this._maps.push(r),o.fit(e),ol.ext.element.create("P",{html:t.title,parent:n})},ol.control.MapZone.prototype.removeZone=function(t){var e=this.element.querySelectorAll(".ol-mapzonezone")[t];e&&(e.remove(),this._maps.splice(t,1))},ol.control.MapZone.zones={},ol.control.MapZone.zones.DOM=[{title:"Guadeloupe",extent:[-61.898594315312444,15.75623038647845,-60.957887532935324,16.575317670979473]},{title:"Guyane",extent:[-54.72525931072715,2.1603763430019,-51.528236062921344,5.7984307809552575]},{title:"Martinique",extent:[-61.257556528564756,14.387506317407514,-60.76934912110432,14.895067461729951]},{title:"Mayotte",extent:[44.959844536967815,-13.01674138212816,45.35328866510648,-12.65521942207829]},{title:"La réunion",extent:[55.17059012967656,-21.407680069231688,55.88195702001797,-20.85560221637526]}],ol.control.MapZone.zones.TOM=[{title:"Polynésie Française",extent:[206.23664226630862,-22.189040615809787,221.85920743981987,-10.835039595040698]},{title:"Nouvelle Calédonie",extent:[163.76420580160925,-22.581641092751838,167.66984709498706,-19.816411635668445]},{title:"St-Pierre et Miquelon",extent:[-56.453698765748676,46.74449858188555,-56.0980198121544,47.14669874229787]},{title:"Wallis et Futuna",extent:[181.7588623143665,-14.7341169873267,183.95612353301715,-13.134720799175085]},{title:"St-Martin St-Barthélemy",extent:[-63.1726389501678,17.806097291313506,-62.7606535945649,18.13267688837938]}],ol.control.MapZone.zones.DOMTOM=[{title:"Métropole",extent:[-5.318421740712579,41.16082274292913,9.73284186155716,51.21957336557702]}].concat(ol.control.MapZone.zones.DOM,ol.control.MapZone.zones.TOM),ol.control.Notification=function(t){t=t||{};var e=document.createElement("DIV");this.contentElement=ol.ext.element.create("DIV",{click:function(){this.get("hideOnClick")&&this.hide()}.bind(this),parent:e});var o=(t.className||"")+" ol-notification";t.target||(o+=" ol-unselectable ol-control ol-collapsed"),e.setAttribute("class",o),ol.control.Control.call(this,{element:e,target:t.target}),this.set("closeBox",t.closeBox),this.set("hideOnClick",t.hideOnClick)},ol.ext.inherits(ol.control.Notification,ol.control.Control),ol.control.Notification.prototype.show=function(t,e){var o=this,i=this.element;t&&(t instanceof Node?(this.contentElement.innerHTML="",this.contentElement.appendChild(t)):this.contentElement.innerHTML=t,this.get("closeBox")?(this.contentElement.classList.add("ol-close"),ol.ext.element.create("SPAN",{className:"closeBox",click:function(){this.hide()}.bind(this),parent:this.contentElement})):this.contentElement.classList.remove("ol-close")),this._listener&&(clearTimeout(this._listener),this._listener=null),i.classList.add("ol-collapsed"),this._listener=setTimeout(function(){i.classList.remove("ol-collapsed"),o._listener=!e||e>=0?setTimeout(function(){i.classList.add("ol-collapsed"),o._listener=null},e||3e3):null},100)},ol.control.Notification.prototype.hide=function(){this._listener&&(clearTimeout(this._listener),this._listener=null),this.element.classList.add("ol-collapsed")},ol.control.Notification.prototype.toggle=function(t){this.element.classList.contains("ol-collapsed")?this.show(null,t):this.hide()},ol.control.Overlay=function(t){t||(t={});var e=ol.ext.element.create("DIV",{className:"ol-unselectable ol-overlay "+(t.className||""),html:t.content});ol.control.Control.call(this,{element:e,target:t.target});var o=this;t.hideOnClick&&e.addEventListener("click",function(){o.hide()}),this.set("closeBox",t.closeBox),this._timeout=!1,this.setContent(t.content)},ol.ext.inherits(ol.control.Overlay,ol.control.Control),ol.control.Overlay.prototype.setContent=function(t){var e=this;if(t){var o=this.element;if(t instanceof Element?(o.innerHTML="",o.appendChild(t)):void 0!==t&&(o.innerHTML=t),this.get("closeBox")){var i=document.createElement("div");i.classList.add("ol-closebox"),i.addEventListener("click",function(){e.hide()}),o.insertBefore(i,o.firstChild)}}},ol.control.Overlay.prototype.show=function(t,e){var o=this,i=this.element;i.style.display="block",e?(this.center_=this.getMap().getPixelFromCoordinate(e),i.style.top=this.center_[1]+"px",i.style.left=this.center_[0]+"px"):(this.center_=!1,i.style.top="",i.style.left=""),t&&this.setContent(t),this._timeout&&clearTimeout(this._timeout),this._timeout=setTimeout(function(){i.classList.add("ol-visible"),i.style.top="",i.style.left="",o.dispatchEvent({type:"change:visible",visible:!0,element:o.element})},10)},ol.control.Overlay.prototype.showImage=function(t,e){e=e||{};var o=ol.ext.element.create("DIV",{className:"ol-fullscreen-image"});ol.ext.element.create("IMG",{src:t,parent:o}),e.title&&(o.classList.add("ol-has-title"),ol.ext.element.create("P",{html:e.title,parent:o})),this.show(o,e.coordinate)},ol.control.Overlay.prototype.hide=function(){var t=this.element;this.element.classList.remove("ol-visible"),this.center_&&(t.style.top=this.center_[1]+"px",t.style.left=this.center_[0]+"px",this.center_=!1),this._timeout&&clearTimeout(this._timeout),this._timeout=setTimeout(function(){t.style.display="none"},500),this.dispatchEvent({type:"change:visible",visible:!1,element:this.element})},ol.control.Overlay.prototype.toggle=function(){this.getVisible()?this.hide():this.show()},ol.control.Overlay.prototype.getVisible=function(){return"none"!==ol.ext.element.getStyle(this.element,"display")},ol.control.Overlay.prototype.setClass=function(t){var e=this.element.classList.contains("ol-visible");this.element.className=("ol-unselectable ol-overlay "+(e?"ol-visible ":"")+t).trim()},ol.control.Overview=function(t){t=t||{};var e,o=this;if(this.minZoom=t.minZoom||0,this.maxZoom=t.maxZoom||18,this.rotation=t.rotation,t.target)e=document.createElement("div"),this.panel_=t.target;else{(e=document.createElement("div")).classList.add("ol-overview","ol-unselectable","ol-control","ol-collapsed"),/top/.test(t.align)&&e.classList.add("ol-control-top"),/right/.test(t.align)&&e.classList.add("ol-control-right");var i=document.createElement("button");i.setAttribute("type","button"),i.addEventListener("touchstart",function(t){o.toggleMap(),t.preventDefault()}),i.addEventListener("click",function(){o.toggleMap()}),e.appendChild(i),this.panel_=document.createElement("div"),this.panel_.classList.add("panel"),e.appendChild(this.panel_)}ol.control.Control.call(this,{element:e,target:t.target}),this.ovmap_=new ol.Map({controls:new ol.Collection,interactions:new ol.Collection,target:this.panel_,view:new ol.View({zoom:2,center:[0,0],projection:t.projection}),layers:t.layers}),this.oview_=this.ovmap_.getView(),this.extentLayer=new ol.layer.Vector({name:"Cache extent",source:new ol.source.Vector,style:t.style||[new ol.style.Style({image:new ol.style.Circle({fill:new ol.style.Fill({color:"rgba(255,0,0, 1)"}),stroke:new ol.style.Stroke({width:7,color:"rgba(255,0,0, 0.8)"}),radius:5}),stroke:new ol.style.Stroke({width:5,color:"rgba(255,0,0,0.8)"})})]}),this.ovmap_.addLayer(this.extentLayer);this.ovmap_.addInteraction(new ol.interaction.Pointer({handleDownEvent:function(e){var i,n,r,s,a;return!1!==t.panAnimation?"elastic"==t.panAnimation||t.elasticPan?o.getMap().getView().animate({center:e.coordinate,easing:(i=2,n=.3,r=3*i*Math.PI/2,s=n>0?-1/n:-100,a=Math.cos(r)*Math.pow(2,s),function(t){return t=1-Math.cos(t*Math.PI/2),1-Math.cos(r*t)*Math.pow(2,s*t)+a*t}),duration:1e3}):o.getMap().getView().animate({center:e.coordinate,duration:300}):o.getMap().getView().setCenter(e.coordinate),!1}}))},ol.ext.inherits(ol.control.Overview,ol.control.Control),ol.control.Overview.prototype.getOverviewMap=function(){return this.ovmap_},ol.control.Overview.prototype.toggleMap=function(){this.element.classList.toggle("ol-collapsed"),this.ovmap_.updateSize(),this.setView()},ol.control.Overview.prototype.setPosition=function(t){/top/.test(t)?this.element.classList.add("ol-control-top"):this.element.classList.remove("ol-control-top"),/right/.test(t)?this.element.classList.add("ol-control-right"):this.element.classList.remove("ol-control-right")},ol.control.Overview.prototype.setMap=function(t){if(this._listener)for(var e in this._listener)ol.Observable.unByKey(this._listener[e]);this._listener={},ol.control.Control.prototype.setMap.call(this,t),t&&(this._listener.map=t.on("change:view",function(){this._listener.view&&ol.Observable.unByKey(this._listener.view),t.getView()&&(this._listener.view=t.getView().on("propertychange",this.setView.bind(this)),this.setView())}.bind(this)),this._listener.view=t.getView().on("propertychange",this.setView.bind(this)),this.setView())},ol.control.Overview.prototype.calcExtent_=function(t){var e=this.getMap();if(e){var o=this.extentLayer.getSource();o.clear();var i=new ol.Feature,n=e.getSize(),r=e.getView().getResolution(),s=e.getView().getRotation(),a=e.getView().getCenter();if(r){var l=r*n[0]/2,c=r*n[1]/2,h=this.oview_.getResolution();if(l/h>5||c/h>5){var p,u,g,d=Math.cos(s),m=Math.sin(s);for(t=[[-l,-c],[-l,c],[l,c],[l,-c]],p=0;p<4;++p)u=t[p][0],g=t[p][1],t[p][0]=a[0]+u*d-g*m,t[p][1]=a[1]+u*m+g*d;i.setGeometry(new ol.geom.Polygon([t]))}else i.setGeometry(new ol.geom.Point(a));o.addFeature(i)}}},ol.control.Overview.prototype.setView=function(t){if(!t)return this.setView({key:"rotation"}),this.setView({key:"resolution"}),void this.setView({key:"center"});switch(t.key){case"rotation":this.rotation?this.oview_.setRotation(this.getMap().getView().getRotation()):this.oview_.getRotation()&&this.oview_.setRotation(0);break;case"center":var e=this.getMap().getView().calculateExtent(this.getMap().getSize()),o=this.oview_.calculateExtent(this.ovmap_.getSize());(e[0]<o[0]||e[1]<o[1]||e[2]>o[2]||e[3]>o[3])&&this.oview_.setCenter(this.getMap().getView().getCenter());break;case"resolution":var i=2*Math.round(this.oview_.getZoomForResolution(this.getMap().getView().getResolution())/2)-4;i=Math.min(this.maxZoom,Math.max(this.minZoom,i)),this.oview_.setZoom(i)}this.calcExtent_()},ol.control.Permalink=function(t){var e=t||{},o=this,i=document.createElement("button");if(this.replaceState_=!1!==e.urlReplace,this.fixed_=e.fixed||6,this.hash_=e.anchor?"#":"?",this._localStorage=e.localStorage,!this._localStorage)try{localStorage.removeItem("ol@permalink")}catch(t){console.warn("Failed to access localStorage...")}function n(){"function"==typeof e.onclick?e.onclick(o.getLink()):o.setUrlReplace(!o.replaceState_)}i.addEventListener("click",n,!1),i.addEventListener("touchstart",n,!1);var r=document.createElement("div");r.className=(e.className||"ol-permalink")+" ol-unselectable ol-control",r.appendChild(i),(e.hidden||!1===e.visible)&&ol.ext.element.hide(r),ol.control.Control.call(this,{element:r,target:e.target}),this.set("geohash",e.geohash),this.set("initial",!1),this.on("change",this.viewChange_.bind(this)),this.search_={};var s={},a=document.location.hash||document.location.search||"";if(this.replaceState_&&!a&&this._localStorage)try{a=localStorage["ol@permalink"]}catch(t){console.warn("Failed to access localStorage...")}if(a){a=a.replace(/(^#|^\?)/,"").split("&");for(var l=0;l<a.length;l++){var c=a[l].split("=");switch(c[0]){case"lon":case"lat":case"z":case"r":s[c[0]]=c[1];break;case"gh":var h=c[1].split("-"),p=ol.geohash.toLonLat(h[0]);s.lon=p[0],s.lat=p[1],s.z=h[1];break;case"l":break;default:this.search_[c[0]]=c[1]}}}s.hasOwnProperty("lon")&&this.set("initial",s),this.replaceState_&&this.setPosition()},ol.ext.inherits(ol.control.Permalink,ol.control.Control),ol.control.Permalink.prototype.getInitialPosition=function(){return this.get("initial")},ol.control.Permalink.prototype.setMap=function(t){this._listener&&(ol.Observable.unByKey(this._listener.change),ol.Observable.unByKey(this._listener.moveend)),this._listener=null,ol.control.Control.prototype.setMap.call(this,t),t&&(this._listener={change:t.getLayerGroup().on("change",this.layerChange_.bind(this)),moveend:t.on("moveend",this.viewChange_.bind(this))},this.setPosition())},ol.control.Permalink.prototype.getLayerByLink=function(t,e){!e&&this.getMap()&&(e=this.getMap().getLayers().getArray());for(var o=0;o<e.length;o++){if(e[o].get("permalink")==t)return e[o];if(e[o].getLayers){var i=this.getLayerByLink(t,e[o].getLayers().getArray());if(i)return i}}return!1},ol.control.Permalink.prototype.setGeohash=function(t){this.set("geohash",t),this.setUrlParam()},ol.control.Permalink.prototype.setPosition=function(t){var e=this.getMap();if(e){var o=this.replaceState_||t?document.location.hash||document.location.search:"";if(!o&&this._localStorage)try{o=localStorage["ol@permalink"]}catch(t){console.warn("Failed to access localStorage...")}if(o){var i,n,r={};for(o=o.replace(/(^#|^\?)/,"").split("&"),i=0;i<o.length;i++)r[(n=o[i].split("="))[0]]=n[1];if(r.gh){var s=r.gh.split("-"),a=ol.geohash.toLonLat(s[0]);r.lon=a[0],r.lat=a[1],r.z=s[1]}var l=ol.proj.transform([Number(r.lon),Number(r.lat)],"EPSG:4326",e.getView().getProjection());if(l[0]&&l[1]&&e.getView().setCenter(l),r.z&&e.getView().setZoom(Number(r.z)),r.r&&e.getView().setRotation(Number(r.r)),r.l){!function t(o){o||(o=e.getLayers().getArray());for(var i=0;i<o.length;i++)o[i].get("permalink")&&o[i].setVisible(!1),o[i].getLayers&&t(o[i].getLayers().getArray())}();var c=r.l.split("|");for(i=0;i<c.length;i++){n=c[i].split(":");var h=this.getLayerByLink(n[0]),p=Number(n[1]);h&&(h.setOpacity(p),h.setVisible(!0))}}}}},ol.control.Permalink.prototype.getUrlParams=function(){return this.search_},ol.control.Permalink.prototype.setUrlParam=function(t,e){t&&(void 0===e||""===e?delete this.search_[encodeURIComponent(t)]:this.search_[encodeURIComponent(t)]=encodeURIComponent(e)),this.viewChange_()},ol.control.Permalink.prototype.getUrlParam=function(t){return decodeURIComponent(this.search_[encodeURIComponent(t)]||"")},ol.control.Permalink.prototype.hasUrlParam=function(t){return this.search_.hasOwnProperty(encodeURIComponent(t))},ol.control.Permalink.prototype.getLink=function(t){var e=this.getMap(),o=ol.proj.transform(e.getView().getCenter(),e.getView().getProjection(),"EPSG:4326"),i=Math.round(10*e.getView().getZoom())/10,n=e.getView().getRotation(),r=this.layerStr_,s=(n?"&r="+Math.round(1e4*n)/1e4:"")+(r?"&l="+r:"");this.get("geohash")?s="gh="+ol.geohash.fromLonLat(o,8)+"-"+i+s:s="lon="+o[0].toFixed(this.fixed_)+"&lat="+o[1].toFixed(this.fixed_)+"&z="+i+s;if("position"===t)return s;for(var a in this.search_)s+="&"+a+(void 0!==this.search_[a]?"="+this.search_[a]:"");return t?s:document.location.protocol+"//"+document.location.host+document.location.pathname+this.hash_+s},ol.control.Permalink.prototype.getUrlReplace=function(){return this.replaceState_},ol.control.Permalink.prototype.setUrlReplace=function(t){try{if(this.replaceState_=t,t)window.history.replaceState(null,null,this.getLink());else{var e="";for(var o in this.search_)e+=(""==e?"?":"&")+o+(void 0!==this.search_[o]?"="+this.search_[o]:"");window.history.replaceState(null,null,document.location.origin+document.location.pathname+e)}}catch(t){}},ol.control.Permalink.prototype.viewChange_=function(){try{this.replaceState_&&window.history.replaceState(null,null,this.getLink())}catch(t){}if(this._localStorage)try{localStorage["ol@permalink"]=this.getLink(this._localStorage)}catch(t){console.warn("Failed to access localStorage...")}},ol.control.Permalink.prototype.layerChange_=function(){this._tout&&(clearTimeout(this._tout),this._tout=null),this._tout=setTimeout(function(){this._tout=null;var t="";!function e(o){for(var i=0;i<o.length;i++)o[i].getVisible()&&o[i].get("permalink")&&(t&&(t+="|"),t+=o[i].get("permalink")+":"+o[i].get("opacity")),o[i].getLayers&&e(o[i].getLayers().getArray())}(this.getMap().getLayers().getArray()),this.layerStr_=t,this.viewChange_()}.bind(this),200)},ol.control.Print=function(t){t||(t={});var e=ol.ext.element.create("DIV",{className:t.className||"ol-print"});t.target||(e.classList.add("ol-unselectable","ol-control"),ol.ext.element.create("BUTTON",{type:"button",title:t.title||"Print",click:function(){this.print()}.bind(this),parent:e})),ol.control.Control.call(this,{element:e,target:t.target}),this.set("immediate",t.immediate),this.set("imageType",t.imageType||"image/jpeg"),this.set("quality",t.quality||.8),this.set("orientation",t.orientation)},ol.ext.inherits(ol.control.Print,ol.control.Control),ol.control.Print.prototype.toClipboard=function(t,e){try{t.canvas.toBlob(function(t){try{navigator.clipboard.write([new window.ClipboardItem(Object.defineProperty({},t.type,{value:t,enumerable:!0}))]),"function"==typeof e&&e(!0)}catch(t){"function"==typeof e&&e(!1)}})}catch(t){"function"==typeof e&&e(!1)}},ol.control.Print.prototype.copyMap=function(t,e){this.once("print",function(t){this.toClipboard(t,e)}.bind(this)),this.print(t)},ol.control.Print.prototype._getCanvas=function(t,e,o){var i;if(t.context)o=t.context.canvas;else{if(o)i=o.getContext("2d");else{o=document.createElement("canvas");var n=this.getMap().getSize();o.width=n[0],o.height=n[1],i=o.getContext("2d"),/jp.*g$/.test(e)&&(i.fillStyle=this.get("bgColor")||"white",i.fillRect(0,0,o.width,o.height))}this.getMap().getViewport().querySelectorAll(".ol-layers canvas, canvas.ol-fixedoverlay").forEach(function(t){if(t.width){if(i.save(),"0"===t.parentNode.style.opacity)return;i.globalAlpha=parseFloat(t.parentNode.style.opacity)||1,"multiply"===ol.ext.element.getStyle(t.parentNode,"mix-blend-mode")&&(i.globalCompositeOperation="multiply");var e=ol.ext.element.getStyle(t,"transform")||ol.ext.element.getStyle(t,"-webkit-transform");/^matrix/.test(e)?((e=e.replace(/^matrix\(|\)$/g,"").split(",")).forEach(function(t,o){e[o]=parseFloat(t)}),i.transform(e[0],e[1],e[2],e[3],e[4],e[5]),i.drawImage(t,0,0)):i.drawImage(t,0,0,ol.ext.element.getStyle(t,"width"),ol.ext.element.getStyle(t,"height")),i.restore()}}.bind(this))}return o},ol.control.Print.prototype.fastPrint=function(t,e){t=t||{},this._ol6?requestAnimationFrame(function(){e(this._getCanvas({},t.imageType,t.canvas))}.bind(this)):(this.getMap().once("postcompose",function(o){o.context||(this._ol6=!0),e(this._getCanvas(o,t.imageType,t.canvas))}.bind(this)),this.getMap().render())},ol.control.Print.prototype.print=function(t){var e=(t=t||{}).imageType||this.get("imageType"),o=t.quality||this.get("quality");if(this.getMap()){if("silent"!==t.immediate&&this.dispatchEvent(Object.assign({type:"printing"},t)),!t.immediate)return void setTimeout(function(){(t=Object.assign({},t)).immediate="silent",this.print(t)}.bind(this),200);this.getMap().once(this.get("immediate")?"postcompose":"rendercomplete",function(i){var n,r,s,a,l=this._getCanvas(i,e),c=t.size||[210,297],h=t.format||"a4",p=t.orient||this.get("orientation"),u="number"==typeof t.margin?t.margin:10;if(l){"landscape"!==p&&"portrait"!==p&&(p=l.width>l.height?"landscape":"portrait"),"landscape"===p&&(c=[c[1],c[0]]);var g=Math.min((c[0]-2*u)/l.width,(c[1]-2*u)/l.height);n=g*l.width,r=g*l.height,s=[(c[0]-n)/2,(c[1]-r)/2]}try{a=l?l.toDataURL(e,o):null}catch(d){return void this.dispatchEvent({type:"error",canvas:l})}var d=Object.assign({type:"print",print:{format:h,orientation:p,unit:"mm",size:c,position:s,imageWidth:n,imageHeight:r},image:a,imageType:e,quality:o,canvas:l},t);this.dispatchEvent(d)}.bind(this)),this.getMap().render()}},ol.control.PrintDialog=function(t){t||(t={}),this._lang=t.lang||"en";var e=ol.ext.element.create("DIV",{className:(t.className||"ol-print")+" ol-unselectable ol-control"});ol.ext.element.create("BUTTON",{type:"button",title:t.title||"Print",click:function(){this.print()}.bind(this),parent:e}),ol.control.Control.call(this,{element:e}),t.openWindow&&this.on("print",function(t){t.canvas&&window.open().document.write('<img src="'+t.canvas.toDataURL()+'"/>')}),t.target=ol.ext.element.create("DIV");var o=this._printCtrl=new ol.control.Print(t);o.on(["print","error","printing"],function(t){n.setAttribute("data-status",t.type),t.clipboard||this.dispatchEvent(t)}.bind(this)),this._compass=new ol.control.Compass({src:t.northImage||"compact",visible:!1,className:"olext-print-compass",style:new ol.style.Stroke({color:"#333",width:0})});var i=this._printDialog=new ol.control.Dialog({target:document.body,closeBox:!0,className:"ol-ext-print-dialog"}),n=i.getContentElement();this._input={};var r=ol.ext.element.create("DIV",{className:"ol-print-param",parent:n});this._pages=[ol.ext.element.create("DIV",{className:"ol-page"})];var s=ol.ext.element.create("DIV",{className:"ol-map",parent:this._pages[0]});ol.ext.element.create("DIV",{html:this._pages[0],className:"ol-print-map",parent:n}),ol.ext.element.create("H2",{html:this.i18n("title"),parent:r});var a=ol.ext.element.create("UL",{parent:r}),l=ol.ext.element.create("LI",{className:"ol-orientation",parent:a});this._input.orientation={list:l};var c,h=ol.ext.element.create("LABEL",{className:"portrait",parent:l});this._input.orientation.portrait=ol.ext.element.create("INPUT",{type:"radio",name:"ol-print-orientation",value:"portrait",checked:!0,on:{change:function(t){this.setOrientation(t.target.value)}.bind(this)},parent:h}),ol.ext.element.create("SPAN",{html:this.i18n("portrait"),parent:h}),h=ol.ext.element.create("LABEL",{className:"landscape",parent:l}),this._input.orientation.landscape=ol.ext.element.create("INPUT",{type:"radio",name:"ol-print-orientation",value:"landscape",on:{change:function(t){this.setOrientation(t.target.value)}.bind(this)},parent:h}),ol.ext.element.create("SPAN",{html:this.i18n("landscape"),parent:h}),l=ol.ext.element.create("LI",{html:ol.ext.element.create("LABEL",{html:this.i18n("size")}),className:"ol-size",parent:a});var p=this._input.size=ol.ext.element.create("SELECT",{on:{change:function(){this.setSize(p.value||C)}.bind(this)},parent:l});for(c in this.paperSize)ol.ext.element.create("OPTION",{html:c+(this.paperSize[c]?" - "+this.paperSize[c][0]+"x"+this.paperSize[c][1]+" mm":this.i18n("custom")),value:c,parent:p});l=ol.ext.element.create("LI",{html:ol.ext.element.create("LABEL",{html:this.i18n("margin")}),className:"ol-margin",parent:a});var u=this._input.margin=ol.ext.element.create("SELECT",{on:{change:function(){this.setMargin(u.value)}.bind(this)},parent:l});for(c in this.marginSize)ol.ext.element.create("OPTION",{html:this.i18n(c)+" - "+this.marginSize[c]+" mm",value:this.marginSize[c],parent:u});l=ol.ext.element.create("LI",{html:ol.ext.element.create("LABEL",{html:this.i18n("scale")}),className:"ol-scale",parent:a});var g=this._input.scale=ol.ext.element.create("SELECT",{on:{change:function(){this.setScale(parseInt(g.value))}.bind(this)},parent:l});Object.keys(this.scales).forEach(function(t){ol.ext.element.create("OPTION",{html:this.scales[t],value:t,parent:g})}.bind(this)),l=ol.ext.element.create("LI",{className:"ol-legend",parent:a});var d=ol.ext.element.createSwitch({html:this.i18n("legend"),checked:!1,on:{change:function(){T.legend.control.setCanvas(d.checked)}.bind(this)},parent:l});l=ol.ext.element.create("LI",{className:"ol-print-north",parent:a});var m=this._input.north=ol.ext.element.createSwitch({html:this.i18n("north"),checked:"checked",on:{change:function(){m.checked?this._compass.element.classList.add("ol-print-compass"):this._compass.element.classList.remove("ol-print-compass"),this.getMap().render()}.bind(this)},parent:l});l=ol.ext.element.create("LI",{className:"ol-print-title",parent:a});var f=ol.ext.element.createSwitch({html:this.i18n("mapTitle"),checked:!1,on:{change:function(t){T.title.control.setVisible(t.target.checked)}.bind(this)},parent:l}),y=ol.ext.element.create("INPUT",{type:"text",placeholder:this.i18n("mapTitle"),on:{keydown:function(t){13===t.keyCode&&t.preventDefault()},keyup:function(){T.title.control.setTitle(y.value)},change:function(){T.title.control.setTitle(y.value)}.bind(this)},parent:l}),v=ol.ext.element.create("DIV",{className:"ol-user-param",parent:r});l=ol.ext.element.create("LI",{className:"ol-saveas",parent:a});var _=ol.ext.element.create("DIV",{html:this.i18n("copied"),className:"ol-clipboard-copy",parent:l}),x=ol.ext.element.create("SELECT",{on:{change:function(){if(this.formats[x.value].clipboard)o.copyMap(this.formats[x.value],function(t){t&&(_.classList.add("visible"),setTimeout(function(){_.classList.remove("visible")},1e3))});else{var t="string"==typeof this.getSize()?this.getSize():null,e=Object.assign({format:t,size:t?this.paperSize[t]:null,orient:this.getOrientation(),margin:this.getMargin()},this.formats[x.value]);o.print(e)}x.value=""}.bind(this)},parent:l});ol.ext.element.create("OPTION",{html:this.i18n("saveas"),style:{display:"none"},value:"",parent:x}),this.formats.forEach(function(e,o){if(e.pdf){if(!1===t.pdf)return}else if(e.clipboard){if(!1===t.copy)return}else if(!1===t.save)return;ol.ext.element.create("OPTION",{html:this.i18n(e.title),value:o,parent:x})}.bind(this)),l=ol.ext.element.create("LI",{className:"ol-savelegend",parent:a});var b=ol.ext.element.create("DIV",{html:this.i18n("copied"),className:"ol-clipboard-copy",parent:l}),w=ol.ext.element.create("SELECT",{on:{change:function(){var t=T.legend.control.getLegend().getCanvas(),e=document.createElement("CANVAS");e.width=t.width,e.height=t.height;var o,i=e.getContext("2d");if(i.fillStyle="#fff",i.fillRect(0,0,e.width,e.height),i.drawImage(t,0,0),this.formats[w.value].clipboard)e.toBlob(function(t){try{navigator.clipboard.write([new window.ClipboardItem(Object.defineProperty({},t.type,{value:t,enumerable:!0}))]),b.classList.add("visible"),setTimeout(function(){b.classList.remove("visible")},1e3)}catch(t){}},"image/png");else try{o=e.toDataURL(this.formats[w.value].imageType,this.formats[w.value].quality);var n="string"==typeof this.getSize()?this.getSize():"A4",r=e.width/96*25.4,s=e.height/96*25.4,a=this.paperSize[n];"landscape"===this.getOrientation()&&(a=[a[1],a[0]]);var l=[(a[0]-r)/2,(a[1]-s)/2];this.dispatchEvent({type:"print",print:{legend:!0,format:n,orientation:this.getOrientation(),unit:"mm",size:this.paperSize[n],position:l,imageWidth:r,imageHeight:s},image:o,imageType:this.formats[w.value].imageType,pdf:this.formats[w.value].pdf,quality:this.formats[w.value].quality,canvas:e})}catch(t){}w.value=""}.bind(this)},parent:l});ol.ext.element.create("OPTION",{html:this.i18n("saveLegend"),style:{display:"none"},value:"",parent:w}),this.formats.forEach(function(t,e){ol.ext.element.create("OPTION",{html:this.i18n(t.title),value:e,parent:w})}.bind(this));var S,C,M,E=ol.ext.element.create("DIV",{className:"ol-ext-buttons",parent:r});ol.ext.element.create("BUTTON",{html:this.i18n("printBt"),type:"submit",click:function(t){t.preventDefault(),window.print()},parent:E}),ol.ext.element.create("BUTTON",{html:this.i18n("cancel"),type:"button",click:function(){i.hide()},parent:E}),ol.ext.element.create("DIV",{html:this.i18n("errorMsg"),className:"ol-error",parent:r});var T={};i.on("show",function(){this.dispatchEvent({type:"show",userElement:v,dialog:this._printDialog,page:this.getPage()});var t=this.getMap();t&&(document.body.classList.add("ol-print-document"),S=t.getTargetElement(),C=t.getSize(),"string"==typeof this.getSize()?this.setSize(this.getSize()):this.setSize(C),t.setTarget(s),M&&ol.Observable.unByKey(M),M=t.on("moveend",function(){this.setScale(ol.sphere.getMapScale(t))}.bind(this)),this.setScale(ol.sphere.getMapScale(t)),T={},this.getMap().getControls().forEach(function(t){t instanceof ol.control.Legend&&(T.legend={control:t}),t instanceof ol.control.CanvasTitle&&(T.title={control:t}),t instanceof ol.control.Compass&&(T.compass?t.element.classList.remove("ol-print-compass"):(this._input.north.checked?t.element.classList.add("ol-print-compass"):t.element.classList.remove("ol-print-compass"),this._compass=t,T.compass={control:t}))}.bind(this)),T.title?(f.checked=T.title.isVisible=T.title.control.getVisible(),y.value=T.title.control.getTitle(),f.parentNode.parentNode.classList.remove("hidden")):f.parentNode.parentNode.classList.add("hidden"),T.legend?(T.legend.ison=T.legend.control.onCanvas(),T.legend.collapsed=T.legend.control.isCollapsed(),T.legend.control.collapse(!1),w.parentNode.classList.remove("hidden"),d.parentNode.parentNode.classList.remove("hidden"),d.checked=!T.legend.collapsed,T.legend.control.setCanvas(!T.legend.collapsed)):(w.parentNode.classList.add("hidden"),d.parentNode.parentNode.classList.add("hidden")))}.bind(this)),i.on("hide",function(){document.body.classList.remove("ol-print-document"),S&&(this.getMap().setTarget(S),S=null,M&&ol.Observable.unByKey(M),T.title&&T.title.control.setVisible(T.title.isVisible),T.legend&&(T.legend.control.setCanvas(T.legend.ison),T.legend.control.collapse(T.legend.collapsed)),this.dispatchEvent({type:"hide"}))}.bind(this)),window.addEventListener("resize",function(){this.setSize()}.bind(this)),t.saveAs&&this.on("print",function(e){e.pdf||e.canvas.toBlob(function(o){var i=(e.print.legend?"legend.":"map.")+e.imageType.replace("image/","");t.saveAs(o,i)},e.imageType,e.quality)}),t.jsPDF&&this.on("print",function(e){if(e.pdf){var o=new t.jsPDF({orientation:e.print.orientation,unit:e.print.unit,format:e.print.size});o.addImage(e.image,"JPEG",e.print.position[0],e.print.position[0],e.print.imageWidth,e.print.imageHeight),o.save(e.print.legend?"legend.pdf":"map.pdf")}})},ol.ext.inherits(ol.control.PrintDialog,ol.control.Control),ol.control.PrintDialog.prototype.isOpen=function(){return this._printDialog.isOpen()},ol.control.PrintDialog.addLang=function(t,e){ol.control.PrintDialog.prototype._labels[t]=e},ol.control.PrintDialog.prototype.i18n=function(t){var e=this._labels.en[t]||"bad param";return this._labels[this._lang]&&this._labels[this._lang][t]&&(e=this._labels[this._lang][t]),e},ol.control.PrintDialog.prototype._labels={en:{title:"Print",orientation:"Orientation",portrait:"Portrait",landscape:"Landscape",size:"Page size",custom:"screen size",margin:"Margin",scale:"Scale",legend:"Legend",north:"North arrow",mapTitle:"Map title",saveas:"Save as...",saveLegend:"Save legend...",copied:"✔ Copied to clipboard",errorMsg:"Can't save map canvas...",printBt:"Print...",clipboardFormat:"copy to clipboard...",jpegFormat:"save as jpeg",pngFormat:"save as png",pdfFormat:"save as pdf",none:"none",small:"small",large:"large",cancel:"cancel"},fr:{title:"Imprimer",orientation:"Orientation",portrait:"Portrait",landscape:"Paysage",size:"Taille du papier",custom:"taille écran",margin:"Marges",scale:"Echelle",legend:"Légende",north:"Flèche du nord",mapTitle:"Titre de la carte",saveas:"Enregistrer sous...",saveLegend:"Enregistrer la légende...",copied:"✔ Carte copiée",errorMsg:"Impossible d'enregistrer la carte",printBt:"Imprimer",clipboardFormat:"copier dans le presse-papier...",jpegFormat:"enregistrer un jpeg",pngFormat:"enregistrer un png",pdfFormat:"enregistrer un pdf",none:"aucune",small:"petites",large:"larges",cancel:"annuler"},de:{title:"Drucken",orientation:"Ausrichtung",portrait:"Hochformat",landscape:"Querformat",size:"Papierformat",custom:"Bildschirmgröße",margin:"Rand",scale:"Maßstab",legend:"Legende",north:"Nordpfeil",mapTitle:"Kartentitel",saveas:"Speichern als...",saveLegend:"Legende speichern...",copied:"✔ In die Zwischenablage kopiert",errorMsg:"Kann Karte nicht speichern...",printBt:"Drucken...",clipboardFormat:"in die Zwischenablage kopieren...",jpegFormat:"speichern als jpeg",pngFormat:"speichern als png",pdfFormat:"speichern als pdf",none:"kein",small:"klein",large:"groß",cancel:"abbrechen"},zh:{title:"打印",orientation:"方向",portrait:"纵向",landscape:"横向",size:"页面大小",custom:"屏幕大小",margin:"外边距",scale:"尺度",legend:"图例",north:"指北针",mapTitle:"地图名字",saveas:"保存为...",saveLegend:"保存图例为...",copied:"✔ 已复制到剪贴板",errorMsg:"无法保存地图...",printBt:"打印...",cancel:"取消"}},ol.control.PrintDialog.prototype.paperSize={"":null,A0:[841,1189],A1:[594,841],A2:[420,594],A3:[297,420],A4:[210,297],"US Letter":[215.9,279.4],A5:[148,210],B4:[257,364],B5:[182,257]},ol.control.PrintDialog.prototype.marginSize={none:0,small:5,large:10},ol.control.PrintDialog.prototype.formats=[{title:"clipboardFormat",imageType:"image/png",clipboard:!0},{title:"jpegFormat",imageType:"image/jpeg",quality:.8},{title:"pngFormat",imageType:"image/png",quality:.8},{title:"pdfFormat",imageType:"image/jpeg",pdf:!0}],ol.control.PrintDialog.prototype.scales={" 5000":"1/5.000"," 10000":"1/10.000"," 25000":"1/25.000"," 50000":"1/50.000"," 100000":"1/100.000"," 250000":"1/250.000"," 1000000":"1/1.000.000"},ol.control.PrintDialog.prototype.getOrientation=function(){return this._orientation||"portrait"},ol.control.PrintDialog.prototype.setOrientation=function(t){this._orientation="landscape"===t?"landscape":"portrait",this._input.orientation[this._orientation].checked=!0,this.setSize()},ol.control.PrintDialog.prototype.getMargin=function(){return this._margin||0},ol.control.PrintDialog.prototype.setMargin=function(t){this._margin=t,this._input.margin.value=t,this.setSize()},ol.control.PrintDialog.prototype.getSize=function(){return this._size},ol.control.PrintDialog.prototype.setSize=function(t){if(this._printDialog.getContentElement().setAttribute("data-status",""),t?this._size=t:t=this._size,t){if("string"==typeof t){for(var e in this.paperSize)e&&new RegExp(e,"i").test(t)&&(t=e);this.paperSize[t]||(t=this._size="A4"),this._input.size.value=t,t=[Math.trunc(96*this.paperSize[t][0]/25.4),Math.trunc(96*this.paperSize[t][1]/25.4)],"landscape"===this.getOrientation()&&(t=[t[1],t[0]]),this.getPage().classList.remove("margin")}else this._input.size.value="",this.getPage().classList.add("margin");var o=this.getPage(),i=o.parentNode.getBoundingClientRect(),n=(i.width-40)/t[0],r=(i.height-40)/t[1],s=Math.min(n,r,1);o.style.width=t[0]+"px",o.style.height=t[1]+"px",o.style["-webkit-transform"]=o.style.transform="translate(-50%,-50%) scale("+s+")";var a=Math.round(5/s);o.style["-webkit-box-shadow"]=o.style["box-shadow"]=a+"px "+a+"px "+a+"px rgba(0,0,0,.6)",o.style.padding=96*this.getMargin()/25.4+"px",this.getMap()&&this.getMap().updateSize(),this.dispatchEvent({type:"dialog:refresh"})}},ol.control.PrintDialog.prototype.getContentElement=function(){return this._printDialog.getContentElement()},ol.control.PrintDialog.prototype.getUserElement=function(){return this._printDialog.getContentElement().querySelector(".ol-user-param")},ol.control.PrintDialog.prototype.getPage=function(){return this._pages[0]},ol.control.PrintDialog.prototype.setMap=function(t){this.getMap()&&(this.getMap().removeControl(this._compass),this.getMap().removeControl(this._printCtrl),this.getMap().removeControl(this._printDialog)),ol.control.Control.prototype.setMap.call(this,t),this.getMap()&&(this.getMap().addControl(this._compass),this.getMap().addControl(this._printCtrl),this.getMap().addControl(this._printDialog))},ol.control.PrintDialog.prototype.setScale=function(t){ol.sphere.setMapScale(this.getMap(),t),this._input.scale.value=" "+100*Math.round(t/100)},ol.control.PrintDialog.prototype.getScale=function(){return ol.sphere.getMapScale(this.getMap())},ol.control.PrintDialog.prototype.print=function(t){(t=t||{}).size&&this.setSize(t.size),t.scale&&this.setScale(t.scale),t.orientation&&this.setOrientation(t.orientation),t.margin&&this.setMargin(t.margin),this._printDialog.show()},ol.control.PrintDialog.prototype.getrintControl=function(){return this._printCtrl},ol.control.Profil=function(t){t=t||{},this.info=t.info||ol.control.Profil.prototype.info;var e,o=this;if(t.target)(e=document.createElement("div")).classList.add(t.className||"ol-profil");else{(e=document.createElement("div")).className=((t.className||"ol-profil")+" ol-unselectable ol-control ol-collapsed").trim(),this.button=document.createElement("button"),this.button.title=t.title||"Profile",this.button.setAttribute("type","button");var i=function(t){o.toggle(),t.preventDefault()};this.button.addEventListener("click",i),this.button.addEventListener("touchstart",i),e.appendChild(this.button)}t.style instanceof ol.style.Style?this._style=t.style:this._style=new ol.style.Style({text:new ol.style.Text,stroke:new ol.style.Stroke({width:1.5,color:"#369"})}),this._style.getText()||this._style.setText(new ol.style.Text),t.selectStyle instanceof ol.style.Style?this._selectStyle=t.selectStyle:this._selectStyle=new ol.style.Style({fill:new ol.style.Fill({color:"#369"})});var n=document.createElement("div");n.classList.add("ol-inner"),e.appendChild(n);var r=document.createElement("div");r.style.position="relative",n.appendChild(r);var s=this.ratio=2;this.canvas_=document.createElement("canvas"),this.canvas_.width=(t.width||300)*s,this.canvas_.height=(t.height||150)*s;var a={msTransform:"scale(0.5,0.5)",msTransformOrigin:"0 0",webkitTransform:"scale(0.5,0.5)",webkitTransformOrigin:"0 0",mozTransform:"scale(0.5,0.5)",mozTransformOrigin:"0 0",transform:"scale(0.5,0.5)",transformOrigin:"0 0"};Object.keys(a).forEach(function(t){t in o.canvas_.style&&(o.canvas_.style[t]=a[t])});var l=document.createElement("div");r.appendChild(l),l.style.width=this.canvas_.width/s+"px",l.style.height=this.canvas_.height/s+"px",l.appendChild(this.canvas_),l.addEventListener("pointerdown",this.onMove.bind(this)),document.addEventListener("pointerup",this.onMove.bind(this)),l.addEventListener("mousemove",this.onMove.bind(this)),l.addEventListener("touchmove",this.onMove.bind(this)),ol.control.Control.call(this,{element:e,target:t.target}),this.set("selectable",t.selectable),this.margin_={top:10*s,left:45*s,bottom:30*s,right:10*s},this.info.ytitle||(this.margin_.left-=20*s),this.info.xtitle||(this.margin_.bottom-=20*s),this.bar_=document.createElement("div"),this.bar_.classList.add("ol-profilbar"),this.bar_.style.top=this.margin_.top/s+"px",this.bar_.style.height=(this.canvas_.height-this.margin_.top-this.margin_.bottom)/s+"px",r.appendChild(this.bar_),this.cursor_=document.createElement("div"),this.cursor_.classList.add("ol-profilcursor"),r.appendChild(this.cursor_),this.popup_=document.createElement("div"),this.popup_.classList.add("ol-profilpopup"),this.cursor_.appendChild(this.popup_);var c=document.createElement("table");c.cellPadding="0",c.cellSpacing="0",c.style.clientWidth=this.canvas_.width/s+"px",r.appendChild(c);var h=document.createElement("tr");h.classList.add("track-info"),c.appendChild(h);var p=document.createElement("td");p.innerHTML=(this.info.zmin||"Zmin")+': <span class="zmin">',h.appendChild(p);var u=document.createElement("td");u.innerHTML=(this.info.zmax||"Zmax")+': <span class="zmax">',h.appendChild(u);var g=document.createElement("td");g.innerHTML=(this.info.distance||"Distance")+': <span class="dist">',h.appendChild(g);var d=document.createElement("td");d.innerHTML=(this.info.time||"Time")+': <span class="time">',h.appendChild(d);var m=document.createElement("tr");m.classList.add("point-info"),c.appendChild(m);var f=document.createElement("td");f.innerHTML=(this.info.altitude||"Altitude")+': <span class="z">',m.appendChild(f);var y=document.createElement("td");y.innerHTML=(this.info.distance||"Distance")+': <span class="dist">',m.appendChild(y);var v,_,x=document.createElement("td");(x.innerHTML=(this.info.time||"Time")+': <span class="time">',m.appendChild(x),this.tab_=[],t.feature&&this.setGeometry(t.feature),t.zoomable)&&(this.set("selectable",!0),this.on("change:geometry",function(){_=null}),this.on("dragstart",function(t){v=t.index}),this.on("dragend",function(t){if(Math.abs(v-t.index)>10){if(!_)var o=ol.ext.element.create("BUTTON",{parent:e,className:"ol-zoom-out",click:function(t){t.stopPropagation(),t.preventDefault(),_&&(this.dispatchEvent({type:"zoom"}),this.setGeometry(_,this._geometry[1])),e.removeChild(o)}.bind(this)});var i=_||this._geometry[0],n=new ol.geom.LineString(this.getSelection(v,t.index));this.setGeometry(n,this._geometry[1]),_=i,this.dispatchEvent({type:"zoom",geometry:n,start:v,end:t.index})}}.bind(this)))},ol.ext.inherits(ol.control.Profil,ol.control.Control),ol.control.Profil.prototype.info={zmin:"Zmin",zmax:"Zmax",ytitle:"Altitude (m)",xtitle:"Distance (km)",time:"Time",altitude:"Altitude",distance:"Distance",altitudeUnits:"m",distanceUnitsM:"m",distanceUnitsKM:"km"},ol.control.Profil.prototype.popup=function(t){this.popup_.innerHTML=t},ol.control.Profil.prototype._drawAt=function(t,e){t?(this.cursor_.style.left=e+"px",this.cursor_.style.top=(this.canvas_.height-this.margin_.bottom+t[1]*this.scale_[1]+this.dy_)/this.ratio+"px",this.cursor_.style.display="block",this.bar_.parentElement.classList.add("over"),this.bar_.style.left=e+"px",this.bar_.style.display="block",this.element.querySelector(".point-info .z").textContent=t[1]+this.info.altitudeUnits,this.element.querySelector(".point-info .dist").textContent=(t[0]/1e3).toFixed(1)+this.info.distanceUnitsKM,this.element.querySelector(".point-info .time").textContent=t[2],e>this.canvas_.width/this.ratio/2?this.popup_.classList.add("ol-left"):this.popup_.classList.remove("ol-left")):(this.cursor_.style.display="none",this.bar_.style.display="none",this.cursor_.style.display="none",this.bar_.parentElement.classList.remove("over"))},ol.control.Profil.prototype.showAt=function(t){var e,o,i,n=1/0;if(void 0===t)this.bar_.parentElement.classList.contains("over")&&this._drawAt();else if(t.length)for(e=1;o=this.tab_[e];e++){var r=ol.coordinate.dist2d(o[3],t);r<n&&(i=o,n=r)}else for(e=0;(o=this.tab_[e])&&(i=o,!(o[0]>=t));e++);if(i){var s=(i[0]*this.scale_[0]+this.margin_.left)/this.ratio;return this._drawAt(i,s),i[3]}return null},ol.control.Profil.prototype.showAtTime=function(t,e){var o,i,n;if(t instanceof Date?t=t.getTime()/1e3:e&&(t+=this.tab_[0][3][3]),void 0===t)this.bar_.parentElement.classList.contains("over")&&this._drawAt();else for(o=0;(i=this.tab_[o])&&(n=i,!(i[3][3]>=t));o++);if(n){var r=(n[0]*this.scale_[0]+this.margin_.left)/this.ratio;return this._drawAt(n,r),n[3]}return null},ol.control.Profil.prototype.pointAtTime=function(t){var e,o;for(e=1;o=this.tab_[e];e++){var i=o[3][3];if(i>=t){var n=this.tab_[e-1][3];return(n[3]+i)/2<t?n:o}}return this.tab_[this.tab_.length-1][3]},ol.control.Profil.prototype.onMove=function(t){if(this.tab_.length){var e=this.canvas_.getBoundingClientRect(),o=e.top+window.pageYOffset-document.documentElement.clientTop,i=e.left+window.pageXOffset-document.documentElement.clientLeft,n=t.pageX||t.touches&&t.touches.length&&t.touches[0].pageX||t.changedTouches&&t.changedTouches.length&&t.changedTouches[0].pageX,r=t.pageY||t.touches&&t.touches.length&&t.touches[0].pageY||t.changedTouches&&t.changedTouches.length&&t.changedTouches[0].pageY,s=n-i,a=r-o,l=this.ratio;if(s>this.margin_.left/l-20&&s<(this.canvas_.width-this.margin_.right)/l+8&&a>this.margin_.top/l&&a<(this.canvas_.height-this.margin_.bottom)/l){var c,h,p=(s*l-this.margin_.left)/this.scale_[0],u=this.tab_[0];for(c=1;h=this.tab_[c];c++)if(h[0]>=p){p<(h[0]+u[0])/2&&(c=0,h=u);break}switch(h||(h=this.tab_[this.tab_.length-1]),s=Math.max(this.margin_.left/l,Math.min(s,(this.canvas_.width-this.margin_.right)/l)),this._drawAt(h,s),this.dispatchEvent({type:"over",click:"click"===t.type,index:c,coord:h[3],time:h[2],distance:h[0]}),t.type){case"pointerdown":this._dragging={event:{type:"dragstart",index:c,coord:h[3],time:h[2],distance:h[0]},pageX:n,pageY:r};break;case"pointerup":this._dragging&&this._dragging.pageX?Math.abs(this._dragging.pageX-n)<3&&Math.abs(this._dragging.pageY-r)<3&&(this.dispatchEvent({type:"click",index:c,coord:h[3],time:h[2],distance:h[0]}),this.refresh()):this.dispatchEvent({type:"dragend",index:c,coord:h[3],time:h[2],distance:h[0]}),this._dragging=!1;break;default:if(this._dragging)if(this._dragging.pageX)(Math.abs(this._dragging.pageX-n)>3||Math.abs(this._dragging.pageY-r)>3)&&(this._dragging.pageX=this._dragging.pageY=!1,this.dispatchEvent(this._dragging.event));else{this.dispatchEvent({type:"dragging",index:c,coord:h[3],time:h[2],distance:h[0]});var g=Math.min(this._dragging.event.index,c),d=Math.max(this._dragging.event.index,c);this.refresh(),this.get("selectable")&&this._drawGraph(this.tab_.slice(g,d),this._selectStyle)}}}else this.bar_.parentElement.classList.contains("over")&&(this._drawAt(),this.dispatchEvent({type:"out"})),"pointerup"===t.type&&this._dragging&&(this.dispatchEvent({type:"dragcancel"}),this._dragging=!1)}},ol.control.Profil.prototype.show=function(){this.element.classList.remove("ol-collapsed"),this.dispatchEvent({type:"show",show:!0})},ol.control.Profil.prototype.hide=function(){this.element.classList.add("ol-collapsed"),this.dispatchEvent({type:"show",show:!1})},ol.control.Profil.prototype.toggle=function(){this.element.classList.toggle("ol-collapsed");var t=this.element.classList.contains("ol-collapsed");this.dispatchEvent({type:"show",show:!t})},ol.control.Profil.prototype.isShown=function(){return!this.element.classList.contains("ol-collapsed")},ol.control.Profil.prototype.getSelection=function(t,e){for(var o=[],i=Math.max(Math.min(t,e),0),n=Math.min(Math.max(t,e),this.tab_.length-1),r=i;r<=n;r++)o.push(this.tab_[r][3]);return o},ol.control.Profil.prototype._drawGraph=function(t,e){if(t.length){var o,i,n=this.canvas_.getContext("2d"),r=this.scale_[0],s=this.scale_[1],a=this.dy_,l=this.ratio;for(n.beginPath(),o=0;i=t[o];o++)0==o?n.moveTo(i[0]*r,i[1]*s+a):n.lineTo(i[0]*r,i[1]*s+a);e.getStroke()&&(n.strokeStyle=e.getStroke().getColor()||"#000",n.lineWidth=e.getStroke().getWidth()*l,n.setLineDash([]),n.stroke()),e.getFill()&&(n.fillStyle=e.getFill().getColor()||"#000",n.Style=e.getFill().getColor()||"#000",n.lineTo(t[t.length-1][0]*r,0),n.lineTo(t[0][0]*r,0),n.fill())}},ol.control.Profil.prototype.setGeometry=function(t,e){if(e||(e={}),t instanceof ol.Feature&&(t=t.getGeometry()),this._geometry=[t,e],/Z/.test(t.getLayout())){/M/.test(t.getLayout())?this.element.querySelector(".time").parentElement.style.display="block":this.element.querySelector(".time").parentElement.style.display="none";var o=t.getCoordinates();switch(t.getType()){case"LineString":break;case"MultiLineString":o=o[0];break;default:return}var i,n,r,s,a,l,c,h=e.projection||this.getMap().getView().getProjection(),p=1/0,u=-1/0,g=this.tab_=[];for(i=0;n=o[i];i++)(s=n[2])<p&&(p=s),s>u&&(u=s),0==i?r=0:r+=(l=o[i-1],c=n,ol.sphere.getDistance(ol.proj.transform(l,h,"EPSG:4326"),ol.proj.transform(c,h,"EPSG:4326"))),a=d(o[0][3],n[3]),g.push([r,s,a,n]);this._z=[p,u],this.set("graduation",e.graduation||100),this.set("zmin",e.zmin),this.set("zmax",e.zmax),this.set("amplitude",e.amplitude),this.set("unit",e.unit),this.set("zunit",e.zunit),this.set("zDigits",e.zDigits),this.set("zMaxChars",e.zMaxChars),this.dispatchEvent({type:"change:geometry",geometry:t}),this.refresh()}function d(t,e){if(!t||!e)return"-";var o=(e-t)/60,i=Math.trunc(o/60),n=Math.trunc(o-60*i);return i+"h"+(n<10?"0":"")+n+"mn"}},ol.control.Profil.prototype.refresh=function(){var t=this.canvas_,e=t.getContext("2d"),o=t.width,i=t.height;e.setTransform(1,0,0,1,0,0),e.clearRect(0,0,o,i);var n,r=this._z[0],s=this._z[1],a=this.tab_,l=a[a.length-1][0],c=a[a.length-1][2];if(l){e.setTransform(1,0,0,1,this.margin_.left,i-this.margin_.bottom);var h=this.ratio;o-=this.margin_.right+this.margin_.left,i-=this.margin_.top+this.margin_.bottom,e.strokeStyle=this._style.getText().getFill().getColor()||"#000",e.lineWidth=.5*h,e.beginPath(),e.moveTo(0,0),e.lineTo(0,-i),e.moveTo(0,0),e.lineTo(o,0),e.stroke(),this.element.querySelector(".track-info .zmin").textContent=r.toFixed(2)+this.info.altitudeUnits,this.element.querySelector(".track-info .zmax").textContent=s.toFixed(2)+this.info.altitudeUnits,this.element.querySelector(".track-info .dist").textContent=l>1e3?(l/1e3).toFixed(1)+this.info.distanceUnitsKM:l.toFixed(1)+this.info.distanceUnitsM,this.element.querySelector(".track-info .time").textContent=c;for(var p=this.get("graduation");;){if(!(i/(((s=Math.ceil(s/p)*p)-(r=Math.floor(r/p)*p))/p)<15*h))break;p*=2}"number"==typeof this.get("zmin")&&r>this.get("zmin")&&(r=this.get("zmin")),"number"==typeof this.get("zmax")&&s<this.get("zmax")&&(s=this.get("zmax"));var u=this.get("amplitude");u&&(s=Math.max(r+u,s));var g=o/l,d=-i/(s-r),m=this.dy_=-r*d;this.scale_=[g,d],this._drawGraph(a,this._style),e.textAlign="right",e.textBaseline="top",e.fillStyle=this._style.getText().getFill().getColor()||"#000",e.beginPath();var f,y=this.get("zDigits")||0,v=null;if("number"==typeof this.get("zMaxChars"))if(f="km"!=this.get("zunit")?Math.max(r.toFixed(y).length,s.toFixed(y).length):Math.max((r/1e3).toFixed(1).length,(s/1e3).toFixed(1).length),this.get("zMaxChars")<f){v=Math.floor(Math.log10(Math.max(Math.abs(r),Math.abs(s),Number.MIN_VALUE))),e.font="bold "+9*h+"px arial",e.fillText(v.toString(),-8*h,8*h);var _=e.measureText(v.toString()),x=_.width,b=_.actualBoundingBoxAscent+_.actualBoundingBoxDescent;e.font="bold "+12*h+"px arial",e.fillText("10",-8*h-x,8*h+.5*b)}for(e.font=10*h+"px arial",e.textBaseline="middle",n=r;n<=s;n+=p){if(null!==v){var w=n/Math.pow(10,v);"km"==this.get("zunit")&&(w/=1e3);var S=this.get("zMaxChars")-Math.floor(Math.log10(Math.max(Math.abs(w),1))+1)-1;w<0&&(S-=1),this.get("zunit"),e.fillText(w.toFixed(Math.max(S,0)),-4*h,n*d+m)}else"km"!=this.get("zunit")?e.fillText(n.toFixed(y),-4*h,n*d+m):e.fillText((n/1e3).toFixed(1),-4*h,n*d+m);e.moveTo(-2*h,n*d+m),0!=n?e.lineTo(l*g,n*d+m):e.lineTo(0,n*d+m)}e.textAlign="center",e.textBaseline="top",e.setLineDash([h,3*h]);var C,M=this.get("unit")||"km";for(l>1e3?(C=100*Math.round(l/1e3))>1e3&&(C=1e3*Math.ceil(C/1e3)):(M="m",C=l>100?10*Math.round(l/100):l>10?Math.round(l/10):l>1?Math.round(l)/10:l),n=0;n<=l;n+=C){var E="m"==M?n:n/1e3;e.fillText(Math.round(10*E)/10,n*g,4*h),e.moveTo(n*g,2*h),e.lineTo(n*g,0)}e.font=12*h+"px arial",e.fillText(this.info.xtitle.replace("(km)","("+M+")"),o/2,18*h),e.save(),e.rotate(-Math.PI/2),e.fillText(this.info.ytitle,i/2,-this.margin_.left),e.restore(),e.stroke()}else console.error("[ol/control/Profil] no data...",a)},ol.control.Profil.prototype.getImage=function(t,e){return"canvas"===t?this.canvas_:this.canvas_.toDataURL(t,e)},ol.control.ProgressBar=function(t){t=t||{};var e=ol.ext.element.create("DIV",{className:((t.className||"")+" ol-progress-bar ol-unselectable ol-control").trim()});this._waiting=ol.ext.element.create("DIV",{html:t.label||"",className:"ol-waiting",parent:e}),this._bar=ol.ext.element.create("DIV",{className:"ol-bar",parent:e}),ol.control.Control.call(this,{element:e,target:t.target}),this._layerlistener=[],this.setLayers(t.layers)},ol.ext.inherits(ol.control.ProgressBar,ol.control.Control),ol.control.ProgressBar.prototype.setPercent=function(t){this._bar.style.width=100*(Number(t)||0)+"%",void 0===t?ol.ext.element.hide(this.element):ol.ext.element.show(this.element)},ol.control.ProgressBar.prototype.setLabel=function(t){this._waiting.innerHTML=t},ol.control.ProgressBar.prototype.setLayers=function(t){this._layerlistener.forEach(function(t){ol.Observable.unByKey(t)}),this._layerlistener=[],this.setPercent();var e,o=0,i=0;(t instanceof ol.layer.Layer&&(t=[t]),t&&t.forEach)&&t.forEach(function(t){t instanceof ol.layer.Layer&&(this._layerlistener.push(t.getSource().on("tileloadstart",function(){o++,this.setPercent(i/o),clearTimeout(e)}.bind(this))),this._layerlistener.push(t.getSource().on(["tileloadend","tileloaderror"],function(){++i===o?(o=i=0,this.setPercent(1),e=setTimeout(this.setPercent.bind(this),300)):this.setPercent(i/o)}.bind(this))))}.bind(this))},ol.control.RoutingGeoportail=function(t){var e=this;t||(t={}),null==t.typing&&(t.typing=300),t.apiKey=t.apiKey||"itineraire",t.search||(t.search={}),t.search.apiKey=t.search.apiKey||"essentiels",this._classname=t.className||"search",this._source=new ol.source.Vector,this._auth=t.authentication;var o=document.createElement("DIV"),i=(t.className||"")+" ol-routing";(t.target||(i+=" ol-unselectable ol-control"),o.setAttribute("class",i),t.target)||ol.ext.element.create("BUTTON",{parent:o}).addEventListener("click",function(){o.classList.toggle("ol-collapsed")});ol.control.Control.call(this,{element:o,target:t.target}),this.set("url","https://wxs.ign.fr/calcul/geoportail/"+t.apiKey+"/rest/1.0.0/route");var n=ol.ext.element.create("DIV",{className:"content",parent:o}),r=ol.ext.element.create("DIV",{className:"search-input",parent:n});this._search=[],this.addSearch(r,t),this.addSearch(r,t),ol.ext.element.create("I",{className:"ol-car",title:t.carlabel||"by car",parent:n}).addEventListener("click",function(){e.setMode("car")}),ol.ext.element.create("I",{className:"ol-pedestrian",title:t.pedlabel||"pedestrian",parent:n}).addEventListener("click",function(){e.setMode("pedestrian")}),ol.ext.element.create("I",{className:"ol-ok",title:t.runlabel||"search",html:"OK",parent:n}).addEventListener("click",function(){e.calculate()}),ol.ext.element.create("I",{className:"ol-cancel",html:"cancel",parent:n}).addEventListener("click",function(){this.resultElement.innerHTML=""}.bind(this)),this.resultElement=document.createElement("DIV"),this.resultElement.setAttribute("class","ol-result"),o.appendChild(this.resultElement),this.setMode(t.mode||"car"),this.set("timeout",t.timeout||2e4)},ol.ext.inherits(ol.control.RoutingGeoportail,ol.control.Control),ol.control.RoutingGeoportail.prototype.setMode=function(t,e){this.set("mode",t),this.element.querySelector(".ol-car").classList.remove("selected"),this.element.querySelector(".ol-pedestrian").classList.remove("selected"),this.element.querySelector(".ol-"+t).classList.add("selected"),e||this.calculate()},ol.control.RoutingGeoportail.prototype.setMethod=function(t,e){this.set("method",t),e||this.calculate()},ol.control.RoutingGeoportail.prototype.addButton=function(t,e,o){var i=document.createElement("I");return i.setAttribute("class",t),i.setAttribute("type","button"),i.setAttribute("title",e),i.innerHTML=o||"",this.element.appendChild(i),i},ol.control.RoutingGeoportail.prototype.getSource=function(){return this._source},ol.control.RoutingGeoportail.prototype._resetArray=function(t){this._search=[];var e=t.parentNode.querySelectorAll(".search-input > div");e.forEach(function(t){t.olsearch&&(t.olsearch.get("feature")&&(t.olsearch.get("feature").set("step",this._search.length),0===this._search.length?t.olsearch.get("feature").set("pos","start"):this._search.length===e.length-1?t.olsearch.get("feature").set("pos","end"):t.olsearch.get("feature").set("pos","")),this._search.push(t.olsearch))}.bind(this))},ol.control.RoutingGeoportail.prototype.removeSearch=function(t,e,o){t.removeChild(o),o.olsearch.get("feature")&&this._source.removeFeature(o.olsearch.get("feature")),this.getMap()&&this.getMap().removeControl(o.olsearch),this._resetArray(t)},ol.control.RoutingGeoportail.prototype.addSearch=function(t,e,o){var i=this,n=ol.ext.element.create("DIV");o?t.insertBefore(n,o.nextSibling):t.appendChild(n),ol.ext.element.create("BUTTON",{title:e.startlabel||"add/remove",parent:n}).addEventListener("click",function(o){o.ctrlKey?this._search.length>2&&this.removeSearch(t,e,n):o.shiftKey&&this.addSearch(t,e,n)}.bind(this));var r=n.olsearch=new ol.control.SearchGeoportail({className:"IGNF ol-collapsed",apiKey:e.search.apiKey,authentication:e.search.authentication,target:n,reverse:!0});r._changeCounter=0,this._resetArray(t),r.on("select",function(t){r.setInput(t.search.fulltext);var e=r.get("feature");e?(r.checkgeom=!1,t.silent||e.getGeometry().setCoordinates(t.coordinate),r.checkgeom=!0):(e=new ol.Feature(new ol.geom.Point(t.coordinate)),r.set("feature",e),this._source.addFeature(e),r.checkgeom=!0,e.getGeometry().on("change",function(){r.checkgeom&&this.onGeometryChange(r,e)}.bind(this))),e.set("name",r.getTitle(t.search)),e.set("step",this._search.indexOf(r)),0===e.get("step")?e.set("pos","start"):e.get("step")===this._search.length-1&&e.set("pos","end"),r.set("selection",t.search)}.bind(this)),r.element.querySelector("input").addEventListener("change",function(){r.set("selection",null),i.resultElement.innerHTML=""}),this.getMap()&&this.getMap().addControl(r)},ol.control.RoutingGeoportail.prototype.onGeometryChange=function(t,e,o){var i=ol.proj.transform(e.getGeometry().getCoordinates(),this.getMap().getView().getProjection(),"EPSG:4326");if(t._handleSelect({x:i[0],y:i[1],fulltext:i[0].toFixed(6)+","+i[1].toFixed(6)},!0,{silent:!0}),o){if(t._changeCounter--,!t._changeCounter)return void t.reverseGeocode(e.getGeometry().getCoordinates(),{silent:!0})}else t._changeCounter++,setTimeout(function(){this.onGeometryChange(t,e,!0)}.bind(this),1e3)},ol.control.RoutingGeoportail.prototype.setMap=function(t){ol.control.Control.prototype.setMap.call(this,t);for(var e=0;e<this._search.length;e++){this._search[e].setMap(t)}},ol.control.RoutingGeoportail.prototype.requestData=function(t){for(var e=t[0],o=t[t.length-1],i="",n=1;n<t.length-1;n++)i+=(i?";":"")+t[n].x+","+t[n].y;return{resource:"bdtopo-osrm",profile:"pedestrian"===this.get("mode")?"pedestrian":"car",optimization:this.get("method")||"fastest",start:e.x+","+e.y,end:o.x+","+o.y,intermediates:i,geometryFormat:"geojson"}},ol.control.RoutingGeoportail.prototype.getTimeString=function(t){return(t/=60)<1?"":t<60?t.toFixed(0)+" min":(t/60).toFixed(0)+" h "+(t%60).toFixed(0)+" min"},ol.control.RoutingGeoportail.prototype.getDistanceString=function(t){return t<1e3?t.toFixed(0)+" m":(t/1e3).toFixed(2)+" km"},ol.control.RoutingGeoportail.prototype.listRouting=function(t){this.resultElement.innerHTML="";var e=this.getTimeString(t.duration);e+=" ("+this.getDistanceString(t.distance)+")";var o=document.createElement("i");o.textContent=e,this.resultElement.appendChild(o);var i=document.createElement("ul");this.resultElement.appendChild(i);var n={none:"Prendre sur ",R:"Tourner à droite sur ",FR:"Tourner légèrement à droite sur ",L:"Tourner à gauche sur ",FL:"Tourner légèrement à gauche sur ",F:"Continuer tout droit sur "};t.features.forEach(function(t,o){var r=this.getDistanceString(t.get("distance"));e=this.getTimeString(t.get("durationT")),ol.ext.element.create("LI",{className:t.get("instruction"),html:(n[t.get("instruction")||"none"]||"#")+" "+t.get("name")+"<i>"+r+(e?" - "+e:"")+"</i>",on:{pointerenter:function(){this.dispatchEvent({type:"step:hover",hover:!1,index:o,feature:t})}.bind(this),pointerleave:function(){this.dispatchEvent({type:"step:hover",hover:!1,index:o,feature:t})}.bind(this)},click:function(){this.dispatchEvent({type:"step:select",index:o,feature:t})}.bind(this),parent:i})}.bind(this))},ol.control.RoutingGeoportail.prototype.handleResponse=function(t,e,o){if("ERROR"!==t.status){for(var i,n,r,s={type:"routing",features:[]},a=0,l=0,c=new ol.format.GeoJSON,h=0;r=t.portions[h];h++)for(var p,u=0;p=r.steps[u];u++){p.type="Feature",p.properties=p.attributes.name||p.attributes,p.properties.distance=p.distance,p.properties.duration=Math.round(60*p.duration),p.instruction&&(p.properties.instruction_type=p.instruction.type,p.properties.instruction_modifier=p.instruction.modifier),a+=p.distance,l+=p.duration,p.properties.distanceT=Math.round(100*a)/100,p.properties.durationT=Math.round(60*l),p.properties.name=p.properties.cpx_toponyme_route_nommee||p.properties.cpx_toponyme||p.properties.cpx_numero||p.properties.nom_1_droite||p.properties.nom_1_gauche||"";var g=p.geometry.coordinates[p.geometry.coordinates.length-1];n&&!ol.coordinate.equal(g,p.geometry.coordinates[p.geometry.coordinates.length-1])&&p.geometry.coordinates.unshift(n),n=p.geometry.coordinates[p.geometry.coordinates.length-1],i=c.readFeature(p,{featureProjection:this.getMap().getView().getProjection()}),s.features.push(i)}s.distance=parseFloat(t.distance),s.duration=parseFloat(t.duration)/60;var d=c.readGeometry(t.geometry,{featureProjection:this.getMap().getView().getProjection()});return s.feature=new ol.Feature({geometry:d,start:this._search[0].getTitle(e),end:this._search[0].getTitle(o),distance:s.distance,duration:s.duration}),this.dispatchEvent(s),this.path=s,s}this.dispatchEvent({type:"errror",status:"200",statusText:t.message})},ol.control.RoutingGeoportail.prototype.abort=function(){this._request&&(this._request.abort(),this._request=null,this.dispatchEvent({type:"abort"}))},ol.control.RoutingGeoportail.prototype.calculate=function(t){if(this.resultElement.innerHTML="",t){var e=[];t.forEach(function(t){e.push({x:t[0],y:t[1]})}),t=e}else{t=[];for(var o=0;o<this._search.length;o++)this._search[o].get("selection")&&t.push(this._search[o].get("selection"))}if(t.length<2)return!1;var i=t[0],n=t[t.length-1],r=this.requestData(t),s=encodeURI(this.get("url")),a="";for(var l in r)a+=a?"&":"?",r.hasOwnProperty(l)&&(a+=l+"="+r[l]);var c=this;return this.dispatchEvent({type:"routing:start"}),this.ajax(s+a,function(t){t.status>=200&&t.status<400?c.listRouting(c.handleResponse(JSON.parse(t.response),i,n)):this.dispatchEvent({type:"error",status:t.status,statusText:t.statusText})}.bind(this),function(t){this.dispatchEvent({type:"error",status:t.status,statusText:t.statusText})}.bind(this)),!0},ol.control.RoutingGeoportail.prototype.ajax=function(t,e,o){var i=this;this._request&&this._request.abort();var n=this._request=new XMLHttpRequest;n.open("GET",t,!0),n.timeout=this.get("timeout")||2e4,this._auth&&n.setRequestHeader("Authorization","Basic "+this._auth),this.element.classList.add("ol-searching"),n.onload=function(){i._request=null,i.element.classList.remove("ol-searching"),e.call(i,this)},n.ontimeout=function(){i._request=null,i.element.classList.remove("ol-searching"),o&&o.call(i,this)},n.onerror=function(){i._request=null,i.element.classList.remove("ol-searching"),o&&o.call(i,this)},n.send()},ol.control.Scale=function(t){t||(t={}),null==t.typing&&(t.typing=300);var e=document.createElement("DIV"),o=(t.className||"")+" ol-scale";t.target||(o+=" ol-unselectable ol-control"),this._input=document.createElement("INPUT"),this._input.value="-",e.setAttribute("class",o),!1===t.editable&&(this._input.readOnly=!0),e.appendChild(this._input),ol.control.Control.call(this,{element:e,target:t.target}),this._input.addEventListener("change",this.setScale.bind(this)),this.set("ppi",t.ppi||96)},ol.ext.inherits(ol.control.Scale,ol.control.Control),ol.control.Scale.prototype.setMap=function(t){this._listener&&ol.Observable.unByKey(this._listener),this._listener=null,ol.control.Control.prototype.setMap.call(this,t),t&&(this._listener=t.on("moveend",this.getScale.bind(this)))},ol.control.Scale.prototype.getScale=function(){var t=this.getMap();if(t){var e=ol.sphere.getMapScale(t,this.get("ppi"));return this._input.value=this.formatScale(e),e}},ol.control.Scale.prototype.formatScale=function(t){return"1 / "+(t=t>100?100*Math.round(t/100):Math.round(t)).toLocaleString()},ol.control.Scale.prototype.setScale=function(t){var e=this.getMap();e&&t&&(t.target&&(t=t.target.value),ol.sphere.setMapScale(e,t,this.get("ppi"))),this.getScale()},ol.control.SearchBAN=function(t){(t=t||{}).typing=t.typing||500,t.url=t.url||"https://api-adresse.data.gouv.fr/search/",t.className=t.className||"BAN",t.copy='<a href="https://adresse.data.gouv.fr/" target="new">&copy; BAN-data.gouv.fr</a>',ol.control.SearchPhoton.call(this,t),this.set("postcode",t.postcode),this.set("citycode",t.citycode),this.set("type",t.type)},ol.ext.inherits(ol.control.SearchBAN,ol.control.SearchPhoton),ol.control.SearchBAN.prototype.getTitle=function(t){return t.properties.label},ol.control.SearchBAN.prototype.select=function(t){var e=t.geometry.coordinates;try{e=ol.proj.transform(t.geometry.coordinates,"EPSG:4326",this.getMap().getView().getProjection())}catch(t){}this.dispatchEvent({type:"select",search:t,coordinate:e})},ol.control.SearchBAN.prototype.requestData=function(t){var e=ol.control.SearchPhoton.prototype.requestData.call(this,t);return e.postcode=this.get("postcode"),e.citycode=this.get("citycode"),e.type=this.get("type"),e},ol.control.SearchDFCI=function(t){t||(t={}),t.className=t.className||"dfci",t.placeholder=t.placeholder||"Code DFCI",ol.control.Search.call(this,t)},ol.ext.inherits(ol.control.SearchDFCI,ol.control.Search),ol.control.SearchDFCI.prototype.autocomplete=function(t){if((t=(t=t.toUpperCase()).replace(/[^0-9,^A-H,^K-N]/g,"")).length<2)return this.setInput(t),[];var e,o=this.getMap().getView().getProjection(),i=[],n=ol.coordinate.fromDFCI(t,o),r=Math.floor(t.length/2)-1,s=ol.coordinate.toDFCI(n,r,o);if(s=s.replace(/[^0-9,^A-H,^K-N]/g,""),!/NaN/.test(s)&&s){if(console.log("ok",s),this.setInput(s+t.substring(s.length,t.length)),i.push({coordinate:ol.coordinate.fromDFCI(s,o),name:s}),5===t.length)for(n=ol.coordinate.fromDFCI(t+0,o),s=ol.coordinate.toDFCI(n,r+1,o).substring(0,5),e=0;e<10;e++)i.push({coordinate:ol.coordinate.fromDFCI(s+e,o),name:s+e});if(2===r)for(e=0;e<6;e++)i.push({coordinate:ol.coordinate.fromDFCI(s+"."+e,o),name:s+"."+e})}return i},ol.control.SearchFeature=function(t){t||(t={}),t.className=t.className||"feature",ol.control.Search.call(this,t),"function"==typeof t.getSearchString&&(this.getSearchString=t.getSearchString),this.set("property",t.property||"name"),this.source_=t.source},ol.ext.inherits(ol.control.SearchFeature,ol.control.Search),ol.control.SearchFeature.prototype.restoreHistory=function(){this.set("history",[])},ol.control.SearchFeature.prototype.saveHistory=function(){try{localStorage.removeItem("ol@search-"+this._classname)}catch(t){console.warn("Failed to access localStorage...")}},ol.control.SearchFeature.prototype.getTitle=function(t){return t.get(this.get("property")||"name")},ol.control.SearchFeature.prototype.getSearchString=function(t){return this.getTitle(t)},ol.control.SearchFeature.prototype.getSource=function(){return this.source_},ol.control.SearchFeature.prototype.setSource=function(t){this.source_=t},ol.control.SearchFeature.prototype.autocomplete=function(t){var e=[];if(this.source_){t=t.replace(/^\*/,"");for(var o,i=new RegExp(t,"i"),n=this.source_.getFeatures(),r=this.get("maxItems"),s=0;o=n[s];s++){var a=this.getSearchString(o);if(void 0!==a&&i.test(a)&&(e.push(o),--r<=0))break}}return e},ol.control.SearchGPS=function(t){t||(t={}),t.className=(t.className||"")+" ol-searchgps",t.placeholder=t.placeholder||"lon,lat",ol.control.Search.call(this,t),this.geolocation=new ol.Geolocation({projection:"EPSG:4326",trackingOptions:{maximumAge:1e4,enableHighAccuracy:!0,timeout:6e5}}),ol.ext.element.create("BUTTON",{className:"ol-geoloc",title:"Locate with GPS",parent:this.element,click:function(){this.geolocation.setTracking(!0)}.bind(this)}),ol.ext.element.createSwitch({html:"decimal",after:"DMS",change:function(t){t.target.checked?this.element.classList.add("ol-dms"):this.element.classList.remove("ol-dms")}.bind(this),parent:this.element}),this._createForm();var e=this.element.querySelector("ul.autocomplete");this.element.appendChild(e)},ol.ext.inherits(ol.control.SearchGPS,ol.control.Search),ol.control.SearchGPS.prototype._createForm=function(){var t=function(t){if(t.target.classList.contains("ol-dms")&&(i.value=(n.value<0?-1:1)*Number(n.value)+Number(r.value)/60+Number(s.value)/3600,i.value=(n.value<0?-1:1)*Math.round(1e7*i.value)/1e7,a.value=(l.value<0?-1:1)*Number(l.value)+Number(c.value)/60+Number(h.value)/3600,a.value=(l.value<0?-1:1)*Math.round(1e7*a.value)/1e7),i.value||a.value?this._input.value=i.value+","+a.value:this._input.value="",!t.target.classList.contains("ol-dms")){var e=ol.coordinate.toStringHDMS([Number(i.value),Number(a.value)]),o=e.replace(/(N|S|E|W)/g,"").split("″");o[1]=o[1].trim().split(" "),n.value=(/W/.test(e)?-1:1)*parseInt(o[1][0]),r.value=parseInt(o[1][1]),s.value=parseInt(o[1][2]),o[0]=o[0].trim().split(" "),l.value=(/W/.test(e)?-1:1)*parseInt(o[0][0]),c.value=parseInt(o[0][1]),h.value=parseInt(o[0][2])}this.search()}.bind(this);function e(e,i){var n=ol.ext.element.create("INPUT",{className:e,type:"number",step:"any",lang:"en",parent:o,on:{"change keyup":t}});return i&&ol.ext.element.create("SPAN",{className:"ol-dms",html:i,parent:o}),n}var o=ol.ext.element.create("DIV",{className:"ol-longitude",parent:this.element});ol.ext.element.create("LABEL",{html:"Longitude",parent:o});var i=e("ol-decimal"),n=e("ol-dms","°"),r=e("ol-dms","'"),s=e("ol-dms",'"');o=ol.ext.element.create("DIV",{className:"ol-latitude",parent:this.element}),ol.ext.element.create("LABEL",{html:"Latitude",parent:o});var a=e("ol-decimal"),l=e("ol-dms","°"),c=e("ol-dms","'"),h=e("ol-dms",'"');this.button&&this.button.addEventListener("click",function(){i.focus()}),this.on("select",function(t){i.value=t.search.gps[0],a.value=t.search.gps[1]}.bind(this)),this.geolocation.on("change",function(){this.geolocation.setTracking(!1);var t=this.geolocation.getPosition();i.value=t[0],a.value=t[1],this._triggerCustomEvent("keyup",i)}.bind(this))},ol.control.SearchGPS.prototype.autocomplete=function(t){var e=[],o=t.split(",");o[0]=Number(o[0]),o[1]=Number(o[1]),(t=ol.coordinate.toStringHDMS(o))&&(t=t.replace(/(°|′|″) /g,"$1"));var i=ol.proj.transform([o[0],o[1]],"EPSG:4326",this.getMap().getView().getProjection());return e.push({gps:o,coordinate:i,name:t}),e},ol.control.SearchGeoportailParcelle=function(t){var e=this;t.type="Commune",t.className=(t.className?t.className:"")+" IGNF-parcelle ol-collapsed-list ol-collapsed-num",t.inputLabel="Commune",t.noCollapse=!0,t.placeholder=t.placeholder||"Choisissez une commune...",ol.control.SearchGeoportail.call(this,t),this.set("copy",null);var o=this.element,i=document.createElement("DIV");o.appendChild(i);var n,r=document.createElement("LABEL");r.innerText="Préfixe",i.appendChild(r),(r=document.createElement("LABEL")).innerText="Section",i.appendChild(r),(r=document.createElement("LABEL")).innerText="Numéro",i.appendChild(r),i.appendChild(document.createElement("BR")),this._inputParcelle={prefix:document.createElement("INPUT"),section:document.createElement("INPUT"),numero:document.createElement("INPUT")},this._inputParcelle.prefix.setAttribute("maxlength",3),this._inputParcelle.section.setAttribute("maxlength",2),this._inputParcelle.numero.setAttribute("maxlength",4);var s=function(){n&&clearTimeout(n),n=setTimeout(function(){e.autocompleteParcelle()},t.typing||0)};for(var a in this._inputParcelle)i.appendChild(this._inputParcelle[a]),this._inputParcelle[a].addEventListener("keyup",s),this._inputParcelle[a].addEventListener("blur",function(){n=setTimeout(function(){o.classList.add("ol-collapsed-num")},200)}),this._inputParcelle[a].addEventListener("focus",function(){clearTimeout(n),o.classList.remove("ol-collapsed-num")});this.activateParcelle(!1);var l=document.createElement("DIV");l.className="autocomplete-parcelle",o.appendChild(l);var c=document.createElement("UL");c.classList.add("autocomplete-parcelle"),l.appendChild(c),(c=document.createElement("UL")).classList.add("autocomplete-page"),l.appendChild(c),this._input.addEventListener("blur",function(){setTimeout(function(){o.classList.add("ol-collapsed-list")},200)}),this._input.addEventListener("focus",function(){o.classList.remove("ol-collapsed-list"),e._listParcelle([]),e._commune&&(e._commune=null,e._input.value="",e.drawList_()),e.activateParcelle(!1)}),this.on("select",this.selectCommune.bind(this)),this.set("pageSize",t.pageSize||5)},ol.ext.inherits(ol.control.SearchGeoportailParcelle,ol.control.SearchGeoportail),ol.control.SearchGeoportailParcelle.prototype.selectCommune=function(t){this._commune=t.search.insee,this._input.value=t.search.insee+" - "+t.search.fulltext,this.activateParcelle(!0),this._inputParcelle.numero.focus(),this.autocompleteParcelle()},ol.control.SearchGeoportailParcelle.prototype.setParcelle=function(t,e){this._inputParcelle.prefix.value=(t.Commune||"")+(t.CommuneAbsorbee||""),this._inputParcelle.section.value=t.Section||"",this._inputParcelle.numero.value=t.Numero||"",e&&this._triggerCustomEvent("keyup",this._inputParcelle.prefix)},ol.control.SearchGeoportailParcelle.prototype.activateParcelle=function(t){for(var e in this._inputParcelle)this._inputParcelle[e].readOnly=!t;t?this._inputParcelle.section.parentElement.classList.add("ol-active"):this._inputParcelle.section.parentElement.classList.remove("ol-active")},ol.control.SearchGeoportailParcelle.prototype.autocompleteParcelle=function(){function t(t,e,o){if(!t)return t;for(o=o||"0";t.length<e;)t=o+t;return t.replace(/\*/g,"_")}var e=this._commune,o=t(this._inputParcelle.prefix.value,3);"000"===o&&(o="___");var i=t(this._inputParcelle.section.value,2),n=t(this._inputParcelle.numero.value,4,"0"),r=e+(o||"___")+(i||"__")+(n||(i?"____":"0001"));this.searchParcelle(r,function(t){this._listParcelle(t)}.bind(this),function(){console.log("oops")})},ol.control.SearchGeoportailParcelle.prototype.searchParcelle=function(t,e){var o='<?xml version="1.0" encoding="UTF-8"?><XLS xmlns:xls="http://www.opengis.net/xls" xmlns:gml="http://www.opengis.net/gml" xmlns="http://www.opengis.net/xls" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.2" xsi:schemaLocation="http://www.opengis.net/xls http://schemas.opengis.net/ols/1.2/olsAll.xsd"><RequestHeader/><Request requestID="1" version="1.2" methodName="LocationUtilityService"><GeocodeRequest returnFreeForm="false"><Address countryCode="CadastralParcel"><freeFormAddress>'+t+"+</freeFormAddress></Address></GeocodeRequest></Request></XLS>";this.ajax(this.get("url").replace("ols/apis/completion","geoportail/ols"),{xls:o},function(t){for(var o,i=(new DOMParser).parseFromString(t,"text/xml").getElementsByTagName("GeocodedAddress"),n=[],r=0;o=i[r];r++){for(var s,a=(o.getElementsByTagName("gml:pos")[0]||o.getElementsByTagName("pos")[0]).childNodes[0].nodeValue.split(" "),l=o.getElementsByTagName("Place"),c={lon:Number(a[1]),lat:Number(a[0])},h=0;s=l[h];h++)c[s.attributes.type.value]=s.childNodes[0].nodeValue;n.push(c)}e(n)},{dataType:"XML"})},ol.control.SearchGeoportailParcelle.prototype._listParcelle=function(t){var e=this,o=this.element.querySelector("ul.autocomplete-parcelle");o.innerHTML="";var i=this.element.querySelector("ul.autocomplete-page");function n(t){var e,n=o.children,r="ol-list-"+t;for(e=0;e<n.length;e++)n[e].style.display=n[e].className===r?"":"none";for(n=i.children,e=0;e<n.length;e++)n[e].className=n[e].innerText==t?"selected":"";i.style.display=n.length>1?"":"none"}i.innerHTML="",this._listParc=[],t.sort(function(t,e){var o=t.INSEE+t.CommuneAbsorbee+t.Section+t.Numero,i=e.INSEE+e.CommuneAbsorbee+e.Section+e.Numero;return o===i?0:o<i?-1:1});for(var r,s=this.get("pageSize"),a=0;r=t[a];a++){var l=document.createElement("LI");l.setAttribute("data-search",a),s>0&&l.classList.add("ol-list-"+Math.floor(a/s)),this._listParc.push(r),l.addEventListener("click",function(t){e._handleParcelle(e._listParc[t.currentTarget.getAttribute("data-search")])}),l.innerHTML=r.INSEE+r.CommuneAbsorbee+r.Section+r.Numero,o.appendChild(l),s>0&&!(a%s)&&((l=document.createElement("LI")).innerText=Math.floor(a/s),l.addEventListener("click",function(t){n(t.currentTarget.innerText)}),i.appendChild(l))}s>0&&n(0)},ol.control.SearchGeoportailParcelle.prototype._handleParcelle=function(t){this.dispatchEvent({type:"parcelle",search:t,coordinate:ol.proj.fromLonLat([t.lon,t.lat],this.getMap().getView().getProjection())})},ol.control.SearchNominatim=function(t){(t=t||{}).className=t.className||"nominatim",t.typing=t.typing||500,t.url=t.url||"https://nominatim.openstreetmap.org/search",t.copy='<a href="http://www.openstreetmap.org/copyright" target="new">&copy; OpenStreetMap contributors</a>',ol.control.SearchJSON.call(this,t),this.set("polygon",t.polygon),this.set("viewbox",t.viewbox),this.set("bounded",t.bounded)},ol.ext.inherits(ol.control.SearchNominatim,ol.control.SearchJSON),ol.control.SearchNominatim.prototype.getTitle=function(t){var e=[];t.class&&e.push(t.class),t.type&&e.push(t.type);var o=t.display_name+(e.length?"<i>"+e.join(" - ")+"</i>":"");return t.icon&&(o="<img src='"+t.icon+"' />"+o),o},ol.control.SearchNominatim.prototype.requestData=function(t){var e={format:"json",addressdetails:1,q:t,polygon_geojson:this.get("polygon")?1:0,bounded:this.get("bounded")?1:0,limit:this.get("maxItems")};return this.get("viewbox")&&(e.viewbox=this.get("viewbox")),e},ol.control.SearchNominatim.prototype.select=function(t){var e=[Number(t.lon),Number(t.lat)];try{e=ol.proj.transform(e,"EPSG:4326",this.getMap().getView().getProjection())}catch(t){}this.dispatchEvent({type:"select",search:t,coordinate:e})},ol.control.SearchJSON.prototype.handleResponse=function(t){return t.results||t},ol.control.SearchNominatim.prototype.reverseGeocode=function(t,e){var o=ol.proj.transform(t,this.getMap().getView().getProjection(),"EPSG:4326");this.ajax(this.get("url").replace("search","reverse"),{lon:o[0],lat:o[1],format:"json"},function(t){e?e.call(this,[t]):t&&!t.error&&this._handleSelect(t,!0)}.bind(this))},ol.control.SearchWikipedia=function(t){(t=t||{}).lang=t.lang||"en",t.className=t.className||"ol-search-wikipedia",t.url="https://"+t.lang+".wikipedia.org/w/api.php",t.placeholder=t.placeholder||"search string, File:filename",t.copy='<a href="https://'+t.lang+'.wikipedia.org/" target="new">Wikipedia&reg; - CC-By-SA</a>',ol.control.SearchJSON.call(this,t),this.set("lang",t.lang)},ol.ext.inherits(ol.control.SearchWikipedia,ol.control.SearchJSON),ol.control.SearchWikipedia.prototype.getTitle=function(t){return ol.ext.element.create("DIV",{html:t.title,title:t.desc})},ol.control.SearchWikipedia.prototype.setLang=function(t){this.set("lang",t),this.set("url","https://"+t+".wikipedia.org/w/api.php")},ol.control.SearchWikipedia.prototype.requestData=function(t){return{action:"opensearch",search:t,lang:this.get("lang"),format:"json",origin:"*",limit:this.get("maxItems")}},ol.control.SearchWikipedia.prototype.handleResponse=function(t){for(var e=[],o=0;o<t[1].length;o++)e.push({title:t[1][o],desc:t[2][o],uri:t[3][o]});return e},ol.control.SearchWikipedia.prototype.select=function(t){var e=decodeURIComponent(t.uri.split("/").pop()).replace(/'/,"%27");ol.ext.Ajax.get({url:t.uri.split("wiki/")[0]+"w/api.php",data:{action:"query",prop:"pageimages|coordinates|extracts",exintro:1,explaintext:1,piprop:"original",origin:"*",format:"json",redirects:1,titles:e},options:{encode:!1},success:function(e){var o=e.query.pages[Object.keys(e.query.pages).pop()];console.log(o);var i,n={title:t.title,desc:o.extract||t.desc,url:t.uri,img:o.original?o.original.source:void 0,pageid:o.pageid};o.coordinates&&(n.lon=o.coordinates[0].lon,n.lat=o.coordinates[0].lat,i=[n.lon,n.lat],i=ol.proj.transform(i,"EPSG:4326",this.getMap().getView().getProjection())),this.dispatchEvent({type:"select",search:n,coordinate:i})}.bind(this)})},ol.control.Select=function(t){var e=this;t||(t={});var o=t.content=document.createElement("div");this._ul=ol.ext.element.create("UL",{parent:o}),this._all=ol.ext.element.create("INPUT",{type:"checkbox",checked:!0});var i=ol.ext.element.create("LABEL",{html:this._all,parent:o});ol.ext.element.appendText(i,t.allLabel||"match all"),this._useCase=ol.ext.element.create("INPUT",{type:"checkbox"});var n=ol.ext.element.create("LABEL",{html:this._useCase,parent:o});ol.ext.element.appendText(n,t.caseLabel||"case sensitive"),ol.control.SelectBase.call(this,t),ol.ext.element.create("BUTTON",{className:"ol-append",html:t.addLabel||"add rule",click:function(){e.addCondition()},parent:o}),this._conditions=[],this.set("attrPlaceHolder",t.attrPlaceHolder||"attribute"),this.set("valuePlaceHolder",t.valuePlaceHolder||"value"),this.addCondition()},ol.ext.inherits(ol.control.Select,ol.control.SelectBase),ol.control.Select.prototype.addCondition=function(t){t=t||{},this._conditions.push({attr:t.attr||"",op:t.op||"=",val:t.val||""}),this._drawlist()},ol.control.Select.prototype.getConditions=function(){return{usecase:this._useCase.checked,all:this._all.checked,conditions:this._conditions}},ol.control.Select.prototype.setConditions=function(t){this._useCase.checked=t.usecase,this._all.checked=t.all,this._conditions=t.conditions,this._drawlist()},ol.control.Select.prototype.getConditionsString=function(t){for(var e,o="",i=0;e=t.conditions[i];i++)e.attr&&(o+=(o?t.all?" AND ":" OR ":"")+e.attr+this.operationsList[e.op]+e.val);return o},ol.control.Select.prototype._drawlist=function(){this._ul.innerHTML="";for(var t=0;t<this._conditions.length;t++)this._ul.appendChild(this._getLiCondition(t))},ol.control.Select.prototype._autocomplete=function(t,e){e.classList.remove("ol-hidden"),e.innerHTML="";for(var o,i={},n=this.get("source"),r=0;o=n[r];r++)for(var s,a=o.getFeatures(),l=0;(s=a[l])&&(Object.assign(i,s.getProperties()),!(l>100));l++);var c=new RegExp(t,"i");for(var h in i)if("geometry"!==h&&c.test(h)){var p=document.createElement("li");p.textContent=h,p.addEventListener("click",function(){e.previousElementSibling.value=this.textContent;var t=document.createEvent("HTMLEvents");t.initEvent("change",!0,!1),e.previousElementSibling.dispatchEvent(t),e.classList.add("ol-hidden")}),e.appendChild(p)}},ol.control.Select.prototype._getLiCondition=function(t){var e=this,o=document.createElement("li"),i=document.createElement("div");i.classList.add("ol-autocomplete"),i.addEventListener("mouseleave",function(){this.querySelector("ul").classList.add("ol-hidden")}),o.appendChild(i);var n=document.createElement("input");n.classList.add("ol-attr"),n.setAttribute("type","search"),n.setAttribute("placeholder",this.get("attrPlaceHolder")),n.addEventListener("keyup",function(){e._autocomplete(this.value,this.nextElementSibling)}),n.addEventListener("focusout",function(){setTimeout(function(){i.querySelector("ul").classList.add("ol-hidden")},300)}),n.addEventListener("click",function(){setTimeout(function(){e._autocomplete(this.value,this.nextElementSibling),this.nextElementSibling.classList.remove("ol-hidden")}.bind(this))}),n.addEventListener("change",function(){e._conditions[t].attr=this.value}),n.value=e._conditions[t].attr,i.appendChild(n);var r=document.createElement("ul");r.classList.add("ol-hidden"),i.appendChild(r);var s=document.createElement("select");for(var a in o.appendChild(s),this.operationsList){var l=document.createElement("option");l.value=a,l.textContent=this.operationsList[a],s.appendChild(l)}s.value=e._conditions[t].op,s.addEventListener("change",function(){e._conditions[t].op=this.value});var c=document.createElement("input");if(c.setAttribute("type","text"),c.setAttribute("placeholder",this.get("valuePlaceHolder")),c.addEventListener("change",function(){e._conditions[t].val=this.value}),c.value=e._conditions[t].val,o.appendChild(c),this._conditions.length>1){var h=document.createElement("div");h.classList.add("ol-delete"),h.addEventListener("click",function(){e.removeCondition(t)}),o.appendChild(h)}return o},ol.control.Select.prototype.removeCondition=function(t){this._conditions.splice(t,1),this._drawlist()},ol.control.Select.prototype.doSelect=function(t){return(t=t||{}).useCase=t.useCase||this._useCase.checked,t.matchAll=t.matchAll||this._all.checked,t.conditions=t.conditions||this._conditions,ol.control.SelectBase.prototype.doSelect.call(this,t)},ol.control.SelectCheck=function(t){t||(t={});var e=t.content=ol.ext.element.create("DIV");t.label&&ol.ext.element.create("LABEL",{html:t.label,parent:e}),this._input=ol.ext.element.create("DIV",{parent:e}),t.className=t.className||"ol-select-check",ol.control.SelectBase.call(this,t),this.set("property",t.property||"name"),this.set("max",t.max||1e4),this.set("defaultLabel",t.defaultLabel),this.set("type",t.type),this._selectAll=t.selectAll,this._onchoice=t.onchoice,t.values?this.setValues({values:t.values,sort:!0}):this.setValues()},ol.ext.inherits(ol.control.SelectCheck,ol.control.SelectBase),ol.control.SelectCheck.prototype.setMap=function(t){ol.control.SelectBase.prototype.setMap.call(this,t),this.setValues()},ol.control.SelectCheck.prototype.doSelect=function(t){console.log("select"),t=t||{};var e=[];return this._checks.forEach(function(t){t.checked&&t.value&&e.push({attr:this.get("property"),op:"=",val:t.value})}.bind(this)),e.length?ol.control.SelectBase.prototype.doSelect.call(this,{features:t.features,conditions:e}):ol.control.SelectBase.prototype.doSelect.call(this,{features:t.features,matchAll:this._selectAll})},ol.control.SelectCheck.prototype.setValues=function(t){var e,o;if((t=t||{}).values)t.values instanceof Array?(o={},t.values.forEach(function(t){o[t]=t})):o=t.values;else{o={};var i=this.get("property");this.getSources().forEach(function(t){for(var e=t.getFeatures(),n=Math.min(e.length,this.get("max")),r=0;r<n;r++){var s=e[r].get(i);s&&(o[s]=s)}}.bind(this))}if(Object.keys(o).length){t.sort?(e={},Object.keys(o).sort().forEach(function(t){e[t]=o[t]})):e=o,ol.ext.element.setHTML(this._input,""),this._checks=[];var n="radio_"+(new Date).getTime(),r=function(t,e){this._checks.push(ol.ext.element.createCheck({after:e,name:n,val:t,type:this.get("type"),change:function(){this._onchoice?this._onchoice():this.doSelect()}.bind(this),parent:this._input}))}.bind(this);for(var s in this.get("defaultLabel")&&"radio"===this.get("type")&&r("",this.get("defaultLabel")),e)r(s,e[s])}},ol.control.SelectCondition=function(t){t||(t={});var e=t.content=ol.ext.element.create("DIV");this._check=ol.ext.element.createSwitch({after:t.label||"condition",change:function(){this._onchoice?this._onchoice():this.doSelect()}.bind(this),parent:e}),this._input=ol.ext.element.create("DIV",{parent:e}),t.className=t.className||"ol-select-condition",ol.control.SelectBase.call(this,t),this.setCondition(t.condition),this._selectAll=t.selectAll,this._onchoice=t.onchoice},ol.ext.inherits(ol.control.SelectCondition,ol.control.SelectBase),ol.control.SelectCondition.prototype.setCondition=function(t){this._conditions=t?t instanceof Array?t:[t]:[]},ol.control.SelectCondition.prototype.addCondition=function(t){this._conditions.push(t)},ol.control.SelectCondition.prototype.doSelect=function(t){t=t||{};var e=this._conditions;return this._check.checked?ol.control.SelectBase.prototype.doSelect.call(this,{features:t.features,conditions:e}):ol.control.SelectBase.prototype.doSelect.call(this,{features:t.features,matchAll:this._selectAll})},ol.control.SelectFulltext=function(t){t||(t={});var e=t.content=ol.ext.element.create("DIV");t.label&&ol.ext.element.create("LABEL",{html:t.label,parent:e}),this._input=ol.ext.element.create("INPUT",{placeHolder:t.placeHolder||"search...",change:function(){this._onchoice&&this._onchoice()}.bind(this),parent:e}),ol.control.SelectBase.call(this,t),this._onchoice=t.onchoice,this.set("property",t.property||"name")},ol.ext.inherits(ol.control.SelectFulltext,ol.control.SelectBase),ol.control.SelectFulltext.prototype.doSelect=function(t){return t=t||{},ol.control.SelectBase.prototype.doSelect.call(this,{features:t.features,useCase:!1,conditions:[{attr:this.get("property"),op:"contain",val:this._input.value}]})},ol.control.SelectMulti=function(t){t||(t={}),t.content=ol.ext.element.create("DIV"),this._container=ol.ext.element.create("UL",{parent:t.content}),t.className=t.className||"ol-select-multi",ol.control.SelectBase.call(this,t),this._controls=[],t.controls.forEach(this.addControl.bind(this))},ol.ext.inherits(ol.control.SelectMulti,ol.control.SelectBase),ol.control.SelectMulti.prototype.setMap=function(t){this.getMap()&&this._controls.forEach(function(t){this.getMap().remveControl(t)}.bind(this)),ol.control.SelectBase.prototype.setMap.call(this,t),this.getMap()&&this._controls.forEach(function(t){this.getMap().addControl(t)}.bind(this))},ol.control.SelectMulti.prototype.addControl=function(t){t instanceof ol.control.SelectBase&&(this._controls.push(t),t.setTarget(ol.ext.element.create("LI",{parent:this._container})),t._selectAll=!0,t._onchoice=this.doSelect.bind(this),this.getMap()&&this.getMap().addControl(t))},ol.control.SelectMulti.prototype.getControls=function(){return this._controls},ol.control.SelectMulti.prototype.doSelect=function(){var t=[];return this.getSources().forEach(function(e){t=t.concat(e.getFeatures())}),this._controls.forEach(function(e){t=e.doSelect({features:t})}),this.dispatchEvent({type:"select",features:t}),t},ol.control.SelectPopup=function(t){t||(t={});var e=t.content=ol.ext.element.create("DIV");t.label&&ol.ext.element.create("LABEL",{html:t.label,parent:e}),this._input=ol.ext.element.create("SELECT",{on:{change:function(){this._onchoice?this._onchoice():this.doSelect()}.bind(this)},parent:e}),t.className=t.className||"ol-select-popup",ol.control.SelectBase.call(this,t),this.set("property",t.property||"name"),this.set("max",t.max||1e4),this.set("defaultLabel",t.defaultLabel),this._selectAll=t.selectAll,this._onchoice=t.onchoice,this.setValues()},ol.ext.inherits(ol.control.SelectPopup,ol.control.SelectBase),ol.control.SelectPopup.prototype.setMap=function(t){ol.control.SelectBase.prototype.setMap.call(this,t),this.setValues()},ol.control.SelectPopup.prototype.doSelect=function(t){return t=t||{},this._input.value?ol.control.SelectBase.prototype.doSelect.call(this,{features:t.features,conditions:[{attr:this.get("property"),op:"=",val:this._input.value}]}):ol.control.SelectBase.prototype.doSelect.call(this,{features:t.features,matchAll:this._selectAll})},ol.control.SelectPopup.prototype.setValues=function(t){var e,o;if((t=t||{}).values)t.values instanceof Array?(o={},t.values.forEach(function(t){o[t]=t})):o=t.values;else{o={};var i=this.get("property");this.getSources().forEach(function(t){for(var e=t.getFeatures(),n=Math.min(e.length,this.get("max")),r=0;r<n;r++){var s=e[r].get(i);s&&(o[s]=s)}}.bind(this))}for(var n in t.sort?(e={},Object.keys(o).sort().forEach(function(t){e[t]=o[t]})):e=o,ol.ext.element.setHTML(this._input,""),ol.ext.element.create("OPTION",{className:"ol-default",html:this.get("defaultLabel")||"",value:"",parent:this._input}),e)ol.ext.element.create("OPTION",{html:e[n],value:n,parent:this._input})},ol.control.Status=function(t){t=t||{};var e=ol.ext.element.create("DIV",{className:(t.className||"")+" ol-status"+(t.target?"":" ol-unselectable ol-control")});ol.control.Control.call(this,{element:e,target:t.target}),this.setVisible(!1!==t.visible),t.position&&this.setPosition(t.position),this.status(t.status||"")},ol.ext.inherits(ol.control.Status,ol.control.Control),ol.control.Status.prototype.setVisible=function(t){t?this.element.classList.add("ol-visible"):this.element.classList.remove("ol-visible")},ol.control.Status.prototype.status=function(t){var e=t||"";if(e){if(ol.ext.element.show(this.element),e instanceof Element||"string"==typeof e)ol.ext.element.setHTML(this.element,e);else for(var o in e="",t)e+="<label>"+o+":</label> "+t[o]+"<br/>";ol.ext.element.setHTML(this.element,e)}else ol.ext.element.hide(this.element)},ol.control.Status.prototype.setPosition=function(t){this.element.classList.remove("ol-left"),this.element.classList.remove("ol-right"),this.element.classList.remove("ol-bottom"),this.element.classList.remove("ol-center"),/^left$|^right$|^bottom$|^center$/.test(t)&&this.element.classList.add("ol-"+t)},ol.control.Status.prototype.show=function(t){!1===t?ol.ext.element.hide(this.element):ol.ext.element.show(this.element)},ol.control.Status.prototype.hide=function(){ol.ext.element.hide(this.element)},ol.control.Status.prototype.toggle=function(){ol.ext.element.toggle(this.element)},ol.control.Status.prototype.isShown=function(){return"none"===this.element.style.display},ol.control.Storymap=function(t){t.target&&(t.html?t.html instanceof Element&&(t.html=t.html.innerHTML):t.html=t.target.innerHTML,t.target.innerHTML="");var e=ol.ext.element.create("DIV",{className:(t.className||"")+" ol-storymap"+(t.target?"":" ol-unselectable ol-control")});this.content=ol.ext.element.create("DIV",{parent:e}),ol.control.Control.call(this,{element:e,target:t.target}),ol.ext.element.scrollDiv(this.content,{vertical:!0,mousewheel:!0,minibar:t.minibar}),this.setStory(t.html)},ol.ext.inherits(ol.control.Storymap,ol.control.Control),ol.control.Storymap.prototype.setChapter=function(t){for(var e,o=this.content.querySelectorAll(".chapter"),i=0;e=o[i];i++)e.getAttribute("name")===t&&(this.content.scrollTop=e.offsetTop-30)},ol.control.Storymap.prototype.setStory=function(t){t instanceof Element?(this.content.innerHTML="",this.content.appendChild(t)):this.content.innerHTML=t,this.content.querySelectorAll(".chapter").forEach(function(t){t.addEventListener("click",function(e){t.classList.contains("ol-select")?"IMG"===e.target.tagName&&e.target.dataset.title&&this.dispatchEvent({coordinate:this.getMap()?this.getMap().getCoordinateFromPixel([e.layerX,e.layerY]):null,type:"clickimage",img:e.target,title:e.target.dataset.title,element:t,name:t.getAttribute("name"),originalEvent:e}):(this.content.scrollTop=t.offsetTop-30,e.preventDefault())}.bind(this))}.bind(this));var e=this.content.querySelectorAll(".ol-scroll-next");e.forEach(function(t){t.addEventListener("click",function(e){if(t.parentElement.classList.contains("ol-select")){for(var o,i=this.content.querySelectorAll(".chapter"),n=t.offsetTop,r=0;o=i[r];r++)if(o.offsetTop>n){n=o.offsetTop;break}this.content.scrollTop=n-30,e.stopPropagation(),e.preventDefault()}}.bind(this))}.bind(this)),(e=this.content.querySelectorAll(".ol-scroll-top")).forEach(function(t){t.addEventListener("click",function(t){this.content.scrollTop=0,t.stopPropagation(),t.preventDefault()}.bind(this))}.bind(this));var o=function(t){var e=[parseFloat(t.getAttribute("data-lon")),parseFloat(t.getAttribute("data-lat"))],o=ol.proj.fromLonLat(e,this.getMap().getView().getProjection()),i=parseFloat(t.getAttribute("data-zoom"));return{type:"scrollto",element:t,name:t.getAttribute("name"),coordinate:o,lon:e,zoom:i}}.bind(this),i=this.content.querySelectorAll(".chapter")[0];setTimeout(function(){i.classList.add("ol-select"),this.dispatchEvent(o(i))}.bind(this)),this.content.addEventListener("scroll",function(){var t,e=this.content.querySelectorAll(".chapter"),n=ol.ext.element.getStyle(this.content,"height");if(this.content.scrollTop)for(var r,s=0;r=e[s];s++){if(r.offsetTop-this.content.scrollTop>n/3)break;t=r}else t=e[0];if(t&&t!==i){i&&i.classList.remove("ol-select"),(i=t).classList.add("ol-select");var a=o(i),l=this.getMap().getView();switch(l.cancelAnimations(),i.getAttribute("data-animation")){case"flyto":l.flyTo({center:a.coordinate,zoomAt:Math.min(l.getZoom(),a.zoom)-1,zoom:a.zoom})}this.dispatchEvent(a)}}.bind(this))},ol.control.Swipe=function(t){t=t||{};var e=document.createElement("button"),o=document.createElement("div");o.className=(t.className||"ol-swipe")+" ol-unselectable ol-control",o.appendChild(e),o.addEventListener("mousedown",this.move.bind(this)),o.addEventListener("touchstart",this.move.bind(this)),ol.control.Control.call(this,{element:o}),this.precomposeRight_=this.precomposeRight.bind(this),this.precomposeLeft_=this.precomposeLeft.bind(this),this.postcompose_=this.postcompose.bind(this),this.layers=[],t.layers&&this.addLayer(t.layers,!1),t.rightLayers&&this.addLayer(t.rightLayers,!0),this.on("propertychange",function(t){if(this.getMap())try{this.getMap().renderSync()}catch(t){}"horizontal"===this.get("orientation")?(this.element.style.top=100*this.get("position")+"%",this.element.style.left=""):("vertical"!==this.get("orientation")&&this.set("orientation","vertical"),this.element.style.left=100*this.get("position")+"%",this.element.style.top=""),"orientation"===t.key&&(this.element.classList.remove("horizontal","vertical"),this.element.classList.add(this.get("orientation"))),this.isMoving||this.layers.forEach(function(t){t.layer.getImageRatio&&t.layer.changed()})}.bind(this)),this.set("position",t.position||.5),this.set("orientation",t.orientation||"vertical")},ol.ext.inherits(ol.control.Swipe,ol.control.Control),ol.control.Swipe.prototype.setMap=function(t){var e,o;if(this.getMap()){for(e=0;e<this.layers.length;e++)(o=this.layers[e]).right?o.layer.un(["precompose","prerender"],this.precomposeRight_):o.layer.un(["precompose","prerender"],this.precomposeLeft_),o.layer.un(["postcompose","postrender"],this.postcompose_);try{this.getMap().renderSync()}catch(t){}}if(ol.control.Control.prototype.setMap.call(this,t),t){for(this._listener=[],e=0;e<this.layers.length;e++)(o=this.layers[e]).right?o.layer.on(["precompose","prerender"],this.precomposeRight_):o.layer.on(["precompose","prerender"],this.precomposeLeft_),o.layer.on(["postcompose","postrender"],this.postcompose_);try{t.renderSync()}catch(t){}}},ol.control.Swipe.prototype.isLayer_=function(t){for(var e=0;e<this.layers.length;e++)if(this.layers[e].layer===t)return e;return-1},ol.control.Swipe.prototype.addLayer=function(t,e){t instanceof Array||(t=[t]);for(var o=0;o<t.length;o++){var i=t[o];if(this.isLayer_(i)<0&&(this.layers.push({layer:i,right:e}),this.getMap())){e?i.on(["precompose","prerender"],this.precomposeRight_):i.on(["precompose","prerender"],this.precomposeLeft_),i.on(["postcompose","postrender"],this.postcompose_);try{this.getMap().renderSync()}catch(t){}}}},ol.control.Swipe.prototype.removeLayers=function(){var t=[];this.layers.forEach(function(e){t.push(e.layer)}),this.removeLayer(t)},ol.control.Swipe.prototype.removeLayer=function(t){t instanceof Array||(t=[t]);for(var e=0;e<t.length;e++){var o=this.isLayer_(t[e]);o>=0&&this.getMap()&&(this.layers[o].right?t[e].un(["precompose","prerender"],this.precomposeRight_):t[e].un(["precompose","prerender"],this.precomposeLeft_),t[e].un(["postcompose","postrender"],this.postcompose_),this.layers.splice(o,1))}if(this.getMap())try{this.getMap().renderSync()}catch(t){}},ol.control.Swipe.prototype.getRectangle=function(){var t;return"vertical"===this.get("orientation")?[0,0,(t=this.getMap().getSize())[0]*this.get("position"),t[1]]:[0,0,(t=this.getMap().getSize())[0],t[1]*this.get("position")]},ol.control.Swipe.prototype.move=function(t){var e,o=this;switch(this._movefn||(this._movefn=this.move.bind(this)),t.type){case"touchcancel":case"touchend":case"mouseup":o.isMoving=!1,["mouseup","mousemove","touchend","touchcancel","touchmove"].forEach(function(t){document.removeEventListener(t,o._movefn)}),this.layers.forEach(function(t){t.layer.getImageRatio&&t.layer.changed()});break;case"mousedown":case"touchstart":o.isMoving=!0,["mouseup","mousemove","touchend","touchcancel","touchmove"].forEach(function(t){document.addEventListener(t,o._movefn)});case"mousemove":case"touchmove":if(o.isMoving)if("vertical"===o.get("orientation")){var i=t.pageX||t.touches&&t.touches.length&&t.touches[0].pageX||t.changedTouches&&t.changedTouches.length&&t.changedTouches[0].pageX;if(!i)break;i-=o.getMap().getTargetElement().getBoundingClientRect().left+window.pageXOffset-document.documentElement.clientLeft;var n=(e=o.getMap().getSize()[0])-Math.min(Math.max(0,e-i),e);e=n/e,o.set("position",e),o.dispatchEvent({type:"moving",size:[n,o.getMap().getSize()[1]],position:[e,0]})}else{var r=t.pageY||t.touches&&t.touches.length&&t.touches[0].pageY||t.changedTouches&&t.changedTouches.length&&t.changedTouches[0].pageY;if(!r)break;r-=o.getMap().getTargetElement().getBoundingClientRect().top+window.pageYOffset-document.documentElement.clientTop;var s=(e=o.getMap().getSize()[1])-Math.min(Math.max(0,e-r),e);e=s/e,o.set("position",e),o.dispatchEvent({type:"moving",size:[o.getMap().getSize()[0],s],position:[0,e]})}}},ol.control.Swipe.prototype._transformPt=function(t,e){var o=t.inversePixelTransform,i=e[0],n=e[1];return e[0]=o[0]*i+o[2]*n+o[4],e[1]=o[1]*i+o[3]*n+o[5],e},ol.control.Swipe.prototype._drawRect=function(t,e){var o=t.inversePixelTransform;if(o){var i=[[e[0][0],e[0][1]],[e[0][0],e[1][1]],[e[1][0],e[1][1]],[e[1][0],e[0][1]],[e[0][0],e[0][1]]];if(t.context.save(),t.target.getImageRatio){var n=-Math.atan2(t.frameState.pixelToCoordinateTransform[1],t.frameState.pixelToCoordinateTransform[0]);t.context.translate(t.frameState.size[0]/2,t.frameState.size[1]/2),t.context.rotate(n),t.context.translate(-t.frameState.size[0]/2,-t.frameState.size[1]/2)}i.forEach(function(e,i){e=[e[0]*o[0]-e[1]*o[1]+o[4],-e[0]*o[2]+e[1]*o[3]+o[5]],i?t.context.lineTo(e[0],e[1]):t.context.moveTo(e[0],e[1])}),t.context.restore()}else{var r=t.frameState.pixelRatio;t.context.rect(e[0][0]*r,e[0][1]*r,e[1][0]*r,e[1][1]*r)}},ol.control.Swipe.prototype.precomposeLeft=function(t){var e=t.context;if(e instanceof WebGLRenderingContext){if("prerender"===t.type){e.clearColor(0,0,0,0),e.clear(e.COLOR_BUFFER_BIT),e.enable(e.SCISSOR_TEST);var o=this.getMap().getSize(),i=this._transformPt(t,[0,o[1]]),n=this._transformPt(t,[o[0],0]),r=n[0]-i[0],s=n[1]-i[1];if("vertical"===this.get("orientation"))var a=Math.round(r*this.get("position")),l=s;else{a=r,l=Math.round(s*this.get("position"));i[1]+=s-l}e.scissor(i[0],i[1],a,l)}}else{var c=t.frameState.size;e.save(),e.beginPath();var h=[[0,0],[c[0],c[1]]];"vertical"===this.get("orientation")?h[1]=[.5*c[0]+this.getMap().getSize()[0]*(this.get("position")-.5),c[1]]:h[1]=[c[0],.5*c[1]+this.getMap().getSize()[1]*(this.get("position")-.5)],this._drawRect(t,h),e.clip()}},ol.control.Swipe.prototype.precomposeRight=function(t){var e=t.context;if(e instanceof WebGLRenderingContext){if("prerender"===t.type){e.clearColor(0,0,0,0),e.clear(e.COLOR_BUFFER_BIT),e.enable(e.SCISSOR_TEST);var o=this.getMap().getSize(),i=this._transformPt(t,[0,o[1]]),n=this._transformPt(t,[o[0],0]),r=n[0]-i[0],s=n[1]-i[1];if("vertical"===this.get("orientation")){var a=s,l=Math.round(r*(1-this.get("position")));i[0]+=r-l}else l=r,a=Math.round(s*(1-this.get("position")));e.scissor(i[0],i[1],l,a)}}else{var c=t.frameState.size;e.save(),e.beginPath();var h=[[0,0],[c[0],c[1]]];"vertical"===this.get("orientation")?h[0]=[.5*c[0]+this.getMap().getSize()[0]*(this.get("position")-.5),0]:h[0]=[0,.5*c[1]+this.getMap().getSize()[1]*(this.get("position")-.5)],this._drawRect(t,h),e.clip()}},ol.control.Swipe.prototype.postcompose=function(t){if(t.context instanceof WebGLRenderingContext){if("postrender"===t.type){var e=t.context;e.disable(e.SCISSOR_TEST)}}else t.target.getClassName&&"ol-layer"!==t.target.getClassName()&&t.target.get("declutter")?setTimeout(function(){t.context.restore()},0):t.context.restore()},ol.control.SwipeMap=function(t){t=t||{};var e=document.createElement("button"),o=document.createElement("div");o.className=(t.className||"ol-swipe")+" ol-unselectable ol-control",o.appendChild(e),o.addEventListener("mousedown",this.move.bind(this)),o.addEventListener("touchstart",this.move.bind(this)),ol.control.Control.call(this,{element:o}),this.on("propertychange",function(t){"horizontal"===this.get("orientation")?(this.element.style.top=100*this.get("position")+"%",this.element.style.left=""):("vertical"!==this.get("orientation")&&this.set("orientation","vertical"),this.element.style.left=100*this.get("position")+"%",this.element.style.top=""),"orientation"===t.key&&(this.element.classList.remove("horizontal","vertical"),this.element.classList.add(this.get("orientation"))),this._clip()}.bind(this)),this.on("change:active",this._clip.bind(this)),this.set("position",t.position||.5),this.set("orientation",t.orientation||"vertical"),this.set("right",t.right)},ol.ext.inherits(ol.control.SwipeMap,ol.control.Control),ol.control.SwipeMap.prototype.setMap=function(t){this.getMap()&&(this._listener&&ol.Observable.unByKey(this._listener),this.getMap().getViewport().querySelector(".ol-layers").style.clip="");ol.control.Control.prototype.setMap.call(this,t),t&&(this._listener=t.on("change:size",this._clip.bind(this)))},ol.control.SwipeMap.prototype._clip=function(){if(this.getMap()){var t=this.getMap().getViewport().querySelector(".ol-layers"),e=this.getRectangle();t.style.clip="rect("+e[1]+"px,"+e[2]+"px,"+e[3]+"px,"+e[0]+"px)"}},ol.control.SwipeMap.prototype.getRectangle=function(){var t=this.getMap().getSize();return"vertical"===this.get("orientation")?this.get("right")?[t[0]*this.get("position"),0,t[0],t[1]]:[0,0,t[0]*this.get("position"),t[1]]:this.get("right")?[0,t[1]*this.get("position"),t[0],t[1]]:[0,0,t[0],t[1]*this.get("position")]},ol.control.SwipeMap.prototype.move=function(t){var e,o=this;switch(this._movefn||(this._movefn=this.move.bind(this)),t.type){case"touchcancel":case"touchend":case"mouseup":o.isMoving=!1,["mouseup","mousemove","touchend","touchcancel","touchmove"].forEach(function(t){document.removeEventListener(t,o._movefn)});break;case"mousedown":case"touchstart":o.isMoving=!0,["mouseup","mousemove","touchend","touchcancel","touchmove"].forEach(function(t){document.addEventListener(t,o._movefn)});case"mousemove":case"touchmove":if(o.isMoving)if("vertical"===o.get("orientation")){var i=t.pageX||t.touches&&t.touches.length&&t.touches[0].pageX||t.changedTouches&&t.changedTouches.length&&t.changedTouches[0].pageX;if(!i)break;i-=o.getMap().getTargetElement().getBoundingClientRect().left+window.pageXOffset-document.documentElement.clientLeft;var n=(e=o.getMap().getSize()[0])-Math.min(Math.max(0,e-i),e);e=n/e,o.set("position",e),o.dispatchEvent({type:"moving",size:[n,o.getMap().getSize()[1]],position:[e,0]})}else{var r=t.pageY||t.touches&&t.touches.length&&t.touches[0].pageY||t.changedTouches&&t.changedTouches.length&&t.changedTouches[0].pageY;if(!r)break;r-=o.getMap().getTargetElement().getBoundingClientRect().top+window.pageYOffset-document.documentElement.clientTop;var s=(e=o.getMap().getSize()[1])-Math.min(Math.max(0,e-r),e);e=s/e,o.set("position",e),o.dispatchEvent({type:"moving",size:[o.getMap().getSize()[0],s],position:[0,e]})}}},ol.control.Target=function(t){t=t||{},this.style=t.style||[new ol.style.Style({image:new ol.style.RegularShape({points:4,radius:11,radius1:0,radius2:0,snapToPixel:!0,stroke:new ol.style.Stroke({color:"#fff",width:3})})}),new ol.style.Style({image:new ol.style.RegularShape({points:4,radius:11,radius1:0,radius2:0,snapToPixel:!0,stroke:new ol.style.Stroke({color:"#000",width:1})})})],this.style instanceof Array||(this.style=[this.style]),this.composite=t.composite||"";var e=document.createElement("div");e.className="ol-target ol-unselectable ol-control",ol.control.CanvasBase.call(this,{element:e,target:t.target}),this.setVisible(!1!==t.visible)},ol.ext.inherits(ol.control.Target,ol.control.CanvasBase),ol.control.Target.prototype.setVisible=function(t){if(this.set("visible",t),this.getMap())try{this.getMap().renderSync()}catch(t){}},ol.control.Target.prototype.getVisible=function(){return this.get("visible")},ol.control.Target.prototype._draw=function(t){var e=this.getContext(t);if(e&&this.getMap()&&this.getVisible()){var o=t.frameState.pixelRatio;e.save(),e.scale(o,o);var i=e.canvas.width/(2*o),n=e.canvas.height/(2*o),r=new ol.geom.Point(this.getMap().getCoordinateFromPixel([i,n]));this.composite&&(e.globalCompositeOperation=this.composite);for(var s=0;s<this.style.length;s++){var a=this.style[s];if(a instanceof ol.style.Style){var l=t.vectorContext;if(!l){var c={inversePixelTransform:[o,0,0,o,0,0],context:e,frameState:{pixelRatio:o,extent:t.frameState.extent,coordinateToPixelTransform:t.frameState.coordinateToPixelTransform,viewState:t.frameState.viewState}};l=ol.render.getVectorContext(c)}l.setStyle(a),l.drawGeometry(r)}}e.restore()}},ol.control.TextButton=function(t){(t=t||{}).className=(t.className||"")+" ol-text-button",ol.control.Button.call(this,t)},ol.ext.inherits(ol.control.TextButton,ol.control.Button),ol.control.Timeline=function(t){var e=ol.ext.element.create("DIV",{className:(t.className||"")+" ol-timeline"+(t.target?"":" ol-unselectable ol-control")+(t.zoomButton?" ol-hasbutton":"")});ol.control.Control.call(this,{element:e,target:t.target}),this._scrollDiv=ol.ext.element.create("DIV",{className:"ol-scroll",parent:this.element}),this._buttons=ol.ext.element.create("DIV",{className:"ol-buttons",parent:this.element}),t.zoomButton&&(this.addButton({className:"ol-zoom-in",handleClick:function(){var t=this.get("zoom");t>=1?t++:t=Math.min(1,t+.1),t=Math.round(100*t)/100,this.refresh(t)}.bind(this)}),this.addButton({className:"ol-zoom-out",handleClick:function(){var t=this.get("zoom");t>1?t--:t-=.1,t=Math.round(100*t)/100,this.refresh(t)}.bind(this)})),this._intervalDiv=ol.ext.element.create("DIV",{className:"ol-center-date",parent:this.element}),this.element.addEventListener("mouseover",function(){this._select&&this._select.elt.classList.remove("ol-select")}.bind(this));var o=null;this._scrollDiv.addEventListener("scroll",function(){this._setScrollLeft(),o&&(clearTimeout(o),o=null),o=setTimeout(function(){this.dispatchEvent({type:"scroll",date:this.getDate(),dateStart:this.getDate("start"),dateEnd:this.getDate("end")})}.bind(this),t.scrollTimeout||15)}.bind(this)),ol.ext.element.scrollDiv(this._scrollDiv,{onmove:function(t){this._moving=t}.bind(this)}),this._tline=[],this._scrollLeft=0,this.set("maxWidth",t.maxWidth||2e3),this.set("minDate",t.minDate||1/0),this.set("maxDate",t.maxDate||-1/0),this.set("graduation",t.graduation),this.set("minZoom",t.minZoom||.2),this.set("maxZoom",t.maxZoom||4),this.setInterval(t.interval),t.getHTML&&(this._getHTML=t.getHTML),t.getFeatureDate&&(this._getFeatureDate=t.getFeatureDate),t.endFeatureDate&&(this._endFeatureDate=t.endFeatureDate),this.setFeatures(t.features||t.source,t.zoom)},ol.ext.inherits(ol.control.Timeline,ol.control.Control),ol.control.Timeline.prototype.setMap=function(t){ol.control.Control.prototype.setMap.call(this,t),this.refresh(this.get("zoom")||1,!0)},ol.control.Timeline.prototype.addButton=function(t){this.element.classList.add("ol-hasbutton"),ol.ext.element.create("BUTTON",{className:t.className||void 0,title:t.title,html:t.html,click:t.handleClick,parent:this._buttons})},ol.control.Timeline.prototype.setInterval=function(t){"string"==typeof t&&(t=/s$/.test(t)?1e3*parseFloat(t):/mn$/.test(t)?1e3*parseFloat(t)*60:/h$/.test(t)?1e3*parseFloat(t)*3600:/d$/.test(t)?1e3*parseFloat(t)*3600*24:/y$/.test(t)?1e3*parseFloat(t)*3600*24*365:0),this.set("interval",t||0),t?this.element.classList.add("ol-interval"):this.element.classList.remove("ol-interval"),this.refresh(this.get("zoom"))},ol.control.Timeline.prototype._getHTML=function(t){return t.get("name")||""},ol.control.Timeline.prototype._getFeatureDate=function(t){return t&&t.get?t.get("date"):null},ol.control.Timeline.prototype._endFeatureDate=function(){},ol.control.Timeline.prototype.isCollapsed=function(){return this.element.classList.contains("ol-collapsed")},ol.control.Timeline.prototype.collapse=function(t){t?this.element.classList.add("ol-collapsed"):this.element.classList.remove("ol-collapsed"),this.dispatchEvent({type:"collapse",collapsed:this.isCollapsed()})},ol.control.Timeline.prototype.toggle=function(){this.element.classList.toggle("ol-collapsed"),this.dispatchEvent({type:"collapse",collapsed:this.isCollapsed()})},ol.control.Timeline.prototype.setFeatures=function(t,e){this._features=this._source=null,t instanceof ol.source.Vector?this._source=t:t instanceof Array?this._features=t:this._features=[],this.refresh(e)},ol.control.Timeline.prototype.getFeatures=function(){return this._features||this._source.getFeatures()},ol.control.Timeline.prototype.refresh=function(t,e){if(this.getMap()){t||(t=this.get("zoom")),t=Math.min(this.get("maxZoom"),Math.max(this.get("minZoom"),t||1)),this.set("zoom",t),this._scrollDiv.innerHTML="";var o,i,n=this.getFeatures(),r=this._tline=[];n.forEach(function(t){(o=this._getFeatureDate(t))&&(o instanceof Date||(o=new Date(o)),this._endFeatureDate&&((i=this._endFeatureDate(t))instanceof Date||(i=new Date(i))),isNaN(o)||r.push({date:o,end:isNaN(i)?null:i,feature:t}))}.bind(this)),r.sort(function(t,e){return t.date<e.date?-1:t.date===e.date?0:1});var s=ol.ext.element.create("DIV",{parent:this._scrollDiv}),a=this._minDate=Math.min(this.get("minDate"),r.length?r[0].date:1/0),l=this._maxDate=Math.max(this.get("maxDate"),r.length?r[r.length-1].date:-1/0);isFinite(a)||(this._minDate=a=new Date),isFinite(l)||(this._maxDate=l=new Date);var c=l-a,h=this.get("maxWidth"),p=this._scale=(c>h?h/c:1)*t;c=(l-(a=this._minDate=this._minDate-10/p))*p,ol.ext.element.setStyle(s,{width:c,maxWidth:"unset"}),this._drawTime(s,a,l,p),this.get("interval")?ol.ext.element.setStyle(this._intervalDiv,{width:this.get("interval")*p}):ol.ext.element.setStyle(this._intervalDiv,{width:""});var u=[],g=ol.ext.element.getStyle(this._scrollDiv,"lineHeight"),d=ol.ext.element.create("DIV",{className:"ol-features",parent:s});r.forEach(function(t){for(var e=t.date,o=t.elt=ol.ext.element.create("DIV",{className:"ol-feature",style:{left:Math.round((e-a)*p)},html:this._getHTML(t.feature),parent:d}),i=o.querySelectorAll("img"),n=0;n<i.length;n++)i[n].ondragstart=function(){return!1};t.end&&ol.ext.element.setStyle(o,{minWidth:(t.end-e)*p,width:(t.end-e)*p,maxWidth:"unset"});var r,s,l=ol.ext.element.getStyle(o,"left");for(o.addEventListener("click",function(){this._moving||this.dispatchEvent({type:"select",feature:t.feature})}.bind(this)),r=0;(s=u[r])&&!(l>s);r++);u[r]=l+ol.ext.element.getStyle(o,"width"),ol.ext.element.setStyle(o,{top:r*g})}.bind(this)),this._nbline=u.length,e&&this.setDate(this._minDate,{anim:!1,position:"start"}),this.dispatchEvent({type:"scroll",date:this.getDate(),dateStart:this.getDate("start"),dateEnd:this.getDate("end")})}},ol.control.Timeline.prototype._getOffsetFromDate=function(t){return(t-this._minDate)*this._scale},ol.control.Timeline.prototype._getDateFromOffset=function(t){return t/this._scale+this._minDate},ol.control.Timeline.prototype._setScrollLeft=function(t){this._scrollLeft=t,void 0!==t&&(this._scrollDiv.scrollLeft=t)},ol.control.Timeline.prototype._getScrollLeft=function(){return void 0===this._scrollLeft?this._scrollDiv.scrollLeft:this._scrollLeft},ol.control.Timeline.prototype._drawTime=function(t,e,o,i){var n,r,s,a,l=ol.ext.element.create("DIV",{className:"ol-times",parent:t}),c=ol.ext.element.getStyle(l,"left"),h=ol.ext.element.getStyle(l,"height"),p=new Date(this._minDate).getFullYear();r=(new Date(0).setFullYear(String(p))-new Date(0).setFullYear(String(p-1)))*i;for(var u=Math.round(2*h/r)+1;!((n=new Date(0).setFullYear(p))>this._maxDate);)ol.ext.element.create("DIV",{className:"ol-time ol-year",style:{left:this._getOffsetFromDate(n)-c},html:p,parent:l}),p+=u;if(/day|month/.test(this.get("graduation"))&&(r=(new Date(0,0,1).setFullYear(String(p))-new Date(0,0,1).setFullYear(String(p-1)))*i,(a=Math.max(1,Math.round(12/Math.round(r/h/2))))<12))for(p=new Date(this._minDate).getFullYear(),s=a+1;(n=new Date(0,0,1)).setFullYear(p),n.setMonth(s-1),!(n>this._maxDate);)ol.ext.element.create("DIV",{className:"ol-time ol-month",style:{left:this._getOffsetFromDate(n)-c},html:n.toLocaleDateString(void 0,{month:"short"}),parent:l}),(s+=a)>12&&(p++,s=a+1);if("day"===this.get("graduation")){r=(new Date(0,1,1)-new Date(0,0,1))*i;var g=Math.max(1,Math.round(31/Math.round(r/h/2)));if(g<31){p=new Date(this._minDate).getFullYear(),s=0;for(var d=g;;)if((n=new Date(0,0,1)).setFullYear(p),n.setMonth(s),n.setDate(d),isNaN(n))++s>12&&(s=1,p++),d=g;else{if(n>this._maxDate)break;if(d>1){var m=this._getOffsetFromDate(n);this._getOffsetFromDate(new Date(p,s+1,1))-m>h&&ol.ext.element.create("DIV",{className:"ol-time ol-day",style:{left:m-c},html:d,parent:l})}p=n.getFullYear(),s=n.getMonth(),(d=n.getDate()+g)>new Date(p,s+1,0).getDate()&&(s++,d=g)}}}},ol.control.Timeline.prototype.setDate=function(t,e){var o;if(e=e||{},t instanceof Date?o=t:(this.getFeatures().indexOf(t)>=0&&(o=this._getFeatureDate(t)),!o||o instanceof Date||(o=new Date(o)),o&&!isNaN(o)||(o=new Date(String(t)))),!isNaN(o)){!1===e.anim&&this._scrollDiv.classList.add("ol-move");var i=this._getOffsetFromDate(o);if("start"===e.position?i+=ol.ext.element.outerWidth(this._scrollDiv)/2-ol.ext.element.getStyle(this._scrollDiv,"marginLeft")/2:"end"===e.position&&(i-=ol.ext.element.outerWidth(this._scrollDiv)/2-ol.ext.element.getStyle(this._scrollDiv,"marginLeft")/2),this._setScrollLeft(i),!1===e.anim&&this._scrollDiv.classList.remove("ol-move"),t)for(var n,r=0;n=this._tline[r];r++)n.feature===t?(n.elt.classList.add("ol-select"),this._select=n):n.elt.classList.remove("ol-select")}},ol.control.Timeline.prototype.roundDate=function(t,e){switch(e){case"mn":return new Date(this._roundTo(t,6e4));case"hour":return new Date(this._roundTo(t,36e5));case"day":return new Date(this._roundTo(t,864e5));case"month":return(t=new Date(this._roundTo(t,864e5))).getDate()>15&&(t=new Date(t.setMonth(t.getMonth()+1))),t=t.setDate(1),new Date(t);default:return new Date(t)}},ol.control.Timeline.prototype.getDate=function(t,e){var o;switch(e||(e=t),t){case"start":o=this.get("interval")?-ol.ext.element.getStyle(this._intervalDiv,"width")/2+ol.ext.element.getStyle(this._scrollDiv,"marginLeft")/2:-ol.ext.element.outerWidth(this._scrollDiv)/2+ol.ext.element.getStyle(this._scrollDiv,"marginLeft")/2;break;case"end":o=this.get("interval")?ol.ext.element.getStyle(this._intervalDiv,"width")/2-ol.ext.element.getStyle(this._scrollDiv,"marginLeft")/2:ol.ext.element.outerWidth(this._scrollDiv)/2-ol.ext.element.getStyle(this._scrollDiv,"marginLeft")/2;break;default:o=0}var i=this._getDateFromOffset(this._getScrollLeft()+o);return i=this.roundDate(i,e),new Date(i)},ol.control.Timeline.prototype._roundTo=function(t,e){return Math.round(t/e)*e},ol.control.Timeline.prototype.getStartDate=function(){return new Date(this.get("minDate"))},ol.control.Timeline.prototype.getEndDate=function(){return new Date(this.get("maxDate"))},ol.control.VideoRecorder=function(t){t||(t={});var e=ol.ext.element.create("DIV",{className:(t.className||"ol-videorec")+" ol-unselectable ol-control"});ol.ext.element.create("BUTTON",{type:"button",className:"ol-start",title:"start",click:function(){this.start()}.bind(this),parent:e}),ol.ext.element.create("BUTTON",{type:"button",className:"ol-stop",title:"stop",click:function(){this.stop()}.bind(this),parent:e}),ol.ext.element.create("BUTTON",{type:"button",className:"ol-pause",title:"pause",click:function(){this.pause()}.bind(this),parent:e}),ol.ext.element.create("BUTTON",{type:"button",className:"ol-resume",title:"resume",click:function(){this.resume()}.bind(this),parent:e}),ol.control.Control.call(this,{element:e,target:t.target}),this.set("framerate",30),this.set("videoBitsPerSecond",5e6),"DIALOG"===t.videoTarget?(this._dialog=new ol.control.Dialog({className:"ol-fullscreen-dialog",target:document.body,closeBox:!0}),this._videoTarget=this._dialog.getContentElement()):this._videoTarget=t.videoTarget,this._printCtrl=new ol.control.Print({target:ol.ext.element.create("DIV")})},ol.ext.inherits(ol.control.VideoRecorder,ol.control.Control),ol.control.VideoRecorder.prototype.setMap=function(t){this.getMap()&&(this.getMap().removeControl(this._printCtrl),this._dialog&&this.getMap().removeControl(this._dialog)),ol.control.Control.prototype.setMap.call(this,t),this.getMap()&&(this.getMap().addControl(this._printCtrl),this._dialog&&this.getMap().addControl(this._dialog))},ol.control.VideoRecorder.prototype.start=function(){var t=this._printCtrl,e=!1;function o(i){e||t.fastPrint({canvas:i},o)}t.fastPrint({},function(t){var i;try{i=t.captureStream(this.get("framerate")||30)}catch(t){return void this.dispatchEvent({type:"error",error:t})}this._mediaRecorder=new MediaRecorder(i,{videoBitsPerSecond:this.get("videoBitsPerSecond")||5e6});var n=[];this._mediaRecorder.ondataavailable=function(t){n.push(t.data)},this._mediaRecorder.onstop=function(){e=!0;var t,o=new Blob(n,{type:"video/mp4"});(n=[],this._videoTarget instanceof Element)?("VIDEO"===this._videoTarget.tagName?t=this._videoTarget:(t=this._videoTarget.querySelector("video"))||(t=ol.ext.element.create("VIDEO",{controls:"",parent:this._videoTarget})),this._dialog&&this._dialog.show(),t.src=URL.createObjectURL(o),this.dispatchEvent({type:"stop",videoURL:t.src})):this.dispatchEvent({type:"stop",videoURL:URL.createObjectURL(o)})}.bind(this),this._mediaRecorder.onpause=function(){e=!0,this.dispatchEvent({type:"pause"})}.bind(this),this._mediaRecorder.onresume=function(){e=!1,o(t),this.dispatchEvent({type:"resume"})}.bind(this),this._mediaRecorder.onerror=function(t){this.dispatchEvent({type:"error",error:t})}.bind(this),e=!1,o(t),this._mediaRecorder.start(),this.dispatchEvent({type:"start",canvas:t}),this.element.setAttribute("data-state","rec")}.bind(this))},ol.control.VideoRecorder.prototype.stop=function(){this._mediaRecorder&&(this._mediaRecorder.stop(),this._mediaRecorder=null,this.element.setAttribute("data-state","inactive"))},ol.control.VideoRecorder.prototype.pause=function(){this._mediaRecorder&&(this._mediaRecorder.pause(),this.element.setAttribute("data-state","pause"))},ol.control.VideoRecorder.prototype.resume=function(){this._mediaRecorder&&(this._mediaRecorder.resume(),this.element.setAttribute("data-state","rec"))},ol.control.WMSCapabilities=function(t){t=t||{};var e=Object.assign({},t||{});this._proxy=t.proxy,e.target===document.body&&delete e.target,e.target?(e.className=((e.className||"")+" ol-wmscapabilities ol-hidden").trim(),delete e.target):(e.className=((e.className||"")+" ol-wmscapabilities").trim(),e.handleClick=function(){this.showDialog()}.bind(this)),ol.control.Button.call(this,e),this.set("srs",t.srs||[]),this.set("cors",t.cors),this.set("trace",t.trace),this.set("title",t.title),this.set("loadLabel",t.loadLabel),this.set("optional",t.optional),this.createDialog(t),this._elements.formVersion.value="1.0.0";var o=this._getParser();this._ajax=new ol.ext.Ajax({dataType:"text",auth:t.authentication}),this._ajax.on("success",function(t){var e;try{e=o.read(t.response)}catch(t){this.showError({type:"load",error:t})}e&&(e.Capability.Layer.Layer?this.showCapabilities(e):this.showError({type:"noLayer"})),this.dispatchEvent({type:"capabilities",capabilities:e}),"function"==typeof t.options.callback&&t.options.callback(e)}.bind(this)),this._ajax.on("error",function(t){this.showError({type:"load",error:t}),this.dispatchEvent({type:"capabilities"}),t.options.callback}.bind(this)),this._ajax.on("loadstart",function(){this._elements.element.classList.add("ol-searching")}.bind(this)),this._ajax.on("loadend",function(){this._elements.element.classList.remove("ol-searching")}.bind(this)),t.onselect&&this.on("load",function(e){t.onselect(e.layer,e.options)})},ol.ext.inherits(ol.control.WMSCapabilities,ol.control.Button),ol.control.WMSCapabilities.prototype._getParser=function(){return new ol.format.WMSCapabilities},ol.control.WMSCapabilities.prototype.error={load:"Can't retrieve service capabilities, try to add it manually...",badUrl:"The input value is not a valid url...",TileMatrix:"No TileMatrixSet supported...",noLayer:"No layer available for this service...",srs:"The service projection looks different from that of your map, it may not display correctly..."},ol.control.WMSCapabilities.prototype.labels={formTitle:"Title:",formLayer:"Layers:",formMap:"Map:",formStyle:"Style:",formFormat:"Format:",formMinZoom:"Min zoom level:",formMaxZoom:"Max zoom level:",formExtent:"Extent:",mapExtent:"use map extent...",formProjection:"Projection:",formCrossOrigin:"CrossOrigin:",formVersion:"Version:",formAttribution:"Attribution:"},ol.control.WMSCapabilities.prototype.createDialog=function(t){var e=t.target;e&&e!==document.body||(this._dialog=new ol.control.Dialog({className:"ol-wmscapabilities",closeBox:!0,closeOnSubmit:!1,target:t.target}),this._dialog.on("button",function(t){"submit"===t.button&&this.getCapabilities(t.inputs.url.value)}.bind(this)),e=null);var o=ol.ext.element.create("DIV",{className:("ol-wmscapabilities "+(t.className||"")).trim(),parent:e});this._elements={element:e||o};var i=ol.ext.element.create("DIV",{className:"ol-url",parent:o}),n=this._elements.input=ol.ext.element.create("INPUT",{className:"url",type:"text",tabIndex:1,placeholder:t.placeholder||"service url...",autocorrect:"off",autocapitalize:"off",parent:i});if(n.addEventListener("keyup",function(e){13===e.keyCode&&this.getCapabilities(n.value,t)}.bind(this)),t.services){var r=ol.ext.element.create("SELECT",{className:"url",on:{change:function(e){var o=e.target.options[e.target.selectedIndex].value;this.getCapabilities(o,t),e.target.selectedIndex=0}.bind(this)},parent:i});for(var s in ol.ext.element.create("OPTION",{html:" ",parent:r}),t.services)ol.ext.element.create("OPTION",{html:s,value:t.services[s],parent:r})}ol.ext.element.create("BUTTON",{click:function(){this.getCapabilities(n.value,t)}.bind(this),html:t.searchLabel||"search",parent:i}),this._elements.error=ol.ext.element.create("DIV",{className:"ol-error",parent:i});var a=this._elements.result=ol.ext.element.create("DIV",{className:"ol-result",parent:o}),l=ol.ext.element.create("DIV",{className:"ol-preview",html:t.previewLabel||"preview",parent:a});this._elements.preview=ol.ext.element.create("IMG",{parent:l}),this._img=new Image,this._img.crossOrigin="Anonymous",this._img.addEventListener("error",function(){l.className="ol-preview tainted",this._elements.formCrossOrigin.checked=!1}.bind(this)),this._img.addEventListener("load",function(){l.className="ol-preview ok",this._elements.formCrossOrigin.checked=!0}.bind(this)),this._elements.select=ol.ext.element.create("DIV",{className:"ol-select-list",tabIndex:2,parent:a}),this._elements.data=ol.ext.element.create("DIV",{className:"ol-data",parent:a}),this._elements.buttons=ol.ext.element.create("DIV",{className:"ol-buttons",parent:a}),this._elements.legend=ol.ext.element.create("IMG",{className:"ol-legend",parent:a});var c=this._elements.form=ol.ext.element.create("UL",{className:"ol-wmsform",parent:o}),h=function(t,e,o){var i=ol.ext.element.create("LI",{parent:c});if(ol.ext.element.create("LABEL",{html:this.labels[t],parent:i}),"boolean"==typeof e)this._elements[t]=ol.ext.element.create("INPUT",{type:"checkbox",checked:e,parent:i});else if(e instanceof Array){var n=this._elements[t]=ol.ext.element.create("SELECT",{parent:i});e.forEach(function(t){ol.ext.element.create("OPTION",{html:t,value:t,parent:n})}.bind(this))}else this._elements[t]=ol.ext.element.create("INPUT",{value:void 0===e?"":e,placeholder:o||"",type:"number"==typeof e?"number":"text",parent:i});return i}.bind(this);h("formTitle"),h("formLayer","","layer1,layer2,...");var p=h("formMap");p.setAttribute("data-param","map"),(p=h("formStyle")).setAttribute("data-param","style"),h("formFormat",["image/png","image/jpeg"]),h("formMinZoom",0),h("formMaxZoom",20),(p=h("formExtent","","xmin,ymin,xmax,ymax")).setAttribute("data-param","extent");var u=p.querySelector("input");return ol.ext.element.create("BUTTON",{title:this.labels.mapExtent,click:function(){u.value=this.getMap().getView().calculateExtent(this.getMap().getSize()).join(",")}.bind(this),parent:p}),(p=h("formProjection","")).setAttribute("data-param","proj"),h("formCrossOrigin",!1),(p=h("formVersion","1.3.0")).setAttribute("data-param","version"),h("formAttribution",""),ol.ext.element.create("BUTTON",{html:this.get("loadLabel")||"Load",click:function(){var t=this._getFormOptions(),e=this.getLayerFromOptions(t);this.dispatchEvent({type:"load",layer:e,options:t}),this._dialog.hide()}.bind(this),parent:c}),o},ol.control.WMSCapabilities.prototype.getLayerFromOptions=function(t){t.layer.source=new ol.source.TileWMS(t.source);var e=new ol.layer.Tile(t.layer);return delete t.layer.source,e},ol.control.WMSCapabilities.prototype.setMap=function(t){ol.control.Button.prototype.setMap.call(this,t),this._dialog&&this._dialog.setMap(t)},ol.control.WMSCapabilities.prototype.getDialog=function(){return this._dialog},ol.control.WMSCapabilities.prototype.showDialog=function(t,e){this.showError(),this._elements.formProjection.value||(this._elements.formProjection.value=this.getMap().getView().getProjection().getCode()),this._dialog&&this._dialog.show({title:void 0===this.get("title")?"WMS":this.get("title"),content:this._elements.element}),this.getCapabilities(t,e);var o=this._elements.select.querySelector(".selected");o&&(this._elements.select.scrollTop=o.offsetTop-20)},ol.control.WMSCapabilities.prototype.testUrl=function(t){return!!new RegExp("^(https?:\\/\\/)((([a-z\\d]([a-z\\d-]*[a-z\\d])*)\\.)+[a-z]{2,}|((\\d{1,3}\\.){3}\\d{1,3}))(\\:\\d+)?(\\/[-a-z\\d%_.~+]*)*(\\?[;&a-z\\d%_.~+=\\/-]*)?(\\#[-a-z\\d_]*)?$","i").test(t)},ol.control.WMSCapabilities.prototype.getRequestParam=function(t){return{SERVICE:"WMS",REQUEST:"GetCapabilities",VERSION:t.version||"1.3.0"}},ol.control.WMSCapabilities.prototype.getCapabilities=function(t,e){if(t)if(this.testUrl(t)){e=e||{};var o=(t=t.split("?"))[1];t=t[0],this._elements.formMap.value="",this._elements.formLayer.value="",this._elements.formStyle.value="",this._elements.formTitle.value="",this._elements.formProjection.value=this.getMap().getView().getProjection().getCode(),this._elements.formFormat.selectedIndex=0;var i=e.map||"",n={};o&&(o=o.replace(/^\?/,"").split("&")).forEach(function(t){if((t=t.split("="))[1]=decodeURIComponent(t[1]||""),/^map$/i.test(t[0])&&(i=t[1],this._elements.formMap.value=i),/^layers$/i.test(t[0])&&(this._elements.formLayer.value=t[1],this._elements.formTitle.value=t[1].split(",")[0]),/^style$/i.test(t[0])&&(this._elements.formStyle.value=t[1]),/^crs$/i.test(t[0])&&(this._elements.formProjection.value=t[1]),/^format$/i.test(t[0]))for(var e,o=0;e=this._elements.formFormat.options[o];o++)if(e.value===t[1]){this._elements.formFormat.selectedIndex=o;break}this.get("optional")&&this.get("optional").split(",").forEach(function(e){e===t[0]&&(n[e]=t[1])}.bind(this))}.bind(this));var r=this.getRequestParam(e),s=[];for(var a in i&&(r.MAP=i,s.push("map="+i)),n)r[a]=n[a],s.push(a+"="+n[a]);if(this._elements.input.value=(t||"")+(s?"?"+s.join("&"):""),this.clearForm(),this._proxy){var l="";for(var c in r)l+=(l?"&":"")+c+"="+r[c];this._ajax.send(this._proxy,{url:l},{timeout:e.timeout||1e4,callback:e.onload,abort:!1})}else this._ajax.send(t,r,{timeout:e.timeout||1e4,callback:e.onload,abort:!1})}else this.showError({type:"badUrl"})},ol.control.WMSCapabilities.prototype.showError=function(t){this._elements.error.innerHTML=t?this.error[t.type]||"ERROR ("+t.type+")":"",t&&"load"===t.type?this._elements.form.classList.add("visible"):this._elements.form.classList.remove("visible")},ol.control.WMSCapabilities.prototype.clearForm=function(){this._elements.result.classList.remove("ol-visible"),this.showError(),this._elements.select.innerHTML="",this._elements.data.innerHTML="",this._elements.preview.src="",this._elements.legend.src="",this._elements.legend.classList.remove("visible")},ol.control.WMSCapabilities.prototype.showCapabilities=function(t){this._elements.result.classList.add("ol-visible");var e=[],o=function(i,n){n=n||0,i.Layer.forEach(function(r){r.Attribution||(r.Attribution=i.Attribution),r.EX_GeographicBoundingBox||(r.EX_GeographicBoundingBox=i.EX_GeographicBoundingBox);var s=ol.ext.element.create("DIV",{className:(r.Layer?"ol-title ":"")+"level-"+n,html:r.Name||r.Title,click:function(){this._elements.buttons.innerHTML="",this._elements.data.innerHTML="",this._elements.legend.src=this._elements.preview.src="",this._elements.element.classList.remove("ol-form"),this.showError();var o=this.getOptionsFromCap(r,t),i=this.getLayerFromOptions(o);if(this._currentOptions=o,e.forEach(function(t){t.classList.remove("selected")}),s.classList.add("selected"),i){ol.ext.element.create("BUTTON",{html:this.get("loadLabel")||"Load",className:"ol-load",click:function(){this.dispatchEvent({type:"load",layer:i,options:o}),this._dialog&&this._dialog.hide()}.bind(this),parent:this._elements.buttons}),ol.ext.element.create("BUTTON",{className:"ol-wmsform",click:function(){this._elements.element.classList.toggle("ol-form")}.bind(this),parent:this._elements.buttons});var n=this.getMap().getView().getResolution(),a=this.getMap().getView().getCenter();this._elements.preview.src=i.getPreview(a,n,this.getMap().getView().getProjection()),this._img.src=this._elements.preview.src,ol.ext.element.create("p",{className:"ol-title",html:o.data.title,parent:this._elements.data}),ol.ext.element.create("p",{html:o.data.abstract,parent:this._elements.data}),o.data.legend.length?(this._elements.legend.src=o.data.legend[0],this._elements.legend.classList.add("visible")):(this._elements.legend.src="",this._elements.legend.classList.remove("visible"))}}.bind(this),parent:this._elements.select});e.push(s),r.Layer&&o(r,n+1)}.bind(this))}.bind(this);this._elements.select.innerHTML="",o(t.Capability.Layer)},ol.control.WMSCapabilities.prototype.getLayerResolution=function(t,e,o){var i="min"===t?"MinScaleDenominator":"MaxScaleDenominator";if(void 0!==e[i])return e[i]/(72/2.54*100);if(!e.Layer)return"min"===t?0:156543.03392804097;o="min"===t?156543.03392804097:0;for(var n=0;n<e.Layer.length;n++){var r=this.getLayerResolution(t,e.Layer[n],o);void 0!==r&&(o=Math[t](o,r))}return o},ol.control.WMSCapabilities.prototype.getOptionsFromCap=function(t,e){var o,i,n=e.Capability.Request.GetMap.Format,r=[/png/,/jpeg/,/gif/];for(i=0;i<3;i++){for(var s=0;s<n.length;s++)if(r[i].test(n[s])){o=n[s];break}if(o)break}o||(o=n[0]);var a=this.getMap().getView().getProjection().getCode();this.showError();var l=!1;t.CRS?t.CRS.indexOf(a)>=0?l=!0:t.CRS.indexOf("EPSG:4326")>=0?(a="EPSG:4326",l=!0):this.get("srs").forEach(function(e){t.CRS.indexOf(e)>=0&&(a=e,l=!0)}):l=!1,l||(this.showError({type:"srs"}),this.get("trace")&&console.log("BAD srs: ",t.CRS));var c=t.EX_GeographicBoundingBox;c&&(c=ol.proj.transformExtent(c,"EPSG:4326",this.getMap().getView().getProjection()));var h=[];t.Attribution&&h.push('<a href="'+encodeURI(t.Attribution.OnlineResource)+'">&copy; '+t.Attribution.Title.replace(/</g,"&lt;")+"</a>");var p={title:t.Title,extent:c,queryable:t.queryable,abstract:t.Abstract,minResolution:this.getLayerResolution("min",t),maxResolution:this.getLayerResolution("max",t)||156543.03392804097},u={url:e.Capability.Request.GetMap.DCPType[0].HTTP.Get.OnlineResource,projection:a,attributions:h,crossOrigin:this.get("cors")?"anonymous":null,params:{LAYERS:t.Name,FORMAT:o,VERSION:e.version||"1.3.0"}},g=new ol.View({projection:this.getMap().getView().getProjection()});g.setResolution(p.minResolution);var d=Math.round(g.getZoom());g.setResolution(p.maxResolution);var m=Math.round(g.getZoom());if(this._fillForm({title:p.title,layers:u.params.LAYERS,format:u.params.FORMAT,minZoom:m,maxZoom:d,extent:c?c.join(","):"",projection:u.projection,attribution:u.attributions[0]||"",version:u.params.VERSION}),this.get("trace")){var f=JSON.stringify([u],null,"\t").replace(/\\"/g,'"');p.source="SOURCE";var y="new ol.layer.Tile ("+JSON.stringify(p,null,"\t")+")";y=y.replace(/\\"/g,'"').replace('"SOURCE"',"new ol.source.TileWMS("+f+")").replace(/\\t/g,"\t").replace(/\\n/g,"\n").replace("([\n\t","(").replace("}\n])","})"),console.log(y),delete p.source}var v=[];return t.Style&&t.Style.forEach(function(t){t.LegendURL&&v.push(t.LegendURL[0].OnlineResource)}),{layer:p,source:u,data:{title:t.Title,abstract:t.Abstract,logo:t.Attribution&&t.Attribution.LogoURL?t.Attribution.LogoURL.OnlineResource:void 0,keyword:t.KeywordList,legend:v,opaque:t.opaque,queryable:t.queryable}}},ol.control.WMSCapabilities.prototype._getFormOptions=function(){var t=parseInt(this._elements.formMinZoom.value),e=parseInt(this._elements.formMaxZoom.value),o=new ol.View({projection:this.getMap().getView().getProjection()});o.setZoom(t);var i=o.getResolution();o.setZoom(e);var n=o.getResolution(),r=[];this._elements.formExtent.value&&this._elements.formExtent.value.split(",").forEach(function(t){r.push(parseFloat(t))}),4!==r.length&&(r=void 0);var s=[];this._elements.formAttribution.value&&s.push(this._elements.formAttribution.value);var a={layer:{title:this._elements.formTitle.value,extent:r,maxResolution:i,minResolution:n},source:{url:this._elements.input.value,crossOrigin:this._elements.formCrossOrigin.checked?"anonymous":null,projection:this._elements.formProjection.value,attributions:s,params:{FORMAT:this._elements.formFormat.options[this._elements.formFormat.selectedIndex].value,LAYERS:this._elements.formLayer.value,VERSION:this._elements.formVersion.value}},data:{title:this._elements.formTitle.value}};return this._elements.formMap.value&&(a.source.params.MAP=this._elements.formMap.value),a},ol.control.WMSCapabilities.prototype._fillForm=function(t){var e,o;for(this._elements.formTitle.value=t.title,this._elements.formLayer.value=t.layers,this._elements.formStyle.value=t.style,o=0;e=this._elements.formFormat.options[o];o++)if(e.value===t.format){this._elements.formFormat.selectedIndex=o;break}this._elements.formExtent.value=t.extent||"",this._elements.formMaxZoom.value=t.maxZoom,this._elements.formMinZoom.value=t.minZoom,this._elements.formProjection.value=t.projection,this._elements.formAttribution.value=t.attribution,this._elements.formVersion.value=t.version},ol.control.WMSCapabilities.prototype.loadLayer=function(t,e,o){this.getCapabilities(t,{onload:function(t){t?t.Capability.Layer.Layer.forEach(function(i){if(i.Name===e||i.Identifier===e){var n=this.getOptionsFromCap(i,t),r=this.getLayerFromOptions(n);this.dispatchEvent({type:"load",layer:r,options:n}),"function"==typeof o&&o({layer:r,options:n})}}.bind(this)):this.dispatchEvent({type:"load",error:!0})}.bind(this)})},ol.control.WMTSCapabilities=function(t){(t=t||{}).title=t.title||"WMTS",ol.control.WMSCapabilities.call(this,t),this.getDialog().element.classList.add("ol-wmtscapabilities")},ol.ext.inherits(ol.control.WMTSCapabilities,ol.control.WMSCapabilities),ol.control.WMTSCapabilities.prototype._getParser=function(){var t=new ol.format.WMTSCapabilities;return{read:function(e){var o=t.read(e);o.Capability={Layer:o.Contents},o.Capability.Layer.Attribution={Title:o.ServiceProvider.ProviderName};var i=[];return o.Contents.Layer.forEach(function(t){t.Format&&/jpeg|png/.test(t.Format[0])&&i.push(t)}),o.Contents.Layer=i,o}.bind(this)}},ol.control.WMTSCapabilities.prototype.getRequestParam=function(t){return{SERVICE:"WMTS",REQUEST:"GetCapabilities",VERSION:t.version||"1.0.0"}},ol.control.WMTSCapabilities.prototype._getTG=function(t,e,o,i){for(var n=new Array,r=new Array,s=ol.extent.getWidth(ol.proj.get("EPSG:3857").getExtent())/256,a=0;a<=(o||20);a++){var l=i?t+":"+a:a;n[a]=l,r[a]=s/Math.pow(2,a)}return{origin:[-20037508,20037508],resolutions:r,matrixIds:n,minZoom:e||0}},ol.control.WMTSCapabilities.prototype.getTileGrid=function(t,e,o,i){return new ol.tilegrid.WMTS(this._getTG(t,e,o,i))},ol.control.WMTSCapabilities.prototype.getOptionsFromCap=function(t,e){var o=t.WGS84BoundingBox;o&&(o=ol.proj.transformExtent(o,"EPSG:4326",this.getMap().getView().getProjection()));var i,n=1/0,r=-1/0;if(t.TileMatrixSetLink.forEach(function(e){"PM"!==e.TileMatrixSet&&"EPSG:3857"!==e.TileMatrixSet||(i=e,t.TileMatrixSet=e.TileMatrixSet)}),i){var s=i.TileMatrixSetLimits[0].TileMatrix.split(":").length>1;i.TileMatrixSetLimits.forEach(function(t){var e=t.TileMatrix.split(":").pop();n=Math.min(n,parseInt(e)),r=Math.max(r,parseInt(e))});var a=new ol.View;a.setZoom(n);var l={title:t.Title,extent:o,abstract:t.Abstract,maxResolution:a.getResolution()},c={url:e.OperationsMetadata.GetTile.DCP.HTTP.Get[0].href,layer:t.Identifier,matrixSet:t.TileMatrixSet,format:t.Format[0]||"image/jpeg",projection:"EPSG:3857",tilePrefix:s,minZoom:n,maxZoom:r,style:t.Style?t.Style[0].Identifier:"normal",attributions:t.Attribution.Title,crossOrigin:this.get("cors")?"anonymous":null,wrapX:!1!==this.get("wrapX")};if(this._fillForm({title:l.title,layers:c.layer,style:c.style,format:c.format,minZoom:n,maxZoom:r,extent:o?o.join(","):"",projection:c.projection,attribution:c.attributions||"",version:"1.0.0"}),this.get("trace")){c.tileGrid="TILEGRID";var h=JSON.stringify([c],null,"\t").replace(/\\"/g,'"');h=h.replace('"TILEGRID"',"new ol.tilegrid.WMTS("+JSON.stringify(this._getTG(c.matrixSet,c.minZoom,c.maxZoom,c.tilePrefix),null,"\t").replace(/\n/g,"\n\t\t")+")"),delete c.tileGrid,l.source="SOURCE";var p="new ol.layer.Tile ("+JSON.stringify(l,null,"\t")+")";p=p.replace(/\\"/g,'"').replace('"SOURCE"',"new ol.source.WMTS("+h+")").replace(/\\t/g,"\t").replace(/\\n/g,"\n").replace(/"tileGrid": {/g,'"tileGrid": new ol.tilegrid.WMTS({').replace(/},\n(\t*)"style"/g,'}),\n$1"style"').replace("([\n\t","(").replace("}\n])","})"),console.log(p),delete l.source}var u=void 0;return t.Style&&t.Style[0]&&t.Style[0].LegendURL&&t.Style[0].LegendURL[0]&&(u=t.Style[0].LegendURL[0].href),{layer:l,source:c,data:{title:t.Title,abstract:t.Abstract,legend:u}}}this.showError({type:"TileMatrix"})},ol.control.WMTSCapabilities.prototype._getFormOptions=function(){var t=this._currentOptions||{};t.layer||(t.layer={}),t.source||(t.source={}),t.data||(t.data={});var e=parseInt(this._elements.formMinZoom.value)||0,o=parseInt(this._elements.formMaxZoom.value)||20,i=[];this._elements.formExtent.value&&this._elements.formExtent.value.split(",").forEach(function(t){i.push(parseFloat(t))}),4!==i.length&&(i=void 0);var n=[];this._elements.formAttribution.value&&n.push(this._elements.formAttribution.value);var r=new ol.View({projection:this.getMap().getView().getProjection()});return r.setZoom(e),{layer:{title:this._elements.formTitle.value,extent:i,abstract:t.layer.abstract||"",maxResolution:r.getResolution()},source:{url:this._elements.input.value,layer:this._elements.formLayer.value,matrixSet:t.source.matrixSet||"PM",format:this._elements.formFormat.options[this._elements.formFormat.selectedIndex].value,projection:"EPSG:3857",minZoom:e,maxZoom:o,style:this._elements.formStyle.value||"normal",attributions:n,crossOrigin:this._elements.formCrossOrigin.checked?"anonymous":null,wrapX:!1!==this.get("wrapX")},data:{title:this._elements.formTitle.value,abstract:t.data.abstract,legend:t.data.legend}}},ol.control.WMTSCapabilities.prototype.getLayerFromOptions=function(t){if(t){t.source.tileGrid=this.getTileGrid(t.source.matrixSet,t.source.minZoom,t.source.maxZoom,t.source.tilePrefix),t.layer.source=new ol.source.WMTS(t.source);var e=new ol.layer.Tile(t.layer);return delete t.layer.source,delete t.source.tileGrid,e}},ol.featureAnimation=function(t){t=t||{},this.duration_="number"==typeof t.duration?t.duration>=0?t.duration:0:1e3,this.fade_="function"==typeof t.fade?t.fade:null,this.repeat_=Number(t.repeat);var e="function"==typeof t.easing?t.easing:ol.easing.linear;t.revers?this.easing_=function(t){return 1-e(t)}:this.easing_=e,this.hiddenStyle=t.hiddenStyle,ol.Object.call(this)},ol.ext.inherits(ol.featureAnimation,ol.Object),ol.featureAnimation.hiddenStyle=new ol.style.Style({image:new ol.style.Circle({}),stroke:new ol.style.Stroke({color:"transparent"})}),ol.featureAnimation.prototype.drawGeom_=function(t,e,o){this.fade_&&(t.context.globalAlpha=this.fade_(1-t.elapsed));for(var i=t.style,n=0;n<i.length;n++)try{var r=t.vectorContext||ol.render.getVectorContext(t),s=ol.ext.getVectorContextStyle(t,i[n]);r.setStyle(s),s.getZIndex()<0?r.drawGeometry(o||e):r.drawGeometry(e)}catch(t){}},ol.featureAnimation.prototype.animate=function(){return!1},ol.Map.prototype.animateFeature=function(t,e){var o=this._featureAnimationLayer;o||(o=this._featureAnimationLayer=new ol.layer.Vector({source:new ol.source.Vector})).setMap(this),o.getSource().addFeature(t);var i=e.on("animationend",function(e){e.feature===t&&(o.getSource().removeFeature(t),ol.Observable.unByKey(i))});o.animateFeature(t,e)},ol.layer.Base.prototype.animateFeature=function(t,e,o){var i,n=this,r=t.getStyle(),s=r||(this.getStyleFunction?this.getStyleFunction()(t):null);s||(s=[]),s instanceof Array||(s=[s]);var a={vectorContext:null,frameState:null,start:0,time:0,elapsed:0,extent:!1,feature:t,geom:t.getGeometry(),typeGeom:t.getGeometry().getType(),bbox:t.getGeometry().getExtent(),coord:ol.extent.getCenter(t.getGeometry().getExtent()),style:s};e instanceof Array||(e=[e]);for(var l=e.length-1;l>=0;l--)0===e[l].duration_&&e.splice(l,1);var c=0,h=0,p=o&&this.getFilters?this.getFilters():[];function u(o){a.type=o.type;try{a.vectorContext=o.vectorContext||ol.render.getVectorContext(o)}catch(o){}if(a.frameState=o.frameState,a.inversePixelTransform=o.inversePixelTransform,a.extent||(a.extent=o.frameState.extent,a.start=o.frameState.time,a.context=o.context),a.time=o.frameState.time-a.start,a.elapsed=a.time/e[h].duration_,a.elapsed>1&&(a.elapsed=1),o.context.save(),p.forEach(function(t){t.get("active")&&t.precompose(o)}),this.getOpacity&&(o.context.globalAlpha=this.getOpacity()),e[h].animate(a)){var i={type:"animating",step:h,start:a.start,time:a.time,elapsed:a.elapsed,rotation:a.rotation||0,geom:a.geom,coordinate:a.coord,feature:t};e[h].dispatchEvent(i),n.dispatchEvent(i)}else++c<e[h].repeat_?a.extent=!1:h<e.length-1?(e[h].dispatchEvent({type:"animationend",feature:t}),h++,c=0,a.extent=!1):g();p.forEach(function(t){t.get("active")&&t.postcompose(o)}),o.context.restore(),o.frameState.animate=!0}function g(o){ol.Observable.unByKey(i),i=null,t.setStyle(r);var s={type:"animationend",feature:t};if(o)for(var a in o)o.hasOwnProperty(a)&&(s[a]=o[a]);e[h].dispatchEvent(s),n.dispatchEvent(s)}function d(o){if(e.length&&!i){if(i=n.on(["postcompose","postrender"],u.bind(n)),n.renderSync)try{n.renderSync()}catch(t){}else n.changed();t.setStyle(e[h].hiddenStyle||ol.featureAnimation.hiddenStyle);var r={type:"animationstart",feature:t};if(o)for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s]);e[h].dispatchEvent(r),n.dispatchEvent(r)}}return d(),{start:d,stop:g,isPlaying:function(){return!!i}}},ol.featureAnimation.Blink=function(t){ol.featureAnimation.call(this,t),this.set("nb",t.nb||10)},ol.ext.inherits(ol.featureAnimation.Blink,ol.featureAnimation),ol.featureAnimation.Blink.prototype.animate=function(t){return Math.round(this.easing_(t.elapsed)*this.get("nb"))%2||this.drawGeom_(t,t.geom),t.time<=this.duration_},ol.featureAnimation.Bounce=function(t){t=t||{},ol.featureAnimation.call(this,t),this.amplitude_=t.amplitude||40,this.bounce_=-Math.PI*(t.bounce||3)},ol.ext.inherits(ol.featureAnimation.Bounce,ol.featureAnimation),ol.featureAnimation.Bounce.prototype.animate=function(t){var e=t.geom.clone(),o=Math.abs(Math.sin(this.bounce_*t.elapsed))*this.amplitude_*(1-this.easing_(t.elapsed))*t.frameState.viewState.resolution;return e.translate(0,o),this.drawGeom_(t,e,t.geom),t.time<=this.duration_},ol.featureAnimation.Drop=function(t){t=t||{},this.speed_=t.speed||0,ol.featureAnimation.call(this,t),this.side_=t.side||"top"},ol.ext.inherits(ol.featureAnimation.Drop,ol.featureAnimation),ol.featureAnimation.Drop.prototype.animate=function(t){if(!t.time){var e=t.frameState.viewState.rotation,o=t.frameState.size[1]*t.frameState.viewState.resolution;"top"!=this.side_&&(o*=-1),this.dx=-Math.sin(e)*o,this.dy=Math.cos(e)*o,this.speed_&&(this.duration_=o/this.speed_/t.frameState.viewState.resolution)}var i=t.geom.clone();return i.translate(this.dx*(1-this.easing_(t.elapsed)),this.dy*(1-this.easing_(t.elapsed))),this.drawGeom_(t,i,t.geom),t.time<=this.duration_},ol.featureAnimation.Fade=function(t){t=t||{},this.speed_=t.speed||0,ol.featureAnimation.call(this,t)},ol.ext.inherits(ol.featureAnimation.Fade,ol.featureAnimation),ol.featureAnimation.Fade.prototype.animate=function(t){return t.context.globalAlpha=this.easing_(t.elapsed),this.drawGeom_(t,t.geom),t.time<=this.duration_},ol.featureAnimation.None=function(t){ol.featureAnimation.call(this,t)},ol.ext.inherits(ol.featureAnimation.None,ol.featureAnimation),ol.featureAnimation.None.prototype.animate=function(t){return t.time<=this.duration_},ol.featureAnimation.Null=function(){ol.featureAnimation.call(this,{duration:0})},ol.ext.inherits(ol.featureAnimation.Null,ol.featureAnimation),ol.featureAnimation.Path=function(t){switch(t=t||{},ol.featureAnimation.call(this,t),this.speed_=t.speed||0,this.path_=t.path,t.rotate){case!0:case 0:this.rotate_=0;break;default:this.rotate_=t.rotate||!1}this.path_&&this.path_.getGeometry&&(this.path_=this.path_.getGeometry()),this.path_&&this.path_.getLineString&&(this.path_=this.path_.getLineString()),this.path_.getLength?(this.dist_=this.path_.getLength(),this.path_&&this.path_.getCoordinates&&(this.path_=this.path_.getCoordinates())):this.dist_=0,this.speed_>0&&(this.duration_=this.dist_/this.speed_)},ol.ext.inherits(ol.featureAnimation.Path,ol.featureAnimation),ol.featureAnimation.Path.prototype.animate=function(t){if(!t.time&&!this.dist_)return!1;var e,o,i,n,r,s,a=this.dist_*this.easing_(t.elapsed),l=0;o=this.path_[0];for(var c=1;c<this.path_.length;c++){if(e=o,n=(o=this.path_[c])[0]-e[0],r=o[1]-e[1],(s=Math.sqrt(n*n+r*r))&&l+s>=a){i=(a-l)/s,o=[e[0]+(o[0]-e[0])*i,e[1]+(o[1]-e[1])*i];break}l+=s}var h=t.style;if(t.rotation=Math.PI/2+Math.atan2(e[1]-o[1],e[0]-o[0]),!1!==this.rotate_){var p=[],u=this.rotate_-t.rotation+t.frameState.viewState.rotation;t.rotation=Math.PI/2+Math.atan2(e[1]-o[1],e[0]-o[0]);for(var g=0;i=t.style[g];g++)i.getImage()&&i.getImage().setRotation(u),p.push(i);t.style=p}return t.geom.setCoordinates(o),this.drawGeom_(t,t.geom),t.style=h,t.time<=this.duration_},ol.featureAnimation.Shake=function(t){t=t||{},ol.featureAnimation.call(this,t),this.amplitude_=t.amplitude||40,this.bounce_=-Math.PI*(t.bounce||6),this.horizontal_=t.horizontal},ol.ext.inherits(ol.featureAnimation.Shake,ol.featureAnimation),ol.featureAnimation.Shake.prototype.animate=function(t){var e=t.geom.clone(),o=t.geom.clone(),i=this.easing_(t.elapsed);return i=Math.sin(this.bounce_*i)*this.amplitude_*(1-i)*t.frameState.viewState.resolution,this.horizontal_?(e.translate(i,0),o.translate(i,0)):e.translate(0,i),this.drawGeom_(t,e,o),t.time<=this.duration_},ol.featureAnimation.Show=function(t){ol.featureAnimation.call(this,t)},ol.ext.inherits(ol.featureAnimation.Show,ol.featureAnimation),ol.featureAnimation.Show.prototype.animate=function(t){return this.drawGeom_(t,t.geom),t.time<=this.duration_},ol.featureAnimation.Slide=function(t){t=t||{},this.speed_=t.speed||0,ol.featureAnimation.call(this,t),this.side_=t.side||"left"};ol.ext.inherits(ol.featureAnimation.Slide,ol.featureAnimation),ol.featureAnimation.Slide.prototype.animate=function(t){t.time||("left"==this.side_?this.dx=t.extent[0]-t.bbox[2]:this.dx=t.extent[2]-t.bbox[0],this.speed_&&(this.duration_=Math.abs(this.dx)/this.speed_/t.frameState.viewState.resolution));var e=t.geom.clone();return e.translate(this.dx*(1-this.easing_(t.elapsed)),0),this.drawGeom_(t,e),t.time<=this.duration_},ol.featureAnimation.Teleport=function(t){ol.featureAnimation.call(this,t)},ol.ext.inherits(ol.featureAnimation.Teleport,ol.featureAnimation),ol.featureAnimation.Teleport.prototype.animate=function(t){var e=this.easing_(t.elapsed);if(e){t.context.save();var o=t.frameState.pixelRatio;t.context.globalAlpha=e,t.context.scale(e,1/e);var i=t.frameState.coordinateToPixelTransform,n=(1/e-1)*o*(i[0]*t.coord[0]+i[1]*t.coord[1]+i[4]),r=(e-1)*o*(i[2]*t.coord[0]+i[3]*t.coord[1]+i[5]);t.context.translate(n,r),this.drawGeom_(t,t.geom),t.context.restore()}return t.time<=this.duration_},ol.featureAnimation.Throw=function(t){t=t||{},ol.featureAnimation.call(this,t),this.speed_=t.speed||0,this.side_=t.side||"left"},ol.ext.inherits(ol.featureAnimation.Throw,ol.featureAnimation),ol.featureAnimation.Throw.prototype.animate=function(t){var e,o;!t.time&&this.speed_&&("left"==this.side_?(e=this.dx=t.extent[0]-t.bbox[2],o=this.dy=t.extent[3]-t.bbox[1]):(e=this.dx=t.extent[2]-t.bbox[0],o=this.dy=t.extent[3]-t.bbox[1]),this.duration_=Math.sqrt(e*e+o*o)/this.speed_/t.frameState.viewState.resolution);var i=t.geom.clone(),n=t.geom.clone();return i.translate(this.dx*(1-this.easing_(t.elapsed)),this.dy*Math.cos(Math.PI/2*this.easing_(t.elapsed))),n.translate(this.dx*(1-this.easing_(t.elapsed)),0),this.drawGeom_(t,i,n),t.time<=this.duration_},ol.featureAnimation.Zoom=function(t){t=t||{},ol.featureAnimation.call(this,t),this.set("zoomout",t.zoomOut)},ol.ext.inherits(ol.featureAnimation.Zoom,ol.featureAnimation),ol.featureAnimation.ZoomOut=function(t){(t=t||{}).zoomOut=!0,ol.featureAnimation.Zoom.call(this,t)},ol.ext.inherits(ol.featureAnimation.ZoomOut,ol.featureAnimation.Zoom),ol.featureAnimation.Zoom.prototype.animate=function(t){var e=this.easing_(t.elapsed);if(e){this.get("zoomout")&&(e=1/e);var o,i,n=t.style,r=[];for(o=0;o<n.length;o++)(i=n[o].getImage())&&(r[o]=i.getScale(),"postrender"===t.type?i.setScale(r[o]*e/t.frameState.pixelRatio):i.setScale(r[o]*e));for(this.drawGeom_(t,t.geom),o=0;o<n.length;o++)(i=n[o].getImage())&&i.setScale(r[o])}return t.time<=this.duration_},ol.filter={},ol.filter.Base=function(t){ol.Object.call(this,t),this._listener=[],t&&!1===t.active?this.set("active",!1):this.set("active",!0)},ol.ext.inherits(ol.filter.Base,ol.Object),ol.filter.Base.prototype.setActive=function(t){this.set("active",!0===t)},ol.filter.Base.prototype.getActive=function(){return this.get("active")},function(){function t(){if(this.renderSync)try{this.renderSync()}catch(t){}else this.changed()}function e(e){this.filters_||(this.filters_=[]),this.filters_.push(e),e.addToLayer&&e.addToLayer(this),e.precompose&&e._listener.push({listener:this.on(["precompose","prerender"],function(t){this.get("active")&&t.context&&this.precompose(t)}.bind(e)),target:this}),e.postcompose&&e._listener.push({listener:this.on(["postcompose","postrender"],function(t){this.get("active")&&t.context&&this.postcompose(t)}.bind(e)),target:this}),e._listener.push({listener:e.on("propertychange",t.bind(this)),target:this}),t.call(this)}function o(e){var o;if(this.filters_||(this.filters_=[]),e){for(o=this.filters_.length-1;o>=0;o--)this.filters_[o]===e&&this.filters_.splice(o,1);for(o=e._listener.length-1;o>=0;o--)e._listener[o].target===this&&(e.removeFromLayer&&e.removeFromLayer(this),ol.Observable.unByKey(e._listener[o].listener),e._listener.splice(o,1));t.call(this)}else this.filters_.forEach(function(t){this.removeFilter(t)}.bind(this))}ol.Map.prototype.addFilter=function(t){console.warn("[OL-EXT] addFilter deprecated on map."),e.call(this,t)},ol.Map.prototype.removeFilter=function(t){o.call(this,t)},ol.Map.prototype.getFilters=function(){return this.filters_||[]},ol.layer.Base.prototype.addFilter=function(t){e.call(this,t)},ol.layer.Base.prototype.removeFilter=function(t){o.call(this,t)},ol.layer.Base.prototype.getFilters=function(){return this.filters_||[]}}(),ol.filter.Mask=function(t){if(t=t||{},ol.filter.Base.call(this,t),t.feature)switch(t.feature.getGeometry().getType()){case"Polygon":case"MultiPolygon":this.feature_=t.feature}this.set("inner",t.inner),this.fillColor_=t.fill&&ol.color.asString(t.fill.getColor())||"rgba(0,0,0,0.2)"},ol.ext.inherits(ol.filter.Mask,ol.filter.Base),ol.filter.Mask.prototype.drawFeaturePath_=function(t,e){var o,i=t.context,n=i.canvas,r=t.frameState.pixelRatio;if(t.frameState.coordinateToPixelTransform){var s=t.frameState.coordinateToPixelTransform;if(t.inversePixelTransform){var a=t.inversePixelTransform;o=function(t){return[(t=[t[0]*s[0]+t[1]*s[1]+s[4],t[0]*s[2]+t[1]*s[3]+s[5]])[0]*a[0]-t[1]*a[1]+a[4],-t[0]*a[2]+t[1]*a[3]+a[5]]}}else o=function(t){return[(t[0]*s[0]+t[1]*s[1]+s[4])*r,(t[0]*s[2]+t[1]*s[3]+s[5])*r]}}else s=t.frameState.coordinateToPixelMatrix,o=function(t){return[(t[0]*s[0]+t[1]*s[1]+s[12])*r,(t[0]*s[4]+t[1]*s[5]+s[13])*r]};var l=this.feature_.getGeometry().getCoordinates();function c(t){for(var e=0;e<l.length;e++)for(var n=l[e],r=0;r<n.length;r++){var s=o([n[r][0][0]+t,n[r][0][1]]);i.moveTo(s[0],s[1]);for(var a=1;a<n[r].length;a++)s=o([n[r][a][0]+t,n[r][a][1]]),i.lineTo(s[0],s[1])}}if("Polygon"===this.feature_.getGeometry().getType()&&(l=[l]),i.beginPath(),e&&(i.moveTo(0,0),i.lineTo(n.width,0),i.lineTo(n.width,n.height),i.lineTo(0,n.height),i.lineTo(0,0)),this.get("wrapX")){var h=t.frameState.viewState.projection.getExtent(),p=h[2]-h[0],u=t.frameState.extent,g=this.feature_.getGeometry().getExtent(),d=g[2]-g[1],m=Math.floor((u[0]+d-h[0])/p),f=Math.floor((u[2]-d-h[2])/p)+1;m>f&&([m,f]=[f,m]);for(var y=m;y<=f;y++)c(y*p)}else c(0)},ol.filter.Mask.prototype.postcompose=function(t){if(this.feature_){var e=t.context;e.save(),this.drawFeaturePath_(t,!this.get("inner")),e.fillStyle=this.fillColor_,e.fill("evenodd"),e.restore()}},ol.filter.CSS=function(t){ol.filter.Base.call(this,t),this._layers=[]},ol.ext.inherits(ol.filter.CSS,ol.filter.Base),ol.filter.CSS.prototype.setBlend=function(t){this.set("blend",t),this._layers.forEach(function(e){e.once("postrender",function(e){e.context.canvas.parentNode.style["mix-blend-mode"]=t||""}.bind(this)),e.changed()})},ol.filter.CSS.prototype.setFilter=function(t){this.set("filter",t),this._layers.forEach(function(e){e.once("postrender",function(e){e.context.canvas.parentNode.style.filter=t||""}.bind(this)),e.changed()})},ol.filter.CSS.prototype.setDisplay=function(t){this.set("display",t),this._layers.forEach(function(e){e.once("postrender",function(e){e.context.canvas.parentNode.style.display=t?"":"none"}.bind(this)),e.changed()})},ol.filter.CSS.prototype.addToLayer=function(t){t.once("postrender",function(t){t.context.canvas.parentNode.style["mix-blend-mode"]=this.get("blend")||"",t.context.canvas.parentNode.style.filter=this.get("filter")||"",t.context.canvas.parentNode.style.display=!1!==this.get("display")?"":"none"}.bind(this)),t.changed(),this._layers.push(t)},ol.filter.CSS.prototype.removeFromLayer=function(t){var e=this._layers.indexOf(t);e>=0&&(t.once("postrender",function(t){t.context.canvas.parentNode.style["mix-blend-mode"]="",t.context.canvas.parentNode.style.filter="",t.context.canvas.parentNode.style.display=""}.bind(this)),t.changed(),this._layers.splice(e,1))},ol.filter.CanvasFilter=function(t){ol.filter.Base.call(this,t),this._svg={}},ol.ext.inherits(ol.filter.CanvasFilter,ol.filter.Base),ol.filter.CanvasFilter.prototype.addSVGFilter=function(t){t.getId&&(t="#"+t.getId()),this._svg[t]=1,this.dispatchEvent({type:"propertychange",key:"svg",oldValue:this._svg})},ol.filter.CanvasFilter.prototype.removeSVGFilter=function(t){t.getId&&(t="#"+t.getId()),delete this._svg[t],this.dispatchEvent({type:"propertychange",key:"svg",oldValue:this._svg})},ol.filter.CanvasFilter.prototype.precompose=function(){},ol.filter.CanvasFilter.prototype.postcompose=function(t){var e=[];for(var o in void 0!==this.get("url")&&e.push("url("+this.get("url")+")"),this._svg)e.push("url("+o+")");void 0!==this.get("blur")&&e.push("blur("+this.get("blur")+"px)"),void 0!==this.get("brightness")&&e.push("brightness("+this.get("brightness")+"%)"),void 0!==this.get("contrast")&&e.push("contrast("+this.get("contrast")+"%)"),void 0!==this.get("shadow")&&e.push("drop-shadow("+this.get("shadow")[0]+"px "+this.get("shadow")[1]+"px "+(this.get("shadowBlur")||0)+"px "+this.get("shadowColor")+")"),void 0!==this.get("grayscale")&&e.push("grayscale("+this.get("grayscale")+"%)"),void 0!==this.get("sepia")&&e.push("sepia("+this.get("sepia")+"%)"),void 0!==this.get("hueRotate")&&e.push("hue-rotate("+this.get("hueRotate")+"deg)"),void 0!==this.get("invert")&&e.push("invert("+this.get("invert")+"%)"),void 0!==this.get("saturate")&&e.push("saturate("+this.get("saturate")+"%)"),(e=e.join(" "))&&(t.context.save(),t.context.filter=e,t.context.drawImage(t.context.canvas,0,0),t.context.restore())},ol.filter.Clip=function(t){if(t=t||{},ol.filter.Base.call(this,t),this.set("coords",t.coords),this.set("units",t.units),this.set("keepAspectRatio",t.keepAspectRatio),this.set("extent",t.extent||[0,0,1,1]),this.set("color",t.color),!t.extent&&"%"!=t.units&&t.coords){for(var e,o=1/0,i=1/0,n=-1/0,r=-1/0,s=0;e=t.coords[s];s++)o>e[0]&&(o=e[0]),n<e[0]&&(n=e[0]),i>e[1]&&(i=e[1]),r<e[1]&&(r=e[1]);t.extent=[o,i,n,r]}},ol.ext.inherits(ol.filter.Clip,ol.filter.Base),ol.filter.Clip.prototype.clipPath_=function(t){var e=t.context,o=t.frameState.size,i=this.get("coords");if(i){var n=this.get("extent"),r=1,s=1;"%"==this.get("units")&&(r=o[0]/(n[2]-n[0]),s=o[1]/(n[3]-n[1])),this.get("keepAspectRatio")&&(r=s=Math.min(r,s));var a=this.get("position"),l=0,c=0;/left/.test(a)?l=-n[0]*r:/center/.test(a)?l=o[0]/2-(n[2]-n[0])*r/2:/right/.test(a)&&(l=o[0]-(n[2]-n[0])*r);var h=function(t){return t*r+l};/top/.test(a)?c=-n[1]*s:/middle/.test(a)?c=o[1]/2-(n[3]-n[1])*s/2:/bottom/.test(a)&&(c=o[1]-(n[3]-n[1])*s);var p=function(t){return t*s+c},u=[h(i[0][0]),p(i[0][1])],g=t.inversePixelTransform;g&&(u=[u[0]*g[0]-u[1]*g[1]+g[4],-u[0]*g[2]+u[1]*g[3]+g[5]]),e.moveTo(u[0],u[1]);for(var d,m=1;d=i[m];m++)u=[h(d[0]),p(d[1])],g&&(u=[u[0]*g[0]-u[1]*g[1]+g[4],-u[0]*g[2]+u[1]*g[3]+g[5]]),e.lineTo(u[0],u[1]);u=[h(i[0][0]),p(i[0][1])],g&&(u=[u[0]*g[0]-u[1]*g[1]+g[4],-u[0]*g[2]+u[1]*g[3]+g[5]]),e.moveTo(u[0],u[1])}},ol.filter.Clip.prototype.precompose=function(t){this.get("color")||(t.context.save(),t.context.beginPath(),this.clipPath_(t),t.context.clip())},ol.filter.Clip.prototype.postcompose=function(t){if(this.get("color")){var e=t.context,o=t.context.canvas;e.save(),e.beginPath(),e.moveTo(0,0),e.lineTo(0,o.height),e.lineTo(o.width,o.height),e.lineTo(o.width,o.height),e.lineTo(o.width,0),e.lineTo(0,0),this.clipPath_(t),e.fillStyle=this.get("color"),e.fill("evenodd")}t.context.restore()},ol.filter.Colorize=function(t){ol.filter.Base.call(this,t),this.setFilter(t)},ol.ext.inherits(ol.filter.Colorize,ol.filter.Base),ol.filter.Colorize.prototype.setFilter=function(t){switch(t=t||{}){case"grayscale":t={operation:"hue",color:[0,0,0],value:1};break;case"invert":t={operation:"difference",color:[255,255,255],value:1};break;case"sepia":t={operation:"color",color:[153,102,51],value:.6}}var e,o=t.color?ol.color.asArray(t.color):[t.red,t.green,t.blue,t.value];switch(this.set("color",ol.color.asString(o)),this.set("value",t.value||1),this.set("preserveAlpha",t.preserveAlpha),t.operation){case"hue":case"difference":case"color-dodge":case"enhance":this.set("operation",t.operation);break;case"saturation":e=255*(t.value||0),this.set("color",ol.color.asString([0,0,e,e||1])),this.set("operation",t.operation);break;case"luminosity":e=255*(t.value||0),this.set("color",ol.color.asString([e,e,e,255])),this.set("operation","hard-light");break;case"contrast":e=255*(t.value||0),this.set("color",ol.color.asString([e,e,e,255])),this.set("operation","soft-light");break;default:this.set("operation","color"),this.setValue(t.value||1)}},ol.filter.Colorize.prototype.setValue=function(t){this.set("value",t);var e=ol.color.asArray(this.get("color"));e[3]=t,this.set("color",ol.color.asString(e))},ol.filter.Colorize.prototype.setColor=function(t){(t=ol.color.asArray(t))&&(t[3]=this.get("value"),this.set("color",ol.color.asString(t)))},ol.filter.Colorize.prototype.precompose=function(){},ol.filter.Colorize.prototype.postcompose=function(t){var e,o,i=t.context,n=i.canvas;if(i.save(),"enhance"==this.get("operation")){var r=this.get("value");if(r){var s=n.width,a=n.height;this.get("preserveAlpha")?((e=document.createElement("CANVAS")).width=n.width,e.height=n.height,(o=e.getContext("2d")).drawImage(n,0,0,s,a),o.globalCompositeOperation="color-burn",console.log(r),o.globalAlpha=r,o.drawImage(e,0,0,s,a),o.drawImage(e,0,0,s,a),o.drawImage(e,0,0,s,a),i.globalCompositeOperation="source-in",i.drawImage(e,0,0)):(i.globalCompositeOperation="color-burn",i.globalAlpha=r,i.drawImage(n,0,0,s,a),i.drawImage(n,0,0,s,a),i.drawImage(n,0,0,s,a))}}else this.get("preserveAlpha")?((e=document.createElement("CANVAS")).width=n.width,e.height=n.height,(o=e.getContext("2d")).drawImage(n,0,0),o.globalCompositeOperation=this.get("operation"),o.fillStyle=this.get("color"),o.fillRect(0,0,n.width,n.height),i.globalCompositeOperation="source-in",i.drawImage(e,0,0)):(i.globalCompositeOperation=this.get("operation"),i.fillStyle=this.get("color"),i.fillRect(0,0,n.width,n.height));i.restore()},ol.filter.Composite=function(t){ol.filter.Base.call(this,t),this.set("operation",t.operation||"source-over")},ol.ext.inherits(ol.filter.Composite,ol.filter.Base),ol.filter.Composite.prototype.setOperation=function(t){this.set("operation",t||"source-over")},ol.filter.Composite.prototype.precompose=function(t){var e=t.context;e.save(),e.globalCompositeOperation=this.get("operation")},ol.filter.Composite.prototype.postcompose=function(t){t.context.restore()},ol.filter.Crop=function(t){t=t||{},ol.filter.Mask.call(this,t)},ol.ext.inherits(ol.filter.Crop,ol.filter.Mask),ol.filter.Crop.prototype.precompose=function(t){if(this.feature_){var e=t.context;e.save(),this.drawFeaturePath_(t,this.get("inner")),e.clip("evenodd")}},ol.filter.Crop.prototype.postcompose=function(t){this.feature_&&t.context.restore()},ol.filter.Fold=function(t){t=t||{},ol.filter.Base.call(this,t),this.set("fold",t.fold||[8,4]),this.set("margin",t.margin||8),this.set("padding",t.padding||8),"number"==typeof t.fsize&&(t.fsize=[t.fsize,t.fsize]),this.set("fsize",t.fsize||[8,10]),this.set("fill",t.fill),this.set("shadow",!1!==t.shadow),this.set("opacity",t.hasOwnProperty("opacity")?t.opacity:.2)},ol.ext.inherits(ol.filter.Fold,ol.filter.Base),ol.filter.Fold.prototype.drawLine_=function(t,e,o){var i,n,r,s=t.canvas,a=this.get("fold"),l=s.width,c=s.height;for(t.beginPath(),t.moveTo(o,o),r=1;r<=a[0];r++)i=r*l/a[0]-(r==a[0]?o:0),n=e[1]*(r%2)+o,t.lineTo(i,n);for(r=1;r<=a[1];r++)i=l-e[0]*(r%2)-o,n=r*c/a[1]-(r==a[1]?e[0]*(a[0]%2)+o:0),t.lineTo(i,n);for(r=a[0];r>0;r--)i=r*l/a[0]-(r==a[0]?e[0]*(a[1]%2)+o:0),n=c-e[1]*(r%2)-o,t.lineTo(i,n);for(r=a[1];r>0;r--)i=e[0]*(r%2)+o,n=r*c/a[1]-(r==a[1]?o:0),t.lineTo(i,n);t.closePath()},ol.filter.Fold.prototype.precompose=function(t){var e=t.context;e.save(),e.shadowColor="rgba(0,0,0,0.3)",e.shadowBlur=8,e.shadowOffsetX=2,e.shadowOffsetY=3,this.drawLine_(e,this.get("fsize"),this.get("margin")),e.fillStyle="#fff",this.get("fill")&&e.fill(),e.strokeStyle="rgba(0,0,0,0.1)",e.stroke(),e.restore(),e.save(),this.drawLine_(e,this.get("fsize"),this.get("margin")+this.get("padding")),e.clip()},ol.filter.Fold.prototype.postcompose=function(t){var e=t.context,o=e.canvas;if(e.restore(),e.save(),this.drawLine_(e,this.get("fsize"),this.get("margin")),e.clip(),this.get("shadow")){var i=this.get("fold"),n=o.width/i[0],r=o.height/i[1],s=e.createRadialGradient(5*n/8,5*n/8,n/4,n/2,n/2,n);s.addColorStop(0,"transparent"),s.addColorStop(1,"rgba(0,0,0,"+this.get("opacity")+")"),e.fillStyle=s,e.scale(1,r/n);for(var a=0;a<i[0];a++)for(var l=0;l<i[1];l++)e.save(),e.translate(a*n,l*n),e.fillRect(0,0,n,n),e.restore()}e.restore()},ol.filter.Halftone=function(t){t||(t={}),ol.filter.Base.call(this,t),this.internal_=document.createElement("canvas"),this.setSize(t.size),this.set("channel",t.channel)},ol.ext.inherits(ol.filter.Halftone,ol.filter.Base),ol.filter.Halftone.prototype.setSize=function(t){t=Number(t)||30,this.set("size",t)},ol.filter.Halftone.prototype.postcompose=function(t){var e=t.context,o=e.canvas,i=t.frameState.pixelRatio;"postrender"===t.type&&(i=1),e.save();var n=this.get("size")*i,r=t.frameState.extent,s=t.frameState.viewState.resolution/i,a=[-Math.round(r[0]/s%n),Math.round(r[1]/s%n)],l=this.internal_.getContext("2d"),c=this.internal_.width=o.width,h=this.internal_.height=o.height;l.webkitImageSmoothingEnabled=l.mozImageSmoothingEnabled=l.msImageSmoothingEnabled=l.imageSmoothingEnabled=!1;var p=Math.floor((c-a[0])/n),u=Math.floor((h-a[1])/n);l.drawImage(o,a[0],a[1],p*n,u*n,0,0,p,u);var g=l.getImageData(0,0,p,u).data;e.clearRect(0,0,c,h),e.fillStyle=ol.color.asString(this.get("color")||"#000");for(var d=0;d<p;d++)for(var m=0;m<u;m++){var f;switch(this.get("channel")){case"r":f=g[4*d+m*p*4]/2.55;break;case"g":f=g[4*d+1+m*p*4]/2.55;break;case"b":f=g[4*d+2+m*p*4]/2.55;break;default:f=(f=ol.color.toHSL([g[4*d+m*p*4],g[4*d+1+m*p*4],g[4*d+2+m*p*4]]))[2]}var y=(100-f)/140;y&&(e.beginPath(),e.arc(a[0]+n/2+d*n,a[1]+n/2+m*n,n*y,0,2*Math.PI),e.closePath(),e.fill())}e.restore()},ol.filter.Lego=function(t){t||(t={}),ol.filter.Base.call(this,t);var e=new Image;e.src=this.img[t.img]||this.img.ol3,e.crossOrigin=t.crossOrigin||null,this.pattern={canvas:document.createElement("canvas")},this.setBrick(t.brickSize,e),this.internal_=document.createElement("canvas")},ol.ext.inherits(ol.filter.Lego,ol.filter.Base),ol.filter.Lego.prototype.img={brick:"data:image/png;base64,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",ol3:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAQAAAAAYLlVAAAAAnNCSVQICFXsRgQAAAAJcEhZcwAAD10AAA9dAah0GUAAAAAZdEVYdFNvZnR3YXJlAHd3dy5pbmtzY2FwZS5vcmeb7jwaAAAHtUlEQVRo3sWZTWxcVxXHf/d9zIztcTz+pE6cOHXiyLJJadKgKE2oCBLlQwIWSCxYI0WiGxZZIYRAArFAYoEEi0hIsGBBURd0g4iK2lJAaWlaojZVKkU0H26cxB8Zz/f7uPeweHdebDLPnqlQ5l2N5/mN7tz/+Z//OffcM4rPUKCPl0eBAqqfAEAt5Ia1LwCuAg93CyCnAzgj7TstEKMluW+/x0AsWmKBmFggTu4lIpYome2Qw0kA8I2xL9T2Bp5COY6ncJRSDkopFEolANowBEAEATGIGBEkFjEiYkQbI0ZrMaFobYwxkY51pOumpSNTiau6bm7oZX1NP4Ai+ylYADkmGqUPxwSUQsG2ZbcDsBAA2QoGkeSvSZ4kr/alDcRGSyyxbJqqvG5+pHAwbRegVMz+leTBY7qcbTee8vsmQycRmnL6CkD1G4DXFl0fGegvANfpnws8+947AwqFg2MDSjAYzJY80QuAHl2gcPDJF3PiDLiimtIQC0ETEhD3klE8AJeuASg8CgeHir7vLBVOjwypQK3plyoromRNtzSamJg6QbcgvJ7C0J0YnCweG/jek/Ozw5q6bEiFiIHz+wNWBv68+rPNmlQjYnKE1Ai6cYfXA/W5Q6Uvl84f3zel3vH+SIDYoVAeofOdqa9PvbHn/PoDHYZ4eDSpE3fJgLs79YXToz858uxJ5+/en4jQ6hHr5OPZlZHhpcM/4BUv9PFw8agQdQVg1+UHnx/75fG5Gf83lFWGVUrQsmmu/HBsbN8f3Mi1MVLeGUJ3Lig8P/a7s5MN97c01I5+VUIk91err0/fLqFwgBHKOzmimzyQPzX2q1OTZfeianUVKCLNr93EZxiFIOyhnB0Tu6vf/XTp54uzY+4r3S1veYj5CEPBjqFsA3cDoEaLXy199rj/Is0eM2XILXzy5MkzSO6TAvAOFF84qf5KRfWYYhE2aJCzI5MDbxf7B58pTpf89x8qX1yWGKXKFaUBZIF1tWo/KzJPiYi3VAgYbrFEnpiYiBzBTgx0ts99YvDcvHr7YSBJka/Q4k1u3jz5eQ/EYebkXvL241NUeZN/31gkDwibhHjk8PGzTh+OrWw7X/6g/+TB8nuJrQCc4Z/KU08rb+1f/1gCSqy9NUNoP72txtXRb40dfJ+nkgMEZTw78riZLhDRndNP3vGG9GBKnRzhrppmilfhmcWoRYkxyuxv86euUaT24h4W2WN53WQmheB1ygc7MaCKuc+N5LeW6wfOXeUorwFQZIV5RlnbNqcGjBMyaAFUcfHwcHHxOznBakA6JQq34B4dkXtt+8QjvnCQa/Z/jxpFCmdbpPSJI7NyhMVzK/j2UQuFi4OLkz57FECcIcGCU8yZeirQvdxjjuvpTKGAem2EcjpjkjnUC5cvfIm/bRG3Y4e7AwOmEwPKOJotfhvlPj61dGaBEChtAdD88Yeq9et1LqWOUTj2lYzOItSmcxi2ZDXUw+k0n0bqDoXDJBsMM8rHKeIKFbxgIV9nL3cSFlPpZQBoa6AjgCYXK2YkndbckkxmWWfu2D00ozzYNinOlagwbRct/k92zNJARxFK01yur/mX2wDWGE0jfuHyNfa+Y6hQYNsmJQ45hqwwFaPpOVo6s2zDsCMDgsBq2sBR9xj8ZvX70+LJc9w+scA1Sjz49rjMy7zMywE5IY64PMcNDlkHKCbt9xhMZwhOooGODGhMzVyqTUxIm4Pll9797ixnWFZ3WORdSqz//hI+Pv7LT5dXOcNZltUa49y3qplC0Hb5uBMAbwcGDKYS/eLu6YMfrSZCUhWY+QCfGZ7iZYRbarSdYMfd0bvXazh8ii/yF2vcAVwitB1hZirWnROREFLYjN4uLQ5QTZ/WmeA2VwDUHbBks351HRxK3OaqtTTHEQwxmpjkxJApQh111kBAvBH+9O7y/KveFsfcYyNj82qywqZdxmWBAjEREbHdkrNEqNE6o6qJiVeiC4UPHuqg20PvExxGE6YAWp2jwEvabmIyqpoGuTB4ozEwd6lKvYflRzgBBIQWQrQjAG2MZABoEeJH4UU3N8f1rC/psPyz+AQWQEhIK6s09wACk+EC0NTwcCM3KrDAf6ihd6ui2ccxcrRoEaQg6lnQPYDYSLZlAS1cXBzyLHGfW0SZPDgMscgBDK10BARUs48mVgNxtl2GKh6ObVpOM8Uy94hsZpe0nakoMMdhPGJreRtAg9YuJ6NIwp18G7OJsilVyHGIQ2yySZ0WIYocQ+xhknEUhiYRoQUQ0KJBbSfleAChjvQuh4wypbQLovEpMWHrnPY2K0RoG/eR5SCgQXVn1SQAJNpNWiFlhm0+i8jZIrMNoN0j0jbhJMoPaOwu2sQFJt69oRKyadNqTGQBOFsAiM34CQchIdVuwtYyEOgu4jumQosiEX5a6aq0S9Z2T2zTThfdkS0MRN21lISAiBwD5KwDnLReStp0MZomrc4bTyaAhql131gztAhw8cnhWxeIBRASEWbVPju5wAS9/VYgdnthGwPSe5uynYqlpun9EuCTzHt0O67r5uP8teRRAC25H/cXgNmQvgKomhXdLwB2M7pu0pTyeK70mJYUm251sLfo/T8AGEoKes8eIGZ43E5wk36BBwhO2mbqgwZa9C0CAP4LFLGzNDDzmrAAAAAASUVORK5CYII=",lego:"data:image/png;base64,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"},ol.filter.Lego.prototype.set=function(t,e){ol.filter.Base.prototype.set.call(this,t,e),"brickSize"==t&&this.pattern&&this.pattern.canvas.width!=e&&this.setBrick(e)},ol.filter.Lego.prototype.setBrick=function(t,e,o){if(t=Number(t)||30,"string"==typeof e){var i=new Image;i.src=this.img[e]||this.img.ol3,i.crossOrigin=o||null,e=i}if(e&&(this.pattern.img=e),this.pattern.img.width)this.pattern.canvas.width=this.pattern.canvas.height=t,this.pattern.ctx=this.pattern.canvas.getContext("2d"),this.pattern.ctx.fillStyle=this.pattern.ctx.createPattern(this.pattern.img,"repeat"),this.set("brickSize",t),e&&this.set("img",e.src);else{var n=this;this.pattern.img.onload=function(){n.setBrick(t,e)}}},ol.filter.Lego.prototype.getPattern=function(t,e){if(!this.pattern.ctx)return"transparent";var o=this.pattern.canvas,i=this.pattern.ctx,n=o.width/this.pattern.img.width;return i.save(),i.clearRect(0,0,o.width,o.height),i.scale(n,n),t/=n,e/=n,i.translate(t,e),i.beginPath(),i.clearRect(-2*o.width,-2*o.height,4*o.width,4*o.height),i.rect(-t,-e,2*o.width/n,2*o.height/n),i.fill(),i.restore(),i.createPattern(o,"repeat")},ol.filter.Lego.prototype.postcompose=function(t){var e=t.context,o=e.canvas,i=t.frameState.pixelRatio;"postrender"===t.type&&(i=1),e.save();var n=this.pattern.canvas.width*i,r=t.frameState.extent,s=t.frameState.viewState.resolution/i,a=[-Math.round(r[0]/s%n),Math.round(r[1]/s%n)],l=this.internal_.getContext("2d"),c=this.internal_.width=o.width,h=this.internal_.height=o.height;l.webkitImageSmoothingEnabled=l.mozImageSmoothingEnabled=l.msImageSmoothingEnabled=l.imageSmoothingEnabled=!1;var p=Math.floor((c-a[0])/n),u=Math.floor((h-a[1])/n);l.drawImage(o,a[0],a[1],p*n,u*n,0,0,p,u),e.webkitImageSmoothingEnabled=e.mozImageSmoothingEnabled=e.msImageSmoothingEnabled=e.imageSmoothingEnabled=!1,e.clearRect(0,0,c,h),e.drawImage(this.internal_,0,0,p,u,a[0],a[1],p*n,u*n),e.scale(i,i),e.fillStyle=this.getPattern(a[0]/i,a[1]/i),e.rect(0,0,c,h),e.fill(),e.restore()},ol.filter.Paper=function(t){t=t||{},ol.filter.Base.call(this,t),this._svgfilter=new ol.ext.SVGFilter.Paper(t)},ol.ext.inherits(ol.filter.Paper,ol.filter.Base),ol.filter.Paper.prototype.precompose=function(){},ol.filter.Paper.prototype.postcompose=function(t){var e=t.context,o=e.canvas;e.save(),e.filter="url(#"+this._svgfilter.getId()+")",e.globalAlpha=1,e.globalCompositeOperation="multiply",e.fillRect(0,0,o.width,o.height),e.restore()},ol.filter.Paper.prototype.setLight=function(t){this._svgfilter.setLight(t)},ol.filter.PencilSketch=function(t){t=t||{},ol.filter.Base.call(this,t),this.set("blur",t.blur||8),this.set("intensity",t.intensity||.8)},ol.ext.inherits(ol.filter.PencilSketch,ol.filter.Base),ol.filter.PencilSketch.prototype.precompose=function(){},ol.filter.PencilSketch.prototype.postcompose=function(t){var e=t.context,o=e.canvas,i=o.width,n=o.height,r=document.createElement("canvas");r.width=i,r.height=n;var s=r.getContext("2d");s.filter="grayscale(1) invert(1) blur("+this.get("blur")+"px)",s.drawImage(o,0,0),e.save(),this.get("color")?(e.globalCompositeOperation="darken",e.globalAlpha=.3,e.drawImage(o,0,0)):(e.filter="grayscale(1)",e.drawImage(o,0,0)),e.globalCompositeOperation="color-dodge",e.globalAlpha=this.get("intensity"),e.drawImage(r,0,0),e.restore()},ol.filter.Pointillism=function(t){t=t||{},ol.filter.Base.call(this,t),this.set("saturate",Number(t.saturate)||2),this.pixels=[]},ol.ext.inherits(ol.filter.Pointillism,ol.filter.Base),ol.filter.Pointillism.prototype._getPixels=function(t){if(t>this.pixels.length)for(;this.pixels.length<t;)this.pixels.push([Math.random(),Math.random(),4*Math.random()+2]);return t},ol.filter.Pointillism.prototype.precompose=function(){},ol.filter.Pointillism.prototype.postcompose=function(t){var e=t.context,o=e.canvas,i=o.width,n=o.height,r=document.createElement("canvas");r.width=i,r.height=n;var s=r.getContext("2d");s.filter="saturate("+Math.round(2*this.get("saturate")*100)+"%)",s.drawImage(o,0,0),e.save(),e.filter="blur(3px) saturate("+100*this.get("saturate")+"%)",e.drawImage(o,0,0),e.filter="none",e.opacity=.5;for(var a=this._getPixels(i*n/50),l=0;l<a;l++){var c=Math.floor(this.pixels[l][0]*i),h=Math.floor(this.pixels[l][1]*n);e.fillStyle=ol.color.asString(s.getImageData(c,h,1,1).data),e.beginPath(),e.arc(c,h,this.pixels[l][2],0,2*Math.PI),e.fill()}e.restore()},ol.filter.SVGFilter=function(t){ol.filter.Base.call(this),this._svg={},t&&(t instanceof Array||(t=[t]),t.forEach(function(t){this.addSVGFilter(t)}.bind(this)))},ol.ext.inherits(ol.filter.SVGFilter,ol.filter.Base),ol.filter.SVGFilter.prototype.addSVGFilter=function(t){var e="#"+t.getId();this._svg[e]=1,this.dispatchEvent({type:"propertychange",key:"svg",oldValue:this._svg})},ol.filter.SVGFilter.prototype.removeSVGFilter=function(t){var e="#"+t.getId();delete this._svg[e],this.dispatchEvent({type:"propertychange",key:"svg",oldValue:this._svg})},ol.filter.SVGFilter.prototype.precompose=function(){},ol.filter.SVGFilter.prototype.postcompose=function(t){var e=[];for(var o in this._svg)e.push("url("+o+")");e=e.join(" ");var i=document.createElement("canvas");i.width=t.context.canvas.width,i.height=t.context.canvas.height,i.getContext("2d").drawImage(t.context.canvas,0,0),e&&(t.context.save(),t.context.clearRect(0,0,i.width,i.height),t.context.filter=e,t.context.drawImage(i,0,0),t.context.restore())},ol.filter.Texture=function(t){ol.filter.Base.call(this,t),this.setFilter(t)},ol.ext.inherits(ol.filter.Texture,ol.filter.Base),ol.filter.Texture.prototype.setFilter=function(t){var e;(t=t||{}).img?e=t.img:(e=new Image,t.src&&(ol.filter.Texture.Image&&ol.filter.Texture.Image[t.src]?e.src=ol.filter.Texture.Image[t.src]:e.src||(e.src=t.src)),e.crossOrigin=t.crossOrigin||null),this.set("rotateWithView",!1!==t.rotateWithView),this.set("opacity","number"==typeof t.opacity?t.opacity:1),this.set("ready",!1);var o=this;function i(e){o.pattern={},o.pattern.scale=t.scale||1,o.pattern.canvas=document.createElement("canvas"),o.pattern.canvas.width=e.width*o.pattern.scale,o.pattern.canvas.height=e.height*o.pattern.scale,o.pattern.canvas.width=e.width,o.pattern.canvas.height=e.height,o.pattern.ctx=o.pattern.canvas.getContext("2d"),o.pattern.ctx.fillStyle=o.pattern.ctx.createPattern(e,"repeat"),o.set("ready",!0)}e.width?i(e):e.onload=function(){i(e)}},ol.filter.Texture.prototype.getPattern=function(t,e){var o=this.pattern.canvas,i=this.pattern.ctx;return i.save(),i.translate(-t,e),i.beginPath(),i.rect(t,-e,o.width,o.height),i.fill(),i.restore(),i.createPattern(o,"repeat")},ol.filter.Texture.prototype.postcompose=function(t){if(this.pattern){var e=t.context,o=e.canvas,i=1.5*Math.max(o.width,o.height),n=t.frameState.pixelToCoordinateTransform;n||((n=t.frameState.pixelToCoordinateMatrix)[2]=n[4],n[3]=n[5],n[4]=n[12],n[5]=n[13]);var r=t.frameState.pixelRatio,s=t.frameState.viewState.resolution,a=o.width/2,l=o.height/2;if(e.save(),e.globalCompositeOperation="multiply",e.globalAlpha=this.get("opacity"),e.scale(r*this.pattern.scale,r*this.pattern.scale),this.get("rotateWithView"))s*=this.pattern.scale,e.fillStyle=this.getPattern((a*n[0]+l*n[1]+n[4])/s,(a*n[2]+l*n[3]+n[5])/s),e.translate(a/this.pattern.scale,l/this.pattern.scale),e.rotate(t.frameState.viewState.rotation),e.beginPath(),e.rect(-a-i,-l-i,2*i,2*i),e.fill();else{var c=-(a*n[0]+l*n[1]+n[4])/s,h=(a*n[2]+l*n[3]+n[5])/s,p=Math.cos(t.frameState.viewState.rotation),u=Math.sin(t.frameState.viewState.rotation),g=(c*p-h*u)/this.pattern.scale,d=(c*u+h*p)/this.pattern.scale;e.translate(g,d),e.beginPath(),e.fillStyle=this.pattern.ctx.fillStyle,e.rect(-g-i,-d-i,2*i,2*i),e.fill()}e.restore()}},ol.format.GeoJSONX=function(t){t=t||{},ol.format.GeoJSON.call(this,t),this._hash={},this._count=0,this._extended=t.extended,"function"==typeof t.whiteList?this._whiteList=t.whiteList:t.whiteList&&t.whiteList.indexOf?this._whiteList=function(e){return t.whiteList.indexOf(e)>-1}:this._whiteList=function(){return!0},"function"==typeof t.blackList?this._blackList=t.blackList:t.blackList&&t.blackList.indexOf?this._blackList=function(e){return t.blackList.indexOf(e)>-1}:this._blackList=function(){return!1},this._deleteNull=!1!==t.deleteNullProperties&&[null,void 0,""];var e=2;t.dataProjection&&"EPSG:4326"!==t.dataProjection||(e=7),isNaN(parseInt(t.decimals))||(e=parseInt(t.decimals)),this._decimals=e,this.setLayout(t.layout||"XY")},ol.ext.inherits(ol.format.GeoJSONX,ol.format.GeoJSON),ol.format.GeoJSONX.prototype._radix="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/ !#$%&'()*-.:<=>?@[]^_`{|}~",ol.format.GeoJSONX.prototype._size=ol.format.GeoJSONX.prototype._radix.length,ol.format.GeoJSONX.prototype._type={Point:0,LineString:1,Polygon:2,MultiPoint:3,MultiLineString:4,MultiPolygon:5,GeometryCollection:null},ol.format.GeoJSONX.prototype._toType=["Point","LineString","Polygon","MultiPoint","MultiLineString","MultiPolygon"],ol.format.GeoJSONX.prototype.setLayout=function(t){switch(t){case"XYZ":case"XYZM":this._layout=t;break;default:this._layout="XY"}},ol.format.GeoJSONX.prototype.getLayout=function(){return this._layout},ol.format.GeoJSONX.prototype.encodeNumber=function(t,e){!isNaN(Number(t))&&null!==t&&isFinite(t)||(t=0),e||0===e||(e=this._decimals),(t=Math.round(t*Math.pow(10,e)))<0?t=-2*t-1:t*=2;for(var o,i="",n=t;o=n%this._size,i=this._radix.charAt(o)+i,0!=(n=Math.floor(n/this._size)););return i},ol.format.GeoJSONX.prototype.decodeNumber=function(t,e){e||0===e||(e=this._decimals);var o=0;t.split("").forEach(function(t){o=o*this._size+this._radix.indexOf(t)}.bind(this));var i=Math.floor(o/2);return i!==o/2&&(i=-1-i),i/Math.pow(10,e)},ol.format.GeoJSONX.prototype.encodeCoordinates=function(t,e){var o,i,n;if("number"==typeof t[0])return i=this.encodeNumber(t[0],e)+","+this.encodeNumber(t[1],e),"Z"==this._layout[2]&&t.length>2&&(i+=","+this.encodeNumber(t[o][2],2)),"M"==this._layout[3]&&t.length>3&&(i+=","+this.encodeNumber(t[o][3],0)),i;if(t.length&&t[0]){if("number"==typeof t[0][0]){var r=[0,0,0,0],s=[],a="Z"==this._layout[2]&&t[0].length>2,l="M"==this._layout[3]&&t[0].length>3;for(o=0;o<t.length;o++){n=[Math.round(t[o][0]*Math.pow(10,e)),Math.round(t[o][1]*Math.pow(10,e))],a&&(n[2]=t[o][2]),l&&(n[3]=t[o][3]),t[o]=n;var c=t[o][0]-r[0],h=t[o][1]-r[1];0!=o&&0===c&&0===h||(i=this.encodeNumber(c,0)+","+this.encodeNumber(h,0)+(a?","+this.encodeNumber(t[o][2]-r[2],2):"")+(l?","+this.encodeNumber(t[o][3]-r[3],0):""),s.push(i),r=t[o])}return s.join(";")}for(o=0;o<t.length;o++)t[o]=this.encodeCoordinates(t[o],e);return t}return this.encodeCoordinates([0,0],e)},ol.format.GeoJSONX.prototype.decodeCoordinates=function(t,e){var o,i;if("string"==typeof t){if((t=t.split(";")).length>1){var n=Math.pow(10,e),r=[0,0,0,0];return t.forEach(function(o,i){t[i]=o.split(","),t[i][0]=Math.round((this.decodeNumber(t[i][0],e)+r[0])*n)/n,t[i][1]=Math.round((this.decodeNumber(t[i][1],e)+r[1])*n)/n,t[i].length>2&&(t[i][2]=Math.round((this.decodeNumber(t[i][2],2)+r[2])*n)/n),t[i].length>3&&(t[i][3]=Math.round((this.decodeNumber(t[i][3],0)+r[3])*n)/n),r=t[i]}.bind(this)),t}return t=t[0].split(","),i=[this.decodeNumber(t[0],e),this.decodeNumber(t[1],e)],t.length>2&&(i[2]=this.decodeNumber(t[2],2)),t.length>3&&(i[3]=this.decodeNumber(t[3],0)),i}if(t.length){var s=[];for(o=0;o<t.length;o++)s[o]=this.decodeCoordinates(t[o],e);return s}return[0,0]},ol.format.GeoJSONX.prototype.writeFeaturesObject=function(t,e){e=e||{},this._count=0,this._hash={};var o=ol.format.GeoJSON.prototype.writeFeaturesObject.call(this,t,e);o.decimals=this._decimals,o.hashProperties=[],Object.keys(this._hash).forEach(function(t){o.hashProperties.push(t)}.bind(this)),this._count=0,this._hash={};var i=o.features;return delete o.features,o.features=i,o},ol.format.GeoJSONX.prototype.writeFeatureObject=function(t,e){var o=ol.format.GeoJSON.prototype.writeFeatureObject.call(this,t,e);if("Feature"!==o.type)throw"GeoJSONX doesn't support "+o.type+".";var i,n=[];if("Point"===o.geometry.type)n.push(this.encodeCoordinates(o.geometry.coordinates,this._decimals));else if("MultiPoint"===o.geometry.type){var r=[];o.geometry.coordinates.forEach(function(t){r.push(this.encodeCoordinates(t,this._decimals))}.bind(this)),n.push([this._type[o.geometry.type],r.join(";")])}else{if(!this._type[o.geometry.type])throw"GeoJSONX doesn't support "+o.geometry.type+".";n.push([this._type[o.geometry.type],this.encodeCoordinates(o.geometry.coordinates,this._decimals)])}var s=[];for(i in o.properties)this._whiteList(i)&&!this._blackList(i)&&(this._hash.hasOwnProperty(i)||(this._hash[i]=this._count,this._count++),(!this._deleteNull||this._deleteNull.indexOf(o.properties[i])<0)&&s.push(this._hash[i],o.properties[i]));if((s.length||this._extended)&&n.push(s),this._extended){var a=!1;for(i in s={},o)/^type$|^geometry$|^properties$/.test(i)||(s[i]=o[i],a=!0);a&&n.push(s)}return n},ol.format.GeoJSONX.prototype.writeGeometryObject=function(t,e){var o=ol.format.GeoJSON.prototype.writeGeometryObject.call(this,t,e);return"Point"===o.type?this.encodeCoordinates(o.coordinates,this._decimals):[this._type[o.type],this.encodeCoordinates(o.coordinates,this._decimals)]},ol.format.GeoJSONX.prototype.readFeaturesFromObject=function(t,e){if(this._hashProperties=t.hashProperties||[],(e=e||{}).decimals=parseInt(t.decimals),!e.decimals&&0!==e.decimals)throw"Bad file format...";return ol.format.GeoJSON.prototype.readFeaturesFromObject.call(this,t,e)},ol.format.GeoJSONX.prototype.readFeatureFromObject=function(t,e){var o={type:"Feature"};if("string"==typeof t[0])o.geometry={type:"Point",coordinates:this.decodeCoordinates(t[0],"number"==typeof e.decimals?e.decimals:this.decimals)};else if(o.geometry={type:this._toType[t[0][0]]},"MultiPoint"===o.geometry.type){var i=o.geometry.coordinates=[];t[0][1].split(";").forEach(function(t){t=t.split(","),i.push([this.decodeNumber(t[0],e.decimals),this.decodeNumber(t[1],e.decimals)])}.bind(this))}else o.geometry.coordinates=this.decodeCoordinates(t[0][1],"number"==typeof e.decimals?e.decimals:this.decimals);if(this._hashProperties&&t[1]){o.properties={};for(var n=t[1],r=0;r<n.length;r+=2)o.properties[this._hashProperties[n[r]]]=n[r+1]}else o.properties=t[1];if(t[2])for(var s in t[2])o[s]=t[2][s];return ol.format.GeoJSON.prototype.readFeatureFromObject.call(this,o,e)},ol.format.GeoJSONP=function(t){t=t||{},ol.format.GeoJSONX.call(this,t),this._lineFormat=new ol.format.Polyline({factor:Math.pow(10,t.decimals||6)})},ol.ext.inherits(ol.format.GeoJSONP,ol.format.GeoJSONX),ol.format.GeoJSONP.prototype.encodeCoordinates=function(t){var e;if("number"==typeof t[0])return e=new ol.geom.Point(t),this._lineFormat.writeGeometry(e);if(t.length&&t[0]){if("number"==typeof t[0][0])return e=new ol.geom.LineString(t),this._lineFormat.writeGeometry(e);for(var o=[],i=0;i<t.length;i++)o[i]=this.encodeCoordinates(t[i]);return o}return this.encodeCoordinates([0,0])},ol.format.GeoJSONP.prototype.decodeCoordinates=function(t){var e,o;if("string"==typeof t)return(o=this._lineFormat.readGeometry(t)).getCoordinates()[0];if(t.length){var i=[];if("string"==typeof t[0])for(e=0;e<t.length;e++)o=this._lineFormat.readGeometry(t[e]),i[e]=o.getCoordinates();else for(e=0;e<t.length;e++)i[e]=this.decodeCoordinates(t[e]);return i}return null},ol.format.GeoRSS=function(t){t=t||{},ol.Object.call(this,t)},ol.ext.inherits(ol.format.GeoRSS,ol.Object),ol.format.GeoRSS.prototype.readFeature=function(t,e){e=e||{};for(var o,i=t.children,n=new ol.Feature,r=0;o=i[r];r++)n.set(o.tagName,o.innerHTML);var s,a,l=[];if(n.get("geo:long"))a=new ol.geom.Point([parseFloat(n.get("geo:long")),parseFloat(n.get("geo:lat"))]),n.unset("geo:long"),n.unset("geo:lat");else if(n.get("georss:point"))l=n.get("georss:point").trim().split(" "),a=new ol.geom.Point([parseFloat(l[1]),parseFloat(l[0])]),n.unset("georss:point");else{if(!n.get("georss:polygon"))return n.get("georss:where")?(console.warn("[GeoRSS] GML format not implemented"),n.unset("georss:where"),null):(console.warn("[GeoRSS] unknown geometry"),null);s=n.get("georss:polygon").trim().split(" ");for(var c=0;c<s.length;c+=2)l.push([parseFloat(s[c+1]),parseFloat(s[c])]);a=new ol.geom.Polygon([l]),n.unset("georss:polygon")}return(e.featureProjection||this.get("featureProjection"))&&a.transform(e.dataProjection||this.get("dataProjection")||"EPSG:4326",e.featureProjection||this.get("featureProjection")),n.setGeometry(a),n},ol.format.GeoRSS.prototype.readFeatures=function(t,e){var o;if("string"==typeof t){var i=(new DOMParser).parseFromString(t,"text/xml");o=i.getElementsByTagName(this.getDocumentItemsTagName(i))}else if(t instanceof Document)o=t.getElementsByTagName(this.getDocumentItemsTagName(t));else{if(!(t instanceof Node))return[];o=t}for(var n,r=[],s=0;n=o[s];s++){var a=this.readFeature(n,e);a&&r.push(a)}return r},ol.format.GeoRSS.prototype.getDocumentItemsTagName=function(t){switch(t.documentElement.tagName){case"feed":return"entry";default:return"item"}},ol.interaction.Clip=function(t){this.layers_=[],ol.interaction.Pointer.call(this,{handleDownEvent:this._setPosition,handleMoveEvent:this._setPosition}),this.precomposeBind_=this.precompose_.bind(this),this.postcomposeBind_=this.postcompose_.bind(this),t=t||{},this.pos=!1,this.radius=t.radius||100,t.layers&&this.addLayer(t.layers)},ol.ext.inherits(ol.interaction.Clip,ol.interaction.Pointer),ol.interaction.Clip.prototype.setMap=function(t){var e;if(this.getMap()){for(e=0;e<this.layers_.length;e++)this.layers_[e].un(["precompose","prerender"],this.precomposeBind_),this.layers_[e].un(["postcompose","postrender"],this.postcomposeBind_);try{this.getMap().renderSync()}catch(t){}}if(ol.interaction.Pointer.prototype.setMap.call(this,t),t){for(e=0;e<this.layers_.length;e++)this.layers_[e].on(["precompose","prerender"],this.precomposeBind_),this.layers_[e].on(["postcompose","postrender"],this.postcomposeBind_);try{t.renderSync()}catch(t){}}},ol.interaction.Clip.prototype.setRadius=function(t){if(this.radius=t,this.getMap())try{this.getMap().renderSync()}catch(t){}},ol.interaction.Clip.prototype.getRadius=function(){return this.radius},ol.interaction.Clip.prototype.addLayer=function(t){t instanceof Array||(t=[t]);for(var e=0;e<t.length;e++){if(this.getMap()){t[e].on(["precompose","prerender"],this.precomposeBind_),t[e].on(["postcompose","postrender"],this.postcomposeBind_);try{this.getMap().renderSync()}catch(t){}}this.layers_.push(t[e])}},ol.interaction.Clip.prototype.removeLayers=function(){this.removeLayer(this.layers_)},ol.interaction.Clip.prototype.removeLayer=function(t){t instanceof Array||(t=[t]);for(var e=0;e<t.length;e++){var o;for(o=0;o<this.layers_.length&&this.layers_[o]!==t[e];o++);o!=this.layers_.length&&this.getMap()&&(this.layers_[o].un(["precompose","prerender"],this.precomposeBind_),this.layers_[o].un(["postcompose","postrender"],this.postcomposeBind_),this.layers_.splice(o,1))}if(this.getMap())try{this.getMap().renderSync()}catch(t){}},ol.interaction.Clip.prototype.setPosition=function(t){if(this.getMap()){this.pos=this.getMap().getPixelFromCoordinate(t);try{this.getMap().renderSync()}catch(t){}}},ol.interaction.Clip.prototype.getPosition=function(){return this.pos?this.getMap().getCoordinateFromPixel(this.pos):null},ol.interaction.Clip.prototype.setPixelPosition=function(t){if(this.pos=t,this.getMap())try{this.getMap().renderSync()}catch(t){}},ol.interaction.Clip.prototype.getPixelPosition=function(){return this.pos},ol.interaction.Clip.prototype._setPosition=function(t){if(("pointermove"!==t.type||"onclick"!==this.get("action"))&&(t.pixel&&(this.pos=t.pixel),this.getMap()))try{this.getMap().renderSync()}catch(t){}},ol.interaction.Clip.prototype.precompose_=function(t){if(this.getActive()){var e=t.context,o=t.frameState.pixelRatio;e.save(),e.beginPath();var i=[this.pos[0],this.pos[1]],n=this.radius,r=t.inversePixelTransform;r?n=(i=[i[0]*r[0]-i[1]*r[1]+r[4],-i[0]*r[2]+i[1]*r[3]+r[5]])[0]-((this.pos[0]-n)*r[0]-this.pos[1]*r[1]+r[4]):(i[0]*=o,i[1]*=o,n*=o),e.arc(i[0],i[1],n,0,2*Math.PI),e.clip()}},ol.interaction.Clip.prototype.postcompose_=function(t){this.getActive()&&t.context.restore()},ol.interaction.Clip.prototype.setActive=function(t){if(t!==this.getActive()){var e;if(ol.interaction.Pointer.prototype.setActive.call(this,t),t)for(e=0;e<this.layers_.length;e++)this.layers_[e].on(["precompose","prerender"],this.precomposeBind_),this.layers_[e].on(["postcompose","postrender"],this.postcomposeBind_);else for(e=0;e<this.layers_.length;e++)this.layers_[e].un(["precompose","prerender"],this.precomposeBind_),this.layers_[e].un(["postcompose","postrender"],this.postcomposeBind_);if(this.getMap())try{this.getMap().renderSync()}catch(t){}}},ol.interaction.CurrentMap=function(t){var e=(t=t||{}).condition||function(){return!0};ol.interaction.Interaction.call(this,{handleEvent:function(t){return e(t)&&(this.isCurrentMap()||(this.setCurrentMap(this.getMap()),this.dispatchEvent({type:"focus",map:this.getMap()}),this.getMap().dispatchEvent({type:"focus",map:this.getMap()}))),!0}.bind(this)}),t.onKeyDown&&document.addEventListener("keydown",function(e){this.isCurrentMap()&&!/INPUT|TEXTAREA|SELECT/.test(document.activeElement.tagName)&&t.onKeyDown({type:e.type,map:this.getMap(),originalEvent:e})}.bind(this)),t.onKeyPress&&document.addEventListener("keydown",function(e){this.isCurrentMap()&&!/INPUT|TEXTAREA|SELECT/.test(document.activeElement.tagName)&&t.onKeyPress({type:e.type,map:this.getMap(),originalEvent:e})}.bind(this)),t.onKeyUp&&document.addEventListener("keydown",function(e){this.isCurrentMap()&&!/INPUT|TEXTAREA|SELECT/.test(document.activeElement.tagName)&&t.onKeyUp({type:e.type,map:this.getMap(),originalEvent:e})}.bind(this))},ol.ext.inherits(ol.interaction.CurrentMap,ol.interaction.Interaction),ol.interaction.CurrentMap.prototype._currentMap=void 0,ol.interaction.CurrentMap.prototype.isCurrentMap=function(){return this.getMap()===ol.interaction.CurrentMap.prototype._currentMap},ol.interaction.CurrentMap.prototype.getCurrentMap=function(){return ol.interaction.CurrentMap.prototype._currentMap},ol.interaction.CurrentMap.prototype.setCurrentMap=function(t){ol.interaction.CurrentMap.prototype._currentMap=t},ol.interaction.Blob=function(t){ol.interaction.Clip.call(this,t)},ol.ext.inherits(ol.interaction.Blob,ol.interaction.Clip),ol.interaction.Blob.prototype.precompose_=function(t){if(this.getActive()){var e=t.context,o=t.frameState.pixelRatio;if(e.save(),!this.pos)return e.beginPath(),e.moveTo(0,0),void e.clip();var i=[this.pos[0],this.pos[1]],n=t.inversePixelTransform;n?i=[i[0]*n[0]-i[1]*n[1]+n[4],-i[0]*n[2]+i[1]*n[3]+n[5]]:(i[0]*=o,i[1]*=o),this.frame||(this.frame=t.frameState.time);var r=t.frameState.time-this.frame;this.frame=t.frameState.time,i=this._getCenter(i,r);var s=this._calculate(r),a=s[0];e.beginPath(),e.moveTo(i[0]+a[0],i[1]+a[1]);for(var l=1;a=s[l];l++)e.lineTo(i[0]+a[0],i[1]+a[1]);e.clip(),t.frameState.animate=!0}},ol.interaction.Blob.prototype._getCenter=function(t,e){if(this._center){var o=this.get("stiffness")||20,i=-1*(this.get("damping")||7),n=Math.max(this.get("mass")||1,.1),r=Math.min(e/1e3,1/30),s=[o*(t[0]-this._center[0]),o*(t[1]-this._center[1])],a=[i*this._velocity[0],i*this._velocity[1]],l=[(s[0]+a[0])/n,(s[1]+a[1])/n];this._velocity[0]+=l[0]*r,this._velocity[1]+=l[1]*r,this._center[0]+=this._velocity[0]*r,this._center[1]+=this._velocity[1]*r}else this._center=t,this._velocity=[0,0];return this._center},ol.interaction.Blob.prototype._calculate=function(t){var e,o=this.get("points")||10;if(!this._waves||this._waves.length!==o)for(this._waves=[],e=0;e<o;e++)this._waves.push({angle:Math.random()*Math.PI,noise:Math.random()});var i=[],n=(this._velocity[0]*this._velocity[0]+this._velocity[1]*this._velocity[1])/500;for(this._rotation=(this._rotation||0)+(this._velocity[0]>0?1:-1)*Math.min(.015,n/7e4*t),e=0;e<o;e++){var r=2*e*Math.PI/o+this._rotation,s=this.radius+Math.min(this.radius,n),a=Math.cos(this._waves[e].angle)*s/4*this._waves[e].noise*(this.get("amplitude")||1);i.push([(this.radius+a)*Math.cos(r),(this.radius+a)*Math.sin(r)]),this._waves[e].angle+=(Math.PI+Math.random()+n/200)/350*t*(this.get("fuss")||1),this._waves[e].noise=Math.min(1,Math.max(0,this._waves[e].noise+.1*(Math.random()-.5)*(this.get("fuss")||1)))}return i.push(i[0]),ol.coordinate.cspline(i,{tension:this.get("tension")})},ol.interaction.CenterTouch=function(t){t=t||{},this._listener={};var e=/^pointermove$|^pointerup$/;this.ctouch=new ol.interaction.Interaction({handleEvent:function(t){return e.test(t.type)&&this.getMap()&&(t.coordinate=this.getMap().getView().getCenter(),t.pixel=this.getMap().getSize(),t.pixel=[t.pixel[0]/2,t.pixel[1]/2]),!0}}),this._target=new ol.control.Target({style:t.targetStyle,composite:t.composite}),ol.interaction.Interaction.call(this,{handleEvent:function(o){return e.test(o.type)&&(this.pos_=o.coordinate),!t.handleEvent||t.handleEvent.call(this,o)}})},ol.ext.inherits(ol.interaction.CenterTouch,ol.interaction.Interaction),ol.interaction.CenterTouch.prototype.setMap=function(t){this.getMap()&&(this.getMap().removeInteraction(this.ctouch),this.getMap().removeInteraction(this._target)),ol.interaction.Interaction.prototype.setMap.call(this,t),this.getMap()&&this.getActive()&&(this.getMap().addInteraction(this.ctouch),this.getMap().addControl(this._target))},ol.interaction.CenterTouch.prototype.setActive=function(t){ol.interaction.Interaction.prototype.setActive.call(this,t),this.pos_=null,this.getMap()&&(this.getActive()?(this.getMap().addInteraction(this.ctouch),this.getMap().addControl(this._target)):(this.getMap().removeInteraction(this.ctouch),this.getMap().removeControl(this._target)))},ol.interaction.CenterTouch.prototype.getPosition=function(){if(!this.pos_){var t=this.getMap().getSize();t=[t[0]/2,t[1]/2],this.pos_=this.getMap().getCoordinateFromPixel(t)}return this.pos_},ol.interaction.ClipMap=function(t){this.layers_=[],ol.interaction.Pointer.call(this,{handleDownEvent:this._clip,handleMoveEvent:this._clip}),t=t||{},this.pos=!1,this.radius=t.radius||100,this.pos=[-1e3,-1e3]},ol.ext.inherits(ol.interaction.ClipMap,ol.interaction.Pointer),ol.interaction.ClipMap.prototype.setMap=function(t){this.getMap()&&(this._listener&&ol.Observable.unByKey(this._listener),this.getMap().getViewport().querySelector(".ol-layers").style.clipPath="");ol.interaction.Pointer.prototype.setMap.call(this,t),t&&(this._listener=t.on("change:size",this._clip.bind(this)))},ol.interaction.ClipMap.prototype.setRadius=function(t){this.radius=t,this._clip()},ol.interaction.ClipMap.prototype.getRadius=function(){return this.radius},ol.interaction.ClipMap.prototype.setPosition=function(t){this.getMap()&&(this.pos=this.getMap().getPixelFromCoordinate(t),this._clip())},ol.interaction.ClipMap.prototype.getPosition=function(){return this.pos?this.getMap().getCoordinateFromPixel(this.pos):null},ol.interaction.ClipMap.prototype.setPixelPosition=function(t){this.pos=t,this._clip()},ol.interaction.ClipMap.prototype.getPixelPosition=function(){return this.pos},ol.interaction.ClipMap.prototype._setPosition=function(t){if(("pointermove"!==t.type||"onclick"!==this.get("action"))&&(t.pixel&&(this.pos=t.pixel),this.getMap()))try{this.getMap().renderSync()}catch(t){}},ol.interaction.ClipMap.prototype._clip=function(t){(t&&t.pixel&&(this.pos=t.pixel),this.pos&&this.getMap())&&(this.getMap().getViewport().querySelector(".ol-layers").style.clipPath="circle("+this.getRadius()+"px at "+this.pos[0]+"px "+this.pos[1]+"px)")},ol.interaction.CopyPaste=function(t){t=t||{},this.features=[],this._cloneFeature=!0;var e=t.condition;"function"!=typeof e&&(e=function(t){if(t.originalEvent.ctrlKey){if(/^c$/i.test(t.originalEvent.key))return"copy";if(/^x$/i.test(t.originalEvent.key))return"cut";if(/^v$/i.test(t.originalEvent.key))return"paste"}return!1}),this._featuresSource=t.features||new ol.Collection,this.setSources(t.sources),this.setDestination(t.destination),ol.interaction.CurrentMap.call(this,{condition:t.mapCondition,onKeyDown:function(t){switch(e(t)){case"copy":this.copy({silent:!1});break;case"cut":this.copy({cut:!0,silent:!1});break;case"paste":this.paste({silent:!1})}}.bind(this)})},ol.ext.inherits(ol.interaction.CopyPaste,ol.interaction.CurrentMap),ol.interaction.CopyPaste.prototype.setSources=function(t){t?(this._source=[],this._source=t instanceof Array?t:[t]):this._source=null},ol.interaction.CopyPaste.prototype.getSources=function(){return this._source},ol.interaction.CopyPaste.prototype.setDestination=function(t){this._destination=t},ol.interaction.CopyPaste.prototype.getDestination=function(){return this._destination},ol.interaction.CopyPaste.prototype.getFeatures=function(){return this.features},ol.interaction.CopyPaste.prototype.copy=function(t){var e=(t=t||{}).features||this._featuresSource.getArray();if(t.cut){var o=this._source||[this._destination];e.forEach(function(t){o.forEach(function(e){try{e.removeFeature(t)}catch(t){}})})}this._cloneFeature?(this.features=[],e.forEach(function(t){this.features.push(t.clone())}.bind(this))):this.features=e,!1===t.silent&&this.dispatchEvent({type:t.cut?"cut":"copy",time:(new Date).getTime()})},ol.interaction.CopyPaste.prototype.paste=function(t){var e=(t=t||{}).features||this.features;if(e){var o=t.destination||this._destination;o&&(o.addFeatures(this.features),this._cloneFeature&&this.copy({features:this.features}))}!1===t.silent&&this.dispatchEvent({type:"paste",features:e,time:(new Date).getTime()})},ol.interaction.Delete=function(t){ol.interaction.Select.call(this,t),this.on("select",function(t){this.getFeatures().clear(),this.delete(t.selected)}.bind(this))},ol.ext.inherits(ol.interaction.Delete,ol.interaction.Select),ol.interaction.Delete.prototype._getSources=function(t){if(!this.getMap())return[];t||(t=this.getMap().getLayers());var e=[];return t.forEach(function(t){t.getLayers?e=e.concat(this._getSources(t.getLayers())):t.getSource&&t.getSource()instanceof ol.source.Vector&&e.push(t.getSource())}.bind(this)),e},ol.interaction.Delete.prototype.delete=function(t){if(t&&(t.length||t.getLength())){this.dispatchEvent({type:"deletestart",features:t});var e=[];this._getSources().forEach(function(o){try{t.forEach(function(t){o.removeFeature(t),e.push(t)})}catch(t){}}),this.dispatchEvent({type:"deleteend",features:e})}},ol.interaction.DragOverlay=function(t){t||(t={});var e=t.offset||[0,0];ol.interaction.Pointer.call(this,{handleDownEvent:function(o){var i=o.frameState.viewState.resolution,n=[o.coordinate[0]+e[0]*i,o.coordinate[1]-e[1]*i];return/^(BUTTON|A)$/.test(o.originalEvent.target.tagName)?(this._dragging=!1,!0):!!this._dragging&&(!1!==t.centerOnClick?this._dragging.setPosition(n,!0):n=this._dragging.getPosition(),this.dispatchEvent({type:"dragstart",overlay:this._dragging,originalEvent:o.originalEvent,frameState:o.frameState,coordinate:n}),!0)},handleDragEvent:function(t){var o=t.frameState.viewState.resolution,i=[t.coordinate[0]+e[0]*o,t.coordinate[1]-e[1]*o];this._dragging&&(this._dragging.setPosition(i,!0),this.dispatchEvent({type:"dragging",overlay:this._dragging,originalEvent:t.originalEvent,frameState:t.frameState,coordinate:i}))},handleUpEvent:function(t){var o=t.frameState.viewState.resolution,i=[t.coordinate[0]+e[0]*o,t.coordinate[1]-e[1]*o];return!!this._dragging&&(this.dispatchEvent({type:"dragend",overlay:this._dragging,originalEvent:t.originalEvent,frameState:t.frameState,coordinate:i}),this._dragging=!1,!0)}}),this._overlays=[],t.overlays instanceof Array||(t.overlays=[t.overlays]),t.overlays.forEach(this.addOverlay.bind(this))},ol.ext.inherits(ol.interaction.DragOverlay,ol.interaction.Pointer),ol.interaction.DragOverlay.prototype.addOverlay=function(t){for(var e,o=0;e=this._overlays[o];o++)if(e===t)return;if(t.element.parentElement&&t.element.parentElement.classList.contains("ol-overlaycontainer-stopevent"))console.warn("[DragOverlay.addOverlay] overlay must be created with stopEvent set to false!");else{var i=function(){this.getMap()===t.getMap()&&(this._dragging=t)}.bind(this);this._overlays.push({overlay:t,listener:i}),t.element.addEventListener("pointerdown",i)}},ol.interaction.DragOverlay.prototype.removeOverlay=function(t){for(var e,o=0;e=this._overlays[o];o++)if(e.overlay===t){var i=this._overlays.splice(o,1)[0];t.element.removeEventListener("pointerdown",i.listener);break}},ol.interaction.DrawHole=function(t){t||(t={});var e=this;this._select=new ol.interaction.Select({style:t.style}),this._select.setActive(!1);var o,i=t.geometryFunction;if(o=i?function(t,o){return o=e._geometryFn(t,o),i(t,o)}:function(t,o){return e._geometryFn(t,o)},t.type="Polygon",t.geometryFunction=o,ol.interaction.Draw.call(this,t),t.layers&&("function"==typeof t.layers?this.layers_=t.layers:t.layers.indexOf&&(this.layers_=function(e){return t.layers.indexOf(e)>=0})),"function"==typeof t.featureFilter)this._features=t.featureFilter;else if(t.featureFilter){var n=t.featureFilter;this._features=function(t){return n.indexOf?!!n[n.indexOf(t)]:!!n.item(n.getArray().indexOf(t))}}else this._features=function(){return!0};this.on("drawstart",this._startDrawing.bind(this)),this.on("drawend",this._finishDrawing.bind(this))},ol.ext.inherits(ol.interaction.DrawHole,ol.interaction.Draw),ol.interaction.DrawHole.prototype.setMap=function(t){this.getMap()&&this.getMap().removeInteraction(this._select),t&&t.addInteraction(this._select),ol.interaction.Draw.prototype.setMap.call(this,t)},ol.interaction.DrawHole.prototype.setActive=function(t){this._select.getFeatures().clear(),ol.interaction.Draw.prototype.setActive.call(this,t)},ol.interaction.DrawHole.prototype.removeLastPoint=function(){this._feature&&this._feature.getGeometry().getCoordinates()[0].length>2&&ol.interaction.Draw.prototype.removeLastPoint.call(this)},ol.interaction.DrawHole.prototype.getPolygon=function(){return this._polygon},ol.interaction.DrawHole.prototype._startDrawing=function(t){var e=this.getMap();this._feature=t.feature;var o=t.feature.getGeometry().getCoordinates()[0][0];this._current=null,e.forEachFeatureAtPixel(e.getPixelFromCoordinate(o),function(t,e){if(!this._current&&this._features(t,e)){var i=t.getGeometry();if("Polygon"===i.getType()&&i.intersectsCoordinate(o))this._polygonIndex=!1,this._polygon=i,this._current=t;else if("MultiPolygon"===i.getType()&&i.intersectsCoordinate(o))for(var n,r=0;n=i.getPolygon(r);r++)if(n.intersectsCoordinate(o)){this._polygonIndex=r,this._polygon=n,this._current=t;break}}}.bind(this),{layerFilter:this.layers_}),this._select.getFeatures().clear(),this._current?this._select.getFeatures().push(this._current):(this.setActive(!1),this.setActive(!0))},ol.interaction.DrawHole.prototype._finishDrawing=function(t){t.hole=t.feature,t.feature=this._select.getFeatures().item(0),this.dispatchEvent({type:"modifystart",features:[this._current]});var e=t.hole.getGeometry().getCoordinates()[0];if(e.length>3)if(!1!==this._polygonIndex){for(var o,i=t.feature.getGeometry(),n=new ol.geom.MultiPolygon([]),r=0;o=i.getPolygon(r);r++)r===this._polygonIndex?(o.appendLinearRing(new ol.geom.LinearRing(e)),n.appendPolygon(o)):n.appendPolygon(o);t.feature.setGeometry(n)}else this.getPolygon().appendLinearRing(new ol.geom.LinearRing(e));this.dispatchEvent({type:"modifyend",features:[this._current]}),this._feature=null,this._select.getFeatures().clear()},ol.interaction.DrawHole.prototype._geometryFn=function(t,e){var o=t[0].pop();return this.getPolygon()&&!this.getPolygon().intersectsCoordinate(o)||(this.lastOKCoord=[o[0],o[1]]),t[0].push([this.lastOKCoord[0],this.lastOKCoord[1]]),e?e.setCoordinates([t[0].concat([t[0][0]])]):e=new ol.geom.Polygon(t),e},ol.interaction.DrawRegular=function(t){t||(t={}),this.squaredClickTolerance_=t.clickTolerance?t.clickTolerance*t.clickTolerance:36,this.maxCircleCoordinates_=t.maxCircleCoordinates||100,this.features_=t.features,this.source_=t.source,this.conditionFn_=t.condition,this.squareFn_=t.squareCondition,this.centeredFn_=t.centerCondition,this.canRotate_=!1!==t.canRotate,this.geometryName_=t.geometryName,this.setSides(t.sides);var e=ol.style.Style.defaultStyle(!0);this.sketch_=new ol.Collection,this.overlayLayer_=new ol.layer.Vector({source:new ol.source.Vector({features:this.sketch_,useSpatialIndex:!1}),name:"DrawRegular overlay",displayInLayerSwitcher:!1,style:t.style||e}),ol.interaction.Interaction.call(this,{handleEvent:this.handleEvent_})},ol.ext.inherits(ol.interaction.DrawRegular,ol.interaction.Interaction),ol.interaction.DrawRegular.prototype.setMap=function(t){this.getMap()&&this.getMap().removeLayer(this.overlayLayer_),ol.interaction.Interaction.prototype.setMap.call(this,t),this.overlayLayer_.setMap(t)},ol.interaction.DrawRegular.prototype.setActive=function(t){this.reset(),ol.interaction.Interaction.prototype.setActive.call(this,t)},ol.interaction.DrawRegular.prototype.reset=function(){this.overlayLayer_.getSource().clear(),this.started_=!1},ol.interaction.DrawRegular.prototype.setSides=function(t){t=parseInt(t),this.sides_=t>2?t:0},ol.interaction.DrawRegular.prototype.canRotate=function(t){return!0!==t&&!1!==t||(this.canRotate_=t),this.canRotate_},ol.interaction.DrawRegular.prototype.getSides=function(){return this.sides_},ol.interaction.DrawRegular.prototype.startAngle={default:Math.PI/2,3:-Math.PI/2,4:Math.PI/4},ol.interaction.DrawRegular.prototype.getGeom_=function(){if(this.overlayLayer_.getSource().clear(),!this.center_)return!1;var t;if(this.coord_){var e,o,i,n,r,s=this.center_,a=this.coord_;if(!this.sides_&&this.square_&&!this.centered_)return s=[(a[0]+s[0])/2,(a[1]+s[1])/2],e=[a[0]-s[0],a[1]-s[1]],i=Math.sqrt(e[0]*e[0]+e[1]*e[1]),n=new ol.geom.Circle(s,i,"XY"),r=this.getMap().getPixelFromCoordinate(s),o=Math.max(100,Math.abs(r[0]-this.coordPx_[0]),Math.abs(r[1]-this.coordPx_[1])),o=Math.min(this.maxCircleCoordinates_,Math.round(o/3)),ol.geom.Polygon.fromCircle(n,o,0);var l=this.canRotate_&&this.centered_&&this.square_;if(e=[a[0]-s[0],a[1]-s[1]],this.square_&&!l){var c=Math.max(Math.abs(e[0]),Math.abs(e[1]));a=[s[0]+(e[0]>0?c:-c),s[1]+(e[1]>0?c:-c)]}if((i=Math.sqrt(e[0]*e[0]+e[1]*e[1]))>0){var h;if(n=new ol.geom.Circle(s,i,"XY"),h=l?Math.atan2(e[1],e[0]):this.startAngle[this.sides_]||this.startAngle.default,this.sides_?t=ol.geom.Polygon.fromCircle(n,this.sides_,h):(r=this.getMap().getPixelFromCoordinate(this.center_),o=Math.max(100,Math.abs(r[0]-this.coordPx_[0]),Math.abs(r[1]-this.coordPx_[1])),o=Math.min(this.maxCircleCoordinates_,Math.round(o/(this.centered_?3:5))),t=ol.geom.Polygon.fromCircle(n,o,0)),l)return t;var p=t.getExtent(),u=((s=this.centered_?[2*this.center_[0]-this.coord_[0],2*this.center_[1]-this.coord_[1]]:this.center_)[0]-a[0])/(p[0]-p[2]),g=(s[1]-a[1])/(p[1]-p[3]);if(this.square_){var d=Math.min(Math.abs(u),Math.abs(g));u=Math.sign(u)*d,g=Math.sign(g)*d}var m=[s[0]-p[0]*u,s[1]-p[1]*g];return t.applyTransform(function(t,e,o){for(var i=0;i<t.length;i+=o)e[i]=t[i]*u+m[0],e[i+1]=t[i+1]*g+m[1];return e}),t}}return new ol.geom.Point(this.center_)},ol.interaction.DrawRegular.prototype.drawSketch_=function(t){if(this.overlayLayer_.getSource().clear(),t){this.square_=this.squareFn_?this.squareFn_(t):t.originalEvent.shiftKey,this.centered_=this.centeredFn_?this.centeredFn_(t):t.originalEvent.metaKey||t.originalEvent.ctrlKey;var e=this.getGeom_();if(e){var o=this.feature_;return"Polygon"===e.getType()&&o.getGeometry().setCoordinates(e.getCoordinates()),this.overlayLayer_.getSource().addFeature(o),this.coord_&&this.square_&&(this.canRotate_&&this.centered_&&this.coord_||!this.sides_&&!this.centered_)&&this.overlayLayer_.getSource().addFeature(new ol.Feature(new ol.geom.LineString([this.center_,this.coord_]))),o}}},ol.interaction.DrawRegular.prototype.drawPoint_=function(t,e){e||this.overlayLayer_.getSource().clear(),this.overlayLayer_.getSource().addFeature(new ol.Feature(new ol.geom.Point(t)))},ol.interaction.DrawRegular.prototype.handleEvent_=function(t){var e,o;switch(this._eventTime=new Date,t.type){case"pointerdown":if(this.conditionFn_&&!this.conditionFn_(t))break;this.downPx_=t.pixel,this.start_(t);this._longTouch=!1,setTimeout(function(){this._longTouch=new Date-this._eventTime>450,this._longTouch&&this.handleMoveEvent_(t)}.bind(this),500);break;case"pointerup":this.started_&&this.coord_&&(e=this.downPx_[0]-t.pixel[0])*e+(o=this.downPx_[1]-t.pixel[1])*o<=this.squaredClickTolerance_&&("pointermove"==this.lastEvent||"keydown"==this.lastEvent?this.end_(t):(e=this.upPx_[0]-t.pixel[0])*e+(o=this.upPx_[1]-t.pixel[1])*o<=this.squaredClickTolerance_?this.end_(t):(this.handleMoveEvent_(t),this.drawPoint_(t.coordinate,!0))),this.upPx_=t.pixel;break;case"pointerdrag":if(this.started_){var i=this.getMap().getPixelFromCoordinate(this.center_);(e=i[0]-t.pixel[0])*e+(o=i[1]-t.pixel[1])*o<=this.squaredClickTolerance_&&this.reset()}return!this._longTouch;case"pointermove":this.started_&&(e=this.downPx_[0]-t.pixel[0])*e+(o=this.downPx_[1]-t.pixel[1])*o>this.squaredClickTolerance_&&(this.handleMoveEvent_(t),this.lastEvent=t.type);break;default:if(this.lastEvent=t.type,this.started_&&"dblclick"===t.type)return!1}return!0},ol.interaction.DrawRegular.prototype.finishDrawing=function(){this.started_&&this.coord_&&this.end_({pixel:this.upPx_,coordinate:this.coord_})},ol.interaction.DrawRegular.prototype.handleMoveEvent_=function(t){if(this.started_){this.coord_=t.coordinate,this.coordPx_=t.pixel;var e=this.drawSketch_(t);this.dispatchEvent({type:"drawing",feature:e,pixel:t.pixel,startCoordinate:this.center_,coordinate:t.coordinate,square:this.square_,centered:this.centered_})}else this.drawPoint_(t.coordinate)},ol.interaction.DrawRegular.prototype.start_=function(t){if(this.started_)this.coord_=t.coordinate;else{this.started_=!0,this.center_=t.coordinate,this.coord_=null;var e=this.feature_=new ol.Feature({});e.setGeometryName(this.geometryName_),e.setGeometry(new ol.geom.Polygon([[t.coordinate,t.coordinate,t.coordinate]])),this.drawSketch_(t),this.dispatchEvent({type:"drawstart",feature:e,pixel:t.pixel,coordinate:t.coordinate})}},ol.interaction.DrawRegular.prototype.end_=function(t){if(this.coord_=t.coordinate,this.started_=!1,!this.coord_||this.center_[0]===this.coord_[0]&&this.center_[1]===this.coord_[1])this.dispatchEvent({type:"drawcancel",feature:null,pixel:t.pixel,coordinate:t.coordinate,square:this.square_,centered:this.centered_});else{var e=this.feature_;e.setGeometry(this.getGeom_()),this.source_?this.source_.addFeature(e):this.features_&&this.features_.push(e),this.dispatchEvent({type:"drawend",feature:e,pixel:t.pixel,coordinate:t.coordinate,square:this.square_,centered:this.centered_})}this.center_=this.coord_=null,this.drawSketch_()},ol.interaction.DrawTouch=function(t){(t=t||{}).handleEvent=function(t){if(this.get("tap"))switch(this.sketch.setPosition(this.getPosition()),t.type){case"singleclick":this.addPoint();break;case"dblclick":return this.addPoint(),this.finishDrawing(),!1}return!0},t.sketchStyle||(t.sketchStyle=ol.style.Style.defaultStyle());var e=this.sketch=new ol.layer.SketchOverlay(t);e.on(["drawstart","drawabort"],function(t){this.dispatchEvent(t)}.bind(this)),e.on(["drawend"],function(e){e.feature&&e.valid&&t.source&&t.source.addFeature(e.feature),this.dispatchEvent(e)}.bind(this)),ol.interaction.CenterTouch.call(this,t),this._source=t.source,this.set("tap",!1!==t.tap)},ol.ext.inherits(ol.interaction.DrawTouch,ol.interaction.CenterTouch),ol.interaction.DrawTouch.prototype.setMap=function(t){if(this._listener)for(var e in this._listener)ol.Observable.unByKey(e);this._listener={},ol.interaction.CenterTouch.prototype.setMap.call(this,t),this.sketch.setMap(t),t&&(this._listener.center=t.on("postcompose",function(){ol.coordinate.equal(this.getPosition(),this.sketch.getPosition()||[])||this.sketch.setPosition(this.getPosition())}.bind(this)))},ol.interaction.DrawTouch.prototype.setGeometryType=function(t){return this.sketch.setGeometryType(t)},ol.interaction.DrawTouch.prototype.getGeometryType=function(){return this.sketch.getGeometryType()},ol.interaction.DrawTouch.prototype.finishDrawing=function(){this.sketch.finishDrawing(!0)},ol.interaction.DrawTouch.prototype.addPoint=function(){this.sketch.addPoint(this.getPosition())},ol.interaction.DrawTouch.prototype.removeLastPoint=function(){this.sketch.removeLastPoint()},ol.interaction.DrawTouch.prototype.setActive=function(t){ol.interaction.CenterTouch.prototype.setActive.call(this,t),this.sketch.abortDrawing(),this.sketch.setVisible(t)},ol.interaction.DropFile=function(t){t=t||{},ol.interaction.DragAndDrop.call(this,{});var e=t.zone||document;e.addEventListener("dragenter",this.onstop),e.addEventListener("dragover",this.onstop),e.addEventListener("dragleave",this.onstop),this.formatConstructors_=t.formatConstructors||[ol.format.GPX,ol.format.GeoJSONX,ol.format.GeoJSONP,ol.format.GeoJSON,ol.format.IGC,ol.format.KML,ol.format.TopoJSON],this.projection_=t.projection,this.accept_=t.accept||["gpx","json","geojsonx","geojsonp","geojson","igc","kml","topojson"];var o=this;e.addEventListener("drop",function(t){return o.ondrop(t)})},ol.ext.inherits(ol.interaction.DropFile,ol.interaction.DragAndDrop),ol.interaction.DropFile.prototype.setMap=function(t){ol.interaction.Interaction.prototype.setMap.call(this,t)},ol.interaction.DropFile.prototype.onstop=function(t){return t.preventDefault(),t.stopPropagation(),!1},ol.interaction.DropFile.prototype.ondrop=function(t){if(t.preventDefault(),t.dataTransfer&&t.dataTransfer.files.length)for(var e,o=this,i=this.projection_||(this.getMap()?this.getMap().getView().getProjection():null),n=t.dataTransfer.files,r=/\.([0-9a-z]+)(?=[?#])|(\.)(?:[\w]+)$/,s=0;e=n[s];s++){var a=e.name.match(r)[0],l=this.accept_.indexOf(a.toLocaleLowerCase())>=0;if(o.dispatchEvent({type:"loadstart",file:e,filesize:e.size,filetype:e.type,fileextension:a,projection:i,isok:l}),this.formatConstructors_.length){var c=new FileReader,h=this.formatConstructors_,p=e;c.onload=function(t){var e,n,r=t.target.result,s=[];for(e=0,n=h.length;e<n;++e){var a=h[e];try{if((s=(new a).readFeatures(r,{featureProjection:i}))&&s.length>0)return o.dispatchEvent({type:"addfeatures",features:s,file:p,projection:i}),void o.dispatchEvent({type:"loadend",features:s,file:p,projection:i})}catch(t){}}o.dispatchEvent({type:"loadend",file:p,result:r})},c.readAsText(e)}}return!1},ol.interaction.FillAttribute=function(t,e){if((t=t||{}).condition||(t.condition=ol.events.condition.click),ol.interaction.Select.call(this,t),this.setActive(!1!==t.active),this.set("name",t.name),this._attributes=e,this.on("select",function(t){this.getFeatures().clear(),this.fill(t.selected,this._attributes)}.bind(this)),void 0===t.cursor){var o=document.createElement("CANVAS");o.width=o.height=32;var i=o.getContext("2d");i.beginPath(),i.moveTo(9,3),i.lineTo(2,9),i.lineTo(10,17),i.lineTo(17,11),i.closePath(),i.fillStyle="#fff",i.fill(),i.stroke(),i.beginPath(),i.moveTo(6,4),i.lineTo(0,8),i.lineTo(0,13),i.lineTo(3,17),i.lineTo(3,8),i.closePath(),i.fillStyle="#000",i.fill(),i.stroke(),i.moveTo(8,8),i.lineTo(10,0),i.lineTo(11,0),i.lineTo(13,3),i.lineTo(13,7),i.stroke(),this._cursor="url("+o.toDataURL()+") 0 13, auto"}t.cursor&&(this._cursor=t.cursor)},ol.ext.inherits(ol.interaction.FillAttribute,ol.interaction.Select),ol.interaction.FillAttribute.prototype.setCursor=function(t){this._cursor=t},ol.interaction.FillAttribute.prototype.getCursor=function(){return this._cursor},ol.interaction.FillAttribute.prototype.setActive=function(t){t!==this.getActive()&&(ol.interaction.Select.prototype.setActive.call(this,t),this.getMap()&&this._cursor&&(t?(this._previousCursor=this.getMap().getTargetElement().style.cursor,this.getMap().getTargetElement().style.cursor=this._cursor):(this.getMap().getTargetElement().style.cursor=this._previousCursor,this._previousCursor=void 0)))},ol.interaction.FillAttribute.prototype.setAttributes=function(t){this._attributes=t},ol.interaction.FillAttribute.prototype.setAttribute=function(t,e){this._attributes[t]=e},ol.interaction.FillAttribute.prototype.getAttributes=function(){return this._attributes},ol.interaction.FillAttribute.prototype.getAttribute=function(t){return this._attributes[t]},ol.interaction.FillAttribute.prototype.fill=function(t,e){if(t.length&&e){for(var o,i=!1,n=0;o=t[n];n++){for(var r in e)o.get(r)!==e[r]&&(i=!0);if(i)break}i&&(this.dispatchEvent({type:"setattributestart",features:t,properties:e}),t.forEach(function(t){for(var o in e)t.set(o,e[o])}),this.dispatchEvent({type:"setattributeend",features:t,properties:e}))}},ol.interaction.Flashlight=function(t){ol.interaction.Pointer.call(this,{handleDownEvent:this.setPosition,handleMoveEvent:this.setPosition}),t=t||{},this.pos=!1,this.radius=t.radius||100,this.setColor(t)},ol.ext.inherits(ol.interaction.Flashlight,ol.interaction.Pointer),ol.interaction.Flashlight.prototype.setMap=function(t){this.getMap()&&this.getMap().render(),this._listener&&ol.Observable.unByKey(this._listener),this._listener=null,ol.interaction.Pointer.prototype.setMap.call(this,t),t&&(this._listener=t.on("postcompose",this.postcompose_.bind(this)))},ol.interaction.Flashlight.prototype.setRadius=function(t){if(this.radius=t,this.getMap())try{this.getMap().renderSync()}catch(t){}},ol.interaction.Flashlight.prototype.setColor=function(t){var e=t.fill?t.fill:[0,0,0,.8],o=ol.color.asArray(e);if(this.startColor=ol.color.asString(o),t.color?o=this.endColor=ol.color.asString(ol.color.asArray(t.color)||t.color):(o[3]=0,this.endColor=ol.color.asString(o)),o[3]=.1,this.midColor=ol.color.asString(o),this.getMap())try{this.getMap().renderSync()}catch(t){}},ol.interaction.Flashlight.prototype.setPosition=function(t){if(t.pixel?this.pos=t.pixel:this.pos=t,this.getMap())try{this.getMap().renderSync()}catch(t){}},ol.interaction.Flashlight.prototype.postcompose_=function(t){var e=ol.ext.getMapCanvas(this.getMap()).getContext("2d"),o=t.frameState.pixelRatio,i=e.canvas.width,n=e.canvas.height;if(e.save(),e.scale(o,o),this.pos){var r=Math.max(i,n),s=e.createRadialGradient(this.pos[0],this.pos[1],i*this.radius/r,this.pos[0],this.pos[1],n*this.radius/r);s.addColorStop(0,this.startColor),s.addColorStop(.8,this.midColor),s.addColorStop(1,this.endColor),e.fillStyle=s,e.fillRect(this.pos[0]-r,this.pos[1]-r,2*r,2*r)}else e.fillStyle=this.startColor,e.fillRect(0,0,i,n);e.restore()},ol.interaction.FocusMap=function(){ol.interaction.Interaction.call(this,{}),this.focusBt=ol.ext.element.create("BUTTON",{on:{focus:function(){this.dispatchEvent({type:"focus"})}.bind(this)},style:{position:"absolute",zIndex:-1,top:0,opacity:0}})},ol.ext.inherits(ol.interaction.FocusMap,ol.interaction.Interaction),ol.interaction.FocusMap.prototype.setMap=function(t){this._listener&&ol.Observable.unByKey(this._listener),this._listener=null,this.getMap()&&this.getMap().getViewport().removeChild(this.focusBt),ol.interaction.Interaction.prototype.setMap.call(this,t),this.getMap()&&(this._listener=this.getMap().on("pointerdown",function(){this.getActive()&&this.focusBt.focus()}.bind(this)),this.getMap().getViewport().appendChild(this.focusBt))},ol.interaction.GeolocationDraw=function(t){t||(t={}),this.geolocation=new ol.Geolocation({projection:"EPSG:4326",trackingOptions:{maximumAge:1e4,enableHighAccuracy:!0,timeout:6e5}}),this.geolocation.on("change",this.draw_.bind(this)),this.path_=[],this.lastPosition_=!1;var e=[255,255,255,1],o=[0,153,255,1],i=new ol.style.Circle({radius:6,fill:new ol.style.Fill({color:o}),stroke:new ol.style.Stroke({color:e,width:1.5})}),n=[new ol.style.Style({stroke:new ol.style.Stroke({color:e,width:5})}),new ol.style.Style({stroke:new ol.style.Stroke({color:o,width:3}),fill:new ol.style.Fill({color:[255,255,255,.5]})})],r=new ol.style.RegularShape({radius:10.5,points:3,rotation:0,fill:new ol.style.Fill({color:o}),stroke:new ol.style.Stroke({color:e,width:1.5})}),s=r.getImage(),a=s.getContext("2d"),l=document.createElement("canvas");l.width=l.height=s.width,l.getContext("2d").drawImage(s,0,0),a.clearRect(0,0,s.width,s.height),a.drawImage(l,0,0,s.width,s.height,3,0,s.width-6,s.height);this.locStyle={error:new ol.style.Style({fill:new ol.style.Fill({color:[255,0,0,.2]})}),warn:new ol.style.Style({fill:new ol.style.Fill({color:[255,192,0,.2]})}),ok:new ol.style.Style({fill:new ol.style.Fill({color:[0,255,0,.2]})})},this.overlayLayer_=new ol.layer.Vector({source:new ol.source.Vector,name:"GeolocationDraw overlay",style:t.style||function(t){return void 0===t.get("heading")?n[1].setImage(i):(n[1].setImage(r),r.setRotation(t.get("heading")||0)),n}}),this.sketch_=[new ol.Feature,new ol.Feature,new ol.Feature],this.overlayLayer_.getSource().addFeatures(this.sketch_),this.features_=t.features,this.source_=t.source,this.condition_=t.condition||function(t){return t.getAccuracy()<this.get("minAccuracy")},ol.interaction.Interaction.call(this,{handleEvent:function(){return!this.get("followTrack")||"auto"==this.get("followTrack")}}),this.set("type",t.type||"LineString"),this.set("attributes",t.attributes||{}),this.set("minAccuracy",t.minAccuracy||20),this.set("tolerance",t.tolerance||5),this.set("zoom",t.zoom),this.set("minZoom",t.minZoom),this.setFollowTrack(void 0===t.followTrack||t.followTrack),this.setActive(!1)},ol.ext.inherits(ol.interaction.GeolocationDraw,ol.interaction.Interaction),ol.interaction.GeolocationDraw.prototype.simplify3D=function(t,e){var o=t.getCoordinates(),i=this.getMap().getView().getProjection();"Polygon"===this.get("type")&&(o=o[0]);for(var n,r=[o[0]],s=ol.proj.transform(o[0],i,"EPSG:4326"),a=1;a<o.length;a++){n=ol.proj.transform(o[a],i,"EPSG:4326"),ol.sphere.getDistance(s,n)>e&&(r.push(o[a]),s=n)}return r[r.length-1]!==o[o.length-1]&&r.push(o[o.length-1]),t="Polygon"===this.get("type")?new ol.geom.Polygon([r],"XYZM"):new ol.geom.LineString(r,"XYZM")},ol.interaction.GeolocationDraw.prototype.setMap=function(t){this.getMap()&&this.getMap().removeLayer(this.overlayLayer_),ol.interaction.Pointer.prototype.setMap.call(this,t),this.overlayLayer_.setMap(t),t&&this.geolocation.setProjection(t.getView().getProjection())},ol.interaction.GeolocationDraw.prototype.setActive=function(t){if(t!==this.getActive()){if(ol.interaction.Interaction.prototype.setActive.call(this,t),this.overlayLayer_.setVisible(t),this.getMap()){this.geolocation.setTracking(t);try{this.getMap().renderSync()}catch(t){}}if(this.pause(!t),t)this.reset(),this.dispatchEvent({type:"drawstart",feature:this.sketch_[1]});else{var e=this.sketch_[1].clone();e.getGeometry()&&(this.features_&&this.features_.push(e),this.source_&&this.source_.addFeature(e)),this.dispatchEvent({type:"drawend",feature:e})}}},ol.interaction.GeolocationDraw.prototype.simulate=function(t,e){if(this._track&&clearTimeout(this._track.timeout),t){var o=(e=e||{}).delay||1e3;this._track={track:t,pos:0,timeout:setTimeout(function t(){if(this._track.pos>=this._track.track.length)this._track=!1;else{var i=this._track.track[this._track.pos];i[2]=i[3]||0,i[3]=(new Date).getTime(),this._track.pos++,!1!==e.repeat&&(this._track.pos=this._track.pos%this._track.track.length),this.getActive()&&this.draw_(!0,i,e.accuracy),this._track.timeout=setTimeout(t.bind(this),o)}}.bind(this),0)}}else this._track=!1},ol.interaction.GeolocationDraw.prototype.simulating=function(){return!!this._track},ol.interaction.GeolocationDraw.prototype.reset=function(){this.sketch_[1].setGeometry(),this.path_=[],this.lastPosition_=!1},ol.interaction.GeolocationDraw.prototype.start=function(){this.setActive(!0)},ol.interaction.GeolocationDraw.prototype.stop=function(){this.setActive(!1)},ol.interaction.GeolocationDraw.prototype.pause=function(t){this.pause_=!1!==t},ol.interaction.GeolocationDraw.prototype.isPaused=function(){return this.pause_},ol.interaction.GeolocationDraw.prototype.setFollowTrack=function(t){this.set("followTrack",t);var e,o=this.getMap();if(this.getActive()&&o)if("position"!==t&&(e=this.get("minZoom")?Math.max(this.get("minZoom"),o.getView().getZoom()):this.get("zoom")),!1===t||this.lastPosition_)"auto"===t&&this.lastPosition_&&o.getView().animate({center:this.lastPosition_,zoom:e});else{var i=this.path_[this.path_.length-1];i&&o.getView().animate({center:i,zoom:e})}this.lastPosition_=!1,this.dispatchEvent({type:"follow",following:!1!==t})},ol.interaction.GeolocationDraw.prototype.draw_=function(t,e,o){var i=this.getMap();if(i){var n,r,s,a,l;if(this._track){if(!0!==t)return;if(r=e,n=o||10,this.path_&&this.path_.length){var c=this.path_[this.path_.length-1];l=Math.atan2(e[0]-c[0],e[1]-c[1])}var h=new ol.geom.Circle(r,i.getView().getResolution()*n);s=ol.geom.Polygon.fromCircle(h)}else n=(a=this.geolocation).getAccuracy(),r=this.getPosition(a),s=a.getAccuracyGeometry(),l=a.getHeading();switch(this.get("followTrack")){case!0:1==this.get("followTrack")&&(this.get("minZoom")?this.get("minZoom")>i.getView().getZoom()&&i.getView().setZoom(this.get("minZoom")):i.getView().setZoom(this.get("zoom")||16),ol.extent.containsExtent(i.getView().calculateExtent(i.getSize()),s.getExtent())||i.getView().fit(s.getExtent())),i.getView().setCenter(r);break;case"position":i.getView().setCenter(r);break;case"auto":if(this.lastPosition_){var p=i.getView().getCenter();p[0]!=this.lastPosition_[0]||p[1]!=this.lastPosition_[1]?this.setFollowTrack(!1):(i.getView().setCenter(r),this.lastPosition_=r)}else i.getView().setCenter(r),this.get("minZoom")?this.get("minZoom")>i.getView().getZoom()&&i.getView().setZoom(this.get("minZoom")):this.get("zoom")&&i.getView().setZoom(this.get("zoom")),this.lastPosition_=r;break;case"visible":ol.extent.containsCoordinate(i.getView().calculateExtent(i.getSize()),r)||i.getView().setCenter(r)}var u,g=this.sketch_[0];if(g.setGeometry(s),n<this.get("minAccuracy")/2?g.setStyle(this.locStyle.ok):n<this.get("minAccuracy")?g.setStyle(this.locStyle.warn):g.setStyle(this.locStyle.error),this.pause_&&(this.lastPosition_=r),!this.pause_&&(!a||this.condition_.call(this,a))){switch(g=this.sketch_[1],this.path_.push(r),this.get("type")){case"Point":this.path_=[r],g.setGeometry(new ol.geom.Point(r,"XYZM"));var d=this.get("attributes");d.heading&&g.set("heading",a.getHeading()),d.accuracy&&g.set("accuracy",a.getAccuracy()),d.altitudeAccuracy&&g.set("altitudeAccuracy",a.getAltitudeAccuracy()),d.speed&&g.set("speed",a.getSpeed());break;case"LineString":this.path_.length>1?(u=new ol.geom.LineString(this.path_,"XYZM"),this.get("tolerance")&&(u=this.simplify3D(u,this.get("tolerance"))),g.setGeometry(u)):g.setGeometry();break;case"Polygon":this.path_.length>2?(u=new ol.geom.Polygon([this.path_],"XYZM"),this.get("tolerance")&&(u=this.simplify3D(u,this.get("tolerance"))),g.setGeometry(u)):g.setGeometry()}this.dispatchEvent({type:"drawing",feature:this.sketch_[1],geolocation:a})}this.sketch_[2].setGeometry(new ol.geom.Point(r)),this.sketch_[2].set("heading",l),this.dispatchEvent({type:"tracking",feature:this.sketch_[1],geolocation:a})}},ol.interaction.GeolocationDraw.prototype.getPosition=function(t){var e=t.getPosition();return e.push(Math.round(100*(t.getAltitude()||0))/100),e.push(Math.round((new Date).getTime()/1e3)),e},ol.interaction.Hover=function(t){t||(t={});var e=this,o=!1;ol.interaction.Interaction.call(this,{handleEvent:function(i){if(!e.getActive())return!0;switch(i.type){case"pointerdrag":o=!0;break;case"pointerup":o=!1;break;case"pointermove":o||e.handleMove_(i)}return!t.handleEvent||t.handleEvent(i)}}),this.setLayerFilter(t.layerFilter),t.layers&&t.layers.length&&this.setLayerFilter(function(e){return t.layers.indexOf(e)>=0}),this.setFeatureFilter(t.featureFilter),this.set("hitTolerance",t.hitTolerance),this.setCursor(t.cursor)},ol.ext.inherits(ol.interaction.Hover,ol.interaction.Interaction),ol.interaction.Hover.prototype.setMap=function(t){void 0!==this.previousCursor_&&this.getMap()&&(this.getMap().getTargetElement().style.cursor=this.previousCursor_,this.previousCursor_=void 0),ol.interaction.Interaction.prototype.setMap.call(this,t)},ol.interaction.Hover.prototype.setActive=function(t){if(ol.interaction.Interaction.prototype.setActive.call(this,t),this.cursor_&&this.getMap()&&this.getMap().getTargetElement()){var e=this.getMap().getTargetElement().style;void 0!==this.previousCursor_&&(e.cursor=this.previousCursor_,this.previousCursor_=void 0)}},ol.interaction.Hover.prototype.setCursor=function(t){!t&&void 0!==this.previousCursor_&&this.getMap()&&(this.getMap().getTargetElement().style.cursor=this.previousCursor_,this.previousCursor_=void 0),this.cursor_=t},ol.interaction.Hover.prototype.setFeatureFilter=function(t){this.featureFilter_="function"==typeof t?t:function(){return!0}},ol.interaction.Hover.prototype.setLayerFilter=function(t){this.layerFilter_="function"==typeof t?t:function(){return!0}},ol.interaction.Hover.prototype.handleMove_=function(t){var e=this.getMap();if(e){var o,i,n=this,r=e.forEachFeatureAtPixel(t.pixel,function(t,e){return n.featureFilter_.call(null,t,e)?(o=t,i=e,!0):(o=i=null,!1)},{hitTolerance:this.get("hitTolerance"),layerFilter:n.layerFilter_});if(r&&this.dispatchEvent({type:"hover",feature:o,layer:i,coordinate:t.coordinate,pixel:t.pixel,map:t.map,originalEvent:t.originalEvent,dragging:t.dragging}),this.feature_===o&&this.layer_===i||(this.feature_=o,this.layer_=i,o?this.dispatchEvent({type:"enter",feature:o,layer:i,coordinate:t.coordinate,pixel:t.pixel,map:t.map,originalEvent:t.originalEvent,dragging:t.dragging}):this.dispatchEvent({type:"leave",coordinate:t.coordinate,pixel:t.pixel,map:t.map,originalEvent:t.originalEvent,dragging:t.dragging})),this.cursor_){var s=e.getTargetElement().style;r?s.cursor!=this.cursor_&&(this.previousCursor_=s.cursor,s.cursor=this.cursor_):void 0!==this.previousCursor_&&(s.cursor=this.previousCursor_,this.previousCursor_=void 0)}}},ol.interaction.LongTouch=function(t){t||(t={}),this.delay_=t.delay||1e3;var e,o,i=t.handleLongTouchEvent||function(){},n=null,r=t.pixelTolerance||0;ol.interaction.Interaction.call(this,{handleEvent:function(t){if(this.getActive())switch(t.type){case"pointerdown":n&&clearTimeout(n),e=t.pixel,o={type:"longtouch",originalEvent:t.originalEvent,frameState:t.frameState,pixel:t.pixel,coordinate:t.coordinate,map:this.getMap()},n=setTimeout(function(){i(o),o.map.dispatchEvent(o)},this.delay_);break;case"pointerdrag":n&&(Math.abs(t.pixel[0]-e[0])>r||Math.abs(t.pixel[1]-e[1])>r)&&(clearTimeout(n),n=null);break;case"pointerup":n&&(clearTimeout(n),n=null)}else n&&(clearTimeout(n),n=null);return!0}})},ol.ext.inherits(ol.interaction.LongTouch,ol.interaction.Interaction),ol.interaction.Modify.prototype.getModifiedFeatures=function(){var t={};this.dragSegments_.forEach(function(e){var o=e[0].feature;window.ol&&window.ol.util?t[ol.util.getUid(o)]=o:t[ol.getUid(o)]=o});var e=[];for(var o in t)e.push(t[o]);return e},ol.interaction.ModifyFeature=function(t){var e,o;t||(t={}),ol.interaction.Pointer.call(this,{handleEvent:function(t){switch(t.type){case"pointerdown":return e=this.handleDownEvent(t),o=e||this._deleteCondition(t),!e;case"pointerup":return e=!1,this.handleUpEvent(t);case"pointerdrag":return!e||this.handleDragEvent(t);case"pointermove":return!!e||this.handleMoveEvent(t);case"singleclick":case"click":return!o;default:return!0}}}),this.snapDistance_=t.pixelTolerance||10,this.tolerance_=1e-10,this.cursor_=t.cursor,this.sources_=t.sources?t.sources instanceof Array?t.sources:[t.sources]:[],t.source&&this.sources_.push(t.source),t.features&&this.sources_.push(new ol.source.Vector({features:t.features})),this.filterSplit_=t.filter||function(){return!0},this._condition=t.condition||ol.events.condition.primaryAction,this._deleteCondition=t.deleteCondition||ol.events.condition.altKeyOnly,this._insertVertexCondition=t.insertVertexCondition||ol.events.condition.always;var i=function(){return[new ol.style.Style({image:new ol.style.Circle({radius:6,fill:new ol.style.Fill({color:[0,153,255,1]}),stroke:new ol.style.Stroke({color:"#FFF",width:1.25})})})]};t.style&&(i="function"==typeof t.style?t.style:function(){return t.style}),this.overlayLayer_=new ol.layer.Vector({source:new ol.source.Vector({useSpatialIndex:!1}),name:"Modify overlay",displayInLayerSwitcher:!1,style:i,wrapX:t.wrapX})},ol.ext.inherits(ol.interaction.ModifyFeature,ol.interaction.Pointer),ol.interaction.ModifyFeature.prototype.setMap=function(t){this.getMap()&&this.getMap().removeLayer(this.overlayLayer_),ol.interaction.Interaction.prototype.setMap.call(this,t),this.overlayLayer_.setMap(t)},ol.interaction.ModifyFeature.prototype.setActive=function(t){ol.interaction.Interaction.prototype.setActive.call(this,t),this.overlayLayer_&&this.overlayLayer_.getSource().clear()},ol.interaction.ModifyFeature.prototype.setFilter=function(t){"function"==typeof t?this.filterSplit_=t:void 0===t&&(this.filterSplit_=function(){return!0})},ol.interaction.ModifyFeature.prototype.getClosestFeature=function(t){for(var e,o,i=this.snapDistance_+1,n=0;n<this.sources_.length;n++){var r=this.sources_[n];if((e=r.getClosestFeatureToCoordinate(t.coordinate))&&this.filterSplit_(e)){var s=e.getGeometry().getClosestPoint(t.coordinate),a=ol.coordinate.dist2d(t.coordinate,s)/t.frameState.viewState.resolution;a<i&&(i=a,o=s);break}}if(i>this.snapDistance_)return this.currentFeature&&this.dispatchEvent({type:"select",selected:[],deselected:[this.currentFeature]}),this.currentFeature=null,!1;var l=this.getNearestCoord(o,e.getGeometry());if(l){l=l.coord;var c=this.getMap().getPixelFromCoordinate(l);return ol.coordinate.dist2d(t.pixel,c)<this.snapDistance_&&(o=l),this.currentFeature!==e&&this.dispatchEvent({type:"select",selected:[e],deselected:[this.currentFeature]}),this.currentFeature=e,{source:r,feature:e,coord:o}}},ol.interaction.ModifyFeature.prototype.getNearestCoord=function(t,e){var o,i,n,r,s;switch(e.getType()){case"Point":return{coord:e.getCoordinates(),dist:ol.coordinate.dist2d(e.getCoordinates(),t)};case"MultiPoint":return this.getNearestCoord(t,new ol.geom.LineString(e.getCoordinates()));case"LineString":case"LinearRing":var a;s=Number.MAX_VALUE;var l=e.getCoordinates();for(o=0;o<l.length;o++)(a=ol.coordinate.dist2d(t,l[o]))<s&&(s=a,r=l[o]);return{coord:r,dist:s};case"MultiLineString":var c=e.getLineStrings();for(r=!1,s=Number.MAX_VALUE,o=0;i=c[o];o++)(n=this.getNearestCoord(t,i))&&n.dist<s&&(r=n,s=n.dist,r.ring=o);return r;case"Polygon":var h=e.getLinearRings();for(r=!1,s=Number.MAX_VALUE,o=0;i=h[o];o++)(n=this.getNearestCoord(t,i))&&n.dist<s&&(r=n,s=n.dist,r.ring=o);return r;case"MultiPolygon":var p=e.getPolygons();for(r=!1,s=Number.MAX_VALUE,o=0;i=p[o];o++)(n=this.getNearestCoord(t,i))&&n.dist<s&&(r=n,s=n.dist,r.poly=o);return r;case"GeometryCollection":var u=e.getGeometries();for(r=!1,s=Number.MAX_VALUE,o=0;i=u[o];o++)(n=this.getNearestCoord(t,i))&&n.dist<s&&(r=n,s=n.dist,r.geom=o);return r;default:return!1}},ol.interaction.ModifyFeature.prototype.getArcs=function(t,e){var o,i,n,r,s,a=!1;switch(t.getType()){case"Point":ol.coordinate.equal(e,t.getCoordinates())&&(a={geom:t,type:t.getType(),coord1:[],coord2:[],node:!0});break;case"MultiPoint":for(o=t.getCoordinates(),i=0;i<o.length;i++)if(ol.coordinate.equal(e,o[i])){a={geom:t,type:t.getType(),index:i,coord1:[],coord2:[],node:!0};break}break;case"LinearRing":case"LineString":var l=t.getClosestPoint(e);if(ol.coordinate.dist2d(l,e)<1.5*this.tolerance_){var c;if((c="LinearRing"===t.getType()?(s=new ol.geom.LineString(t.getCoordinates())).splitAt(e,this.tolerance_):t.splitAt(e,this.tolerance_)).length>2){for(o=c[1].getCoordinates(),i=2;n=c[i];i++){var h=n.getCoordinates();h.shift(),o=o.concat(h)}c=[c[0],new ol.geom.LineString(o)]}if(2===c.length){var p=c[0].getCoordinates(),u=c[1].getCoordinates(),g=p.length+u.length-1;p.pop(),u.shift(),a={geom:t,type:t.getType(),coord1:p,coord2:u,node:t.getCoordinates().length===g,closed:!1}}else if(1===c.length){n=c[0].getCoordinates();var d=ol.coordinate.equal(n[0],e),m=ol.coordinate.equal(n[n.length-1],e);d?(n.shift(),m&&n.pop(),a={geom:t,type:t.getType(),coord1:[],coord2:n,node:!0,closed:m}):m&&(n.pop(),a={geom:t,type:t.getType(),coord1:n,coord2:[],node:!0,closed:!1})}}break;case"MultiLineString":var f=t.getLineStrings();for(i=0;r=f[i];i++)if(a=this.getArcs(r,e)){a.geom=t,a.type=t.getType(),a.lstring=i;break}break;case"Polygon":var y=t.getLinearRings();for(i=0;r=y[i];i++)if(a=this.getArcs(r,e)){a.geom=t,a.type=t.getType(),a.index=i;break}break;case"MultiPolygon":var v=t.getPolygons();for(i=0;r=v[i];i++)if(a=this.getArcs(r,e)){a.geom=t,a.type=t.getType(),a.poly=i;break}break;case"GeometryCollection":for(s=t.getGeometries(),i=0;r=s[i];i++)if(a=this.getArcs(r,e)){a.geom=t,a.g=i,a.typeg=a.type,a.type=t.getType();break}break;default:console.error("ol/interaction/ModifyFeature "+t.getType()+" not supported!")}return a},ol.interaction.ModifyFeature.prototype.handleDownEvent=function(t){if(!this.getActive())return!1;var e=this.getClosestFeature(t);if(e&&(this._condition(t)||this._deleteCondition(t))){var o=[];return this.arcs=[],this.sources_.forEach(function(t){var i=ol.extent.buffer(ol.extent.boundingExtent([e.coord]),this.tolerance_);o=o.concat(o,t.getFeaturesInExtent(i))}.bind(this)),this._modifiedFeatures=[],o.forEach(function(o){var i=this.getArcs(o.getGeometry(),e.coord);i&&(this._insertVertexCondition(t)||i.node)&&(i.feature=o,this._modifiedFeatures.push(o),this.arcs.push(i))}.bind(this)),!this._modifiedFeatures.length||(this._deleteCondition(t)?!this._removePoint(e,t):(this.dispatchEvent({type:"modifystart",coordinate:e.coord,originalEvent:t.originalEvent,features:this._modifiedFeatures}),this.handleDragEvent({coordinate:e.coord,originalEvent:t.originalEvent}),!0))}return!1},ol.interaction.ModifyFeature.prototype.getModifiedFeatures=function(){return this._modifiedFeatures||[]},ol.interaction.ModifyFeature.prototype.removePoint=function(){this._removePoint({},{})},ol.interaction.ModifyFeature.prototype._getModification=function(t){var e=t.coord1.concat(t.coord2);switch(t.type){case"LineString":if(t.closed&&e.push(e[0]),e.length>1&&t.geom.getCoordinates().length!=e.length)return t.coords=e,!0;break;case"MultiLineString":if(t.closed&&e.push(e[0]),e.length>1){var o=t.geom.getCoordinates();if(o[t.lstring].length!=e.length)return o[t.lstring]=e,t.coords=o,!0}break;case"Polygon":if(t.closed&&e.push(e[0]),e.length>3&&(o=t.geom.getCoordinates())[t.index].length!=e.length)return o[t.index]=e,t.coords=o,!0;break;case"MultiPolygon":if(t.closed&&e.push(e[0]),e.length>3&&(o=t.geom.getCoordinates())[t.poly][t.index].length!=e.length)return o[t.poly][t.index]=e,t.coords=o,!0;break;case"GeometryCollection":t.type=t.typeg;var i=t.geom,n=i.getGeometries();t.geom=n[t.g];var r=this._getModification(t);return i.setGeometries(n),t.geom=i,t.type="GeometryCollection",r}return!1},ol.interaction.ModifyFeature.prototype._removePoint=function(t,e){if(!this.arcs)return!1;this.overlayLayer_.getSource().clear();var o=!1;return this.arcs.forEach(function(t){o=o||this._getModification(t)}.bind(this)),o&&(this.dispatchEvent({type:"modifystart",coordinate:t.coord,originalEvent:e.originalEvent,features:this._modifiedFeatures}),this.arcs.forEach(function(t){if("GeometryCollection"===t.geom.getType()){if(t.coords){var e=t.geom.getGeometries();e[t.g].setCoordinates(t.coords),t.geom.setGeometries(e)}}else t.coords&&t.geom.setCoordinates(t.coords)}.bind(this)),this.dispatchEvent({type:"modifyend",coordinate:t.coord,originalEvent:e.originalEvent,features:this._modifiedFeatures})),this.arcs=[],o},ol.interaction.ModifyFeature.prototype.handleUpEvent=function(t){return!!this.getActive()&&(!this.arcs||!this.arcs.length||(this.overlayLayer_.getSource().clear(),this.dispatchEvent({type:"modifyend",coordinate:t.coordinate,originalEvent:t.originalEvent,features:this._modifiedFeatures}),this.arcs=[],!0))},ol.interaction.ModifyFeature.prototype.setArcCoordinates=function(t,e){var o;switch(t.type){case"Point":t.geom.setCoordinates(e[0]);break;case"MultiPoint":(o=t.geom.getCoordinates())[t.index]=e[0],t.geom.setCoordinates(o);break;case"LineString":t.geom.setCoordinates(e);break;case"MultiLineString":(o=t.geom.getCoordinates())[t.lstring]=e,t.geom.setCoordinates(o);break;case"Polygon":(o=t.geom.getCoordinates())[t.index]=e,t.geom.setCoordinates(o);break;case"MultiPolygon":(o=t.geom.getCoordinates())[t.poly][t.index]=e,t.geom.setCoordinates(o);break;case"GeometryCollection":t.type=t.typeg;var i=t.geom,n=i.getGeometries();t.geom=n[t.g],this.setArcCoordinates(t,e),i.setGeometries(n),t.geom=i,t.type="GeometryCollection"}},ol.interaction.ModifyFeature.prototype.handleDragEvent=function(t){if(!this.getActive())return!1;if(!this.arcs)return!0;this.overlayLayer_.getSource().clear();var e=new ol.Feature(new ol.geom.Point(t.coordinate));return this.overlayLayer_.getSource().addFeature(e),!this.arcs.length||(this.arcs.forEach(function(e){var o=e.coord1.concat([t.coordinate],e.coord2);e.closed&&o.push(t.coordinate),this.setArcCoordinates(e,o)}.bind(this)),this.dispatchEvent({type:"modifying",coordinate:t.coordinate,originalEvent:t.originalEvent,features:this._modifiedFeatures}),!0)},ol.interaction.ModifyFeature.prototype.handleMoveEvent=function(t){if(!this.getActive())return!1;this.overlayLayer_.getSource().clear();var e=this.getClosestFeature(t);if(e){var o=new ol.Feature(new ol.geom.Point(e.coord));this.overlayLayer_.getSource().addFeature(o)}var i=t.map.getTargetElement();this.cursor_&&(e?i.style.cursor!=this.cursor_&&(this.previousCursor_=i.style.cursor,i.style.cursor=this.cursor_):void 0!==this.previousCursor_&&(i.style.cursor=this.previousCursor_,this.previousCursor_=void 0))},ol.interaction.ModifyFeature.prototype.getCurrentFeature=function(){return this.currentFeature},ol.interaction.ModifyTouch=function(t){var e=this;t||(t={}),this._popup=new ol.Overlay.Popup({popupClass:t.className||"modifytouch",positioning:t.positioning||"bottom-rigth",offsetBox:t.offsetBox||10}),this._source=t.source,this._features=t.features;var o=document.createElement("a");o.appendChild(document.createTextNode(t.title||"remove point")),o.onclick=function(){e.removePoint()},this.setPopupContent(o);var i=(t.pixelTolerance||0)+5;t.condition=function(t){var e,o,n=this.getMap().getFeaturesAtPixel(t.pixel,{hitTolerance:i}),r=!1;if(n){var s=this._features;if(!s){e=[t.pixel[0]-i,t.pixel[1]-i],o=[t.pixel[0]+i,t.pixel[1]+i],e=this.getMap().getCoordinateFromPixel(e),o=this.getMap().getCoordinateFromPixel(o);var a=ol.extent.boundingExtent([e,o]);s=this._source.getFeaturesInExtent(a)}s.getArray&&(s=s.getArray());for(var l,c=0;(l=n[c])&&!(s.indexOf(l)>=0);c++);if(l){e=t.pixel,o=l.getGeometry().getClosestPoint(t.coordinate),o=this.getMap().getPixelFromCoordinate(o);var h=e[0]-o[0],p=e[1]-o[1];r=Math.sqrt(h*h+p*p)<i}}return this.showDeleteBt(r?{type:"show",feature:l,coordinate:t.coordinate}:{type:"hide"}),!0},t.insertVertexCondition=function(){return this.showDeleteBt({type:"hide"}),!0},ol.interaction.Modify.call(this,t),this.on(["modifystart","modifyend"],function(){this.showDeleteBt({type:"hide",modifying:!0})}),this.set("usePopup",!1!==t.usePopup)},ol.ext.inherits(ol.interaction.ModifyTouch,ol.interaction.Modify),ol.interaction.ModifyTouch.prototype.setMap=function(t){this.getMap()&&this.getMap().removeOverlay(this._popup),ol.interaction.Modify.prototype.setMap.call(this,t),this.getMap()&&this.getMap().addOverlay(this._popup)},ol.interaction.ModifyTouch.prototype.setActive=function(t){ol.interaction.Modify.prototype.setActive.call(this,t),this.showDeleteBt({type:"hide"})},ol.interaction.ModifyTouch.prototype.removePoint=function(){new Date-this._timeout<200||(ol.interaction.Modify.prototype.removePoint.call(this),this.showDeleteBt({type:"hide"}))},ol.interaction.ModifyTouch.prototype.showDeleteBt=function(t){this.get("usePopup")&&"show"===t.type?this._popup.show(t.coordinate,this._menu):this._popup.hide(),t.type+="popup",this.dispatchEvent(t),this._timeout=new Date},ol.interaction.ModifyTouch.prototype.setPopupContent=function(t){this._menu=t},ol.interaction.ModifyTouch.prototype.getPopupContent=function(){return this._menu},ol.interaction.Offset=function(t){t||(t={}),ol.interaction.Pointer.call(this,{handleDownEvent:this.handleDownEvent_,handleDragEvent:this.handleDragEvent_,handleMoveEvent:this.handleMoveEvent_,handleUpEvent:this.handleUpEvent_}),this._filter=t.filter,this.features_=t.features,this.layers_=t.layers?t.layers instanceof Array?t.layers:[t.layers]:null,this.set("duplicate",t.duplicate),this.source_=t.source,this._style="function"==typeof t.style?t.style:function(){return t.style?t.style:ol.style.Style.defaultStyle(!0)},this.previousCursor_=!1},ol.ext.inherits(ol.interaction.Offset,ol.interaction.Pointer),ol.interaction.Offset.prototype.setMap=function(t){ol.interaction.Pointer.prototype.setMap.call(this,t)},ol.interaction.Offset.prototype.getFeatureAtPixel_=function(t){var e=this;return this.getMap().forEachFeatureAtPixel(t.pixel,function(o,i){var n;if(e._filter&&!e._filter(o,i))return!1;if(e.layers_){for(var r=0;r<e.layers_.length;r++)if(e.layers_[r]===i){n=o;break}}else e.features_?e.features_.forEach(function(t){t===o&&(n=o)}):n=o;var s=n.getGeometry().getType();if(n&&/Polygon|LineString/.test(s)){if("Polygon"===s&&n.getGeometry().getCoordinates().length>1)return!1;var a=n.getGeometry().getClosestPoint(t.coordinate),l=a[0]-t.coordinate[0],c=a[1]-t.coordinate[1];return Math.sqrt(l*l+c*c)/t.frameState.viewState.resolution<5&&{feature:n,hit:a,coordinates:n.getGeometry().getCoordinates(),geom:n.getGeometry().clone(),geomType:s}}return!1},{hitTolerance:5})},ol.interaction.Offset.prototype.handleDownEvent_=function(t){return this.current_=this.getFeatureAtPixel_(t),!!this.current_&&(this.currentStyle_=this.current_.feature.getStyle(),this.source_&&(this.get("duplicate")||t.originalEvent.ctrlKey)?(this.current_.feature=this.current_.feature.clone(),this.current_.feature.setStyle(this._style(this.current_.feature)),this.source_.addFeature(this.current_.feature)):(this.current_.feature.setStyle(this._style(this.current_.feature)),this._modifystart=!0),this.dispatchEvent({type:"offsetstart",feature:this.current_.feature,offset:0}),!0)},ol.interaction.Offset.prototype.handleDragEvent_=function(t){this._modifystart&&(this.dispatchEvent({type:"modifystart",features:[this.current_.feature]}),this._modifystart=!1);var e,o,i,n,r=this.current_.geom.getClosestPoint(t.coordinate),s=ol.coordinate.dist2d(r,t.coordinate);switch(this.current_.geomType){case"Polygon":if(e=ol.coordinate.findSegment(r,this.current_.coordinates[0]).segment){o=[e[1][0]-e[0][0],e[1][1]-e[0][1]],i=[t.coordinate[0]-r[0],t.coordinate[1]-r[1]],o[0]*i[1]-o[1]*i[0]>0&&(s=-s),n=[];for(var a=0;a<this.current_.coordinates.length;a++)n.push(ol.coordinate.offsetCoords(this.current_.coordinates[a],0==a?s:-s));this.current_.feature.setGeometry(new ol.geom.Polygon(n))}break;case"LineString":(e=ol.coordinate.findSegment(r,this.current_.coordinates).segment)&&(o=[e[1][0]-e[0][0],e[1][1]-e[0][1]],i=[t.coordinate[0]-r[0],t.coordinate[1]-r[1]],o[0]*i[1]-o[1]*i[0]>0&&(s=-s),n=ol.coordinate.offsetCoords(this.current_.coordinates,s),this.current_.feature.setGeometry(new ol.geom.LineString(n)))}this.dispatchEvent({type:"offsetting",feature:this.current_.feature,offset:s,segment:[r,t.coordinate],coordinate:t.coordinate})},ol.interaction.Offset.prototype.handleUpEvent_=function(t){this._modifystart||this.dispatchEvent({type:"offsetend",feature:this.current_.feature,coordinate:t.coordinate}),this.current_.feature.setStyle(this.currentStyle_),this.current_=!1},ol.interaction.Offset.prototype.handleMoveEvent_=function(t){this.getFeatureAtPixel_(t)?(!1===this.previousCursor_&&(this.previousCursor_=t.map.getTargetElement().style.cursor),t.map.getTargetElement().style.cursor="pointer"):(t.map.getTargetElement().style.cursor=this.previousCursor_,this.previousCursor_=!1)},ol.interaction.Ripple=function(t){ol.interaction.Pointer.call(this,{handleDownEvent:this.rainDrop,handleMoveEvent:this.rainDrop}),t=t||{},this.riprad=t.radius||3,this.ripplemap=[],this.last_map=[],this.rains(this.interval),t.layer.on(["postcompose","postrender"],this.postcompose_.bind(this))},ol.ext.inherits(ol.interaction.Ripple,ol.interaction.Pointer),ol.interaction.Ripple.prototype.rains=function(t){this.onrain&&clearTimeout(this.onrain);var e=this,o=("number"==typeof t?t:1e3)/2,i=3*o/2,n=Math.random;i&&function t(){e.width&&e.rainDrop([n()*e.width,n()*e.height]),e.onrain=setTimeout(t,n()*o+i)}()},ol.interaction.Ripple.prototype.rainDrop=function(t){if(this.width){var e,o;t.pixel?(e=t.pixel[0]*this.ratio,o=t.pixel[1]*this.ratio):(e=t[0]*this.ratio,o=t[1]*this.ratio),e<<=0;for(var i=(o<<=0)-this.riprad*this.ratio;i<o+this.riprad*this.ratio;i++)for(var n=e-this.riprad*this.ratio;n<e+this.riprad*this.ratio;n++)this.ripplemap[this.oldind+i*this.width+n]+=128}},ol.interaction.Ripple.prototype.postcompose_=function(t){var e,o,i,n,r,s=t.context,a=s.canvas;if(this.width!=a.width||this.height!=a.height){this.width=a.width,this.height=a.height,this.ratio=t.frameState.pixelRatio,this.half_width=this.width>>1,this.half_height=this.height>>1,this.size=this.width*(this.height+2)*2,this.oldind=this.width,this.newind=this.width*(this.height+3);for(var l=0;l<this.size;l++)this.last_map[l]=this.ripplemap[l]=0}this.texture=s.getImageData(0,0,this.width,this.height),this.ripple=s.getImageData(0,0,this.width,this.height);var c=this.oldind;this.oldind=this.newind,this.newind=c,l=0;for(var h=this.ripple.data,p=this.texture.data,u=0;u<this.height;u++)for(var g=0;g<this.width;g++){var d=this.newind+l,m=this.oldind+l;i=this.ripplemap[m-this.width]+this.ripplemap[m+this.width]+this.ripplemap[m-1]+this.ripplemap[m+1]>>1,i-=this.ripplemap[d],i-=i>>5,this.ripplemap[d]=i,i=1024-i,this.last_map[l]!=i&&(this.last_map[l]=i,e=((g-this.half_width)*i/1024<<0)+this.half_width,o=((u-this.half_height)*i/1024<<0)+this.half_height,e>=this.width&&(e=this.width-1),e<0&&(e=0),o>=this.height&&(o=this.height-1),o<0&&(o=0),r=4*(e+o*this.width),h[n=4*l]=p[r],h[n+1]=p[r+1],h[n+2]=p[r+2]),++l}s.putImageData(this.ripple,0,0),this.getMap().render()},ol.interaction.SelectCluster=function(t){t=t||{},this.pointRadius=t.pointRadius||12,this.circleMaxObjects=t.circleMaxObjects||10,this.maxObjects=t.maxObjects||60,this.spiral=!1!==t.spiral,this.animate=t.animate,this.animationDuration=t.animationDuration||500,this.selectCluster_=!1!==t.selectCluster,this._autoClose=!1!==t.autoClose;var e=this.overlayLayer_=new ol.layer.Vector({source:new ol.source.Vector({features:new ol.Collection,wrapX:t.wrapX,useSpatialIndex:!0}),name:"Cluster overlay",updateWhileAnimating:!0,updateWhileInteracting:!0,displayInLayerSwitcher:!1,style:t.featureStyle});if(t.layers)if("function"==typeof t.layers){var o=t.layers;t.layers=function(t){return t===e||o(t)}}else t.layers.push&&t.layers.push(this.overlayLayer_);if(t.filter){var i=t.filter;t.filter=function(t,e){return!(!e&&t.get("selectclusterlink"))&&i(t,e)}}else t.filter=function(t,e){return!(!e&&t.get("selectclusterlink"))};this.filter_=t.filter,this._autoClose||t.toggleCondition||(t.toggleCondition=ol.events.condition.singleClick),ol.interaction.Select.call(this,t),this.on("select",this.selectCluster.bind(this))},ol.ext.inherits(ol.interaction.SelectCluster,ol.interaction.Select),ol.interaction.SelectCluster.prototype.setMap=function(t){this.getMap()&&this.getMap().removeLayer(this.overlayLayer_),this._listener&&ol.Observable.unByKey(this._listener),this._listener=null,ol.interaction.Select.prototype.setMap.call(this,t),this.overlayLayer_.setMap(t),t&&t.getView()&&(this._listener=t.getView().on("change:resolution",this.clear.bind(this)))},ol.interaction.SelectCluster.prototype.clear=function(){this.getFeatures().clear(),this.overlayLayer_.getSource().clear()},ol.interaction.SelectCluster.prototype.getLayer=function(){return this.overlayLayer_},ol.interaction.SelectCluster.prototype.selectCluster=function(t){if(t instanceof ol.Feature&&(t={selected:[t]}),t.selected.length){var e=t.selected[0];if(!e.get("selectclusterfeature")){var o=this.overlayLayer_.getSource();this._autoClose&&o.clear();var i=e.get("features");if(i&&1!=i.length){this.selectCluster_||this.getFeatures().clear();var n,r,s,a,l,c,h,p=e.getGeometry().getCoordinates(),u=this.getMap().getView().getResolution(),g=[];if(!this.spiral||i.length<=this.circleMaxObjects)for(a=Math.min(i.length,this.circleMaxObjects),n=u*this.pointRadius*(.5+a/4),s=0;s<a;s++)r=2*Math.PI*s/a,2!=a&&4!=a||(r+=Math.PI/4),l=[p[0]+n*Math.sin(r),p[1]+n*Math.cos(r)],(c=new ol.Feature({selectclusterfeature:!0,features:[i[s]],geometry:new ol.geom.Point(l)})).setStyle(i[s].getStyle()),g.push(c),h=new ol.Feature({selectclusterlink:!0,geometry:new ol.geom.LineString([p,l])}),g.push(h);else{r=0;var d=2*this.pointRadius;for(a=Math.min(this.maxObjects,i.length),s=0;s<a;s++){r+=(d+.1)/(n=d/2+d*r/(2*Math.PI));var m=u*n*Math.sin(r),f=u*n*Math.cos(r);l=[p[0]+m,p[1]+f],(c=new ol.Feature({selectclusterfeature:!0,features:[i[s]],geometry:new ol.geom.Point(l)})).setStyle(i[s].getStyle()),g.push(c),h=new ol.Feature({selectclusterlink:!0,geometry:new ol.geom.LineString([p,l])}),g.push(h)}}e.set("selectcluserfeatures",g),this.animate?this.animateCluster_(p,g):o.addFeatures(g)}}}else{this._autoClose?this.clear():t.deselected.forEach(t=>{var e=t.get("selectcluserfeatures");e&&e.forEach(t=>{this.overlayLayer_.getSource().removeFeature(t)})})}},ol.interaction.SelectCluster.prototype.animateCluster_=function(t,e){if(this.listenerKey_&&ol.Observable.unByKey(this.listenerKey_),e.length){var o=this.overlayLayer_.getStyle(),i="function"==typeof o?o:o.length?function(){return o}:function(){return[o]},n=this.animationDuration||500,r=(new Date).getTime();this.listenerKey_=this.overlayLayer_.on(["postcompose","postrender"],function(o){for(var s,a=o.vectorContext||ol.render.getVectorContext(o),l=o.frameState.pixelRatio,c=this.getMap().getView().getResolution(),h=ol.easing.easeOut((o.frameState.time-r)/n),p=0;s=e[p];p++)if(s.get("features")){var u=s.getGeometry().getCoordinates();u[0]=t[0]+h*(u[0]-t[0]),u[1]=t[1]+h*(u[1]-t[1]);for(var g=new ol.geom.Point(u),d=i(s,c),m=0;m<d.length;m++){var f,y=!ol.Map.prototype.getFeaturesAtPixel&&d[m].getImage();y&&(f=y.getScale(),y.setScale(l)),a.setStyle?(a.setStyle(d[m]),a.drawGeometry(g)):(a.setImageStyle(y),a.drawPointGeometry(g)),y&&y.setScale(f)}}if(h>1)return ol.Observable.unByKey(this.listenerKey_),this.overlayLayer_.getSource().addFeatures(e),void this.overlayLayer_.changed();o.frameState.animate=!0}.bind(this));var s=new ol.Feature(new ol.geom.Point(this.getMap().getView().getCenter()));s.setStyle(new ol.style.Style({image:new ol.style.Circle({})})),this.overlayLayer_.getSource().addFeature(s)}},ol.interaction.SelectCluster.prototype.getClusterExtent=function(t){if(!t.get("features"))return null;var e=ol.extent.createEmpty();return t.get("features").forEach(function(t){e=ol.extent.extend(e,t.getGeometry().getExtent())}),e[0]===e[2]&&e[1]===e[3]?null:e},ol.interaction.SnapGuides=function(t){function e(t,e){var o=t[1][0]-t[0][0],i=t[1][1]-t[0][1],n=e[1][0]-e[0][0],r=e[1][1]-e[0][1],s=o*r-i*n;if(0!=s){var a=(o*t[0][1]-o*e[0][1]-i*t[0][0]+i*e[0][0])/s;return[e[0][0]+a*n,e[0][1]+a*r]}return!1}function o(t,e){var o=t[0]-e[0],i=t[1]-e[1];return Math.sqrt(o*o+i*i)}t||(t={}),this.snapDistance_=t.pixelTolerance||10,this.enableInitialGuides_=t.enableInitialGuides||!1;var i=[new ol.style.Style({stroke:new ol.style.Stroke({color:"#ffcc33",lineDash:[8,5],width:1.25})})];t.style&&(i=t.style instanceof Array?t.style:[t.style]),this.overlaySource_=new ol.source.Vector({features:new ol.Collection,useSpatialIndex:!1});var n=t.vectorClass||ol.layer.Vector;this.overlayLayer_=new n({renderMode:"image",source:this.overlaySource_,style:function(){return i},name:"Snap overlay",displayInLayerSwitcher:!1}),ol.interaction.Interaction.call(this,{handleEvent:function(t){if(this.getActive()){for(var i,n=this.overlaySource_.getFeatures(),r=null,s=null,a=t.frameState.viewState.resolution,l=0;i=n[l];l++){var c=i.getGeometry().getClosestPoint(t.coordinate);if(o(c,t.coordinate)/a<this.snapDistance_){if(r){var h=e(r.getGeometry().getCoordinates(),i.getGeometry().getCoordinates());h&&o(h,t.coordinate)/a<this.snapDistance_&&(s=h)}else s=c;r=i}}s&&(t.coordinate=s)}return!0}})},ol.ext.inherits(ol.interaction.SnapGuides,ol.interaction.Interaction),ol.interaction.SnapGuides.prototype.setMap=function(t){this.getMap()&&this.getMap().removeLayer(this.overlayLayer_),ol.interaction.Interaction.prototype.setMap.call(this,t),this.overlayLayer_.setMap(t),t&&(this.projExtent_=t.getView().getProjection().getExtent())},ol.interaction.SnapGuides.prototype.setActive=function(t){this.overlayLayer_.setVisible(t),ol.interaction.Interaction.prototype.setActive.call(this,t)},ol.interaction.SnapGuides.prototype.clearGuides=function(t){if(t)for(var e,o=0;e=t[o];o++)try{this.overlaySource_.removeFeature(e)}catch(t){}else this.overlaySource_.clear()},ol.interaction.SnapGuides.prototype.getGuides=function(){return this.overlaySource_.getFeaturesCollection()},ol.interaction.SnapGuides.prototype.addGuide=function(t,e){if(t){var o=this.getMap(),i=o.getView().calculateExtent(o.getSize()),n=Math.max(this.projExtent_[2]-this.projExtent_[0],this.projExtent_[3]-this.projExtent_[1]);(i=ol.extent.buffer(i,1.5*n))[0]<this.projExtent_[0]&&(i[0]=this.projExtent_[0]),i[1]<this.projExtent_[1]&&(i[1]=this.projExtent_[1]),i[2]>this.projExtent_[2]&&(i[2]=this.projExtent_[2]),i[3]>this.projExtent_[3]&&(i[3]=this.projExtent_[3]);var r=t[0][0]-t[1][0],s=t[0][1]-t[1][1],a=1/Math.sqrt(r*r+s*s),l=function(o){for(var l,c=[],h=n*o*2,p=0;(o>0?p<h:p>h)&&(l=e?[t[0][0]+s*a*p,t[0][1]-r*a*p]:[t[0][0]+r*a*p,t[0][1]+s*a*p],ol.extent.containsCoordinate(i,l));p+=n*o/100)c.push(l);return new ol.Feature(new ol.geom.LineString([c[0],c[c.length-1]]))},c=l(1),h=l(-1);return this.overlaySource_.addFeature(c),this.overlaySource_.addFeature(h),[c,h]}},ol.interaction.SnapGuides.prototype.addOrthoGuide=function(t){return this.addGuide(t,!0)},ol.interaction.SnapGuides.prototype.setDrawInteraction=function(t){var e=this,o=0,i=[];function n(t){var n=t.target.getCoordinates();switch(t.target.getType()){case"Point":return;case"Polygon":n=n[0].slice(0,-1)}var r=n.length;if(2===r&&e.enableInitialGuides_){var s=n[0][0],a=n[0][1];n=[[s,a],[s,a-1]]}if(r!=o&&(e.enableInitialGuides_?r>=2:r>2)){e.clearGuides(i);try{var l=n[r-2],c=n[r-2-1];r>2&&(l[0]!==c[0]||l[1]!==c[1])&&(i=e.addOrthoGuide([n[r-2],n[r-2-1]])),i=(i=i.concat(e.addGuide([n[0],n[1]]))).concat(e.addOrthoGuide([n[0],n[1]])),o=r}catch(t){}}}t.on("drawstart",function(t){t.feature.getGeometry().on("change",n)}),t.on(["drawend","change:active"],function(t){e.clearGuides(i),t.feature&&t.feature.getGeometry().un("change",n),o=0,i=[]})},ol.interaction.SnapGuides.prototype.setModifyInteraction=function(t){function e(t,e){return(t%e+e)%e}var o=this,i=[];function n(t){var n=t.target.vertexFeature_;if(n){var r=t.target.getModifiedFeatures()[0].getGeometry(),s=r.getCoordinates();switch(r.getType()){case"Point":return;case"Polygon":s=s[0].slice(0,-1)}var a=n.getGeometry().getCoordinates(),l=s.findIndex(function(t){return t[0]===a[0]&&t[1]===a[1]}),c=s.length;o.clearGuides(i),i=(i=(i=(i=o.addOrthoGuide([s[e(l-1,c)],s[e(l-2,c)]])).concat(o.addGuide([s[e(l-1,c)],s[e(l-2,c)]]))).concat(o.addGuide([s[e(l+1,c)],s[e(l+2,c)]]))).concat(o.addOrthoGuide([s[e(l+1,c)],s[e(l+2,c)]]))}}t.on("modifystart",function(t){setTimeout(n,0,t)}),t.on("modifyend",function(){o.clearGuides(i),i=[]})},ol.interaction.SnapLayerPixel=function(t){t=t||{},this._layer=t.layer,this._layer.on(["postcompose","postrender"],function(t){this._ctx=t.context}.bind(this));var e=t.radius||8,o=2*e;ol.interaction.Interaction.call(this,{handleEvent:function(t){if(this._layer.getVisible()&&this._layer.getOpacity()&&ol.events.condition.altKeyOnly(t)&&this.getMap()){var i,n,r,s,a=t.pixel[0]-e,l=t.pixel[1]-e,c=this._ctx.getImageData(a,l,o,o).data,h=-1,p=[];for(i=0;i<o;i++)for(p.push([]),n=0;n<o;n++){var u=c[3+4*(i+n*o)];p[i].push(u>10?u:0)}for(i=1;i<o-1;i++)for(n=1;n<o-1;n++){var g=p[i][n+1]+p[i][n]+p[i][n+1]+p[i-1][n-1]+p[i-1][n]+p[i-1][n+1]+p[i+1][n-1]+p[i+1][n]+p[i+1][n+1];g>h&&(h=g,r=i,s=n)}t.pixel=[a+r,l+s],t.coordinate=this.getMap().getCoordinateFromPixel(t.pixel)}return!0}})},ol.ext.inherits(ol.interaction.SnapLayerPixel,ol.interaction.Interaction),ol.interaction.Split=function(t){t||(t={}),ol.interaction.Interaction.call(this,{handleEvent:function(t){switch(t.type){case"singleclick":return this.handleDownEvent(t);case"pointermove":return this.handleMoveEvent(t);default:return!0}}}),this.snapDistance_=t.snapDistance||25,this.tolerance_=t.tolerance||1e-10,this.cursor_=t.cursor,this.setSources(t.sources),t.features&&this.sources_.push(new ol.source.Vector({features:t.features})),this.filterSplit_=t.filter||function(){return!0};var e=[255,255,255,1],o=[0,153,255,1],i=new ol.style.Fill({color:"rgba(255,255,255,0.4)"}),n=new ol.style.Stroke({color:"#3399CC",width:1.25}),r=[new ol.style.Style({image:new ol.style.Circle({fill:i,stroke:n,radius:5}),fill:i,stroke:n})],s=[new ol.style.Style({stroke:new ol.style.Stroke({color:e,width:5})}),new ol.style.Style({image:new ol.style.Circle({radius:6,fill:new ol.style.Fill({color:o}),stroke:new ol.style.Stroke({color:e,width:1.5})}),stroke:new ol.style.Stroke({color:o,width:3})})];t.sketchStyle&&(r=t.sketchStyle instanceof Array?t.sketchStyle:[t.sketchStyle]),t.featureStyle&&(s=t.featureStyle instanceof Array?t.featureStyle:[t.featureStyle]),this.overlayLayer_=new ol.layer.Vector({source:new ol.source.Vector({useSpatialIndex:!1}),name:"Split overlay",displayInLayerSwitcher:!1,style:function(t){return t._sketch_?r:s}})},ol.ext.inherits(ol.interaction.Split,ol.interaction.Interaction),ol.interaction.Split.prototype.setMap=function(t){this.getMap()&&this.getMap().removeLayer(this.overlayLayer_),ol.interaction.Interaction.prototype.setMap.call(this,t),this.overlayLayer_.setMap(t)},ol.interaction.Split.prototype.getSources=function(){if(!this.sources_&&this.getMap()){var t=[];return function e(o){o.forEach(function(o){o.getVisible()&&(o.getSource&&o.getSource()instanceof ol.source.Vector?t.unshift(o.getSource()):o.getLayers&&e(o.getLayers()))})}(this.getMap().getLayers()),t}return this.sources_||[]},ol.interaction.Split.prototype.setSources=function(t){this.sources_=!!t&&(t instanceof Array?t||!1:[t])},ol.interaction.Split.prototype.getClosestFeature=function(t){var e,o,i,n,r=this.snapDistance_+1;if(this.getSources().forEach(function(s){var a=s.getClosestFeatureToCoordinate(t.coordinate);if(a&&a.getGeometry().splitAt){var l=a.getGeometry().getClosestPoint(t.coordinate),c=new ol.geom.LineString([t.coordinate,l]),h=c.getLength()/t.frameState.viewState.resolution;h<r&&(e=s,r=h,o=a,n=c,i=l)}}),r>this.snapDistance_)return!1;var s=this.getNearestCoord(i,o.getGeometry().getCoordinates()),a=this.getMap().getPixelFromCoordinate(s);return ol.coordinate.dist2d(t.pixel,a)<this.snapDistance_&&(i=s),{source:e,feature:o,coord:i,link:n}},ol.interaction.Split.prototype.getNearestCoord=function(t,e){for(var o,i,n=Number.MAX_VALUE,r=0;r<e.length;r++)(o=ol.coordinate.dist2d(t,e[r]))<n&&(n=o,i=e[r]);return i},ol.interaction.Split.prototype.handleDownEvent=function(t){var e=this.getClosestFeature(t);if(e){this.overlayLayer_.getSource().clear();var o,i=e.feature.getGeometry().splitAt(e.coord,this.tolerance_);if(i.length>1){var n=[];for(o=0;o<i.length;o++){var r=e.feature.clone();r.setGeometry(i[o]),n.push(r)}for(this.dispatchEvent({type:"beforesplit",original:e.feature,features:n}),e.source.dispatchEvent({type:"beforesplit",original:e.feature,features:n}),e.source.removeFeature(e.feature),o=0;o<n.length;o++)e.source.addFeature(n[o]);this.dispatchEvent({type:"aftersplit",original:e.feature,features:n}),e.source.dispatchEvent({type:"aftersplit",original:e.feature,features:n})}}return!1},ol.interaction.Split.prototype.handleMoveEvent=function(t){var e=t.map;this.overlayLayer_.getSource().clear();var o,i,n=this.getClosestFeature(t);n&&this.filterSplit_(n.feature)?(this.overlayLayer_.getSource().addFeature(n.feature),(o=new ol.Feature(new ol.geom.Point(n.coord)))._sketch_=!0,this.overlayLayer_.getSource().addFeature(o),(i=new ol.Feature(n.link))._sketch_=!0,this.overlayLayer_.getSource().addFeature(i),this.dispatchEvent({type:"pointermove",coordinate:t.coordinate,frameState:t.frameState,originalEvent:t.originalEvent,map:t.map,pixel:t.pixel,feature:n.feature,linkGeometry:n.link})):this.dispatchEvent(t);var r=e.getTargetElement();this.cursor_&&(n?r.style.cursor!=this.cursor_&&(this.previousCursor_=r.style.cursor,r.style.cursor=this.cursor_):void 0!==this.previousCursor_&&(r.style.cursor=this.previousCursor_,this.previousCursor_=void 0))},ol.interaction.Splitter=function(t){t||(t={}),ol.interaction.Interaction.call(this,{handleEvent:function(t){return"pointermove"!=t.type&&"pointerdrag"!=t.type?(this.lastEvent_&&(this.splitSource(this.lastEvent_.feature),this.lastEvent_=null),this.moving_=!1):this.moving_=!0,!0}}),this.added_=[],this.removed_=[],t.features?this.source_=new ol.source.Vector({features:t.features}):this.source_=t.source?t.source:new ol.source.Vector({features:new ol.Collection});var e=this.triggerSource;t.triggerFeatures&&(e=new ol.source.Vector({features:t.triggerFeatures})),e?(e.on("addfeature",this.onAddFeature.bind(this)),e.on("changefeature",this.onChangeFeature.bind(this)),e.on("removefeature",this.onRemoveFeature.bind(this))):(this.source_.on("addfeature",this.onAddFeature.bind(this)),this.source_.on("changefeature",this.onChangeFeature.bind(this)),this.source_.on("removefeature",this.onRemoveFeature.bind(this))),this.tolerance_=t.tolerance||1e-10,this.filterSplit_=t.filter||function(){return!0}},ol.ext.inherits(ol.interaction.Splitter,ol.interaction.Interaction),ol.interaction.Splitter.prototype.intersectSegs=function(t,e){var o=this.tolerance_,i=t[0][0]-t[1][0],n=e[0][0]-e[1][0],r=t[0][1]-t[1][1],s=e[0][1]-e[1][1],a=i*s-r*n;if(Math.abs(a)<o)return!1;var l=((t[0][0]-e[1][0])*s-(t[0][1]-e[1][1])*n)/a;if(Math.abs(l)<o)return t[0];if(Math.abs(1-l)<o)return t[1];if(l<0||l>1)return!1;var c=((t[0][1]-e[1][1])*i-(t[0][0]-e[1][0])*r)/a;if(Math.abs(c)<o)return e[1];if(Math.abs(1-c)<o)return e[0];if(c<0||c>1)return!1;var h=t[0][0]*t[1][1]-t[0][1]*t[1][0],p=e[0][0]*e[1][1]-e[0][1]*e[1][0];return[(h*n-p*i)/a,(h*s-p*r)/a]},ol.interaction.Splitter.prototype.splitSource=function(t,e){this.getActive()&&(this.splitting||(this.source_.dispatchEvent({type:"beforesplit",feaure:t,source:this.source_}),this.dispatchEvent({type:"beforesplit",feaure:t,source:this.source_}),e?this._splitSource(t):setTimeout(function(){this._splitSource(t)}.bind(this))))},ol.interaction.Splitter.prototype._splitSource=function(t){var e,o,i;this.splitting=!0,this.added_=[],this.removed_=[];var n,r=t.getGeometry().getCoordinates(),s=[];function a(e){if(e!==t)for(var o=e.getGeometry().getCoordinates(),i=0;i<o.length-1;i++){var r=this.intersectSegs(n,[o[i],o[i+1]]);if(r&&(s.push(r),(l=e.getGeometry().splitAt(r,this.tolerance_))&&l.length>1))return h=e,!0}return!1}for(e=0;e<r.length-1;e++){n=[r[e],r[e+1]];for(var l,c=ol.extent.buffer(ol.extent.boundingExtent(n),this.tolerance_);;){var h=!1;if(this.source_.forEachFeatureIntersectingExtent(c,a.bind(this)),!h)break;var p=h;for(this.source_.removeFeature(p),o=0;o<l.length;o++)(i=p.clone()).setGeometry(l[o]),this.source_.addFeature(i)}}for(e=0;e<r.length-2;e++)for(var u=e+1;u<r.length-1;u++){var g=this.intersectSegs([r[e],r[e+1]],[r[u],r[u+1]]);g&&g!=r[e+1]&&s.push(g)}var d=!1;if(s.length){var m=t.getGeometry().splitAt(s,this.tolerance_);if(m.length>1){for(o=0;o<m.length;o++)(i=t.clone()).setGeometry(m[o]),this.source_.addFeature(i);d=!0}}setTimeout(function(){d&&this.source_.removeFeature(t),this.source_.dispatchEvent({type:"aftersplit",featureAdded:this.added_,featureRemoved:this.removed_,source:this.source_}),this.dispatchEvent({type:"aftersplit",featureAdded:this.added_,featureRemoved:this.removed_,source:this.source_}),this.splitting=!1}.bind(this))},ol.interaction.Splitter.prototype.onAddFeature=function(t){this.splitSource(t.feature),this.splitting&&this.added_.push(t.feature)},ol.interaction.Splitter.prototype.onRemoveFeature=function(t){if(this.splitting){var e=this.added_.indexOf(t.feature);-1==e?this.removed_.push(t.feature):this.added_.splice(e,1)}},ol.interaction.Splitter.prototype.onChangeFeature=function(t){this.moving_?this.lastEvent_=t:this.splitSource(t.feature,!0)},ol.interaction.Synchronize=function(t){t||(t={});var e=this;ol.interaction.Interaction.call(this,{handleEvent:function(t){return"pointermove"==t.type&&e.handleMove_(t),!0}}),this.maps=t.maps||[],!1===t.active&&this.setActive(!1)},ol.ext.inherits(ol.interaction.Synchronize,ol.interaction.Interaction),ol.interaction.Synchronize.prototype.setMap=function(t){this._listener&&(ol.Observable.unByKey(this._listener.center),ol.Observable.unByKey(this._listener.rotation),ol.Observable.unByKey(this._listener.resolution),this.getMap().getTargetElement().removeEventListener("mouseout",this._listener.mouseout)),this._listener=null,ol.interaction.Interaction.prototype.setMap.call(this,t),t&&(this._listener={},this._listener.center=this.getMap().getView().on("change:center",this.syncMaps.bind(this)),this._listener.rotation=this.getMap().getView().on("change:rotation",this.syncMaps.bind(this)),this._listener.resolution=this.getMap().getView().on("change:resolution",this.syncMaps.bind(this)),this._listener.mouseout=this.handleMouseOut_.bind(this),this.getMap().getTargetElement()&&this.getMap().getTargetElement().addEventListener("mouseout",this._listener.mouseout),this.syncMaps())},ol.interaction.Synchronize.prototype.setActive=function(t){ol.interaction.Interaction.prototype.setActive.call(this,t),this.syncMaps()},ol.interaction.Synchronize.prototype.syncMaps=function(){if(this.getActive()){var t=this.getMap();if(t){if(t.get("lockView"))return;for(var e=0;e<this.maps.length;e++)this.maps[e].set("lockView",!0),this.maps[e].getView().getRotation()!=t.getView().getRotation()&&this.maps[e].getView().setRotation(t.getView().getRotation()),this.maps[e].getView().getCenter()!=t.getView().getCenter()&&this.maps[e].getView().setCenter(t.getView().getCenter()),this.maps[e].getView().getResolution()!=t.getView().getResolution()&&this.maps[e].getView().setResolution(t.getView().getResolution()),this.maps[e].set("lockView",!1)}}},ol.interaction.Synchronize.prototype.handleMove_=function(t){for(var e=0;e<this.maps.length;e++)this.maps[e].showTarget(t.coordinate);this.getMap().showTarget()},ol.interaction.Synchronize.prototype.handleMouseOut_=function(){for(var t=0;t<this.maps.length;t++)this.maps[t]._targetOverlay&&this.maps[t]._targetOverlay.setPosition(void 0)},ol.Map.prototype.showTarget=function(t){if(!this._targetOverlay){var e=document.createElement("div");e.classList.add("ol-target"),this._targetOverlay=new ol.Overlay({element:e}),this._targetOverlay.setPositioning("center-center"),this.addOverlay(this._targetOverlay),e.parentElement.classList.add("ol-target-overlay"),this._targetOverlay.setPosition([0,0])}this._targetOverlay.setPosition(t)},ol.Map.prototype.hideTarget=function(){this.removeOverlay(this._targetOverlay),this._targetOverlay=void 0},ol.interaction.TinkerBell=function(t){t=t||{},ol.interaction.Pointer.call(this,{handleDownEvent:this.onMove,handleMoveEvent:this.onMove}),this.set("color",t.color?ol.color.asString(t.color):"#fff"),this.sparkle=[0,0],this.sparkles=[],this.lastSparkle=this.time=new Date;var e=this;this.out_=function(){e.isout_=!0},this.isout_=!0},ol.ext.inherits(ol.interaction.TinkerBell,ol.interaction.Pointer),ol.interaction.TinkerBell.prototype.setMap=function(t){this._listener&&ol.Observable.unByKey(this._listener),this._listener=null,this.getMap()&&(t.getViewport().removeEventListener("mouseout",this.out_,!1),this.getMap().render()),ol.interaction.Pointer.prototype.setMap.call(this,t),t&&(this._listener=t.on("postcompose",this.postcompose_.bind(this)),t.getViewport().addEventListener("mouseout",this.out_,!1))},ol.interaction.TinkerBell.prototype.onMove=function(t){this.sparkle=t.pixel,this.isout_=!1,this.getMap().render()},ol.interaction.TinkerBell.prototype.postcompose_=function(t){var e=t.context||ol.ext.getMapCanvas(this.getMap()).getContext("2d"),o=t.frameState.time-this.time;this.time=t.frameState.time,t.frameState.time-this.lastSparkle>30&&!this.isout_&&(this.lastSparkle=t.frameState.time,this.sparkles.push({p:[this.sparkle[0]+15*Math.random()-7.5,this.sparkle[1]+15*Math.random()],o:1})),e.save(),e.scale(t.frameState.pixelRatio,t.frameState.pixelRatio),e.fillStyle=this.get("color");for(var i,n=this.sparkles.length-1;i=this.sparkles[n];n--){if(i.o<.2){this.sparkles.splice(0,n+1);break}e.globalAlpha=i.o,e.beginPath(),e.arc(i.p[0],i.p[1],2.2,0,2*Math.PI,!1),e.fill(),i.o*=.98,i.p[0]+=Math.random()-.5,i.p[1]+=o*(1+Math.random())/30}e.restore(),this.sparkles.length&&this.getMap().render()},ol.interaction.TouchCompass=function(t){t=t||{};var e={handleDownEvent:function(t){var e=this.getCenter_(),o=t.pixel[0]-e[0],i=t.pixel[1]-e[1];return this.start=t,Math.sqrt(o*o+i*i)<this.size/2},handleDragEvent:function(t){if(!this.pos){this.pos=this.start;try{this.getMap().renderSync()}catch(t){}}this.pos=t},handleUpEvent:function(){return this.pos=!1,!0}};if(ol.interaction.Pointer.call(this,e),this.ondrag_=t.onDrag,this.size=t.size||80,this.alpha=t.alpha||.5,!ol.interaction.TouchCompass.prototype.compass){var o=ol.interaction.TouchCompass.prototype.compass=document.createElement("canvas"),i=o.getContext("2d"),n=o.width=o.height=this.size,r=n/10,s=n/2,a=.22*s;i.translate(s,s),i.fillStyle="#999",i.strokeStyle="#ccc",i.lineWidth=r,i.beginPath(),i.arc(0,0,.42*n,0,2*Math.PI),i.fill(),i.stroke(),i.fillStyle="#99f",i.beginPath(),i.moveTo(0,0),i.lineTo(s,0),i.lineTo(a,a),i.moveTo(0,0),i.lineTo(-s,0),i.lineTo(-a,-a),i.moveTo(0,0),i.lineTo(0,s),i.lineTo(-a,a),i.moveTo(0,0),i.lineTo(0,-s),i.lineTo(a,-a),i.moveTo(0,0),i.fill(),i.fillStyle="#eee",i.beginPath(),i.moveTo(0,0),i.lineTo(s,0),i.lineTo(a,-a),i.moveTo(0,0),i.lineTo(-s,0),i.lineTo(-a,a),i.moveTo(0,0),i.lineTo(0,s),i.lineTo(a,a),i.moveTo(0,0),i.lineTo(0,-s),i.lineTo(-a,-a),i.moveTo(0,0),i.fill()}},ol.ext.inherits(ol.interaction.TouchCompass,ol.interaction.Pointer),ol.interaction.TouchCompass.prototype.compass=null,ol.interaction.TouchCompass.prototype.setMap=function(t){this._listener&&ol.Observable.unByKey(this._listener),this._listener=null,ol.interaction.Pointer.prototype.setMap.call(this,t),t&&(this._listener=t.on("postcompose",this.drawCompass_.bind(this)),ol.ext.getMapCanvas(t))},ol.interaction.TouchCompass.prototype.setActive=function(t){if(ol.interaction.Pointer.prototype.setActive.call(this,t),this.getMap())try{this.getMap().renderSync()}catch(t){}},ol.interaction.TouchCompass.prototype.getCenter_=function(){var t=this.size,e=this.getMap().getSize();return[e[0]/2,e[1]-10-t/2]},ol.interaction.TouchCompass.prototype.drawCompass_=function(t){if(this.getActive()){var e=t.context||ol.ext.getMapCanvas(this.getMap()).getContext("2d"),o=t.frameState.pixelRatio;e.save(),e.scale(o,o),e.globalAlpha=this.alpha,e.strokeStyle="#fff",e.lineWidth=5;var i=this.size,n=this.getCenter_();if(e.drawImage(this.compass,0,0,this.compass.width,this.compass.height,n[0]-i/2,n[1]-i/2,i,i),this.pos)for(var r=this.pos.pixel[0]-this.start.pixel[0],s=this.pos.pixel[1]-this.start.pixel[1],a=1;a<=4;a++)e.beginPath(),e.arc(n[0]+r/4*a,n[1]+s/4*a,i/2*(.6+.4*a/4),0,2*Math.PI),e.stroke();if(e.restore(),this.pos){if(this.ondrag_){var l=this.getMap().getView().getResolution(),c={dpixel:[this.pos.pixel[0]-this.start.pixel[0],this.pos.pixel[1]-this.start.pixel[1]]};c.traction=[c.dpixel[0]*l,-c.dpixel[1]*l],this.ondrag_(c,this.pos)}t.frameState.animate=!0}}},ol.interaction.TouchCursor=function(t){t=t||{},this._listeners={};var e=[-35,-35];if(this.ctouch=new ol.interaction.Interaction({handleEvent:function(t){if(!/drag/.test(t.type)&&this.getMap())t.coordinate=this.overlay.getPosition(),t.pixel=this.getMap().getPixelFromCoordinate(t.coordinate),this._lastEvent=t;else{var o=t.frameState.viewState.resolution,i=Math.cos(t.frameState.viewState.rotation),n=Math.sin(t.frameState.viewState.rotation);t.coordinate=[t.coordinate[0]+i*e[0]*o+n*e[1]*o,t.coordinate[1]+n*e[0]*o-i*e[1]*o],t.pixel=this.getMap().getPixelFromCoordinate(t.coordinate)}return!0}.bind(this)}),this.ctouch.set("onTop",!0),this.overlay=new ol.Overlay.Fixed({className:("ol-touch-cursor "+(t.className||"")).trim(),positioning:"top-left",element:ol.ext.element.create("DIV",{}),stopEvent:!1}),ol.interaction.DragOverlay.call(this,{centerOnClick:!1,overlays:this.overlay}),this.setPosition(t.coordinate,!0),this.set("maxButtons",t.maxButtons||5),t.buttons){t.buttons.length>this.get("maxButtons")&&this.set("maxButtons",t.buttons.length);var o=this.overlay.element,i=t.buttons.length>4?0:1;t.buttons.forEach(function(t,e){e<5&&ol.ext.element.create("DIV",{className:((t.className||"")+" ol-button ol-button-"+(e+i)).trim(),html:ol.ext.element.create("DIV",{html:t.html}),click:t.click,on:t.on,parent:o})})}var n=!1,r=!1;this.on("dragstart",function(t){return this._pixel=this.getMap().getPixelFromCoordinate(this.overlay.getPosition()),r=t,!t.overlay}),this.on("dragend",function(t){return this._pixel=this.getMap().getPixelFromCoordinate(this.overlay.getPosition()),!t.overlay||(n?(this.dispatchEvent({type:"dragend",dragging:n,originalEvent:t.originalEvent,frameState:t.frameState,pixel:this._pixel,coordinate:this.overlay.getPosition()}),n=!1):t.originalEvent.target===this.overlay.element&&this.dispatchEvent({type:"click",dragging:n,originalEvent:t.originalEvent,frameState:t.frameState,pixel:this._pixel,coordinate:this.overlay.getPosition()}),!1)}.bind(this)),this.on("dragging",function(t){return this._pixel=this.getMap().getPixelFromCoordinate(this.overlay.getPosition()),!t.overlay||(n=!0,r&&(this.dispatchEvent({type:"dragstart",dragging:n,originalEvent:r.originalEvent,frameState:t.frameState,pixel:this._pixel,coordinate:r.coordinate}),r=!1),this.dispatchEvent({type:"dragging",dragging:n,originalEvent:t.originalEvent,frameState:t.frameState,pixel:this._pixel,coordinate:this.overlay.getPosition()}),!1)}.bind(this))},ol.ext.inherits(ol.interaction.TouchCursor,ol.interaction.DragOverlay),ol.interaction.TouchCursor.prototype.setMap=function(t){for(var e in this.getMap()&&(this.getMap().removeInteraction(this.ctouch),this.getActive()&&this.getMap().removeOverlay(this.overlay)),this._listeners)ol.Observable.unByKey(this._listeners[e]);this._listeners={},ol.interaction.DragOverlay.prototype.setMap.call(this,t),t&&(this.getActive()&&(t.addOverlay(this.overlay),setTimeout(function(){this.setPosition(this.getPosition()||t.getView().getCenter())}.bind(this))),t.addInteraction(this.ctouch),this._listeners.addInteraction=t.getInteractions().on("add",function(e){e.element.get("onTop")||(t.removeInteraction(this.ctouch),t.addInteraction(this.ctouch))}.bind(this)))},ol.interaction.TouchCursor.prototype.setActive=function(t,e){t!==this.getActive()?(this.ctouch.setActive(t),t?(this.getMap()&&this.getMap().addOverlay(this.overlay),e?this.setPosition(e):this.getMap()&&this.setPosition(this.getMap().getView().getCenter()),this._activate=setTimeout(function(){this.overlay.element.classList.add("active")}.bind(this),100)):(this.setPosition(),this.overlay.element.classList.remove("active"),this._activate&&clearTimeout(this._activate),this.getMap()&&this.getMap().removeOverlay(this.overlay)),ol.interaction.DragOverlay.prototype.setActive.call(this,t)):e?this.setPosition(e):this.getMap()&&this.setPosition(this.getMap().getView().getCenter())},ol.interaction.TouchCursor.prototype.setPosition=function(t){this.overlay.setPosition(t,!0),this.getMap()&&t&&(this._pixel=this.getMap().getPixelFromCoordinate(t))},ol.interaction.TouchCursor.prototype.offsetPosition=function(t){var e=this.overlay.getPosition();e&&this.overlay.setPosition([e[0]+t[0],e[1]+t[1]])},ol.interaction.TouchCursor.prototype.getPosition=function(){return this.overlay.getPosition()},ol.interaction.TouchCursor.prototype.getPixel=function(){if(this.getMap())return this.getMap().getPixelFromCoordinate(this.getPosition())},ol.interaction.TouchCursor.prototype.getOverlay=function(){return this.overlay},ol.interaction.TouchCursor.prototype.getOverlayElement=function(){return this.overlay.element},ol.interaction.TouchCursor.prototype.getButtonElement=function(t){return"number"==typeof t?this.getOverlayElement().getElementsByClassName("ol-button")[t]:this.getOverlayElement().getElementsByClassName(t)[0]},ol.interaction.TouchCursor.prototype.removeButton=function(t){if(void 0===t)for(var e=this.getOverlayElement().getElementsByClassName("ol-button"),o=e.length-1;o>=0;o--)this.getOverlayElement().removeChild(e[o]);else{var i=this.getButtonElement(t);i&&this.getOverlayElement().removeChild(i)}},ol.interaction.TouchCursor.prototype.addButton=function(t){var e=this.getOverlayElement().getElementsByClassName("ol-button"),o=this.get("maxButtons")||5;if(e.length>=o)console.error("[ol/interaction/TouchCursor~addButton] too many button on the cursor (max="+o+")...");else{var i=ol.ext.element.create("DIV",{className:((t.className||"")+" ol-button").trim(),html:ol.ext.element.create("DIV",{html:t.html}),click:t.click,on:t.on});t.before&&0!==e.length?this.getOverlayElement().insertBefore(i,e[0]):this.getOverlayElement().appendChild(i);for(var n=e.length>=o?0:1,r=0;r<e.length;r++)e[r].className=e[r].className.replace(/ol-button-\d/g,"").trim()+" ol-button-"+(r+n)}},ol.interaction.TouchCursorDraw=function(t){t=t||{};var e=this.sketch=new ol.layer.SketchOverlay({type:t.type});e.on("drawend",function(e){e.valid&&t.source&&t.source.addFeature(e.feature),this.getOverlayElement().classList.add("nodrawing"),this.dispatchEvent(e)}.bind(this)),e.on("drawstart",function(t){this.getOverlayElement().classList.remove("nodrawing"),this.dispatchEvent(t)}.bind(this)),e.on("drawabort",function(t){this.getOverlayElement().classList.add("nodrawing"),this.dispatchEvent(t)}.bind(this)),ol.interaction.TouchCursor.call(this,{className:t.className,coordinate:t.coordinate}),this.getOverlayElement().classList.add("nodrawing"),this.set("types",t.types),this.setType(t.type),this.on("click",function(){this.sketch.addPoint(this.getPosition())}.bind(this)),this.on("dragging",function(){this.sketch.setPosition(this.getPosition())}.bind(this))},ol.ext.inherits(ol.interaction.TouchCursorDraw,ol.interaction.TouchCursor),ol.interaction.TouchCursorDraw.prototype.setMap=function(t){ol.interaction.TouchCursor.prototype.setMap.call(this,t),this.sketch.setMap(t),t&&(this._listeners.movend=t.on("moveend",function(){this.sketch.setPosition(this.getPosition())}.bind(this)))},ol.interaction.TouchCursorDraw.prototype.setActive=function(t,e){ol.interaction.TouchCursor.prototype.setActive.call(this,t,e),this.sketch.abortDrawing(),this.sketch.setPosition(e),this.sketch.setVisible(t)},ol.interaction.TouchCursorDraw.prototype.setType=function(t){this.removeButton();var e=this.sketch;this.getOverlayElement().classList.remove(e.getGeometryType());var o=e.setGeometryType();t=e.setGeometryType(t),this.getOverlayElement().classList.add(t),this.dispatchEvent({type:"change:type",oldValue:o});var i=this.get("types");if(i&&i.length){var n=i[(i.indexOf(t)+1)%i.length];this.addButton({className:"ol-button-type "+n,click:function(){this.setType(n)}.bind(this)})}"Point"!==t&&(this.addButton({className:"ol-button-x",click:function(){e.abortDrawing()}}),"Circle"!==t&&(this.addButton({className:"ol-button-check",click:function(){e.finishDrawing(!0)}}),this.addButton({className:"ol-button-remove",click:function(){e.removeLastPoint()}})))},ol.interaction.TouchCursorDraw.prototype.getType=function(){return this.sketch.getGeometryType()},ol.interaction.TouchCursorModify=function(t){t=t||{};var e=!1,o=!1,i=!1,n=this._modify=new ol.interaction.ModifyFeature({source:t.source,sources:t.sources,features:t.features,pixelTolerance:t.pixelTolerance,filter:t.filter,style:t.style||[new ol.style.Style({image:new ol.style.RegularShape({points:4,radius:10,radius2:0,stroke:new ol.style.Stroke({color:[255,255,255,.5],width:3})})}),new ol.style.Style({image:new ol.style.RegularShape({points:4,radius:10,radius2:0,stroke:new ol.style.Stroke({color:[0,153,255,1],width:1.25})})})],wrapX:t.wrapX,condition:function(t){return t.dragging||o},deleteCondition:function(){return i}});ol.interaction.TouchCursor.call(this,{className:("disable "+t.className).trim(),coordinate:t.coordinate,buttons:[{className:"ol-button-move",on:{pointerdown:function(){e=!0},pointerup:function(){e=!1}}},{className:"ol-button-add",click:function(){o=!0,n.handleDownEvent(this._lastEvent),n.handleUpEvent(this._lastEvent),o=!1}.bind(this)},{className:"ol-button-remove",click:function(){i=!0,n.handleDownEvent(this._lastEvent),i=!1}.bind(this)}]}),n.on("select",function(t){t.selected.length?this.getOverlayElement().classList.remove("disable"):this.getOverlayElement().classList.add("disable")}.bind(this)),this.on("dragstart",function(){e&&n.handleDownEvent(this._lastEvent)}.bind(this)),this.on("dragging",function(t){e&&n.handleDragEvent(t)}),this.on("dragend",function(t){n.handleUpEvent(t),e=!1})},ol.ext.inherits(ol.interaction.TouchCursorModify,ol.interaction.TouchCursor),ol.interaction.TouchCursorModify.prototype.setMap=function(t){this.getMap()&&this.getMap().removeInteraction(this._modify),t&&t.addInteraction(this._modify),ol.interaction.TouchCursor.prototype.setMap.call(this,t)},ol.interaction.TouchCursorModify.prototype.setActive=function(t,e){ol.interaction.TouchCursor.prototype.setActive.call(this,t,e),this._modify.setActive(t)},ol.interaction.TouchCursorModify.prototype.getInteraction=function(){return this._modify},ol.interaction.TouchCursorSelect=function(t){t=t||{},ol.interaction.TouchCursor.call(this,{className:"ol-select "+(t.className||""),coordinate:t.coordinate}),this._selection=null,this._layerFilter=t.layerFilter,this._filter=t.filter,this._style=t.style||ol.style.Style.defaultStyle(!0),this.set("hitTolerance",t.hitTolerance||0),this.on(["change:active","dragging"],function(){this.select()})},ol.ext.inherits(ol.interaction.TouchCursorSelect,ol.interaction.TouchCursor),ol.interaction.TouchCursorSelect.prototype.setMap=function(t){ol.interaction.TouchCursor.prototype.setMap.call(this,t),t&&(this._listeners.movend=t.on("moveend",function(){this.select()}.bind(this)))},ol.interaction.TouchCursorSelect.prototype.getSelection=function(){return this._selection?this._selection.feature:null},ol.interaction.TouchCursorSelect.prototype.setPosition=function(t){ol.interaction.TouchCursor.prototype.setPosition.call(this,t),this.select()},ol.interaction.TouchCursorSelect.prototype.select=function(t){var e=this._selection;if(this.getActive()&&this.getPosition()){if(!t){var o=this.getMap().getFeaturesAtPixel(this.getPixel(),{layerFilter:this._layerFilter,filter:this._filter,hitTolerance:this.get("hitTolerance")});t=o?o[0]:null}t?e&&t===e.feature?e=null:(this._selection={feature:t,style:t.getStyle()},t.setStyle(this._style),this.dispatchEvent({type:"select",selected:[t],deselected:e?[e.feature]:[]})):(this._selection=null,this.dispatchEvent({type:"select",selected:[],deselected:e?[e.feature]:[]}))}else this._selection=null,this.dispatchEvent({type:"select",selected:[],deselected:e?[e.feature]:[]});e&&e.feature.setStyle(e.style),this._selection?this.getOverlayElement().classList.remove("disable"):this.getOverlayElement().classList.add("disable")},ol.interaction.Transform=function(t){t||(t={});var e=this;this.selection_=new ol.Collection,this.handles_=new ol.Collection,this.overlayLayer_=new ol.layer.Vector({source:new ol.source.Vector({features:this.handles_,useSpatialIndex:!1,wrapX:!1}),name:"Transform overlay",displayInLayerSwitcher:!1,style:function(t){return e.style[(t.get("handle")||"default")+(t.get("constraint")||"")+(t.get("option")||"")]}}),ol.interaction.Pointer.call(this,{handleDownEvent:this.handleDownEvent_,handleDragEvent:this.handleDragEvent_,handleMoveEvent:this.handleMoveEvent_,handleUpEvent:this.handleUpEvent_}),this.features_=t.features,"function"==typeof t.filter&&(this._filter=t.filter),this.layers_=t.layers?t.layers instanceof Array?t.layers:[t.layers]:null,this._handleEvent=t.condition||function(){return!0},this.addFn_=t.addCondition||function(){return!1},this.setPointRadius(t.pointRadius),this.set("translateFeature",!1!==t.translateFeature),this.set("translate",!1!==t.translate),this.set("translateBBox",!0===t.translateBBox),this.set("stretch",!1!==t.stretch),this.set("scale",!1!==t.scale),this.set("rotate",!1!==t.rotate),this.set("keepAspectRatio",t.keepAspectRatio||function(t){return t.originalEvent.shiftKey}),this.set("modifyCenter",t.modifyCenter||function(t){return t.originalEvent.metaKey||t.originalEvent.ctrlKey}),this.set("noFlip",t.noFlip||!1),this.set("selection",!1!==t.selection),this.set("hitTolerance",t.hitTolerance||0),this.set("enableRotatedTransform",t.enableRotatedTransform||!1),this.set("keepRectangle",t.keepRectangle||!1),this.on("propertychange",function(){this.drawSketch_()}),this.setDefaultStyle()},ol.ext.inherits(ol.interaction.Transform,ol.interaction.Pointer),ol.interaction.Transform.prototype.Cursors={default:"auto",select:"pointer",translate:"move",rotate:"move",rotate0:"move",scale:"nesw-resize",scale1:"nwse-resize",scale2:"nesw-resize",scale3:"nwse-resize",scalev:"ew-resize",scaleh1:"ns-resize",scalev2:"ew-resize",scaleh3:"ns-resize"},ol.interaction.Transform.prototype.setMap=function(t){var e=this.getMap();if(e){var o=e.getTargetElement();e.removeLayer(this.overlayLayer_),this.previousCursor_&&o&&(o.style.cursor=this.previousCursor_),this.previousCursor_=void 0}ol.interaction.Pointer.prototype.setMap.call(this,t),this.overlayLayer_.setMap(t),null===t&&this.select(null),null!==t&&(this.isTouch=/touch/.test(t.getViewport().className),this.setDefaultStyle())},ol.interaction.Transform.prototype.setActive=function(t){this.select(null),this.overlayLayer_.setVisible(t),ol.interaction.Pointer.prototype.setActive.call(this,t)},ol.interaction.Transform.prototype.setDefaultStyle=function(t){var e=(t=t||{}).pointStroke||new ol.style.Stroke({color:[255,0,0,1],width:1}),o=t.stroke||new ol.style.Stroke({color:[255,0,0,1],width:1,lineDash:[4,4]}),i=t.fill||new ol.style.Fill({color:[255,0,0,.01]}),n=t.pointFill||new ol.style.Fill({color:[255,255,255,.8]}),r=new ol.style.RegularShape({fill:n,stroke:e,radius:this.isTouch?12:6,displacement:this.isTouch?[24,-24]:[12,-12],points:15});r.setDisplacement||(r.getAnchor()[0]=this.isTouch?-10:-5);var s=new ol.style.RegularShape({fill:n,stroke:e,radius:this.isTouch?16:8,points:4,angle:Math.PI/4}),a=new ol.style.RegularShape({fill:n,stroke:e,radius:this.isTouch?12:6,points:4,angle:Math.PI/4});function l(t,e,o){return[new ol.style.Style({image:t,stroke:e,fill:o})]}this.style={default:l(s,o,i),translate:l(s,e,n),rotate:l(r,e,n),rotate0:l(s,e,n),scale:l(s,e,n),scale1:l(s,e,n),scale2:l(s,e,n),scale3:l(s,e,n),scalev:l(a,e,n),scaleh1:l(a,e,n),scalev2:l(a,e,n),scaleh3:l(a,e,n)},this.drawSketch_()},ol.interaction.Transform.prototype.setStyle=function(t,e){if(e){e instanceof Array?this.style[t]=e:this.style[t]=[e];for(var o=0;o<this.style[t].length;o++){var i=this.style[t][o].getImage();i&&("rotate"==t&&(i.getAnchor()[0]=-5),this.isTouch&&i.setScale(1.8));var n=this.style[t][o].getText();n&&("rotate"==t&&n.setOffsetX(this.isTouch?14:7),this.isTouch&&n.setScale(1.8))}this.drawSketch_()}},ol.interaction.Transform.prototype.getFeatureAtPixel_=function(t){var e=this;return this.getMap().forEachFeatureAtPixel(t,function(t,o){var i=!1;if(!o){if(t===e.bbox_)return!!e.get("translateBBox")&&{feature:t,handle:"translate",constraint:"",option:""};if(e.handles_.forEach(function(e){e===t&&(i=!0)}),i)return{feature:t,handle:t.get("handle"),constraint:t.get("constraint"),option:t.get("option")}}if(!e.get("selection"))return e.selection_.getArray().some(function(e){return t===e})?{feature:t}:null;if(e._filter)return e._filter(t,o)?{feature:t}:null;if(e.layers_){for(var n=0;n<e.layers_.length;n++)if(e.layers_[n]===o)return{feature:t};return null}return e.features_?(e.features_.forEach(function(e){e===t&&(i=!0)}),i?{feature:t}:null):{feature:t}},{hitTolerance:this.get("hitTolerance")})||{}},ol.interaction.Transform.prototype.getGeometryRotateToZero_=function(t,e){var o=t.getGeometry(),i=this.getMap().getView().getRotation();if(0===i||!this.get("enableRotatedTransform"))return e?o.clone():o;var n=o.clone();return n.rotate(-1*i,this.getMap().getView().getCenter()),n},ol.interaction.Transform.prototype._isRectangle=function(t){return!(!this.get("keepRectangle")||"Polygon"!==t.getType())&&5===t.getCoordinates()[0].length},ol.interaction.Transform.prototype.drawSketch_=function(t){var e,o,i,n=this.selection_.item(0)&&this._isRectangle(this.selection_.item(0).getGeometry());if(this.overlayLayer_.getSource().clear(),this.selection_.getLength()){var r,s=this.getMap().getView().getRotation(),a=this.getGeometryRotateToZero_(this.selection_.item(0)).getExtent();n&&(r=this.getGeometryRotateToZero_(this.selection_.item(0)).getCoordinates()[0].slice(0,4)).unshift(r[3]),a=ol.extent.buffer(a,0),this.selection_.forEach(function(t){var e=this.getGeometryRotateToZero_(t).getExtent();ol.extent.extend(a,e)}.bind(this));var l=1===this.selection_.getLength()?this._pointRadius(this.selection_.item(0)):0;if(!l||l instanceof Array||(l=[l,l]),!0===t)this.ispt_||(this.overlayLayer_.getSource().addFeature(new ol.Feature({geometry:new ol.geom.Point(this.center_),handle:"rotate0"})),i=ol.geom.Polygon.fromExtent(a),this.get("enableRotatedTransform")&&0!==s&&i.rotate(s,this.getMap().getView().getCenter()),o=this.bbox_=new ol.Feature(i),this.overlayLayer_.getSource().addFeature(o));else{if(this.ispt_){var c=this.getMap().getPixelFromCoordinate([a[0],a[1]]);if(c){var h=l&&l[0]||10,p=l&&l[1]||10;a=ol.extent.boundingExtent([this.getMap().getCoordinateFromPixel([c[0]-h,c[1]-p]),this.getMap().getCoordinateFromPixel([c[0]+h,c[1]+p])])}}i=n?new ol.geom.Polygon([r]):ol.geom.Polygon.fromExtent(a),this.get("enableRotatedTransform")&&0!==s&&i.rotate(s,this.getMap().getView().getCenter()),o=this.bbox_=new ol.Feature(i);var u=[],g=i.getCoordinates()[0];if(!this.ispt_||l){if(u.push(o),!this.iscircle_&&!this.ispt_&&this.get("stretch")&&this.get("scale"))for(e=0;e<g.length-1;e++)o=new ol.Feature({geometry:new ol.geom.Point([(g[e][0]+g[e+1][0])/2,(g[e][1]+g[e+1][1])/2]),handle:"scale",constraint:e%2?"h":"v",option:e}),u.push(o);if(this.get("scale"))for(e=0;e<g.length-1;e++)o=new ol.Feature({geometry:new ol.geom.Point(g[e]),handle:"scale",option:e}),u.push(o);this.get("translate")&&!this.get("translateFeature")&&(o=new ol.Feature({geometry:new ol.geom.Point([(g[0][0]+g[2][0])/2,(g[0][1]+g[2][1])/2]),handle:"translate"}),u.push(o))}!this.iscircle_&&this.get("rotate")&&(o=new ol.Feature({geometry:new ol.geom.Point(g[3]),handle:"rotate"}),u.push(o)),this.overlayLayer_.getSource().addFeatures(u)}}},ol.interaction.Transform.prototype.select=function(t,e){if(!t)return this.selection_.clear(),void this.drawSketch_();if(t.getGeometry&&t.getGeometry()){if(e)this.selection_.push(t);else{var o=this.selection_.getArray().indexOf(t);this.selection_.removeAt(o)}this.ispt_=1===this.selection_.getLength()&&"Point"==this.selection_.item(0).getGeometry().getType(),this.iscircle_=1===this.selection_.getLength()&&"Circle"==this.selection_.item(0).getGeometry().getType(),this.drawSketch_(),this.watchFeatures_(),this.dispatchEvent({type:"select",feature:t,features:this.selection_})}},ol.interaction.Transform.prototype.setSelection=function(t){this.selection_.clear(),t.forEach(function(t){this.selection_.push(t)}.bind(this)),this.ispt_=1===this.selection_.getLength()&&"Point"==this.selection_.item(0).getGeometry().getType(),this.iscircle_=1===this.selection_.getLength()&&"Circle"==this.selection_.item(0).getGeometry().getType(),this.drawSketch_(),this.watchFeatures_(),this.dispatchEvent({type:"select",features:this.selection_})},ol.interaction.Transform.prototype.watchFeatures_=function(){this._featureListeners&&this._featureListeners.forEach(function(t){ol.Observable.unByKey(t)}),this._featureListeners=[],this.selection_.forEach(function(t){this._featureListeners.push(t.on("change",function(){this.isUpdating_||this.drawSketch_()}.bind(this)))}.bind(this))},ol.interaction.Transform.prototype.handleDownEvent_=function(t){if(this._handleEvent(t,this.selection_)){var e=this.getFeatureAtPixel_(t.pixel),o=e.feature;if(this.selection_.getLength()&&this.selection_.getArray().indexOf(o)>=0&&(this.ispt_&&this.get("translate")||this.get("translateFeature"))&&(e.handle="translate"),e.handle){this.mode_=e.handle,this.opt_=e.option,this.constraint_=e.constraint;var i=this.getMap().getView().getRotation();this.coordinate_=t.coordinate,this.pixel_=t.pixel,this.geoms_=[],this.rotatedGeoms_=[];for(var n,r=ol.extent.createEmpty(),s=ol.extent.createEmpty(),a=0;n=this.selection_.item(a);a++)if(this.geoms_.push(n.getGeometry().clone()),r=ol.extent.extend(r,n.getGeometry().getExtent()),this.get("enableRotatedTransform")&&0!==i){var l=this.getGeometryRotateToZero_(n,!0);this.rotatedGeoms_.push(l),s=ol.extent.extend(s,l.getExtent())}if(this.extent_=ol.geom.Polygon.fromExtent(r).getCoordinates()[0],this.get("enableRotatedTransform")&&0!==i&&(this.rotatedExtent_=ol.geom.Polygon.fromExtent(s).getCoordinates()[0]),"rotate"===this.mode_){this.center_=this.getCenter()||ol.extent.getCenter(r);var c=t.map.getTargetElement();c.style.cursor=this.Cursors.rotate0,this.previousCursor_=c.style.cursor}else this.center_=ol.extent.getCenter(r);return this.angle_=Math.atan2(this.center_[1]-t.coordinate[1],this.center_[0]-t.coordinate[0]),this.dispatchEvent({type:this.mode_+"start",feature:this.selection_.item(0),features:this.selection_,pixel:t.pixel,coordinate:t.coordinate}),!0}if(this.get("selection")){if(o){this.addFn_(t)||this.selection_.clear();var h=this.selection_.getArray().indexOf(o);h<0?this.selection_.push(o):this.selection_.removeAt(h)}else this.selection_.clear();return this.ispt_=1===this.selection_.getLength()&&"Point"==this.selection_.item(0).getGeometry().getType(),this.iscircle_=1===this.selection_.getLength()&&"Circle"==this.selection_.item(0).getGeometry().getType(),this.drawSketch_(),this.watchFeatures_(),this.dispatchEvent({type:"select",feature:o,features:this.selection_,pixel:t.pixel,coordinate:t.coordinate}),!1}}},ol.interaction.Transform.prototype.getFeatures=function(){return this.selection_},ol.interaction.Transform.prototype.getCenter=function(){return this.get("center")},ol.interaction.Transform.prototype.setCenter=function(t){return this.set("center",t)},ol.interaction.Transform.prototype.handleDragEvent_=function(t){if(this._handleEvent(t,this.features_)){var e,o,i,n,r=this.getMap().getView().getRotation(),s=[this.coordinate_[0],this.coordinate_[1]],a=[t.coordinate[0],t.coordinate[1]];switch(this.isUpdating_=!0,this.mode_){case"rotate":var l=Math.atan2(this.center_[1]-a[1],this.center_[0]-a[0]);if(!this.ispt)for(e=0;i=this.selection_.item(e);e++)(n=this.geoms_[e].clone()).rotate(l-this.angle_,this.center_),"Circle"==n.getType()&&n.setCenterAndRadius(n.getCenter(),n.getRadius()),i.setGeometry(n);this.drawSketch_(!0),this.dispatchEvent({type:"rotating",feature:this.selection_.item(0),features:this.selection_,angle:l-this.angle_,pixel:t.pixel,coordinate:t.coordinate});break;case"translate":var c=a[0]-s[0],h=a[1]-s[1];for(e=0;i=this.selection_.item(e);e++)i.getGeometry().translate(c,h);this.handles_.forEach(function(t){t.getGeometry().translate(c,h)}),this.coordinate_=t.coordinate,this.dispatchEvent({type:"translating",feature:this.selection_.item(0),features:this.selection_,delta:[c,h],pixel:t.pixel,coordinate:t.coordinate});break;case"scale":var p=this.center_;if(this.get("modifyCenter")(t)){var u=this.extent_;this.get("enableRotatedTransform")&&0!==r&&(u=this.rotatedExtent_),p=u[(Number(this.opt_)+2)%4]}var g=1==this.geoms_.length&&this._isRectangle(this.geoms_[0]),d=this.constraint_,m=this.opt_,f=this.coordinate_,y=t.coordinate;if(this.get("enableRotatedTransform")&&0!==r){var v=new ol.geom.Point(this.coordinate_);v.rotate(-1*r,p),f=v.getCoordinates();var _=new ol.geom.Point(t.coordinate);_.rotate(-1*r,p),y=_.getCoordinates()}var x=(y[0]-p[0])/(f[0]-p[0]),b=(y[1]-p[1])/(f[1]-p[1]),w=[y[0]-f[0],y[1]-f[1]];if(this.get("enableRotatedTransform")&&0!==r){var S=new ol.geom.Point(p);S.rotate(-1*r,this.getMap().getView().getCenter()),p=S.getCoordinates()}for(this.get("noFlip")&&(x<0&&(x=-x),b<0&&(b=-b)),this.constraint_?"h"==this.constraint_?x=1:b=1:this.get("keepAspectRatio")(t)&&(x=b=Math.min(x,b)),e=0;i=this.selection_.item(e);e++)(n=0!==r&&this.get("enableRotatedTransform")?this.rotatedGeoms_[e].clone():this.geoms_[e].clone()).applyTransform(function(t,e,i){if(i<2)return e;if(g){var r=[[6],[0,8],[2],[4]],s=[t[0],t[1]],a=[t[2],t[3]],l=[t[4],t[5]],c=[t[6],t[7]],h=[t[8],t[9]];if(d){var u=m%2==0?countVector(s,a):countVector(c,s),f=projectVectorOnVector(w,u),v=[...r[m],...r[m+1<r.length?m+1:0]];for(o=0;o<t.length;o+=i)e[o]=v.includes(o)?t[o]+f[0]:t[o],e[o+1]=v.includes(o)?t[o+1]+f[1]:t[o+1]}else{var _,S;switch(m){case 0:_=projectVectorOnVector(w=countVector(c,y),countVector(l,c)),S=projectVectorOnVector(w,countVector(s,c)),[e[0],e[1]]=movePoint(s,_),[e[4],e[5]]=movePoint(l,S),[e[6],e[7]]=movePoint(c,w),[e[8],e[9]]=movePoint(h,_);break;case 1:_=projectVectorOnVector(w=countVector(s,y),countVector(c,s)),S=projectVectorOnVector(w,countVector(a,s)),[e[0],e[1]]=movePoint(s,w),[e[2],e[3]]=movePoint(a,_),[e[6],e[7]]=movePoint(c,S),[e[8],e[9]]=movePoint(h,w);break;case 2:_=projectVectorOnVector(w=countVector(a,y),countVector(s,a)),S=projectVectorOnVector(w,countVector(l,a)),[e[0],e[1]]=movePoint(s,S),[e[2],e[3]]=movePoint(a,w),[e[4],e[5]]=movePoint(l,_),[e[8],e[9]]=movePoint(h,S);break;case 3:_=projectVectorOnVector(w=countVector(l,y),countVector(a,l)),S=projectVectorOnVector(w,countVector(c,l)),[e[2],e[3]]=movePoint(a,S),[e[4],e[5]]=movePoint(l,w),[e[6],e[7]]=movePoint(c,_)}}}else for(o=0;o<t.length;o+=i)1!=x&&(e[o]=p[0]+(t[o]-p[0])*x),1!=b&&(e[o+1]=p[1]+(t[o+1]-p[1])*b);return"Circle"==n.getType()&&n.setCenterAndRadius(n.getCenter(),n.getRadius()),e}),this.get("enableRotatedTransform")&&0!==r&&n.rotate(r,this.getMap().getView().getCenter()),i.setGeometry(n);this.drawSketch_(),this.dispatchEvent({type:"scaling",feature:this.selection_.item(0),features:this.selection_,scale:[x,b],pixel:t.pixel,coordinate:t.coordinate})}this.isUpdating_=!1}},ol.interaction.Transform.prototype.handleMoveEvent_=function(t){if(this._handleEvent(t,this.features_)&&!this.mode_){var e=this.getFeatureAtPixel_(t.pixel),o=t.map.getTargetElement();if(e.feature){var i=e.handle?this.Cursors[(e.handle||"default")+(e.constraint||"")+(e.option||"")]:this.Cursors.select;void 0===this.previousCursor_&&(this.previousCursor_=o.style.cursor),o.style.cursor=i}else void 0!==this.previousCursor_&&(o.style.cursor=this.previousCursor_),this.previousCursor_=void 0}},ol.interaction.Transform.prototype.handleUpEvent_=function(t){"rotate"===this.mode_&&(t.map.getTargetElement().style.cursor=this.Cursors.default,this.previousCursor_=void 0);return this.dispatchEvent({type:this.mode_+"end",feature:this.selection_.item(0),features:this.selection_,oldgeom:this.geoms_[0],oldgeoms:this.geoms_}),this.drawSketch_(),this.mode_=null,!1},ol.interaction.Transform.prototype.getFeatures=function(){return this.selection_},ol.interaction.Transform.prototype.setPointRadius=function(t){this._pointRadius="function"==typeof t?t:function(){return t}},ol.interaction.UndoRedo=function(t){t||(t={}),ol.interaction.Interaction.call(this,{handleEvent:function(){return!0}}),this._layers=t.layers,this._undoStack=new ol.Collection,this._redoStack=new ol.Collection,this._undo=[],this._redo=[],this._undoStack.on("add",function(t){void 0===t.element.level?(t.element.level=this._level,t.element.level||(t.element.view={center:this.getMap().getView().getCenter(),zoom:this.getMap().getView().getZoom()},this._undo.push(t.element))):t.element.level||this._undo.push(this._redo.shift()),t.element.level||this.dispatchEvent({type:"stack:add",action:t.element}),this._reduce()}.bind(this)),this._undoStack.on("remove",function(t){t.element.level||(this._doShift?this._undo.shift():this._undo.length&&this._redo.push(this._undo.pop()),this._doClear||this.dispatchEvent({type:"stack:remove",action:t.element,shift:this._doShift}))}.bind(this)),this._block=0,this._level=0,this._doShift=!1,this._record=!0,this._defs={}},ol.ext.inherits(ol.interaction.UndoRedo,ol.interaction.Interaction),ol.interaction.UndoRedo.prototype.define=function(t,e,o){this._defs[t]={undo:e,redo:o}},ol.interaction.UndoRedo.prototype.length=function(t){return"redo"===t?this._redo.length:this._undo.length},ol.interaction.UndoRedo.prototype.setMaxLength=function(t){(t=parseInt(t))&&t<0&&(t=0),this.set("maxLength",t),this._reduce()},ol.interaction.UndoRedo.prototype.size=function(t){return"redo"===t?this._redoStack.getLength():this._undoStack.getLength()},ol.interaction.UndoRedo.prototype.setMaxSize=function(t){(t=parseInt(t))&&t<0&&(t=0),this.set("maxSize",t),this._reduce()},ol.interaction.UndoRedo.prototype._reduce=function(){if(this.get("maxLength"))for(;this.length()>this.get("maxLength");)this.shift();if(this.get("maxSize"))for(;this.length()>1&&this.size()>this.get("maxSize");)this.shift()},ol.interaction.UndoRedo.prototype.getStack=function(t){return"redo"===t?this._redo:this._undo},ol.interaction.UndoRedo.prototype.push=function(t,e,o){return this._defs[t]?(this._undoStack.push({type:t,name:o,custom:!0,prop:e}),!0):(console.warn('[UndoRedoInteraction]: "'+t+'" is not defined.'),!1)},ol.interaction.UndoRedo.prototype.shift=function(){this._doShift=!0;var t=this._undoStack.removeAt(0);if(this._doShift=!1,"blockstart"===t.type)for(t=this._undoStack.item(0);this._undoStack.getLength()&&t.level>0;)this._undoStack.removeAt(0),t=this._undoStack.item(0)},ol.interaction.UndoRedo.prototype.setActive=function(t){ol.interaction.Interaction.prototype.setActive.call(this,t),this._record=t},ol.interaction.UndoRedo.prototype.setMap=function(t){this._mapListener&&this._mapListener.forEach(function(t){ol.Observable.unByKey(t)}),this._mapListener=[],ol.interaction.Interaction.prototype.setMap.call(this,t),t&&(this._mapListener.push(t.on("undoblockstart",this.blockStart.bind(this))),this._mapListener.push(t.on("undoblockend",this.blockEnd.bind(this)))),this._watchSources(),this._watchInteractions()},ol.interaction.UndoRedo.prototype._watchSources=function(){var t=this.getMap();this._sourceListener&&this._sourceListener.forEach(function(t){ol.Observable.unByKey(t)}),this._sourceListener=[];var e=this;t&&(function t(o,i){return i||(i=[]),o.forEach(function(o){o instanceof ol.layer.Vector?(!e._layers||e._layers.indexOf(o)>=0)&&i.push(o):o.getLayers&&t(o.getLayers(),i)}),i}(t.getLayers()).forEach(function(t){var e=t.getSource();this._sourceListener.push(e.on(["addfeature","removefeature"],this._onAddRemove.bind(this))),this._sourceListener.push(e.on("clearstart",function(){this.blockStart("clear")}.bind(this))),this._sourceListener.push(e.on("clearend",this.blockEnd.bind(this)))}.bind(this)),this._sourceListener.push(t.getLayers().on(["add","remove"],this._watchSources.bind(this))))},ol.interaction.UndoRedo.prototype._watchInteractions=function(){var t=this.getMap();this._interactionListener&&this._interactionListener.forEach(function(t){ol.Observable.unByKey(t)}),this._interactionListener=[],t&&(t.getInteractions().forEach(function(t){this._interactionListener.push(t.on(["setattributestart","modifystart","rotatestart","translatestart","scalestart","deletestart","deleteend","beforesplit","aftersplit"],this._onInteraction.bind(this)))}.bind(this)),this._interactionListener.push(t.getInteractions().on(["add","remove"],this._watchInteractions.bind(this))))},ol.interaction.UndoRedo.prototype._onAddRemove=function(t){this._record&&(this._redoStack.clear(),this._redo.length=0,this._undoStack.push({type:t.type,source:t.target,feature:t.feature}))},ol.interaction.UndoRedo.prototype._onInteraction=function(t){var e=this._onInteraction[t.type];e&&e.call(this,t)},ol.interaction.UndoRedo.prototype._onInteraction.setattributestart=function(t){this.blockStart(t.target.get("name")||"setattribute");var e=Object.assign({},t.properties);t.features.forEach(function(t){var o={};for(var i in e)o[i]=t.get(i);this._undoStack.push({type:"changeattribute",feature:t,newProperties:e,oldProperties:o})}.bind(this)),this.blockEnd()},ol.interaction.UndoRedo.prototype._onInteraction.rotatestart=ol.interaction.UndoRedo.prototype._onInteraction.translatestart=ol.interaction.UndoRedo.prototype._onInteraction.scalestart=ol.interaction.UndoRedo.prototype._onInteraction.modifystart=function(t){this.blockStart(t.type.replace(/start$/,"")),t.features.forEach(function(t){this._undoStack.push({type:"changegeometry",feature:t,oldGeom:t.getGeometry().clone()})}.bind(this)),this.blockEnd()},ol.interaction.UndoRedo.prototype.blockStart=function(t){this._redoStack.clear(),this._redo.length=0,this._undoStack.push({type:"blockstart",name:t}),this._level++},ol.interaction.UndoRedo.prototype._onInteraction.beforesplit=function(){var t=this._undoStack.getLength();t>2&&"blockend"===this._undoStack.item(t-1).type&&"changegeometry"===this._undoStack.item(t-2).type?this._undoStack.pop():this.blockStart("split")},ol.interaction.UndoRedo.prototype._onInteraction.deletestart=function(){this.blockStart("delete")},ol.interaction.UndoRedo.prototype.blockEnd=function(){this._undoStack.push({type:"blockend"}),this._level--},ol.interaction.UndoRedo.prototype._onInteraction.aftersplit=ol.interaction.UndoRedo.prototype._onInteraction.deleteend=ol.interaction.UndoRedo.prototype.blockEnd,ol.interaction.UndoRedo.prototype._handleDo=function(t,e){if(this.getActive()){if(this._record=!1,t.custom)this._defs[t.type]?e?this._defs[t.type].undo(t.prop):this._defs[t.type].redo(t.prop):console.warn('[UndoRedoInteraction]: "'+t.type+'" is not defined.');else switch(t.type){case"addfeature":e?t.source.removeFeature(t.feature):t.source.addFeature(t.feature);break;case"removefeature":e?t.source.addFeature(t.feature):t.source.removeFeature(t.feature);break;case"changegeometry":var o=t.feature.getGeometry();t.feature.setGeometry(t.oldGeom),t.oldGeom=o;break;case"changeattribute":var i=t.newProperties,n=t.oldProperties;for(var r in n)void 0===n?t.feature.unset(r):t.feature.set(r,n[r]);t.oldProperties=i,t.newProperties=n;break;case"blockstart":this._block+=e?-1:1;break;case"blockend":this._block+=e?1:-1;break;default:console.warn('[UndoRedoInteraction]: "'+t.type+'" is not defined.')}this._block<0&&(this._block=0),this._block&&(e?this.undo():this.redo()),this._record=!0,this.dispatchEvent({type:e?"undo":"redo",action:t})}},ol.interaction.UndoRedo.prototype.undo=function(){var t=this._undoStack.item(this._undoStack.getLength()-1);t&&(this._redoStack.push(t),this._undoStack.pop(),this._handleDo(t,!0))},ol.interaction.UndoRedo.prototype.redo=function(){var t=this._redoStack.item(this._redoStack.getLength()-1);t&&(this._undoStack.push(t),this._redoStack.pop(),this._handleDo(t,!1))},ol.interaction.UndoRedo.prototype.clear=function(){this._doClear=!0,this._undo.length=this._redo.length=0,this._undoStack.clear(),this._redoStack.clear(),this._doClear=!1,this.dispatchEvent({type:"stack:clear"})},ol.interaction.UndoRedo.prototype.hasUndo=function(){return this._undoStack.getLength()},ol.interaction.UndoRedo.prototype.hasRedo=function(){return this._redoStack.getLength()},ol.source.BinBase=function(t){t=t||{},this._bindModify=this._onModifyFeature.bind(this),this._watch=!0,ol.source.Vector.call(this,t),this._origin=t.source,this._listen=!1!==t.listenChange,this._geomFn=t.geometryFunction||ol.coordinate.getFeatureCenter||function(t){return t.getGeometry().getFirstCoordinate()},this.reset(),this._origin.on("addfeature",this._onAddFeature.bind(this)),this._origin.on("removefeature",this._onRemoveFeature.bind(this)),this._origin.on("clearstart",this._onClearFeature.bind(this)),this._origin.on("clearend",this._onClearFeature.bind(this)),"function"==typeof t.flatAttributes&&(this._flatAttributes=t.flatAttributes)},ol.ext.inherits(ol.source.BinBase,ol.source.Vector),ol.source.BinBase.prototype._onAddFeature=function(t,e,o){var i=t.feature||t.target;(e=e||this.getBinAt(this._geomFn(i),!0))&&e.get("features").push(i),this._listen&&!1!==o&&i.on("change",this._bindModify)},ol.source.BinBase.prototype._onRemoveFeature=function(t,e,o){if(this._watch){var i=t.feature||t.target;if(e=e||this.getBinAt(this._geomFn(i))){for(var n,r=e.get("features"),s=0;n=r[s];s++)if(n===i){r.splice(s,1);break}r.length||this.removeFeature(e)}this._listen&&!1!==o&&i.un("change",this._bindModify)}},ol.source.BinBase.prototype._onClearFeature=function(t){"clearstart"===t.type?(this._listen&&this._origin.getFeatures().forEach(function(t){t.un("change",this._bindModify)}.bind(this)),this.clear(),this._watch=!1):this._watch=!0},ol.source.BinBase.prototype.getBin=function(t){for(var e,o=this.getFeatures(),i=0;e=o[i];i++)for(var n,r=e.get("features"),s=0;n=r[s];s++)if(n===t)return e;return null},ol.source.BinBase.prototype.getGridGeomAt=function(t){return new ol.geom.Polygon([t])},ol.source.BinBase.prototype.getBinAt=function(t,e){var o={},i=this.getGridGeomAt(t,o);if(!i)return null;var n=i.getInteriorPoint?i.getInteriorPoint().getCoordinates():i.getInteriorPoints().getCoordinates()[0],r=this.getFeaturesAtCoordinate(n)[0];return!r&&e&&(o.geometry=i,o.features=[],o.center=n,r=new ol.Feature(o),this.addFeature(r)),r||null},ol.source.BinBase.prototype._onModifyFeature=function(t){var e=this.getBin(t.target),o=this.getBinAt(this._geomFn(t.target),"create");e!==o&&(e&&this._onRemoveFeature(t,e,!1),o&&this._onAddFeature(t,o,!1)),this.changed()},ol.source.BinBase.prototype.reset=function(){this.clear();for(var t,e=this._origin.getFeatures(),o=0;t=e[o];o++)this._onAddFeature({feature:t});this.changed()},ol.source.BinBase.prototype.getGridFeatures=function(){var t=[];return this.getFeatures().forEach(function(e){var o=new ol.Feature(e.getGeometry().clone());for(var i in e.getProperties())"features"!==i&&"geometry"!==i&&o.set(i,e.get(i));o.set("nb",e.get("features").length),this._flatAttributes(o,e.get("features")),t.push(o)}.bind(this)),t},ol.source.BinBase.prototype._flatAttributes=function(){},ol.source.BinBase.prototype.setFlatAttributesFn=function(t){"function"==typeof t&&(this._flatAttributes=t)},ol.source.BinBase.prototype.getSource=function(){return this._origin},ol.source.DBPedia=function(t){var e=t||{};e.loader=this._loaderFn,this._url=e.url||"http://fr.dbpedia.org/sparql",this._maxResolution=e.maxResolution||100,this._lang=e.lang||"fr",this._limit=e.limit||1e3,e.attributions||(e.attributions=["&copy; <a href='http://dbpedia.org/'>DBpedia</a> CC-by-SA"]),e.strategy||(e.strategy=ol.loadingstrategy.bbox),ol.source.Vector.call(this,e)},ol.ext.inherits(ol.source.DBPedia,ol.source.Vector),ol.source.DBPedia.prototype.readFeature=function(t,e,o){for(var i in e)"uri"===e[i].type&&(e[i].value=encodeURI(e[i].value)),t.set(i,e[i].value);return!o||o.get("subject")!=e.subject.value||(o.set("type",o.get("type")+"\n"+e.type.value),!1)},ol.source.DBPedia.prototype.querySubject=function(){return"?subject rdfs:label ?label. OPTIONAL {?subject dbpedia-owl:thumbnail ?thumbnail}.OPTIONAL {?subject dbpedia-owl:abstract ?abstract} . OPTIONAL {?subject rdf:type ?type}"},ol.source.DBPedia.prototype.queryFilter=function(){return"lang(?label) = '"+this._lang+"' && lang(?abstract) = '"+this._lang+"'"},ol.source.DBPedia.prototype._loaderFn=function(t,e,o){if(!(e>this._maxResolution)){var i=this,n=ol.proj.transformExtent(t,o,"EPSG:4326"),r="PREFIX geo: <http://www.w3.org/2003/01/geo/wgs84_pos#> SELECT DISTINCT * WHERE { ?subject geo:lat ?lat . ?subject geo:long ?long . "+this.querySubject()+" . FILTER("+this.queryFilter()+") . FILTER(xsd:float(?lat) <= "+n[3]+" && "+n[1]+" <= xsd:float(?lat) && xsd:float(?long) <= "+n[2]+" && "+n[0]+" <= xsd:float(?long) ) . } LIMIT "+this._limit;ol.ext.Ajax.get({url:this._url,data:{query:r,format:"json"},success:function(t){var e,n,r,s=t.results.bindings,a=[],l=null;for(var c in s)e=s[c],n=[Number(s[c].long.value),Number(s[c].lat.value)],r=new ol.Feature(new ol.geom.Point(ol.proj.transform(n,"EPSG:4326",o))),i.readFeature(r,e,l)&&(a.push(r),l=r);i.addFeatures(a)}})}},ol.style.clearDBPediaStyleCache,ol.style.dbPediaStyleFunction,function(){var t={};ol.style.clearDBPediaStyleCache=function(){t={}},ol.style.dbPediaStyleFunction=function(e){var o;switch(e||(e={}),typeof e.glyph){case"function":o=e.glyph;break;case"string":o=function(){return e.glyph};break;default:o=function(t){var e=t.get("type");if(e){if(e.match("/Museum"))return"fa-camera";if(e.match("/Monument"))return"fa-building";if(e.match("/Sculpture"))return"fa-android";if(e.match("/Religious"))return"fa-institution";if(e.match("/Castle"))return"fa-key";if(e.match("Water"))return"fa-tint";if(e.match("Island"))return"fa-leaf";if(e.match("/Event"))return"fa-heart";if(e.match("/Artwork"))return"fa-asterisk";if(e.match("/Stadium"))return"fa-futbol-o";if(e.match("/Place"))return"fa-street-view"}return"fa-star"}}var i=e.radius||8,n=e.fill||new ol.style.Fill({color:"navy"}),r=e.stroke||new ol.style.Stroke({color:"#fff",width:2}),s=e.prefix?e.prefix+"_":"";return function(e){var a=o(e),l=s+a,c=t[l];return c||(t[l]=c=new ol.style.Style({image:new ol.style.FontSymbol({glyph:a,radius:i,fill:n,stroke:r})})),[c]}}}(),ol.source.DFCI=function(t){(t=t||{}).loader=this._calcGrid,t.strategy=function(t,e){return this.resolution&&this.resolution!=e&&(this.clear(),this.refresh()),[t]},this._bbox=[[0,16e5],[11e5,26e5]],ol.source.Vector.call(this,t),this.set("resolutions",t.resolutions||[1e3,100,20]),proj4.defs["EPSG:27572"]||proj4.defs("EPSG:27572","+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.99987742 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs"),ol.proj.proj4.register(proj4)},ol.ext.inherits(ol.source.DFCI,ol.source.Vector),ol.source.DFCI.prototype._calcGrid=function(t,e,o){var i,n,r=this.get("resolutions");e>(r[0]||1e3)?this.resolution!=e&&(this._features0||(n=[this._bbox[0][0],this._bbox[0][1],this._bbox[1][0],this._bbox[1][1]],this._features0=this._getFeatures(0,n,o)),this.addFeatures(this._features0)):e>(r[1]||100)?(this.clear(),n=ol.proj.transformExtent(t,o,"EPSG:27572"),i=this._getFeatures(1,n,o),this.addFeatures(i)):e>(r[2]||0)?(this.clear(),n=ol.proj.transformExtent(t,o,"EPSG:27572"),i=this._getFeatures(2,n,o),this.addFeatures(i)):(this.clear(),n=ol.proj.transformExtent(t,o,"EPSG:27572"),i=this._getFeatures(3,n,o),this.addFeatures(i)),this.resolution=e},ol.source.DFCI.prototype._midPt=function(t,e){return[(t[0]+e[0])/2,(t[1]+e[1])/2]},ol.source.DFCI.prototype._trFeature=function(t,e,o,i){var n=new ol.geom.Polygon([t]),r=new ol.Feature(n.transform("EPSG:27572",i));return r.set("id",e),r.set("level",o),r},ol.source.DFCI.prototype._getFeatures=function(t,e,o){var i,n=[],r=1e5;t>0&&(r/=5),t>1&&(r/=10);for(var s=[Math.max(this._bbox[0][0],Math.floor(e[0]/r)*r),Math.max(this._bbox[0][1],Math.floor(e[1]/r)*r)],a=[Math.min(this._bbox[1][0]+99999,Math.floor(e[2]/r)*r),Math.min(this._bbox[1][1]+99999,Math.floor(e[3]/r)*r)],l=s[0];l<=a[0];l+=r)for(var c=s[1];c<=a[1];c+=r){var h,p=[[l,c],[l+r,c],[l+r,c+r],[l,c+r],[l,c]];if(t>2){var u=this._midPt(p[0],p[2]),g=[];for(i=0;i<p.length;i++)g.push(this._midPt(p[i],u));for(n.push(this._trFeature(g,ol.coordinate.toDFCI([l,c],2)+".5",t,o)),i=0;i<4;i++)(g=[]).push(p[i]),g.push(this._midPt(p[i],p[(i+1)%4])),g.push(this._midPt(u,g[1])),g.push(this._midPt(u,p[i])),h=this._midPt(p[i],p[(i+3)%4]),g.push(this._midPt(u,h)),g.push(h),g.push(p[i]),n.push(this._trFeature(g,ol.coordinate.toDFCI([l,c],2)+"."+(4-i),t,o))}else n.push(this._trFeature(p,ol.coordinate.toDFCI([l,c],t),t,o))}return n},ol.source.DayNight=function(t){(t=t||{}).loader=this._loader,t.strategy=ol.loadingstrategy.all,ol.source.Vector.call(this,t),this.set("time",t.time||new Date),this.set("step",t.step||1)},ol.ext.inherits(ol.source.DayNight,ol.source.Vector),function(){function t(t){var e=Math.PI/180,o=t-2451545,i=280.46+.9856474*o,n=357.528+.9856003*o;return n%=360,{lambda:(i%=360)+1.915*Math.sin(n*e)+.02*Math.sin(2*n*e),R:1.00014-.01671*Math.cos(n*e)-.0014*Math.cos(2*n*e)}}function e(t){var e=(t-2451545)/36525;return 23.43929111-e*(46.836769/3600-e*(1831e-7/3600+e*(5.565e-7-e*(1.6e-10-4.34e-8*e/3600))))}function o(t,e){var o=180/Math.PI,i=Math.PI/180,n=Math.atan(Math.cos(e*i)*Math.tan(t*i))*o,r=Math.asin(Math.sin(e*i)*Math.sin(t*i))*o;return{alpha:n+=90*Math.floor(t/90)-90*Math.floor(n/90),delta:r}}ol.source.DayNight.prototype._loader=function(t,e,o){var i=this.getCoordinates(this.get("time")),n=new ol.geom.Polygon([i]);n.transform("EPSG:4326",o),this.addFeature(new ol.Feature(n))},ol.source.DayNight.prototype.setTime=function(t){this.set("time",t),this.refresh()},ol.source.DayNight.prototype.getSunPosition=function(i){var n=(i?new Date(i):new Date)/864e5+2440587.5,r=(18.697374558+24.06570982441908*(n-2451545))%24,s=t(n),a=e(n),l=o(s.lambda,a);return[l.alpha-15*r,l.delta]},ol.source.DayNight.getNightLat=function(i,n){var r=180/Math.PI,s=Math.PI/180,a=(n?new Date(n):new Date)/864e5+2440587.5,l=(18.697374558+24.06570982441908*(a-2451545))%24,c=t(a),h=e(a),p=o(c.lambda,h),u=15*l+i-p.alpha;return Math.atan(-Math.cos(u*s)/Math.tan(p.delta*s))*r},ol.source.DayNight.prototype.getCoordinates=function(i,n){for(var r=180/Math.PI,s=Math.PI/180,a=(i?new Date(i):new Date)/864e5+2440587.5,l=(18.697374558+24.06570982441908*(a-2451545))%24,c=[],h=t(a),p=e(a),u=o(h.lambda,p),g=this.get("step")||1,d=-180;d<=180;d+=g){var m=d,f=15*l+m-u.alpha,y=Math.atan(-Math.cos(f*s)/Math.tan(u.delta*s))*r;c.push([m,y])}switch(n){case"line":break;case"day":u.delta*=-1;default:y=u.delta<0?90:-90;for(var v=180;v>=-180;v-=g)c.push([v,y]);c.push(c[0])}if("daynight"===n){var _=[];c.forEach(function(t){_.push(t.slice())}),_[0][1]=-_[0][1],_[_.length-1][1]=-_[0][1],_[_.length-1][1]=-_[0][1],c=[c,_]}return c}}(),ol.source.Delaunay=function(t){t=t||{},this._nodes=t.source,delete t.source,ol.source.Vector.call(this,t),this.hull=[],this._nodes.on("addfeature",this._onAddNode.bind(this)),this._nodes.on("removefeature",this._onRemoveNode.bind(this)),this.set("epsilon",t.epsilon||1e-4)},ol.ext.inherits(ol.source.Delaunay,ol.source.Vector),ol.source.Delaunay.prototype.clear=function(t){ol.source.Vector.prototype.clear.call(this,t),this.getNodeSource().clear(t)},ol.source.Delaunay.prototype._addTriangle=function(t){t.push(t[0]);var e=new ol.Feature(new ol.geom.Polygon([t]));return this.addFeature(e),this.flip.push(e),e},ol.source.Delaunay.prototype.getNodes=function(){return this._nodes.getFeatures()},ol.source.Delaunay.prototype.getNodeSource=function(){return this._nodes},ol.source.Delaunay.prototype._onRemoveNode=function(t){var e=t.feature.getGeometry().getCoordinates();if(e&&!this.getNodesAt(e).length){var o,i=this.getTrianglesAt(e);this.flip=[];for(var n=[];i.length;){var r=i.pop();this.removeFeature(r),r=r.getGeometry().getCoordinates()[0];var s=[];for(o=0;o<3;o++)l=r[o],ol.coordinate.equal(l,e)||s.push(l);n.push(s)}for(s=n.pop(),o=0;;){var a=n[o];if(f(a[0],a[1],0)||f(a[1],a[0],0)||f(a[0],a[1],s.length-1)||f(a[1],a[0],s.length-1)?(n.splice(o,1),o=0):o++,!n.length)break;if(o>=n.length)throw"[DELAUNAY:removePoint] No edge found"}var l,c=ol.coordinate.equal(s[0],s[s.length-1]);for(c&&s.pop();l=this.hull[o];o++)if(ol.coordinate.equal(e,l)){this.hull.splice(o,1);break}this.hull=ol.coordinate.convexHull(this.hull.concat(s));var h,p=function(t){for(var e,o=0,i=0;i<t.length;i++)o+=(t[e=(i+1)%t.length][0]-t[i][0])*(t[e][1]+t[i][1]);return o>=0?1:-1},u=s.slice();for(c?h=p(s):(u.push(e),h=p(u)),o=0;o<=s.length+1&&!(s.length<3);o++){var g=[s[o%s.length],s[(o+1)%s.length],s[(o+2)%s.length]];if(p(g)===h){for(var d=!0,m=o+3;m<o+s.length;m++)if(this.inCircle(s[m%s.length],g)){d=!1;break}d&&(this._addTriangle(g),s.splice((o+1)%s.length,1),o=-1)}}this.flipTriangles()}function f(t,e,o){return!!ol.coordinate.equal(t,s[o])&&(o?s.push(e):s.unshift(e),!0)}},ol.source.Delaunay.prototype._onAddNode=function(t){var e,o,i=t.feature;if("Point"===i.getGeometry().getType()){this.flip=[];var n=this.getNodes(),r=i.getGeometry().getCoordinates();if(this.getNodesAt(r).length>1)this._nodes.removeFeature(i);else if(n.length<=3){if(3===n.length){var s=[];for(e=0;e<3;e++)s.push(n[e].getGeometry().getCoordinates());this._addTriangle(s),this.hull=ol.coordinate.convexHull(s)}}else{var a=this.getFeaturesAtCoordinate(r)[0];if(a){this.removeFeature(a),a.set("del",!0);var l=a.getGeometry().getCoordinates()[0];for(e=0;e<3;e++)this._addTriangle([r,l[e],l[(e+1)%3]])}else{var c=this.hull.slice();for(c.push(r),c=ol.coordinate.convexHull(c),e=0;(o=c[e])&&!ol.coordinate.equal(o,r);e++);var h=c[e=0!==e?e-1:c.length-1],p=c[(e+2)%c.length];for(e=0;(o=this.hull[e])&&!ol.coordinate.equal(o,h);e++);for(;;){if(e>1e3){console.error("[DELAUNAY:addPoint] Too many iterations");break}if(e++,o=this.hull[e%this.hull.length],this._addTriangle([r,o,h]),h=o,o[0]===p[0]&&o[1]===p[1])break}this.hull=c}this.flipTriangles()}}else this._nodes.removeFeature(i)},ol.source.Delaunay.prototype.flipTriangles=function(){for(var t,e=1e3;this.flip.length;){if(e--<0){console.error("[DELAUNAY:flipTriangles] Too many iterations");break}var o=this.flip.pop();if(!o.get("del"))for(var i=o.getGeometry().getCoordinates()[0],n=0;n<3;n++){var r=[(i[(n+1)%3][0]+i[n][0])/2,(i[(n+1)%3][1]+i[n][1])/2],s=this.getTrianglesAt(r),a=null;if(s.length>1){var l=s[0].getGeometry().getCoordinates()[0],c=s[1].getGeometry().getCoordinates()[0];for(t=0;t<c.length;t++)if(!this._ptInTriangle(c[t],l)){a=c[t];break}}if(a&&this.inCircle(a,l)){var h;for(t=0;t<l.length;t++)if(!this._ptInTriangle(l[t],c)){h=l.splice(t,1)[0];break}if(this.intersectSegs([a,h],l)){for(;s.length;){var p=s.pop();p.set("del",!0),this.removeFeature(p)}this._addTriangle([a,h,l[0]]),this._addTriangle([a,h,l[1]])}}}}},ol.source.Delaunay.prototype.intersectSegs=function(t,e){var o=t[1][0]-t[0][0],i=t[1][1]-t[0][1],n=e[1][0]-e[0][0],r=o*(e[1][1]-e[0][1])-i*n;if(0!=r){var s=(o*t[0][1]-o*e[0][1]-i*t[0][0]+i*e[0][0])/r;return 0<s&&s<1}return!1},ol.source.Delaunay.prototype._ptInTriangle=function(t,e){for(var o,i=0;o=e[i];i++)if(ol.coordinate.equal(t,o))return!0;return!1},ol.source.Delaunay.prototype.listpt=function(t){for(var e,o="",i=0;e=t[i];i++){var n=this._nodes.getClosestFeatureToCoordinate(e);ol.coordinate.equal(n.getGeometry().getCoordinates(),e)||(n=null),o+=(o?", ":"")+(n?n.get("id"):"?")}return o},ol.source.Delaunay.prototype.inCircle=function(t,e){var o=this.getCircumCircle(e);return ol.coordinate.dist2d(t,o.center)<o.radius},ol.source.Delaunay.prototype.getCircumCircle=function(t){var e=t[0][0],o=t[0][1],i=t[1][0],n=t[1][1],r=t[2][0],s=t[2][1],a=(e-i)/(n-o),l=(e-r)/(s-o),c=(o+n)/2-a*(e+i)/2,h=((o+s)/2-l*(e+r)/2-c)/(a-l),p=[h,a*h+c];return{center:p,radius:ol.coordinate.dist2d(p,t[0])}},ol.source.Delaunay.prototype.getTrianglesAt=function(t){var e=ol.extent.buffer(ol.extent.boundingExtent([t]),this.get("epsilon")),o=[];return this.forEachFeatureIntersectingExtent(e,function(t){o.push(t)}),o},ol.source.Delaunay.prototype.getNodesAt=function(t){var e=ol.extent.buffer(ol.extent.boundingExtent([t]),this.get("epsilon"));return this._nodes.getFeaturesInExtent(e)},ol.source.Delaunay.prototype.calculateVoronoi=function(t){var e=[];return this.getNodes().forEach(function(o){var i=o.getGeometry().getCoordinates(),n=!1;if(!0!==t)for(var r=0;r<this.hull.length;r++)if(ol.coordinate.equal(i,this.hull[r])){n=!0;break}if(!n){var s=this.getTrianglesAt(i),a=[];s.forEach(function(t){var e=this.getCircumCircle(t.getGeometry().getCoordinates()[0]);a.push({pt:e.center,d:Math.atan2(e.center[1]-i[1],e.center[0]-i[0])})}.bind(this)),a.sort(function(t,e){return t.d-e.d});var l=[];a.forEach(function(t){l.push(t.pt)}),l.push(l[0]);var c=o.getProperties();c.geometry=new ol.geom.Polygon([l]),e.push(new ol.Feature(c))}}.bind(this)),e},ol.source.FeatureBin=function(t){var e;(t=t||{}).binSource?(this._sourceFeature=t.binSource,this._sourceFeature.on(["addfeature","changefeature","removefeature"],function(){e&&clearTimeout(e),e=setTimeout(function(){this.reset()}.bind(this))}.bind(this))):this._sourceFeature=new ol.source.Vector({features:t.features||[]});ol.source.BinBase.call(this,t)},ol.ext.inherits(ol.source.FeatureBin,ol.source.BinBase),ol.source.FeatureBin.prototype.setFeatures=function(t){this._sourceFeature.clear(),this._sourceFeature.addFeatures(t||[]),this.reset()},ol.source.FeatureBin.prototype.getGridGeomAt=function(t,e){var o=this._sourceFeature.getFeaturesAtCoordinate(t)[0];if(!o)return null;var i=o.getProperties();for(var n in i)"geometry"!==n&&(e[n]=i[n]);return o.getGeometry()},ol.source.GeoImage=function(t){var e={attributions:t.attributions,logo:t.logo,projection:t.projection};this._image=t.image?t.image:new Image,this._image.crossOrigin=t.crossOrigin;var o=this;this._image.onload=function(){o.setCrop(o.crop),o.changed()},t.image||(this._image.src=t.url),e.canvasFunction=this.calculateImage,ol.source.ImageCanvas.call(this,e),this.center=t.imageCenter,this.setScale(t.imageScale),this.rotate=t.imageRotate?t.imageRotate:0,this.crop=t.imageCrop,this.mask=t.imageMask,this.setCrop(this.crop),this.on("change",function(){this.set("extent",this.calculateExtent())}.bind(this))},ol.ext.inherits(ol.source.GeoImage,ol.source.ImageCanvas),ol.source.GeoImage.prototype.calculateImage=function(t,e,o,i){if(this.center){var n=document.createElement("canvas");n.width=i[0],n.height=i[1];var r=n.getContext("2d");if(!this._imageSize)return n;if(this.mask){r.beginPath();var s=g(this.mask[0]);r.moveTo(s[0],s[1]);for(var a=1;a<this.mask.length;a++)s=g(this.mask[a]),r.lineTo(s[0],s[1]);r.clip()}var l=g(this.center),c=(this._image.naturalWidth/2-this.crop[0])*this.scale[0]/e*o,h=(this._image.naturalHeight/2-this.crop[1])*this.scale[1]/e*o,p=this._imageSize[0]*this.scale[0]/e*o,u=this._imageSize[1]*this.scale[1]/e*o;return r.translate(l[0],l[1]),this.rotate&&r.rotate(this.rotate),r.drawImage(this._image,this.crop[0],this.crop[1],this._imageSize[0],this._imageSize[1],-c,-h,p,u),n}function g(e){return[(e[0]-t[0])/(t[2]-t[0])*i[0],(e[1]-t[3])/(t[1]-t[3])*i[1]]}},ol.source.GeoImage.prototype.getCenter=function(){return this.center},ol.source.GeoImage.prototype.setCenter=function(t){this.center=t,this.changed()},ol.source.GeoImage.prototype.getScale=function(){return this.scale},ol.source.GeoImage.prototype.setScale=function(t){switch(typeof t){case"number":t=[t,t];break;case"object":if(2!=t.length)return;break;default:return}this.scale=t,this.changed()},ol.source.GeoImage.prototype.getRotation=function(){return this.rotate},ol.source.GeoImage.prototype.setRotation=function(t){this.rotate=t,this.changed()},ol.source.GeoImage.prototype.getGeoImage=function(){return this._image},ol.source.GeoImage.prototype.getCrop=function(){return this.crop},ol.source.GeoImage.prototype.setMask=function(t){this.mask=t,this.changed()},ol.source.GeoImage.prototype.getMask=function(){return this.mask},ol.source.GeoImage.prototype.setCrop=function(t){if(this._image.naturalWidth){if(t){switch(typeof t){case"number":t=[t,t,this._image.naturalWidth-t,this._image.naturalHeight-t];break;case"object":if(4!=t.length)return;break;default:return}t=ol.extent.boundingExtent([[t[0],t[1]],[t[2],t[3]]]),this.crop=[Math.max(0,t[0]),Math.max(0,t[1]),Math.min(this._image.naturalWidth,t[2]),Math.min(this._image.naturalHeight,t[3])]}else this.crop=[0,0,this._image.naturalWidth,this._image.naturalHeight];this.crop[2]<=this.crop[0]&&(this.crop[2]=this.crop[0]+1),this.crop[3]<=this.crop[1]&&(this.crop[3]=this.crop[1]+1),this._imageSize=[this.crop[2]-this.crop[0],this.crop[3]-this.crop[1]],this.changed()}else this.crop=t},ol.source.GeoImage.prototype.getExtent=function(t){var e=this.get("extent");if(e||(e=this.calculateExtent()),t)for(var o=0;o<t.length;o++)t[o]=e[o];return e},ol.source.GeoImage.prototype.calculateExtent=function(t){var e;if(!1!==t&&this.getMask())e=new ol.geom.Polygon([this.getMask()]);else{var o=this.getCenter(),i=this.getScale(),n=this.getGeoImage().width*i[0],r=this.getGeoImage().height*i[1],s=ol.extent.boundingExtent([[o[0]-n/2,o[1]-r/2],[o[0]+n/2,o[1]+r/2]]);(e=ol.geom.Polygon.fromExtent(s)).rotate(-this.getRotation(),o)}return e.getExtent()},ol.source.GeoRSS=function(t){(t=t||{}).loader=this._loaderFn,ol.source.Vector.call(this,t)},ol.ext.inherits(ol.source.GeoRSS,ol.source.Vector),ol.source.GeoRSS.prototype._loaderFn=function(t,e,o){ol.ext.Ajax.get({url:this.getUrl(),dataType:"XML",error:function(){console.log("oops")},success:function(t){var e=(new ol.format.GeoRSS).readFeatures(t,{featureProjection:o});this.addFeatures(e)}.bind(this)})},ol.source.Geoportail=function(t,e){e=e||{},t.layer&&(t=(e=t).layer);for(var o=new Array,i=new Array,n=ol.extent.getWidth(ol.proj.get("EPSG:3857").getExtent())/256,r=0;r<=(e.maxZoom?e.maxZoom:20);r++)o[r]=r,i[r]=n/Math.pow(2,r);var s=new ol.tilegrid.WMTS({origin:[-20037508,20037508],resolutions:i,matrixIds:o});s.minZoom=e.minZoom?e.minZoom:0;var a=[ol.source.Geoportail.prototype.attribution];e.attributions&&(a=e.attributions),this._server=e.server||"https://wxs.ign.fr/geoportail/wmts",this._gppKey=e.gppKey||e.key||"choisirgeoportail";var l={url:this.serviceURL(),layer:t,matrixSet:"PM",format:e.format?e.format:"image/jpeg",projection:"EPSG:3857",tileGrid:s,style:e.style?e.style:"normal",attributions:a,crossOrigin:void 0===e.crossOrigin?"anonymous":e.crossOrigin,wrapX:!(!1===e.wrapX)};ol.source.WMTS.call(this,l),e.authentication&&this.setTileLoadFunction(ol.source.Geoportail.tileLoadFunctionWithAuthentication(e.authentication,this.getFormat()))},ol.ext.inherits(ol.source.Geoportail,ol.source.WMTS),ol.source.Geoportail.prototype.attribution='<a href="http://www.geoportail.gouv.fr/">Géoportail</a> &copy; <a href="http://www.ign.fr/">IGN-France</a>',ol.source.Geoportail.prototype.serviceURL=function(){return this._server?this._server.replace(/^(https?:\/\/[^/]*)(.*)$/,"$1/"+this._gppKey+"$2"):(window.geoportailConfig?window.geoportailConfig.url:"https://wxs.ign.fr/")+this._gppKey+"/geoportail/wmts"},ol.source.Geoportail.prototype.getGPPKey=function(){return this._gppKey},ol.source.Geoportail.prototype.setGPPKey=function(t,e){this._gppKey=t;var o=this.serviceURL();this.setTileUrlFunction(function(){var t=ol.source.Geoportail.prototype.getTileUrlFunction().apply(this,arguments);if(t){var e=t.split("?");return o+"?"+e[1]}return t}),e&&this.setTileLoadFunction(ol.source.Geoportail.tileLoadFunctionWithAuthentication(e,this.getFormat()))},ol.source.Geoportail.prototype.getFeatureInfoUrl=function(t,e,o,i){i=i||{},o||(o=this.getProjection());var n=this.tileGrid.getTileCoordForCoordAndResolution(t,e),r=this.getTileUrlFunction()(n,1,o);if(!r)return r;var s=this.tileGrid.getResolution(n[0]),a=this.tileGrid.getTileCoordExtent(n),l=Math.floor((t[0]-a[0])/(s/1)),c=Math.floor((a[3]-t[1])/(s/1));return r.replace(/Request=GetTile/i,"Request=getFeatureInfo")+"&INFOFORMAT="+(i.INFO_FORMAT||"text/plain")+"&I="+l+"&J="+c},ol.source.Geoportail.prototype.getFeatureInfo=function(t,e,o){var i=this.getFeatureInfoUrl(t,e,null,o);ol.ext.Ajax.get({url:i,dataType:o.format||"text/plain",options:{encode:!1},success:function(t){o.callback&&o.callback(t)},error:o.error||function(){}})},ol.source.Geoportail.tileLoadFunctionWithAuthentication=function(t,e){if(t)return function(o,i){var n=new XMLHttpRequest;n.open("GET",i),n.setRequestHeader("Authorization","Basic "+t),n.responseType="arraybuffer",n.onload=function(){var t=new Uint8Array(this.response),i=new Blob([t],{type:e}),n=(window.URL||window.webkitURL).createObjectURL(i);o.getImage().src=n},n.onerror=function(){o.getImage().src=""},n.send()}},ol.source.GridBin=function(t){t=t||{},ol.source.BinBase.call(this,t),this.set("gridProjection",t.gridProjection||"EPSG:4326"),this.set("size",t.size||1)},ol.ext.inherits(ol.source.GridBin,ol.source.BinBase),ol.source.GridBin.prototype.setGridProjection=function(t){this.set("gridProjection",t),this.reset()},ol.source.GridBin.prototype.setSize=function(t){this.set("size",t),this.reset()},ol.source.GridBin.prototype.getGridGeomAt=function(t){t=ol.proj.transform(t,this.getProjection()||"EPSG:3857",this.get("gridProjection"));var e=this.get("size"),o=e*Math.floor(t[0]/e),i=e*Math.floor(t[1]/e);return new ol.geom.Polygon([[[o,i],[o+e,i],[o+e,i+e],[o,i+e],[o,i]]]).transform(this.get("gridProjection"),this.getProjection()||"EPSG:3857")},ol.source.HexBin=function(t){t=t||{},this._hexgrid=new ol.HexGrid(t),ol.source.BinBase.call(this,t)},ol.ext.inherits(ol.source.HexBin,ol.source.BinBase),ol.source.HexBin.prototype.getGridGeomAt=function(t){var e=this._hexgrid.coord2hex(t);return new ol.geom.Polygon([this._hexgrid.getHexagon(e)])},ol.source.HexBin.prototype.setSize=function(t,e){this._hexgrid.setSize(t),e||this.reset()},ol.source.HexBin.prototype.getSize=function(){return this._hexgrid.getSize()},ol.source.HexBin.prototype.setLayout=function(t,e){this._hexgrid.setLayout(t),e||this.reset()},ol.source.HexBin.prototype.getLayout=function(){return this._hexgrid.getLayout()},ol.source.HexBin.prototype.setOrigin=function(t,e){this._hexgrid.setOrigin(t),e||this.reset()},ol.source.HexBin.prototype.getOrigin=function(){return this._hexgrid.getOrigin()},ol.source.HexBin.prototype.getHexFeatures=function(){return ol.source.BinBase.prototype.getGridFeatures.call(this)},ol.source.IDW=function(t){(t=t||{}).canvasFunction=this.calculateImage,this._source=t.source,this._canvas=document.createElement("CANVAS"),this._source.on(["addfeature","removefeature","clear","removefeature"],function(){this.changed()}.bind(this)),ol.source.ImageCanvas.call(this,t),this.set("scale",t.scale||4),this._weight="function"==typeof t.weight?t.weight:function(e){return e.get(t.weight||"weight")}},ol.ext.inherits(ol.source.IDW,ol.source.ImageCanvas),ol.source.IDW.prototype.getSource=function(){return this._source},ol.source.IDW.prototype.hue2rgb=function(t){return(t=(t+6)%6)<1?Math.round(255*t):t<3?255:t<4?Math.round(255*(4-t)):0},ol.source.IDW.prototype.getColor=function(t){var e=4-.04*t;return[this.hue2rgb(e+2),this.hue2rgb(e),this.hue2rgb(e-2),255]},ol.source.IDW.prototype.setData=function(t,e,o){var i=this.getColor(t);e[o]=i[0],e[o+1]=i[1],e[o+2]=i[2],e[o+3]=i[3]},ol.source.IDW.prototype.getValue=function(t){if(!this._canvas)return null;var e=this.transform(t);return this._canvas.getContext("2d").getImageData(Math.round(e[0]),Math.round(e[1]),1,1).data},ol.source.IDW.prototype.calculateImage=function(t,e,o,i){if(!this._source)return this._canvas;var n,r,s=document.createElement("CANVAS"),a=s.width=Math.round(i[0]/(this.get("scale")*o)),l=s.height=Math.round(i[1]/(this.get("scale")*o)),c=s.getContext("2d"),h=c.getImageData(0,0,a,l),p=[],u=a/(t[2]-t[0]),g=l/(t[1]-t[3]),d=this.transform=function(e,o){return[(e[0]-t[0])*u,(e[1]-t[3])*g,o]};for(this._source.getFeatures().forEach(function(t){p.push(d(t.getGeometry().getFirstCoordinate(),this._weight(t)))}.bind(this)),r=0;r<l;r++)for(n=0;n<a;n++){for(var m=0,f=0,y=0;y<p.length;++y){var v=n-p[y][0],_=r-p[y][1],x=v*v+_*_;if(0===x){f=1,m=p[y][2];break}var b=1/(x*x);m+=b*p[y][2],f+=b}this.setData(m/f,h.data,4*(r*a+n))}return c.putImageData(h,0,0),this._canvas.width=Math.round(i[0]),this._canvas.height=Math.round(i[1]),this._canvas.getContext("2d").drawImage(s,0,0,i[0],i[1]),this._canvas},ol.source.InseeBin=function(t){t=t||{},this._grid=new ol.InseeGrid({size:t.size}),ol.source.BinBase.call(this,t)},ol.ext.inherits(ol.source.InseeBin,ol.source.BinBase),ol.source.InseeBin.prototype.setSize=function(t){this.getSize()!==t&&(this._grid.set("size",t),this.reset())},ol.source.InseeBin.prototype.getSize=function(){return this._grid.get("size")},ol.source.InseeBin.prototype.getGridGeomAt=function(t){return this._grid.getGridAtCoordinate(t,this.getProjection())},ol.source.InseeBin.prototype.getGridExtent=function(t){return this._grid.getExtent(t)},ol.source.Mapillary=function(t){var e=t||{};e.loader=this._loaderFn,this._maxResolution=e.maxResolution||100,this._limit=e.limit||100,e.attributions||(e.attributions=["&copy; <a href='https://www.mapillary.com/'>Mapillary</a>"]),e.strategy||(e.strategy=ol.loadingstrategy.bbox),ol.source.Vector.call(this,e)},ol.ext.inherits(ol.source.Mapillary,ol.source.Vector),ol.source.Mapillary.prototype.readFeature=function(){return!0},ol.source.Mapillary.prototype._loaderFn=function(t,e,o){if(!(e>this._maxResolution)){var i=ol.proj.transformExtent(t,o,"EPSG:4326"),n=Date.now()-15552e6,r="https://a.mapillary.com/v2/search/im?client_id="+this.get("clientId")+"&max_lat="+i[3]+"&max_lon="+i[2]+"&min_lat="+i[1]+"&min_lon="+i[0]+"&limit="+(this._limit-1)+"&start_time="+n;ol.ext.Ajax.get({url:r,dataType:"jsonp",success:function(t){console.log(t)}})}},ol.source.OilPainting=function(t){t.operation=this._operation,t.operationType="image",ol.source.Raster.call(this,t),this.set("radius",t.radius||4),this.set("intensity",t.intensity||25),this.on("beforeoperations",function(t){var e=Math.round((t.extent[2]-t.extent[0])/t.resolution),o=Math.round((t.extent[3]-t.extent[1])/t.resolution);t.data.image=new ImageData(e,o),t.data.radius=Number(this.get("radius"))||1,t.data.intensity=Number(this.get("intensity"))}.bind(this))},ol.ext.inherits(ol.source.OilPainting,ol.source.Raster),ol.source.OilPainting.prototype.set=function(t,e){if(e)switch(t){case"intensity":case"radius":(e=Number(e))<1&&(e=1),this.changed()}return ol.source.Raster.prototype.set.call(this,t,e)},ol.source.OilPainting.prototype._operation=function(t,e){for(var o=t[0].width,i=t[0].height,n=t[0].data,r=[],s=e.image,a=s.data,l=[],c=[],h=0;h<i;h++){l[h]=[],c[h]=[];for(var p=0;p<o;p++){var u=4*(h*o+p),g=n[u],d=n[u+1],m=n[u+2],f=(g+d+m)/3;l[h][p]=Math.round(f*e.intensity/255),c[h][p]={r:g,g:d,b:m}}}var y=e.radius;for(h=0;h<i;h++)for(p=0;p<o;p++){r=[];for(var v=-y;v<=y;v++)for(var _=-y;_<=y;_++)if(h+v>0&&h+v<i&&p+_>0&&p+_<o){var x=l[h+v][p+_];r[x]?(r[x].val++,r[x].r+=c[h+v][p+_].r,r[x].g+=c[h+v][p+_].g,r[x].b+=c[h+v][p+_].b):r[x]={val:1,r:c[h+v][p+_].r,g:c[h+v][p+_].g,b:c[h+v][p+_].b}}r.sort(function(t,e){return e.val-t.val});var b=r[0].val,w=4*(h*o+p);a[w]=~~(r[0].r/b),a[w+1]=~~(r[0].g/b),a[w+2]=~~(r[0].b/b),a[w+3]=255}return s},ol.source.Overpass=function(t){(t=t||{}).loader=this._loaderFn,this._url=t.url||"https://overpass-api.de/api/interpreter",this._maxResolution=t.maxResolution||100,t.attributions||(t.attributions=ol.source.OSM.ATTRIBUTION),t.strategy||(t.strategy=ol.loadingstrategy.bbox),ol.source.Vector.call(this,t),this._types={node:!1!==t.node,way:!1!==t.way,rel:!0===t.rel},this._filter=t.filter},ol.ext.inherits(ol.source.Overpass,ol.source.Vector),ol.source.Overpass.prototype._loaderFn=function(t,e,o){if(!(e>this._maxResolution)){var i=this,n=ol.proj.transformExtent(t,o,"EPSG:4326"),r="[bbox:"+(n=n[1]+","+n[0]+","+n[3]+","+n[2])+"][out:xml][timeout:25];";for(var s in r+="(",this._types)if(this._types[s]){r+=s;for(var a,l=0;a=this._filter[l];l++)r+="["+a+"]";r+=";"}r+=");out;>;out skel qt;";var c=new XMLHttpRequest;c.open("POST",this._url,!0),c.onload=function(){for(var t,e=(new ol.format.OSMXML).readFeatures(this.responseText,{featureProjection:o}),n=[],r=0;t=e[r];r++)i.hasFeature(t)||n.push(t);i.addFeatures(n)},c.onerror=function(){console.log(arguments)},c.send("data="+r)}},ol.source.Overpass.prototype.hasFeature=function(t){for(var e,o=t.getGeometry().getFirstCoordinate(),i=t.getId(),n=this.getFeaturesInExtent([o[0]-.1,o[1]-.1,o[0]+.1,o[1]+.1]),r=0;e=n[r];r++)if(i===e.getId())return!0;return!1},ol.source.TileWFS=function(t){(t=t||{}).featureLimit||(t.featureLimit=1/0);var e=t.tileZoom||14,o={strategy:ol.loadingstrategy.tile(ol.tilegrid.createXYZ({minZoom:e,maxZoom:e,tileSize:512}))},i=new ol.format.GeoJSON,n=t.url+"?service=WFS&request=GetFeature&version="+(t.version||"1.1.0")+"&typename="+(t.typeName||"")+"&outputFormat=application/json";t.maxFeatures&&(n+="&maxFeatures="+t.maxFeatures+"&count="+t.maxFeatures);var r={loading:0,loaded:0};o.loader=function(e,o,s){r.loading===r.loaded&&(r.loading=r.loaded=0,this.getFeatures().length>t.maxFeatures&&(this.clear(),this.refresh())),r.loading++,this.dispatchEvent({type:"tileloadstart",loading:r.loading,loaded:r.loaded}),this._loadTile(n,e,s,i,r)},ol.source.Vector.call(this,o),this.set("pagination",t.pagination)},ol.ext.inherits(ol.source.TileWFS,ol.source.Vector),ol.source.TileWFS.prototype._loadTile=function(t,e,o,i,n){var r=t+"&srsname="+o.getCode()+"&bbox="+e.join(",")+","+o.getCode();this.get("pagination")&&!/&startIndex/.test(t)&&(r+="&startIndex=0"),ol.ext.Ajax.get({url:r,success:function(r){if(n.loaded++,r.error)this.dispatchEvent({type:"tileloaderror",error:r,loading:n.loading,loaded:n.loaded});else{var s=i.readFeatures(r,{featureProjection:o});s.length>0&&this.addFeatures(s);var a=r.numberReturned||0;/&startIndex/.test(t)&&(a+=parseInt(t.replace(/.*&startIndex=(\d*).*/,"$1")),t=t.replace(/&startIndex=(\d*)/,"")),a<r.totalFeatures?this.get("pagination")?(t+="&startIndex="+a,n.loaded--,this._loadTile(t,e,o,i,n)):(this.dispatchEvent({type:"overload",total:r.totalFeatures,returned:r.numberReturned}),this.dispatchEvent({type:"tileloadend",loading:n.loading,loaded:n.loaded})):this.dispatchEvent({type:"tileloadend",loading:n.loading,loaded:n.loaded})}}.bind(this),error:function(t){n.loaded++,this.dispatchEvent({type:"tileloaderror",error:t,loading:n.loading,loaded:n.loaded})}.bind(this)})},function(){var t=ol.source.Vector.prototype.clear;ol.source.Vector.prototype.clear=function(e){this.dispatchEvent({type:"clearstart"}),t.call(this,e),this.dispatchEvent({type:"clearend"})}}(),ol.layer.Vector3D=function(t){t=t||{},this._source=t.source,this.height_=this.getHfn(t.height);var e=document.createElement("canvas");ol.layer.Image.call(this,{source:new ol.source.ImageCanvas({canvasFunction:function(t,o,i,n){return e.width=n[0],e.height=n[1],e}}),center:t.center||[.5,1],defaultHeight:t.defaultHeight||0,maxResolution:t.maxResolution||1/0}),this.setStyle(t.style),this.on(["postcompose","postrender"],this.onPostcompose_.bind(this))},ol.ext.inherits(ol.layer.Vector3D,ol.layer.Image),ol.layer.Vector3D.prototype.setHeight=function(t){this.height_=this.getHfn(t),this.changed()},ol.layer.Vector3D.prototype.setStyle=function(t){if(t instanceof ol.style.Style?this._style=t:this._style=new ol.style.Style,this._style.getStroke()||this._style.setStroke(new ol.style.Stroke({width:1,color:"red"})),this._style.getFill()||this._style.setFill(new ol.style.Fill({color:"rgba(0,0,255,0.5)"})),this._style.getText()||this._style.setText(new ol.style.Fill({color:"red"})),t&&t.getGeometry()){var e=t.getGeometry();"function"==typeof e?this.set("geometry",e):this.set("geometry",function(){return e})}else this.set("geometry",function(t){return t.getGeometry()})},ol.layer.Vector3D.prototype.getStyle=function(){return this._style},ol.layer.Vector3D.prototype.onPostcompose_=function(t){var e=t.frameState.viewState.resolution;if(!(e>this.get("maxResolution"))){if(this.res_=400*e,this.animate_){var o=t.frameState.time-this.animate_;o<this.animateDuration_?(this.elapsedRatio_=this.easing_(o/this.animateDuration_),t.frameState.animate=!0):(this.animate_=!1,this.height_=this.toHeight_)}var i=t.frameState.pixelRatio,n=t.context,r=this.matrix_=t.frameState.coordinateToPixelTransform;r||((r=t.frameState.coordinateToPixelMatrix)[2]=r[4],r[3]=r[5],r[4]=r[12],r[5]=r[13]),this.center_=[n.canvas.width*this.get("center")[0]/i,n.canvas.height*this.get("center")[1]/i];var s=this._source.getFeaturesInExtent(t.frameState.extent);n.save(),n.scale(i,i);var a=this.getStyle();n.lineWidth=a.getStroke().getWidth(),n.lineCap=a.getStroke().getLineCap(),n.strokeStyle=ol.color.asString(a.getStroke().getColor()),n.fillStyle=ol.color.asString(a.getFill().getColor());for(var l=[],c=0;c<s.length;c++)l.push(this.getFeature3D_(s[c],this._getFeatureHeight(s[c])));this.drawFeature3D_(n,l),n.restore()}},ol.layer.Vector3D.prototype.getHfn=function(t){switch(typeof t){case"function":return t;case"string":var e=this.get("defaultHeight");return function(o){return Number(o.get(t))||e};case"number":return function(){return t};default:return function(){return 10}}},ol.layer.Vector3D.prototype.animate=function(t){t=t||{},this.toHeight_=this.getHfn(t.height),this.animate_=(new Date).getTime(),this.animateDuration_=t.duration||1e3,this.easing_=t.easing||ol.easing.easeOut,this.changed()},ol.layer.Vector3D.prototype.animating=function(){return this.animate_&&(new Date).getTime()-this.animate_>this.animateDuration_&&(this.animate_=!1),!!this.animate_},ol.layer.Vector3D.prototype._getFeatureHeight=function(t){if(this.animate_){var e=this.height_(t),o=this.toHeight_(t);return e*(1-this.elapsedRatio_)+this.elapsedRatio_*o}return this.height_(t)},ol.layer.Vector3D.prototype.hvector_=function(t,e){var o=[t[0]*this.matrix_[0]+t[1]*this.matrix_[1]+this.matrix_[4],t[0]*this.matrix_[2]+t[1]*this.matrix_[3]+this.matrix_[5]];return{p0:o,p1:[o[0]+e/this.res_*(o[0]-this.center_[0]),o[1]+e/this.res_*(o[1]-this.center_[1])]}},ol.layer.Vector3D.prototype.getFeature3D_=function(t,e){var o=this.get("geometry")(t),i=o.getCoordinates();switch(o.getType()){case"Polygon":i=[i];case"MultiPolygon":for(var n=[],r=0;r<i.length;r++)for(var s=0;s<i[r].length;s++){for(var a=[],l=0;l<i[r][s].length;l++)a.push(this.hvector_(i[r][s][l],e));n.push(a)}return{type:"MultiPolygon",feature:t,geom:n};case"Point":return{type:"Point",feature:t,geom:this.hvector_(i,e)};default:return{}}},ol.layer.Vector3D.prototype.drawFeature3D_=function(t,e){var o,i,n,r;for(o=0;o<e.length;o++)switch(e[o].type){case"MultiPolygon":for(i=0;i<e[o].geom.length;i++)for(n=e[o].geom[i],r=0;r<n.length;r++)t.beginPath(),t.moveTo(n[r].p0[0],n[r].p0[1]),t.lineTo(n[r].p1[0],n[r].p1[1]),t.stroke();break;case"Point":var s=e[o].geom;t.beginPath(),t.moveTo(s.p0[0],s.p0[1]),t.lineTo(s.p1[0],s.p1[1]),t.stroke()}for(o=0;o<e.length;o++)switch(e[o].type){case"MultiPolygon":for(t.beginPath(),i=0;i<e[o].geom.length;i++){if(n=e[o].geom[i],0==i)for(t.moveTo(n[0].p1[0],n[0].p1[1]),r=1;r<n.length;r++)t.lineTo(n[r].p1[0],n[r].p1[1]);else for(t.moveTo(n[0].p1[0],n[0].p1[1]),r=n.length-2;r>=0;r--)t.lineTo(n[r].p1[0],n[r].p1[1]);t.closePath()}t.fill("evenodd"),t.stroke();break;case"Point":var a=(n=e[o]).feature.get("label");if(a){var l=n.geom.p1,c=t.measureText(a),h=Number(t.font.match(/\d+(\.\d+)?/g).join([]));t.fillRect(l[0]-c.width/2-5,l[1]-h-5,c.width+10,h+10),t.strokeRect(l[0]-c.width/2-5,l[1]-h-5,c.width+10,h+10),t.save(),t.fillStyle=ol.color.asString(this._style.getText().getFill().getColor()),t.textAlign="center",t.textBaseline="bottom",t.fillText(a,l[0],l[1]),t.restore()}}},ol.source.WikiCommons=function(t){var e=t||{};e.loader=this._loaderFn,this._maxResolution=e.maxResolution||100,this._lang=e.lang||"fr",this._limit=e.limit||100,e.attributions||(e.attributions=["&copy; <a href='https://commons.wikimedia.org/'>Wikimedia Commons</a>"]),e.strategy||(e.strategy=ol.loadingstrategy.bbox),ol.source.Vector.call(this,e)},ol.ext.inherits(ol.source.WikiCommons,ol.source.Vector),ol.source.WikiCommons.prototype.readFeature=function(t,e){return t.set("descriptionurl",e.descriptionurl),t.set("url",e.url),t.set("title",e.title.replace(/^file:|.jpg$/gi,"")),t.set("thumbnail",e.url.replace(/^(.+wikipedia\/commons)\/([a-zA-Z0-9]\/[a-zA-Z0-9]{2})\/(.+)$/,"$1/thumb/$2/$3/200px-$3")),t.set("user",e.user),e.extmetadata&&e.extmetadata.LicenseShortName&&t.set("copy",e.extmetadata.LicenseShortName.value),!0},ol.source.WikiCommons.prototype._loaderFn=function(t,e,o){if(!(e>this._maxResolution)){var i=this,n=ol.proj.transformExtent(t,o,"EPSG:4326"),r="https://commons.wikimedia.org/w/api.php?action=query&format=json&origin=*&prop=coordinates|imageinfo&generator=geosearch&iiprop=timestamp|user|url|extmetadata|metadata|size&iiextmetadatafilter=LicenseShortName&ggsbbox="+n[3]+"|"+n[0]+"|"+n[1]+"|"+n[2]+"&ggslimit="+this._limit+"&iilimit="+(this._limit-1)+"&ggsnamespace=6";ol.ext.Ajax.get({url:r,success:function(t){var e,n,r,s=[];if(t.query&&t.query.pages){for(var a in t.query.pages){if((e=t.query.pages[a]).coordinates&&e.coordinates.length)n=[e.coordinates[0].lon,e.coordinates[0].lat];else{var l=e.imageinfo[0].metadata;if(!l)continue;n=[];for(var c=0,h=0;h<l.length;h++)"GPSLongitude"==l[h].name&&(n[0]=l[h].value,c++),"GPSLatitude"==l[h].name&&(n[1]=l[h].value,c++);if(2!=c)continue}r=new ol.Feature(new ol.geom.Point(ol.proj.transform(n,"EPSG:4326",o))),e.imageinfo[0].title=e.title,i.readFeature(r,e.imageinfo[0])&&s.push(r)}i.addFeatures(s)}}})}},ol.layer.AnimatedCluster=function(t){var e=t||{};ol.layer.Vector.call(this,e),this.oldcluster=new ol.source.Vector,this.clusters=[],this.animation={start:!1},this.set("animationDuration","number"==typeof e.animationDuration?e.animationDuration:700),this.set("animationMethod",e.animationMethod||ol.easing.easeOut),this.getSource().on("change",this.saveCluster.bind(this)),this.on(["precompose","prerender"],this.animate.bind(this)),this.on(["postcompose","postrender"],this.postanimate.bind(this))},ol.ext.inherits(ol.layer.AnimatedCluster,ol.layer.Vector),ol.layer.AnimatedCluster.prototype.saveCluster=function(){if(this.oldcluster){if(this.oldcluster.clear(),!this.get("animationDuration"))return;var t=this.getSource().getFeatures();t.length&&t[0].get("features")&&(this.oldcluster.addFeatures(this.clusters),this.clusters=t.slice(0),this.sourceChanged=!0)}},ol.layer.AnimatedCluster.prototype.getClusterForFeature=function(t,e){for(var o,i=0;o=e[i];i++){var n=o.get("features");if(n&&n.length)for(var r,s=0;r=n[s];s++)if(t===r)return o}return!1},ol.layer.AnimatedCluster.prototype.stopAnimation=function(){this.animation.start=!1,this.animation.cA=[],this.animation.cB=[]},ol.layer.AnimatedCluster.prototype.animate=function(t){var e=this.get("animationDuration");if(e){var o,i,n=t.frameState.viewState.resolution,r=this.animation,s=t.frameState.time;if(r.resolution!=n&&this.sourceChanged){var a=t.frameState.extent;for(r.resolution<n?(a=ol.extent.buffer(a,100*n),r.cA=this.oldcluster.getFeaturesInExtent(a),r.cB=this.getSource().getFeaturesInExtent(a),r.revers=!1):(a=ol.extent.buffer(a,100*n),r.cA=this.getSource().getFeaturesInExtent(a),r.cB=this.oldcluster.getFeaturesInExtent(a),r.revers=!0),r.clusters=[],o=0;i=r.cA[o];o++){var l=i.get("features");if(l&&l.length){var c=this.getClusterForFeature(l[0],r.cB);c&&r.clusters.push({f:i,pt:c.getGeometry().getCoordinates()})}}if(r.resolution=n,this.sourceChanged=!1,!r.clusters.length||r.clusters.length>1e3)return void this.stopAnimation();s=r.start=(new Date).getTime()}if(r.start){var h=t.vectorContext||ol.render.getVectorContext(t),p=(s-r.start)/e;p>1&&(this.stopAnimation(),p=1),p=this.get("animationMethod")(p);var u=this.getStyle(),g="function"==typeof u?u:u.length?function(){return u}:function(){return[u]};for(t.context.save(),t.context.globalAlpha=this.getOpacity(),o=0;c=r.clusters[o];o++){var d=c.f.getGeometry().getCoordinates(),m=d[0]-c.pt[0],f=d[1]-c.pt[1];r.revers?(d[0]=c.pt[0]+p*m,d[1]=c.pt[1]+p*f):(d[0]=d[0]-p*m,d[1]=d[1]-p*f);var y=g(c.f,n,!0);if(y.length||(y=[y]),1!==c.f.get("features").length||m||f){var v=new ol.geom.Point(d);l=new ol.Feature(v)}else l=c.f.get("features")[0];for(var _,x=0;_=y[x];x++)if(_.getText()&&/\n/.test(_.getText().getText())){var b,w=_.getText().getOffsetX(),S=_.getText().getOffsetY(),C=_.getText().getRotation()||0,M=1.2*Number((_.getText().getFont()||"10px").match(/\d+/)),E=_.getText().getText().split("\n"),T=E.length-1,L=_.clone();E.forEach(function(e,o){switch(1==o&&(L.setImage(),L.setFill(),L.setStroke()),_.getText().getTextBaseline()){case"alphabetic":case"ideographic":case"bottom":b=T;break;case"hanging":case"top":b=0;break;default:b=T/2}L.getText().setOffsetX(w-Math.sin(C)*M*(o-b)),L.getText().setOffsetY(S+Math.cos(C)*M*(o-b)),L.getText().setText(e),h.drawFeature(l,ol.ext.getVectorContextStyle(t,L))})}else h.drawFeature(l,ol.ext.getVectorContextStyle(t,_))}t.context.restore(),t.frameState.animate=!0,t.context.save(),t.context.beginPath(),t.context.rect(0,0,0,0),t.context.clip(),this.clip_=!0}}},ol.layer.AnimatedCluster.prototype.postanimate=function(t){this.clip_&&(t.context.restore(),this.clip_=!1)},ol.layer.GeoImage=function(t){ol.layer.Image.call(this,t)},ol.ext.inherits(ol.layer.GeoImage,ol.layer.Image),ol.layer.GeoImage.prototype.getExtent=function(){return this.getSource().getExtent()},ol.layer.Geoportail=function(t,e,o){e=e||{},o=o||{},"string"!=typeof t&&(o=e||{},t=(e=t).layer);var i=e.maxZoom;e.source&&(t=e.source.getLayer(),e.gppKey=e.source.getGPPKey());var n=window.geoportailConfig&&(window.geoportailConfig.capabilities[e.gppKey||e.key]||window.geoportailConfig.capabilities.default)||ol.layer.Geoportail.capabilities;for(var r in(n=n[t])||(n=ol.layer.Geoportail.capabilities[t]),n||(n={title:t,originators:[]},console.error('ol.layer.Geoportail: no layer definition for "'+t+'"\nTry to use ol/layer/Geoportail~loadCapabilities() to get it.')),n)void 0===o[r]&&(o[r]=n[r]);this._originators=n.originators,o.gppKey||o.key||(o.gppKey=e.gppKey||e.key),e.source||(e.source=new ol.source.Geoportail(t,o)),e.title||(e.title=n.title),e.name||(e.name=t),e.layer=t,e.queryable||(e.queryable=n.queryable),e.desc||(e.desc=n.desc),!e.extent&&n.bbox&&n.bbox[0]>-170&&n.bbox[2]<170&&(e.extent=ol.proj.transformExtent(n.bbox,"EPSG:4326",e.projection||"EPSG:3857")),e.maxZoom=i,!e.maxResolution&&o.minZoom&&(e.source.getTileGrid().minZoom-=o.minZoom>1?2:1,e.maxResolution=e.source.getTileGrid().getResolution(e.source.getTileGrid().minZoom),e.source.getTileGrid().minZoom=o.minZoom),ol.layer.Tile.call(this,e)},ol.ext.inherits(ol.layer.Geoportail,ol.layer.Tile),ol.layer.Geoportail.capabilities={"GEOGRAPHICALGRIDSYSTEMS.PLANIGNV2":{key:"cartes",server:"https://wxs.ign.fr/geoportail/wmts",layer:"GEOGRAPHICALGRIDSYSTEMS.PLANIGNV2",title:"Plan IGN v2",format:"image/png",style:"normal",queryable:!1,tilematrix:"PM",minZoom:0,maxZoom:19,bbox:[-175,-85,175,85],desc:"Cartographie multi-échelles sur le territoire national, issue des bases de données vecteur de l’IGN, mis à jour régulièrement et réalisée selon un processus entièrement automatisé. Version actuellement en beta test",originators:{IGN:{href:"http://www.ign.fr",attribution:"Institut national de l'information géographique et forestière",logo:"https://wxs.ign.fr/static/logos/IGN/IGN.gif",minZoom:0,maxZoom:19,constraint:[{minZoom:0,maxZoom:19,bbox:[-175,-85,175,85]}]}}},"CADASTRALPARCELS.PARCELLAIRE_EXPRESS":{key:"parcellaire",server:"https://wxs.ign.fr/geoportail/wmts",layer:"CADASTRALPARCELS.PARCELLAIRE_EXPRESS",title:"PCI vecteur",format:"image/png",style:"PCI vecteur",queryable:!1,tilematrix:"PM",minZoom:0,maxZoom:19,bbox:[-63.37252,-21.475586,55.925865,51.31212],desc:"Plan cadastral informatisé vecteur de la DGFIP.",originators:{IGN:{href:"http://www.ign.fr",attribution:"Institut national de l'information géographique et forestière",logo:"https://wxs.ign.fr/static/logos/IGN/IGN.gif",minZoom:0,maxZoom:19,constraint:[{minZoom:0,maxZoom:19,bbox:[-63.37252,-21.475586,55.925865,51.31212]}]}}},"ORTHOIMAGERY.ORTHOPHOTOS":{key:"ortho",server:"https://wxs.ign.fr/geoportail/wmts",layer:"ORTHOIMAGERY.ORTHOPHOTOS",title:"Photographies aériennes",format:"image/jpeg",style:"normal",queryable:!0,tilematrix:"PM",minZoom:0,bbox:[-178.18713,-22.767689,167.94624,51.11242],desc:"Photographies aériennes",originators:{CRCORSE:{href:"http://www.corse.fr//",attribution:"CRCORSE",logo:"https://wxs.ign.fr/static/logos/CRCORSE/CRCORSE.gif",minZoom:13,maxZoom:19,constraint:[{minZoom:13,maxZoom:19,bbox:[8.428783,41.338627,9.688606,43.08541]}]},SIGLR:{href:"http://www.siglr.org//",attribution:"SIGLR",logo:"https://wxs.ign.fr/static/logos/SIGLR/SIGLR.gif",minZoom:13,maxZoom:19,constraint:[{minZoom:13,maxZoom:19,bbox:[1.6784439,42.316307,4.8729386,44.978218]}]},"BOURGOGNE-FRANCHE-COMTE":{href:"https://www.bourgognefranchecomte.fr/",attribution:"Auvergne",logo:"https://wxs.ign.fr/static/logos/BOURGOGNE-FRANCHE-COMTE/BOURGOGNE-FRANCHE-COMTE.gif",minZoom:13,maxZoom:19,constraint:[{minZoom:13,maxZoom:19,bbox:[2.837849,46.131435,7.1713247,48.408287]}]},FEDER_AUVERGNE:{href:"http://www.europe-en-auvergne.eu/",attribution:"Auvergne",logo:"https://wxs.ign.fr/static/logos/FEDER_AUVERGNE/FEDER_AUVERGNE.gif",minZoom:13,maxZoom:19,constraint:[{minZoom:13,maxZoom:19,bbox:[2.0398402,44.60505,3.38408,45.49146]}]},FEDER_PAYSDELALOIRE:{href:"https://www.europe.paysdelaloire.fr/",attribution:"Pays-de-la-Loire",logo:"https://wxs.ign.fr/static/logos/FEDER_PAYSDELALOIRE/FEDER_PAYSDELALOIRE.gif",minZoom:13,maxZoom:19,constraint:[{minZoom:13,maxZoom:19,bbox:[-2.457367,46.19304,.951426,48.57609]}]},IGN:{href:"http://www.ign.fr",attribution:"Institut national de l'information géographique et forestière",logo:"https://wxs.ign.fr/static/logos/IGN/IGN.gif",minZoom:13,maxZoom:20,constraint:[{minZoom:19,maxZoom:19,bbox:[-63.160706,-21.401262,55.84643,51.11242]},{bbox:[.035491213,43.221077,6.0235267,49.696926]},{minZoom:20,maxZoom:20,bbox:[.035491213,43.221077,6.0235267,49.696926]},{minZoom:13,maxZoom:18,bbox:[-178.18713,-21.401329,55.85611,51.11242]}]},"E-MEGALIS":{href:"http://www.e-megalisbretagne.org//",attribution:"Syndicat mixte de coopération territoriale (e-Megalis)",logo:"https://wxs.ign.fr/static/logos/E-MEGALIS/E-MEGALIS.gif",minZoom:13,maxZoom:19,constraint:[{minZoom:13,maxZoom:19,bbox:[-3.7059498,47.971947,-1.8486879,48.99035]}]},FEDER2:{href:"http://www.europe-en-france.gouv.fr/",attribution:"Fonds européen de développement économique et régional",logo:"https://wxs.ign.fr/static/logos/FEDER2/FEDER2.gif",minZoom:13,maxZoom:19,constraint:[{minZoom:13,maxZoom:19,bbox:[1.3577043,48.824635,4.269964,50.37648]}]},PREFECTURE_GUADELOUPE:{href:"www.guadeloupe.pref.gouv.fr/",attribution:"guadeloupe",logo:"https://wxs.ign.fr/static/logos/PREFECTURE_GUADELOUPE/PREFECTURE_GUADELOUPE.gif",minZoom:13,maxZoom:19,constraint:[{minZoom:13,maxZoom:19,bbox:[-61.82342,14.371942,-60.787838,16.521578]}]},OCCITANIE:{href:"https://www.laregion.fr/",attribution:"La Région Occitanie; Pyrénées - Méditerranée",logo:"https://wxs.ign.fr/static/logos/OCCITANIE/OCCITANIE.gif",minZoom:13,maxZoom:19,constraint:[{minZoom:13,maxZoom:19,bbox:[2.2086434,48.805965,2.4859917,48.915382]}]},RGD_SAVOIE:{href:"http://www.rgd.fr",attribution:"Régie de Gestion de Données des Pays de Savoie (RGD 73-74)",logo:"https://wxs.ign.fr/static/logos/RGD_SAVOIE/RGD_SAVOIE.gif",minZoom:13,maxZoom:19,constraint:[{minZoom:19,maxZoom:19,bbox:[5.7759595,45.65335,7.0887337,46.438328]},{minZoom:13,maxZoom:18,bbox:[5.5923314,45.017353,7.2323394,46.438328]}]},CG45:{href:"http://www.loiret.com",attribution:"Le conseil général du Loiret",logo:"https://wxs.ign.fr/static/logos/CG45/CG45.gif",minZoom:13,maxZoom:19,constraint:[{minZoom:13,maxZoom:19,bbox:[1.4883244,47.471867,3.1349874,48.354233]}]},CRAIG:{href:"http://www.craig.fr",attribution:"Centre Régional Auvergnat de l'Information Géographique (CRAIG)",logo:"https://wxs.ign.fr/static/logos/CRAIG/CRAIG.gif",minZoom:13,maxZoom:20,constraint:[{minZoom:13,maxZoom:19,bbox:[2.0398402,44.60505,6.4295278,46.8038]},{minZoom:20,maxZoom:20,bbox:[2.2243388,44.76621,2.7314367,45.11295]}]},"e-Megalis":{href:"http://www.e-megalisbretagne.org//",attribution:"Syndicat mixte de coopération territoriale (e-Megalis)",logo:"https://wxs.ign.fr/static/logos/e-Megalis/e-Megalis.gif",minZoom:13,maxZoom:19,constraint:[{minZoom:13,maxZoom:19,bbox:[-5.1937118,47.23789,-.98568505,48.980812]}]},PPIGE:{href:"http://www.ppige-npdc.fr/",attribution:"PPIGE",logo:"https://wxs.ign.fr/static/logos/PPIGE/PPIGE.gif",minZoom:13,maxZoom:19,constraint:[{minZoom:13,maxZoom:19,bbox:[1.5212119,49.957302,4.2673664,51.090965]}]},CG06:{href:"http://www.cg06.fr",attribution:"Département Alpes Maritimes (06) en partenariat avec : Groupement Orthophoto 06 (NCA, Ville de Cannes, CARF, CASA,CG06, CA de Grasse) ",logo:"https://wxs.ign.fr/static/logos/CG06/CG06.gif",minZoom:13,maxZoom:19,constraint:[{minZoom:13,maxZoom:19,bbox:[6.6093955,43.44647,7.7436337,44.377018]}]},"MEGALIS-BRETAGNE":{href:"https://www.megalisbretagne.org/",attribution:"Syndicat mixte Mégalis Bretagne",logo:"https://wxs.ign.fr/static/logos/MEGALIS-BRETAGNE/MEGALIS-BRETAGNE.gif",minZoom:13,maxZoom:19,constraint:[{minZoom:13,maxZoom:19,bbox:[-5.2086344,47.591938,-3.3396015,48.808697]}]},FEDER:{href:"http://www.europe-en-france.gouv.fr/",attribution:"Fonds européen de développement économique et régional",logo:"https://wxs.ign.fr/static/logos/FEDER/FEDER.gif",minZoom:0,maxZoom:19,constraint:[{minZoom:13,maxZoom:19,bbox:[-1.9662633,42.316307,8.25674,50.18387]},{minZoom:0,maxZoom:12,bbox:[-2.400665,41.333557,9.560094,50.366302]}]},"LANGUEDOC-ROUSSILLON":{href:"https://www.laregion.fr/",attribution:"Région Occitanie",logo:"https://wxs.ign.fr/static/logos/LANGUEDOC-ROUSSILLON/LANGUEDOC-ROUSSILLON.gif",minZoom:13,maxZoom:19,constraint:[{minZoom:13,maxZoom:19,bbox:[1.6784439,42.63972,4.208843,43.979004]}]},GRAND_EST:{href:"https://www.grandest.fr/",attribution:"Hauts-de-France",logo:"https://wxs.ign.fr/static/logos/GRAND_EST/GRAND_EST.gif",minZoom:13,maxZoom:19,constraint:[{minZoom:13,maxZoom:19,bbox:[5.362788,47.390827,7.6924667,49.58011]}]},CNES_AUVERGNE:{href:"http://www.cnes.fr/",attribution:"Centre national d'études spatiales (CNES)",logo:"https://wxs.ign.fr/static/logos/CNES_AUVERGNE/CNES_AUVERGNE.gif",minZoom:13,maxZoom:19,constraint:[{minZoom:13,maxZoom:19,bbox:[2.2656832,45.279934,4.0227704,46.8038]}]},HAUTS_DE_FRANCE:{href:"https://www.hautsdefrance.fr/",attribution:"Hauts-de-France",logo:"https://wxs.ign.fr/static/logos/HAUTS_DE_FRANCE/HAUTS_DE_FRANCE.gif",minZoom:13,maxZoom:19,constraint:[{minZoom:13,maxZoom:19,bbox:[2.0740242,48.81521,4.3390365,51.11242]}]},MPM:{href:"http://www.marseille-provence.com/",attribution:"Marseille Provence Métropole",logo:"https://wxs.ign.fr/static/logos/MPM/MPM.gif",minZoom:20,maxZoom:20,constraint:[{minZoom:20,maxZoom:20,bbox:[5.076959,43.153347,5.7168245,43.454994]}]},DITTT:{href:"http://www.dittt.gouv.nc/portal/page/portal/dittt/",attribution:"Direction des Infrastructures, de la Topographie et des Transports Terrestres",logo:"https://wxs.ign.fr/static/logos/DITTT/DITTT.gif",minZoom:13,maxZoom:18,constraint:[{minZoom:13,maxZoom:18,bbox:[163.47784,-22.767689,167.94624,-19.434975]}]},CNES_978:{href:"http://www.cnes.fr/",attribution:"Centre national d'études spatiales (CNES)",logo:"https://wxs.ign.fr/static/logos/CNES_978/CNES_978.gif",minZoom:13,maxZoom:18,constraint:[{minZoom:13,maxZoom:18,bbox:[-63.160706,18.04345,-62.962185,18.133898]}]},CNES_ALSACE:{href:"http://www.cnes.fr/",attribution:"Centre national d'études spatiales (CNES)",logo:"https://wxs.ign.fr/static/logos/CNES_ALSACE/CNES_ALSACE.gif",minZoom:13,maxZoom:18,constraint:[{minZoom:13,maxZoom:18,bbox:[6.8086324,47.39981,7.668318,48.32695]}]},CNES_974:{href:"http://www.cnes.fr/",attribution:"Centre national d'études spatiales (CNES)",logo:"https://wxs.ign.fr/static/logos/CNES_974/CNES_974.gif",minZoom:13,maxZoom:18,constraint:[{minZoom:13,maxZoom:18,bbox:[55.205757,-21.401262,55.84643,-20.862825]}]},CNES_975:{href:"http://www.cnes.fr/",attribution:"Centre national d'études spatiales (CNES)",logo:"https://wxs.ign.fr/static/logos/CNES_975/CNES_975.gif",minZoom:13,maxZoom:18,constraint:[{minZoom:13,maxZoom:18,bbox:[-56.410988,46.734093,-56.10308,47.149963]}]},CNES_976:{href:"http://www.cnes.fr/",attribution:"Centre national d'études spatiales (CNES)",logo:"https://wxs.ign.fr/static/logos/CNES_976/CNES_976.gif",minZoom:13,maxZoom:18,constraint:[{minZoom:13,maxZoom:18,bbox:[44.916977,-13.089187,45.30442,-12.564543]}]},CNES_977:{href:"http://www.cnes.fr/",attribution:"Centre national d'études spatiales (CNES)",logo:"https://wxs.ign.fr/static/logos/CNES_977/CNES_977.gif",minZoom:13,maxZoom:18,constraint:[{minZoom:13,maxZoom:18,bbox:[-62.952805,17.862621,-62.78276,17.98024]}]},CNES:{href:"http://www.cnes.fr/",attribution:"Centre national d'études spatiales (CNES)",logo:"https://wxs.ign.fr/static/logos/CNES/CNES.gif",minZoom:13,maxZoom:16,constraint:[{minZoom:13,maxZoom:16,bbox:[-55.01953,1.845384,-50.88867,6.053161]}]},ASTRIUM:{href:"http://www.geo-airbusds.com/",attribution:"Airbus Defence and Space",logo:"https://wxs.ign.fr/static/logos/ASTRIUM/ASTRIUM.gif",minZoom:13,maxZoom:16,constraint:[{minZoom:13,maxZoom:16,bbox:[-55.01953,1.845384,-50.88867,6.053161]}]},CNES_971:{href:"http://www.cnes.fr/",attribution:"Centre national d'études spatiales (CNES)",logo:"https://wxs.ign.fr/static/logos/CNES_971/CNES_971.gif",minZoom:13,maxZoom:18,constraint:[{minZoom:13,maxZoom:18,bbox:[-61.82342,15.819616,-60.99497,16.521578]}]},CNES_972:{href:"http://www.cnes.fr/",attribution:"Centre national d'études spatiales (CNES)",logo:"https://wxs.ign.fr/static/logos/CNES_972/CNES_972.gif",minZoom:13,maxZoom:18,constraint:[{minZoom:13,maxZoom:18,bbox:[-61.247208,14.371855,-60.778458,14.899901]}]}}},"GEOGRAPHICALGRIDSYSTEMS.MAPS.SCAN-EXPRESS.STANDARD":{server:"https://wxs.ign.fr/geoportail/wmts",layer:"GEOGRAPHICALGRIDSYSTEMS.MAPS.SCAN-EXPRESS.STANDARD",title:"Carte IGN",format:"image/jpeg",style:"normal",queryable:!1,tilematrix:"PM",minZoom:0,maxZoom:18,bbox:[-179.62723,-84.5047,179.74588,85.47958],desc:"Cartographie topographique multi-échelles du territoire français issue des bases de données vecteur de l’IGN - emprise nationale, visible du 1/200 au 1/130000000",originators:{IGN:{href:"http://www.ign.fr",attribution:"Institut national de l'information géographique et forestière",logo:"https://wxs.ign.fr/static/logos/IGN/IGN.gif",minZoom:0,maxZoom:18,constraint:[{minZoom:5,maxZoom:5,bbox:[-179.57285,-83.84196,178.4975,85.36646]},{minZoom:0,maxZoom:2,bbox:[-175.99709,-84.42859,175.99709,84.2865]},{minZoom:3,maxZoom:3,bbox:[-176.23093,-84.5047,179.08267,84.89126]},{minZoom:4,maxZoom:4,bbox:[-179.62723,-84.0159,-179.21112,85.47958]},{minZoom:6,maxZoom:8,bbox:[-179.49689,-84.02368,179.74588,85.30035]},{minZoom:15,maxZoom:18,bbox:[-5.6663494,41.209736,10.819784,51.175068]},{minZoom:14,maxZoom:14,bbox:[-5.713191,40.852314,11.429714,51.44377]},{minZoom:13,maxZoom:13,bbox:[-63.37252,13.428586,11.429714,51.44377]},{minZoom:11,maxZoom:12,bbox:[-63.37252,13.428586,11.496459,51.444122]},{minZoom:9,maxZoom:9,bbox:[-64.81273,13.428586,11.496459,51.444016]},{minZoom:10,maxZoom:10,bbox:[-63.37252,13.428586,11.496459,51.444016]}]}}},"GEOGRAPHICALGRIDSYSTEMS.MAPS":{server:"https://wxs.ign.fr/geoportail/wmts",layer:"GEOGRAPHICALGRIDSYSTEMS.MAPS",title:"Cartes IGN",format:"image/jpeg",style:"normal",queryable:!0,tilematrix:"PM",minZoom:0,maxZoom:18,bbox:[-180,-75,180,80],desc:"Cartes IGN",originators:{IGN:{href:"http://www.ign.fr",attribution:"Institut national de l'information géographique et forestière",logo:"https://wxs.ign.fr/static/logos/IGN/IGN.gif",minZoom:0,maxZoom:18,constraint:[{minZoom:7,maxZoom:7,bbox:[-178.20573,-68.138855,144.84375,51.909786]},{minZoom:8,maxZoom:8,bbox:[-178.20573,-68.138855,168.24327,51.909786]},{minZoom:13,maxZoom:13,bbox:[-178.20573,-67.101425,168.24327,51.44377]},{minZoom:14,maxZoom:14,bbox:[-178.20573,-67.101425,168.23909,51.44377]},{minZoom:11,maxZoom:12,bbox:[-178.20573,-67.101425,168.24327,51.444122]},{minZoom:9,maxZoom:10,bbox:[-178.20573,-68.138855,168.24327,51.444016]},{minZoom:15,maxZoom:15,bbox:[-178.20573,-46.502903,168.23909,51.175068]},{minZoom:16,maxZoom:16,bbox:[-178.20573,-46.502903,168.29811,51.175068]},{minZoom:0,maxZoom:6,bbox:[-180,-60,180,80]},{minZoom:18,maxZoom:18,bbox:[-5.6663494,41.209736,10.819784,51.175068]},{minZoom:17,maxZoom:17,bbox:[-179.5,-75,179.5,75]}]},DITTT:{href:"http://www.dittt.gouv.nc/portal/page/portal/dittt/",attribution:"Direction des Infrastructures, de la Topographie et des Transports Terrestres",logo:"https://wxs.ign.fr/static/logos/DITTT/DITTT.gif",minZoom:8,maxZoom:16,constraint:[{minZoom:8,maxZoom:10,bbox:[163.47784,-22.972307,168.24327,-19.402702]},{minZoom:11,maxZoom:13,bbox:[163.47784,-22.972307,168.24327,-19.494438]},{minZoom:14,maxZoom:15,bbox:[163.47784,-22.764496,168.23909,-19.493542]},{minZoom:16,maxZoom:16,bbox:[163.47784,-22.809465,168.29811,-19.403923]}]}}},"ADMINEXPRESS-COG-CARTO.LATEST":{key:"administratif",server:"https://wxs.ign.fr/geoportail/wmts",layer:"ADMINEXPRESS-COG-CARTO.LATEST",title:"ADMINEXPRESS COG CARTO",format:"image/png",style:"normal",queryable:!0,tilematrix:"PM",minZoom:6,maxZoom:16,bbox:[-63.37252,-21.475586,55.925865,51.31212],desc:"Limites administratives Express COG code officiel géographique 2021",originators:{IGN:{href:"https://www.ign.fr",attribution:"Institut national de l'information géographique et forestière",logo:"https://wxs.ign.fr/static/logos/IGN/IGN.gif",minZoom:6,maxZoom:16,constraint:[{minZoom:6,maxZoom:16,bbox:[-63.37252,-21.475586,55.925865,51.31212]}]}}},"GEOGRAPHICALGRIDSYSTEMS.SLOPES.MOUNTAIN":{key:"altimetrie",server:"https://wxs.ign.fr/geoportail/wmts",layer:"GEOGRAPHICALGRIDSYSTEMS.SLOPES.MOUNTAIN",title:"Carte des pentes",format:"image/png",style:"normal",queryable:!1,tilematrix:"PM",minZoom:0,maxZoom:17,bbox:[-63.161392,-21.544624,56.001812,51.099052],desc:"Carte des zones ayant une valeur de pente supérieure à 30°-35°-40°-45° d'après la BD ALTI au pas de 5m",originators:{IGN:{href:"http://www.ign.fr",attribution:"Institut national de l'information géographique et forestière",logo:"https://wxs.ign.fr/static/logos/IGN/IGN.gif",minZoom:0,maxZoom:17,constraint:[{minZoom:0,maxZoom:17,bbox:[-5.1504726,41.32521,9.570543,51.099052]}]}}},"ELEVATION.SLOPES":{key:"altimetrie",server:"https://wxs.ign.fr/geoportail/wmts",layer:"ELEVATION.SLOPES",title:"Altitude",format:"image/jpeg",style:"normal",queryable:!0,tilematrix:"PM",minZoom:6,maxZoom:14,bbox:[-178.20589,-22.595179,167.43176,50.93085],desc:"La couche altitude se compose d'un MNT (Modèle Numérique de Terrain) affiché en teintes hypsométriques et issu de la BD ALTI®.",originators:{IGN:{href:"http://www.ign.fr",attribution:"Institut national de l'information géographique et forestière",logo:"https://wxs.ign.fr/static/logos/IGN/IGN.gif",minZoom:6,maxZoom:14,constraint:[{minZoom:6,maxZoom:14,bbox:[55.205746,-21.392344,55.846554,-20.86271]}]}}},"GEOGRAPHICALGRIDSYSTEMS.MAPS.BDUNI.J1":{key:"cartes",server:"https://wxs.ign.fr/geoportail/wmts",layer:"GEOGRAPHICALGRIDSYSTEMS.MAPS.BDUNI.J1",title:"Plan IGN j+1",format:"image/png",style:"normal",queryable:!1,tilematrix:"PM",minZoom:0,maxZoom:18,bbox:[-179.5,-75,179.5,75],desc:"Plan IGN j+1",originators:{IGN:{href:"http://www.ign.fr",attribution:"Institut national de l'information géographique et forestière",logo:"https://wxs.ign.fr/static/logos/IGN/IGN.gif",minZoom:0,maxZoom:18,constraint:[{minZoom:0,maxZoom:18,bbox:[-179,-80,179,80]}]}}},"TRANSPORTNETWORKS.ROADS":{key:"topographie",server:"https://wxs.ign.fr/geoportail/wmts",layer:"TRANSPORTNETWORKS.ROADS",title:"Routes",format:"image/png",style:"normal",queryable:!1,tilematrix:"PM",minZoom:6,maxZoom:18,bbox:[-63.969162,-21.49687,55.964417,71.584076],desc:"Affichage du réseau routier français et européen.",originators:{IGN:{href:"http://www.ign.fr",attribution:"Institut national de l'information géographique et forestière",logo:"https://wxs.ign.fr/static/logos/IGN/IGN.gif",minZoom:6,maxZoom:18,constraint:[{minZoom:15,maxZoom:18,bbox:[-63.37252,-21.475586,55.925865,51.31212]},{minZoom:6,maxZoom:14,bbox:[-63.969162,-21.49687,55.964417,71.584076]}]}}}},ol.layer.Geoportail.register=function(t,e){ol.layer.Geoportail.capabilities[t]=e},ol.layer.Geoportail.isRegistered=function(t){return ol.layer.Geoportail.capabilities[t]&&ol.layer.Geoportail.capabilities[t].key},ol.layer.Geoportail.loadCapabilities=function(t,e){var o=function(){},i=function(){},n=function(){};this.getCapabilities(t,e).then(function(t){ol.layer.Geoportail.capabilities=t,o(t)}).catch(function(t){i(t)}).finally(function(t){n(t)});var r={then:function(t){return"function"==typeof t&&(o=t),r},catch:function(t){return"function"==typeof t&&(i=t),r},finally:function(t){return"function"==typeof t&&(n=t),r}};return r},ol.layer.Geoportail.getCapabilities=function(t){var e={},o=function(){},i=function(){},n=function(){},r=[156543.03390625,78271.516953125,39135.7584765625,19567.87923828125,9783.939619140625,4891.9698095703125,2445.9849047851562,1222.9924523925781,611.4962261962891,305.74811309814453,152.87405654907226,76.43702827453613,38.218514137268066,19.109257068634033,9.554628534317017,4.777314267158508,2.388657133579254,1.194328566789627,.5971642833948135,.29858214169740677,.14929107084870338];function s(t){t=281e-6*Number(t);for(var e=0;e<r.length;e++)if(t>r[e])return e}function a(t){for(var e=t.constraint.length-1;e>0;e--)for(var o=0;o<e;o++){for(var i=!0,n=0;n<4;n++)if(t.constraint[e].bbox[n]!=t.constraint[o].bbox[n]){i=!1;break}if(i&&(t.constraint[e].maxZoom==t.constraint[o].minZoom||t.constraint[o].maxZoom==t.constraint[e].minZoom||t.constraint[e].maxZoom+1==t.constraint[o].minZoom||t.constraint[o].maxZoom+1==t.constraint[e].minZoom||t.constraint[e].minZoom-1==t.constraint[o].maxZoom||t.constraint[o].minZoom-1==t.constraint[e].maxZoom)){t.constraint[o].maxZoom=Math.max(t.constraint[e].maxZoom,t.constraint[o].maxZoom),t.constraint[o].minZoom=Math.min(t.constraint[e].minZoom,t.constraint[o].minZoom),t.constraint.splice(e,1);break}}}ol.ext.Ajax.get({url:"https://wxs.ign.fr/"+t+"/autoconf/",dataType:"TEXT",error:function(t){i(t),n({})},success:function(i){for(var r,l=(new DOMParser).parseFromString(i,"text/xml").getElementsByTagName("Layer"),c=0;r=l[c];c++)if(/WMTS/.test(r.getElementsByTagName("Server")[0].attributes.service.value)){for(var h,p={key:t,server:r.getElementsByTagName("gpp:Key")[0].innerHTML.replace(t+"/",""),layer:r.getElementsByTagName("Name")[0].innerHTML,title:r.getElementsByTagName("Title")[0].innerHTML,format:r.getElementsByTagName("Format")[0]?r.getElementsByTagName("Format")[0].innerHTML:"image.jpeg",style:r.getElementsByTagName("Style")[0].getElementsByTagName("Name")[0].innerHTML,queryable:"1"===r.attributes.queryable.value,tilematrix:"PM",minZoom:s(r.getElementsByTagName("sld:MaxScaleDenominator")[0].innerHTML),maxZoom:s(r.getElementsByTagName("sld:MinScaleDenominator")[0].innerHTML),bbox:JSON.parse("["+r.getElementsByTagName("gpp:BoundingBox")[0].innerHTML+"]"),desc:r.getElementsByTagName("Abstract")[0].innerHTML.replace(/^<!\[CDATA\[(.*)\]\]>$/,"$1"),originators:{}},u=r.getElementsByTagName("gpp:Originator"),g=0;h=u[g];g++){for(var d,m=p.originators[h.attributes.name.value]={href:h.getElementsByTagName("gpp:URL")[0].innerHTML,attribution:h.getElementsByTagName("gpp:Attribution")[0].innerHTML,logo:h.getElementsByTagName("gpp:Logo")[0].innerHTML,minZoom:20,maxZoom:0,constraint:[]},f=h.getElementsByTagName("gpp:Constraint"),y=0;d=f[y];y++){var v=s(d.getElementsByTagName("sld:MinScaleDenominator")[0].innerHTML),_=s(d.getElementsByTagName("sld:MaxScaleDenominator")[0].innerHTML);_>m.maxZoom&&(m.maxZoom=_),_<m.minZoom&&(m.minZoom=_),v>m.maxZoom&&(m.maxZoom=v),v<m.minZoom&&(m.minZoom=v),m.constraint.push({minZoom:_,maxZoom:v,bbox:JSON.parse("["+d.getElementsByTagName("gpp:BoundingBox")[0].innerHTML+"]")})}a(m)}e[p.layer]=p}o(e),n(e)}});var l={then:function(t){return"function"==typeof t&&(o=t),l},catch:function(t){return"function"==typeof t&&(i=t),l},finally:function(t){return"function"==typeof t&&(n=t),l}};return l},ol.source.Source.prototype.getPreview=function(){return"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAk6QAAJOkBUCTn+AAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAANeSURBVHic7ZpPiE1RHMc/780MBhkik79JSUlIUbOxI+wkI2yRhYSUlJLNpJF/xcpiJBmZGBZsNM1CkmhKITGkGbH0/BuPmXnP4rxbb/TOn3fvOffeec6nfqvb/b7f93fveeec37ng8Xg8Ho/nf6Uu4d+fDswFssCvhHOJhaXAMeApMAQUyyIPPAdOAiuTStAVy4EHjDWsix5gdRLJ2mY34ulWYz6IEeA4kIk9awtkgTOEM/5vdAKT4k0/Ou3YMR/ELcbRm9AKFLBbgCJwNE4TYZkJfMG++SIwDCyLz0o4bI17WdyJz0r1TAZ+oDcxCBwAFgIzEIuhvcBbg3sLwOK4DFXLFvQGniCGSSUagS4DjUPOHESkA3XiOWCORqMR6Nfo9DjI3QqPUSd+ylBnv0Zn0GrWFvmIOvGNhjqrNDp/EAutyFgRKUM2tgO+Gur81FxvAKYZaimxXYBvmuuLDHWWaK4X0RfJCNsF6NdcbzXU2a65PohYFKWOc+jn8PUajbWIXaBKp9NB7lZYh34OzwFbFfd/NtDYYSth27urLGIm0M31AL3APWAAmIooymaDnPIl/Vz4NN1yHrd7gcvxWQnHAuA3bsyPop8hUsE13BSgK04TUViBeFo2zedJ8S6wElexW4D2eNOPTjNi6WvD/DtEr8E6tk6GGoAmxFY2iFHE9NZiQf8gogiB9gTEH23izAZuE77vHyU+ANucO1QwD3hD/MbLowAcdm20EmkwXx4n3NodS9rMB2HabYpEWs0HcRqHp0fNwAvJD+eBTZr7p6BvmQVxUaEzEbiruNfJekH15L8jtrEm7JJolEcOmKXRqQOuKDQuY7HZY8s8iNfzkSLxIuI43FTrkkLnOlBfRW4VsWk+oAX5weknxFAxJQNckGgVgZuIRVoomoGXEmGTMa+iQ6K7M4SW7k24QYgiuDQPYinbhugiF4H3RGtzZYCzyIvQXfpNI1ybLyeLpf5+iTbkRbiP2EcocTHm4+YI8iI8RFHwWjAfsA95Q+YZFU6wasl8wB7kReijtNbIILa0vcg/PRlGfPQwHmlCviDqAzaA+OREtzqr1ejOIDorxlNEjTGUBV4nnUWCvAJxGDlA8q9j3DEArAn2zvXAfOwfl6eVAmJrPpJ0Ih6Px+PxeJLjLwPul3vj5d0eAAAAAElFTkSuQmCC"},ol.source.Tile.prototype.getPreview=function(t,e){t||(t=[21020,6355964]),e||(e=150);var o=this.getTileGrid().getTileCoordForCoordAndResolution(t,e);return this.getTileUrlFunction().call(this,o,this.getProjection())},ol.source.TileWMS.prototype.getPreview=function(t,e){t||(t=[21020,6355964]),e||(e=150);var o=this.getTileUrlFunction();if(o){var i=(this.getTileGrid()||this.getTileGridForProjection(this.getProjection())).getTileCoordForCoordAndResolution(t,e);return o.call(this,i,1,this.getProjection())}var n=this.getGetFeatureInfoUrl?this.getGetFeatureInfoUrl(t,e,this.getProjection()||"EPSG:3857",{}):this.getFeatureInfoUrl(t,e,this.getProjection()||"EPSG:3857",{});return n=n.replace(/getfeatureinfo/i,"GetMap")},ol.layer.Base.prototype.getPreview=function(t,e,o){if(this.get("preview"))return[this.get("preview")];if(e||(e=150),e<this.getMinResolution()||e>this.getMaxResolution()){var i=this.getMinResolution(),n=this.getMaxResolution();for(n>1e5&&(n=156543),i<.15&&(i=.15),e=n;n>i;)n/=2,e=i*=2}var r=this.getExtent();return t||(t=[21020,6355964]),r&&!ol.extent.containsCoordinate(r,t)&&(t=[(r[0]+r[2])/2,(r[1]+r[3])/2]),o&&(t=ol.proj.transform(t,o,this.getSource().getProjection())),this.getSource&&this.getSource()?[this.getSource().getPreview(t,e)]:[]},ol.layer.Group.prototype.getPreview=function(t,e){if(this.get("preview"))return[this.get("preview")];var o=[];if(this.getLayers)for(var i=this.getLayers().getArray(),n=0;n<i.length;n++)o=o.concat(i[n].getPreview(t,e));return o},ol.layer.Maplibre=function(t){ol.layer.Layer||console.error("[ol/layer/MapLibre] bad ol version (need ol@6+)"),(t=t||{}).render=function(e){this._container||this._create(t.style);this._container.style.width=1*e.size[0]+"px",this._container.style.height=1*e.size[1]+"px";var o=this.glMap;if(!o)return null;var i=o.getCanvas();i.style.transform="scale(1)",e.size[0]===i.width&&e.size[1]===i.height||o.resize(),i.style.opacity=this.getOpacity();var n=e.viewState;return o.jumpTo({center:ol.proj.toLonLat(n.center),zoom:n.zoom-1,bearing:180*-n.rotation/Math.PI,animate:!1}),o._frame&&(o._frame.cancel(),o._frame=null),o._render(),this._container},ol.layer.Layer.call(this,t)},ol.layer.Layer||(ol.layer.Layer=function(){}),ol.ext.inherits(ol.layer.Maplibre,ol.layer.Layer),ol.layer.Maplibre.prototype.getMapGL=function(){return this.glMap},ol.layer.Maplibre.prototype.setStyle=function(t){this.set("style",t),this.getMapGL()&&this.getMapGL().setStyle(t),this.changed()},ol.layer.Maplibre.prototype.getStyle=function(){return this.getMapGL().get("style")},ol.layer.Maplibre.prototype._create=function(t){this._container=ol.ext.element.create("DIV",{className:"ol-maplibre-gl",style:{position:"absolute",top:0,left:0},parent:document.body}),this.glMap=new mapboxgl.Map({container:this._container,style:t,center:[3,47],zoom:5,pitch:0,antialias:!0,attributionControl:!1,boxZoom:!1,doubleClickZoom:!1,dragPan:!1,dragRotate:!1,interactive:!1,keyboard:!1,pitchWithRotate:!1,scrollZoom:!1,touchZoomRotate:!1})},ol.layer.Vector.prototype.setRender3D=function(t){t.setLayer(this)},ol.render3D=function(t){(t=t||{}).maxResolution=t.maxResolution||100,t.defaultHeight=t.defaultHeight||0,ol.Object.call(this,t),this.setStyle(t.style),this.set("ghost",t.ghost),this.setActive(t.active||!1!==t.active),this.height_=t.height=this.getHfn(t.height),t.layer&&this.setLayer(t.layer)},ol.ext.inherits(ol.render3D,ol.Object),ol.render3D.prototype.setStyle=function(t){if(t instanceof ol.style.Style?this._style=t:this._style=new ol.style.Style,this._style.getStroke()||this._style.setStroke(new ol.style.Stroke({width:1,color:"red"})),this._style.getFill()||this._style.setFill(new ol.style.Fill({color:"rgba(0,0,255,0.5)"})),t&&t.getGeometry()){var e=t.getGeometry();"function"==typeof e?this.set("geometry",e):this.set("geometry",function(){return e})}else this.set("geometry",function(t){return t.getGeometry()})},ol.render3D.prototype.getStyle=function(){return this._style},ol.render3D.prototype.setActive=function(t){this._active="function"==typeof t?t:function(){return t},this.layer_&&this.layer_.changed()},ol.render3D.prototype.getActive=function(){return this._active()},ol.render3D.prototype.onPostcompose_=function(t){if(this.getActive()){var e=t.frameState.viewState.resolution;if(!(e>this.get("maxResolution"))){if(this.res_=400*e,this.animate_){var o=t.frameState.time-this.animate_;o<this.animateDuration_?(this.elapsedRatio_=this.easing_(o/this.animateDuration_),t.frameState.animate=!0):(this.animate_=!1,this.height_=this.toHeight_)}var i=t.frameState.pixelRatio,n=t.context,r=this.matrix_=t.frameState.coordinateToPixelTransform;r||((r=t.frameState.coordinateToPixelMatrix)[2]=r[4],r[3]=r[5],r[4]=r[12],r[5]=r[13]),this.center_=[n.canvas.width/2/i,n.canvas.height/i];var s=this.layer_.getSource().getFeaturesInExtent(t.frameState.extent);n.save(),n.scale(i,i);var a=this.getStyle();n.lineWidth=a.getStroke().getWidth(),n.strokeStyle=ol.color.asString(a.getStroke().getColor()),n.fillStyle=ol.color.asString(a.getFill().getColor());for(var l=[],c=0;c<s.length;c++){var h=this.getFeatureHeight(s[c]);h&&l.push(this.getFeature3D_(s[c],h))}this.get("ghost")?this.drawGhost3D_(n,l):this.drawFeature3D_(n,l),n.restore()}}},ol.render3D.prototype.setLayer=function(t){this._listener&&this._listener.forEach(function(t){ol.Observable.unByKey(t)}),this.layer_=t,this._listener=t.on(["postcompose","postrender"],this.onPostcompose_.bind(this))},ol.render3D.prototype.getHfn=function(t){switch(typeof t){case"function":return t;case"string":var e=this.get("defaultHeight");return function(o){return Number(o.get(t))||e};case"number":return function(){return t};default:return function(){return 10}}},ol.render3D.prototype.animate=function(t){t=t||{},this.toHeight_=this.getHfn(t.height),this.animate_=(new Date).getTime(),this.animateDuration_=t.duration||1e3,this.easing_=t.easing||ol.easing.easeOut,this.layer_.changed()},ol.render3D.prototype.animating=function(){return this.animate_&&(new Date).getTime()-this.animate_>this.animateDuration_&&(this.animate_=!1),!!this.animate_},ol.render3D.prototype.getFeatureHeight=function(t){if(this.animate_){var e=this.height_(t),o=this.toHeight_(t);return e*(1-this.elapsedRatio_)+this.elapsedRatio_*o}return this.height_(t)},ol.render3D.prototype.hvector_=function(t,e){var o=[t[0]*this.matrix_[0]+t[1]*this.matrix_[1]+this.matrix_[4],t[0]*this.matrix_[2]+t[1]*this.matrix_[3]+this.matrix_[5]];return{p0:o,p1:[o[0]+e/this.res_*(o[0]-this.center_[0]),o[1]+e/this.res_*(o[1]-this.center_[1])]}},ol.render3D.prototype.getFeature3D_=function(t,e){var o=this.get("geometry")(t),i=o.getCoordinates();switch(o.getType()){case"Polygon":i=[i];case"MultiPolygon":for(var n=[],r=0;r<i.length;r++)for(var s=0;s<i[r].length;s++){for(var a=[],l=0;l<i[r][s].length;l++)a.push(this.hvector_(i[r][s][l],e));n.push(a)}return{type:"MultiPolygon",feature:t,geom:n,height:e};case"Point":return{type:"Point",feature:t,geom:this.hvector_(i,e),height:e};default:return{}}},ol.render3D.prototype.drawFeature3D_=function(t,e){var o,i,n,r;for(o=0;o<e.length;o++)switch(e[o].type){case"MultiPolygon":for(i=0;i<e[o].geom.length;i++)for(n=e[o].geom[i],r=0;r<n.length;r++)t.beginPath(),t.moveTo(n[r].p0[0],n[r].p0[1]),t.lineTo(n[r].p1[0],n[r].p1[1]),t.stroke();break;case"Point":var s=e[o].geom;t.beginPath(),t.moveTo(s.p0[0],s.p0[1]),t.lineTo(s.p1[0],s.p1[1]),t.stroke()}for(o=0;o<e.length;o++)switch(e[o].type){case"MultiPolygon":for(t.beginPath(),i=0;i<e[o].geom.length;i++){if(n=e[o].geom[i],0==i)for(t.moveTo(n[0].p1[0],n[0].p1[1]),r=1;r<n.length;r++)t.lineTo(n[r].p1[0],n[r].p1[1]);else for(t.moveTo(n[0].p1[0],n[0].p1[1]),r=n.length-2;r>=0;r--)t.lineTo(n[r].p1[0],n[r].p1[1]);t.closePath()}t.fill("evenodd"),t.stroke();break;case"Point":var a=(n=e[o]).feature.get("label");if(a){var l=n.geom.p1,c=t.fillStyle;t.fillStyle=t.strokeStyle,t.textAlign="center",t.textBaseline="bottom",t.fillText(a,l[0],l[1]);var h=t.measureText(a),p=Number(t.font.match(/\d+(\.\d+)?/g).join([]));t.fillStyle="rgba(255,255,255,0.5)",t.fillRect(l[0]-h.width/2-5,l[1]-p-5,h.width+10,p+10),t.strokeRect(l[0]-h.width/2-5,l[1]-p-5,h.width+10,p+10),t.fillStyle=c}}},ol.render3D.prototype.drawGhost3D_=function(t,e){var o,i,n,r;for(o=0;o<e.length;o++)switch(e[o].type){case"MultiPolygon":for(i=0;i<e[o].geom.length;i++)for(n=e[o].geom[i],r=0;r<n.length-1;r++){t.beginPath(),t.moveTo(n[r].p0[0],n[r].p0[1]),t.lineTo(n[r].p1[0],n[r].p1[1]),t.lineTo(n[r+1].p1[0],n[r+1].p1[1]),t.lineTo(n[r+1].p0[0],n[r+1].p0[1]),t.lineTo(n[r].p0[0],n[r].p0[1]);var s=[(n[r].p0[0]+n[r+1].p0[0])/2,(n[r].p0[1]+n[r+1].p0[1])/2],a=[n[r].p0[1]-n[r+1].p0[1],-n[r].p0[0]+n[r+1].p0[0]],l=ol.coordinate.getIntersectionPoint([s,[s[0]+a[0],s[1]+a[1]]],[n[r].p1,n[r+1].p1]),c=t.createLinearGradient(s[0],s[1],l[0],l[1]);c.addColorStop(0,"rgba(255,255,255,.2)"),c.addColorStop(1,"rgba(255,255,255,0)"),t.fillStyle=c,t.fill()}break;case"Point":var h=e[o].geom;t.beginPath(),t.moveTo(h.p0[0],h.p0[1]),t.lineTo(h.p1[0],h.p1[1]),t.stroke()}},ol.layer.SketchOverlay=function(t){var e=(t=t||{}).style||ol.style.Style.defaultStyle(!0),o=t.sketchStyle;o||(o=ol.style.Style.defaultStyle(),(o=[new ol.style.Style({image:new ol.style.RegularShape({points:4,radius:10,radius2:0,stroke:new ol.style.Stroke({color:[255,255,255,.5],width:3})})}),o[0].clone()])[1].setImage(new ol.style.RegularShape({points:4,radius:10,radius2:0,stroke:new ol.style.Stroke({color:[0,153,255,1],width:1.25})}))),this._geom=[],ol.layer.Vector.call(this,{name:"sketch",source:new ol.source.Vector({useSpatialIndex:!1}),style:function(t){return t.get("sketch")?o:e},updateWhileAnimating:!0,updateWhileInteracting:!0}),this.getSource().addFeatures([new ol.Feature({sketch:!0,geometry:new ol.geom.Point([])}),new ol.Feature({sketch:!0,geometry:new ol.geom.LineString([])}),new ol.Feature,new ol.Feature(new ol.geom.Point([]))]),this.setGeometryType(t.type)},ol.ext.inherits(ol.layer.SketchOverlay,ol.layer.Vector),ol.layer.SketchOverlay.prototype.setGeometryType=function(t){var e=/^Point$|^LineString$|^Polygon$|^Circle$/.test(t)?t:"LineString";return e!==this._type&&(this.abortDrawing(),this._type=e),this._type},ol.layer.SketchOverlay.prototype.getGeometryType=function(){return this._type},ol.layer.SketchOverlay.prototype.addPoint=function(t){return this._lastCoord!==this._position&&(this._geom.length||this.startDrawing(),this._geom.push(t),this._lastCoord=t,this._position=t,this.drawSketch(),"Point"===this.getGeometryType()&&this.finishDrawing(),"Circle"===this.getGeometryType()&&this._geom.length>=2&&this.finishDrawing(),!0)},ol.layer.SketchOverlay.prototype.removeLastPoint=function(){this._geom.pop(),this._lastCoord=this._geom[this._geom.length-1],this.drawSketch()},ol.layer.SketchOverlay.prototype.startDrawing=function(t){t=t||{},this._geom=[],t.type&&this.setGeometryType(t.type),this.drawSketch(),this._drawing||this.dispatchEvent({type:"drawstart",feature:this.getFeature()}),this._drawing=!0},ol.layer.SketchOverlay.prototype.finishDrawing=function(t){var e=this.getSource().getFeatures()[2].clone(),o=!!e;switch(this.getGeometryType()){case"Circle":case"LineString":o=this._geom.length>1;break;case"Polygon":o=this._geom.length>2}return!(t&&!o)&&(this._geom=[],this._lastCoord=null,this.drawSketch(),this._drawing&&this.dispatchEvent({type:"drawend",valid:o,feature:e}),this._drawing=!1,e)},ol.layer.SketchOverlay.prototype.abortDrawing=function(){this._drawing&&this.dispatchEvent({type:"drawabort",feature:this.getFeature()}),this._drawing=!1,this._geom=[],this._lastCoord=null,this.drawSketch()},ol.layer.SketchOverlay.prototype.setPosition=function(t){this._position=t,this.drawLink()},ol.layer.SketchOverlay.prototype.getPosition=function(){return this._position},ol.layer.SketchOverlay.prototype.drawLink=function(){var t=this.getSource().getFeatures();this._position?(this._lastCoord&&this._lastCoord===this._position?t[0].getGeometry().setCoordinates([]):t[0].getGeometry().setCoordinates(this._position),this._geom.length?"Circle"===this.getGeometryType()?t[1].setGeometry(new ol.geom.Circle(this._geom[0],ol.coordinate.dist2d(this._geom[0],this._position))):"Polygon"===this.getGeometryType()?t[1].setGeometry(new ol.geom.LineString([this._lastCoord,this._position,this._geom[0]])):t[1].setGeometry(new ol.geom.LineString([this._lastCoord,this._position])):t[1].setGeometry(new ol.geom.LineString([]))):(t[0].getGeometry().setCoordinates([]),t[1].setGeometry(new ol.geom.LineString([])))},ol.layer.SketchOverlay.prototype.getFeature=function(){return this.getSource().getFeatures()[2]},ol.layer.SketchOverlay.prototype.drawSketch=function(){this.drawLink();var t=this.getSource().getFeatures();if(this._geom.length)switch(this._lastCoord||(this._lastCoord=this._geom[this._geom.length-1]),t[3].getGeometry().setCoordinates(this._lastCoord),this._type){case"Point":t[2].setGeometry(new ol.geom.Point(this._lastCoord));break;case"Circle":t[2].getGeometry()?t[2].getGeometry().setRadius(ol.coordinate.dist2d(this._geom[0],this._geom[this._geom.length-1])):t[2].setGeometry(new ol.geom.Circle(this._geom[0],ol.coordinate.dist2d(this._geom[0],this._geom[this._geom.length-1])));break;case"LineString":t[2].getGeometry()?t[2].getGeometry().setCoordinates(this._geom):t[2].setGeometry(new ol.geom.LineString(this._geom));break;case"Polygon":this._geom.push(this._geom[0]),t[2].getGeometry()?t[2].getGeometry().setCoordinates([this._geom]):t[2].setGeometry(new ol.geom.Polygon([this._geom])),this._geom.pop();break;default:console.error("[ol/layer/SketchOverlay~drawSketch] geometry type not supported ("+this._type+")")}else t[2].setGeometry(null),t[3].setGeometry(new ol.geom.Point([]))},ol.PerspectiveMap=function(t){var e=t.target instanceof Element?t.target:document.getElementById(t.target);"absolute"!==window.getComputedStyle(e).position&&(e.style.position="relative"),e.style.overflow="hidden";var o=ol.ext.element.create("DIV",{className:"ol-perspective-map",parent:e}),i={};Object.assign(i,t),i.target=o,ol.Map.call(this,i),this._tiltCondition=t.tiltCondition||ol.events.condition.altKeyOnly},ol.ext.inherits(ol.PerspectiveMap,ol.Map),ol.PerspectiveMap.prototype.getPixelRatio=function(){return window.devicePixelRatio},ol.PerspectiveMap.prototype.setPerspective=function(t,e){e=e||{},t>30?t=30:t<0&&(t=0);var o=this._angle||0,i=Math.round(10*t)/10,n=this.getTarget().querySelector(".ol-layers").style;cancelAnimationFrame(this._animatedPerspective),requestAnimationFrame(function(t){this._animatePerpective(t,t,n,o,i,e.duration,e.easing||ol.easing.inAndOut)}.bind(this))},ol.PerspectiveMap.prototype._animatePerpective=function(t,e,o,i,n,r,s){var a,l,c;0===r?(a=1,l=!0):l=(a=(e-t)/(r||500))>=1,a=s(a);var h=(c=this._angle=l?n:i+(n-i)*a)/30;o.transform="translateY(-"+17*h+"%) perspective(200px) rotateX("+c+"deg) scaleY("+(1-h/2)+")",this.getMatrix3D(!0),this.render(),l||requestAnimationFrame(function(e){this._animatePerpective(t,e,o,i,n,r||500,s||ol.easing.inAndOut)}.bind(this)),this.dispatchEvent({type:"change:perspective",angle:c,animating:!l})},ol.PerspectiveMap.prototype.handleMapBrowserEvent=function(t){if(t.pixel=[t.originalEvent.offsetX/this.getPixelRatio(),t.originalEvent.offsetY/this.getPixelRatio()],t.coordinate=this.getCoordinateFromPixel(t.pixel),ol.Map.prototype.handleMapBrowserEvent.call(this,t),this._tiltCondition(t))switch(t.type){case"pointerdown":this._dragging=t.originalEvent.offsetY;break;case"pointerup":this._dragging=!1;break;case"pointerdrag":if(!1!==this._dragging){var e=t.originalEvent.offsetY>this._dragging?.5:-.5;e&&this.setPerspective((this._angle||0)+e,{duration:0}),this._dragging=t.originalEvent.offsetY}}else this._dragging=!1},ol.PerspectiveMap.prototype.getMatrix3D=function(t){if(t){var e=this.getTarget().querySelector(".ol-layers"),o=ol.matrix3D.getTransform(e),i=ol.matrix3D.getTransformOrigin(e);this._matrixTransform=ol.matrix3D.computeTransformMatrix(o,i)}return this._matrixTransform||(this._matrixTransform=ol.matrix3D.identity()),this._matrixTransform},ol.PerspectiveMap.prototype.getPixelScreenFromCoordinate=function(t){var e=this.getPixelFromCoordinate(t),o=this.getMatrix3D(),i=ol.matrix3D.transformVertex(o,e);return[(i=ol.matrix3D.projectVertex(i))[0],i[1]]},ol.PerspectiveMap.prototype.getPixelFromPixelScreen=function(t){var e=ol.matrix3D.inverse(this.getMatrix3D()),o=ol.matrix3D.transformVertex(e,t);return[(o=ol.matrix3D.projectVertex(o))[0],o[1]]},function(){var t=ol.Overlay.prototype.updatePixelPosition;ol.Overlay.prototype.updatePixelPosition=function(){var e=this.getMap();if(e&&e instanceof ol.PerspectiveMap){var o=this.getPosition();if(!e||!e.isRendered()||!o)return void this.setVisible(!1);var i=e.getPixelScreenFromCoordinate(o),n=e.getSize();i[0]-=n[0]/4,i[1]-=n[1]/4,this.updateRenderedPosition(i,n)}else t.call(this)}}(),window.ol&&!ol.particule&&(ol.particule={}),ol.particule.Base=function(t){t||(t={}),ol.Object.call(this),this.setOverlay(t.overlay),this.coordinate=t.coordinate||[0,0]},ol.ext.inherits(ol.particule.Base,ol.Object),ol.particule.Base.prototype.setOverlay=function(t){this._overlay=t},ol.particule.Base.prototype.getOverlay=function(){return this._overlay},ol.particule.Base.prototype.draw=function(){},ol.particule.Base.prototype.update=function(){},ol.particule.Base.prototype.getRandomCoord=function(t){return this.getOverlay().randomCoord?this.getOverlay().randomCoord():[t,0]},ol.particule.Bird=function(t){t||(t={}),ol.particule.Base.call(this,t),this.bird=new Image,this.bird.src="data:image/png;base64,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",this.set("size",[this.bird.width||50,this.bird.height||50])},ol.ext.inherits(ol.particule.Bird,ol.particule.Base),ol.particule.Bird.prototype.draw=function(t){var e=this.getOverlay().get("angle");t.save(),t.translate(this.coordinate[0],this.coordinate[1]),t.rotate(e+Math.PI/2),t.scale(.5,.5),t.drawImage(this.bird,-this.bird.width/2,-this.bird.height/2),t.restore()},ol.particule.Bird.prototype.update=function(t){var e=this.getOverlay().get("speed")*t/this.getOverlay()._fps,o=this.getOverlay().get("angle");this.coordinate[0]+=e*Math.cos(o),this.coordinate[1]+=e*Math.sin(o)},ol.particule.Cloud=function(t){t||(t={}),ol.particule.Base.call(this,t),this.set("size",[100,100]);var e=document.createElement("CANVAS");e.width=200,e.height=200;var o=e.getContext("2d"),i=this.gradient=o.createRadialGradient(50,50,0,50,50,50);i.addColorStop(0,"rgba(255,255,255,.2"),i.addColorStop(1,"rgba(255,255,255,0"),this.image=e;for(var n=0;n<7;n++){o.save();var r=100*Math.random(),s=100*Math.random();o.translate(r,s),o.fillStyle=i,o.fillRect(0,0,e.width,e.height),o.restore()}},ol.ext.inherits(ol.particule.Cloud,ol.particule.Base),ol.particule.Cloud.prototype.draw=function(t){t.save(),t.translate(this.coordinate[0],this.coordinate[1]),t.drawImage(this.image,-this.image.width/2,-this.image.width/2),t.restore()},ol.particule.Cloud.prototype.update=function(t){var e=this.getOverlay().get("speed")*t/this.getOverlay()._fps,o=this.getOverlay().get("angle");this.coordinate[0]+=e*Math.cos(o),this.coordinate[1]+=e*Math.sin(o)},ol.particule.Rain=function(t){t||(t={}),ol.particule.Base.call(this,t),this.z=Math.floor(5*Math.random())+1;var e=document.createElement("CANVAS");e.width=50,e.height=50;var o=e.getContext("2d");this.gradient=o.createRadialGradient(0,0,0,0,0,25),this.gradient.addColorStop(0,"rgba(0,0,80,0)"),this.gradient.addColorStop(1,"rgba(0,0,80,.3)")},ol.ext.inherits(ol.particule.Rain,ol.particule.Base),ol.particule.Rain.prototype.draw=function(t){t.save();var e=this.getOverlay().get("angle");t.beginPath();var o=10*Math.cos(e)*(1+this.z/2),i=10*Math.sin(e)*(1+this.z/2);t.lineWidth=Math.round(this.z/2),t.strokeStyle=this.gradient,t.translate(this.coordinate[0],this.coordinate[1]),t.moveTo(0,0),t.lineTo(o,i),t.stroke(),t.restore()},ol.particule.Rain.prototype.update=function(t){var e=this.getOverlay().get("speed")*t/this.getOverlay()._fps*this.z,o=this.getOverlay().get("angle");this.coordinate[0]+=e*Math.cos(o),this.coordinate[1]+=e*Math.sin(o)},ol.particule.RainDrop=function(t){t||(t={}),ol.particule.Base.call(this,t),this.size=0;var e=document.createElement("CANVAS");e.width=100,e.height=100;var o=e.getContext("2d"),i=o.createRadialGradient(50,50,0,50,50,50);i.addColorStop(0,"rgba(128,128,192,.8"),i.addColorStop(1,"rgba(128,128,192,0"),this.image=e,o.fillStyle=i,o.fillRect(0,0,e.width,e.height)},ol.ext.inherits(ol.particule.RainDrop,ol.particule.Base),ol.particule.RainDrop.prototype.draw=function(t){this.size>0&&(t.save(),t.translate(this.coordinate[0],this.coordinate[1]),t.globalAlpha=this.size/50,t.scale(1-this.size/50,1-this.size/50),t.drawImage(this.image,-50,-50),t.restore())},ol.particule.RainDrop.prototype.update=function(t){(this.size>0||Math.random()<.01)&&(this.size<=0&&(this.size=50,this.coordinates=this.getRandomCoord()),this.size=this.size-Math.round(t/20))},ol.particule.Snow=function(t){t||(t={}),ol.particule.Base.call(this,t),this.z=(Math.floor(5*Math.random())+1)/5,this.angle=Math.random()*Math.PI;var e=document.createElement("CANVAS");e.width=20,e.height=20;var o=e.getContext("2d"),i=o.createRadialGradient(10,10,0,10,10,10);i.addColorStop(0,"rgba(255, 255, 255,1)"),i.addColorStop(.8,"rgba(210, 236, 242,.8)"),i.addColorStop(1,"rgba(237, 247, 249,0)"),this.image=e,o.fillStyle=i,o.fillRect(0,0,e.width,e.height)},ol.ext.inherits(ol.particule.Snow,ol.particule.Base),ol.particule.Snow.prototype.draw=function(t){t.save(),t.translate(this.coordinate[0],this.coordinate[1]),t.globalAlpha=.4+this.z/2,t.scale(this.z,this.z),t.drawImage(this.image,-10,-10),t.restore()},ol.particule.Snow.prototype.update=function(t){var e=this.getOverlay().get("speed")*t/this.getOverlay()._fps*this.z*5,o=this.getOverlay().get("angle");this.angle=this.angle+t/this.getOverlay()._fps/100,this.coordinate[0]+=2*Math.sin(this.angle+this.z)+e*Math.cos(o),this.coordinate[1]+=Math.cos(this.angle)+e*Math.sin(o)},ol.Overlay.Popup=function(t){"number"==typeof(t=t||{}).offsetBox?this.offsetBox=[t.offsetBox,t.offsetBox,t.offsetBox,t.offsetBox]:this.offsetBox=t.offsetBox;var e=document.createElement("div");t.element=e,this.closeBox=t.closeBox,this.onclose=t.onclose,this.onshow=t.onshow,ol.ext.element.create("BUTTON",{className:"closeBox"+(t.closeBox?" hasclosebox":""),type:"button",click:function(){this.hide()}.bind(this),parent:e}),!1!==t.anchor&&ol.ext.element.create("DIV",{className:"anchor",parent:e}),this.content=ol.ext.element.create("DIV",{html:t.html||"",className:"ol-popup-content",parent:e}),t.minibar&&ol.ext.element.scrollDiv(this.content,{vertical:!0,mousewheel:!0,minibar:!0}),t.stopEvent&&(e.addEventListener("mousedown",function(t){t.stopPropagation()}),e.addEventListener("touchstart",function(t){t.stopPropagation()})),ol.Overlay.call(this,t),this._elt=e,this.setPositioning(t.positioning||"auto"),this.setPopupClass(t.popupClass||t.className||"default"),t.anim&&this.addPopupClass("anim"),t.position&&setTimeout(function(){this.show(t.position)}.bind(this))},ol.ext.inherits(ol.Overlay.Popup,ol.Overlay),ol.Overlay.Popup.prototype.getClassPositioning=function(){var t="",e=this.getPositioning();return/bottom/.test(e)&&(t+="ol-popup-bottom "),/top/.test(e)&&(t+="ol-popup-top "),/left/.test(e)&&(t+="ol-popup-left "),/right/.test(e)&&(t+="ol-popup-right "),/^center/.test(e)&&(t+="ol-popup-middle "),/center$/.test(e)&&(t+="ol-popup-center "),t},ol.Overlay.Popup.prototype.setClosebox=function(t){this.closeBox=t,t?this.element.classList.add("hasclosebox"):this.element.classList.remove("hasclosebox")},ol.Overlay.Popup.prototype.setPopupClass=function(t){var e=["ol-popup"];this.getVisible()&&e.push("visible"),this.element.className="";var o=this.getClassPositioning().split(" ").filter(function(t){return t.length>0});t?t.split(" ").filter(function(t){return t.length>0}).forEach(function(t){e.push(t)}):e.push("default"),o.forEach(function(t){e.push(t)}),this.closeBox&&e.push("hasclosebox"),this.element.classList.add.apply(this.element.classList,e)},ol.Overlay.Popup.prototype.addPopupClass=function(t){this.element.classList.add(t)},ol.Overlay.Popup.prototype.removePopupClass=function(t){this.element.classList.remove(t)},ol.Overlay.Popup.prototype.setPositioning=function(t){void 0!==t&&(/auto/.test(t)?(this.autoPositioning=t.split("-"),1==this.autoPositioning.length&&(this.autoPositioning[1]="auto")):this.autoPositioning=!1,"center"==(t=t.replace(/auto/g,"center"))&&(t="bottom-center"),this.setPositioning_(t))},ol.Overlay.Popup.prototype.setPositioning_=function(t){if(this.element){ol.Overlay.prototype.setPositioning.call(this,t),this.element.classList.remove("ol-popup-top","ol-popup-bottom","ol-popup-left","ol-popup-right","ol-popup-center","ol-popup-middle");var e=this.getClassPositioning().split(" ").filter(function(t){return t.length>0});this.element.classList.add.apply(this.element.classList,e)}},ol.Overlay.Popup.prototype.getVisible=function(){return this.element.classList.contains("visible")},ol.Overlay.Popup.prototype.show=function(t,e){e||"string"!=typeof t||(e=t,t=null),!0===t&&(t=this.getPosition());var o=this,i=this.getMap();if(i&&(e&&e!==this.prevHTML&&(this.prevHTML=e,this.content.innerHTML="",e instanceof Element?this.content.appendChild(e):ol.ext.element.create("DIV",{html:e,parent:this.content}),Array.prototype.slice.call(this.content.querySelectorAll("img")).forEach(function(t){t.addEventListener("load",function(){try{i.renderSync()}catch(t){}o.content.dispatchEvent(new Event("scroll"))})})),t)){if(this.autoPositioning){var n=i.getPixelFromCoordinate(t),r=i.getSize(),s=[];"auto"==this.autoPositioning[0]?s[0]=n[1]<r[1]/3?"top":"bottom":s[0]=this.autoPositioning[0],s[1]=n[0]<2*r[0]/3?"left":"right",this.setPositioning_(s[0]+"-"+s[1]),this.offsetBox&&this.setOffset([this.offsetBox["left"==s[1]?2:0],this.offsetBox["top"==s[0]?3:1]])}else this.offsetBox&&this.setOffset(this.offsetBox);this.setPosition(t),this.element.parentElement.style.display="","function"==typeof this.onshow&&this.onshow(),this.dispatchEvent({type:"show"}),this._tout=setTimeout(function(){o.element.classList.add("visible")},0)}},ol.Overlay.Popup.prototype.hide=function(){null!=this.getPosition()&&("function"==typeof this.onclose&&this.onclose(),this.setPosition(void 0),this._tout&&clearTimeout(this._tout),this.element.classList.remove("visible"),this.dispatchEvent({type:"hide"}))},ol.Overlay.AnimatedCanvas=function(t){t||(t={}),this._canvas=ol.ext.element.create("CANVAS",{className:((t.className||"")+" ol-animated-overlay").trim()}),this._ctx=this._canvas.getContext("2d"),ol.Overlay.call(this,{element:this._canvas,stopEvent:!1}),this._listener=[],this._time=0,this._particuleClass=t.particule||ol.particule.Base,t.createParticule&&(this._createParticule=t.createParticule),this._fps=1e3/(t.fps||25);var e=this._createParticule();this._psize=e.get("size")||[50,50],this.set("density",t.density||.5),this.set("speed",t.speed||4),this.set("angle","number"==typeof t.angle?t.angle:Math.PI/4),!1!==t.animate&&this.setAnimation(!0),document.addEventListener("visibilitychange",function(){this._pause=!0}.bind(this))},ol.ext.inherits(ol.Overlay.AnimatedCanvas,ol.Overlay),ol.Overlay.AnimatedCanvas.prototype.setVisible=function(t){this.element.style.display=t?"block":"none",t&&this.setAnimation(this.get("animation"))},ol.Overlay.AnimatedCanvas.prototype.getVisible=function(){return"none"!=this.element.style.display},ol.Overlay.AnimatedCanvas.prototype.updatePixelPosition=function(){},ol.Overlay.AnimatedCanvas.prototype.setMap=function(t){if(this.getMap()&&this.getMap().getViewport().querySelector(".ol-overlaycontainer").removeChild(this._canvas),this._listener.forEach(function(t){ol.Observable.unByKey(t)}),this._listener=[],ol.Overlay.prototype.setMap.call(this,t),t){var e=t.getSize();this._canvas.width=e[0],this._canvas.height=e[1],this.draw(),this._listener.push(t.on("change:size",function(){var e=t.getSize();this._canvas.width===e[0]&&this._canvas.height===e[1]||(this._canvas.width=e[0],this._canvas.height=e[1],this.draw())}.bind(this)))}},ol.Overlay.AnimatedCanvas.prototype.getParticules=function(){var t=this._psize[0],e=this._psize[1],o=this.get("density")*this._canvas.width*this._canvas.height/t/e<<0;if(this._particules||(this._particules=[]),o>this._particules.length)for(var i=this._particules.length;i<o;i++)this._particules.push(this._createParticule(this,this.randomCoord()));else this._particules.length=o;return this._particules},ol.Overlay.AnimatedCanvas.prototype._createParticule=function(t,e){return new this._particuleClass({overlay:t,coordinate:e})},ol.Overlay.AnimatedCanvas.prototype.randomCoord=function(){return[Math.random()*(this._canvas.width+this._psize[0])-this._psize[0]/2,Math.random()*(this._canvas.height+this._psize[1])-this._psize[1]/2]},ol.Overlay.AnimatedCanvas.prototype.draw=function(t){var e=this._ctx;this.clear(),e.beginPath(),this.getParticules().forEach(function(e){t&&(e.update(t),this.testExit(e)),e.draw(this._ctx)}.bind(this))},ol.Overlay.AnimatedCanvas.prototype.testExit=function(t){var e=this._psize;t.coordinate[0]<-e[0]?(t.coordinate[0]=this._canvas.width+e[0],t.coordinate[1]=Math.random()*(this._canvas.height+e[1])-e[1]/2):t.coordinate[0]>this._canvas.width+e[0]?(t.coordinate[0]=-e[0],t.coordinate[1]=Math.random()*(this._canvas.height+e[1])-e[1]/2):t.coordinate[1]<-e[1]?(t.coordinate[0]=Math.random()*(this._canvas.width+e[0])-e[0]/2,t.coordinate[1]=this._canvas.height+e[1]):t.coordinate[1]>this._canvas.height+e[1]&&(t.coordinate[0]=Math.random()*(this._canvas.width+e[0])-e[0]/2,t.coordinate[1]=-e[1])},ol.Overlay.AnimatedCanvas.prototype.clear=function(){this._ctx.clearRect(0,0,this._canvas.width,this._canvas.height)},ol.Overlay.AnimatedCanvas.prototype.getCanvas=function(){return this._canvas},ol.Overlay.AnimatedCanvas.prototype.setAnimation=function(t){t=!1!==t,this.set("animation",t),t?(this._pause=!0,requestAnimationFrame(this._animate.bind(this))):this.dispatchEvent({type:"animation:stop",time:this._time})},ol.Overlay.AnimatedCanvas.prototype._animate=function(t){this.getVisible()&&this.get("animation")&&(this._pause?requestAnimationFrame(function(t){this._time=t,requestAnimationFrame(this._animate.bind(this))}.bind(this)):(t-this._time>this._fps&&(this.draw(t-this._time),this._time=t),requestAnimationFrame(this._animate.bind(this)))),this._pause=!1},ol.Overlay.Fixed=function(t){ol.Overlay.call(this,t)},ol.ext.inherits(ol.Overlay.Fixed,ol.Overlay),ol.Overlay.Fixed.prototype.setPosition=function(t,e){this.getMap()&&t&&(this._pixel=this.getMap().getPixelFromCoordinate(t)),ol.Overlay.prototype.setPosition.call(this,t),e&&ol.Overlay.prototype.updatePixelPosition.call(this)},ol.Overlay.Fixed.prototype.updatePixelPosition=function(){if(this.getMap()&&this._pixel&&this.getPosition()){var t=this.getMap().getPixelFromCoordinate(this.getPosition());Math.round(1e3*t[0])===Math.round(1e3*this._pixel[0])&&Math.round(1e3*t[0])===Math.round(1e3*this._pixel[0])||this.setPosition(this.getMap().getCoordinateFromPixel(this._pixel))}},ol.Overlay.FixedPopup=function(t){t.anchor=!1,t.positioning=t.positioning||"center-center",t.className=(t.className||"")+" ol-fixPopup",ol.Overlay.Popup.call(this,t),this.set("minScale",t.minScale||.5),this.set("maxScale",t.maxScale||2);var e=document.createElement("canvas");this._overlay=new ol.layer.Image({source:new ol.source.ImageCanvas({canvasFunction:function(t,o,i,n){return e.width=n[0],e.height=n[1],e}})}),this._style=t.style||new ol.style.Style({fill:new ol.style.Fill({color:[102,153,255]})}),this._overlay.on(["postcompose","postrender"],function(t){if(this.getVisible()&&this._pixel){var e=this.getMap(),o=this.getPosition(),i=e.getPixelFromCoordinate(o),n=this.element.getBoundingClientRect(),r=this.getMap().getTargetElement().getBoundingClientRect(),s=[n.left-r.left+n.width/2,n.top-r.top+n.height/2];t.context.save();var a=t.inversePixelTransform;a?t.context.transform(a[0],a[1],a[2],a[3],a[4],a[5]):t.context.scale(t.frameState.pixelRatio,t.frameState.pixelRatio),t.context.beginPath(),t.context.moveTo(i[0],i[1]),Math.abs(s[0]-i[0])>Math.abs(s[1]-i[1])?(t.context.lineTo(s[0],s[1]-8),t.context.lineTo(s[0],s[1]+8)):(t.context.lineTo(s[0]-8,s[1]),t.context.lineTo(s[0]+8,s[1])),t.context.moveTo(i[0],i[1]),this._style.getFill()&&(t.context.fillStyle=ol.color.asString(this._style.getFill().getColor()),t.context.fill()),this._style.getStroke()&&(t.context.strokeStyle=ol.color.asString(this._style.getStroke().getColor()),t.context.lineWidth=this._style.getStroke().width(),t.context.stroke()),t.context.restore()}}.bind(this));var o=function(){this.setPixelPosition()}.bind(this);function i(t){var e=0,o=0,i=0;for(var n in t)e+=t[n].clientX,o+=t[n].clientY,i++;return[e/i,o/i]}function n(t){var e=Object.keys(t);return!(e.length<2)&&ol.coordinate.dist2d([t[e[0]].clientX,t[e[0]].clientY],[t[e[1]].clientX,t[e[1]].clientY])}this.on(["hide","show"],function(){setTimeout(o)}.bind(this));var r,s,a,l,c={},h={},p=[];this.element.addEventListener("pointerdown",function(t){for(var e in t.preventDefault(),t.stopPropagation(),c)h[e]&&(c[e]=h[e]);c[t.pointerId]=t,p=this._pixel,s=this.get("rotation")||0,a=this.get("scale")||1,r=n(c),l=!1}.bind(this)),this.element.addEventListener("click",function(t){l&&(t.preventDefault(),t.stopPropagation())},!0);var u=function(t){c[t.pointerId]&&(delete c[t.pointerId],t.preventDefault()),h[t.pointerId]&&delete h[t.pointerId]}.bind(this);document.addEventListener("pointerup",u),document.addEventListener("pointercancel",u),document.addEventListener("pointermove",function(t){if(c[t.pointerId]){t.preventDefault(),h[t.pointerId]=t;var e=i(c),o=i(h),u=o[0]-e[0],g=o[1]-e[1];l=l||Math.abs(u)>3||Math.abs(g)>3;var d=function(){var t,e,o=Object.keys(c);if(o.length<2)return!1;t=c[o[0]];var i=[(e=c[o[1]]).clientX-t.clientX,e.clientY-t.clientY];t=h[o[0]];var n=[(e=h[o[1]]).clientX-t.clientX,e.clientY-t.clientY],r=Math.sqrt(i[0]*i[0]+i[1]*i[1]),s=Math.sqrt(n[0]*n[0]+n[1]*n[1]),a=360*Math.acos((i[0]*n[0]+i[1]*n[1])/(r*s))/Math.PI;return i[0]*n[1]-i[1]*n[0]<0?-a:a}();d&&this.setRotation(s+1.5*d,!1);var m=n(h);!1!==m&&r&&(this.setScale(a*m/r,!1),r=a*m/this.get("scale")),this.setPixelPosition([p[0]+u,p[1]+g])}}.bind(this))},ol.ext.inherits(ol.Overlay.FixedPopup,ol.Overlay.Popup),ol.Overlay.FixedPopup.prototype.setMap=function(t){ol.Overlay.Popup.prototype.setMap.call(this,t),this._overlay.setMap(this.getMap()),this._listener&&ol.Observable.unByKey(this._listener),t&&(this._listener=t.on("change:size",function(){this.setPixelPosition()}.bind(this)))},ol.Overlay.FixedPopup.prototype.updatePixelPosition=function(){var t=this.getMap(),e=this.getPosition();if(t&&t.isRendered()&&e)if(this._pixel)this.setVisible(!0);else{this._pixel=t.getPixelFromCoordinate(e);var o=t.getSize();this.updateRenderedPosition(this._pixel,o)}else this.setVisible(!1)},ol.Overlay.FixedPopup.prototype.updateRenderedPosition=function(t,e){ol.Overlay.Popup.prototype.updateRenderedPosition.call(this,t,e),this.setRotation(),this.setScale()},ol.Overlay.FixedPopup.prototype.setPixelPosition=function(t,e){var o,i=this.getMap(),n=i?i.getSize():[0,0];if(e&&(this.setPositioning(e),(o=ol.ext.element.offsetRect(this.element)).width=o.height=0,/top/.test(e)?t[1]+=o.height/2:/bottom/.test(e)?t[1]=n[1]-o.height/2-t[1]:t[1]=n[1]/2+t[1],/left/.test(e)?t[0]+=o.width/2:/right/.test(e)?t[0]=n[0]-o.width/2-t[0]:t[0]=n[0]/2+t[0]),t&&(this._pixel=t),i&&this._pixel){this.updateRenderedPosition(this._pixel,n);var r=!1;o=ol.ext.element.offsetRect(this.element);var s=ol.ext.element.offsetRect(i.getTargetElement());o.left<s.left?(this._pixel[0]=this._pixel[0]+s.left-o.left,r=!0):o.left+o.width>s.left+s.width&&(this._pixel[0]=this._pixel[0]+s.left-o.left+s.width-o.width,r=!0),o.top<s.top?(this._pixel[1]=this._pixel[1]+s.top-o.top,r=!0):o.top+o.height>s.top+s.height&&(this._pixel[1]=this._pixel[1]+s.top-o.top+s.height-o.height,r=!0),r&&this.updateRenderedPosition(this._pixel,n),this._overlay.changed()}},ol.Overlay.FixedPopup.prototype.getPixelPosition=function(){return this._pixel},ol.Overlay.FixedPopup.prototype.setPopupClass=function(t){ol.Overlay.Popup.prototype.setPopupClass.call(this,t),this.addPopupClass("ol-fixPopup")},ol.Overlay.FixedPopup.prototype.setRotation=function(t,e){"number"==typeof t&&this.set("rotation",t),!1!==e&&(/rotate/.test(this.element.style.transform)?this.element.style.transform=this.element.style.transform.replace(/rotate\((-?[\d,.]+)deg\)/,"rotate("+(this.get("rotation")||0)+"deg)"):this.element.style.transform=this.element.style.transform+" rotate("+(this.get("rotation")||0)+"deg)")},ol.Overlay.FixedPopup.prototype.setScale=function(t,e){"number"==typeof t&&this.set("scale",t),t=Math.min(Math.max(this.get("minScale")||0,this.get("scale")||1),this.get("maxScale")||2),this.set("scale",t),!1!==e&&(/scale/.test(this.element.style.transform)?this.element.style.transform=this.element.style.transform.replace(/scale\(([\d,.]+)\)/,"scale("+t+")"):this.element.style.transform=this.element.style.transform+" scale("+t+")")},ol.Overlay.FixedPopup.prototype.setLinkStyle=function(t){this._style=t,this._overlay.changed()},ol.Overlay.FixedPopup.prototype.getLinkStyle=function(){return this._style},ol.Overlay.Magnify=function(t){var e=document.createElement("div");e.className="ol-magnify",this._elt=e,ol.Overlay.call(this,{positioning:t.positioning||"center-center",element:this._elt,stopEvent:!1}),this.mgmap_=new ol.Map({controls:new ol.Collection,interactions:new ol.Collection,target:t.target||this._elt,view:new ol.View({projection:t.projection}),layers:t.layers}),this.mgview_=this.mgmap_.getView(),this.external_=!!t.target,this.set("zoomOffset",t.zoomOffset||1),this.set("active",!0),this.on("propertychange",this.setView_.bind(this))},ol.ext.inherits(ol.Overlay.Magnify,ol.Overlay),ol.Overlay.Magnify.prototype.setMap=function(t){this.getMap()&&this.getMap().getViewport().removeEventListener("mousemove",this.onMouseMove_),this._listener&&ol.Observable.unByKey(this._listener),this._listener=null,ol.Overlay.prototype.setMap.call(this,t),t.getViewport().addEventListener("mousemove",this.onMouseMove_.bind(this)),this._listener=t.getView().on("propertychange",this.setView_.bind(this)),this.setView_()},ol.Overlay.Magnify.prototype.getMagMap=function(){return this.mgmap_},ol.Overlay.Magnify.prototype.getActive=function(){return this.get("active")},ol.Overlay.Magnify.prototype.setActive=function(t){return this.set("active",t)},ol.Overlay.Magnify.prototype.onMouseMove_=function(t){if(this.get("active")){var e=this.getMap().getEventCoordinate(t);this.external_||this.setPosition(e),this.mgview_.setCenter(e),this._elt.querySelector("canvas")&&"none"!=this._elt.querySelector("canvas").style.display||this.mgmap_.updateSize()}else this.setPosition()},ol.Overlay.Magnify.prototype.setView_=function(t){if(this.get("active")){if(!t)return this.setView_({key:"rotation"}),void this.setView_({key:"resolution"});switch(t.key){case"rotation":this.mgview_.setRotation(this.getMap().getView().getRotation());break;case"zoomOffset":case"resolution":var e=Math.max(0,this.getMap().getView().getZoom()+Number(this.get("zoomOffset")));this.mgview_.setZoom(e)}}else this.setPosition()},ol.Overlay.Placemark=function(t){(t=t||{}).popupClass=(t.popupClass||"")+" placemark anim",t.positioning="bottom-center",ol.Overlay.Popup.call(this,t),this.setPositioning=function(){},t.color&&(this.element.style.color=t.color),t.backgroundColor&&(this.element.style.backgroundColor=t.backgroundColor),t.contentColor&&this.setContentColor(t.contentColor),t.size&&this.setRadius(t.size)},ol.ext.inherits(ol.Overlay.Placemark,ol.Overlay.Popup),ol.Overlay.Placemark.prototype.show=function(t,e){!0===t&&(t=this.getPosition()),this.hide(),ol.Overlay.Popup.prototype.show.apply(this,[t,e])},ol.Overlay.Placemark.prototype.setColor=function(t){this.element.style.color=t},ol.Overlay.Placemark.prototype.setBackgroundColor=function(t){this._elt.style.backgroundColor=t},ol.Overlay.Placemark.prototype.setContentColor=function(t){var e=this.element.getElementsByClassName("ol-popup-content")[0];e&&(e.style.color=t)},ol.Overlay.Placemark.prototype.setClassName=function(t){var e=this.element.className;this.element.className="ol-popup placemark ol-popup-bottom ol-popup-center "+(/visible/.test(e)?"visible ":"")+(/anim/.test(e)?"anim ":"")+t},ol.Overlay.Placemark.prototype.setRadius=function(t){this.element.style.fontSize=t+"px"},ol.Overlay.PopupFeature=function(t){t=t||{},ol.Overlay.Popup.call(this,t),this.setTemplate(t.template),this.set("canFix",t.canFix),this.set("showImage",t.showImage),this.set("maxChar",t.maxChar||200),this.set("keepSelection",t.keepSelection),t.select&&"function"==typeof t.select.on&&(this._select=t.select,t.select.on("select",function(e){this._noselect||(e.selected[0]?this.show(e.mapBrowserEvent.coordinate,t.select.getFeatures().getArray(),e.selected[0]):this.hide())}.bind(this)))},ol.ext.inherits(ol.Overlay.PopupFeature,ol.Overlay.Popup),ol.Overlay.PopupFeature.prototype.setTemplate=function(t){t||(t=function(t){var e=t.getProperties();return delete e[t.getGeometryName()],{attributes:Object.keys(e)}}),this._template=t,this._attributeObject(this._template)},ol.Overlay.PopupFeature.prototype._attributeObject=function(t){if(t&&t.attributes instanceof Array){var e={};t.attributes.forEach(function(t){e[t]=!0}),t.attributes=e}return t.attributes},ol.Overlay.PopupFeature.prototype.show=function(t,e,o){(t instanceof ol.Feature||t instanceof Array&&t[0]instanceof ol.Feature)&&(e=t,t=null),e instanceof Array||(e=[e]),this._features=e.slice(),this._count||(this._count=1),this._count=1;var i=this.get("keepSelection")&&o||e[0],n=this._getHtml(i);n?(this.element.classList.contains("ol-fixed")||this.hide(),t&&"Point"!==e[0].getGeometry().getType()||(t=e[0].getGeometry().getFirstCoordinate()),ol.Overlay.Popup.prototype.show.call(this,t,n)):this.hide()},ol.Overlay.PopupFeature.prototype._getHtml=function(t){if(!t)return"";var e=ol.ext.element.create("DIV",{className:"ol-popupfeature"});this.get("canFix")&&ol.ext.element.create("I",{className:"ol-fix",parent:e}).addEventListener("click",function(){this.element.classList.toggle("ol-fixed")}.bind(this));var o,i=this._template;if("function"==typeof i)i=i(t,this._count,this._features.length);else if(!i||!i.attributes)for(var n in(i=i||{}).attributes={},t.getProperties())"geometry"!=n&&(i.attributes[n]=n);i.title&&(o="function"==typeof i.title?i.title(t):t.get(i.title),ol.ext.element.create("H1",{html:o,parent:e}));if(i.attributes){var r,s=ol.ext.element.create("TABLE",{parent:e}),a=this._attributeObject(i),l=t.getProperties();for(var c in a)if(l.hasOwnProperty(c)){var h,p=a[c],u=l[c];"function"==typeof p.format&&(u=p.format(u,t));var g=!0;if("boolean"==typeof p.visible?g=p.visible:"function"==typeof p.visible&&(g=p.visible(t,u)),g){if(r=ol.ext.element.create("TR",{parent:s}),ol.ext.element.create("TD",{html:p.title||c,parent:r}),this.get("showImage")&&/(http(s?):)([/|.|\w|\s|-])*\.(?:jpg|gif|png)/.test(u))h=ol.ext.element.create("IMG",{src:u});else{h=(p.before||"")+u+(p.after||"");var d=this.get("maxChar")||200;"string"==typeof h&&h.length>d&&(h=h.substr(0,d)+"[...]")}ol.ext.element.create("TD",{html:h,parent:r})}}}if(ol.ext.element.create("BUTTON",{className:"ol-zoombt",parent:e}).addEventListener("click",function(){if("Point"===t.getGeometry().getType())this.getMap().getView().animate({center:t.getGeometry().getFirstCoordinate(),zoom:Math.max(this.getMap().getView().getZoom(),18)});else{var e=t.getGeometry().getExtent();this.getMap().getView().fit(e,{duration:1e3})}}.bind(this)),!this.get("keepSelection")&&this._features.length>1){var m=ol.ext.element.create("DIV",{className:"ol-count",parent:e});ol.ext.element.create("DIV",{className:"ol-prev",parent:m,click:function(){this._count--,this._count<1&&(this._count=this._features.length),e=this._getHtml(this._features[this._count-1]),setTimeout(function(){ol.Overlay.Popup.prototype.show.call(this,this.getPosition(),e)}.bind(this),350)}.bind(this)}),ol.ext.element.create("TEXT",{html:this._count+"/"+this._features.length,parent:m}),ol.ext.element.create("DIV",{className:"ol-next",parent:m,click:function(){this._count++,this._count>this._features.length&&(this._count=1),e=this._getHtml(this._features[this._count-1]),setTimeout(function(){ol.Overlay.Popup.prototype.show.call(this,this.getPosition(),e)}.bind(this),350)}.bind(this)})}return this._select&&!this.get("keepSelection")&&(this._noselect=!0,this._select.getFeatures().clear(),this._select.getFeatures().push(t),this._noselect=!1),this.dispatchEvent({type:"select",feature:t,index:this._count}),e},ol.Overlay.PopupFeature.prototype.setFix=function(t){t?this.element.classList.add("ol-fixed"):this.element.classList.remove("ol-fixed")},ol.Overlay.PopupFeature.prototype.getFix=function(){return this.element.classList.contains("ol-fixed")},ol.Overlay.PopupFeature.localString=function(t,e){return function(o){if(o&&o.toLocaleString)return o.toLocaleString(t,e);var i=new Date(o);return isNaN(i)?o:i.toLocaleString(t,e)}},ol.Overlay.Tooltip=function(t){(t=t||{}).popupClass=t.popupClass||t.className||"tooltips black",t.positioning=t.positioning||"center-left",t.stopEvent=!!t.stopEvent,ol.Overlay.Popup.call(this,t),this.set("maximumFractionDigits",t.maximumFractionDigits||2),"function"==typeof t.formatLength&&(this.formatLength=t.formatLength),"function"==typeof t.formatArea&&(this.formatArea=t.formatArea),"function"==typeof t.getHTML&&(this.getHTML=t.getHTML),this._interaction=new ol.interaction.Interaction({handleEvent:function(t){if("pointermove"===t.type||"click"===t.type){var e=this.getHTML(this._feature,this.get("info"));e?this.show(t.coordinate,e):this.hide(),this._coord=t.coordinate}return!0}.bind(this)})},ol.ext.inherits(ol.Overlay.Tooltip,ol.Overlay.Popup),ol.Overlay.Tooltip.prototype.setMap=function(t){this.getMap()&&this.getMap().removeInteraction(this._interaction),ol.Overlay.Popup.prototype.setMap.call(this,t),this.getMap()&&this.getMap().addInteraction(this._interaction)},ol.Overlay.Tooltip.prototype.getHTML=function(t,e){return this.get("measure")?this.get("measure")+(e?"<br/>"+e:""):e||""},ol.Overlay.Tooltip.prototype.setInfo=function(t){t?setTimeout(function(){this.set("info",t),this.show(this._coord,this.get("info"))}.bind(this)):(this.set("info",""),this.hide())},ol.Overlay.Tooltip.prototype.removeFeature=function(){this.setFeature()},ol.Overlay.Tooltip.prototype.formatArea=function(t){return t>Math.pow(10,-1*this.get("maximumFractionDigits"))?t>1e4?(t/1e6).toLocaleString(void 0,{maximumFractionDigits:this.get("maximumFractionDigits)")})+" km²":t.toLocaleString(void 0,{maximumFractionDigits:this.get("maximumFractionDigits")})+" m²":""},ol.Overlay.Tooltip.prototype.formatLength=function(t){return t>Math.pow(10,-1*this.get("maximumFractionDigits"))?t>100?(t/1e3).toLocaleString(void 0,{maximumFractionDigits:this.get("maximumFractionDigits")})+" km":t.toLocaleString(void 0,{maximumFractionDigits:this.get("maximumFractionDigits")})+" m":""},ol.Overlay.Tooltip.prototype.setFeature=function(t){t&&t.feature&&(t=t.feature),this._feature=t,this._listener&&this._listener.forEach(function(t){ol.Observable.unByKey(t)}),this._listener=[],this.set("measure",""),t&&this._listener.push(t.getGeometry().on("change",function(t){var e,o=t.target;o.getArea?e=this.formatArea(ol.sphere.getArea(o,{projection:this.getMap().getView().getProjection()})):o.getLength&&(e=this.formatLength(ol.sphere.getLength(o,{projection:this.getMap().getView().getProjection()}))),this.set("measure",e)}.bind(this)))},ol.coordinate.convexHull,function(){var t=function(t,e,o){return(t[0]-o[0])*(e[1]-o[1])-(t[1]-o[1])*(e[0]-o[0])<=0};ol.coordinate.convexHull=function(e){var o;e.sort(function(t,e){return t[0]==e[0]?t[1]-e[1]:t[0]-e[0]});var i=[];for(o=0;o<e.length;o++){for(;i.length>=2&&t(i[i.length-2],i[i.length-1],e[o]);)i.pop();i.push(e[o])}var n=[];for(o=e.length-1;o>=0;o--){for(;n.length>=2&&t(n[n.length-2],n[n.length-1],e[o]);)n.pop();n.push(e[o])}return n.pop(),i.pop(),i.concat(n)};var e=function(t){var o,i,n=[];switch(t.getType()){case"Point":n.push(t.getCoordinates());break;case"LineString":case"LinearRing":case"MultiPoint":n=t.getCoordinates();break;case"MultiLineString":for(i=t.getLineStrings(),o=0;o<i.length;o++)n.concat(e(i[o]));break;case"Polygon":n=e(t.getLinearRing(0));break;case"MultiPolygon":for(i=t.getPolygons(),o=0;o<i.length;o++)n.concat(e(i[o]));break;case"GeometryCollection":for(i=t.getGeometries(),o=0;o<i.length;o++)n.concat(e(i[o]))}return n};ol.geom.Geometry.prototype.convexHull=function(){return ol.coordinate.convexHull(e(this))}}(),ol.coordinate.toDFCI=function(t,e,o){e||0===e||(e=3),o&&(ol.proj.get("EPSG:27572")||(proj4.defs["EPSG:27572"]||proj4.defs("EPSG:27572","+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.99987742 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs"),ol.proj.proj4.register(proj4)),t=ol.proj.transform(t,o,"EPSG:27572"));var i=t[0],n=t[1],r="";if(r+=String.fromCharCode(65+Math.floor((i<8e5?i:i+2e5)/1e5))+String.fromCharCode(65+Math.floor((n<23e5?n:n+2e5)/1e5)-15),0===e)return r;if(r+=2*Math.floor(i%1e5/2e4),r+=2*Math.floor(n%1e5/2e4),1===e)return r;var s=Math.floor(i%2e4/2e3);if(r+=String.fromCharCode(65+(s<8?s:s+2)),r+=Math.floor(n%2e4/2e3),2===e)return r;var a=Math.floor(i%2e3/500),l=Math.floor(n%2e3/500);return r+=a<1?l>1?".1":".4":a>2?l>1?".2":".3":l>2?a<2?".1":".2":l<1?a<2?".4":".3":".5"},ol.coordinate.fromDFCI=function(t,e){var o,i=1e5,n=t.charCodeAt(0)-65;n=(n<8?n:n-2)*i;var r=t.charCodeAt(1)-65;if(r=(r<8?r:r-2)*i+15e5,2===t.length)o=[n+i/2,r+i/2];else if(i/=5,n+=Number(t.charAt(2))/2*i,r+=Number(t.charAt(3))/2*i,4===t.length)o=[n+i/2,r+i/2];else{i/=10;var s=t.charCodeAt(4)-65;if(n+=(s<8?s:s-2)*i,r+=Number(t.charAt(5))*i,6===t.length)o=[n+i/2,r+i/2];else switch(t.charAt(7)){case"1":o=[n+i/4,r+3*i/4];break;case"2":o=[n+3*i/4,r+3*i/4];break;case"3":o=[n+3*i/4,r+i/4];break;case"4":o=[n+i/4,r+i/4];break;default:o=[n+i/2,r+i/2]}}return e&&(ol.proj.get("EPSG:27572")||(proj4.defs["EPSG:27572"]||proj4.defs("EPSG:27572","+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.99987742 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs"),ol.proj.proj4.register(proj4)),o=ol.proj.transform(o,"EPSG:27572",e)),o},ol.coordinate.validDFCI=function(t){if(t.length<2||t.length>8)return!1;if(/[^A-H|^K-N]/.test(t.substr(0,1)))return!1;if(/[^B-H|^K-N]/.test(t.substr(1,1)))return!1;if(t.length>2){if(t.length<4)return!1;if(/[^0,^2,^4,^6,^8]/.test(t.substr(2,1)))return!1;if(/[^0,^2,^4,^6,^8]/.test(t.substr(3,1)))return!1}if(t.length>4){if(t.length<6)return!1;if(/[^A-H|^K-L]/.test(t.substr(4,1)))return!1;if(/[^0-9]/.test(t.substr(5,1)))return!1}if(t.length>6){if(t.length<8)return!1;if("."!==t.substr(6,1))return!1;if(/[^1-5]/.test(t.substr(7,1)))return!1}return!0},ol.coordinate.validDFCICoord=function(t,e){return e&&(ol.proj.get("EPSG:27572")||(proj4.defs["EPSG:27572"]||proj4.defs("EPSG:27572","+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.99987742 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs"),ol.proj.proj4.register(proj4)),t=ol.proj.transform(t,e,"EPSG:27572")),!(0>t[0]||t[0]>12e5)&&!(16e5>t[1]||t[1]>27e5)},ol.graph={},ol.graph.Dijskra=function(t){t=t||{},this.source=t.source,this.nodes=new ol.source.Vector,this.maxIteration=t.maxIteration||2e4,this.stepIteration=t.stepIteration||2e3,this.astar=!0,this.candidat=[],ol.Object.call(this),this.set("epsilon",t.epsilon||1e-6)},ol.ext.inherits(ol.graph.Dijskra,ol.Object),ol.graph.Dijskra.prototype.weight=function(){return 1},ol.graph.Dijskra.prototype.direction=function(){return 2},ol.graph.Dijskra.prototype.getLength=function(t){return t.getGeometry&&(t=t.getGeometry()),t.getLength()},ol.graph.Dijskra.prototype.getNodeSource=function(){return this.nodes},ol.graph.Dijskra.prototype.getEdges=function(t){var e=ol.extent.buffer(ol.extent.boundingExtent([t]),this.get("epsilon")),o=[];return this.source.forEachFeatureIntersectingExtent(e,function(t){o.push(t)}),o},ol.graph.Dijskra.prototype.getNode=function(t){var e=ol.extent.buffer(ol.extent.boundingExtent([t]),this.get("epsilon")),o=[];return this.nodes.forEachFeatureIntersectingExtent(e,function(t){o.push(t)}),o[0]},ol.graph.Dijskra.prototype.addNode=function(t,e,o,i,n){if(this.wdist&&e>this.wdist)return!1;var r=this.getNode(t),s=e+this.getLength(new ol.geom.LineString([this.end,t]))*this.weight();if(this.astar&&this.wdist&&s>this.wdist)return!1;if(r){if(r!==this.arrival&&r.get("wdist")<=e)return r;r.set("dist",o),r.set("wdist",e),r.set("dtotal",s),r.set("from",i),r.set("prev",n),r===this.arrival&&(this.wdist=e),this.candidat.push(r)}else r=new ol.Feature({geometry:new ol.geom.Point(t),from:i,prev:n,dist:o||0,wdist:e,dtotal:s}),e<0?r.set("wdist",!1):this.candidat.push(r),this.nodes.addFeature(r);return r},ol.graph.Dijskra.prototype.closestCoordinate=function(t){var e=this.source.getClosestFeatureToCoordinate(t),o=e.getGeometry().getFirstCoordinate(),i=e.getGeometry().getLastCoordinate();return ol.coordinate.dist2d(t,o)<ol.coordinate.dist2d(t,i)?o:i},ol.graph.Dijskra.prototype.path=function(t,e){if(this.running)return!1;if(t=this.closestCoordinate(t),this.end=this.closestCoordinate(e),t[0]===this.end[0]&&t[1]===this.end[1])return this.dispatchEvent({type:"finish",route:[],wDistance:-1,distance:this.wdist}),!1;var o=this;return this.nodes.clear(),this.candidat=[],this.wdist=0,this.running=!0,this.addNode(t,0),this.arrival=this.addNode(this.end,-1),this.nb=0,this.dispatchEvent({type:"start"}),setTimeout(function(){o._resume()}),[t,this.end]},ol.graph.Dijskra.prototype.resume=function(){this.running||this.candidat.length&&(this.running=!0,this.nb=0,this._resume())},ol.graph.Dijskra.prototype.pause=function(){this.running&&(this.nb=-1)},ol.graph.Dijskra.prototype.getBestWay=function(){for(var t,e,o=-1,i=0;e=this.candidat[i];i++)e.get("wdist")>o&&(t=e,o=e.get("wdist"));return this.getRoute(t)},ol.graph.Dijskra.prototype._resume=function(){if(this.running){for(;this.candidat.length;){this.candidat.sort(function(t,e){return t.get("dtotal")<e.get("dtotal")?1:t.get("dtotal")===e.get("dtotal")?0:-1});for(var t,e=this.candidat.pop(),o=e.getGeometry().getCoordinates(),i=this.getEdges(o),n=0;t=i[n];n++){if(e.get("from")!==t){var r=this.getLength(t);r<0&&console.log("distance < 0!");var s=e.get("wdist")+r*this.weight(t);r=e.get("dist")+r;var a=t.getGeometry().getFirstCoordinate(),l=t.getGeometry().getLastCoordinate(),c=this.direction(t);0!==c&&(o[0]===a[0]&&o[1]===a[1]&&-1!==c&&this.addNode(l,s,r,t,e),o[0]===l[0]&&o[0]===l[0]&&1!==c&&this.addNode(a,s,r,t,e))}if(-1===this.nb||this.nb++>this.maxIteration)return this.running=!1,void this.dispatchEvent({type:"pause",overflow:-1!==this.nb});if(!(this.nb%this.stepIteration)){var h=this;return window.setTimeout(function(){h._resume()},5),void this.dispatchEvent({type:"calculating"})}}}this.nodes.clear(),this.running=!1,this.dispatchEvent({type:"finish",route:this.getRoute(this.arrival),wDistance:this.wdist,distance:this.arrival.get("dist")})}},ol.graph.Dijskra.prototype.getRoute=function(t){for(var e=[];t;)e.unshift(t.get("from")),t=t.get("prev");return e.shift(),e},ol.geom.GPAltiCode=function(t,e){e=e||{};var o=t.getType();if("Point"===o||"LineString"===o){var i=e.projection||"EPSG:3857",n=e.sampling||0;if(e.samplingDist){var r=t.getLength();n=Math.max(n,Math.round(r/e.samplingDist))}n>5e3&&(n=5e3),n<2&&(n=0),t=t.clone().transform(i,"EPSG:4326");var s,a=[],l=[];switch(o){case"Point":s=[t.getCoordinates()];break;case"LineString":s=t.getCoordinates();break;default:return}n<=s.length&&(n=0),s.forEach(function(t){a.push(Math.round(1e6*t[0])/1e6),l.push(Math.round(1e6*t[1])/1e6)});var c="lon="+a.join("|")+"&lat="+l.join("|");n&&(c+="&sampling="+n),ol.ext.Ajax.get({url:"https://wxs.ign.fr/"+(e.apiKey||"essentiels")+"/alti/rest/"+(a.length>1?"elevationLine":"elevation")+".json?"+c,success:function(t){var r=[];t.elevations.forEach(function(t,e){n?r.push([t.lon,t.lat,t.z]):r.push([s[e][0],s[e][1],t.z])}),"Point"===o&&(r=r[0]);var a=ol.geom.createFromType(o,r);a.transform("EPSG:4326",i),"function"==typeof e.success&&e.success(a)},error:function(t){"function"==typeof e.error&&e.error(t)}})}else console.warn("[GPAltiCode] "+o+" not supported...")},ol.coordinate.GPAltiCode=function(t,e){e=e||{};var o=!t[0].length?new ol.geom.Point(t):new ol.geom.LineString(t);ol.geom.GPAltiCode(o,{projection:e.projection,apiKey:e.apiKey,sampling:e.sampling,samplingDist:e.samplingDist,success:function(t){"function"==typeof e.success&&e.success(t.getCoordinates())},error:e.error})},ol.coordinate.dist2d=function(t,e){var o=t[0]-e[0],i=t[1]-e[1];return Math.sqrt(o*o+i*i)},ol.coordinate.equal=function(t,e){return t[0]==e[0]&&t[1]==e[1]},ol.coordinate.getFeatureCenter=function(t){return ol.coordinate.getGeomCenter(t.getGeometry())},ol.coordinate.getGeomCenter=function(t){switch(t.getType()){case"Point":return t.getCoordinates();case"MultiPolygon":t=t.getPolygon(0);case"Polygon":return t.getInteriorPoint().getCoordinates();default:return t.getClosestPoint(ol.extent.getCenter(t.getExtent()))}},ol.coordinate.offsetCoords=function(t,e){var o,i,n,r,s,a,l,c,h,p,u,g,d,m=[],f=t.length-1,y=f,v=ol.coordinate.equal(t[0],t[f]);v||(u=t[0],g=t[1],d=[u[0]+(g[1]-u[1])/ol.coordinate.dist2d(u,g)*e,u[1]-(g[0]-u[0])/ol.coordinate.dist2d(u,g)*e],m.push(d),t.push(t[f]),f++,y--);for(var _=0;_<y;_++)u=t[_],g=t[(_+1)%f],d=t[(_+2)%f],o=(g[1]-u[1])/(g[0]-u[0]),i=(d[1]-g[1])/(d[0]-g[0]),Math.abs(o-i)>1e-10&&(n=Math.sqrt((g[0]-u[0])*(g[0]-u[0])+(g[1]-u[1])*(g[1]-u[1])),r=Math.sqrt((d[0]-g[0])*(d[0]-g[0])+(d[1]-g[1])*(d[1]-g[1])),s=u[0]+e*(g[1]-u[1])/n,h=(i*(a=g[0]+e*(d[1]-g[1])/r)-o*s+(l=u[1]-e*(g[0]-u[0])/n)-(c=g[1]-e*(d[0]-g[0])/r))/(i-o),p=(o*i*(a-s)+i*l-o*c)/(i-o),g[0]-u[0]==0&&(p=i*(h=g[0]+e*(g[1]-u[1])/Math.abs(g[1]-u[1]))-i*a+c),d[0]-g[0]==0&&(p=o*(h=d[0]+e*(d[1]-g[1])/Math.abs(d[1]-g[1]))-o*s+l),m.push([h,p]));return v?m.push(m[0]):(t.pop(),u=t[t.length-1],g=t[t.length-2],d=[u[0]-(g[1]-u[1])/ol.coordinate.dist2d(u,g)*e,u[1]+(g[0]-u[0])/ol.coordinate.dist2d(u,g)*e],m.push(d)),m},ol.coordinate.findSegment=function(t,e){for(var o=0;o<e.length-1;o++){var i=e[o],n=e[o+1];if(ol.coordinate.equal(t,i)||ol.coordinate.equal(t,n))return{index:1,segment:[i,n]};var r=ol.coordinate.dist2d(i,n),s=[(n[0]-i[0])/r,(n[1]-i[1])/r],a=ol.coordinate.dist2d(i,t),l=[(t[0]-i[0])/a,(t[1]-i[1])/a];if(Math.abs(s[0]*l[1]-s[1]*l[0])<1e-10)return{index:1,segment:[i,n]}}return{index:-1}},ol.coordinate.splitH=function(t,e,o){for(var i,n,r=[],s=0;s<t.length-1;s++)t[s].length&&t[s+1].length&&(t[s][1]<=e&&t[s+1][1]>e||t[s][1]>=e&&t[s+1][1]<e)&&(i=(n=(e-t[s][1])/(t[s+1][1]-t[s][1]))*(t[s+1][0]-t[s][0])+t[s][0],r.push({contour:o,index:s,pt:[i,e],abs:n}));r.sort(function(t,e){return t.pt[0]-e.pt[0]});for(var a=[],l=0;l<r.length-1;l+=2)a.push([r[l],r[l+1]]);return a};ol.geom.createFromType=function(t,e){switch(t){case"LineString":return new ol.geom.LineString(e);case"LinearRing":return new ol.geom.LinearRing(e);case"MultiLineString":return new ol.geom.MultiLineString(e);case"MultiPoint":return new ol.geom.MultiPoint(e);case"MultiPolygon":return new ol.geom.MultiPolygon(e);case"Point":return new ol.geom.Point(e);case"Polygon":return new ol.geom.Polygon(e);default:return console.error("[createFromType] Unsupported type: "+t),null}},ol.coordinate.getIntersectionPoint=function(t,e){var o=t[1][0]-t[0][0],i=t[1][1]-t[0][1],n=e[1][0]-e[0][0],r=e[1][1]-e[0][1],s=o*r-i*n;if(0!=s){var a=(o*t[0][1]-o*e[0][1]-i*t[0][0]+i*e[0][0])/s;return[e[0][0]+a*n,e[0][1]+a*r]}return!1},ol.extent.intersection,function(){function t(t,e){for(var o,i=t.length-1;i>0;i--)(t[i][0]>e&&t[i-1][0]<e||t[i][0]<e&&t[i-1][0]>e)&&(o=[e,(e-t[i][0])/(t[i-1][0]-t[i][0])*(t[i-1][1]-t[i][1])+t[i][1]],t.splice(i,0,o))}function e(t,e){for(var o,i=t.length-1;i>0;i--)(t[i][1]>e&&t[i-1][1]<e||t[i][1]<e&&t[i-1][1]>e)&&(o=[(e-t[i][1])/(t[i-1][1]-t[i][1])*(t[i-1][0]-t[i][0])+t[i][0],e],t.splice(i,0,o))}ol.extent.intersection=function(o,i){var n="Polygon"===i.getType();if(!n&&"MultiPolygon"!==i.getType())return null;var r=i.getCoordinates();return n&&(r=[r]),r.forEach(function(i){i.forEach(function(i){t(i,o[0]),t(i,o[2]),e(i,o[1]),e(i,o[3])})}),r.forEach(function(t){t.forEach(function(t){t.forEach(function(t){t[0]<o[0]?t[0]=o[0]:t[0]>o[2]&&(t[0]=o[2]),t[1]<o[1]?t[1]=o[1]:t[1]>o[3]&&(t[1]=o[3])})})}),n?new ol.geom.Polygon(r[0]):new ol.geom.MultiPolygon(r)}}(),ol.coordinate.sampleAt=function(t,e,o,i){var n=[];!1!==i&&n.push(t);var r=ol.coordinate.dist2d(t,e);if(r){var s=Math.round(r/o);if(s>1)for(var a=(e[0]-t[0])/s,l=(e[1]-t[1])/s,c=1;c<s;c++)n.push([t[0]+a*c,t[1]+l*c])}return n.push(e),n},ol.geom.LineString.prototype.sampleAt=function(t){for(var e=this.getCoordinates(),o=[],i=1;i<e.length;i++)o=o.concat(ol.coordinate.sampleAt(e[i-1],e[i],t,1===i));return new ol.geom.LineString(o)},ol.geom.MultiLineString.prototype.sampleAt=function(t){var e=this.getCoordinates(),o=[];return e.forEach(function(e){for(var i=[],n=1;n<e.length;n++)i=i.concat(ol.coordinate.sampleAt(e[n-1],e[n],t,1===n));o.push(i)}),new ol.geom.MultiLineString(o)},ol.geom.Polygon.prototype.sampleAt=function(t){var e=this.getCoordinates(),o=[];return e.forEach(function(e){for(var i=[],n=1;n<e.length;n++)i=i.concat(ol.coordinate.sampleAt(e[n-1],e[n],t,1===n));o.push(i)}),new ol.geom.Polygon(o)},ol.geom.MultiPolygon.prototype.sampleAt=function(t){var e=this.getCoordinates(),o=[];return e.forEach(function(e){var i=[];o.push(i),e.forEach(function(e){for(var o=[],n=1;n<e.length;n++)o=o.concat(ol.coordinate.sampleAt(e[n-1],e[n],t,1===n));i.push(o)})}),new ol.geom.MultiPolygon(o)},ol.geom.Circle.prototype.intersection=function(t,e){if(t.sampleAt){var o=ol.extent.buffer(this.getCenter().concat(this.getCenter()),this.getRadius());t=(t=ol.extent.intersection(o,t)).simplify(e);var i=this.getCenter(),n=this.getRadius(),r=t.sampleAt(e).getCoordinates();switch(t.getType()){case"Polygon":r=[r];case"MultiPolygon":var s=!1,a=[];return r.forEach(function(t){var e=[];a.push(e),t.forEach(function(t){var o=[];e.push(o),t.forEach(function(t){var e=ol.coordinate.dist2d(i,t);e>n?(s=!0,o.push([i[0]+n/e*(t[0]-i[0]),i[1]+n/e*(t[1]-i[1])])):o.push(t)})})}),s?"Polygon"===t.getType()?new ol.geom.Polygon(a[0]):new ol.geom.MultiPolygon(a):t}}else console.warn("[ol/geom/Circle~intersection] Unsupported geometry type: "+t.getType());return t},ol.geom.LineString.prototype.splitAt=function(t,e){var o;if(!t)return[this];if(e||(e=1e-10),t.length&&t[0].length){var i=[this];for(o=0;o<t.length;o++){for(var n=[],r=0;r<i.length;r++){var s=i[r].splitAt(t[o],e);n=n.concat(s)}i=n}return i}if(ol.coordinate.equal(t,this.getFirstCoordinate())||ol.coordinate.equal(t,this.getLastCoordinate()))return[this];var a=this.getCoordinates(),l=[a[0]],c=[];for(o=0;o<a.length-1;o++)if(!ol.coordinate.equal(a[o],a[o+1])){if(ol.coordinate.equal(t,a[o+1]))l.push(a[o+1]),c.push(new ol.geom.LineString(l)),l=[];else if(!ol.coordinate.equal(t,a[o])){var h,p,u=!1;a[o][0]==a[o+1][0]?(h=(a[o][1]-t[1])/(a[o][1]-a[o+1][1]),u=a[o][0]==t[0]&&0<h&&h<=1):a[o][1]==a[o+1][1]?(h=(a[o][0]-t[0])/(a[o][0]-a[o+1][0]),u=a[o][1]==t[1]&&0<h&&h<=1):(h=(a[o][0]-t[0])/(a[o][0]-a[o+1][0]),p=(a[o][1]-t[1])/(a[o][1]-a[o+1][1]),u=Math.abs(h-p)<=e&&0<h&&h<=1),u&&(l.push(t),c.push(new ol.geom.LineString(l)),l=[t])}l.push(a[o+1])}return l.length>1&&c.push(new ol.geom.LineString(l)),c.length?c:[this]},ol.geom.MultiPolygon.prototype.scribbleFill=function(t){var e,o,i,n=[],r=this.getPolygons();for(e=0;o=r[e];e++){var s=o.scribbleFill(t);s&&n.push(s)}if(!n.length)return null;var a,l=n[0];for(e=0;i=n[e];e++){a=i.getLineStrings();for(var c=0;c<a.length;c++)l.appendLineString(a[c])}return l},ol.geom.Polygon.prototype.scribbleFill=function(t){var e,o,i,n=t.interval,r=t.angle||Math.PI/2,s=this.clone();s.rotate(r,[0,0]);var a=s.getCoordinates(),l=a[0];for(e=1;e<a.length;e++)l.push([]),l=l.concat(a[e]);for(var c=s.getExtent(),h=[],p=(Math.floor(c[1]/n)+1)*n;p<c[3];p+=n)i=ol.coordinate.splitH(l,p,e),h=h.concat(i);if(!h.length)return null;var u=l.length-1,g=h[0][0].index;for(o=0;i=h[o];o++)h[o][0].index=(h[o][0].index-g+u)%u,h[o][1].index=(h[o][1].index-g+u)%u;for(var d=[];;){for(o=0;(i=h[o])&&i[0].done;o++);if(!i)break;for(var m=[];i;){i[0].done=!0,m.push(i[0].pt),m.push(i[1].pt);for(var f=i[0].pt[1]+n,y=1/0,v=null;h[o]&&!(h[o][0].pt[1]>f);){if(h[o][0].pt[1]===f){var _=Math.min((h[o][0].index-i[0].index+u)%u,(i[0].index-h[o][0].index+u)%u),x=Math.min((i[1].index-i[0].index+u)%u,(i[0].index-i[1].index+u)%u);_<y&&_<x&&(y=_,v=h[o][0].done?null:h[o])}o++}i=v}m.length&&d.push(m)}if(!d.length)return null;var b=new ol.geom.MultiLineString(d);return b.rotate(-r,[0,0]),b.cspline({pointsPerSeg:8,tension:.9})},ol.geohash={base32:"0123456789bcdefghjkmnpqrstuvwxyz"},ol.geohash.fromLonLat=function(t,e){var o=t[0],i=t[1];if(!e){for(var n=1;n<=12;n++){var r=ol.geohash.fromLonLat([o,i],n),s=ol.geohash.toLonLat(r);if(s.lat==i&&s.lon==o)return r}e=12}(e<1||e>12)&&(e=12);for(var a=0,l=0,c=!0,h="",p=-90,u=90,g=-180,d=180;h.length<e;){if(c){var m=(g+d)/2;o>=m?(a=2*a+1,g=m):(a*=2,d=m)}else{var f=(p+u)/2;i>=f?(a=2*a+1,p=f):(a*=2,u=f)}c=!c,5==++l&&(h+=ol.geohash.base32.charAt(a),l=0,a=0)}return h},ol.geohash.toLonLat=function(t){var e=ol.geohash.getExtent(t),o=e[1],i=e[0],n=e[3],r=e[2],s=(o+n)/2,a=(i+r)/2;return s=s.toFixed(Math.floor(2-Math.log(n-o)/Math.LN10)),a=a.toFixed(Math.floor(2-Math.log(r-i)/Math.LN10)),[Number(a),Number(s)]},ol.geohash.getExtent=function(t){if(!t)return!1;t=t.toLowerCase();for(var e=!0,o=-90,i=90,n=-180,r=180,s=0;s<t.length;s++){var a=t.charAt(s),l=ol.geohash.base32.indexOf(a);if(-1==l)return!1;for(var c=4;c>=0;c--){var h=l>>c&1;if(e){var p=(n+r)/2;1==h?n=p:r=p}else{var u=(o+i)/2;1==h?o=u:i=u}e=!e}}return[n,o,r,i]},ol.geohash.getAdjacent=function(t,e){if(t=t.toLowerCase(),e=e.toLowerCase(),!t)return!1;if(-1=="nsew".indexOf(e))return!1;var o=t.slice(-1),i=t.slice(0,-1),n=t.length%2;return-1!={n:["prxz","bcfguvyz"],s:["028b","0145hjnp"],e:["bcfguvyz","prxz"],w:["0145hjnp","028b"]}[e][n].indexOf(o)&&""!=i&&(i=ol.geohash.getAdjacent(i,e)),i+ol.geohash.base32.charAt({n:["p0r21436x8zb9dcf5h7kjnmqesgutwvy","bc01fg45238967deuvhjyznpkmstqrwx"],s:["14365h7k9dcfesgujnmqp0r2twvyx8zb","238967debc01fg45kmstqrwxuvhjyznp"],e:["bc01fg45238967deuvhjyznpkmstqrwx","p0r21436x8zb9dcf5h7kjnmqesgutwvy"],w:["238967debc01fg45kmstqrwxuvhjyznp","14365h7k9dcfesgujnmqp0r2twvyx8zb"]}[e][n].indexOf(o))},ol.geohash.getNeighbours=function(t){return{n:ol.geohash.getAdjacent(t,"n"),ne:ol.geohash.getAdjacent(ol.geohash.getAdjacent(t,"n"),"e"),e:ol.geohash.getAdjacent(t,"e"),se:ol.geohash.getAdjacent(ol.geohash.getAdjacent(t,"s"),"e"),s:ol.geohash.getAdjacent(t,"s"),sw:ol.geohash.getAdjacent(ol.geohash.getAdjacent(t,"s"),"w"),w:ol.geohash.getAdjacent(t,"w"),nw:ol.geohash.getAdjacent(ol.geohash.getAdjacent(t,"n"),"w")}},ol.sphere.greatCircleBearing=function(t,e){var o=Math.PI/180,i=[t[0]*o,t[1]*o],n=[e[0]*o,e[1]*o];return Math.atan2(Math.sin(n[0]-i[0])*Math.cos(n[1]),Math.cos(i[1])*Math.sin(n[1])-Math.sin(i[1])*Math.cos(n[1])*Math.cos(n[0]-i[0]))},ol.sphere.computeDestinationPoint=function(t,e,o,i){i=i||{};var n=Math.PI/180,r=i.radius||6371008.8,s=t[1]*n,a=t[0]*n,l=e/r,c=Math.asin(Math.sin(s)*Math.cos(l)+Math.cos(s)*Math.sin(l)*Math.cos(o)),h=(a+Math.atan2(Math.sin(o)*Math.sin(l)*Math.cos(s),Math.cos(l)-Math.sin(s)*Math.sin(c)))/n;return!1!==i.normalize&&(h<-180||h>180)&&(h=540*h%360-180),[h,c/n]},ol.sphere.greatCircleTrack=function(t,e,o){o=o||{};for(var i=ol.sphere.greatCircleBearing(t,e),n=ol.sphere.getDistance(t,e,o.radius),r=o.distance||1e3,s=r,a=[t];s<n;)a.push(ol.sphere.computeDestinationPoint(t,s,i,{radius:o.radius,normalize:!1})),s+=r;var l=ol.sphere.computeDestinationPoint(t,n,i,{radius:o.radius,normalize:!1});return Math.abs(l[0]-e[0])>1&&(l[0]>e[0]?e[0]+=360:e[0]-=360),a.push(e),a},ol.sphere.getMapScale=function(t,e){var o=t.getView(),i=o.getProjection(),n=o.getCenter(),r=t.getPixelFromCoordinate(n);r[1]+=1;var s=t.getCoordinateFromPixel(r),a=ol.sphere.getDistance(ol.proj.transform(n,i,"EPSG:4326"),ol.proj.transform(s,i,"EPSG:4326"));return a*=(e||96)/.0254},ol.sphere.setMapScale=function(t,e,o){if(t&&e){var i=e;if("string"==typeof e&&((i=e.split("/")[1])||(i=e),i=i.replace(/[^\d]/g,""),i=parseInt(i)),!i)return;var n=t.getView(),r=n.getProjection(),s=n.getCenter(),a=t.getPixelFromCoordinate(s);a[1]+=1;var l=t.getCoordinateFromPixel(a),c=ol.sphere.getDistance(ol.proj.transform(s,r,"EPSG:4326"),ol.proj.transform(l,r,"EPSG:4326"));return c*=(o||96)/.0254,n.setResolution(n.getResolution()*i/c),i}},ol.Map.prototype.animExtent=function(t,e){var o;(e=e||{}).projection&&(t=ol.proj.transformExtent(t,e.projection,this.getView().getProjection()));var i=(new Date).getTime(),n=e.duration||1e3,r=e.easing||ol.easing.upAndDown,s=e.style&&e.style.getWidth()||2,a=e.style&&e.style.getColr()||"red";o=this.on("postcompose",function(e){var l=e.frameState,c=l.pixelRatio,h=l.time-i;if(h>n)ol.Observable.unByKey(o);else{var p=h/n,u=this.getPixelFromCoordinate([t[0],t[1]]),g=this.getPixelFromCoordinate([t[2],t[3]]),d=e.context;d.save(),d.scale(c,c),d.beginPath(),d.globalAlpha=r(1-p),d.lineWidth=s,d.strokeStyle=a,d.rect(u[0],u[1],g[0]-u[0],g[1]-u[1]),d.stroke(),d.restore(),l.animate=!0}}.bind(this));try{this.renderSync()}catch(t){}},ol.geom.Geometry.prototype.cspline=function(t){return this.calcCSpline_?(this.csplineGeometryRevision==this.getRevision()&&this.csplineOption==JSON.stringify(t)||(this.csplineGeometry_=this.calcCSpline_(t),this.csplineGeometryRevision=this.getRevision(),this.csplineOption=JSON.stringify(t)),this.csplineGeometry_):this},ol.geom.GeometryCollection.prototype.calcCSpline_=function(t){for(var e=[],o=this.getGeometries(),i=0;i<o.length;i++)e.push(o[i].cspline(t));return new ol.geom.GeometryCollection(e)},ol.geom.MultiLineString.prototype.calcCSpline_=function(t){for(var e=[],o=this.getLineStrings(),i=0;i<o.length;i++)e.push(o[i].cspline(t).getCoordinates());return new ol.geom.MultiLineString(e)},ol.geom.Polygon.prototype.calcCSpline_=function(t){for(var e=[],o=this.getCoordinates(),i=0;i<o.length;i++)e.push(new ol.geom.LineString(o[i]).cspline(t).getCoordinates());return new ol.geom.Polygon(e)},ol.geom.MultiPolygon.prototype.calcCSpline_=function(t){for(var e=[],o=this.getPolygons(),i=0;i<o.length;i++)e.push(o[i].cspline(t).getCoordinates());return new ol.geom.MultiPolygon(e)},ol.coordinate.cspline=function(t,e){e||(e={});var o="number"==typeof e.tension?e.tension:.5,i=0,n=t[0];t.forEach(function(t){i+=ol.coordinate.dist2d(n,t),n=t});var r,s,a,l,c,h,p,u,g,d,m,f,y,v,_=e.resolution||i/t.length/(e.pointsPerSeg||10),x=[];function b(t,e,o,i){var n=o-t,r=i-e;return Math.sqrt(n*n+r*r)}for(r=t.slice(0),t.length>2&&t[0][0]==t[t.length-1][0]&&t[0][1]==t[t.length-1][1]?(r.unshift(t[t.length-2]),r.push(t[1])):(r.unshift(t[0]),r.push(t[t.length-1])),v=1;v<r.length-2;v++){var w=b(r[v][0],r[v][1],r[v+1][0],r[v+1][1]),S=Math.round(w/_),C=1;if(e.normalize){w=b(r[v+1][0],r[v+1][1],r[v-1][0],r[v-1][1]);var M=b(r[v+2][0],r[v+2][1],r[v][0],r[v][1]);C=w<M?w/M:M/w}for(l=(r[v+1][0]-r[v-1][0])*o*C,c=(r[v+2][0]-r[v][0])*o*C,h=(r[v+1][1]-r[v-1][1])*o*C,p=(r[v+2][1]-r[v][1])*o*C,y=0;y<=S;y++)f=y/S,u=2*Math.pow(f,3)-3*Math.pow(f,2)+1,g=-2*Math.pow(f,3)+3*Math.pow(f,2),d=Math.pow(f,3)-2*Math.pow(f,2)+f,m=Math.pow(f,3)-Math.pow(f,2),s=u*r[v][0]+g*r[v+1][0]+d*l+m*c,a=u*r[v][1]+g*r[v+1][1]+d*h+m*p,s&&a&&x.push([s,a])}return x},ol.geom.LineString.prototype.calcCSpline_=function(t){var e=this.getCoordinates(),o=ol.coordinate.cspline(e,t);return new ol.geom.LineString(o)},ol.HexGrid=function(t){t=t||{},ol.Object.call(this,t),this.size_=t.size||8e4,this.origin_=t.origin||[0,0],this.layout_=this.layout[t.layout]||this.layout.pointy},ol.ext.inherits(ol.HexGrid,ol.Object),ol.HexGrid.prototype.layout={pointy:[Math.sqrt(3),Math.sqrt(3)/2,0,1.5,Math.sqrt(3)/3,-1/3,0,2/3,Math.cos(Math.PI/180*30),Math.sin(Math.PI/180*30),Math.cos(Math.PI/180*90),Math.sin(Math.PI/180*90),Math.cos(Math.PI/180*150),Math.sin(Math.PI/180*150),Math.cos(Math.PI/180*210),Math.sin(Math.PI/180*210),Math.cos(Math.PI/180*270),Math.sin(Math.PI/180*270),Math.cos(Math.PI/180*330),Math.sin(Math.PI/180*330)],flat:[1.5,0,Math.sqrt(3)/2,Math.sqrt(3),2/3,0,-1/3,Math.sqrt(3)/3,Math.cos(Math.PI/180*0),Math.sin(Math.PI/180*0),Math.cos(Math.PI/180*60),Math.sin(Math.PI/180*60),Math.cos(Math.PI/180*120),Math.sin(Math.PI/180*120),Math.cos(Math.PI/180*180),Math.sin(Math.PI/180*180),Math.cos(Math.PI/180*240),Math.sin(Math.PI/180*240),Math.cos(Math.PI/180*300),Math.sin(Math.PI/180*300)]},ol.HexGrid.prototype.setLayout=function(t){this.layout_=this.layout[t]||this.layout.pointy,this.changed()},ol.HexGrid.prototype.getLayout=function(){return 0!=this.layout_[9]?"pointy":"flat"},ol.HexGrid.prototype.setOrigin=function(t){this.origin_=t,this.changed()},ol.HexGrid.prototype.getOrigin=function(){return this.origin_},ol.HexGrid.prototype.setSize=function(t){this.size_=t||8e4,this.changed()},ol.HexGrid.prototype.getSize=function(){return this.size_},ol.HexGrid.prototype.cube2hex=function(t){return[t[0],t[2]]},ol.HexGrid.prototype.hex2cube=function(t){return[t[0],-t[0]-t[1],t[1]]},ol.HexGrid.prototype.hex2offset=function(t){return this.layout_[9]?[t[0]+(t[1]-(1&t[1]))/2,t[1]]:[t[0],t[1]+(t[0]+(1&t[0]))/2]},ol.HexGrid.prototype.offset2hex=function(t){return this.layout_[9]?[t[0]-(t[1]-(1&t[1]))/2,t[1]]:[t[0],t[1]-(t[0]+(1&t[0]))/2]},ol.HexGrid.prototype.cube_round=function(t){var e=Math.round(t[0]),o=Math.round(t[1]),i=Math.round(t[2]),n=Math.abs(e-t[0]),r=Math.abs(o-t[1]),s=Math.abs(i-t[2]);return n>r&&n>s?e=-o-i:r>s?o=-e-i:i=-e-o,[e,o,i]},ol.HexGrid.prototype.hex_round=function(t){return this.cube2hex(this.cube_round(this.hex2cube(t)))},ol.HexGrid.prototype.hex_corner=function(t,e,o){return[t[0]+e*this.layout_[8+o%6*2],t[1]+e*this.layout_[9+o%6*2]]},ol.HexGrid.prototype.getHexagonAtCoord=function(t){return this.getHexagon(this.coord2hex(t))},ol.HexGrid.prototype.getHexagon=function(t){for(var e=[],o=this.hex2coord(t),i=0;i<=7;i++)e.push(this.hex_corner(o,this.size_,i,this.layout_[8]));return e},ol.HexGrid.prototype.hex2coord=function(t){return[this.origin_[0]+this.size_*(this.layout_[0]*t[0]+this.layout_[1]*t[1]),this.origin_[1]+this.size_*(this.layout_[2]*t[0]+this.layout_[3]*t[1])]},ol.HexGrid.prototype.coord2hex=function(t){var e=[(t[0]-this.origin_[0])/this.size_,(t[1]-this.origin_[1])/this.size_],o=this.layout_[4]*e[0]+this.layout_[5]*e[1],i=this.layout_[6]*e[0]+this.layout_[7]*e[1];return this.hex_round([o,i])},ol.HexGrid.prototype.cube_distance=function(t,e){return Math.max(Math.abs(t[0]-e[0]),Math.abs(t[1]-e[1]),Math.abs(t[2]-e[2]))},function(){function t(t,e,o){return t+(e-t)*o}function e(e,o,i){return[t(e[0]+1e-6,o[0],i),t(e[1]+1e-6,o[1],i),t(e[2]+1e-6,o[2],i)]}ol.HexGrid.prototype.cube_line=function(t,o){var i=this.cube_distance(t,o);if(!i)return[t];for(var n=[],r=0;r<=i;r++)n.push(this.cube_round(e(t,o,r/i)));return n}}(),ol.HexGrid.prototype.neighbors={cube:[[1,-1,0],[1,0,-1],[0,1,-1],[-1,1,0],[-1,0,1],[0,-1,1]],hex:[[1,0],[1,-1],[0,-1],[-1,0],[-1,1],[0,1]]},ol.HexGrid.prototype.hex_neighbors=function(t,e){if(void 0!==e)return[t[0]+this.neighbors.hex[e%6][0],t[1]+this.neighbors.hex[e%6][1]];var o=[];for(e=0;e<6;e++)o.push([t[0]+this.neighbors.hex[e][0],t[1]+this.neighbors.hex[e][1]]);return o},ol.HexGrid.prototype.cube_neighbors=function(t,e){if(void 0!==e)return[t[0]+this.neighbors.cube[e%6][0],t[1]+this.neighbors.cube[e%6][1],t[2]+this.neighbors.cube[e%6][2]];var o=[];for(e=0;e<6;e++)o.push([t[0]+this.neighbors.cube[e][0],t[1]+this.neighbors.cube[e][1],t[2]+this.neighbors.cube[e][2]]);for(e=0;e<6;e++)o[e]=this.cube2hex(o[e]);return o},ol.InseeGrid=function(t){t=t||{},proj4.defs["EPSG:3035"]||(proj4.defs("EPSG:3035","+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000 +ellps=GRS80 +units=m +no_defs"),ol.proj.proj4.register(proj4)),ol.Object.call(this,t);var e=Math.max(200,200*Math.round((t.size||0)/200));this.set("size",e)},ol.ext.inherits(ol.InseeGrid,ol.Object),ol.InseeGrid.extent=[32e5,2e6,43e5,314e4],ol.InseeGrid.prototype.getExtent=function(t){return ol.proj.transformExtent(ol.InseeGrid.extent,t||"EPSG:3035","EPSG:3857")},ol.InseeGrid.prototype.getGridAtCoordinate=function(t,e){var o=ol.proj.transform(t,e||"EPSG:3857","EPSG:3035"),i=this.get("size"),n=Math.floor(o[0]/i)*i,r=Math.floor(o[1]/i)*i,s=new ol.geom.Polygon([[[n,r],[n+i,r],[n+i,r+i],[n,r+i],[n,r]]]);return s.transform("EPSG:3035",e||"EPSG:3857"),s},ol.Map.prototype.markup=function(t,e){var o,i=this;(e=e||{}).projection&&(t=ol.proj.transform(t,e.projection,this.getView().getProjection()));var n=(new Date).getTime(),r=e.delay||3e3,s=1e3,a=e.maxZoom||100,l=ol.easing.easeOut,c=e.style;c||(c=new ol.style.Circle({radius:10,stroke:new ol.style.Stroke({color:"red",width:2})})),c instanceof ol.style.Image&&(c=new ol.style.Style({image:c})),c instanceof Array||(c=[c]),setTimeout(function(){if(o)try{i.renderSync()}catch(t){}},r),o=this.on("postcompose",function(e){var i=e.frameState,h=i.time-n;if(h>r+s)ol.Observable.unByKey(o),o=null;else{r>h&&this.getView().getZoom()>a&&(r=h);var p=i.pixelRatio,u=0;h>r&&(u=(h-r)/s);var g=e.context;g.save(),g.beginPath(),g.globalAlpha=l(1-u);for(var d=0;d<c.length;d++){var m=c[d].getImage(),f=m.getScale();m.setScale(f*p),e.vectorContext.setStyle(c[d]),e.vectorContext.drawGeometry(new ol.geom.Point(t)),m.setScale(f)}g.restore(),h>=r&&(i.animate=!0)}}.bind(this));try{this.renderSync()}catch(t){}return o.stop=function(){r=s=0;try{this.target.renderSync()}catch(t){}},o},ol.ordering={},ol.ordering.yOrdering=function(){return function(t,e){return e.getGeometry().getExtent()[1]-t.getGeometry().getExtent()[1]}},ol.ordering.zIndex=function(t){t||(t={});var e=t.attribute||"zIndex";return t.equalFn?function(o,i){return o.get(e)==i.get(e)?t.equalFn(o,i):o.get(e)<i.get(e)?1:-1}:function(t,o){return t.get(e)==o.get(e)?0:t.get(e)<o.get(e)?1:-1}},ol.Map.prototype.pulse=function(t,e){var o;(e=e||{}).projection&&(t=ol.proj.transform(t,e.projection,this.getView().getProjection()));var i=(new Date).getTime(),n=e.duration||3e3,r=e.easing||ol.easing.easeOut,s=e.style;s||(s=new ol.style.Circle({radius:30,stroke:new ol.style.Stroke({color:"red",width:2})})),s instanceof ol.style.Image&&(s=new ol.style.Style({image:s})),s instanceof Array||(s=[s]);var a=e.amplitude||1;a<0&&(a=0);var l=e.radius||15;l<0&&(l=5),o=this.on("postcompose",function(e){var l=e.frameState,c=l.pixelRatio,h=l.time-i;if(h>n)ol.Observable.unByKey(o);else{var p=h/n,u=e.context;u.save(),u.beginPath();var g=r(p);u.globalAlpha=r(1-p),console.log("anim");for(var d=0;d<s.length;d++){var m=s[d].getImage(),f=m.getScale();m.setScale(c*f*(1+a*(g-1))),e.vectorContext.setStyle(s[d]),e.vectorContext.drawGeometry(new ol.geom.Point(t)),m.setScale(f)}u.restore(),l.animate=!0}}.bind(this));try{this.renderSync()}catch(t){}},ol.style.Chart=function(t){var e=t||{},o=0;t.stroke&&(o=t.stroke.getWidth()),ol.style.RegularShape.call(this,{radius:e.radius+o,fill:new ol.style.Fill({color:[0,0,0]}),rotation:e.rotation,displacement:e.displacement,snapToPixel:e.snapToPixel}),e.scale&&this.setScale(e.scale),this._stroke=e.stroke,this._radius=e.radius||20,this._donutratio=e.donutRatio||.5,this._type=e.type,this._offset=[e.offsetX?e.offsetX:0,e.offsetY?e.offsetY:0],this._animation="number"==typeof e.animation?{animate:!0,step:e.animation}:this._animation={animate:!1,step:1},this._max=e.max,this._data=e.data,e.colors instanceof Array?this._colors=e.colors:(this._colors=ol.style.Chart.colors[e.colors],this._colors||(this._colors=ol.style.Chart.colors.classic)),this.renderChart_()},ol.ext.inherits(ol.style.Chart,ol.style.RegularShape),ol.style.Chart.colors={classic:["#ffa500","blue","red","green","cyan","magenta","yellow","#0f0"],dark:["#960","#003","#900","#060","#099","#909","#990","#090"],pale:["#fd0","#369","#f64","#3b7","#880","#b5d","#666"],pastel:["#fb4","#79c","#f66","#7d7","#acc","#fdd","#ff9","#b9b"],neon:["#ff0","#0ff","#0f0","#f0f","#f00","#00f"]},ol.style.Chart.prototype.clone=function(){var t=new ol.style.Chart({type:this._type,radius:this._radius,rotation:this.getRotation(),scale:this.getScale(),data:this.getData(),snapToPixel:!!this.getSnapToPixel&&this.getSnapToPixel(),stroke:this._stroke,colors:this._colors,offsetX:this._offset[0],offsetY:this._offset[1],animation:this._animation});return t.setScale(this.getScale()),t.setOpacity(this.getOpacity()),t},ol.style.Chart.prototype.getData=function(){return this._data},ol.style.Chart.prototype.setData=function(t){this._data=t,this.renderChart_()},ol.style.Chart.prototype.getRadius=function(){return this._radius},ol.style.Chart.prototype.setRadius=function(t,e){this._radius=t,this.donuratio_=e||this.donuratio_,this.renderChart_()},ol.style.Chart.prototype.setAnimation=function(t){if(!1===t){if(0==this._animation.animate)return;this._animation.animate=!1}else{if(this._animation.step==t)return;this._animation.animate=!0,this._animation.step=t}this.renderChart_()},ol.style.Chart.prototype.renderChart_=function(t){if(t){var e,o=0;this._stroke&&(e=ol.color.asString(this._stroke.getColor()),o=this._stroke.getWidth());var i=this.getImage(t),n=i.getContext("2d");n.save(),n.setTransform(t,0,0,t,0,0),n.clearRect(0,0,i.width,i.height),n.lineJoin="round";var r,s,a=0;for(r=0;r<this._data.length;r++)a+=this._data[r];n.translate(0,0);var l=this._animation.animate?this._animation.step:1;switch(this._type){case"donut":case"pie3D":case"pie":var c,h=Math.PI*(l-1.5);for(s=i.width/2/t,n.strokeStyle=e,n.lineWidth=o,n.save(),"pie3D"==this._type&&(n.translate(0,.3*s),n.scale(1,.7),n.beginPath(),n.fillStyle="#369",n.arc(s,1.4*s,this._radius*l,0,2*Math.PI),n.fill(),n.stroke()),"donut"==this._type&&(n.save(),n.beginPath(),n.rect(0,0,2*s,2*s),n.arc(s,s,this._radius*l*this._donutratio,0,2*Math.PI),n.clip("evenodd")),r=0;r<this._data.length;r++)n.beginPath(),n.moveTo(s,s),n.fillStyle=this._colors[r%this._colors.length],c=h+2*Math.PI*this._data[r]/a*l,n.arc(s,s,this._radius*l,h,c),n.closePath(),n.fill(),n.stroke(),h=c;"donut"==this._type&&(n.restore(),n.beginPath(),n.strokeStyle=e,n.lineWidth=o,n.arc(s,s,this._radius*l*this._donutratio,Math.PI*(l-1.5),h),n.stroke()),n.restore();break;case"bar":default:var p=0;if(this._max)p=this._max;else for(r=0;r<this._data.length;r++)p<this._data[r]&&(p=this._data[r]);var u=Math.min(5,2*this._radius/this._data.length);s=i.width/2/t;var g,d=i.width/t-o,m=s-this._data.length*u/2;for(n.strokeStyle=e,n.lineWidth=o,r=0;r<this._data.length;r++){n.beginPath(),n.fillStyle=this._colors[r%this._colors.length],g=m+u;var f=this._data[r]/p*2*this._radius*l;n.rect(m,d-f,u,f),n.closePath(),n.fill(),n.stroke(),m=g}}if(n.restore(),!this.setDisplacement){var y=this.getAnchor();y[0]=s-this._offset[0],y[1]=s-this._offset[1]}}else this.getPixelRatio?(t=window.devicePixelRatio,this.renderChart_(t),this.getPixelRatio&&1!==t&&this.renderChart_(1)):this.renderChart_(1)},ol.style.FillPattern=function(t){var e;t||(t={});var o=this.canvas_=document.createElement("canvas"),i=(Number(t.scale)>0?Number(t.scale):1)*ol.has.DEVICE_PIXEL_RATIO||ol.has.DEVICE_PIXEL_RATIO,n=o.getContext("2d");if(t.image){var r;t.image.load();var s=t.image.getImage();if(s.width)o.width=Math.round(s.width*i),o.height=Math.round(s.height*i),n.globalAlpha="number"==typeof t.opacity?t.opacity:1,n.drawImage(s,0,0,s.width,s.height,0,0,o.width,o.height),e=n.createPattern(o,"repeat");else{var a=this;e=[0,0,0,0],s.onload=function(){o.width=Math.round(s.width*i),o.height=Math.round(s.height*i),n.globalAlpha="number"==typeof t.opacity?t.opacity:1,n.drawImage(s,0,0,s.width,s.height,0,0,o.width,o.height),e=n.createPattern(o,"repeat"),a.setColor(e)}}}else{var l=this.getPattern_(t);if(o.width=Math.round(l.width*i),o.height=Math.round(l.height*i),n.beginPath(),t.fill&&(n.fillStyle=ol.color.asString(t.fill.getColor()),n.fillRect(0,0,o.width,o.height)),n.scale(i,i),n.lineCap="round",n.lineWidth=l.stroke||1,n.fillStyle=ol.color.asString(t.color||"#000"),n.strokeStyle=ol.color.asString(t.color||"#000"),l.circles)for(r=0;r<l.circles.length;r++){var c=l.circles[r];n.beginPath(),n.arc(c[0],c[1],c[2],0,2*Math.PI),l.fill&&n.fill(),l.stroke&&n.stroke()}if(l.repeat||(l.repeat=[[0,0]]),l.char&&(n.font=l.font||l.width+"px Arial",n.textAlign="center",n.textBaseline="middle",l.angle?(n.fillText(l.char,l.width/4,l.height/4),n.fillText(l.char,5*l.width/4,5*l.height/4),n.fillText(l.char,l.width/4,5*l.height/4),n.fillText(l.char,5*l.width/4,l.height/4),n.fillText(l.char,3*l.width/4,3*l.height/4),n.fillText(l.char,-l.width/4,-l.height/4),n.fillText(l.char,3*l.width/4,-l.height/4),n.fillText(l.char,-l.width/4,3*l.height/4)):n.fillText(l.char,l.width/2,l.height/2)),l.lines)for(r=0;r<l.lines.length;r++)for(var h=0;h<l.repeat.length;h++){var p=l.lines[r];n.beginPath(),n.moveTo(p[0]+l.repeat[h][0],p[1]+l.repeat[h][1]);for(var u=2;u<p.length;u+=2)n.lineTo(p[u]+l.repeat[h][0],p[u+1]+l.repeat[h][1]);l.fill&&n.fill(),l.stroke&&n.stroke(),n.save(),n.strokeStyle="red",n.strokeWidth=.1,n.restore()}if(e=n.createPattern(o,"repeat"),t.offset){var g=t.offset;if("number"==typeof g&&(g=[g,g]),g instanceof Array){var d=Math.round(g[0]*i),m=Math.round(g[1]*i);n.scale(1/i,1/i),n.clearRect(0,0,o.width,o.height),n.translate(d,m),n.fillStyle=e,n.fillRect(-d,-m,o.width,o.height),e=n.createPattern(o,"repeat")}}}ol.style.Fill.call(this,{color:e})},ol.ext.inherits(ol.style.FillPattern,ol.style.Fill),ol.style.FillPattern.prototype.clone=function(){var t=ol.style.Fill.prototype.clone.call(this);return t.canvas_=this.canvas_,t},ol.style.FillPattern.prototype.getImage=function(){return this.canvas_},ol.style.FillPattern.prototype.getPattern_=function(t){var e,o=ol.style.FillPattern.prototype.patterns[t.pattern]||ol.style.FillPattern.prototype.patterns.dot,i=Math.round(t.spacing)||10;switch(t.pattern){case"dot":case"circle":e=0===t.size?0:t.size/2||2,t.angle?(i=o.width=o.height=Math.round(1.4*i),o.circles=[[i/4,i/4,e],[3*i/4,3*i/4,e]],"circle"==t.pattern&&(o.circles=o.circles.concat([[i/4+i,i/4,e],[i/4,i/4+i,e],[3*i/4-i,3*i/4,e],[3*i/4,3*i/4-i,e],[i/4+i,i/4+i,e],[3*i/4-i,3*i/4-i,e]]))):(o.width=o.height=i,o.circles=[[i/2,i/2,e]],"circle"==t.pattern&&(o.circles=o.circles.concat([[i/2+i,i/2,e],[i/2-i,i/2,e],[i/2,i/2+i,e],[i/2,i/2-i,e],[i/2+i,i/2+i,e],[i/2+i,i/2-i,e],[i/2-i,i/2+i,e],[i/2-i,i/2-i,e]])));break;case"tile":case"square":e=0===t.size?0:t.size/2||2,t.angle?(o.width=o.height=i,o.lines=[[i/2-e,i/2,i/2,i/2-e,i/2+e,i/2,i/2,i/2+e,i/2-e,i/2]]):(o.width=o.height=i,o.lines=[[i/2-e,i/2-e,i/2+e,i/2-e,i/2+e,i/2+e,i/2-e,i/2+e,i/2-e,i/2-e]]),"square"==t.pattern&&(o.repeat=[[0,0],[0,i],[i,0],[0,-i],[-i,0],[-i,-i],[i,i],[-i,i],[i,-i]]);break;case"cross":t.angle&&(t.angle=45);case"hatch":var n=Math.round(((t.angle||0)-90)%360);n>180&&(n-=360),n*=Math.PI/180;var r=Math.cos(n),s=Math.sin(n);if(Math.abs(s)<1e-4)o.width=o.height=i,o.lines=[[0,.5,i,.5]],o.repeat=[[0,0],[0,i]];else if(Math.abs(r)<1e-4)o.width=o.height=i,o.lines=[[.5,0,.5,i]],o.repeat=[[0,0],[i,0]],"cross"==t.pattern&&(o.lines.push([0,.5,i,.5]),o.repeat.push([0,i]));else{var a=o.width=Math.round(Math.abs(i/s))||1,l=o.height=Math.round(Math.abs(i/r))||1;"cross"==t.pattern?(o.lines=[[-a,-l,2*a,2*l],[2*a,-l,-a,2*l]],o.repeat=[[0,0]]):r*s>0?(o.lines=[[-a,-l,2*a,2*l]],o.repeat=[[0,0],[a,0],[0,l]]):(o.lines=[[2*a,-l,-a,2*l]],o.repeat=[[0,0],[-a,0],[0,l]])}o.stroke=0===t.size?0:t.size||4}return o},ol.style.FillPattern.addPattern=function(t,e){e||(e={}),ol.style.FillPattern.prototype.patterns[t||e.char]={width:e.width||e.size||10,height:e.height||e.size||10,font:e.font,char:e.char,circles:e.circles,lines:e.lines,repeat:e.repeat,stroke:e.stroke,angle:e.angle,fill:e.fill}},ol.style.FillPattern.prototype.patterns={hatch:{width:5,height:5,lines:[[0,2.5,5,2.5]],stroke:1},cross:{width:7,height:7,lines:[[0,3,10,3],[3,0,3,10]],stroke:1},dot:{width:8,height:8,circles:[[5,5,2]],stroke:!1,fill:!0},circle:{width:10,height:10,circles:[[5,5,2]],stroke:1,fill:!1},square:{width:10,height:10,lines:[[3,3,3,8,8,8,8,3,3,3]],stroke:1,fill:!1},tile:{width:10,height:10,lines:[[3,3,3,8,8,8,8,3,3,3]],fill:!0},woven:{width:12,height:12,lines:[[3,3,9,9],[0,12,3,9],[9,3,12,0],[-1,1,1,-1],[13,11,11,13]],stroke:1},crosses:{width:8,height:8,lines:[[2,2,6,6],[2,6,6,2]],stroke:1},caps:{width:8,height:8,lines:[[2,6,4,2,6,6]],stroke:1},nylon:{width:20,height:20,lines:[[1,6,1,1,6,1],[6,11,11,11,11,6],[11,16,11,21,16,21],[16,11,21,11,21,16]],repeat:[[0,0],[-20,0],[0,-20]],stroke:1},hexagon:{width:20,height:12,lines:[[0,10,4,4,10,4,14,10,10,16,4,16,0,10]],stroke:1,repeat:[[0,0],[10,6],[10,-6],[-10,-6]]},cemetry:{width:15,height:19,lines:[[0,3.5,7,3.5],[3.5,0,3.5,10]],stroke:1,repeat:[[0,0],[7,9]]},sand:{width:20,height:20,circles:[[1,2,1],[9,3,1],[2,16,1],[7,8,1],[6,14,1],[4,19,1],[14,2,1],[12,10,1],[14,18,1],[18,8,1],[18,14,1]],fill:1},conglomerate:{width:60,height:40,circles:[[2,4,1],[17,3,1],[26,18,1],[12,17,1],[5,17,2],[28,11,2]],lines:[[7,5,6,7,9,9,11,8,11,6,9,5,7,5],[16,10,15,13,16,14,19,15,21,13,22,9,20,8,19,8,16,10],[24,6,26,7,27,5,26,4,24,4,24,6]],repeat:[[30,0],[-15,20],[15,20],[45,20]],stroke:1},conglomerate2:{width:60,height:40,circles:[[2,4,1],[17,3,1],[26,18,1],[12,17,1],[5,17,2],[28,11,2]],lines:[[7,5,6,7,9,9,11,8,11,6,9,5,7,5],[16,10,15,13,16,14,19,15,21,13,22,9,20,8,19,8,16,10],[24,6,26,7,27,5,26,4,24,4,24,6]],repeat:[[30,0],[-15,20],[15,20],[45,20]],fill:1},gravel:{width:15,height:10,circles:[[4,2,1],[5,9,1],[1,7,1]],lines:[[7,5,6,6,7,7,8,7,9,7,10,5,9,4,7,5],[11,2,14,4,14,1,12,1,11,2]],stroke:1},brick:{width:18,height:16,lines:[[0,1,18,1],[0,10,18,10],[6,1,6,10],[12,10,12,18],[12,0,12,1]],stroke:1},dolomite:{width:20,height:16,lines:[[0,1,20,1],[0,9,20,9],[1,9,6,1],[11,9,14,16],[14,0,14.4,1]],stroke:1},coal:{width:20,height:16,lines:[[1,5,7,1,7,7],[11,10,12,5,18,9],[5,10,2,15,9,15],[15,16,15,13,20,16],[15,0,15,2,20,0]],fill:1},breccia:{width:20,height:16,lines:[[1,5,7,1,7,7,1,5],[11,10,12,5,18,9,11,10],[5,10,2,15,9,15,5,10],[15,16,15,13,22,18],[15,0,15,2,20,0]],stroke:1},clay:{width:20,height:20,lines:[[0,0,3,11,0,20],[11,0,10,3,13,13,11,20],[0,0,10,3,20,0],[0,12,3,11,13,13,20,12]],stroke:1},flooded:{width:15,height:10,lines:[[0,1,10,1],[0,6,5,6],[10,6,15,6]],stroke:1},chaos:{width:40,height:40,lines:[[40,2,40,0,38,0,40,2],[4,0,3,2,2,5,0,0,0,3,2,7,5,6,7,7,8,10,9,12,9,13,9,14,8,14,6,15,2,15,0,20,0,22,2,20,5,19,8,15,10,14,11,12.25,10,12,10,10,12,9,13,7,12,6,13,4,16,7,17,4,20,0,18,0,15,3,14,2,14,0,12,1,11,0,10,1,11,4,10,7,9,8,8,5,6,4,5,3,5,1,5,0,4,0],[7,1,7,3,8,3,8,2,7,1],[4,3,5,5,4,5,4,3],[34,5,33,7,38,10,38,8,36,5,34,5],[27,0,23,2,21,8,30,0,27,0],[25,8,26,12,26,16,22.71875,15.375,20,13,18,15,17,18,13,22,17,21,19,22,21,20,19,18,22,17,30,25,26,26,24,28,21.75,33.34375,20,36,18,40,20,40,24,37,25,32,27,31,26,38,27,37,30,32,32,35,36,37,38,40,38,39,40,40,37,36,34,32,37,31,36,29,33,27,34,24,39,21,40,21,40,16,37,20,31,22,32,25,27,20,29,15,30,20,32,20,34,18,33,12,31,11,29,14,26,9,25,8],[39,24,37,26,40,28,39,24],[13,15,9,19,14,18,13,15],[18,23,14,27,16,27,17,25,20,26,18,23],[6,24,2,26,1,28,2,30,5,28,12,30,16,32,18,30,15,30,12,28,9,25,7,27,6,24],[29,27,32,28,33,31,30,29,27,28,29,27],[5,35,1,33,3,36,13,38,15,35,10,36,5,35]],fill:1},grass:{width:27,height:22,lines:[[0,10.5,13,10.5],[2.5,10,1.5,7],[4.5,10,4.5,5,3.5,4],[7,10,7.5,6,8.5,3],[10,10,11,6]],repeat:[[0,0],[14,10]],stroke:1},swamp:{width:24,height:23,lines:[[0,10.5,9.5,10.5],[2.5,10,2.5,7],[4.5,10,4.5,4],[6.5,10,6.5,6],[3,12.5,7,12.5]],repeat:[[0,0],[14,10]],stroke:1},reed:{width:26,height:23,lines:[[2.5,10,2,7],[4.5,10,4.2,4],[6.5,10,6.8,4],[8.5,10,9,6],[3.7,4,3.7,2.5],[4.7,4,4.7,2.5],[6.3,4,6.3,2.5],[7.3,4,7.3,2.5]],circles:[[4.2,2.5,.5],[18.2,12.5,.5],[6.8,2.5,.5],[20.8,12.5,.5],[9,6,.5],[23,16,.5]],repeat:[[0,0],[14,10]],stroke:1},wave:{width:10,height:8,lines:[[0,0,5,4,10,0]],stroke:1},vine:{width:13,height:13,lines:[[3,0,3,6],[9,7,9,13]],stroke:1},forest:{width:55,height:30,circles:[[7,7,3.5],[20,20,1.5],[42,22,3.5],[35,5,1.5]],stroke:1},forest2:{width:55,height:30,circles:[[7,7,3.5],[20,20,1.5],[42,22,3.5],[35,5,1.5]],fill:1,stroke:1},scrub:{width:26,height:20,lines:[[1,4,4,8,6,4]],circles:[[20,13,1.5]],stroke:1},tree:{width:30,height:30,lines:[[7.78,10.61,4.95,10.61,4.95,7.78,3.54,7.78,2.12,6.36,.71,6.36,0,4.24,.71,2.12,4.24,0,7.78,.71,9.19,3.54,7.78,4.95,7.07,7.07,4.95,7.78]],repeat:[[3,1],[18,16]],stroke:1},tree2:{width:30,height:30,lines:[[7.78,10.61,4.95,10.61,4.95,7.78,3.54,7.78,2.12,6.36,.71,6.36,0,4.24,.71,2.12,4.24,0,7.78,.71,9.19,3.54,7.78,4.95,7.07,7.07,4.95,7.78,4.95,10.61,7.78,10.61]],repeat:[[3,1],[18,16]],fill:1,stroke:1},pine:{width:30,height:30,lines:[[5.66,11.31,2.83,11.31,2.83,8.49,0,8.49,2.83,0,5.66,8.49,2.83,8.49]],repeat:[[3,1],[18,16]],stroke:1},pine2:{width:30,height:30,lines:[[5.66,11.31,2.83,11.31,2.83,8.49,0,8.49,2.83,0,5.66,8.49,2.83,8.49,2.83,11.31,5.66,11.31]],repeat:[[3,1],[18,16]],fill:1,stroke:1},mixtree:{width:30,height:30,lines:[[7.78,10.61,4.95,10.61,4.95,7.78,3.54,7.78,2.12,6.36,.71,6.36,0,4.24,.71,2.12,4.24,0,7.78,.71,9.19,3.54,7.78,4.95,7.07,7.07,4.95,7.78,4.95,10.61,7.78,10.61],[23.66,27.31,20.83,27.31,20.83,24.49,18,24.49,20.83,16,23.66,24.49,20.83,24.49,20.83,27.31,23.66,27.31]],repeat:[[3,1]],stroke:1},mixtree2:{width:30,height:30,lines:[[7.78,10.61,4.95,10.61,4.95,7.78,3.54,7.78,2.12,6.36,.71,6.36,0,4.24,.71,2.12,4.24,0,7.78,.71,9.19,3.54,7.78,4.95,7.07,7.07,4.95,7.78,4.95,10.61,7.78,10.61],[23.66,27.31,20.83,27.31,20.83,24.49,18,24.49,20.83,16,23.66,24.49,20.83,24.49,20.83,27.31,23.66,27.31]],repeat:[[3,1]],fill:1,stroke:1},pines:{width:22,height:20,lines:[[1,4,3.5,1,6,4],[1,8,3.5,5,6,8],[3.5,1,3.5,11],[12,14.5,14.5,14,17,14.5],[12,18,17,18],[14.5,12,14.5,18]],repeat:[[2,1]],stroke:1},rock:{width:20,height:20,lines:[[1,0,1,9],[4,0,4,9],[7,0,7,9],[10,1,19,1],[10,4,19,4],[10,7,19,7],[0,11,9,11],[0,14,9,14],[0,17,9,17],[12,10,12,19],[15,10,15,19],[18,10,18,19]],repeat:[[.5,.5]],stroke:1},rocks:{width:20,height:20,lines:[[5,0,3,0,5,4,4,6,0,3,0,5,3,6,5,9,3.75,10,2.5,10,0,9,0,10,4,11,5,14,4,15,0,13,0,13,0,13,0,14,0,14,5,16,5,18,3,19,0,19,-.25,19.9375,5,20,10,19,10,20,11,20,12,19,14,20,15,20,17,19,20,20,20,19,19,16,20,15,20,11,20,10,19,8,20,5,20,0,19,0,20,2,19,4,17,4,16,3,15,0,14,0,15,4,11,5,10,4,11,0,10,0,9,4,6,5,5,0],[18,5,19,6,18,10,16,10,14,9,16,5,18,5],[5,6,9,5,10,6,10,9,6,10,5,6],[14,5,14,8,13,9,12,9,11,7,12,5,14,5],[5,11,8,10,9,11,10,14,6,15,6,15,5,11],[13,10,14,11,15,14,15,14,15,14,11,15,10,11,11,10,13,10],[15,12,16,11,19,11,19,15,16,14,16,14,15,12],[6,16,9,15,10,18,5,19,6,16],[10,16,14,16,14,18,13,19,11,18,10,16],[15,15,18,16,18,18,16,19,15,18,15,15]],stroke:1}},ol.style.FlowLine=function(t){t||(t={}),ol.style.Style.call(this,{renderer:this._render.bind(this),stroke:t.stroke,text:t.text,zIndex:t.zIndex,geometry:t.geometry}),this._visible=!1!==t.visible,"function"==typeof t.width?this._widthFn=t.width:this.setWidth(t.width),this.setWidth2(t.width2),"function"==typeof t.color?this._colorFn=t.color:this.setColor(t.color),this.setColor2(t.color2),this.setLineCap(t.lineCap),this.setArrow(t.arrow),this.setArrowSize(t.arrowSize),this.setArrowColor(t.arrowColor),this._offset=[0,0],this.setOffset(t.offset0,0),this.setOffset(t.offset1,1),this._noOverlap=t.noOverlap},ol.ext.inherits(ol.style.FlowLine,ol.style.Style),ol.style.FlowLine.prototype.setWidth=function(t){this._width=t||0},ol.style.FlowLine.prototype.setWidth2=function(t){this._width2=t},ol.style.FlowLine.prototype.getOffset=function(t){return this._offset[t]},ol.style.FlowLine.prototype.setOffset=function(t,e){switch(t=Math.max(0,parseFloat(t)),e){case 0:this._offset[0]=t;break;case 1:this._offset[1]=t}},ol.style.FlowLine.prototype.setLineCap=function(t){this._lineCap="round"===t?"round":"butt"},ol.style.FlowLine.prototype.getWidth=function(t,e){if(this._widthFn)return this._widthFn(t,e);var o="number"==typeof this._width2?this._width2:this._width;return this._width+(o-this._width)*e},ol.style.FlowLine.prototype.setColor=function(t){try{this._color=ol.color.asArray(t)}catch(t){this._color=[0,0,0,1]}},ol.style.FlowLine.prototype.setColor2=function(t){try{this._color2=ol.color.asArray(t)}catch(t){this._color2=null}},ol.style.FlowLine.prototype.setArrowColor=function(t){try{this._acolor=ol.color.asString(t)}catch(t){this._acolor=null}},ol.style.FlowLine.prototype.getColor=function(t,e){if(this._colorFn)return ol.color.asString(this._colorFn(t,e));var o=this._color,i=this._color2||this._color;return"rgba("+ +Math.round(o[0]+(i[0]-o[0])*e)+","+Math.round(o[1]+(i[1]-o[1])*e)+","+Math.round(o[2]+(i[2]-o[2])*e)+","+(o[3]+(i[3]-o[3])*e)+")"},ol.style.FlowLine.prototype.getArrow=function(){return this._arrow},ol.style.FlowLine.prototype.setArrow=function(t){this._arrow=parseInt(t),(this._arrow<-1||this._arrow>2)&&(this._arrow=0)},ol.style.FlowLine.prototype.getArrowSize=function(){return this._arrowSize||[16,16]},ol.style.FlowLine.prototype.setArrowSize=function(t){Array.isArray(t)?this._arrowSize=t:"number"==typeof t&&(this._arrowSize=[t,t])},ol.style.FlowLine.prototype.drawArrow=function(t,e,o,i,n){var r=this.getArrowSize()[0]*n,s=ol.coordinate.dist2d(e,o),a=(e[0]-o[0])/s,l=(e[1]-o[1])/s;i=Math.max(this.getArrowSize()[1]/2,i/2)*n,t.beginPath(),t.moveTo(e[0],e[1]),t.lineTo(e[0]-r*a+i*l,e[1]-r*l-i*a),t.lineTo(e[0]-r*a-i*l,e[1]-r*l+i*a),t.lineTo(e[0],e[1]),t.fill()},ol.style.FlowLine.prototype._render=function(t,e){if("LineString"===e.geometry.getType()){var o,i,n,r=e.context;if(!this._visible){var s=e.pixelRatio/e.resolution,a=Math.cos(e.rotation),l=Math.sin(e.rotation);i=e.geometry.getCoordinates();var c=t[0][0]-i[0][0]*s*a-i[0][1]*s*l,h=t[0][1]-i[0][0]*s*l+i[0][1]*s*a;for(t=[],o=0;n=i[o];o++)t[o]=[c+n[0]*s*a+n[1]*s*l,h+n[0]*s*l-n[1]*s*a,n[2]]}var p=this.getArrowSize()[0]*e.pixelRatio;r.save(),this.getOffset(0)&&this._splitAsize(t,this.getOffset(0)*e.pixelRatio),this.getOffset(1)&&this._splitAsize(t,this.getOffset(1)*e.pixelRatio,!0),t.length>1&&(-1===this.getArrow()||2===this.getArrow())&&(n=this._splitAsize(t,p),this._acolor?r.fillStyle=this._acolor:r.fillStyle=this.getColor(e.feature,0),this.drawArrow(r,n[0],n[1],this.getWidth(e.feature,0),e.pixelRatio)),t.length>1&&this.getArrow()>0&&(n=this._splitAsize(t,p,!0),this._acolor?r.fillStyle=this._acolor:r.fillStyle=this.getColor(e.feature,1),this.drawArrow(r,n[0],n[1],this.getWidth(e.feature,1),e.pixelRatio));var u=this._splitInto(t,255,2),g=0,d=u.length;if(r.lineJoin="round",r.lineCap=this._lineCap||"butt",u.length>1)for(g=0;g<u.length;g++){var m=g/d;for(i=u[g],r.lineWidth=this.getWidth(e.feature,m)*e.pixelRatio,r.strokeStyle=this.getColor(e.feature,m),r.beginPath(),r.moveTo(i[0][0],i[0][1]),o=1;n=i[o];o++)r.lineTo(n[0],n[1]);r.stroke()}r.restore()}},ol.style.FlowLine.prototype._splitAsize=function(t,e,o){var i,n,r,s,a=0;for(i=r=o?t.pop():t.shift();t.length;){if(n=o?t.pop():t.shift(),a+(s=ol.coordinate.dist2d(i,n))>e){i=[i[0]+(n[0]-i[0])*(e-a)/s,i[1]+(n[1]-i[1])*(e-a)/s],s=ol.coordinate.dist2d(i,r),o?(t.push(n),t.push(i),t.push([i[0]+(r[0]-i[0])/s,i[1]+(r[1]-i[1])/s])):(t.unshift(n),t.unshift(i),t.unshift([i[0]+(r[0]-i[0])/s,i[1]+(r[1]-i[1])/s]));break}a+=s,i=n}return[r,i]},ol.style.FlowLine.prototype._splitInto=function(t,e,o){var i,n,r,s=this._noOverlap?1:.9,a=[],l=0;for(i=1;n=t[i];i++)l+=ol.coordinate.dist2d(t[i-1],n);var c=Math.max(o||2,l/(e||255)),h=t[0];l=0;var p=[h];for(i=1,n=t[1];i<t.length;){var u=n[0]-h[0],g=n[1]-h[1];if(l+(r=Math.sqrt(u*u+g*g))>c){var d=(c-l)/r;p.push([h[0]+u*d,h[1]+g*d]),a.push(p),p=[h=[h[0]+u*d*s,h[1]+g*d*s]],l=0}else l+=r,h=n,p.push(h),n=t[++i]}return a.push(p),a},ol.style.FontSymbol=function(t){var e=0;(t=t||{}).stroke&&(e=t.stroke.getWidth()),t.displacement||(t.displacement=[t.offsetX||0,-t.offsetY||0]),"number"==typeof t.opacity&&this.setOpacity(t.opacity),this._color=t.color,this._fontSize=t.fontSize||1,this._fontStyle=t.fontStyle||"",this._stroke=t.stroke,this._fill=t.fill,this._radius=t.radius-e,this._form=t.form||"none",this._gradient=t.gradient,this._offset=[t.offsetX?t.offsetX:0,t.offsetY?t.offsetY:0],t.glyph?this._glyph=this.getGlyph(t.glyph):this._glyph=this.getTextGlyph(t.text||"",t.font),ol.style.RegularShape.call(this,{radius:t.radius,fill:t.fill,rotation:t.rotation,displacement:t.displacement,rotateWithView:t.rotateWithView}),this.getDisplacement||this.getImage()},ol.ext.inherits(ol.style.FontSymbol,ol.style.RegularShape),ol.style.Image.prototype.getImagePNG=function(t){t=t||window.devicePixelRatio;var e=this.getImage(t);if(!e)return!1;try{return e.toDataURL("image/png")}catch(t){return!1}},ol.style.FontSymbol.prototype.defs={fonts:{},glyphs:{}},ol.style.FontSymbol.addDefs=function(t,e){var o=t;if("string"==typeof t&&(o={font:t,name:t,copyright:""}),o.font&&"string"==typeof o.font){var i=o.font;for(var n in ol.style.FontSymbol.prototype.defs.fonts[i]=o,e){var r=e[n];"string"==typeof r&&1==r.length&&(r={char:r}),ol.style.FontSymbol.prototype.defs.glyphs[n]={font:o.font,char:r.char||""+String.fromCharCode(r.code)||"",theme:r.theme||o.name,name:r.name||n,search:r.search||""}}}else console.log("bad font def")},ol.style.FontSymbol.prototype.clone=function(){var t=new ol.style.FontSymbol({glyph:"",color:this._color,fontSize:this._fontSize,fontStyle:this._fontStyle,stroke:this._stroke,fill:this._fill,radius:this._radius+(this._stroke?this._stroke.getWidth():0),form:this._form,gradient:this._gradient,offsetX:this._offset[0],offsetY:this._offset[1],opacity:this.getOpacity(),rotation:this.getRotation(),rotateWithView:this.getRotateWithView()});return t.setScale(this.getScale()),t.glyph_=this._glyph,t.getImage(),t},ol.style.FontSymbol.prototype.getFill=function(){return this._fill},ol.style.FontSymbol.prototype.getStroke=function(){return this._stroke},ol.style.FontSymbol.prototype.getGlyph=function(t){return t?ol.style.FontSymbol.prototype.defs.glyphs[t]||{font:"sans-serif",char:t.charAt(0),theme:"none",name:"none",search:""}:this._glyph},ol.style.FontSymbol.prototype.getTextGlyph=function(t,e){return{font:e||"sans-serif",char:String(t),theme:"none",name:"none",search:""}},ol.style.FontSymbol.prototype.getGlyphName=function(){for(var t in ol.style.FontSymbol.prototype.defs.glyphs)if(ol.style.FontSymbol.prototype.defs.glyphs[t]===this._glyph)return t;return""},ol.style.FontSymbol.prototype.getFontInfo=function(t){return ol.style.FontSymbol.prototype.defs.fonts[t.font]},ol.style.FontSymbol.prototype.getImage=function(t){t=t||1;var e,o=ol.style.RegularShape.prototype.getImage.call(this,t),i=0;this._stroke&&(e=ol.color.asString(this._stroke.getColor()),i=this._stroke.getWidth());var n={strokeStyle:e,strokeWidth:i,size:o.width/t},r=o.getContext("2d");if(r.clearRect(0,0,o.width,o.height),this.drawMarker_(n,r,0,0,t),!this.getDisplacement){var s=this.getAnchor();s[0]=o.width/2-this._offset[0],s[1]=o.width/2-this._offset[1]}return o},ol.style.FontSymbol.prototype.drawPath_=function(t,e){var o=2*this._radius+t.strokeWidth,i=t.strokeWidth/2,n=t.size/2,r={fac:1,posX:t.size/2,posY:t.size/2};switch(e.lineJoin="round",e.lineCap="round",e.beginPath(),this._form){case"none":r.fac=1;break;case"circle":case"ban":e.arc(n,n,o/2,0,2*Math.PI,!0);break;case"poi":e.arc(n,n-.4*this._radius,.6*this._radius,.15*Math.PI,.85*Math.PI,!0),e.lineTo(n-.89*.05*o,(.95+.45*.05)*o+i),e.arc(n,.95*o+i,.05*o,.85*Math.PI,.15*Math.PI,!0),r={fac:.45,posX:n,posY:n-.35*this._radius};break;case"bubble":e.arc(n,n-.2*this._radius,.8*this._radius,.4*Math.PI,.6*Math.PI,!0),e.lineTo(.5*o+i,o+i),r={fac:.7,posX:n,posY:n-.2*this._radius};break;case"marker":e.arc(n,n-.2*this._radius,.8*this._radius,.25*Math.PI,.75*Math.PI,!0),e.lineTo(.5*o+i,o+i),r={fac:.7,posX:n,posY:n-.2*this._radius};break;case"coma":e.moveTo(n+.8*this._radius,n-.2*this._radius),e.quadraticCurveTo(.95*o+i,.75*o+i,.5*o+i,o+i),e.arc(n,n-.2*this._radius,.8*this._radius,.45*Math.PI,0,!1),r={fac:.7,posX:n,posY:n-.2*this._radius};break;default:var s;switch(this._form){case"shield":s=[.05,0,.95,0,.95,.8,.5,1,.05,.8,.05,0],r.posY=.45*o+i;break;case"blazon":s=[.1,0,.9,0,.9,.8,.6,.8,.5,1,.4,.8,.1,.8,.1,0],r.fac=.8,r.posY=.4*o+i;break;case"bookmark":s=[.05,0,.95,0,.95,1,.5,.8,.05,1,.05,0],r.fac=.9,r.posY=.4*o+i;break;case"hexagon":s=[.05,.2,.5,0,.95,.2,.95,.8,.5,1,.05,.8,.05,.2],r.fac=.9,r.posY=.5*o+i;break;case"diamond":s=[.25,0,.75,0,1,.2,1,.4,.5,1,0,.4,0,.2,.25,0],r.fac=.75,r.posY=.35*o+i;break;case"triangle":s=[0,0,1,0,.5,1,0,0],r.fac=.6,r.posY=.3*o+i;break;case"sign":s=[.5,.05,1,.95,0,.95,.5,.05],r.fac=.7,r.posY=.65*o+i;break;case"lozenge":s=[.5,0,1,.5,.5,1,0,.5,.5,0],r.fac=.7;break;case"square":default:s=[0,0,1,0,1,1,0,1,0,0]}for(var a=0;a<s.length;a+=2)e.lineTo(s[a]*o+i,s[a+1]*o+i)}return e.closePath(),r},ol.style.FontSymbol.prototype.drawMarker_=function(t,e,o,i,n){var r=this._fill?this._fill.getColor():"#000",s=this._stroke?this._stroke.getColor():"#000";"none"==this._form&&this._stroke&&this._fill&&(s=this._fill.getColor(),r=this._stroke.getColor()),e.setTransform(n,0,0,n,0,0),e.translate(o,i);var a=this.drawPath_(t,e,n);if(this._fill){if(this._gradient&&"none"!=this._form){var l=e.createLinearGradient(0,0,t.size/2,t.size);l.addColorStop(1,ol.color.asString(r)),l.addColorStop(0,ol.color.asString(s)),e.fillStyle=l}else e.fillStyle=ol.color.asString(r);e.fill()}if(this._stroke&&t.strokeWidth&&(e.strokeStyle=t.strokeStyle,e.lineWidth=t.strokeWidth,e.stroke()),this._glyph.char){e.font=this._fontStyle+" "+2*a.fac*this._radius*this._fontSize+"px "+this._glyph.font,e.strokeStyle=e.fillStyle,e.lineWidth=t.strokeWidth*("none"==this._form?2:1),e.fillStyle=ol.color.asString(this._color||s),e.textAlign="center",e.textBaseline="middle";var c=this._glyph.char;t.strokeWidth&&"transparent"!=s&&e.strokeText(c,a.posX,a.posY),e.fillText(c,a.posX,a.posY)}if("ban"==this._form&&this._stroke&&t.strokeWidth){e.strokeStyle=t.strokeStyle,e.lineWidth=t.strokeWidth;var h=this._radius+t.strokeWidth,p=this._radius*Math.cos(Math.PI/4);e.moveTo(h+p,h-p),e.lineTo(h-p,h+p),e.stroke()}},ol.style.FontSymbol.prototype.getChecksum=function(){var t=null!==this._stroke?this._stroke.getChecksum():"-",e=null!==this._fill?this._fill.getChecksum():"-";if(null===this.checksums_||t!=this.checksums_[1]||e!=this.checksums_[2]||this._radius!=this.checksums_[3]||this._form+"-"+this.glyphs_!=this.checksums_[4]){var o="c"+t+e+(void 0!==this._radius?this._radius.toString():"-")+this._form+"-"+this.glyphs_;this.checksums_=[o,t,e,this._radius,this._form+"-"+this.glyphs_]}return this.checksums_[0]},ol.style.Photo=function(t){(t=t||{}).displacement||(t.displacement=[t.offsetX||0,-t.offsetY||0]),this.sanchor_="anchored"===t.kind?8:0,this._shadow=Number(t.shadow)||0,t.stroke||(t.stroke=new ol.style.Stroke({width:0,color:"#000"}));var e=t.stroke.getWidth();if(e<0&&(e=0),"folio"==t.kind&&(e+=6),t.stroke.setWidth(e),ol.style.RegularShape.call(this,{radius:t.radius+e+this.sanchor_/2+this._shadow/2,points:0,displacement:[t.displacement[0]||0,(t.displacement[1]||0)+this.sanchor_],fill:ol.style.RegularShape.prototype.render?new ol.style.Fill({color:[0,0,0,0]}):null}),!this.getHitDetectionImage){var o=ol.style.RegularShape.prototype.getImage.call(this);if(!this.hitDetectionCanvas_)for(var i in this)if(this[i]&&this[i].getContext&&this[i]!==o){this.hitDetectionCanvas_=this[i];break}this.hitDetectionCanvas_=document.createElement("canvas"),this.hitDetectionCanvas_.width=o.width,this.hitDetectionCanvas_.height=o.height;var n=this.hitDetectionCanvas_;this.getHitDetectionImage=function(){return n},setTimeout(function(){this.getImage()}.bind(this))}this._stroke=t.stroke,this._fill=t.fill,this._crop=t.crop,this._crossOrigin=t.crossOrigin,this._kind=t.kind||"default",this._radius=t.radius,this._src=t.src,this._offset=[t.offsetX?t.offsetX:0,t.offsetY?t.offsetY:0],this._onload=t.onload,"number"==typeof t.opacity&&this.setOpacity(t.opacity),"number"==typeof t.rotation&&this.setRotation(t.rotation)},ol.ext.inherits(ol.style.Photo,ol.style.RegularShape),ol.style.Photo.prototype.setOffset=function(t){this._offset=[t[0]||0,t[1]||0],this.getImage()},ol.style.Photo.prototype.clone=function(){var t=new ol.style.Photo({stroke:this._stroke,fill:this._fill,shadow:this._shadow,crop:this._crop,crossOrigin:this._crossOrigin,kind:this._kind,radius:this._radius,src:this._src,offsetX:this._offset[0],offsetY:this._offset[1],opacity:this.getOpacity(),rotation:this.getRotation()});return t.getImage(),t},CanvasRenderingContext2D.prototype.roundRect=function(t,e,o,i,n){return n?(o<2*n&&(n=o/2),i<2*n&&(n=i/2),this.beginPath(),this.moveTo(t+n,e),this.arcTo(t+o,e,t+o,e+i,n),this.arcTo(t+o,e+i,t,e+i,n),this.arcTo(t,e+i,t,e,n),this.arcTo(t,e,t+o,e,n),this.closePath()):this.rect(t,e,o,i),this},ol.style.Photo.prototype.drawBack_=function(t,e,o,i){var n=this._shadow,r=t.canvas;t.beginPath(),t.fillStyle=e,t.clearRect(0,0,r.width,r.height);var s=r.width/i,a=r.height/i;switch(this._kind){case"square":t.rect(0,0,s-n,a-n);break;case"circle":t.arc(this._radius+o,this._radius+o,this._radius+o,0,2*Math.PI,!1);break;case"folio":o-=6,t.strokeStyle="rgba(0,0,0,0.5)",t.lineWidth=1;var l=s-n-12,c=Math.atan(6/l);t.save(),t.rotate(-c),t.translate(-6,2),t.beginPath(),t.rect(6,6,l,l),t.stroke(),t.fill(),t.restore(),t.save(),t.translate(6,-1),t.rotate(c),t.beginPath(),t.rect(6,6,l,l),t.stroke(),t.fill(),t.restore(),t.beginPath(),t.rect(6,6,l,l),t.stroke();break;case"anchored":t.roundRect(this.sanchor_/2,0,s-this.sanchor_-n,a-this.sanchor_-n,o),t.moveTo(s/2-this.sanchor_-n/2,a-this.sanchor_-n),t.lineTo(s/2+this.sanchor_-n/2,a-this.sanchor_-n),t.lineTo(s/2-n/2,a-n);break;default:t.roundRect(0,0,s-n,a-n,o)}t.closePath()},ol.style.Photo.prototype.getImage=function(t){t=t||1;var e,o=ol.style.RegularShape.prototype.getImage.call(this,t);if(this._gethit)return o;var i=0;this._stroke&&(e=ol.color.asString(this._stroke.getColor()),i=this._stroke.getWidth()),this._gethit=!0;var n=this.getHitDetectionImage().getContext("2d");n.save(),n.setTransform(1,0,0,1,0,0),this.drawBack_(n,"#000",i,1),n.fill(),n.restore(),this._gethit=!1,(n=o.getContext("2d")).save(),n.setTransform(t,0,0,t,0,0),this.drawBack_(n,e,i,t),this._shadow&&(n.shadowColor="rgba(0,0,0,0.5)",n.shadowBlur=t*this._shadow/2,n.shadowOffsetX=t*this._shadow/2,n.shadowOffsetY=t*this._shadow/2),n.fill(),n.restore();var r=this,s=this.img_=new Image;if(this._crossOrigin&&(s.crossOrigin=this._crossOrigin),s.src=this._src,s.width?r.drawImage_(o,s,t):s.onload=function(){r.drawImage_(o,s,t),r._onload&&r._onload()},!this.getDisplacement){var a=this.getAnchor();a[0]=(o.width/t-this._shadow)/2-this._offset[0],this.sanchor_?a[1]=o.height/t-this._shadow-this._offset[1]:a[1]=(o.height/t-this._shadow)/2-this._offset[1]}return o},ol.style.Photo.prototype.drawImage_=function(t,e,o){var i=t.getContext("2d"),n=0;this._stroke&&(n=this._stroke.getWidth());var r,s,a,l,c,h,p,u,g,d=2*this._radius;i.save(),ol.style.RegularShape.prototype.render&&i.setTransform(o,0,0,o,0,0),"circle"==this._kind&&(i.beginPath(),i.arc(this._radius+n,this._radius+n,this._radius,0,2*Math.PI,!1),i.clip()),this._crop?(u=g=(r=Math.min(e.width/d,e.height/d))*d,h=(e.width-u)/2,p=(e.height-g)/2,s=a=0,l=c=d+1):(h=p=0,s=(d-(l=(r=Math.min(d/e.width,d/e.height))*(u=e.width)))/2,a=(d-(c=r*(g=e.height)))/2),s+=n+this.sanchor_/2,a+=n,i.drawImage(e,h,p,u,g,s,a,l,c),"circle"==this._kind&&n&&(i.beginPath(),i.strokeStyle=ol.color.asString(this._stroke.getColor()),i.lineWidth=n/4,i.arc(this._radius+n,this._radius+n,this._radius,0,2*Math.PI,!1),i.stroke()),i.restore()},ol.style.Profile=function(t){t||(t={}),ol.style.Style.call(this,{renderer:this._render.bind(this),zIndex:t.zIndex,geometry:t.geometry}),this.setStroke(t.stroke),this.setFill(t.fill),this.setScale(t.scale)},ol.ext.inherits(ol.style.Profile,ol.style.Style),ol.style.Profile.prototype.setStroke=function(t){this._stroke=t||new ol.style.Stroke({color:"#fff",width:1})},ol.style.Profile.prototype.getStroke=function(){return this._stroke},ol.style.Profile.prototype.setFill=function(t){this._fill=t||new ol.style.Fill({color:"rgba(255,255,255,.3"})},ol.style.Profile.prototype.getFill=function(){return this._fill},ol.style.Profile.prototype.setScale=function(t){this._scale=t||.2},ol.style.Profile.prototype.getScale=function(){return this._scale},ol.style.Profile.prototype._render=function(t,e){if(/Z/.test(e.feature.getGeometry().getLayout())){var o=e.geometry.getCoordinates();switch(e.geometry.getType()){case"LineString":this._renderLine(t,o,e.feature.getGeometry(),e);break;case"MultiLineString":e.feature.getGeometry().getLineStrings().forEach(function(i,n){this._renderLine(t[n],o[n],i,e)}.bind(this))}}},ol.style.Profile.prototype._renderLine=function(t,e,o,i){var n,r,s=i.context,a=Math.cos(i.rotation),l=Math.sin(i.rotation),c=ol.coordinate.dist2d(t[0],t[1])/ol.coordinate.dist2d(e[0],e[1]),h=t[0][0]-e[0][0]*c*a-e[0][1]*c*l,p=t[0][1]-e[0][0]*c*l+e[0][1]*c*a;t=o.getCoordinates();var u=1/0;for(n=0;r=t[n];n++){var g=h+r[0]*c*a+r[1]*c*l,d=p+r[0]*c*l-r[1]*c*a;u=Math.min(u,r[2]),t[n]=[g,d,r[2]]}s.save(),s.fillStyle=ol.color.asString(this.getFill().getColor()),s.strokeStyle=ol.color.asString(this.getStroke().getColor()),s.lineWidth=this.getStroke().getWidth();var m=t[0],f=this.getScale()*i.pixelRatio;for(n=1;r=t[n];n++)s.beginPath(),s.moveTo(m[0],m[1]),s.lineTo(r[0],r[1]),s.lineTo(r[0],r[1]-(r[2]-u)*f),s.lineTo(m[0],m[1]-(m[2]-u)*f),s.lineTo(m[0],m[1]),s.fill(),m=r;for(m=t[0],s.beginPath(),s.moveTo(m[0],m[1]-(m[2]-u)*f),n=1;r=t[n];n++)s.lineTo(r[0],r[1]-(r[2]-u)*f);s.stroke(),s.restore()},function(){ol.layer.Vector.prototype.setTextPathStyle=function(t,e){if(null===t)return this.textPath_&&this.unByKey(this.textPath_),this.textPath_=null,void this.changed();this.textPath_||(this.textPath_=this.on(["postcompose","postrender"],function(t){if(!(t.frameState.viewState.resolution>this.textPathMaxResolution_)){var e,o=t.frameState.extent,i=t.frameState.coordinateToPixelTransform,n=t.context;n.save(),n.scale(t.frameState.pixelRatio,t.frameState.pixelRatio);for(var r,s=this.getSource().getFeaturesInExtent(o),a=0;r=s[a];a++)for(var l,c=this.textPathStyle_(r,t.frameState.viewState.resolution),h=0;l=c[h];h++){var p,u=l.getGeometry()||r.getGeometry();switch(u.getType()){case"LineString":p=u.getCoordinates();break;case"MultiLineString":p=u.getLineString(0).getCoordinates();break;default:continue}var g=l.getText(),d=m(p,g.getRotateWithView());n.font=g.getFont(),n.textBaseline=g.getTextBaseline(),n.textAlign=g.getTextAlign(),n.lineWidth=g.getStroke()&&g.getStroke().getWidth()||0,n.strokeStyle=g.getStroke()&&g.getStroke().getColor()||"#fff",n.fillStyle=g.getFill()&&g.getFill().getColor()||"#000",n.textJustify="justify"==g.getTextAlign(),n.textOverflow=g.getTextOverflow?g.getTextOverflow():"",n.minWidth=g.getMinWidth?g.getMinWidth():0,n.textPath(g.getText()||r.get("name"),d)}n.restore()}function m(t,o){var n=[];for(e=0;e<t.length;e++)n.push(i[0]*t[e][0]+i[1]*t[e][1]+i[4]),n.push(i[2]*t[e][0]+i[3]*t[e][1]+i[5]);if(o&&n[0]>n[n.length-2]){var r=[];for(e=n.length-2;e>=0;e-=2)r.push(n[e]),r.push(n[e+1]);return r}return n}}.bind(this))),void 0===t&&(t=[new ol.style.Style({text:new ol.style.Text})]),this.textPathStyle_="function"==typeof t?t:function(){return t},this.textPathMaxResolution_=Number(e)||Number.MAX_VALUE,this.changed()},ol.style.TextPath=function(t){t||(t={}),ol.style.Text.call(this,t),this.textOverflow_=void 0!==t.textOverflow?t.textOverflow:"visible",this.minWidth_=t.minWidth||0},ol.ext.inherits(ol.style.TextPath,ol.style.Text),ol.style.TextPath.prototype.getTextOverflow=function(){return this.textOverflow_},ol.style.TextPath.prototype.getMinWidth=function(){return this.minWidth_}}(),CanvasRenderingContext2D.prototype.textPath=function(t,e){var o=this;function i(t,e,o,i){var n=o-t,r=i-e;return Math.sqrt(n*n+r*r)}var n,r=0,s=2;function a(t,e){if(!n||r+n<e)for(;s<t.length&&(n=i(t[s-2],t[s-1],t[s],t[s+1]),!(r+n>e))&&!((s+=2)>=t.length);)r+=n;var o,a,l,c=e-r;return s>=t.length&&(s=t.length-2),c?(o=t[s-2]+(t[s]-t[s-2])*c/n,a=t[s-1]+(t[s+1]-t[s-1])*c/n,l=Math.atan2(t[s+1]-t[s-1],t[s]-t[s-2])):(o=t[s-2],a=t[s-1],l=Math.atan2(t[s+1]-t[s-1],t[s]-t[s-2])),[o,a,l]}for(var l=.25*o.measureText(" ").width,c=0,h=0,p=2;p<e.length;p+=2)h+=i(e[p-2],e[p-1],e[p],e[p+1]);if(!(h<o.minWidth)){var u=t.split(" ").length-1;if("visible"!=o.textOverflow&&h<o.measureText(t).width+(t.length-1+u)*l){var g="ellipsis"==o.textOverflow?"…":o.textOverflow;do{u=t.split(" ").length-1,t=t.slice(0,t.length-1)}while(t&&h<o.measureText(t+g).width+(t.length+g.length-1+u)*l);t+=g}switch(o.textJustify||o.textAlign){case!0:case"center":case"end":case"right":o.textJustify?(c=0,l=(h-o.measureText(t).width)/(t.length-1+u)):(c=h-o.measureText(t).width-(t.length+u)*l,"center"==o.textAlign&&(c/=2))}for(var d=0;d<t.length;d++){var m=t[d],f=o.measureText(m).width,y=a(e,c+f/2);o.save(),o.textAlign="center",o.translate(y[0],y[1]),o.rotate(y[2]),o.lineWidth&&o.strokeText(m,0,0),o.fillText(m,0,0),o.restore(),c+=f+l*(" "==m?2:1)}}},ol.style.Shadow=function(t){t=t||{},this._fill=t.fill||new ol.style.Fill({color:"rgba(0,0,0,0.5)"}),this._radius=t.radius,this._blur=0===t.blur?0:t.blur||t.radius/3,this._offset=[t.offsetX?t.offsetX:0,t.offsetY?t.offsetY:0],t.displacement||(t.displacement=[t.offsetX||0,-t.offsetY||0]),ol.style.RegularShape.call(this,{radius:t.radius,fill:t.fill,displacement:t.displacement}),this.setDisplacement||this.getImage()},ol.ext.inherits(ol.style.Shadow,ol.style.RegularShape),ol.style.Shadow.prototype.clone=function(){var t=new ol.style.Shadow({fill:this._fill,radius:this._radius,blur:this._blur,offsetX:this._offset[0],offsetY:this._offset[1]});return t.setScale(this.getScale()),t.setOpacity(this.getOpacity()),t},ol.style.Shadow.prototype.getImage=function(t){t=t||1;var e=this._radius,o=ol.style.RegularShape.prototype.getImage.call(this,t),i=o.getContext("2d");if(i.clearRect(0,0,o.width,o.height),i.save(),i.beginPath(),i.setTransform(t,0,0,t,0,0),i.scale(1,.5),i.arc(e,-e,e-this._blur,0,2*Math.PI,!1),i.fillStyle="#000",i.shadowColor=this._fill.getColor(),i.shadowBlur=.7*this._blur*t,i.shadowOffsetX=0,i.shadowOffsetY=1.5*e*t,i.closePath(),i.fill(),i.shadowColor="transparent",i.restore(),!this.getDisplacement){var n=this.getAnchor();n[0]=o.width/2-this._offset[0],n[1]=o.height/2-this._offset[1]}return o},ol.style.StrokePattern=function(t){var e,o;t||(t={});var i=this.canvas_=document.createElement("canvas"),n=(Number(t.scale)>0?Number(t.scale):1)*ol.has.DEVICE_PIXEL_RATIO||ol.has.DEVICE_PIXEL_RATIO,r=i.getContext("2d");if(t.image){t.image.load();var s=t.image.getImage();if(s.width)i.width=Math.round(s.width*n),i.height=Math.round(s.height*n),r.globalAlpha="number"==typeof t.opacity?t.opacity:1,r.drawImage(s,0,0,s.width,s.height,0,0,i.width,i.height),e=r.createPattern(i,"repeat");else{var a=this;e=[0,0,0,0],s.onload=function(){i.width=Math.round(s.width*n),i.height=Math.round(s.height*n),r.globalAlpha="number"==typeof t.opacity?t.opacity:1,r.drawImage(s,0,0,s.width,s.height,0,0,i.width,i.height),e=r.createPattern(i,"repeat"),a.setColor(e)}}}else{var l=this.getPattern_(t);if(i.width=Math.round(l.width*n),i.height=Math.round(l.height*n),r.beginPath(),t.fill&&(r.fillStyle=ol.color.asString(t.fill.getColor()),r.fillRect(0,0,i.width,i.height)),r.scale(n,n),r.lineCap="round",r.lineWidth=l.stroke||1,r.fillStyle=ol.color.asString(t.color||"#000"),r.strokeStyle=ol.color.asString(t.color||"#000"),l.circles)for(o=0;o<l.circles.length;o++){var c=l.circles[o];r.beginPath(),r.arc(c[0],c[1],c[2],0,2*Math.PI),l.fill&&r.fill(),l.stroke&&r.stroke()}if(l.repeat||(l.repeat=[[0,0]]),l.char&&(r.font=l.font||l.width+"px Arial",r.textAlign="center",r.textBaseline="middle",l.angle?(r.fillText(l.char,l.width/4,l.height/4),r.fillText(l.char,5*l.width/4,5*l.height/4),r.fillText(l.char,l.width/4,5*l.height/4),r.fillText(l.char,5*l.width/4,l.height/4),r.fillText(l.char,3*l.width/4,3*l.height/4),r.fillText(l.char,-l.width/4,-l.height/4),r.fillText(l.char,3*l.width/4,-l.height/4),r.fillText(l.char,-l.width/4,3*l.height/4)):r.fillText(l.char,l.width/2,l.height/2)),l.lines)for(o=0;o<l.lines.length;o++)for(var h=0;h<l.repeat.length;h++){var p=l.lines[o];r.beginPath(),r.moveTo(p[0]+l.repeat[h][0],p[1]+l.repeat[h][1]);for(var u=2;u<p.length;u+=2)r.lineTo(p[u]+l.repeat[h][0],p[u+1]+l.repeat[h][1]);l.fill&&r.fill(),l.stroke&&r.stroke(),r.save(),r.strokeStyle="red",r.strokeWidth=.1,r.restore()}if(e=r.createPattern(i,"repeat"),t.offset){var g=t.offset;if("number"==typeof g&&(g=[g,g]),g instanceof Array){var d=Math.round(g[0]*n),m=Math.round(g[1]*n);r.scale(1/n,1/n),r.clearRect(0,0,i.width,i.height),r.translate(d,m),r.fillStyle=e,r.fillRect(-d,-m,i.width,i.height),e=r.createPattern(i,"repeat")}}}t.color=e,ol.style.Stroke.call(this,t)},ol.ext.inherits(ol.style.StrokePattern,ol.style.Stroke),ol.style.StrokePattern.prototype.clone=function(){var t=ol.style.Fill.prototype.clone.call(this);return t.canvas_=this.canvas_,t},ol.style.StrokePattern.prototype.getImage=function(){return this.canvas_},ol.style.StrokePattern.prototype.getPattern_=function(t){var e,o=ol.style.FillPattern.prototype.patterns[t.pattern]||ol.style.FillPattern.prototype.patterns.dot,i=Math.round(t.spacing)||10;switch(t.pattern){case"dot":case"circle":e=0===t.size?0:t.size/2||2,t.angle?(i=o.width=o.height=Math.round(1.4*i),o.circles=[[i/4,i/4,e],[3*i/4,3*i/4,e]],"circle"==t.pattern&&(o.circles=o.circles.concat([[i/4+i,i/4,e],[i/4,i/4+i,e],[3*i/4-i,3*i/4,e],[3*i/4,3*i/4-i,e],[i/4+i,i/4+i,e],[3*i/4-i,3*i/4-i,e]]))):(o.width=o.height=i,o.circles=[[i/2,i/2,e]],"circle"==t.pattern&&(o.circles=o.circles.concat([[i/2+i,i/2,e],[i/2-i,i/2,e],[i/2,i/2+i,e],[i/2,i/2-i,e],[i/2+i,i/2+i,e],[i/2+i,i/2-i,e],[i/2-i,i/2+i,e],[i/2-i,i/2-i,e]])));break;case"tile":case"square":e=0===t.size?0:t.size/2||2,t.angle?(o.width=o.height=i,o.lines=[[i/2-e,i/2,i/2,i/2-e,i/2+e,i/2,i/2,i/2+e,i/2-e,i/2]]):(o.width=o.height=i,o.lines=[[i/2-e,i/2-e,i/2+e,i/2-e,i/2+e,i/2+e,i/2-e,i/2+e,i/2-e,i/2-e]]),"square"==t.pattern&&(o.repeat=[[0,0],[0,i],[i,0],[0,-i],[-i,0],[-i,-i],[i,i],[-i,i],[i,-i]]);break;case"cross":t.angle&&(t.angle=45);case"hatch":var n=Math.round(((t.angle||0)-90)%360);n>180&&(n-=360),n*=Math.PI/180;var r=Math.cos(n),s=Math.sin(n);if(Math.abs(s)<1e-4)o.width=o.height=i,o.lines=[[0,.5,i,.5]],o.repeat=[[0,0],[0,i]];else if(Math.abs(r)<1e-4)o.width=o.height=i,o.lines=[[.5,0,.5,i]],o.repeat=[[0,0],[i,0]],"cross"==t.pattern&&(o.lines.push([0,.5,i,.5]),o.repeat.push([0,i]));else{var a=o.width=Math.round(Math.abs(i/s))||1,l=o.height=Math.round(Math.abs(i/r))||1;"cross"==t.pattern?(o.lines=[[-a,-l,2*a,2*l],[2*a,-l,-a,2*l]],o.repeat=[[0,0]]):r*s>0?(o.lines=[[-a,-l,2*a,2*l]],o.repeat=[[0,0],[a,0],[0,l]]):(o.lines=[[2*a,-l,-a,2*l]],o.repeat=[[0,0],[-a,0],[0,l]])}o.stroke=0===t.size?0:t.size||4}return o},ol.style.Style.defaultStyle,function(){var t=[255,255,255,1],e=[0,153,255,1],o=[new ol.style.Style({stroke:new ol.style.Stroke({color:t,width:5})}),new ol.style.Style({image:new ol.style.Circle({radius:6,fill:new ol.style.Fill({color:e}),stroke:new ol.style.Stroke({color:t,width:1.5})}),stroke:new ol.style.Stroke({color:e,width:3}),fill:new ol.style.Fill({color:[255,255,255,.5]})})];ol.style.Style.defaultStyle=function(t){if(!0===t)return o;t=t||{};var e=new ol.style.Fill({color:t.fillColor||"rgba(255,255,255,0.4)"}),i=new ol.style.Stroke({color:t.color||"#3399CC",width:1.25});return[new ol.style.Style({image:new ol.style.Circle({fill:e,stroke:i,radius:5}),fill:e,stroke:i})]}}(),ol.style.geoportailStyle,function(){var t={},e=0;function o(o){var i="ROUT-"+e+++"-";return function(e,n){var r=!0===o.sens||n<o.sens,s=i+e.get("nature")+"-"+e.get("position_par_rapport_au_sol")+"-"+(r?e.get("sens_de_circulation"):"Sans objet")+"-"+e.get("position_par_rapport_au_sol")+"-"+e.get("importance")+"-"+e.get("largeur_de_chaussee")+"-"+e.get("itineraire_vert"),a=t[s];return a||(a=t[s]=[new ol.style.Style({text:r?function(t){return o.sens&&!/double|sans/i.test(t.get("sens_de_circulation"))?new ol.style.Text({text:"Sens direct"==t.get("sens_de_circulation")?"→":"←",font:"bold 12px sans-serif",placement:"point",textAlign:"center",fill:new ol.style.Fill({color:[0,0,0,.3]}),stroke:new ol.style.Stroke({color:[0,0,0,.3],width:1.5}),rotateWithView:!0}):null}(e):null,stroke:new ol.style.Stroke({color:function(t){if(o.vert&&t.get("itineraire_vert"))return t.get("position_par_rapport_au_sol")<0?[0,128,0,.7]:t.get("position_par_rapport_au_sol")>0?[0,100,0,1]:[0,128,0,1];if(!t.get("importance"))return"magenta";if("Piste cyclable"===t.get("nature"))return[27,177,27,.5];if("0"!=t.get("position_par_rapport_au_sol")){var e;switch(t.get("importance")){case"1":e=[177,27,177,1];break;case"2":e=[177,27,27,1];break;case"3":e=[217,119,0,1];break;case"4":e=[255,225,0,1];break;case"5":e=[204,204,204,1];break;default:e=[211,211,211,1]}return t.get("position_par_rapport_au_sol")<0&&(e[3]=.7),e}switch(t.get("importance")){case"1":return[255,0,255,1];case"2":return[255,0,0,1];case"3":return[255,165,0,1];case"4":return[255,255,0,1];case"5":return[255,255,255,1];default:return[211,211,211,1]}}(e),width:function(t){return Math.max(t.get("largeur_de_chaussee")||2,2)}(e),lineDash:function(t){switch(t.get("nature")){case"Escalier":return[1,4];case"Sentier":return[8,10]}}(e)}),zIndex:function(t){if(!t.get("position_par_rapport_au_sol"))return 100;var e=Number(t.get("position_par_rapport_au_sol"));return e>0?10+10*e-(Number(t.get("importance"))||10):e<0?Math.max(4+e,0):10-(Number(t.get("importance"))||10)}(e)-100})]),a[0].getText()&&a[0].getText().setRotation(function(t){for(var e,o,i=t.getCoordinates(),n=0,r=t.getLength(),s=0;s<i.length-1&&(e=i[s+1][0]-i[s][0],o=i[s+1][1]-i[s][1],!((n+=Math.sqrt(e*e+o*o))>=r/2));s++);return-Math.atan2(o,e)}(e.getGeometry())),a}}var i={111:{color:[230,0,77,255],title:"Continuous urban fabric"},112:{color:[255,0,0,255],title:"Discontinuous urban fabric"},121:{color:[204,77,242,255],title:"Industrial or commercial units"},122:{color:[204,0,0,255],title:"Road and rail networks and associated land"},123:{color:[230,204,204,255],title:"Port areas"},124:{color:[230,204,230,255],title:"Airports"},131:{color:[166,0,204,255],title:"Mineral extraction sites"},132:{color:[166,77,0,255],title:"Dump sites"},133:{color:[255,77,255,255],title:"Construction sites"},141:{color:[255,166,255,255],title:"Green urban areas"},142:{color:[255,230,255,255],title:"Sport and leisure facilities"},211:{color:[255,255,168,255],title:"Non-irrigated arable land"},212:{color:[255,255,0,255],title:"Permanently irrigated land"},213:{color:[230,230,0,255],title:"Rice fields"},221:{color:[230,128,0,255],title:"Vineyards"},222:{color:[242,166,77,255],title:"Fruit trees and berry plantations"},223:{color:[230,166,0,255],title:"Olive groves"},231:{color:[230,230,77,255],title:"Pastures"},241:{color:[255,230,166,255],title:"Annual crops associated with permanent crops"},242:{color:[255,230,77,255],title:"Complex cultivation patterns"},243:{color:[230,204,77,255],title:"Land principally occupied by agriculture with significant areas of natural vegetation"},244:{color:[242,204,166,255],title:"Agro-forestry areas"},311:{color:[128,255,0,255],title:"Broad-leaved forest"},312:{color:[0,166,0,255],title:"Coniferous forest"},313:{color:[77,255,0,255],title:"Mixed forest"},321:{color:[204,242,77,255],title:"Natural grasslands"},322:{color:[166,255,128,255],title:"Moors and heathland"},323:{color:[166,230,77,255],title:"Sclerophyllous vegetation"},324:{color:[166,242,0,255],title:"Transitional woodland-shrub"},331:{color:[230,230,230,255],title:"Beaches dunes sands"},332:{color:[204,204,204,255],title:"Bare rocks"},333:{color:[204,255,204,255],title:"Sparsely vegetated areas"},334:{color:[0,0,0,255],title:"Burnt areas"},335:{color:[166,230,204,255],title:"Glaciers and perpetual snow"},411:{color:[166,166,255,255],title:"Inland marshes"},412:{color:[77,77,255,255],title:"Peat bogs"},421:{color:[204,204,255,255],title:"Salt marshes"},422:{color:[230,230,255,255],title:"Salines"},423:{color:[166,166,230,255],title:"Intertidal flats"},511:{color:[0,204,242,255],title:"Water courses"},512:{color:[128,242,230,255],title:"Water bodies"},521:{color:[0,255,166,255],title:"Coastal lagoons"},522:{color:[166,255,230,255],title:"Estuaries"},523:{color:[230,242,255,255],title:"Sea and ocean"}};ol.style.geoportailStyle=function(n,r){switch(r=r||{},n){case"BDTOPO_V3:troncon_de_route":return o(r);case"BDTOPO_V3:batiment":return function(o){var i="BATI-"+e+++"-";return function(e){if(e.get("detruit"))return[];var n=i+e.get("usage_1")+"-"+e.get("nature")+"-"+e.get("etat_de_l_objet"),r=t[n];if(!r){var s=function(t){switch(t.get("nature")){case"Industriel, agricole ou commercial":return[51,102,153,1];case"Remarquable":return[0,192,0,1];default:switch(t.get("usage_1")){case"Résidentiel":case"Indifférencié":return[128,128,128,1];case"Industriel":case"Commercial et services":return[51,102,153,1];case"Sportif":return[51,153,102,1];case"Religieux":return[153,102,51,1];default:return[153,51,51,1]}}}(e),a=[s[0],s[1],s[1],.5],l=!/en service/i.test(e.get("etat_de_l_objet"));l&&(a[3]=.1);var c=o.symbol?function(t){switch(t.get("usage_1")){case"Commercial et services":return"";case"Sportif":return"";default:return null}}(e):null;return[new ol.style.Style({text:c?new ol.style.Text({text:c,font:"12px FontAwesome",fill:new ol.style.Fill({color:[0,0,0,.6]})}):null,fill:new ol.style.Fill({color:a}),stroke:new ol.style.Stroke({color:s,width:1.5,lineDash:l?[5,5]:null})})]}return r}}(r);case"CADASTRALPARCELS.PARCELLAIRE_EXPRESS:parcelle":return function(t){var e=new ol.style.Style({text:new ol.style.Text({text:"0000",font:"bold 12px sans-serif",fill:new ol.style.Fill({color:[100,0,255,1]}),stroke:new ol.style.Stroke({color:[255,255,255,.8],width:3})}),stroke:new ol.style.Stroke({color:[255,165,0,1],width:1.5}),fill:new ol.style.Fill({color:[100,0,255,.1]})});return function(o,i){return i<.8?e.getText().setFont("bold 12px sans-serif"):e.getText().setFont("bold 10px sans-serif"),t.section?e.getText().setText(o.get("section")+"-"+(o.get("numero")||"").replace(/^0*/,"")):e.getText().setText((o.get("numero")||"").replace(/^0*/,"")),e}}(r);default:return/LANDCOVER/.test(n)?(r.date=n.replace(/[^\d]*(\d*).*/,"$1"),function(e){return function(o){var n=o.get("code_"+e.date),r=t["CLC-"+n];if(!r){var s=i[n].color.slice();s[3]=e.opacity||1,r=t["CLC-"+n]=new ol.style.Style({fill:new ol.style.Fill({color:s||[255,255,255,.5]})})}return r}}(r)):(console.warn("[ol/style/geoportailStyle] no style defined for type: "+n),ol.style.Style.defaultStyle())}},ol.style.geoportailStyle.clcColors=JSON.parse(JSON.stringify(i))}();