(ns laniakea-stars-bot.core
  (:require
    [clojure.string :as str]
    [himmelsstuermer.api :as hs]
    [himmelsstuermer.api.buttons :as hsb]
    [himmelsstuermer.api.texts :as hst]
    [himmelsstuermer.api.transactor :refer [transact!]]
    [himmelsstuermer.user :as hsu]))


(defn main
  [{:keys [usr msg amount] :as state}]
  (let [amount (if (some? (:text msg))
                 (try (Long/parseUnsignedLong (:text msg))
                      (catch Exception _ (or amount 100)))
                 (if (some? amount) (max 1 amount) 100))
        text (hst/txt state :main-menu/greeting-text (:user/first-name usr))]
    (hsu/set-handler state 'laniakea-stars-bot.core/main {:amount amount})
    (hs/send-message state usr text #{{:type "bold" :offset 0 :length (count text)}}
                     [[(hsb/text-btn (hst/txt state :buttons/send amount) 'pay {:amount amount})]
                      [(hsb/text-btn "➖100" 'main {:amount (- amount 100)})
                       (hsb/text-btn "➕100" 'main {:amount (+ amount 100)})]
                      [(hsb/text-btn "➖10" 'main {:amount (- amount 10)})
                       (hsb/text-btn "➕10" 'main {:amount (+ amount 10)})]
                      [(hsb/text-btn "➖1" 'main {:amount (- amount 1)})
                       (hsb/text-btn "➕1" 'main {:amount (+ amount 1)})]])))


(defn pay
  [{:keys [usr amount] :as state}]
  (hs/send-invoice state usr
                   {:title (hst/txt state :invoice/title)
                    :description (hst/txt state :invoice/description)
                    :payload (-> {:XTR amount} prn-str str/trim)
                    :provider_token "" ; Like XTR
                    :currency "XTR"
                    :prices [{:label (hst/txt state :invoice/label amount) :amount (* 100 amount)}]}
                   (hst/txt state :buttons/send amount)))


(defn payment
  [{usr :usr txs :txs {payment :successful_payment} :msg :as state}]
  (let [[currency amount] (-> payment :invoice_payload read-string first)
        uuid (random-uuid)
        main (hst/txt state :gratitude/main)
        tx (hst/txt state :gratitude/tx)
        full (str main "\n\n" tx)]
    (transact! txs [{:payment/id uuid
                     :payment/amount (bigdec amount)
                     :payment/currency currency
                     :payment/user (:db/id usr)
                     :payment/paid-on (java.util.Date.)}])
    (hs/send-message state usr (str full uuid)
                     #{{:type "bold" :offset 0 :length (count main)}
                       {:type "pre" :offset (count full) :length (count (str uuid))}}
                     [] :modal)))
