(defproject io.github.algoflora/laniakea-stars-bot "0.1.0"
  :description "Start donation and testing bot..."
  ;; :url "http://example.com/FIXME"
  :license {:name "EPL-2.0 OR GPL-2.0-or-later WITH Classpath-exception-2.0"
            :url "https://www.eclipse.org/legal/epl-2.0/"}
  :dependencies [[io.github.algoflora/himmelsstuermer "0.1.3-SNAPSHOT"]]

  :plugins [[jonase/eastwood "1.4.3"]
            [lein-ancient "1.0.0-RC3"]
            [io.taylorwood/lein-native-image "0.3.1"]]

  :native-image {:name "lambda"}

  :source-paths ["src"]
  :resource-paths ["resources"]
  :main ^:skip-aot laniakea-stars-bot.bootstrap

  :target-path "target/%s"

  :profiles {:test      {:source-paths ["src" "test"]
                         :main laniakea-stars-bot.test-runner
                         :resource-paths ["resources" "test/resources"]
                         :dependencies [[lambdaisland/kaocha "1.91.1392"
                                         :exclusions [net.incongru.watchservice/barbary-watchservice]]]
                         :jvm-opts ["-Dhimmelsstuermer.malli.instrument=true"
                                    "-Dhimmelsstuermer.profile=test"]}

             ;; :uber      {:main laniakea-stars-bot.bootstrap
             ;;             :aot [laniakea-stars-bot.bootstrap]
             ;;             :jvm-opts ["-Dclojure.compiler.direct-linking=true"]
             ;;             :uberjar-name "lanikea-stars-bot.jar"}

             ;; :uber-test {:main laniakea-stars-bot.test-runner
             ;;             :aot [laniakea-stars-bot.test-runner]
             ;;             :jvm-opts ["-Dclojure.compiler.direct-linking=true"]
             ;;             :uberjar-name "lanikea-stars-bot.jar"}

             :uberjar   {;; :main himmelsstuermer.java
                         :aot :all
                         :jvm-opts ["-Dclojure.compiler.direct-linking=true"]
                         :uberjar-name "lambda.jar"}

             :native    {:dependencies [[com.github.clj-easy/graal-build-time "1.0.5"]]
                         :jvm-opts ["-Dclojure.compiler.direct-linking=true"]}}

  :aliases {"test" ["with-profile" "+test" "run" "-m" "laniakea-stars-bot.test-runner/kaocha" "--fail-fast"]
            "aws"  ["run" "-m" "himmelsstuermer.aws/deploy!" {:lambda-name "laniakea-stars-bot"
                                                              :cluster "devel"}]})
