(ns himmelsstuermer.aws
  (:require
    [himmelsstuermer.aws.build :refer [build-image]]
    ;; [himmelsstuermer.blambda.api.terraform :refer [write-config apply!]]
    [himmelsstuermer.misc :refer [do-nanos]]))


(def default-opts
  {:arch "aarch64"
   :container-registry "himmelsstuermer"
   :tfstate-bucket "himmelsstuermer"
   :lambda-handler "lambda"
   :lambda-env-vars #{}
   :lambda-memory-size 512
   ;; :lambda-name
   ;; :cluster
   :lambda-timeout 15
   :aux-files #{}
   :target-dir "target"
   :tf-config-dir "."
   :tf-module-dir "modules"
   :work-dir ".work"})


(defn deploy!
  [opts]
  (println "Deploy started...\nUser options:" opts)
  (let [opts (merge default-opts (read-string opts))
        _ (println "Full opts: " opts)
        nsec (do-nanos (build-image opts)
                       ;; (write-config opts)
                       ;; (apply! opts)
                       )]
    (printf "Deploy finished in %.2f seconds." (* nsec 0.000000001))))
