// Compiled by ClojureScript 0.0-2727 {}
goog.provide('cljs_http.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('cljs_http.core');
goog.require('no.en.core');
goog.require('cljs_http.util');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('cljs.reader');
cljs_http.client.if_pos = (function if_pos(v){
if(cljs.core.truth_((function (){var and__3746__auto__ = v;
if(cljs.core.truth_(and__3746__auto__)){
return (v > (0));
} else {
return and__3746__auto__;
}
})())){
return v;
} else {
return null;
}
});
/**
* Parse `s` as query params and return a hash map.
*/
cljs_http.client.parse_query_params = (function parse_query_params(s){
if(cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,s))){
return cljs.core.reduce.call(null,(function (p1__15797_SHARP_,p2__15796_SHARP_){
var vec__15799 = clojure.string.split.call(null,p2__15796_SHARP_,/=/);
var k = cljs.core.nth.call(null,vec__15799,(0),null);
var v = cljs.core.nth.call(null,vec__15799,(1),null);
return cljs.core.assoc.call(null,p1__15797_SHARP_,cljs.core.keyword.call(null,no.en.core.url_decode.call(null,k)),no.en.core.url_decode.call(null,v));
}),cljs.core.PersistentArrayMap.EMPTY,clojure.string.split.call(null,[cljs.core.str(s)].join(''),/&/));
} else {
return null;
}
});
/**
* Parse `url` into a hash map.
*/
cljs_http.client.parse_url = (function parse_url(url){
if(cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,url))){
var uri = goog.Uri.parse(url);
var query_data = uri.getQueryData();
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"scheme","scheme",90199613),cljs.core.keyword.call(null,uri.getScheme()),new cljs.core.Keyword(null,"server-name","server-name",-1012104295),uri.getDomain(),new cljs.core.Keyword(null,"server-port","server-port",663745648),cljs_http.client.if_pos.call(null,uri.getPort()),new cljs.core.Keyword(null,"uri","uri",-774711847),uri.getPath(),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),((cljs.core.not.call(null,query_data.isEmpty()))?[cljs.core.str(query_data)].join(''):null),new cljs.core.Keyword(null,"query-params","query-params",900640534),((cljs.core.not.call(null,query_data.isEmpty()))?cljs_http.client.parse_query_params.call(null,[cljs.core.str(query_data)].join('')):null)], null);
} else {
return null;
}
});
cljs_http.client.unexceptional_status_QMARK_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [(205),null,(206),null,(300),null,(204),null,(307),null,(303),null,(301),null,(201),null,(302),null,(202),null,(200),null,(203),null,(207),null], null), null);
cljs_http.client.encode_val = (function encode_val(k,v){
return [cljs.core.str(no.en.core.url_encode.call(null,cljs.core.name.call(null,k))),cljs.core.str("="),cljs.core.str(no.en.core.url_encode.call(null,[cljs.core.str(v)].join('')))].join('');
});
cljs_http.client.encode_vals = (function encode_vals(k,vs){
return clojure.string.join.call(null,"&",cljs.core.map.call(null,(function (p1__15800_SHARP_){
return cljs_http.client.encode_val.call(null,k,p1__15800_SHARP_);
}),vs));
});
cljs_http.client.encode_param = (function encode_param(p__15801){
var vec__15803 = p__15801;
var k = cljs.core.nth.call(null,vec__15803,(0),null);
var v = cljs.core.nth.call(null,vec__15803,(1),null);
if(cljs.core.coll_QMARK_.call(null,v)){
return cljs_http.client.encode_vals.call(null,k,v);
} else {
return cljs_http.client.encode_val.call(null,k,v);
}
});
cljs_http.client.generate_query_string = (function generate_query_string(params){
return clojure.string.join.call(null,"&",cljs.core.map.call(null,cljs_http.client.encode_param,params));
});
cljs_http.client.regex_char_esc_smap = (function (){var esc_chars = "()*&^%$#!+";
return cljs.core.zipmap.call(null,esc_chars,cljs.core.map.call(null,((function (esc_chars){
return (function (p1__15804_SHARP_){
return [cljs.core.str("\\"),cljs.core.str(p1__15804_SHARP_)].join('');
});})(esc_chars))
,esc_chars));
})();
/**
* Escape special characters -- for content-type.
*/
cljs_http.client.escape_special = (function escape_special(string){
return cljs.core.reduce.call(null,cljs.core.str,cljs.core.replace.call(null,cljs_http.client.regex_char_esc_smap,string));
});
/**
* Decocde the :body of `response` with `decode-fn` if the content type matches.
*/
cljs_http.client.decode_body = (function decode_body(response,decode_fn,content_type,request_method){
if(cljs.core.truth_((function (){var and__3746__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"head","head",-771383919),request_method);
if(and__3746__auto__){
return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,[cljs.core.str("(?i)"),cljs.core.str(cljs_http.client.escape_special.call(null,content_type))].join('')),[cljs.core.str(cljs.core.get.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(response),"content-type",""))].join(''));
} else {
return and__3746__auto__;
}
})())){
return cljs.core.update_in.call(null,response,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"body","body",-2049205669)], null),decode_fn);
} else {
return response;
}
});
/**
* Encode :edn-params in the `request` :body and set the appropriate
* Content Type header.
*/
cljs_http.client.wrap_edn_params = (function wrap_edn_params(client){
return (function (request){
var temp__4124__auto__ = new cljs.core.Keyword(null,"edn-params","edn-params",894273052).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4124__auto__)){
var params = temp__4124__auto__;
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"edn-params","edn-params",894273052)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.pr_str.call(null,params)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"content-type"], null),"application/edn"));
} else {
return client.call(null,request);
}
});
});
/**
* Decode application/edn responses.
*/
cljs_http.client.wrap_edn_response = (function wrap_edn_response(client){
return (function (request){
var channel = cljs.core.async.chan.call(null);
var c__8178__auto___15841 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8178__auto___15841,channel){
return (function (){
var f__8179__auto__ = (function (){var switch__8163__auto__ = ((function (c__8178__auto___15841,channel){
return (function (state_15831){
var state_val_15832 = (state_15831[(1)]);
if((state_val_15832 === (2))){
var inst_15825 = (state_15831[(2)]);
var inst_15826 = new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request);
var inst_15827 = cljs_http.client.decode_body.call(null,inst_15825,cljs.reader.read_string,"application/edn",inst_15826);
var inst_15828 = cljs.core.async.put_BANG_.call(null,channel,inst_15827);
var inst_15829 = cljs.core.async.close_BANG_.call(null,channel);
var state_15831__$1 = (function (){var statearr_15833 = state_15831;
(statearr_15833[(7)] = inst_15828);

return statearr_15833;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15831__$1,inst_15829);
} else {
if((state_val_15832 === (1))){
var inst_15823 = client.call(null,request);
var state_15831__$1 = state_15831;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15831__$1,(2),inst_15823);
} else {
return null;
}
}
});})(c__8178__auto___15841,channel))
;
return ((function (switch__8163__auto__,c__8178__auto___15841,channel){
return (function() {
var state_machine__8164__auto__ = null;
var state_machine__8164__auto____0 = (function (){
var statearr_15837 = [null,null,null,null,null,null,null,null];
(statearr_15837[(0)] = state_machine__8164__auto__);

(statearr_15837[(1)] = (1));

return statearr_15837;
});
var state_machine__8164__auto____1 = (function (state_15831){
while(true){
var ret_value__8165__auto__ = (function (){try{while(true){
var result__8166__auto__ = switch__8163__auto__.call(null,state_15831);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8166__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8166__auto__;
}
break;
}
}catch (e15838){if((e15838 instanceof Object)){
var ex__8167__auto__ = e15838;
var statearr_15839_15842 = state_15831;
(statearr_15839_15842[(5)] = ex__8167__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15831);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15838;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8165__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15843 = state_15831;
state_15831 = G__15843;
continue;
} else {
return ret_value__8165__auto__;
}
break;
}
});
state_machine__8164__auto__ = function(state_15831){
switch(arguments.length){
case 0:
return state_machine__8164__auto____0.call(this);
case 1:
return state_machine__8164__auto____1.call(this,state_15831);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__8164__auto____0;
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__8164__auto____1;
return state_machine__8164__auto__;
})()
;})(switch__8163__auto__,c__8178__auto___15841,channel))
})();
var state__8180__auto__ = (function (){var statearr_15840 = f__8179__auto__.call(null);
(statearr_15840[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8178__auto___15841);

return statearr_15840;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8180__auto__);
});})(c__8178__auto___15841,channel))
);


return channel;
});
});
/**
* @param {...*} var_args
*/
cljs_http.client.wrap_accept = (function() { 
var wrap_accept__delegate = function (client,p__15844){
var vec__15846 = p__15844;
var accept = cljs.core.nth.call(null,vec__15846,(0),null);
return ((function (vec__15846,accept){
return (function (request){
var temp__4124__auto__ = (function (){var or__3758__auto__ = new cljs.core.Keyword(null,"accept","accept",1874130431).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return accept;
}
})();
if(cljs.core.truth_(temp__4124__auto__)){
var accept__$1 = temp__4124__auto__;
return client.call(null,cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"accept"], null),accept__$1));
} else {
return client.call(null,request);
}
});
;})(vec__15846,accept))
};
var wrap_accept = function (client,var_args){
var p__15844 = null;
if (arguments.length > 1) {
var G__15847__i = 0, G__15847__a = new Array(arguments.length -  1);
while (G__15847__i < G__15847__a.length) {G__15847__a[G__15847__i] = arguments[G__15847__i + 1]; ++G__15847__i;}
  p__15844 = new cljs.core.IndexedSeq(G__15847__a,0);
} 
return wrap_accept__delegate.call(this,client,p__15844);};
wrap_accept.cljs$lang$maxFixedArity = 1;
wrap_accept.cljs$lang$applyTo = (function (arglist__15848){
var client = cljs.core.first(arglist__15848);
var p__15844 = cljs.core.rest(arglist__15848);
return wrap_accept__delegate(client,p__15844);
});
wrap_accept.cljs$core$IFn$_invoke$arity$variadic = wrap_accept__delegate;
return wrap_accept;
})()
;
/**
* @param {...*} var_args
*/
cljs_http.client.wrap_content_type = (function() { 
var wrap_content_type__delegate = function (client,p__15849){
var vec__15851 = p__15849;
var content_type = cljs.core.nth.call(null,vec__15851,(0),null);
return ((function (vec__15851,content_type){
return (function (request){
var temp__4124__auto__ = (function (){var or__3758__auto__ = new cljs.core.Keyword(null,"content-type","content-type",-508222634).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return content_type;
}
})();
if(cljs.core.truth_(temp__4124__auto__)){
var content_type__$1 = temp__4124__auto__;
return client.call(null,cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"content-type"], null),content_type__$1));
} else {
return client.call(null,request);
}
});
;})(vec__15851,content_type))
};
var wrap_content_type = function (client,var_args){
var p__15849 = null;
if (arguments.length > 1) {
var G__15852__i = 0, G__15852__a = new Array(arguments.length -  1);
while (G__15852__i < G__15852__a.length) {G__15852__a[G__15852__i] = arguments[G__15852__i + 1]; ++G__15852__i;}
  p__15849 = new cljs.core.IndexedSeq(G__15852__a,0);
} 
return wrap_content_type__delegate.call(this,client,p__15849);};
wrap_content_type.cljs$lang$maxFixedArity = 1;
wrap_content_type.cljs$lang$applyTo = (function (arglist__15853){
var client = cljs.core.first(arglist__15853);
var p__15849 = cljs.core.rest(arglist__15853);
return wrap_content_type__delegate(client,p__15849);
});
wrap_content_type.cljs$core$IFn$_invoke$arity$variadic = wrap_content_type__delegate;
return wrap_content_type;
})()
;
cljs_http.client.default_transit_opts = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"encoding","encoding",1728578272),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"encoding-opts","encoding-opts",-1805664631),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"decoding","decoding",-568180903),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"decoding-opts","decoding-opts",1050289140),cljs.core.PersistentArrayMap.EMPTY], null);
/**
* Encode :transit-params in the `request` :body and set the appropriate
* Content Type header.
* 
* A :transit-opts map can be optionally provided with the following keys:
* 
* :encoding                #{:json, :json-verbose}
* :decoding                #{:json, :json-verbose}
* :encoding/decoding-opts  appropriate map of options to be passed to
* transit writer/reader, respectively.
*/
cljs_http.client.wrap_transit_params = (function wrap_transit_params(client){
return (function (request){
var temp__4124__auto__ = new cljs.core.Keyword(null,"transit-params","transit-params",357261095).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4124__auto__)){
var params = temp__4124__auto__;
var map__15855 = cljs.core.merge.call(null,cljs_http.client.default_transit_opts,new cljs.core.Keyword(null,"transit-opts","transit-opts",1104386010).cljs$core$IFn$_invoke$arity$1(request));
var map__15855__$1 = ((cljs.core.seq_QMARK_.call(null,map__15855))?cljs.core.apply.call(null,cljs.core.hash_map,map__15855):map__15855);
var encoding_opts = cljs.core.get.call(null,map__15855__$1,new cljs.core.Keyword(null,"encoding-opts","encoding-opts",-1805664631));
var encoding = cljs.core.get.call(null,map__15855__$1,new cljs.core.Keyword(null,"encoding","encoding",1728578272));
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"transit-params","transit-params",357261095)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.util.transit_encode.call(null,params,encoding,encoding_opts)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"content-type"], null),"application/transit+json"));
} else {
return client.call(null,request);
}
});
});
/**
* Decode application/transit+json responses.
*/
cljs_http.client.wrap_transit_response = (function wrap_transit_response(client){
return (function (request){
var channel = cljs.core.async.chan.call(null);
var map__15877 = cljs.core.merge.call(null,cljs_http.client.default_transit_opts,new cljs.core.Keyword(null,"transit-opts","transit-opts",1104386010).cljs$core$IFn$_invoke$arity$1(request));
var map__15877__$1 = ((cljs.core.seq_QMARK_.call(null,map__15877))?cljs.core.apply.call(null,cljs.core.hash_map,map__15877):map__15877);
var decoding_opts = cljs.core.get.call(null,map__15877__$1,new cljs.core.Keyword(null,"decoding-opts","decoding-opts",1050289140));
var decoding = cljs.core.get.call(null,map__15877__$1,new cljs.core.Keyword(null,"decoding","decoding",-568180903));
var c__8178__auto___15897 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8178__auto___15897,channel,map__15877,map__15877__$1,decoding_opts,decoding){
return (function (){
var f__8179__auto__ = (function (){var switch__8163__auto__ = ((function (c__8178__auto___15897,channel,map__15877,map__15877__$1,decoding_opts,decoding){
return (function (state_15887){
var state_val_15888 = (state_15887[(1)]);
if((state_val_15888 === (2))){
var inst_15880 = (state_15887[(2)]);
var inst_15881 = (function (){var response = inst_15880;
return ((function (response,inst_15880,state_val_15888,c__8178__auto___15897,channel,map__15877,map__15877__$1,decoding_opts,decoding){
return (function (p1__15856_SHARP_){
return cljs_http.util.transit_decode.call(null,p1__15856_SHARP_,decoding,decoding_opts);
});
;})(response,inst_15880,state_val_15888,c__8178__auto___15897,channel,map__15877,map__15877__$1,decoding_opts,decoding))
})();
var inst_15882 = new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request);
var inst_15883 = cljs_http.client.decode_body.call(null,inst_15880,inst_15881,"application/transit+json",inst_15882);
var inst_15884 = cljs.core.async.put_BANG_.call(null,channel,inst_15883);
var inst_15885 = cljs.core.async.close_BANG_.call(null,channel);
var state_15887__$1 = (function (){var statearr_15889 = state_15887;
(statearr_15889[(7)] = inst_15884);

return statearr_15889;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15887__$1,inst_15885);
} else {
if((state_val_15888 === (1))){
var inst_15878 = client.call(null,request);
var state_15887__$1 = state_15887;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15887__$1,(2),inst_15878);
} else {
return null;
}
}
});})(c__8178__auto___15897,channel,map__15877,map__15877__$1,decoding_opts,decoding))
;
return ((function (switch__8163__auto__,c__8178__auto___15897,channel,map__15877,map__15877__$1,decoding_opts,decoding){
return (function() {
var state_machine__8164__auto__ = null;
var state_machine__8164__auto____0 = (function (){
var statearr_15893 = [null,null,null,null,null,null,null,null];
(statearr_15893[(0)] = state_machine__8164__auto__);

(statearr_15893[(1)] = (1));

return statearr_15893;
});
var state_machine__8164__auto____1 = (function (state_15887){
while(true){
var ret_value__8165__auto__ = (function (){try{while(true){
var result__8166__auto__ = switch__8163__auto__.call(null,state_15887);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8166__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8166__auto__;
}
break;
}
}catch (e15894){if((e15894 instanceof Object)){
var ex__8167__auto__ = e15894;
var statearr_15895_15898 = state_15887;
(statearr_15895_15898[(5)] = ex__8167__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15887);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15894;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8165__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15899 = state_15887;
state_15887 = G__15899;
continue;
} else {
return ret_value__8165__auto__;
}
break;
}
});
state_machine__8164__auto__ = function(state_15887){
switch(arguments.length){
case 0:
return state_machine__8164__auto____0.call(this);
case 1:
return state_machine__8164__auto____1.call(this,state_15887);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__8164__auto____0;
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__8164__auto____1;
return state_machine__8164__auto__;
})()
;})(switch__8163__auto__,c__8178__auto___15897,channel,map__15877,map__15877__$1,decoding_opts,decoding))
})();
var state__8180__auto__ = (function (){var statearr_15896 = f__8179__auto__.call(null);
(statearr_15896[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8178__auto___15897);

return statearr_15896;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8180__auto__);
});})(c__8178__auto___15897,channel,map__15877,map__15877__$1,decoding_opts,decoding))
);


return channel;
});
});
/**
* Encode :json-params in the `request` :body and set the appropriate
* Content Type header.
*/
cljs_http.client.wrap_json_params = (function wrap_json_params(client){
return (function (request){
var temp__4124__auto__ = new cljs.core.Keyword(null,"json-params","json-params",-1112693596).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4124__auto__)){
var params = temp__4124__auto__;
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"json-params","json-params",-1112693596)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.util.json_encode.call(null,params)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"content-type"], null),"application/json"));
} else {
return client.call(null,request);
}
});
});
/**
* Decode application/json responses.
*/
cljs_http.client.wrap_json_response = (function wrap_json_response(client){
return (function (request){
var channel = cljs.core.async.chan.call(null);
var c__8178__auto___15936 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8178__auto___15936,channel){
return (function (){
var f__8179__auto__ = (function (){var switch__8163__auto__ = ((function (c__8178__auto___15936,channel){
return (function (state_15926){
var state_val_15927 = (state_15926[(1)]);
if((state_val_15927 === (2))){
var inst_15920 = (state_15926[(2)]);
var inst_15921 = new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request);
var inst_15922 = cljs_http.client.decode_body.call(null,inst_15920,cljs_http.util.json_decode,"application/json",inst_15921);
var inst_15923 = cljs.core.async.put_BANG_.call(null,channel,inst_15922);
var inst_15924 = cljs.core.async.close_BANG_.call(null,channel);
var state_15926__$1 = (function (){var statearr_15928 = state_15926;
(statearr_15928[(7)] = inst_15923);

return statearr_15928;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15926__$1,inst_15924);
} else {
if((state_val_15927 === (1))){
var inst_15918 = client.call(null,request);
var state_15926__$1 = state_15926;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15926__$1,(2),inst_15918);
} else {
return null;
}
}
});})(c__8178__auto___15936,channel))
;
return ((function (switch__8163__auto__,c__8178__auto___15936,channel){
return (function() {
var state_machine__8164__auto__ = null;
var state_machine__8164__auto____0 = (function (){
var statearr_15932 = [null,null,null,null,null,null,null,null];
(statearr_15932[(0)] = state_machine__8164__auto__);

(statearr_15932[(1)] = (1));

return statearr_15932;
});
var state_machine__8164__auto____1 = (function (state_15926){
while(true){
var ret_value__8165__auto__ = (function (){try{while(true){
var result__8166__auto__ = switch__8163__auto__.call(null,state_15926);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8166__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8166__auto__;
}
break;
}
}catch (e15933){if((e15933 instanceof Object)){
var ex__8167__auto__ = e15933;
var statearr_15934_15937 = state_15926;
(statearr_15934_15937[(5)] = ex__8167__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15926);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15933;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8165__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15938 = state_15926;
state_15926 = G__15938;
continue;
} else {
return ret_value__8165__auto__;
}
break;
}
});
state_machine__8164__auto__ = function(state_15926){
switch(arguments.length){
case 0:
return state_machine__8164__auto____0.call(this);
case 1:
return state_machine__8164__auto____1.call(this,state_15926);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__8164__auto____0;
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__8164__auto____1;
return state_machine__8164__auto__;
})()
;})(switch__8163__auto__,c__8178__auto___15936,channel))
})();
var state__8180__auto__ = (function (){var statearr_15935 = f__8179__auto__.call(null);
(statearr_15935[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8178__auto___15936);

return statearr_15935;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8180__auto__);
});})(c__8178__auto___15936,channel))
);


return channel;
});
});
cljs_http.client.wrap_query_params = (function wrap_query_params(client){
return (function (p__15941){
var map__15942 = p__15941;
var map__15942__$1 = ((cljs.core.seq_QMARK_.call(null,map__15942))?cljs.core.apply.call(null,cljs.core.hash_map,map__15942):map__15942);
var req = map__15942__$1;
var query_params = cljs.core.get.call(null,map__15942__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
if(cljs.core.truth_(query_params)){
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"query-params","query-params",900640534)),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),cljs_http.client.generate_query_string.call(null,query_params)));
} else {
return client.call(null,req);
}
});
});
cljs_http.client.wrap_form_params = (function wrap_form_params(client){
return (function (p__15945){
var map__15946 = p__15945;
var map__15946__$1 = ((cljs.core.seq_QMARK_.call(null,map__15946))?cljs.core.apply.call(null,cljs.core.hash_map,map__15946):map__15946);
var request = map__15946__$1;
var request_method = cljs.core.get.call(null,map__15946__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
var form_params = cljs.core.get.call(null,map__15946__$1,new cljs.core.Keyword(null,"form-params","form-params",1884296467));
if(cljs.core.truth_((function (){var and__3746__auto__ = form_params;
if(cljs.core.truth_(and__3746__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"patch","patch",380775109),null,new cljs.core.Keyword(null,"delete","delete",-1768633620),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"put","put",1299772570),null], null), null).call(null,request_method);
} else {
return and__3746__auto__;
}
})())){
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"form-params","form-params",1884296467)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.client.generate_query_string.call(null,form_params)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"content-type"], null),"application/x-www-form-urlencoded"));
} else {
return client.call(null,request);
}
});
});
cljs_http.client.wrap_android_cors_bugfix = (function wrap_android_cors_bugfix(client){
return (function (request){
return client.call(null,(cljs.core.truth_(cljs_http.util.android_QMARK_.call(null))?cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query-params","query-params",900640534),new cljs.core.Keyword(null,"android","android",-2084094573)], null),Math.random.call(null)):request));
});
});
cljs_http.client.wrap_method = (function wrap_method(client){
return (function (req){
var temp__4124__auto__ = new cljs.core.Keyword(null,"method","method",55703592).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4124__auto__)){
var m = temp__4124__auto__;
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"method","method",55703592)),new cljs.core.Keyword(null,"request-method","request-method",1764796830),m));
} else {
return client.call(null,req);
}
});
});
cljs_http.client.wrap_server_name = (function wrap_server_name(client,server_name){
return (function (p1__15947_SHARP_){
return client.call(null,cljs.core.assoc.call(null,p1__15947_SHARP_,new cljs.core.Keyword(null,"server-name","server-name",-1012104295),server_name));
});
});
cljs_http.client.wrap_url = (function wrap_url(client){
return (function (p__15951){
var map__15952 = p__15951;
var map__15952__$1 = ((cljs.core.seq_QMARK_.call(null,map__15952))?cljs.core.apply.call(null,cljs.core.hash_map,map__15952):map__15952);
var req = map__15952__$1;
var query_params = cljs.core.get.call(null,map__15952__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
var temp__4124__auto__ = cljs_http.client.parse_url.call(null,new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(req));
if(cljs.core.truth_(temp__4124__auto__)){
var spec = temp__4124__auto__;
return client.call(null,cljs.core.update_in.call(null,cljs.core.dissoc.call(null,cljs.core.merge.call(null,req,spec),new cljs.core.Keyword(null,"url","url",276297046)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query-params","query-params",900640534)], null),((function (spec,temp__4124__auto__,map__15952,map__15952__$1,req,query_params){
return (function (p1__15948_SHARP_){
return cljs.core.merge.call(null,p1__15948_SHARP_,query_params);
});})(spec,temp__4124__auto__,map__15952,map__15952__$1,req,query_params))
));
} else {
return client.call(null,req);
}
});
});
/**
* Middleware converting the :basic-auth option or `credentials` into
* an Authorization header.
* @param {...*} var_args
*/
cljs_http.client.wrap_basic_auth = (function() { 
var wrap_basic_auth__delegate = function (client,p__15953){
var vec__15955 = p__15953;
var credentials = cljs.core.nth.call(null,vec__15955,(0),null);
return ((function (vec__15955,credentials){
return (function (req){
var credentials__$1 = (function (){var or__3758__auto__ = new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return credentials;
}
})();
if(!(cljs.core.empty_QMARK_.call(null,credentials__$1))){
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"authorization"], null),cljs_http.util.basic_auth.call(null,credentials__$1)));
} else {
return client.call(null,req);
}
});
;})(vec__15955,credentials))
};
var wrap_basic_auth = function (client,var_args){
var p__15953 = null;
if (arguments.length > 1) {
var G__15956__i = 0, G__15956__a = new Array(arguments.length -  1);
while (G__15956__i < G__15956__a.length) {G__15956__a[G__15956__i] = arguments[G__15956__i + 1]; ++G__15956__i;}
  p__15953 = new cljs.core.IndexedSeq(G__15956__a,0);
} 
return wrap_basic_auth__delegate.call(this,client,p__15953);};
wrap_basic_auth.cljs$lang$maxFixedArity = 1;
wrap_basic_auth.cljs$lang$applyTo = (function (arglist__15957){
var client = cljs.core.first(arglist__15957);
var p__15953 = cljs.core.rest(arglist__15957);
return wrap_basic_auth__delegate(client,p__15953);
});
wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic = wrap_basic_auth__delegate;
return wrap_basic_auth;
})()
;
/**
* Middleware converting the :oauth-token option into an Authorization header.
*/
cljs_http.client.wrap_oauth = (function wrap_oauth(client){
return (function (req){
var temp__4124__auto__ = new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4124__auto__)){
var oauth_token = temp__4124__auto__;
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"authorization"], null),[cljs.core.str("Bearer "),cljs.core.str(oauth_token)].join('')));
} else {
return client.call(null,req);
}
});
});
/**
* Returns a batteries-included HTTP request function coresponding to the given
* core client. See client/client.
*/
cljs_http.client.wrap_request = (function wrap_request(request){
return cljs_http.client.wrap_url.call(null,cljs_http.client.wrap_method.call(null,cljs_http.client.wrap_android_cors_bugfix.call(null,cljs_http.client.wrap_oauth.call(null,cljs_http.client.wrap_basic_auth.call(null,cljs_http.client.wrap_query_params.call(null,cljs_http.client.wrap_json_response.call(null,cljs_http.client.wrap_json_params.call(null,cljs_http.client.wrap_transit_response.call(null,cljs_http.client.wrap_transit_params.call(null,cljs_http.client.wrap_edn_response.call(null,cljs_http.client.wrap_edn_params.call(null,cljs_http.client.wrap_content_type.call(null,cljs_http.client.wrap_form_params.call(null,cljs_http.client.wrap_accept.call(null,request)))))))))))))));
});
/**
* Executes the HTTP request corresponding to the given map and returns the
* response map for corresponding to the resulting HTTP response.
* 
* In addition to the standard Ring request keys, the following keys are also
* recognized:
* * :url
* * :method
* * :query-params
*/
cljs_http.client.request = cljs_http.client.wrap_request.call(null,cljs_http.core.request);
/**
* Like #'request, but sets the :method and :url as appropriate.
* @param {...*} var_args
*/
cljs_http.client.delete$ = (function() { 
var delete$__delegate = function (url,p__15958){
var vec__15960 = p__15958;
var req = cljs.core.nth.call(null,vec__15960,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"delete","delete",-1768633620),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
};
var delete$ = function (url,var_args){
var p__15958 = null;
if (arguments.length > 1) {
var G__15961__i = 0, G__15961__a = new Array(arguments.length -  1);
while (G__15961__i < G__15961__a.length) {G__15961__a[G__15961__i] = arguments[G__15961__i + 1]; ++G__15961__i;}
  p__15958 = new cljs.core.IndexedSeq(G__15961__a,0);
} 
return delete$__delegate.call(this,url,p__15958);};
delete$.cljs$lang$maxFixedArity = 1;
delete$.cljs$lang$applyTo = (function (arglist__15962){
var url = cljs.core.first(arglist__15962);
var p__15958 = cljs.core.rest(arglist__15962);
return delete$__delegate(url,p__15958);
});
delete$.cljs$core$IFn$_invoke$arity$variadic = delete$__delegate;
return delete$;
})()
;
/**
* Like #'request, but sets the :method and :url as appropriate.
* @param {...*} var_args
*/
cljs_http.client.get = (function() { 
var get__delegate = function (url,p__15963){
var vec__15965 = p__15963;
var req = cljs.core.nth.call(null,vec__15965,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"get","get",1683182755),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
};
var get = function (url,var_args){
var p__15963 = null;
if (arguments.length > 1) {
var G__15966__i = 0, G__15966__a = new Array(arguments.length -  1);
while (G__15966__i < G__15966__a.length) {G__15966__a[G__15966__i] = arguments[G__15966__i + 1]; ++G__15966__i;}
  p__15963 = new cljs.core.IndexedSeq(G__15966__a,0);
} 
return get__delegate.call(this,url,p__15963);};
get.cljs$lang$maxFixedArity = 1;
get.cljs$lang$applyTo = (function (arglist__15967){
var url = cljs.core.first(arglist__15967);
var p__15963 = cljs.core.rest(arglist__15967);
return get__delegate(url,p__15963);
});
get.cljs$core$IFn$_invoke$arity$variadic = get__delegate;
return get;
})()
;
/**
* Like #'request, but sets the :method and :url as appropriate.
* @param {...*} var_args
*/
cljs_http.client.head = (function() { 
var head__delegate = function (url,p__15968){
var vec__15970 = p__15968;
var req = cljs.core.nth.call(null,vec__15970,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"head","head",-771383919),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
};
var head = function (url,var_args){
var p__15968 = null;
if (arguments.length > 1) {
var G__15971__i = 0, G__15971__a = new Array(arguments.length -  1);
while (G__15971__i < G__15971__a.length) {G__15971__a[G__15971__i] = arguments[G__15971__i + 1]; ++G__15971__i;}
  p__15968 = new cljs.core.IndexedSeq(G__15971__a,0);
} 
return head__delegate.call(this,url,p__15968);};
head.cljs$lang$maxFixedArity = 1;
head.cljs$lang$applyTo = (function (arglist__15972){
var url = cljs.core.first(arglist__15972);
var p__15968 = cljs.core.rest(arglist__15972);
return head__delegate(url,p__15968);
});
head.cljs$core$IFn$_invoke$arity$variadic = head__delegate;
return head;
})()
;
/**
* Like #'request, but sets the :method and :url as appropriate.
* @param {...*} var_args
*/
cljs_http.client.move = (function() { 
var move__delegate = function (url,p__15973){
var vec__15975 = p__15973;
var req = cljs.core.nth.call(null,vec__15975,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"move","move",-2110884309),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
};
var move = function (url,var_args){
var p__15973 = null;
if (arguments.length > 1) {
var G__15976__i = 0, G__15976__a = new Array(arguments.length -  1);
while (G__15976__i < G__15976__a.length) {G__15976__a[G__15976__i] = arguments[G__15976__i + 1]; ++G__15976__i;}
  p__15973 = new cljs.core.IndexedSeq(G__15976__a,0);
} 
return move__delegate.call(this,url,p__15973);};
move.cljs$lang$maxFixedArity = 1;
move.cljs$lang$applyTo = (function (arglist__15977){
var url = cljs.core.first(arglist__15977);
var p__15973 = cljs.core.rest(arglist__15977);
return move__delegate(url,p__15973);
});
move.cljs$core$IFn$_invoke$arity$variadic = move__delegate;
return move;
})()
;
/**
* Like #'request, but sets the :method and :url as appropriate.
* @param {...*} var_args
*/
cljs_http.client.options = (function() { 
var options__delegate = function (url,p__15978){
var vec__15980 = p__15978;
var req = cljs.core.nth.call(null,vec__15980,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
};
var options = function (url,var_args){
var p__15978 = null;
if (arguments.length > 1) {
var G__15981__i = 0, G__15981__a = new Array(arguments.length -  1);
while (G__15981__i < G__15981__a.length) {G__15981__a[G__15981__i] = arguments[G__15981__i + 1]; ++G__15981__i;}
  p__15978 = new cljs.core.IndexedSeq(G__15981__a,0);
} 
return options__delegate.call(this,url,p__15978);};
options.cljs$lang$maxFixedArity = 1;
options.cljs$lang$applyTo = (function (arglist__15982){
var url = cljs.core.first(arglist__15982);
var p__15978 = cljs.core.rest(arglist__15982);
return options__delegate(url,p__15978);
});
options.cljs$core$IFn$_invoke$arity$variadic = options__delegate;
return options;
})()
;
/**
* Like #'request, but sets the :method and :url as appropriate.
* @param {...*} var_args
*/
cljs_http.client.patch = (function() { 
var patch__delegate = function (url,p__15983){
var vec__15985 = p__15983;
var req = cljs.core.nth.call(null,vec__15985,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"patch","patch",380775109),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
};
var patch = function (url,var_args){
var p__15983 = null;
if (arguments.length > 1) {
var G__15986__i = 0, G__15986__a = new Array(arguments.length -  1);
while (G__15986__i < G__15986__a.length) {G__15986__a[G__15986__i] = arguments[G__15986__i + 1]; ++G__15986__i;}
  p__15983 = new cljs.core.IndexedSeq(G__15986__a,0);
} 
return patch__delegate.call(this,url,p__15983);};
patch.cljs$lang$maxFixedArity = 1;
patch.cljs$lang$applyTo = (function (arglist__15987){
var url = cljs.core.first(arglist__15987);
var p__15983 = cljs.core.rest(arglist__15987);
return patch__delegate(url,p__15983);
});
patch.cljs$core$IFn$_invoke$arity$variadic = patch__delegate;
return patch;
})()
;
/**
* Like #'request, but sets the :method and :url as appropriate.
* @param {...*} var_args
*/
cljs_http.client.post = (function() { 
var post__delegate = function (url,p__15988){
var vec__15990 = p__15988;
var req = cljs.core.nth.call(null,vec__15990,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
};
var post = function (url,var_args){
var p__15988 = null;
if (arguments.length > 1) {
var G__15991__i = 0, G__15991__a = new Array(arguments.length -  1);
while (G__15991__i < G__15991__a.length) {G__15991__a[G__15991__i] = arguments[G__15991__i + 1]; ++G__15991__i;}
  p__15988 = new cljs.core.IndexedSeq(G__15991__a,0);
} 
return post__delegate.call(this,url,p__15988);};
post.cljs$lang$maxFixedArity = 1;
post.cljs$lang$applyTo = (function (arglist__15992){
var url = cljs.core.first(arglist__15992);
var p__15988 = cljs.core.rest(arglist__15992);
return post__delegate(url,p__15988);
});
post.cljs$core$IFn$_invoke$arity$variadic = post__delegate;
return post;
})()
;
/**
* Like #'request, but sets the :method and :url as appropriate.
* @param {...*} var_args
*/
cljs_http.client.put = (function() { 
var put__delegate = function (url,p__15993){
var vec__15995 = p__15993;
var req = cljs.core.nth.call(null,vec__15995,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"put","put",1299772570),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
};
var put = function (url,var_args){
var p__15993 = null;
if (arguments.length > 1) {
var G__15996__i = 0, G__15996__a = new Array(arguments.length -  1);
while (G__15996__i < G__15996__a.length) {G__15996__a[G__15996__i] = arguments[G__15996__i + 1]; ++G__15996__i;}
  p__15993 = new cljs.core.IndexedSeq(G__15996__a,0);
} 
return put__delegate.call(this,url,p__15993);};
put.cljs$lang$maxFixedArity = 1;
put.cljs$lang$applyTo = (function (arglist__15997){
var url = cljs.core.first(arglist__15997);
var p__15993 = cljs.core.rest(arglist__15997);
return put__delegate(url,p__15993);
});
put.cljs$core$IFn$_invoke$arity$variadic = put__delegate;
return put;
})()
;

//# sourceMappingURL=client.js.map