// Compiled by ClojureScript 0.0-2727 {:static-fns true}
goog.provide('cljs.core');
goog.require('goog.string.StringBuffer');
goog.require('goog.array');
goog.require('goog.object');
goog.require('goog.string');
cljs.core._STAR_clojurescript_version_STAR_ = "0.0-2727";
cljs.core._STAR_unchecked_if_STAR_ = false;
if(typeof cljs.core._STAR_print_fn_STAR_ !== 'undefined'){
} else {
/**
* Each runtime environment provides a different way to print output.
* Whatever function *print-fn* is bound to will be passed any
* Strings which should be printed.
*/
cljs.core._STAR_print_fn_STAR_ = (function _STAR_print_fn_STAR_(_){
throw (new Error("No *print-fn* fn set for evaluation environment"));
});
}
/**
* Set *print-fn* to f.
*/
cljs.core.set_print_fn_BANG_ = (function set_print_fn_BANG_(f){
return cljs.core._STAR_print_fn_STAR_ = f;
});
cljs.core._STAR_flush_on_newline_STAR_ = true;
cljs.core._STAR_print_newline_STAR_ = true;
cljs.core._STAR_print_readably_STAR_ = true;
cljs.core._STAR_print_meta_STAR_ = false;
cljs.core._STAR_print_dup_STAR_ = false;
cljs.core._STAR_print_length_STAR_ = null;
cljs.core._STAR_print_level_STAR_ = null;
if(typeof cljs.core._STAR_loaded_libs_STAR_ !== 'undefined'){
} else {
cljs.core._STAR_loaded_libs_STAR_ = null;
}
cljs.core.pr_opts = (function pr_opts(){
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"flush-on-newline","flush-on-newline",-151457939),cljs.core._STAR_flush_on_newline_STAR_,new cljs.core.Keyword(null,"readably","readably",1129599760),cljs.core._STAR_print_readably_STAR_,new cljs.core.Keyword(null,"meta","meta",1499536964),cljs.core._STAR_print_meta_STAR_,new cljs.core.Keyword(null,"dup","dup",556298533),cljs.core._STAR_print_dup_STAR_,new cljs.core.Keyword(null,"print-length","print-length",1931866356),cljs.core._STAR_print_length_STAR_], null);
});
/**
* Set *print-fn* to console.log
*/
cljs.core.enable_console_print_BANG_ = (function enable_console_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

return cljs.core._STAR_print_fn_STAR_ = (function() { 
var G__7480__delegate = function (args){
return console.log.apply(console,(function (){var G__7479 = args;
return (cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(G__7479) : cljs.core.into_array.call(null,G__7479));
})());
};
var G__7480 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__7481__i = 0, G__7481__a = new Array(arguments.length -  0);
while (G__7481__i < G__7481__a.length) {G__7481__a[G__7481__i] = arguments[G__7481__i + 0]; ++G__7481__i;}
  args = new cljs.core.IndexedSeq(G__7481__a,0);
} 
return G__7480__delegate.call(this,args);};
G__7480.cljs$lang$maxFixedArity = 0;
G__7480.cljs$lang$applyTo = (function (arglist__7482){
var args = cljs.core.seq(arglist__7482);
return G__7480__delegate(args);
});
G__7480.cljs$core$IFn$_invoke$arity$variadic = G__7480__delegate;
return G__7480;
})()
;
});
/**
* Internal - do not use!
*/
cljs.core.truth_ = (function truth_(x){
return (x != null && x !== false);
});
cljs.core.not_native = null;

/**
* Tests if 2 arguments are the same object
*/
cljs.core.identical_QMARK_ = (function identical_QMARK_(x,y){
return (x === y);
});
/**
* Returns true if x is nil, false otherwise.
*/
cljs.core.nil_QMARK_ = (function nil_QMARK_(x){
return (x == null);
});
cljs.core.array_QMARK_ = (function array_QMARK_(x){
return x instanceof Array;
});
cljs.core.number_QMARK_ = (function number_QMARK_(n){
return typeof n === 'number';
});
/**
* Returns true if x is logical false, false otherwise.
*/
cljs.core.not = (function not(x){
if(cljs.core.truth_(x)){
return false;
} else {
return true;
}
});
/**
* Returns true if x is not nil, false otherwise.
*/
cljs.core.some_QMARK_ = (function some_QMARK_(x){
return !((x == null));
});
cljs.core.object_QMARK_ = (function object_QMARK_(x){
if(!((x == null))){
return (x.constructor === Object);
} else {
return false;
}
});
cljs.core.string_QMARK_ = (function string_QMARK_(x){
var G__7484 = x;
return goog.isString(G__7484);
});
/**
* Internal - do not use!
*/
cljs.core.native_satisfies_QMARK_ = (function native_satisfies_QMARK_(p,x){
var x__$1 = (((x == null))?null:x);
if((p[(function (){var G__7486 = x__$1;
return goog.typeOf(G__7486);
})()])){
return true;
} else {
if((p["_"])){
return true;
} else {
return false;

}
}
});
cljs.core.is_proto_ = (function is_proto_(x){
return (x.constructor.prototype === x);
});
/**
* When compiled for a command-line target, whatever
* function *main-fn* is set to will be called with the command-line
* argv as arguments
*/
cljs.core._STAR_main_cli_fn_STAR_ = null;
cljs.core.type = (function type(x){
if((x == null)){
return null;
} else {
return x.constructor;
}
});
cljs.core.missing_protocol = (function missing_protocol(proto,obj){
var ty = cljs.core.type(obj);
var ty__$1 = (cljs.core.truth_((function (){var and__3746__auto__ = ty;
if(cljs.core.truth_(and__3746__auto__)){
return ty.cljs$lang$type;
} else {
return and__3746__auto__;
}
})())?ty.cljs$lang$ctorStr:(function (){var G__7488 = obj;
return goog.typeOf(G__7488);
})());
return (new Error(["No protocol method ",proto," defined for type ",ty__$1,": ",obj].join("")));
});
cljs.core.type__GT_str = (function type__GT_str(ty){
var temp__4124__auto__ = ty.cljs$lang$ctorStr;
if(cljs.core.truth_(temp__4124__auto__)){
var s = temp__4124__auto__;
return s;
} else {
return [cljs.core.str(ty)].join('');
}
});
cljs.core.load_file = (function load_file(file){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
return goog.importScript_(file);
}
});
if((typeof Symbol !== 'undefined') && (((function (){var G__7490 = Symbol;
return goog.typeOf(G__7490);
})() === "function"))){
cljs.core.ITER_SYMBOL = Symbol.iterator;
} else {
cljs.core.ITER_SYMBOL = "@@iterator";
}
cljs.core.make_array = (function() {
var make_array = null;
var make_array__1 = (function (size){
return (new Array(size));
});
var make_array__2 = (function (type,size){
return make_array.cljs$core$IFn$_invoke$arity$1(size);
});
make_array = function(type,size){
switch(arguments.length){
case 1:
return make_array__1.call(this,type);
case 2:
return make_array__2.call(this,type,size);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
make_array.cljs$core$IFn$_invoke$arity$1 = make_array__1;
make_array.cljs$core$IFn$_invoke$arity$2 = make_array__2;
return make_array;
})()
;
/**
* Returns a javascript array, cloned from the passed in array
*/
cljs.core.aclone = (function aclone(arr){
var len = arr.length;
var new_arr = (new Array(len));
var n__4645__auto___7492 = len;
var i_7493 = (0);
while(true){
if((i_7493 < n__4645__auto___7492)){
(new_arr[i_7493] = (arr[i_7493]));

var G__7494 = (i_7493 + (1));
i_7493 = G__7494;
continue;
} else {
}
break;
}

return new_arr;
});
/**
* Creates a new javascript array.
* @param {...*} var_args
*/
cljs.core.array = (function array(var_args){
var a = (new Array(arguments.length));
var i = (0);
while(true){
if((i < a.length)){
(a[i] = (arguments[i]));

var G__7495 = (i + (1));
i = G__7495;
continue;
} else {
return a;
}
break;
}
});
/**
* Returns the value at the index.
* @param {...*} var_args
*/
cljs.core.aget = (function() {
var aget = null;
var aget__2 = (function (array,i){
return (array[i]);
});
var aget__3 = (function() { 
var G__7504__delegate = function (array,i,idxs){
var G__7501 = aget;
var G__7502 = aget.cljs$core$IFn$_invoke$arity$2(array,i);
var G__7503 = idxs;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__7501,G__7502,G__7503) : cljs.core.apply.call(null,G__7501,G__7502,G__7503));
};
var G__7504 = function (array,i,var_args){
var idxs = null;
if (arguments.length > 2) {
var G__7505__i = 0, G__7505__a = new Array(arguments.length -  2);
while (G__7505__i < G__7505__a.length) {G__7505__a[G__7505__i] = arguments[G__7505__i + 2]; ++G__7505__i;}
  idxs = new cljs.core.IndexedSeq(G__7505__a,0);
} 
return G__7504__delegate.call(this,array,i,idxs);};
G__7504.cljs$lang$maxFixedArity = 2;
G__7504.cljs$lang$applyTo = (function (arglist__7506){
var array = cljs.core.first(arglist__7506);
arglist__7506 = cljs.core.next(arglist__7506);
var i = cljs.core.first(arglist__7506);
var idxs = cljs.core.rest(arglist__7506);
return G__7504__delegate(array,i,idxs);
});
G__7504.cljs$core$IFn$_invoke$arity$variadic = G__7504__delegate;
return G__7504;
})()
;
aget = function(array,i,var_args){
var idxs = var_args;
switch(arguments.length){
case 2:
return aget__2.call(this,array,i);
default:
var G__7507 = null;
if (arguments.length > 2) {
var G__7508__i = 0, G__7508__a = new Array(arguments.length -  2);
while (G__7508__i < G__7508__a.length) {G__7508__a[G__7508__i] = arguments[G__7508__i + 2]; ++G__7508__i;}
G__7507 = new cljs.core.IndexedSeq(G__7508__a,0);
}
return aget__3.cljs$core$IFn$_invoke$arity$variadic(array,i, G__7507);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
aget.cljs$lang$maxFixedArity = 2;
aget.cljs$lang$applyTo = aget__3.cljs$lang$applyTo;
aget.cljs$core$IFn$_invoke$arity$2 = aget__2;
aget.cljs$core$IFn$_invoke$arity$variadic = aget__3.cljs$core$IFn$_invoke$arity$variadic;
return aget;
})()
;
/**
* Sets the value at the index.
* @param {...*} var_args
*/
cljs.core.aset = (function() {
var aset = null;
var aset__3 = (function (array,i,val){
return (array[i] = val);
});
var aset__4 = (function() { 
var G__7517__delegate = function (array,idx,idx2,idxv){
var G__7513 = aset;
var G__7514 = (array[idx]);
var G__7515 = idx2;
var G__7516 = idxv;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__7513,G__7514,G__7515,G__7516) : cljs.core.apply.call(null,G__7513,G__7514,G__7515,G__7516));
};
var G__7517 = function (array,idx,idx2,var_args){
var idxv = null;
if (arguments.length > 3) {
var G__7518__i = 0, G__7518__a = new Array(arguments.length -  3);
while (G__7518__i < G__7518__a.length) {G__7518__a[G__7518__i] = arguments[G__7518__i + 3]; ++G__7518__i;}
  idxv = new cljs.core.IndexedSeq(G__7518__a,0);
} 
return G__7517__delegate.call(this,array,idx,idx2,idxv);};
G__7517.cljs$lang$maxFixedArity = 3;
G__7517.cljs$lang$applyTo = (function (arglist__7519){
var array = cljs.core.first(arglist__7519);
arglist__7519 = cljs.core.next(arglist__7519);
var idx = cljs.core.first(arglist__7519);
arglist__7519 = cljs.core.next(arglist__7519);
var idx2 = cljs.core.first(arglist__7519);
var idxv = cljs.core.rest(arglist__7519);
return G__7517__delegate(array,idx,idx2,idxv);
});
G__7517.cljs$core$IFn$_invoke$arity$variadic = G__7517__delegate;
return G__7517;
})()
;
aset = function(array,idx,idx2,var_args){
var idxv = var_args;
switch(arguments.length){
case 3:
return aset__3.call(this,array,idx,idx2);
default:
var G__7520 = null;
if (arguments.length > 3) {
var G__7521__i = 0, G__7521__a = new Array(arguments.length -  3);
while (G__7521__i < G__7521__a.length) {G__7521__a[G__7521__i] = arguments[G__7521__i + 3]; ++G__7521__i;}
G__7520 = new cljs.core.IndexedSeq(G__7521__a,0);
}
return aset__4.cljs$core$IFn$_invoke$arity$variadic(array,idx,idx2, G__7520);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
aset.cljs$lang$maxFixedArity = 3;
aset.cljs$lang$applyTo = aset__4.cljs$lang$applyTo;
aset.cljs$core$IFn$_invoke$arity$3 = aset__3;
aset.cljs$core$IFn$_invoke$arity$variadic = aset__4.cljs$core$IFn$_invoke$arity$variadic;
return aset;
})()
;
/**
* Returns the length of the array. Works on arrays of all types.
*/
cljs.core.alength = (function alength(array){
return array.length;
});
cljs.core.into_array = (function() {
var into_array = null;
var into_array__1 = (function (aseq){
return into_array.cljs$core$IFn$_invoke$arity$2(null,aseq);
});
var into_array__2 = (function (type,aseq){
var G__7527 = (function (a,x){
a.push(x);

return a;
});
var G__7528 = [];
var G__7529 = aseq;
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__7527,G__7528,G__7529) : cljs.core.reduce.call(null,G__7527,G__7528,G__7529));
});
into_array = function(type,aseq){
switch(arguments.length){
case 1:
return into_array__1.call(this,type);
case 2:
return into_array__2.call(this,type,aseq);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
into_array.cljs$core$IFn$_invoke$arity$1 = into_array__1;
into_array.cljs$core$IFn$_invoke$arity$2 = into_array__2;
return into_array;
})()
;
/**
* Invoke JavaScript object method via string. Needed when the
* string is not a valid unquoted property name.
* @param {...*} var_args
*/
cljs.core.js_invoke = (function() { 
var js_invoke__delegate = function (obj,s,args){
return (obj[s]).apply(obj,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));
};
var js_invoke = function (obj,s,var_args){
var args = null;
if (arguments.length > 2) {
var G__7530__i = 0, G__7530__a = new Array(arguments.length -  2);
while (G__7530__i < G__7530__a.length) {G__7530__a[G__7530__i] = arguments[G__7530__i + 2]; ++G__7530__i;}
  args = new cljs.core.IndexedSeq(G__7530__a,0);
} 
return js_invoke__delegate.call(this,obj,s,args);};
js_invoke.cljs$lang$maxFixedArity = 2;
js_invoke.cljs$lang$applyTo = (function (arglist__7531){
var obj = cljs.core.first(arglist__7531);
arglist__7531 = cljs.core.next(arglist__7531);
var s = cljs.core.first(arglist__7531);
var args = cljs.core.rest(arglist__7531);
return js_invoke__delegate(obj,s,args);
});
js_invoke.cljs$core$IFn$_invoke$arity$variadic = js_invoke__delegate;
return js_invoke;
})()
;

cljs.core.Fn = (function (){var obj7533 = {};
return obj7533;
})();


cljs.core.IFn = (function (){var obj7535 = {};
return obj7535;
})();

cljs.core._invoke = (function() {
var _invoke = null;
var _invoke__1 = (function (this$){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$1;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$1(this$);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7581 = x__4402__auto__;
return goog.typeOf(G__7581);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$);
}
});
var _invoke__2 = (function (this$,a){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$2;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$2(this$,a);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7583 = x__4402__auto__;
return goog.typeOf(G__7583);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a);
}
});
var _invoke__3 = (function (this$,a,b){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$3;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$3(this$,a,b);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7585 = x__4402__auto__;
return goog.typeOf(G__7585);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b);
}
});
var _invoke__4 = (function (this$,a,b,c){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$4;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7587 = x__4402__auto__;
return goog.typeOf(G__7587);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c);
}
});
var _invoke__5 = (function (this$,a,b,c,d){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$5;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7589 = x__4402__auto__;
return goog.typeOf(G__7589);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d);
}
});
var _invoke__6 = (function (this$,a,b,c,d,e){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$6;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7591 = x__4402__auto__;
return goog.typeOf(G__7591);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e);
}
});
var _invoke__7 = (function (this$,a,b,c,d,e,f){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$7;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7593 = x__4402__auto__;
return goog.typeOf(G__7593);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f);
}
});
var _invoke__8 = (function (this$,a,b,c,d,e,f,g){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$8;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7595 = x__4402__auto__;
return goog.typeOf(G__7595);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g);
}
});
var _invoke__9 = (function (this$,a,b,c,d,e,f,g,h){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$9;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7597 = x__4402__auto__;
return goog.typeOf(G__7597);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h);
}
});
var _invoke__10 = (function (this$,a,b,c,d,e,f,g,h,i){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$10;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7599 = x__4402__auto__;
return goog.typeOf(G__7599);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i);
}
});
var _invoke__11 = (function (this$,a,b,c,d,e,f,g,h,i,j){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$11;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7601 = x__4402__auto__;
return goog.typeOf(G__7601);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j);
}
});
var _invoke__12 = (function (this$,a,b,c,d,e,f,g,h,i,j,k){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$12;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7603 = x__4402__auto__;
return goog.typeOf(G__7603);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k);
}
});
var _invoke__13 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$13;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7605 = x__4402__auto__;
return goog.typeOf(G__7605);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l);
}
});
var _invoke__14 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$14;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7607 = x__4402__auto__;
return goog.typeOf(G__7607);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
}
});
var _invoke__15 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$15;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7609 = x__4402__auto__;
return goog.typeOf(G__7609);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
}
});
var _invoke__16 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$16;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7611 = x__4402__auto__;
return goog.typeOf(G__7611);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
}
});
var _invoke__17 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$17;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7613 = x__4402__auto__;
return goog.typeOf(G__7613);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
}
});
var _invoke__18 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$18;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7615 = x__4402__auto__;
return goog.typeOf(G__7615);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
}
});
var _invoke__19 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$19;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7617 = x__4402__auto__;
return goog.typeOf(G__7617);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
}
});
var _invoke__20 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$20;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7619 = x__4402__auto__;
return goog.typeOf(G__7619);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
}
});
var _invoke__21 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$21;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7621 = x__4402__auto__;
return goog.typeOf(G__7621);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
}
});
var _invoke__22 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$22;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7623 = x__4402__auto__;
return goog.typeOf(G__7623);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
});
_invoke = function(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return _invoke__1.call(this,this$);
case 2:
return _invoke__2.call(this,this$,a);
case 3:
return _invoke__3.call(this,this$,a,b);
case 4:
return _invoke__4.call(this,this$,a,b,c);
case 5:
return _invoke__5.call(this,this$,a,b,c,d);
case 6:
return _invoke__6.call(this,this$,a,b,c,d,e);
case 7:
return _invoke__7.call(this,this$,a,b,c,d,e,f);
case 8:
return _invoke__8.call(this,this$,a,b,c,d,e,f,g);
case 9:
return _invoke__9.call(this,this$,a,b,c,d,e,f,g,h);
case 10:
return _invoke__10.call(this,this$,a,b,c,d,e,f,g,h,i);
case 11:
return _invoke__11.call(this,this$,a,b,c,d,e,f,g,h,i,j);
case 12:
return _invoke__12.call(this,this$,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return _invoke__13.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return _invoke__14.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return _invoke__15.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return _invoke__16.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return _invoke__17.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return _invoke__18.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return _invoke__19.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return _invoke__20.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return _invoke__21.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return _invoke__22.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_invoke.cljs$core$IFn$_invoke$arity$1 = _invoke__1;
_invoke.cljs$core$IFn$_invoke$arity$2 = _invoke__2;
_invoke.cljs$core$IFn$_invoke$arity$3 = _invoke__3;
_invoke.cljs$core$IFn$_invoke$arity$4 = _invoke__4;
_invoke.cljs$core$IFn$_invoke$arity$5 = _invoke__5;
_invoke.cljs$core$IFn$_invoke$arity$6 = _invoke__6;
_invoke.cljs$core$IFn$_invoke$arity$7 = _invoke__7;
_invoke.cljs$core$IFn$_invoke$arity$8 = _invoke__8;
_invoke.cljs$core$IFn$_invoke$arity$9 = _invoke__9;
_invoke.cljs$core$IFn$_invoke$arity$10 = _invoke__10;
_invoke.cljs$core$IFn$_invoke$arity$11 = _invoke__11;
_invoke.cljs$core$IFn$_invoke$arity$12 = _invoke__12;
_invoke.cljs$core$IFn$_invoke$arity$13 = _invoke__13;
_invoke.cljs$core$IFn$_invoke$arity$14 = _invoke__14;
_invoke.cljs$core$IFn$_invoke$arity$15 = _invoke__15;
_invoke.cljs$core$IFn$_invoke$arity$16 = _invoke__16;
_invoke.cljs$core$IFn$_invoke$arity$17 = _invoke__17;
_invoke.cljs$core$IFn$_invoke$arity$18 = _invoke__18;
_invoke.cljs$core$IFn$_invoke$arity$19 = _invoke__19;
_invoke.cljs$core$IFn$_invoke$arity$20 = _invoke__20;
_invoke.cljs$core$IFn$_invoke$arity$21 = _invoke__21;
_invoke.cljs$core$IFn$_invoke$arity$22 = _invoke__22;
return _invoke;
})()
;


cljs.core.ICloneable = (function (){var obj7625 = {};
return obj7625;
})();

cljs.core._clone = (function _clone(value){
if((function (){var and__3746__auto__ = value;
if(and__3746__auto__){
return value.cljs$core$ICloneable$_clone$arity$1;
} else {
return and__3746__auto__;
}
})()){
return value.cljs$core$ICloneable$_clone$arity$1(value);
} else {
var x__4402__auto__ = (((value == null))?null:value);
return (function (){var or__3758__auto__ = (cljs.core._clone[(function (){var G__7629 = x__4402__auto__;
return goog.typeOf(G__7629);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._clone["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ICloneable.-clone",value);
}
}
})().call(null,value);
}
});


cljs.core.ICounted = (function (){var obj7631 = {};
return obj7631;
})();

cljs.core._count = (function _count(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$ICounted$_count$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$ICounted$_count$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._count[(function (){var G__7635 = x__4402__auto__;
return goog.typeOf(G__7635);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._count["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ICounted.-count",coll);
}
}
})().call(null,coll);
}
});


cljs.core.IEmptyableCollection = (function (){var obj7637 = {};
return obj7637;
})();

cljs.core._empty = (function _empty(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._empty[(function (){var G__7641 = x__4402__auto__;
return goog.typeOf(G__7641);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._empty["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IEmptyableCollection.-empty",coll);
}
}
})().call(null,coll);
}
});


cljs.core.ICollection = (function (){var obj7643 = {};
return obj7643;
})();

cljs.core._conj = (function _conj(coll,o){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$ICollection$_conj$arity$2;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$ICollection$_conj$arity$2(coll,o);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._conj[(function (){var G__7647 = x__4402__auto__;
return goog.typeOf(G__7647);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._conj["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ICollection.-conj",coll);
}
}
})().call(null,coll,o);
}
});


cljs.core.IIndexed = (function (){var obj7649 = {};
return obj7649;
})();

cljs.core._nth = (function() {
var _nth = null;
var _nth__2 = (function (coll,n){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IIndexed$_nth$arity$2;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$2(coll,n);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._nth[(function (){var G__7655 = x__4402__auto__;
return goog.typeOf(G__7655);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._nth["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
})().call(null,coll,n);
}
});
var _nth__3 = (function (coll,n,not_found){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IIndexed$_nth$arity$3;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$3(coll,n,not_found);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._nth[(function (){var G__7657 = x__4402__auto__;
return goog.typeOf(G__7657);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._nth["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
})().call(null,coll,n,not_found);
}
});
_nth = function(coll,n,not_found){
switch(arguments.length){
case 2:
return _nth__2.call(this,coll,n);
case 3:
return _nth__3.call(this,coll,n,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_nth.cljs$core$IFn$_invoke$arity$2 = _nth__2;
_nth.cljs$core$IFn$_invoke$arity$3 = _nth__3;
return _nth;
})()
;


cljs.core.ASeq = (function (){var obj7659 = {};
return obj7659;
})();


cljs.core.ISeq = (function (){var obj7661 = {};
return obj7661;
})();

cljs.core._first = (function _first(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$ISeq$_first$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$ISeq$_first$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._first[(function (){var G__7665 = x__4402__auto__;
return goog.typeOf(G__7665);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._first["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ISeq.-first",coll);
}
}
})().call(null,coll);
}
});

cljs.core._rest = (function _rest(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$ISeq$_rest$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$ISeq$_rest$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._rest[(function (){var G__7669 = x__4402__auto__;
return goog.typeOf(G__7669);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._rest["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ISeq.-rest",coll);
}
}
})().call(null,coll);
}
});


cljs.core.INext = (function (){var obj7671 = {};
return obj7671;
})();

cljs.core._next = (function _next(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$INext$_next$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$INext$_next$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._next[(function (){var G__7675 = x__4402__auto__;
return goog.typeOf(G__7675);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._next["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("INext.-next",coll);
}
}
})().call(null,coll);
}
});


cljs.core.ILookup = (function (){var obj7677 = {};
return obj7677;
})();

cljs.core._lookup = (function() {
var _lookup = null;
var _lookup__2 = (function (o,k){
if((function (){var and__3746__auto__ = o;
if(and__3746__auto__){
return o.cljs$core$ILookup$_lookup$arity$2;
} else {
return and__3746__auto__;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$2(o,k);
} else {
var x__4402__auto__ = (((o == null))?null:o);
return (function (){var or__3758__auto__ = (cljs.core._lookup[(function (){var G__7683 = x__4402__auto__;
return goog.typeOf(G__7683);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._lookup["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
})().call(null,o,k);
}
});
var _lookup__3 = (function (o,k,not_found){
if((function (){var and__3746__auto__ = o;
if(and__3746__auto__){
return o.cljs$core$ILookup$_lookup$arity$3;
} else {
return and__3746__auto__;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$3(o,k,not_found);
} else {
var x__4402__auto__ = (((o == null))?null:o);
return (function (){var or__3758__auto__ = (cljs.core._lookup[(function (){var G__7685 = x__4402__auto__;
return goog.typeOf(G__7685);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._lookup["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
})().call(null,o,k,not_found);
}
});
_lookup = function(o,k,not_found){
switch(arguments.length){
case 2:
return _lookup__2.call(this,o,k);
case 3:
return _lookup__3.call(this,o,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_lookup.cljs$core$IFn$_invoke$arity$2 = _lookup__2;
_lookup.cljs$core$IFn$_invoke$arity$3 = _lookup__3;
return _lookup;
})()
;


cljs.core.IAssociative = (function (){var obj7687 = {};
return obj7687;
})();

cljs.core._contains_key_QMARK_ = (function _contains_key_QMARK_(coll,k){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll,k);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._contains_key_QMARK_[(function (){var G__7691 = x__4402__auto__;
return goog.typeOf(G__7691);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._contains_key_QMARK_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IAssociative.-contains-key?",coll);
}
}
})().call(null,coll,k);
}
});

cljs.core._assoc = (function _assoc(coll,k,v){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IAssociative$_assoc$arity$3;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IAssociative$_assoc$arity$3(coll,k,v);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._assoc[(function (){var G__7695 = x__4402__auto__;
return goog.typeOf(G__7695);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._assoc["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IAssociative.-assoc",coll);
}
}
})().call(null,coll,k,v);
}
});


cljs.core.IMap = (function (){var obj7697 = {};
return obj7697;
})();

cljs.core._dissoc = (function _dissoc(coll,k){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IMap$_dissoc$arity$2;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IMap$_dissoc$arity$2(coll,k);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._dissoc[(function (){var G__7701 = x__4402__auto__;
return goog.typeOf(G__7701);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._dissoc["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IMap.-dissoc",coll);
}
}
})().call(null,coll,k);
}
});


cljs.core.IMapEntry = (function (){var obj7703 = {};
return obj7703;
})();

cljs.core._key = (function _key(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IMapEntry$_key$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IMapEntry$_key$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._key[(function (){var G__7707 = x__4402__auto__;
return goog.typeOf(G__7707);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._key["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IMapEntry.-key",coll);
}
}
})().call(null,coll);
}
});

cljs.core._val = (function _val(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IMapEntry$_val$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IMapEntry$_val$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._val[(function (){var G__7711 = x__4402__auto__;
return goog.typeOf(G__7711);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._val["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IMapEntry.-val",coll);
}
}
})().call(null,coll);
}
});


cljs.core.ISet = (function (){var obj7713 = {};
return obj7713;
})();

cljs.core._disjoin = (function _disjoin(coll,v){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$ISet$_disjoin$arity$2;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$ISet$_disjoin$arity$2(coll,v);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._disjoin[(function (){var G__7717 = x__4402__auto__;
return goog.typeOf(G__7717);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._disjoin["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ISet.-disjoin",coll);
}
}
})().call(null,coll,v);
}
});


cljs.core.IStack = (function (){var obj7719 = {};
return obj7719;
})();

cljs.core._peek = (function _peek(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IStack$_peek$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IStack$_peek$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._peek[(function (){var G__7723 = x__4402__auto__;
return goog.typeOf(G__7723);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._peek["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IStack.-peek",coll);
}
}
})().call(null,coll);
}
});

cljs.core._pop = (function _pop(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IStack$_pop$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IStack$_pop$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._pop[(function (){var G__7727 = x__4402__auto__;
return goog.typeOf(G__7727);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._pop["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IStack.-pop",coll);
}
}
})().call(null,coll);
}
});


cljs.core.IVector = (function (){var obj7729 = {};
return obj7729;
})();

cljs.core._assoc_n = (function _assoc_n(coll,n,val){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IVector$_assoc_n$arity$3;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IVector$_assoc_n$arity$3(coll,n,val);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._assoc_n[(function (){var G__7733 = x__4402__auto__;
return goog.typeOf(G__7733);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._assoc_n["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IVector.-assoc-n",coll);
}
}
})().call(null,coll,n,val);
}
});


cljs.core.IDeref = (function (){var obj7735 = {};
return obj7735;
})();

cljs.core._deref = (function _deref(o){
if((function (){var and__3746__auto__ = o;
if(and__3746__auto__){
return o.cljs$core$IDeref$_deref$arity$1;
} else {
return and__3746__auto__;
}
})()){
return o.cljs$core$IDeref$_deref$arity$1(o);
} else {
var x__4402__auto__ = (((o == null))?null:o);
return (function (){var or__3758__auto__ = (cljs.core._deref[(function (){var G__7739 = x__4402__auto__;
return goog.typeOf(G__7739);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._deref["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IDeref.-deref",o);
}
}
})().call(null,o);
}
});


cljs.core.IDerefWithTimeout = (function (){var obj7741 = {};
return obj7741;
})();

cljs.core._deref_with_timeout = (function _deref_with_timeout(o,msec,timeout_val){
if((function (){var and__3746__auto__ = o;
if(and__3746__auto__){
return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3;
} else {
return and__3746__auto__;
}
})()){
return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o,msec,timeout_val);
} else {
var x__4402__auto__ = (((o == null))?null:o);
return (function (){var or__3758__auto__ = (cljs.core._deref_with_timeout[(function (){var G__7745 = x__4402__auto__;
return goog.typeOf(G__7745);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._deref_with_timeout["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IDerefWithTimeout.-deref-with-timeout",o);
}
}
})().call(null,o,msec,timeout_val);
}
});


cljs.core.IMeta = (function (){var obj7747 = {};
return obj7747;
})();

cljs.core._meta = (function _meta(o){
if((function (){var and__3746__auto__ = o;
if(and__3746__auto__){
return o.cljs$core$IMeta$_meta$arity$1;
} else {
return and__3746__auto__;
}
})()){
return o.cljs$core$IMeta$_meta$arity$1(o);
} else {
var x__4402__auto__ = (((o == null))?null:o);
return (function (){var or__3758__auto__ = (cljs.core._meta[(function (){var G__7751 = x__4402__auto__;
return goog.typeOf(G__7751);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._meta["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IMeta.-meta",o);
}
}
})().call(null,o);
}
});


cljs.core.IWithMeta = (function (){var obj7753 = {};
return obj7753;
})();

cljs.core._with_meta = (function _with_meta(o,meta){
if((function (){var and__3746__auto__ = o;
if(and__3746__auto__){
return o.cljs$core$IWithMeta$_with_meta$arity$2;
} else {
return and__3746__auto__;
}
})()){
return o.cljs$core$IWithMeta$_with_meta$arity$2(o,meta);
} else {
var x__4402__auto__ = (((o == null))?null:o);
return (function (){var or__3758__auto__ = (cljs.core._with_meta[(function (){var G__7757 = x__4402__auto__;
return goog.typeOf(G__7757);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._with_meta["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IWithMeta.-with-meta",o);
}
}
})().call(null,o,meta);
}
});


cljs.core.IReduce = (function (){var obj7759 = {};
return obj7759;
})();

cljs.core._reduce = (function() {
var _reduce = null;
var _reduce__2 = (function (coll,f){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IReduce$_reduce$arity$2;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$2(coll,f);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._reduce[(function (){var G__7765 = x__4402__auto__;
return goog.typeOf(G__7765);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._reduce["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
})().call(null,coll,f);
}
});
var _reduce__3 = (function (coll,f,start){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IReduce$_reduce$arity$3;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$3(coll,f,start);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._reduce[(function (){var G__7767 = x__4402__auto__;
return goog.typeOf(G__7767);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._reduce["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
})().call(null,coll,f,start);
}
});
_reduce = function(coll,f,start){
switch(arguments.length){
case 2:
return _reduce__2.call(this,coll,f);
case 3:
return _reduce__3.call(this,coll,f,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_reduce.cljs$core$IFn$_invoke$arity$2 = _reduce__2;
_reduce.cljs$core$IFn$_invoke$arity$3 = _reduce__3;
return _reduce;
})()
;


cljs.core.IKVReduce = (function (){var obj7769 = {};
return obj7769;
})();

cljs.core._kv_reduce = (function _kv_reduce(coll,f,init){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IKVReduce$_kv_reduce$arity$3;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll,f,init);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._kv_reduce[(function (){var G__7773 = x__4402__auto__;
return goog.typeOf(G__7773);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._kv_reduce["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IKVReduce.-kv-reduce",coll);
}
}
})().call(null,coll,f,init);
}
});


cljs.core.IEquiv = (function (){var obj7775 = {};
return obj7775;
})();

cljs.core._equiv = (function _equiv(o,other){
if((function (){var and__3746__auto__ = o;
if(and__3746__auto__){
return o.cljs$core$IEquiv$_equiv$arity$2;
} else {
return and__3746__auto__;
}
})()){
return o.cljs$core$IEquiv$_equiv$arity$2(o,other);
} else {
var x__4402__auto__ = (((o == null))?null:o);
return (function (){var or__3758__auto__ = (cljs.core._equiv[(function (){var G__7779 = x__4402__auto__;
return goog.typeOf(G__7779);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._equiv["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IEquiv.-equiv",o);
}
}
})().call(null,o,other);
}
});


cljs.core.IHash = (function (){var obj7781 = {};
return obj7781;
})();

cljs.core._hash = (function _hash(o){
if((function (){var and__3746__auto__ = o;
if(and__3746__auto__){
return o.cljs$core$IHash$_hash$arity$1;
} else {
return and__3746__auto__;
}
})()){
return o.cljs$core$IHash$_hash$arity$1(o);
} else {
var x__4402__auto__ = (((o == null))?null:o);
return (function (){var or__3758__auto__ = (cljs.core._hash[(function (){var G__7785 = x__4402__auto__;
return goog.typeOf(G__7785);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._hash["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IHash.-hash",o);
}
}
})().call(null,o);
}
});


cljs.core.ISeqable = (function (){var obj7787 = {};
return obj7787;
})();

cljs.core._seq = (function _seq(o){
if((function (){var and__3746__auto__ = o;
if(and__3746__auto__){
return o.cljs$core$ISeqable$_seq$arity$1;
} else {
return and__3746__auto__;
}
})()){
return o.cljs$core$ISeqable$_seq$arity$1(o);
} else {
var x__4402__auto__ = (((o == null))?null:o);
return (function (){var or__3758__auto__ = (cljs.core._seq[(function (){var G__7791 = x__4402__auto__;
return goog.typeOf(G__7791);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._seq["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ISeqable.-seq",o);
}
}
})().call(null,o);
}
});


cljs.core.ISequential = (function (){var obj7793 = {};
return obj7793;
})();


cljs.core.IList = (function (){var obj7795 = {};
return obj7795;
})();


cljs.core.IRecord = (function (){var obj7797 = {};
return obj7797;
})();


cljs.core.IReversible = (function (){var obj7799 = {};
return obj7799;
})();

cljs.core._rseq = (function _rseq(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IReversible$_rseq$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IReversible$_rseq$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._rseq[(function (){var G__7803 = x__4402__auto__;
return goog.typeOf(G__7803);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._rseq["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IReversible.-rseq",coll);
}
}
})().call(null,coll);
}
});


cljs.core.ISorted = (function (){var obj7805 = {};
return obj7805;
})();

cljs.core._sorted_seq = (function _sorted_seq(coll,ascending_QMARK_){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$ISorted$_sorted_seq$arity$2;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll,ascending_QMARK_);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._sorted_seq[(function (){var G__7809 = x__4402__auto__;
return goog.typeOf(G__7809);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._sorted_seq["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq",coll);
}
}
})().call(null,coll,ascending_QMARK_);
}
});

cljs.core._sorted_seq_from = (function _sorted_seq_from(coll,k,ascending_QMARK_){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$ISorted$_sorted_seq_from$arity$3;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll,k,ascending_QMARK_);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._sorted_seq_from[(function (){var G__7813 = x__4402__auto__;
return goog.typeOf(G__7813);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._sorted_seq_from["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq-from",coll);
}
}
})().call(null,coll,k,ascending_QMARK_);
}
});

cljs.core._entry_key = (function _entry_key(coll,entry){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$ISorted$_entry_key$arity$2;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$ISorted$_entry_key$arity$2(coll,entry);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._entry_key[(function (){var G__7817 = x__4402__auto__;
return goog.typeOf(G__7817);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._entry_key["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-entry-key",coll);
}
}
})().call(null,coll,entry);
}
});

cljs.core._comparator = (function _comparator(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$ISorted$_comparator$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$ISorted$_comparator$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._comparator[(function (){var G__7821 = x__4402__auto__;
return goog.typeOf(G__7821);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._comparator["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-comparator",coll);
}
}
})().call(null,coll);
}
});


cljs.core.IWriter = (function (){var obj7823 = {};
return obj7823;
})();

cljs.core._write = (function _write(writer,s){
if((function (){var and__3746__auto__ = writer;
if(and__3746__auto__){
return writer.cljs$core$IWriter$_write$arity$2;
} else {
return and__3746__auto__;
}
})()){
return writer.cljs$core$IWriter$_write$arity$2(writer,s);
} else {
var x__4402__auto__ = (((writer == null))?null:writer);
return (function (){var or__3758__auto__ = (cljs.core._write[(function (){var G__7827 = x__4402__auto__;
return goog.typeOf(G__7827);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._write["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IWriter.-write",writer);
}
}
})().call(null,writer,s);
}
});

cljs.core._flush = (function _flush(writer){
if((function (){var and__3746__auto__ = writer;
if(and__3746__auto__){
return writer.cljs$core$IWriter$_flush$arity$1;
} else {
return and__3746__auto__;
}
})()){
return writer.cljs$core$IWriter$_flush$arity$1(writer);
} else {
var x__4402__auto__ = (((writer == null))?null:writer);
return (function (){var or__3758__auto__ = (cljs.core._flush[(function (){var G__7831 = x__4402__auto__;
return goog.typeOf(G__7831);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._flush["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IWriter.-flush",writer);
}
}
})().call(null,writer);
}
});


cljs.core.IPrintWithWriter = (function (){var obj7833 = {};
return obj7833;
})();

cljs.core._pr_writer = (function _pr_writer(o,writer,opts){
if((function (){var and__3746__auto__ = o;
if(and__3746__auto__){
return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3;
} else {
return and__3746__auto__;
}
})()){
return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o,writer,opts);
} else {
var x__4402__auto__ = (((o == null))?null:o);
return (function (){var or__3758__auto__ = (cljs.core._pr_writer[(function (){var G__7837 = x__4402__auto__;
return goog.typeOf(G__7837);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._pr_writer["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IPrintWithWriter.-pr-writer",o);
}
}
})().call(null,o,writer,opts);
}
});


cljs.core.IPending = (function (){var obj7839 = {};
return obj7839;
})();

cljs.core._realized_QMARK_ = (function _realized_QMARK_(d){
if((function (){var and__3746__auto__ = d;
if(and__3746__auto__){
return d.cljs$core$IPending$_realized_QMARK_$arity$1;
} else {
return and__3746__auto__;
}
})()){
return d.cljs$core$IPending$_realized_QMARK_$arity$1(d);
} else {
var x__4402__auto__ = (((d == null))?null:d);
return (function (){var or__3758__auto__ = (cljs.core._realized_QMARK_[(function (){var G__7843 = x__4402__auto__;
return goog.typeOf(G__7843);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._realized_QMARK_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IPending.-realized?",d);
}
}
})().call(null,d);
}
});


cljs.core.IWatchable = (function (){var obj7845 = {};
return obj7845;
})();

cljs.core._notify_watches = (function _notify_watches(this$,oldval,newval){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IWatchable$_notify_watches$arity$3;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$,oldval,newval);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._notify_watches[(function (){var G__7849 = x__4402__auto__;
return goog.typeOf(G__7849);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._notify_watches["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IWatchable.-notify-watches",this$);
}
}
})().call(null,this$,oldval,newval);
}
});

cljs.core._add_watch = (function _add_watch(this$,key,f){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IWatchable$_add_watch$arity$3;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IWatchable$_add_watch$arity$3(this$,key,f);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._add_watch[(function (){var G__7853 = x__4402__auto__;
return goog.typeOf(G__7853);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._add_watch["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IWatchable.-add-watch",this$);
}
}
})().call(null,this$,key,f);
}
});

cljs.core._remove_watch = (function _remove_watch(this$,key){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IWatchable$_remove_watch$arity$2;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$,key);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._remove_watch[(function (){var G__7857 = x__4402__auto__;
return goog.typeOf(G__7857);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._remove_watch["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IWatchable.-remove-watch",this$);
}
}
})().call(null,this$,key);
}
});


cljs.core.IEditableCollection = (function (){var obj7859 = {};
return obj7859;
})();

cljs.core._as_transient = (function _as_transient(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IEditableCollection$_as_transient$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._as_transient[(function (){var G__7863 = x__4402__auto__;
return goog.typeOf(G__7863);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._as_transient["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IEditableCollection.-as-transient",coll);
}
}
})().call(null,coll);
}
});


cljs.core.ITransientCollection = (function (){var obj7865 = {};
return obj7865;
})();

cljs.core._conj_BANG_ = (function _conj_BANG_(tcoll,val){
if((function (){var and__3746__auto__ = tcoll;
if(and__3746__auto__){
return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2;
} else {
return and__3746__auto__;
}
})()){
return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll,val);
} else {
var x__4402__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3758__auto__ = (cljs.core._conj_BANG_[(function (){var G__7869 = x__4402__auto__;
return goog.typeOf(G__7869);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._conj_BANG_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientCollection.-conj!",tcoll);
}
}
})().call(null,tcoll,val);
}
});

cljs.core._persistent_BANG_ = (function _persistent_BANG_(tcoll){
if((function (){var and__3746__auto__ = tcoll;
if(and__3746__auto__){
return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1;
} else {
return and__3746__auto__;
}
})()){
return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
} else {
var x__4402__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3758__auto__ = (cljs.core._persistent_BANG_[(function (){var G__7873 = x__4402__auto__;
return goog.typeOf(G__7873);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._persistent_BANG_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientCollection.-persistent!",tcoll);
}
}
})().call(null,tcoll);
}
});


cljs.core.ITransientAssociative = (function (){var obj7875 = {};
return obj7875;
})();

cljs.core._assoc_BANG_ = (function _assoc_BANG_(tcoll,key,val){
if((function (){var and__3746__auto__ = tcoll;
if(and__3746__auto__){
return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3;
} else {
return and__3746__auto__;
}
})()){
return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll,key,val);
} else {
var x__4402__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3758__auto__ = (cljs.core._assoc_BANG_[(function (){var G__7879 = x__4402__auto__;
return goog.typeOf(G__7879);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._assoc_BANG_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientAssociative.-assoc!",tcoll);
}
}
})().call(null,tcoll,key,val);
}
});


cljs.core.ITransientMap = (function (){var obj7881 = {};
return obj7881;
})();

cljs.core._dissoc_BANG_ = (function _dissoc_BANG_(tcoll,key){
if((function (){var and__3746__auto__ = tcoll;
if(and__3746__auto__){
return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2;
} else {
return and__3746__auto__;
}
})()){
return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll,key);
} else {
var x__4402__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3758__auto__ = (cljs.core._dissoc_BANG_[(function (){var G__7885 = x__4402__auto__;
return goog.typeOf(G__7885);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._dissoc_BANG_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientMap.-dissoc!",tcoll);
}
}
})().call(null,tcoll,key);
}
});


cljs.core.ITransientVector = (function (){var obj7887 = {};
return obj7887;
})();

cljs.core._assoc_n_BANG_ = (function _assoc_n_BANG_(tcoll,n,val){
if((function (){var and__3746__auto__ = tcoll;
if(and__3746__auto__){
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3;
} else {
return and__3746__auto__;
}
})()){
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll,n,val);
} else {
var x__4402__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3758__auto__ = (cljs.core._assoc_n_BANG_[(function (){var G__7891 = x__4402__auto__;
return goog.typeOf(G__7891);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._assoc_n_BANG_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientVector.-assoc-n!",tcoll);
}
}
})().call(null,tcoll,n,val);
}
});

cljs.core._pop_BANG_ = (function _pop_BANG_(tcoll){
if((function (){var and__3746__auto__ = tcoll;
if(and__3746__auto__){
return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1;
} else {
return and__3746__auto__;
}
})()){
return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
} else {
var x__4402__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3758__auto__ = (cljs.core._pop_BANG_[(function (){var G__7895 = x__4402__auto__;
return goog.typeOf(G__7895);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._pop_BANG_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientVector.-pop!",tcoll);
}
}
})().call(null,tcoll);
}
});


cljs.core.ITransientSet = (function (){var obj7897 = {};
return obj7897;
})();

cljs.core._disjoin_BANG_ = (function _disjoin_BANG_(tcoll,v){
if((function (){var and__3746__auto__ = tcoll;
if(and__3746__auto__){
return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2;
} else {
return and__3746__auto__;
}
})()){
return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll,v);
} else {
var x__4402__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3758__auto__ = (cljs.core._disjoin_BANG_[(function (){var G__7901 = x__4402__auto__;
return goog.typeOf(G__7901);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._disjoin_BANG_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientSet.-disjoin!",tcoll);
}
}
})().call(null,tcoll,v);
}
});


cljs.core.IComparable = (function (){var obj7903 = {};
return obj7903;
})();

cljs.core._compare = (function _compare(x,y){
if((function (){var and__3746__auto__ = x;
if(and__3746__auto__){
return x.cljs$core$IComparable$_compare$arity$2;
} else {
return and__3746__auto__;
}
})()){
return x.cljs$core$IComparable$_compare$arity$2(x,y);
} else {
var x__4402__auto__ = (((x == null))?null:x);
return (function (){var or__3758__auto__ = (cljs.core._compare[(function (){var G__7907 = x__4402__auto__;
return goog.typeOf(G__7907);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._compare["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IComparable.-compare",x);
}
}
})().call(null,x,y);
}
});


cljs.core.IChunk = (function (){var obj7909 = {};
return obj7909;
})();

cljs.core._drop_first = (function _drop_first(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IChunk$_drop_first$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._drop_first[(function (){var G__7913 = x__4402__auto__;
return goog.typeOf(G__7913);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._drop_first["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunk.-drop-first",coll);
}
}
})().call(null,coll);
}
});


cljs.core.IChunkedSeq = (function (){var obj7915 = {};
return obj7915;
})();

cljs.core._chunked_first = (function _chunked_first(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._chunked_first[(function (){var G__7919 = x__4402__auto__;
return goog.typeOf(G__7919);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._chunked_first["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-first",coll);
}
}
})().call(null,coll);
}
});

cljs.core._chunked_rest = (function _chunked_rest(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._chunked_rest[(function (){var G__7923 = x__4402__auto__;
return goog.typeOf(G__7923);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._chunked_rest["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-rest",coll);
}
}
})().call(null,coll);
}
});


cljs.core.IChunkedNext = (function (){var obj7925 = {};
return obj7925;
})();

cljs.core._chunked_next = (function _chunked_next(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IChunkedNext$_chunked_next$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._chunked_next[(function (){var G__7929 = x__4402__auto__;
return goog.typeOf(G__7929);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._chunked_next["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunkedNext.-chunked-next",coll);
}
}
})().call(null,coll);
}
});


cljs.core.INamed = (function (){var obj7931 = {};
return obj7931;
})();

cljs.core._name = (function _name(x){
if((function (){var and__3746__auto__ = x;
if(and__3746__auto__){
return x.cljs$core$INamed$_name$arity$1;
} else {
return and__3746__auto__;
}
})()){
return x.cljs$core$INamed$_name$arity$1(x);
} else {
var x__4402__auto__ = (((x == null))?null:x);
return (function (){var or__3758__auto__ = (cljs.core._name[(function (){var G__7935 = x__4402__auto__;
return goog.typeOf(G__7935);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._name["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("INamed.-name",x);
}
}
})().call(null,x);
}
});

cljs.core._namespace = (function _namespace(x){
if((function (){var and__3746__auto__ = x;
if(and__3746__auto__){
return x.cljs$core$INamed$_namespace$arity$1;
} else {
return and__3746__auto__;
}
})()){
return x.cljs$core$INamed$_namespace$arity$1(x);
} else {
var x__4402__auto__ = (((x == null))?null:x);
return (function (){var or__3758__auto__ = (cljs.core._namespace[(function (){var G__7939 = x__4402__auto__;
return goog.typeOf(G__7939);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._namespace["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("INamed.-namespace",x);
}
}
})().call(null,x);
}
});


cljs.core.IAtom = (function (){var obj7941 = {};
return obj7941;
})();


cljs.core.IReset = (function (){var obj7943 = {};
return obj7943;
})();

cljs.core._reset_BANG_ = (function _reset_BANG_(o,new_value){
if((function (){var and__3746__auto__ = o;
if(and__3746__auto__){
return o.cljs$core$IReset$_reset_BANG_$arity$2;
} else {
return and__3746__auto__;
}
})()){
return o.cljs$core$IReset$_reset_BANG_$arity$2(o,new_value);
} else {
var x__4402__auto__ = (((o == null))?null:o);
return (function (){var or__3758__auto__ = (cljs.core._reset_BANG_[(function (){var G__7947 = x__4402__auto__;
return goog.typeOf(G__7947);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._reset_BANG_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IReset.-reset!",o);
}
}
})().call(null,o,new_value);
}
});


cljs.core.ISwap = (function (){var obj7949 = {};
return obj7949;
})();

cljs.core._swap_BANG_ = (function() {
var _swap_BANG_ = null;
var _swap_BANG___2 = (function (o,f){
if((function (){var and__3746__auto__ = o;
if(and__3746__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$2;
} else {
return and__3746__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$2(o,f);
} else {
var x__4402__auto__ = (((o == null))?null:o);
return (function (){var or__3758__auto__ = (cljs.core._swap_BANG_[(function (){var G__7959 = x__4402__auto__;
return goog.typeOf(G__7959);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f);
}
});
var _swap_BANG___3 = (function (o,f,a){
if((function (){var and__3746__auto__ = o;
if(and__3746__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$3;
} else {
return and__3746__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$3(o,f,a);
} else {
var x__4402__auto__ = (((o == null))?null:o);
return (function (){var or__3758__auto__ = (cljs.core._swap_BANG_[(function (){var G__7961 = x__4402__auto__;
return goog.typeOf(G__7961);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f,a);
}
});
var _swap_BANG___4 = (function (o,f,a,b){
if((function (){var and__3746__auto__ = o;
if(and__3746__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$4;
} else {
return and__3746__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$4(o,f,a,b);
} else {
var x__4402__auto__ = (((o == null))?null:o);
return (function (){var or__3758__auto__ = (cljs.core._swap_BANG_[(function (){var G__7963 = x__4402__auto__;
return goog.typeOf(G__7963);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f,a,b);
}
});
var _swap_BANG___5 = (function (o,f,a,b,xs){
if((function (){var and__3746__auto__ = o;
if(and__3746__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$5;
} else {
return and__3746__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$5(o,f,a,b,xs);
} else {
var x__4402__auto__ = (((o == null))?null:o);
return (function (){var or__3758__auto__ = (cljs.core._swap_BANG_[(function (){var G__7965 = x__4402__auto__;
return goog.typeOf(G__7965);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f,a,b,xs);
}
});
_swap_BANG_ = function(o,f,a,b,xs){
switch(arguments.length){
case 2:
return _swap_BANG___2.call(this,o,f);
case 3:
return _swap_BANG___3.call(this,o,f,a);
case 4:
return _swap_BANG___4.call(this,o,f,a,b);
case 5:
return _swap_BANG___5.call(this,o,f,a,b,xs);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_swap_BANG_.cljs$core$IFn$_invoke$arity$2 = _swap_BANG___2;
_swap_BANG_.cljs$core$IFn$_invoke$arity$3 = _swap_BANG___3;
_swap_BANG_.cljs$core$IFn$_invoke$arity$4 = _swap_BANG___4;
_swap_BANG_.cljs$core$IFn$_invoke$arity$5 = _swap_BANG___5;
return _swap_BANG_;
})()
;


cljs.core.IVolatile = (function (){var obj7967 = {};
return obj7967;
})();

cljs.core._vreset_BANG_ = (function _vreset_BANG_(o,new_value){
if((function (){var and__3746__auto__ = o;
if(and__3746__auto__){
return o.cljs$core$IVolatile$_vreset_BANG_$arity$2;
} else {
return and__3746__auto__;
}
})()){
return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o,new_value);
} else {
var x__4402__auto__ = (((o == null))?null:o);
return (function (){var or__3758__auto__ = (cljs.core._vreset_BANG_[(function (){var G__7971 = x__4402__auto__;
return goog.typeOf(G__7971);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._vreset_BANG_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IVolatile.-vreset!",o);
}
}
})().call(null,o,new_value);
}
});


cljs.core.IIterable = (function (){var obj7973 = {};
return obj7973;
})();

cljs.core._iterator = (function _iterator(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IIterable$_iterator$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IIterable$_iterator$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._iterator[(function (){var G__7977 = x__4402__auto__;
return goog.typeOf(G__7977);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._iterator["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IIterable.-iterator",coll);
}
}
})().call(null,coll);
}
});


/**
* @constructor
*/
cljs.core.StringBufferWriter = (function (sb){
this.sb = sb;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 1073741824;
})
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = (function (_,s){
var self__ = this;
var ___$1 = this;
return self__.sb.append(s);
});

cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return null;
});

cljs.core.StringBufferWriter.cljs$lang$type = true;

cljs.core.StringBufferWriter.cljs$lang$ctorStr = "cljs.core/StringBufferWriter";

cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/StringBufferWriter");
});

cljs.core.__GT_StringBufferWriter = (function __GT_StringBufferWriter(sb){
return (new cljs.core.StringBufferWriter(sb));
});

/**
* Support so that collections can implement toString without
* loading all the printing machinery.
*/
cljs.core.pr_str_STAR_ = (function pr_str_STAR_(obj){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,cljs.core.pr_opts());

writer.cljs$core$IWriter$_flush$arity$1(null);

return [cljs.core.str(sb)].join('');
});
cljs.core.int_rotate_left = (function int_rotate_left(x,n){
return ((x << n) | (x >>> (- n)));
});
if((typeof Math.imul !== 'undefined') && (!(((function (){var G__7980 = (4294967295);
var G__7981 = (5);
return (Math.imul.cljs$core$IFn$_invoke$arity$2 ? Math.imul.cljs$core$IFn$_invoke$arity$2(G__7980,G__7981) : Math.imul.call(null,G__7980,G__7981));
})() === (0))))){
cljs.core.imul = (function imul(a,b){
var G__7984 = a;
var G__7985 = b;
return (Math.imul.cljs$core$IFn$_invoke$arity$2 ? Math.imul.cljs$core$IFn$_invoke$arity$2(G__7984,G__7985) : Math.imul.call(null,G__7984,G__7985));
});
} else {
cljs.core.imul = (function imul(a,b){
var ah = ((a >>> (16)) & (65535));
var al = (a & (65535));
var bh = ((b >>> (16)) & (65535));
var bl = (b & (65535));
return (((al * bl) + ((((ah * bl) + (al * bh)) << (16)) >>> (0))) | (0));
});
}
cljs.core.m3_seed = (0);
cljs.core.m3_C1 = (3432918353);
cljs.core.m3_C2 = (461845907);
cljs.core.m3_mix_K1 = (function m3_mix_K1(k1){
return cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul(k1,cljs.core.m3_C1),(15)),cljs.core.m3_C2);
});
cljs.core.m3_mix_H1 = (function m3_mix_H1(h1,k1){
return (cljs.core.imul(cljs.core.int_rotate_left((h1 ^ k1),(13)),(5)) + (3864292196));
});
cljs.core.m3_fmix = (function m3_fmix(h1,len){
var h1__$1 = h1;
var h1__$2 = (h1__$1 ^ len);
var h1__$3 = (h1__$2 ^ (h1__$2 >>> (16)));
var h1__$4 = cljs.core.imul(h1__$3,(2246822507));
var h1__$5 = (h1__$4 ^ (h1__$4 >>> (13)));
var h1__$6 = cljs.core.imul(h1__$5,(3266489909));
var h1__$7 = (h1__$6 ^ (h1__$6 >>> (16)));
return h1__$7;
});
cljs.core.m3_hash_int = (function m3_hash_int(in$){
if((in$ === (0))){
return in$;
} else {
var k1 = cljs.core.m3_mix_K1(in$);
var h1 = cljs.core.m3_mix_H1(cljs.core.m3_seed,k1);
return cljs.core.m3_fmix(h1,(4));
}
});
cljs.core.m3_hash_unencoded_chars = (function m3_hash_unencoded_chars(in$){
var h1 = (function (){var i = (1);
var h1 = cljs.core.m3_seed;
while(true){
if((i < in$.length)){
var G__7986 = (i + (2));
var G__7987 = cljs.core.m3_mix_H1(h1,cljs.core.m3_mix_K1((in$.charCodeAt((i - (1))) | (in$.charCodeAt(i) << (16)))));
i = G__7986;
h1 = G__7987;
continue;
} else {
return h1;
}
break;
}
})();
var h1__$1 = ((((in$.length & (1)) === (1)))?(h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt((in$.length - (1))))):h1);
return cljs.core.m3_fmix(h1__$1,cljs.core.imul((2),in$.length));
});



cljs.core.string_hash_cache = (function (){var obj7989 = {};
return obj7989;
})();
cljs.core.string_hash_cache_count = (0);
cljs.core.hash_string_STAR_ = (function hash_string_STAR_(s){
if(!((s == null))){
var len = s.length;
if((len > (0))){
var i = (0);
var hash = (0);
while(true){
if((i < len)){
var G__7990 = (i + (1));
var G__7991 = (cljs.core.imul((31),hash) + s.charCodeAt(i));
i = G__7990;
hash = G__7991;
continue;
} else {
return hash;
}
break;
}
} else {
return (0);
}
} else {
return (0);
}
});
cljs.core.add_to_string_hash_cache = (function add_to_string_hash_cache(k){
var h = cljs.core.hash_string_STAR_(k);
(cljs.core.string_hash_cache[k] = h);

cljs.core.string_hash_cache_count = (cljs.core.string_hash_cache_count + (1));

return h;
});
cljs.core.hash_string = (function hash_string(k){
if((cljs.core.string_hash_cache_count > (255))){
cljs.core.string_hash_cache = (function (){var obj7995 = {};
return obj7995;
})();

cljs.core.string_hash_cache_count = (0);
} else {
}

var h = (cljs.core.string_hash_cache[k]);
if(typeof h === 'number'){
return h;
} else {
return cljs.core.add_to_string_hash_cache(k);
}
});
cljs.core.hash = (function hash(o){
if((function (){var G__7998 = o;
if(G__7998){
var bit__4432__auto__ = (G__7998.cljs$lang$protocol_mask$partition0$ & (4194304));
if((bit__4432__auto__) || (G__7998.cljs$core$IHash$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return o.cljs$core$IHash$_hash$arity$1(null);
} else {
if(typeof o === 'number'){
return ((function (){var G__7999 = o;
return (Math.floor.cljs$core$IFn$_invoke$arity$1 ? Math.floor.cljs$core$IFn$_invoke$arity$1(G__7999) : Math.floor.call(null,G__7999));
})() % (2147483647));
} else {
if(o === true){
return (1);
} else {
if(o === false){
return (0);
} else {
if(typeof o === 'string'){
return cljs.core.m3_hash_int(cljs.core.hash_string(o));
} else {
if((o instanceof Date)){
return o.valueOf();
} else {
if((o == null)){
return (0);
} else {
return cljs.core._hash(o);

}
}
}
}
}
}
}
});
cljs.core.hash_combine = (function hash_combine(seed,hash){
return (seed ^ (((hash + (2654435769)) + (seed << (6))) + (seed >> (2))));
});
cljs.core.instance_QMARK_ = (function instance_QMARK_(t,o){
return (o instanceof t);
});
cljs.core.symbol_QMARK_ = (function symbol_QMARK_(x){
return (x instanceof cljs.core.Symbol);
});
cljs.core.hash_symbol = (function hash_symbol(sym){
return cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name),cljs.core.hash_string(sym.ns));
});
cljs.core.compare_symbols = (function compare_symbols(a,b){
if((a.str === b.str)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__3746__auto__ = cljs.core.not(a.ns);
if(and__3746__auto__){
return b.ns;
} else {
return and__3746__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__8006 = a.ns;
var G__8007 = b.ns;
return goog.array.defaultCompare(G__8006,G__8007);
})();
if(((0) === nsc)){
var G__8008 = a.name;
var G__8009 = b.name;
return goog.array.defaultCompare(G__8008,G__8009);
} else {
return nsc;
}
}
} else {
var G__8010 = a.name;
var G__8011 = b.name;
return goog.array.defaultCompare(G__8010,G__8011);

}
}
}
});

/**
* @constructor
*/
cljs.core.Symbol = (function (ns,name,str,_hash,_meta){
this.ns = ns;
this.name = name;
this.str = str;
this._hash = _hash;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 2154168321;
this.cljs$lang$protocol_mask$partition1$ = 4096;
})
cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,self__.str);
});

cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
});

cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
});

cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = (function (sym){
var self__ = this;
var sym__$1 = this;
var h__4179__auto__ = self__._hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_symbol(sym__$1);
self__._hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Symbol(self__.ns,self__.name,self__.str,self__._hash,new_meta));
});

cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

cljs.core.Symbol.prototype.call = (function() {
var G__8013 = null;
var G__8013__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,null);
});
var G__8013__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found);
});
G__8013 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__8013__2.call(this,self__,coll);
case 3:
return G__8013__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8013.cljs$core$IFn$_invoke$arity$2 = G__8013__2;
G__8013.cljs$core$IFn$_invoke$arity$3 = G__8013__3;
return G__8013;
})()
;

cljs.core.Symbol.prototype.apply = (function (self__,args8012){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args8012)));
});

cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var sym = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,null);
});

cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var sym = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found);
});

cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Symbol)){
return (self__.str === other.str);
} else {
return false;
}
});

cljs.core.Symbol.prototype.toString = (function (){
var self__ = this;
var _ = this;
return self__.str;
});

cljs.core.Symbol.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Symbol.cljs$lang$type = true;

cljs.core.Symbol.cljs$lang$ctorStr = "cljs.core/Symbol";

cljs.core.Symbol.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/Symbol");
});

cljs.core.__GT_Symbol = (function __GT_Symbol(ns,name,str,_hash,_meta){
return (new cljs.core.Symbol(ns,name,str,_hash,_meta));
});

cljs.core.symbol = (function() {
var symbol = null;
var symbol__1 = (function (name){
if((name instanceof cljs.core.Symbol)){
return name;
} else {
return symbol.cljs$core$IFn$_invoke$arity$2(null,name);
}
});
var symbol__2 = (function (ns,name){
var sym_str = ((!((ns == null)))?[cljs.core.str(ns),cljs.core.str("/"),cljs.core.str(name)].join(''):name);
return (new cljs.core.Symbol(ns,name,sym_str,null,null));
});
symbol = function(ns,name){
switch(arguments.length){
case 1:
return symbol__1.call(this,ns);
case 2:
return symbol__2.call(this,ns,name);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
symbol.cljs$core$IFn$_invoke$arity$1 = symbol__1;
symbol.cljs$core$IFn$_invoke$arity$2 = symbol__2;
return symbol;
})()
;

/**
* @constructor
*/
cljs.core.Var = (function (val,sym,_meta){
this.val = val;
this.sym = sym;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 163841;
})
cljs.core.Var.prototype.call = (function() {
var G__8061 = null;
var G__8061__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null);
});
var G__8061__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a);
});
var G__8061__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b);
});
var G__8061__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c);
});
var G__8061__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d);
});
var G__8061__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e);
});
var G__8061__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f);
});
var G__8061__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g);
});
var G__8061__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h);
});
var G__8061__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i);
});
var G__8061__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j);
});
var G__8061__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k);
});
var G__8061__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l);
});
var G__8061__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m);
});
var G__8061__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});
var G__8061__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});
var G__8061__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});
var G__8061__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});
var G__8061__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});
var G__8061__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});
var G__8061__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});
var G__8061__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8017 = (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})();
var G__8018 = a;
var G__8019 = b;
var G__8020 = c;
var G__8021 = d;
var G__8022 = e;
var G__8023 = f;
var G__8024 = g;
var G__8025 = h;
var G__8026 = i;
var G__8027 = j;
var G__8028 = k;
var G__8029 = l;
var G__8030 = m;
var G__8031 = n;
var G__8032 = o;
var G__8033 = p;
var G__8034 = q;
var G__8035 = r;
var G__8036 = s;
var G__8037 = t;
var G__8038 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__8017,G__8018,G__8019,G__8020,G__8021,G__8022,G__8023,G__8024,G__8025,G__8026,G__8027,G__8028,G__8029,G__8030,G__8031,G__8032,G__8033,G__8034,G__8035,G__8036,G__8037,G__8038) : cljs.core.apply.call(null,G__8017,G__8018,G__8019,G__8020,G__8021,G__8022,G__8023,G__8024,G__8025,G__8026,G__8027,G__8028,G__8029,G__8030,G__8031,G__8032,G__8033,G__8034,G__8035,G__8036,G__8037,G__8038));
});
G__8061 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__8061__1.call(this,self__);
case 2:
return G__8061__2.call(this,self__,a);
case 3:
return G__8061__3.call(this,self__,a,b);
case 4:
return G__8061__4.call(this,self__,a,b,c);
case 5:
return G__8061__5.call(this,self__,a,b,c,d);
case 6:
return G__8061__6.call(this,self__,a,b,c,d,e);
case 7:
return G__8061__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__8061__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__8061__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__8061__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__8061__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__8061__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__8061__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__8061__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__8061__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__8061__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__8061__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__8061__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__8061__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__8061__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__8061__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__8061__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8061.cljs$core$IFn$_invoke$arity$1 = G__8061__1;
G__8061.cljs$core$IFn$_invoke$arity$2 = G__8061__2;
G__8061.cljs$core$IFn$_invoke$arity$3 = G__8061__3;
G__8061.cljs$core$IFn$_invoke$arity$4 = G__8061__4;
G__8061.cljs$core$IFn$_invoke$arity$5 = G__8061__5;
G__8061.cljs$core$IFn$_invoke$arity$6 = G__8061__6;
G__8061.cljs$core$IFn$_invoke$arity$7 = G__8061__7;
G__8061.cljs$core$IFn$_invoke$arity$8 = G__8061__8;
G__8061.cljs$core$IFn$_invoke$arity$9 = G__8061__9;
G__8061.cljs$core$IFn$_invoke$arity$10 = G__8061__10;
G__8061.cljs$core$IFn$_invoke$arity$11 = G__8061__11;
G__8061.cljs$core$IFn$_invoke$arity$12 = G__8061__12;
G__8061.cljs$core$IFn$_invoke$arity$13 = G__8061__13;
G__8061.cljs$core$IFn$_invoke$arity$14 = G__8061__14;
G__8061.cljs$core$IFn$_invoke$arity$15 = G__8061__15;
G__8061.cljs$core$IFn$_invoke$arity$16 = G__8061__16;
G__8061.cljs$core$IFn$_invoke$arity$17 = G__8061__17;
G__8061.cljs$core$IFn$_invoke$arity$18 = G__8061__18;
G__8061.cljs$core$IFn$_invoke$arity$19 = G__8061__19;
G__8061.cljs$core$IFn$_invoke$arity$20 = G__8061__20;
G__8061.cljs$core$IFn$_invoke$arity$21 = G__8061__21;
G__8061.cljs$core$IFn$_invoke$arity$22 = G__8061__22;
return G__8061;
})()
;

cljs.core.Var.prototype.apply = (function (self__,args8016){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args8016)));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
var G__8039 = (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})();
var G__8040 = a;
var G__8041 = b;
var G__8042 = c;
var G__8043 = d;
var G__8044 = e;
var G__8045 = f;
var G__8046 = g;
var G__8047 = h;
var G__8048 = i;
var G__8049 = j;
var G__8050 = k;
var G__8051 = l;
var G__8052 = m;
var G__8053 = n;
var G__8054 = o;
var G__8055 = p;
var G__8056 = q;
var G__8057 = r;
var G__8058 = s;
var G__8059 = t;
var G__8060 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__8039,G__8040,G__8041,G__8042,G__8043,G__8044,G__8045,G__8046,G__8047,G__8048,G__8049,G__8050,G__8051,G__8052,G__8053,G__8054,G__8055,G__8056,G__8057,G__8058,G__8059,G__8060) : cljs.core.apply.call(null,G__8039,G__8040,G__8041,G__8042,G__8043,G__8044,G__8045,G__8046,G__8047,G__8048,G__8049,G__8050,G__8051,G__8052,G__8053,G__8054,G__8055,G__8056,G__8057,G__8058,G__8059,G__8060));
});

cljs.core.Var.prototype.cljs$core$Fn$ = true;

cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
});

cljs.core.Var.cljs$lang$type = true;

cljs.core.Var.cljs$lang$ctorStr = "cljs.core/Var";

cljs.core.Var.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/Var");
});

cljs.core.__GT_Var = (function __GT_Var(val,sym,_meta){
return (new cljs.core.Var(val,sym,_meta));
});



cljs.core.iterable_QMARK_ = (function iterable_QMARK_(x){
var G__8063 = x;
if(G__8063){
var bit__4439__auto__ = null;
if(cljs.core.truth_((function (){var or__3758__auto__ = bit__4439__auto__;
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return G__8063.cljs$core$IIterable$;
}
})())){
return true;
} else {
if((!G__8063.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,G__8063);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,G__8063);
}
});
cljs.core.clone = (function clone(value){
return cljs.core._clone(value);
});
cljs.core.cloneable_QMARK_ = (function cloneable_QMARK_(value){
var G__8065 = value;
if(G__8065){
var bit__4439__auto__ = (G__8065.cljs$lang$protocol_mask$partition1$ & (8192));
if((bit__4439__auto__) || (G__8065.cljs$core$ICloneable$)){
return true;
} else {
if((!G__8065.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,G__8065);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,G__8065);
}
});
/**
* Returns a seq on the collection. If the collection is
* empty, returns nil.  (seq nil) returns nil. seq also works on
* Strings.
*/
cljs.core.seq = (function seq(coll){
if((coll == null)){
return null;
} else {
if((function (){var G__8067 = coll;
if(G__8067){
var bit__4432__auto__ = (G__8067.cljs$lang$protocol_mask$partition0$ & (8388608));
if((bit__4432__auto__) || (G__8067.cljs$core$ISeqable$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ISeqable$_seq$arity$1(null);
} else {
if(coll instanceof Array){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0)));
}
} else {
if(typeof coll === 'string'){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0)));
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,coll)){
return cljs.core._seq(coll);
} else {
throw (new Error([cljs.core.str(coll),cljs.core.str(" is not ISeqable")].join('')));

}
}
}
}
}
});
/**
* Returns the first item in the collection. Calls seq on its
* argument. If coll is nil, returns nil.
*/
cljs.core.first = (function first(coll){
if((coll == null)){
return null;
} else {
if((function (){var G__8069 = coll;
if(G__8069){
var bit__4432__auto__ = (G__8069.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4432__auto__) || (G__8069.cljs$core$ISeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ISeq$_first$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if((s == null)){
return null;
} else {
return cljs.core._first(s);
}
}
}
});
/**
* Returns a possibly empty seq of the items after the first. Calls seq on its
* argument.
*/
cljs.core.rest = (function rest(coll){
if(!((coll == null))){
if((function (){var G__8071 = coll;
if(G__8071){
var bit__4432__auto__ = (G__8071.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4432__auto__) || (G__8071.cljs$core$ISeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ISeq$_rest$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if(s){
return cljs.core._rest(s);
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return cljs.core.List.EMPTY;
}
});
/**
* Returns a seq of the items after the first. Calls seq on its
* argument.  If there are no more items, returns nil
*/
cljs.core.next = (function next(coll){
if((coll == null)){
return null;
} else {
if((function (){var G__8073 = coll;
if(G__8073){
var bit__4432__auto__ = (G__8073.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4432__auto__) || (G__8073.cljs$core$INext$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$INext$_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core.rest(coll));
}
}
});
/**
* Equality. Returns true if x equals y, false if not. Compares
* numbers and collections in a type-independent manner.  Clojure's immutable data
* structures define -equiv (and thus =) as a value, not an identity,
* comparison.
* @param {...*} var_args
*/
cljs.core._EQ_ = (function() {
var _EQ_ = null;
var _EQ___1 = (function (x){
return true;
});
var _EQ___2 = (function (x,y){
if((x == null)){
return (y == null);
} else {
return ((x === y)) || (cljs.core._equiv(x,y));
}
});
var _EQ___3 = (function() { 
var G__8078__delegate = function (x,y,more){
while(true){
if(_EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
if(cljs.core.next(more)){
var G__8079 = y;
var G__8080 = cljs.core.first(more);
var G__8081 = cljs.core.next(more);
x = G__8079;
y = G__8080;
more = G__8081;
continue;
} else {
return _EQ_.cljs$core$IFn$_invoke$arity$2(y,cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__8078 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8082__i = 0, G__8082__a = new Array(arguments.length -  2);
while (G__8082__i < G__8082__a.length) {G__8082__a[G__8082__i] = arguments[G__8082__i + 2]; ++G__8082__i;}
  more = new cljs.core.IndexedSeq(G__8082__a,0);
} 
return G__8078__delegate.call(this,x,y,more);};
G__8078.cljs$lang$maxFixedArity = 2;
G__8078.cljs$lang$applyTo = (function (arglist__8083){
var x = cljs.core.first(arglist__8083);
arglist__8083 = cljs.core.next(arglist__8083);
var y = cljs.core.first(arglist__8083);
var more = cljs.core.rest(arglist__8083);
return G__8078__delegate(x,y,more);
});
G__8078.cljs$core$IFn$_invoke$arity$variadic = G__8078__delegate;
return G__8078;
})()
;
_EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return _EQ___1.call(this,x);
case 2:
return _EQ___2.call(this,x,y);
default:
var G__8084 = null;
if (arguments.length > 2) {
var G__8085__i = 0, G__8085__a = new Array(arguments.length -  2);
while (G__8085__i < G__8085__a.length) {G__8085__a[G__8085__i] = arguments[G__8085__i + 2]; ++G__8085__i;}
G__8084 = new cljs.core.IndexedSeq(G__8085__a,0);
}
return _EQ___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8084);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_EQ_.cljs$lang$maxFixedArity = 2;
_EQ_.cljs$lang$applyTo = _EQ___3.cljs$lang$applyTo;
_EQ_.cljs$core$IFn$_invoke$arity$1 = _EQ___1;
_EQ_.cljs$core$IFn$_invoke$arity$2 = _EQ___2;
_EQ_.cljs$core$IFn$_invoke$arity$variadic = _EQ___3.cljs$core$IFn$_invoke$arity$variadic;
return _EQ_;
})()
;

/**
* @constructor
*/
cljs.core.ES6Iterator = (function (s){
this.s = s;
})
cljs.core.ES6Iterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var x = cljs.core.first(self__.s);
self__.s = cljs.core.next(self__.s);

return {"done": false, "value": x};
} else {
return {"done": true, "value": null};
}
});

cljs.core.ES6Iterator.cljs$lang$type = true;

cljs.core.ES6Iterator.cljs$lang$ctorStr = "cljs.core/ES6Iterator";

cljs.core.ES6Iterator.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/ES6Iterator");
});

cljs.core.__GT_ES6Iterator = (function __GT_ES6Iterator(s){
return (new cljs.core.ES6Iterator(s));
});

cljs.core.es6_iterator = (function es6_iterator(coll){
return (new cljs.core.ES6Iterator(cljs.core.seq(coll)));
});

/**
* @constructor
*/
cljs.core.ES6IteratorSeq = (function (value,iter,_rest){
this.value = value;
this.iter = iter;
this._rest = _rest;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 8388672;
})
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.value;
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if((self__._rest == null)){
self__._rest = (function (){var G__8086 = self__.iter;
return (cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1(G__8086) : cljs.core.es6_iterator_seq.call(null,G__8086));
})();
} else {
}

return self__._rest;
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.ES6IteratorSeq.cljs$lang$type = true;

cljs.core.ES6IteratorSeq.cljs$lang$ctorStr = "cljs.core/ES6IteratorSeq";

cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/ES6IteratorSeq");
});

cljs.core.__GT_ES6IteratorSeq = (function __GT_ES6IteratorSeq(value,iter,_rest){
return (new cljs.core.ES6IteratorSeq(value,iter,_rest));
});

cljs.core.es6_iterator_seq = (function es6_iterator_seq(iter){
var v = iter.next();
if(cljs.core.truth_(v.done)){
return cljs.core.List.EMPTY;
} else {
return (new cljs.core.ES6IteratorSeq(v.value,iter,null));
}
});
/**
* Mix final collection hash for ordered or unordered collections.
* hash-basis is the combined collection hash, count is the number
* of elements included in the basis. Note this is the hash code
* consistent with =, different from .hashCode.
* See http://clojure.org/data_structures#hash for full algorithms.
*/
cljs.core.mix_collection_hash = (function mix_collection_hash(hash_basis,count){
var h1 = cljs.core.m3_seed;
var k1 = cljs.core.m3_mix_K1(hash_basis);
var h1__$1 = cljs.core.m3_mix_H1(h1,k1);
return cljs.core.m3_fmix(h1__$1,count);
});
/**
* Returns the hash code, consistent with =, for an external ordered
* collection implementing Iterable.
* See http://clojure.org/data_structures#hash for full algorithms.
*/
cljs.core.hash_ordered_coll = (function hash_ordered_coll(coll){
var n = (0);
var hash_code = (1);
var coll__$1 = cljs.core.seq(coll);
while(true){
if(!((coll__$1 == null))){
var G__8087 = (n + (1));
var G__8088 = ((cljs.core.imul((31),hash_code) + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__8089 = cljs.core.next(coll__$1);
n = G__8087;
hash_code = G__8088;
coll__$1 = G__8089;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_ordered_hash = cljs.core.mix_collection_hash((1),(0));
/**
* Returns the hash code, consistent with =, for an external unordered
* collection implementing Iterable. For maps, the iterator should
* return map entries whose hash is computed as
* (hash-ordered-coll [k v]).
* See http://clojure.org/data_structures#hash for full algorithms.
*/
cljs.core.hash_unordered_coll = (function hash_unordered_coll(coll){
var n = (0);
var hash_code = (0);
var coll__$1 = cljs.core.seq(coll);
while(true){
if(!((coll__$1 == null))){
var G__8090 = (n + (1));
var G__8091 = ((hash_code + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__8092 = cljs.core.next(coll__$1);
n = G__8090;
hash_code = G__8091;
coll__$1 = G__8092;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_unordered_hash = cljs.core.mix_collection_hash((0),(0));


(cljs.core.ICounted["null"] = true);

(cljs.core._count["null"] = (function (_){
return (0);
}));
Date.prototype.cljs$core$IEquiv$ = true;

Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var o__$1 = this;
return ((other instanceof Date)) && ((o__$1.toString() === other.toString()));
});
(cljs.core.IEquiv["number"] = true);

(cljs.core._equiv["number"] = (function (x,o){
return (x === o);
}));
(cljs.core.IMeta["function"] = true);

(cljs.core._meta["function"] = (function (_){
return null;
}));

(cljs.core.Fn["function"] = true);
(cljs.core.IHash["_"] = true);

(cljs.core._hash["_"] = (function (o){
var G__8093 = o;
return goog.getUid(G__8093);
}));
/**
* Returns a number one greater than num.
*/
cljs.core.inc = (function inc(x){
return (x + (1));
});

/**
* @constructor
*/
cljs.core.Reduced = (function (val){
this.val = val;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32768;
})
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = (function (o){
var self__ = this;
var o__$1 = this;
return self__.val;
});

cljs.core.Reduced.cljs$lang$type = true;

cljs.core.Reduced.cljs$lang$ctorStr = "cljs.core/Reduced";

cljs.core.Reduced.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/Reduced");
});

cljs.core.__GT_Reduced = (function __GT_Reduced(val){
return (new cljs.core.Reduced(val));
});

/**
* Wraps x in a way such that a reduce will terminate with the value x
*/
cljs.core.reduced = (function reduced(x){
return (new cljs.core.Reduced(x));
});
/**
* Returns true if x is the result of a call to reduced
*/
cljs.core.reduced_QMARK_ = (function reduced_QMARK_(r){
return (r instanceof cljs.core.Reduced);
});
/**
* If x is already reduced?, returns it, else returns (reduced x)
*/
cljs.core.ensure_reduced = (function ensure_reduced(x){
if(cljs.core.reduced_QMARK_(x)){
return x;
} else {
return cljs.core.reduced(x);
}
});
/**
* If x is reduced?, returns (deref x), else returns x
*/
cljs.core.unreduced = (function unreduced(x){
if(cljs.core.reduced_QMARK_(x)){
var G__8095 = x;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__8095) : cljs.core.deref.call(null,G__8095));
} else {
return x;
}
});
cljs.core.deref = (function deref(o){
return cljs.core._deref(o);
});
/**
* Accepts any collection which satisfies the ICount and IIndexed protocols and
* reduces them without incurring seq initialization
*/
cljs.core.ci_reduce = (function() {
var ci_reduce = null;
var ci_reduce__2 = (function (cicoll,f){
var cnt = cljs.core._count(cicoll);
if((cnt === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,(0));
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__8102 = val;
var G__8103 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8102,G__8103) : f.call(null,G__8102,G__8103));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__8108 = nval;
var G__8109 = (n + (1));
val = G__8108;
n = G__8109;
continue;
}
} else {
return val;
}
break;
}
}
});
var ci_reduce__3 = (function (cicoll,f,val){
var cnt = cljs.core._count(cicoll);
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__8104 = val__$1;
var G__8105 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8104,G__8105) : f.call(null,G__8104,G__8105));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__8110 = nval;
var G__8111 = (n + (1));
val__$1 = G__8110;
n = G__8111;
continue;
}
} else {
return val__$1;
}
break;
}
});
var ci_reduce__4 = (function (cicoll,f,val,idx){
var cnt = cljs.core._count(cicoll);
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__8106 = val__$1;
var G__8107 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8106,G__8107) : f.call(null,G__8106,G__8107));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__8112 = nval;
var G__8113 = (n + (1));
val__$1 = G__8112;
n = G__8113;
continue;
}
} else {
return val__$1;
}
break;
}
});
ci_reduce = function(cicoll,f,val,idx){
switch(arguments.length){
case 2:
return ci_reduce__2.call(this,cicoll,f);
case 3:
return ci_reduce__3.call(this,cicoll,f,val);
case 4:
return ci_reduce__4.call(this,cicoll,f,val,idx);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
ci_reduce.cljs$core$IFn$_invoke$arity$2 = ci_reduce__2;
ci_reduce.cljs$core$IFn$_invoke$arity$3 = ci_reduce__3;
ci_reduce.cljs$core$IFn$_invoke$arity$4 = ci_reduce__4;
return ci_reduce;
})()
;
cljs.core.array_reduce = (function() {
var array_reduce = null;
var array_reduce__2 = (function (arr,f){
var cnt = arr.length;
if((arr.length === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = (arr[(0)]);
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__8120 = val;
var G__8121 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8120,G__8121) : f.call(null,G__8120,G__8121));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__8126 = nval;
var G__8127 = (n + (1));
val = G__8126;
n = G__8127;
continue;
}
} else {
return val;
}
break;
}
}
});
var array_reduce__3 = (function (arr,f,val){
var cnt = arr.length;
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__8122 = val__$1;
var G__8123 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8122,G__8123) : f.call(null,G__8122,G__8123));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__8128 = nval;
var G__8129 = (n + (1));
val__$1 = G__8128;
n = G__8129;
continue;
}
} else {
return val__$1;
}
break;
}
});
var array_reduce__4 = (function (arr,f,val,idx){
var cnt = arr.length;
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__8124 = val__$1;
var G__8125 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8124,G__8125) : f.call(null,G__8124,G__8125));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__8130 = nval;
var G__8131 = (n + (1));
val__$1 = G__8130;
n = G__8131;
continue;
}
} else {
return val__$1;
}
break;
}
});
array_reduce = function(arr,f,val,idx){
switch(arguments.length){
case 2:
return array_reduce__2.call(this,arr,f);
case 3:
return array_reduce__3.call(this,arr,f,val);
case 4:
return array_reduce__4.call(this,arr,f,val,idx);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
array_reduce.cljs$core$IFn$_invoke$arity$2 = array_reduce__2;
array_reduce.cljs$core$IFn$_invoke$arity$3 = array_reduce__3;
array_reduce.cljs$core$IFn$_invoke$arity$4 = array_reduce__4;
return array_reduce;
})()
;



/**
* Returns true if coll implements count in constant time
*/
cljs.core.counted_QMARK_ = (function counted_QMARK_(x){
var G__8133 = x;
if(G__8133){
var bit__4439__auto__ = (G__8133.cljs$lang$protocol_mask$partition0$ & (2));
if((bit__4439__auto__) || (G__8133.cljs$core$ICounted$)){
return true;
} else {
if((!G__8133.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,G__8133);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,G__8133);
}
});
/**
* Returns true if coll implements nth in constant time
*/
cljs.core.indexed_QMARK_ = (function indexed_QMARK_(x){
var G__8135 = x;
if(G__8135){
var bit__4439__auto__ = (G__8135.cljs$lang$protocol_mask$partition0$ & (16));
if((bit__4439__auto__) || (G__8135.cljs$core$IIndexed$)){
return true;
} else {
if((!G__8135.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,G__8135);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,G__8135);
}
});

/**
* @constructor
*/
cljs.core.IndexedSeqIterator = (function (arr,i){
this.arr = arr;
this.i = i;
})
cljs.core.IndexedSeqIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
});

cljs.core.IndexedSeqIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.IndexedSeqIterator.cljs$lang$type = true;

cljs.core.IndexedSeqIterator.cljs$lang$ctorStr = "cljs.core/IndexedSeqIterator";

cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/IndexedSeqIterator");
});

cljs.core.__GT_IndexedSeqIterator = (function __GT_IndexedSeqIterator(arr,i){
return (new cljs.core.IndexedSeqIterator(arr,i));
});


/**
* @constructor
*/
cljs.core.IndexedSeq = (function (arr,i){
this.arr = arr;
this.i = i;
this.cljs$lang$protocol_mask$partition0$ = 166199550;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.IndexedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.IndexedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if((i__$1 < self__.arr.length)){
return (self__.arr[i__$1]);
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if((i__$1 < self__.arr.length)){
return (self__.arr[i__$1]);
} else {
return not_found;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IIterable$ = true;

cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.IndexedSeqIterator(self__.arr,self__.i));
});

cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.IndexedSeq(self__.arr,self__.i));
});

cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1))));
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.arr.length - self__.i);
});

cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var c = cljs.core._count(coll__$1);
if((c > (0))){
return (new cljs.core.RSeq(coll__$1,(c - (1)),null));
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
var G__8136 = coll__$1;
var G__8137 = other;
return (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(G__8136,G__8137) : cljs.core.equiv_sequential.call(null,G__8136,G__8137));
});

cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.i]),(self__.i + (1)));
});

cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.i);
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.arr[self__.i]);
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1))));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__8138 = o;
var G__8139 = coll__$1;
return (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(G__8138,G__8139) : cljs.core.cons.call(null,G__8138,G__8139));
});

cljs.core.IndexedSeq.cljs$lang$type = true;

cljs.core.IndexedSeq.cljs$lang$ctorStr = "cljs.core/IndexedSeq";

cljs.core.IndexedSeq.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/IndexedSeq");
});

cljs.core.__GT_IndexedSeq = (function __GT_IndexedSeq(arr,i){
return (new cljs.core.IndexedSeq(arr,i));
});

(cljs.core.IndexedSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
cljs.core.prim_seq = (function() {
var prim_seq = null;
var prim_seq__1 = (function (prim){
return prim_seq.cljs$core$IFn$_invoke$arity$2(prim,(0));
});
var prim_seq__2 = (function (prim,i){
if((i < prim.length)){
return (new cljs.core.IndexedSeq(prim,i));
} else {
return null;
}
});
prim_seq = function(prim,i){
switch(arguments.length){
case 1:
return prim_seq__1.call(this,prim);
case 2:
return prim_seq__2.call(this,prim,i);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
prim_seq.cljs$core$IFn$_invoke$arity$1 = prim_seq__1;
prim_seq.cljs$core$IFn$_invoke$arity$2 = prim_seq__2;
return prim_seq;
})()
;
cljs.core.array_seq = (function() {
var array_seq = null;
var array_seq__1 = (function (array){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,(0));
});
var array_seq__2 = (function (array,i){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,i);
});
array_seq = function(array,i){
switch(arguments.length){
case 1:
return array_seq__1.call(this,array);
case 2:
return array_seq__2.call(this,array,i);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
array_seq.cljs$core$IFn$_invoke$arity$1 = array_seq__1;
array_seq.cljs$core$IFn$_invoke$arity$2 = array_seq__2;
return array_seq;
})()
;


/**
* @constructor
*/
cljs.core.RSeq = (function (ci,i,meta){
this.ci = ci;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.RSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.RSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,self__.meta));
});

cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return null;
}
});

cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.i + (1));
});

cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
var G__8142 = coll__$1;
var G__8143 = other;
return (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(G__8142,G__8143) : cljs.core.equiv_sequential.call(null,G__8142,G__8143));
});

cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var G__8144 = cljs.core.List.EMPTY;
var G__8145 = self__.meta;
return (cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2(G__8144,G__8145) : cljs.core.with_meta.call(null,G__8144,G__8145));
});

cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (col,f){
var self__ = this;
var col__$1 = this;
var G__8146 = f;
var G__8147 = col__$1;
return (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(G__8146,G__8147) : cljs.core.seq_reduce.call(null,G__8146,G__8147));
});

cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (col,f,start){
var self__ = this;
var col__$1 = this;
var G__8148 = f;
var G__8149 = start;
var G__8150 = col__$1;
return (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(G__8148,G__8149,G__8150) : cljs.core.seq_reduce.call(null,G__8148,G__8149,G__8150));
});

cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.ci,self__.i);
});

cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,new_meta));
});

cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__8151 = o;
var G__8152 = coll__$1;
return (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(G__8151,G__8152) : cljs.core.cons.call(null,G__8151,G__8152));
});

cljs.core.RSeq.cljs$lang$type = true;

cljs.core.RSeq.cljs$lang$ctorStr = "cljs.core/RSeq";

cljs.core.RSeq.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/RSeq");
});

cljs.core.__GT_RSeq = (function __GT_RSeq(ci,i,meta){
return (new cljs.core.RSeq(ci,i,meta));
});

(cljs.core.RSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
/**
* Same as (first (next x))
*/
cljs.core.second = (function second(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
* Same as (first (first x))
*/
cljs.core.ffirst = (function ffirst(coll){
return cljs.core.first(cljs.core.first(coll));
});
/**
* Same as (next (first x))
*/
cljs.core.nfirst = (function nfirst(coll){
return cljs.core.next(cljs.core.first(coll));
});
/**
* Same as (first (next x))
*/
cljs.core.fnext = (function fnext(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
* Same as (next (next x))
*/
cljs.core.nnext = (function nnext(coll){
return cljs.core.next(cljs.core.next(coll));
});
/**
* Return the last item in coll, in linear time
*/
cljs.core.last = (function last(s){
while(true){
var sn = cljs.core.next(s);
if(!((sn == null))){
var G__8153 = sn;
s = G__8153;
continue;
} else {
return cljs.core.first(s);
}
break;
}
});
(cljs.core.IEquiv["_"] = true);

(cljs.core._equiv["_"] = (function (x,o){
return (x === o);
}));
/**
* conj[oin]. Returns a new collection with the xs
* 'added'. (conj nil item) returns (item).  The 'addition' may
* happen at different 'places' depending on the concrete type.
* @param {...*} var_args
*/
cljs.core.conj = (function() {
var conj = null;
var conj__0 = (function (){
return cljs.core.PersistentVector.EMPTY;
});
var conj__1 = (function (coll){
return coll;
});
var conj__2 = (function (coll,x){
if(!((coll == null))){
return cljs.core._conj(coll,x);
} else {
return cljs.core._conj(cljs.core.List.EMPTY,x);
}
});
var conj__3 = (function() { 
var G__8158__delegate = function (coll,x,xs){
while(true){
if(cljs.core.truth_(xs)){
var G__8159 = conj.cljs$core$IFn$_invoke$arity$2(coll,x);
var G__8160 = cljs.core.first(xs);
var G__8161 = cljs.core.next(xs);
coll = G__8159;
x = G__8160;
xs = G__8161;
continue;
} else {
return conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
break;
}
};
var G__8158 = function (coll,x,var_args){
var xs = null;
if (arguments.length > 2) {
var G__8162__i = 0, G__8162__a = new Array(arguments.length -  2);
while (G__8162__i < G__8162__a.length) {G__8162__a[G__8162__i] = arguments[G__8162__i + 2]; ++G__8162__i;}
  xs = new cljs.core.IndexedSeq(G__8162__a,0);
} 
return G__8158__delegate.call(this,coll,x,xs);};
G__8158.cljs$lang$maxFixedArity = 2;
G__8158.cljs$lang$applyTo = (function (arglist__8163){
var coll = cljs.core.first(arglist__8163);
arglist__8163 = cljs.core.next(arglist__8163);
var x = cljs.core.first(arglist__8163);
var xs = cljs.core.rest(arglist__8163);
return G__8158__delegate(coll,x,xs);
});
G__8158.cljs$core$IFn$_invoke$arity$variadic = G__8158__delegate;
return G__8158;
})()
;
conj = function(coll,x,var_args){
var xs = var_args;
switch(arguments.length){
case 0:
return conj__0.call(this);
case 1:
return conj__1.call(this,coll);
case 2:
return conj__2.call(this,coll,x);
default:
var G__8164 = null;
if (arguments.length > 2) {
var G__8165__i = 0, G__8165__a = new Array(arguments.length -  2);
while (G__8165__i < G__8165__a.length) {G__8165__a[G__8165__i] = arguments[G__8165__i + 2]; ++G__8165__i;}
G__8164 = new cljs.core.IndexedSeq(G__8165__a,0);
}
return conj__3.cljs$core$IFn$_invoke$arity$variadic(coll,x, G__8164);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
conj.cljs$lang$maxFixedArity = 2;
conj.cljs$lang$applyTo = conj__3.cljs$lang$applyTo;
conj.cljs$core$IFn$_invoke$arity$0 = conj__0;
conj.cljs$core$IFn$_invoke$arity$1 = conj__1;
conj.cljs$core$IFn$_invoke$arity$2 = conj__2;
conj.cljs$core$IFn$_invoke$arity$variadic = conj__3.cljs$core$IFn$_invoke$arity$variadic;
return conj;
})()
;
/**
* Returns an empty collection of the same category as coll, or nil
*/
cljs.core.empty = (function empty(coll){
if((coll == null)){
return null;
} else {
return cljs.core._empty(coll);
}
});
cljs.core.accumulating_seq_count = (function accumulating_seq_count(coll){
var s = cljs.core.seq(coll);
var acc = (0);
while(true){
if(cljs.core.counted_QMARK_(s)){
return (acc + cljs.core._count(s));
} else {
var G__8166 = cljs.core.next(s);
var G__8167 = (acc + (1));
s = G__8166;
acc = G__8167;
continue;
}
break;
}
});
/**
* Returns the number of items in the collection. (count nil) returns
* 0.  Also works on strings, arrays, and Maps
*/
cljs.core.count = (function count(coll){
if(!((coll == null))){
if((function (){var G__8169 = coll;
if(G__8169){
var bit__4432__auto__ = (G__8169.cljs$lang$protocol_mask$partition0$ & (2));
if((bit__4432__auto__) || (G__8169.cljs$core$ICounted$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ICounted$_count$arity$1(null);
} else {
if(coll instanceof Array){
return coll.length;
} else {
if(typeof coll === 'string'){
return coll.length;
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,coll)){
return cljs.core._count(coll);
} else {
return cljs.core.accumulating_seq_count(coll);

}
}
}
}
} else {
return (0);
}
});
cljs.core.linear_traversal_nth = (function() {
var linear_traversal_nth = null;
var linear_traversal_nth__2 = (function (coll,n){
while(true){
if((coll == null)){
throw (new Error("Index out of bounds"));
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if(cljs.core.seq(coll)){
var G__8170 = cljs.core.next(coll);
var G__8171 = (n - (1));
coll = G__8170;
n = G__8171;
continue;
} else {
throw (new Error("Index out of bounds"));

}
}
}
}
break;
}
});
var linear_traversal_nth__3 = (function (coll,n,not_found){
while(true){
if((coll == null)){
return not_found;
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
return not_found;
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
if(cljs.core.seq(coll)){
var G__8172 = cljs.core.next(coll);
var G__8173 = (n - (1));
var G__8174 = not_found;
coll = G__8172;
n = G__8173;
not_found = G__8174;
continue;
} else {
return not_found;

}
}
}
}
break;
}
});
linear_traversal_nth = function(coll,n,not_found){
switch(arguments.length){
case 2:
return linear_traversal_nth__2.call(this,coll,n);
case 3:
return linear_traversal_nth__3.call(this,coll,n,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = linear_traversal_nth__2;
linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = linear_traversal_nth__3;
return linear_traversal_nth;
})()
;
/**
* Returns the value at the index. get returns nil if index out of
* bounds, nth throws an exception unless not-found is supplied.  nth
* also works for strings, arrays, regex Matchers and Lists, and,
* in O(n) time, for sequences.
*/
cljs.core.nth = (function() {
var nth = null;
var nth__2 = (function (coll,n){
if(!(typeof n === 'number')){
throw (new Error("index argument to nth must be a number"));
} else {
if((coll == null)){
return coll;
} else {
if((function (){var G__8179 = coll;
if(G__8179){
var bit__4432__auto__ = (G__8179.cljs$lang$protocol_mask$partition0$ & (16));
if((bit__4432__auto__) || (G__8179.cljs$core$IIndexed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$2(null,n);
} else {
if(coll instanceof Array){
if((n < coll.length)){
return (coll[n]);
} else {
return null;
}
} else {
if(typeof coll === 'string'){
if((n < coll.length)){
return (coll[n]);
} else {
return null;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if((function (){var G__8180 = coll;
if(G__8180){
var bit__4439__auto__ = (G__8180.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4439__auto__) || (G__8180.cljs$core$ISeq$)){
return true;
} else {
if((!G__8180.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__8180);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__8180);
}
})()){
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
throw (new Error([cljs.core.str("nth not supported on this type "),cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
});
var nth__3 = (function (coll,n,not_found){
if(!(typeof n === 'number')){
throw (new Error("index argument to nth must be a number."));
} else {
if((coll == null)){
return not_found;
} else {
if((function (){var G__8181 = coll;
if(G__8181){
var bit__4432__auto__ = (G__8181.cljs$lang$protocol_mask$partition0$ & (16));
if((bit__4432__auto__) || (G__8181.cljs$core$IIndexed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$3(null,n,not_found);
} else {
if(coll instanceof Array){
if((n < coll.length)){
return (coll[n]);
} else {
return not_found;
}
} else {
if(typeof coll === 'string'){
if((n < coll.length)){
return (coll[n]);
} else {
return not_found;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if((function (){var G__8182 = coll;
if(G__8182){
var bit__4439__auto__ = (G__8182.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4439__auto__) || (G__8182.cljs$core$ISeq$)){
return true;
} else {
if((!G__8182.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__8182);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__8182);
}
})()){
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
throw (new Error([cljs.core.str("nth not supported on this type "),cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
});
nth = function(coll,n,not_found){
switch(arguments.length){
case 2:
return nth__2.call(this,coll,n);
case 3:
return nth__3.call(this,coll,n,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
nth.cljs$core$IFn$_invoke$arity$2 = nth__2;
nth.cljs$core$IFn$_invoke$arity$3 = nth__3;
return nth;
})()
;
/**
* Returns the nth rest of coll, coll when n is 0.
*/
cljs.core.nthrest = (function nthrest(coll,n){
var n__$1 = n;
var xs = coll;
while(true){
if(((n__$1 > (0))) && (cljs.core.seq(xs))){
var G__8183 = (n__$1 - (1));
var G__8184 = cljs.core.rest(xs);
n__$1 = G__8183;
xs = G__8184;
continue;
} else {
return xs;
}
break;
}
});
/**
* Returns the value mapped to key, not-found or nil if key not present.
*/
cljs.core.get = (function() {
var get = null;
var get__2 = (function (o,k){
if((o == null)){
return null;
} else {
if((function (){var G__8187 = o;
if(G__8187){
var bit__4432__auto__ = (G__8187.cljs$lang$protocol_mask$partition0$ & (256));
if((bit__4432__auto__) || (G__8187.cljs$core$ILookup$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$2(null,k);
} else {
if(o instanceof Array){
if((k < o.length)){
return (o[k]);
} else {
return null;
}
} else {
if(typeof o === 'string'){
if((k < o.length)){
return (o[k]);
} else {
return null;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(o,k);
} else {
return null;

}
}
}
}
}
});
var get__3 = (function (o,k,not_found){
if(!((o == null))){
if((function (){var G__8188 = o;
if(G__8188){
var bit__4432__auto__ = (G__8188.cljs$lang$protocol_mask$partition0$ & (256));
if((bit__4432__auto__) || (G__8188.cljs$core$ILookup$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
} else {
if(o instanceof Array){
if((k < o.length)){
return (o[k]);
} else {
return not_found;
}
} else {
if(typeof o === 'string'){
if((k < o.length)){
return (o[k]);
} else {
return not_found;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(o,k,not_found);
} else {
return not_found;

}
}
}
}
} else {
return not_found;
}
});
get = function(o,k,not_found){
switch(arguments.length){
case 2:
return get__2.call(this,o,k);
case 3:
return get__3.call(this,o,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
get.cljs$core$IFn$_invoke$arity$2 = get__2;
get.cljs$core$IFn$_invoke$arity$3 = get__3;
return get;
})()
;
/**
* assoc[iate]. When applied to a map, returns a new map of the
* same (hashed/sorted) type, that contains the mapping of key(s) to
* val(s). When applied to a vector, returns a new vector that
* contains val at index.
* @param {...*} var_args
*/
cljs.core.assoc = (function() {
var assoc = null;
var assoc__3 = (function (coll,k,v){
if(!((coll == null))){
return cljs.core._assoc(coll,k,v);
} else {
return cljs.core.PersistentHashMap.fromArrays([k],[v]);
}
});
var assoc__4 = (function() { 
var G__8192__delegate = function (coll,k,v,kvs){
while(true){
var ret = assoc.cljs$core$IFn$_invoke$arity$3(coll,k,v);
if(cljs.core.truth_(kvs)){
var G__8193 = ret;
var G__8194 = cljs.core.first(kvs);
var G__8195 = cljs.core.second(kvs);
var G__8196 = cljs.core.nnext(kvs);
coll = G__8193;
k = G__8194;
v = G__8195;
kvs = G__8196;
continue;
} else {
return ret;
}
break;
}
};
var G__8192 = function (coll,k,v,var_args){
var kvs = null;
if (arguments.length > 3) {
var G__8197__i = 0, G__8197__a = new Array(arguments.length -  3);
while (G__8197__i < G__8197__a.length) {G__8197__a[G__8197__i] = arguments[G__8197__i + 3]; ++G__8197__i;}
  kvs = new cljs.core.IndexedSeq(G__8197__a,0);
} 
return G__8192__delegate.call(this,coll,k,v,kvs);};
G__8192.cljs$lang$maxFixedArity = 3;
G__8192.cljs$lang$applyTo = (function (arglist__8198){
var coll = cljs.core.first(arglist__8198);
arglist__8198 = cljs.core.next(arglist__8198);
var k = cljs.core.first(arglist__8198);
arglist__8198 = cljs.core.next(arglist__8198);
var v = cljs.core.first(arglist__8198);
var kvs = cljs.core.rest(arglist__8198);
return G__8192__delegate(coll,k,v,kvs);
});
G__8192.cljs$core$IFn$_invoke$arity$variadic = G__8192__delegate;
return G__8192;
})()
;
assoc = function(coll,k,v,var_args){
var kvs = var_args;
switch(arguments.length){
case 3:
return assoc__3.call(this,coll,k,v);
default:
var G__8199 = null;
if (arguments.length > 3) {
var G__8200__i = 0, G__8200__a = new Array(arguments.length -  3);
while (G__8200__i < G__8200__a.length) {G__8200__a[G__8200__i] = arguments[G__8200__i + 3]; ++G__8200__i;}
G__8199 = new cljs.core.IndexedSeq(G__8200__a,0);
}
return assoc__4.cljs$core$IFn$_invoke$arity$variadic(coll,k,v, G__8199);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
assoc.cljs$lang$maxFixedArity = 3;
assoc.cljs$lang$applyTo = assoc__4.cljs$lang$applyTo;
assoc.cljs$core$IFn$_invoke$arity$3 = assoc__3;
assoc.cljs$core$IFn$_invoke$arity$variadic = assoc__4.cljs$core$IFn$_invoke$arity$variadic;
return assoc;
})()
;
/**
* dissoc[iate]. Returns a new map of the same (hashed/sorted) type,
* that does not contain a mapping for key(s).
* @param {...*} var_args
*/
cljs.core.dissoc = (function() {
var dissoc = null;
var dissoc__1 = (function (coll){
return coll;
});
var dissoc__2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._dissoc(coll,k);
}
});
var dissoc__3 = (function() { 
var G__8203__delegate = function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = dissoc.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__8204 = ret;
var G__8205 = cljs.core.first(ks);
var G__8206 = cljs.core.next(ks);
coll = G__8204;
k = G__8205;
ks = G__8206;
continue;
} else {
return ret;
}
}
break;
}
};
var G__8203 = function (coll,k,var_args){
var ks = null;
if (arguments.length > 2) {
var G__8207__i = 0, G__8207__a = new Array(arguments.length -  2);
while (G__8207__i < G__8207__a.length) {G__8207__a[G__8207__i] = arguments[G__8207__i + 2]; ++G__8207__i;}
  ks = new cljs.core.IndexedSeq(G__8207__a,0);
} 
return G__8203__delegate.call(this,coll,k,ks);};
G__8203.cljs$lang$maxFixedArity = 2;
G__8203.cljs$lang$applyTo = (function (arglist__8208){
var coll = cljs.core.first(arglist__8208);
arglist__8208 = cljs.core.next(arglist__8208);
var k = cljs.core.first(arglist__8208);
var ks = cljs.core.rest(arglist__8208);
return G__8203__delegate(coll,k,ks);
});
G__8203.cljs$core$IFn$_invoke$arity$variadic = G__8203__delegate;
return G__8203;
})()
;
dissoc = function(coll,k,var_args){
var ks = var_args;
switch(arguments.length){
case 1:
return dissoc__1.call(this,coll);
case 2:
return dissoc__2.call(this,coll,k);
default:
var G__8209 = null;
if (arguments.length > 2) {
var G__8210__i = 0, G__8210__a = new Array(arguments.length -  2);
while (G__8210__i < G__8210__a.length) {G__8210__a[G__8210__i] = arguments[G__8210__i + 2]; ++G__8210__i;}
G__8209 = new cljs.core.IndexedSeq(G__8210__a,0);
}
return dissoc__3.cljs$core$IFn$_invoke$arity$variadic(coll,k, G__8209);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
dissoc.cljs$lang$maxFixedArity = 2;
dissoc.cljs$lang$applyTo = dissoc__3.cljs$lang$applyTo;
dissoc.cljs$core$IFn$_invoke$arity$1 = dissoc__1;
dissoc.cljs$core$IFn$_invoke$arity$2 = dissoc__2;
dissoc.cljs$core$IFn$_invoke$arity$variadic = dissoc__3.cljs$core$IFn$_invoke$arity$variadic;
return dissoc;
})()
;
cljs.core.fn_QMARK_ = (function fn_QMARK_(f){
var or__3758__auto__ = (function (){var G__8215 = f;
return goog.isFunction(G__8215);
})();
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
var G__8216 = f;
if(G__8216){
var bit__4439__auto__ = null;
if(cljs.core.truth_((function (){var or__3758__auto____$1 = bit__4439__auto__;
if(cljs.core.truth_(or__3758__auto____$1)){
return or__3758__auto____$1;
} else {
return G__8216.cljs$core$Fn$;
}
})())){
return true;
} else {
if((!G__8216.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,G__8216);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,G__8216);
}
}
});

/**
* @constructor
*/
cljs.core.MetaFn = (function (afn,meta){
this.afn = afn;
this.meta = meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393217;
})
cljs.core.MetaFn.prototype.call = (function() {
var G__8682 = null;
var G__8682__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});
var G__8682__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8218 = a;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(G__8218) : self__.afn.call(null,G__8218));
});
var G__8682__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8219 = a;
var G__8220 = b;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(G__8219,G__8220) : self__.afn.call(null,G__8219,G__8220));
});
var G__8682__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8221 = a;
var G__8222 = b;
var G__8223 = c;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(G__8221,G__8222,G__8223) : self__.afn.call(null,G__8221,G__8222,G__8223));
});
var G__8682__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8224 = a;
var G__8225 = b;
var G__8226 = c;
var G__8227 = d;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(G__8224,G__8225,G__8226,G__8227) : self__.afn.call(null,G__8224,G__8225,G__8226,G__8227));
});
var G__8682__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8228 = a;
var G__8229 = b;
var G__8230 = c;
var G__8231 = d;
var G__8232 = e;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(G__8228,G__8229,G__8230,G__8231,G__8232) : self__.afn.call(null,G__8228,G__8229,G__8230,G__8231,G__8232));
});
var G__8682__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8233 = a;
var G__8234 = b;
var G__8235 = c;
var G__8236 = d;
var G__8237 = e;
var G__8238 = f;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(G__8233,G__8234,G__8235,G__8236,G__8237,G__8238) : self__.afn.call(null,G__8233,G__8234,G__8235,G__8236,G__8237,G__8238));
});
var G__8682__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8239 = a;
var G__8240 = b;
var G__8241 = c;
var G__8242 = d;
var G__8243 = e;
var G__8244 = f;
var G__8245 = g;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(G__8239,G__8240,G__8241,G__8242,G__8243,G__8244,G__8245) : self__.afn.call(null,G__8239,G__8240,G__8241,G__8242,G__8243,G__8244,G__8245));
});
var G__8682__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8246 = a;
var G__8247 = b;
var G__8248 = c;
var G__8249 = d;
var G__8250 = e;
var G__8251 = f;
var G__8252 = g;
var G__8253 = h;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(G__8246,G__8247,G__8248,G__8249,G__8250,G__8251,G__8252,G__8253) : self__.afn.call(null,G__8246,G__8247,G__8248,G__8249,G__8250,G__8251,G__8252,G__8253));
});
var G__8682__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8254 = a;
var G__8255 = b;
var G__8256 = c;
var G__8257 = d;
var G__8258 = e;
var G__8259 = f;
var G__8260 = g;
var G__8261 = h;
var G__8262 = i;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(G__8254,G__8255,G__8256,G__8257,G__8258,G__8259,G__8260,G__8261,G__8262) : self__.afn.call(null,G__8254,G__8255,G__8256,G__8257,G__8258,G__8259,G__8260,G__8261,G__8262));
});
var G__8682__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8263 = a;
var G__8264 = b;
var G__8265 = c;
var G__8266 = d;
var G__8267 = e;
var G__8268 = f;
var G__8269 = g;
var G__8270 = h;
var G__8271 = i;
var G__8272 = j;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(G__8263,G__8264,G__8265,G__8266,G__8267,G__8268,G__8269,G__8270,G__8271,G__8272) : self__.afn.call(null,G__8263,G__8264,G__8265,G__8266,G__8267,G__8268,G__8269,G__8270,G__8271,G__8272));
});
var G__8682__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8273 = a;
var G__8274 = b;
var G__8275 = c;
var G__8276 = d;
var G__8277 = e;
var G__8278 = f;
var G__8279 = g;
var G__8280 = h;
var G__8281 = i;
var G__8282 = j;
var G__8283 = k;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(G__8273,G__8274,G__8275,G__8276,G__8277,G__8278,G__8279,G__8280,G__8281,G__8282,G__8283) : self__.afn.call(null,G__8273,G__8274,G__8275,G__8276,G__8277,G__8278,G__8279,G__8280,G__8281,G__8282,G__8283));
});
var G__8682__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8284 = a;
var G__8285 = b;
var G__8286 = c;
var G__8287 = d;
var G__8288 = e;
var G__8289 = f;
var G__8290 = g;
var G__8291 = h;
var G__8292 = i;
var G__8293 = j;
var G__8294 = k;
var G__8295 = l;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(G__8284,G__8285,G__8286,G__8287,G__8288,G__8289,G__8290,G__8291,G__8292,G__8293,G__8294,G__8295) : self__.afn.call(null,G__8284,G__8285,G__8286,G__8287,G__8288,G__8289,G__8290,G__8291,G__8292,G__8293,G__8294,G__8295));
});
var G__8682__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8296 = a;
var G__8297 = b;
var G__8298 = c;
var G__8299 = d;
var G__8300 = e;
var G__8301 = f;
var G__8302 = g;
var G__8303 = h;
var G__8304 = i;
var G__8305 = j;
var G__8306 = k;
var G__8307 = l;
var G__8308 = m;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(G__8296,G__8297,G__8298,G__8299,G__8300,G__8301,G__8302,G__8303,G__8304,G__8305,G__8306,G__8307,G__8308) : self__.afn.call(null,G__8296,G__8297,G__8298,G__8299,G__8300,G__8301,G__8302,G__8303,G__8304,G__8305,G__8306,G__8307,G__8308));
});
var G__8682__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8309 = a;
var G__8310 = b;
var G__8311 = c;
var G__8312 = d;
var G__8313 = e;
var G__8314 = f;
var G__8315 = g;
var G__8316 = h;
var G__8317 = i;
var G__8318 = j;
var G__8319 = k;
var G__8320 = l;
var G__8321 = m;
var G__8322 = n;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(G__8309,G__8310,G__8311,G__8312,G__8313,G__8314,G__8315,G__8316,G__8317,G__8318,G__8319,G__8320,G__8321,G__8322) : self__.afn.call(null,G__8309,G__8310,G__8311,G__8312,G__8313,G__8314,G__8315,G__8316,G__8317,G__8318,G__8319,G__8320,G__8321,G__8322));
});
var G__8682__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8323 = a;
var G__8324 = b;
var G__8325 = c;
var G__8326 = d;
var G__8327 = e;
var G__8328 = f;
var G__8329 = g;
var G__8330 = h;
var G__8331 = i;
var G__8332 = j;
var G__8333 = k;
var G__8334 = l;
var G__8335 = m;
var G__8336 = n;
var G__8337 = o;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(G__8323,G__8324,G__8325,G__8326,G__8327,G__8328,G__8329,G__8330,G__8331,G__8332,G__8333,G__8334,G__8335,G__8336,G__8337) : self__.afn.call(null,G__8323,G__8324,G__8325,G__8326,G__8327,G__8328,G__8329,G__8330,G__8331,G__8332,G__8333,G__8334,G__8335,G__8336,G__8337));
});
var G__8682__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8338 = a;
var G__8339 = b;
var G__8340 = c;
var G__8341 = d;
var G__8342 = e;
var G__8343 = f;
var G__8344 = g;
var G__8345 = h;
var G__8346 = i;
var G__8347 = j;
var G__8348 = k;
var G__8349 = l;
var G__8350 = m;
var G__8351 = n;
var G__8352 = o;
var G__8353 = p;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(G__8338,G__8339,G__8340,G__8341,G__8342,G__8343,G__8344,G__8345,G__8346,G__8347,G__8348,G__8349,G__8350,G__8351,G__8352,G__8353) : self__.afn.call(null,G__8338,G__8339,G__8340,G__8341,G__8342,G__8343,G__8344,G__8345,G__8346,G__8347,G__8348,G__8349,G__8350,G__8351,G__8352,G__8353));
});
var G__8682__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8354 = a;
var G__8355 = b;
var G__8356 = c;
var G__8357 = d;
var G__8358 = e;
var G__8359 = f;
var G__8360 = g;
var G__8361 = h;
var G__8362 = i;
var G__8363 = j;
var G__8364 = k;
var G__8365 = l;
var G__8366 = m;
var G__8367 = n;
var G__8368 = o;
var G__8369 = p;
var G__8370 = q;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(G__8354,G__8355,G__8356,G__8357,G__8358,G__8359,G__8360,G__8361,G__8362,G__8363,G__8364,G__8365,G__8366,G__8367,G__8368,G__8369,G__8370) : self__.afn.call(null,G__8354,G__8355,G__8356,G__8357,G__8358,G__8359,G__8360,G__8361,G__8362,G__8363,G__8364,G__8365,G__8366,G__8367,G__8368,G__8369,G__8370));
});
var G__8682__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8371 = a;
var G__8372 = b;
var G__8373 = c;
var G__8374 = d;
var G__8375 = e;
var G__8376 = f;
var G__8377 = g;
var G__8378 = h;
var G__8379 = i;
var G__8380 = j;
var G__8381 = k;
var G__8382 = l;
var G__8383 = m;
var G__8384 = n;
var G__8385 = o;
var G__8386 = p;
var G__8387 = q;
var G__8388 = r;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(G__8371,G__8372,G__8373,G__8374,G__8375,G__8376,G__8377,G__8378,G__8379,G__8380,G__8381,G__8382,G__8383,G__8384,G__8385,G__8386,G__8387,G__8388) : self__.afn.call(null,G__8371,G__8372,G__8373,G__8374,G__8375,G__8376,G__8377,G__8378,G__8379,G__8380,G__8381,G__8382,G__8383,G__8384,G__8385,G__8386,G__8387,G__8388));
});
var G__8682__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8389 = a;
var G__8390 = b;
var G__8391 = c;
var G__8392 = d;
var G__8393 = e;
var G__8394 = f;
var G__8395 = g;
var G__8396 = h;
var G__8397 = i;
var G__8398 = j;
var G__8399 = k;
var G__8400 = l;
var G__8401 = m;
var G__8402 = n;
var G__8403 = o;
var G__8404 = p;
var G__8405 = q;
var G__8406 = r;
var G__8407 = s;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(G__8389,G__8390,G__8391,G__8392,G__8393,G__8394,G__8395,G__8396,G__8397,G__8398,G__8399,G__8400,G__8401,G__8402,G__8403,G__8404,G__8405,G__8406,G__8407) : self__.afn.call(null,G__8389,G__8390,G__8391,G__8392,G__8393,G__8394,G__8395,G__8396,G__8397,G__8398,G__8399,G__8400,G__8401,G__8402,G__8403,G__8404,G__8405,G__8406,G__8407));
});
var G__8682__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8408 = a;
var G__8409 = b;
var G__8410 = c;
var G__8411 = d;
var G__8412 = e;
var G__8413 = f;
var G__8414 = g;
var G__8415 = h;
var G__8416 = i;
var G__8417 = j;
var G__8418 = k;
var G__8419 = l;
var G__8420 = m;
var G__8421 = n;
var G__8422 = o;
var G__8423 = p;
var G__8424 = q;
var G__8425 = r;
var G__8426 = s;
var G__8427 = t;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(G__8408,G__8409,G__8410,G__8411,G__8412,G__8413,G__8414,G__8415,G__8416,G__8417,G__8418,G__8419,G__8420,G__8421,G__8422,G__8423,G__8424,G__8425,G__8426,G__8427) : self__.afn.call(null,G__8408,G__8409,G__8410,G__8411,G__8412,G__8413,G__8414,G__8415,G__8416,G__8417,G__8418,G__8419,G__8420,G__8421,G__8422,G__8423,G__8424,G__8425,G__8426,G__8427));
});
var G__8682__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8428 = self__.afn;
var G__8429 = a;
var G__8430 = b;
var G__8431 = c;
var G__8432 = d;
var G__8433 = e;
var G__8434 = f;
var G__8435 = g;
var G__8436 = h;
var G__8437 = i;
var G__8438 = j;
var G__8439 = k;
var G__8440 = l;
var G__8441 = m;
var G__8442 = n;
var G__8443 = o;
var G__8444 = p;
var G__8445 = q;
var G__8446 = r;
var G__8447 = s;
var G__8448 = t;
var G__8449 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__8428,G__8429,G__8430,G__8431,G__8432,G__8433,G__8434,G__8435,G__8436,G__8437,G__8438,G__8439,G__8440,G__8441,G__8442,G__8443,G__8444,G__8445,G__8446,G__8447,G__8448,G__8449) : cljs.core.apply.call(null,G__8428,G__8429,G__8430,G__8431,G__8432,G__8433,G__8434,G__8435,G__8436,G__8437,G__8438,G__8439,G__8440,G__8441,G__8442,G__8443,G__8444,G__8445,G__8446,G__8447,G__8448,G__8449));
});
G__8682 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__8682__1.call(this,self__);
case 2:
return G__8682__2.call(this,self__,a);
case 3:
return G__8682__3.call(this,self__,a,b);
case 4:
return G__8682__4.call(this,self__,a,b,c);
case 5:
return G__8682__5.call(this,self__,a,b,c,d);
case 6:
return G__8682__6.call(this,self__,a,b,c,d,e);
case 7:
return G__8682__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__8682__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__8682__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__8682__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__8682__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__8682__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__8682__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__8682__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__8682__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__8682__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__8682__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__8682__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__8682__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__8682__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__8682__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__8682__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8682.cljs$core$IFn$_invoke$arity$1 = G__8682__1;
G__8682.cljs$core$IFn$_invoke$arity$2 = G__8682__2;
G__8682.cljs$core$IFn$_invoke$arity$3 = G__8682__3;
G__8682.cljs$core$IFn$_invoke$arity$4 = G__8682__4;
G__8682.cljs$core$IFn$_invoke$arity$5 = G__8682__5;
G__8682.cljs$core$IFn$_invoke$arity$6 = G__8682__6;
G__8682.cljs$core$IFn$_invoke$arity$7 = G__8682__7;
G__8682.cljs$core$IFn$_invoke$arity$8 = G__8682__8;
G__8682.cljs$core$IFn$_invoke$arity$9 = G__8682__9;
G__8682.cljs$core$IFn$_invoke$arity$10 = G__8682__10;
G__8682.cljs$core$IFn$_invoke$arity$11 = G__8682__11;
G__8682.cljs$core$IFn$_invoke$arity$12 = G__8682__12;
G__8682.cljs$core$IFn$_invoke$arity$13 = G__8682__13;
G__8682.cljs$core$IFn$_invoke$arity$14 = G__8682__14;
G__8682.cljs$core$IFn$_invoke$arity$15 = G__8682__15;
G__8682.cljs$core$IFn$_invoke$arity$16 = G__8682__16;
G__8682.cljs$core$IFn$_invoke$arity$17 = G__8682__17;
G__8682.cljs$core$IFn$_invoke$arity$18 = G__8682__18;
G__8682.cljs$core$IFn$_invoke$arity$19 = G__8682__19;
G__8682.cljs$core$IFn$_invoke$arity$20 = G__8682__20;
G__8682.cljs$core$IFn$_invoke$arity$21 = G__8682__21;
G__8682.cljs$core$IFn$_invoke$arity$22 = G__8682__22;
return G__8682;
})()
;

cljs.core.MetaFn.prototype.apply = (function (self__,args8217){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args8217)));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
var G__8450 = a;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(G__8450) : self__.afn.call(null,G__8450));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
var G__8451 = a;
var G__8452 = b;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(G__8451,G__8452) : self__.afn.call(null,G__8451,G__8452));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
var G__8453 = a;
var G__8454 = b;
var G__8455 = c;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(G__8453,G__8454,G__8455) : self__.afn.call(null,G__8453,G__8454,G__8455));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
var G__8456 = a;
var G__8457 = b;
var G__8458 = c;
var G__8459 = d;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(G__8456,G__8457,G__8458,G__8459) : self__.afn.call(null,G__8456,G__8457,G__8458,G__8459));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
var G__8460 = a;
var G__8461 = b;
var G__8462 = c;
var G__8463 = d;
var G__8464 = e;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(G__8460,G__8461,G__8462,G__8463,G__8464) : self__.afn.call(null,G__8460,G__8461,G__8462,G__8463,G__8464));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
var G__8465 = a;
var G__8466 = b;
var G__8467 = c;
var G__8468 = d;
var G__8469 = e;
var G__8470 = f;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(G__8465,G__8466,G__8467,G__8468,G__8469,G__8470) : self__.afn.call(null,G__8465,G__8466,G__8467,G__8468,G__8469,G__8470));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
var G__8471 = a;
var G__8472 = b;
var G__8473 = c;
var G__8474 = d;
var G__8475 = e;
var G__8476 = f;
var G__8477 = g;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(G__8471,G__8472,G__8473,G__8474,G__8475,G__8476,G__8477) : self__.afn.call(null,G__8471,G__8472,G__8473,G__8474,G__8475,G__8476,G__8477));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
var G__8478 = a;
var G__8479 = b;
var G__8480 = c;
var G__8481 = d;
var G__8482 = e;
var G__8483 = f;
var G__8484 = g;
var G__8485 = h;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(G__8478,G__8479,G__8480,G__8481,G__8482,G__8483,G__8484,G__8485) : self__.afn.call(null,G__8478,G__8479,G__8480,G__8481,G__8482,G__8483,G__8484,G__8485));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
var G__8486 = a;
var G__8487 = b;
var G__8488 = c;
var G__8489 = d;
var G__8490 = e;
var G__8491 = f;
var G__8492 = g;
var G__8493 = h;
var G__8494 = i;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(G__8486,G__8487,G__8488,G__8489,G__8490,G__8491,G__8492,G__8493,G__8494) : self__.afn.call(null,G__8486,G__8487,G__8488,G__8489,G__8490,G__8491,G__8492,G__8493,G__8494));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
var G__8495 = a;
var G__8496 = b;
var G__8497 = c;
var G__8498 = d;
var G__8499 = e;
var G__8500 = f;
var G__8501 = g;
var G__8502 = h;
var G__8503 = i;
var G__8504 = j;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(G__8495,G__8496,G__8497,G__8498,G__8499,G__8500,G__8501,G__8502,G__8503,G__8504) : self__.afn.call(null,G__8495,G__8496,G__8497,G__8498,G__8499,G__8500,G__8501,G__8502,G__8503,G__8504));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
var G__8505 = a;
var G__8506 = b;
var G__8507 = c;
var G__8508 = d;
var G__8509 = e;
var G__8510 = f;
var G__8511 = g;
var G__8512 = h;
var G__8513 = i;
var G__8514 = j;
var G__8515 = k;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(G__8505,G__8506,G__8507,G__8508,G__8509,G__8510,G__8511,G__8512,G__8513,G__8514,G__8515) : self__.afn.call(null,G__8505,G__8506,G__8507,G__8508,G__8509,G__8510,G__8511,G__8512,G__8513,G__8514,G__8515));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
var G__8516 = a;
var G__8517 = b;
var G__8518 = c;
var G__8519 = d;
var G__8520 = e;
var G__8521 = f;
var G__8522 = g;
var G__8523 = h;
var G__8524 = i;
var G__8525 = j;
var G__8526 = k;
var G__8527 = l;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(G__8516,G__8517,G__8518,G__8519,G__8520,G__8521,G__8522,G__8523,G__8524,G__8525,G__8526,G__8527) : self__.afn.call(null,G__8516,G__8517,G__8518,G__8519,G__8520,G__8521,G__8522,G__8523,G__8524,G__8525,G__8526,G__8527));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
var G__8528 = a;
var G__8529 = b;
var G__8530 = c;
var G__8531 = d;
var G__8532 = e;
var G__8533 = f;
var G__8534 = g;
var G__8535 = h;
var G__8536 = i;
var G__8537 = j;
var G__8538 = k;
var G__8539 = l;
var G__8540 = m;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(G__8528,G__8529,G__8530,G__8531,G__8532,G__8533,G__8534,G__8535,G__8536,G__8537,G__8538,G__8539,G__8540) : self__.afn.call(null,G__8528,G__8529,G__8530,G__8531,G__8532,G__8533,G__8534,G__8535,G__8536,G__8537,G__8538,G__8539,G__8540));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
var G__8541 = a;
var G__8542 = b;
var G__8543 = c;
var G__8544 = d;
var G__8545 = e;
var G__8546 = f;
var G__8547 = g;
var G__8548 = h;
var G__8549 = i;
var G__8550 = j;
var G__8551 = k;
var G__8552 = l;
var G__8553 = m;
var G__8554 = n;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(G__8541,G__8542,G__8543,G__8544,G__8545,G__8546,G__8547,G__8548,G__8549,G__8550,G__8551,G__8552,G__8553,G__8554) : self__.afn.call(null,G__8541,G__8542,G__8543,G__8544,G__8545,G__8546,G__8547,G__8548,G__8549,G__8550,G__8551,G__8552,G__8553,G__8554));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
var G__8555 = a;
var G__8556 = b;
var G__8557 = c;
var G__8558 = d;
var G__8559 = e;
var G__8560 = f;
var G__8561 = g;
var G__8562 = h;
var G__8563 = i;
var G__8564 = j;
var G__8565 = k;
var G__8566 = l;
var G__8567 = m;
var G__8568 = n;
var G__8569 = o;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(G__8555,G__8556,G__8557,G__8558,G__8559,G__8560,G__8561,G__8562,G__8563,G__8564,G__8565,G__8566,G__8567,G__8568,G__8569) : self__.afn.call(null,G__8555,G__8556,G__8557,G__8558,G__8559,G__8560,G__8561,G__8562,G__8563,G__8564,G__8565,G__8566,G__8567,G__8568,G__8569));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
var G__8570 = a;
var G__8571 = b;
var G__8572 = c;
var G__8573 = d;
var G__8574 = e;
var G__8575 = f;
var G__8576 = g;
var G__8577 = h;
var G__8578 = i;
var G__8579 = j;
var G__8580 = k;
var G__8581 = l;
var G__8582 = m;
var G__8583 = n;
var G__8584 = o;
var G__8585 = p;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(G__8570,G__8571,G__8572,G__8573,G__8574,G__8575,G__8576,G__8577,G__8578,G__8579,G__8580,G__8581,G__8582,G__8583,G__8584,G__8585) : self__.afn.call(null,G__8570,G__8571,G__8572,G__8573,G__8574,G__8575,G__8576,G__8577,G__8578,G__8579,G__8580,G__8581,G__8582,G__8583,G__8584,G__8585));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
var G__8586 = a;
var G__8587 = b;
var G__8588 = c;
var G__8589 = d;
var G__8590 = e;
var G__8591 = f;
var G__8592 = g;
var G__8593 = h;
var G__8594 = i;
var G__8595 = j;
var G__8596 = k;
var G__8597 = l;
var G__8598 = m;
var G__8599 = n;
var G__8600 = o;
var G__8601 = p;
var G__8602 = q;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(G__8586,G__8587,G__8588,G__8589,G__8590,G__8591,G__8592,G__8593,G__8594,G__8595,G__8596,G__8597,G__8598,G__8599,G__8600,G__8601,G__8602) : self__.afn.call(null,G__8586,G__8587,G__8588,G__8589,G__8590,G__8591,G__8592,G__8593,G__8594,G__8595,G__8596,G__8597,G__8598,G__8599,G__8600,G__8601,G__8602));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
var G__8603 = a;
var G__8604 = b;
var G__8605 = c;
var G__8606 = d;
var G__8607 = e;
var G__8608 = f;
var G__8609 = g;
var G__8610 = h;
var G__8611 = i;
var G__8612 = j;
var G__8613 = k;
var G__8614 = l;
var G__8615 = m;
var G__8616 = n;
var G__8617 = o;
var G__8618 = p;
var G__8619 = q;
var G__8620 = r;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(G__8603,G__8604,G__8605,G__8606,G__8607,G__8608,G__8609,G__8610,G__8611,G__8612,G__8613,G__8614,G__8615,G__8616,G__8617,G__8618,G__8619,G__8620) : self__.afn.call(null,G__8603,G__8604,G__8605,G__8606,G__8607,G__8608,G__8609,G__8610,G__8611,G__8612,G__8613,G__8614,G__8615,G__8616,G__8617,G__8618,G__8619,G__8620));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
var G__8621 = a;
var G__8622 = b;
var G__8623 = c;
var G__8624 = d;
var G__8625 = e;
var G__8626 = f;
var G__8627 = g;
var G__8628 = h;
var G__8629 = i;
var G__8630 = j;
var G__8631 = k;
var G__8632 = l;
var G__8633 = m;
var G__8634 = n;
var G__8635 = o;
var G__8636 = p;
var G__8637 = q;
var G__8638 = r;
var G__8639 = s;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(G__8621,G__8622,G__8623,G__8624,G__8625,G__8626,G__8627,G__8628,G__8629,G__8630,G__8631,G__8632,G__8633,G__8634,G__8635,G__8636,G__8637,G__8638,G__8639) : self__.afn.call(null,G__8621,G__8622,G__8623,G__8624,G__8625,G__8626,G__8627,G__8628,G__8629,G__8630,G__8631,G__8632,G__8633,G__8634,G__8635,G__8636,G__8637,G__8638,G__8639));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
var G__8640 = a;
var G__8641 = b;
var G__8642 = c;
var G__8643 = d;
var G__8644 = e;
var G__8645 = f;
var G__8646 = g;
var G__8647 = h;
var G__8648 = i;
var G__8649 = j;
var G__8650 = k;
var G__8651 = l;
var G__8652 = m;
var G__8653 = n;
var G__8654 = o;
var G__8655 = p;
var G__8656 = q;
var G__8657 = r;
var G__8658 = s;
var G__8659 = t;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(G__8640,G__8641,G__8642,G__8643,G__8644,G__8645,G__8646,G__8647,G__8648,G__8649,G__8650,G__8651,G__8652,G__8653,G__8654,G__8655,G__8656,G__8657,G__8658,G__8659) : self__.afn.call(null,G__8640,G__8641,G__8642,G__8643,G__8644,G__8645,G__8646,G__8647,G__8648,G__8649,G__8650,G__8651,G__8652,G__8653,G__8654,G__8655,G__8656,G__8657,G__8658,G__8659));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
var G__8660 = self__.afn;
var G__8661 = a;
var G__8662 = b;
var G__8663 = c;
var G__8664 = d;
var G__8665 = e;
var G__8666 = f;
var G__8667 = g;
var G__8668 = h;
var G__8669 = i;
var G__8670 = j;
var G__8671 = k;
var G__8672 = l;
var G__8673 = m;
var G__8674 = n;
var G__8675 = o;
var G__8676 = p;
var G__8677 = q;
var G__8678 = r;
var G__8679 = s;
var G__8680 = t;
var G__8681 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__8660,G__8661,G__8662,G__8663,G__8664,G__8665,G__8666,G__8667,G__8668,G__8669,G__8670,G__8671,G__8672,G__8673,G__8674,G__8675,G__8676,G__8677,G__8678,G__8679,G__8680,G__8681) : cljs.core.apply.call(null,G__8660,G__8661,G__8662,G__8663,G__8664,G__8665,G__8666,G__8667,G__8668,G__8669,G__8670,G__8671,G__8672,G__8673,G__8674,G__8675,G__8676,G__8677,G__8678,G__8679,G__8680,G__8681));
});

cljs.core.MetaFn.prototype.cljs$core$Fn$ = true;

cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.MetaFn(self__.afn,new_meta));
});

cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
});

cljs.core.MetaFn.cljs$lang$type = true;

cljs.core.MetaFn.cljs$lang$ctorStr = "cljs.core/MetaFn";

cljs.core.MetaFn.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/MetaFn");
});

cljs.core.__GT_MetaFn = (function __GT_MetaFn(afn,meta){
return (new cljs.core.MetaFn(afn,meta));
});

/**
* Returns an object of the same type and value as obj, with
* map m as its metadata.
*/
cljs.core.with_meta = (function with_meta(o,meta){
if((cljs.core.fn_QMARK_(o)) && (!((function (){var G__8686 = o;
if(G__8686){
var bit__4439__auto__ = (G__8686.cljs$lang$protocol_mask$partition0$ & (262144));
if((bit__4439__auto__) || (G__8686.cljs$core$IWithMeta$)){
return true;
} else {
if((!G__8686.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IWithMeta,G__8686);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IWithMeta,G__8686);
}
})()))){
return (new cljs.core.MetaFn(o,meta));
} else {
if((o == null)){
return null;
} else {
return cljs.core._with_meta(o,meta);
}
}
});
/**
* Returns the metadata of obj, returns nil if there is no metadata.
*/
cljs.core.meta = (function meta(o){
if((function (){var and__3746__auto__ = !((o == null));
if(and__3746__auto__){
var G__8690 = o;
if(G__8690){
var bit__4439__auto__ = (G__8690.cljs$lang$protocol_mask$partition0$ & (131072));
if((bit__4439__auto__) || (G__8690.cljs$core$IMeta$)){
return true;
} else {
if((!G__8690.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__8690);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__8690);
}
} else {
return and__3746__auto__;
}
})()){
return cljs.core._meta(o);
} else {
return null;
}
});
/**
* For a list or queue, same as first, for a vector, same as, but much
* more efficient than, last. If the collection is empty, returns nil.
*/
cljs.core.peek = (function peek(coll){
if((coll == null)){
return null;
} else {
return cljs.core._peek(coll);
}
});
/**
* For a list or queue, returns a new list/queue without the first
* item, for a vector, returns a new vector without the last item.
* Note - not the same as next/butlast.
*/
cljs.core.pop = (function pop(coll){
if((coll == null)){
return null;
} else {
return cljs.core._pop(coll);
}
});
/**
* disj[oin]. Returns a new set of the same (hashed/sorted) type, that
* does not contain key(s).
* @param {...*} var_args
*/
cljs.core.disj = (function() {
var disj = null;
var disj__1 = (function (coll){
return coll;
});
var disj__2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._disjoin(coll,k);
}
});
var disj__3 = (function() { 
var G__8693__delegate = function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = disj.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__8694 = ret;
var G__8695 = cljs.core.first(ks);
var G__8696 = cljs.core.next(ks);
coll = G__8694;
k = G__8695;
ks = G__8696;
continue;
} else {
return ret;
}
}
break;
}
};
var G__8693 = function (coll,k,var_args){
var ks = null;
if (arguments.length > 2) {
var G__8697__i = 0, G__8697__a = new Array(arguments.length -  2);
while (G__8697__i < G__8697__a.length) {G__8697__a[G__8697__i] = arguments[G__8697__i + 2]; ++G__8697__i;}
  ks = new cljs.core.IndexedSeq(G__8697__a,0);
} 
return G__8693__delegate.call(this,coll,k,ks);};
G__8693.cljs$lang$maxFixedArity = 2;
G__8693.cljs$lang$applyTo = (function (arglist__8698){
var coll = cljs.core.first(arglist__8698);
arglist__8698 = cljs.core.next(arglist__8698);
var k = cljs.core.first(arglist__8698);
var ks = cljs.core.rest(arglist__8698);
return G__8693__delegate(coll,k,ks);
});
G__8693.cljs$core$IFn$_invoke$arity$variadic = G__8693__delegate;
return G__8693;
})()
;
disj = function(coll,k,var_args){
var ks = var_args;
switch(arguments.length){
case 1:
return disj__1.call(this,coll);
case 2:
return disj__2.call(this,coll,k);
default:
var G__8699 = null;
if (arguments.length > 2) {
var G__8700__i = 0, G__8700__a = new Array(arguments.length -  2);
while (G__8700__i < G__8700__a.length) {G__8700__a[G__8700__i] = arguments[G__8700__i + 2]; ++G__8700__i;}
G__8699 = new cljs.core.IndexedSeq(G__8700__a,0);
}
return disj__3.cljs$core$IFn$_invoke$arity$variadic(coll,k, G__8699);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
disj.cljs$lang$maxFixedArity = 2;
disj.cljs$lang$applyTo = disj__3.cljs$lang$applyTo;
disj.cljs$core$IFn$_invoke$arity$1 = disj__1;
disj.cljs$core$IFn$_invoke$arity$2 = disj__2;
disj.cljs$core$IFn$_invoke$arity$variadic = disj__3.cljs$core$IFn$_invoke$arity$variadic;
return disj;
})()
;
/**
* Returns true if coll has no items - same as (not (seq coll)).
* Please use the idiom (seq x) rather than (not (empty? x))
*/
cljs.core.empty_QMARK_ = (function empty_QMARK_(coll){
return ((coll == null)) || (cljs.core.not(cljs.core.seq(coll)));
});
/**
* Returns true if x satisfies ICollection
*/
cljs.core.coll_QMARK_ = (function coll_QMARK_(x){
if((x == null)){
return false;
} else {
var G__8702 = x;
if(G__8702){
var bit__4439__auto__ = (G__8702.cljs$lang$protocol_mask$partition0$ & (8));
if((bit__4439__auto__) || (G__8702.cljs$core$ICollection$)){
return true;
} else {
if((!G__8702.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,G__8702);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,G__8702);
}
}
});
/**
* Returns true if x satisfies ISet
*/
cljs.core.set_QMARK_ = (function set_QMARK_(x){
if((x == null)){
return false;
} else {
var G__8704 = x;
if(G__8704){
var bit__4439__auto__ = (G__8704.cljs$lang$protocol_mask$partition0$ & (4096));
if((bit__4439__auto__) || (G__8704.cljs$core$ISet$)){
return true;
} else {
if((!G__8704.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,G__8704);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,G__8704);
}
}
});
/**
* Returns true if coll implements Associative
*/
cljs.core.associative_QMARK_ = (function associative_QMARK_(x){
var G__8706 = x;
if(G__8706){
var bit__4439__auto__ = (G__8706.cljs$lang$protocol_mask$partition0$ & (512));
if((bit__4439__auto__) || (G__8706.cljs$core$IAssociative$)){
return true;
} else {
if((!G__8706.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,G__8706);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,G__8706);
}
});
/**
* Returns true if coll satisfies ISequential
*/
cljs.core.sequential_QMARK_ = (function sequential_QMARK_(x){
var G__8708 = x;
if(G__8708){
var bit__4439__auto__ = (G__8708.cljs$lang$protocol_mask$partition0$ & (16777216));
if((bit__4439__auto__) || (G__8708.cljs$core$ISequential$)){
return true;
} else {
if((!G__8708.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,G__8708);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,G__8708);
}
});
/**
* Returns true if coll satisfies ISorted
*/
cljs.core.sorted_QMARK_ = (function sorted_QMARK_(x){
var G__8710 = x;
if(G__8710){
var bit__4439__auto__ = (G__8710.cljs$lang$protocol_mask$partition0$ & (268435456));
if((bit__4439__auto__) || (G__8710.cljs$core$ISorted$)){
return true;
} else {
if((!G__8710.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,G__8710);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,G__8710);
}
});
/**
* Returns true if coll satisfies IReduce
*/
cljs.core.reduceable_QMARK_ = (function reduceable_QMARK_(x){
var G__8712 = x;
if(G__8712){
var bit__4439__auto__ = (G__8712.cljs$lang$protocol_mask$partition0$ & (524288));
if((bit__4439__auto__) || (G__8712.cljs$core$IReduce$)){
return true;
} else {
if((!G__8712.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,G__8712);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,G__8712);
}
});
/**
* Return true if x satisfies IMap
*/
cljs.core.map_QMARK_ = (function map_QMARK_(x){
if((x == null)){
return false;
} else {
var G__8714 = x;
if(G__8714){
var bit__4439__auto__ = (G__8714.cljs$lang$protocol_mask$partition0$ & (1024));
if((bit__4439__auto__) || (G__8714.cljs$core$IMap$)){
return true;
} else {
if((!G__8714.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,G__8714);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,G__8714);
}
}
});
/**
* Return true if x satisfies IVector
*/
cljs.core.vector_QMARK_ = (function vector_QMARK_(x){
var G__8716 = x;
if(G__8716){
var bit__4439__auto__ = (G__8716.cljs$lang$protocol_mask$partition0$ & (16384));
if((bit__4439__auto__) || (G__8716.cljs$core$IVector$)){
return true;
} else {
if((!G__8716.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,G__8716);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,G__8716);
}
});

cljs.core.chunked_seq_QMARK_ = (function chunked_seq_QMARK_(x){
var G__8718 = x;
if(G__8718){
var bit__4432__auto__ = (G__8718.cljs$lang$protocol_mask$partition1$ & (512));
if((bit__4432__auto__) || (G__8718.cljs$core$IChunkedSeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
});
/**
* @param {...*} var_args
*/
cljs.core.js_obj = (function() {
var js_obj = null;
var js_obj__0 = (function (){
var obj8724 = {};
return obj8724;
});
var js_obj__1 = (function() { 
var G__8727__delegate = function (keyvals){
var G__8725 = goog.object.create;
var G__8726 = keyvals;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$2 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(G__8725,G__8726) : cljs.core.apply.call(null,G__8725,G__8726));
};
var G__8727 = function (var_args){
var keyvals = null;
if (arguments.length > 0) {
var G__8728__i = 0, G__8728__a = new Array(arguments.length -  0);
while (G__8728__i < G__8728__a.length) {G__8728__a[G__8728__i] = arguments[G__8728__i + 0]; ++G__8728__i;}
  keyvals = new cljs.core.IndexedSeq(G__8728__a,0);
} 
return G__8727__delegate.call(this,keyvals);};
G__8727.cljs$lang$maxFixedArity = 0;
G__8727.cljs$lang$applyTo = (function (arglist__8729){
var keyvals = cljs.core.seq(arglist__8729);
return G__8727__delegate(keyvals);
});
G__8727.cljs$core$IFn$_invoke$arity$variadic = G__8727__delegate;
return G__8727;
})()
;
js_obj = function(var_args){
var keyvals = var_args;
switch(arguments.length){
case 0:
return js_obj__0.call(this);
default:
var G__8730 = null;
if (arguments.length > 0) {
var G__8731__i = 0, G__8731__a = new Array(arguments.length -  0);
while (G__8731__i < G__8731__a.length) {G__8731__a[G__8731__i] = arguments[G__8731__i + 0]; ++G__8731__i;}
G__8730 = new cljs.core.IndexedSeq(G__8731__a,0);
}
return js_obj__1.cljs$core$IFn$_invoke$arity$variadic(G__8730);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
js_obj.cljs$lang$maxFixedArity = 0;
js_obj.cljs$lang$applyTo = js_obj__1.cljs$lang$applyTo;
js_obj.cljs$core$IFn$_invoke$arity$0 = js_obj__0;
js_obj.cljs$core$IFn$_invoke$arity$variadic = js_obj__1.cljs$core$IFn$_invoke$arity$variadic;
return js_obj;
})()
;
cljs.core.js_keys = (function js_keys(obj){
var keys = [];
var G__8734_8736 = obj;
var G__8735_8737 = ((function (G__8734_8736,keys){
return (function (val,key,obj__$1){
return keys.push(key);
});})(G__8734_8736,keys))
;
goog.object.forEach(G__8734_8736,G__8735_8737);

return keys;
});
cljs.core.js_delete = (function js_delete(obj,key){
return delete obj[key];
});
cljs.core.array_copy = (function array_copy(from,i,to,j,len){
var i__$1 = i;
var j__$1 = j;
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__8738 = (i__$1 + (1));
var G__8739 = (j__$1 + (1));
var G__8740 = (len__$1 - (1));
i__$1 = G__8738;
j__$1 = G__8739;
len__$1 = G__8740;
continue;
}
break;
}
});
cljs.core.array_copy_downward = (function array_copy_downward(from,i,to,j,len){
var i__$1 = (i + (len - (1)));
var j__$1 = (j + (len - (1)));
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__8741 = (i__$1 - (1));
var G__8742 = (j__$1 - (1));
var G__8743 = (len__$1 - (1));
i__$1 = G__8741;
j__$1 = G__8742;
len__$1 = G__8743;
continue;
}
break;
}
});
cljs.core.lookup_sentinel = (function (){var obj8745 = {};
return obj8745;
})();
/**
* Returns true if x is the value false, false otherwise.
*/
cljs.core.false_QMARK_ = (function false_QMARK_(x){
return x === false;
});
/**
* Returns true if x is the value true, false otherwise.
*/
cljs.core.true_QMARK_ = (function true_QMARK_(x){
return x === true;
});
cljs.core.undefined_QMARK_ = (function undefined_QMARK_(x){
return (void 0 === x);
});
/**
* Return true if s satisfies ISeq
*/
cljs.core.seq_QMARK_ = (function seq_QMARK_(s){
if((s == null)){
return false;
} else {
var G__8747 = s;
if(G__8747){
var bit__4439__auto__ = (G__8747.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4439__auto__) || (G__8747.cljs$core$ISeq$)){
return true;
} else {
if((!G__8747.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__8747);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__8747);
}
}
});
/**
* Return true if s satisfies ISeqable
*/
cljs.core.seqable_QMARK_ = (function seqable_QMARK_(s){
var G__8749 = s;
if(G__8749){
var bit__4439__auto__ = (G__8749.cljs$lang$protocol_mask$partition0$ & (8388608));
if((bit__4439__auto__) || (G__8749.cljs$core$ISeqable$)){
return true;
} else {
if((!G__8749.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,G__8749);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,G__8749);
}
});
cljs.core.boolean$ = (function boolean$(x){
if(cljs.core.truth_(x)){
return true;
} else {
return false;
}
});
cljs.core.ifn_QMARK_ = (function ifn_QMARK_(f){
var or__3758__auto__ = cljs.core.fn_QMARK_(f);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var G__8753 = f;
if(G__8753){
var bit__4439__auto__ = (G__8753.cljs$lang$protocol_mask$partition0$ & (1));
if((bit__4439__auto__) || (G__8753.cljs$core$IFn$)){
return true;
} else {
if((!G__8753.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,G__8753);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,G__8753);
}
}
});
/**
* Returns true if n is an integer.
*/
cljs.core.integer_QMARK_ = (function integer_QMARK_(n){
return (typeof n === 'number') && (cljs.core.not((function (){var G__8766 = n;
return isNaN(G__8766);
})())) && (!((n === Infinity))) && (((function (){var G__8767 = n;
return parseFloat(G__8767);
})() === (function (){var G__8768 = n;
var G__8769 = (10);
return parseInt(G__8768,G__8769);
})()));
});
/**
* Returns true if key is present in the given collection, otherwise
* returns false.  Note that for numerically indexed collections like
* vectors and arrays, this tests if the numeric key is within the
* range of indexes. 'contains?' operates constant or logarithmic time;
* it will not perform a linear search for a value.  See also 'some'.
*/
cljs.core.contains_QMARK_ = (function contains_QMARK_(coll,v){
if((cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return false;
} else {
return true;
}
});
/**
* Returns the map entry for key, or nil if key not present.
*/
cljs.core.find = (function find(coll,k){
if((!((coll == null))) && (cljs.core.associative_QMARK_(coll)) && (cljs.core.contains_QMARK_(coll,k))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,k)], null);
} else {
return null;
}
});
/**
* Returns true if no two of the arguments are =
* @param {...*} var_args
*/
cljs.core.distinct_QMARK_ = (function() {
var distinct_QMARK_ = null;
var distinct_QMARK___1 = (function (x){
return true;
});
var distinct_QMARK___2 = (function (x,y){
return !(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y));
});
var distinct_QMARK___3 = (function() { 
var G__8770__delegate = function (x,y,more){
if(!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y))){
var s = cljs.core.PersistentHashSet.fromArray([x,y], true);
var xs = more;
while(true){
var x__$1 = cljs.core.first(xs);
var etc = cljs.core.next(xs);
if(cljs.core.truth_(xs)){
if(cljs.core.contains_QMARK_(s,x__$1)){
return false;
} else {
var G__8771 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s,x__$1);
var G__8772 = etc;
s = G__8771;
xs = G__8772;
continue;
}
} else {
return true;
}
break;
}
} else {
return false;
}
};
var G__8770 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8773__i = 0, G__8773__a = new Array(arguments.length -  2);
while (G__8773__i < G__8773__a.length) {G__8773__a[G__8773__i] = arguments[G__8773__i + 2]; ++G__8773__i;}
  more = new cljs.core.IndexedSeq(G__8773__a,0);
} 
return G__8770__delegate.call(this,x,y,more);};
G__8770.cljs$lang$maxFixedArity = 2;
G__8770.cljs$lang$applyTo = (function (arglist__8774){
var x = cljs.core.first(arglist__8774);
arglist__8774 = cljs.core.next(arglist__8774);
var y = cljs.core.first(arglist__8774);
var more = cljs.core.rest(arglist__8774);
return G__8770__delegate(x,y,more);
});
G__8770.cljs$core$IFn$_invoke$arity$variadic = G__8770__delegate;
return G__8770;
})()
;
distinct_QMARK_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return distinct_QMARK___1.call(this,x);
case 2:
return distinct_QMARK___2.call(this,x,y);
default:
var G__8775 = null;
if (arguments.length > 2) {
var G__8776__i = 0, G__8776__a = new Array(arguments.length -  2);
while (G__8776__i < G__8776__a.length) {G__8776__a[G__8776__i] = arguments[G__8776__i + 2]; ++G__8776__i;}
G__8775 = new cljs.core.IndexedSeq(G__8776__a,0);
}
return distinct_QMARK___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8775);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
distinct_QMARK_.cljs$lang$maxFixedArity = 2;
distinct_QMARK_.cljs$lang$applyTo = distinct_QMARK___3.cljs$lang$applyTo;
distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = distinct_QMARK___1;
distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = distinct_QMARK___2;
distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = distinct_QMARK___3.cljs$core$IFn$_invoke$arity$variadic;
return distinct_QMARK_;
})()
;
/**
* Comparator. Returns a negative number, zero, or a positive number
* when x is logically 'less than', 'equal to', or 'greater than'
* y. Uses IComparable if available and google.array.defaultCompare for objects
* of the same type and special-cases nil to be less than any other object.
*/
cljs.core.compare = (function compare(x,y){
if((x === y)){
return (0);
} else {
if((x == null)){
return (-1);
} else {
if((y == null)){
return (1);
} else {
if((cljs.core.type(x) === cljs.core.type(y))){
if((function (){var G__8780 = x;
if(G__8780){
var bit__4432__auto__ = (G__8780.cljs$lang$protocol_mask$partition1$ & (2048));
if((bit__4432__auto__) || (G__8780.cljs$core$IComparable$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return x.cljs$core$IComparable$_compare$arity$2(null,y);
} else {
var G__8781 = x;
var G__8782 = y;
return goog.array.defaultCompare(G__8781,G__8782);
}
} else {
throw (new Error("compare on non-nil objects of different types"));

}
}
}
}
});
/**
* Compare indexed collection.
*/
cljs.core.compare_indexed = (function() {
var compare_indexed = null;
var compare_indexed__2 = (function (xs,ys){
var xl = cljs.core.count(xs);
var yl = cljs.core.count(ys);
if((xl < yl)){
return (-1);
} else {
if((xl > yl)){
return (1);
} else {
return compare_indexed.cljs$core$IFn$_invoke$arity$4(xs,ys,xl,(0));

}
}
});
var compare_indexed__4 = (function (xs,ys,len,n){
while(true){
var d = cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs,n),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys,n));
if(((d === (0))) && (((n + (1)) < len))){
var G__8787 = xs;
var G__8788 = ys;
var G__8789 = len;
var G__8790 = (n + (1));
xs = G__8787;
ys = G__8788;
len = G__8789;
n = G__8790;
continue;
} else {
return d;
}
break;
}
});
compare_indexed = function(xs,ys,len,n){
switch(arguments.length){
case 2:
return compare_indexed__2.call(this,xs,ys);
case 4:
return compare_indexed__4.call(this,xs,ys,len,n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
compare_indexed.cljs$core$IFn$_invoke$arity$2 = compare_indexed__2;
compare_indexed.cljs$core$IFn$_invoke$arity$4 = compare_indexed__4;
return compare_indexed;
})()
;
/**
* Given a fn that might be boolean valued or a comparator,
* return a fn that is a comparator.
*/
cljs.core.fn__GT_comparator = (function fn__GT_comparator(f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f,cljs.core.compare)){
return cljs.core.compare;
} else {
return (function (x,y){
var r = (function (){var G__8795 = x;
var G__8796 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8795,G__8796) : f.call(null,G__8795,G__8796));
})();
if(typeof r === 'number'){
return r;
} else {
if(cljs.core.truth_(r)){
return (-1);
} else {
if(cljs.core.truth_((function (){var G__8797 = y;
var G__8798 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8797,G__8798) : f.call(null,G__8797,G__8798));
})())){
return (1);
} else {
return (0);
}
}
}
});
}
});
/**
* Returns a sorted sequence of the items in coll. Comp can be
* boolean-valued comparison function, or a -/0/+ valued comparator.
* Comp defaults to compare.
*/
cljs.core.sort = (function() {
var sort = null;
var sort__1 = (function (coll){
return sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,coll);
});
var sort__2 = (function (comp,coll){
if(cljs.core.seq(coll)){
var a = (function (){var G__8804 = coll;
return (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(G__8804) : cljs.core.to_array.call(null,G__8804));
})();
var G__8805_8807 = a;
var G__8806_8808 = cljs.core.fn__GT_comparator(comp);
goog.array.stableSort(G__8805_8807,G__8806_8808);

return cljs.core.seq(a);
} else {
return cljs.core.List.EMPTY;
}
});
sort = function(comp,coll){
switch(arguments.length){
case 1:
return sort__1.call(this,comp);
case 2:
return sort__2.call(this,comp,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sort.cljs$core$IFn$_invoke$arity$1 = sort__1;
sort.cljs$core$IFn$_invoke$arity$2 = sort__2;
return sort;
})()
;
/**
* Returns a sorted sequence of the items in coll, where the sort
* order is determined by comparing (keyfn item).  Comp can be
* boolean-valued comparison funcion, or a -/0/+ valued comparator.
* Comp defaults to compare.
*/
cljs.core.sort_by = (function() {
var sort_by = null;
var sort_by__2 = (function (keyfn,coll){
return sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,cljs.core.compare,coll);
});
var sort_by__3 = (function (keyfn,comp,coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function (x,y){
return cljs.core.fn__GT_comparator(comp).call(null,(function (){var G__8814 = x;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__8814) : keyfn.call(null,G__8814));
})(),(function (){var G__8815 = y;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__8815) : keyfn.call(null,G__8815));
})());
}),coll);
});
sort_by = function(keyfn,comp,coll){
switch(arguments.length){
case 2:
return sort_by__2.call(this,keyfn,comp);
case 3:
return sort_by__3.call(this,keyfn,comp,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sort_by.cljs$core$IFn$_invoke$arity$2 = sort_by__2;
sort_by.cljs$core$IFn$_invoke$arity$3 = sort_by__3;
return sort_by;
})()
;
cljs.core.seq_reduce = (function() {
var seq_reduce = null;
var seq_reduce__2 = (function (f,coll){
var temp__4124__auto__ = cljs.core.seq(coll);
if(temp__4124__auto__){
var s = temp__4124__auto__;
var G__8821 = f;
var G__8822 = cljs.core.first(s);
var G__8823 = cljs.core.next(s);
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__8821,G__8822,G__8823) : cljs.core.reduce.call(null,G__8821,G__8822,G__8823));
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
});
var seq_reduce__3 = (function (f,val,coll){
var val__$1 = val;
var coll__$1 = cljs.core.seq(coll);
while(true){
if(coll__$1){
var nval = (function (){var G__8824 = val__$1;
var G__8825 = cljs.core.first(coll__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8824,G__8825) : f.call(null,G__8824,G__8825));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__8826 = nval;
var G__8827 = cljs.core.next(coll__$1);
val__$1 = G__8826;
coll__$1 = G__8827;
continue;
}
} else {
return val__$1;
}
break;
}
});
seq_reduce = function(f,val,coll){
switch(arguments.length){
case 2:
return seq_reduce__2.call(this,f,val);
case 3:
return seq_reduce__3.call(this,f,val,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
seq_reduce.cljs$core$IFn$_invoke$arity$2 = seq_reduce__2;
seq_reduce.cljs$core$IFn$_invoke$arity$3 = seq_reduce__3;
return seq_reduce;
})()
;
/**
* Return a random permutation of coll
*/
cljs.core.shuffle = (function shuffle(coll){
var a = (function (){var G__8831 = coll;
return (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(G__8831) : cljs.core.to_array.call(null,G__8831));
})();
var G__8832_8834 = a;
goog.array.shuffle(G__8832_8834);

var G__8833 = a;
return (cljs.core.vec.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vec.cljs$core$IFn$_invoke$arity$1(G__8833) : cljs.core.vec.call(null,G__8833));
});
/**
* f should be a function of 2 arguments. If val is not supplied,
* returns the result of applying f to the first 2 items in coll, then
* applying f to that result and the 3rd item, etc. If coll contains no
* items, f must accept no arguments as well, and reduce returns the
* result of calling f with no arguments.  If coll has only 1 item, it
* is returned and f is not called.  If val is supplied, returns the
* result of applying f to val and the first item in coll, then
* applying f to that result and the 2nd item, etc. If coll contains no
* items, returns val and f is not called.
*/
cljs.core.reduce = (function() {
var reduce = null;
var reduce__2 = (function (f,coll){
if((function (){var G__8837 = coll;
if(G__8837){
var bit__4432__auto__ = (G__8837.cljs$lang$protocol_mask$partition0$ & (524288));
if((bit__4432__auto__) || (G__8837.cljs$core$IReduce$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$2(null,f);
} else {
if(coll instanceof Array){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll);

}
}
}
}
});
var reduce__3 = (function (f,val,coll){
if((function (){var G__8838 = coll;
if(G__8838){
var bit__4432__auto__ = (G__8838.cljs$lang$protocol_mask$partition0$ & (524288));
if((bit__4432__auto__) || (G__8838.cljs$core$IReduce$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$3(null,f,val);
} else {
if(coll instanceof Array){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,val,coll);

}
}
}
}
});
reduce = function(f,val,coll){
switch(arguments.length){
case 2:
return reduce__2.call(this,f,val);
case 3:
return reduce__3.call(this,f,val,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
reduce.cljs$core$IFn$_invoke$arity$2 = reduce__2;
reduce.cljs$core$IFn$_invoke$arity$3 = reduce__3;
return reduce;
})()
;
/**
* Reduces an associative collection. f should be a function of 3
* arguments. Returns the result of applying f to init, the first key
* and the first value in coll, then applying f to that result and the
* 2nd key and value, etc. If coll contains no entries, returns init
* and f is not called. Note that reduce-kv is supported on vectors,
* where the keys will be the ordinals.
*/
cljs.core.reduce_kv = (function reduce_kv(f,init,coll){
if(!((coll == null))){
return cljs.core._kv_reduce(coll,f,init);
} else {
return init;
}
});
cljs.core.identity = (function identity(x){
return x;
});
cljs.core.completing = (function() {
var completing = null;
var completing__1 = (function (f){
return completing.cljs$core$IFn$_invoke$arity$2(f,cljs.core.identity);
});
var completing__2 = (function (f,cf){
return (function() {
var G__8847 = null;
var G__8847__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
});
var G__8847__1 = (function (x){
var G__8844 = x;
return (cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(G__8844) : cf.call(null,G__8844));
});
var G__8847__2 = (function (x,y){
var G__8845 = x;
var G__8846 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8845,G__8846) : f.call(null,G__8845,G__8846));
});
G__8847 = function(x,y){
switch(arguments.length){
case 0:
return G__8847__0.call(this);
case 1:
return G__8847__1.call(this,x);
case 2:
return G__8847__2.call(this,x,y);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8847.cljs$core$IFn$_invoke$arity$0 = G__8847__0;
G__8847.cljs$core$IFn$_invoke$arity$1 = G__8847__1;
G__8847.cljs$core$IFn$_invoke$arity$2 = G__8847__2;
return G__8847;
})()
});
completing = function(f,cf){
switch(arguments.length){
case 1:
return completing__1.call(this,f);
case 2:
return completing__2.call(this,f,cf);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
completing.cljs$core$IFn$_invoke$arity$1 = completing__1;
completing.cljs$core$IFn$_invoke$arity$2 = completing__2;
return completing;
})()
;
/**
* reduce with a transformation of f (xf). If init is not
* supplied, (f) will be called to produce it. f should be a reducing
* step function that accepts both 1 and 2 arguments, if it accepts
* only 2 you can add the arity-1 with 'completing'. Returns the result
* of applying (the transformed) xf to init and the first item in coll,
* then applying xf to that result and the 2nd item, etc. If coll
* contains no items, returns init and f is not called. Note that
* certain transforms may inject or skip items.
*/
cljs.core.transduce = (function() {
var transduce = null;
var transduce__3 = (function (xform,f,coll){
return transduce.cljs$core$IFn$_invoke$arity$4(xform,f,(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),coll);
});
var transduce__4 = (function (xform,f,init,coll){
var f__$1 = (function (){var G__8854 = f;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__8854) : xform.call(null,G__8854));
})();
var ret = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1,init,coll);
var G__8855 = ret;
return (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(G__8855) : f__$1.call(null,G__8855));
});
transduce = function(xform,f,init,coll){
switch(arguments.length){
case 3:
return transduce__3.call(this,xform,f,init);
case 4:
return transduce__4.call(this,xform,f,init,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
transduce.cljs$core$IFn$_invoke$arity$3 = transduce__3;
transduce.cljs$core$IFn$_invoke$arity$4 = transduce__4;
return transduce;
})()
;
/**
* Returns the sum of nums. (+) returns 0.
* @param {...*} var_args
*/
cljs.core._PLUS_ = (function() {
var _PLUS_ = null;
var _PLUS___0 = (function (){
return (0);
});
var _PLUS___1 = (function (x){
return x;
});
var _PLUS___2 = (function (x,y){
return (x + y);
});
var _PLUS___3 = (function() { 
var G__8856__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(_PLUS_,(x + y),more);
};
var G__8856 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8857__i = 0, G__8857__a = new Array(arguments.length -  2);
while (G__8857__i < G__8857__a.length) {G__8857__a[G__8857__i] = arguments[G__8857__i + 2]; ++G__8857__i;}
  more = new cljs.core.IndexedSeq(G__8857__a,0);
} 
return G__8856__delegate.call(this,x,y,more);};
G__8856.cljs$lang$maxFixedArity = 2;
G__8856.cljs$lang$applyTo = (function (arglist__8858){
var x = cljs.core.first(arglist__8858);
arglist__8858 = cljs.core.next(arglist__8858);
var y = cljs.core.first(arglist__8858);
var more = cljs.core.rest(arglist__8858);
return G__8856__delegate(x,y,more);
});
G__8856.cljs$core$IFn$_invoke$arity$variadic = G__8856__delegate;
return G__8856;
})()
;
_PLUS_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return _PLUS___0.call(this);
case 1:
return _PLUS___1.call(this,x);
case 2:
return _PLUS___2.call(this,x,y);
default:
var G__8859 = null;
if (arguments.length > 2) {
var G__8860__i = 0, G__8860__a = new Array(arguments.length -  2);
while (G__8860__i < G__8860__a.length) {G__8860__a[G__8860__i] = arguments[G__8860__i + 2]; ++G__8860__i;}
G__8859 = new cljs.core.IndexedSeq(G__8860__a,0);
}
return _PLUS___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8859);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_PLUS_.cljs$lang$maxFixedArity = 2;
_PLUS_.cljs$lang$applyTo = _PLUS___3.cljs$lang$applyTo;
_PLUS_.cljs$core$IFn$_invoke$arity$0 = _PLUS___0;
_PLUS_.cljs$core$IFn$_invoke$arity$1 = _PLUS___1;
_PLUS_.cljs$core$IFn$_invoke$arity$2 = _PLUS___2;
_PLUS_.cljs$core$IFn$_invoke$arity$variadic = _PLUS___3.cljs$core$IFn$_invoke$arity$variadic;
return _PLUS_;
})()
;
/**
* If no ys are supplied, returns the negation of x, else subtracts
* the ys from x and returns the result.
* @param {...*} var_args
*/
cljs.core._ = (function() {
var _ = null;
var ___1 = (function (x){
return (- x);
});
var ___2 = (function (x,y){
return (x - y);
});
var ___3 = (function() { 
var G__8861__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(_,(x - y),more);
};
var G__8861 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8862__i = 0, G__8862__a = new Array(arguments.length -  2);
while (G__8862__i < G__8862__a.length) {G__8862__a[G__8862__i] = arguments[G__8862__i + 2]; ++G__8862__i;}
  more = new cljs.core.IndexedSeq(G__8862__a,0);
} 
return G__8861__delegate.call(this,x,y,more);};
G__8861.cljs$lang$maxFixedArity = 2;
G__8861.cljs$lang$applyTo = (function (arglist__8863){
var x = cljs.core.first(arglist__8863);
arglist__8863 = cljs.core.next(arglist__8863);
var y = cljs.core.first(arglist__8863);
var more = cljs.core.rest(arglist__8863);
return G__8861__delegate(x,y,more);
});
G__8861.cljs$core$IFn$_invoke$arity$variadic = G__8861__delegate;
return G__8861;
})()
;
_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return ___1.call(this,x);
case 2:
return ___2.call(this,x,y);
default:
var G__8864 = null;
if (arguments.length > 2) {
var G__8865__i = 0, G__8865__a = new Array(arguments.length -  2);
while (G__8865__i < G__8865__a.length) {G__8865__a[G__8865__i] = arguments[G__8865__i + 2]; ++G__8865__i;}
G__8864 = new cljs.core.IndexedSeq(G__8865__a,0);
}
return ___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8864);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_.cljs$lang$maxFixedArity = 2;
_.cljs$lang$applyTo = ___3.cljs$lang$applyTo;
_.cljs$core$IFn$_invoke$arity$1 = ___1;
_.cljs$core$IFn$_invoke$arity$2 = ___2;
_.cljs$core$IFn$_invoke$arity$variadic = ___3.cljs$core$IFn$_invoke$arity$variadic;
return _;
})()
;
/**
* Returns the product of nums. (*) returns 1.
* @param {...*} var_args
*/
cljs.core._STAR_ = (function() {
var _STAR_ = null;
var _STAR___0 = (function (){
return (1);
});
var _STAR___1 = (function (x){
return x;
});
var _STAR___2 = (function (x,y){
return (x * y);
});
var _STAR___3 = (function() { 
var G__8866__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(_STAR_,(x * y),more);
};
var G__8866 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8867__i = 0, G__8867__a = new Array(arguments.length -  2);
while (G__8867__i < G__8867__a.length) {G__8867__a[G__8867__i] = arguments[G__8867__i + 2]; ++G__8867__i;}
  more = new cljs.core.IndexedSeq(G__8867__a,0);
} 
return G__8866__delegate.call(this,x,y,more);};
G__8866.cljs$lang$maxFixedArity = 2;
G__8866.cljs$lang$applyTo = (function (arglist__8868){
var x = cljs.core.first(arglist__8868);
arglist__8868 = cljs.core.next(arglist__8868);
var y = cljs.core.first(arglist__8868);
var more = cljs.core.rest(arglist__8868);
return G__8866__delegate(x,y,more);
});
G__8866.cljs$core$IFn$_invoke$arity$variadic = G__8866__delegate;
return G__8866;
})()
;
_STAR_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return _STAR___0.call(this);
case 1:
return _STAR___1.call(this,x);
case 2:
return _STAR___2.call(this,x,y);
default:
var G__8869 = null;
if (arguments.length > 2) {
var G__8870__i = 0, G__8870__a = new Array(arguments.length -  2);
while (G__8870__i < G__8870__a.length) {G__8870__a[G__8870__i] = arguments[G__8870__i + 2]; ++G__8870__i;}
G__8869 = new cljs.core.IndexedSeq(G__8870__a,0);
}
return _STAR___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8869);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_STAR_.cljs$lang$maxFixedArity = 2;
_STAR_.cljs$lang$applyTo = _STAR___3.cljs$lang$applyTo;
_STAR_.cljs$core$IFn$_invoke$arity$0 = _STAR___0;
_STAR_.cljs$core$IFn$_invoke$arity$1 = _STAR___1;
_STAR_.cljs$core$IFn$_invoke$arity$2 = _STAR___2;
_STAR_.cljs$core$IFn$_invoke$arity$variadic = _STAR___3.cljs$core$IFn$_invoke$arity$variadic;
return _STAR_;
})()
;
/**
* If no denominators are supplied, returns 1/numerator,
* else returns numerator divided by all of the denominators.
* @param {...*} var_args
*/
cljs.core._SLASH_ = (function() {
var _SLASH_ = null;
var _SLASH___1 = (function (x){
return _SLASH_.cljs$core$IFn$_invoke$arity$2((1),x);
});
var _SLASH___2 = (function (x,y){
return (x / y);
});
var _SLASH___3 = (function() { 
var G__8875__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(_SLASH_,_SLASH_.cljs$core$IFn$_invoke$arity$2(x,y),more);
};
var G__8875 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8876__i = 0, G__8876__a = new Array(arguments.length -  2);
while (G__8876__i < G__8876__a.length) {G__8876__a[G__8876__i] = arguments[G__8876__i + 2]; ++G__8876__i;}
  more = new cljs.core.IndexedSeq(G__8876__a,0);
} 
return G__8875__delegate.call(this,x,y,more);};
G__8875.cljs$lang$maxFixedArity = 2;
G__8875.cljs$lang$applyTo = (function (arglist__8877){
var x = cljs.core.first(arglist__8877);
arglist__8877 = cljs.core.next(arglist__8877);
var y = cljs.core.first(arglist__8877);
var more = cljs.core.rest(arglist__8877);
return G__8875__delegate(x,y,more);
});
G__8875.cljs$core$IFn$_invoke$arity$variadic = G__8875__delegate;
return G__8875;
})()
;
_SLASH_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return _SLASH___1.call(this,x);
case 2:
return _SLASH___2.call(this,x,y);
default:
var G__8878 = null;
if (arguments.length > 2) {
var G__8879__i = 0, G__8879__a = new Array(arguments.length -  2);
while (G__8879__i < G__8879__a.length) {G__8879__a[G__8879__i] = arguments[G__8879__i + 2]; ++G__8879__i;}
G__8878 = new cljs.core.IndexedSeq(G__8879__a,0);
}
return _SLASH___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8878);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_SLASH_.cljs$lang$maxFixedArity = 2;
_SLASH_.cljs$lang$applyTo = _SLASH___3.cljs$lang$applyTo;
_SLASH_.cljs$core$IFn$_invoke$arity$1 = _SLASH___1;
_SLASH_.cljs$core$IFn$_invoke$arity$2 = _SLASH___2;
_SLASH_.cljs$core$IFn$_invoke$arity$variadic = _SLASH___3.cljs$core$IFn$_invoke$arity$variadic;
return _SLASH_;
})()
;
/**
* Returns non-nil if nums are in monotonically increasing order,
* otherwise false.
* @param {...*} var_args
*/
cljs.core._LT_ = (function() {
var _LT_ = null;
var _LT___1 = (function (x){
return true;
});
var _LT___2 = (function (x,y){
return (x < y);
});
var _LT___3 = (function() { 
var G__8880__delegate = function (x,y,more){
while(true){
if((x < y)){
if(cljs.core.next(more)){
var G__8881 = y;
var G__8882 = cljs.core.first(more);
var G__8883 = cljs.core.next(more);
x = G__8881;
y = G__8882;
more = G__8883;
continue;
} else {
return (y < cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__8880 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8884__i = 0, G__8884__a = new Array(arguments.length -  2);
while (G__8884__i < G__8884__a.length) {G__8884__a[G__8884__i] = arguments[G__8884__i + 2]; ++G__8884__i;}
  more = new cljs.core.IndexedSeq(G__8884__a,0);
} 
return G__8880__delegate.call(this,x,y,more);};
G__8880.cljs$lang$maxFixedArity = 2;
G__8880.cljs$lang$applyTo = (function (arglist__8885){
var x = cljs.core.first(arglist__8885);
arglist__8885 = cljs.core.next(arglist__8885);
var y = cljs.core.first(arglist__8885);
var more = cljs.core.rest(arglist__8885);
return G__8880__delegate(x,y,more);
});
G__8880.cljs$core$IFn$_invoke$arity$variadic = G__8880__delegate;
return G__8880;
})()
;
_LT_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return _LT___1.call(this,x);
case 2:
return _LT___2.call(this,x,y);
default:
var G__8886 = null;
if (arguments.length > 2) {
var G__8887__i = 0, G__8887__a = new Array(arguments.length -  2);
while (G__8887__i < G__8887__a.length) {G__8887__a[G__8887__i] = arguments[G__8887__i + 2]; ++G__8887__i;}
G__8886 = new cljs.core.IndexedSeq(G__8887__a,0);
}
return _LT___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8886);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_LT_.cljs$lang$maxFixedArity = 2;
_LT_.cljs$lang$applyTo = _LT___3.cljs$lang$applyTo;
_LT_.cljs$core$IFn$_invoke$arity$1 = _LT___1;
_LT_.cljs$core$IFn$_invoke$arity$2 = _LT___2;
_LT_.cljs$core$IFn$_invoke$arity$variadic = _LT___3.cljs$core$IFn$_invoke$arity$variadic;
return _LT_;
})()
;
/**
* Returns non-nil if nums are in monotonically non-decreasing order,
* otherwise false.
* @param {...*} var_args
*/
cljs.core._LT__EQ_ = (function() {
var _LT__EQ_ = null;
var _LT__EQ___1 = (function (x){
return true;
});
var _LT__EQ___2 = (function (x,y){
return (x <= y);
});
var _LT__EQ___3 = (function() { 
var G__8888__delegate = function (x,y,more){
while(true){
if((x <= y)){
if(cljs.core.next(more)){
var G__8889 = y;
var G__8890 = cljs.core.first(more);
var G__8891 = cljs.core.next(more);
x = G__8889;
y = G__8890;
more = G__8891;
continue;
} else {
return (y <= cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__8888 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8892__i = 0, G__8892__a = new Array(arguments.length -  2);
while (G__8892__i < G__8892__a.length) {G__8892__a[G__8892__i] = arguments[G__8892__i + 2]; ++G__8892__i;}
  more = new cljs.core.IndexedSeq(G__8892__a,0);
} 
return G__8888__delegate.call(this,x,y,more);};
G__8888.cljs$lang$maxFixedArity = 2;
G__8888.cljs$lang$applyTo = (function (arglist__8893){
var x = cljs.core.first(arglist__8893);
arglist__8893 = cljs.core.next(arglist__8893);
var y = cljs.core.first(arglist__8893);
var more = cljs.core.rest(arglist__8893);
return G__8888__delegate(x,y,more);
});
G__8888.cljs$core$IFn$_invoke$arity$variadic = G__8888__delegate;
return G__8888;
})()
;
_LT__EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return _LT__EQ___1.call(this,x);
case 2:
return _LT__EQ___2.call(this,x,y);
default:
var G__8894 = null;
if (arguments.length > 2) {
var G__8895__i = 0, G__8895__a = new Array(arguments.length -  2);
while (G__8895__i < G__8895__a.length) {G__8895__a[G__8895__i] = arguments[G__8895__i + 2]; ++G__8895__i;}
G__8894 = new cljs.core.IndexedSeq(G__8895__a,0);
}
return _LT__EQ___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8894);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_LT__EQ_.cljs$lang$maxFixedArity = 2;
_LT__EQ_.cljs$lang$applyTo = _LT__EQ___3.cljs$lang$applyTo;
_LT__EQ_.cljs$core$IFn$_invoke$arity$1 = _LT__EQ___1;
_LT__EQ_.cljs$core$IFn$_invoke$arity$2 = _LT__EQ___2;
_LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = _LT__EQ___3.cljs$core$IFn$_invoke$arity$variadic;
return _LT__EQ_;
})()
;
/**
* Returns non-nil if nums are in monotonically decreasing order,
* otherwise false.
* @param {...*} var_args
*/
cljs.core._GT_ = (function() {
var _GT_ = null;
var _GT___1 = (function (x){
return true;
});
var _GT___2 = (function (x,y){
return (x > y);
});
var _GT___3 = (function() { 
var G__8896__delegate = function (x,y,more){
while(true){
if((x > y)){
if(cljs.core.next(more)){
var G__8897 = y;
var G__8898 = cljs.core.first(more);
var G__8899 = cljs.core.next(more);
x = G__8897;
y = G__8898;
more = G__8899;
continue;
} else {
return (y > cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__8896 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8900__i = 0, G__8900__a = new Array(arguments.length -  2);
while (G__8900__i < G__8900__a.length) {G__8900__a[G__8900__i] = arguments[G__8900__i + 2]; ++G__8900__i;}
  more = new cljs.core.IndexedSeq(G__8900__a,0);
} 
return G__8896__delegate.call(this,x,y,more);};
G__8896.cljs$lang$maxFixedArity = 2;
G__8896.cljs$lang$applyTo = (function (arglist__8901){
var x = cljs.core.first(arglist__8901);
arglist__8901 = cljs.core.next(arglist__8901);
var y = cljs.core.first(arglist__8901);
var more = cljs.core.rest(arglist__8901);
return G__8896__delegate(x,y,more);
});
G__8896.cljs$core$IFn$_invoke$arity$variadic = G__8896__delegate;
return G__8896;
})()
;
_GT_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return _GT___1.call(this,x);
case 2:
return _GT___2.call(this,x,y);
default:
var G__8902 = null;
if (arguments.length > 2) {
var G__8903__i = 0, G__8903__a = new Array(arguments.length -  2);
while (G__8903__i < G__8903__a.length) {G__8903__a[G__8903__i] = arguments[G__8903__i + 2]; ++G__8903__i;}
G__8902 = new cljs.core.IndexedSeq(G__8903__a,0);
}
return _GT___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8902);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_GT_.cljs$lang$maxFixedArity = 2;
_GT_.cljs$lang$applyTo = _GT___3.cljs$lang$applyTo;
_GT_.cljs$core$IFn$_invoke$arity$1 = _GT___1;
_GT_.cljs$core$IFn$_invoke$arity$2 = _GT___2;
_GT_.cljs$core$IFn$_invoke$arity$variadic = _GT___3.cljs$core$IFn$_invoke$arity$variadic;
return _GT_;
})()
;
/**
* Returns non-nil if nums are in monotonically non-increasing order,
* otherwise false.
* @param {...*} var_args
*/
cljs.core._GT__EQ_ = (function() {
var _GT__EQ_ = null;
var _GT__EQ___1 = (function (x){
return true;
});
var _GT__EQ___2 = (function (x,y){
return (x >= y);
});
var _GT__EQ___3 = (function() { 
var G__8904__delegate = function (x,y,more){
while(true){
if((x >= y)){
if(cljs.core.next(more)){
var G__8905 = y;
var G__8906 = cljs.core.first(more);
var G__8907 = cljs.core.next(more);
x = G__8905;
y = G__8906;
more = G__8907;
continue;
} else {
return (y >= cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__8904 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8908__i = 0, G__8908__a = new Array(arguments.length -  2);
while (G__8908__i < G__8908__a.length) {G__8908__a[G__8908__i] = arguments[G__8908__i + 2]; ++G__8908__i;}
  more = new cljs.core.IndexedSeq(G__8908__a,0);
} 
return G__8904__delegate.call(this,x,y,more);};
G__8904.cljs$lang$maxFixedArity = 2;
G__8904.cljs$lang$applyTo = (function (arglist__8909){
var x = cljs.core.first(arglist__8909);
arglist__8909 = cljs.core.next(arglist__8909);
var y = cljs.core.first(arglist__8909);
var more = cljs.core.rest(arglist__8909);
return G__8904__delegate(x,y,more);
});
G__8904.cljs$core$IFn$_invoke$arity$variadic = G__8904__delegate;
return G__8904;
})()
;
_GT__EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return _GT__EQ___1.call(this,x);
case 2:
return _GT__EQ___2.call(this,x,y);
default:
var G__8910 = null;
if (arguments.length > 2) {
var G__8911__i = 0, G__8911__a = new Array(arguments.length -  2);
while (G__8911__i < G__8911__a.length) {G__8911__a[G__8911__i] = arguments[G__8911__i + 2]; ++G__8911__i;}
G__8910 = new cljs.core.IndexedSeq(G__8911__a,0);
}
return _GT__EQ___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8910);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_GT__EQ_.cljs$lang$maxFixedArity = 2;
_GT__EQ_.cljs$lang$applyTo = _GT__EQ___3.cljs$lang$applyTo;
_GT__EQ_.cljs$core$IFn$_invoke$arity$1 = _GT__EQ___1;
_GT__EQ_.cljs$core$IFn$_invoke$arity$2 = _GT__EQ___2;
_GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = _GT__EQ___3.cljs$core$IFn$_invoke$arity$variadic;
return _GT__EQ_;
})()
;
/**
* Returns a number one less than num.
*/
cljs.core.dec = (function dec(x){
return (x - (1));
});
/**
* Returns the greatest of the nums.
* @param {...*} var_args
*/
cljs.core.max = (function() {
var max = null;
var max__1 = (function (x){
return x;
});
var max__2 = (function (x,y){
var x__4075__auto__ = x;
var y__4076__auto__ = y;
return ((x__4075__auto__ > y__4076__auto__) ? x__4075__auto__ : y__4076__auto__);
});
var max__3 = (function() { 
var G__8912__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(max,(function (){var x__4075__auto__ = x;
var y__4076__auto__ = y;
return ((x__4075__auto__ > y__4076__auto__) ? x__4075__auto__ : y__4076__auto__);
})(),more);
};
var G__8912 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8913__i = 0, G__8913__a = new Array(arguments.length -  2);
while (G__8913__i < G__8913__a.length) {G__8913__a[G__8913__i] = arguments[G__8913__i + 2]; ++G__8913__i;}
  more = new cljs.core.IndexedSeq(G__8913__a,0);
} 
return G__8912__delegate.call(this,x,y,more);};
G__8912.cljs$lang$maxFixedArity = 2;
G__8912.cljs$lang$applyTo = (function (arglist__8914){
var x = cljs.core.first(arglist__8914);
arglist__8914 = cljs.core.next(arglist__8914);
var y = cljs.core.first(arglist__8914);
var more = cljs.core.rest(arglist__8914);
return G__8912__delegate(x,y,more);
});
G__8912.cljs$core$IFn$_invoke$arity$variadic = G__8912__delegate;
return G__8912;
})()
;
max = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return max__1.call(this,x);
case 2:
return max__2.call(this,x,y);
default:
var G__8915 = null;
if (arguments.length > 2) {
var G__8916__i = 0, G__8916__a = new Array(arguments.length -  2);
while (G__8916__i < G__8916__a.length) {G__8916__a[G__8916__i] = arguments[G__8916__i + 2]; ++G__8916__i;}
G__8915 = new cljs.core.IndexedSeq(G__8916__a,0);
}
return max__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8915);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
max.cljs$lang$maxFixedArity = 2;
max.cljs$lang$applyTo = max__3.cljs$lang$applyTo;
max.cljs$core$IFn$_invoke$arity$1 = max__1;
max.cljs$core$IFn$_invoke$arity$2 = max__2;
max.cljs$core$IFn$_invoke$arity$variadic = max__3.cljs$core$IFn$_invoke$arity$variadic;
return max;
})()
;
/**
* Returns the least of the nums.
* @param {...*} var_args
*/
cljs.core.min = (function() {
var min = null;
var min__1 = (function (x){
return x;
});
var min__2 = (function (x,y){
var x__4082__auto__ = x;
var y__4083__auto__ = y;
return ((x__4082__auto__ < y__4083__auto__) ? x__4082__auto__ : y__4083__auto__);
});
var min__3 = (function() { 
var G__8917__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(min,(function (){var x__4082__auto__ = x;
var y__4083__auto__ = y;
return ((x__4082__auto__ < y__4083__auto__) ? x__4082__auto__ : y__4083__auto__);
})(),more);
};
var G__8917 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8918__i = 0, G__8918__a = new Array(arguments.length -  2);
while (G__8918__i < G__8918__a.length) {G__8918__a[G__8918__i] = arguments[G__8918__i + 2]; ++G__8918__i;}
  more = new cljs.core.IndexedSeq(G__8918__a,0);
} 
return G__8917__delegate.call(this,x,y,more);};
G__8917.cljs$lang$maxFixedArity = 2;
G__8917.cljs$lang$applyTo = (function (arglist__8919){
var x = cljs.core.first(arglist__8919);
arglist__8919 = cljs.core.next(arglist__8919);
var y = cljs.core.first(arglist__8919);
var more = cljs.core.rest(arglist__8919);
return G__8917__delegate(x,y,more);
});
G__8917.cljs$core$IFn$_invoke$arity$variadic = G__8917__delegate;
return G__8917;
})()
;
min = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return min__1.call(this,x);
case 2:
return min__2.call(this,x,y);
default:
var G__8920 = null;
if (arguments.length > 2) {
var G__8921__i = 0, G__8921__a = new Array(arguments.length -  2);
while (G__8921__i < G__8921__a.length) {G__8921__a[G__8921__i] = arguments[G__8921__i + 2]; ++G__8921__i;}
G__8920 = new cljs.core.IndexedSeq(G__8921__a,0);
}
return min__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8920);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
min.cljs$lang$maxFixedArity = 2;
min.cljs$lang$applyTo = min__3.cljs$lang$applyTo;
min.cljs$core$IFn$_invoke$arity$1 = min__1;
min.cljs$core$IFn$_invoke$arity$2 = min__2;
min.cljs$core$IFn$_invoke$arity$variadic = min__3.cljs$core$IFn$_invoke$arity$variadic;
return min;
})()
;
cljs.core.byte$ = (function byte$(x){
return x;
});
/**
* Coerce to char
*/
cljs.core.char$ = (function char$(x){
if(typeof x === 'number'){
return String.fromCharCode(x);
} else {
if((typeof x === 'string') && ((x.length === (1)))){
return x;
} else {
throw (new Error("Argument to char must be a character or number"));

}
}
});
cljs.core.short$ = (function short$(x){
return x;
});
cljs.core.float$ = (function float$(x){
return x;
});
cljs.core.double$ = (function double$(x){
return x;
});
cljs.core.unchecked_byte = (function unchecked_byte(x){
return x;
});
cljs.core.unchecked_char = (function unchecked_char(x){
return x;
});
cljs.core.unchecked_short = (function unchecked_short(x){
return x;
});
cljs.core.unchecked_float = (function unchecked_float(x){
return x;
});
cljs.core.unchecked_double = (function unchecked_double(x){
return x;
});
/**
* Returns the sum of nums. (+) returns 0.
* @param {...*} var_args
*/
cljs.core.unchecked_add = (function() {
var unchecked_add = null;
var unchecked_add__0 = (function (){
return (0);
});
var unchecked_add__1 = (function (x){
return x;
});
var unchecked_add__2 = (function (x,y){
return (x + y);
});
var unchecked_add__3 = (function() { 
var G__8922__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(unchecked_add,(x + y),more);
};
var G__8922 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8923__i = 0, G__8923__a = new Array(arguments.length -  2);
while (G__8923__i < G__8923__a.length) {G__8923__a[G__8923__i] = arguments[G__8923__i + 2]; ++G__8923__i;}
  more = new cljs.core.IndexedSeq(G__8923__a,0);
} 
return G__8922__delegate.call(this,x,y,more);};
G__8922.cljs$lang$maxFixedArity = 2;
G__8922.cljs$lang$applyTo = (function (arglist__8924){
var x = cljs.core.first(arglist__8924);
arglist__8924 = cljs.core.next(arglist__8924);
var y = cljs.core.first(arglist__8924);
var more = cljs.core.rest(arglist__8924);
return G__8922__delegate(x,y,more);
});
G__8922.cljs$core$IFn$_invoke$arity$variadic = G__8922__delegate;
return G__8922;
})()
;
unchecked_add = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return unchecked_add__0.call(this);
case 1:
return unchecked_add__1.call(this,x);
case 2:
return unchecked_add__2.call(this,x,y);
default:
var G__8925 = null;
if (arguments.length > 2) {
var G__8926__i = 0, G__8926__a = new Array(arguments.length -  2);
while (G__8926__i < G__8926__a.length) {G__8926__a[G__8926__i] = arguments[G__8926__i + 2]; ++G__8926__i;}
G__8925 = new cljs.core.IndexedSeq(G__8926__a,0);
}
return unchecked_add__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8925);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unchecked_add.cljs$lang$maxFixedArity = 2;
unchecked_add.cljs$lang$applyTo = unchecked_add__3.cljs$lang$applyTo;
unchecked_add.cljs$core$IFn$_invoke$arity$0 = unchecked_add__0;
unchecked_add.cljs$core$IFn$_invoke$arity$1 = unchecked_add__1;
unchecked_add.cljs$core$IFn$_invoke$arity$2 = unchecked_add__2;
unchecked_add.cljs$core$IFn$_invoke$arity$variadic = unchecked_add__3.cljs$core$IFn$_invoke$arity$variadic;
return unchecked_add;
})()
;
/**
* Returns the sum of nums. (+) returns 0.
* @param {...*} var_args
*/
cljs.core.unchecked_add_int = (function() {
var unchecked_add_int = null;
var unchecked_add_int__0 = (function (){
return (0);
});
var unchecked_add_int__1 = (function (x){
return x;
});
var unchecked_add_int__2 = (function (x,y){
return (x + y);
});
var unchecked_add_int__3 = (function() { 
var G__8927__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(unchecked_add_int,(x + y),more);
};
var G__8927 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8928__i = 0, G__8928__a = new Array(arguments.length -  2);
while (G__8928__i < G__8928__a.length) {G__8928__a[G__8928__i] = arguments[G__8928__i + 2]; ++G__8928__i;}
  more = new cljs.core.IndexedSeq(G__8928__a,0);
} 
return G__8927__delegate.call(this,x,y,more);};
G__8927.cljs$lang$maxFixedArity = 2;
G__8927.cljs$lang$applyTo = (function (arglist__8929){
var x = cljs.core.first(arglist__8929);
arglist__8929 = cljs.core.next(arglist__8929);
var y = cljs.core.first(arglist__8929);
var more = cljs.core.rest(arglist__8929);
return G__8927__delegate(x,y,more);
});
G__8927.cljs$core$IFn$_invoke$arity$variadic = G__8927__delegate;
return G__8927;
})()
;
unchecked_add_int = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return unchecked_add_int__0.call(this);
case 1:
return unchecked_add_int__1.call(this,x);
case 2:
return unchecked_add_int__2.call(this,x,y);
default:
var G__8930 = null;
if (arguments.length > 2) {
var G__8931__i = 0, G__8931__a = new Array(arguments.length -  2);
while (G__8931__i < G__8931__a.length) {G__8931__a[G__8931__i] = arguments[G__8931__i + 2]; ++G__8931__i;}
G__8930 = new cljs.core.IndexedSeq(G__8931__a,0);
}
return unchecked_add_int__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8930);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unchecked_add_int.cljs$lang$maxFixedArity = 2;
unchecked_add_int.cljs$lang$applyTo = unchecked_add_int__3.cljs$lang$applyTo;
unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = unchecked_add_int__0;
unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = unchecked_add_int__1;
unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = unchecked_add_int__2;
unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = unchecked_add_int__3.cljs$core$IFn$_invoke$arity$variadic;
return unchecked_add_int;
})()
;
cljs.core.unchecked_dec = (function unchecked_dec(x){
return (x - (1));
});
cljs.core.unchecked_dec_int = (function unchecked_dec_int(x){
return (x - (1));
});
/**
* If no denominators are supplied, returns 1/numerator,
* else returns numerator divided by all of the denominators.
* @param {...*} var_args
*/
cljs.core.unchecked_divide_int = (function() {
var unchecked_divide_int = null;
var unchecked_divide_int__1 = (function (x){
return unchecked_divide_int.cljs$core$IFn$_invoke$arity$2((1),x);
});
var unchecked_divide_int__2 = (function (x,y){
return (x / y);
});
var unchecked_divide_int__3 = (function() { 
var G__8936__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(unchecked_divide_int,unchecked_divide_int.cljs$core$IFn$_invoke$arity$2(x,y),more);
};
var G__8936 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8937__i = 0, G__8937__a = new Array(arguments.length -  2);
while (G__8937__i < G__8937__a.length) {G__8937__a[G__8937__i] = arguments[G__8937__i + 2]; ++G__8937__i;}
  more = new cljs.core.IndexedSeq(G__8937__a,0);
} 
return G__8936__delegate.call(this,x,y,more);};
G__8936.cljs$lang$maxFixedArity = 2;
G__8936.cljs$lang$applyTo = (function (arglist__8938){
var x = cljs.core.first(arglist__8938);
arglist__8938 = cljs.core.next(arglist__8938);
var y = cljs.core.first(arglist__8938);
var more = cljs.core.rest(arglist__8938);
return G__8936__delegate(x,y,more);
});
G__8936.cljs$core$IFn$_invoke$arity$variadic = G__8936__delegate;
return G__8936;
})()
;
unchecked_divide_int = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return unchecked_divide_int__1.call(this,x);
case 2:
return unchecked_divide_int__2.call(this,x,y);
default:
var G__8939 = null;
if (arguments.length > 2) {
var G__8940__i = 0, G__8940__a = new Array(arguments.length -  2);
while (G__8940__i < G__8940__a.length) {G__8940__a[G__8940__i] = arguments[G__8940__i + 2]; ++G__8940__i;}
G__8939 = new cljs.core.IndexedSeq(G__8940__a,0);
}
return unchecked_divide_int__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8939);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unchecked_divide_int.cljs$lang$maxFixedArity = 2;
unchecked_divide_int.cljs$lang$applyTo = unchecked_divide_int__3.cljs$lang$applyTo;
unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = unchecked_divide_int__1;
unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = unchecked_divide_int__2;
unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = unchecked_divide_int__3.cljs$core$IFn$_invoke$arity$variadic;
return unchecked_divide_int;
})()
;
cljs.core.unchecked_inc = (function unchecked_inc(x){
return (x + (1));
});
cljs.core.unchecked_inc_int = (function unchecked_inc_int(x){
return (x + (1));
});
/**
* Returns the product of nums. (*) returns 1.
* @param {...*} var_args
*/
cljs.core.unchecked_multiply = (function() {
var unchecked_multiply = null;
var unchecked_multiply__0 = (function (){
return (1);
});
var unchecked_multiply__1 = (function (x){
return x;
});
var unchecked_multiply__2 = (function (x,y){
return (x * y);
});
var unchecked_multiply__3 = (function() { 
var G__8941__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(unchecked_multiply,(x * y),more);
};
var G__8941 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8942__i = 0, G__8942__a = new Array(arguments.length -  2);
while (G__8942__i < G__8942__a.length) {G__8942__a[G__8942__i] = arguments[G__8942__i + 2]; ++G__8942__i;}
  more = new cljs.core.IndexedSeq(G__8942__a,0);
} 
return G__8941__delegate.call(this,x,y,more);};
G__8941.cljs$lang$maxFixedArity = 2;
G__8941.cljs$lang$applyTo = (function (arglist__8943){
var x = cljs.core.first(arglist__8943);
arglist__8943 = cljs.core.next(arglist__8943);
var y = cljs.core.first(arglist__8943);
var more = cljs.core.rest(arglist__8943);
return G__8941__delegate(x,y,more);
});
G__8941.cljs$core$IFn$_invoke$arity$variadic = G__8941__delegate;
return G__8941;
})()
;
unchecked_multiply = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return unchecked_multiply__0.call(this);
case 1:
return unchecked_multiply__1.call(this,x);
case 2:
return unchecked_multiply__2.call(this,x,y);
default:
var G__8944 = null;
if (arguments.length > 2) {
var G__8945__i = 0, G__8945__a = new Array(arguments.length -  2);
while (G__8945__i < G__8945__a.length) {G__8945__a[G__8945__i] = arguments[G__8945__i + 2]; ++G__8945__i;}
G__8944 = new cljs.core.IndexedSeq(G__8945__a,0);
}
return unchecked_multiply__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8944);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unchecked_multiply.cljs$lang$maxFixedArity = 2;
unchecked_multiply.cljs$lang$applyTo = unchecked_multiply__3.cljs$lang$applyTo;
unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = unchecked_multiply__0;
unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = unchecked_multiply__1;
unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = unchecked_multiply__2;
unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = unchecked_multiply__3.cljs$core$IFn$_invoke$arity$variadic;
return unchecked_multiply;
})()
;
/**
* Returns the product of nums. (*) returns 1.
* @param {...*} var_args
*/
cljs.core.unchecked_multiply_int = (function() {
var unchecked_multiply_int = null;
var unchecked_multiply_int__0 = (function (){
return (1);
});
var unchecked_multiply_int__1 = (function (x){
return x;
});
var unchecked_multiply_int__2 = (function (x,y){
return (x * y);
});
var unchecked_multiply_int__3 = (function() { 
var G__8946__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(unchecked_multiply_int,(x * y),more);
};
var G__8946 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8947__i = 0, G__8947__a = new Array(arguments.length -  2);
while (G__8947__i < G__8947__a.length) {G__8947__a[G__8947__i] = arguments[G__8947__i + 2]; ++G__8947__i;}
  more = new cljs.core.IndexedSeq(G__8947__a,0);
} 
return G__8946__delegate.call(this,x,y,more);};
G__8946.cljs$lang$maxFixedArity = 2;
G__8946.cljs$lang$applyTo = (function (arglist__8948){
var x = cljs.core.first(arglist__8948);
arglist__8948 = cljs.core.next(arglist__8948);
var y = cljs.core.first(arglist__8948);
var more = cljs.core.rest(arglist__8948);
return G__8946__delegate(x,y,more);
});
G__8946.cljs$core$IFn$_invoke$arity$variadic = G__8946__delegate;
return G__8946;
})()
;
unchecked_multiply_int = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return unchecked_multiply_int__0.call(this);
case 1:
return unchecked_multiply_int__1.call(this,x);
case 2:
return unchecked_multiply_int__2.call(this,x,y);
default:
var G__8949 = null;
if (arguments.length > 2) {
var G__8950__i = 0, G__8950__a = new Array(arguments.length -  2);
while (G__8950__i < G__8950__a.length) {G__8950__a[G__8950__i] = arguments[G__8950__i + 2]; ++G__8950__i;}
G__8949 = new cljs.core.IndexedSeq(G__8950__a,0);
}
return unchecked_multiply_int__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8949);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unchecked_multiply_int.cljs$lang$maxFixedArity = 2;
unchecked_multiply_int.cljs$lang$applyTo = unchecked_multiply_int__3.cljs$lang$applyTo;
unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = unchecked_multiply_int__0;
unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = unchecked_multiply_int__1;
unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = unchecked_multiply_int__2;
unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = unchecked_multiply_int__3.cljs$core$IFn$_invoke$arity$variadic;
return unchecked_multiply_int;
})()
;
cljs.core.unchecked_negate = (function unchecked_negate(x){
return (- x);
});
cljs.core.unchecked_negate_int = (function unchecked_negate_int(x){
return (- x);
});
cljs.core.unchecked_remainder_int = (function unchecked_remainder_int(x,n){
var G__8953 = x;
var G__8954 = n;
return (cljs.core.mod.cljs$core$IFn$_invoke$arity$2 ? cljs.core.mod.cljs$core$IFn$_invoke$arity$2(G__8953,G__8954) : cljs.core.mod.call(null,G__8953,G__8954));
});
/**
* If no ys are supplied, returns the negation of x, else subtracts
* the ys from x and returns the result.
* @param {...*} var_args
*/
cljs.core.unchecked_subtract = (function() {
var unchecked_subtract = null;
var unchecked_subtract__1 = (function (x){
return (- x);
});
var unchecked_subtract__2 = (function (x,y){
return (x - y);
});
var unchecked_subtract__3 = (function() { 
var G__8955__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(unchecked_subtract,(x - y),more);
};
var G__8955 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8956__i = 0, G__8956__a = new Array(arguments.length -  2);
while (G__8956__i < G__8956__a.length) {G__8956__a[G__8956__i] = arguments[G__8956__i + 2]; ++G__8956__i;}
  more = new cljs.core.IndexedSeq(G__8956__a,0);
} 
return G__8955__delegate.call(this,x,y,more);};
G__8955.cljs$lang$maxFixedArity = 2;
G__8955.cljs$lang$applyTo = (function (arglist__8957){
var x = cljs.core.first(arglist__8957);
arglist__8957 = cljs.core.next(arglist__8957);
var y = cljs.core.first(arglist__8957);
var more = cljs.core.rest(arglist__8957);
return G__8955__delegate(x,y,more);
});
G__8955.cljs$core$IFn$_invoke$arity$variadic = G__8955__delegate;
return G__8955;
})()
;
unchecked_subtract = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return unchecked_subtract__1.call(this,x);
case 2:
return unchecked_subtract__2.call(this,x,y);
default:
var G__8958 = null;
if (arguments.length > 2) {
var G__8959__i = 0, G__8959__a = new Array(arguments.length -  2);
while (G__8959__i < G__8959__a.length) {G__8959__a[G__8959__i] = arguments[G__8959__i + 2]; ++G__8959__i;}
G__8958 = new cljs.core.IndexedSeq(G__8959__a,0);
}
return unchecked_subtract__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8958);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unchecked_subtract.cljs$lang$maxFixedArity = 2;
unchecked_subtract.cljs$lang$applyTo = unchecked_subtract__3.cljs$lang$applyTo;
unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = unchecked_subtract__1;
unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = unchecked_subtract__2;
unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = unchecked_subtract__3.cljs$core$IFn$_invoke$arity$variadic;
return unchecked_subtract;
})()
;
/**
* If no ys are supplied, returns the negation of x, else subtracts
* the ys from x and returns the result.
* @param {...*} var_args
*/
cljs.core.unchecked_subtract_int = (function() {
var unchecked_subtract_int = null;
var unchecked_subtract_int__1 = (function (x){
return (- x);
});
var unchecked_subtract_int__2 = (function (x,y){
return (x - y);
});
var unchecked_subtract_int__3 = (function() { 
var G__8960__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(unchecked_subtract_int,(x - y),more);
};
var G__8960 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8961__i = 0, G__8961__a = new Array(arguments.length -  2);
while (G__8961__i < G__8961__a.length) {G__8961__a[G__8961__i] = arguments[G__8961__i + 2]; ++G__8961__i;}
  more = new cljs.core.IndexedSeq(G__8961__a,0);
} 
return G__8960__delegate.call(this,x,y,more);};
G__8960.cljs$lang$maxFixedArity = 2;
G__8960.cljs$lang$applyTo = (function (arglist__8962){
var x = cljs.core.first(arglist__8962);
arglist__8962 = cljs.core.next(arglist__8962);
var y = cljs.core.first(arglist__8962);
var more = cljs.core.rest(arglist__8962);
return G__8960__delegate(x,y,more);
});
G__8960.cljs$core$IFn$_invoke$arity$variadic = G__8960__delegate;
return G__8960;
})()
;
unchecked_subtract_int = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return unchecked_subtract_int__1.call(this,x);
case 2:
return unchecked_subtract_int__2.call(this,x,y);
default:
var G__8963 = null;
if (arguments.length > 2) {
var G__8964__i = 0, G__8964__a = new Array(arguments.length -  2);
while (G__8964__i < G__8964__a.length) {G__8964__a[G__8964__i] = arguments[G__8964__i + 2]; ++G__8964__i;}
G__8963 = new cljs.core.IndexedSeq(G__8964__a,0);
}
return unchecked_subtract_int__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8963);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unchecked_subtract_int.cljs$lang$maxFixedArity = 2;
unchecked_subtract_int.cljs$lang$applyTo = unchecked_subtract_int__3.cljs$lang$applyTo;
unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = unchecked_subtract_int__1;
unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = unchecked_subtract_int__2;
unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = unchecked_subtract_int__3.cljs$core$IFn$_invoke$arity$variadic;
return unchecked_subtract_int;
})()
;
cljs.core.fix = (function fix(q){
if((q >= (0))){
var G__8967 = q;
return (Math.floor.cljs$core$IFn$_invoke$arity$1 ? Math.floor.cljs$core$IFn$_invoke$arity$1(G__8967) : Math.floor.call(null,G__8967));
} else {
var G__8968 = q;
return (Math.ceil.cljs$core$IFn$_invoke$arity$1 ? Math.ceil.cljs$core$IFn$_invoke$arity$1(G__8968) : Math.ceil.call(null,G__8968));
}
});
/**
* Coerce to int by stripping decimal places.
*/
cljs.core.int$ = (function int$(x){
return (x | (0));
});
/**
* Coerce to int by stripping decimal places.
*/
cljs.core.unchecked_int = (function unchecked_int(x){
return cljs.core.fix(x);
});
/**
* Coerce to long by stripping decimal places. Identical to `int'.
*/
cljs.core.long$ = (function long$(x){
return cljs.core.fix(x);
});
/**
* Coerce to long by stripping decimal places. Identical to `int'.
*/
cljs.core.unchecked_long = (function unchecked_long(x){
return cljs.core.fix(x);
});
cljs.core.booleans = (function booleans(x){
return x;
});
cljs.core.bytes = (function bytes(x){
return x;
});
cljs.core.chars = (function chars(x){
return x;
});
cljs.core.shorts = (function shorts(x){
return x;
});
cljs.core.ints = (function ints(x){
return x;
});
cljs.core.floats = (function floats(x){
return x;
});
cljs.core.doubles = (function doubles(x){
return x;
});
cljs.core.longs = (function longs(x){
return x;
});
/**
* Modulus of num and div with original javascript behavior. i.e. bug for negative numbers
*/
cljs.core.js_mod = (function js_mod(n,d){
return (n % d);
});
/**
* Modulus of num and div. Truncates toward negative infinity.
*/
cljs.core.mod = (function mod(n,d){
return (((n % d) + d) % d);
});
/**
* quot[ient] of dividing numerator by denominator.
*/
cljs.core.quot = (function quot(n,d){
var rem = (n % d);
return cljs.core.fix(((n - rem) / d));
});
/**
* remainder of dividing numerator by denominator.
*/
cljs.core.rem = (function rem(n,d){
var q = cljs.core.quot(n,d);
return (n - (d * q));
});
/**
* Bitwise exclusive or
* @param {...*} var_args
*/
cljs.core.bit_xor = (function() {
var bit_xor = null;
var bit_xor__2 = (function (x,y){
return (x ^ y);
});
var bit_xor__3 = (function() { 
var G__8969__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(bit_xor,(x ^ y),more);
};
var G__8969 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8970__i = 0, G__8970__a = new Array(arguments.length -  2);
while (G__8970__i < G__8970__a.length) {G__8970__a[G__8970__i] = arguments[G__8970__i + 2]; ++G__8970__i;}
  more = new cljs.core.IndexedSeq(G__8970__a,0);
} 
return G__8969__delegate.call(this,x,y,more);};
G__8969.cljs$lang$maxFixedArity = 2;
G__8969.cljs$lang$applyTo = (function (arglist__8971){
var x = cljs.core.first(arglist__8971);
arglist__8971 = cljs.core.next(arglist__8971);
var y = cljs.core.first(arglist__8971);
var more = cljs.core.rest(arglist__8971);
return G__8969__delegate(x,y,more);
});
G__8969.cljs$core$IFn$_invoke$arity$variadic = G__8969__delegate;
return G__8969;
})()
;
bit_xor = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return bit_xor__2.call(this,x,y);
default:
var G__8972 = null;
if (arguments.length > 2) {
var G__8973__i = 0, G__8973__a = new Array(arguments.length -  2);
while (G__8973__i < G__8973__a.length) {G__8973__a[G__8973__i] = arguments[G__8973__i + 2]; ++G__8973__i;}
G__8972 = new cljs.core.IndexedSeq(G__8973__a,0);
}
return bit_xor__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8972);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
bit_xor.cljs$lang$maxFixedArity = 2;
bit_xor.cljs$lang$applyTo = bit_xor__3.cljs$lang$applyTo;
bit_xor.cljs$core$IFn$_invoke$arity$2 = bit_xor__2;
bit_xor.cljs$core$IFn$_invoke$arity$variadic = bit_xor__3.cljs$core$IFn$_invoke$arity$variadic;
return bit_xor;
})()
;
/**
* Bitwise and
* @param {...*} var_args
*/
cljs.core.bit_and = (function() {
var bit_and = null;
var bit_and__2 = (function (x,y){
return (x & y);
});
var bit_and__3 = (function() { 
var G__8974__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(bit_and,(x & y),more);
};
var G__8974 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8975__i = 0, G__8975__a = new Array(arguments.length -  2);
while (G__8975__i < G__8975__a.length) {G__8975__a[G__8975__i] = arguments[G__8975__i + 2]; ++G__8975__i;}
  more = new cljs.core.IndexedSeq(G__8975__a,0);
} 
return G__8974__delegate.call(this,x,y,more);};
G__8974.cljs$lang$maxFixedArity = 2;
G__8974.cljs$lang$applyTo = (function (arglist__8976){
var x = cljs.core.first(arglist__8976);
arglist__8976 = cljs.core.next(arglist__8976);
var y = cljs.core.first(arglist__8976);
var more = cljs.core.rest(arglist__8976);
return G__8974__delegate(x,y,more);
});
G__8974.cljs$core$IFn$_invoke$arity$variadic = G__8974__delegate;
return G__8974;
})()
;
bit_and = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return bit_and__2.call(this,x,y);
default:
var G__8977 = null;
if (arguments.length > 2) {
var G__8978__i = 0, G__8978__a = new Array(arguments.length -  2);
while (G__8978__i < G__8978__a.length) {G__8978__a[G__8978__i] = arguments[G__8978__i + 2]; ++G__8978__i;}
G__8977 = new cljs.core.IndexedSeq(G__8978__a,0);
}
return bit_and__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8977);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
bit_and.cljs$lang$maxFixedArity = 2;
bit_and.cljs$lang$applyTo = bit_and__3.cljs$lang$applyTo;
bit_and.cljs$core$IFn$_invoke$arity$2 = bit_and__2;
bit_and.cljs$core$IFn$_invoke$arity$variadic = bit_and__3.cljs$core$IFn$_invoke$arity$variadic;
return bit_and;
})()
;
/**
* Bitwise or
* @param {...*} var_args
*/
cljs.core.bit_or = (function() {
var bit_or = null;
var bit_or__2 = (function (x,y){
return (x | y);
});
var bit_or__3 = (function() { 
var G__8979__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(bit_or,(x | y),more);
};
var G__8979 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8980__i = 0, G__8980__a = new Array(arguments.length -  2);
while (G__8980__i < G__8980__a.length) {G__8980__a[G__8980__i] = arguments[G__8980__i + 2]; ++G__8980__i;}
  more = new cljs.core.IndexedSeq(G__8980__a,0);
} 
return G__8979__delegate.call(this,x,y,more);};
G__8979.cljs$lang$maxFixedArity = 2;
G__8979.cljs$lang$applyTo = (function (arglist__8981){
var x = cljs.core.first(arglist__8981);
arglist__8981 = cljs.core.next(arglist__8981);
var y = cljs.core.first(arglist__8981);
var more = cljs.core.rest(arglist__8981);
return G__8979__delegate(x,y,more);
});
G__8979.cljs$core$IFn$_invoke$arity$variadic = G__8979__delegate;
return G__8979;
})()
;
bit_or = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return bit_or__2.call(this,x,y);
default:
var G__8982 = null;
if (arguments.length > 2) {
var G__8983__i = 0, G__8983__a = new Array(arguments.length -  2);
while (G__8983__i < G__8983__a.length) {G__8983__a[G__8983__i] = arguments[G__8983__i + 2]; ++G__8983__i;}
G__8982 = new cljs.core.IndexedSeq(G__8983__a,0);
}
return bit_or__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8982);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
bit_or.cljs$lang$maxFixedArity = 2;
bit_or.cljs$lang$applyTo = bit_or__3.cljs$lang$applyTo;
bit_or.cljs$core$IFn$_invoke$arity$2 = bit_or__2;
bit_or.cljs$core$IFn$_invoke$arity$variadic = bit_or__3.cljs$core$IFn$_invoke$arity$variadic;
return bit_or;
})()
;
/**
* Bitwise and
* @param {...*} var_args
*/
cljs.core.bit_and_not = (function() {
var bit_and_not = null;
var bit_and_not__2 = (function (x,y){
return (x & ~y);
});
var bit_and_not__3 = (function() { 
var G__8984__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(bit_and_not,(x & ~y),more);
};
var G__8984 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8985__i = 0, G__8985__a = new Array(arguments.length -  2);
while (G__8985__i < G__8985__a.length) {G__8985__a[G__8985__i] = arguments[G__8985__i + 2]; ++G__8985__i;}
  more = new cljs.core.IndexedSeq(G__8985__a,0);
} 
return G__8984__delegate.call(this,x,y,more);};
G__8984.cljs$lang$maxFixedArity = 2;
G__8984.cljs$lang$applyTo = (function (arglist__8986){
var x = cljs.core.first(arglist__8986);
arglist__8986 = cljs.core.next(arglist__8986);
var y = cljs.core.first(arglist__8986);
var more = cljs.core.rest(arglist__8986);
return G__8984__delegate(x,y,more);
});
G__8984.cljs$core$IFn$_invoke$arity$variadic = G__8984__delegate;
return G__8984;
})()
;
bit_and_not = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return bit_and_not__2.call(this,x,y);
default:
var G__8987 = null;
if (arguments.length > 2) {
var G__8988__i = 0, G__8988__a = new Array(arguments.length -  2);
while (G__8988__i < G__8988__a.length) {G__8988__a[G__8988__i] = arguments[G__8988__i + 2]; ++G__8988__i;}
G__8987 = new cljs.core.IndexedSeq(G__8988__a,0);
}
return bit_and_not__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8987);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
bit_and_not.cljs$lang$maxFixedArity = 2;
bit_and_not.cljs$lang$applyTo = bit_and_not__3.cljs$lang$applyTo;
bit_and_not.cljs$core$IFn$_invoke$arity$2 = bit_and_not__2;
bit_and_not.cljs$core$IFn$_invoke$arity$variadic = bit_and_not__3.cljs$core$IFn$_invoke$arity$variadic;
return bit_and_not;
})()
;
/**
* Clear bit at index n
*/
cljs.core.bit_clear = (function bit_clear(x,n){
return (x & ~(1 << n));
});
/**
* Flip bit at index n
*/
cljs.core.bit_flip = (function bit_flip(x,n){
return (x ^ (1 << n));
});
/**
* Bitwise complement
*/
cljs.core.bit_not = (function bit_not(x){
return (~ x);
});
/**
* Set bit at index n
*/
cljs.core.bit_set = (function bit_set(x,n){
return (x | (1 << n));
});
/**
* Test bit at index n
*/
cljs.core.bit_test = (function bit_test(x,n){
return ((x & (1 << n)) != 0);
});
/**
* Bitwise shift left
*/
cljs.core.bit_shift_left = (function bit_shift_left(x,n){
return (x << n);
});
/**
* Bitwise shift right
*/
cljs.core.bit_shift_right = (function bit_shift_right(x,n){
return (x >> n);
});
/**
* DEPRECATED: Bitwise shift right with zero fill
*/
cljs.core.bit_shift_right_zero_fill = (function bit_shift_right_zero_fill(x,n){
return (x >>> n);
});
/**
* Bitwise shift right with zero fill
*/
cljs.core.unsigned_bit_shift_right = (function unsigned_bit_shift_right(x,n){
return (x >>> n);
});
/**
* Counts the number of bits set in n
*/
cljs.core.bit_count = (function bit_count(v){
var v__$1 = (v - ((v >> (1)) & (1431655765)));
var v__$2 = ((v__$1 & (858993459)) + ((v__$1 >> (2)) & (858993459)));
return ((((v__$2 + (v__$2 >> (4))) & (252645135)) * (16843009)) >> (24));
});
/**
* Returns non-nil if nums all have the equivalent
* value, otherwise false. Behavior on non nums is
* undefined.
* @param {...*} var_args
*/
cljs.core._EQ__EQ_ = (function() {
var _EQ__EQ_ = null;
var _EQ__EQ___1 = (function (x){
return true;
});
var _EQ__EQ___2 = (function (x,y){
return cljs.core._equiv(x,y);
});
var _EQ__EQ___3 = (function() { 
var G__8993__delegate = function (x,y,more){
while(true){
if(_EQ__EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
if(cljs.core.next(more)){
var G__8994 = y;
var G__8995 = cljs.core.first(more);
var G__8996 = cljs.core.next(more);
x = G__8994;
y = G__8995;
more = G__8996;
continue;
} else {
return _EQ__EQ_.cljs$core$IFn$_invoke$arity$2(y,cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__8993 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8997__i = 0, G__8997__a = new Array(arguments.length -  2);
while (G__8997__i < G__8997__a.length) {G__8997__a[G__8997__i] = arguments[G__8997__i + 2]; ++G__8997__i;}
  more = new cljs.core.IndexedSeq(G__8997__a,0);
} 
return G__8993__delegate.call(this,x,y,more);};
G__8993.cljs$lang$maxFixedArity = 2;
G__8993.cljs$lang$applyTo = (function (arglist__8998){
var x = cljs.core.first(arglist__8998);
arglist__8998 = cljs.core.next(arglist__8998);
var y = cljs.core.first(arglist__8998);
var more = cljs.core.rest(arglist__8998);
return G__8993__delegate(x,y,more);
});
G__8993.cljs$core$IFn$_invoke$arity$variadic = G__8993__delegate;
return G__8993;
})()
;
_EQ__EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return _EQ__EQ___1.call(this,x);
case 2:
return _EQ__EQ___2.call(this,x,y);
default:
var G__8999 = null;
if (arguments.length > 2) {
var G__9000__i = 0, G__9000__a = new Array(arguments.length -  2);
while (G__9000__i < G__9000__a.length) {G__9000__a[G__9000__i] = arguments[G__9000__i + 2]; ++G__9000__i;}
G__8999 = new cljs.core.IndexedSeq(G__9000__a,0);
}
return _EQ__EQ___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8999);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_EQ__EQ_.cljs$lang$maxFixedArity = 2;
_EQ__EQ_.cljs$lang$applyTo = _EQ__EQ___3.cljs$lang$applyTo;
_EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = _EQ__EQ___1;
_EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = _EQ__EQ___2;
_EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = _EQ__EQ___3.cljs$core$IFn$_invoke$arity$variadic;
return _EQ__EQ_;
})()
;
/**
* Returns true if num is greater than zero, else false
*/
cljs.core.pos_QMARK_ = (function pos_QMARK_(n){
return (n > (0));
});
cljs.core.zero_QMARK_ = (function zero_QMARK_(n){
return (n === (0));
});
/**
* Returns true if num is less than zero, else false
*/
cljs.core.neg_QMARK_ = (function neg_QMARK_(x){
return (x < (0));
});
/**
* Returns the nth next of coll, (seq coll) when n is 0.
*/
cljs.core.nthnext = (function nthnext(coll,n){
var n__$1 = n;
var xs = cljs.core.seq(coll);
while(true){
if((xs) && ((n__$1 > (0)))){
var G__9001 = (n__$1 - (1));
var G__9002 = cljs.core.next(xs);
n__$1 = G__9001;
xs = G__9002;
continue;
} else {
return xs;
}
break;
}
});
/**
* With no args, returns the empty string. With one arg x, returns
* x.toString().  (str nil) returns the empty string. With more than
* one arg, returns the concatenation of the str values of the args.
* @param {...*} var_args
*/
cljs.core.str = (function() {
var str = null;
var str__0 = (function (){
return "";
});
var str__1 = (function (x){
if((x == null)){
return "";
} else {
var G__9006 = x;
return goog.string.buildString(G__9006);
}
});
var str__2 = (function() { 
var G__9007__delegate = function (x,ys){
var sb = (new goog.string.StringBuffer(str.cljs$core$IFn$_invoke$arity$1(x)));
var more = ys;
while(true){
if(cljs.core.truth_(more)){
var G__9008 = sb.append(str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(more)));
var G__9009 = cljs.core.next(more);
sb = G__9008;
more = G__9009;
continue;
} else {
return sb.toString();
}
break;
}
};
var G__9007 = function (x,var_args){
var ys = null;
if (arguments.length > 1) {
var G__9010__i = 0, G__9010__a = new Array(arguments.length -  1);
while (G__9010__i < G__9010__a.length) {G__9010__a[G__9010__i] = arguments[G__9010__i + 1]; ++G__9010__i;}
  ys = new cljs.core.IndexedSeq(G__9010__a,0);
} 
return G__9007__delegate.call(this,x,ys);};
G__9007.cljs$lang$maxFixedArity = 1;
G__9007.cljs$lang$applyTo = (function (arglist__9011){
var x = cljs.core.first(arglist__9011);
var ys = cljs.core.rest(arglist__9011);
return G__9007__delegate(x,ys);
});
G__9007.cljs$core$IFn$_invoke$arity$variadic = G__9007__delegate;
return G__9007;
})()
;
str = function(x,var_args){
var ys = var_args;
switch(arguments.length){
case 0:
return str__0.call(this);
case 1:
return str__1.call(this,x);
default:
var G__9012 = null;
if (arguments.length > 1) {
var G__9013__i = 0, G__9013__a = new Array(arguments.length -  1);
while (G__9013__i < G__9013__a.length) {G__9013__a[G__9013__i] = arguments[G__9013__i + 1]; ++G__9013__i;}
G__9012 = new cljs.core.IndexedSeq(G__9013__a,0);
}
return str__2.cljs$core$IFn$_invoke$arity$variadic(x, G__9012);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
str.cljs$lang$maxFixedArity = 1;
str.cljs$lang$applyTo = str__2.cljs$lang$applyTo;
str.cljs$core$IFn$_invoke$arity$0 = str__0;
str.cljs$core$IFn$_invoke$arity$1 = str__1;
str.cljs$core$IFn$_invoke$arity$variadic = str__2.cljs$core$IFn$_invoke$arity$variadic;
return str;
})()
;
/**
* Returns the substring of s beginning at start inclusive, and ending
* at end (defaults to length of string), exclusive.
*/
cljs.core.subs = (function() {
var subs = null;
var subs__2 = (function (s,start){
return s.substring(start);
});
var subs__3 = (function (s,start,end){
return s.substring(start,end);
});
subs = function(s,start,end){
switch(arguments.length){
case 2:
return subs__2.call(this,s,start);
case 3:
return subs__3.call(this,s,start,end);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
subs.cljs$core$IFn$_invoke$arity$2 = subs__2;
subs.cljs$core$IFn$_invoke$arity$3 = subs__3;
return subs;
})()
;

/**
* Assumes x is sequential. Returns true if x equals y, otherwise
* returns false.
*/
cljs.core.equiv_sequential = (function equiv_sequential(x,y){
return cljs.core.boolean$(((cljs.core.sequential_QMARK_(y))?(((cljs.core.counted_QMARK_(x)) && (cljs.core.counted_QMARK_(y)) && (!((cljs.core.count(x) === cljs.core.count(y)))))?false:(function (){var xs = cljs.core.seq(x);
var ys = cljs.core.seq(y);
while(true){
if((xs == null)){
return (ys == null);
} else {
if((ys == null)){
return false;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs),cljs.core.first(ys))){
var G__9014 = cljs.core.next(xs);
var G__9015 = cljs.core.next(ys);
xs = G__9014;
ys = G__9015;
continue;
} else {
return false;

}
}
}
break;
}
})()):null));
});
cljs.core.hash_coll = (function hash_coll(coll){
if(cljs.core.seq(coll)){
var res = cljs.core.hash(cljs.core.first(coll));
var s = cljs.core.next(coll);
while(true){
if((s == null)){
return res;
} else {
var G__9016 = cljs.core.hash_combine(res,cljs.core.hash(cljs.core.first(s)));
var G__9017 = cljs.core.next(s);
res = G__9016;
s = G__9017;
continue;
}
break;
}
} else {
return (0);
}
});

cljs.core.hash_imap = (function hash_imap(m){
var h = (0);
var s = cljs.core.seq(m);
while(true){
if(s){
var e = cljs.core.first(s);
var G__9022 = ((h + (cljs.core.hash((function (){var G__9020 = e;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__9020) : cljs.core.key.call(null,G__9020));
})()) ^ cljs.core.hash((function (){var G__9021 = e;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__9021) : cljs.core.val.call(null,G__9021));
})()))) % (4503599627370496));
var G__9023 = cljs.core.next(s);
h = G__9022;
s = G__9023;
continue;
} else {
return h;
}
break;
}
});
cljs.core.hash_iset = (function hash_iset(s){
var h = (0);
var s__$1 = cljs.core.seq(s);
while(true){
if(s__$1){
var e = cljs.core.first(s__$1);
var G__9024 = ((h + cljs.core.hash(e)) % (4503599627370496));
var G__9025 = cljs.core.next(s__$1);
h = G__9024;
s__$1 = G__9025;
continue;
} else {
return h;
}
break;
}
});


/**
* Takes a JavaScript object and a map of names to functions and
* attaches said functions as methods on the object.  Any references to
* JavaScript's implicit this (via the this-as macro) will resolve to the
* object that the function is attached.
*/
cljs.core.extend_object_BANG_ = (function extend_object_BANG_(obj,fn_map){
var seq__9036_9046 = cljs.core.seq(fn_map);
var chunk__9037_9047 = null;
var count__9038_9048 = (0);
var i__9039_9049 = (0);
while(true){
if((i__9039_9049 < count__9038_9048)){
var vec__9040_9050 = chunk__9037_9047.cljs$core$IIndexed$_nth$arity$2(null,i__9039_9049);
var key_name_9051 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9040_9050,(0),null);
var f_9052 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9040_9050,(1),null);
var str_name_9053 = (function (){var G__9041 = key_name_9051;
return (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__9041) : cljs.core.name.call(null,G__9041));
})();
(obj[str_name_9053] = f_9052);

var G__9054 = seq__9036_9046;
var G__9055 = chunk__9037_9047;
var G__9056 = count__9038_9048;
var G__9057 = (i__9039_9049 + (1));
seq__9036_9046 = G__9054;
chunk__9037_9047 = G__9055;
count__9038_9048 = G__9056;
i__9039_9049 = G__9057;
continue;
} else {
var temp__4126__auto___9058 = cljs.core.seq(seq__9036_9046);
if(temp__4126__auto___9058){
var seq__9036_9059__$1 = temp__4126__auto___9058;
if(cljs.core.chunked_seq_QMARK_(seq__9036_9059__$1)){
var c__4545__auto___9060 = (function (){var G__9042 = seq__9036_9059__$1;
return (cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1(G__9042) : cljs.core.chunk_first.call(null,G__9042));
})();
var G__9061 = (function (){var G__9043 = seq__9036_9059__$1;
return (cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1(G__9043) : cljs.core.chunk_rest.call(null,G__9043));
})();
var G__9062 = c__4545__auto___9060;
var G__9063 = cljs.core.count(c__4545__auto___9060);
var G__9064 = (0);
seq__9036_9046 = G__9061;
chunk__9037_9047 = G__9062;
count__9038_9048 = G__9063;
i__9039_9049 = G__9064;
continue;
} else {
var vec__9044_9065 = cljs.core.first(seq__9036_9059__$1);
var key_name_9066 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9044_9065,(0),null);
var f_9067 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9044_9065,(1),null);
var str_name_9068 = (function (){var G__9045 = key_name_9066;
return (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__9045) : cljs.core.name.call(null,G__9045));
})();
(obj[str_name_9068] = f_9067);

var G__9069 = cljs.core.next(seq__9036_9059__$1);
var G__9070 = null;
var G__9071 = (0);
var G__9072 = (0);
seq__9036_9046 = G__9069;
chunk__9037_9047 = G__9070;
count__9038_9048 = G__9071;
i__9039_9049 = G__9072;
continue;
}
} else {
}
}
break;
}

return obj;
});

/**
* @constructor
*/
cljs.core.List = (function (meta,first,rest,count,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.count = count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65937646;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.List.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.List.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.List(self__.meta,self__.first,self__.rest,self__.count,self__.__hash));
});

cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return null;
} else {
return self__.rest;
}
});

cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
});

cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._rest(coll__$1);
});

cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(meta__$1,self__.first,self__.rest,self__.count,self__.__hash));
});

cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,coll__$1,(self__.count + (1)),null));
});

cljs.core.List.cljs$lang$type = true;

cljs.core.List.cljs$lang$ctorStr = "cljs.core/List";

cljs.core.List.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/List");
});

cljs.core.__GT_List = (function __GT_List(meta,first,rest,count,__hash){
return (new cljs.core.List(meta,first,rest,count,__hash));
});

(cljs.core.List.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));

/**
* @constructor
*/
cljs.core.EmptyList = (function (meta){
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 65937614;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.EmptyList.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.EmptyList.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.EmptyList(self__.meta));
});

cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (0);
});

cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
throw (new Error("Can't pop empty list"));
});

cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.empty_ordered_hash;
});

cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.EmptyList(meta__$1));
});

cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,null,(1),null));
});

cljs.core.EmptyList.cljs$lang$type = true;

cljs.core.EmptyList.cljs$lang$ctorStr = "cljs.core/EmptyList";

cljs.core.EmptyList.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/EmptyList");
});

cljs.core.__GT_EmptyList = (function __GT_EmptyList(meta){
return (new cljs.core.EmptyList(meta));
});

cljs.core.List.EMPTY = (new cljs.core.EmptyList(null));
(cljs.core.EmptyList.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
cljs.core.reversible_QMARK_ = (function reversible_QMARK_(coll){
var G__9074 = coll;
if(G__9074){
var bit__4439__auto__ = (G__9074.cljs$lang$protocol_mask$partition0$ & (134217728));
if((bit__4439__auto__) || (G__9074.cljs$core$IReversible$)){
return true;
} else {
if((!G__9074.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,G__9074);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,G__9074);
}
});
cljs.core.rseq = (function rseq(coll){
return cljs.core._rseq(coll);
});
/**
* Returns a seq of the items in coll in reverse order. Not lazy.
*/
cljs.core.reverse = (function reverse(coll){
if(cljs.core.reversible_QMARK_(coll)){
return cljs.core.rseq(coll);
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,coll);
}
});
/**
* @param {...*} var_args
*/
cljs.core.list = (function() { 
var list__delegate = function (xs){
var arr = ((((xs instanceof cljs.core.IndexedSeq)) && ((xs.i === (0))))?xs.arr:(function (){var arr = [];
var xs__$1 = xs;
while(true){
if(!((xs__$1 == null))){
arr.push(xs__$1.cljs$core$ISeq$_first$arity$1(null));

var G__9075 = xs__$1.cljs$core$INext$_next$arity$1(null);
xs__$1 = G__9075;
continue;
} else {
return arr;
}
break;
}
})());
var i = arr.length;
var r = cljs.core.List.EMPTY;
while(true){
if((i > (0))){
var G__9076 = (i - (1));
var G__9077 = r.cljs$core$ICollection$_conj$arity$2(null,(arr[(i - (1))]));
i = G__9076;
r = G__9077;
continue;
} else {
return r;
}
break;
}
};
var list = function (var_args){
var xs = null;
if (arguments.length > 0) {
var G__9078__i = 0, G__9078__a = new Array(arguments.length -  0);
while (G__9078__i < G__9078__a.length) {G__9078__a[G__9078__i] = arguments[G__9078__i + 0]; ++G__9078__i;}
  xs = new cljs.core.IndexedSeq(G__9078__a,0);
} 
return list__delegate.call(this,xs);};
list.cljs$lang$maxFixedArity = 0;
list.cljs$lang$applyTo = (function (arglist__9079){
var xs = cljs.core.seq(arglist__9079);
return list__delegate(xs);
});
list.cljs$core$IFn$_invoke$arity$variadic = list__delegate;
return list;
})()
;

/**
* @constructor
*/
cljs.core.Cons = (function (meta,first,rest,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65929452;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Cons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Cons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Cons(self__.meta,self__.first,self__.rest,self__.__hash));
});

cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return null;
} else {
return cljs.core.seq(self__.rest);
}
});

cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(meta__$1,self__.first,self__.rest,self__.__hash));
});

cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(null,o,coll__$1,self__.__hash));
});

cljs.core.Cons.cljs$lang$type = true;

cljs.core.Cons.cljs$lang$ctorStr = "cljs.core/Cons";

cljs.core.Cons.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/Cons");
});

cljs.core.__GT_Cons = (function __GT_Cons(meta,first,rest,__hash){
return (new cljs.core.Cons(meta,first,rest,__hash));
});

(cljs.core.Cons.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
/**
* Returns a new seq where x is the first element and seq is the rest.
*/
cljs.core.cons = (function cons(x,coll){
if((function (){var or__3758__auto__ = (coll == null);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var G__9083 = coll;
if(G__9083){
var bit__4432__auto__ = (G__9083.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4432__auto__) || (G__9083.cljs$core$ISeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
return (new cljs.core.Cons(null,x,coll,null));
} else {
return (new cljs.core.Cons(null,x,cljs.core.seq(coll),null));
}
});
cljs.core.list_QMARK_ = (function list_QMARK_(x){
var G__9085 = x;
if(G__9085){
var bit__4439__auto__ = (G__9085.cljs$lang$protocol_mask$partition0$ & (33554432));
if((bit__4439__auto__) || (G__9085.cljs$core$IList$)){
return true;
} else {
if((!G__9085.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,G__9085);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,G__9085);
}
});
cljs.core.hash_keyword = (function hash_keyword(k){
return ((cljs.core.hash_symbol(k) + (2654435769)) | (0));
});
cljs.core.compare_keywords = (function compare_keywords(a,b){
if((a.fqn === b.fqn)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__3746__auto__ = cljs.core.not(a.ns);
if(and__3746__auto__){
return b.ns;
} else {
return and__3746__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__9092 = a.ns;
var G__9093 = b.ns;
return goog.array.defaultCompare(G__9092,G__9093);
})();
if(((0) === nsc)){
var G__9094 = a.name;
var G__9095 = b.name;
return goog.array.defaultCompare(G__9094,G__9095);
} else {
return nsc;
}
}
} else {
var G__9096 = a.name;
var G__9097 = b.name;
return goog.array.defaultCompare(G__9096,G__9097);

}
}
}
});

/**
* @constructor
*/
cljs.core.Keyword = (function (ns,name,fqn,_hash){
this.ns = ns;
this.name = name;
this.fqn = fqn;
this._hash = _hash;
this.cljs$lang$protocol_mask$partition0$ = 2153775105;
this.cljs$lang$protocol_mask$partition1$ = 4096;
})
cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,[cljs.core.str(":"),cljs.core.str(self__.fqn)].join(''));
});

cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
});

cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
});

cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4179__auto__ = self__._hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_keyword(this$__$1);
self__._hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.Keyword.prototype.call = (function() {
var G__9099 = null;
var G__9099__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});
var G__9099__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});
G__9099 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__9099__2.call(this,self__,coll);
case 3:
return G__9099__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9099.cljs$core$IFn$_invoke$arity$2 = G__9099__2;
G__9099.cljs$core$IFn$_invoke$arity$3 = G__9099__3;
return G__9099;
})()
;

cljs.core.Keyword.prototype.apply = (function (self__,args9098){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9098)));
});

cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});

cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});

cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Keyword)){
return (self__.fqn === other.fqn);
} else {
return false;
}
});

cljs.core.Keyword.prototype.toString = (function (){
var self__ = this;
var _ = this;
return [cljs.core.str(":"),cljs.core.str(self__.fqn)].join('');
});

cljs.core.Keyword.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Keyword.cljs$lang$type = true;

cljs.core.Keyword.cljs$lang$ctorStr = "cljs.core/Keyword";

cljs.core.Keyword.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/Keyword");
});

cljs.core.__GT_Keyword = (function __GT_Keyword(ns,name,fqn,_hash){
return (new cljs.core.Keyword(ns,name,fqn,_hash));
});

cljs.core.keyword_QMARK_ = (function keyword_QMARK_(x){
return (x instanceof cljs.core.Keyword);
});
cljs.core.keyword_identical_QMARK_ = (function keyword_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if(((x instanceof cljs.core.Keyword)) && ((y instanceof cljs.core.Keyword))){
return (x.fqn === y.fqn);
} else {
return false;
}
}
});
/**
* Returns the namespace String of a symbol or keyword, or nil if not present.
*/
cljs.core.namespace = (function namespace(x){
if((function (){var G__9101 = x;
if(G__9101){
var bit__4432__auto__ = (G__9101.cljs$lang$protocol_mask$partition1$ & (4096));
if((bit__4432__auto__) || (G__9101.cljs$core$INamed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return x.cljs$core$INamed$_namespace$arity$1(null);
} else {
throw (new Error([cljs.core.str("Doesn't support namespace: "),cljs.core.str(x)].join('')));
}
});
/**
* Returns a Keyword with the given namespace and name.  Do not use :
* in the keyword strings, it will be added automatically.
*/
cljs.core.keyword = (function() {
var keyword = null;
var keyword__1 = (function (name){
if((name instanceof cljs.core.Keyword)){
return name;
} else {
if((name instanceof cljs.core.Symbol)){
return (new cljs.core.Keyword(cljs.core.namespace(name),(function (){var G__9103 = name;
return (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__9103) : cljs.core.name.call(null,G__9103));
})(),name.str,null));
} else {
if(typeof name === 'string'){
var parts = name.split("/");
if((parts.length === (2))){
return (new cljs.core.Keyword((parts[(0)]),(parts[(1)]),name,null));
} else {
return (new cljs.core.Keyword(null,(parts[(0)]),name,null));
}
} else {
return null;
}
}
}
});
var keyword__2 = (function (ns,name){
return (new cljs.core.Keyword(ns,name,[cljs.core.str((cljs.core.truth_(ns)?[cljs.core.str(ns),cljs.core.str("/")].join(''):null)),cljs.core.str(name)].join(''),null));
});
keyword = function(ns,name){
switch(arguments.length){
case 1:
return keyword__1.call(this,ns);
case 2:
return keyword__2.call(this,ns,name);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
keyword.cljs$core$IFn$_invoke$arity$1 = keyword__1;
keyword.cljs$core$IFn$_invoke$arity$2 = keyword__2;
return keyword;
})()
;

/**
* @constructor
*/
cljs.core.LazySeq = (function (meta,fn,s,__hash){
this.meta = meta;
this.fn = fn;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
})
cljs.core.LazySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.LazySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.LazySeq.prototype.sval = (function (){
var self__ = this;
var coll = this;
if((self__.fn == null)){
return self__.s;
} else {
self__.s = (function (){return (self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null));
})();

self__.fn = null;

return self__.s;
}
});

cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if((self__.s == null)){
return null;
} else {
return cljs.core.next(self__.s);
}
});

cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if((self__.s == null)){
return null;
} else {
return cljs.core.first(self__.s);
}
});

cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if(!((self__.s == null))){
return cljs.core.rest(self__.s);
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.sval();

if((self__.s == null)){
return null;
} else {
var ls = self__.s;
while(true){
if((ls instanceof cljs.core.LazySeq)){
var G__9104 = ls.sval();
ls = G__9104;
continue;
} else {
self__.s = ls;

return cljs.core.seq(self__.s);
}
break;
}
}
});

cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.LazySeq(meta__$1,self__.fn,self__.s,self__.__hash));
});

cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.LazySeq.cljs$lang$type = true;

cljs.core.LazySeq.cljs$lang$ctorStr = "cljs.core/LazySeq";

cljs.core.LazySeq.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/LazySeq");
});

cljs.core.__GT_LazySeq = (function __GT_LazySeq(meta,fn,s,__hash){
return (new cljs.core.LazySeq(meta,fn,s,__hash));
});

(cljs.core.LazySeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));

/**
* @constructor
*/
cljs.core.ChunkBuffer = (function (buf,end){
this.buf = buf;
this.end = end;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 2;
})
cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.end;
});

cljs.core.ChunkBuffer.prototype.add = (function (o){
var self__ = this;
var _ = this;
(self__.buf[self__.end] = o);

return self__.end = (self__.end + (1));
});

cljs.core.ChunkBuffer.prototype.chunk = (function (o){
var self__ = this;
var _ = this;
var ret = (new cljs.core.ArrayChunk(self__.buf,(0),self__.end));
self__.buf = null;

return ret;
});

cljs.core.ChunkBuffer.cljs$lang$type = true;

cljs.core.ChunkBuffer.cljs$lang$ctorStr = "cljs.core/ChunkBuffer";

cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/ChunkBuffer");
});

cljs.core.__GT_ChunkBuffer = (function __GT_ChunkBuffer(buf,end){
return (new cljs.core.ChunkBuffer(buf,end));
});

cljs.core.chunk_buffer = (function chunk_buffer(capacity){
return (new cljs.core.ChunkBuffer((new Array(capacity)),(0)));
});

/**
* @constructor
*/
cljs.core.ArrayChunk = (function (arr,off,end){
this.arr = arr;
this.off = off;
this.end = end;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 524306;
})
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.off]),(self__.off + (1)));
});

cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.off);
});

cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = true;

cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.off === self__.end)){
throw (new Error("-drop-first of empty chunk"));
} else {
return (new cljs.core.ArrayChunk(self__.arr,(self__.off + (1)),self__.end));
}
});

cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,i){
var self__ = this;
var coll__$1 = this;
return (self__.arr[(self__.off + i)]);
});

cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,i,not_found){
var self__ = this;
var coll__$1 = this;
if(((i >= (0))) && ((i < (self__.end - self__.off)))){
return (self__.arr[(self__.off + i)]);
} else {
return not_found;
}
});

cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.end - self__.off);
});

cljs.core.ArrayChunk.cljs$lang$type = true;

cljs.core.ArrayChunk.cljs$lang$ctorStr = "cljs.core/ArrayChunk";

cljs.core.ArrayChunk.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/ArrayChunk");
});

cljs.core.__GT_ArrayChunk = (function __GT_ArrayChunk(arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});

cljs.core.array_chunk = (function() {
var array_chunk = null;
var array_chunk__1 = (function (arr){
return (new cljs.core.ArrayChunk(arr,(0),arr.length));
});
var array_chunk__2 = (function (arr,off){
return (new cljs.core.ArrayChunk(arr,off,arr.length));
});
var array_chunk__3 = (function (arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});
array_chunk = function(arr,off,end){
switch(arguments.length){
case 1:
return array_chunk__1.call(this,arr);
case 2:
return array_chunk__2.call(this,arr,off);
case 3:
return array_chunk__3.call(this,arr,off,end);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
array_chunk.cljs$core$IFn$_invoke$arity$1 = array_chunk__1;
array_chunk.cljs$core$IFn$_invoke$arity$2 = array_chunk__2;
array_chunk.cljs$core$IFn$_invoke$arity$3 = array_chunk__3;
return array_chunk;
})()
;

/**
* @constructor
*/
cljs.core.ChunkedCons = (function (chunk,more,meta,__hash){
this.chunk = chunk;
this.more = more;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850732;
this.cljs$lang$protocol_mask$partition1$ = 1536;
})
cljs.core.ChunkedCons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ChunkedCons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,self__.meta,null));
} else {
var more__$1 = cljs.core._seq(self__.more);
if((more__$1 == null)){
return null;
} else {
return more__$1;
}
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.chunk,(0));
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,self__.meta,null));
} else {
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
}
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.chunk;
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,m){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ChunkedCons(self__.chunk,self__.more,m,self__.__hash));
});

cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,this$__$1);
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return null;
} else {
return self__.more;
}
});

cljs.core.ChunkedCons.cljs$lang$type = true;

cljs.core.ChunkedCons.cljs$lang$ctorStr = "cljs.core/ChunkedCons";

cljs.core.ChunkedCons.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/ChunkedCons");
});

cljs.core.__GT_ChunkedCons = (function __GT_ChunkedCons(chunk,more,meta,__hash){
return (new cljs.core.ChunkedCons(chunk,more,meta,__hash));
});

(cljs.core.ChunkedCons.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
cljs.core.chunk_cons = (function chunk_cons(chunk,rest){
if((cljs.core._count(chunk) === (0))){
return rest;
} else {
return (new cljs.core.ChunkedCons(chunk,rest,null,null));
}
});
cljs.core.chunk_append = (function chunk_append(b,x){
return b.add(x);
});
cljs.core.chunk = (function chunk(b){
return b.chunk();
});
cljs.core.chunk_first = (function chunk_first(s){
return cljs.core._chunked_first(s);
});
cljs.core.chunk_rest = (function chunk_rest(s){
return cljs.core._chunked_rest(s);
});
cljs.core.chunk_next = (function chunk_next(s){
if((function (){var G__9106 = s;
if(G__9106){
var bit__4432__auto__ = (G__9106.cljs$lang$protocol_mask$partition1$ & (1024));
if((bit__4432__auto__) || (G__9106.cljs$core$IChunkedNext$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return cljs.core._chunked_next(s);
} else {
return cljs.core.seq(cljs.core._chunked_rest(s));
}
});
/**
* Naive impl of to-array as a start.
*/
cljs.core.to_array = (function to_array(s){
var ary = [];
var s__$1 = s;
while(true){
if(cljs.core.seq(s__$1)){
ary.push(cljs.core.first(s__$1));

var G__9107 = cljs.core.next(s__$1);
s__$1 = G__9107;
continue;
} else {
return ary;
}
break;
}
});
/**
* Returns a (potentially-ragged) 2-dimensional array
* containing the contents of coll.
*/
cljs.core.to_array_2d = (function to_array_2d(coll){
var ret = (new Array(cljs.core.count(coll)));
var i_9108 = (0);
var xs_9109 = cljs.core.seq(coll);
while(true){
if(xs_9109){
(ret[i_9108] = cljs.core.to_array(cljs.core.first(xs_9109)));

var G__9110 = (i_9108 + (1));
var G__9111 = cljs.core.next(xs_9109);
i_9108 = G__9110;
xs_9109 = G__9111;
continue;
} else {
}
break;
}

return ret;
});
cljs.core.int_array = (function() {
var int_array = null;
var int_array__1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});
var int_array__2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__9114 = (i + (1));
var G__9115 = cljs.core.next(s__$1);
i = G__9114;
s__$1 = G__9115;
continue;
} else {
return a;
}
break;
}
} else {
var n__4645__auto___9116 = size;
var i_9117 = (0);
while(true){
if((i_9117 < n__4645__auto___9116)){
(a[i_9117] = init_val_or_seq);

var G__9118 = (i_9117 + (1));
i_9117 = G__9118;
continue;
} else {
}
break;
}

return a;
}
});
int_array = function(size,init_val_or_seq){
switch(arguments.length){
case 1:
return int_array__1.call(this,size);
case 2:
return int_array__2.call(this,size,init_val_or_seq);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
int_array.cljs$core$IFn$_invoke$arity$1 = int_array__1;
int_array.cljs$core$IFn$_invoke$arity$2 = int_array__2;
return int_array;
})()
;
cljs.core.long_array = (function() {
var long_array = null;
var long_array__1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});
var long_array__2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__9121 = (i + (1));
var G__9122 = cljs.core.next(s__$1);
i = G__9121;
s__$1 = G__9122;
continue;
} else {
return a;
}
break;
}
} else {
var n__4645__auto___9123 = size;
var i_9124 = (0);
while(true){
if((i_9124 < n__4645__auto___9123)){
(a[i_9124] = init_val_or_seq);

var G__9125 = (i_9124 + (1));
i_9124 = G__9125;
continue;
} else {
}
break;
}

return a;
}
});
long_array = function(size,init_val_or_seq){
switch(arguments.length){
case 1:
return long_array__1.call(this,size);
case 2:
return long_array__2.call(this,size,init_val_or_seq);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
long_array.cljs$core$IFn$_invoke$arity$1 = long_array__1;
long_array.cljs$core$IFn$_invoke$arity$2 = long_array__2;
return long_array;
})()
;
cljs.core.double_array = (function() {
var double_array = null;
var double_array__1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});
var double_array__2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__9128 = (i + (1));
var G__9129 = cljs.core.next(s__$1);
i = G__9128;
s__$1 = G__9129;
continue;
} else {
return a;
}
break;
}
} else {
var n__4645__auto___9130 = size;
var i_9131 = (0);
while(true){
if((i_9131 < n__4645__auto___9130)){
(a[i_9131] = init_val_or_seq);

var G__9132 = (i_9131 + (1));
i_9131 = G__9132;
continue;
} else {
}
break;
}

return a;
}
});
double_array = function(size,init_val_or_seq){
switch(arguments.length){
case 1:
return double_array__1.call(this,size);
case 2:
return double_array__2.call(this,size,init_val_or_seq);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
double_array.cljs$core$IFn$_invoke$arity$1 = double_array__1;
double_array.cljs$core$IFn$_invoke$arity$2 = double_array__2;
return double_array;
})()
;
cljs.core.object_array = (function() {
var object_array = null;
var object_array__1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});
var object_array__2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__9135 = (i + (1));
var G__9136 = cljs.core.next(s__$1);
i = G__9135;
s__$1 = G__9136;
continue;
} else {
return a;
}
break;
}
} else {
var n__4645__auto___9137 = size;
var i_9138 = (0);
while(true){
if((i_9138 < n__4645__auto___9137)){
(a[i_9138] = init_val_or_seq);

var G__9139 = (i_9138 + (1));
i_9138 = G__9139;
continue;
} else {
}
break;
}

return a;
}
});
object_array = function(size,init_val_or_seq){
switch(arguments.length){
case 1:
return object_array__1.call(this,size);
case 2:
return object_array__2.call(this,size,init_val_or_seq);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
object_array.cljs$core$IFn$_invoke$arity$1 = object_array__1;
object_array.cljs$core$IFn$_invoke$arity$2 = object_array__2;
return object_array;
})()
;
cljs.core.bounded_count = (function bounded_count(s,n){
if(cljs.core.counted_QMARK_(s)){
return cljs.core.count(s);
} else {
var s__$1 = s;
var i = n;
var sum = (0);
while(true){
if(((i > (0))) && (cljs.core.seq(s__$1))){
var G__9140 = cljs.core.next(s__$1);
var G__9141 = (i - (1));
var G__9142 = (sum + (1));
s__$1 = G__9140;
i = G__9141;
sum = G__9142;
continue;
} else {
return sum;
}
break;
}
}
});
cljs.core.spread = (function spread(arglist){
if((arglist == null)){
return null;
} else {
if((cljs.core.next(arglist) == null)){
return cljs.core.seq(cljs.core.first(arglist));
} else {
return cljs.core.cons(cljs.core.first(arglist),spread(cljs.core.next(arglist)));

}
}
});
/**
* Returns a lazy seq representing the concatenation of the elements in the supplied colls.
* @param {...*} var_args
*/
cljs.core.concat = (function() {
var concat = null;
var concat__0 = (function (){
return (new cljs.core.LazySeq(null,(function (){
return null;
}),null,null));
});
var concat__1 = (function (x){
return (new cljs.core.LazySeq(null,(function (){
return x;
}),null,null));
});
var concat__2 = (function (x,y){
return (new cljs.core.LazySeq(null,(function (){
var s = cljs.core.seq(x);
if(s){
if(cljs.core.chunked_seq_QMARK_(s)){
return cljs.core.chunk_cons(cljs.core.chunk_first(s),concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s),y));
} else {
return cljs.core.cons(cljs.core.first(s),concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s),y));
}
} else {
return y;
}
}),null,null));
});
var concat__3 = (function() { 
var G__9162__delegate = function (x,y,zs){
var cat = (function cat(xys,zs__$1){
return (new cljs.core.LazySeq(null,(function (){
var xys__$1 = cljs.core.seq(xys);
if(xys__$1){
if(cljs.core.chunked_seq_QMARK_(xys__$1)){
return cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1),cat(cljs.core.chunk_rest(xys__$1),zs__$1));
} else {
return cljs.core.cons(cljs.core.first(xys__$1),cat(cljs.core.rest(xys__$1),zs__$1));
}
} else {
if(cljs.core.truth_(zs__$1)){
return cat(cljs.core.first(zs__$1),cljs.core.next(zs__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(concat.cljs$core$IFn$_invoke$arity$2(x,y),zs);
};
var G__9162 = function (x,y,var_args){
var zs = null;
if (arguments.length > 2) {
var G__9163__i = 0, G__9163__a = new Array(arguments.length -  2);
while (G__9163__i < G__9163__a.length) {G__9163__a[G__9163__i] = arguments[G__9163__i + 2]; ++G__9163__i;}
  zs = new cljs.core.IndexedSeq(G__9163__a,0);
} 
return G__9162__delegate.call(this,x,y,zs);};
G__9162.cljs$lang$maxFixedArity = 2;
G__9162.cljs$lang$applyTo = (function (arglist__9164){
var x = cljs.core.first(arglist__9164);
arglist__9164 = cljs.core.next(arglist__9164);
var y = cljs.core.first(arglist__9164);
var zs = cljs.core.rest(arglist__9164);
return G__9162__delegate(x,y,zs);
});
G__9162.cljs$core$IFn$_invoke$arity$variadic = G__9162__delegate;
return G__9162;
})()
;
concat = function(x,y,var_args){
var zs = var_args;
switch(arguments.length){
case 0:
return concat__0.call(this);
case 1:
return concat__1.call(this,x);
case 2:
return concat__2.call(this,x,y);
default:
var G__9165 = null;
if (arguments.length > 2) {
var G__9166__i = 0, G__9166__a = new Array(arguments.length -  2);
while (G__9166__i < G__9166__a.length) {G__9166__a[G__9166__i] = arguments[G__9166__i + 2]; ++G__9166__i;}
G__9165 = new cljs.core.IndexedSeq(G__9166__a,0);
}
return concat__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__9165);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
concat.cljs$lang$maxFixedArity = 2;
concat.cljs$lang$applyTo = concat__3.cljs$lang$applyTo;
concat.cljs$core$IFn$_invoke$arity$0 = concat__0;
concat.cljs$core$IFn$_invoke$arity$1 = concat__1;
concat.cljs$core$IFn$_invoke$arity$2 = concat__2;
concat.cljs$core$IFn$_invoke$arity$variadic = concat__3.cljs$core$IFn$_invoke$arity$variadic;
return concat;
})()
;
/**
* Creates a new list containing the items prepended to the rest, the
* last of which will be treated as a sequence.
* @param {...*} var_args
*/
cljs.core.list_STAR_ = (function() {
var list_STAR_ = null;
var list_STAR___1 = (function (args){
return cljs.core.seq(args);
});
var list_STAR___2 = (function (a,args){
return cljs.core.cons(a,args);
});
var list_STAR___3 = (function (a,b,args){
return cljs.core.cons(a,cljs.core.cons(b,args));
});
var list_STAR___4 = (function (a,b,c,args){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,args)));
});
var list_STAR___5 = (function() { 
var G__9167__delegate = function (a,b,c,d,more){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(more)))));
};
var G__9167 = function (a,b,c,d,var_args){
var more = null;
if (arguments.length > 4) {
var G__9168__i = 0, G__9168__a = new Array(arguments.length -  4);
while (G__9168__i < G__9168__a.length) {G__9168__a[G__9168__i] = arguments[G__9168__i + 4]; ++G__9168__i;}
  more = new cljs.core.IndexedSeq(G__9168__a,0);
} 
return G__9167__delegate.call(this,a,b,c,d,more);};
G__9167.cljs$lang$maxFixedArity = 4;
G__9167.cljs$lang$applyTo = (function (arglist__9169){
var a = cljs.core.first(arglist__9169);
arglist__9169 = cljs.core.next(arglist__9169);
var b = cljs.core.first(arglist__9169);
arglist__9169 = cljs.core.next(arglist__9169);
var c = cljs.core.first(arglist__9169);
arglist__9169 = cljs.core.next(arglist__9169);
var d = cljs.core.first(arglist__9169);
var more = cljs.core.rest(arglist__9169);
return G__9167__delegate(a,b,c,d,more);
});
G__9167.cljs$core$IFn$_invoke$arity$variadic = G__9167__delegate;
return G__9167;
})()
;
list_STAR_ = function(a,b,c,d,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return list_STAR___1.call(this,a);
case 2:
return list_STAR___2.call(this,a,b);
case 3:
return list_STAR___3.call(this,a,b,c);
case 4:
return list_STAR___4.call(this,a,b,c,d);
default:
var G__9170 = null;
if (arguments.length > 4) {
var G__9171__i = 0, G__9171__a = new Array(arguments.length -  4);
while (G__9171__i < G__9171__a.length) {G__9171__a[G__9171__i] = arguments[G__9171__i + 4]; ++G__9171__i;}
G__9170 = new cljs.core.IndexedSeq(G__9171__a,0);
}
return list_STAR___5.cljs$core$IFn$_invoke$arity$variadic(a,b,c,d, G__9170);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
list_STAR_.cljs$lang$maxFixedArity = 4;
list_STAR_.cljs$lang$applyTo = list_STAR___5.cljs$lang$applyTo;
list_STAR_.cljs$core$IFn$_invoke$arity$1 = list_STAR___1;
list_STAR_.cljs$core$IFn$_invoke$arity$2 = list_STAR___2;
list_STAR_.cljs$core$IFn$_invoke$arity$3 = list_STAR___3;
list_STAR_.cljs$core$IFn$_invoke$arity$4 = list_STAR___4;
list_STAR_.cljs$core$IFn$_invoke$arity$variadic = list_STAR___5.cljs$core$IFn$_invoke$arity$variadic;
return list_STAR_;
})()
;
/**
* Returns a new, transient version of the collection, in constant time.
*/
cljs.core.transient$ = (function transient$(coll){
return cljs.core._as_transient(coll);
});
/**
* Returns a new, persistent version of the transient collection, in
* constant time. The transient collection cannot be used after this
* call, any such use will throw an exception.
*/
cljs.core.persistent_BANG_ = (function persistent_BANG_(tcoll){
return cljs.core._persistent_BANG_(tcoll);
});
/**
* Adds x to the transient collection, and return coll. The 'addition'
* may happen at different 'places' depending on the concrete type.
* @param {...*} var_args
*/
cljs.core.conj_BANG_ = (function() {
var conj_BANG_ = null;
var conj_BANG___0 = (function (){
return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
});
var conj_BANG___1 = (function (coll){
return coll;
});
var conj_BANG___2 = (function (tcoll,val){
return cljs.core._conj_BANG_(tcoll,val);
});
var conj_BANG___3 = (function() { 
var G__9172__delegate = function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._conj_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__9173 = ntcoll;
var G__9174 = cljs.core.first(vals);
var G__9175 = cljs.core.next(vals);
tcoll = G__9173;
val = G__9174;
vals = G__9175;
continue;
} else {
return ntcoll;
}
break;
}
};
var G__9172 = function (tcoll,val,var_args){
var vals = null;
if (arguments.length > 2) {
var G__9176__i = 0, G__9176__a = new Array(arguments.length -  2);
while (G__9176__i < G__9176__a.length) {G__9176__a[G__9176__i] = arguments[G__9176__i + 2]; ++G__9176__i;}
  vals = new cljs.core.IndexedSeq(G__9176__a,0);
} 
return G__9172__delegate.call(this,tcoll,val,vals);};
G__9172.cljs$lang$maxFixedArity = 2;
G__9172.cljs$lang$applyTo = (function (arglist__9177){
var tcoll = cljs.core.first(arglist__9177);
arglist__9177 = cljs.core.next(arglist__9177);
var val = cljs.core.first(arglist__9177);
var vals = cljs.core.rest(arglist__9177);
return G__9172__delegate(tcoll,val,vals);
});
G__9172.cljs$core$IFn$_invoke$arity$variadic = G__9172__delegate;
return G__9172;
})()
;
conj_BANG_ = function(tcoll,val,var_args){
var vals = var_args;
switch(arguments.length){
case 0:
return conj_BANG___0.call(this);
case 1:
return conj_BANG___1.call(this,tcoll);
case 2:
return conj_BANG___2.call(this,tcoll,val);
default:
var G__9178 = null;
if (arguments.length > 2) {
var G__9179__i = 0, G__9179__a = new Array(arguments.length -  2);
while (G__9179__i < G__9179__a.length) {G__9179__a[G__9179__i] = arguments[G__9179__i + 2]; ++G__9179__i;}
G__9178 = new cljs.core.IndexedSeq(G__9179__a,0);
}
return conj_BANG___3.cljs$core$IFn$_invoke$arity$variadic(tcoll,val, G__9178);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
conj_BANG_.cljs$lang$maxFixedArity = 2;
conj_BANG_.cljs$lang$applyTo = conj_BANG___3.cljs$lang$applyTo;
conj_BANG_.cljs$core$IFn$_invoke$arity$0 = conj_BANG___0;
conj_BANG_.cljs$core$IFn$_invoke$arity$1 = conj_BANG___1;
conj_BANG_.cljs$core$IFn$_invoke$arity$2 = conj_BANG___2;
conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = conj_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return conj_BANG_;
})()
;
/**
* When applied to a transient map, adds mapping of key(s) to
* val(s). When applied to a transient vector, sets the val at index.
* Note - index must be <= (count vector). Returns coll.
* @param {...*} var_args
*/
cljs.core.assoc_BANG_ = (function() {
var assoc_BANG_ = null;
var assoc_BANG___3 = (function (tcoll,key,val){
return cljs.core._assoc_BANG_(tcoll,key,val);
});
var assoc_BANG___4 = (function() { 
var G__9180__delegate = function (tcoll,key,val,kvs){
while(true){
var ntcoll = cljs.core._assoc_BANG_(tcoll,key,val);
if(cljs.core.truth_(kvs)){
var G__9181 = ntcoll;
var G__9182 = cljs.core.first(kvs);
var G__9183 = cljs.core.second(kvs);
var G__9184 = cljs.core.nnext(kvs);
tcoll = G__9181;
key = G__9182;
val = G__9183;
kvs = G__9184;
continue;
} else {
return ntcoll;
}
break;
}
};
var G__9180 = function (tcoll,key,val,var_args){
var kvs = null;
if (arguments.length > 3) {
var G__9185__i = 0, G__9185__a = new Array(arguments.length -  3);
while (G__9185__i < G__9185__a.length) {G__9185__a[G__9185__i] = arguments[G__9185__i + 3]; ++G__9185__i;}
  kvs = new cljs.core.IndexedSeq(G__9185__a,0);
} 
return G__9180__delegate.call(this,tcoll,key,val,kvs);};
G__9180.cljs$lang$maxFixedArity = 3;
G__9180.cljs$lang$applyTo = (function (arglist__9186){
var tcoll = cljs.core.first(arglist__9186);
arglist__9186 = cljs.core.next(arglist__9186);
var key = cljs.core.first(arglist__9186);
arglist__9186 = cljs.core.next(arglist__9186);
var val = cljs.core.first(arglist__9186);
var kvs = cljs.core.rest(arglist__9186);
return G__9180__delegate(tcoll,key,val,kvs);
});
G__9180.cljs$core$IFn$_invoke$arity$variadic = G__9180__delegate;
return G__9180;
})()
;
assoc_BANG_ = function(tcoll,key,val,var_args){
var kvs = var_args;
switch(arguments.length){
case 3:
return assoc_BANG___3.call(this,tcoll,key,val);
default:
var G__9187 = null;
if (arguments.length > 3) {
var G__9188__i = 0, G__9188__a = new Array(arguments.length -  3);
while (G__9188__i < G__9188__a.length) {G__9188__a[G__9188__i] = arguments[G__9188__i + 3]; ++G__9188__i;}
G__9187 = new cljs.core.IndexedSeq(G__9188__a,0);
}
return assoc_BANG___4.cljs$core$IFn$_invoke$arity$variadic(tcoll,key,val, G__9187);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
assoc_BANG_.cljs$lang$maxFixedArity = 3;
assoc_BANG_.cljs$lang$applyTo = assoc_BANG___4.cljs$lang$applyTo;
assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = assoc_BANG___3;
assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = assoc_BANG___4.cljs$core$IFn$_invoke$arity$variadic;
return assoc_BANG_;
})()
;
/**
* Returns a transient map that doesn't contain a mapping for key(s).
* @param {...*} var_args
*/
cljs.core.dissoc_BANG_ = (function() {
var dissoc_BANG_ = null;
var dissoc_BANG___2 = (function (tcoll,key){
return cljs.core._dissoc_BANG_(tcoll,key);
});
var dissoc_BANG___3 = (function() { 
var G__9189__delegate = function (tcoll,key,ks){
while(true){
var ntcoll = cljs.core._dissoc_BANG_(tcoll,key);
if(cljs.core.truth_(ks)){
var G__9190 = ntcoll;
var G__9191 = cljs.core.first(ks);
var G__9192 = cljs.core.next(ks);
tcoll = G__9190;
key = G__9191;
ks = G__9192;
continue;
} else {
return ntcoll;
}
break;
}
};
var G__9189 = function (tcoll,key,var_args){
var ks = null;
if (arguments.length > 2) {
var G__9193__i = 0, G__9193__a = new Array(arguments.length -  2);
while (G__9193__i < G__9193__a.length) {G__9193__a[G__9193__i] = arguments[G__9193__i + 2]; ++G__9193__i;}
  ks = new cljs.core.IndexedSeq(G__9193__a,0);
} 
return G__9189__delegate.call(this,tcoll,key,ks);};
G__9189.cljs$lang$maxFixedArity = 2;
G__9189.cljs$lang$applyTo = (function (arglist__9194){
var tcoll = cljs.core.first(arglist__9194);
arglist__9194 = cljs.core.next(arglist__9194);
var key = cljs.core.first(arglist__9194);
var ks = cljs.core.rest(arglist__9194);
return G__9189__delegate(tcoll,key,ks);
});
G__9189.cljs$core$IFn$_invoke$arity$variadic = G__9189__delegate;
return G__9189;
})()
;
dissoc_BANG_ = function(tcoll,key,var_args){
var ks = var_args;
switch(arguments.length){
case 2:
return dissoc_BANG___2.call(this,tcoll,key);
default:
var G__9195 = null;
if (arguments.length > 2) {
var G__9196__i = 0, G__9196__a = new Array(arguments.length -  2);
while (G__9196__i < G__9196__a.length) {G__9196__a[G__9196__i] = arguments[G__9196__i + 2]; ++G__9196__i;}
G__9195 = new cljs.core.IndexedSeq(G__9196__a,0);
}
return dissoc_BANG___3.cljs$core$IFn$_invoke$arity$variadic(tcoll,key, G__9195);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
dissoc_BANG_.cljs$lang$maxFixedArity = 2;
dissoc_BANG_.cljs$lang$applyTo = dissoc_BANG___3.cljs$lang$applyTo;
dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = dissoc_BANG___2;
dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = dissoc_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return dissoc_BANG_;
})()
;
/**
* Removes the last item from a transient vector. If
* the collection is empty, throws an exception. Returns coll
*/
cljs.core.pop_BANG_ = (function pop_BANG_(tcoll){
return cljs.core._pop_BANG_(tcoll);
});
/**
* disj[oin]. Returns a transient set of the same (hashed/sorted) type, that
* does not contain key(s).
* @param {...*} var_args
*/
cljs.core.disj_BANG_ = (function() {
var disj_BANG_ = null;
var disj_BANG___2 = (function (tcoll,val){
return cljs.core._disjoin_BANG_(tcoll,val);
});
var disj_BANG___3 = (function() { 
var G__9197__delegate = function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._disjoin_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__9198 = ntcoll;
var G__9199 = cljs.core.first(vals);
var G__9200 = cljs.core.next(vals);
tcoll = G__9198;
val = G__9199;
vals = G__9200;
continue;
} else {
return ntcoll;
}
break;
}
};
var G__9197 = function (tcoll,val,var_args){
var vals = null;
if (arguments.length > 2) {
var G__9201__i = 0, G__9201__a = new Array(arguments.length -  2);
while (G__9201__i < G__9201__a.length) {G__9201__a[G__9201__i] = arguments[G__9201__i + 2]; ++G__9201__i;}
  vals = new cljs.core.IndexedSeq(G__9201__a,0);
} 
return G__9197__delegate.call(this,tcoll,val,vals);};
G__9197.cljs$lang$maxFixedArity = 2;
G__9197.cljs$lang$applyTo = (function (arglist__9202){
var tcoll = cljs.core.first(arglist__9202);
arglist__9202 = cljs.core.next(arglist__9202);
var val = cljs.core.first(arglist__9202);
var vals = cljs.core.rest(arglist__9202);
return G__9197__delegate(tcoll,val,vals);
});
G__9197.cljs$core$IFn$_invoke$arity$variadic = G__9197__delegate;
return G__9197;
})()
;
disj_BANG_ = function(tcoll,val,var_args){
var vals = var_args;
switch(arguments.length){
case 2:
return disj_BANG___2.call(this,tcoll,val);
default:
var G__9203 = null;
if (arguments.length > 2) {
var G__9204__i = 0, G__9204__a = new Array(arguments.length -  2);
while (G__9204__i < G__9204__a.length) {G__9204__a[G__9204__i] = arguments[G__9204__i + 2]; ++G__9204__i;}
G__9203 = new cljs.core.IndexedSeq(G__9204__a,0);
}
return disj_BANG___3.cljs$core$IFn$_invoke$arity$variadic(tcoll,val, G__9203);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
disj_BANG_.cljs$lang$maxFixedArity = 2;
disj_BANG_.cljs$lang$applyTo = disj_BANG___3.cljs$lang$applyTo;
disj_BANG_.cljs$core$IFn$_invoke$arity$2 = disj_BANG___2;
disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = disj_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return disj_BANG_;
})()
;

cljs.core.apply_to = (function apply_to(f,argc,args){
var args__$1 = cljs.core.seq(args);
if((argc === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var a4689 = cljs.core._first(args__$1);
var args__$2 = cljs.core._rest(args__$1);
if((argc === (1))){
if(f.cljs$core$IFn$_invoke$arity$1){
return f.cljs$core$IFn$_invoke$arity$1(a4689);
} else {
var G__9415 = a4689;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9415) : f.call(null,G__9415));
}
} else {
var b4690 = cljs.core._first(args__$2);
var args__$3 = cljs.core._rest(args__$2);
if((argc === (2))){
if(f.cljs$core$IFn$_invoke$arity$2){
return f.cljs$core$IFn$_invoke$arity$2(a4689,b4690);
} else {
var G__9416 = a4689;
var G__9417 = b4690;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9416,G__9417) : f.call(null,G__9416,G__9417));
}
} else {
var c4691 = cljs.core._first(args__$3);
var args__$4 = cljs.core._rest(args__$3);
if((argc === (3))){
if(f.cljs$core$IFn$_invoke$arity$3){
return f.cljs$core$IFn$_invoke$arity$3(a4689,b4690,c4691);
} else {
var G__9418 = a4689;
var G__9419 = b4690;
var G__9420 = c4691;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9418,G__9419,G__9420) : f.call(null,G__9418,G__9419,G__9420));
}
} else {
var d4692 = cljs.core._first(args__$4);
var args__$5 = cljs.core._rest(args__$4);
if((argc === (4))){
if(f.cljs$core$IFn$_invoke$arity$4){
return f.cljs$core$IFn$_invoke$arity$4(a4689,b4690,c4691,d4692);
} else {
var G__9421 = a4689;
var G__9422 = b4690;
var G__9423 = c4691;
var G__9424 = d4692;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__9421,G__9422,G__9423,G__9424) : f.call(null,G__9421,G__9422,G__9423,G__9424));
}
} else {
var e4693 = cljs.core._first(args__$5);
var args__$6 = cljs.core._rest(args__$5);
if((argc === (5))){
if(f.cljs$core$IFn$_invoke$arity$5){
return f.cljs$core$IFn$_invoke$arity$5(a4689,b4690,c4691,d4692,e4693);
} else {
var G__9425 = a4689;
var G__9426 = b4690;
var G__9427 = c4691;
var G__9428 = d4692;
var G__9429 = e4693;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__9425,G__9426,G__9427,G__9428,G__9429) : f.call(null,G__9425,G__9426,G__9427,G__9428,G__9429));
}
} else {
var f4694 = cljs.core._first(args__$6);
var args__$7 = cljs.core._rest(args__$6);
if((argc === (6))){
if(f.cljs$core$IFn$_invoke$arity$6){
return f.cljs$core$IFn$_invoke$arity$6(a4689,b4690,c4691,d4692,e4693,f4694);
} else {
var G__9430 = a4689;
var G__9431 = b4690;
var G__9432 = c4691;
var G__9433 = d4692;
var G__9434 = e4693;
var G__9435 = f4694;
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(G__9430,G__9431,G__9432,G__9433,G__9434,G__9435) : f.call(null,G__9430,G__9431,G__9432,G__9433,G__9434,G__9435));
}
} else {
var g4695 = cljs.core._first(args__$7);
var args__$8 = cljs.core._rest(args__$7);
if((argc === (7))){
if(f.cljs$core$IFn$_invoke$arity$7){
return f.cljs$core$IFn$_invoke$arity$7(a4689,b4690,c4691,d4692,e4693,f4694,g4695);
} else {
var G__9436 = a4689;
var G__9437 = b4690;
var G__9438 = c4691;
var G__9439 = d4692;
var G__9440 = e4693;
var G__9441 = f4694;
var G__9442 = g4695;
return (f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(G__9436,G__9437,G__9438,G__9439,G__9440,G__9441,G__9442) : f.call(null,G__9436,G__9437,G__9438,G__9439,G__9440,G__9441,G__9442));
}
} else {
var h4696 = cljs.core._first(args__$8);
var args__$9 = cljs.core._rest(args__$8);
if((argc === (8))){
if(f.cljs$core$IFn$_invoke$arity$8){
return f.cljs$core$IFn$_invoke$arity$8(a4689,b4690,c4691,d4692,e4693,f4694,g4695,h4696);
} else {
var G__9443 = a4689;
var G__9444 = b4690;
var G__9445 = c4691;
var G__9446 = d4692;
var G__9447 = e4693;
var G__9448 = f4694;
var G__9449 = g4695;
var G__9450 = h4696;
return (f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(G__9443,G__9444,G__9445,G__9446,G__9447,G__9448,G__9449,G__9450) : f.call(null,G__9443,G__9444,G__9445,G__9446,G__9447,G__9448,G__9449,G__9450));
}
} else {
var i4697 = cljs.core._first(args__$9);
var args__$10 = cljs.core._rest(args__$9);
if((argc === (9))){
if(f.cljs$core$IFn$_invoke$arity$9){
return f.cljs$core$IFn$_invoke$arity$9(a4689,b4690,c4691,d4692,e4693,f4694,g4695,h4696,i4697);
} else {
var G__9451 = a4689;
var G__9452 = b4690;
var G__9453 = c4691;
var G__9454 = d4692;
var G__9455 = e4693;
var G__9456 = f4694;
var G__9457 = g4695;
var G__9458 = h4696;
var G__9459 = i4697;
return (f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(G__9451,G__9452,G__9453,G__9454,G__9455,G__9456,G__9457,G__9458,G__9459) : f.call(null,G__9451,G__9452,G__9453,G__9454,G__9455,G__9456,G__9457,G__9458,G__9459));
}
} else {
var j4698 = cljs.core._first(args__$10);
var args__$11 = cljs.core._rest(args__$10);
if((argc === (10))){
if(f.cljs$core$IFn$_invoke$arity$10){
return f.cljs$core$IFn$_invoke$arity$10(a4689,b4690,c4691,d4692,e4693,f4694,g4695,h4696,i4697,j4698);
} else {
var G__9460 = a4689;
var G__9461 = b4690;
var G__9462 = c4691;
var G__9463 = d4692;
var G__9464 = e4693;
var G__9465 = f4694;
var G__9466 = g4695;
var G__9467 = h4696;
var G__9468 = i4697;
var G__9469 = j4698;
return (f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(G__9460,G__9461,G__9462,G__9463,G__9464,G__9465,G__9466,G__9467,G__9468,G__9469) : f.call(null,G__9460,G__9461,G__9462,G__9463,G__9464,G__9465,G__9466,G__9467,G__9468,G__9469));
}
} else {
var k4699 = cljs.core._first(args__$11);
var args__$12 = cljs.core._rest(args__$11);
if((argc === (11))){
if(f.cljs$core$IFn$_invoke$arity$11){
return f.cljs$core$IFn$_invoke$arity$11(a4689,b4690,c4691,d4692,e4693,f4694,g4695,h4696,i4697,j4698,k4699);
} else {
var G__9470 = a4689;
var G__9471 = b4690;
var G__9472 = c4691;
var G__9473 = d4692;
var G__9474 = e4693;
var G__9475 = f4694;
var G__9476 = g4695;
var G__9477 = h4696;
var G__9478 = i4697;
var G__9479 = j4698;
var G__9480 = k4699;
return (f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(G__9470,G__9471,G__9472,G__9473,G__9474,G__9475,G__9476,G__9477,G__9478,G__9479,G__9480) : f.call(null,G__9470,G__9471,G__9472,G__9473,G__9474,G__9475,G__9476,G__9477,G__9478,G__9479,G__9480));
}
} else {
var l4700 = cljs.core._first(args__$12);
var args__$13 = cljs.core._rest(args__$12);
if((argc === (12))){
if(f.cljs$core$IFn$_invoke$arity$12){
return f.cljs$core$IFn$_invoke$arity$12(a4689,b4690,c4691,d4692,e4693,f4694,g4695,h4696,i4697,j4698,k4699,l4700);
} else {
var G__9481 = a4689;
var G__9482 = b4690;
var G__9483 = c4691;
var G__9484 = d4692;
var G__9485 = e4693;
var G__9486 = f4694;
var G__9487 = g4695;
var G__9488 = h4696;
var G__9489 = i4697;
var G__9490 = j4698;
var G__9491 = k4699;
var G__9492 = l4700;
return (f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(G__9481,G__9482,G__9483,G__9484,G__9485,G__9486,G__9487,G__9488,G__9489,G__9490,G__9491,G__9492) : f.call(null,G__9481,G__9482,G__9483,G__9484,G__9485,G__9486,G__9487,G__9488,G__9489,G__9490,G__9491,G__9492));
}
} else {
var m4701 = cljs.core._first(args__$13);
var args__$14 = cljs.core._rest(args__$13);
if((argc === (13))){
if(f.cljs$core$IFn$_invoke$arity$13){
return f.cljs$core$IFn$_invoke$arity$13(a4689,b4690,c4691,d4692,e4693,f4694,g4695,h4696,i4697,j4698,k4699,l4700,m4701);
} else {
var G__9493 = a4689;
var G__9494 = b4690;
var G__9495 = c4691;
var G__9496 = d4692;
var G__9497 = e4693;
var G__9498 = f4694;
var G__9499 = g4695;
var G__9500 = h4696;
var G__9501 = i4697;
var G__9502 = j4698;
var G__9503 = k4699;
var G__9504 = l4700;
var G__9505 = m4701;
return (f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(G__9493,G__9494,G__9495,G__9496,G__9497,G__9498,G__9499,G__9500,G__9501,G__9502,G__9503,G__9504,G__9505) : f.call(null,G__9493,G__9494,G__9495,G__9496,G__9497,G__9498,G__9499,G__9500,G__9501,G__9502,G__9503,G__9504,G__9505));
}
} else {
var n4702 = cljs.core._first(args__$14);
var args__$15 = cljs.core._rest(args__$14);
if((argc === (14))){
if(f.cljs$core$IFn$_invoke$arity$14){
return f.cljs$core$IFn$_invoke$arity$14(a4689,b4690,c4691,d4692,e4693,f4694,g4695,h4696,i4697,j4698,k4699,l4700,m4701,n4702);
} else {
var G__9506 = a4689;
var G__9507 = b4690;
var G__9508 = c4691;
var G__9509 = d4692;
var G__9510 = e4693;
var G__9511 = f4694;
var G__9512 = g4695;
var G__9513 = h4696;
var G__9514 = i4697;
var G__9515 = j4698;
var G__9516 = k4699;
var G__9517 = l4700;
var G__9518 = m4701;
var G__9519 = n4702;
return (f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(G__9506,G__9507,G__9508,G__9509,G__9510,G__9511,G__9512,G__9513,G__9514,G__9515,G__9516,G__9517,G__9518,G__9519) : f.call(null,G__9506,G__9507,G__9508,G__9509,G__9510,G__9511,G__9512,G__9513,G__9514,G__9515,G__9516,G__9517,G__9518,G__9519));
}
} else {
var o4703 = cljs.core._first(args__$15);
var args__$16 = cljs.core._rest(args__$15);
if((argc === (15))){
if(f.cljs$core$IFn$_invoke$arity$15){
return f.cljs$core$IFn$_invoke$arity$15(a4689,b4690,c4691,d4692,e4693,f4694,g4695,h4696,i4697,j4698,k4699,l4700,m4701,n4702,o4703);
} else {
var G__9520 = a4689;
var G__9521 = b4690;
var G__9522 = c4691;
var G__9523 = d4692;
var G__9524 = e4693;
var G__9525 = f4694;
var G__9526 = g4695;
var G__9527 = h4696;
var G__9528 = i4697;
var G__9529 = j4698;
var G__9530 = k4699;
var G__9531 = l4700;
var G__9532 = m4701;
var G__9533 = n4702;
var G__9534 = o4703;
return (f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(G__9520,G__9521,G__9522,G__9523,G__9524,G__9525,G__9526,G__9527,G__9528,G__9529,G__9530,G__9531,G__9532,G__9533,G__9534) : f.call(null,G__9520,G__9521,G__9522,G__9523,G__9524,G__9525,G__9526,G__9527,G__9528,G__9529,G__9530,G__9531,G__9532,G__9533,G__9534));
}
} else {
var p4704 = cljs.core._first(args__$16);
var args__$17 = cljs.core._rest(args__$16);
if((argc === (16))){
if(f.cljs$core$IFn$_invoke$arity$16){
return f.cljs$core$IFn$_invoke$arity$16(a4689,b4690,c4691,d4692,e4693,f4694,g4695,h4696,i4697,j4698,k4699,l4700,m4701,n4702,o4703,p4704);
} else {
var G__9535 = a4689;
var G__9536 = b4690;
var G__9537 = c4691;
var G__9538 = d4692;
var G__9539 = e4693;
var G__9540 = f4694;
var G__9541 = g4695;
var G__9542 = h4696;
var G__9543 = i4697;
var G__9544 = j4698;
var G__9545 = k4699;
var G__9546 = l4700;
var G__9547 = m4701;
var G__9548 = n4702;
var G__9549 = o4703;
var G__9550 = p4704;
return (f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(G__9535,G__9536,G__9537,G__9538,G__9539,G__9540,G__9541,G__9542,G__9543,G__9544,G__9545,G__9546,G__9547,G__9548,G__9549,G__9550) : f.call(null,G__9535,G__9536,G__9537,G__9538,G__9539,G__9540,G__9541,G__9542,G__9543,G__9544,G__9545,G__9546,G__9547,G__9548,G__9549,G__9550));
}
} else {
var q4705 = cljs.core._first(args__$17);
var args__$18 = cljs.core._rest(args__$17);
if((argc === (17))){
if(f.cljs$core$IFn$_invoke$arity$17){
return f.cljs$core$IFn$_invoke$arity$17(a4689,b4690,c4691,d4692,e4693,f4694,g4695,h4696,i4697,j4698,k4699,l4700,m4701,n4702,o4703,p4704,q4705);
} else {
var G__9551 = a4689;
var G__9552 = b4690;
var G__9553 = c4691;
var G__9554 = d4692;
var G__9555 = e4693;
var G__9556 = f4694;
var G__9557 = g4695;
var G__9558 = h4696;
var G__9559 = i4697;
var G__9560 = j4698;
var G__9561 = k4699;
var G__9562 = l4700;
var G__9563 = m4701;
var G__9564 = n4702;
var G__9565 = o4703;
var G__9566 = p4704;
var G__9567 = q4705;
return (f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(G__9551,G__9552,G__9553,G__9554,G__9555,G__9556,G__9557,G__9558,G__9559,G__9560,G__9561,G__9562,G__9563,G__9564,G__9565,G__9566,G__9567) : f.call(null,G__9551,G__9552,G__9553,G__9554,G__9555,G__9556,G__9557,G__9558,G__9559,G__9560,G__9561,G__9562,G__9563,G__9564,G__9565,G__9566,G__9567));
}
} else {
var r4706 = cljs.core._first(args__$18);
var args__$19 = cljs.core._rest(args__$18);
if((argc === (18))){
if(f.cljs$core$IFn$_invoke$arity$18){
return f.cljs$core$IFn$_invoke$arity$18(a4689,b4690,c4691,d4692,e4693,f4694,g4695,h4696,i4697,j4698,k4699,l4700,m4701,n4702,o4703,p4704,q4705,r4706);
} else {
var G__9568 = a4689;
var G__9569 = b4690;
var G__9570 = c4691;
var G__9571 = d4692;
var G__9572 = e4693;
var G__9573 = f4694;
var G__9574 = g4695;
var G__9575 = h4696;
var G__9576 = i4697;
var G__9577 = j4698;
var G__9578 = k4699;
var G__9579 = l4700;
var G__9580 = m4701;
var G__9581 = n4702;
var G__9582 = o4703;
var G__9583 = p4704;
var G__9584 = q4705;
var G__9585 = r4706;
return (f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(G__9568,G__9569,G__9570,G__9571,G__9572,G__9573,G__9574,G__9575,G__9576,G__9577,G__9578,G__9579,G__9580,G__9581,G__9582,G__9583,G__9584,G__9585) : f.call(null,G__9568,G__9569,G__9570,G__9571,G__9572,G__9573,G__9574,G__9575,G__9576,G__9577,G__9578,G__9579,G__9580,G__9581,G__9582,G__9583,G__9584,G__9585));
}
} else {
var s4707 = cljs.core._first(args__$19);
var args__$20 = cljs.core._rest(args__$19);
if((argc === (19))){
if(f.cljs$core$IFn$_invoke$arity$19){
return f.cljs$core$IFn$_invoke$arity$19(a4689,b4690,c4691,d4692,e4693,f4694,g4695,h4696,i4697,j4698,k4699,l4700,m4701,n4702,o4703,p4704,q4705,r4706,s4707);
} else {
var G__9586 = a4689;
var G__9587 = b4690;
var G__9588 = c4691;
var G__9589 = d4692;
var G__9590 = e4693;
var G__9591 = f4694;
var G__9592 = g4695;
var G__9593 = h4696;
var G__9594 = i4697;
var G__9595 = j4698;
var G__9596 = k4699;
var G__9597 = l4700;
var G__9598 = m4701;
var G__9599 = n4702;
var G__9600 = o4703;
var G__9601 = p4704;
var G__9602 = q4705;
var G__9603 = r4706;
var G__9604 = s4707;
return (f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(G__9586,G__9587,G__9588,G__9589,G__9590,G__9591,G__9592,G__9593,G__9594,G__9595,G__9596,G__9597,G__9598,G__9599,G__9600,G__9601,G__9602,G__9603,G__9604) : f.call(null,G__9586,G__9587,G__9588,G__9589,G__9590,G__9591,G__9592,G__9593,G__9594,G__9595,G__9596,G__9597,G__9598,G__9599,G__9600,G__9601,G__9602,G__9603,G__9604));
}
} else {
var t4708 = cljs.core._first(args__$20);
var args__$21 = cljs.core._rest(args__$20);
if((argc === (20))){
if(f.cljs$core$IFn$_invoke$arity$20){
return f.cljs$core$IFn$_invoke$arity$20(a4689,b4690,c4691,d4692,e4693,f4694,g4695,h4696,i4697,j4698,k4699,l4700,m4701,n4702,o4703,p4704,q4705,r4706,s4707,t4708);
} else {
var G__9605 = a4689;
var G__9606 = b4690;
var G__9607 = c4691;
var G__9608 = d4692;
var G__9609 = e4693;
var G__9610 = f4694;
var G__9611 = g4695;
var G__9612 = h4696;
var G__9613 = i4697;
var G__9614 = j4698;
var G__9615 = k4699;
var G__9616 = l4700;
var G__9617 = m4701;
var G__9618 = n4702;
var G__9619 = o4703;
var G__9620 = p4704;
var G__9621 = q4705;
var G__9622 = r4706;
var G__9623 = s4707;
var G__9624 = t4708;
return (f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(G__9605,G__9606,G__9607,G__9608,G__9609,G__9610,G__9611,G__9612,G__9613,G__9614,G__9615,G__9616,G__9617,G__9618,G__9619,G__9620,G__9621,G__9622,G__9623,G__9624) : f.call(null,G__9605,G__9606,G__9607,G__9608,G__9609,G__9610,G__9611,G__9612,G__9613,G__9614,G__9615,G__9616,G__9617,G__9618,G__9619,G__9620,G__9621,G__9622,G__9623,G__9624));
}
} else {
throw (new Error("Only up to 20 arguments supported on functions"));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

/**
* Applies fn f to the argument list formed by prepending intervening arguments to args.
* First cut.  Not lazy.  Needs to use emitted toApply.
* @param {...*} var_args
*/
cljs.core.apply = (function() {
var apply = null;
var apply__2 = (function (f,args){
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(args,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,args);
} else {
return f.cljs$lang$applyTo(args);
}
} else {
return f.apply(f,cljs.core.to_array(args));
}
});
var apply__3 = (function (f,x,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});
var apply__4 = (function (f,x,y,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x,y,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});
var apply__5 = (function (f,x,y,z,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x,y,z,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});
var apply__6 = (function() { 
var G__9625__delegate = function (f,a,b,c,d,args){
var arglist = cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(args)))));
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
};
var G__9625 = function (f,a,b,c,d,var_args){
var args = null;
if (arguments.length > 5) {
var G__9626__i = 0, G__9626__a = new Array(arguments.length -  5);
while (G__9626__i < G__9626__a.length) {G__9626__a[G__9626__i] = arguments[G__9626__i + 5]; ++G__9626__i;}
  args = new cljs.core.IndexedSeq(G__9626__a,0);
} 
return G__9625__delegate.call(this,f,a,b,c,d,args);};
G__9625.cljs$lang$maxFixedArity = 5;
G__9625.cljs$lang$applyTo = (function (arglist__9627){
var f = cljs.core.first(arglist__9627);
arglist__9627 = cljs.core.next(arglist__9627);
var a = cljs.core.first(arglist__9627);
arglist__9627 = cljs.core.next(arglist__9627);
var b = cljs.core.first(arglist__9627);
arglist__9627 = cljs.core.next(arglist__9627);
var c = cljs.core.first(arglist__9627);
arglist__9627 = cljs.core.next(arglist__9627);
var d = cljs.core.first(arglist__9627);
var args = cljs.core.rest(arglist__9627);
return G__9625__delegate(f,a,b,c,d,args);
});
G__9625.cljs$core$IFn$_invoke$arity$variadic = G__9625__delegate;
return G__9625;
})()
;
apply = function(f,a,b,c,d,var_args){
var args = var_args;
switch(arguments.length){
case 2:
return apply__2.call(this,f,a);
case 3:
return apply__3.call(this,f,a,b);
case 4:
return apply__4.call(this,f,a,b,c);
case 5:
return apply__5.call(this,f,a,b,c,d);
default:
var G__9628 = null;
if (arguments.length > 5) {
var G__9629__i = 0, G__9629__a = new Array(arguments.length -  5);
while (G__9629__i < G__9629__a.length) {G__9629__a[G__9629__i] = arguments[G__9629__i + 5]; ++G__9629__i;}
G__9628 = new cljs.core.IndexedSeq(G__9629__a,0);
}
return apply__6.cljs$core$IFn$_invoke$arity$variadic(f,a,b,c,d, G__9628);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
apply.cljs$lang$maxFixedArity = 5;
apply.cljs$lang$applyTo = apply__6.cljs$lang$applyTo;
apply.cljs$core$IFn$_invoke$arity$2 = apply__2;
apply.cljs$core$IFn$_invoke$arity$3 = apply__3;
apply.cljs$core$IFn$_invoke$arity$4 = apply__4;
apply.cljs$core$IFn$_invoke$arity$5 = apply__5;
apply.cljs$core$IFn$_invoke$arity$variadic = apply__6.cljs$core$IFn$_invoke$arity$variadic;
return apply;
})()
;
/**
* Returns an object of the same type and value as obj, with
* (apply f (meta obj) args) as its metadata.
* @param {...*} var_args
*/
cljs.core.vary_meta = (function() {
var vary_meta = null;
var vary_meta__2 = (function (obj,f){
return cljs.core.with_meta(obj,(function (){var G__9645 = cljs.core.meta(obj);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9645) : f.call(null,G__9645));
})());
});
var vary_meta__3 = (function (obj,f,a){
return cljs.core.with_meta(obj,(function (){var G__9646 = cljs.core.meta(obj);
var G__9647 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9646,G__9647) : f.call(null,G__9646,G__9647));
})());
});
var vary_meta__4 = (function (obj,f,a,b){
return cljs.core.with_meta(obj,(function (){var G__9648 = cljs.core.meta(obj);
var G__9649 = a;
var G__9650 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9648,G__9649,G__9650) : f.call(null,G__9648,G__9649,G__9650));
})());
});
var vary_meta__5 = (function (obj,f,a,b,c){
return cljs.core.with_meta(obj,(function (){var G__9651 = cljs.core.meta(obj);
var G__9652 = a;
var G__9653 = b;
var G__9654 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__9651,G__9652,G__9653,G__9654) : f.call(null,G__9651,G__9652,G__9653,G__9654));
})());
});
var vary_meta__6 = (function (obj,f,a,b,c,d){
return cljs.core.with_meta(obj,(function (){var G__9655 = cljs.core.meta(obj);
var G__9656 = a;
var G__9657 = b;
var G__9658 = c;
var G__9659 = d;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__9655,G__9656,G__9657,G__9658,G__9659) : f.call(null,G__9655,G__9656,G__9657,G__9658,G__9659));
})());
});
var vary_meta__7 = (function() { 
var G__9660__delegate = function (obj,f,a,b,c,d,args){
return cljs.core.with_meta(obj,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.meta(obj),a,b,c,cljs.core.array_seq([d,args], 0)));
};
var G__9660 = function (obj,f,a,b,c,d,var_args){
var args = null;
if (arguments.length > 6) {
var G__9661__i = 0, G__9661__a = new Array(arguments.length -  6);
while (G__9661__i < G__9661__a.length) {G__9661__a[G__9661__i] = arguments[G__9661__i + 6]; ++G__9661__i;}
  args = new cljs.core.IndexedSeq(G__9661__a,0);
} 
return G__9660__delegate.call(this,obj,f,a,b,c,d,args);};
G__9660.cljs$lang$maxFixedArity = 6;
G__9660.cljs$lang$applyTo = (function (arglist__9662){
var obj = cljs.core.first(arglist__9662);
arglist__9662 = cljs.core.next(arglist__9662);
var f = cljs.core.first(arglist__9662);
arglist__9662 = cljs.core.next(arglist__9662);
var a = cljs.core.first(arglist__9662);
arglist__9662 = cljs.core.next(arglist__9662);
var b = cljs.core.first(arglist__9662);
arglist__9662 = cljs.core.next(arglist__9662);
var c = cljs.core.first(arglist__9662);
arglist__9662 = cljs.core.next(arglist__9662);
var d = cljs.core.first(arglist__9662);
var args = cljs.core.rest(arglist__9662);
return G__9660__delegate(obj,f,a,b,c,d,args);
});
G__9660.cljs$core$IFn$_invoke$arity$variadic = G__9660__delegate;
return G__9660;
})()
;
vary_meta = function(obj,f,a,b,c,d,var_args){
var args = var_args;
switch(arguments.length){
case 2:
return vary_meta__2.call(this,obj,f);
case 3:
return vary_meta__3.call(this,obj,f,a);
case 4:
return vary_meta__4.call(this,obj,f,a,b);
case 5:
return vary_meta__5.call(this,obj,f,a,b,c);
case 6:
return vary_meta__6.call(this,obj,f,a,b,c,d);
default:
var G__9663 = null;
if (arguments.length > 6) {
var G__9664__i = 0, G__9664__a = new Array(arguments.length -  6);
while (G__9664__i < G__9664__a.length) {G__9664__a[G__9664__i] = arguments[G__9664__i + 6]; ++G__9664__i;}
G__9663 = new cljs.core.IndexedSeq(G__9664__a,0);
}
return vary_meta__7.cljs$core$IFn$_invoke$arity$variadic(obj,f,a,b,c,d, G__9663);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
vary_meta.cljs$lang$maxFixedArity = 6;
vary_meta.cljs$lang$applyTo = vary_meta__7.cljs$lang$applyTo;
vary_meta.cljs$core$IFn$_invoke$arity$2 = vary_meta__2;
vary_meta.cljs$core$IFn$_invoke$arity$3 = vary_meta__3;
vary_meta.cljs$core$IFn$_invoke$arity$4 = vary_meta__4;
vary_meta.cljs$core$IFn$_invoke$arity$5 = vary_meta__5;
vary_meta.cljs$core$IFn$_invoke$arity$6 = vary_meta__6;
vary_meta.cljs$core$IFn$_invoke$arity$variadic = vary_meta__7.cljs$core$IFn$_invoke$arity$variadic;
return vary_meta;
})()
;
/**
* Same as (not (= obj1 obj2))
* @param {...*} var_args
*/
cljs.core.not_EQ_ = (function() {
var not_EQ_ = null;
var not_EQ___1 = (function (x){
return false;
});
var not_EQ___2 = (function (x,y){
return !(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y));
});
var not_EQ___3 = (function() { 
var G__9665__delegate = function (x,y,more){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_,x,y,more));
};
var G__9665 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__9666__i = 0, G__9666__a = new Array(arguments.length -  2);
while (G__9666__i < G__9666__a.length) {G__9666__a[G__9666__i] = arguments[G__9666__i + 2]; ++G__9666__i;}
  more = new cljs.core.IndexedSeq(G__9666__a,0);
} 
return G__9665__delegate.call(this,x,y,more);};
G__9665.cljs$lang$maxFixedArity = 2;
G__9665.cljs$lang$applyTo = (function (arglist__9667){
var x = cljs.core.first(arglist__9667);
arglist__9667 = cljs.core.next(arglist__9667);
var y = cljs.core.first(arglist__9667);
var more = cljs.core.rest(arglist__9667);
return G__9665__delegate(x,y,more);
});
G__9665.cljs$core$IFn$_invoke$arity$variadic = G__9665__delegate;
return G__9665;
})()
;
not_EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return not_EQ___1.call(this,x);
case 2:
return not_EQ___2.call(this,x,y);
default:
var G__9668 = null;
if (arguments.length > 2) {
var G__9669__i = 0, G__9669__a = new Array(arguments.length -  2);
while (G__9669__i < G__9669__a.length) {G__9669__a[G__9669__i] = arguments[G__9669__i + 2]; ++G__9669__i;}
G__9668 = new cljs.core.IndexedSeq(G__9669__a,0);
}
return not_EQ___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__9668);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
not_EQ_.cljs$lang$maxFixedArity = 2;
not_EQ_.cljs$lang$applyTo = not_EQ___3.cljs$lang$applyTo;
not_EQ_.cljs$core$IFn$_invoke$arity$1 = not_EQ___1;
not_EQ_.cljs$core$IFn$_invoke$arity$2 = not_EQ___2;
not_EQ_.cljs$core$IFn$_invoke$arity$variadic = not_EQ___3.cljs$core$IFn$_invoke$arity$variadic;
return not_EQ_;
})()
;
/**
* If coll is empty, returns nil, else coll
*/
cljs.core.not_empty = (function not_empty(coll){
if(cljs.core.seq(coll)){
return coll;
} else {
return null;
}
});
cljs.core.nil_iter = (function nil_iter(){
if(typeof cljs.core.t9673 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.t9673 = (function (nil_iter,meta9674){
this.nil_iter = nil_iter;
this.meta9674 = meta9674;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.t9673.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return false;
});

cljs.core.t9673.prototype.next = (function (){
var self__ = this;
var _ = this;
return (new Error("No such element"));
});

cljs.core.t9673.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.t9673.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_9675){
var self__ = this;
var _9675__$1 = this;
return self__.meta9674;
});

cljs.core.t9673.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_9675,meta9674__$1){
var self__ = this;
var _9675__$1 = this;
return (new cljs.core.t9673(self__.nil_iter,meta9674__$1));
});

cljs.core.t9673.cljs$lang$type = true;

cljs.core.t9673.cljs$lang$ctorStr = "cljs.core/t9673";

cljs.core.t9673.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/t9673");
});

cljs.core.__GT_t9673 = (function __GT_t9673(nil_iter__$1,meta9674){
return (new cljs.core.t9673(nil_iter__$1,meta9674));
});

}

return (new cljs.core.t9673(nil_iter,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"end-column","end-column",1425389514),54,new cljs.core.Keyword(null,"end-line","end-line",1837326455),3063,new cljs.core.Keyword(null,"column","column",2078222095),3,new cljs.core.Keyword(null,"line","line",212345235),3059,new cljs.core.Keyword(null,"file","file",-1269645878),"/home/andrew/code/overseer/resources/static/js-out/cljs/core.cljs"], null)));
});

/**
* @constructor
*/
cljs.core.StringIter = (function (s,i){
this.s = s;
this.i = i;
})
cljs.core.StringIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.s.length);
});

cljs.core.StringIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.s.charAt(self__.i);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.StringIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.StringIter.cljs$lang$type = true;

cljs.core.StringIter.cljs$lang$ctorStr = "cljs.core/StringIter";

cljs.core.StringIter.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/StringIter");
});

cljs.core.__GT_StringIter = (function __GT_StringIter(s,i){
return (new cljs.core.StringIter(s,i));
});

cljs.core.string_iter = (function string_iter(x){
return (new cljs.core.StringIter(x,(0)));
});

/**
* @constructor
*/
cljs.core.ArrayIter = (function (arr,i){
this.arr = arr;
this.i = i;
})
cljs.core.ArrayIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
});

cljs.core.ArrayIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.ArrayIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.ArrayIter.cljs$lang$type = true;

cljs.core.ArrayIter.cljs$lang$ctorStr = "cljs.core/ArrayIter";

cljs.core.ArrayIter.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/ArrayIter");
});

cljs.core.__GT_ArrayIter = (function __GT_ArrayIter(arr,i){
return (new cljs.core.ArrayIter(arr,i));
});

cljs.core.array_iter = (function array_iter(x){
return (new cljs.core.ArrayIter(x,(0)));
});
cljs.core.INIT = {};
cljs.core.START = {};

/**
* @constructor
*/
cljs.core.SeqIter = (function (_seq,_next){
this._seq = _seq;
this._next = _next;
})
cljs.core.SeqIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__._seq === cljs.core.INIT)){
self__._seq = cljs.core.START;

self__._next = cljs.core.seq(self__._next);
} else {
if((self__._seq === self__._next)){
self__._next = cljs.core.next(self__._seq);
} else {
}
}

return !((self__._next == null));
});

cljs.core.SeqIter.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(cljs.core.not(this$.hasNext())){
throw (new Error("No such element"));
} else {
self__._seq = self__._next;

return cljs.core.first(self__._next);
}
});

cljs.core.SeqIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.SeqIter.cljs$lang$type = true;

cljs.core.SeqIter.cljs$lang$ctorStr = "cljs.core/SeqIter";

cljs.core.SeqIter.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/SeqIter");
});

cljs.core.__GT_SeqIter = (function __GT_SeqIter(_seq,_next){
return (new cljs.core.SeqIter(_seq,_next));
});

cljs.core.seq_iter = (function seq_iter(coll){
return (new cljs.core.SeqIter(cljs.core.INIT,coll));
});
cljs.core.iter = (function iter(coll){
if((coll == null)){
return cljs.core.nil_iter();
} else {
if(typeof coll === 'string'){
return cljs.core.string_iter(coll);
} else {
if(coll instanceof Array){
return cljs.core.array_iter(coll);
} else {
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core._iterator(coll);
} else {
if(cljs.core.seqable_QMARK_(coll)){
return cljs.core.seq_iter(coll);
} else {
throw (new Error([cljs.core.str("Cannot create iterator from "),cljs.core.str(coll)].join('')));

}
}
}
}
}
});
cljs.core.lazy_transformer = (function lazy_transformer(stepper){
return (new cljs.core.LazyTransformer(stepper,null,null,null));
});

/**
* @constructor
*/
cljs.core.Stepper = (function (xform,iter){
this.xform = xform;
this.iter = iter;
})
cljs.core.Stepper.prototype.step = (function (lt){
var self__ = this;
var this$ = this;
while(true){
if(cljs.core.truth_((function (){var and__3746__auto__ = !((lt.stepper == null));
if(and__3746__auto__){
return self__.iter.hasNext();
} else {
return and__3746__auto__;
}
})())){
if(cljs.core.reduced_QMARK_((function (){var G__9676 = lt;
var G__9677 = self__.iter.next();
return (self__.xform.cljs$core$IFn$_invoke$arity$2 ? self__.xform.cljs$core$IFn$_invoke$arity$2(G__9676,G__9677) : self__.xform.call(null,G__9676,G__9677));
})())){
if((lt.rest == null)){
} else {
lt.rest.stepper = null;
}
} else {
continue;
}
} else {
}
break;
}

if((lt.stepper == null)){
return null;
} else {
var G__9678 = lt;
return (self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(G__9678) : self__.xform.call(null,G__9678));
}
});

cljs.core.Stepper.cljs$lang$type = true;

cljs.core.Stepper.cljs$lang$ctorStr = "cljs.core/Stepper";

cljs.core.Stepper.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/Stepper");
});

cljs.core.__GT_Stepper = (function __GT_Stepper(xform,iter){
return (new cljs.core.Stepper(xform,iter));
});

cljs.core.stepper = (function stepper(xform,iter){
var stepfn = (function() {
var stepfn = null;
var stepfn__1 = (function (result){
var lt = ((cljs.core.reduced_QMARK_(result))?cljs.core.deref(result):result);
lt.stepper = null;

return result;
});
var stepfn__2 = (function (result,input){
var lt = result;
lt.first = input;

lt.rest = cljs.core.lazy_transformer(lt.stepper);

lt.stepper = null;

return lt.rest;
});
stepfn = function(result,input){
switch(arguments.length){
case 1:
return stepfn__1.call(this,result);
case 2:
return stepfn__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
stepfn.cljs$core$IFn$_invoke$arity$1 = stepfn__1;
stepfn.cljs$core$IFn$_invoke$arity$2 = stepfn__2;
return stepfn;
})()
;
return (new cljs.core.Stepper((function (){var G__9680 = stepfn;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__9680) : xform.call(null,G__9680));
})(),iter));
});

/**
* @constructor
*/
cljs.core.MultiStepper = (function (xform,iters,nexts){
this.xform = xform;
this.iters = iters;
this.nexts = nexts;
})
cljs.core.MultiStepper.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var iters__$1 = cljs.core.seq(self__.iters);
while(true){
if(!((iters__$1 == null))){
var iter = cljs.core.first(iters__$1);
if(cljs.core.not(iter.hasNext())){
return false;
} else {
var G__9682 = cljs.core.next(iters__$1);
iters__$1 = G__9682;
continue;
}
} else {
return true;
}
break;
}
});

cljs.core.MultiStepper.prototype.next = (function (){
var self__ = this;
var _ = this;
var n__4645__auto___9683 = self__.iters.length;
var i_9684 = (0);
while(true){
if((i_9684 < n__4645__auto___9683)){
(self__.nexts[i_9684] = (self__.iters[i_9684]).next());

var G__9685 = (i_9684 + (1));
i_9684 = G__9685;
continue;
} else {
}
break;
}

return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(self__.nexts,(0));
});

cljs.core.MultiStepper.prototype.step = (function (lt){
var self__ = this;
var this$ = this;
while(true){
if(cljs.core.truth_((function (){var and__3746__auto__ = !((lt.stepper == null));
if(and__3746__auto__){
return this$.hasNext();
} else {
return and__3746__auto__;
}
})())){
if(cljs.core.reduced_QMARK_(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xform,cljs.core.cons(lt,this$.next())))){
if((lt.rest == null)){
} else {
lt.rest.stepper = null;
}
} else {
continue;
}
} else {
}
break;
}

if((lt.stepper == null)){
return null;
} else {
var G__9681 = lt;
return (self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(G__9681) : self__.xform.call(null,G__9681));
}
});

cljs.core.MultiStepper.cljs$lang$type = true;

cljs.core.MultiStepper.cljs$lang$ctorStr = "cljs.core/MultiStepper";

cljs.core.MultiStepper.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/MultiStepper");
});

cljs.core.__GT_MultiStepper = (function __GT_MultiStepper(xform,iters,nexts){
return (new cljs.core.MultiStepper(xform,iters,nexts));
});

cljs.core.multi_stepper = (function() {
var multi_stepper = null;
var multi_stepper__2 = (function (xform,iters){
return multi_stepper.cljs$core$IFn$_invoke$arity$3(xform,iters,(new Array(iters.length)));
});
var multi_stepper__3 = (function (xform,iters,nexts){
var stepfn = (function() {
var stepfn = null;
var stepfn__1 = (function (result){
var lt = ((cljs.core.reduced_QMARK_(result))?cljs.core.deref(result):result);
lt.stepper = null;

return lt;
});
var stepfn__2 = (function (result,input){
var lt = result;
lt.first = input;

lt.rest = cljs.core.lazy_transformer(lt.stepper);

lt.stepper = null;

return lt.rest;
});
stepfn = function(result,input){
switch(arguments.length){
case 1:
return stepfn__1.call(this,result);
case 2:
return stepfn__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
stepfn.cljs$core$IFn$_invoke$arity$1 = stepfn__1;
stepfn.cljs$core$IFn$_invoke$arity$2 = stepfn__2;
return stepfn;
})()
;
return (new cljs.core.MultiStepper((function (){var G__9690 = stepfn;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__9690) : xform.call(null,G__9690));
})(),iters,nexts));
});
multi_stepper = function(xform,iters,nexts){
switch(arguments.length){
case 2:
return multi_stepper__2.call(this,xform,iters);
case 3:
return multi_stepper__3.call(this,xform,iters,nexts);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
multi_stepper.cljs$core$IFn$_invoke$arity$2 = multi_stepper__2;
multi_stepper.cljs$core$IFn$_invoke$arity$3 = multi_stepper__3;
return multi_stepper;
})()
;

/**
* @constructor
*/
cljs.core.LazyTransformer = (function (stepper,first,rest,meta){
this.stepper = stepper;
this.first = first;
this.rest = rest;
this.meta = meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 31719628;
})
cljs.core.LazyTransformer.prototype.cljs$core$INext$_next$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return cljs.core._seq(self__.rest);
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return self__.first;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
self__.stepper.step(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return this$__$1;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.hash_ordered_coll(this$__$1);
});

cljs.core.LazyTransformer.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
var s = cljs.core._seq(this$__$1);
if(!((s == null))){
return cljs.core.equiv_sequential(this$__$1,other);
} else {
return (cljs.core.sequential_QMARK_(other)) && ((cljs.core.seq(other) == null));
}
});

cljs.core.LazyTransformer.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.LazyTransformer.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,cljs.core._seq(this$__$1));
});

cljs.core.LazyTransformer.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,new_meta){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.LazyTransformer(self__.stepper,self__.first,self__.rest,new_meta));
});

cljs.core.LazyTransformer.cljs$lang$type = true;

cljs.core.LazyTransformer.cljs$lang$ctorStr = "cljs.core/LazyTransformer";

cljs.core.LazyTransformer.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/LazyTransformer");
});

cljs.core.__GT_LazyTransformer = (function __GT_LazyTransformer(stepper,first,rest,meta){
return (new cljs.core.LazyTransformer(stepper,first,rest,meta));
});

(cljs.core.LazyTransformer.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
cljs.core.LazyTransformer.create = (function (xform,coll){
return (new cljs.core.LazyTransformer(cljs.core.stepper(xform,cljs.core.iter(coll)),null,null,null));
});
cljs.core.LazyTransformer.createMulti = (function (xform,colls){
var iters = [];
var seq__9691_9695 = cljs.core.seq(colls);
var chunk__9692_9696 = null;
var count__9693_9697 = (0);
var i__9694_9698 = (0);
while(true){
if((i__9694_9698 < count__9693_9697)){
var coll_9699 = chunk__9692_9696.cljs$core$IIndexed$_nth$arity$2(null,i__9694_9698);
iters.push(cljs.core.iter(coll_9699));

var G__9700 = seq__9691_9695;
var G__9701 = chunk__9692_9696;
var G__9702 = count__9693_9697;
var G__9703 = (i__9694_9698 + (1));
seq__9691_9695 = G__9700;
chunk__9692_9696 = G__9701;
count__9693_9697 = G__9702;
i__9694_9698 = G__9703;
continue;
} else {
var temp__4126__auto___9704 = cljs.core.seq(seq__9691_9695);
if(temp__4126__auto___9704){
var seq__9691_9705__$1 = temp__4126__auto___9704;
if(cljs.core.chunked_seq_QMARK_(seq__9691_9705__$1)){
var c__4545__auto___9706 = cljs.core.chunk_first(seq__9691_9705__$1);
var G__9707 = cljs.core.chunk_rest(seq__9691_9705__$1);
var G__9708 = c__4545__auto___9706;
var G__9709 = cljs.core.count(c__4545__auto___9706);
var G__9710 = (0);
seq__9691_9695 = G__9707;
chunk__9692_9696 = G__9708;
count__9693_9697 = G__9709;
i__9694_9698 = G__9710;
continue;
} else {
var coll_9711 = cljs.core.first(seq__9691_9705__$1);
iters.push(cljs.core.iter(coll_9711));

var G__9712 = cljs.core.next(seq__9691_9705__$1);
var G__9713 = null;
var G__9714 = (0);
var G__9715 = (0);
seq__9691_9695 = G__9712;
chunk__9692_9696 = G__9713;
count__9693_9697 = G__9714;
i__9694_9698 = G__9715;
continue;
}
} else {
}
}
break;
}

return (new cljs.core.LazyTransformer(cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform,iters,(new Array(iters.length))),null,null,null));
});
/**
* Coerces coll to a (possibly empty) sequence, if it is not already
* one. Will not force a lazy seq. (sequence nil) yields (), When a
* transducer is supplied, returns a lazy sequence of applications of
* the transform to the items in coll(s), i.e. to the set of first
* items of each coll, followed by the set of second
* items in each coll, until any one of the colls is exhausted.  Any
* remaining items in other colls are ignored. The transform should accept
* number-of-colls arguments
* @param {...*} var_args
*/
cljs.core.sequence = (function() {
var sequence = null;
var sequence__1 = (function (coll){
if(cljs.core.seq_QMARK_(coll)){
return coll;
} else {
var or__3758__auto__ = cljs.core.seq(coll);
if(or__3758__auto__){
return or__3758__auto__;
} else {
return cljs.core.List.EMPTY;
}
}
});
var sequence__2 = (function (xform,coll){
return cljs.core.LazyTransformer.create(xform,coll);
});
var sequence__3 = (function() { 
var G__9716__delegate = function (xform,coll,colls){
return cljs.core.LazyTransformer.createMulti(xform,cljs.core.to_array(cljs.core.cons(coll,colls)));
};
var G__9716 = function (xform,coll,var_args){
var colls = null;
if (arguments.length > 2) {
var G__9717__i = 0, G__9717__a = new Array(arguments.length -  2);
while (G__9717__i < G__9717__a.length) {G__9717__a[G__9717__i] = arguments[G__9717__i + 2]; ++G__9717__i;}
  colls = new cljs.core.IndexedSeq(G__9717__a,0);
} 
return G__9716__delegate.call(this,xform,coll,colls);};
G__9716.cljs$lang$maxFixedArity = 2;
G__9716.cljs$lang$applyTo = (function (arglist__9718){
var xform = cljs.core.first(arglist__9718);
arglist__9718 = cljs.core.next(arglist__9718);
var coll = cljs.core.first(arglist__9718);
var colls = cljs.core.rest(arglist__9718);
return G__9716__delegate(xform,coll,colls);
});
G__9716.cljs$core$IFn$_invoke$arity$variadic = G__9716__delegate;
return G__9716;
})()
;
sequence = function(xform,coll,var_args){
var colls = var_args;
switch(arguments.length){
case 1:
return sequence__1.call(this,xform);
case 2:
return sequence__2.call(this,xform,coll);
default:
var G__9719 = null;
if (arguments.length > 2) {
var G__9720__i = 0, G__9720__a = new Array(arguments.length -  2);
while (G__9720__i < G__9720__a.length) {G__9720__a[G__9720__i] = arguments[G__9720__i + 2]; ++G__9720__i;}
G__9719 = new cljs.core.IndexedSeq(G__9720__a,0);
}
return sequence__3.cljs$core$IFn$_invoke$arity$variadic(xform,coll, G__9719);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sequence.cljs$lang$maxFixedArity = 2;
sequence.cljs$lang$applyTo = sequence__3.cljs$lang$applyTo;
sequence.cljs$core$IFn$_invoke$arity$1 = sequence__1;
sequence.cljs$core$IFn$_invoke$arity$2 = sequence__2;
sequence.cljs$core$IFn$_invoke$arity$variadic = sequence__3.cljs$core$IFn$_invoke$arity$variadic;
return sequence;
})()
;
/**
* Returns true if (pred x) is logical true for every x in coll, else
* false.
*/
cljs.core.every_QMARK_ = (function every_QMARK_(pred,coll){
while(true){
if((cljs.core.seq(coll) == null)){
return true;
} else {
if(cljs.core.truth_((function (){var G__9722 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__9722) : pred.call(null,G__9722));
})())){
var G__9723 = pred;
var G__9724 = cljs.core.next(coll);
pred = G__9723;
coll = G__9724;
continue;
} else {
return false;

}
}
break;
}
});
/**
* Returns false if (pred x) is logical true for every x in
* coll, else true.
*/
cljs.core.not_every_QMARK_ = (function not_every_QMARK_(pred,coll){
return !(cljs.core.every_QMARK_(pred,coll));
});
/**
* Returns the first logical true value of (pred x) for any x in coll,
* else nil.  One common idiom is to use a set as pred, for example
* this will return :fred if :fred is in the sequence, otherwise nil:
* (some #{:fred} coll)
*/
cljs.core.some = (function some(pred,coll){
while(true){
if(cljs.core.seq(coll)){
var or__3758__auto__ = (function (){var G__9728 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__9728) : pred.call(null,G__9728));
})();
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
var G__9729 = pred;
var G__9730 = cljs.core.next(coll);
pred = G__9729;
coll = G__9730;
continue;
}
} else {
return null;
}
break;
}
});
/**
* Returns false if (pred x) is logical true for any x in coll,
* else true.
*/
cljs.core.not_any_QMARK_ = (function not_any_QMARK_(pred,coll){
return cljs.core.not(cljs.core.some(pred,coll));
});
/**
* Returns true if n is even, throws an exception if n is not an integer
*/
cljs.core.even_QMARK_ = (function even_QMARK_(n){
if(cljs.core.integer_QMARK_(n)){
return ((n & (1)) === (0));
} else {
throw (new Error([cljs.core.str("Argument must be an integer: "),cljs.core.str(n)].join('')));
}
});
/**
* Returns true if n is odd, throws an exception if n is not an integer
*/
cljs.core.odd_QMARK_ = (function odd_QMARK_(n){
return !(cljs.core.even_QMARK_(n));
});
/**
* Takes a fn f and returns a fn that takes the same arguments as f,
* has the same effects, if any, and returns the opposite truth value.
*/
cljs.core.complement = (function complement(f){
return (function() {
var G__9737 = null;
var G__9737__0 = (function (){
return cljs.core.not((function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})());
});
var G__9737__1 = (function (x){
return cljs.core.not((function (){var G__9734 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9734) : f.call(null,G__9734));
})());
});
var G__9737__2 = (function (x,y){
return cljs.core.not((function (){var G__9735 = x;
var G__9736 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9735,G__9736) : f.call(null,G__9735,G__9736));
})());
});
var G__9737__3 = (function() { 
var G__9738__delegate = function (x,y,zs){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f,x,y,zs));
};
var G__9738 = function (x,y,var_args){
var zs = null;
if (arguments.length > 2) {
var G__9739__i = 0, G__9739__a = new Array(arguments.length -  2);
while (G__9739__i < G__9739__a.length) {G__9739__a[G__9739__i] = arguments[G__9739__i + 2]; ++G__9739__i;}
  zs = new cljs.core.IndexedSeq(G__9739__a,0);
} 
return G__9738__delegate.call(this,x,y,zs);};
G__9738.cljs$lang$maxFixedArity = 2;
G__9738.cljs$lang$applyTo = (function (arglist__9740){
var x = cljs.core.first(arglist__9740);
arglist__9740 = cljs.core.next(arglist__9740);
var y = cljs.core.first(arglist__9740);
var zs = cljs.core.rest(arglist__9740);
return G__9738__delegate(x,y,zs);
});
G__9738.cljs$core$IFn$_invoke$arity$variadic = G__9738__delegate;
return G__9738;
})()
;
G__9737 = function(x,y,var_args){
var zs = var_args;
switch(arguments.length){
case 0:
return G__9737__0.call(this);
case 1:
return G__9737__1.call(this,x);
case 2:
return G__9737__2.call(this,x,y);
default:
var G__9741 = null;
if (arguments.length > 2) {
var G__9742__i = 0, G__9742__a = new Array(arguments.length -  2);
while (G__9742__i < G__9742__a.length) {G__9742__a[G__9742__i] = arguments[G__9742__i + 2]; ++G__9742__i;}
G__9741 = new cljs.core.IndexedSeq(G__9742__a,0);
}
return G__9737__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__9741);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9737.cljs$lang$maxFixedArity = 2;
G__9737.cljs$lang$applyTo = G__9737__3.cljs$lang$applyTo;
G__9737.cljs$core$IFn$_invoke$arity$0 = G__9737__0;
G__9737.cljs$core$IFn$_invoke$arity$1 = G__9737__1;
G__9737.cljs$core$IFn$_invoke$arity$2 = G__9737__2;
G__9737.cljs$core$IFn$_invoke$arity$variadic = G__9737__3.cljs$core$IFn$_invoke$arity$variadic;
return G__9737;
})()
});
/**
* Returns a function that takes any number of arguments and returns x.
*/
cljs.core.constantly = (function constantly(x){
return (function() { 
var G__9743__delegate = function (args){
return x;
};
var G__9743 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__9744__i = 0, G__9744__a = new Array(arguments.length -  0);
while (G__9744__i < G__9744__a.length) {G__9744__a[G__9744__i] = arguments[G__9744__i + 0]; ++G__9744__i;}
  args = new cljs.core.IndexedSeq(G__9744__a,0);
} 
return G__9743__delegate.call(this,args);};
G__9743.cljs$lang$maxFixedArity = 0;
G__9743.cljs$lang$applyTo = (function (arglist__9745){
var args = cljs.core.seq(arglist__9745);
return G__9743__delegate(args);
});
G__9743.cljs$core$IFn$_invoke$arity$variadic = G__9743__delegate;
return G__9743;
})()
;
});
/**
* Takes a set of functions and returns a fn that is the composition
* of those fns.  The returned fn takes a variable number of args,
* applies the rightmost of fns to the args, the next
* fn (right-to-left) to the result, etc.
* @param {...*} var_args
*/
cljs.core.comp = (function() {
var comp = null;
var comp__0 = (function (){
return cljs.core.identity;
});
var comp__1 = (function (f){
return f;
});
var comp__2 = (function (f,g){
return (function() {
var G__9800 = null;
var G__9800__0 = (function (){
var G__9773 = (function (){return (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9773) : f.call(null,G__9773));
});
var G__9800__1 = (function (x){
var G__9774 = (function (){var G__9775 = x;
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__9775) : g.call(null,G__9775));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9774) : f.call(null,G__9774));
});
var G__9800__2 = (function (x,y){
var G__9776 = (function (){var G__9777 = x;
var G__9778 = y;
return (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(G__9777,G__9778) : g.call(null,G__9777,G__9778));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9776) : f.call(null,G__9776));
});
var G__9800__3 = (function (x,y,z){
var G__9779 = (function (){var G__9780 = x;
var G__9781 = y;
var G__9782 = z;
return (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(G__9780,G__9781,G__9782) : g.call(null,G__9780,G__9781,G__9782));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9779) : f.call(null,G__9779));
});
var G__9800__4 = (function() { 
var G__9801__delegate = function (x,y,z,args){
var G__9783 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9783) : f.call(null,G__9783));
};
var G__9801 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9802__i = 0, G__9802__a = new Array(arguments.length -  3);
while (G__9802__i < G__9802__a.length) {G__9802__a[G__9802__i] = arguments[G__9802__i + 3]; ++G__9802__i;}
  args = new cljs.core.IndexedSeq(G__9802__a,0);
} 
return G__9801__delegate.call(this,x,y,z,args);};
G__9801.cljs$lang$maxFixedArity = 3;
G__9801.cljs$lang$applyTo = (function (arglist__9803){
var x = cljs.core.first(arglist__9803);
arglist__9803 = cljs.core.next(arglist__9803);
var y = cljs.core.first(arglist__9803);
arglist__9803 = cljs.core.next(arglist__9803);
var z = cljs.core.first(arglist__9803);
var args = cljs.core.rest(arglist__9803);
return G__9801__delegate(x,y,z,args);
});
G__9801.cljs$core$IFn$_invoke$arity$variadic = G__9801__delegate;
return G__9801;
})()
;
G__9800 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__9800__0.call(this);
case 1:
return G__9800__1.call(this,x);
case 2:
return G__9800__2.call(this,x,y);
case 3:
return G__9800__3.call(this,x,y,z);
default:
var G__9804 = null;
if (arguments.length > 3) {
var G__9805__i = 0, G__9805__a = new Array(arguments.length -  3);
while (G__9805__i < G__9805__a.length) {G__9805__a[G__9805__i] = arguments[G__9805__i + 3]; ++G__9805__i;}
G__9804 = new cljs.core.IndexedSeq(G__9805__a,0);
}
return G__9800__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9804);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9800.cljs$lang$maxFixedArity = 3;
G__9800.cljs$lang$applyTo = G__9800__4.cljs$lang$applyTo;
G__9800.cljs$core$IFn$_invoke$arity$0 = G__9800__0;
G__9800.cljs$core$IFn$_invoke$arity$1 = G__9800__1;
G__9800.cljs$core$IFn$_invoke$arity$2 = G__9800__2;
G__9800.cljs$core$IFn$_invoke$arity$3 = G__9800__3;
G__9800.cljs$core$IFn$_invoke$arity$variadic = G__9800__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9800;
})()
});
var comp__3 = (function (f,g,h){
return (function() {
var G__9806 = null;
var G__9806__0 = (function (){
var G__9784 = (function (){var G__9785 = (function (){return (h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__9785) : g.call(null,G__9785));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9784) : f.call(null,G__9784));
});
var G__9806__1 = (function (x){
var G__9786 = (function (){var G__9787 = (function (){var G__9788 = x;
return (h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(G__9788) : h.call(null,G__9788));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__9787) : g.call(null,G__9787));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9786) : f.call(null,G__9786));
});
var G__9806__2 = (function (x,y){
var G__9789 = (function (){var G__9790 = (function (){var G__9791 = x;
var G__9792 = y;
return (h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(G__9791,G__9792) : h.call(null,G__9791,G__9792));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__9790) : g.call(null,G__9790));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9789) : f.call(null,G__9789));
});
var G__9806__3 = (function (x,y,z){
var G__9793 = (function (){var G__9794 = (function (){var G__9795 = x;
var G__9796 = y;
var G__9797 = z;
return (h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(G__9795,G__9796,G__9797) : h.call(null,G__9795,G__9796,G__9797));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__9794) : g.call(null,G__9794));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9793) : f.call(null,G__9793));
});
var G__9806__4 = (function() { 
var G__9807__delegate = function (x,y,z,args){
var G__9798 = (function (){var G__9799 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args);
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__9799) : g.call(null,G__9799));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9798) : f.call(null,G__9798));
};
var G__9807 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9808__i = 0, G__9808__a = new Array(arguments.length -  3);
while (G__9808__i < G__9808__a.length) {G__9808__a[G__9808__i] = arguments[G__9808__i + 3]; ++G__9808__i;}
  args = new cljs.core.IndexedSeq(G__9808__a,0);
} 
return G__9807__delegate.call(this,x,y,z,args);};
G__9807.cljs$lang$maxFixedArity = 3;
G__9807.cljs$lang$applyTo = (function (arglist__9809){
var x = cljs.core.first(arglist__9809);
arglist__9809 = cljs.core.next(arglist__9809);
var y = cljs.core.first(arglist__9809);
arglist__9809 = cljs.core.next(arglist__9809);
var z = cljs.core.first(arglist__9809);
var args = cljs.core.rest(arglist__9809);
return G__9807__delegate(x,y,z,args);
});
G__9807.cljs$core$IFn$_invoke$arity$variadic = G__9807__delegate;
return G__9807;
})()
;
G__9806 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__9806__0.call(this);
case 1:
return G__9806__1.call(this,x);
case 2:
return G__9806__2.call(this,x,y);
case 3:
return G__9806__3.call(this,x,y,z);
default:
var G__9810 = null;
if (arguments.length > 3) {
var G__9811__i = 0, G__9811__a = new Array(arguments.length -  3);
while (G__9811__i < G__9811__a.length) {G__9811__a[G__9811__i] = arguments[G__9811__i + 3]; ++G__9811__i;}
G__9810 = new cljs.core.IndexedSeq(G__9811__a,0);
}
return G__9806__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9810);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9806.cljs$lang$maxFixedArity = 3;
G__9806.cljs$lang$applyTo = G__9806__4.cljs$lang$applyTo;
G__9806.cljs$core$IFn$_invoke$arity$0 = G__9806__0;
G__9806.cljs$core$IFn$_invoke$arity$1 = G__9806__1;
G__9806.cljs$core$IFn$_invoke$arity$2 = G__9806__2;
G__9806.cljs$core$IFn$_invoke$arity$3 = G__9806__3;
G__9806.cljs$core$IFn$_invoke$arity$variadic = G__9806__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9806;
})()
});
var comp__4 = (function() { 
var G__9812__delegate = function (f1,f2,f3,fs){
var fs__$1 = cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1,f2,f3,fs));
return ((function (fs__$1){
return (function() { 
var G__9813__delegate = function (args){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1),args);
var fs__$2 = cljs.core.next(fs__$1);
while(true){
if(fs__$2){
var G__9814 = cljs.core.first(fs__$2).call(null,ret);
var G__9815 = cljs.core.next(fs__$2);
ret = G__9814;
fs__$2 = G__9815;
continue;
} else {
return ret;
}
break;
}
};
var G__9813 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__9816__i = 0, G__9816__a = new Array(arguments.length -  0);
while (G__9816__i < G__9816__a.length) {G__9816__a[G__9816__i] = arguments[G__9816__i + 0]; ++G__9816__i;}
  args = new cljs.core.IndexedSeq(G__9816__a,0);
} 
return G__9813__delegate.call(this,args);};
G__9813.cljs$lang$maxFixedArity = 0;
G__9813.cljs$lang$applyTo = (function (arglist__9817){
var args = cljs.core.seq(arglist__9817);
return G__9813__delegate(args);
});
G__9813.cljs$core$IFn$_invoke$arity$variadic = G__9813__delegate;
return G__9813;
})()
;
;})(fs__$1))
};
var G__9812 = function (f1,f2,f3,var_args){
var fs = null;
if (arguments.length > 3) {
var G__9818__i = 0, G__9818__a = new Array(arguments.length -  3);
while (G__9818__i < G__9818__a.length) {G__9818__a[G__9818__i] = arguments[G__9818__i + 3]; ++G__9818__i;}
  fs = new cljs.core.IndexedSeq(G__9818__a,0);
} 
return G__9812__delegate.call(this,f1,f2,f3,fs);};
G__9812.cljs$lang$maxFixedArity = 3;
G__9812.cljs$lang$applyTo = (function (arglist__9819){
var f1 = cljs.core.first(arglist__9819);
arglist__9819 = cljs.core.next(arglist__9819);
var f2 = cljs.core.first(arglist__9819);
arglist__9819 = cljs.core.next(arglist__9819);
var f3 = cljs.core.first(arglist__9819);
var fs = cljs.core.rest(arglist__9819);
return G__9812__delegate(f1,f2,f3,fs);
});
G__9812.cljs$core$IFn$_invoke$arity$variadic = G__9812__delegate;
return G__9812;
})()
;
comp = function(f1,f2,f3,var_args){
var fs = var_args;
switch(arguments.length){
case 0:
return comp__0.call(this);
case 1:
return comp__1.call(this,f1);
case 2:
return comp__2.call(this,f1,f2);
case 3:
return comp__3.call(this,f1,f2,f3);
default:
var G__9820 = null;
if (arguments.length > 3) {
var G__9821__i = 0, G__9821__a = new Array(arguments.length -  3);
while (G__9821__i < G__9821__a.length) {G__9821__a[G__9821__i] = arguments[G__9821__i + 3]; ++G__9821__i;}
G__9820 = new cljs.core.IndexedSeq(G__9821__a,0);
}
return comp__4.cljs$core$IFn$_invoke$arity$variadic(f1,f2,f3, G__9820);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
comp.cljs$lang$maxFixedArity = 3;
comp.cljs$lang$applyTo = comp__4.cljs$lang$applyTo;
comp.cljs$core$IFn$_invoke$arity$0 = comp__0;
comp.cljs$core$IFn$_invoke$arity$1 = comp__1;
comp.cljs$core$IFn$_invoke$arity$2 = comp__2;
comp.cljs$core$IFn$_invoke$arity$3 = comp__3;
comp.cljs$core$IFn$_invoke$arity$variadic = comp__4.cljs$core$IFn$_invoke$arity$variadic;
return comp;
})()
;
/**
* Takes a function f and fewer than the normal arguments to f, and
* returns a fn that takes a variable number of additional args. When
* called, the returned function calls f with args + additional args.
* @param {...*} var_args
*/
cljs.core.partial = (function() {
var partial = null;
var partial__1 = (function (f){
return f;
});
var partial__2 = (function (f,arg1){
return (function() {
var G__9906 = null;
var G__9906__0 = (function (){
var G__9864 = arg1;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9864) : f.call(null,G__9864));
});
var G__9906__1 = (function (x){
var G__9865 = arg1;
var G__9866 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9865,G__9866) : f.call(null,G__9865,G__9866));
});
var G__9906__2 = (function (x,y){
var G__9867 = arg1;
var G__9868 = x;
var G__9869 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9867,G__9868,G__9869) : f.call(null,G__9867,G__9868,G__9869));
});
var G__9906__3 = (function (x,y,z){
var G__9870 = arg1;
var G__9871 = x;
var G__9872 = y;
var G__9873 = z;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__9870,G__9871,G__9872,G__9873) : f.call(null,G__9870,G__9871,G__9872,G__9873));
});
var G__9906__4 = (function() { 
var G__9907__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,x,y,z,cljs.core.array_seq([args], 0));
};
var G__9907 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9908__i = 0, G__9908__a = new Array(arguments.length -  3);
while (G__9908__i < G__9908__a.length) {G__9908__a[G__9908__i] = arguments[G__9908__i + 3]; ++G__9908__i;}
  args = new cljs.core.IndexedSeq(G__9908__a,0);
} 
return G__9907__delegate.call(this,x,y,z,args);};
G__9907.cljs$lang$maxFixedArity = 3;
G__9907.cljs$lang$applyTo = (function (arglist__9909){
var x = cljs.core.first(arglist__9909);
arglist__9909 = cljs.core.next(arglist__9909);
var y = cljs.core.first(arglist__9909);
arglist__9909 = cljs.core.next(arglist__9909);
var z = cljs.core.first(arglist__9909);
var args = cljs.core.rest(arglist__9909);
return G__9907__delegate(x,y,z,args);
});
G__9907.cljs$core$IFn$_invoke$arity$variadic = G__9907__delegate;
return G__9907;
})()
;
G__9906 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__9906__0.call(this);
case 1:
return G__9906__1.call(this,x);
case 2:
return G__9906__2.call(this,x,y);
case 3:
return G__9906__3.call(this,x,y,z);
default:
var G__9910 = null;
if (arguments.length > 3) {
var G__9911__i = 0, G__9911__a = new Array(arguments.length -  3);
while (G__9911__i < G__9911__a.length) {G__9911__a[G__9911__i] = arguments[G__9911__i + 3]; ++G__9911__i;}
G__9910 = new cljs.core.IndexedSeq(G__9911__a,0);
}
return G__9906__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9910);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9906.cljs$lang$maxFixedArity = 3;
G__9906.cljs$lang$applyTo = G__9906__4.cljs$lang$applyTo;
G__9906.cljs$core$IFn$_invoke$arity$0 = G__9906__0;
G__9906.cljs$core$IFn$_invoke$arity$1 = G__9906__1;
G__9906.cljs$core$IFn$_invoke$arity$2 = G__9906__2;
G__9906.cljs$core$IFn$_invoke$arity$3 = G__9906__3;
G__9906.cljs$core$IFn$_invoke$arity$variadic = G__9906__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9906;
})()
});
var partial__3 = (function (f,arg1,arg2){
return (function() {
var G__9912 = null;
var G__9912__0 = (function (){
var G__9874 = arg1;
var G__9875 = arg2;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9874,G__9875) : f.call(null,G__9874,G__9875));
});
var G__9912__1 = (function (x){
var G__9876 = arg1;
var G__9877 = arg2;
var G__9878 = x;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9876,G__9877,G__9878) : f.call(null,G__9876,G__9877,G__9878));
});
var G__9912__2 = (function (x,y){
var G__9879 = arg1;
var G__9880 = arg2;
var G__9881 = x;
var G__9882 = y;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__9879,G__9880,G__9881,G__9882) : f.call(null,G__9879,G__9880,G__9881,G__9882));
});
var G__9912__3 = (function (x,y,z){
var G__9883 = arg1;
var G__9884 = arg2;
var G__9885 = x;
var G__9886 = y;
var G__9887 = z;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__9883,G__9884,G__9885,G__9886,G__9887) : f.call(null,G__9883,G__9884,G__9885,G__9886,G__9887));
});
var G__9912__4 = (function() { 
var G__9913__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,x,y,cljs.core.array_seq([z,args], 0));
};
var G__9913 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9914__i = 0, G__9914__a = new Array(arguments.length -  3);
while (G__9914__i < G__9914__a.length) {G__9914__a[G__9914__i] = arguments[G__9914__i + 3]; ++G__9914__i;}
  args = new cljs.core.IndexedSeq(G__9914__a,0);
} 
return G__9913__delegate.call(this,x,y,z,args);};
G__9913.cljs$lang$maxFixedArity = 3;
G__9913.cljs$lang$applyTo = (function (arglist__9915){
var x = cljs.core.first(arglist__9915);
arglist__9915 = cljs.core.next(arglist__9915);
var y = cljs.core.first(arglist__9915);
arglist__9915 = cljs.core.next(arglist__9915);
var z = cljs.core.first(arglist__9915);
var args = cljs.core.rest(arglist__9915);
return G__9913__delegate(x,y,z,args);
});
G__9913.cljs$core$IFn$_invoke$arity$variadic = G__9913__delegate;
return G__9913;
})()
;
G__9912 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__9912__0.call(this);
case 1:
return G__9912__1.call(this,x);
case 2:
return G__9912__2.call(this,x,y);
case 3:
return G__9912__3.call(this,x,y,z);
default:
var G__9916 = null;
if (arguments.length > 3) {
var G__9917__i = 0, G__9917__a = new Array(arguments.length -  3);
while (G__9917__i < G__9917__a.length) {G__9917__a[G__9917__i] = arguments[G__9917__i + 3]; ++G__9917__i;}
G__9916 = new cljs.core.IndexedSeq(G__9917__a,0);
}
return G__9912__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9916);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9912.cljs$lang$maxFixedArity = 3;
G__9912.cljs$lang$applyTo = G__9912__4.cljs$lang$applyTo;
G__9912.cljs$core$IFn$_invoke$arity$0 = G__9912__0;
G__9912.cljs$core$IFn$_invoke$arity$1 = G__9912__1;
G__9912.cljs$core$IFn$_invoke$arity$2 = G__9912__2;
G__9912.cljs$core$IFn$_invoke$arity$3 = G__9912__3;
G__9912.cljs$core$IFn$_invoke$arity$variadic = G__9912__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9912;
})()
});
var partial__4 = (function (f,arg1,arg2,arg3){
return (function() {
var G__9918 = null;
var G__9918__0 = (function (){
var G__9888 = arg1;
var G__9889 = arg2;
var G__9890 = arg3;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9888,G__9889,G__9890) : f.call(null,G__9888,G__9889,G__9890));
});
var G__9918__1 = (function (x){
var G__9891 = arg1;
var G__9892 = arg2;
var G__9893 = arg3;
var G__9894 = x;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__9891,G__9892,G__9893,G__9894) : f.call(null,G__9891,G__9892,G__9893,G__9894));
});
var G__9918__2 = (function (x,y){
var G__9895 = arg1;
var G__9896 = arg2;
var G__9897 = arg3;
var G__9898 = x;
var G__9899 = y;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__9895,G__9896,G__9897,G__9898,G__9899) : f.call(null,G__9895,G__9896,G__9897,G__9898,G__9899));
});
var G__9918__3 = (function (x,y,z){
var G__9900 = arg1;
var G__9901 = arg2;
var G__9902 = arg3;
var G__9903 = x;
var G__9904 = y;
var G__9905 = z;
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(G__9900,G__9901,G__9902,G__9903,G__9904,G__9905) : f.call(null,G__9900,G__9901,G__9902,G__9903,G__9904,G__9905));
});
var G__9918__4 = (function() { 
var G__9919__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,arg3,x,cljs.core.array_seq([y,z,args], 0));
};
var G__9919 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9920__i = 0, G__9920__a = new Array(arguments.length -  3);
while (G__9920__i < G__9920__a.length) {G__9920__a[G__9920__i] = arguments[G__9920__i + 3]; ++G__9920__i;}
  args = new cljs.core.IndexedSeq(G__9920__a,0);
} 
return G__9919__delegate.call(this,x,y,z,args);};
G__9919.cljs$lang$maxFixedArity = 3;
G__9919.cljs$lang$applyTo = (function (arglist__9921){
var x = cljs.core.first(arglist__9921);
arglist__9921 = cljs.core.next(arglist__9921);
var y = cljs.core.first(arglist__9921);
arglist__9921 = cljs.core.next(arglist__9921);
var z = cljs.core.first(arglist__9921);
var args = cljs.core.rest(arglist__9921);
return G__9919__delegate(x,y,z,args);
});
G__9919.cljs$core$IFn$_invoke$arity$variadic = G__9919__delegate;
return G__9919;
})()
;
G__9918 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__9918__0.call(this);
case 1:
return G__9918__1.call(this,x);
case 2:
return G__9918__2.call(this,x,y);
case 3:
return G__9918__3.call(this,x,y,z);
default:
var G__9922 = null;
if (arguments.length > 3) {
var G__9923__i = 0, G__9923__a = new Array(arguments.length -  3);
while (G__9923__i < G__9923__a.length) {G__9923__a[G__9923__i] = arguments[G__9923__i + 3]; ++G__9923__i;}
G__9922 = new cljs.core.IndexedSeq(G__9923__a,0);
}
return G__9918__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9922);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9918.cljs$lang$maxFixedArity = 3;
G__9918.cljs$lang$applyTo = G__9918__4.cljs$lang$applyTo;
G__9918.cljs$core$IFn$_invoke$arity$0 = G__9918__0;
G__9918.cljs$core$IFn$_invoke$arity$1 = G__9918__1;
G__9918.cljs$core$IFn$_invoke$arity$2 = G__9918__2;
G__9918.cljs$core$IFn$_invoke$arity$3 = G__9918__3;
G__9918.cljs$core$IFn$_invoke$arity$variadic = G__9918__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9918;
})()
});
var partial__5 = (function() { 
var G__9924__delegate = function (f,arg1,arg2,arg3,more){
return (function() { 
var G__9925__delegate = function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,arg1,arg2,arg3,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more,args));
};
var G__9925 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__9926__i = 0, G__9926__a = new Array(arguments.length -  0);
while (G__9926__i < G__9926__a.length) {G__9926__a[G__9926__i] = arguments[G__9926__i + 0]; ++G__9926__i;}
  args = new cljs.core.IndexedSeq(G__9926__a,0);
} 
return G__9925__delegate.call(this,args);};
G__9925.cljs$lang$maxFixedArity = 0;
G__9925.cljs$lang$applyTo = (function (arglist__9927){
var args = cljs.core.seq(arglist__9927);
return G__9925__delegate(args);
});
G__9925.cljs$core$IFn$_invoke$arity$variadic = G__9925__delegate;
return G__9925;
})()
;
};
var G__9924 = function (f,arg1,arg2,arg3,var_args){
var more = null;
if (arguments.length > 4) {
var G__9928__i = 0, G__9928__a = new Array(arguments.length -  4);
while (G__9928__i < G__9928__a.length) {G__9928__a[G__9928__i] = arguments[G__9928__i + 4]; ++G__9928__i;}
  more = new cljs.core.IndexedSeq(G__9928__a,0);
} 
return G__9924__delegate.call(this,f,arg1,arg2,arg3,more);};
G__9924.cljs$lang$maxFixedArity = 4;
G__9924.cljs$lang$applyTo = (function (arglist__9929){
var f = cljs.core.first(arglist__9929);
arglist__9929 = cljs.core.next(arglist__9929);
var arg1 = cljs.core.first(arglist__9929);
arglist__9929 = cljs.core.next(arglist__9929);
var arg2 = cljs.core.first(arglist__9929);
arglist__9929 = cljs.core.next(arglist__9929);
var arg3 = cljs.core.first(arglist__9929);
var more = cljs.core.rest(arglist__9929);
return G__9924__delegate(f,arg1,arg2,arg3,more);
});
G__9924.cljs$core$IFn$_invoke$arity$variadic = G__9924__delegate;
return G__9924;
})()
;
partial = function(f,arg1,arg2,arg3,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return partial__1.call(this,f);
case 2:
return partial__2.call(this,f,arg1);
case 3:
return partial__3.call(this,f,arg1,arg2);
case 4:
return partial__4.call(this,f,arg1,arg2,arg3);
default:
var G__9930 = null;
if (arguments.length > 4) {
var G__9931__i = 0, G__9931__a = new Array(arguments.length -  4);
while (G__9931__i < G__9931__a.length) {G__9931__a[G__9931__i] = arguments[G__9931__i + 4]; ++G__9931__i;}
G__9930 = new cljs.core.IndexedSeq(G__9931__a,0);
}
return partial__5.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,arg3, G__9930);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partial.cljs$lang$maxFixedArity = 4;
partial.cljs$lang$applyTo = partial__5.cljs$lang$applyTo;
partial.cljs$core$IFn$_invoke$arity$1 = partial__1;
partial.cljs$core$IFn$_invoke$arity$2 = partial__2;
partial.cljs$core$IFn$_invoke$arity$3 = partial__3;
partial.cljs$core$IFn$_invoke$arity$4 = partial__4;
partial.cljs$core$IFn$_invoke$arity$variadic = partial__5.cljs$core$IFn$_invoke$arity$variadic;
return partial;
})()
;
/**
* Takes a function f, and returns a function that calls f, replacing
* a nil first argument to f with the supplied value x. Higher arity
* versions can replace arguments in the second and third
* positions (y, z). Note that the function f can take any number of
* arguments, not just the one(s) being nil-patched.
*/
cljs.core.fnil = (function() {
var fnil = null;
var fnil__2 = (function (f,x){
return (function() {
var G__9964 = null;
var G__9964__1 = (function (a){
var G__9948 = (((a == null))?x:a);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9948) : f.call(null,G__9948));
});
var G__9964__2 = (function (a,b){
var G__9949 = (((a == null))?x:a);
var G__9950 = b;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9949,G__9950) : f.call(null,G__9949,G__9950));
});
var G__9964__3 = (function (a,b,c){
var G__9951 = (((a == null))?x:a);
var G__9952 = b;
var G__9953 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9951,G__9952,G__9953) : f.call(null,G__9951,G__9952,G__9953));
});
var G__9964__4 = (function() { 
var G__9965__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),b,c,ds);
};
var G__9965 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__9966__i = 0, G__9966__a = new Array(arguments.length -  3);
while (G__9966__i < G__9966__a.length) {G__9966__a[G__9966__i] = arguments[G__9966__i + 3]; ++G__9966__i;}
  ds = new cljs.core.IndexedSeq(G__9966__a,0);
} 
return G__9965__delegate.call(this,a,b,c,ds);};
G__9965.cljs$lang$maxFixedArity = 3;
G__9965.cljs$lang$applyTo = (function (arglist__9967){
var a = cljs.core.first(arglist__9967);
arglist__9967 = cljs.core.next(arglist__9967);
var b = cljs.core.first(arglist__9967);
arglist__9967 = cljs.core.next(arglist__9967);
var c = cljs.core.first(arglist__9967);
var ds = cljs.core.rest(arglist__9967);
return G__9965__delegate(a,b,c,ds);
});
G__9965.cljs$core$IFn$_invoke$arity$variadic = G__9965__delegate;
return G__9965;
})()
;
G__9964 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 1:
return G__9964__1.call(this,a);
case 2:
return G__9964__2.call(this,a,b);
case 3:
return G__9964__3.call(this,a,b,c);
default:
var G__9968 = null;
if (arguments.length > 3) {
var G__9969__i = 0, G__9969__a = new Array(arguments.length -  3);
while (G__9969__i < G__9969__a.length) {G__9969__a[G__9969__i] = arguments[G__9969__i + 3]; ++G__9969__i;}
G__9968 = new cljs.core.IndexedSeq(G__9969__a,0);
}
return G__9964__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__9968);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9964.cljs$lang$maxFixedArity = 3;
G__9964.cljs$lang$applyTo = G__9964__4.cljs$lang$applyTo;
G__9964.cljs$core$IFn$_invoke$arity$1 = G__9964__1;
G__9964.cljs$core$IFn$_invoke$arity$2 = G__9964__2;
G__9964.cljs$core$IFn$_invoke$arity$3 = G__9964__3;
G__9964.cljs$core$IFn$_invoke$arity$variadic = G__9964__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9964;
})()
});
var fnil__3 = (function (f,x,y){
return (function() {
var G__9970 = null;
var G__9970__2 = (function (a,b){
var G__9954 = (((a == null))?x:a);
var G__9955 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9954,G__9955) : f.call(null,G__9954,G__9955));
});
var G__9970__3 = (function (a,b,c){
var G__9956 = (((a == null))?x:a);
var G__9957 = (((b == null))?y:b);
var G__9958 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9956,G__9957,G__9958) : f.call(null,G__9956,G__9957,G__9958));
});
var G__9970__4 = (function() { 
var G__9971__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),c,ds);
};
var G__9971 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__9972__i = 0, G__9972__a = new Array(arguments.length -  3);
while (G__9972__i < G__9972__a.length) {G__9972__a[G__9972__i] = arguments[G__9972__i + 3]; ++G__9972__i;}
  ds = new cljs.core.IndexedSeq(G__9972__a,0);
} 
return G__9971__delegate.call(this,a,b,c,ds);};
G__9971.cljs$lang$maxFixedArity = 3;
G__9971.cljs$lang$applyTo = (function (arglist__9973){
var a = cljs.core.first(arglist__9973);
arglist__9973 = cljs.core.next(arglist__9973);
var b = cljs.core.first(arglist__9973);
arglist__9973 = cljs.core.next(arglist__9973);
var c = cljs.core.first(arglist__9973);
var ds = cljs.core.rest(arglist__9973);
return G__9971__delegate(a,b,c,ds);
});
G__9971.cljs$core$IFn$_invoke$arity$variadic = G__9971__delegate;
return G__9971;
})()
;
G__9970 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__9970__2.call(this,a,b);
case 3:
return G__9970__3.call(this,a,b,c);
default:
var G__9974 = null;
if (arguments.length > 3) {
var G__9975__i = 0, G__9975__a = new Array(arguments.length -  3);
while (G__9975__i < G__9975__a.length) {G__9975__a[G__9975__i] = arguments[G__9975__i + 3]; ++G__9975__i;}
G__9974 = new cljs.core.IndexedSeq(G__9975__a,0);
}
return G__9970__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__9974);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9970.cljs$lang$maxFixedArity = 3;
G__9970.cljs$lang$applyTo = G__9970__4.cljs$lang$applyTo;
G__9970.cljs$core$IFn$_invoke$arity$2 = G__9970__2;
G__9970.cljs$core$IFn$_invoke$arity$3 = G__9970__3;
G__9970.cljs$core$IFn$_invoke$arity$variadic = G__9970__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9970;
})()
});
var fnil__4 = (function (f,x,y,z){
return (function() {
var G__9976 = null;
var G__9976__2 = (function (a,b){
var G__9959 = (((a == null))?x:a);
var G__9960 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9959,G__9960) : f.call(null,G__9959,G__9960));
});
var G__9976__3 = (function (a,b,c){
var G__9961 = (((a == null))?x:a);
var G__9962 = (((b == null))?y:b);
var G__9963 = (((c == null))?z:c);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9961,G__9962,G__9963) : f.call(null,G__9961,G__9962,G__9963));
});
var G__9976__4 = (function() { 
var G__9977__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),(((c == null))?z:c),ds);
};
var G__9977 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__9978__i = 0, G__9978__a = new Array(arguments.length -  3);
while (G__9978__i < G__9978__a.length) {G__9978__a[G__9978__i] = arguments[G__9978__i + 3]; ++G__9978__i;}
  ds = new cljs.core.IndexedSeq(G__9978__a,0);
} 
return G__9977__delegate.call(this,a,b,c,ds);};
G__9977.cljs$lang$maxFixedArity = 3;
G__9977.cljs$lang$applyTo = (function (arglist__9979){
var a = cljs.core.first(arglist__9979);
arglist__9979 = cljs.core.next(arglist__9979);
var b = cljs.core.first(arglist__9979);
arglist__9979 = cljs.core.next(arglist__9979);
var c = cljs.core.first(arglist__9979);
var ds = cljs.core.rest(arglist__9979);
return G__9977__delegate(a,b,c,ds);
});
G__9977.cljs$core$IFn$_invoke$arity$variadic = G__9977__delegate;
return G__9977;
})()
;
G__9976 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__9976__2.call(this,a,b);
case 3:
return G__9976__3.call(this,a,b,c);
default:
var G__9980 = null;
if (arguments.length > 3) {
var G__9981__i = 0, G__9981__a = new Array(arguments.length -  3);
while (G__9981__i < G__9981__a.length) {G__9981__a[G__9981__i] = arguments[G__9981__i + 3]; ++G__9981__i;}
G__9980 = new cljs.core.IndexedSeq(G__9981__a,0);
}
return G__9976__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__9980);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9976.cljs$lang$maxFixedArity = 3;
G__9976.cljs$lang$applyTo = G__9976__4.cljs$lang$applyTo;
G__9976.cljs$core$IFn$_invoke$arity$2 = G__9976__2;
G__9976.cljs$core$IFn$_invoke$arity$3 = G__9976__3;
G__9976.cljs$core$IFn$_invoke$arity$variadic = G__9976__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9976;
})()
});
fnil = function(f,x,y,z){
switch(arguments.length){
case 2:
return fnil__2.call(this,f,x);
case 3:
return fnil__3.call(this,f,x,y);
case 4:
return fnil__4.call(this,f,x,y,z);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fnil.cljs$core$IFn$_invoke$arity$2 = fnil__2;
fnil.cljs$core$IFn$_invoke$arity$3 = fnil__3;
fnil.cljs$core$IFn$_invoke$arity$4 = fnil__4;
return fnil;
})()
;
/**
* Returns a lazy sequence consisting of the result of applying f to 0
* and the first item of coll, followed by applying f to 1 and the second
* item in coll, etc, until coll is exhausted. Thus function f should
* accept 2 arguments, index and item.
*/
cljs.core.map_indexed = (function() {
var map_indexed = null;
var map_indexed__1 = (function (f){
return (function (rf){
var i = (function (){var G__10012 = (-1);
return (cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1 ? cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1(G__10012) : cljs.core.volatile_BANG_.call(null,G__10012));
})();
return ((function (i){
return (function() {
var G__10042 = null;
var G__10042__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__10042__1 = (function (result){
var G__10013 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__10013) : rf.call(null,G__10013));
});
var G__10042__2 = (function (result,input){
var G__10014 = result;
var G__10015 = (function (){var G__10016 = cljs.core._vreset_BANG_(i,(cljs.core._deref(i) + (1)));
var G__10017 = input;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10016,G__10017) : f.call(null,G__10016,G__10017));
})();
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10014,G__10015) : rf.call(null,G__10014,G__10015));
});
G__10042 = function(result,input){
switch(arguments.length){
case 0:
return G__10042__0.call(this);
case 1:
return G__10042__1.call(this,result);
case 2:
return G__10042__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10042.cljs$core$IFn$_invoke$arity$0 = G__10042__0;
G__10042.cljs$core$IFn$_invoke$arity$1 = G__10042__1;
G__10042.cljs$core$IFn$_invoke$arity$2 = G__10042__2;
return G__10042;
})()
;})(i))
});
});
var map_indexed__2 = (function (f,coll){
var mapi = (function mapi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll__$1);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4645__auto___10043 = size;
var i_10044 = (0);
while(true){
if((i_10044 < n__4645__auto___10043)){
cljs.core.chunk_append(b,(function (){var G__10038 = (idx + i_10044);
var G__10039 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_10044);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10038,G__10039) : f.call(null,G__10038,G__10039));
})());

var G__10045 = (i_10044 + (1));
i_10044 = G__10045;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),mapi((idx + size),cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__10040 = idx;
var G__10041 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10040,G__10041) : f.call(null,G__10040,G__10041));
})(),mapi((idx + (1)),cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});
return mapi((0),coll);
});
map_indexed = function(f,coll){
switch(arguments.length){
case 1:
return map_indexed__1.call(this,f);
case 2:
return map_indexed__2.call(this,f,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
map_indexed.cljs$core$IFn$_invoke$arity$1 = map_indexed__1;
map_indexed.cljs$core$IFn$_invoke$arity$2 = map_indexed__2;
return map_indexed;
})()
;
/**
* Returns a lazy sequence of the non-nil results of (f item). Note,
* this means false return values will be included.  f must be free of
* side-effects.  Returns a transducer when no collection is provided.
*/
cljs.core.keep = (function() {
var keep = null;
var keep__1 = (function (f){
return (function (rf){
return (function() {
var G__10064 = null;
var G__10064__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__10064__1 = (function (result){
var G__10058 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__10058) : rf.call(null,G__10058));
});
var G__10064__2 = (function (result,input){
var v = (function (){var G__10059 = input;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10059) : f.call(null,G__10059));
})();
if((v == null)){
return result;
} else {
var G__10060 = result;
var G__10061 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10060,G__10061) : rf.call(null,G__10060,G__10061));
}
});
G__10064 = function(result,input){
switch(arguments.length){
case 0:
return G__10064__0.call(this);
case 1:
return G__10064__1.call(this,result);
case 2:
return G__10064__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10064.cljs$core$IFn$_invoke$arity$0 = G__10064__0;
G__10064.cljs$core$IFn$_invoke$arity$1 = G__10064__1;
G__10064.cljs$core$IFn$_invoke$arity$2 = G__10064__2;
return G__10064;
})()
});
});
var keep__2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4645__auto___10065 = size;
var i_10066 = (0);
while(true){
if((i_10066 < n__4645__auto___10065)){
var x_10067 = (function (){var G__10062 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_10066);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10062) : f.call(null,G__10062));
})();
if((x_10067 == null)){
} else {
cljs.core.chunk_append(b,x_10067);
}

var G__10068 = (i_10066 + (1));
i_10066 = G__10068;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__10063 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10063) : f.call(null,G__10063));
})();
if((x == null)){
return keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s));
} else {
return cljs.core.cons(x,keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});
keep = function(f,coll){
switch(arguments.length){
case 1:
return keep__1.call(this,f);
case 2:
return keep__2.call(this,f,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
keep.cljs$core$IFn$_invoke$arity$1 = keep__1;
keep.cljs$core$IFn$_invoke$arity$2 = keep__2;
return keep;
})()
;

/**
* @constructor
*/
cljs.core.Atom = (function (state,meta,validator,watches){
this.state = state;
this.meta = meta;
this.validator = validator;
this.watches = watches;
this.cljs$lang$protocol_mask$partition0$ = 6455296;
this.cljs$lang$protocol_mask$partition1$ = 16386;
})
cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var G__10069 = this$__$1;
return goog.getUid(G__10069);
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){
var self__ = this;
var this$__$1 = this;
var seq__10070 = cljs.core.seq(self__.watches);
var chunk__10071 = null;
var count__10072 = (0);
var i__10073 = (0);
while(true){
if((i__10073 < count__10072)){
var vec__10074 = chunk__10071.cljs$core$IIndexed$_nth$arity$2(null,i__10073);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10074,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10074,(1),null);
var G__10075_10084 = key;
var G__10076_10085 = this$__$1;
var G__10077_10086 = oldval;
var G__10078_10087 = newval;
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__10075_10084,G__10076_10085,G__10077_10086,G__10078_10087) : f.call(null,G__10075_10084,G__10076_10085,G__10077_10086,G__10078_10087));

var G__10088 = seq__10070;
var G__10089 = chunk__10071;
var G__10090 = count__10072;
var G__10091 = (i__10073 + (1));
seq__10070 = G__10088;
chunk__10071 = G__10089;
count__10072 = G__10090;
i__10073 = G__10091;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__10070);
if(temp__4126__auto__){
var seq__10070__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10070__$1)){
var c__4545__auto__ = cljs.core.chunk_first(seq__10070__$1);
var G__10092 = cljs.core.chunk_rest(seq__10070__$1);
var G__10093 = c__4545__auto__;
var G__10094 = cljs.core.count(c__4545__auto__);
var G__10095 = (0);
seq__10070 = G__10092;
chunk__10071 = G__10093;
count__10072 = G__10094;
i__10073 = G__10095;
continue;
} else {
var vec__10079 = cljs.core.first(seq__10070__$1);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10079,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10079,(1),null);
var G__10080_10096 = key;
var G__10081_10097 = this$__$1;
var G__10082_10098 = oldval;
var G__10083_10099 = newval;
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__10080_10096,G__10081_10097,G__10082_10098,G__10083_10099) : f.call(null,G__10080_10096,G__10081_10097,G__10082_10098,G__10083_10099));

var G__10100 = cljs.core.next(seq__10070__$1);
var G__10101 = null;
var G__10102 = (0);
var G__10103 = (0);
seq__10070 = G__10100;
chunk__10071 = G__10101;
count__10072 = G__10102;
i__10073 = G__10103;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key,f){
var self__ = this;
var this$__$1 = this;
this$__$1.watches = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches,key,f);

return this$__$1;
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
return this$__$1.watches = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches,key);
});

cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
});

cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
});

cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return (o__$1 === other);
});

cljs.core.Atom.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Atom.cljs$lang$type = true;

cljs.core.Atom.cljs$lang$ctorStr = "cljs.core/Atom";

cljs.core.Atom.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/Atom");
});

cljs.core.__GT_Atom = (function __GT_Atom(state,meta,validator,watches){
return (new cljs.core.Atom(state,meta,validator,watches));
});

/**
* Creates and returns an Atom with an initial value of x and zero or
* more options (in any order):
* 
* :meta metadata-map
* 
* :validator validate-fn
* 
* If metadata-map is supplied, it will be come the metadata on the
* atom. validate-fn must be nil or a side-effect-free fn of one
* argument, which will be passed the intended new state on any state
* change. If the new state is unacceptable, the validate-fn should
* return false or throw an Error.  If either of these error conditions
* occur, then the value of the atom will not change.
* @param {...*} var_args
*/
cljs.core.atom = (function() {
var atom = null;
var atom__1 = (function (x){
return (new cljs.core.Atom(x,null,null,null));
});
var atom__2 = (function() { 
var G__10107__delegate = function (x,p__10104){
var map__10106 = p__10104;
var map__10106__$1 = ((cljs.core.seq_QMARK_(map__10106))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10106):map__10106);
var validator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10106__$1,new cljs.core.Keyword(null,"validator","validator",-1966190681));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10106__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
return (new cljs.core.Atom(x,meta,validator,null));
};
var G__10107 = function (x,var_args){
var p__10104 = null;
if (arguments.length > 1) {
var G__10108__i = 0, G__10108__a = new Array(arguments.length -  1);
while (G__10108__i < G__10108__a.length) {G__10108__a[G__10108__i] = arguments[G__10108__i + 1]; ++G__10108__i;}
  p__10104 = new cljs.core.IndexedSeq(G__10108__a,0);
} 
return G__10107__delegate.call(this,x,p__10104);};
G__10107.cljs$lang$maxFixedArity = 1;
G__10107.cljs$lang$applyTo = (function (arglist__10109){
var x = cljs.core.first(arglist__10109);
var p__10104 = cljs.core.rest(arglist__10109);
return G__10107__delegate(x,p__10104);
});
G__10107.cljs$core$IFn$_invoke$arity$variadic = G__10107__delegate;
return G__10107;
})()
;
atom = function(x,var_args){
var p__10104 = var_args;
switch(arguments.length){
case 1:
return atom__1.call(this,x);
default:
var G__10110 = null;
if (arguments.length > 1) {
var G__10111__i = 0, G__10111__a = new Array(arguments.length -  1);
while (G__10111__i < G__10111__a.length) {G__10111__a[G__10111__i] = arguments[G__10111__i + 1]; ++G__10111__i;}
G__10110 = new cljs.core.IndexedSeq(G__10111__a,0);
}
return atom__2.cljs$core$IFn$_invoke$arity$variadic(x, G__10110);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
atom.cljs$lang$maxFixedArity = 1;
atom.cljs$lang$applyTo = atom__2.cljs$lang$applyTo;
atom.cljs$core$IFn$_invoke$arity$1 = atom__1;
atom.cljs$core$IFn$_invoke$arity$variadic = atom__2.cljs$core$IFn$_invoke$arity$variadic;
return atom;
})()
;
/**
* Sets the value of atom to newval without regard for the
* current value. Returns newval.
*/
cljs.core.reset_BANG_ = (function reset_BANG_(a,new_value){
if((a instanceof cljs.core.Atom)){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_((function (){var G__10114 = new_value;
return (validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(G__10114) : validate.call(null,G__10114));
})())){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Validator rejected reference state"),cljs.core.str("\n"),cljs.core.str((function (){var G__10115 = cljs.core.list(new cljs.core.Symbol(null,"validate","validate",1439230700,null),new cljs.core.Symbol(null,"new-value","new-value",-1567397401,null));
return (cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1 ? cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1(G__10115) : cljs.core.pr_str.call(null,G__10115));
})())].join('')));
}
}

var old_value = a.state;
a.state = new_value;

if((a.watches == null)){
} else {
cljs.core._notify_watches(a,old_value,new_value);
}

return new_value;
} else {
return cljs.core._reset_BANG_(a,new_value);
}
});
/**
* Atomically swaps the value of atom to be:
* (apply f current-value-of-atom args). Note that f may be called
* multiple times, and thus should be free of side effects.  Returns
* the value that was swapped in.
* @param {...*} var_args
*/
cljs.core.swap_BANG_ = (function() {
var swap_BANG_ = null;
var swap_BANG___2 = (function (a,f){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__10122 = a.state;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10122) : f.call(null,G__10122));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a,f);
}
});
var swap_BANG___3 = (function (a,f,x){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__10123 = a.state;
var G__10124 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10123,G__10124) : f.call(null,G__10123,G__10124));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a,f,x);
}
});
var swap_BANG___4 = (function (a,f,x,y){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__10125 = a.state;
var G__10126 = x;
var G__10127 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10125,G__10126,G__10127) : f.call(null,G__10125,G__10126,G__10127));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,f,x,y);
}
});
var swap_BANG___5 = (function() { 
var G__10128__delegate = function (a,f,x,y,more){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a.state,x,y,more));
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a,f,x,y,more);
}
};
var G__10128 = function (a,f,x,y,var_args){
var more = null;
if (arguments.length > 4) {
var G__10129__i = 0, G__10129__a = new Array(arguments.length -  4);
while (G__10129__i < G__10129__a.length) {G__10129__a[G__10129__i] = arguments[G__10129__i + 4]; ++G__10129__i;}
  more = new cljs.core.IndexedSeq(G__10129__a,0);
} 
return G__10128__delegate.call(this,a,f,x,y,more);};
G__10128.cljs$lang$maxFixedArity = 4;
G__10128.cljs$lang$applyTo = (function (arglist__10130){
var a = cljs.core.first(arglist__10130);
arglist__10130 = cljs.core.next(arglist__10130);
var f = cljs.core.first(arglist__10130);
arglist__10130 = cljs.core.next(arglist__10130);
var x = cljs.core.first(arglist__10130);
arglist__10130 = cljs.core.next(arglist__10130);
var y = cljs.core.first(arglist__10130);
var more = cljs.core.rest(arglist__10130);
return G__10128__delegate(a,f,x,y,more);
});
G__10128.cljs$core$IFn$_invoke$arity$variadic = G__10128__delegate;
return G__10128;
})()
;
swap_BANG_ = function(a,f,x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return swap_BANG___2.call(this,a,f);
case 3:
return swap_BANG___3.call(this,a,f,x);
case 4:
return swap_BANG___4.call(this,a,f,x,y);
default:
var G__10131 = null;
if (arguments.length > 4) {
var G__10132__i = 0, G__10132__a = new Array(arguments.length -  4);
while (G__10132__i < G__10132__a.length) {G__10132__a[G__10132__i] = arguments[G__10132__i + 4]; ++G__10132__i;}
G__10131 = new cljs.core.IndexedSeq(G__10132__a,0);
}
return swap_BANG___5.cljs$core$IFn$_invoke$arity$variadic(a,f,x,y, G__10131);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
swap_BANG_.cljs$lang$maxFixedArity = 4;
swap_BANG_.cljs$lang$applyTo = swap_BANG___5.cljs$lang$applyTo;
swap_BANG_.cljs$core$IFn$_invoke$arity$2 = swap_BANG___2;
swap_BANG_.cljs$core$IFn$_invoke$arity$3 = swap_BANG___3;
swap_BANG_.cljs$core$IFn$_invoke$arity$4 = swap_BANG___4;
swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = swap_BANG___5.cljs$core$IFn$_invoke$arity$variadic;
return swap_BANG_;
})()
;
/**
* Atomically sets the value of atom to newval if and only if the
* current value of the atom is equal to oldval. Returns true if
* set happened, else false.
*/
cljs.core.compare_and_set_BANG_ = (function compare_and_set_BANG_(a,oldval,newval){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a.cljs$core$IDeref$_deref$arity$1(null),oldval)){
cljs.core.reset_BANG_(a,newval);

return true;
} else {
return false;
}
});
/**
* Sets the validator-fn for an atom. validator-fn must be nil or a
* side-effect-free fn of one argument, which will be passed the intended
* new state on any state change. If the new state is unacceptable, the
* validator-fn should return false or throw an Error. If the current state
* is not acceptable to the new validator, an Error will be thrown and the
* validator will not be changed.
*/
cljs.core.set_validator_BANG_ = (function set_validator_BANG_(iref,val){
return iref.validator = val;
});
/**
* Gets the validator-fn for a var/ref/agent/atom.
*/
cljs.core.get_validator = (function get_validator(iref){
return iref.validator;
});

/**
* @constructor
*/
cljs.core.Volatile = (function (state){
this.state = state;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32768;
})
cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
});

cljs.core.Volatile.prototype.cljs$core$IVolatile$ = true;

cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2 = (function (_,new_state){
var self__ = this;
var ___$1 = this;
return self__.state = new_state;
});

cljs.core.Volatile.cljs$lang$type = true;

cljs.core.Volatile.cljs$lang$ctorStr = "cljs.core/Volatile";

cljs.core.Volatile.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/Volatile");
});

cljs.core.__GT_Volatile = (function __GT_Volatile(state){
return (new cljs.core.Volatile(state));
});

/**
* Creates and returns a Volatile with an initial value of val.
*/
cljs.core.volatile_BANG_ = (function volatile_BANG_(val){
return (new cljs.core.Volatile(val));
});
/**
* Returns true if x is a volatile.
*/
cljs.core.volatile_QMARK_ = (function volatile_QMARK_(x){
return (x instanceof cljs.core.Volatile);
});
/**
* Sets the value of volatile to newval without regard for the
* current value. Returns newval.
*/
cljs.core.vreset_BANG_ = (function vreset_BANG_(vol,newval){
return cljs.core._vreset_BANG_(vol,newval);
});
/**
* Returns a lazy sequence of the non-nil results of (f index item). Note,
* this means false return values will be included.  f must be free of
* side-effects.  Returns a stateful transducer when no collection is
* provided.
*/
cljs.core.keep_indexed = (function() {
var keep_indexed = null;
var keep_indexed__1 = (function (f){
return (function (rf){
var ia = cljs.core.volatile_BANG_((-1));
return ((function (ia){
return (function() {
var G__10199 = null;
var G__10199__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__10199__1 = (function (result){
var G__10166 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__10166) : rf.call(null,G__10166));
});
var G__10199__2 = (function (result,input){
var i = ia.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(ia.cljs$core$IDeref$_deref$arity$1(null) + (1)));
var v = (function (){var G__10167 = i;
var G__10168 = input;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10167,G__10168) : f.call(null,G__10167,G__10168));
})();
if((v == null)){
return result;
} else {
var G__10169 = result;
var G__10170 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10169,G__10170) : rf.call(null,G__10169,G__10170));
}
});
G__10199 = function(result,input){
switch(arguments.length){
case 0:
return G__10199__0.call(this);
case 1:
return G__10199__1.call(this,result);
case 2:
return G__10199__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10199.cljs$core$IFn$_invoke$arity$0 = G__10199__0;
G__10199.cljs$core$IFn$_invoke$arity$1 = G__10199__1;
G__10199.cljs$core$IFn$_invoke$arity$2 = G__10199__2;
return G__10199;
})()
;})(ia))
});
});
var keep_indexed__2 = (function (f,coll){
var keepi = (function keepi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll__$1);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4645__auto___10200 = size;
var i_10201 = (0);
while(true){
if((i_10201 < n__4645__auto___10200)){
var x_10202 = (function (){var G__10195 = (idx + i_10201);
var G__10196 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_10201);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10195,G__10196) : f.call(null,G__10195,G__10196));
})();
if((x_10202 == null)){
} else {
cljs.core.chunk_append(b,x_10202);
}

var G__10203 = (i_10201 + (1));
i_10201 = G__10203;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),keepi((idx + size),cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__10197 = idx;
var G__10198 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10197,G__10198) : f.call(null,G__10197,G__10198));
})();
if((x == null)){
return keepi((idx + (1)),cljs.core.rest(s));
} else {
return cljs.core.cons(x,keepi((idx + (1)),cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});
return keepi((0),coll);
});
keep_indexed = function(f,coll){
switch(arguments.length){
case 1:
return keep_indexed__1.call(this,f);
case 2:
return keep_indexed__2.call(this,f,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
keep_indexed.cljs$core$IFn$_invoke$arity$1 = keep_indexed__1;
keep_indexed.cljs$core$IFn$_invoke$arity$2 = keep_indexed__2;
return keep_indexed;
})()
;
/**
* Takes a set of predicates and returns a function f that returns true if all of its
* composing predicates return a logical true value against all of its arguments, else it returns
* false. Note that f is short-circuiting in that it will stop execution on the first
* argument that triggers a logical false result against the original predicates.
* @param {...*} var_args
*/
cljs.core.every_pred = (function() {
var every_pred = null;
var every_pred__1 = (function (p){
return (function() {
var ep1 = null;
var ep1__0 = (function (){
return true;
});
var ep1__1 = (function (x){
return cljs.core.boolean$((function (){var G__10417 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__10417) : p.call(null,G__10417));
})());
});
var ep1__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__3746__auto__ = (function (){var G__10419 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__10419) : p.call(null,G__10419));
})();
if(cljs.core.truth_(and__3746__auto__)){
var G__10420 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__10420) : p.call(null,G__10420));
} else {
return and__3746__auto__;
}
})());
});
var ep1__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__3746__auto__ = (function (){var G__10422 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__10422) : p.call(null,G__10422));
})();
if(cljs.core.truth_(and__3746__auto__)){
var and__3746__auto____$1 = (function (){var G__10424 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__10424) : p.call(null,G__10424));
})();
if(cljs.core.truth_(and__3746__auto____$1)){
var G__10425 = z;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__10425) : p.call(null,G__10425));
} else {
return and__3746__auto____$1;
}
} else {
return and__3746__auto__;
}
})());
});
var ep1__4 = (function() { 
var G__10594__delegate = function (x,y,z,args){
return cljs.core.boolean$((ep1.cljs$core$IFn$_invoke$arity$3(x,y,z)) && (cljs.core.every_QMARK_(p,args)));
};
var G__10594 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__10595__i = 0, G__10595__a = new Array(arguments.length -  3);
while (G__10595__i < G__10595__a.length) {G__10595__a[G__10595__i] = arguments[G__10595__i + 3]; ++G__10595__i;}
  args = new cljs.core.IndexedSeq(G__10595__a,0);
} 
return G__10594__delegate.call(this,x,y,z,args);};
G__10594.cljs$lang$maxFixedArity = 3;
G__10594.cljs$lang$applyTo = (function (arglist__10596){
var x = cljs.core.first(arglist__10596);
arglist__10596 = cljs.core.next(arglist__10596);
var y = cljs.core.first(arglist__10596);
arglist__10596 = cljs.core.next(arglist__10596);
var z = cljs.core.first(arglist__10596);
var args = cljs.core.rest(arglist__10596);
return G__10594__delegate(x,y,z,args);
});
G__10594.cljs$core$IFn$_invoke$arity$variadic = G__10594__delegate;
return G__10594;
})()
;
ep1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return ep1__0.call(this);
case 1:
return ep1__1.call(this,x);
case 2:
return ep1__2.call(this,x,y);
case 3:
return ep1__3.call(this,x,y,z);
default:
var G__10597 = null;
if (arguments.length > 3) {
var G__10598__i = 0, G__10598__a = new Array(arguments.length -  3);
while (G__10598__i < G__10598__a.length) {G__10598__a[G__10598__i] = arguments[G__10598__i + 3]; ++G__10598__i;}
G__10597 = new cljs.core.IndexedSeq(G__10598__a,0);
}
return ep1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__10597);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
ep1.cljs$lang$maxFixedArity = 3;
ep1.cljs$lang$applyTo = ep1__4.cljs$lang$applyTo;
ep1.cljs$core$IFn$_invoke$arity$0 = ep1__0;
ep1.cljs$core$IFn$_invoke$arity$1 = ep1__1;
ep1.cljs$core$IFn$_invoke$arity$2 = ep1__2;
ep1.cljs$core$IFn$_invoke$arity$3 = ep1__3;
ep1.cljs$core$IFn$_invoke$arity$variadic = ep1__4.cljs$core$IFn$_invoke$arity$variadic;
return ep1;
})()
});
var every_pred__2 = (function (p1,p2){
return (function() {
var ep2 = null;
var ep2__0 = (function (){
return true;
});
var ep2__1 = (function (x){
return cljs.core.boolean$((function (){var and__3746__auto__ = (function (){var G__10457 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10457) : p1.call(null,G__10457));
})();
if(cljs.core.truth_(and__3746__auto__)){
var G__10458 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10458) : p2.call(null,G__10458));
} else {
return and__3746__auto__;
}
})());
});
var ep2__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__3746__auto__ = (function (){var G__10460 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10460) : p1.call(null,G__10460));
})();
if(cljs.core.truth_(and__3746__auto__)){
var and__3746__auto____$1 = (function (){var G__10462 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10462) : p1.call(null,G__10462));
})();
if(cljs.core.truth_(and__3746__auto____$1)){
var and__3746__auto____$2 = (function (){var G__10464 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10464) : p2.call(null,G__10464));
})();
if(cljs.core.truth_(and__3746__auto____$2)){
var G__10465 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10465) : p2.call(null,G__10465));
} else {
return and__3746__auto____$2;
}
} else {
return and__3746__auto____$1;
}
} else {
return and__3746__auto__;
}
})());
});
var ep2__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__3746__auto__ = (function (){var G__10467 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10467) : p1.call(null,G__10467));
})();
if(cljs.core.truth_(and__3746__auto__)){
var and__3746__auto____$1 = (function (){var G__10469 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10469) : p1.call(null,G__10469));
})();
if(cljs.core.truth_(and__3746__auto____$1)){
var and__3746__auto____$2 = (function (){var G__10471 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10471) : p1.call(null,G__10471));
})();
if(cljs.core.truth_(and__3746__auto____$2)){
var and__3746__auto____$3 = (function (){var G__10473 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10473) : p2.call(null,G__10473));
})();
if(cljs.core.truth_(and__3746__auto____$3)){
var and__3746__auto____$4 = (function (){var G__10475 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10475) : p2.call(null,G__10475));
})();
if(cljs.core.truth_(and__3746__auto____$4)){
var G__10476 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10476) : p2.call(null,G__10476));
} else {
return and__3746__auto____$4;
}
} else {
return and__3746__auto____$3;
}
} else {
return and__3746__auto____$2;
}
} else {
return and__3746__auto____$1;
}
} else {
return and__3746__auto__;
}
})());
});
var ep2__4 = (function() { 
var G__10599__delegate = function (x,y,z,args){
return cljs.core.boolean$((ep2.cljs$core$IFn$_invoke$arity$3(x,y,z)) && (cljs.core.every_QMARK_((function (p1__10204_SHARP_){
var and__3746__auto__ = (function (){var G__10481 = p1__10204_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10481) : p1.call(null,G__10481));
})();
if(cljs.core.truth_(and__3746__auto__)){
var G__10482 = p1__10204_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10482) : p2.call(null,G__10482));
} else {
return and__3746__auto__;
}
}),args)));
};
var G__10599 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__10600__i = 0, G__10600__a = new Array(arguments.length -  3);
while (G__10600__i < G__10600__a.length) {G__10600__a[G__10600__i] = arguments[G__10600__i + 3]; ++G__10600__i;}
  args = new cljs.core.IndexedSeq(G__10600__a,0);
} 
return G__10599__delegate.call(this,x,y,z,args);};
G__10599.cljs$lang$maxFixedArity = 3;
G__10599.cljs$lang$applyTo = (function (arglist__10601){
var x = cljs.core.first(arglist__10601);
arglist__10601 = cljs.core.next(arglist__10601);
var y = cljs.core.first(arglist__10601);
arglist__10601 = cljs.core.next(arglist__10601);
var z = cljs.core.first(arglist__10601);
var args = cljs.core.rest(arglist__10601);
return G__10599__delegate(x,y,z,args);
});
G__10599.cljs$core$IFn$_invoke$arity$variadic = G__10599__delegate;
return G__10599;
})()
;
ep2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return ep2__0.call(this);
case 1:
return ep2__1.call(this,x);
case 2:
return ep2__2.call(this,x,y);
case 3:
return ep2__3.call(this,x,y,z);
default:
var G__10602 = null;
if (arguments.length > 3) {
var G__10603__i = 0, G__10603__a = new Array(arguments.length -  3);
while (G__10603__i < G__10603__a.length) {G__10603__a[G__10603__i] = arguments[G__10603__i + 3]; ++G__10603__i;}
G__10602 = new cljs.core.IndexedSeq(G__10603__a,0);
}
return ep2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__10602);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
ep2.cljs$lang$maxFixedArity = 3;
ep2.cljs$lang$applyTo = ep2__4.cljs$lang$applyTo;
ep2.cljs$core$IFn$_invoke$arity$0 = ep2__0;
ep2.cljs$core$IFn$_invoke$arity$1 = ep2__1;
ep2.cljs$core$IFn$_invoke$arity$2 = ep2__2;
ep2.cljs$core$IFn$_invoke$arity$3 = ep2__3;
ep2.cljs$core$IFn$_invoke$arity$variadic = ep2__4.cljs$core$IFn$_invoke$arity$variadic;
return ep2;
})()
});
var every_pred__3 = (function (p1,p2,p3){
return (function() {
var ep3 = null;
var ep3__0 = (function (){
return true;
});
var ep3__1 = (function (x){
return cljs.core.boolean$((function (){var and__3746__auto__ = (function (){var G__10528 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10528) : p1.call(null,G__10528));
})();
if(cljs.core.truth_(and__3746__auto__)){
var and__3746__auto____$1 = (function (){var G__10530 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10530) : p2.call(null,G__10530));
})();
if(cljs.core.truth_(and__3746__auto____$1)){
var G__10531 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10531) : p3.call(null,G__10531));
} else {
return and__3746__auto____$1;
}
} else {
return and__3746__auto__;
}
})());
});
var ep3__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__3746__auto__ = (function (){var G__10533 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10533) : p1.call(null,G__10533));
})();
if(cljs.core.truth_(and__3746__auto__)){
var and__3746__auto____$1 = (function (){var G__10535 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10535) : p2.call(null,G__10535));
})();
if(cljs.core.truth_(and__3746__auto____$1)){
var and__3746__auto____$2 = (function (){var G__10537 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10537) : p3.call(null,G__10537));
})();
if(cljs.core.truth_(and__3746__auto____$2)){
var and__3746__auto____$3 = (function (){var G__10539 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10539) : p1.call(null,G__10539));
})();
if(cljs.core.truth_(and__3746__auto____$3)){
var and__3746__auto____$4 = (function (){var G__10541 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10541) : p2.call(null,G__10541));
})();
if(cljs.core.truth_(and__3746__auto____$4)){
var G__10542 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10542) : p3.call(null,G__10542));
} else {
return and__3746__auto____$4;
}
} else {
return and__3746__auto____$3;
}
} else {
return and__3746__auto____$2;
}
} else {
return and__3746__auto____$1;
}
} else {
return and__3746__auto__;
}
})());
});
var ep3__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__3746__auto__ = (function (){var G__10544 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10544) : p1.call(null,G__10544));
})();
if(cljs.core.truth_(and__3746__auto__)){
var and__3746__auto____$1 = (function (){var G__10546 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10546) : p2.call(null,G__10546));
})();
if(cljs.core.truth_(and__3746__auto____$1)){
var and__3746__auto____$2 = (function (){var G__10548 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10548) : p3.call(null,G__10548));
})();
if(cljs.core.truth_(and__3746__auto____$2)){
var and__3746__auto____$3 = (function (){var G__10550 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10550) : p1.call(null,G__10550));
})();
if(cljs.core.truth_(and__3746__auto____$3)){
var and__3746__auto____$4 = (function (){var G__10552 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10552) : p2.call(null,G__10552));
})();
if(cljs.core.truth_(and__3746__auto____$4)){
var and__3746__auto____$5 = (function (){var G__10554 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10554) : p3.call(null,G__10554));
})();
if(cljs.core.truth_(and__3746__auto____$5)){
var and__3746__auto____$6 = (function (){var G__10556 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10556) : p1.call(null,G__10556));
})();
if(cljs.core.truth_(and__3746__auto____$6)){
var and__3746__auto____$7 = (function (){var G__10558 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10558) : p2.call(null,G__10558));
})();
if(cljs.core.truth_(and__3746__auto____$7)){
var G__10559 = z;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10559) : p3.call(null,G__10559));
} else {
return and__3746__auto____$7;
}
} else {
return and__3746__auto____$6;
}
} else {
return and__3746__auto____$5;
}
} else {
return and__3746__auto____$4;
}
} else {
return and__3746__auto____$3;
}
} else {
return and__3746__auto____$2;
}
} else {
return and__3746__auto____$1;
}
} else {
return and__3746__auto__;
}
})());
});
var ep3__4 = (function() { 
var G__10604__delegate = function (x,y,z,args){
return cljs.core.boolean$((ep3.cljs$core$IFn$_invoke$arity$3(x,y,z)) && (cljs.core.every_QMARK_((function (p1__10205_SHARP_){
var and__3746__auto__ = (function (){var G__10566 = p1__10205_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10566) : p1.call(null,G__10566));
})();
if(cljs.core.truth_(and__3746__auto__)){
var and__3746__auto____$1 = (function (){var G__10568 = p1__10205_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10568) : p2.call(null,G__10568));
})();
if(cljs.core.truth_(and__3746__auto____$1)){
var G__10569 = p1__10205_SHARP_;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10569) : p3.call(null,G__10569));
} else {
return and__3746__auto____$1;
}
} else {
return and__3746__auto__;
}
}),args)));
};
var G__10604 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__10605__i = 0, G__10605__a = new Array(arguments.length -  3);
while (G__10605__i < G__10605__a.length) {G__10605__a[G__10605__i] = arguments[G__10605__i + 3]; ++G__10605__i;}
  args = new cljs.core.IndexedSeq(G__10605__a,0);
} 
return G__10604__delegate.call(this,x,y,z,args);};
G__10604.cljs$lang$maxFixedArity = 3;
G__10604.cljs$lang$applyTo = (function (arglist__10606){
var x = cljs.core.first(arglist__10606);
arglist__10606 = cljs.core.next(arglist__10606);
var y = cljs.core.first(arglist__10606);
arglist__10606 = cljs.core.next(arglist__10606);
var z = cljs.core.first(arglist__10606);
var args = cljs.core.rest(arglist__10606);
return G__10604__delegate(x,y,z,args);
});
G__10604.cljs$core$IFn$_invoke$arity$variadic = G__10604__delegate;
return G__10604;
})()
;
ep3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return ep3__0.call(this);
case 1:
return ep3__1.call(this,x);
case 2:
return ep3__2.call(this,x,y);
case 3:
return ep3__3.call(this,x,y,z);
default:
var G__10607 = null;
if (arguments.length > 3) {
var G__10608__i = 0, G__10608__a = new Array(arguments.length -  3);
while (G__10608__i < G__10608__a.length) {G__10608__a[G__10608__i] = arguments[G__10608__i + 3]; ++G__10608__i;}
G__10607 = new cljs.core.IndexedSeq(G__10608__a,0);
}
return ep3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__10607);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
ep3.cljs$lang$maxFixedArity = 3;
ep3.cljs$lang$applyTo = ep3__4.cljs$lang$applyTo;
ep3.cljs$core$IFn$_invoke$arity$0 = ep3__0;
ep3.cljs$core$IFn$_invoke$arity$1 = ep3__1;
ep3.cljs$core$IFn$_invoke$arity$2 = ep3__2;
ep3.cljs$core$IFn$_invoke$arity$3 = ep3__3;
ep3.cljs$core$IFn$_invoke$arity$variadic = ep3__4.cljs$core$IFn$_invoke$arity$variadic;
return ep3;
})()
});
var every_pred__4 = (function() { 
var G__10609__delegate = function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return ((function (ps__$1){
return (function() {
var epn = null;
var epn__0 = (function (){
return true;
});
var epn__1 = (function (x){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__10206_SHARP_){
var G__10585 = x;
return (p1__10206_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10206_SHARP_.cljs$core$IFn$_invoke$arity$1(G__10585) : p1__10206_SHARP_.call(null,G__10585));
});})(ps__$1))
,ps__$1);
});
var epn__2 = (function (x,y){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__10207_SHARP_){
var and__3746__auto__ = (function (){var G__10587 = x;
return (p1__10207_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10207_SHARP_.cljs$core$IFn$_invoke$arity$1(G__10587) : p1__10207_SHARP_.call(null,G__10587));
})();
if(cljs.core.truth_(and__3746__auto__)){
var G__10588 = y;
return (p1__10207_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10207_SHARP_.cljs$core$IFn$_invoke$arity$1(G__10588) : p1__10207_SHARP_.call(null,G__10588));
} else {
return and__3746__auto__;
}
});})(ps__$1))
,ps__$1);
});
var epn__3 = (function (x,y,z){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__10208_SHARP_){
var and__3746__auto__ = (function (){var G__10590 = x;
return (p1__10208_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10208_SHARP_.cljs$core$IFn$_invoke$arity$1(G__10590) : p1__10208_SHARP_.call(null,G__10590));
})();
if(cljs.core.truth_(and__3746__auto__)){
var and__3746__auto____$1 = (function (){var G__10592 = y;
return (p1__10208_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10208_SHARP_.cljs$core$IFn$_invoke$arity$1(G__10592) : p1__10208_SHARP_.call(null,G__10592));
})();
if(cljs.core.truth_(and__3746__auto____$1)){
var G__10593 = z;
return (p1__10208_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10208_SHARP_.cljs$core$IFn$_invoke$arity$1(G__10593) : p1__10208_SHARP_.call(null,G__10593));
} else {
return and__3746__auto____$1;
}
} else {
return and__3746__auto__;
}
});})(ps__$1))
,ps__$1);
});
var epn__4 = (function() { 
var G__10610__delegate = function (x,y,z,args){
return cljs.core.boolean$((epn.cljs$core$IFn$_invoke$arity$3(x,y,z)) && (cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__10209_SHARP_){
return cljs.core.every_QMARK_(p1__10209_SHARP_,args);
});})(ps__$1))
,ps__$1)));
};
var G__10610 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__10611__i = 0, G__10611__a = new Array(arguments.length -  3);
while (G__10611__i < G__10611__a.length) {G__10611__a[G__10611__i] = arguments[G__10611__i + 3]; ++G__10611__i;}
  args = new cljs.core.IndexedSeq(G__10611__a,0);
} 
return G__10610__delegate.call(this,x,y,z,args);};
G__10610.cljs$lang$maxFixedArity = 3;
G__10610.cljs$lang$applyTo = (function (arglist__10612){
var x = cljs.core.first(arglist__10612);
arglist__10612 = cljs.core.next(arglist__10612);
var y = cljs.core.first(arglist__10612);
arglist__10612 = cljs.core.next(arglist__10612);
var z = cljs.core.first(arglist__10612);
var args = cljs.core.rest(arglist__10612);
return G__10610__delegate(x,y,z,args);
});
G__10610.cljs$core$IFn$_invoke$arity$variadic = G__10610__delegate;
return G__10610;
})()
;
epn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return epn__0.call(this);
case 1:
return epn__1.call(this,x);
case 2:
return epn__2.call(this,x,y);
case 3:
return epn__3.call(this,x,y,z);
default:
var G__10613 = null;
if (arguments.length > 3) {
var G__10614__i = 0, G__10614__a = new Array(arguments.length -  3);
while (G__10614__i < G__10614__a.length) {G__10614__a[G__10614__i] = arguments[G__10614__i + 3]; ++G__10614__i;}
G__10613 = new cljs.core.IndexedSeq(G__10614__a,0);
}
return epn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__10613);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
epn.cljs$lang$maxFixedArity = 3;
epn.cljs$lang$applyTo = epn__4.cljs$lang$applyTo;
epn.cljs$core$IFn$_invoke$arity$0 = epn__0;
epn.cljs$core$IFn$_invoke$arity$1 = epn__1;
epn.cljs$core$IFn$_invoke$arity$2 = epn__2;
epn.cljs$core$IFn$_invoke$arity$3 = epn__3;
epn.cljs$core$IFn$_invoke$arity$variadic = epn__4.cljs$core$IFn$_invoke$arity$variadic;
return epn;
})()
;})(ps__$1))
};
var G__10609 = function (p1,p2,p3,var_args){
var ps = null;
if (arguments.length > 3) {
var G__10615__i = 0, G__10615__a = new Array(arguments.length -  3);
while (G__10615__i < G__10615__a.length) {G__10615__a[G__10615__i] = arguments[G__10615__i + 3]; ++G__10615__i;}
  ps = new cljs.core.IndexedSeq(G__10615__a,0);
} 
return G__10609__delegate.call(this,p1,p2,p3,ps);};
G__10609.cljs$lang$maxFixedArity = 3;
G__10609.cljs$lang$applyTo = (function (arglist__10616){
var p1 = cljs.core.first(arglist__10616);
arglist__10616 = cljs.core.next(arglist__10616);
var p2 = cljs.core.first(arglist__10616);
arglist__10616 = cljs.core.next(arglist__10616);
var p3 = cljs.core.first(arglist__10616);
var ps = cljs.core.rest(arglist__10616);
return G__10609__delegate(p1,p2,p3,ps);
});
G__10609.cljs$core$IFn$_invoke$arity$variadic = G__10609__delegate;
return G__10609;
})()
;
every_pred = function(p1,p2,p3,var_args){
var ps = var_args;
switch(arguments.length){
case 1:
return every_pred__1.call(this,p1);
case 2:
return every_pred__2.call(this,p1,p2);
case 3:
return every_pred__3.call(this,p1,p2,p3);
default:
var G__10617 = null;
if (arguments.length > 3) {
var G__10618__i = 0, G__10618__a = new Array(arguments.length -  3);
while (G__10618__i < G__10618__a.length) {G__10618__a[G__10618__i] = arguments[G__10618__i + 3]; ++G__10618__i;}
G__10617 = new cljs.core.IndexedSeq(G__10618__a,0);
}
return every_pred__4.cljs$core$IFn$_invoke$arity$variadic(p1,p2,p3, G__10617);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
every_pred.cljs$lang$maxFixedArity = 3;
every_pred.cljs$lang$applyTo = every_pred__4.cljs$lang$applyTo;
every_pred.cljs$core$IFn$_invoke$arity$1 = every_pred__1;
every_pred.cljs$core$IFn$_invoke$arity$2 = every_pred__2;
every_pred.cljs$core$IFn$_invoke$arity$3 = every_pred__3;
every_pred.cljs$core$IFn$_invoke$arity$variadic = every_pred__4.cljs$core$IFn$_invoke$arity$variadic;
return every_pred;
})()
;
/**
* Takes a set of predicates and returns a function f that returns the first logical true value
* returned by one of its composing predicates against any of its arguments, else it returns
* logical false. Note that f is short-circuiting in that it will stop execution on the first
* argument that triggers a logical true result against the original predicates.
* @param {...*} var_args
*/
cljs.core.some_fn = (function() {
var some_fn = null;
var some_fn__1 = (function (p){
return (function() {
var sp1 = null;
var sp1__0 = (function (){
return null;
});
var sp1__1 = (function (x){
var G__10824 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__10824) : p.call(null,G__10824));
});
var sp1__2 = (function (x,y){
var or__3758__auto__ = (function (){var G__10826 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__10826) : p.call(null,G__10826));
})();
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
var G__10827 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__10827) : p.call(null,G__10827));
}
});
var sp1__3 = (function (x,y,z){
var or__3758__auto__ = (function (){var G__10829 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__10829) : p.call(null,G__10829));
})();
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (function (){var G__10831 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__10831) : p.call(null,G__10831));
})();
if(cljs.core.truth_(or__3758__auto____$1)){
return or__3758__auto____$1;
} else {
var G__10832 = z;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__10832) : p.call(null,G__10832));
}
}
});
var sp1__4 = (function() { 
var G__10993__delegate = function (x,y,z,args){
var or__3758__auto__ = sp1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return cljs.core.some(p,args);
}
};
var G__10993 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__10994__i = 0, G__10994__a = new Array(arguments.length -  3);
while (G__10994__i < G__10994__a.length) {G__10994__a[G__10994__i] = arguments[G__10994__i + 3]; ++G__10994__i;}
  args = new cljs.core.IndexedSeq(G__10994__a,0);
} 
return G__10993__delegate.call(this,x,y,z,args);};
G__10993.cljs$lang$maxFixedArity = 3;
G__10993.cljs$lang$applyTo = (function (arglist__10995){
var x = cljs.core.first(arglist__10995);
arglist__10995 = cljs.core.next(arglist__10995);
var y = cljs.core.first(arglist__10995);
arglist__10995 = cljs.core.next(arglist__10995);
var z = cljs.core.first(arglist__10995);
var args = cljs.core.rest(arglist__10995);
return G__10993__delegate(x,y,z,args);
});
G__10993.cljs$core$IFn$_invoke$arity$variadic = G__10993__delegate;
return G__10993;
})()
;
sp1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return sp1__0.call(this);
case 1:
return sp1__1.call(this,x);
case 2:
return sp1__2.call(this,x,y);
case 3:
return sp1__3.call(this,x,y,z);
default:
var G__10996 = null;
if (arguments.length > 3) {
var G__10997__i = 0, G__10997__a = new Array(arguments.length -  3);
while (G__10997__i < G__10997__a.length) {G__10997__a[G__10997__i] = arguments[G__10997__i + 3]; ++G__10997__i;}
G__10996 = new cljs.core.IndexedSeq(G__10997__a,0);
}
return sp1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__10996);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sp1.cljs$lang$maxFixedArity = 3;
sp1.cljs$lang$applyTo = sp1__4.cljs$lang$applyTo;
sp1.cljs$core$IFn$_invoke$arity$0 = sp1__0;
sp1.cljs$core$IFn$_invoke$arity$1 = sp1__1;
sp1.cljs$core$IFn$_invoke$arity$2 = sp1__2;
sp1.cljs$core$IFn$_invoke$arity$3 = sp1__3;
sp1.cljs$core$IFn$_invoke$arity$variadic = sp1__4.cljs$core$IFn$_invoke$arity$variadic;
return sp1;
})()
});
var some_fn__2 = (function (p1,p2){
return (function() {
var sp2 = null;
var sp2__0 = (function (){
return null;
});
var sp2__1 = (function (x){
var or__3758__auto__ = (function (){var G__10864 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10864) : p1.call(null,G__10864));
})();
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
var G__10865 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10865) : p2.call(null,G__10865));
}
});
var sp2__2 = (function (x,y){
var or__3758__auto__ = (function (){var G__10867 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10867) : p1.call(null,G__10867));
})();
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (function (){var G__10869 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10869) : p1.call(null,G__10869));
})();
if(cljs.core.truth_(or__3758__auto____$1)){
return or__3758__auto____$1;
} else {
var or__3758__auto____$2 = (function (){var G__10871 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10871) : p2.call(null,G__10871));
})();
if(cljs.core.truth_(or__3758__auto____$2)){
return or__3758__auto____$2;
} else {
var G__10872 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10872) : p2.call(null,G__10872));
}
}
}
});
var sp2__3 = (function (x,y,z){
var or__3758__auto__ = (function (){var G__10874 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10874) : p1.call(null,G__10874));
})();
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (function (){var G__10876 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10876) : p1.call(null,G__10876));
})();
if(cljs.core.truth_(or__3758__auto____$1)){
return or__3758__auto____$1;
} else {
var or__3758__auto____$2 = (function (){var G__10878 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10878) : p1.call(null,G__10878));
})();
if(cljs.core.truth_(or__3758__auto____$2)){
return or__3758__auto____$2;
} else {
var or__3758__auto____$3 = (function (){var G__10880 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10880) : p2.call(null,G__10880));
})();
if(cljs.core.truth_(or__3758__auto____$3)){
return or__3758__auto____$3;
} else {
var or__3758__auto____$4 = (function (){var G__10882 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10882) : p2.call(null,G__10882));
})();
if(cljs.core.truth_(or__3758__auto____$4)){
return or__3758__auto____$4;
} else {
var G__10883 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10883) : p2.call(null,G__10883));
}
}
}
}
}
});
var sp2__4 = (function() { 
var G__10998__delegate = function (x,y,z,args){
var or__3758__auto__ = sp2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return cljs.core.some(((function (or__3758__auto__){
return (function (p1__10619_SHARP_){
var or__3758__auto____$1 = (function (){var G__10885 = p1__10619_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10885) : p1.call(null,G__10885));
})();
if(cljs.core.truth_(or__3758__auto____$1)){
return or__3758__auto____$1;
} else {
var G__10886 = p1__10619_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10886) : p2.call(null,G__10886));
}
});})(or__3758__auto__))
,args);
}
};
var G__10998 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__10999__i = 0, G__10999__a = new Array(arguments.length -  3);
while (G__10999__i < G__10999__a.length) {G__10999__a[G__10999__i] = arguments[G__10999__i + 3]; ++G__10999__i;}
  args = new cljs.core.IndexedSeq(G__10999__a,0);
} 
return G__10998__delegate.call(this,x,y,z,args);};
G__10998.cljs$lang$maxFixedArity = 3;
G__10998.cljs$lang$applyTo = (function (arglist__11000){
var x = cljs.core.first(arglist__11000);
arglist__11000 = cljs.core.next(arglist__11000);
var y = cljs.core.first(arglist__11000);
arglist__11000 = cljs.core.next(arglist__11000);
var z = cljs.core.first(arglist__11000);
var args = cljs.core.rest(arglist__11000);
return G__10998__delegate(x,y,z,args);
});
G__10998.cljs$core$IFn$_invoke$arity$variadic = G__10998__delegate;
return G__10998;
})()
;
sp2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return sp2__0.call(this);
case 1:
return sp2__1.call(this,x);
case 2:
return sp2__2.call(this,x,y);
case 3:
return sp2__3.call(this,x,y,z);
default:
var G__11001 = null;
if (arguments.length > 3) {
var G__11002__i = 0, G__11002__a = new Array(arguments.length -  3);
while (G__11002__i < G__11002__a.length) {G__11002__a[G__11002__i] = arguments[G__11002__i + 3]; ++G__11002__i;}
G__11001 = new cljs.core.IndexedSeq(G__11002__a,0);
}
return sp2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__11001);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sp2.cljs$lang$maxFixedArity = 3;
sp2.cljs$lang$applyTo = sp2__4.cljs$lang$applyTo;
sp2.cljs$core$IFn$_invoke$arity$0 = sp2__0;
sp2.cljs$core$IFn$_invoke$arity$1 = sp2__1;
sp2.cljs$core$IFn$_invoke$arity$2 = sp2__2;
sp2.cljs$core$IFn$_invoke$arity$3 = sp2__3;
sp2.cljs$core$IFn$_invoke$arity$variadic = sp2__4.cljs$core$IFn$_invoke$arity$variadic;
return sp2;
})()
});
var some_fn__3 = (function (p1,p2,p3){
return (function() {
var sp3 = null;
var sp3__0 = (function (){
return null;
});
var sp3__1 = (function (x){
var or__3758__auto__ = (function (){var G__10932 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10932) : p1.call(null,G__10932));
})();
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (function (){var G__10934 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10934) : p2.call(null,G__10934));
})();
if(cljs.core.truth_(or__3758__auto____$1)){
return or__3758__auto____$1;
} else {
var G__10935 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10935) : p3.call(null,G__10935));
}
}
});
var sp3__2 = (function (x,y){
var or__3758__auto__ = (function (){var G__10937 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10937) : p1.call(null,G__10937));
})();
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (function (){var G__10939 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10939) : p2.call(null,G__10939));
})();
if(cljs.core.truth_(or__3758__auto____$1)){
return or__3758__auto____$1;
} else {
var or__3758__auto____$2 = (function (){var G__10941 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10941) : p3.call(null,G__10941));
})();
if(cljs.core.truth_(or__3758__auto____$2)){
return or__3758__auto____$2;
} else {
var or__3758__auto____$3 = (function (){var G__10943 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10943) : p1.call(null,G__10943));
})();
if(cljs.core.truth_(or__3758__auto____$3)){
return or__3758__auto____$3;
} else {
var or__3758__auto____$4 = (function (){var G__10945 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10945) : p2.call(null,G__10945));
})();
if(cljs.core.truth_(or__3758__auto____$4)){
return or__3758__auto____$4;
} else {
var G__10946 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10946) : p3.call(null,G__10946));
}
}
}
}
}
});
var sp3__3 = (function (x,y,z){
var or__3758__auto__ = (function (){var G__10948 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10948) : p1.call(null,G__10948));
})();
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (function (){var G__10950 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10950) : p2.call(null,G__10950));
})();
if(cljs.core.truth_(or__3758__auto____$1)){
return or__3758__auto____$1;
} else {
var or__3758__auto____$2 = (function (){var G__10952 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10952) : p3.call(null,G__10952));
})();
if(cljs.core.truth_(or__3758__auto____$2)){
return or__3758__auto____$2;
} else {
var or__3758__auto____$3 = (function (){var G__10954 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10954) : p1.call(null,G__10954));
})();
if(cljs.core.truth_(or__3758__auto____$3)){
return or__3758__auto____$3;
} else {
var or__3758__auto____$4 = (function (){var G__10956 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10956) : p2.call(null,G__10956));
})();
if(cljs.core.truth_(or__3758__auto____$4)){
return or__3758__auto____$4;
} else {
var or__3758__auto____$5 = (function (){var G__10958 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10958) : p3.call(null,G__10958));
})();
if(cljs.core.truth_(or__3758__auto____$5)){
return or__3758__auto____$5;
} else {
var or__3758__auto____$6 = (function (){var G__10960 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10960) : p1.call(null,G__10960));
})();
if(cljs.core.truth_(or__3758__auto____$6)){
return or__3758__auto____$6;
} else {
var or__3758__auto____$7 = (function (){var G__10962 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10962) : p2.call(null,G__10962));
})();
if(cljs.core.truth_(or__3758__auto____$7)){
return or__3758__auto____$7;
} else {
var G__10963 = z;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10963) : p3.call(null,G__10963));
}
}
}
}
}
}
}
}
});
var sp3__4 = (function() { 
var G__11003__delegate = function (x,y,z,args){
var or__3758__auto__ = sp3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return cljs.core.some(((function (or__3758__auto__){
return (function (p1__10620_SHARP_){
var or__3758__auto____$1 = (function (){var G__10965 = p1__10620_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10965) : p1.call(null,G__10965));
})();
if(cljs.core.truth_(or__3758__auto____$1)){
return or__3758__auto____$1;
} else {
var or__3758__auto____$2 = (function (){var G__10967 = p1__10620_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10967) : p2.call(null,G__10967));
})();
if(cljs.core.truth_(or__3758__auto____$2)){
return or__3758__auto____$2;
} else {
var G__10968 = p1__10620_SHARP_;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10968) : p3.call(null,G__10968));
}
}
});})(or__3758__auto__))
,args);
}
};
var G__11003 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__11004__i = 0, G__11004__a = new Array(arguments.length -  3);
while (G__11004__i < G__11004__a.length) {G__11004__a[G__11004__i] = arguments[G__11004__i + 3]; ++G__11004__i;}
  args = new cljs.core.IndexedSeq(G__11004__a,0);
} 
return G__11003__delegate.call(this,x,y,z,args);};
G__11003.cljs$lang$maxFixedArity = 3;
G__11003.cljs$lang$applyTo = (function (arglist__11005){
var x = cljs.core.first(arglist__11005);
arglist__11005 = cljs.core.next(arglist__11005);
var y = cljs.core.first(arglist__11005);
arglist__11005 = cljs.core.next(arglist__11005);
var z = cljs.core.first(arglist__11005);
var args = cljs.core.rest(arglist__11005);
return G__11003__delegate(x,y,z,args);
});
G__11003.cljs$core$IFn$_invoke$arity$variadic = G__11003__delegate;
return G__11003;
})()
;
sp3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return sp3__0.call(this);
case 1:
return sp3__1.call(this,x);
case 2:
return sp3__2.call(this,x,y);
case 3:
return sp3__3.call(this,x,y,z);
default:
var G__11006 = null;
if (arguments.length > 3) {
var G__11007__i = 0, G__11007__a = new Array(arguments.length -  3);
while (G__11007__i < G__11007__a.length) {G__11007__a[G__11007__i] = arguments[G__11007__i + 3]; ++G__11007__i;}
G__11006 = new cljs.core.IndexedSeq(G__11007__a,0);
}
return sp3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__11006);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sp3.cljs$lang$maxFixedArity = 3;
sp3.cljs$lang$applyTo = sp3__4.cljs$lang$applyTo;
sp3.cljs$core$IFn$_invoke$arity$0 = sp3__0;
sp3.cljs$core$IFn$_invoke$arity$1 = sp3__1;
sp3.cljs$core$IFn$_invoke$arity$2 = sp3__2;
sp3.cljs$core$IFn$_invoke$arity$3 = sp3__3;
sp3.cljs$core$IFn$_invoke$arity$variadic = sp3__4.cljs$core$IFn$_invoke$arity$variadic;
return sp3;
})()
});
var some_fn__4 = (function() { 
var G__11008__delegate = function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return ((function (ps__$1){
return (function() {
var spn = null;
var spn__0 = (function (){
return null;
});
var spn__1 = (function (x){
return cljs.core.some(((function (ps__$1){
return (function (p1__10621_SHARP_){
var G__10984 = x;
return (p1__10621_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10621_SHARP_.cljs$core$IFn$_invoke$arity$1(G__10984) : p1__10621_SHARP_.call(null,G__10984));
});})(ps__$1))
,ps__$1);
});
var spn__2 = (function (x,y){
return cljs.core.some(((function (ps__$1){
return (function (p1__10622_SHARP_){
var or__3758__auto__ = (function (){var G__10986 = x;
return (p1__10622_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10622_SHARP_.cljs$core$IFn$_invoke$arity$1(G__10986) : p1__10622_SHARP_.call(null,G__10986));
})();
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
var G__10987 = y;
return (p1__10622_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10622_SHARP_.cljs$core$IFn$_invoke$arity$1(G__10987) : p1__10622_SHARP_.call(null,G__10987));
}
});})(ps__$1))
,ps__$1);
});
var spn__3 = (function (x,y,z){
return cljs.core.some(((function (ps__$1){
return (function (p1__10623_SHARP_){
var or__3758__auto__ = (function (){var G__10989 = x;
return (p1__10623_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10623_SHARP_.cljs$core$IFn$_invoke$arity$1(G__10989) : p1__10623_SHARP_.call(null,G__10989));
})();
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (function (){var G__10991 = y;
return (p1__10623_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10623_SHARP_.cljs$core$IFn$_invoke$arity$1(G__10991) : p1__10623_SHARP_.call(null,G__10991));
})();
if(cljs.core.truth_(or__3758__auto____$1)){
return or__3758__auto____$1;
} else {
var G__10992 = z;
return (p1__10623_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10623_SHARP_.cljs$core$IFn$_invoke$arity$1(G__10992) : p1__10623_SHARP_.call(null,G__10992));
}
}
});})(ps__$1))
,ps__$1);
});
var spn__4 = (function() { 
var G__11009__delegate = function (x,y,z,args){
var or__3758__auto__ = spn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return cljs.core.some(((function (or__3758__auto__,ps__$1){
return (function (p1__10624_SHARP_){
return cljs.core.some(p1__10624_SHARP_,args);
});})(or__3758__auto__,ps__$1))
,ps__$1);
}
};
var G__11009 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__11010__i = 0, G__11010__a = new Array(arguments.length -  3);
while (G__11010__i < G__11010__a.length) {G__11010__a[G__11010__i] = arguments[G__11010__i + 3]; ++G__11010__i;}
  args = new cljs.core.IndexedSeq(G__11010__a,0);
} 
return G__11009__delegate.call(this,x,y,z,args);};
G__11009.cljs$lang$maxFixedArity = 3;
G__11009.cljs$lang$applyTo = (function (arglist__11011){
var x = cljs.core.first(arglist__11011);
arglist__11011 = cljs.core.next(arglist__11011);
var y = cljs.core.first(arglist__11011);
arglist__11011 = cljs.core.next(arglist__11011);
var z = cljs.core.first(arglist__11011);
var args = cljs.core.rest(arglist__11011);
return G__11009__delegate(x,y,z,args);
});
G__11009.cljs$core$IFn$_invoke$arity$variadic = G__11009__delegate;
return G__11009;
})()
;
spn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return spn__0.call(this);
case 1:
return spn__1.call(this,x);
case 2:
return spn__2.call(this,x,y);
case 3:
return spn__3.call(this,x,y,z);
default:
var G__11012 = null;
if (arguments.length > 3) {
var G__11013__i = 0, G__11013__a = new Array(arguments.length -  3);
while (G__11013__i < G__11013__a.length) {G__11013__a[G__11013__i] = arguments[G__11013__i + 3]; ++G__11013__i;}
G__11012 = new cljs.core.IndexedSeq(G__11013__a,0);
}
return spn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__11012);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
spn.cljs$lang$maxFixedArity = 3;
spn.cljs$lang$applyTo = spn__4.cljs$lang$applyTo;
spn.cljs$core$IFn$_invoke$arity$0 = spn__0;
spn.cljs$core$IFn$_invoke$arity$1 = spn__1;
spn.cljs$core$IFn$_invoke$arity$2 = spn__2;
spn.cljs$core$IFn$_invoke$arity$3 = spn__3;
spn.cljs$core$IFn$_invoke$arity$variadic = spn__4.cljs$core$IFn$_invoke$arity$variadic;
return spn;
})()
;})(ps__$1))
};
var G__11008 = function (p1,p2,p3,var_args){
var ps = null;
if (arguments.length > 3) {
var G__11014__i = 0, G__11014__a = new Array(arguments.length -  3);
while (G__11014__i < G__11014__a.length) {G__11014__a[G__11014__i] = arguments[G__11014__i + 3]; ++G__11014__i;}
  ps = new cljs.core.IndexedSeq(G__11014__a,0);
} 
return G__11008__delegate.call(this,p1,p2,p3,ps);};
G__11008.cljs$lang$maxFixedArity = 3;
G__11008.cljs$lang$applyTo = (function (arglist__11015){
var p1 = cljs.core.first(arglist__11015);
arglist__11015 = cljs.core.next(arglist__11015);
var p2 = cljs.core.first(arglist__11015);
arglist__11015 = cljs.core.next(arglist__11015);
var p3 = cljs.core.first(arglist__11015);
var ps = cljs.core.rest(arglist__11015);
return G__11008__delegate(p1,p2,p3,ps);
});
G__11008.cljs$core$IFn$_invoke$arity$variadic = G__11008__delegate;
return G__11008;
})()
;
some_fn = function(p1,p2,p3,var_args){
var ps = var_args;
switch(arguments.length){
case 1:
return some_fn__1.call(this,p1);
case 2:
return some_fn__2.call(this,p1,p2);
case 3:
return some_fn__3.call(this,p1,p2,p3);
default:
var G__11016 = null;
if (arguments.length > 3) {
var G__11017__i = 0, G__11017__a = new Array(arguments.length -  3);
while (G__11017__i < G__11017__a.length) {G__11017__a[G__11017__i] = arguments[G__11017__i + 3]; ++G__11017__i;}
G__11016 = new cljs.core.IndexedSeq(G__11017__a,0);
}
return some_fn__4.cljs$core$IFn$_invoke$arity$variadic(p1,p2,p3, G__11016);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
some_fn.cljs$lang$maxFixedArity = 3;
some_fn.cljs$lang$applyTo = some_fn__4.cljs$lang$applyTo;
some_fn.cljs$core$IFn$_invoke$arity$1 = some_fn__1;
some_fn.cljs$core$IFn$_invoke$arity$2 = some_fn__2;
some_fn.cljs$core$IFn$_invoke$arity$3 = some_fn__3;
some_fn.cljs$core$IFn$_invoke$arity$variadic = some_fn__4.cljs$core$IFn$_invoke$arity$variadic;
return some_fn;
})()
;
/**
* Returns a lazy sequence consisting of the result of applying f to
* the set of first items of each coll, followed by applying f to the
* set of second items in each coll, until any one of the colls is
* exhausted.  Any remaining items in other colls are ignored. Function
* f should accept number-of-colls arguments. Returns a transducer when
* no collection is provided.
* @param {...*} var_args
*/
cljs.core.map = (function() {
var map = null;
var map__1 = (function (f){
return (function (rf){
return (function() {
var G__11072 = null;
var G__11072__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11072__1 = (function (result){
var G__11058 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11058) : rf.call(null,G__11058));
});
var G__11072__2 = (function (result,input){
var G__11059 = result;
var G__11060 = (function (){var G__11061 = input;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11061) : f.call(null,G__11061));
})();
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11059,G__11060) : rf.call(null,G__11059,G__11060));
});
var G__11072__3 = (function() { 
var G__11073__delegate = function (result,input,inputs){
var G__11062 = result;
var G__11063 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,input,inputs);
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11062,G__11063) : rf.call(null,G__11062,G__11063));
};
var G__11073 = function (result,input,var_args){
var inputs = null;
if (arguments.length > 2) {
var G__11074__i = 0, G__11074__a = new Array(arguments.length -  2);
while (G__11074__i < G__11074__a.length) {G__11074__a[G__11074__i] = arguments[G__11074__i + 2]; ++G__11074__i;}
  inputs = new cljs.core.IndexedSeq(G__11074__a,0);
} 
return G__11073__delegate.call(this,result,input,inputs);};
G__11073.cljs$lang$maxFixedArity = 2;
G__11073.cljs$lang$applyTo = (function (arglist__11075){
var result = cljs.core.first(arglist__11075);
arglist__11075 = cljs.core.next(arglist__11075);
var input = cljs.core.first(arglist__11075);
var inputs = cljs.core.rest(arglist__11075);
return G__11073__delegate(result,input,inputs);
});
G__11073.cljs$core$IFn$_invoke$arity$variadic = G__11073__delegate;
return G__11073;
})()
;
G__11072 = function(result,input,var_args){
var inputs = var_args;
switch(arguments.length){
case 0:
return G__11072__0.call(this);
case 1:
return G__11072__1.call(this,result);
case 2:
return G__11072__2.call(this,result,input);
default:
var G__11076 = null;
if (arguments.length > 2) {
var G__11077__i = 0, G__11077__a = new Array(arguments.length -  2);
while (G__11077__i < G__11077__a.length) {G__11077__a[G__11077__i] = arguments[G__11077__i + 2]; ++G__11077__i;}
G__11076 = new cljs.core.IndexedSeq(G__11077__a,0);
}
return G__11072__3.cljs$core$IFn$_invoke$arity$variadic(result,input, G__11076);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11072.cljs$lang$maxFixedArity = 2;
G__11072.cljs$lang$applyTo = G__11072__3.cljs$lang$applyTo;
G__11072.cljs$core$IFn$_invoke$arity$0 = G__11072__0;
G__11072.cljs$core$IFn$_invoke$arity$1 = G__11072__1;
G__11072.cljs$core$IFn$_invoke$arity$2 = G__11072__2;
G__11072.cljs$core$IFn$_invoke$arity$variadic = G__11072__3.cljs$core$IFn$_invoke$arity$variadic;
return G__11072;
})()
});
});
var map__2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4645__auto___11078 = size;
var i_11079 = (0);
while(true){
if((i_11079 < n__4645__auto___11078)){
cljs.core.chunk_append(b,(function (){var G__11064 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_11079);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11064) : f.call(null,G__11064));
})());

var G__11080 = (i_11079 + (1));
i_11079 = G__11080;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__11065 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11065) : f.call(null,G__11065));
})(),map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});
var map__3 = (function (f,c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if((s1) && (s2)){
return cljs.core.cons((function (){var G__11066 = cljs.core.first(s1);
var G__11067 = cljs.core.first(s2);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11066,G__11067) : f.call(null,G__11066,G__11067));
})(),map.cljs$core$IFn$_invoke$arity$3(f,cljs.core.rest(s1),cljs.core.rest(s2)));
} else {
return null;
}
}),null,null));
});
var map__4 = (function (f,c1,c2,c3){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
var s3 = cljs.core.seq(c3);
if((s1) && (s2) && (s3)){
return cljs.core.cons((function (){var G__11068 = cljs.core.first(s1);
var G__11069 = cljs.core.first(s2);
var G__11070 = cljs.core.first(s3);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11068,G__11069,G__11070) : f.call(null,G__11068,G__11069,G__11070));
})(),map.cljs$core$IFn$_invoke$arity$4(f,cljs.core.rest(s1),cljs.core.rest(s2),cljs.core.rest(s3)));
} else {
return null;
}
}),null,null));
});
var map__5 = (function() { 
var G__11081__delegate = function (f,c1,c2,c3,colls){
var step = (function step(cs){
return (new cljs.core.LazySeq(null,(function (){
var ss = map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cs);
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.cons(map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),step(map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
});
return map.cljs$core$IFn$_invoke$arity$2(((function (step){
return (function (p1__11018_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,p1__11018_SHARP_);
});})(step))
,step(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c3,cljs.core.array_seq([c2,c1], 0))));
};
var G__11081 = function (f,c1,c2,c3,var_args){
var colls = null;
if (arguments.length > 4) {
var G__11082__i = 0, G__11082__a = new Array(arguments.length -  4);
while (G__11082__i < G__11082__a.length) {G__11082__a[G__11082__i] = arguments[G__11082__i + 4]; ++G__11082__i;}
  colls = new cljs.core.IndexedSeq(G__11082__a,0);
} 
return G__11081__delegate.call(this,f,c1,c2,c3,colls);};
G__11081.cljs$lang$maxFixedArity = 4;
G__11081.cljs$lang$applyTo = (function (arglist__11083){
var f = cljs.core.first(arglist__11083);
arglist__11083 = cljs.core.next(arglist__11083);
var c1 = cljs.core.first(arglist__11083);
arglist__11083 = cljs.core.next(arglist__11083);
var c2 = cljs.core.first(arglist__11083);
arglist__11083 = cljs.core.next(arglist__11083);
var c3 = cljs.core.first(arglist__11083);
var colls = cljs.core.rest(arglist__11083);
return G__11081__delegate(f,c1,c2,c3,colls);
});
G__11081.cljs$core$IFn$_invoke$arity$variadic = G__11081__delegate;
return G__11081;
})()
;
map = function(f,c1,c2,c3,var_args){
var colls = var_args;
switch(arguments.length){
case 1:
return map__1.call(this,f);
case 2:
return map__2.call(this,f,c1);
case 3:
return map__3.call(this,f,c1,c2);
case 4:
return map__4.call(this,f,c1,c2,c3);
default:
var G__11084 = null;
if (arguments.length > 4) {
var G__11085__i = 0, G__11085__a = new Array(arguments.length -  4);
while (G__11085__i < G__11085__a.length) {G__11085__a[G__11085__i] = arguments[G__11085__i + 4]; ++G__11085__i;}
G__11084 = new cljs.core.IndexedSeq(G__11085__a,0);
}
return map__5.cljs$core$IFn$_invoke$arity$variadic(f,c1,c2,c3, G__11084);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
map.cljs$lang$maxFixedArity = 4;
map.cljs$lang$applyTo = map__5.cljs$lang$applyTo;
map.cljs$core$IFn$_invoke$arity$1 = map__1;
map.cljs$core$IFn$_invoke$arity$2 = map__2;
map.cljs$core$IFn$_invoke$arity$3 = map__3;
map.cljs$core$IFn$_invoke$arity$4 = map__4;
map.cljs$core$IFn$_invoke$arity$variadic = map__5.cljs$core$IFn$_invoke$arity$variadic;
return map;
})()
;
/**
* Returns a lazy sequence of the first n items in coll, or all items if
* there are fewer than n.  Returns a stateful transducer when
* no collection is provided.
*/
cljs.core.take = (function() {
var take = null;
var take__1 = (function (n){
return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return ((function (na){
return (function() {
var G__11094 = null;
var G__11094__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11094__1 = (function (result){
var G__11091 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11091) : rf.call(null,G__11091));
});
var G__11094__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
var nn = na.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(na.cljs$core$IDeref$_deref$arity$1(null) - (1)));
var result__$1 = (((n__$1 > (0)))?(function (){var G__11092 = result;
var G__11093 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11092,G__11093) : rf.call(null,G__11092,G__11093));
})():result);
if(!((nn > (0)))){
return cljs.core.ensure_reduced(result__$1);
} else {
return result__$1;
}
});
G__11094 = function(result,input){
switch(arguments.length){
case 0:
return G__11094__0.call(this);
case 1:
return G__11094__1.call(this,result);
case 2:
return G__11094__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11094.cljs$core$IFn$_invoke$arity$0 = G__11094__0;
G__11094.cljs$core$IFn$_invoke$arity$1 = G__11094__1;
G__11094.cljs$core$IFn$_invoke$arity$2 = G__11094__2;
return G__11094;
})()
;})(na))
});
});
var take__2 = (function (n,coll){
return (new cljs.core.LazySeq(null,(function (){
if((n > (0))){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return cljs.core.cons(cljs.core.first(s),take.cljs$core$IFn$_invoke$arity$2((n - (1)),cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});
take = function(n,coll){
switch(arguments.length){
case 1:
return take__1.call(this,n);
case 2:
return take__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
take.cljs$core$IFn$_invoke$arity$1 = take__1;
take.cljs$core$IFn$_invoke$arity$2 = take__2;
return take;
})()
;
/**
* Returns a lazy sequence of all but the first n items in coll.
* Returns a stateful transducer when no collection is provided.
*/
cljs.core.drop = (function() {
var drop = null;
var drop__1 = (function (n){
return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return ((function (na){
return (function() {
var G__11101 = null;
var G__11101__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11101__1 = (function (result){
var G__11098 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11098) : rf.call(null,G__11098));
});
var G__11101__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
na.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(na.cljs$core$IDeref$_deref$arity$1(null) - (1)));

if((n__$1 > (0))){
return result;
} else {
var G__11099 = result;
var G__11100 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11099,G__11100) : rf.call(null,G__11099,G__11100));
}
});
G__11101 = function(result,input){
switch(arguments.length){
case 0:
return G__11101__0.call(this);
case 1:
return G__11101__1.call(this,result);
case 2:
return G__11101__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11101.cljs$core$IFn$_invoke$arity$0 = G__11101__0;
G__11101.cljs$core$IFn$_invoke$arity$1 = G__11101__1;
G__11101.cljs$core$IFn$_invoke$arity$2 = G__11101__2;
return G__11101;
})()
;})(na))
});
});
var drop__2 = (function (n,coll){
var step = (function (n__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(((n__$1 > (0))) && (s)){
var G__11102 = (n__$1 - (1));
var G__11103 = cljs.core.rest(s);
n__$1 = G__11102;
coll__$1 = G__11103;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,((function (step){
return (function (){
return step(n,coll);
});})(step))
,null,null));
});
drop = function(n,coll){
switch(arguments.length){
case 1:
return drop__1.call(this,n);
case 2:
return drop__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
drop.cljs$core$IFn$_invoke$arity$1 = drop__1;
drop.cljs$core$IFn$_invoke$arity$2 = drop__2;
return drop;
})()
;
/**
* Return a lazy sequence of all but the last n (default 1) items in coll
*/
cljs.core.drop_last = (function() {
var drop_last = null;
var drop_last__1 = (function (s){
return drop_last.cljs$core$IFn$_invoke$arity$2((1),s);
});
var drop_last__2 = (function (n,s){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((function (x,_){
return x;
}),s,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s));
});
drop_last = function(n,s){
switch(arguments.length){
case 1:
return drop_last__1.call(this,n);
case 2:
return drop_last__2.call(this,n,s);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
drop_last.cljs$core$IFn$_invoke$arity$1 = drop_last__1;
drop_last.cljs$core$IFn$_invoke$arity$2 = drop_last__2;
return drop_last;
})()
;
/**
* Returns a seq of the last n items in coll.  Depending on the type
* of coll may be no better than linear time.  For vectors, see also subvec.
*/
cljs.core.take_last = (function take_last(n,coll){
var s = cljs.core.seq(coll);
var lead = cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll));
while(true){
if(lead){
var G__11106 = cljs.core.next(s);
var G__11107 = cljs.core.next(lead);
s = G__11106;
lead = G__11107;
continue;
} else {
return s;
}
break;
}
});
/**
* Returns a lazy sequence of the items in coll starting from the
* first item for which (pred item) returns logical false.  Returns a
* stateful transducer when no collection is provided.
*/
cljs.core.drop_while = (function() {
var drop_while = null;
var drop_while__1 = (function (pred){
return (function (rf){
var da = cljs.core.volatile_BANG_(true);
return ((function (da){
return (function() {
var G__11120 = null;
var G__11120__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11120__1 = (function (result){
var G__11114 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11114) : rf.call(null,G__11114));
});
var G__11120__2 = (function (result,input){
var drop_QMARK_ = cljs.core.deref(da);
if(cljs.core.truth_((function (){var and__3746__auto__ = drop_QMARK_;
if(cljs.core.truth_(and__3746__auto__)){
var G__11115 = input;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__11115) : pred.call(null,G__11115));
} else {
return and__3746__auto__;
}
})())){
return result;
} else {
cljs.core.vreset_BANG_(da,null);

var G__11116 = result;
var G__11117 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11116,G__11117) : rf.call(null,G__11116,G__11117));
}
});
G__11120 = function(result,input){
switch(arguments.length){
case 0:
return G__11120__0.call(this);
case 1:
return G__11120__1.call(this,result);
case 2:
return G__11120__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11120.cljs$core$IFn$_invoke$arity$0 = G__11120__0;
G__11120.cljs$core$IFn$_invoke$arity$1 = G__11120__1;
G__11120.cljs$core$IFn$_invoke$arity$2 = G__11120__2;
return G__11120;
})()
;})(da))
});
});
var drop_while__2 = (function (pred,coll){
var step = (function (pred__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(cljs.core.truth_((function (){var and__3746__auto__ = s;
if(and__3746__auto__){
var G__11119 = cljs.core.first(s);
return (pred__$1.cljs$core$IFn$_invoke$arity$1 ? pred__$1.cljs$core$IFn$_invoke$arity$1(G__11119) : pred__$1.call(null,G__11119));
} else {
return and__3746__auto__;
}
})())){
var G__11121 = pred__$1;
var G__11122 = cljs.core.rest(s);
pred__$1 = G__11121;
coll__$1 = G__11122;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,((function (step){
return (function (){
return step(pred,coll);
});})(step))
,null,null));
});
drop_while = function(pred,coll){
switch(arguments.length){
case 1:
return drop_while__1.call(this,pred);
case 2:
return drop_while__2.call(this,pred,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
drop_while.cljs$core$IFn$_invoke$arity$1 = drop_while__1;
drop_while.cljs$core$IFn$_invoke$arity$2 = drop_while__2;
return drop_while;
})()
;
/**
* Returns a lazy (infinite!) sequence of repetitions of the items in coll.
*/
cljs.core.cycle = (function cycle(coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(s,cycle(s));
} else {
return null;
}
}),null,null));
});
/**
* Returns a vector of [(take n coll) (drop n coll)]
*/
cljs.core.split_at = (function split_at(n,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,coll),cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll)], null);
});
/**
* Returns a lazy (infinite!, or length n if supplied) sequence of xs.
*/
cljs.core.repeat = (function() {
var repeat = null;
var repeat__1 = (function (x){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons(x,repeat.cljs$core$IFn$_invoke$arity$1(x));
}),null,null));
});
var repeat__2 = (function (n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,repeat.cljs$core$IFn$_invoke$arity$1(x));
});
repeat = function(n,x){
switch(arguments.length){
case 1:
return repeat__1.call(this,n);
case 2:
return repeat__2.call(this,n,x);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
repeat.cljs$core$IFn$_invoke$arity$1 = repeat__1;
repeat.cljs$core$IFn$_invoke$arity$2 = repeat__2;
return repeat;
})()
;
/**
* Returns a lazy seq of n xs.
*/
cljs.core.replicate = (function replicate(n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
});
/**
* Takes a function of no args, presumably with side effects, and
* returns an infinite (or length n if supplied) lazy sequence of calls
* to it
*/
cljs.core.repeatedly = (function() {
var repeatedly = null;
var repeatedly__1 = (function (f){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),repeatedly.cljs$core$IFn$_invoke$arity$1(f));
}),null,null));
});
var repeatedly__2 = (function (n,f){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,repeatedly.cljs$core$IFn$_invoke$arity$1(f));
});
repeatedly = function(n,f){
switch(arguments.length){
case 1:
return repeatedly__1.call(this,n);
case 2:
return repeatedly__2.call(this,n,f);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
repeatedly.cljs$core$IFn$_invoke$arity$1 = repeatedly__1;
repeatedly.cljs$core$IFn$_invoke$arity$2 = repeatedly__2;
return repeatedly;
})()
;
/**
* Returns a lazy sequence of x, (f x), (f (f x)) etc. f must be free of side-effects
*/
cljs.core.iterate = (function iterate(f,x){
return cljs.core.cons(x,(new cljs.core.LazySeq(null,(function (){
return iterate(f,(function (){var G__11131 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11131) : f.call(null,G__11131));
})());
}),null,null)));
});
/**
* Returns a lazy seq of the first item in each coll, then the second etc.
* @param {...*} var_args
*/
cljs.core.interleave = (function() {
var interleave = null;
var interleave__2 = (function (c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if((s1) && (s2)){
return cljs.core.cons(cljs.core.first(s1),cljs.core.cons(cljs.core.first(s2),interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1),cljs.core.rest(s2))));
} else {
return null;
}
}),null,null));
});
var interleave__3 = (function() { 
var G__11134__delegate = function (c1,c2,colls){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c2,cljs.core.array_seq([c1], 0)));
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(interleave,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
};
var G__11134 = function (c1,c2,var_args){
var colls = null;
if (arguments.length > 2) {
var G__11135__i = 0, G__11135__a = new Array(arguments.length -  2);
while (G__11135__i < G__11135__a.length) {G__11135__a[G__11135__i] = arguments[G__11135__i + 2]; ++G__11135__i;}
  colls = new cljs.core.IndexedSeq(G__11135__a,0);
} 
return G__11134__delegate.call(this,c1,c2,colls);};
G__11134.cljs$lang$maxFixedArity = 2;
G__11134.cljs$lang$applyTo = (function (arglist__11136){
var c1 = cljs.core.first(arglist__11136);
arglist__11136 = cljs.core.next(arglist__11136);
var c2 = cljs.core.first(arglist__11136);
var colls = cljs.core.rest(arglist__11136);
return G__11134__delegate(c1,c2,colls);
});
G__11134.cljs$core$IFn$_invoke$arity$variadic = G__11134__delegate;
return G__11134;
})()
;
interleave = function(c1,c2,var_args){
var colls = var_args;
switch(arguments.length){
case 2:
return interleave__2.call(this,c1,c2);
default:
var G__11137 = null;
if (arguments.length > 2) {
var G__11138__i = 0, G__11138__a = new Array(arguments.length -  2);
while (G__11138__i < G__11138__a.length) {G__11138__a[G__11138__i] = arguments[G__11138__i + 2]; ++G__11138__i;}
G__11137 = new cljs.core.IndexedSeq(G__11138__a,0);
}
return interleave__3.cljs$core$IFn$_invoke$arity$variadic(c1,c2, G__11137);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
interleave.cljs$lang$maxFixedArity = 2;
interleave.cljs$lang$applyTo = interleave__3.cljs$lang$applyTo;
interleave.cljs$core$IFn$_invoke$arity$2 = interleave__2;
interleave.cljs$core$IFn$_invoke$arity$variadic = interleave__3.cljs$core$IFn$_invoke$arity$variadic;
return interleave;
})()
;
/**
* Returns a lazy seq of the elements of coll separated by sep
*/
cljs.core.interpose = (function() {
var interpose = null;
var interpose__1 = (function (sep){
return (function (rf){
var started = cljs.core.volatile_BANG_(false);
return ((function (started){
return (function() {
var G__11153 = null;
var G__11153__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11153__1 = (function (result){
var G__11146 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11146) : rf.call(null,G__11146));
});
var G__11153__2 = (function (result,input){
if(cljs.core.truth_(cljs.core.deref(started))){
var sepr = (function (){var G__11147 = result;
var G__11148 = sep;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11147,G__11148) : rf.call(null,G__11147,G__11148));
})();
if(cljs.core.reduced_QMARK_(sepr)){
return sepr;
} else {
var G__11149 = sepr;
var G__11150 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11149,G__11150) : rf.call(null,G__11149,G__11150));
}
} else {
cljs.core.vreset_BANG_(started,true);

var G__11151 = result;
var G__11152 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11151,G__11152) : rf.call(null,G__11151,G__11152));
}
});
G__11153 = function(result,input){
switch(arguments.length){
case 0:
return G__11153__0.call(this);
case 1:
return G__11153__1.call(this,result);
case 2:
return G__11153__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11153.cljs$core$IFn$_invoke$arity$0 = G__11153__0;
G__11153.cljs$core$IFn$_invoke$arity$1 = G__11153__1;
G__11153.cljs$core$IFn$_invoke$arity$2 = G__11153__2;
return G__11153;
})()
;})(started))
});
});
var interpose__2 = (function (sep,coll){
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(sep),coll));
});
interpose = function(sep,coll){
switch(arguments.length){
case 1:
return interpose__1.call(this,sep);
case 2:
return interpose__2.call(this,sep,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
interpose.cljs$core$IFn$_invoke$arity$1 = interpose__1;
interpose.cljs$core$IFn$_invoke$arity$2 = interpose__2;
return interpose;
})()
;
/**
* Take a collection of collections, and return a lazy seq
* of items from the inner collection
*/
cljs.core.flatten1 = (function flatten1(colls){
var cat = (function cat(coll,colls__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4124__auto__ = cljs.core.seq(coll);
if(temp__4124__auto__){
var coll__$1 = temp__4124__auto__;
return cljs.core.cons(cljs.core.first(coll__$1),cat(cljs.core.rest(coll__$1),colls__$1));
} else {
if(cljs.core.seq(colls__$1)){
return cat(cljs.core.first(colls__$1),cljs.core.rest(colls__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(null,colls);
});
/**
* Returns the result of applying concat to the result of applying map
* to f and colls.  Thus function f should return a collection. Returns
* a transducer when no collections are provided
* @param {...*} var_args
*/
cljs.core.mapcat = (function() {
var mapcat = null;
var mapcat__1 = (function (f){
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(f),cljs.core.cat);
});
var mapcat__2 = (function() { 
var G__11162__delegate = function (f,colls){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map,f,colls));
};
var G__11162 = function (f,var_args){
var colls = null;
if (arguments.length > 1) {
var G__11163__i = 0, G__11163__a = new Array(arguments.length -  1);
while (G__11163__i < G__11163__a.length) {G__11163__a[G__11163__i] = arguments[G__11163__i + 1]; ++G__11163__i;}
  colls = new cljs.core.IndexedSeq(G__11163__a,0);
} 
return G__11162__delegate.call(this,f,colls);};
G__11162.cljs$lang$maxFixedArity = 1;
G__11162.cljs$lang$applyTo = (function (arglist__11164){
var f = cljs.core.first(arglist__11164);
var colls = cljs.core.rest(arglist__11164);
return G__11162__delegate(f,colls);
});
G__11162.cljs$core$IFn$_invoke$arity$variadic = G__11162__delegate;
return G__11162;
})()
;
mapcat = function(f,var_args){
var colls = var_args;
switch(arguments.length){
case 1:
return mapcat__1.call(this,f);
default:
var G__11165 = null;
if (arguments.length > 1) {
var G__11166__i = 0, G__11166__a = new Array(arguments.length -  1);
while (G__11166__i < G__11166__a.length) {G__11166__a[G__11166__i] = arguments[G__11166__i + 1]; ++G__11166__i;}
G__11165 = new cljs.core.IndexedSeq(G__11166__a,0);
}
return mapcat__2.cljs$core$IFn$_invoke$arity$variadic(f, G__11165);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
mapcat.cljs$lang$maxFixedArity = 1;
mapcat.cljs$lang$applyTo = mapcat__2.cljs$lang$applyTo;
mapcat.cljs$core$IFn$_invoke$arity$1 = mapcat__1;
mapcat.cljs$core$IFn$_invoke$arity$variadic = mapcat__2.cljs$core$IFn$_invoke$arity$variadic;
return mapcat;
})()
;
/**
* Returns a lazy sequence of the items in coll for which
* (pred item) returns true. pred must be free of side-effects.
* Returns a transducer when no collection is provided.
*/
cljs.core.filter = (function() {
var filter = null;
var filter__1 = (function (pred){
return (function (rf){
return (function() {
var G__11185 = null;
var G__11185__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11185__1 = (function (result){
var G__11179 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11179) : rf.call(null,G__11179));
});
var G__11185__2 = (function (result,input){
if(cljs.core.truth_((function (){var G__11180 = input;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__11180) : pred.call(null,G__11180));
})())){
var G__11181 = result;
var G__11182 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11181,G__11182) : rf.call(null,G__11181,G__11182));
} else {
return result;
}
});
G__11185 = function(result,input){
switch(arguments.length){
case 0:
return G__11185__0.call(this);
case 1:
return G__11185__1.call(this,result);
case 2:
return G__11185__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11185.cljs$core$IFn$_invoke$arity$0 = G__11185__0;
G__11185.cljs$core$IFn$_invoke$arity$1 = G__11185__1;
G__11185.cljs$core$IFn$_invoke$arity$2 = G__11185__2;
return G__11185;
})()
});
});
var filter__2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4645__auto___11186 = size;
var i_11187 = (0);
while(true){
if((i_11187 < n__4645__auto___11186)){
if(cljs.core.truth_((function (){var G__11183 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_11187);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__11183) : pred.call(null,G__11183));
})())){
cljs.core.chunk_append(b,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_11187));
} else {
}

var G__11188 = (i_11187 + (1));
i_11187 = G__11188;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),filter.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.chunk_rest(s)));
} else {
var f = cljs.core.first(s);
var r = cljs.core.rest(s);
if(cljs.core.truth_((function (){var G__11184 = f;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__11184) : pred.call(null,G__11184));
})())){
return cljs.core.cons(f,filter.cljs$core$IFn$_invoke$arity$2(pred,r));
} else {
return filter.cljs$core$IFn$_invoke$arity$2(pred,r);
}
}
} else {
return null;
}
}),null,null));
});
filter = function(pred,coll){
switch(arguments.length){
case 1:
return filter__1.call(this,pred);
case 2:
return filter__2.call(this,pred,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
filter.cljs$core$IFn$_invoke$arity$1 = filter__1;
filter.cljs$core$IFn$_invoke$arity$2 = filter__2;
return filter;
})()
;
/**
* Returns a lazy sequence of the items in coll for which
* (pred item) returns false. pred must be free of side-effects.
* Returns a transducer when no collection is provided.
*/
cljs.core.remove = (function() {
var remove = null;
var remove__1 = (function (pred){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.complement(pred));
});
var remove__2 = (function (pred,coll){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(pred),coll);
});
remove = function(pred,coll){
switch(arguments.length){
case 1:
return remove__1.call(this,pred);
case 2:
return remove__2.call(this,pred,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
remove.cljs$core$IFn$_invoke$arity$1 = remove__1;
remove.cljs$core$IFn$_invoke$arity$2 = remove__2;
return remove;
})()
;
/**
* Returns a lazy sequence of the nodes in a tree, via a depth-first walk.
* branch? must be a fn of one arg that returns true if passed a node
* that can have children (but may not).  children must be a fn of one
* arg that returns a sequence of the children. Will only be called on
* nodes for which branch? returns true. Root is the root node of the
* tree.
*/
cljs.core.tree_seq = (function tree_seq(branch_QMARK_,children,root){
var walk = (function walk(node){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons(node,(cljs.core.truth_((function (){var G__11195 = node;
return (branch_QMARK_.cljs$core$IFn$_invoke$arity$1 ? branch_QMARK_.cljs$core$IFn$_invoke$arity$1(G__11195) : branch_QMARK_.call(null,G__11195));
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(walk,cljs.core.array_seq([(function (){var G__11196 = node;
return (children.cljs$core$IFn$_invoke$arity$1 ? children.cljs$core$IFn$_invoke$arity$1(G__11196) : children.call(null,G__11196));
})()], 0)):null));
}),null,null));
});
return walk(root);
});
/**
* Takes any nested combination of sequential things (lists, vectors,
* etc.) and returns their contents as a single, flat sequence.
* (flatten nil) returns nil.
*/
cljs.core.flatten = (function flatten(x){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__11197_SHARP_){
return !(cljs.core.sequential_QMARK_(p1__11197_SHARP_));
}),cljs.core.rest(cljs.core.tree_seq(cljs.core.sequential_QMARK_,cljs.core.seq,x)));
});
/**
* Returns a new coll consisting of to-coll with all of the items of
* from-coll conjoined. A transducer may be supplied.
*/
cljs.core.into = (function() {
var into = null;
var into__2 = (function (to,from){
if(!((to == null))){
if((function (){var G__11200 = to;
if(G__11200){
var bit__4432__auto__ = (G__11200.cljs$lang$protocol_mask$partition1$ & (4));
if((bit__4432__auto__) || (G__11200.cljs$core$IEditableCollection$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,to,from);
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,from);
}
});
var into__3 = (function (to,xform,from){
if((function (){var G__11201 = to;
if(G__11201){
var bit__4432__auto__ = (G__11201.cljs$lang$protocol_mask$partition1$ & (4));
if((bit__4432__auto__) || (G__11201.cljs$core$IEditableCollection$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj,to,from);
}
});
into = function(to,xform,from){
switch(arguments.length){
case 2:
return into__2.call(this,to,xform);
case 3:
return into__3.call(this,to,xform,from);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
into.cljs$core$IFn$_invoke$arity$2 = into__2;
into.cljs$core$IFn$_invoke$arity$3 = into__3;
return into;
})()
;
/**
* Returns a vector consisting of the result of applying f to the
* set of first items of each coll, followed by applying f to the set
* of second items in each coll, until any one of the colls is
* exhausted.  Any remaining items in other colls are ignored. Function
* f should accept number-of-colls arguments.
* @param {...*} var_args
*/
cljs.core.mapv = (function() {
var mapv = null;
var mapv__2 = (function (f,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,(function (){var G__11203 = o;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11203) : f.call(null,G__11203));
})());
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});
var mapv__3 = (function (f,c1,c2){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,c1,c2));
});
var mapv__4 = (function (f,c1,c2,c3){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,c1,c2,c3));
});
var mapv__5 = (function() { 
var G__11204__delegate = function (f,c1,c2,c3,colls){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map,f,c1,c2,c3,cljs.core.array_seq([colls], 0)));
};
var G__11204 = function (f,c1,c2,c3,var_args){
var colls = null;
if (arguments.length > 4) {
var G__11205__i = 0, G__11205__a = new Array(arguments.length -  4);
while (G__11205__i < G__11205__a.length) {G__11205__a[G__11205__i] = arguments[G__11205__i + 4]; ++G__11205__i;}
  colls = new cljs.core.IndexedSeq(G__11205__a,0);
} 
return G__11204__delegate.call(this,f,c1,c2,c3,colls);};
G__11204.cljs$lang$maxFixedArity = 4;
G__11204.cljs$lang$applyTo = (function (arglist__11206){
var f = cljs.core.first(arglist__11206);
arglist__11206 = cljs.core.next(arglist__11206);
var c1 = cljs.core.first(arglist__11206);
arglist__11206 = cljs.core.next(arglist__11206);
var c2 = cljs.core.first(arglist__11206);
arglist__11206 = cljs.core.next(arglist__11206);
var c3 = cljs.core.first(arglist__11206);
var colls = cljs.core.rest(arglist__11206);
return G__11204__delegate(f,c1,c2,c3,colls);
});
G__11204.cljs$core$IFn$_invoke$arity$variadic = G__11204__delegate;
return G__11204;
})()
;
mapv = function(f,c1,c2,c3,var_args){
var colls = var_args;
switch(arguments.length){
case 2:
return mapv__2.call(this,f,c1);
case 3:
return mapv__3.call(this,f,c1,c2);
case 4:
return mapv__4.call(this,f,c1,c2,c3);
default:
var G__11207 = null;
if (arguments.length > 4) {
var G__11208__i = 0, G__11208__a = new Array(arguments.length -  4);
while (G__11208__i < G__11208__a.length) {G__11208__a[G__11208__i] = arguments[G__11208__i + 4]; ++G__11208__i;}
G__11207 = new cljs.core.IndexedSeq(G__11208__a,0);
}
return mapv__5.cljs$core$IFn$_invoke$arity$variadic(f,c1,c2,c3, G__11207);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
mapv.cljs$lang$maxFixedArity = 4;
mapv.cljs$lang$applyTo = mapv__5.cljs$lang$applyTo;
mapv.cljs$core$IFn$_invoke$arity$2 = mapv__2;
mapv.cljs$core$IFn$_invoke$arity$3 = mapv__3;
mapv.cljs$core$IFn$_invoke$arity$4 = mapv__4;
mapv.cljs$core$IFn$_invoke$arity$variadic = mapv__5.cljs$core$IFn$_invoke$arity$variadic;
return mapv;
})()
;
/**
* Returns a vector of the items in coll for which
* (pred item) returns true. pred must be free of side-effects.
*/
cljs.core.filterv = (function filterv(pred,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
if(cljs.core.truth_((function (){var G__11210 = o;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__11210) : pred.call(null,G__11210));
})())){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,o);
} else {
return v;
}
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});
/**
* Returns a lazy sequence of lists of n items each, at offsets step
* apart. If step is not supplied, defaults to n, i.e. the partitions
* do not overlap. If a pad collection is supplied, use its elements as
* necessary to complete last partition up to n items. In case there are
* not enough padding elements, return a partition with less than n items.
*/
cljs.core.partition = (function() {
var partition = null;
var partition__2 = (function (n,coll){
return partition.cljs$core$IFn$_invoke$arity$3(n,n,coll);
});
var partition__3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,partition.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});
var partition__4 = (function (n,step,pad,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,partition.cljs$core$IFn$_invoke$arity$4(n,step,pad,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return cljs.core._conj(cljs.core.List.EMPTY,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(p,pad)));
}
} else {
return null;
}
}),null,null));
});
partition = function(n,step,pad,coll){
switch(arguments.length){
case 2:
return partition__2.call(this,n,step);
case 3:
return partition__3.call(this,n,step,pad);
case 4:
return partition__4.call(this,n,step,pad,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partition.cljs$core$IFn$_invoke$arity$2 = partition__2;
partition.cljs$core$IFn$_invoke$arity$3 = partition__3;
partition.cljs$core$IFn$_invoke$arity$4 = partition__4;
return partition;
})()
;
/**
* Returns the value in a nested associative structure,
* where ks is a sequence of keys. Returns nil if the key is not present,
* or the not-found value if supplied.
*/
cljs.core.get_in = (function() {
var get_in = null;
var get_in__2 = (function (m,ks){
return get_in.cljs$core$IFn$_invoke$arity$3(m,ks,null);
});
var get_in__3 = (function (m,ks,not_found){
var sentinel = cljs.core.lookup_sentinel;
var m__$1 = m;
var ks__$1 = cljs.core.seq(ks);
while(true){
if(ks__$1){
if(!((function (){var G__11225 = m__$1;
if(G__11225){
var bit__4439__auto__ = (G__11225.cljs$lang$protocol_mask$partition0$ & (256));
if((bit__4439__auto__) || (G__11225.cljs$core$ILookup$)){
return true;
} else {
if((!G__11225.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,G__11225);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,G__11225);
}
})())){
return not_found;
} else {
var m__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core.first(ks__$1),sentinel);
if((sentinel === m__$2)){
return not_found;
} else {
var G__11226 = sentinel;
var G__11227 = m__$2;
var G__11228 = cljs.core.next(ks__$1);
sentinel = G__11226;
m__$1 = G__11227;
ks__$1 = G__11228;
continue;
}
}
} else {
return m__$1;
}
break;
}
});
get_in = function(m,ks,not_found){
switch(arguments.length){
case 2:
return get_in__2.call(this,m,ks);
case 3:
return get_in__3.call(this,m,ks,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
get_in.cljs$core$IFn$_invoke$arity$2 = get_in__2;
get_in.cljs$core$IFn$_invoke$arity$3 = get_in__3;
return get_in;
})()
;
/**
* Associates a value in a nested associative structure, where ks is a
* sequence of keys and v is the new value and returns a new nested structure.
* If any levels do not exist, hash-maps will be created.
*/
cljs.core.assoc_in = (function assoc_in(m,p__11229,v){
var vec__11234 = p__11229;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11234,(0),null);
var ks = cljs.core.nthnext(vec__11234,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,assoc_in(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,v));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
/**
* 'Updates' a value in a nested associative structure, where ks is a
* sequence of keys and f is a function that will take the old value
* and any supplied args and return the new value, and returns a new
* nested structure.  If any levels do not exist, hash-maps will be
* created.
* @param {...*} var_args
*/
cljs.core.update_in = (function() {
var update_in = null;
var update_in__3 = (function (m,p__11235,f){
var vec__11273 = p__11235;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11273,(0),null);
var ks = cljs.core.nthnext(vec__11273,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__11274 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11274) : f.call(null,G__11274));
})());
}
});
var update_in__4 = (function (m,p__11236,f,a){
var vec__11275 = p__11236;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11275,(0),null);
var ks = cljs.core.nthnext(vec__11275,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__11276 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__11277 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11276,G__11277) : f.call(null,G__11276,G__11277));
})());
}
});
var update_in__5 = (function (m,p__11237,f,a,b){
var vec__11278 = p__11237;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11278,(0),null);
var ks = cljs.core.nthnext(vec__11278,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__11279 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__11280 = a;
var G__11281 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11279,G__11280,G__11281) : f.call(null,G__11279,G__11280,G__11281));
})());
}
});
var update_in__6 = (function (m,p__11238,f,a,b,c){
var vec__11282 = p__11238;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11282,(0),null);
var ks = cljs.core.nthnext(vec__11282,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,update_in.cljs$core$IFn$_invoke$arity$6(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b,c));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__11283 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__11284 = a;
var G__11285 = b;
var G__11286 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__11283,G__11284,G__11285,G__11286) : f.call(null,G__11283,G__11284,G__11285,G__11286));
})());
}
});
var update_in__7 = (function() { 
var G__11288__delegate = function (m,p__11239,f,a,b,c,args){
var vec__11287 = p__11239;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11287,(0),null);
var ks = cljs.core.nthnext(vec__11287,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(update_in,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,cljs.core.array_seq([b,c,args], 0)));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),a,b,c,cljs.core.array_seq([args], 0)));
}
};
var G__11288 = function (m,p__11239,f,a,b,c,var_args){
var args = null;
if (arguments.length > 6) {
var G__11289__i = 0, G__11289__a = new Array(arguments.length -  6);
while (G__11289__i < G__11289__a.length) {G__11289__a[G__11289__i] = arguments[G__11289__i + 6]; ++G__11289__i;}
  args = new cljs.core.IndexedSeq(G__11289__a,0);
} 
return G__11288__delegate.call(this,m,p__11239,f,a,b,c,args);};
G__11288.cljs$lang$maxFixedArity = 6;
G__11288.cljs$lang$applyTo = (function (arglist__11290){
var m = cljs.core.first(arglist__11290);
arglist__11290 = cljs.core.next(arglist__11290);
var p__11239 = cljs.core.first(arglist__11290);
arglist__11290 = cljs.core.next(arglist__11290);
var f = cljs.core.first(arglist__11290);
arglist__11290 = cljs.core.next(arglist__11290);
var a = cljs.core.first(arglist__11290);
arglist__11290 = cljs.core.next(arglist__11290);
var b = cljs.core.first(arglist__11290);
arglist__11290 = cljs.core.next(arglist__11290);
var c = cljs.core.first(arglist__11290);
var args = cljs.core.rest(arglist__11290);
return G__11288__delegate(m,p__11239,f,a,b,c,args);
});
G__11288.cljs$core$IFn$_invoke$arity$variadic = G__11288__delegate;
return G__11288;
})()
;
update_in = function(m,p__11239,f,a,b,c,var_args){
var args = var_args;
switch(arguments.length){
case 3:
return update_in__3.call(this,m,p__11239,f);
case 4:
return update_in__4.call(this,m,p__11239,f,a);
case 5:
return update_in__5.call(this,m,p__11239,f,a,b);
case 6:
return update_in__6.call(this,m,p__11239,f,a,b,c);
default:
var G__11291 = null;
if (arguments.length > 6) {
var G__11292__i = 0, G__11292__a = new Array(arguments.length -  6);
while (G__11292__i < G__11292__a.length) {G__11292__a[G__11292__i] = arguments[G__11292__i + 6]; ++G__11292__i;}
G__11291 = new cljs.core.IndexedSeq(G__11292__a,0);
}
return update_in__7.cljs$core$IFn$_invoke$arity$variadic(m,p__11239,f,a,b,c, G__11291);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
update_in.cljs$lang$maxFixedArity = 6;
update_in.cljs$lang$applyTo = update_in__7.cljs$lang$applyTo;
update_in.cljs$core$IFn$_invoke$arity$3 = update_in__3;
update_in.cljs$core$IFn$_invoke$arity$4 = update_in__4;
update_in.cljs$core$IFn$_invoke$arity$5 = update_in__5;
update_in.cljs$core$IFn$_invoke$arity$6 = update_in__6;
update_in.cljs$core$IFn$_invoke$arity$variadic = update_in__7.cljs$core$IFn$_invoke$arity$variadic;
return update_in;
})()
;
/**
* 'Updates' a value in an associative structure, where k is a
* key and f is a function that will take the old value
* and any supplied args and return the new value, and returns a new
* structure.  If the key does not exist, nil is passed as the old value.
* @param {...*} var_args
*/
cljs.core.update = (function() {
var update = null;
var update__3 = (function (m,k,f){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__11303 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11303) : f.call(null,G__11303));
})());
});
var update__4 = (function (m,k,f,x){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__11304 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__11305 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11304,G__11305) : f.call(null,G__11304,G__11305));
})());
});
var update__5 = (function (m,k,f,x,y){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__11306 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__11307 = x;
var G__11308 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11306,G__11307,G__11308) : f.call(null,G__11306,G__11307,G__11308));
})());
});
var update__6 = (function (m,k,f,x,y,z){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__11309 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__11310 = x;
var G__11311 = y;
var G__11312 = z;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__11309,G__11310,G__11311,G__11312) : f.call(null,G__11309,G__11310,G__11311,G__11312));
})());
});
var update__7 = (function() { 
var G__11313__delegate = function (m,k,f,x,y,z,more){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),x,y,z,cljs.core.array_seq([more], 0)));
};
var G__11313 = function (m,k,f,x,y,z,var_args){
var more = null;
if (arguments.length > 6) {
var G__11314__i = 0, G__11314__a = new Array(arguments.length -  6);
while (G__11314__i < G__11314__a.length) {G__11314__a[G__11314__i] = arguments[G__11314__i + 6]; ++G__11314__i;}
  more = new cljs.core.IndexedSeq(G__11314__a,0);
} 
return G__11313__delegate.call(this,m,k,f,x,y,z,more);};
G__11313.cljs$lang$maxFixedArity = 6;
G__11313.cljs$lang$applyTo = (function (arglist__11315){
var m = cljs.core.first(arglist__11315);
arglist__11315 = cljs.core.next(arglist__11315);
var k = cljs.core.first(arglist__11315);
arglist__11315 = cljs.core.next(arglist__11315);
var f = cljs.core.first(arglist__11315);
arglist__11315 = cljs.core.next(arglist__11315);
var x = cljs.core.first(arglist__11315);
arglist__11315 = cljs.core.next(arglist__11315);
var y = cljs.core.first(arglist__11315);
arglist__11315 = cljs.core.next(arglist__11315);
var z = cljs.core.first(arglist__11315);
var more = cljs.core.rest(arglist__11315);
return G__11313__delegate(m,k,f,x,y,z,more);
});
G__11313.cljs$core$IFn$_invoke$arity$variadic = G__11313__delegate;
return G__11313;
})()
;
update = function(m,k,f,x,y,z,var_args){
var more = var_args;
switch(arguments.length){
case 3:
return update__3.call(this,m,k,f);
case 4:
return update__4.call(this,m,k,f,x);
case 5:
return update__5.call(this,m,k,f,x,y);
case 6:
return update__6.call(this,m,k,f,x,y,z);
default:
var G__11316 = null;
if (arguments.length > 6) {
var G__11317__i = 0, G__11317__a = new Array(arguments.length -  6);
while (G__11317__i < G__11317__a.length) {G__11317__a[G__11317__i] = arguments[G__11317__i + 6]; ++G__11317__i;}
G__11316 = new cljs.core.IndexedSeq(G__11317__a,0);
}
return update__7.cljs$core$IFn$_invoke$arity$variadic(m,k,f,x,y,z, G__11316);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
update.cljs$lang$maxFixedArity = 6;
update.cljs$lang$applyTo = update__7.cljs$lang$applyTo;
update.cljs$core$IFn$_invoke$arity$3 = update__3;
update.cljs$core$IFn$_invoke$arity$4 = update__4;
update.cljs$core$IFn$_invoke$arity$5 = update__5;
update.cljs$core$IFn$_invoke$arity$6 = update__6;
update.cljs$core$IFn$_invoke$arity$variadic = update__7.cljs$core$IFn$_invoke$arity$variadic;
return update;
})()
;

/**
* @constructor
*/
cljs.core.VectorNode = (function (edit,arr){
this.edit = edit;
this.arr = arr;
})

cljs.core.VectorNode.cljs$lang$type = true;

cljs.core.VectorNode.cljs$lang$ctorStr = "cljs.core/VectorNode";

cljs.core.VectorNode.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/VectorNode");
});

cljs.core.__GT_VectorNode = (function __GT_VectorNode(edit,arr){
return (new cljs.core.VectorNode(edit,arr));
});

cljs.core.pv_fresh_node = (function pv_fresh_node(edit){
return (new cljs.core.VectorNode(edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
});
cljs.core.pv_aget = (function pv_aget(node,idx){
return (node.arr[idx]);
});
cljs.core.pv_aset = (function pv_aset(node,idx,val){
return (node.arr[idx] = val);
});
cljs.core.pv_clone_node = (function pv_clone_node(node){
return (new cljs.core.VectorNode(node.edit,cljs.core.aclone(node.arr)));
});
cljs.core.tail_off = (function tail_off(pv){
var cnt = pv.cnt;
if((cnt < (32))){
return (0);
} else {
return (((cnt - (1)) >>> (5)) << (5));
}
});
cljs.core.new_path = (function new_path(edit,level,node){
var ll = level;
var ret = node;
while(true){
if((ll === (0))){
return ret;
} else {
var embed = ret;
var r = cljs.core.pv_fresh_node(edit);
var _ = cljs.core.pv_aset(r,(0),embed);
var G__11318 = (ll - (5));
var G__11319 = r;
ll = G__11318;
ret = G__11319;
continue;
}
break;
}
});
cljs.core.push_tail = (function push_tail(pv,level,parent,tailnode){
var ret = cljs.core.pv_clone_node(parent);
var subidx = (((pv.cnt - (1)) >>> level) & (31));
if(((5) === level)){
cljs.core.pv_aset(ret,subidx,tailnode);

return ret;
} else {
var child = cljs.core.pv_aget(parent,subidx);
if(!((child == null))){
var node_to_insert = push_tail(pv,(level - (5)),child,tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
} else {
var node_to_insert = cljs.core.new_path(null,(level - (5)),tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
}
}
});
cljs.core.vector_index_out_of_bounds = (function vector_index_out_of_bounds(i,cnt){
throw (new Error([cljs.core.str("No item "),cljs.core.str(i),cljs.core.str(" in vector of length "),cljs.core.str(cnt)].join('')));
});
cljs.core.first_array_for_longvec = (function first_array_for_longvec(pv){
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__11324 = cljs.core.pv_aget(node,(0));
var G__11325 = (level - (5));
node = G__11324;
level = G__11325;
continue;
} else {
return node.arr;
}
break;
}
});
cljs.core.unchecked_array_for = (function unchecked_array_for(pv,i){
if((i >= cljs.core.tail_off(pv))){
return pv.tail;
} else {
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__11326 = cljs.core.pv_aget(node,((i >>> level) & (31)));
var G__11327 = (level - (5));
node = G__11326;
level = G__11327;
continue;
} else {
return node.arr;
}
break;
}
}
});
cljs.core.array_for = (function array_for(pv,i){
if((((0) <= i)) && ((i < pv.cnt))){
return cljs.core.unchecked_array_for(pv,i);
} else {
return cljs.core.vector_index_out_of_bounds(i,pv.cnt);
}
});
cljs.core.do_assoc = (function do_assoc(pv,level,node,i,val){
var ret = cljs.core.pv_clone_node(node);
if((level === (0))){
cljs.core.pv_aset(ret,(i & (31)),val);

return ret;
} else {
var subidx = ((i >>> level) & (31));
cljs.core.pv_aset(ret,subidx,do_assoc(pv,(level - (5)),cljs.core.pv_aget(node,subidx),i,val));

return ret;
}
});
cljs.core.pop_tail = (function pop_tail(pv,level,node){
var subidx = (((pv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = pop_tail(pv,(level - (5)),cljs.core.pv_aget(node,subidx));
if(((new_child == null)) && ((subidx === (0)))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,new_child);

return ret;
}
} else {
if((subidx === (0))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,null);

return ret;

}
}
});

/**
* @constructor
*/
cljs.core.RangedIterator = (function (i,base,arr,v,start,end){
this.i = i;
this.base = base;
this.arr = arr;
this.v = v;
this.start = start;
this.end = end;
})
cljs.core.RangedIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
return (self__.i < self__.end);
});

cljs.core.RangedIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(((self__.i - self__.base) === (32))){
self__.arr = cljs.core.unchecked_array_for(self__.v,self__.i);

self__.base = (self__.base + (32));
} else {
}

var ret = (self__.arr[(self__.i & (31))]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.RangedIterator.cljs$lang$type = true;

cljs.core.RangedIterator.cljs$lang$ctorStr = "cljs.core/RangedIterator";

cljs.core.RangedIterator.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/RangedIterator");
});

cljs.core.__GT_RangedIterator = (function __GT_RangedIterator(i,base,arr,v,start,end){
return (new cljs.core.RangedIterator(i,base,arr,v,start,end));
});

cljs.core.ranged_iterator = (function ranged_iterator(v,start,end){
var i = start;
return (new cljs.core.RangedIterator(i,(i - (i % (32))),(((start < cljs.core.count(v)))?cljs.core.unchecked_array_for(v,i):null),v,start,end));
});







/**
* @constructor
*/
cljs.core.PersistentVector = (function (meta,cnt,shift,root,tail,__hash){
this.meta = meta;
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167668511;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentVector.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentVector.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__11337 = init__$2;
var G__11338 = (j + i);
var G__11339 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11337,G__11338,G__11339) : f.call(null,G__11337,G__11338,G__11339));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__11350 = (j + (1));
var G__11351 = init__$3;
j = G__11350;
init__$2 = G__11351;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__11340 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11340) : cljs.core.deref.call(null,G__11340));
} else {
var G__11352 = (i + len);
var G__11353 = init__$2;
i = G__11352;
init__$1 = G__11353;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
});

cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
return (cljs.core.unchecked_array_for(coll__$1,n)[(n & (31))]);
} else {
return not_found;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
if((cljs.core.tail_off(coll__$1) <= n)){
var new_tail = cljs.core.aclone(self__.tail);
(new_tail[(n & (31))] = val);

return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,cljs.core.do_assoc(coll__$1,self__.shift,self__.root,n,val),self__.tail,null));
}
} else {
if((n === self__.cnt)){
return cljs.core._conj(coll__$1,val);
} else {
throw (new Error([cljs.core.str("Index "),cljs.core.str(n),cljs.core.str(" out of bounds  [0,"),cljs.core.str(self__.cnt),cljs.core.str("]")].join('')));

}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IIterable$ = true;

cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.ranged_iterator(this$__$1,(0),self__.cnt);
});

cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
});

cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(0));
});

cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(1));
});

cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(self__.cnt - (1)));
} else {
return null;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
} else {
if(((1) < (self__.cnt - cljs.core.tail_off(coll__$1)))){
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt - (1)),self__.shift,self__.root,self__.tail.slice((0),(-1)),null));
} else {
var new_tail = cljs.core.unchecked_array_for(coll__$1,(self__.cnt - (2)));
var nr = cljs.core.pop_tail(coll__$1,self__.shift,self__.root);
var new_root = (((nr == null))?cljs.core.PersistentVector.EMPTY_NODE:nr);
var cnt_1 = (self__.cnt - (1));
if((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null))){
return (new cljs.core.PersistentVector(self__.meta,cnt_1,(self__.shift - (5)),cljs.core.pv_aget(new_root,(0)),new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,cnt_1,self__.shift,new_root,new_tail,null));
}

}
}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return (new cljs.core.RSeq(coll__$1,(self__.cnt - (1)),null));
} else {
return null;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if((other instanceof cljs.core.PersistentVector)){
if((self__.cnt === cljs.core.count(other))){
var me_iter = cljs.core._iterator(coll__$1);
var you_iter = cljs.core._iterator(other);
while(true){
if(cljs.core.truth_(me_iter.hasNext())){
var x = me_iter.next();
var y = you_iter.next();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_sequential(coll__$1,other);
}
});

cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientVector(self__.cnt,self__.shift,(function (){var G__11341 = self__.root;
return (cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1(G__11341) : cljs.core.tv_editable_root.call(null,G__11341));
})(),(function (){var G__11342 = self__.tail;
return (cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1(G__11342) : cljs.core.tv_editable_tail.call(null,G__11342));
})()));
});

cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (v,f){
var self__ = this;
var v__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(v__$1,f);
});

cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__11343 = init__$2;
var G__11344 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11343,G__11344) : f.call(null,G__11343,G__11344));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__11354 = (j + (1));
var G__11355 = init__$3;
j = G__11354;
init__$2 = G__11355;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__11345 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11345) : cljs.core.deref.call(null,G__11345));
} else {
var G__11356 = (i + len);
var G__11357 = init__$2;
i = G__11356;
init__$1 = G__11357;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._assoc_n(coll__$1,k,v);
} else {
throw (new Error("Vector's key for assoc must be a number."));
}
});

cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
return null;
} else {
if((self__.cnt <= (32))){
return (new cljs.core.IndexedSeq(self__.tail,(0)));
} else {
var G__11346 = coll__$1;
var G__11347 = cljs.core.first_array_for_longvec(coll__$1);
var G__11348 = (0);
var G__11349 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__11346,G__11347,G__11348,G__11349) : cljs.core.chunked_seq.call(null,G__11346,G__11347,G__11348,G__11349));

}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentVector(meta__$1,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
});

cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(((self__.cnt - cljs.core.tail_off(coll__$1)) < (32))){
var len = self__.tail.length;
var new_tail = (new Array((len + (1))));
var n__4645__auto___11358 = len;
var i_11359 = (0);
while(true){
if((i_11359 < n__4645__auto___11358)){
(new_tail[i_11359] = (self__.tail[i_11359]));

var G__11360 = (i_11359 + (1));
i_11359 = G__11360;
continue;
} else {
}
break;
}

(new_tail[len] = o);

return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),self__.shift,self__.root,new_tail,null));
} else {
var root_overflow_QMARK_ = ((self__.cnt >>> (5)) > ((1) << self__.shift));
var new_shift = ((root_overflow_QMARK_)?(self__.shift + (5)):self__.shift);
var new_root = ((root_overflow_QMARK_)?(function (){var n_r = cljs.core.pv_fresh_node(null);
cljs.core.pv_aset(n_r,(0),self__.root);

cljs.core.pv_aset(n_r,(1),cljs.core.new_path(null,self__.shift,(new cljs.core.VectorNode(null,self__.tail))));

return n_r;
})():cljs.core.push_tail(coll__$1,self__.shift,self__.root,(new cljs.core.VectorNode(null,self__.tail))));
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),new_shift,new_root,[o],null));
}
});

cljs.core.PersistentVector.prototype.call = (function() {
var G__11361 = null;
var G__11361__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__11361__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__11361 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__11361__2.call(this,self__,k);
case 3:
return G__11361__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11361.cljs$core$IFn$_invoke$arity$2 = G__11361__2;
G__11361.cljs$core$IFn$_invoke$arity$3 = G__11361__3;
return G__11361;
})()
;

cljs.core.PersistentVector.prototype.apply = (function (self__,args11336){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args11336)));
});

cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});

cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.PersistentVector.cljs$lang$type = true;

cljs.core.PersistentVector.cljs$lang$ctorStr = "cljs.core/PersistentVector";

cljs.core.PersistentVector.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/PersistentVector");
});

cljs.core.__GT_PersistentVector = (function __GT_PersistentVector(meta,cnt,shift,root,tail,__hash){
return (new cljs.core.PersistentVector(meta,cnt,shift,root,tail,__hash));
});

cljs.core.PersistentVector.EMPTY_NODE = (new cljs.core.VectorNode(null,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
cljs.core.PersistentVector.EMPTY = (new cljs.core.PersistentVector(null,(0),(5),cljs.core.PersistentVector.EMPTY_NODE,[],cljs.core.empty_ordered_hash));
cljs.core.PersistentVector.fromArray = (function (xs,no_clone){
var l = xs.length;
var xs__$1 = ((no_clone)?xs:cljs.core.aclone(xs));
if((l < (32))){
return (new cljs.core.PersistentVector(null,l,(5),cljs.core.PersistentVector.EMPTY_NODE,xs__$1,null));
} else {
var node = xs__$1.slice((0),(32));
var v = (new cljs.core.PersistentVector(null,(32),(5),cljs.core.PersistentVector.EMPTY_NODE,node,null));
var i = (32);
var out = v.cljs$core$IEditableCollection$_as_transient$arity$1(null);
while(true){
if((i < l)){
var G__11362 = (i + (1));
var G__11363 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(out,(xs__$1[i]));
i = G__11362;
out = G__11363;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}
});
(cljs.core.PersistentVector.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
cljs.core.vec = (function vec(coll){
if(coll instanceof Array){
return cljs.core.PersistentVector.fromArray(coll,true);
} else {
return cljs.core._persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core._as_transient(cljs.core.PersistentVector.EMPTY),coll));
}
});
/**
* @param {...*} var_args
*/
cljs.core.vector = (function() { 
var vector__delegate = function (args){
if(((args instanceof cljs.core.IndexedSeq)) && ((args.i === (0)))){
return cljs.core.PersistentVector.fromArray(args.arr,true);
} else {
return cljs.core.vec(args);
}
};
var vector = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__11364__i = 0, G__11364__a = new Array(arguments.length -  0);
while (G__11364__i < G__11364__a.length) {G__11364__a[G__11364__i] = arguments[G__11364__i + 0]; ++G__11364__i;}
  args = new cljs.core.IndexedSeq(G__11364__a,0);
} 
return vector__delegate.call(this,args);};
vector.cljs$lang$maxFixedArity = 0;
vector.cljs$lang$applyTo = (function (arglist__11365){
var args = cljs.core.seq(arglist__11365);
return vector__delegate(args);
});
vector.cljs$core$IFn$_invoke$arity$variadic = vector__delegate;
return vector;
})()
;

/**
* @constructor
*/
cljs.core.ChunkedSeq = (function (vec,node,i,off,meta,__hash){
this.vec = vec;
this.node = node;
this.i = i;
this.off = off;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375020;
this.cljs$lang$protocol_mask$partition1$ = 1536;
})
cljs.core.ChunkedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ChunkedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = (function (){var G__11366 = self__.vec;
var G__11367 = self__.node;
var G__11368 = self__.i;
var G__11369 = (self__.off + (1));
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__11366,G__11367,G__11368,G__11369) : cljs.core.chunked_seq.call(null,G__11366,G__11367,G__11368,G__11369));
})();
if((s == null)){
return null;
} else {
return s;
}
} else {
return cljs.core._chunked_next(coll__$1);
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((function (){var G__11370 = self__.vec;
var G__11371 = (self__.i + self__.off);
var G__11372 = cljs.core.count(self__.vec);
return (cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__11370,G__11371,G__11372) : cljs.core.subvec.call(null,G__11370,G__11371,G__11372));
})(),f);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((function (){var G__11373 = self__.vec;
var G__11374 = (self__.i + self__.off);
var G__11375 = cljs.core.count(self__.vec);
return (cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__11373,G__11374,G__11375) : cljs.core.subvec.call(null,G__11373,G__11374,G__11375));
})(),f,start);
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.node[self__.off]);
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = (function (){var G__11376 = self__.vec;
var G__11377 = self__.node;
var G__11378 = self__.i;
var G__11379 = (self__.off + (1));
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__11376,G__11377,G__11378,G__11379) : cljs.core.chunked_seq.call(null,G__11376,G__11377,G__11378,G__11379));
})();
if((s == null)){
return cljs.core.List.EMPTY;
} else {
return s;
}
} else {
return cljs.core._chunked_rest(coll__$1);
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(self__.node,self__.off);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
var G__11380 = self__.vec;
var G__11381 = cljs.core.unchecked_array_for(self__.vec,end);
var G__11382 = end;
var G__11383 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__11380,G__11381,G__11382,G__11383) : cljs.core.chunked_seq.call(null,G__11380,G__11381,G__11382,G__11383));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,m){
var self__ = this;
var coll__$1 = this;
var G__11384 = self__.vec;
var G__11385 = self__.node;
var G__11386 = self__.i;
var G__11387 = self__.off;
var G__11388 = m;
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(G__11384,G__11385,G__11386,G__11387,G__11388) : cljs.core.chunked_seq.call(null,G__11384,G__11385,G__11386,G__11387,G__11388));
});

cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
var G__11389 = self__.vec;
var G__11390 = cljs.core.unchecked_array_for(self__.vec,end);
var G__11391 = end;
var G__11392 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__11389,G__11390,G__11391,G__11392) : cljs.core.chunked_seq.call(null,G__11389,G__11390,G__11391,G__11392));
} else {
return null;
}
});

cljs.core.ChunkedSeq.cljs$lang$type = true;

cljs.core.ChunkedSeq.cljs$lang$ctorStr = "cljs.core/ChunkedSeq";

cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/ChunkedSeq");
});

cljs.core.__GT_ChunkedSeq = (function __GT_ChunkedSeq(vec,node,i,off,meta,__hash){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,__hash));
});

(cljs.core.ChunkedSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
cljs.core.chunked_seq = (function() {
var chunked_seq = null;
var chunked_seq__3 = (function (vec,i,off){
return (new cljs.core.ChunkedSeq(vec,cljs.core.array_for(vec,i),i,off,null,null));
});
var chunked_seq__4 = (function (vec,node,i,off){
return (new cljs.core.ChunkedSeq(vec,node,i,off,null,null));
});
var chunked_seq__5 = (function (vec,node,i,off,meta){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,null));
});
chunked_seq = function(vec,node,i,off,meta){
switch(arguments.length){
case 3:
return chunked_seq__3.call(this,vec,node,i);
case 4:
return chunked_seq__4.call(this,vec,node,i,off);
case 5:
return chunked_seq__5.call(this,vec,node,i,off,meta);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chunked_seq.cljs$core$IFn$_invoke$arity$3 = chunked_seq__3;
chunked_seq.cljs$core$IFn$_invoke$arity$4 = chunked_seq__4;
chunked_seq.cljs$core$IFn$_invoke$arity$5 = chunked_seq__5;
return chunked_seq;
})()
;

/**
* @constructor
*/
cljs.core.Subvec = (function (meta,v,start,end,__hash){
this.meta = meta;
this.v = v;
this.start = start;
this.end = end;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 166617887;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Subvec.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Subvec.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(((n < (0))) || ((self__.end <= (self__.start + n)))){
return cljs.core.vector_index_out_of_bounds(n,(self__.end - self__.start));
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.start + n));
}
});

cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((n < (0))) || ((self__.end <= (self__.start + n)))){
return not_found;
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(self__.v,(self__.start + n),not_found);
}
});

cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
var v_pos = (self__.start + n);
var G__11394 = self__.meta;
var G__11395 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.v,v_pos,val);
var G__11396 = self__.start;
var G__11397 = (function (){var x__4075__auto__ = self__.end;
var y__4076__auto__ = (v_pos + (1));
return ((x__4075__auto__ > y__4076__auto__) ? x__4075__auto__ : y__4076__auto__);
})();
var G__11398 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__11394,G__11395,G__11396,G__11397,G__11398) : cljs.core.build_subvec.call(null,G__11394,G__11395,G__11396,G__11397,G__11398));
});

cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Subvec(self__.meta,self__.v,self__.start,self__.end,self__.__hash));
});

cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.end - self__.start);
});

cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.end - (1)));
});

cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.start === self__.end)){
throw (new Error("Can't pop empty vector"));
} else {
var G__11399 = self__.meta;
var G__11400 = self__.v;
var G__11401 = self__.start;
var G__11402 = (self__.end - (1));
var G__11403 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__11399,G__11400,G__11401,G__11402,G__11403) : cljs.core.build_subvec.call(null,G__11399,G__11400,G__11401,G__11402,G__11403));
}
});

cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(!((self__.start === self__.end))){
return (new cljs.core.RSeq(coll__$1,((self__.end - self__.start) - (1)),null));
} else {
return null;
}
});

cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1,f);
});

cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start__$1){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1,f,start__$1);
});

cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,key,val){
var self__ = this;
var coll__$1 = this;
if(typeof key === 'number'){
return cljs.core._assoc_n(coll__$1,key,val);
} else {
throw (new Error("Subvec's key for assoc must be a number."));
}
});

cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var subvec_seq = ((function (coll__$1){
return (function subvec_seq(i){
if((i === self__.end)){
return null;
} else {
return cljs.core.cons(cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i),(new cljs.core.LazySeq(null,((function (coll__$1){
return (function (){
return subvec_seq((i + (1)));
});})(coll__$1))
,null,null)));
}
});})(coll__$1))
;
return subvec_seq(self__.start);
});

cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
var G__11405 = meta__$1;
var G__11406 = self__.v;
var G__11407 = self__.start;
var G__11408 = self__.end;
var G__11409 = self__.__hash;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__11405,G__11406,G__11407,G__11408,G__11409) : cljs.core.build_subvec.call(null,G__11405,G__11406,G__11407,G__11408,G__11409));
});

cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__11410 = self__.meta;
var G__11411 = cljs.core._assoc_n(self__.v,self__.end,o);
var G__11412 = self__.start;
var G__11413 = (self__.end + (1));
var G__11414 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__11410,G__11411,G__11412,G__11413,G__11414) : cljs.core.build_subvec.call(null,G__11410,G__11411,G__11412,G__11413,G__11414));
});

cljs.core.Subvec.prototype.call = (function() {
var G__11415 = null;
var G__11415__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__11415__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__11415 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__11415__2.call(this,self__,k);
case 3:
return G__11415__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11415.cljs$core$IFn$_invoke$arity$2 = G__11415__2;
G__11415.cljs$core$IFn$_invoke$arity$3 = G__11415__3;
return G__11415;
})()
;

cljs.core.Subvec.prototype.apply = (function (self__,args11393){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args11393)));
});

cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});

cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.Subvec.cljs$lang$type = true;

cljs.core.Subvec.cljs$lang$ctorStr = "cljs.core/Subvec";

cljs.core.Subvec.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/Subvec");
});

cljs.core.__GT_Subvec = (function __GT_Subvec(meta,v,start,end,__hash){
return (new cljs.core.Subvec(meta,v,start,end,__hash));
});

(cljs.core.Subvec.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
cljs.core.build_subvec = (function build_subvec(meta,v,start,end,__hash){
while(true){
if((v instanceof cljs.core.Subvec)){
var G__11416 = meta;
var G__11417 = v.v;
var G__11418 = (v.start + start);
var G__11419 = (v.start + end);
var G__11420 = __hash;
meta = G__11416;
v = G__11417;
start = G__11418;
end = G__11419;
__hash = G__11420;
continue;
} else {
var c = cljs.core.count(v);
if(((start < (0))) || ((end < (0))) || ((start > c)) || ((end > c))){
throw (new Error("Index out of bounds"));
} else {
}

return (new cljs.core.Subvec(meta,v,start,end,__hash));
}
break;
}
});
/**
* Returns a persistent vector of the items in vector from
* start (inclusive) to end (exclusive).  If end is not supplied,
* defaults to (count vector). This operation is O(1) and very fast, as
* the resulting vector shares structure with the original and no
* trimming is done.
*/
cljs.core.subvec = (function() {
var subvec = null;
var subvec__2 = (function (v,start){
return subvec.cljs$core$IFn$_invoke$arity$3(v,start,cljs.core.count(v));
});
var subvec__3 = (function (v,start,end){
return cljs.core.build_subvec(null,v,start,end,null);
});
subvec = function(v,start,end){
switch(arguments.length){
case 2:
return subvec__2.call(this,v,start);
case 3:
return subvec__3.call(this,v,start,end);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
subvec.cljs$core$IFn$_invoke$arity$2 = subvec__2;
subvec.cljs$core$IFn$_invoke$arity$3 = subvec__3;
return subvec;
})()
;
cljs.core.tv_ensure_editable = (function tv_ensure_editable(edit,node){
if((edit === node.edit)){
return node;
} else {
return (new cljs.core.VectorNode(edit,cljs.core.aclone(node.arr)));
}
});
cljs.core.tv_editable_root = (function tv_editable_root(node){
return (new cljs.core.VectorNode((function (){var obj11427 = {};
return obj11427;
})(),cljs.core.aclone(node.arr)));
});
cljs.core.tv_editable_tail = (function tv_editable_tail(tl){
var ret = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
cljs.core.array_copy(tl,(0),ret,(0),tl.length);

return ret;
});
cljs.core.tv_push_tail = (function tv_push_tail(tv,level,parent,tail_node){
var ret = cljs.core.tv_ensure_editable(tv.root.edit,parent);
var subidx = (((tv.cnt - (1)) >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(((level === (5)))?tail_node:(function (){var child = cljs.core.pv_aget(ret,subidx);
if(!((child == null))){
return tv_push_tail(tv,(level - (5)),child,tail_node);
} else {
return cljs.core.new_path(tv.root.edit,(level - (5)),tail_node);
}
})()));

return ret;
});
cljs.core.tv_pop_tail = (function tv_pop_tail(tv,level,node){
var node__$1 = cljs.core.tv_ensure_editable(tv.root.edit,node);
var subidx = (((tv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = tv_pop_tail(tv,(level - (5)),cljs.core.pv_aget(node__$1,subidx));
if(((new_child == null)) && ((subidx === (0)))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,new_child);

return node__$1;
}
} else {
if((subidx === (0))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,null);

return node__$1;

}
}
});
cljs.core.unchecked_editable_array_for = (function unchecked_editable_array_for(tv,i){
if((i >= cljs.core.tail_off(tv))){
return tv.tail;
} else {
var root = tv.root;
var node = root;
var level = tv.shift;
while(true){
if((level > (0))){
var G__11435 = cljs.core.tv_ensure_editable(root.edit,cljs.core.pv_aget(node,((i >>> level) & (31))));
var G__11436 = (level - (5));
node = G__11435;
level = G__11436;
continue;
} else {
return node.arr;
}
break;
}
}
});

/**
* @constructor
*/
cljs.core.TransientVector = (function (cnt,shift,root,tail){
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.cljs$lang$protocol_mask$partition0$ = 275;
this.cljs$lang$protocol_mask$partition1$ = 88;
})
cljs.core.TransientVector.prototype.call = (function() {
var G__11440 = null;
var G__11440__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__11440__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__11440 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__11440__2.call(this,self__,k);
case 3:
return G__11440__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11440.cljs$core$IFn$_invoke$arity$2 = G__11440__2;
G__11440.cljs$core$IFn$_invoke$arity$3 = G__11440__3;
return G__11440;
})()
;

cljs.core.TransientVector.prototype.apply = (function (self__,args11437){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args11437)));
});

cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
} else {
throw (new Error("nth after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,n);
} else {
return not_found;
}
});

cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return self__.cnt;
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = (function (tcoll,n,val){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((((0) <= n)) && ((n < self__.cnt))){
if((cljs.core.tail_off(tcoll__$1) <= n)){
(self__.tail[(n & (31))] = val);

return tcoll__$1;
} else {
var new_root = ((function (tcoll__$1){
return (function go(level,node){
var node__$1 = cljs.core.tv_ensure_editable(self__.root.edit,node);
if((level === (0))){
cljs.core.pv_aset(node__$1,(n & (31)),val);

return node__$1;
} else {
var subidx = ((n >>> level) & (31));
cljs.core.pv_aset(node__$1,subidx,go((level - (5)),cljs.core.pv_aget(node__$1,subidx)));

return node__$1;
}
});})(tcoll__$1))
.call(null,self__.shift,self__.root);
self__.root = new_root;

return tcoll__$1;
}
} else {
if((n === self__.cnt)){
return cljs.core._conj_BANG_(tcoll__$1,val);
} else {
throw (new Error([cljs.core.str("Index "),cljs.core.str(n),cljs.core.str(" out of bounds for TransientVector of length"),cljs.core.str(self__.cnt)].join('')));

}
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
self__.cnt = (0);

return tcoll__$1;
} else {
if((((self__.cnt - (1)) & (31)) > (0))){
self__.cnt = (self__.cnt - (1));

return tcoll__$1;
} else {
var new_tail = cljs.core.unchecked_editable_array_for(tcoll__$1,(self__.cnt - (2)));
var new_root = (function (){var nr = cljs.core.tv_pop_tail(tcoll__$1,self__.shift,self__.root);
if(!((nr == null))){
return nr;
} else {
return (new cljs.core.VectorNode(self__.root.edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
}
})();
if((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null))){
var new_root__$1 = cljs.core.tv_ensure_editable(self__.root.edit,cljs.core.pv_aget(new_root,(0)));
self__.root = new_root__$1;

self__.shift = (self__.shift - (5));

self__.cnt = (self__.cnt - (1));

self__.tail = new_tail;

return tcoll__$1;
} else {
self__.root = new_root;

self__.cnt = (self__.cnt - (1));

self__.tail = new_tail;

return tcoll__$1;
}

}
}
}
} else {
throw (new Error("pop! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(typeof key === 'number'){
return cljs.core._assoc_n_BANG_(tcoll__$1,key,val);
} else {
throw (new Error("TransientVector's key for assoc! must be a number."));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((self__.cnt - cljs.core.tail_off(tcoll__$1)) < (32))){
(self__.tail[(self__.cnt & (31))] = o);

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
} else {
var tail_node = (new cljs.core.VectorNode(self__.root.edit,self__.tail));
var new_tail = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(new_tail[(0)] = o);

self__.tail = new_tail;

if(((self__.cnt >>> (5)) > ((1) << self__.shift))){
var new_root_array = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var new_shift = (self__.shift + (5));
(new_root_array[(0)] = self__.root);

(new_root_array[(1)] = cljs.core.new_path(self__.root.edit,self__.shift,tail_node));

self__.root = (new cljs.core.VectorNode(self__.root.edit,new_root_array));

self__.shift = new_shift;

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
} else {
var new_root = cljs.core.tv_push_tail(tcoll__$1,self__.shift,self__.root,tail_node);
self__.root = new_root;

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
self__.root.edit = null;

var len = (self__.cnt - cljs.core.tail_off(tcoll__$1));
var trimmed_tail = (new Array(len));
cljs.core.array_copy(self__.tail,(0),trimmed_tail,(0),len);

return (new cljs.core.PersistentVector(null,self__.cnt,self__.shift,self__.root,trimmed_tail,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientVector.cljs$lang$type = true;

cljs.core.TransientVector.cljs$lang$ctorStr = "cljs.core/TransientVector";

cljs.core.TransientVector.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/TransientVector");
});

cljs.core.__GT_TransientVector = (function __GT_TransientVector(cnt,shift,root,tail){
return (new cljs.core.TransientVector(cnt,shift,root,tail));
});


/**
* @constructor
*/
cljs.core.PersistentQueueSeq = (function (meta,front,rear,__hash){
this.meta = meta;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 31850572;
})
cljs.core.PersistentQueueSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentQueueSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var temp__4124__auto__ = cljs.core.next(self__.front);
if(temp__4124__auto__){
var f1 = temp__4124__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((self__.rear == null)){
return cljs.core._empty(coll__$1);
} else {
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
}
}
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueueSeq(meta__$1,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentQueueSeq.cljs$lang$type = true;

cljs.core.PersistentQueueSeq.cljs$lang$ctorStr = "cljs.core/PersistentQueueSeq";

cljs.core.PersistentQueueSeq.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/PersistentQueueSeq");
});

cljs.core.__GT_PersistentQueueSeq = (function __GT_PersistentQueueSeq(meta,front,rear,__hash){
return (new cljs.core.PersistentQueueSeq(meta,front,rear,__hash));
});

(cljs.core.PersistentQueueSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));

/**
* @constructor
*/
cljs.core.PersistentQueue = (function (meta,count,front,rear,__hash){
this.meta = meta;
this.count = count;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31858766;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentQueue.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentQueue.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(self__.meta,self__.count,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
});

cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
var temp__4124__auto__ = cljs.core.next(self__.front);
if(temp__4124__auto__){
var f1 = temp__4124__auto__;
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),f1,self__.rear,null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),cljs.core.seq(self__.rear),cljs.core.PersistentVector.EMPTY,null));
}
} else {
return coll__$1;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentQueue.EMPTY,self__.meta);
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.rest(cljs.core.seq(coll__$1));
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var rear__$1 = cljs.core.seq(self__.rear);
if(cljs.core.truth_((function (){var or__3758__auto__ = self__.front;
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return rear__$1;
}
})())){
return (new cljs.core.PersistentQueueSeq(null,self__.front,cljs.core.seq(rear__$1),null));
} else {
return null;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(meta__$1,self__.count,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),self__.front,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__3758__auto__ = self__.rear;
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),o),null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.front,o),cljs.core.PersistentVector.EMPTY,null));
}
});

cljs.core.PersistentQueue.cljs$lang$type = true;

cljs.core.PersistentQueue.cljs$lang$ctorStr = "cljs.core/PersistentQueue";

cljs.core.PersistentQueue.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/PersistentQueue");
});

cljs.core.__GT_PersistentQueue = (function __GT_PersistentQueue(meta,count,front,rear,__hash){
return (new cljs.core.PersistentQueue(meta,count,front,rear,__hash));
});

cljs.core.PersistentQueue.EMPTY = (new cljs.core.PersistentQueue(null,(0),null,cljs.core.PersistentVector.EMPTY,cljs.core.empty_ordered_hash));
(cljs.core.PersistentQueue.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));

/**
* @constructor
*/
cljs.core.NeverEquiv = (function (){
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 2097152;
})
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return false;
});

cljs.core.NeverEquiv.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.NeverEquiv.cljs$lang$type = true;

cljs.core.NeverEquiv.cljs$lang$ctorStr = "cljs.core/NeverEquiv";

cljs.core.NeverEquiv.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/NeverEquiv");
});

cljs.core.__GT_NeverEquiv = (function __GT_NeverEquiv(){
return (new cljs.core.NeverEquiv());
});

cljs.core.never_equiv = (new cljs.core.NeverEquiv());
/**
* Assumes y is a map. Returns true if x equals y, otherwise returns
* false.
*/
cljs.core.equiv_map = (function equiv_map(x,y){
return cljs.core.boolean$(((cljs.core.map_QMARK_(y))?(((cljs.core.count(x) === cljs.core.count(y)))?cljs.core.every_QMARK_(cljs.core.identity,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (xkv){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y,cljs.core.first(xkv),cljs.core.never_equiv),cljs.core.second(xkv));
}),x)):null):null));
});
cljs.core.scan_array = (function scan_array(incr,k,array){
var len = array.length;
var i = (0);
while(true){
if((i < len)){
if((k === (array[i]))){
return i;
} else {
var G__11441 = (i + incr);
i = G__11441;
continue;
}
} else {
return null;
}
break;
}
});
cljs.core.obj_map_compare_keys = (function obj_map_compare_keys(a,b){
var a__$1 = cljs.core.hash(a);
var b__$1 = cljs.core.hash(b);
if((a__$1 < b__$1)){
return (-1);
} else {
if((a__$1 > b__$1)){
return (1);
} else {
return (0);

}
}
});
cljs.core.obj_map__GT_hash_map = (function obj_map__GT_hash_map(m,k,v){
var ks = m.keys;
var len = ks.length;
var so = m.strobj;
var mm = cljs.core.meta(m);
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var k__$1 = (ks[i]);
var G__11442 = (i + (1));
var G__11443 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k__$1,(so[k__$1]));
i = G__11442;
out = G__11443;
continue;
} else {
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k,v)),mm);
}
break;
}
});
cljs.core.obj_clone = (function obj_clone(obj,ks){
var new_obj = (function (){var obj11447 = {};
return obj11447;
})();
var l = ks.length;
var i_11448 = (0);
while(true){
if((i_11448 < l)){
var k_11449 = (ks[i_11448]);
(new_obj[k_11449] = (obj[k_11449]));

var G__11450 = (i_11448 + (1));
i_11448 = G__11450;
continue;
} else {
}
break;
}

return new_obj;
});

/**
* @constructor
*/
cljs.core.ObjMap = (function (meta,keys,strobj,update_count,__hash){
this.meta = meta;
this.keys = keys;
this.strobj = strobj;
this.update_count = update_count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 4;
})
cljs.core.ObjMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ObjMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var and__3746__auto__ = (function (){var G__11454 = k;
return goog.isString(G__11454);
})();
if(cljs.core.truth_(and__3746__auto__)){
return !((cljs.core.scan_array((1),k,self__.keys) == null));
} else {
return and__3746__auto__;
}
})())){
return (self__.strobj[k]);
} else {
return not_found;
}
});

cljs.core.ObjMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.keys.length;
var keys__$1 = self__.keys.sort(cljs.core.obj_map_compare_keys);
var init__$1 = init;
while(true){
if(cljs.core.seq(keys__$1)){
var k = cljs.core.first(keys__$1);
var init__$2 = (function (){var G__11455 = init__$1;
var G__11456 = k;
var G__11457 = (self__.strobj[k]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11455,G__11456,G__11457) : f.call(null,G__11455,G__11456,G__11457));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__11458 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11458) : cljs.core.deref.call(null,G__11458));
} else {
var G__11464 = cljs.core.rest(keys__$1);
var G__11465 = init__$2;
keys__$1 = G__11464;
init__$1 = G__11465;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.keys.length;
});

cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.transient$(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1));
});

cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.ObjMap.EMPTY,self__.meta);
});

cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var and__3746__auto__ = (function (){var G__11460 = k;
return goog.isString(G__11460);
})();
if(cljs.core.truth_(and__3746__auto__)){
return !((cljs.core.scan_array((1),k,self__.keys) == null));
} else {
return and__3746__auto__;
}
})())){
var new_keys = cljs.core.aclone(self__.keys);
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
new_keys.splice(cljs.core.scan_array((1),k,new_keys),(1));

delete new_strobj[k];

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
} else {
return coll__$1;
}
});

cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var G__11461 = k;
return goog.isString(G__11461);
})())){
if(((self__.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD)) || ((self__.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD))){
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
} else {
if(!((cljs.core.scan_array((1),k,self__.keys) == null))){
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
(new_strobj[k] = v);

return (new cljs.core.ObjMap(self__.meta,self__.keys,new_strobj,(self__.update_count + (1)),null));
} else {
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
var new_keys = cljs.core.aclone(self__.keys);
(new_strobj[k] = v);

new_keys.push(k);

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
}
}
} else {
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
}
});

cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var and__3746__auto__ = (function (){var G__11463 = k;
return goog.isString(G__11463);
})();
if(cljs.core.truth_(and__3746__auto__)){
return !((cljs.core.scan_array((1),k,self__.keys) == null));
} else {
return and__3746__auto__;
}
})())){
return true;
} else {
return false;
}
});

cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.keys.length > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (coll__$1){
return (function (p1__11451_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__11451_SHARP_,(self__.strobj[p1__11451_SHARP_])],null));
});})(coll__$1))
,self__.keys.sort(cljs.core.obj_map_compare_keys));
} else {
return null;
}
});

cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ObjMap(meta__$1,self__.keys,self__.strobj,self__.update_count,self__.__hash));
});

cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,coll__$1,entry);
}
});

cljs.core.ObjMap.prototype.call = (function() {
var G__11466 = null;
var G__11466__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__11466__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__11466 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__11466__2.call(this,self__,k);
case 3:
return G__11466__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11466.cljs$core$IFn$_invoke$arity$2 = G__11466__2;
G__11466.cljs$core$IFn$_invoke$arity$3 = G__11466__3;
return G__11466;
})()
;

cljs.core.ObjMap.prototype.apply = (function (self__,args11452){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args11452)));
});

cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.ObjMap.cljs$lang$type = true;

cljs.core.ObjMap.cljs$lang$ctorStr = "cljs.core/ObjMap";

cljs.core.ObjMap.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/ObjMap");
});

cljs.core.__GT_ObjMap = (function __GT_ObjMap(meta,keys,strobj,update_count,__hash){
return (new cljs.core.ObjMap(meta,keys,strobj,update_count,__hash));
});

cljs.core.ObjMap.EMPTY = (new cljs.core.ObjMap(null,[],(function (){var obj11468 = {};
return obj11468;
})(),(0),cljs.core.empty_unordered_hash));
cljs.core.ObjMap.HASHMAP_THRESHOLD = (8);
cljs.core.ObjMap.fromObject = (function (ks,obj){
return (new cljs.core.ObjMap(null,ks,obj,(0),null));
});

/**
* @constructor
*/
cljs.core.ES6EntriesIterator = (function (s){
this.s = s;
})
cljs.core.ES6EntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var vec__11469 = cljs.core.first(self__.s);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11469,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11469,(1),null);
self__.s = cljs.core.next(self__.s);

return {"done": false, "value": [k,v]};
} else {
return {"done": true, "value": null};
}
});

cljs.core.ES6EntriesIterator.cljs$lang$type = true;

cljs.core.ES6EntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6EntriesIterator";

cljs.core.ES6EntriesIterator.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/ES6EntriesIterator");
});

cljs.core.__GT_ES6EntriesIterator = (function __GT_ES6EntriesIterator(s){
return (new cljs.core.ES6EntriesIterator(s));
});

cljs.core.es6_entries_iterator = (function es6_entries_iterator(coll){
return (new cljs.core.ES6EntriesIterator(cljs.core.seq(coll)));
});

/**
* @constructor
*/
cljs.core.ES6SetEntriesIterator = (function (s){
this.s = s;
})
cljs.core.ES6SetEntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var x = cljs.core.first(self__.s);
self__.s = cljs.core.next(self__.s);

return {"done": false, "value": [x,x]};
} else {
return {"done": true, "value": null};
}
});

cljs.core.ES6SetEntriesIterator.cljs$lang$type = true;

cljs.core.ES6SetEntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6SetEntriesIterator";

cljs.core.ES6SetEntriesIterator.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/ES6SetEntriesIterator");
});

cljs.core.__GT_ES6SetEntriesIterator = (function __GT_ES6SetEntriesIterator(s){
return (new cljs.core.ES6SetEntriesIterator(s));
});

cljs.core.es6_set_entries_iterator = (function es6_set_entries_iterator(coll){
return (new cljs.core.ES6SetEntriesIterator(cljs.core.seq(coll)));
});
cljs.core.array_map_index_of_nil_QMARK_ = (function array_map_index_of_nil_QMARK_(arr,m,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((arr[i]) == null)){
return i;
} else {
var G__11470 = (i + (2));
i = G__11470;
continue;

}
}
break;
}
});
cljs.core.array_map_index_of_keyword_QMARK_ = (function array_map_index_of_keyword_QMARK_(arr,m,k){
var len = arr.length;
var kstr = k.fqn;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((function (){var k_SINGLEQUOTE_ = (arr[i]);
return ((k_SINGLEQUOTE_ instanceof cljs.core.Keyword)) && ((kstr === k_SINGLEQUOTE_.fqn));
})()){
return i;
} else {
var G__11471 = (i + (2));
i = G__11471;
continue;

}
}
break;
}
});
cljs.core.array_map_index_of_symbol_QMARK_ = (function array_map_index_of_symbol_QMARK_(arr,m,k){
var len = arr.length;
var kstr = k.str;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((function (){var k_SINGLEQUOTE_ = (arr[i]);
return ((k_SINGLEQUOTE_ instanceof cljs.core.Symbol)) && ((kstr === k_SINGLEQUOTE_.str));
})()){
return i;
} else {
var G__11472 = (i + (2));
i = G__11472;
continue;

}
}
break;
}
});
cljs.core.array_map_index_of_identical_QMARK_ = (function array_map_index_of_identical_QMARK_(arr,m,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((k === (arr[i]))){
return i;
} else {
var G__11473 = (i + (2));
i = G__11473;
continue;

}
}
break;
}
});
cljs.core.array_map_index_of_equiv_QMARK_ = (function array_map_index_of_equiv_QMARK_(arr,m,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(arr[i]))){
return i;
} else {
var G__11474 = (i + (2));
i = G__11474;
continue;

}
}
break;
}
});
cljs.core.array_map_index_of = (function array_map_index_of(m,k){
var arr = m.arr;
if((k instanceof cljs.core.Keyword)){
return cljs.core.array_map_index_of_keyword_QMARK_(arr,m,k);
} else {
if(cljs.core.truth_((function (){var or__3758__auto__ = (function (){var G__11478 = k;
return goog.isString(G__11478);
})();
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return typeof k === 'number';
}
})())){
return cljs.core.array_map_index_of_identical_QMARK_(arr,m,k);
} else {
if((k instanceof cljs.core.Symbol)){
return cljs.core.array_map_index_of_symbol_QMARK_(arr,m,k);
} else {
if((k == null)){
return cljs.core.array_map_index_of_nil_QMARK_(arr,m,k);
} else {
return cljs.core.array_map_index_of_equiv_QMARK_(arr,m,k);

}
}
}
}
});
cljs.core.array_map_extend_kv = (function array_map_extend_kv(m,k,v){
var arr = m.arr;
var l = arr.length;
var narr = (new Array((l + (2))));
var i_11479 = (0);
while(true){
if((i_11479 < l)){
(narr[i_11479] = (arr[i_11479]));

var G__11480 = (i_11479 + (1));
i_11479 = G__11480;
continue;
} else {
}
break;
}

(narr[l] = k);

(narr[(l + (1))] = v);

return narr;
});

/**
* @constructor
*/
cljs.core.PersistentArrayMapSeq = (function (arr,i,_meta){
this.arr = arr;
this.i = i;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
})
cljs.core.PersistentArrayMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentArrayMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),self__._meta));
} else {
return null;
}
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return ((self__.arr.length - self__.i) / (2));
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[self__.i]),(self__.arr[(self__.i + (1))])], null);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentArrayMapSeq(self__.arr,self__.i,new_meta));
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentArrayMapSeq.cljs$lang$type = true;

cljs.core.PersistentArrayMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapSeq";

cljs.core.PersistentArrayMapSeq.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/PersistentArrayMapSeq");
});

cljs.core.__GT_PersistentArrayMapSeq = (function __GT_PersistentArrayMapSeq(arr,i,_meta){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
});

(cljs.core.PersistentArrayMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
cljs.core.persistent_array_map_seq = (function persistent_array_map_seq(arr,i,_meta){
if((i <= (arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
} else {
return null;
}
});


/**
* @constructor
*/
cljs.core.PersistentArrayMapIterator = (function (arr,i,cnt){
this.arr = arr;
this.i = i;
this.cnt = cnt;
})
cljs.core.PersistentArrayMapIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.cnt);
});

cljs.core.PersistentArrayMapIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[self__.i]),(self__.arr[(self__.i + (1))])], null);
self__.i = (self__.i + (2));

return ret;
});

cljs.core.PersistentArrayMapIterator.cljs$lang$type = true;

cljs.core.PersistentArrayMapIterator.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapIterator";

cljs.core.PersistentArrayMapIterator.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/PersistentArrayMapIterator");
});

cljs.core.__GT_PersistentArrayMapIterator = (function __GT_PersistentArrayMapIterator(arr,i,cnt){
return (new cljs.core.PersistentArrayMapIterator(arr,i,cnt));
});


/**
* @constructor
*/
cljs.core.PersistentArrayMap = (function (meta,cnt,arr,__hash){
this.meta = meta;
this.cnt = cnt;
this.arr = arr;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16647951;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentArrayMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentArrayMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentArrayMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__11482 = coll;
return (cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__11482) : cljs.core.keys.call(null,G__11482));
})());
});

cljs.core.PersistentArrayMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentArrayMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__11483 = coll;
return (cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__11483) : cljs.core.vals.call(null,G__11483));
})());
});

cljs.core.PersistentArrayMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentArrayMap.prototype.get = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentArrayMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__11484 = cljs.core.seq(coll);
var chunk__11485 = null;
var count__11486 = (0);
var i__11487 = (0);
while(true){
if((i__11487 < count__11486)){
var vec__11488 = chunk__11485.cljs$core$IIndexed$_nth$arity$2(null,i__11487);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11488,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11488,(1),null);
var G__11489_11502 = v;
var G__11490_11503 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11489_11502,G__11490_11503) : f.call(null,G__11489_11502,G__11490_11503));

var G__11504 = seq__11484;
var G__11505 = chunk__11485;
var G__11506 = count__11486;
var G__11507 = (i__11487 + (1));
seq__11484 = G__11504;
chunk__11485 = G__11505;
count__11486 = G__11506;
i__11487 = G__11507;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__11484);
if(temp__4126__auto__){
var seq__11484__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11484__$1)){
var c__4545__auto__ = cljs.core.chunk_first(seq__11484__$1);
var G__11508 = cljs.core.chunk_rest(seq__11484__$1);
var G__11509 = c__4545__auto__;
var G__11510 = cljs.core.count(c__4545__auto__);
var G__11511 = (0);
seq__11484 = G__11508;
chunk__11485 = G__11509;
count__11486 = G__11510;
i__11487 = G__11511;
continue;
} else {
var vec__11491 = cljs.core.first(seq__11484__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11491,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11491,(1),null);
var G__11492_11512 = v;
var G__11493_11513 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11492_11512,G__11493_11513) : f.call(null,G__11492_11512,G__11493_11513));

var G__11514 = cljs.core.next(seq__11484__$1);
var G__11515 = null;
var G__11516 = (0);
var G__11517 = (0);
seq__11484 = G__11514;
chunk__11485 = G__11515;
count__11486 = G__11516;
i__11487 = G__11517;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var G__11494 = init__$1;
var G__11495 = (self__.arr[i]);
var G__11496 = (self__.arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11494,G__11495,G__11496) : f.call(null,G__11494,G__11495,G__11496));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__11497 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11497) : cljs.core.deref.call(null,G__11497));
} else {
var G__11518 = (i + (2));
var G__11519 = init__$2;
i = G__11518;
init__$1 = G__11519;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$ = true;

cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.PersistentArrayMapIterator(self__.arr,(0),(self__.cnt * (2))));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,self__.arr,self__.__hash));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if((function (){var G__11498 = other;
if(G__11498){
var bit__4432__auto__ = (G__11498.cljs$lang$protocol_mask$partition0$ & (1024));
if((bit__4432__auto__) || (G__11498.cljs$core$IMap$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
var alen = self__.arr.length;
var other__$1 = other;
if((self__.cnt === other__$1.cljs$core$ICounted$_count$arity$1(null))){
var i = (0);
while(true){
if((i < alen)){
var v = other__$1.cljs$core$ILookup$_lookup$arity$3(null,(self__.arr[i]),cljs.core.lookup_sentinel);
if(!((v === cljs.core.lookup_sentinel))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(i + (1))]),v)){
var G__11520 = (i + (2));
i = G__11520;
continue;
} else {
return false;
}
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_map(coll__$1,other);
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientArrayMap((function (){var obj11500 = {};
return obj11500;
})(),self__.arr.length,cljs.core.aclone(self__.arr)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentArrayMap.EMPTY,self__.meta);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx >= (0))){
var len = self__.arr.length;
var new_len = (len - (2));
if((new_len === (0))){
return cljs.core._empty(coll__$1);
} else {
var new_arr = (new Array(new_len));
var s = (0);
var d = (0);
while(true){
if((s >= len)){
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt - (1)),new_arr,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(self__.arr[s]))){
var G__11521 = (s + (2));
var G__11522 = d;
s = G__11521;
d = G__11522;
continue;
} else {
(new_arr[d] = (self__.arr[s]));

(new_arr[(d + (1))] = (self__.arr[(s + (1))]));

var G__11523 = (s + (2));
var G__11524 = (d + (2));
s = G__11523;
d = G__11524;
continue;

}
}
break;
}
}
} else {
return coll__$1;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
if((self__.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr__$1 = cljs.core.array_map_extend_kv(coll__$1,k,v);
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt + (1)),arr__$1,null));
} else {
return cljs.core._with_meta(cljs.core._assoc(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1),k,v),self__.meta);
}
} else {
if((v === (self__.arr[(idx + (1))]))){
return coll__$1;
} else {
var arr__$1 = (function (){var G__11501 = cljs.core.aclone(self__.arr);
(G__11501[(idx + (1))] = v);

return G__11501;
})();
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,arr__$1,null));

}
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return !((cljs.core.array_map_index_of(coll__$1,k) === (-1)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.persistent_array_map_seq(self__.arr,(0),null);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentArrayMap(meta__$1,self__.cnt,self__.arr,self__.__hash));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__11525 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__11526 = cljs.core.next(es);
ret = G__11525;
es = G__11526;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentArrayMap.prototype.call = (function() {
var G__11527 = null;
var G__11527__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__11527__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__11527 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__11527__2.call(this,self__,k);
case 3:
return G__11527__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11527.cljs$core$IFn$_invoke$arity$2 = G__11527__2;
G__11527.cljs$core$IFn$_invoke$arity$3 = G__11527__3;
return G__11527;
})()
;

cljs.core.PersistentArrayMap.prototype.apply = (function (self__,args11481){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args11481)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentArrayMap.cljs$lang$type = true;

cljs.core.PersistentArrayMap.cljs$lang$ctorStr = "cljs.core/PersistentArrayMap";

cljs.core.PersistentArrayMap.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/PersistentArrayMap");
});

cljs.core.__GT_PersistentArrayMap = (function __GT_PersistentArrayMap(meta,cnt,arr,__hash){
return (new cljs.core.PersistentArrayMap(meta,cnt,arr,__hash));
});

cljs.core.PersistentArrayMap.EMPTY = (new cljs.core.PersistentArrayMap(null,(0),[],cljs.core.empty_unordered_hash));
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = (8);
cljs.core.PersistentArrayMap.fromArray = (function (arr,no_clone,no_check){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
if(no_check){
var cnt = (arr__$1.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr__$1,null));
} else {
var len = arr__$1.length;
var i = (0);
var ret = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < len)){
var G__11528 = (i + (2));
var G__11529 = cljs.core._assoc_BANG_(ret,(arr__$1[i]),(arr__$1[(i + (1))]));
i = G__11528;
ret = G__11529;
continue;
} else {
return cljs.core._persistent_BANG_(ret);
}
break;
}
}
});
(cljs.core.PersistentArrayMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));

/**
* @constructor
*/
cljs.core.TransientArrayMap = (function (editable_QMARK_,len,arr){
this.editable_QMARK_ = editable_QMARK_;
this.len = len;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 56;
this.cljs$lang$protocol_mask$partition0$ = 258;
})
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx >= (0))){
(self__.arr[idx] = (self__.arr[(self__.len - (2))]));

(self__.arr[(idx + (1))] = (self__.arr[(self__.len - (1))]));

var G__11530_11538 = self__.arr;
G__11530_11538.pop();

G__11530_11538.pop();


self__.len = (self__.len - (2));
} else {
}

return tcoll__$1;
} else {
throw (new Error("dissoc! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx === (-1))){
if(((self__.len + (2)) <= ((2) * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD))){
self__.len = (self__.len + (2));

self__.arr.push(key);

self__.arr.push(val);

return tcoll__$1;
} else {
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((function (){var G__11531 = self__.len;
var G__11532 = self__.arr;
return (cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2 ? cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2(G__11531,G__11532) : cljs.core.array__GT_transient_hash_map.call(null,G__11531,G__11532));
})(),key,val);
}
} else {
if((val === (self__.arr[(idx + (1))]))){
return tcoll__$1;
} else {
(self__.arr[(idx + (1))] = val);

return tcoll__$1;
}
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
if((function (){var G__11533 = o;
if(G__11533){
var bit__4439__auto__ = (G__11533.cljs$lang$protocol_mask$partition0$ & (2048));
if((bit__4439__auto__) || (G__11533.cljs$core$IMapEntry$)){
return true;
} else {
if((!G__11533.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__11533);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__11533);
}
})()){
return cljs.core._assoc_BANG_(tcoll__$1,(function (){var G__11534 = o;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__11534) : cljs.core.key.call(null,G__11534));
})(),(function (){var G__11535 = o;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__11535) : cljs.core.val.call(null,G__11535));
})());
} else {
var es = cljs.core.seq(o);
var tcoll__$2 = tcoll__$1;
while(true){
var temp__4124__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
var G__11539 = cljs.core.next(es);
var G__11540 = cljs.core._assoc_BANG_(tcoll__$2,(function (){var G__11536 = e;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__11536) : cljs.core.key.call(null,G__11536));
})(),(function (){var G__11537 = e;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__11537) : cljs.core.val.call(null,G__11537));
})());
es = G__11539;
tcoll__$2 = G__11540;
continue;
} else {
return tcoll__$2;
}
break;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
self__.editable_QMARK_ = false;

return (new cljs.core.PersistentArrayMap(null,cljs.core.quot(self__.len,(2)),self__.arr,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1,k,null);
});

cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
} else {
throw (new Error("lookup after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
return cljs.core.quot(self__.len,(2));
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientArrayMap.cljs$lang$type = true;

cljs.core.TransientArrayMap.cljs$lang$ctorStr = "cljs.core/TransientArrayMap";

cljs.core.TransientArrayMap.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/TransientArrayMap");
});

cljs.core.__GT_TransientArrayMap = (function __GT_TransientArrayMap(editable_QMARK_,len,arr){
return (new cljs.core.TransientArrayMap(editable_QMARK_,len,arr));
});


cljs.core.array__GT_transient_hash_map = (function array__GT_transient_hash_map(len,arr){
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
var i = (0);
while(true){
if((i < len)){
var G__11541 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,(arr[i]),(arr[(i + (1))]));
var G__11542 = (i + (2));
out = G__11541;
i = G__11542;
continue;
} else {
return out;
}
break;
}
});

/**
* @constructor
*/
cljs.core.Box = (function (val){
this.val = val;
})

cljs.core.Box.cljs$lang$type = true;

cljs.core.Box.cljs$lang$ctorStr = "cljs.core/Box";

cljs.core.Box.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/Box");
});

cljs.core.__GT_Box = (function __GT_Box(val){
return (new cljs.core.Box(val));
});






cljs.core.key_test = (function key_test(key,other){
if((key === other)){
return true;
} else {
if(cljs.core.keyword_identical_QMARK_(key,other)){
return true;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,other);

}
}
});
cljs.core.mask = (function mask(hash,shift){
return ((hash >>> shift) & (31));
});
cljs.core.clone_and_set = (function() {
var clone_and_set = null;
var clone_and_set__3 = (function (arr,i,a){
var G__11545 = cljs.core.aclone(arr);
(G__11545[i] = a);

return G__11545;
});
var clone_and_set__5 = (function (arr,i,a,j,b){
var G__11546 = cljs.core.aclone(arr);
(G__11546[i] = a);

(G__11546[j] = b);

return G__11546;
});
clone_and_set = function(arr,i,a,j,b){
switch(arguments.length){
case 3:
return clone_and_set__3.call(this,arr,i,a);
case 5:
return clone_and_set__5.call(this,arr,i,a,j,b);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
clone_and_set.cljs$core$IFn$_invoke$arity$3 = clone_and_set__3;
clone_and_set.cljs$core$IFn$_invoke$arity$5 = clone_and_set__5;
return clone_and_set;
})()
;
cljs.core.remove_pair = (function remove_pair(arr,i){
var new_arr = (new Array((arr.length - (2))));
cljs.core.array_copy(arr,(0),new_arr,(0),((2) * i));

cljs.core.array_copy(arr,((2) * (i + (1))),new_arr,((2) * i),(new_arr.length - ((2) * i)));

return new_arr;
});
cljs.core.bitmap_indexed_node_index = (function bitmap_indexed_node_index(bitmap,bit){
return cljs.core.bit_count((bitmap & (bit - (1))));
});
cljs.core.bitpos = (function bitpos(hash,shift){
return ((1) << ((hash >>> shift) & 0x01f));
});
cljs.core.edit_and_set = (function() {
var edit_and_set = null;
var edit_and_set__4 = (function (inode,edit,i,a){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

return editable;
});
var edit_and_set__6 = (function (inode,edit,i,a,j,b){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

(editable.arr[j] = b);

return editable;
});
edit_and_set = function(inode,edit,i,a,j,b){
switch(arguments.length){
case 4:
return edit_and_set__4.call(this,inode,edit,i,a);
case 6:
return edit_and_set__6.call(this,inode,edit,i,a,j,b);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
edit_and_set.cljs$core$IFn$_invoke$arity$4 = edit_and_set__4;
edit_and_set.cljs$core$IFn$_invoke$arity$6 = edit_and_set__6;
return edit_and_set;
})()
;
cljs.core.inode_kv_reduce = (function inode_kv_reduce(arr,f,init){
var len = arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var k = (arr[i]);
if(!((k == null))){
var G__11551 = init__$1;
var G__11552 = k;
var G__11553 = (arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11551,G__11552,G__11553) : f.call(null,G__11551,G__11552,G__11553));
} else {
var node = (arr[(i + (1))]);
if(!((node == null))){
return node.kv_reduce(f,init__$1);
} else {
return init__$1;
}
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__11554 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11554) : cljs.core.deref.call(null,G__11554));
} else {
var G__11555 = (i + (2));
var G__11556 = init__$2;
i = G__11555;
init__$1 = G__11556;
continue;
}
} else {
return init__$1;
}
break;
}
});

/**
* @constructor
*/
cljs.core.BitmapIndexedNode = (function (edit,bitmap,arr){
this.edit = edit;
this.bitmap = bitmap;
this.arr = arr;
})
cljs.core.BitmapIndexedNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var n = cljs.core.bit_count(self__.bitmap);
var new_arr = (new Array((((n < (0)))?(4):((2) * (n + (1))))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * n));

return (new cljs.core.BitmapIndexedNode(e,self__.bitmap,new_arr));
}
});

cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
if(!((n == null))){
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
} else {
if((self__.bitmap === bit)){
return null;
} else {
return inode.edit_and_remove_pair(edit__$1,bit,idx);

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
(removed_leaf_QMARK_[(0)] = true);

return inode.edit_and_remove_pair(edit__$1,bit,idx);
} else {
return inode;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = (function (e,bit,i){
var self__ = this;
var inode = this;
if((self__.bitmap === bit)){
return null;
} else {
var editable = inode.ensure_editable(e);
var earr = editable.arr;
var len = earr.length;
editable.bitmap = (bit ^ editable.bitmap);

cljs.core.array_copy(earr,((2) * (i + (1))),earr,((2) * i),(len - ((2) * (i + (1)))));

(earr[(len - (2))] = null);

(earr[(len - (1))] = null);

return editable;
}
});

cljs.core.BitmapIndexedNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
var G__11557 = self__.arr;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(G__11557) : cljs.core.create_inode_seq.call(null,G__11557));
});

cljs.core.BitmapIndexedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
});

cljs.core.BitmapIndexedNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return val_or_node;
} else {
return not_found;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((((2) * n) < self__.arr.length)){
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
added_leaf_QMARK_.val = true;

cljs.core.array_copy_downward(earr,((2) * idx),earr,((2) * (idx + (1))),((2) * (n - idx)));

(earr[((2) * idx)] = key);

(earr[(((2) * idx) + (1))] = val);

editable.bitmap = (editable.bitmap | bit);

return editable;
} else {
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_11571 = (0);
var j_11572 = (0);
while(true){
if((i_11571 < (32))){
if((((self__.bitmap >>> i_11571) & (1)) === (0))){
var G__11573 = (i_11571 + (1));
var G__11574 = j_11572;
i_11571 = G__11573;
j_11572 = G__11574;
continue;
} else {
(nodes[i_11571] = ((!(((self__.arr[j_11572]) == null)))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),cljs.core.hash((self__.arr[j_11572])),(self__.arr[j_11572]),(self__.arr[(j_11572 + (1))]),added_leaf_QMARK_):(self__.arr[(j_11572 + (1))])));

var G__11575 = (i_11571 + (1));
var G__11576 = (j_11572 + (2));
i_11571 = G__11575;
j_11572 = G__11576;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(edit__$1,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (4)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

added_leaf_QMARK_.val = true;

var editable = inode.ensure_editable(edit__$1);
editable.arr = new_arr;

editable.bitmap = (editable.bitmap | bit);

return editable;

}
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),val);
}
} else {
added_leaf_QMARK_.val = true;

return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * idx),null,(((2) * idx) + (1)),(function (){var G__11558 = edit__$1;
var G__11559 = (shift + (5));
var G__11560 = key_or_nil;
var G__11561 = val_or_node;
var G__11562 = hash;
var G__11563 = key;
var G__11564 = val;
return (cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(G__11558,G__11559,G__11560,G__11561,G__11562,G__11563,G__11564) : cljs.core.create_node.call(null,G__11558,G__11559,G__11560,G__11561,G__11562,G__11563,G__11564));
})());

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_11577 = (0);
var j_11578 = (0);
while(true){
if((i_11577 < (32))){
if((((self__.bitmap >>> i_11577) & (1)) === (0))){
var G__11579 = (i_11577 + (1));
var G__11580 = j_11578;
i_11577 = G__11579;
j_11578 = G__11580;
continue;
} else {
(nodes[i_11577] = ((!(((self__.arr[j_11578]) == null)))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),cljs.core.hash((self__.arr[j_11578])),(self__.arr[j_11578]),(self__.arr[(j_11578 + (1))]),added_leaf_QMARK_):(self__.arr[(j_11578 + (1))])));

var G__11581 = (i_11577 + (1));
var G__11582 = (j_11578 + (2));
i_11577 = G__11581;
j_11578 = G__11582;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(null,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

added_leaf_QMARK_.val = true;

return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap | bit),new_arr));
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),val)));
}
} else {
added_leaf_QMARK_.val = true;

return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(self__.arr,((2) * idx),null,(((2) * idx) + (1)),(function (){var G__11565 = (shift + (5));
var G__11566 = key_or_nil;
var G__11567 = val_or_node;
var G__11568 = hash;
var G__11569 = key;
var G__11570 = val;
return (cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$6(G__11565,G__11566,G__11567,G__11568,G__11569,G__11570) : cljs.core.create_node.call(null,G__11565,G__11566,G__11567,G__11568,G__11569,G__11570));
})())));

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_find((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_or_nil,val_or_node], null);
} else {
return not_found;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without((shift + (5)),hash,key);
if((n === val_or_node)){
return inode;
} else {
if(!((n == null))){
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
} else {
if((self__.bitmap === bit)){
return null;
} else {
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));
} else {
return inode;

}
}
}
});

cljs.core.BitmapIndexedNode.cljs$lang$type = true;

cljs.core.BitmapIndexedNode.cljs$lang$ctorStr = "cljs.core/BitmapIndexedNode";

cljs.core.BitmapIndexedNode.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/BitmapIndexedNode");
});

cljs.core.__GT_BitmapIndexedNode = (function __GT_BitmapIndexedNode(edit,bitmap,arr){
return (new cljs.core.BitmapIndexedNode(edit,bitmap,arr));
});

cljs.core.BitmapIndexedNode.EMPTY = (new cljs.core.BitmapIndexedNode(null,(0),[]));
cljs.core.pack_array_node = (function pack_array_node(array_node,edit,idx){
var arr = array_node.arr;
var len = arr.length;
var new_arr = (new Array(((2) * (array_node.cnt - (1)))));
var i = (0);
var j = (1);
var bitmap = (0);
while(true){
if((i < len)){
if((!((i === idx))) && (!(((arr[i]) == null)))){
(new_arr[j] = (arr[i]));

var G__11583 = (i + (1));
var G__11584 = (j + (2));
var G__11585 = (bitmap | ((1) << i));
i = G__11583;
j = G__11584;
bitmap = G__11585;
continue;
} else {
var G__11586 = (i + (1));
var G__11587 = j;
var G__11588 = bitmap;
i = G__11586;
j = G__11587;
bitmap = G__11588;
continue;
}
} else {
return (new cljs.core.BitmapIndexedNode(edit,bitmap,new_arr));
}
break;
}
});

/**
* @constructor
*/
cljs.core.ArrayNode = (function (edit,cnt,arr){
this.edit = edit;
this.cnt = cnt;
this.arr = arr;
})
cljs.core.ArrayNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
return (new cljs.core.ArrayNode(e,self__.cnt,cljs.core.aclone(self__.arr)));
}
});

cljs.core.ArrayNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return inode;
} else {
var n = node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,edit__$1,idx);
} else {
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
editable.cnt = (editable.cnt - (1));

return editable;
}
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);

}
}
}
});

cljs.core.ArrayNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
var G__11589 = self__.arr;
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(G__11589) : cljs.core.create_array_node_seq.call(null,G__11589));
});

cljs.core.ArrayNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var node = (self__.arr[i]);
if(!((node == null))){
var init__$2 = node.kv_reduce(f,init__$1);
if(cljs.core.reduced_QMARK_(init__$2)){
var G__11590 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11590) : cljs.core.deref.call(null,G__11590));
} else {
var G__11591 = (i + (1));
var G__11592 = init__$2;
i = G__11591;
init__$1 = G__11592;
continue;
}
} else {
var G__11593 = (i + (1));
var G__11594 = init__$1;
i = G__11593;
init__$1 = G__11594;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.ArrayNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
return node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
});

cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));
editable.cnt = (editable.cnt + (1));

return editable;
} else {
var n = node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
}
}
});

cljs.core.ArrayNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return (new cljs.core.ArrayNode(null,(self__.cnt + (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_))));
} else {
var n = node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
}
});

cljs.core.ArrayNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
return node.inode_find((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
});

cljs.core.ArrayNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
var n = node.inode_without((shift + (5)),hash,key);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,null,idx);
} else {
return (new cljs.core.ArrayNode(null,(self__.cnt - (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));

}
}
} else {
return inode;
}
});

cljs.core.ArrayNode.cljs$lang$type = true;

cljs.core.ArrayNode.cljs$lang$ctorStr = "cljs.core/ArrayNode";

cljs.core.ArrayNode.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/ArrayNode");
});

cljs.core.__GT_ArrayNode = (function __GT_ArrayNode(edit,cnt,arr){
return (new cljs.core.ArrayNode(edit,cnt,arr));
});

cljs.core.hash_collision_node_find_index = (function hash_collision_node_find_index(arr,cnt,key){
var lim = ((2) * cnt);
var i = (0);
while(true){
if((i < lim)){
if(cljs.core.key_test(key,(arr[i]))){
return i;
} else {
var G__11595 = (i + (2));
i = G__11595;
continue;
}
} else {
return (-1);
}
break;
}
});

/**
* @constructor
*/
cljs.core.HashCollisionNode = (function (edit,collision_hash,cnt,arr){
this.edit = edit;
this.collision_hash = collision_hash;
this.cnt = cnt;
this.arr = arr;
})
cljs.core.HashCollisionNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var new_arr = (new Array(((2) * (self__.cnt + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * self__.cnt));

return (new cljs.core.HashCollisionNode(e,self__.collision_hash,self__.cnt,new_arr));
}
});

cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
(removed_leaf_QMARK_[(0)] = true);

if((self__.cnt === (1))){
return null;
} else {
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
(earr[idx] = (earr[(((2) * self__.cnt) - (2))]));

(earr[(idx + (1))] = (earr[(((2) * self__.cnt) - (1))]));

(earr[(((2) * self__.cnt) - (1))] = null);

(earr[(((2) * self__.cnt) - (2))] = null);

editable.cnt = (editable.cnt - (1));

return editable;
}
}
});

cljs.core.HashCollisionNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
var G__11596 = self__.arr;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(G__11596) : cljs.core.create_inode_seq.call(null,G__11596));
});

cljs.core.HashCollisionNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
});

cljs.core.HashCollisionNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return (self__.arr[(idx + (1))]);
} else {
return not_found;

}
}
});

cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
if((self__.arr.length > ((2) * self__.cnt))){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * self__.cnt),key,(((2) * self__.cnt) + (1)),val);
added_leaf_QMARK_.val = true;

editable.cnt = (editable.cnt + (1));

return editable;
} else {
var len = self__.arr.length;
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

added_leaf_QMARK_.val = true;

return inode.ensure_editable_array(edit__$1,(self__.cnt + (1)),new_arr);
}
} else {
if(((self__.arr[(idx + (1))]) === val)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(idx + (1)),val);
}
}
} else {
return (new cljs.core.BitmapIndexedNode(edit__$1,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode,null,null])).inode_assoc_BANG_(edit__$1,shift,hash,key,val,added_leaf_QMARK_);
}
});

cljs.core.HashCollisionNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
var len = ((2) * self__.cnt);
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

added_leaf_QMARK_.val = true;

return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt + (1)),new_arr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[idx]),val)){
return inode;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(idx + (1)),val)));
}
}
} else {
return (new cljs.core.BitmapIndexedNode(null,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode])).inode_assoc(shift,hash,key,val,added_leaf_QMARK_);
}
});

cljs.core.HashCollisionNode.prototype.ensure_editable_array = (function (e,count,array){
var self__ = this;
var inode = this;
if((e === self__.edit)){
self__.arr = array;

self__.cnt = count;

return inode;
} else {
return (new cljs.core.HashCollisionNode(self__.edit,self__.collision_hash,count,array));
}
});

cljs.core.HashCollisionNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[idx]),(self__.arr[(idx + (1))])], null);
} else {
return not_found;

}
}
});

cljs.core.HashCollisionNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
if((self__.cnt === (1))){
return null;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt - (1)),cljs.core.remove_pair(self__.arr,cljs.core.quot(idx,(2)))));

}
}
});

cljs.core.HashCollisionNode.cljs$lang$type = true;

cljs.core.HashCollisionNode.cljs$lang$ctorStr = "cljs.core/HashCollisionNode";

cljs.core.HashCollisionNode.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/HashCollisionNode");
});

cljs.core.__GT_HashCollisionNode = (function __GT_HashCollisionNode(edit,collision_hash,cnt,arr){
return (new cljs.core.HashCollisionNode(edit,collision_hash,cnt,arr));
});

cljs.core.create_node = (function() {
var create_node = null;
var create_node__6 = (function (shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc(shift,key2hash,key2,val2,added_leaf_QMARK_);
}
});
var create_node__7 = (function (edit,shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit,shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc_BANG_(edit,shift,key2hash,key2,val2,added_leaf_QMARK_);
}
});
create_node = function(edit,shift,key1,val1,key2hash,key2,val2){
switch(arguments.length){
case 6:
return create_node__6.call(this,edit,shift,key1,val1,key2hash,key2);
case 7:
return create_node__7.call(this,edit,shift,key1,val1,key2hash,key2,val2);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
create_node.cljs$core$IFn$_invoke$arity$6 = create_node__6;
create_node.cljs$core$IFn$_invoke$arity$7 = create_node__7;
return create_node;
})()
;

/**
* @constructor
*/
cljs.core.NodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374860;
})
cljs.core.NodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.NodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.nodes[self__.i]),(self__.nodes[(self__.i + (1))])], null);
} else {
return cljs.core.first(self__.s);
}
});

cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
var G__11597 = self__.nodes;
var G__11598 = (self__.i + (2));
var G__11599 = null;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__11597,G__11598,G__11599) : cljs.core.create_inode_seq.call(null,G__11597,G__11598,G__11599));
} else {
var G__11600 = self__.nodes;
var G__11601 = self__.i;
var G__11602 = cljs.core.next(self__.s);
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__11600,G__11601,G__11602) : cljs.core.create_inode_seq.call(null,G__11600,G__11601,G__11602));
}
});

cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeSeq(meta__$1,self__.nodes,self__.i,self__.s,self__.__hash));
});

cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.NodeSeq.cljs$lang$type = true;

cljs.core.NodeSeq.cljs$lang$ctorStr = "cljs.core/NodeSeq";

cljs.core.NodeSeq.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/NodeSeq");
});

cljs.core.__GT_NodeSeq = (function __GT_NodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.NodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.NodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
cljs.core.create_inode_seq = (function() {
var create_inode_seq = null;
var create_inode_seq__1 = (function (nodes){
return create_inode_seq.cljs$core$IFn$_invoke$arity$3(nodes,(0),null);
});
var create_inode_seq__3 = (function (nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
if(!(((nodes[j]) == null))){
return (new cljs.core.NodeSeq(null,nodes,j,null,null));
} else {
var temp__4124__auto__ = (nodes[(j + (1))]);
if(cljs.core.truth_(temp__4124__auto__)){
var node = temp__4124__auto__;
var temp__4124__auto____$1 = node.inode_seq();
if(cljs.core.truth_(temp__4124__auto____$1)){
var node_seq = temp__4124__auto____$1;
return (new cljs.core.NodeSeq(null,nodes,(j + (2)),node_seq,null));
} else {
var G__11606 = (j + (2));
j = G__11606;
continue;
}
} else {
var G__11607 = (j + (2));
j = G__11607;
continue;
}
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.NodeSeq(null,nodes,i,s,null));
}
});
create_inode_seq = function(nodes,i,s){
switch(arguments.length){
case 1:
return create_inode_seq__1.call(this,nodes);
case 3:
return create_inode_seq__3.call(this,nodes,i,s);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
create_inode_seq.cljs$core$IFn$_invoke$arity$1 = create_inode_seq__1;
create_inode_seq.cljs$core$IFn$_invoke$arity$3 = create_inode_seq__3;
return create_inode_seq;
})()
;

/**
* @constructor
*/
cljs.core.ArrayNodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374860;
})
cljs.core.ArrayNodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ArrayNodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.s);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var G__11608 = null;
var G__11609 = self__.nodes;
var G__11610 = self__.i;
var G__11611 = cljs.core.next(self__.s);
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(G__11608,G__11609,G__11610,G__11611) : cljs.core.create_array_node_seq.call(null,G__11608,G__11609,G__11610,G__11611));
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ArrayNodeSeq(meta__$1,self__.nodes,self__.i,self__.s,self__.__hash));
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ArrayNodeSeq.cljs$lang$type = true;

cljs.core.ArrayNodeSeq.cljs$lang$ctorStr = "cljs.core/ArrayNodeSeq";

cljs.core.ArrayNodeSeq.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/ArrayNodeSeq");
});

cljs.core.__GT_ArrayNodeSeq = (function __GT_ArrayNodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.ArrayNodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
cljs.core.create_array_node_seq = (function() {
var create_array_node_seq = null;
var create_array_node_seq__1 = (function (nodes){
return create_array_node_seq.cljs$core$IFn$_invoke$arity$4(null,nodes,(0),null);
});
var create_array_node_seq__4 = (function (meta,nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
var temp__4124__auto__ = (nodes[j]);
if(cljs.core.truth_(temp__4124__auto__)){
var nj = temp__4124__auto__;
var temp__4124__auto____$1 = nj.inode_seq();
if(cljs.core.truth_(temp__4124__auto____$1)){
var ns = temp__4124__auto____$1;
return (new cljs.core.ArrayNodeSeq(meta,nodes,(j + (1)),ns,null));
} else {
var G__11616 = (j + (1));
j = G__11616;
continue;
}
} else {
var G__11617 = (j + (1));
j = G__11617;
continue;
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,null));
}
});
create_array_node_seq = function(meta,nodes,i,s){
switch(arguments.length){
case 1:
return create_array_node_seq__1.call(this,meta);
case 4:
return create_array_node_seq__4.call(this,meta,nodes,i,s);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
create_array_node_seq.cljs$core$IFn$_invoke$arity$1 = create_array_node_seq__1;
create_array_node_seq.cljs$core$IFn$_invoke$arity$4 = create_array_node_seq__4;
return create_array_node_seq;
})()
;

/**
* @constructor
*/
cljs.core.PersistentHashMap = (function (meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
this.meta = meta;
this.cnt = cnt;
this.root = root;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentHashMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentHashMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentHashMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__11619 = coll;
return (cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__11619) : cljs.core.keys.call(null,G__11619));
})());
});

cljs.core.PersistentHashMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__11620 = coll;
return (cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__11620) : cljs.core.vals.call(null,G__11620));
})());
});

cljs.core.PersistentHashMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentHashMap.prototype.get = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentHashMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__11621 = cljs.core.seq(coll);
var chunk__11622 = null;
var count__11623 = (0);
var i__11624 = (0);
while(true){
if((i__11624 < count__11623)){
var vec__11625 = chunk__11622.cljs$core$IIndexed$_nth$arity$2(null,i__11624);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11625,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11625,(1),null);
var G__11626_11637 = v;
var G__11627_11638 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11626_11637,G__11627_11638) : f.call(null,G__11626_11637,G__11627_11638));

var G__11639 = seq__11621;
var G__11640 = chunk__11622;
var G__11641 = count__11623;
var G__11642 = (i__11624 + (1));
seq__11621 = G__11639;
chunk__11622 = G__11640;
count__11623 = G__11641;
i__11624 = G__11642;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__11621);
if(temp__4126__auto__){
var seq__11621__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11621__$1)){
var c__4545__auto__ = cljs.core.chunk_first(seq__11621__$1);
var G__11643 = cljs.core.chunk_rest(seq__11621__$1);
var G__11644 = c__4545__auto__;
var G__11645 = cljs.core.count(c__4545__auto__);
var G__11646 = (0);
seq__11621 = G__11643;
chunk__11622 = G__11644;
count__11623 = G__11645;
i__11624 = G__11646;
continue;
} else {
var vec__11628 = cljs.core.first(seq__11621__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11628,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11628,(1),null);
var G__11629_11647 = v;
var G__11630_11648 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11629_11647,G__11630_11648) : f.call(null,G__11629_11647,G__11630_11648));

var G__11649 = cljs.core.next(seq__11621__$1);
var G__11650 = null;
var G__11651 = (0);
var G__11652 = (0);
seq__11621 = G__11649;
chunk__11622 = G__11650;
count__11623 = G__11651;
i__11624 = G__11652;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var init__$1 = ((self__.has_nil_QMARK_)?(function (){var G__11631 = init;
var G__11632 = null;
var G__11633 = self__.nil_val;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11631,G__11632,G__11633) : f.call(null,G__11631,G__11632,G__11633));
})():init);
if(cljs.core.reduced_QMARK_(init__$1)){
var G__11634 = init__$1;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11634) : cljs.core.deref.call(null,G__11634));
} else {
if(!((self__.root == null))){
return self__.root.kv_reduce(f,init__$1);
} else {
return init__$1;

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashMap(self__.meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashMap((function (){var obj11636 = {};
return obj11636;
})(),self__.root,self__.cnt,self__.has_nil_QMARK_,self__.nil_val));
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentHashMap.EMPTY,self__.meta);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),self__.root,false,null,null));
} else {
return coll__$1;
}
} else {
if((self__.root == null)){
return coll__$1;
} else {
var new_root = self__.root.inode_without((0),cljs.core.hash(k),k);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if((self__.has_nil_QMARK_) && ((v === self__.nil_val))){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((self__.has_nil_QMARK_)?self__.cnt:(self__.cnt + (1))),self__.root,true,v,null));
}
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var new_root = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc((0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((added_leaf_QMARK_.val)?(self__.cnt + (1)):self__.cnt),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
return self__.has_nil_QMARK_;
} else {
if((self__.root == null)){
return false;
} else {
return !((self__.root.inode_lookup((0),cljs.core.hash(k),k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel));

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var s = ((!((self__.root == null)))?self__.root.inode_seq():null);
if(self__.has_nil_QMARK_){
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,self__.nil_val], null),s);
} else {
return s;
}
} else {
return null;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashMap(meta__$1,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__11653 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__11654 = cljs.core.next(es);
ret = G__11653;
es = G__11654;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentHashMap.prototype.call = (function() {
var G__11655 = null;
var G__11655__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__11655__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__11655 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__11655__2.call(this,self__,k);
case 3:
return G__11655__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11655.cljs$core$IFn$_invoke$arity$2 = G__11655__2;
G__11655.cljs$core$IFn$_invoke$arity$3 = G__11655__3;
return G__11655;
})()
;

cljs.core.PersistentHashMap.prototype.apply = (function (self__,args11618){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args11618)));
});

cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashMap.cljs$lang$type = true;

cljs.core.PersistentHashMap.cljs$lang$ctorStr = "cljs.core/PersistentHashMap";

cljs.core.PersistentHashMap.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/PersistentHashMap");
});

cljs.core.__GT_PersistentHashMap = (function __GT_PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
return (new cljs.core.PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash));
});

cljs.core.PersistentHashMap.EMPTY = (new cljs.core.PersistentHashMap(null,(0),null,false,null,cljs.core.empty_unordered_hash));
cljs.core.PersistentHashMap.fromArray = (function (arr,no_clone){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var len = arr__$1.length;
var i = (0);
var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__11656 = (i + (2));
var G__11657 = cljs.core._assoc_BANG_(ret,(arr__$1[i]),(arr__$1[(i + (1))]));
i = G__11656;
ret = G__11657;
continue;
} else {
return cljs.core._persistent_BANG_(ret);
}
break;
}
});
cljs.core.PersistentHashMap.fromArrays = (function (ks,vs){
var len = ks.length;
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__11658 = (i + (1));
var G__11659 = out.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null,(ks[i]),(vs[i]));
i = G__11658;
out = G__11659;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
});
(cljs.core.PersistentHashMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));

/**
* @constructor
*/
cljs.core.TransientHashMap = (function (edit,root,count,has_nil_QMARK_,nil_val){
this.edit = edit;
this.root = root;
this.count = count;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.cljs$lang$protocol_mask$partition1$ = 56;
this.cljs$lang$protocol_mask$partition0$ = 258;
})
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.without_BANG_(key);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.assoc_BANG_(key,val);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.conj_BANG_(val);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.persistent_BANG_();
});

cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k);
}
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);
}
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.edit){
return self__.count;
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.conj_BANG_ = (function (o){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((function (){var G__11660 = o;
if(G__11660){
var bit__4439__auto__ = (G__11660.cljs$lang$protocol_mask$partition0$ & (2048));
if((bit__4439__auto__) || (G__11660.cljs$core$IMapEntry$)){
return true;
} else {
if((!G__11660.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__11660);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__11660);
}
})()){
return tcoll.assoc_BANG_((function (){var G__11661 = o;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__11661) : cljs.core.key.call(null,G__11661));
})(),(function (){var G__11662 = o;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__11662) : cljs.core.val.call(null,G__11662));
})());
} else {
var es = cljs.core.seq(o);
var tcoll__$1 = tcoll;
while(true){
var temp__4124__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
var G__11665 = cljs.core.next(es);
var G__11666 = tcoll__$1.assoc_BANG_((function (){var G__11663 = e;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__11663) : cljs.core.key.call(null,G__11663));
})(),(function (){var G__11664 = e;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__11664) : cljs.core.val.call(null,G__11664));
})());
es = G__11665;
tcoll__$1 = G__11666;
continue;
} else {
return tcoll__$1;
}
break;
}
}
} else {
throw (new Error("conj! after persistent"));
}
});

cljs.core.TransientHashMap.prototype.assoc_BANG_ = (function (k,v){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if((self__.nil_val === v)){
} else {
self__.nil_val = v;
}

if(self__.has_nil_QMARK_){
} else {
self__.count = (self__.count + (1));

self__.has_nil_QMARK_ = true;
}

return tcoll;
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var node = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc_BANG_(self__.edit,(0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((node === self__.root)){
} else {
self__.root = node;
}

if(added_leaf_QMARK_.val){
self__.count = (self__.count + (1));
} else {
}

return tcoll;
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.without_BANG_ = (function (k){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if(self__.has_nil_QMARK_){
self__.has_nil_QMARK_ = false;

self__.nil_val = null;

self__.count = (self__.count - (1));

return tcoll;
} else {
return tcoll;
}
} else {
if((self__.root == null)){
return tcoll;
} else {
var removed_leaf_QMARK_ = (new cljs.core.Box(false));
var node = self__.root.inode_without_BANG_(self__.edit,(0),cljs.core.hash(k),k,removed_leaf_QMARK_);
if((node === self__.root)){
} else {
self__.root = node;
}

if(cljs.core.truth_((removed_leaf_QMARK_[(0)]))){
self__.count = (self__.count - (1));
} else {
}

return tcoll;
}
}
} else {
throw (new Error("dissoc! after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.persistent_BANG_ = (function (){
var self__ = this;
var tcoll = this;
if(self__.edit){
self__.edit = null;

return (new cljs.core.PersistentHashMap(null,self__.count,self__.root,self__.has_nil_QMARK_,self__.nil_val,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientHashMap.cljs$lang$type = true;

cljs.core.TransientHashMap.cljs$lang$ctorStr = "cljs.core/TransientHashMap";

cljs.core.TransientHashMap.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/TransientHashMap");
});

cljs.core.__GT_TransientHashMap = (function __GT_TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val){
return (new cljs.core.TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val));
});

cljs.core.tree_map_seq_push = (function tree_map_seq_push(node,stack,ascending_QMARK_){
var t = node;
var stack__$1 = stack;
while(true){
if(!((t == null))){
var G__11667 = ((ascending_QMARK_)?t.left:t.right);
var G__11668 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack__$1,t);
t = G__11667;
stack__$1 = G__11668;
continue;
} else {
return stack__$1;
}
break;
}
});

/**
* @constructor
*/
cljs.core.PersistentTreeMapSeq = (function (meta,stack,ascending_QMARK_,cnt,__hash){
this.meta = meta;
this.stack = stack;
this.ascending_QMARK_ = ascending_QMARK_;
this.cnt = cnt;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374862;
})
cljs.core.PersistentTreeMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt < (0))){
return (cljs.core.count(cljs.core.next(coll__$1)) + (1));
} else {
return self__.cnt;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.peek(self__.stack);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first(self__.stack);
var next_stack = cljs.core.tree_map_seq_push(((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next(self__.stack),self__.ascending_QMARK_);
if(!((next_stack == null))){
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMapSeq(meta__$1,self__.stack,self__.ascending_QMARK_,self__.cnt,self__.__hash));
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;

cljs.core.PersistentTreeMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentTreeMapSeq";

cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/PersistentTreeMapSeq");
});

cljs.core.__GT_PersistentTreeMapSeq = (function __GT_PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash){
return (new cljs.core.PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash));
});

(cljs.core.PersistentTreeMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
cljs.core.create_tree_map_seq = (function create_tree_map_seq(tree,ascending_QMARK_,cnt){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.tree_map_seq_push(tree,null,ascending_QMARK_),ascending_QMARK_,cnt,null));
});

cljs.core.balance_left = (function balance_left(key,val,ins,right){
if((ins instanceof cljs.core.RedNode)){
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,ins.left.blacken(),(new cljs.core.BlackNode(key,val,ins.right,right,null)),null));
} else {
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.right.key,ins.right.val,(new cljs.core.BlackNode(ins.key,ins.val,ins.left,ins.right.left,null)),(new cljs.core.BlackNode(key,val,ins.right.right,right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));
}
});
cljs.core.balance_right = (function balance_right(key,val,left,ins){
if((ins instanceof cljs.core.RedNode)){
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,(new cljs.core.BlackNode(key,val,left,ins.left,null)),ins.right.blacken(),null));
} else {
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.left.key,ins.left.val,(new cljs.core.BlackNode(key,val,left,ins.left.left,null)),(new cljs.core.BlackNode(ins.key,ins.val,ins.left.right,ins.right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));
}
});
cljs.core.balance_left_del = (function balance_left_del(key,val,del,right){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,del.blacken(),right,null));
} else {
if((right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right(key,val,del,right.redden());
} else {
if(((right instanceof cljs.core.RedNode)) && ((right.left instanceof cljs.core.BlackNode))){
return (new cljs.core.RedNode(right.left.key,right.left.val,(new cljs.core.BlackNode(key,val,del,right.left.left,null)),cljs.core.balance_right(right.key,right.val,right.left.right,right.right.redden()),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.balance_right_del = (function balance_right_del(key,val,left,del){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,left,del.blacken(),null));
} else {
if((left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left(key,val,left.redden(),del);
} else {
if(((left instanceof cljs.core.RedNode)) && ((left.right instanceof cljs.core.BlackNode))){
return (new cljs.core.RedNode(left.right.key,left.right.val,cljs.core.balance_left(left.key,left.val,left.left.redden(),left.right.left),(new cljs.core.BlackNode(key,val,left.right.right,del,null)),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.tree_map_kv_reduce = (function tree_map_kv_reduce(node,f,init){
var init__$1 = ((!((node.left == null)))?tree_map_kv_reduce(node.left,f,init):init);
if(cljs.core.reduced_QMARK_(init__$1)){
var G__11681 = init__$1;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11681) : cljs.core.deref.call(null,G__11681));
} else {
var init__$2 = (function (){var G__11682 = init__$1;
var G__11683 = node.key;
var G__11684 = node.val;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11682,G__11683,G__11684) : f.call(null,G__11682,G__11683,G__11684));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__11685 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11685) : cljs.core.deref.call(null,G__11685));
} else {
var init__$3 = ((!((node.right == null)))?tree_map_kv_reduce(node.right,f,init__$2):init__$2);
if(cljs.core.reduced_QMARK_(init__$3)){
var G__11686 = init__$3;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11686) : cljs.core.deref.call(null,G__11686));
} else {
return init__$3;
}
}
}
});

/**
* @constructor
*/
cljs.core.BlackNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32402207;
})
cljs.core.BlackNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return ins.balance_right(node);
});

cljs.core.BlackNode.prototype.redden = (function (){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,self__.right,null));
});

cljs.core.BlackNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return node;
});

cljs.core.BlackNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return ins.balance_left(node);
});

cljs.core.BlackNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(key__$1,val__$1,left__$1,right__$1,null));
});

cljs.core.BlackNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));
});

cljs.core.BlackNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));
});

cljs.core.BlackNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_left_del(self__.key,self__.val,del,self__.right);
});

cljs.core.BlackNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
});

cljs.core.BlackNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_right_del(self__.key,self__.val,self__.left,del);
});

cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,null);
});

cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,not_found);
});

cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return null;

}
}
});

cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
});

cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
});

cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
});

cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
});

cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
});

cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
});

cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
});

cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
});

cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core._conj(cljs.core._conj(cljs.core.List.EMPTY,self__.val),self__.key);
});

cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
});

cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
});

cljs.core.BlackNode.prototype.call = (function() {
var G__11688 = null;
var G__11688__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__11688__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__11688 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__11688__2.call(this,self__,k);
case 3:
return G__11688__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11688.cljs$core$IFn$_invoke$arity$2 = G__11688__2;
G__11688.cljs$core$IFn$_invoke$arity$3 = G__11688__3;
return G__11688;
})()
;

cljs.core.BlackNode.prototype.apply = (function (self__,args11687){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args11687)));
});

cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.BlackNode.cljs$lang$type = true;

cljs.core.BlackNode.cljs$lang$ctorStr = "cljs.core/BlackNode";

cljs.core.BlackNode.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/BlackNode");
});

cljs.core.__GT_BlackNode = (function __GT_BlackNode(key,val,left,right,__hash){
return (new cljs.core.BlackNode(key,val,left,right,__hash));
});

(cljs.core.BlackNode.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));

/**
* @constructor
*/
cljs.core.RedNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32402207;
})
cljs.core.RedNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,ins,null));
});

cljs.core.RedNode.prototype.redden = (function (){
var self__ = this;
var node = this;
throw (new Error("red-black tree invariant violation"));
});

cljs.core.RedNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right,null));
});

cljs.core.RedNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,ins,self__.right,null));
});

cljs.core.RedNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(key__$1,val__$1,left__$1,right__$1,null));
});

cljs.core.RedNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,self__.left.blacken(),(new cljs.core.BlackNode(parent.key,parent.val,self__.right,parent.right,null)),null));
} else {
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.right.key,self__.right.val,(new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right.left,null)),(new cljs.core.BlackNode(parent.key,parent.val,self__.right.right,parent.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));

}
}
});

cljs.core.RedNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left,null)),self__.right.blacken(),null));
} else {
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.left.key,self__.left.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left.left,null)),(new cljs.core.BlackNode(self__.key,self__.val,self__.left.right,self__.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));

}
}
});

cljs.core.RedNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,del,self__.right,null));
});

cljs.core.RedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
});

cljs.core.RedNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,del,null));
});

cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,null);
});

cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,not_found);
});

cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return null;

}
}
});

cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
});

cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
});

cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
});

cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
});

cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
});

cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
});

cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
});

cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
});

cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core._conj(cljs.core._conj(cljs.core.List.EMPTY,self__.val),self__.key);
});

cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
});

cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
});

cljs.core.RedNode.prototype.call = (function() {
var G__11690 = null;
var G__11690__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__11690__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__11690 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__11690__2.call(this,self__,k);
case 3:
return G__11690__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11690.cljs$core$IFn$_invoke$arity$2 = G__11690__2;
G__11690.cljs$core$IFn$_invoke$arity$3 = G__11690__3;
return G__11690;
})()
;

cljs.core.RedNode.prototype.apply = (function (self__,args11689){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args11689)));
});

cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.RedNode.cljs$lang$type = true;

cljs.core.RedNode.cljs$lang$ctorStr = "cljs.core/RedNode";

cljs.core.RedNode.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/RedNode");
});

cljs.core.__GT_RedNode = (function __GT_RedNode(key,val,left,right,__hash){
return (new cljs.core.RedNode(key,val,left,right,__hash));
});

(cljs.core.RedNode.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
cljs.core.tree_map_add = (function tree_map_add(comp,tree,k,v,found){
if((tree == null)){
return (new cljs.core.RedNode(k,v,null,null,null));
} else {
var c = (function (){var G__11703 = k;
var G__11704 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__11703,G__11704) : comp.call(null,G__11703,G__11704));
})();
if((c === (0))){
(found[(0)] = tree);

return null;
} else {
if((c < (0))){
var ins = tree_map_add(comp,tree.left,k,v,found);
if(!((ins == null))){
return tree.add_left(ins);
} else {
return null;
}
} else {
var ins = tree_map_add(comp,tree.right,k,v,found);
if(!((ins == null))){
return tree.add_right(ins);
} else {
return null;
}

}
}
}
});
cljs.core.tree_map_append = (function tree_map_append(left,right){
if((left == null)){
return right;
} else {
if((right == null)){
return left;
} else {
if((left instanceof cljs.core.RedNode)){
if((right instanceof cljs.core.RedNode)){
var app = tree_map_append(left.right,right.left);
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.RedNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.RedNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,(new cljs.core.RedNode(right.key,right.val,app,right.right,null)),null));
}
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,tree_map_append(left.right,right),null));
}
} else {
if((right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(right.key,right.val,tree_map_append(left,right.left),right.right,null));
} else {
var app = tree_map_append(left.right,right.left);
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.BlackNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.BlackNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return cljs.core.balance_left_del(left.key,left.val,left.left,(new cljs.core.BlackNode(right.key,right.val,app,right.right,null)));
}

}
}
}
}
});
cljs.core.tree_map_remove = (function tree_map_remove(comp,tree,k,found){
if(!((tree == null))){
var c = (function (){var G__11723 = k;
var G__11724 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__11723,G__11724) : comp.call(null,G__11723,G__11724));
})();
if((c === (0))){
(found[(0)] = tree);

return cljs.core.tree_map_append(tree.left,tree.right);
} else {
if((c < (0))){
var del = tree_map_remove(comp,tree.left,k,found);
if((!((del == null))) || (!(((found[(0)]) == null)))){
if((tree.left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left_del(tree.key,tree.val,del,tree.right);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,del,tree.right,null));
}
} else {
return null;
}
} else {
var del = tree_map_remove(comp,tree.right,k,found);
if((!((del == null))) || (!(((found[(0)]) == null)))){
if((tree.right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right_del(tree.key,tree.val,tree.left,del);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,tree.left,del,null));
}
} else {
return null;
}

}
}
} else {
return null;
}
});
cljs.core.tree_map_replace = (function tree_map_replace(comp,tree,k,v){
var tk = tree.key;
var c = (function (){var G__11735 = k;
var G__11736 = tk;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__11735,G__11736) : comp.call(null,G__11735,G__11736));
})();
if((c === (0))){
return tree.replace(tk,v,tree.left,tree.right);
} else {
if((c < (0))){
return tree.replace(tk,tree.val,tree_map_replace(comp,tree.left,k,v),tree.right);
} else {
return tree.replace(tk,tree.val,tree.left,tree_map_replace(comp,tree.right,k,v));

}
}
});

/**
* @constructor
*/
cljs.core.PersistentTreeMap = (function (comp,tree,cnt,meta,__hash){
this.comp = comp;
this.tree = tree;
this.cnt = cnt;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 418776847;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentTreeMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__11738 = cljs.core.seq(coll);
var chunk__11739 = null;
var count__11740 = (0);
var i__11741 = (0);
while(true){
if((i__11741 < count__11740)){
var vec__11742 = chunk__11739.cljs$core$IIndexed$_nth$arity$2(null,i__11741);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11742,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11742,(1),null);
var G__11743_11755 = v;
var G__11744_11756 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11743_11755,G__11744_11756) : f.call(null,G__11743_11755,G__11744_11756));

var G__11757 = seq__11738;
var G__11758 = chunk__11739;
var G__11759 = count__11740;
var G__11760 = (i__11741 + (1));
seq__11738 = G__11757;
chunk__11739 = G__11758;
count__11740 = G__11759;
i__11741 = G__11760;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__11738);
if(temp__4126__auto__){
var seq__11738__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11738__$1)){
var c__4545__auto__ = cljs.core.chunk_first(seq__11738__$1);
var G__11761 = cljs.core.chunk_rest(seq__11738__$1);
var G__11762 = c__4545__auto__;
var G__11763 = cljs.core.count(c__4545__auto__);
var G__11764 = (0);
seq__11738 = G__11761;
chunk__11739 = G__11762;
count__11740 = G__11763;
i__11741 = G__11764;
continue;
} else {
var vec__11745 = cljs.core.first(seq__11738__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11745,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11745,(1),null);
var G__11746_11765 = v;
var G__11747_11766 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11746_11765,G__11747_11766) : f.call(null,G__11746_11765,G__11747_11766));

var G__11767 = cljs.core.next(seq__11738__$1);
var G__11768 = null;
var G__11769 = (0);
var G__11770 = (0);
seq__11738 = G__11767;
chunk__11739 = G__11768;
count__11740 = G__11769;
i__11741 = G__11770;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentTreeMap.prototype.get = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentTreeMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__11748 = coll;
return (cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__11748) : cljs.core.keys.call(null,G__11748));
})());
});

cljs.core.PersistentTreeMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__11749 = coll;
return (cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__11749) : cljs.core.vals.call(null,G__11749));
})());
});

cljs.core.PersistentTreeMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeMap.prototype.entry_at = (function (k){
var self__ = this;
var coll = this;
var t = self__.tree;
while(true){
if(!((t == null))){
var c = (function (){var G__11750 = k;
var G__11751 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__11750,G__11751) : self__.comp.call(null,G__11750,G__11751));
})();
if((c === (0))){
return t;
} else {
if((c < (0))){
var G__11771 = t.left;
t = G__11771;
continue;
} else {
var G__11772 = t.right;
t = G__11772;
continue;

}
}
} else {
return null;
}
break;
}
});

cljs.core.PersistentTreeMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var n = coll__$1.entry_at(k);
if(!((n == null))){
return n.val;
} else {
return not_found;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
if(!((self__.tree == null))){
return cljs.core.tree_map_kv_reduce(self__.tree,f,init);
} else {
return init;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,self__.meta,self__.__hash));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,false,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,(0)));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_remove(self__.comp,self__.tree,k,found);
if((t == null)){
if((cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0)) == null)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt - (1)),self__.meta,null));
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_add(self__.comp,self__.tree,k,v,found);
if((t == null)){
var found_node = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(v,found_node.val)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,cljs.core.tree_map_replace(self__.comp,self__.tree,k,v),self__.cnt,self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt + (1)),self__.meta,null));
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return !((coll__$1.entry_at(k) == null));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,true,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,meta__$1,self__.__hash));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__11773 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__11774 = cljs.core.next(es);
ret = G__11773;
es = G__11774;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentTreeMap.prototype.call = (function() {
var G__11775 = null;
var G__11775__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__11775__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__11775 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__11775__2.call(this,self__,k);
case 3:
return G__11775__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11775.cljs$core$IFn$_invoke$arity$2 = G__11775__2;
G__11775.cljs$core$IFn$_invoke$arity$3 = G__11775__3;
return G__11775;
})()
;

cljs.core.PersistentTreeMap.prototype.apply = (function (self__,args11737){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args11737)));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,ascending_QMARK_,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var stack = null;
var t = self__.tree;
while(true){
if(!((t == null))){
var c = (function (){var G__11752 = k;
var G__11753 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__11752,G__11753) : self__.comp.call(null,G__11752,G__11753));
})();
if((c === (0))){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t),ascending_QMARK_,(-1),null));
} else {
if(cljs.core.truth_(ascending_QMARK_)){
if((c < (0))){
var G__11776 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__11777 = t.left;
stack = G__11776;
t = G__11777;
continue;
} else {
var G__11778 = stack;
var G__11779 = t.right;
stack = G__11778;
t = G__11779;
continue;
}
} else {
if((c > (0))){
var G__11780 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__11781 = t.right;
stack = G__11780;
t = G__11781;
continue;
} else {
var G__11782 = stack;
var G__11783 = t.left;
stack = G__11782;
t = G__11783;
continue;
}

}
}
} else {
if((stack == null)){
return null;
} else {
return (new cljs.core.PersistentTreeMapSeq(null,stack,ascending_QMARK_,(-1),null));
}
}
break;
}
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
var G__11754 = entry;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__11754) : cljs.core.key.call(null,G__11754));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.comp;
});

cljs.core.PersistentTreeMap.cljs$lang$type = true;

cljs.core.PersistentTreeMap.cljs$lang$ctorStr = "cljs.core/PersistentTreeMap";

cljs.core.PersistentTreeMap.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/PersistentTreeMap");
});

cljs.core.__GT_PersistentTreeMap = (function __GT_PersistentTreeMap(comp,tree,cnt,meta,__hash){
return (new cljs.core.PersistentTreeMap(comp,tree,cnt,meta,__hash));
});

cljs.core.PersistentTreeMap.EMPTY = (new cljs.core.PersistentTreeMap(cljs.core.compare,null,(0),null,cljs.core.empty_unordered_hash));
(cljs.core.PersistentTreeMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
/**
* keyval => key val
* Returns a new hash map with supplied mappings.
* @param {...*} var_args
*/
cljs.core.hash_map = (function() { 
var hash_map__delegate = function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if(in$){
var G__11784 = cljs.core.nnext(in$);
var G__11785 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__11784;
out = G__11785;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
};
var hash_map = function (var_args){
var keyvals = null;
if (arguments.length > 0) {
var G__11786__i = 0, G__11786__a = new Array(arguments.length -  0);
while (G__11786__i < G__11786__a.length) {G__11786__a[G__11786__i] = arguments[G__11786__i + 0]; ++G__11786__i;}
  keyvals = new cljs.core.IndexedSeq(G__11786__a,0);
} 
return hash_map__delegate.call(this,keyvals);};
hash_map.cljs$lang$maxFixedArity = 0;
hash_map.cljs$lang$applyTo = (function (arglist__11787){
var keyvals = cljs.core.seq(arglist__11787);
return hash_map__delegate(keyvals);
});
hash_map.cljs$core$IFn$_invoke$arity$variadic = hash_map__delegate;
return hash_map;
})()
;
/**
* keyval => key val
* Returns a new array map with supplied mappings.
* @param {...*} var_args
*/
cljs.core.array_map = (function() { 
var array_map__delegate = function (keyvals){
return cljs.core.PersistentArrayMap.fromArray(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.array,keyvals),true,false);
};
var array_map = function (var_args){
var keyvals = null;
if (arguments.length > 0) {
var G__11788__i = 0, G__11788__a = new Array(arguments.length -  0);
while (G__11788__i < G__11788__a.length) {G__11788__a[G__11788__i] = arguments[G__11788__i + 0]; ++G__11788__i;}
  keyvals = new cljs.core.IndexedSeq(G__11788__a,0);
} 
return array_map__delegate.call(this,keyvals);};
array_map.cljs$lang$maxFixedArity = 0;
array_map.cljs$lang$applyTo = (function (arglist__11789){
var keyvals = cljs.core.seq(arglist__11789);
return array_map__delegate(keyvals);
});
array_map.cljs$core$IFn$_invoke$arity$variadic = array_map__delegate;
return array_map;
})()
;
/**
* keyval => key val
* Returns a new object map with supplied mappings.
* @param {...*} var_args
*/
cljs.core.obj_map = (function() { 
var obj_map__delegate = function (keyvals){
var ks = [];
var obj = (function (){var obj11793 = {};
return obj11793;
})();
var kvs = cljs.core.seq(keyvals);
while(true){
if(kvs){
ks.push(cljs.core.first(kvs));

(obj[cljs.core.first(kvs)] = cljs.core.second(kvs));

var G__11794 = cljs.core.nnext(kvs);
kvs = G__11794;
continue;
} else {
return cljs.core.ObjMap.fromObject(ks,obj);
}
break;
}
};
var obj_map = function (var_args){
var keyvals = null;
if (arguments.length > 0) {
var G__11795__i = 0, G__11795__a = new Array(arguments.length -  0);
while (G__11795__i < G__11795__a.length) {G__11795__a[G__11795__i] = arguments[G__11795__i + 0]; ++G__11795__i;}
  keyvals = new cljs.core.IndexedSeq(G__11795__a,0);
} 
return obj_map__delegate.call(this,keyvals);};
obj_map.cljs$lang$maxFixedArity = 0;
obj_map.cljs$lang$applyTo = (function (arglist__11796){
var keyvals = cljs.core.seq(arglist__11796);
return obj_map__delegate(keyvals);
});
obj_map.cljs$core$IFn$_invoke$arity$variadic = obj_map__delegate;
return obj_map;
})()
;
/**
* keyval => key val
* Returns a new sorted map with supplied mappings.
* @param {...*} var_args
*/
cljs.core.sorted_map = (function() { 
var sorted_map__delegate = function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.PersistentTreeMap.EMPTY;
while(true){
if(in$){
var G__11797 = cljs.core.nnext(in$);
var G__11798 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__11797;
out = G__11798;
continue;
} else {
return out;
}
break;
}
};
var sorted_map = function (var_args){
var keyvals = null;
if (arguments.length > 0) {
var G__11799__i = 0, G__11799__a = new Array(arguments.length -  0);
while (G__11799__i < G__11799__a.length) {G__11799__a[G__11799__i] = arguments[G__11799__i + 0]; ++G__11799__i;}
  keyvals = new cljs.core.IndexedSeq(G__11799__a,0);
} 
return sorted_map__delegate.call(this,keyvals);};
sorted_map.cljs$lang$maxFixedArity = 0;
sorted_map.cljs$lang$applyTo = (function (arglist__11800){
var keyvals = cljs.core.seq(arglist__11800);
return sorted_map__delegate(keyvals);
});
sorted_map.cljs$core$IFn$_invoke$arity$variadic = sorted_map__delegate;
return sorted_map;
})()
;
/**
* keyval => key val
* Returns a new sorted map with supplied mappings, using the supplied comparator.
* @param {...*} var_args
*/
cljs.core.sorted_map_by = (function() { 
var sorted_map_by__delegate = function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = (new cljs.core.PersistentTreeMap(cljs.core.fn__GT_comparator(comparator),null,(0),null,(0)));
while(true){
if(in$){
var G__11801 = cljs.core.nnext(in$);
var G__11802 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__11801;
out = G__11802;
continue;
} else {
return out;
}
break;
}
};
var sorted_map_by = function (comparator,var_args){
var keyvals = null;
if (arguments.length > 1) {
var G__11803__i = 0, G__11803__a = new Array(arguments.length -  1);
while (G__11803__i < G__11803__a.length) {G__11803__a[G__11803__i] = arguments[G__11803__i + 1]; ++G__11803__i;}
  keyvals = new cljs.core.IndexedSeq(G__11803__a,0);
} 
return sorted_map_by__delegate.call(this,comparator,keyvals);};
sorted_map_by.cljs$lang$maxFixedArity = 1;
sorted_map_by.cljs$lang$applyTo = (function (arglist__11804){
var comparator = cljs.core.first(arglist__11804);
var keyvals = cljs.core.rest(arglist__11804);
return sorted_map_by__delegate(comparator,keyvals);
});
sorted_map_by.cljs$core$IFn$_invoke$arity$variadic = sorted_map_by__delegate;
return sorted_map_by;
})()
;

/**
* @constructor
*/
cljs.core.KeySeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
})
cljs.core.KeySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.KeySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.KeySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.KeySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__11805 = self__.mseq;
if(G__11805){
var bit__4439__auto__ = (G__11805.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4439__auto__) || (G__11805.cljs$core$INext$)){
return true;
} else {
if((!G__11805.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__11805);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__11805);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.KeySeq(nseq,self__._meta));
}
});

cljs.core.KeySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.KeySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_key$arity$1(null);
});

cljs.core.KeySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__11806 = self__.mseq;
if(G__11806){
var bit__4439__auto__ = (G__11806.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4439__auto__) || (G__11806.cljs$core$INext$)){
return true;
} else {
if((!G__11806.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__11806);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__11806);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if(!((nseq == null))){
return (new cljs.core.KeySeq(nseq,self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.KeySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.KeySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.KeySeq(self__.mseq,new_meta));
});

cljs.core.KeySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.KeySeq.cljs$lang$type = true;

cljs.core.KeySeq.cljs$lang$ctorStr = "cljs.core/KeySeq";

cljs.core.KeySeq.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/KeySeq");
});

cljs.core.__GT_KeySeq = (function __GT_KeySeq(mseq,_meta){
return (new cljs.core.KeySeq(mseq,_meta));
});

(cljs.core.KeySeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
/**
* Returns a sequence of the map's keys.
*/
cljs.core.keys = (function keys(hash_map){
var temp__4126__auto__ = cljs.core.seq(hash_map);
if(temp__4126__auto__){
var mseq = temp__4126__auto__;
return (new cljs.core.KeySeq(mseq,null));
} else {
return null;
}
});
/**
* Returns the key of the map entry.
*/
cljs.core.key = (function key(map_entry){
return cljs.core._key(map_entry);
});

/**
* @constructor
*/
cljs.core.ValSeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
})
cljs.core.ValSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ValSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ValSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.ValSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__11807 = self__.mseq;
if(G__11807){
var bit__4439__auto__ = (G__11807.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4439__auto__) || (G__11807.cljs$core$INext$)){
return true;
} else {
if((!G__11807.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__11807);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__11807);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.ValSeq(nseq,self__._meta));
}
});

cljs.core.ValSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ValSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_val$arity$1(null);
});

cljs.core.ValSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__11808 = self__.mseq;
if(G__11808){
var bit__4439__auto__ = (G__11808.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4439__auto__) || (G__11808.cljs$core$INext$)){
return true;
} else {
if((!G__11808.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__11808);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__11808);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if(!((nseq == null))){
return (new cljs.core.ValSeq(nseq,self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ValSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ValSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ValSeq(self__.mseq,new_meta));
});

cljs.core.ValSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ValSeq.cljs$lang$type = true;

cljs.core.ValSeq.cljs$lang$ctorStr = "cljs.core/ValSeq";

cljs.core.ValSeq.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/ValSeq");
});

cljs.core.__GT_ValSeq = (function __GT_ValSeq(mseq,_meta){
return (new cljs.core.ValSeq(mseq,_meta));
});

(cljs.core.ValSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
/**
* Returns a sequence of the map's values.
*/
cljs.core.vals = (function vals(hash_map){
var temp__4126__auto__ = cljs.core.seq(hash_map);
if(temp__4126__auto__){
var mseq = temp__4126__auto__;
return (new cljs.core.ValSeq(mseq,null));
} else {
return null;
}
});
/**
* Returns the value in the map entry.
*/
cljs.core.val = (function val(map_entry){
return cljs.core._val(map_entry);
});
/**
* Returns a map that consists of the rest of the maps conj-ed onto
* the first.  If a key occurs in more than one map, the mapping from
* the latter (left-to-right) will be the mapping in the result.
* @param {...*} var_args
*/
cljs.core.merge = (function() { 
var merge__delegate = function (maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__11809_SHARP_,p2__11810_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__3758__auto__ = p1__11809_SHARP_;
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),p2__11810_SHARP_);
}),maps);
} else {
return null;
}
};
var merge = function (var_args){
var maps = null;
if (arguments.length > 0) {
var G__11811__i = 0, G__11811__a = new Array(arguments.length -  0);
while (G__11811__i < G__11811__a.length) {G__11811__a[G__11811__i] = arguments[G__11811__i + 0]; ++G__11811__i;}
  maps = new cljs.core.IndexedSeq(G__11811__a,0);
} 
return merge__delegate.call(this,maps);};
merge.cljs$lang$maxFixedArity = 0;
merge.cljs$lang$applyTo = (function (arglist__11812){
var maps = cljs.core.seq(arglist__11812);
return merge__delegate(maps);
});
merge.cljs$core$IFn$_invoke$arity$variadic = merge__delegate;
return merge;
})()
;
/**
* Returns a map that consists of the rest of the maps conj-ed onto
* the first.  If a key occurs in more than one map, the mapping(s)
* from the latter (left-to-right) will be combined with the mapping in
* the result by calling (f val-in-result val-in-latter).
* @param {...*} var_args
*/
cljs.core.merge_with = (function() { 
var merge_with__delegate = function (f,maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
var merge_entry = (function (m,e){
var k = cljs.core.first(e);
var v = cljs.core.second(e);
if(cljs.core.contains_QMARK_(m,k)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__11815 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__11816 = v;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11815,G__11816) : f.call(null,G__11815,G__11816));
})());
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
var merge2 = ((function (merge_entry){
return (function (m1,m2){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(merge_entry,(function (){var or__3758__auto__ = m1;
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.seq(m2));
});})(merge_entry))
;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(merge2,maps);
} else {
return null;
}
};
var merge_with = function (f,var_args){
var maps = null;
if (arguments.length > 1) {
var G__11817__i = 0, G__11817__a = new Array(arguments.length -  1);
while (G__11817__i < G__11817__a.length) {G__11817__a[G__11817__i] = arguments[G__11817__i + 1]; ++G__11817__i;}
  maps = new cljs.core.IndexedSeq(G__11817__a,0);
} 
return merge_with__delegate.call(this,f,maps);};
merge_with.cljs$lang$maxFixedArity = 1;
merge_with.cljs$lang$applyTo = (function (arglist__11818){
var f = cljs.core.first(arglist__11818);
var maps = cljs.core.rest(arglist__11818);
return merge_with__delegate(f,maps);
});
merge_with.cljs$core$IFn$_invoke$arity$variadic = merge_with__delegate;
return merge_with;
})()
;
/**
* Returns a map containing only those entries in map whose key is in keys
*/
cljs.core.select_keys = (function select_keys(map,keyseq){
var ret = cljs.core.PersistentArrayMap.EMPTY;
var keys = cljs.core.seq(keyseq);
while(true){
if(keys){
var key = cljs.core.first(keys);
var entry = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map,key,new cljs.core.Keyword("cljs.core","not-found","cljs.core/not-found",-1572889185));
var G__11819 = ((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(entry,new cljs.core.Keyword("cljs.core","not-found","cljs.core/not-found",-1572889185)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret,key,entry):ret);
var G__11820 = cljs.core.next(keys);
ret = G__11819;
keys = G__11820;
continue;
} else {
return cljs.core.with_meta(ret,cljs.core.meta(map));
}
break;
}
});

/**
* @constructor
*/
cljs.core.PersistentHashSet = (function (meta,hash_map,__hash){
this.meta = meta;
this.hash_map = hash_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 15077647;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentHashSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentHashSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentHashSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentHashSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__11823 = cljs.core.seq(coll);
var chunk__11824 = null;
var count__11825 = (0);
var i__11826 = (0);
while(true){
if((i__11826 < count__11825)){
var vec__11827 = chunk__11824.cljs$core$IIndexed$_nth$arity$2(null,i__11826);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11827,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11827,(1),null);
var G__11828_11833 = v;
var G__11829_11834 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11828_11833,G__11829_11834) : f.call(null,G__11828_11833,G__11829_11834));

var G__11835 = seq__11823;
var G__11836 = chunk__11824;
var G__11837 = count__11825;
var G__11838 = (i__11826 + (1));
seq__11823 = G__11835;
chunk__11824 = G__11836;
count__11825 = G__11837;
i__11826 = G__11838;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__11823);
if(temp__4126__auto__){
var seq__11823__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11823__$1)){
var c__4545__auto__ = cljs.core.chunk_first(seq__11823__$1);
var G__11839 = cljs.core.chunk_rest(seq__11823__$1);
var G__11840 = c__4545__auto__;
var G__11841 = cljs.core.count(c__4545__auto__);
var G__11842 = (0);
seq__11823 = G__11839;
chunk__11824 = G__11840;
count__11825 = G__11841;
i__11826 = G__11842;
continue;
} else {
var vec__11830 = cljs.core.first(seq__11823__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11830,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11830,(1),null);
var G__11831_11843 = v;
var G__11832_11844 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11831_11843,G__11832_11844) : f.call(null,G__11831_11843,G__11832_11844));

var G__11845 = cljs.core.next(seq__11823__$1);
var G__11846 = null;
var G__11847 = (0);
var G__11848 = (0);
seq__11823 = G__11845;
chunk__11824 = G__11846;
count__11825 = G__11847;
i__11826 = G__11848;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,v,null);
});

cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
if(cljs.core._contains_key_QMARK_(self__.hash_map,v)){
return v;
} else {
return not_found;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,self__.hash_map,self__.__hash));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._count(self__.hash_map);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.set_QMARK_(other)) && ((cljs.core.count(coll__$1) === cljs.core.count(other))) && (cljs.core.every_QMARK_(((function (coll__$1){
return (function (p1__11821_SHARP_){
return cljs.core.contains_QMARK_(coll__$1,p1__11821_SHARP_);
});})(coll__$1))
,other));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashSet(cljs.core._as_transient(self__.hash_map)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentHashSet.EMPTY,self__.meta);
});

cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core._dissoc(self__.hash_map,v),null));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys(self__.hash_map);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(meta__$1,self__.hash_map,self__.__hash));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.hash_map,o,null),null));
});

cljs.core.PersistentHashSet.prototype.call = (function() {
var G__11849 = null;
var G__11849__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__11849__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__11849 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__11849__2.call(this,self__,k);
case 3:
return G__11849__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11849.cljs$core$IFn$_invoke$arity$2 = G__11849__2;
G__11849.cljs$core$IFn$_invoke$arity$3 = G__11849__3;
return G__11849;
})()
;

cljs.core.PersistentHashSet.prototype.apply = (function (self__,args11822){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args11822)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashSet.cljs$lang$type = true;

cljs.core.PersistentHashSet.cljs$lang$ctorStr = "cljs.core/PersistentHashSet";

cljs.core.PersistentHashSet.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/PersistentHashSet");
});

cljs.core.__GT_PersistentHashSet = (function __GT_PersistentHashSet(meta,hash_map,__hash){
return (new cljs.core.PersistentHashSet(meta,hash_map,__hash));
});

cljs.core.PersistentHashSet.EMPTY = (new cljs.core.PersistentHashSet(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.empty_unordered_hash));
cljs.core.PersistentHashSet.fromArray = (function (items,no_clone){
var len = items.length;
if((len <= cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr = ((no_clone)?items:cljs.core.aclone(items));
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < len)){
var G__11850 = (i + (1));
var G__11851 = cljs.core._assoc_BANG_(out,(items[i]),null);
i = G__11850;
out = G__11851;
continue;
} else {
return (new cljs.core.PersistentHashSet(null,cljs.core._persistent_BANG_(out),null));
}
break;
}
} else {
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < len)){
var G__11852 = (i + (1));
var G__11853 = cljs.core._conj_BANG_(out,(items[i]));
i = G__11852;
out = G__11853;
continue;
} else {
return cljs.core._persistent_BANG_(out);
}
break;
}
}
});
(cljs.core.PersistentHashSet.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));

/**
* @constructor
*/
cljs.core.TransientHashSet = (function (transient_map){
this.transient_map = transient_map;
this.cljs$lang$protocol_mask$partition0$ = 259;
this.cljs$lang$protocol_mask$partition1$ = 136;
})
cljs.core.TransientHashSet.prototype.call = (function() {
var G__11855 = null;
var G__11855__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
});
var G__11855__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
});
G__11855 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__11855__2.call(this,self__,k);
case 3:
return G__11855__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11855.cljs$core$IFn$_invoke$arity$2 = G__11855__2;
G__11855.cljs$core$IFn$_invoke$arity$3 = G__11855__3;
return G__11855;
})()
;

cljs.core.TransientHashSet.prototype.apply = (function (self__,args11854){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args11854)));
});

cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
});

cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
});

cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1,v,null);
});

cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,v,not_found){
var self__ = this;
var tcoll__$1 = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return v;
}
});

cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return cljs.core.count(self__.transient_map);
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
self__.transient_map = cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(self__.transient_map,v);

return tcoll__$1;
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
self__.transient_map = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(self__.transient_map,o,null);

return tcoll__$1;
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return (new cljs.core.PersistentHashSet(null,cljs.core.persistent_BANG_(self__.transient_map),null));
});

cljs.core.TransientHashSet.cljs$lang$type = true;

cljs.core.TransientHashSet.cljs$lang$ctorStr = "cljs.core/TransientHashSet";

cljs.core.TransientHashSet.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/TransientHashSet");
});

cljs.core.__GT_TransientHashSet = (function __GT_TransientHashSet(transient_map){
return (new cljs.core.TransientHashSet(transient_map));
});


/**
* @constructor
*/
cljs.core.PersistentTreeSet = (function (meta,tree_map,__hash){
this.meta = meta;
this.tree_map = tree_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 417730831;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentTreeSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentTreeSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__11858 = cljs.core.seq(coll);
var chunk__11859 = null;
var count__11860 = (0);
var i__11861 = (0);
while(true){
if((i__11861 < count__11860)){
var vec__11862 = chunk__11859.cljs$core$IIndexed$_nth$arity$2(null,i__11861);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11862,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11862,(1),null);
var G__11863_11868 = v;
var G__11864_11869 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11863_11868,G__11864_11869) : f.call(null,G__11863_11868,G__11864_11869));

var G__11870 = seq__11858;
var G__11871 = chunk__11859;
var G__11872 = count__11860;
var G__11873 = (i__11861 + (1));
seq__11858 = G__11870;
chunk__11859 = G__11871;
count__11860 = G__11872;
i__11861 = G__11873;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__11858);
if(temp__4126__auto__){
var seq__11858__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11858__$1)){
var c__4545__auto__ = cljs.core.chunk_first(seq__11858__$1);
var G__11874 = cljs.core.chunk_rest(seq__11858__$1);
var G__11875 = c__4545__auto__;
var G__11876 = cljs.core.count(c__4545__auto__);
var G__11877 = (0);
seq__11858 = G__11874;
chunk__11859 = G__11875;
count__11860 = G__11876;
i__11861 = G__11877;
continue;
} else {
var vec__11865 = cljs.core.first(seq__11858__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11865,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11865,(1),null);
var G__11866_11878 = v;
var G__11867_11879 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11866_11878,G__11867_11879) : f.call(null,G__11866_11878,G__11867_11879));

var G__11880 = cljs.core.next(seq__11858__$1);
var G__11881 = null;
var G__11882 = (0);
var G__11883 = (0);
seq__11858 = G__11880;
chunk__11859 = G__11881;
count__11860 = G__11882;
i__11861 = G__11883;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,v,null);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
var n = self__.tree_map.entry_at(v);
if(!((n == null))){
return n.key;
} else {
return not_found;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,self__.tree_map,self__.__hash));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.count(self__.tree_map);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core.count(self__.tree_map) > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core.rseq(self__.tree_map));
} else {
return null;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.set_QMARK_(other)) && ((cljs.core.count(coll__$1) === cljs.core.count(other))) && (cljs.core.every_QMARK_(((function (coll__$1){
return (function (p1__11856_SHARP_){
return cljs.core.contains_QMARK_(coll__$1,p1__11856_SHARP_);
});})(coll__$1))
,other));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core._empty(self__.tree_map),(0)));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.tree_map,v),null));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys(self__.tree_map);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(meta__$1,self__.tree_map,self__.__hash));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.tree_map,o,null),null));
});

cljs.core.PersistentTreeSet.prototype.call = (function() {
var G__11884 = null;
var G__11884__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__11884__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__11884 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__11884__2.call(this,self__,k);
case 3:
return G__11884__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11884.cljs$core$IFn$_invoke$arity$2 = G__11884__2;
G__11884.cljs$core$IFn$_invoke$arity$3 = G__11884__3;
return G__11884;
})()
;

cljs.core.PersistentTreeSet.prototype.apply = (function (self__,args11857){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args11857)));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core._sorted_seq(self__.tree_map,ascending_QMARK_));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core._sorted_seq_from(self__.tree_map,k,ascending_QMARK_));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
return entry;
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._comparator(self__.tree_map);
});

cljs.core.PersistentTreeSet.cljs$lang$type = true;

cljs.core.PersistentTreeSet.cljs$lang$ctorStr = "cljs.core/PersistentTreeSet";

cljs.core.PersistentTreeSet.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/PersistentTreeSet");
});

cljs.core.__GT_PersistentTreeSet = (function __GT_PersistentTreeSet(meta,tree_map,__hash){
return (new cljs.core.PersistentTreeSet(meta,tree_map,__hash));
});

cljs.core.PersistentTreeSet.EMPTY = (new cljs.core.PersistentTreeSet(null,cljs.core.PersistentTreeMap.EMPTY,cljs.core.empty_unordered_hash));
(cljs.core.PersistentTreeSet.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
cljs.core.set_from_indexed_seq = (function set_from_indexed_seq(iseq){
var arr = iseq.arr;
var ret = (function (){var a__4639__auto__ = arr;
var i = (0);
var res = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < a__4639__auto__.length)){
var G__11885 = (i + (1));
var G__11886 = res.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,(arr[i]));
i = G__11885;
res = G__11886;
continue;
} else {
return res;
}
break;
}
})();
return ret.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(null);
});
/**
* Returns a set of the distinct elements of coll.
*/
cljs.core.set = (function set(coll){
var in$ = cljs.core.seq(coll);
if((in$ == null)){
return cljs.core.PersistentHashSet.EMPTY;
} else {
if(((in$ instanceof cljs.core.IndexedSeq)) && ((in$.i === (0)))){
return cljs.core.set_from_indexed_seq(in$);
} else {
var in$__$1 = in$;
var out = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
while(true){
if(!((in$__$1 == null))){
var G__11887 = in$__$1.cljs$core$INext$_next$arity$1(null);
var G__11888 = out.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,in$__$1.cljs$core$ISeq$_first$arity$1(null));
in$__$1 = G__11887;
out = G__11888;
continue;
} else {
return out.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(null);
}
break;
}

}
}
});
/**
* @param {...*} var_args
*/
cljs.core.hash_set = (function() {
var hash_set = null;
var hash_set__0 = (function (){
return cljs.core.PersistentHashSet.EMPTY;
});
var hash_set__1 = (function() { 
var G__11889__delegate = function (keys){
return cljs.core.set(keys);
};
var G__11889 = function (var_args){
var keys = null;
if (arguments.length > 0) {
var G__11890__i = 0, G__11890__a = new Array(arguments.length -  0);
while (G__11890__i < G__11890__a.length) {G__11890__a[G__11890__i] = arguments[G__11890__i + 0]; ++G__11890__i;}
  keys = new cljs.core.IndexedSeq(G__11890__a,0);
} 
return G__11889__delegate.call(this,keys);};
G__11889.cljs$lang$maxFixedArity = 0;
G__11889.cljs$lang$applyTo = (function (arglist__11891){
var keys = cljs.core.seq(arglist__11891);
return G__11889__delegate(keys);
});
G__11889.cljs$core$IFn$_invoke$arity$variadic = G__11889__delegate;
return G__11889;
})()
;
hash_set = function(var_args){
var keys = var_args;
switch(arguments.length){
case 0:
return hash_set__0.call(this);
default:
var G__11892 = null;
if (arguments.length > 0) {
var G__11893__i = 0, G__11893__a = new Array(arguments.length -  0);
while (G__11893__i < G__11893__a.length) {G__11893__a[G__11893__i] = arguments[G__11893__i + 0]; ++G__11893__i;}
G__11892 = new cljs.core.IndexedSeq(G__11893__a,0);
}
return hash_set__1.cljs$core$IFn$_invoke$arity$variadic(G__11892);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hash_set.cljs$lang$maxFixedArity = 0;
hash_set.cljs$lang$applyTo = hash_set__1.cljs$lang$applyTo;
hash_set.cljs$core$IFn$_invoke$arity$0 = hash_set__0;
hash_set.cljs$core$IFn$_invoke$arity$variadic = hash_set__1.cljs$core$IFn$_invoke$arity$variadic;
return hash_set;
})()
;
/**
* Returns a new sorted set with supplied keys.
* @param {...*} var_args
*/
cljs.core.sorted_set = (function() { 
var sorted_set__delegate = function (keys){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,cljs.core.PersistentTreeSet.EMPTY,keys);
};
var sorted_set = function (var_args){
var keys = null;
if (arguments.length > 0) {
var G__11894__i = 0, G__11894__a = new Array(arguments.length -  0);
while (G__11894__i < G__11894__a.length) {G__11894__a[G__11894__i] = arguments[G__11894__i + 0]; ++G__11894__i;}
  keys = new cljs.core.IndexedSeq(G__11894__a,0);
} 
return sorted_set__delegate.call(this,keys);};
sorted_set.cljs$lang$maxFixedArity = 0;
sorted_set.cljs$lang$applyTo = (function (arglist__11895){
var keys = cljs.core.seq(arglist__11895);
return sorted_set__delegate(keys);
});
sorted_set.cljs$core$IFn$_invoke$arity$variadic = sorted_set__delegate;
return sorted_set;
})()
;
/**
* Returns a new sorted set with supplied keys, using the supplied comparator.
* @param {...*} var_args
*/
cljs.core.sorted_set_by = (function() { 
var sorted_set_by__delegate = function (comparator,keys){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,(new cljs.core.PersistentTreeSet(null,cljs.core.sorted_map_by(comparator),(0))),keys);
};
var sorted_set_by = function (comparator,var_args){
var keys = null;
if (arguments.length > 1) {
var G__11896__i = 0, G__11896__a = new Array(arguments.length -  1);
while (G__11896__i < G__11896__a.length) {G__11896__a[G__11896__i] = arguments[G__11896__i + 1]; ++G__11896__i;}
  keys = new cljs.core.IndexedSeq(G__11896__a,0);
} 
return sorted_set_by__delegate.call(this,comparator,keys);};
sorted_set_by.cljs$lang$maxFixedArity = 1;
sorted_set_by.cljs$lang$applyTo = (function (arglist__11897){
var comparator = cljs.core.first(arglist__11897);
var keys = cljs.core.rest(arglist__11897);
return sorted_set_by__delegate(comparator,keys);
});
sorted_set_by.cljs$core$IFn$_invoke$arity$variadic = sorted_set_by__delegate;
return sorted_set_by;
})()
;
/**
* Given a map of replacement pairs and a vector/collection, returns a
* vector/seq with any elements = a key in smap replaced with the
* corresponding val in smap.  Returns a transducer when no collection
* is provided.
*/
cljs.core.replace = (function() {
var replace = null;
var replace__1 = (function (smap){
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (p1__11898_SHARP_){
var temp__4124__auto__ = cljs.core.find(smap,p1__11898_SHARP_);
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
return cljs.core.val(e);
} else {
return p1__11898_SHARP_;
}
}));
});
var replace__2 = (function (smap,coll){
if(cljs.core.vector_QMARK_(coll)){
var n = cljs.core.count(coll);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (n){
return (function (v,i){
var temp__4124__auto__ = cljs.core.find(smap,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(v,i));
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(v,i,cljs.core.second(e));
} else {
return v;
}
});})(n))
,coll,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.iterate(cljs.core.inc,(0))));
} else {
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__11899_SHARP_){
var temp__4124__auto__ = cljs.core.find(smap,p1__11899_SHARP_);
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
return cljs.core.second(e);
} else {
return p1__11899_SHARP_;
}
}),coll);
}
});
replace = function(smap,coll){
switch(arguments.length){
case 1:
return replace__1.call(this,smap);
case 2:
return replace__2.call(this,smap,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
replace.cljs$core$IFn$_invoke$arity$1 = replace__1;
replace.cljs$core$IFn$_invoke$arity$2 = replace__2;
return replace;
})()
;
/**
* Returns a lazy sequence of the elements of coll with duplicates removed
*/
cljs.core.distinct = (function() {
var distinct = null;
var distinct__0 = (function (){
return (function (rf){
var seen = cljs.core.volatile_BANG_(cljs.core.PersistentHashSet.EMPTY);
return ((function (seen){
return (function() {
var G__11920 = null;
var G__11920__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11920__1 = (function (result){
var G__11910 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11910) : rf.call(null,G__11910));
});
var G__11920__2 = (function (result,input){
if(cljs.core.contains_QMARK_((function (){var G__11911 = seen;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11911) : cljs.core.deref.call(null,G__11911));
})(),input)){
return result;
} else {
seen.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen.cljs$core$IDeref$_deref$arity$1(null),input));

var G__11912 = result;
var G__11913 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11912,G__11913) : rf.call(null,G__11912,G__11913));
}
});
G__11920 = function(result,input){
switch(arguments.length){
case 0:
return G__11920__0.call(this);
case 1:
return G__11920__1.call(this,result);
case 2:
return G__11920__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11920.cljs$core$IFn$_invoke$arity$0 = G__11920__0;
G__11920.cljs$core$IFn$_invoke$arity$1 = G__11920__1;
G__11920.cljs$core$IFn$_invoke$arity$2 = G__11920__2;
return G__11920;
})()
;})(seen))
});
});
var distinct__1 = (function (coll){
var step = (function step(xs,seen){
return (new cljs.core.LazySeq(null,(function (){
return (function (p__11918,seen__$1){
while(true){
var vec__11919 = p__11918;
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11919,(0),null);
var xs__$1 = vec__11919;
var temp__4126__auto__ = cljs.core.seq(xs__$1);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.contains_QMARK_(seen__$1,f)){
var G__11921 = cljs.core.rest(s);
var G__11922 = seen__$1;
p__11918 = G__11921;
seen__$1 = G__11922;
continue;
} else {
return cljs.core.cons(f,step(cljs.core.rest(s),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen__$1,f)));
}
} else {
return null;
}
break;
}
}).call(null,xs,seen);
}),null,null));
});
return step(coll,cljs.core.PersistentHashSet.EMPTY);
});
distinct = function(coll){
switch(arguments.length){
case 0:
return distinct__0.call(this);
case 1:
return distinct__1.call(this,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
distinct.cljs$core$IFn$_invoke$arity$0 = distinct__0;
distinct.cljs$core$IFn$_invoke$arity$1 = distinct__1;
return distinct;
})()
;
cljs.core.butlast = (function butlast(s){
var ret = cljs.core.PersistentVector.EMPTY;
var s__$1 = s;
while(true){
if(cljs.core.next(s__$1)){
var G__11923 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,cljs.core.first(s__$1));
var G__11924 = cljs.core.next(s__$1);
ret = G__11923;
s__$1 = G__11924;
continue;
} else {
return cljs.core.seq(ret);
}
break;
}
});
/**
* Returns the name String of a string, symbol or keyword.
*/
cljs.core.name = (function name(x){
if((function (){var G__11926 = x;
if(G__11926){
var bit__4432__auto__ = (G__11926.cljs$lang$protocol_mask$partition1$ & (4096));
if((bit__4432__auto__) || (G__11926.cljs$core$INamed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return x.cljs$core$INamed$_name$arity$1(null);
} else {
if(typeof x === 'string'){
return x;
} else {
throw (new Error([cljs.core.str("Doesn't support name: "),cljs.core.str(x)].join('')));
}
}
});
/**
* Returns a map with the keys mapped to the corresponding vals.
*/
cljs.core.zipmap = (function zipmap(keys,vals){
var map = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
var ks = cljs.core.seq(keys);
var vs = cljs.core.seq(vals);
while(true){
if((ks) && (vs)){
var G__11927 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(map,cljs.core.first(ks),cljs.core.first(vs));
var G__11928 = cljs.core.next(ks);
var G__11929 = cljs.core.next(vs);
map = G__11927;
ks = G__11928;
vs = G__11929;
continue;
} else {
return cljs.core.persistent_BANG_(map);
}
break;
}
});
/**
* Returns the x for which (k x), a number, is greatest.
* @param {...*} var_args
*/
cljs.core.max_key = (function() {
var max_key = null;
var max_key__2 = (function (k,x){
return x;
});
var max_key__3 = (function (k,x,y){
if(((function (){var G__11940 = x;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__11940) : k.call(null,G__11940));
})() > (function (){var G__11941 = y;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__11941) : k.call(null,G__11941));
})())){
return x;
} else {
return y;
}
});
var max_key__4 = (function() { 
var G__11942__delegate = function (k,x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__11930_SHARP_,p2__11931_SHARP_){
return max_key.cljs$core$IFn$_invoke$arity$3(k,p1__11930_SHARP_,p2__11931_SHARP_);
}),max_key.cljs$core$IFn$_invoke$arity$3(k,x,y),more);
};
var G__11942 = function (k,x,y,var_args){
var more = null;
if (arguments.length > 3) {
var G__11943__i = 0, G__11943__a = new Array(arguments.length -  3);
while (G__11943__i < G__11943__a.length) {G__11943__a[G__11943__i] = arguments[G__11943__i + 3]; ++G__11943__i;}
  more = new cljs.core.IndexedSeq(G__11943__a,0);
} 
return G__11942__delegate.call(this,k,x,y,more);};
G__11942.cljs$lang$maxFixedArity = 3;
G__11942.cljs$lang$applyTo = (function (arglist__11944){
var k = cljs.core.first(arglist__11944);
arglist__11944 = cljs.core.next(arglist__11944);
var x = cljs.core.first(arglist__11944);
arglist__11944 = cljs.core.next(arglist__11944);
var y = cljs.core.first(arglist__11944);
var more = cljs.core.rest(arglist__11944);
return G__11942__delegate(k,x,y,more);
});
G__11942.cljs$core$IFn$_invoke$arity$variadic = G__11942__delegate;
return G__11942;
})()
;
max_key = function(k,x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return max_key__2.call(this,k,x);
case 3:
return max_key__3.call(this,k,x,y);
default:
var G__11945 = null;
if (arguments.length > 3) {
var G__11946__i = 0, G__11946__a = new Array(arguments.length -  3);
while (G__11946__i < G__11946__a.length) {G__11946__a[G__11946__i] = arguments[G__11946__i + 3]; ++G__11946__i;}
G__11945 = new cljs.core.IndexedSeq(G__11946__a,0);
}
return max_key__4.cljs$core$IFn$_invoke$arity$variadic(k,x,y, G__11945);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
max_key.cljs$lang$maxFixedArity = 3;
max_key.cljs$lang$applyTo = max_key__4.cljs$lang$applyTo;
max_key.cljs$core$IFn$_invoke$arity$2 = max_key__2;
max_key.cljs$core$IFn$_invoke$arity$3 = max_key__3;
max_key.cljs$core$IFn$_invoke$arity$variadic = max_key__4.cljs$core$IFn$_invoke$arity$variadic;
return max_key;
})()
;
/**
* Returns the x for which (k x), a number, is least.
* @param {...*} var_args
*/
cljs.core.min_key = (function() {
var min_key = null;
var min_key__2 = (function (k,x){
return x;
});
var min_key__3 = (function (k,x,y){
if(((function (){var G__11957 = x;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__11957) : k.call(null,G__11957));
})() < (function (){var G__11958 = y;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__11958) : k.call(null,G__11958));
})())){
return x;
} else {
return y;
}
});
var min_key__4 = (function() { 
var G__11959__delegate = function (k,x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__11947_SHARP_,p2__11948_SHARP_){
return min_key.cljs$core$IFn$_invoke$arity$3(k,p1__11947_SHARP_,p2__11948_SHARP_);
}),min_key.cljs$core$IFn$_invoke$arity$3(k,x,y),more);
};
var G__11959 = function (k,x,y,var_args){
var more = null;
if (arguments.length > 3) {
var G__11960__i = 0, G__11960__a = new Array(arguments.length -  3);
while (G__11960__i < G__11960__a.length) {G__11960__a[G__11960__i] = arguments[G__11960__i + 3]; ++G__11960__i;}
  more = new cljs.core.IndexedSeq(G__11960__a,0);
} 
return G__11959__delegate.call(this,k,x,y,more);};
G__11959.cljs$lang$maxFixedArity = 3;
G__11959.cljs$lang$applyTo = (function (arglist__11961){
var k = cljs.core.first(arglist__11961);
arglist__11961 = cljs.core.next(arglist__11961);
var x = cljs.core.first(arglist__11961);
arglist__11961 = cljs.core.next(arglist__11961);
var y = cljs.core.first(arglist__11961);
var more = cljs.core.rest(arglist__11961);
return G__11959__delegate(k,x,y,more);
});
G__11959.cljs$core$IFn$_invoke$arity$variadic = G__11959__delegate;
return G__11959;
})()
;
min_key = function(k,x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return min_key__2.call(this,k,x);
case 3:
return min_key__3.call(this,k,x,y);
default:
var G__11962 = null;
if (arguments.length > 3) {
var G__11963__i = 0, G__11963__a = new Array(arguments.length -  3);
while (G__11963__i < G__11963__a.length) {G__11963__a[G__11963__i] = arguments[G__11963__i + 3]; ++G__11963__i;}
G__11962 = new cljs.core.IndexedSeq(G__11963__a,0);
}
return min_key__4.cljs$core$IFn$_invoke$arity$variadic(k,x,y, G__11962);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
min_key.cljs$lang$maxFixedArity = 3;
min_key.cljs$lang$applyTo = min_key__4.cljs$lang$applyTo;
min_key.cljs$core$IFn$_invoke$arity$2 = min_key__2;
min_key.cljs$core$IFn$_invoke$arity$3 = min_key__3;
min_key.cljs$core$IFn$_invoke$arity$variadic = min_key__4.cljs$core$IFn$_invoke$arity$variadic;
return min_key;
})()
;

/**
* @constructor
*/
cljs.core.ArrayList = (function (arr){
this.arr = arr;
})
cljs.core.ArrayList.prototype.add = (function (x){
var self__ = this;
var _ = this;
return self__.arr.push(x);
});

cljs.core.ArrayList.prototype.size = (function (){
var self__ = this;
var _ = this;
return self__.arr.length;
});

cljs.core.ArrayList.prototype.clear = (function (){
var self__ = this;
var _ = this;
return self__.arr = [];
});

cljs.core.ArrayList.prototype.isEmpty = (function (){
var self__ = this;
var _ = this;
return (self__.arr.length === (0));
});

cljs.core.ArrayList.prototype.toArray = (function (){
var self__ = this;
var _ = this;
return self__.arr;
});

cljs.core.ArrayList.cljs$lang$type = true;

cljs.core.ArrayList.cljs$lang$ctorStr = "cljs.core/ArrayList";

cljs.core.ArrayList.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/ArrayList");
});

cljs.core.__GT_ArrayList = (function __GT_ArrayList(arr){
return (new cljs.core.ArrayList(arr));
});

cljs.core.array_list = (function array_list(){
return (new cljs.core.ArrayList([]));
});
/**
* Returns a lazy sequence of lists like partition, but may include
* partitions with fewer than n items at the end.  Returns a stateful
* transducer when no collection is provided.
*/
cljs.core.partition_all = (function() {
var partition_all = null;
var partition_all__1 = (function (n){
return (function (rf){
var a = cljs.core.array_list();
return ((function (a){
return (function() {
var G__11980 = null;
var G__11980__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11980__1 = (function (result){
var result__$1 = (cljs.core.truth_(a.isEmpty())?result:(function (){var v = cljs.core.vec(a.toArray());
a.clear();

return cljs.core.unreduced((function (){var G__11975 = result;
var G__11976 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11975,G__11976) : rf.call(null,G__11975,G__11976));
})());
})());
var G__11977 = result__$1;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11977) : rf.call(null,G__11977));
});
var G__11980__2 = (function (result,input){
a.add(input);

if((n === a.size())){
var v = cljs.core.vec(a.toArray());
a.clear();

var G__11978 = result;
var G__11979 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11978,G__11979) : rf.call(null,G__11978,G__11979));
} else {
return result;
}
});
G__11980 = function(result,input){
switch(arguments.length){
case 0:
return G__11980__0.call(this);
case 1:
return G__11980__1.call(this,result);
case 2:
return G__11980__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11980.cljs$core$IFn$_invoke$arity$0 = G__11980__0;
G__11980.cljs$core$IFn$_invoke$arity$1 = G__11980__1;
G__11980.cljs$core$IFn$_invoke$arity$2 = G__11980__2;
return G__11980;
})()
;})(a))
});
});
var partition_all__2 = (function (n,coll){
return partition_all.cljs$core$IFn$_invoke$arity$3(n,n,coll);
});
var partition_all__3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return cljs.core.cons(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s),partition_all.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
}),null,null));
});
partition_all = function(n,step,coll){
switch(arguments.length){
case 1:
return partition_all__1.call(this,n);
case 2:
return partition_all__2.call(this,n,step);
case 3:
return partition_all__3.call(this,n,step,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partition_all.cljs$core$IFn$_invoke$arity$1 = partition_all__1;
partition_all.cljs$core$IFn$_invoke$arity$2 = partition_all__2;
partition_all.cljs$core$IFn$_invoke$arity$3 = partition_all__3;
return partition_all;
})()
;
/**
* Returns a lazy sequence of successive items from coll while
* (pred item) returns true. pred must be free of side-effects.
* Returns a transducer when no collection is provided.
*/
cljs.core.take_while = (function() {
var take_while = null;
var take_while__1 = (function (pred){
return (function (rf){
return (function() {
var G__11993 = null;
var G__11993__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11993__1 = (function (result){
var G__11988 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11988) : rf.call(null,G__11988));
});
var G__11993__2 = (function (result,input){
if(cljs.core.truth_((function (){var G__11989 = input;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__11989) : pred.call(null,G__11989));
})())){
var G__11990 = result;
var G__11991 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11990,G__11991) : rf.call(null,G__11990,G__11991));
} else {
return cljs.core.reduced(result);
}
});
G__11993 = function(result,input){
switch(arguments.length){
case 0:
return G__11993__0.call(this);
case 1:
return G__11993__1.call(this,result);
case 2:
return G__11993__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11993.cljs$core$IFn$_invoke$arity$0 = G__11993__0;
G__11993.cljs$core$IFn$_invoke$arity$1 = G__11993__1;
G__11993.cljs$core$IFn$_invoke$arity$2 = G__11993__2;
return G__11993;
})()
});
});
var take_while__2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.truth_((function (){var G__11992 = cljs.core.first(s);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__11992) : pred.call(null,G__11992));
})())){
return cljs.core.cons(cljs.core.first(s),take_while.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});
take_while = function(pred,coll){
switch(arguments.length){
case 1:
return take_while__1.call(this,pred);
case 2:
return take_while__2.call(this,pred,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
take_while.cljs$core$IFn$_invoke$arity$1 = take_while__1;
take_while.cljs$core$IFn$_invoke$arity$2 = take_while__2;
return take_while;
})()
;
cljs.core.mk_bound_fn = (function mk_bound_fn(sc,test,key){
return (function (e){
var comp = cljs.core._comparator(sc);
var G__11998 = (function (){var G__12000 = cljs.core._entry_key(sc,e);
var G__12001 = key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__12000,G__12001) : comp.call(null,G__12000,G__12001));
})();
var G__11999 = (0);
return (test.cljs$core$IFn$_invoke$arity$2 ? test.cljs$core$IFn$_invoke$arity$2(G__11998,G__11999) : test.call(null,G__11998,G__11999));
});
});
/**
* sc must be a sorted collection, test(s) one of <, <=, > or
* >=. Returns a seq of those entries with keys ek for
* which (test (.. sc comparator (compare ek key)) 0) is true
*/
cljs.core.subseq = (function() {
var subseq = null;
var subseq__3 = (function (sc,test,key){
var include = cljs.core.mk_bound_fn(sc,test,key);
if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._GT_,cljs.core._GT__EQ_], true).call(null,test))){
var temp__4126__auto__ = cljs.core._sorted_seq_from(sc,key,true);
if(cljs.core.truth_(temp__4126__auto__)){
var vec__12005 = temp__4126__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12005,(0),null);
var s = vec__12005;
if(cljs.core.truth_((function (){var G__12006 = e;
return (include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(G__12006) : include.call(null,G__12006));
})())){
return s;
} else {
return cljs.core.next(s);
}
} else {
return null;
}
} else {
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include,cljs.core._sorted_seq(sc,true));
}
});
var subseq__5 = (function (sc,start_test,start_key,end_test,end_key){
var temp__4126__auto__ = cljs.core._sorted_seq_from(sc,start_key,true);
if(cljs.core.truth_(temp__4126__auto__)){
var vec__12007 = temp__4126__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12007,(0),null);
var s = vec__12007;
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc,end_test,end_key),(cljs.core.truth_(cljs.core.mk_bound_fn(sc,start_test,start_key).call(null,e))?s:cljs.core.next(s)));
} else {
return null;
}
});
subseq = function(sc,start_test,start_key,end_test,end_key){
switch(arguments.length){
case 3:
return subseq__3.call(this,sc,start_test,start_key);
case 5:
return subseq__5.call(this,sc,start_test,start_key,end_test,end_key);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
subseq.cljs$core$IFn$_invoke$arity$3 = subseq__3;
subseq.cljs$core$IFn$_invoke$arity$5 = subseq__5;
return subseq;
})()
;
/**
* sc must be a sorted collection, test(s) one of <, <=, > or
* >=. Returns a reverse seq of those entries with keys ek for
* which (test (.. sc comparator (compare ek key)) 0) is true
*/
cljs.core.rsubseq = (function() {
var rsubseq = null;
var rsubseq__3 = (function (sc,test,key){
var include = cljs.core.mk_bound_fn(sc,test,key);
if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._LT_,cljs.core._LT__EQ_], true).call(null,test))){
var temp__4126__auto__ = cljs.core._sorted_seq_from(sc,key,false);
if(cljs.core.truth_(temp__4126__auto__)){
var vec__12011 = temp__4126__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12011,(0),null);
var s = vec__12011;
if(cljs.core.truth_((function (){var G__12012 = e;
return (include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(G__12012) : include.call(null,G__12012));
})())){
return s;
} else {
return cljs.core.next(s);
}
} else {
return null;
}
} else {
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include,cljs.core._sorted_seq(sc,false));
}
});
var rsubseq__5 = (function (sc,start_test,start_key,end_test,end_key){
var temp__4126__auto__ = cljs.core._sorted_seq_from(sc,end_key,false);
if(cljs.core.truth_(temp__4126__auto__)){
var vec__12013 = temp__4126__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12013,(0),null);
var s = vec__12013;
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc,start_test,start_key),(cljs.core.truth_(cljs.core.mk_bound_fn(sc,end_test,end_key).call(null,e))?s:cljs.core.next(s)));
} else {
return null;
}
});
rsubseq = function(sc,start_test,start_key,end_test,end_key){
switch(arguments.length){
case 3:
return rsubseq__3.call(this,sc,start_test,start_key);
case 5:
return rsubseq__5.call(this,sc,start_test,start_key,end_test,end_key);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
rsubseq.cljs$core$IFn$_invoke$arity$3 = rsubseq__3;
rsubseq.cljs$core$IFn$_invoke$arity$5 = rsubseq__5;
return rsubseq;
})()
;

/**
* @constructor
*/
cljs.core.RangeIterator = (function (i,end,step){
this.i = i;
this.end = end;
this.step = step;
})
cljs.core.RangeIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__.step > (0))){
return (self__.i < self__.end);
} else {
return (self__.i > self__.end);
}
});

cljs.core.RangeIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.i;
self__.i = (self__.i + self__.step);

return ret;
});

cljs.core.RangeIterator.cljs$lang$type = true;

cljs.core.RangeIterator.cljs$lang$ctorStr = "cljs.core/RangeIterator";

cljs.core.RangeIterator.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/RangeIterator");
});

cljs.core.__GT_RangeIterator = (function __GT_RangeIterator(i,end,step){
return (new cljs.core.RangeIterator(i,end,step));
});


/**
* @constructor
*/
cljs.core.Range = (function (meta,start,end,step,__hash){
this.meta = meta;
this.start = start;
this.end = end;
this.step = step;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375006;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Range.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Range.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (rng,n){
var self__ = this;
var rng__$1 = this;
if((n < cljs.core._count(rng__$1))){
return (self__.start + (n * self__.step));
} else {
if(((self__.start > self__.end)) && ((self__.step === (0)))){
return self__.start;
} else {
throw (new Error("Index out of bounds"));
}
}
});

cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (rng,n,not_found){
var self__ = this;
var rng__$1 = this;
if((n < cljs.core._count(rng__$1))){
return (self__.start + (n * self__.step));
} else {
if(((self__.start > self__.end)) && ((self__.step === (0)))){
return self__.start;
} else {
return not_found;
}
}
});

cljs.core.Range.prototype.cljs$core$IIterable$ = true;

cljs.core.Range.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RangeIterator(self__.start,self__.end,self__.step));
});

cljs.core.Range.prototype.cljs$core$IMeta$_meta$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return self__.meta;
});

cljs.core.Range.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Range(self__.meta,self__.start,self__.end,self__.step,self__.__hash));
});

cljs.core.Range.prototype.cljs$core$INext$_next$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((self__.step > (0))){
if(((self__.start + self__.step) < self__.end)){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return null;
}
} else {
if(((self__.start + self__.step) > self__.end)){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return null;
}
}
});

cljs.core.Range.prototype.cljs$core$ICounted$_count$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if(cljs.core.not(cljs.core._seq(rng__$1))){
return (0);
} else {
var G__12014 = ((self__.end - self__.start) / self__.step);
return (Math.ceil.cljs$core$IFn$_invoke$arity$1 ? Math.ceil.cljs$core$IFn$_invoke$arity$1(G__12014) : Math.ceil.call(null,G__12014));
}
});

cljs.core.Range.prototype.cljs$core$IHash$_hash$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(rng__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.Range.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (rng,other){
var self__ = this;
var rng__$1 = this;
return cljs.core.equiv_sequential(rng__$1,other);
});

cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (rng,f){
var self__ = this;
var rng__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(rng__$1,f);
});

cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (rng,f,init){
var self__ = this;
var rng__$1 = this;
var i = self__.start;
var ret = init;
while(true){
if((((self__.step > (0)))?(i < self__.end):(i > self__.end))){
var ret__$1 = (function (){var G__12015 = ret;
var G__12016 = i;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__12015,G__12016) : f.call(null,G__12015,G__12016));
})();
if(cljs.core.reduced_QMARK_(ret__$1)){
var G__12017 = ret__$1;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12017) : cljs.core.deref.call(null,G__12017));
} else {
var G__12018 = (i + self__.step);
var G__12019 = ret__$1;
i = G__12018;
ret = G__12019;
continue;
}
} else {
return ret;
}
break;
}
});

cljs.core.Range.prototype.cljs$core$ISeq$_first$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((cljs.core._seq(rng__$1) == null)){
return null;
} else {
return self__.start;
}
});

cljs.core.Range.prototype.cljs$core$ISeq$_rest$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if(!((cljs.core._seq(rng__$1) == null))){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.Range.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((self__.step > (0))){
if((self__.start < self__.end)){
return rng__$1;
} else {
return null;
}
} else {
if((self__.start > self__.end)){
return rng__$1;
} else {
return null;
}
}
});

cljs.core.Range.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (rng,meta__$1){
var self__ = this;
var rng__$1 = this;
return (new cljs.core.Range(meta__$1,self__.start,self__.end,self__.step,self__.__hash));
});

cljs.core.Range.prototype.cljs$core$ICollection$_conj$arity$2 = (function (rng,o){
var self__ = this;
var rng__$1 = this;
return cljs.core.cons(o,rng__$1);
});

cljs.core.Range.cljs$lang$type = true;

cljs.core.Range.cljs$lang$ctorStr = "cljs.core/Range";

cljs.core.Range.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/Range");
});

cljs.core.__GT_Range = (function __GT_Range(meta,start,end,step,__hash){
return (new cljs.core.Range(meta,start,end,step,__hash));
});

(cljs.core.Range.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
/**
* Returns a lazy seq of nums from start (inclusive) to end
* (exclusive), by step, where start defaults to 0, step to 1,
* and end to infinity.
*/
cljs.core.range = (function() {
var range = null;
var range__0 = (function (){
return range.cljs$core$IFn$_invoke$arity$3((0),Number.MAX_VALUE,(1));
});
var range__1 = (function (end){
return range.cljs$core$IFn$_invoke$arity$3((0),end,(1));
});
var range__2 = (function (start,end){
return range.cljs$core$IFn$_invoke$arity$3(start,end,(1));
});
var range__3 = (function (start,end,step){
return (new cljs.core.Range(null,start,end,step,null));
});
range = function(start,end,step){
switch(arguments.length){
case 0:
return range__0.call(this);
case 1:
return range__1.call(this,start);
case 2:
return range__2.call(this,start,end);
case 3:
return range__3.call(this,start,end,step);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
range.cljs$core$IFn$_invoke$arity$0 = range__0;
range.cljs$core$IFn$_invoke$arity$1 = range__1;
range.cljs$core$IFn$_invoke$arity$2 = range__2;
range.cljs$core$IFn$_invoke$arity$3 = range__3;
return range;
})()
;
/**
* Returns a lazy seq of every nth item in coll.  Returns a stateful
* transducer when no collection is provided.
*/
cljs.core.take_nth = (function() {
var take_nth = null;
var take_nth__1 = (function (n){
return (function (rf){
var ia = cljs.core.volatile_BANG_((-1));
return ((function (ia){
return (function() {
var G__12037 = null;
var G__12037__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__12037__1 = (function (result){
var G__12034 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__12034) : rf.call(null,G__12034));
});
var G__12037__2 = (function (result,input){
var i = ia.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(ia.cljs$core$IDeref$_deref$arity$1(null) + (1)));
if((cljs.core.rem(i,n) === (0))){
var G__12035 = result;
var G__12036 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__12035,G__12036) : rf.call(null,G__12035,G__12036));
} else {
return result;
}
});
G__12037 = function(result,input){
switch(arguments.length){
case 0:
return G__12037__0.call(this);
case 1:
return G__12037__1.call(this,result);
case 2:
return G__12037__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12037.cljs$core$IFn$_invoke$arity$0 = G__12037__0;
G__12037.cljs$core$IFn$_invoke$arity$1 = G__12037__1;
G__12037.cljs$core$IFn$_invoke$arity$2 = G__12037__2;
return G__12037;
})()
;})(ia))
});
});
var take_nth__2 = (function (n,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return cljs.core.cons(cljs.core.first(s),take_nth.cljs$core$IFn$_invoke$arity$2(n,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s)));
} else {
return null;
}
}),null,null));
});
take_nth = function(n,coll){
switch(arguments.length){
case 1:
return take_nth__1.call(this,n);
case 2:
return take_nth__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
take_nth.cljs$core$IFn$_invoke$arity$1 = take_nth__1;
take_nth.cljs$core$IFn$_invoke$arity$2 = take_nth__2;
return take_nth;
})()
;
/**
* Returns a vector of [(take-while pred coll) (drop-while pred coll)]
*/
cljs.core.split_with = (function split_with(pred,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(pred,coll),cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(pred,coll)], null);
});
/**
* Applies f to each value in coll, splitting it each time f returns a
* new value.  Returns a lazy seq of partitions.  Returns a stateful
* transducer when no collection is provided.
*/
cljs.core.partition_by = (function() {
var partition_by = null;
var partition_by__1 = (function (f){
return (function (rf){
var a = cljs.core.array_list();
var pa = cljs.core.volatile_BANG_(new cljs.core.Keyword("cljs.core","none","cljs.core/none",926646439));
return ((function (a,pa){
return (function() {
var G__12059 = null;
var G__12059__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__12059__1 = (function (result){
var result__$1 = (cljs.core.truth_(a.isEmpty())?result:(function (){var v = cljs.core.vec(a.toArray());
a.clear();

return cljs.core.unreduced((function (){var G__12050 = result;
var G__12051 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__12050,G__12051) : rf.call(null,G__12050,G__12051));
})());
})());
var G__12052 = result__$1;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__12052) : rf.call(null,G__12052));
});
var G__12059__2 = (function (result,input){
var pval = (function (){var G__12053 = pa;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12053) : cljs.core.deref.call(null,G__12053));
})();
var val = (function (){var G__12054 = input;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__12054) : f.call(null,G__12054));
})();
cljs.core.vreset_BANG_(pa,val);

if((cljs.core.keyword_identical_QMARK_(pval,new cljs.core.Keyword("cljs.core","none","cljs.core/none",926646439))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,pval))){
a.add(input);

return result;
} else {
var v = cljs.core.vec(a.toArray());
a.clear();

var ret = (function (){var G__12055 = result;
var G__12056 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__12055,G__12056) : rf.call(null,G__12055,G__12056));
})();
if(cljs.core.reduced_QMARK_(ret)){
} else {
a.add(input);
}

return ret;
}
});
G__12059 = function(result,input){
switch(arguments.length){
case 0:
return G__12059__0.call(this);
case 1:
return G__12059__1.call(this,result);
case 2:
return G__12059__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12059.cljs$core$IFn$_invoke$arity$0 = G__12059__0;
G__12059.cljs$core$IFn$_invoke$arity$1 = G__12059__1;
G__12059.cljs$core$IFn$_invoke$arity$2 = G__12059__2;
return G__12059;
})()
;})(a,pa))
});
});
var partition_by__2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
var fst = cljs.core.first(s);
var fv = (function (){var G__12057 = fst;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__12057) : f.call(null,G__12057));
})();
var run = cljs.core.cons(fst,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(((function (fst,fv,s,temp__4126__auto__){
return (function (p1__12038_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fv,(function (){var G__12058 = p1__12038_SHARP_;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__12058) : f.call(null,G__12058));
})());
});})(fst,fv,s,temp__4126__auto__))
,cljs.core.next(s)));
return cljs.core.cons(run,partition_by.cljs$core$IFn$_invoke$arity$2(f,cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(cljs.core.count(run),s))));
} else {
return null;
}
}),null,null));
});
partition_by = function(f,coll){
switch(arguments.length){
case 1:
return partition_by__1.call(this,f);
case 2:
return partition_by__2.call(this,f,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partition_by.cljs$core$IFn$_invoke$arity$1 = partition_by__1;
partition_by.cljs$core$IFn$_invoke$arity$2 = partition_by__2;
return partition_by;
})()
;
/**
* Returns a map from distinct items in coll to the number of times
* they appear.
*/
cljs.core.frequencies = (function frequencies(coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (counts,x){
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(counts,x,(cljs.core.get.cljs$core$IFn$_invoke$arity$3(counts,x,(0)) + (1)));
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),coll));
});
/**
* Returns a lazy seq of the intermediate values of the reduction (as
* per reduce) of coll by f, starting with init.
*/
cljs.core.reductions = (function() {
var reductions = null;
var reductions__2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4124__auto__ = cljs.core.seq(coll);
if(temp__4124__auto__){
var s = temp__4124__auto__;
return reductions.cljs$core$IFn$_invoke$arity$3(f,cljs.core.first(s),cljs.core.rest(s));
} else {
return cljs.core._conj(cljs.core.List.EMPTY,(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})());
}
}),null,null));
});
var reductions__3 = (function (f,init,coll){
return cljs.core.cons(init,(new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return reductions.cljs$core$IFn$_invoke$arity$3(f,(function (){var G__12068 = init;
var G__12069 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__12068,G__12069) : f.call(null,G__12068,G__12069));
})(),cljs.core.rest(s));
} else {
return null;
}
}),null,null)));
});
reductions = function(f,init,coll){
switch(arguments.length){
case 2:
return reductions__2.call(this,f,init);
case 3:
return reductions__3.call(this,f,init,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
reductions.cljs$core$IFn$_invoke$arity$2 = reductions__2;
reductions.cljs$core$IFn$_invoke$arity$3 = reductions__3;
return reductions;
})()
;
/**
* Takes a set of functions and returns a fn that is the juxtaposition
* of those fns.  The returned fn takes a variable number of args, and
* returns a vector containing the result of applying each fn to the
* args (left-to-right).
* ((juxt a b c) x) => [(a x) (b x) (c x)]
* @param {...*} var_args
*/
cljs.core.juxt = (function() {
var juxt = null;
var juxt__1 = (function (f){
return (function() {
var G__12164 = null;
var G__12164__0 = (function (){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})()],null));
});
var G__12164__1 = (function (x){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__12122 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__12122) : f.call(null,G__12122));
})()],null));
});
var G__12164__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__12123 = x;
var G__12124 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__12123,G__12124) : f.call(null,G__12123,G__12124));
})()],null));
});
var G__12164__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__12125 = x;
var G__12126 = y;
var G__12127 = z;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__12125,G__12126,G__12127) : f.call(null,G__12125,G__12126,G__12127));
})()],null));
});
var G__12164__4 = (function() { 
var G__12165__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args)],null));
};
var G__12165 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__12166__i = 0, G__12166__a = new Array(arguments.length -  3);
while (G__12166__i < G__12166__a.length) {G__12166__a[G__12166__i] = arguments[G__12166__i + 3]; ++G__12166__i;}
  args = new cljs.core.IndexedSeq(G__12166__a,0);
} 
return G__12165__delegate.call(this,x,y,z,args);};
G__12165.cljs$lang$maxFixedArity = 3;
G__12165.cljs$lang$applyTo = (function (arglist__12167){
var x = cljs.core.first(arglist__12167);
arglist__12167 = cljs.core.next(arglist__12167);
var y = cljs.core.first(arglist__12167);
arglist__12167 = cljs.core.next(arglist__12167);
var z = cljs.core.first(arglist__12167);
var args = cljs.core.rest(arglist__12167);
return G__12165__delegate(x,y,z,args);
});
G__12165.cljs$core$IFn$_invoke$arity$variadic = G__12165__delegate;
return G__12165;
})()
;
G__12164 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__12164__0.call(this);
case 1:
return G__12164__1.call(this,x);
case 2:
return G__12164__2.call(this,x,y);
case 3:
return G__12164__3.call(this,x,y,z);
default:
var G__12168 = null;
if (arguments.length > 3) {
var G__12169__i = 0, G__12169__a = new Array(arguments.length -  3);
while (G__12169__i < G__12169__a.length) {G__12169__a[G__12169__i] = arguments[G__12169__i + 3]; ++G__12169__i;}
G__12168 = new cljs.core.IndexedSeq(G__12169__a,0);
}
return G__12164__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__12168);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12164.cljs$lang$maxFixedArity = 3;
G__12164.cljs$lang$applyTo = G__12164__4.cljs$lang$applyTo;
G__12164.cljs$core$IFn$_invoke$arity$0 = G__12164__0;
G__12164.cljs$core$IFn$_invoke$arity$1 = G__12164__1;
G__12164.cljs$core$IFn$_invoke$arity$2 = G__12164__2;
G__12164.cljs$core$IFn$_invoke$arity$3 = G__12164__3;
G__12164.cljs$core$IFn$_invoke$arity$variadic = G__12164__4.cljs$core$IFn$_invoke$arity$variadic;
return G__12164;
})()
});
var juxt__2 = (function (f,g){
return (function() {
var G__12170 = null;
var G__12170__0 = (function (){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),(function (){return (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
})()],null));
});
var G__12170__1 = (function (x){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__12128 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__12128) : f.call(null,G__12128));
})(),(function (){var G__12129 = x;
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__12129) : g.call(null,G__12129));
})()],null));
});
var G__12170__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__12130 = x;
var G__12131 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__12130,G__12131) : f.call(null,G__12130,G__12131));
})(),(function (){var G__12132 = x;
var G__12133 = y;
return (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(G__12132,G__12133) : g.call(null,G__12132,G__12133));
})()],null));
});
var G__12170__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__12134 = x;
var G__12135 = y;
var G__12136 = z;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__12134,G__12135,G__12136) : f.call(null,G__12134,G__12135,G__12136));
})(),(function (){var G__12137 = x;
var G__12138 = y;
var G__12139 = z;
return (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(G__12137,G__12138,G__12139) : g.call(null,G__12137,G__12138,G__12139));
})()],null));
});
var G__12170__4 = (function() { 
var G__12171__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args)],null));
};
var G__12171 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__12172__i = 0, G__12172__a = new Array(arguments.length -  3);
while (G__12172__i < G__12172__a.length) {G__12172__a[G__12172__i] = arguments[G__12172__i + 3]; ++G__12172__i;}
  args = new cljs.core.IndexedSeq(G__12172__a,0);
} 
return G__12171__delegate.call(this,x,y,z,args);};
G__12171.cljs$lang$maxFixedArity = 3;
G__12171.cljs$lang$applyTo = (function (arglist__12173){
var x = cljs.core.first(arglist__12173);
arglist__12173 = cljs.core.next(arglist__12173);
var y = cljs.core.first(arglist__12173);
arglist__12173 = cljs.core.next(arglist__12173);
var z = cljs.core.first(arglist__12173);
var args = cljs.core.rest(arglist__12173);
return G__12171__delegate(x,y,z,args);
});
G__12171.cljs$core$IFn$_invoke$arity$variadic = G__12171__delegate;
return G__12171;
})()
;
G__12170 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__12170__0.call(this);
case 1:
return G__12170__1.call(this,x);
case 2:
return G__12170__2.call(this,x,y);
case 3:
return G__12170__3.call(this,x,y,z);
default:
var G__12174 = null;
if (arguments.length > 3) {
var G__12175__i = 0, G__12175__a = new Array(arguments.length -  3);
while (G__12175__i < G__12175__a.length) {G__12175__a[G__12175__i] = arguments[G__12175__i + 3]; ++G__12175__i;}
G__12174 = new cljs.core.IndexedSeq(G__12175__a,0);
}
return G__12170__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__12174);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12170.cljs$lang$maxFixedArity = 3;
G__12170.cljs$lang$applyTo = G__12170__4.cljs$lang$applyTo;
G__12170.cljs$core$IFn$_invoke$arity$0 = G__12170__0;
G__12170.cljs$core$IFn$_invoke$arity$1 = G__12170__1;
G__12170.cljs$core$IFn$_invoke$arity$2 = G__12170__2;
G__12170.cljs$core$IFn$_invoke$arity$3 = G__12170__3;
G__12170.cljs$core$IFn$_invoke$arity$variadic = G__12170__4.cljs$core$IFn$_invoke$arity$variadic;
return G__12170;
})()
});
var juxt__3 = (function (f,g,h){
return (function() {
var G__12176 = null;
var G__12176__0 = (function (){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),(function (){return (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
})(),(function (){return (h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null));
})()],null));
});
var G__12176__1 = (function (x){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__12140 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__12140) : f.call(null,G__12140));
})(),(function (){var G__12141 = x;
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__12141) : g.call(null,G__12141));
})(),(function (){var G__12142 = x;
return (h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(G__12142) : h.call(null,G__12142));
})()],null));
});
var G__12176__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__12143 = x;
var G__12144 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__12143,G__12144) : f.call(null,G__12143,G__12144));
})(),(function (){var G__12145 = x;
var G__12146 = y;
return (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(G__12145,G__12146) : g.call(null,G__12145,G__12146));
})(),(function (){var G__12147 = x;
var G__12148 = y;
return (h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(G__12147,G__12148) : h.call(null,G__12147,G__12148));
})()],null));
});
var G__12176__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__12149 = x;
var G__12150 = y;
var G__12151 = z;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__12149,G__12150,G__12151) : f.call(null,G__12149,G__12150,G__12151));
})(),(function (){var G__12152 = x;
var G__12153 = y;
var G__12154 = z;
return (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(G__12152,G__12153,G__12154) : g.call(null,G__12152,G__12153,G__12154));
})(),(function (){var G__12155 = x;
var G__12156 = y;
var G__12157 = z;
return (h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(G__12155,G__12156,G__12157) : h.call(null,G__12155,G__12156,G__12157));
})()],null));
});
var G__12176__4 = (function() { 
var G__12177__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args)],null));
};
var G__12177 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__12178__i = 0, G__12178__a = new Array(arguments.length -  3);
while (G__12178__i < G__12178__a.length) {G__12178__a[G__12178__i] = arguments[G__12178__i + 3]; ++G__12178__i;}
  args = new cljs.core.IndexedSeq(G__12178__a,0);
} 
return G__12177__delegate.call(this,x,y,z,args);};
G__12177.cljs$lang$maxFixedArity = 3;
G__12177.cljs$lang$applyTo = (function (arglist__12179){
var x = cljs.core.first(arglist__12179);
arglist__12179 = cljs.core.next(arglist__12179);
var y = cljs.core.first(arglist__12179);
arglist__12179 = cljs.core.next(arglist__12179);
var z = cljs.core.first(arglist__12179);
var args = cljs.core.rest(arglist__12179);
return G__12177__delegate(x,y,z,args);
});
G__12177.cljs$core$IFn$_invoke$arity$variadic = G__12177__delegate;
return G__12177;
})()
;
G__12176 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__12176__0.call(this);
case 1:
return G__12176__1.call(this,x);
case 2:
return G__12176__2.call(this,x,y);
case 3:
return G__12176__3.call(this,x,y,z);
default:
var G__12180 = null;
if (arguments.length > 3) {
var G__12181__i = 0, G__12181__a = new Array(arguments.length -  3);
while (G__12181__i < G__12181__a.length) {G__12181__a[G__12181__i] = arguments[G__12181__i + 3]; ++G__12181__i;}
G__12180 = new cljs.core.IndexedSeq(G__12181__a,0);
}
return G__12176__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__12180);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12176.cljs$lang$maxFixedArity = 3;
G__12176.cljs$lang$applyTo = G__12176__4.cljs$lang$applyTo;
G__12176.cljs$core$IFn$_invoke$arity$0 = G__12176__0;
G__12176.cljs$core$IFn$_invoke$arity$1 = G__12176__1;
G__12176.cljs$core$IFn$_invoke$arity$2 = G__12176__2;
G__12176.cljs$core$IFn$_invoke$arity$3 = G__12176__3;
G__12176.cljs$core$IFn$_invoke$arity$variadic = G__12176__4.cljs$core$IFn$_invoke$arity$variadic;
return G__12176;
})()
});
var juxt__4 = (function() { 
var G__12182__delegate = function (f,g,h,fs){
var fs__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f,g,h,fs);
return ((function (fs__$1){
return (function() {
var G__12183 = null;
var G__12183__0 = (function (){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__12070_SHARP_,p2__12071_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__12070_SHARP_,(function (){return (p2__12071_SHARP_.cljs$core$IFn$_invoke$arity$0 ? p2__12071_SHARP_.cljs$core$IFn$_invoke$arity$0() : p2__12071_SHARP_.call(null));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__12183__1 = (function (x){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__12072_SHARP_,p2__12073_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__12072_SHARP_,(function (){var G__12158 = x;
return (p2__12073_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p2__12073_SHARP_.cljs$core$IFn$_invoke$arity$1(G__12158) : p2__12073_SHARP_.call(null,G__12158));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__12183__2 = (function (x,y){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__12074_SHARP_,p2__12075_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__12074_SHARP_,(function (){var G__12159 = x;
var G__12160 = y;
return (p2__12075_SHARP_.cljs$core$IFn$_invoke$arity$2 ? p2__12075_SHARP_.cljs$core$IFn$_invoke$arity$2(G__12159,G__12160) : p2__12075_SHARP_.call(null,G__12159,G__12160));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__12183__3 = (function (x,y,z){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__12076_SHARP_,p2__12077_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__12076_SHARP_,(function (){var G__12161 = x;
var G__12162 = y;
var G__12163 = z;
return (p2__12077_SHARP_.cljs$core$IFn$_invoke$arity$3 ? p2__12077_SHARP_.cljs$core$IFn$_invoke$arity$3(G__12161,G__12162,G__12163) : p2__12077_SHARP_.call(null,G__12161,G__12162,G__12163));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__12183__4 = (function() { 
var G__12184__delegate = function (x,y,z,args){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__12078_SHARP_,p2__12079_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__12078_SHARP_,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(p2__12079_SHARP_,x,y,z,args));
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
};
var G__12184 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__12185__i = 0, G__12185__a = new Array(arguments.length -  3);
while (G__12185__i < G__12185__a.length) {G__12185__a[G__12185__i] = arguments[G__12185__i + 3]; ++G__12185__i;}
  args = new cljs.core.IndexedSeq(G__12185__a,0);
} 
return G__12184__delegate.call(this,x,y,z,args);};
G__12184.cljs$lang$maxFixedArity = 3;
G__12184.cljs$lang$applyTo = (function (arglist__12186){
var x = cljs.core.first(arglist__12186);
arglist__12186 = cljs.core.next(arglist__12186);
var y = cljs.core.first(arglist__12186);
arglist__12186 = cljs.core.next(arglist__12186);
var z = cljs.core.first(arglist__12186);
var args = cljs.core.rest(arglist__12186);
return G__12184__delegate(x,y,z,args);
});
G__12184.cljs$core$IFn$_invoke$arity$variadic = G__12184__delegate;
return G__12184;
})()
;
G__12183 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__12183__0.call(this);
case 1:
return G__12183__1.call(this,x);
case 2:
return G__12183__2.call(this,x,y);
case 3:
return G__12183__3.call(this,x,y,z);
default:
var G__12187 = null;
if (arguments.length > 3) {
var G__12188__i = 0, G__12188__a = new Array(arguments.length -  3);
while (G__12188__i < G__12188__a.length) {G__12188__a[G__12188__i] = arguments[G__12188__i + 3]; ++G__12188__i;}
G__12187 = new cljs.core.IndexedSeq(G__12188__a,0);
}
return G__12183__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__12187);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12183.cljs$lang$maxFixedArity = 3;
G__12183.cljs$lang$applyTo = G__12183__4.cljs$lang$applyTo;
G__12183.cljs$core$IFn$_invoke$arity$0 = G__12183__0;
G__12183.cljs$core$IFn$_invoke$arity$1 = G__12183__1;
G__12183.cljs$core$IFn$_invoke$arity$2 = G__12183__2;
G__12183.cljs$core$IFn$_invoke$arity$3 = G__12183__3;
G__12183.cljs$core$IFn$_invoke$arity$variadic = G__12183__4.cljs$core$IFn$_invoke$arity$variadic;
return G__12183;
})()
;})(fs__$1))
};
var G__12182 = function (f,g,h,var_args){
var fs = null;
if (arguments.length > 3) {
var G__12189__i = 0, G__12189__a = new Array(arguments.length -  3);
while (G__12189__i < G__12189__a.length) {G__12189__a[G__12189__i] = arguments[G__12189__i + 3]; ++G__12189__i;}
  fs = new cljs.core.IndexedSeq(G__12189__a,0);
} 
return G__12182__delegate.call(this,f,g,h,fs);};
G__12182.cljs$lang$maxFixedArity = 3;
G__12182.cljs$lang$applyTo = (function (arglist__12190){
var f = cljs.core.first(arglist__12190);
arglist__12190 = cljs.core.next(arglist__12190);
var g = cljs.core.first(arglist__12190);
arglist__12190 = cljs.core.next(arglist__12190);
var h = cljs.core.first(arglist__12190);
var fs = cljs.core.rest(arglist__12190);
return G__12182__delegate(f,g,h,fs);
});
G__12182.cljs$core$IFn$_invoke$arity$variadic = G__12182__delegate;
return G__12182;
})()
;
juxt = function(f,g,h,var_args){
var fs = var_args;
switch(arguments.length){
case 1:
return juxt__1.call(this,f);
case 2:
return juxt__2.call(this,f,g);
case 3:
return juxt__3.call(this,f,g,h);
default:
var G__12191 = null;
if (arguments.length > 3) {
var G__12192__i = 0, G__12192__a = new Array(arguments.length -  3);
while (G__12192__i < G__12192__a.length) {G__12192__a[G__12192__i] = arguments[G__12192__i + 3]; ++G__12192__i;}
G__12191 = new cljs.core.IndexedSeq(G__12192__a,0);
}
return juxt__4.cljs$core$IFn$_invoke$arity$variadic(f,g,h, G__12191);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
juxt.cljs$lang$maxFixedArity = 3;
juxt.cljs$lang$applyTo = juxt__4.cljs$lang$applyTo;
juxt.cljs$core$IFn$_invoke$arity$1 = juxt__1;
juxt.cljs$core$IFn$_invoke$arity$2 = juxt__2;
juxt.cljs$core$IFn$_invoke$arity$3 = juxt__3;
juxt.cljs$core$IFn$_invoke$arity$variadic = juxt__4.cljs$core$IFn$_invoke$arity$variadic;
return juxt;
})()
;
/**
* When lazy sequences are produced via functions that have side
* effects, any effects other than those needed to produce the first
* element in the seq do not occur until the seq is consumed. dorun can
* be used to force any effects. Walks through the successive nexts of
* the seq, does not retain the head and returns nil.
*/
cljs.core.dorun = (function() {
var dorun = null;
var dorun__1 = (function (coll){
while(true){
if(cljs.core.seq(coll)){
var G__12193 = cljs.core.next(coll);
coll = G__12193;
continue;
} else {
return null;
}
break;
}
});
var dorun__2 = (function (n,coll){
while(true){
if((cljs.core.seq(coll)) && ((n > (0)))){
var G__12194 = (n - (1));
var G__12195 = cljs.core.next(coll);
n = G__12194;
coll = G__12195;
continue;
} else {
return null;
}
break;
}
});
dorun = function(n,coll){
switch(arguments.length){
case 1:
return dorun__1.call(this,n);
case 2:
return dorun__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
dorun.cljs$core$IFn$_invoke$arity$1 = dorun__1;
dorun.cljs$core$IFn$_invoke$arity$2 = dorun__2;
return dorun;
})()
;
/**
* When lazy sequences are produced via functions that have side
* effects, any effects other than those needed to produce the first
* element in the seq do not occur until the seq is consumed. doall can
* be used to force any effects. Walks through the successive nexts of
* the seq, retains the head and returns it, thus causing the entire
* seq to reside in memory at one time.
*/
cljs.core.doall = (function() {
var doall = null;
var doall__1 = (function (coll){
cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(coll);

return coll;
});
var doall__2 = (function (n,coll){
cljs.core.dorun.cljs$core$IFn$_invoke$arity$2(n,coll);

return coll;
});
doall = function(n,coll){
switch(arguments.length){
case 1:
return doall__1.call(this,n);
case 2:
return doall__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
doall.cljs$core$IFn$_invoke$arity$1 = doall__1;
doall.cljs$core$IFn$_invoke$arity$2 = doall__2;
return doall;
})()
;
cljs.core.regexp_QMARK_ = (function regexp_QMARK_(o){
return (o instanceof RegExp);
});
/**
* Returns the result of (re-find re s) if re fully matches s.
*/
cljs.core.re_matches = (function re_matches(re,s){
if(typeof s === 'string'){
var matches = re.exec(s);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(matches),s)){
if((cljs.core.count(matches) === (1))){
return cljs.core.first(matches);
} else {
return cljs.core.vec(matches);
}
} else {
return null;
}
} else {
throw (new TypeError("re-matches must match against a string."));
}
});
/**
* Returns the first regex match, if any, of s to re, using
* re.exec(s). Returns a vector, containing first the matching
* substring, then any capturing groups if the regular expression contains
* capturing groups.
*/
cljs.core.re_find = (function re_find(re,s){
if(typeof s === 'string'){
var matches = re.exec(s);
if((matches == null)){
return null;
} else {
if((cljs.core.count(matches) === (1))){
return cljs.core.first(matches);
} else {
return cljs.core.vec(matches);
}
}
} else {
throw (new TypeError("re-find must match against a string."));
}
});
/**
* Returns a lazy sequence of successive matches of re in s.
*/
cljs.core.re_seq = (function re_seq(re,s){
var match_data = cljs.core.re_find(re,s);
var match_idx = s.search(re);
var match_str = ((cljs.core.coll_QMARK_(match_data))?cljs.core.first(match_data):match_data);
var post_match = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,(match_idx + cljs.core.count(match_str)));
if(cljs.core.truth_(match_data)){
return (new cljs.core.LazySeq(null,((function (match_data,match_idx,match_str,post_match){
return (function (){
return cljs.core.cons(match_data,((cljs.core.seq(post_match))?re_seq(re,post_match):null));
});})(match_data,match_idx,match_str,post_match))
,null,null));
} else {
return null;
}
});
/**
* Returns an instance of RegExp which has compiled the provided string.
*/
cljs.core.re_pattern = (function re_pattern(s){
if((s instanceof RegExp)){
return s;
} else {
var vec__12199 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,s);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12199,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12199,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12199,(2),null);
return (new RegExp(pattern,flags));
}
});
cljs.core.pr_sequential_writer = (function pr_sequential_writer(writer,print_one,begin,sep,end,opts,coll){
var _STAR_print_level_STAR_12207 = cljs.core._STAR_print_level_STAR_;
try{cljs.core._STAR_print_level_STAR_ = (((cljs.core._STAR_print_level_STAR_ == null))?null:(cljs.core._STAR_print_level_STAR_ - (1)));

if((!((cljs.core._STAR_print_level_STAR_ == null))) && ((cljs.core._STAR_print_level_STAR_ < (0)))){
return cljs.core._write(writer,"#");
} else {
cljs.core._write(writer,begin);

if(cljs.core.seq(coll)){
var G__12208_12214 = cljs.core.first(coll);
var G__12209_12215 = writer;
var G__12210_12216 = opts;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__12208_12214,G__12209_12215,G__12210_12216) : print_one.call(null,G__12208_12214,G__12209_12215,G__12210_12216));
} else {
}

var coll_12217__$1 = cljs.core.next(coll);
var n_12218 = (new cljs.core.Keyword(null,"print-length","print-length",1931866356).cljs$core$IFn$_invoke$arity$1(opts) - (1));
while(true){
if((coll_12217__$1) && (((n_12218 == null)) || (!((n_12218 === (0)))))){
cljs.core._write(writer,sep);

var G__12211_12219 = cljs.core.first(coll_12217__$1);
var G__12212_12220 = writer;
var G__12213_12221 = opts;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__12211_12219,G__12212_12220,G__12213_12221) : print_one.call(null,G__12211_12219,G__12212_12220,G__12213_12221));

var G__12222 = cljs.core.next(coll_12217__$1);
var G__12223 = (n_12218 - (1));
coll_12217__$1 = G__12222;
n_12218 = G__12223;
continue;
} else {
if((cljs.core.seq(coll_12217__$1)) && ((n_12218 === (0)))){
cljs.core._write(writer,sep);

cljs.core._write(writer,"...");
} else {
}
}
break;
}

return cljs.core._write(writer,end);
}
}finally {cljs.core._STAR_print_level_STAR_ = _STAR_print_level_STAR_12207;
}});
/**
* @param {...*} var_args
*/
cljs.core.write_all = (function() { 
var write_all__delegate = function (writer,ss){
var seq__12228 = cljs.core.seq(ss);
var chunk__12229 = null;
var count__12230 = (0);
var i__12231 = (0);
while(true){
if((i__12231 < count__12230)){
var s = chunk__12229.cljs$core$IIndexed$_nth$arity$2(null,i__12231);
cljs.core._write(writer,s);

var G__12232 = seq__12228;
var G__12233 = chunk__12229;
var G__12234 = count__12230;
var G__12235 = (i__12231 + (1));
seq__12228 = G__12232;
chunk__12229 = G__12233;
count__12230 = G__12234;
i__12231 = G__12235;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__12228);
if(temp__4126__auto__){
var seq__12228__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12228__$1)){
var c__4545__auto__ = cljs.core.chunk_first(seq__12228__$1);
var G__12236 = cljs.core.chunk_rest(seq__12228__$1);
var G__12237 = c__4545__auto__;
var G__12238 = cljs.core.count(c__4545__auto__);
var G__12239 = (0);
seq__12228 = G__12236;
chunk__12229 = G__12237;
count__12230 = G__12238;
i__12231 = G__12239;
continue;
} else {
var s = cljs.core.first(seq__12228__$1);
cljs.core._write(writer,s);

var G__12240 = cljs.core.next(seq__12228__$1);
var G__12241 = null;
var G__12242 = (0);
var G__12243 = (0);
seq__12228 = G__12240;
chunk__12229 = G__12241;
count__12230 = G__12242;
i__12231 = G__12243;
continue;
}
} else {
return null;
}
}
break;
}
};
var write_all = function (writer,var_args){
var ss = null;
if (arguments.length > 1) {
var G__12244__i = 0, G__12244__a = new Array(arguments.length -  1);
while (G__12244__i < G__12244__a.length) {G__12244__a[G__12244__i] = arguments[G__12244__i + 1]; ++G__12244__i;}
  ss = new cljs.core.IndexedSeq(G__12244__a,0);
} 
return write_all__delegate.call(this,writer,ss);};
write_all.cljs$lang$maxFixedArity = 1;
write_all.cljs$lang$applyTo = (function (arglist__12245){
var writer = cljs.core.first(arglist__12245);
var ss = cljs.core.rest(arglist__12245);
return write_all__delegate(writer,ss);
});
write_all.cljs$core$IFn$_invoke$arity$variadic = write_all__delegate;
return write_all;
})()
;
cljs.core.string_print = (function string_print(x){
(cljs.core._STAR_print_fn_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.core._STAR_print_fn_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.core._STAR_print_fn_STAR_.call(null,x));

return null;
});
cljs.core.flush = (function flush(){
return null;
});
cljs.core.char_escapes = (function (){var obj12247 = {"\"":"\\\"","\\":"\\\\","\b":"\\b","\f":"\\f","\n":"\\n","\r":"\\r","\t":"\\t"};
return obj12247;
})();
cljs.core.quote_string = (function quote_string(s){
return [cljs.core.str("\""),cljs.core.str(s.replace((function (){var G__12250 = "[\\\\\"\b\f\n\r\t]";
var G__12251 = "g";
return RegExp(G__12250,G__12251);
})(),(function (match){
return (cljs.core.char_escapes[match]);
}))),cljs.core.str("\"")].join('');
});
/**
* Prefer this to pr-seq, because it makes the printing function
* configurable, allowing efficient implementations such as appending
* to a StringBuffer.
*/
cljs.core.pr_writer = (function pr_writer(obj,writer,opts){
if((obj == null)){
return cljs.core._write(writer,"nil");
} else {
if((void 0 === obj)){
return cljs.core._write(writer,"#<undefined>");
} else {
if(cljs.core.truth_((function (){var and__3746__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.core.truth_(and__3746__auto__)){
var and__3746__auto____$1 = (function (){var G__12265 = obj;
if(G__12265){
var bit__4439__auto__ = (G__12265.cljs$lang$protocol_mask$partition0$ & (131072));
if((bit__4439__auto__) || (G__12265.cljs$core$IMeta$)){
return true;
} else {
if((!G__12265.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__12265);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__12265);
}
})();
if(and__3746__auto____$1){
return cljs.core.meta(obj);
} else {
return and__3746__auto____$1;
}
} else {
return and__3746__auto__;
}
})())){
cljs.core._write(writer,"^");

pr_writer(cljs.core.meta(obj),writer,opts);

cljs.core._write(writer," ");
} else {
}

if((obj == null)){
return cljs.core._write(writer,"nil");
} else {
if(obj.cljs$lang$type){
return obj.cljs$lang$ctorPrWriter(obj,writer,opts);
} else {
if((function (){var G__12266 = obj;
if(G__12266){
var bit__4432__auto__ = (G__12266.cljs$lang$protocol_mask$partition0$ & (2147483648));
if((bit__4432__auto__) || (G__12266.cljs$core$IPrintWithWriter$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,opts);
} else {
if(((cljs.core.type(obj) === Boolean)) || (typeof obj === 'number')){
return cljs.core._write(writer,[cljs.core.str(obj)].join(''));
} else {
if(cljs.core.object_QMARK_(obj)){
cljs.core._write(writer,"#js ");

var G__12267 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (k){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k),(obj[k])], null);
}),cljs.core.js_keys(obj));
var G__12268 = pr_writer;
var G__12269 = writer;
var G__12270 = opts;
return (cljs.core.print_map.cljs$core$IFn$_invoke$arity$4 ? cljs.core.print_map.cljs$core$IFn$_invoke$arity$4(G__12267,G__12268,G__12269,G__12270) : cljs.core.print_map.call(null,G__12267,G__12268,G__12269,G__12270));
} else {
if(obj instanceof Array){
return cljs.core.pr_sequential_writer(writer,pr_writer,"#js ["," ","]",opts,obj);
} else {
if(cljs.core.truth_((function (){var G__12271 = obj;
return goog.isString(G__12271);
})())){
if(cljs.core.truth_(new cljs.core.Keyword(null,"readably","readably",1129599760).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core._write(writer,cljs.core.quote_string(obj));
} else {
return cljs.core._write(writer,obj);
}
} else {
if(cljs.core.fn_QMARK_(obj)){
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#<",[cljs.core.str(obj)].join(''),">"], 0));
} else {
if((obj instanceof Date)){
var normalize = (function (n,len){
var ns = [cljs.core.str(n)].join('');
while(true){
if((cljs.core.count(ns) < len)){
var G__12273 = [cljs.core.str("0"),cljs.core.str(ns)].join('');
ns = G__12273;
continue;
} else {
return ns;
}
break;
}
});
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#inst \"",[cljs.core.str(obj.getUTCFullYear())].join(''),"-",normalize((obj.getUTCMonth() + (1)),(2)),"-",normalize(obj.getUTCDate(),(2)),"T",normalize(obj.getUTCHours(),(2)),":",normalize(obj.getUTCMinutes(),(2)),":",normalize(obj.getUTCSeconds(),(2)),".",normalize(obj.getUTCMilliseconds(),(3)),"-","00:00\""], 0));
} else {
if(cljs.core.regexp_QMARK_(obj)){
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#\"",obj.source,"\""], 0));
} else {
if((function (){var G__12272 = obj;
if(G__12272){
var bit__4439__auto__ = (G__12272.cljs$lang$protocol_mask$partition0$ & (2147483648));
if((bit__4439__auto__) || (G__12272.cljs$core$IPrintWithWriter$)){
return true;
} else {
if((!G__12272.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IPrintWithWriter,G__12272);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IPrintWithWriter,G__12272);
}
})()){
return cljs.core._pr_writer(obj,writer,opts);
} else {
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#<",[cljs.core.str(obj)].join(''),">"], 0));

}
}
}
}
}
}
}
}
}
}
}

}
}
});
cljs.core.pr_seq_writer = (function pr_seq_writer(objs,writer,opts){
cljs.core.pr_writer(cljs.core.first(objs),writer,opts);

var seq__12278 = cljs.core.seq(cljs.core.next(objs));
var chunk__12279 = null;
var count__12280 = (0);
var i__12281 = (0);
while(true){
if((i__12281 < count__12280)){
var obj = chunk__12279.cljs$core$IIndexed$_nth$arity$2(null,i__12281);
cljs.core._write(writer," ");

cljs.core.pr_writer(obj,writer,opts);

var G__12282 = seq__12278;
var G__12283 = chunk__12279;
var G__12284 = count__12280;
var G__12285 = (i__12281 + (1));
seq__12278 = G__12282;
chunk__12279 = G__12283;
count__12280 = G__12284;
i__12281 = G__12285;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__12278);
if(temp__4126__auto__){
var seq__12278__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12278__$1)){
var c__4545__auto__ = cljs.core.chunk_first(seq__12278__$1);
var G__12286 = cljs.core.chunk_rest(seq__12278__$1);
var G__12287 = c__4545__auto__;
var G__12288 = cljs.core.count(c__4545__auto__);
var G__12289 = (0);
seq__12278 = G__12286;
chunk__12279 = G__12287;
count__12280 = G__12288;
i__12281 = G__12289;
continue;
} else {
var obj = cljs.core.first(seq__12278__$1);
cljs.core._write(writer," ");

cljs.core.pr_writer(obj,writer,opts);

var G__12290 = cljs.core.next(seq__12278__$1);
var G__12291 = null;
var G__12292 = (0);
var G__12293 = (0);
seq__12278 = G__12290;
chunk__12279 = G__12291;
count__12280 = G__12292;
i__12281 = G__12293;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.core.pr_sb_with_opts = (function pr_sb_with_opts(objs,opts){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
cljs.core.pr_seq_writer(objs,writer,opts);

writer.cljs$core$IWriter$_flush$arity$1(null);

return sb;
});
/**
* Prints a sequence of objects to a string, observing all the
* options given in opts
*/
cljs.core.pr_str_with_opts = (function pr_str_with_opts(objs,opts){
if(cljs.core.empty_QMARK_(objs)){
return "";
} else {
return [cljs.core.str(cljs.core.pr_sb_with_opts(objs,opts))].join('');
}
});
/**
* Same as pr-str-with-opts followed by (newline)
*/
cljs.core.prn_str_with_opts = (function prn_str_with_opts(objs,opts){
if(cljs.core.empty_QMARK_(objs)){
return "\n";
} else {
var sb = cljs.core.pr_sb_with_opts(objs,opts);
sb.append("\n");

return [cljs.core.str(sb)].join('');
}
});
/**
* Prints a sequence of objects using string-print, observing all
* the options given in opts
*/
cljs.core.pr_with_opts = (function pr_with_opts(objs,opts){
return cljs.core.string_print(cljs.core.pr_str_with_opts(objs,opts));
});
cljs.core.newline = (function newline(opts){
cljs.core.string_print("\n");

if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.Keyword(null,"flush-on-newline","flush-on-newline",-151457939)))){
return cljs.core.flush();
} else {
return null;
}
});
/**
* pr to a string, returning it. Fundamental entrypoint to IPrintWithWriter.
* @param {...*} var_args
*/
cljs.core.pr_str = (function() { 
var pr_str__delegate = function (objs){
return cljs.core.pr_str_with_opts(objs,cljs.core.pr_opts());
};
var pr_str = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__12294__i = 0, G__12294__a = new Array(arguments.length -  0);
while (G__12294__i < G__12294__a.length) {G__12294__a[G__12294__i] = arguments[G__12294__i + 0]; ++G__12294__i;}
  objs = new cljs.core.IndexedSeq(G__12294__a,0);
} 
return pr_str__delegate.call(this,objs);};
pr_str.cljs$lang$maxFixedArity = 0;
pr_str.cljs$lang$applyTo = (function (arglist__12295){
var objs = cljs.core.seq(arglist__12295);
return pr_str__delegate(objs);
});
pr_str.cljs$core$IFn$_invoke$arity$variadic = pr_str__delegate;
return pr_str;
})()
;
/**
* Same as pr-str followed by (newline)
* @param {...*} var_args
*/
cljs.core.prn_str = (function() { 
var prn_str__delegate = function (objs){
return cljs.core.prn_str_with_opts(objs,cljs.core.pr_opts());
};
var prn_str = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__12296__i = 0, G__12296__a = new Array(arguments.length -  0);
while (G__12296__i < G__12296__a.length) {G__12296__a[G__12296__i] = arguments[G__12296__i + 0]; ++G__12296__i;}
  objs = new cljs.core.IndexedSeq(G__12296__a,0);
} 
return prn_str__delegate.call(this,objs);};
prn_str.cljs$lang$maxFixedArity = 0;
prn_str.cljs$lang$applyTo = (function (arglist__12297){
var objs = cljs.core.seq(arglist__12297);
return prn_str__delegate(objs);
});
prn_str.cljs$core$IFn$_invoke$arity$variadic = prn_str__delegate;
return prn_str;
})()
;
/**
* Prints the object(s) using string-print.  Prints the
* object(s), separated by spaces if there is more than one.
* By default, pr and prn print in a way that objects can be
* read by the reader
* @param {...*} var_args
*/
cljs.core.pr = (function() { 
var pr__delegate = function (objs){
return cljs.core.pr_with_opts(objs,cljs.core.pr_opts());
};
var pr = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__12298__i = 0, G__12298__a = new Array(arguments.length -  0);
while (G__12298__i < G__12298__a.length) {G__12298__a[G__12298__i] = arguments[G__12298__i + 0]; ++G__12298__i;}
  objs = new cljs.core.IndexedSeq(G__12298__a,0);
} 
return pr__delegate.call(this,objs);};
pr.cljs$lang$maxFixedArity = 0;
pr.cljs$lang$applyTo = (function (arglist__12299){
var objs = cljs.core.seq(arglist__12299);
return pr__delegate(objs);
});
pr.cljs$core$IFn$_invoke$arity$variadic = pr__delegate;
return pr;
})()
;
/**
* Prints the object(s) using string-print.
* print and println produce output for human consumption.
* @param {...*} var_args
*/
cljs.core.print = (function() { 
var cljs_core_print__delegate = function (objs){
return cljs.core.pr_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));
};
var cljs_core_print = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__12300__i = 0, G__12300__a = new Array(arguments.length -  0);
while (G__12300__i < G__12300__a.length) {G__12300__a[G__12300__i] = arguments[G__12300__i + 0]; ++G__12300__i;}
  objs = new cljs.core.IndexedSeq(G__12300__a,0);
} 
return cljs_core_print__delegate.call(this,objs);};
cljs_core_print.cljs$lang$maxFixedArity = 0;
cljs_core_print.cljs$lang$applyTo = (function (arglist__12301){
var objs = cljs.core.seq(arglist__12301);
return cljs_core_print__delegate(objs);
});
cljs_core_print.cljs$core$IFn$_invoke$arity$variadic = cljs_core_print__delegate;
return cljs_core_print;
})()
;
/**
* print to a string, returning it
* @param {...*} var_args
*/
cljs.core.print_str = (function() { 
var print_str__delegate = function (objs){
return cljs.core.pr_str_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));
};
var print_str = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__12302__i = 0, G__12302__a = new Array(arguments.length -  0);
while (G__12302__i < G__12302__a.length) {G__12302__a[G__12302__i] = arguments[G__12302__i + 0]; ++G__12302__i;}
  objs = new cljs.core.IndexedSeq(G__12302__a,0);
} 
return print_str__delegate.call(this,objs);};
print_str.cljs$lang$maxFixedArity = 0;
print_str.cljs$lang$applyTo = (function (arglist__12303){
var objs = cljs.core.seq(arglist__12303);
return print_str__delegate(objs);
});
print_str.cljs$core$IFn$_invoke$arity$variadic = print_str__delegate;
return print_str;
})()
;
/**
* Same as print followed by (newline)
* @param {...*} var_args
*/
cljs.core.println = (function() { 
var println__delegate = function (objs){
cljs.core.pr_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));

if(cljs.core.truth_(cljs.core._STAR_print_newline_STAR_)){
return cljs.core.newline(cljs.core.pr_opts());
} else {
return null;
}
};
var println = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__12304__i = 0, G__12304__a = new Array(arguments.length -  0);
while (G__12304__i < G__12304__a.length) {G__12304__a[G__12304__i] = arguments[G__12304__i + 0]; ++G__12304__i;}
  objs = new cljs.core.IndexedSeq(G__12304__a,0);
} 
return println__delegate.call(this,objs);};
println.cljs$lang$maxFixedArity = 0;
println.cljs$lang$applyTo = (function (arglist__12305){
var objs = cljs.core.seq(arglist__12305);
return println__delegate(objs);
});
println.cljs$core$IFn$_invoke$arity$variadic = println__delegate;
return println;
})()
;
/**
* println to a string, returning it
* @param {...*} var_args
*/
cljs.core.println_str = (function() { 
var println_str__delegate = function (objs){
return cljs.core.prn_str_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));
};
var println_str = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__12306__i = 0, G__12306__a = new Array(arguments.length -  0);
while (G__12306__i < G__12306__a.length) {G__12306__a[G__12306__i] = arguments[G__12306__i + 0]; ++G__12306__i;}
  objs = new cljs.core.IndexedSeq(G__12306__a,0);
} 
return println_str__delegate.call(this,objs);};
println_str.cljs$lang$maxFixedArity = 0;
println_str.cljs$lang$applyTo = (function (arglist__12307){
var objs = cljs.core.seq(arglist__12307);
return println_str__delegate(objs);
});
println_str.cljs$core$IFn$_invoke$arity$variadic = println_str__delegate;
return println_str;
})()
;
/**
* Same as pr followed by (newline).
* @param {...*} var_args
*/
cljs.core.prn = (function() { 
var prn__delegate = function (objs){
cljs.core.pr_with_opts(objs,cljs.core.pr_opts());

if(cljs.core.truth_(cljs.core._STAR_print_newline_STAR_)){
return cljs.core.newline(cljs.core.pr_opts());
} else {
return null;
}
};
var prn = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__12308__i = 0, G__12308__a = new Array(arguments.length -  0);
while (G__12308__i < G__12308__a.length) {G__12308__a[G__12308__i] = arguments[G__12308__i + 0]; ++G__12308__i;}
  objs = new cljs.core.IndexedSeq(G__12308__a,0);
} 
return prn__delegate.call(this,objs);};
prn.cljs$lang$maxFixedArity = 0;
prn.cljs$lang$applyTo = (function (arglist__12309){
var objs = cljs.core.seq(arglist__12309);
return prn__delegate(objs);
});
prn.cljs$core$IFn$_invoke$arity$variadic = prn__delegate;
return prn;
})()
;
cljs.core.print_map = (function print_map(m,print_one,writer,opts){
return cljs.core.pr_sequential_writer(writer,(function (e,w,opts__$1){
var G__12316_12322 = cljs.core.key(e);
var G__12317_12323 = w;
var G__12318_12324 = opts__$1;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__12316_12322,G__12317_12323,G__12318_12324) : print_one.call(null,G__12316_12322,G__12317_12323,G__12318_12324));

cljs.core._write(w," ");

var G__12319 = cljs.core.val(e);
var G__12320 = w;
var G__12321 = opts__$1;
return (print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__12319,G__12320,G__12321) : print_one.call(null,G__12319,G__12320,G__12321));
}),"{",", ","}",opts,cljs.core.seq(m));
});
cljs.core.Volatile.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Volatile.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (a,writer,opts){
var a__$1 = this;
cljs.core._write(writer,"#<Volatile: ");

cljs.core.pr_writer(a__$1.state,writer,opts);

return cljs.core._write(writer,">");
});

cljs.core.Var.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Var.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (a,writer,opts){
var a__$1 = this;
cljs.core._write(writer,"#'");

return cljs.core.pr_writer(a__$1.sym,writer,opts);
});

cljs.core.IndexedSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.IndexedSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.LazySeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.NodeSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.BlackNode.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.BlackNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ES6IteratorSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#{"," ","}",opts,coll__$1);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ChunkedSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.ObjMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ObjMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.Cons.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Cons.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.RSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.RSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentHashMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.Subvec.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Subvec.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentHashSet.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#{"," ","}",opts,coll__$1);
});

cljs.core.ChunkedCons.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ChunkedCons.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.Atom.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Atom.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (a,writer,opts){
var a__$1 = this;
cljs.core._write(writer,"#<Atom: ");

cljs.core.pr_writer(a__$1.state,writer,opts);

return cljs.core._write(writer,">");
});

cljs.core.ValSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ValSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.RedNode.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.RedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentVector.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentVector.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentQueueSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.EmptyList.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core._write(writer,"()");
});

cljs.core.LazyTransformer.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.LazyTransformer.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentQueue.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentQueue.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#queue ["," ","]",opts,cljs.core.seq(coll__$1));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.Range.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Range.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.KeySeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.List.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.List.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});
cljs.core.PersistentVector.prototype.cljs$core$IComparable$ = true;

cljs.core.PersistentVector.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2(x__$1,y);
});

cljs.core.Subvec.prototype.cljs$core$IComparable$ = true;

cljs.core.Subvec.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2(x__$1,y);
});

cljs.core.Keyword.prototype.cljs$core$IComparable$ = true;

cljs.core.Keyword.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.compare_keywords(x__$1,y);
});

cljs.core.Symbol.prototype.cljs$core$IComparable$ = true;

cljs.core.Symbol.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.compare_symbols(x__$1,y);
});
/**
* Atomically sets the metadata for a namespace/var/ref/agent/atom to be:
* 
* (apply f its-current-meta args)
* 
* f must be free of side-effects
* @param {...*} var_args
*/
cljs.core.alter_meta_BANG_ = (function() { 
var alter_meta_BANG___delegate = function (iref,f,args){
return iref.meta = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,iref.meta,args);
};
var alter_meta_BANG_ = function (iref,f,var_args){
var args = null;
if (arguments.length > 2) {
var G__12325__i = 0, G__12325__a = new Array(arguments.length -  2);
while (G__12325__i < G__12325__a.length) {G__12325__a[G__12325__i] = arguments[G__12325__i + 2]; ++G__12325__i;}
  args = new cljs.core.IndexedSeq(G__12325__a,0);
} 
return alter_meta_BANG___delegate.call(this,iref,f,args);};
alter_meta_BANG_.cljs$lang$maxFixedArity = 2;
alter_meta_BANG_.cljs$lang$applyTo = (function (arglist__12326){
var iref = cljs.core.first(arglist__12326);
arglist__12326 = cljs.core.next(arglist__12326);
var f = cljs.core.first(arglist__12326);
var args = cljs.core.rest(arglist__12326);
return alter_meta_BANG___delegate(iref,f,args);
});
alter_meta_BANG_.cljs$core$IFn$_invoke$arity$variadic = alter_meta_BANG___delegate;
return alter_meta_BANG_;
})()
;
/**
* Atomically resets the metadata for an atom
*/
cljs.core.reset_meta_BANG_ = (function reset_meta_BANG_(iref,m){
return iref.meta = m;
});
/**
* Alpha - subject to change.
* 
* Adds a watch function to an atom reference. The watch fn must be a
* fn of 4 args: a key, the reference, its old-state, its
* new-state. Whenever the reference's state might have been changed,
* any registered watches will have their functions called. The watch
* fn will be called synchronously. Note that an atom's state
* may have changed again prior to the fn call, so use old/new-state
* rather than derefing the reference. Keys must be unique per
* reference, and can be used to remove the watch with remove-watch,
* but are otherwise considered opaque by the watch mechanism.  Bear in
* mind that regardless of the result or action of the watch fns the
* atom's value will change.  Example:
* 
* (def a (atom 0))
* (add-watch a :inc (fn [k r o n] (assert (== 0 n))))
* (swap! a inc)
* ;; Assertion Error
* (deref a)
* ;=> 1
*/
cljs.core.add_watch = (function add_watch(iref,key,f){
cljs.core._add_watch(iref,key,f);

return iref;
});
/**
* Alpha - subject to change.
* 
* Removes a watch (set by add-watch) from a reference
*/
cljs.core.remove_watch = (function remove_watch(iref,key){
cljs.core._remove_watch(iref,key);

return iref;
});
cljs.core.gensym_counter = null;
/**
* Returns a new symbol with a unique name. If a prefix string is
* supplied, the name is prefix# where # is some unique number. If
* prefix is not supplied, the prefix is 'G__'.
*/
cljs.core.gensym = (function() {
var gensym = null;
var gensym__0 = (function (){
return gensym.cljs$core$IFn$_invoke$arity$1("G__");
});
var gensym__1 = (function (prefix_string){
if((cljs.core.gensym_counter == null)){
cljs.core.gensym_counter = (function (){var G__12329 = (0);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__12329) : cljs.core.atom.call(null,G__12329));
})();
} else {
}

return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str(prefix_string),cljs.core.str(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.gensym_counter,cljs.core.inc))].join(''));
});
gensym = function(prefix_string){
switch(arguments.length){
case 0:
return gensym__0.call(this);
case 1:
return gensym__1.call(this,prefix_string);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
gensym.cljs$core$IFn$_invoke$arity$0 = gensym__0;
gensym.cljs$core$IFn$_invoke$arity$1 = gensym__1;
return gensym;
})()
;
cljs.core.fixture1 = (1);
cljs.core.fixture2 = (2);

/**
* @constructor
*/
cljs.core.Delay = (function (f,value){
this.f = f;
this.value = value;
this.cljs$lang$protocol_mask$partition1$ = 1;
this.cljs$lang$protocol_mask$partition0$ = 32768;
})
cljs.core.Delay.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (d){
var self__ = this;
var d__$1 = this;
return cljs.core.not(self__.f);
});

cljs.core.Delay.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.f)){
self__.value = (function (){return (self__.f.cljs$core$IFn$_invoke$arity$0 ? self__.f.cljs$core$IFn$_invoke$arity$0() : self__.f.call(null));
})();

self__.f = null;
} else {
}

return self__.value;
});

cljs.core.Delay.cljs$lang$type = true;

cljs.core.Delay.cljs$lang$ctorStr = "cljs.core/Delay";

cljs.core.Delay.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/Delay");
});

cljs.core.__GT_Delay = (function __GT_Delay(f,value){
return (new cljs.core.Delay(f,value));
});

/**
* returns true if x is a Delay created with delay
*/
cljs.core.delay_QMARK_ = (function delay_QMARK_(x){
return (x instanceof cljs.core.Delay);
});
/**
* If x is a Delay, returns the (possibly cached) value of its expression, else returns x
*/
cljs.core.force = (function force(x){
if(cljs.core.delay_QMARK_(x)){
var G__12331 = x;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12331) : cljs.core.deref.call(null,G__12331));
} else {
return x;
}
});
/**
* Returns true if a value has been produced for a promise, delay, future or lazy sequence.
*/
cljs.core.realized_QMARK_ = (function realized_QMARK_(d){
return cljs.core._realized_QMARK_(d);
});
cljs.core.preserving_reduced = (function preserving_reduced(rf){
return (function (p1__12332_SHARP_,p2__12333_SHARP_){
var ret = (function (){var G__12336 = p1__12332_SHARP_;
var G__12337 = p2__12333_SHARP_;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__12336,G__12337) : rf.call(null,G__12336,G__12337));
})();
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.reduced(ret);
} else {
return ret;
}
});
});
/**
* A transducer which concatenates the contents of each input, which must be a
* collection, into the reduction.
*/
cljs.core.cat = (function cat(rf){
var rf1 = cljs.core.preserving_reduced(rf);
return ((function (rf1){
return (function() {
var G__12340 = null;
var G__12340__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__12340__1 = (function (result){
var G__12339 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__12339) : rf.call(null,G__12339));
});
var G__12340__2 = (function (result,input){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(rf1,result,input);
});
G__12340 = function(result,input){
switch(arguments.length){
case 0:
return G__12340__0.call(this);
case 1:
return G__12340__1.call(this,result);
case 2:
return G__12340__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12340.cljs$core$IFn$_invoke$arity$0 = G__12340__0;
G__12340.cljs$core$IFn$_invoke$arity$1 = G__12340__1;
G__12340.cljs$core$IFn$_invoke$arity$2 = G__12340__2;
return G__12340;
})()
;})(rf1))
});
/**
* Returns a lazy sequence removing consecutive duplicates in coll.
* Returns a transducer when no collection is provided.
*/
cljs.core.dedupe = (function() {
var dedupe = null;
var dedupe__0 = (function (){
return (function (rf){
var pa = cljs.core.volatile_BANG_(new cljs.core.Keyword("cljs.core","none","cljs.core/none",926646439));
return ((function (pa){
return (function() {
var G__12349 = null;
var G__12349__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__12349__1 = (function (result){
var G__12345 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__12345) : rf.call(null,G__12345));
});
var G__12349__2 = (function (result,input){
var prior = (function (){var G__12346 = pa;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12346) : cljs.core.deref.call(null,G__12346));
})();
cljs.core.vreset_BANG_(pa,input);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(prior,input)){
return result;
} else {
var G__12347 = result;
var G__12348 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__12347,G__12348) : rf.call(null,G__12347,G__12348));
}
});
G__12349 = function(result,input){
switch(arguments.length){
case 0:
return G__12349__0.call(this);
case 1:
return G__12349__1.call(this,result);
case 2:
return G__12349__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12349.cljs$core$IFn$_invoke$arity$0 = G__12349__0;
G__12349.cljs$core$IFn$_invoke$arity$1 = G__12349__1;
G__12349.cljs$core$IFn$_invoke$arity$2 = G__12349__2;
return G__12349;
})()
;})(pa))
});
});
var dedupe__1 = (function (coll){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(dedupe.cljs$core$IFn$_invoke$arity$0(),coll);
});
dedupe = function(coll){
switch(arguments.length){
case 0:
return dedupe__0.call(this);
case 1:
return dedupe__1.call(this,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
dedupe.cljs$core$IFn$_invoke$arity$0 = dedupe__0;
dedupe.cljs$core$IFn$_invoke$arity$1 = dedupe__1;
return dedupe;
})()
;
/**
* Returns items from coll with random probability of prob (0.0 -
* 1.0).  Returns a transducer when no collection is provided.
*/
cljs.core.random_sample = (function() {
var random_sample = null;
var random_sample__1 = (function (prob){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (_){
return ((function (){return (cljs.core.rand.cljs$core$IFn$_invoke$arity$0 ? cljs.core.rand.cljs$core$IFn$_invoke$arity$0() : cljs.core.rand.call(null));
})() < prob);
}));
});
var random_sample__2 = (function (prob,coll){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (_){
return ((function (){return (cljs.core.rand.cljs$core$IFn$_invoke$arity$0 ? cljs.core.rand.cljs$core$IFn$_invoke$arity$0() : cljs.core.rand.call(null));
})() < prob);
}),coll);
});
random_sample = function(prob,coll){
switch(arguments.length){
case 1:
return random_sample__1.call(this,prob);
case 2:
return random_sample__2.call(this,prob,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
random_sample.cljs$core$IFn$_invoke$arity$1 = random_sample__1;
random_sample.cljs$core$IFn$_invoke$arity$2 = random_sample__2;
return random_sample;
})()
;

/**
* @constructor
*/
cljs.core.Eduction = (function (xform,coll){
this.xform = xform;
this.coll = coll;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 2173173760;
})
cljs.core.Eduction.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll__$1,writer,opts){
var self__ = this;
var coll__$2 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$2);
});

cljs.core.Eduction.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (_,f,init){
var self__ = this;
var ___$1 = this;
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(self__.xform,f,init,self__.coll);
});

cljs.core.Eduction.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.seq(cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(self__.xform,self__.coll));
});

cljs.core.Eduction.cljs$lang$type = true;

cljs.core.Eduction.cljs$lang$ctorStr = "cljs.core/Eduction";

cljs.core.Eduction.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/Eduction");
});

cljs.core.__GT_Eduction = (function __GT_Eduction(xform,coll){
return (new cljs.core.Eduction(xform,coll));
});

(cljs.core.Eduction.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
/**
* Returns a reducible/iterable/seqable application of
* the transducer to the items in coll. Note that these applications
* will be performed every time iterator/seq/reduce is called.
*/
cljs.core.eduction = (function eduction(xform,coll){
return (new cljs.core.Eduction(xform,coll));
});
/**
* Runs the supplied procedure (via reduce), for purposes of side
* effects, on successive items in the collection. Returns nil
*/
cljs.core.run_BANG_ = (function run_BANG_(proc,coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__12351_SHARP_,p2__12350_SHARP_){
var G__12353 = p2__12350_SHARP_;
return (proc.cljs$core$IFn$_invoke$arity$1 ? proc.cljs$core$IFn$_invoke$arity$1(G__12353) : proc.call(null,G__12353));
}),null,coll);
});

cljs.core.IEncodeJS = (function (){var obj12355 = {};
return obj12355;
})();

cljs.core._clj__GT_js = (function _clj__GT_js(x){
if((function (){var and__3746__auto__ = x;
if(and__3746__auto__){
return x.cljs$core$IEncodeJS$_clj__GT_js$arity$1;
} else {
return and__3746__auto__;
}
})()){
return x.cljs$core$IEncodeJS$_clj__GT_js$arity$1(x);
} else {
var x__4402__auto__ = (((x == null))?null:x);
return (function (){var or__3758__auto__ = (cljs.core._clj__GT_js[(function (){var G__12359 = x__4402__auto__;
return goog.typeOf(G__12359);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._clj__GT_js["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IEncodeJS.-clj->js",x);
}
}
})().call(null,x);
}
});

cljs.core._key__GT_js = (function _key__GT_js(x){
if((function (){var and__3746__auto__ = x;
if(and__3746__auto__){
return x.cljs$core$IEncodeJS$_key__GT_js$arity$1;
} else {
return and__3746__auto__;
}
})()){
return x.cljs$core$IEncodeJS$_key__GT_js$arity$1(x);
} else {
var x__4402__auto__ = (((x == null))?null:x);
return (function (){var or__3758__auto__ = (cljs.core._key__GT_js[(function (){var G__12363 = x__4402__auto__;
return goog.typeOf(G__12363);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._key__GT_js["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IEncodeJS.-key->js",x);
}
}
})().call(null,x);
}
});

cljs.core.key__GT_js = (function key__GT_js(k){
if((function (){var G__12366 = k;
if(G__12366){
var bit__4439__auto__ = null;
if(cljs.core.truth_((function (){var or__3758__auto__ = bit__4439__auto__;
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return G__12366.cljs$core$IEncodeJS$;
}
})())){
return true;
} else {
if((!G__12366.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__12366);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__12366);
}
})()){
return cljs.core._clj__GT_js(k);
} else {
if((typeof k === 'string') || (typeof k === 'number') || ((k instanceof cljs.core.Keyword)) || ((k instanceof cljs.core.Symbol))){
var G__12367 = k;
return (cljs.core.clj__GT_js.cljs$core$IFn$_invoke$arity$1 ? cljs.core.clj__GT_js.cljs$core$IFn$_invoke$arity$1(G__12367) : cljs.core.clj__GT_js.call(null,G__12367));
} else {
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([k], 0));
}
}
});
/**
* Recursively transforms ClojureScript values to JavaScript.
* sets/vectors/lists become Arrays, Keywords and Symbol become Strings,
* Maps become Objects. Arbitrary keys are encoded to by key->js.
*/
cljs.core.clj__GT_js = (function clj__GT_js(x){
if((x == null)){
return null;
} else {
if((function (){var G__12383 = x;
if(G__12383){
var bit__4439__auto__ = null;
if(cljs.core.truth_((function (){var or__3758__auto__ = bit__4439__auto__;
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return G__12383.cljs$core$IEncodeJS$;
}
})())){
return true;
} else {
if((!G__12383.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__12383);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__12383);
}
})()){
return cljs.core._clj__GT_js(x);
} else {
if((x instanceof cljs.core.Keyword)){
return cljs.core.name(x);
} else {
if((x instanceof cljs.core.Symbol)){
return [cljs.core.str(x)].join('');
} else {
if(cljs.core.map_QMARK_(x)){
var m = (function (){var obj12385 = {};
return obj12385;
})();
var seq__12386_12396 = cljs.core.seq(x);
var chunk__12387_12397 = null;
var count__12388_12398 = (0);
var i__12389_12399 = (0);
while(true){
if((i__12389_12399 < count__12388_12398)){
var vec__12390_12400 = chunk__12387_12397.cljs$core$IIndexed$_nth$arity$2(null,i__12389_12399);
var k_12401 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12390_12400,(0),null);
var v_12402 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12390_12400,(1),null);
(m[cljs.core.key__GT_js(k_12401)] = clj__GT_js(v_12402));

var G__12403 = seq__12386_12396;
var G__12404 = chunk__12387_12397;
var G__12405 = count__12388_12398;
var G__12406 = (i__12389_12399 + (1));
seq__12386_12396 = G__12403;
chunk__12387_12397 = G__12404;
count__12388_12398 = G__12405;
i__12389_12399 = G__12406;
continue;
} else {
var temp__4126__auto___12407 = cljs.core.seq(seq__12386_12396);
if(temp__4126__auto___12407){
var seq__12386_12408__$1 = temp__4126__auto___12407;
if(cljs.core.chunked_seq_QMARK_(seq__12386_12408__$1)){
var c__4545__auto___12409 = cljs.core.chunk_first(seq__12386_12408__$1);
var G__12410 = cljs.core.chunk_rest(seq__12386_12408__$1);
var G__12411 = c__4545__auto___12409;
var G__12412 = cljs.core.count(c__4545__auto___12409);
var G__12413 = (0);
seq__12386_12396 = G__12410;
chunk__12387_12397 = G__12411;
count__12388_12398 = G__12412;
i__12389_12399 = G__12413;
continue;
} else {
var vec__12391_12414 = cljs.core.first(seq__12386_12408__$1);
var k_12415 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12391_12414,(0),null);
var v_12416 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12391_12414,(1),null);
(m[cljs.core.key__GT_js(k_12415)] = clj__GT_js(v_12416));

var G__12417 = cljs.core.next(seq__12386_12408__$1);
var G__12418 = null;
var G__12419 = (0);
var G__12420 = (0);
seq__12386_12396 = G__12417;
chunk__12387_12397 = G__12418;
count__12388_12398 = G__12419;
i__12389_12399 = G__12420;
continue;
}
} else {
}
}
break;
}

return m;
} else {
if(cljs.core.coll_QMARK_(x)){
var arr = [];
var seq__12392_12421 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clj__GT_js,x));
var chunk__12393_12422 = null;
var count__12394_12423 = (0);
var i__12395_12424 = (0);
while(true){
if((i__12395_12424 < count__12394_12423)){
var x_12425__$1 = chunk__12393_12422.cljs$core$IIndexed$_nth$arity$2(null,i__12395_12424);
arr.push(x_12425__$1);

var G__12426 = seq__12392_12421;
var G__12427 = chunk__12393_12422;
var G__12428 = count__12394_12423;
var G__12429 = (i__12395_12424 + (1));
seq__12392_12421 = G__12426;
chunk__12393_12422 = G__12427;
count__12394_12423 = G__12428;
i__12395_12424 = G__12429;
continue;
} else {
var temp__4126__auto___12430 = cljs.core.seq(seq__12392_12421);
if(temp__4126__auto___12430){
var seq__12392_12431__$1 = temp__4126__auto___12430;
if(cljs.core.chunked_seq_QMARK_(seq__12392_12431__$1)){
var c__4545__auto___12432 = cljs.core.chunk_first(seq__12392_12431__$1);
var G__12433 = cljs.core.chunk_rest(seq__12392_12431__$1);
var G__12434 = c__4545__auto___12432;
var G__12435 = cljs.core.count(c__4545__auto___12432);
var G__12436 = (0);
seq__12392_12421 = G__12433;
chunk__12393_12422 = G__12434;
count__12394_12423 = G__12435;
i__12395_12424 = G__12436;
continue;
} else {
var x_12437__$1 = cljs.core.first(seq__12392_12431__$1);
arr.push(x_12437__$1);

var G__12438 = cljs.core.next(seq__12392_12431__$1);
var G__12439 = null;
var G__12440 = (0);
var G__12441 = (0);
seq__12392_12421 = G__12438;
chunk__12393_12422 = G__12439;
count__12394_12423 = G__12440;
i__12395_12424 = G__12441;
continue;
}
} else {
}
}
break;
}

return arr;
} else {
return x;

}
}
}
}
}
}
});

cljs.core.IEncodeClojure = (function (){var obj12443 = {};
return obj12443;
})();

cljs.core._js__GT_clj = (function _js__GT_clj(x,options){
if((function (){var and__3746__auto__ = x;
if(and__3746__auto__){
return x.cljs$core$IEncodeClojure$_js__GT_clj$arity$2;
} else {
return and__3746__auto__;
}
})()){
return x.cljs$core$IEncodeClojure$_js__GT_clj$arity$2(x,options);
} else {
var x__4402__auto__ = (((x == null))?null:x);
return (function (){var or__3758__auto__ = (cljs.core._js__GT_clj[(function (){var G__12447 = x__4402__auto__;
return goog.typeOf(G__12447);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._js__GT_clj["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IEncodeClojure.-js->clj",x);
}
}
})().call(null,x,options);
}
});

/**
* Recursively transforms JavaScript arrays into ClojureScript
* vectors, and JavaScript objects into ClojureScript maps.  With
* option ':keywordize-keys true' will convert object fields from
* strings to keywords.
* @param {...*} var_args
*/
cljs.core.js__GT_clj = (function() {
var js__GT_clj = null;
var js__GT_clj__1 = (function (x){
return js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),false], null)], 0));
});
var js__GT_clj__2 = (function() { 
var G__12504__delegate = function (x,opts){
var map__12477 = opts;
var map__12477__$1 = ((cljs.core.seq_QMARK_(map__12477))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12477):map__12477);
var keywordize_keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12477__$1,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252));
var keyfn = (cljs.core.truth_(keywordize_keys)?cljs.core.keyword:cljs.core.str);
var f = ((function (map__12477,map__12477__$1,keywordize_keys,keyfn){
return (function thisfn(x__$1){
if((function (){var G__12493 = x__$1;
if(G__12493){
var bit__4439__auto__ = null;
if(cljs.core.truth_((function (){var or__3758__auto__ = bit__4439__auto__;
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return G__12493.cljs$core$IEncodeClojure$;
}
})())){
return true;
} else {
if((!G__12493.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeClojure,G__12493);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeClojure,G__12493);
}
})()){
return cljs.core._js__GT_clj(x__$1,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.array_map,opts));
} else {
if(cljs.core.seq_QMARK_(x__$1)){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(thisfn,x__$1));
} else {
if(cljs.core.coll_QMARK_(x__$1)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.empty(x__$1),cljs.core.map.cljs$core$IFn$_invoke$arity$2(thisfn,x__$1));
} else {
if(x__$1 instanceof Array){
return cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2(thisfn,x__$1));
} else {
if((cljs.core.type(x__$1) === Object)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4514__auto__ = ((function (map__12477,map__12477__$1,keywordize_keys,keyfn){
return (function iter__12494(s__12495){
return (new cljs.core.LazySeq(null,((function (map__12477,map__12477__$1,keywordize_keys,keyfn){
return (function (){
var s__12495__$1 = s__12495;
while(true){
var temp__4126__auto__ = cljs.core.seq(s__12495__$1);
if(temp__4126__auto__){
var s__12495__$2 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s__12495__$2)){
var c__4512__auto__ = cljs.core.chunk_first(s__12495__$2);
var size__4513__auto__ = cljs.core.count(c__4512__auto__);
var b__12497 = cljs.core.chunk_buffer(size__4513__auto__);
if((function (){var i__12496 = (0);
while(true){
if((i__12496 < size__4513__auto__)){
var k = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4512__auto__,i__12496);
cljs.core.chunk_append(b__12497,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__12502 = k;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__12502) : keyfn.call(null,G__12502));
})(),thisfn((x__$1[k]))], null));

var G__12505 = (i__12496 + (1));
i__12496 = G__12505;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__12497),iter__12494(cljs.core.chunk_rest(s__12495__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__12497),null);
}
} else {
var k = cljs.core.first(s__12495__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__12503 = k;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__12503) : keyfn.call(null,G__12503));
})(),thisfn((x__$1[k]))], null),iter__12494(cljs.core.rest(s__12495__$2)));
}
} else {
return null;
}
break;
}
});})(map__12477,map__12477__$1,keywordize_keys,keyfn))
,null,null));
});})(map__12477,map__12477__$1,keywordize_keys,keyfn))
;
return iter__4514__auto__(cljs.core.js_keys(x__$1));
})());
} else {
return x__$1;

}
}
}
}
}
});})(map__12477,map__12477__$1,keywordize_keys,keyfn))
;
return f(x);
};
var G__12504 = function (x,var_args){
var opts = null;
if (arguments.length > 1) {
var G__12506__i = 0, G__12506__a = new Array(arguments.length -  1);
while (G__12506__i < G__12506__a.length) {G__12506__a[G__12506__i] = arguments[G__12506__i + 1]; ++G__12506__i;}
  opts = new cljs.core.IndexedSeq(G__12506__a,0);
} 
return G__12504__delegate.call(this,x,opts);};
G__12504.cljs$lang$maxFixedArity = 1;
G__12504.cljs$lang$applyTo = (function (arglist__12507){
var x = cljs.core.first(arglist__12507);
var opts = cljs.core.rest(arglist__12507);
return G__12504__delegate(x,opts);
});
G__12504.cljs$core$IFn$_invoke$arity$variadic = G__12504__delegate;
return G__12504;
})()
;
js__GT_clj = function(x,var_args){
var opts = var_args;
switch(arguments.length){
case 1:
return js__GT_clj__1.call(this,x);
default:
var G__12508 = null;
if (arguments.length > 1) {
var G__12509__i = 0, G__12509__a = new Array(arguments.length -  1);
while (G__12509__i < G__12509__a.length) {G__12509__a[G__12509__i] = arguments[G__12509__i + 1]; ++G__12509__i;}
G__12508 = new cljs.core.IndexedSeq(G__12509__a,0);
}
return js__GT_clj__2.cljs$core$IFn$_invoke$arity$variadic(x, G__12508);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
js__GT_clj.cljs$lang$maxFixedArity = 1;
js__GT_clj.cljs$lang$applyTo = js__GT_clj__2.cljs$lang$applyTo;
js__GT_clj.cljs$core$IFn$_invoke$arity$1 = js__GT_clj__1;
js__GT_clj.cljs$core$IFn$_invoke$arity$variadic = js__GT_clj__2.cljs$core$IFn$_invoke$arity$variadic;
return js__GT_clj;
})()
;
/**
* Returns a memoized version of a referentially transparent function. The
* memoized version of the function keeps a cache of the mapping from arguments
* to results and, when calls with the same arguments are repeated often, has
* higher performance at the expense of higher memory use.
*/
cljs.core.memoize = (function memoize(f){
var mem = (function (){var G__12512 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__12512) : cljs.core.atom.call(null,G__12512));
})();
return ((function (mem){
return (function() { 
var G__12514__delegate = function (args){
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$3((function (){var G__12513 = mem;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12513) : cljs.core.deref.call(null,G__12513));
})(),args,cljs.core.lookup_sentinel);
if((v === cljs.core.lookup_sentinel)){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(mem,cljs.core.assoc,args,ret);

return ret;
} else {
return v;
}
};
var G__12514 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__12515__i = 0, G__12515__a = new Array(arguments.length -  0);
while (G__12515__i < G__12515__a.length) {G__12515__a[G__12515__i] = arguments[G__12515__i + 0]; ++G__12515__i;}
  args = new cljs.core.IndexedSeq(G__12515__a,0);
} 
return G__12514__delegate.call(this,args);};
G__12514.cljs$lang$maxFixedArity = 0;
G__12514.cljs$lang$applyTo = (function (arglist__12516){
var args = cljs.core.seq(arglist__12516);
return G__12514__delegate(args);
});
G__12514.cljs$core$IFn$_invoke$arity$variadic = G__12514__delegate;
return G__12514;
})()
;
;})(mem))
});
/**
* trampoline can be used to convert algorithms requiring mutual
* recursion without stack consumption. Calls f with supplied args, if
* any. If f returns a fn, calls that fn with no arguments, and
* continues to repeat, until the return value is not a fn, then
* returns that non-fn value. Note that if you want to return a fn as a
* final value, you must wrap it in some data structure and unpack it
* after trampoline returns.
* @param {...*} var_args
*/
cljs.core.trampoline = (function() {
var trampoline = null;
var trampoline__1 = (function (f){
while(true){
var ret = (function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})();
if(cljs.core.fn_QMARK_(ret)){
var G__12518 = ret;
f = G__12518;
continue;
} else {
return ret;
}
break;
}
});
var trampoline__2 = (function() { 
var G__12519__delegate = function (f,args){
return trampoline.cljs$core$IFn$_invoke$arity$1((function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
}));
};
var G__12519 = function (f,var_args){
var args = null;
if (arguments.length > 1) {
var G__12520__i = 0, G__12520__a = new Array(arguments.length -  1);
while (G__12520__i < G__12520__a.length) {G__12520__a[G__12520__i] = arguments[G__12520__i + 1]; ++G__12520__i;}
  args = new cljs.core.IndexedSeq(G__12520__a,0);
} 
return G__12519__delegate.call(this,f,args);};
G__12519.cljs$lang$maxFixedArity = 1;
G__12519.cljs$lang$applyTo = (function (arglist__12521){
var f = cljs.core.first(arglist__12521);
var args = cljs.core.rest(arglist__12521);
return G__12519__delegate(f,args);
});
G__12519.cljs$core$IFn$_invoke$arity$variadic = G__12519__delegate;
return G__12519;
})()
;
trampoline = function(f,var_args){
var args = var_args;
switch(arguments.length){
case 1:
return trampoline__1.call(this,f);
default:
var G__12522 = null;
if (arguments.length > 1) {
var G__12523__i = 0, G__12523__a = new Array(arguments.length -  1);
while (G__12523__i < G__12523__a.length) {G__12523__a[G__12523__i] = arguments[G__12523__i + 1]; ++G__12523__i;}
G__12522 = new cljs.core.IndexedSeq(G__12523__a,0);
}
return trampoline__2.cljs$core$IFn$_invoke$arity$variadic(f, G__12522);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
trampoline.cljs$lang$maxFixedArity = 1;
trampoline.cljs$lang$applyTo = trampoline__2.cljs$lang$applyTo;
trampoline.cljs$core$IFn$_invoke$arity$1 = trampoline__1;
trampoline.cljs$core$IFn$_invoke$arity$variadic = trampoline__2.cljs$core$IFn$_invoke$arity$variadic;
return trampoline;
})()
;
/**
* Returns a random floating point number between 0 (inclusive) and
* n (default 1) (exclusive).
*/
cljs.core.rand = (function() {
var rand = null;
var rand__0 = (function (){
return rand.cljs$core$IFn$_invoke$arity$1((1));
});
var rand__1 = (function (n){
return ((function (){return (Math.random.cljs$core$IFn$_invoke$arity$0 ? Math.random.cljs$core$IFn$_invoke$arity$0() : Math.random.call(null));
})() * n);
});
rand = function(n){
switch(arguments.length){
case 0:
return rand__0.call(this);
case 1:
return rand__1.call(this,n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
rand.cljs$core$IFn$_invoke$arity$0 = rand__0;
rand.cljs$core$IFn$_invoke$arity$1 = rand__1;
return rand;
})()
;
/**
* Returns a random integer between 0 (inclusive) and n (exclusive).
*/
cljs.core.rand_int = (function rand_int(n){
var G__12526 = ((function (){return (Math.random.cljs$core$IFn$_invoke$arity$0 ? Math.random.cljs$core$IFn$_invoke$arity$0() : Math.random.call(null));
})() * n);
return (Math.floor.cljs$core$IFn$_invoke$arity$1 ? Math.floor.cljs$core$IFn$_invoke$arity$1(G__12526) : Math.floor.call(null,G__12526));
});
/**
* Return a random element of the (sequential) collection. Will have
* the same performance characteristics as nth for the given
* collection.
*/
cljs.core.rand_nth = (function rand_nth(coll){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,cljs.core.rand_int(cljs.core.count(coll)));
});
/**
* Returns a map of the elements of coll keyed by the result of
* f on each element. The value at each key will be a vector of the
* corresponding elements, in the order they appeared in coll.
*/
cljs.core.group_by = (function group_by(f,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret,x){
var k = (function (){var G__12528 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__12528) : f.call(null,G__12528));
})();
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(ret,k,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(ret,k,cljs.core.PersistentVector.EMPTY),x));
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),coll));
});
/**
* Creates a hierarchy object for use with derive, isa? etc.
*/
cljs.core.make_hierarchy = (function make_hierarchy(){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"parents","parents",-2027538891),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"descendants","descendants",1824886031),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"ancestors","ancestors",-776045424),cljs.core.PersistentArrayMap.EMPTY], null);
});
cljs.core._global_hierarchy = null;
cljs.core.get_global_hierarchy = (function get_global_hierarchy(){
if((cljs.core._global_hierarchy == null)){
cljs.core._global_hierarchy = (function (){var G__12530 = cljs.core.make_hierarchy();
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__12530) : cljs.core.atom.call(null,G__12530));
})();
} else {
}

return cljs.core._global_hierarchy;
});
/**
* @param {...*} var_args
*/
cljs.core.swap_global_hierarchy_BANG_ = (function() { 
var swap_global_hierarchy_BANG___delegate = function (f,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.swap_BANG_,cljs.core.get_global_hierarchy(),f,args);
};
var swap_global_hierarchy_BANG_ = function (f,var_args){
var args = null;
if (arguments.length > 1) {
var G__12531__i = 0, G__12531__a = new Array(arguments.length -  1);
while (G__12531__i < G__12531__a.length) {G__12531__a[G__12531__i] = arguments[G__12531__i + 1]; ++G__12531__i;}
  args = new cljs.core.IndexedSeq(G__12531__a,0);
} 
return swap_global_hierarchy_BANG___delegate.call(this,f,args);};
swap_global_hierarchy_BANG_.cljs$lang$maxFixedArity = 1;
swap_global_hierarchy_BANG_.cljs$lang$applyTo = (function (arglist__12532){
var f = cljs.core.first(arglist__12532);
var args = cljs.core.rest(arglist__12532);
return swap_global_hierarchy_BANG___delegate(f,args);
});
swap_global_hierarchy_BANG_.cljs$core$IFn$_invoke$arity$variadic = swap_global_hierarchy_BANG___delegate;
return swap_global_hierarchy_BANG_;
})()
;
/**
* Returns true if (= child parent), or child is directly or indirectly derived from
* parent, either via a JavaScript type inheritance relationship or a
* relationship established via derive. h must be a hierarchy obtained
* from make-hierarchy, if not supplied defaults to the global
* hierarchy
*/
cljs.core.isa_QMARK_ = (function() {
var isa_QMARK_ = null;
var isa_QMARK___2 = (function (child,parent){
return isa_QMARK_.cljs$core$IFn$_invoke$arity$3((function (){var G__12597 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12597) : cljs.core.deref.call(null,G__12597));
})(),child,parent);
});
var isa_QMARK___3 = (function (h,child,parent){
var or__3758__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(child,parent);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"ancestors","ancestors",-776045424).cljs$core$IFn$_invoke$arity$1(h).call(null,child),parent);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
var and__3746__auto__ = cljs.core.vector_QMARK_(parent);
if(and__3746__auto__){
var and__3746__auto____$1 = cljs.core.vector_QMARK_(child);
if(and__3746__auto____$1){
var and__3746__auto____$2 = (cljs.core.count(parent) === cljs.core.count(child));
if(and__3746__auto____$2){
var ret = true;
var i = (0);
while(true){
if((!(ret)) || ((i === cljs.core.count(parent)))){
return ret;
} else {
var G__12622 = isa_QMARK_.cljs$core$IFn$_invoke$arity$3(h,(function (){var G__12620 = i;
return (child.cljs$core$IFn$_invoke$arity$1 ? child.cljs$core$IFn$_invoke$arity$1(G__12620) : child.call(null,G__12620));
})(),(function (){var G__12621 = i;
return (parent.cljs$core$IFn$_invoke$arity$1 ? parent.cljs$core$IFn$_invoke$arity$1(G__12621) : parent.call(null,G__12621));
})());
var G__12623 = (i + (1));
ret = G__12622;
i = G__12623;
continue;
}
break;
}
} else {
return and__3746__auto____$2;
}
} else {
return and__3746__auto____$1;
}
} else {
return and__3746__auto__;
}
}
}
});
isa_QMARK_ = function(h,child,parent){
switch(arguments.length){
case 2:
return isa_QMARK___2.call(this,h,child);
case 3:
return isa_QMARK___3.call(this,h,child,parent);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
isa_QMARK_.cljs$core$IFn$_invoke$arity$2 = isa_QMARK___2;
isa_QMARK_.cljs$core$IFn$_invoke$arity$3 = isa_QMARK___3;
return isa_QMARK_;
})()
;
/**
* Returns the immediate parents of tag, either via a JavaScript type
* inheritance relationship or a relationship established via derive. h
* must be a hierarchy obtained from make-hierarchy, if not supplied
* defaults to the global hierarchy
*/
cljs.core.parents = (function() {
var parents = null;
var parents__1 = (function (tag){
return parents.cljs$core$IFn$_invoke$arity$2((function (){var G__12627 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12627) : cljs.core.deref.call(null,G__12627));
})(),tag);
});
var parents__2 = (function (h,tag){
return cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(h),tag));
});
parents = function(h,tag){
switch(arguments.length){
case 1:
return parents__1.call(this,h);
case 2:
return parents__2.call(this,h,tag);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
parents.cljs$core$IFn$_invoke$arity$1 = parents__1;
parents.cljs$core$IFn$_invoke$arity$2 = parents__2;
return parents;
})()
;
/**
* Returns the immediate and indirect parents of tag, either via a JavaScript type
* inheritance relationship or a relationship established via derive. h
* must be a hierarchy obtained from make-hierarchy, if not supplied
* defaults to the global hierarchy
*/
cljs.core.ancestors = (function() {
var ancestors = null;
var ancestors__1 = (function (tag){
return ancestors.cljs$core$IFn$_invoke$arity$2((function (){var G__12631 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12631) : cljs.core.deref.call(null,G__12631));
})(),tag);
});
var ancestors__2 = (function (h,tag){
return cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ancestors","ancestors",-776045424).cljs$core$IFn$_invoke$arity$1(h),tag));
});
ancestors = function(h,tag){
switch(arguments.length){
case 1:
return ancestors__1.call(this,h);
case 2:
return ancestors__2.call(this,h,tag);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
ancestors.cljs$core$IFn$_invoke$arity$1 = ancestors__1;
ancestors.cljs$core$IFn$_invoke$arity$2 = ancestors__2;
return ancestors;
})()
;
/**
* Returns the immediate and indirect children of tag, through a
* relationship established via derive. h must be a hierarchy obtained
* from make-hierarchy, if not supplied defaults to the global
* hierarchy. Note: does not work on JavaScript type inheritance
* relationships.
*/
cljs.core.descendants = (function() {
var descendants = null;
var descendants__1 = (function (tag){
return descendants.cljs$core$IFn$_invoke$arity$2((function (){var G__12635 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12635) : cljs.core.deref.call(null,G__12635));
})(),tag);
});
var descendants__2 = (function (h,tag){
return cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"descendants","descendants",1824886031).cljs$core$IFn$_invoke$arity$1(h),tag));
});
descendants = function(h,tag){
switch(arguments.length){
case 1:
return descendants__1.call(this,h);
case 2:
return descendants__2.call(this,h,tag);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
descendants.cljs$core$IFn$_invoke$arity$1 = descendants__1;
descendants.cljs$core$IFn$_invoke$arity$2 = descendants__2;
return descendants;
})()
;
/**
* Establishes a parent/child relationship between parent and
* tag. Parent must be a namespace-qualified symbol or keyword and
* child can be either a namespace-qualified symbol or keyword or a
* class. h must be a hierarchy obtained from make-hierarchy, if not
* supplied defaults to, and modifies, the global hierarchy.
*/
cljs.core.derive = (function() {
var derive = null;
var derive__2 = (function (tag,parent){
if(cljs.core.truth_(cljs.core.namespace(parent))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"namespace","namespace",1263021155,null),new cljs.core.Symbol(null,"parent","parent",761652748,null))], 0)))].join('')));
}

cljs.core.swap_global_hierarchy_BANG_.cljs$core$IFn$_invoke$arity$variadic(derive,cljs.core.array_seq([tag,parent], 0));

return null;
});
var derive__3 = (function (h,tag,parent){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(tag,parent)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"not=","not=",1466536204,null),new cljs.core.Symbol(null,"tag","tag",350170304,null),new cljs.core.Symbol(null,"parent","parent",761652748,null))], 0)))].join('')));
}

var tp = new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(h);
var td = new cljs.core.Keyword(null,"descendants","descendants",1824886031).cljs$core$IFn$_invoke$arity$1(h);
var ta = new cljs.core.Keyword(null,"ancestors","ancestors",-776045424).cljs$core$IFn$_invoke$arity$1(h);
var tf = ((function (tp,td,ta){
return (function (m,source,sources,target,targets){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (tp,td,ta){
return (function (ret,k){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret,k,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.get.cljs$core$IFn$_invoke$arity$3(targets,k,cljs.core.PersistentHashSet.EMPTY),cljs.core.cons(target,(function (){var G__12644 = target;
return (targets.cljs$core$IFn$_invoke$arity$1 ? targets.cljs$core$IFn$_invoke$arity$1(G__12644) : targets.call(null,G__12644));
})())));
});})(tp,td,ta))
,m,cljs.core.cons(source,(function (){var G__12645 = source;
return (sources.cljs$core$IFn$_invoke$arity$1 ? sources.cljs$core$IFn$_invoke$arity$1(G__12645) : sources.call(null,G__12645));
})()));
});})(tp,td,ta))
;
var or__3758__auto__ = ((cljs.core.contains_QMARK_((function (){var G__12649 = tag;
return (tp.cljs$core$IFn$_invoke$arity$1 ? tp.cljs$core$IFn$_invoke$arity$1(G__12649) : tp.call(null,G__12649));
})(),parent))?null:(function (){
if(cljs.core.contains_QMARK_((function (){var G__12650 = tag;
return (ta.cljs$core$IFn$_invoke$arity$1 ? ta.cljs$core$IFn$_invoke$arity$1(G__12650) : ta.call(null,G__12650));
})(),parent)){
throw (new Error([cljs.core.str(tag),cljs.core.str("already has"),cljs.core.str(parent),cljs.core.str("as ancestor")].join('')));
} else {
}

if(cljs.core.contains_QMARK_((function (){var G__12651 = parent;
return (ta.cljs$core$IFn$_invoke$arity$1 ? ta.cljs$core$IFn$_invoke$arity$1(G__12651) : ta.call(null,G__12651));
})(),tag)){
throw (new Error([cljs.core.str("Cyclic derivation:"),cljs.core.str(parent),cljs.core.str("has"),cljs.core.str(tag),cljs.core.str("as ancestor")].join('')));
} else {
}

return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"parents","parents",-2027538891),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(h),tag,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(tp,tag,cljs.core.PersistentHashSet.EMPTY),parent)),new cljs.core.Keyword(null,"ancestors","ancestors",-776045424),tf(new cljs.core.Keyword(null,"ancestors","ancestors",-776045424).cljs$core$IFn$_invoke$arity$1(h),tag,td,parent,ta),new cljs.core.Keyword(null,"descendants","descendants",1824886031),tf(new cljs.core.Keyword(null,"descendants","descendants",1824886031).cljs$core$IFn$_invoke$arity$1(h),parent,ta,tag,td)], null);
})()
);
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return h;
}
});
derive = function(h,tag,parent){
switch(arguments.length){
case 2:
return derive__2.call(this,h,tag);
case 3:
return derive__3.call(this,h,tag,parent);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
derive.cljs$core$IFn$_invoke$arity$2 = derive__2;
derive.cljs$core$IFn$_invoke$arity$3 = derive__3;
return derive;
})()
;
/**
* Removes a parent/child relationship between parent and
* tag. h must be a hierarchy obtained from make-hierarchy, if not
* supplied defaults to, and modifies, the global hierarchy.
*/
cljs.core.underive = (function() {
var underive = null;
var underive__2 = (function (tag,parent){
cljs.core.swap_global_hierarchy_BANG_.cljs$core$IFn$_invoke$arity$variadic(underive,cljs.core.array_seq([tag,parent], 0));

return null;
});
var underive__3 = (function (h,tag,parent){
var parentMap = new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(h);
var childsParents = (cljs.core.truth_((function (){var G__12658 = tag;
return (parentMap.cljs$core$IFn$_invoke$arity$1 ? parentMap.cljs$core$IFn$_invoke$arity$1(G__12658) : parentMap.call(null,G__12658));
})())?cljs.core.disj.cljs$core$IFn$_invoke$arity$2((function (){var G__12659 = tag;
return (parentMap.cljs$core$IFn$_invoke$arity$1 ? parentMap.cljs$core$IFn$_invoke$arity$1(G__12659) : parentMap.call(null,G__12659));
})(),parent):cljs.core.PersistentHashSet.EMPTY);
var newParents = (cljs.core.truth_(cljs.core.not_empty(childsParents))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(parentMap,tag,childsParents):cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(parentMap,tag));
var deriv_seq = cljs.core.flatten(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (parentMap,childsParents,newParents){
return (function (p1__12652_SHARP_){
return cljs.core.cons(cljs.core.first(p1__12652_SHARP_),cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(cljs.core.first(p1__12652_SHARP_),cljs.core.second(p1__12652_SHARP_)));
});})(parentMap,childsParents,newParents))
,cljs.core.seq(newParents)));
if(cljs.core.contains_QMARK_((function (){var G__12660 = tag;
return (parentMap.cljs$core$IFn$_invoke$arity$1 ? parentMap.cljs$core$IFn$_invoke$arity$1(G__12660) : parentMap.call(null,G__12660));
})(),parent)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (parentMap,childsParents,newParents,deriv_seq){
return (function (p1__12653_SHARP_,p2__12654_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.derive,p1__12653_SHARP_,p2__12654_SHARP_);
});})(parentMap,childsParents,newParents,deriv_seq))
,cljs.core.make_hierarchy(),cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),deriv_seq));
} else {
return h;
}
});
underive = function(h,tag,parent){
switch(arguments.length){
case 2:
return underive__2.call(this,h,tag);
case 3:
return underive__3.call(this,h,tag,parent);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
underive.cljs$core$IFn$_invoke$arity$2 = underive__2;
underive.cljs$core$IFn$_invoke$arity$3 = underive__3;
return underive;
})()
;
cljs.core.reset_cache = (function reset_cache(method_cache,method_table,cached_hierarchy,hierarchy){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(method_cache,(function (_){
var G__12663 = method_table;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12663) : cljs.core.deref.call(null,G__12663));
}));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cached_hierarchy,(function (_){
var G__12664 = hierarchy;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12664) : cljs.core.deref.call(null,G__12664));
}));
});
cljs.core.prefers_STAR_ = (function prefers_STAR_(x,y,prefer_table){
var xprefs = (function (){var G__12680 = prefer_table;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12680) : cljs.core.deref.call(null,G__12680));
})().call(null,x);
var or__3758__auto__ = (cljs.core.truth_((function (){var and__3746__auto__ = xprefs;
if(cljs.core.truth_(and__3746__auto__)){
var G__12682 = y;
return (xprefs.cljs$core$IFn$_invoke$arity$1 ? xprefs.cljs$core$IFn$_invoke$arity$1(G__12682) : xprefs.call(null,G__12682));
} else {
return and__3746__auto__;
}
})())?true:null);
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (function (){var ps = cljs.core.parents.cljs$core$IFn$_invoke$arity$1(y);
while(true){
if((cljs.core.count(ps) > (0))){
if(cljs.core.truth_(prefers_STAR_(x,cljs.core.first(ps),prefer_table))){
} else {
}

var G__12683 = cljs.core.rest(ps);
ps = G__12683;
continue;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(or__3758__auto____$1)){
return or__3758__auto____$1;
} else {
var or__3758__auto____$2 = (function (){var ps = cljs.core.parents.cljs$core$IFn$_invoke$arity$1(x);
while(true){
if((cljs.core.count(ps) > (0))){
if(cljs.core.truth_(prefers_STAR_(cljs.core.first(ps),y,prefer_table))){
} else {
}

var G__12684 = cljs.core.rest(ps);
ps = G__12684;
continue;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(or__3758__auto____$2)){
return or__3758__auto____$2;
} else {
return false;
}
}
}
});
cljs.core.dominates = (function dominates(x,y,prefer_table){
var or__3758__auto__ = cljs.core.prefers_STAR_(x,y,prefer_table);
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return cljs.core.isa_QMARK_.cljs$core$IFn$_invoke$arity$2(x,y);
}
});
cljs.core.find_and_cache_best_method = (function find_and_cache_best_method(name,dispatch_val,hierarchy,method_table,prefer_table,method_cache,cached_hierarchy){
var best_entry = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (be,p__12698){
var vec__12699 = p__12698;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12699,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12699,(1),null);
var e = vec__12699;
if(cljs.core.isa_QMARK_.cljs$core$IFn$_invoke$arity$3((function (){var G__12700 = hierarchy;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12700) : cljs.core.deref.call(null,G__12700));
})(),dispatch_val,k)){
var be2 = (cljs.core.truth_((function (){var or__3758__auto__ = (be == null);
if(or__3758__auto__){
return or__3758__auto__;
} else {
return cljs.core.dominates(k,cljs.core.first(be),prefer_table);
}
})())?e:be);
if(cljs.core.truth_(cljs.core.dominates(cljs.core.first(be2),k,prefer_table))){
} else {
throw (new Error([cljs.core.str("Multiple methods in multimethod '"),cljs.core.str(name),cljs.core.str("' match dispatch value: "),cljs.core.str(dispatch_val),cljs.core.str(" -> "),cljs.core.str(k),cljs.core.str(" and "),cljs.core.str(cljs.core.first(be2)),cljs.core.str(", and neither is preferred")].join('')));
}

return be2;
} else {
return be;
}
}),null,(function (){var G__12701 = method_table;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12701) : cljs.core.deref.call(null,G__12701));
})());
if(cljs.core.truth_(best_entry)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((function (){var G__12702 = cached_hierarchy;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12702) : cljs.core.deref.call(null,G__12702));
})(),(function (){var G__12703 = hierarchy;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12703) : cljs.core.deref.call(null,G__12703));
})())){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(method_cache,cljs.core.assoc,dispatch_val,cljs.core.second(best_entry));

return cljs.core.second(best_entry);
} else {
cljs.core.reset_cache(method_cache,method_table,cached_hierarchy,hierarchy);

return find_and_cache_best_method(name,dispatch_val,hierarchy,method_table,prefer_table,method_cache,cached_hierarchy);
}
} else {
return null;
}
});

cljs.core.IMultiFn = (function (){var obj12705 = {};
return obj12705;
})();

cljs.core._reset = (function _reset(mf){
if((function (){var and__3746__auto__ = mf;
if(and__3746__auto__){
return mf.cljs$core$IMultiFn$_reset$arity$1;
} else {
return and__3746__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_reset$arity$1(mf);
} else {
var x__4402__auto__ = (((mf == null))?null:mf);
return (function (){var or__3758__auto__ = (cljs.core._reset[(function (){var G__12709 = x__4402__auto__;
return goog.typeOf(G__12709);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._reset["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-reset",mf);
}
}
})().call(null,mf);
}
});

cljs.core._add_method = (function _add_method(mf,dispatch_val,method){
if((function (){var and__3746__auto__ = mf;
if(and__3746__auto__){
return mf.cljs$core$IMultiFn$_add_method$arity$3;
} else {
return and__3746__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_add_method$arity$3(mf,dispatch_val,method);
} else {
var x__4402__auto__ = (((mf == null))?null:mf);
return (function (){var or__3758__auto__ = (cljs.core._add_method[(function (){var G__12713 = x__4402__auto__;
return goog.typeOf(G__12713);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._add_method["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-add-method",mf);
}
}
})().call(null,mf,dispatch_val,method);
}
});

cljs.core._remove_method = (function _remove_method(mf,dispatch_val){
if((function (){var and__3746__auto__ = mf;
if(and__3746__auto__){
return mf.cljs$core$IMultiFn$_remove_method$arity$2;
} else {
return and__3746__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_remove_method$arity$2(mf,dispatch_val);
} else {
var x__4402__auto__ = (((mf == null))?null:mf);
return (function (){var or__3758__auto__ = (cljs.core._remove_method[(function (){var G__12717 = x__4402__auto__;
return goog.typeOf(G__12717);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._remove_method["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-remove-method",mf);
}
}
})().call(null,mf,dispatch_val);
}
});

cljs.core._prefer_method = (function _prefer_method(mf,dispatch_val,dispatch_val_y){
if((function (){var and__3746__auto__ = mf;
if(and__3746__auto__){
return mf.cljs$core$IMultiFn$_prefer_method$arity$3;
} else {
return and__3746__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_prefer_method$arity$3(mf,dispatch_val,dispatch_val_y);
} else {
var x__4402__auto__ = (((mf == null))?null:mf);
return (function (){var or__3758__auto__ = (cljs.core._prefer_method[(function (){var G__12721 = x__4402__auto__;
return goog.typeOf(G__12721);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._prefer_method["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-prefer-method",mf);
}
}
})().call(null,mf,dispatch_val,dispatch_val_y);
}
});

cljs.core._get_method = (function _get_method(mf,dispatch_val){
if((function (){var and__3746__auto__ = mf;
if(and__3746__auto__){
return mf.cljs$core$IMultiFn$_get_method$arity$2;
} else {
return and__3746__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_get_method$arity$2(mf,dispatch_val);
} else {
var x__4402__auto__ = (((mf == null))?null:mf);
return (function (){var or__3758__auto__ = (cljs.core._get_method[(function (){var G__12725 = x__4402__auto__;
return goog.typeOf(G__12725);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._get_method["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-get-method",mf);
}
}
})().call(null,mf,dispatch_val);
}
});

cljs.core._methods = (function _methods(mf){
if((function (){var and__3746__auto__ = mf;
if(and__3746__auto__){
return mf.cljs$core$IMultiFn$_methods$arity$1;
} else {
return and__3746__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_methods$arity$1(mf);
} else {
var x__4402__auto__ = (((mf == null))?null:mf);
return (function (){var or__3758__auto__ = (cljs.core._methods[(function (){var G__12729 = x__4402__auto__;
return goog.typeOf(G__12729);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._methods["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-methods",mf);
}
}
})().call(null,mf);
}
});

cljs.core._prefers = (function _prefers(mf){
if((function (){var and__3746__auto__ = mf;
if(and__3746__auto__){
return mf.cljs$core$IMultiFn$_prefers$arity$1;
} else {
return and__3746__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_prefers$arity$1(mf);
} else {
var x__4402__auto__ = (((mf == null))?null:mf);
return (function (){var or__3758__auto__ = (cljs.core._prefers[(function (){var G__12733 = x__4402__auto__;
return goog.typeOf(G__12733);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._prefers["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-prefers",mf);
}
}
})().call(null,mf);
}
});

cljs.core.throw_no_method_error = (function throw_no_method_error(name,dispatch_val){
throw (new Error([cljs.core.str("No method in multimethod '"),cljs.core.str(name),cljs.core.str("' for dispatch value: "),cljs.core.str(dispatch_val)].join('')));
});

/**
* @constructor
*/
cljs.core.MultiFn = (function (name,dispatch_fn,default_dispatch_val,hierarchy,method_table,prefer_table,method_cache,cached_hierarchy){
this.name = name;
this.dispatch_fn = dispatch_fn;
this.default_dispatch_val = default_dispatch_val;
this.hierarchy = hierarchy;
this.method_table = method_table;
this.prefer_table = prefer_table;
this.method_cache = method_cache;
this.cached_hierarchy = cached_hierarchy;
this.cljs$lang$protocol_mask$partition0$ = 4194305;
this.cljs$lang$protocol_mask$partition1$ = 4352;
})
cljs.core.MultiFn.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var G__12735 = this$__$1;
return goog.getUid(G__12735);
});

cljs.core.MultiFn.prototype.cljs$core$INamed$_name$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._name(self__.name);
});

cljs.core.MultiFn.prototype.cljs$core$INamed$_namespace$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._namespace(self__.name);
});

cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_reset$arity$1 = (function (mf){
var self__ = this;
var mf__$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(self__.method_table,((function (mf__$1){
return (function (mf__$2){
return cljs.core.PersistentArrayMap.EMPTY;
});})(mf__$1))
);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(self__.method_cache,((function (mf__$1){
return (function (mf__$2){
return cljs.core.PersistentArrayMap.EMPTY;
});})(mf__$1))
);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(self__.prefer_table,((function (mf__$1){
return (function (mf__$2){
return cljs.core.PersistentArrayMap.EMPTY;
});})(mf__$1))
);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(self__.cached_hierarchy,((function (mf__$1){
return (function (mf__$2){
return null;
});})(mf__$1))
);

return mf__$1;
});

cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_add_method$arity$3 = (function (mf,dispatch_val,method){
var self__ = this;
var mf__$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.method_table,cljs.core.assoc,dispatch_val,method);

cljs.core.reset_cache(self__.method_cache,self__.method_table,self__.cached_hierarchy,self__.hierarchy);

return mf__$1;
});

cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_remove_method$arity$2 = (function (mf,dispatch_val){
var self__ = this;
var mf__$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.method_table,cljs.core.dissoc,dispatch_val);

cljs.core.reset_cache(self__.method_cache,self__.method_table,self__.cached_hierarchy,self__.hierarchy);

return mf__$1;
});

cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_get_method$arity$2 = (function (mf,dispatch_val){
var self__ = this;
var mf__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((function (){var G__12736 = self__.cached_hierarchy;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12736) : cljs.core.deref.call(null,G__12736));
})(),(function (){var G__12737 = self__.hierarchy;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12737) : cljs.core.deref.call(null,G__12737));
})())){
} else {
cljs.core.reset_cache(self__.method_cache,self__.method_table,self__.cached_hierarchy,self__.hierarchy);
}

var temp__4124__auto__ = (function (){var G__12738 = self__.method_cache;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12738) : cljs.core.deref.call(null,G__12738));
})().call(null,dispatch_val);
if(cljs.core.truth_(temp__4124__auto__)){
var target_fn = temp__4124__auto__;
return target_fn;
} else {
var temp__4124__auto____$1 = cljs.core.find_and_cache_best_method(self__.name,dispatch_val,self__.hierarchy,self__.method_table,self__.prefer_table,self__.method_cache,self__.cached_hierarchy);
if(cljs.core.truth_(temp__4124__auto____$1)){
var target_fn = temp__4124__auto____$1;
return target_fn;
} else {
return (function (){var G__12739 = self__.method_table;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12739) : cljs.core.deref.call(null,G__12739));
})().call(null,self__.default_dispatch_val);
}
}
});

cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefer_method$arity$3 = (function (mf,dispatch_val_x,dispatch_val_y){
var self__ = this;
var mf__$1 = this;
if(cljs.core.truth_(cljs.core.prefers_STAR_(dispatch_val_x,dispatch_val_y,self__.prefer_table))){
throw (new Error([cljs.core.str("Preference conflict in multimethod '"),cljs.core.str(self__.name),cljs.core.str("': "),cljs.core.str(dispatch_val_y),cljs.core.str(" is already preferred to "),cljs.core.str(dispatch_val_x)].join('')));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(self__.prefer_table,((function (mf__$1){
return (function (old){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(old,dispatch_val_x,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(old,dispatch_val_x,cljs.core.PersistentHashSet.EMPTY),dispatch_val_y));
});})(mf__$1))
);

return cljs.core.reset_cache(self__.method_cache,self__.method_table,self__.cached_hierarchy,self__.hierarchy);
});

cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_methods$arity$1 = (function (mf){
var self__ = this;
var mf__$1 = this;
var G__12740 = self__.method_table;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12740) : cljs.core.deref.call(null,G__12740));
});

cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefers$arity$1 = (function (mf){
var self__ = this;
var mf__$1 = this;
var G__12741 = self__.prefer_table;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12741) : cljs.core.deref.call(null,G__12741));
});

cljs.core.MultiFn.prototype.call = (function() {
var G__13582 = null;
var G__13582__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$0 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$0() : self__.dispatch_fn.call(null));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

return (target_fn.cljs$core$IFn$_invoke$arity$0 ? target_fn.cljs$core$IFn$_invoke$arity$0() : target_fn.call(null));
});
var G__13582__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12742 = a;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$1 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$1(G__12742) : self__.dispatch_fn.call(null,G__12742));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12743 = a;
return (target_fn.cljs$core$IFn$_invoke$arity$1 ? target_fn.cljs$core$IFn$_invoke$arity$1(G__12743) : target_fn.call(null,G__12743));
});
var G__13582__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12744 = a;
var G__12745 = b;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$2 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$2(G__12744,G__12745) : self__.dispatch_fn.call(null,G__12744,G__12745));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12746 = a;
var G__12747 = b;
return (target_fn.cljs$core$IFn$_invoke$arity$2 ? target_fn.cljs$core$IFn$_invoke$arity$2(G__12746,G__12747) : target_fn.call(null,G__12746,G__12747));
});
var G__13582__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12748 = a;
var G__12749 = b;
var G__12750 = c;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$3 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$3(G__12748,G__12749,G__12750) : self__.dispatch_fn.call(null,G__12748,G__12749,G__12750));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12751 = a;
var G__12752 = b;
var G__12753 = c;
return (target_fn.cljs$core$IFn$_invoke$arity$3 ? target_fn.cljs$core$IFn$_invoke$arity$3(G__12751,G__12752,G__12753) : target_fn.call(null,G__12751,G__12752,G__12753));
});
var G__13582__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12754 = a;
var G__12755 = b;
var G__12756 = c;
var G__12757 = d;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$4 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$4(G__12754,G__12755,G__12756,G__12757) : self__.dispatch_fn.call(null,G__12754,G__12755,G__12756,G__12757));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12758 = a;
var G__12759 = b;
var G__12760 = c;
var G__12761 = d;
return (target_fn.cljs$core$IFn$_invoke$arity$4 ? target_fn.cljs$core$IFn$_invoke$arity$4(G__12758,G__12759,G__12760,G__12761) : target_fn.call(null,G__12758,G__12759,G__12760,G__12761));
});
var G__13582__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12762 = a;
var G__12763 = b;
var G__12764 = c;
var G__12765 = d;
var G__12766 = e;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$5 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$5(G__12762,G__12763,G__12764,G__12765,G__12766) : self__.dispatch_fn.call(null,G__12762,G__12763,G__12764,G__12765,G__12766));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12767 = a;
var G__12768 = b;
var G__12769 = c;
var G__12770 = d;
var G__12771 = e;
return (target_fn.cljs$core$IFn$_invoke$arity$5 ? target_fn.cljs$core$IFn$_invoke$arity$5(G__12767,G__12768,G__12769,G__12770,G__12771) : target_fn.call(null,G__12767,G__12768,G__12769,G__12770,G__12771));
});
var G__13582__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12772 = a;
var G__12773 = b;
var G__12774 = c;
var G__12775 = d;
var G__12776 = e;
var G__12777 = f;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$6 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$6(G__12772,G__12773,G__12774,G__12775,G__12776,G__12777) : self__.dispatch_fn.call(null,G__12772,G__12773,G__12774,G__12775,G__12776,G__12777));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12778 = a;
var G__12779 = b;
var G__12780 = c;
var G__12781 = d;
var G__12782 = e;
var G__12783 = f;
return (target_fn.cljs$core$IFn$_invoke$arity$6 ? target_fn.cljs$core$IFn$_invoke$arity$6(G__12778,G__12779,G__12780,G__12781,G__12782,G__12783) : target_fn.call(null,G__12778,G__12779,G__12780,G__12781,G__12782,G__12783));
});
var G__13582__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12784 = a;
var G__12785 = b;
var G__12786 = c;
var G__12787 = d;
var G__12788 = e;
var G__12789 = f;
var G__12790 = g;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$7 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$7(G__12784,G__12785,G__12786,G__12787,G__12788,G__12789,G__12790) : self__.dispatch_fn.call(null,G__12784,G__12785,G__12786,G__12787,G__12788,G__12789,G__12790));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12791 = a;
var G__12792 = b;
var G__12793 = c;
var G__12794 = d;
var G__12795 = e;
var G__12796 = f;
var G__12797 = g;
return (target_fn.cljs$core$IFn$_invoke$arity$7 ? target_fn.cljs$core$IFn$_invoke$arity$7(G__12791,G__12792,G__12793,G__12794,G__12795,G__12796,G__12797) : target_fn.call(null,G__12791,G__12792,G__12793,G__12794,G__12795,G__12796,G__12797));
});
var G__13582__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12798 = a;
var G__12799 = b;
var G__12800 = c;
var G__12801 = d;
var G__12802 = e;
var G__12803 = f;
var G__12804 = g;
var G__12805 = h;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$8 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$8(G__12798,G__12799,G__12800,G__12801,G__12802,G__12803,G__12804,G__12805) : self__.dispatch_fn.call(null,G__12798,G__12799,G__12800,G__12801,G__12802,G__12803,G__12804,G__12805));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12806 = a;
var G__12807 = b;
var G__12808 = c;
var G__12809 = d;
var G__12810 = e;
var G__12811 = f;
var G__12812 = g;
var G__12813 = h;
return (target_fn.cljs$core$IFn$_invoke$arity$8 ? target_fn.cljs$core$IFn$_invoke$arity$8(G__12806,G__12807,G__12808,G__12809,G__12810,G__12811,G__12812,G__12813) : target_fn.call(null,G__12806,G__12807,G__12808,G__12809,G__12810,G__12811,G__12812,G__12813));
});
var G__13582__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12814 = a;
var G__12815 = b;
var G__12816 = c;
var G__12817 = d;
var G__12818 = e;
var G__12819 = f;
var G__12820 = g;
var G__12821 = h;
var G__12822 = i;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$9 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$9(G__12814,G__12815,G__12816,G__12817,G__12818,G__12819,G__12820,G__12821,G__12822) : self__.dispatch_fn.call(null,G__12814,G__12815,G__12816,G__12817,G__12818,G__12819,G__12820,G__12821,G__12822));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12823 = a;
var G__12824 = b;
var G__12825 = c;
var G__12826 = d;
var G__12827 = e;
var G__12828 = f;
var G__12829 = g;
var G__12830 = h;
var G__12831 = i;
return (target_fn.cljs$core$IFn$_invoke$arity$9 ? target_fn.cljs$core$IFn$_invoke$arity$9(G__12823,G__12824,G__12825,G__12826,G__12827,G__12828,G__12829,G__12830,G__12831) : target_fn.call(null,G__12823,G__12824,G__12825,G__12826,G__12827,G__12828,G__12829,G__12830,G__12831));
});
var G__13582__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12832 = a;
var G__12833 = b;
var G__12834 = c;
var G__12835 = d;
var G__12836 = e;
var G__12837 = f;
var G__12838 = g;
var G__12839 = h;
var G__12840 = i;
var G__12841 = j;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$10 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$10(G__12832,G__12833,G__12834,G__12835,G__12836,G__12837,G__12838,G__12839,G__12840,G__12841) : self__.dispatch_fn.call(null,G__12832,G__12833,G__12834,G__12835,G__12836,G__12837,G__12838,G__12839,G__12840,G__12841));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12842 = a;
var G__12843 = b;
var G__12844 = c;
var G__12845 = d;
var G__12846 = e;
var G__12847 = f;
var G__12848 = g;
var G__12849 = h;
var G__12850 = i;
var G__12851 = j;
return (target_fn.cljs$core$IFn$_invoke$arity$10 ? target_fn.cljs$core$IFn$_invoke$arity$10(G__12842,G__12843,G__12844,G__12845,G__12846,G__12847,G__12848,G__12849,G__12850,G__12851) : target_fn.call(null,G__12842,G__12843,G__12844,G__12845,G__12846,G__12847,G__12848,G__12849,G__12850,G__12851));
});
var G__13582__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12852 = a;
var G__12853 = b;
var G__12854 = c;
var G__12855 = d;
var G__12856 = e;
var G__12857 = f;
var G__12858 = g;
var G__12859 = h;
var G__12860 = i;
var G__12861 = j;
var G__12862 = k;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$11 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$11(G__12852,G__12853,G__12854,G__12855,G__12856,G__12857,G__12858,G__12859,G__12860,G__12861,G__12862) : self__.dispatch_fn.call(null,G__12852,G__12853,G__12854,G__12855,G__12856,G__12857,G__12858,G__12859,G__12860,G__12861,G__12862));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12863 = a;
var G__12864 = b;
var G__12865 = c;
var G__12866 = d;
var G__12867 = e;
var G__12868 = f;
var G__12869 = g;
var G__12870 = h;
var G__12871 = i;
var G__12872 = j;
var G__12873 = k;
return (target_fn.cljs$core$IFn$_invoke$arity$11 ? target_fn.cljs$core$IFn$_invoke$arity$11(G__12863,G__12864,G__12865,G__12866,G__12867,G__12868,G__12869,G__12870,G__12871,G__12872,G__12873) : target_fn.call(null,G__12863,G__12864,G__12865,G__12866,G__12867,G__12868,G__12869,G__12870,G__12871,G__12872,G__12873));
});
var G__13582__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12874 = a;
var G__12875 = b;
var G__12876 = c;
var G__12877 = d;
var G__12878 = e;
var G__12879 = f;
var G__12880 = g;
var G__12881 = h;
var G__12882 = i;
var G__12883 = j;
var G__12884 = k;
var G__12885 = l;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$12 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$12(G__12874,G__12875,G__12876,G__12877,G__12878,G__12879,G__12880,G__12881,G__12882,G__12883,G__12884,G__12885) : self__.dispatch_fn.call(null,G__12874,G__12875,G__12876,G__12877,G__12878,G__12879,G__12880,G__12881,G__12882,G__12883,G__12884,G__12885));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12886 = a;
var G__12887 = b;
var G__12888 = c;
var G__12889 = d;
var G__12890 = e;
var G__12891 = f;
var G__12892 = g;
var G__12893 = h;
var G__12894 = i;
var G__12895 = j;
var G__12896 = k;
var G__12897 = l;
return (target_fn.cljs$core$IFn$_invoke$arity$12 ? target_fn.cljs$core$IFn$_invoke$arity$12(G__12886,G__12887,G__12888,G__12889,G__12890,G__12891,G__12892,G__12893,G__12894,G__12895,G__12896,G__12897) : target_fn.call(null,G__12886,G__12887,G__12888,G__12889,G__12890,G__12891,G__12892,G__12893,G__12894,G__12895,G__12896,G__12897));
});
var G__13582__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12898 = a;
var G__12899 = b;
var G__12900 = c;
var G__12901 = d;
var G__12902 = e;
var G__12903 = f;
var G__12904 = g;
var G__12905 = h;
var G__12906 = i;
var G__12907 = j;
var G__12908 = k;
var G__12909 = l;
var G__12910 = m;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$13 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$13(G__12898,G__12899,G__12900,G__12901,G__12902,G__12903,G__12904,G__12905,G__12906,G__12907,G__12908,G__12909,G__12910) : self__.dispatch_fn.call(null,G__12898,G__12899,G__12900,G__12901,G__12902,G__12903,G__12904,G__12905,G__12906,G__12907,G__12908,G__12909,G__12910));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12911 = a;
var G__12912 = b;
var G__12913 = c;
var G__12914 = d;
var G__12915 = e;
var G__12916 = f;
var G__12917 = g;
var G__12918 = h;
var G__12919 = i;
var G__12920 = j;
var G__12921 = k;
var G__12922 = l;
var G__12923 = m;
return (target_fn.cljs$core$IFn$_invoke$arity$13 ? target_fn.cljs$core$IFn$_invoke$arity$13(G__12911,G__12912,G__12913,G__12914,G__12915,G__12916,G__12917,G__12918,G__12919,G__12920,G__12921,G__12922,G__12923) : target_fn.call(null,G__12911,G__12912,G__12913,G__12914,G__12915,G__12916,G__12917,G__12918,G__12919,G__12920,G__12921,G__12922,G__12923));
});
var G__13582__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12924 = a;
var G__12925 = b;
var G__12926 = c;
var G__12927 = d;
var G__12928 = e;
var G__12929 = f;
var G__12930 = g;
var G__12931 = h;
var G__12932 = i;
var G__12933 = j;
var G__12934 = k;
var G__12935 = l;
var G__12936 = m;
var G__12937 = n;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$14 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$14(G__12924,G__12925,G__12926,G__12927,G__12928,G__12929,G__12930,G__12931,G__12932,G__12933,G__12934,G__12935,G__12936,G__12937) : self__.dispatch_fn.call(null,G__12924,G__12925,G__12926,G__12927,G__12928,G__12929,G__12930,G__12931,G__12932,G__12933,G__12934,G__12935,G__12936,G__12937));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12938 = a;
var G__12939 = b;
var G__12940 = c;
var G__12941 = d;
var G__12942 = e;
var G__12943 = f;
var G__12944 = g;
var G__12945 = h;
var G__12946 = i;
var G__12947 = j;
var G__12948 = k;
var G__12949 = l;
var G__12950 = m;
var G__12951 = n;
return (target_fn.cljs$core$IFn$_invoke$arity$14 ? target_fn.cljs$core$IFn$_invoke$arity$14(G__12938,G__12939,G__12940,G__12941,G__12942,G__12943,G__12944,G__12945,G__12946,G__12947,G__12948,G__12949,G__12950,G__12951) : target_fn.call(null,G__12938,G__12939,G__12940,G__12941,G__12942,G__12943,G__12944,G__12945,G__12946,G__12947,G__12948,G__12949,G__12950,G__12951));
});
var G__13582__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12952 = a;
var G__12953 = b;
var G__12954 = c;
var G__12955 = d;
var G__12956 = e;
var G__12957 = f;
var G__12958 = g;
var G__12959 = h;
var G__12960 = i;
var G__12961 = j;
var G__12962 = k;
var G__12963 = l;
var G__12964 = m;
var G__12965 = n;
var G__12966 = o;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$15 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$15(G__12952,G__12953,G__12954,G__12955,G__12956,G__12957,G__12958,G__12959,G__12960,G__12961,G__12962,G__12963,G__12964,G__12965,G__12966) : self__.dispatch_fn.call(null,G__12952,G__12953,G__12954,G__12955,G__12956,G__12957,G__12958,G__12959,G__12960,G__12961,G__12962,G__12963,G__12964,G__12965,G__12966));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12967 = a;
var G__12968 = b;
var G__12969 = c;
var G__12970 = d;
var G__12971 = e;
var G__12972 = f;
var G__12973 = g;
var G__12974 = h;
var G__12975 = i;
var G__12976 = j;
var G__12977 = k;
var G__12978 = l;
var G__12979 = m;
var G__12980 = n;
var G__12981 = o;
return (target_fn.cljs$core$IFn$_invoke$arity$15 ? target_fn.cljs$core$IFn$_invoke$arity$15(G__12967,G__12968,G__12969,G__12970,G__12971,G__12972,G__12973,G__12974,G__12975,G__12976,G__12977,G__12978,G__12979,G__12980,G__12981) : target_fn.call(null,G__12967,G__12968,G__12969,G__12970,G__12971,G__12972,G__12973,G__12974,G__12975,G__12976,G__12977,G__12978,G__12979,G__12980,G__12981));
});
var G__13582__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12982 = a;
var G__12983 = b;
var G__12984 = c;
var G__12985 = d;
var G__12986 = e;
var G__12987 = f;
var G__12988 = g;
var G__12989 = h;
var G__12990 = i;
var G__12991 = j;
var G__12992 = k;
var G__12993 = l;
var G__12994 = m;
var G__12995 = n;
var G__12996 = o;
var G__12997 = p;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$16 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$16(G__12982,G__12983,G__12984,G__12985,G__12986,G__12987,G__12988,G__12989,G__12990,G__12991,G__12992,G__12993,G__12994,G__12995,G__12996,G__12997) : self__.dispatch_fn.call(null,G__12982,G__12983,G__12984,G__12985,G__12986,G__12987,G__12988,G__12989,G__12990,G__12991,G__12992,G__12993,G__12994,G__12995,G__12996,G__12997));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12998 = a;
var G__12999 = b;
var G__13000 = c;
var G__13001 = d;
var G__13002 = e;
var G__13003 = f;
var G__13004 = g;
var G__13005 = h;
var G__13006 = i;
var G__13007 = j;
var G__13008 = k;
var G__13009 = l;
var G__13010 = m;
var G__13011 = n;
var G__13012 = o;
var G__13013 = p;
return (target_fn.cljs$core$IFn$_invoke$arity$16 ? target_fn.cljs$core$IFn$_invoke$arity$16(G__12998,G__12999,G__13000,G__13001,G__13002,G__13003,G__13004,G__13005,G__13006,G__13007,G__13008,G__13009,G__13010,G__13011,G__13012,G__13013) : target_fn.call(null,G__12998,G__12999,G__13000,G__13001,G__13002,G__13003,G__13004,G__13005,G__13006,G__13007,G__13008,G__13009,G__13010,G__13011,G__13012,G__13013));
});
var G__13582__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__13014 = a;
var G__13015 = b;
var G__13016 = c;
var G__13017 = d;
var G__13018 = e;
var G__13019 = f;
var G__13020 = g;
var G__13021 = h;
var G__13022 = i;
var G__13023 = j;
var G__13024 = k;
var G__13025 = l;
var G__13026 = m;
var G__13027 = n;
var G__13028 = o;
var G__13029 = p;
var G__13030 = q;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$17 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$17(G__13014,G__13015,G__13016,G__13017,G__13018,G__13019,G__13020,G__13021,G__13022,G__13023,G__13024,G__13025,G__13026,G__13027,G__13028,G__13029,G__13030) : self__.dispatch_fn.call(null,G__13014,G__13015,G__13016,G__13017,G__13018,G__13019,G__13020,G__13021,G__13022,G__13023,G__13024,G__13025,G__13026,G__13027,G__13028,G__13029,G__13030));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__13031 = a;
var G__13032 = b;
var G__13033 = c;
var G__13034 = d;
var G__13035 = e;
var G__13036 = f;
var G__13037 = g;
var G__13038 = h;
var G__13039 = i;
var G__13040 = j;
var G__13041 = k;
var G__13042 = l;
var G__13043 = m;
var G__13044 = n;
var G__13045 = o;
var G__13046 = p;
var G__13047 = q;
return (target_fn.cljs$core$IFn$_invoke$arity$17 ? target_fn.cljs$core$IFn$_invoke$arity$17(G__13031,G__13032,G__13033,G__13034,G__13035,G__13036,G__13037,G__13038,G__13039,G__13040,G__13041,G__13042,G__13043,G__13044,G__13045,G__13046,G__13047) : target_fn.call(null,G__13031,G__13032,G__13033,G__13034,G__13035,G__13036,G__13037,G__13038,G__13039,G__13040,G__13041,G__13042,G__13043,G__13044,G__13045,G__13046,G__13047));
});
var G__13582__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__13048 = a;
var G__13049 = b;
var G__13050 = c;
var G__13051 = d;
var G__13052 = e;
var G__13053 = f;
var G__13054 = g;
var G__13055 = h;
var G__13056 = i;
var G__13057 = j;
var G__13058 = k;
var G__13059 = l;
var G__13060 = m;
var G__13061 = n;
var G__13062 = o;
var G__13063 = p;
var G__13064 = q;
var G__13065 = r;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$18 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$18(G__13048,G__13049,G__13050,G__13051,G__13052,G__13053,G__13054,G__13055,G__13056,G__13057,G__13058,G__13059,G__13060,G__13061,G__13062,G__13063,G__13064,G__13065) : self__.dispatch_fn.call(null,G__13048,G__13049,G__13050,G__13051,G__13052,G__13053,G__13054,G__13055,G__13056,G__13057,G__13058,G__13059,G__13060,G__13061,G__13062,G__13063,G__13064,G__13065));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__13066 = a;
var G__13067 = b;
var G__13068 = c;
var G__13069 = d;
var G__13070 = e;
var G__13071 = f;
var G__13072 = g;
var G__13073 = h;
var G__13074 = i;
var G__13075 = j;
var G__13076 = k;
var G__13077 = l;
var G__13078 = m;
var G__13079 = n;
var G__13080 = o;
var G__13081 = p;
var G__13082 = q;
var G__13083 = r;
return (target_fn.cljs$core$IFn$_invoke$arity$18 ? target_fn.cljs$core$IFn$_invoke$arity$18(G__13066,G__13067,G__13068,G__13069,G__13070,G__13071,G__13072,G__13073,G__13074,G__13075,G__13076,G__13077,G__13078,G__13079,G__13080,G__13081,G__13082,G__13083) : target_fn.call(null,G__13066,G__13067,G__13068,G__13069,G__13070,G__13071,G__13072,G__13073,G__13074,G__13075,G__13076,G__13077,G__13078,G__13079,G__13080,G__13081,G__13082,G__13083));
});
var G__13582__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__13084 = a;
var G__13085 = b;
var G__13086 = c;
var G__13087 = d;
var G__13088 = e;
var G__13089 = f;
var G__13090 = g;
var G__13091 = h;
var G__13092 = i;
var G__13093 = j;
var G__13094 = k;
var G__13095 = l;
var G__13096 = m;
var G__13097 = n;
var G__13098 = o;
var G__13099 = p;
var G__13100 = q;
var G__13101 = r;
var G__13102 = s;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$19 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$19(G__13084,G__13085,G__13086,G__13087,G__13088,G__13089,G__13090,G__13091,G__13092,G__13093,G__13094,G__13095,G__13096,G__13097,G__13098,G__13099,G__13100,G__13101,G__13102) : self__.dispatch_fn.call(null,G__13084,G__13085,G__13086,G__13087,G__13088,G__13089,G__13090,G__13091,G__13092,G__13093,G__13094,G__13095,G__13096,G__13097,G__13098,G__13099,G__13100,G__13101,G__13102));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__13103 = a;
var G__13104 = b;
var G__13105 = c;
var G__13106 = d;
var G__13107 = e;
var G__13108 = f;
var G__13109 = g;
var G__13110 = h;
var G__13111 = i;
var G__13112 = j;
var G__13113 = k;
var G__13114 = l;
var G__13115 = m;
var G__13116 = n;
var G__13117 = o;
var G__13118 = p;
var G__13119 = q;
var G__13120 = r;
var G__13121 = s;
return (target_fn.cljs$core$IFn$_invoke$arity$19 ? target_fn.cljs$core$IFn$_invoke$arity$19(G__13103,G__13104,G__13105,G__13106,G__13107,G__13108,G__13109,G__13110,G__13111,G__13112,G__13113,G__13114,G__13115,G__13116,G__13117,G__13118,G__13119,G__13120,G__13121) : target_fn.call(null,G__13103,G__13104,G__13105,G__13106,G__13107,G__13108,G__13109,G__13110,G__13111,G__13112,G__13113,G__13114,G__13115,G__13116,G__13117,G__13118,G__13119,G__13120,G__13121));
});
var G__13582__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__13122 = a;
var G__13123 = b;
var G__13124 = c;
var G__13125 = d;
var G__13126 = e;
var G__13127 = f;
var G__13128 = g;
var G__13129 = h;
var G__13130 = i;
var G__13131 = j;
var G__13132 = k;
var G__13133 = l;
var G__13134 = m;
var G__13135 = n;
var G__13136 = o;
var G__13137 = p;
var G__13138 = q;
var G__13139 = r;
var G__13140 = s;
var G__13141 = t;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$20 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$20(G__13122,G__13123,G__13124,G__13125,G__13126,G__13127,G__13128,G__13129,G__13130,G__13131,G__13132,G__13133,G__13134,G__13135,G__13136,G__13137,G__13138,G__13139,G__13140,G__13141) : self__.dispatch_fn.call(null,G__13122,G__13123,G__13124,G__13125,G__13126,G__13127,G__13128,G__13129,G__13130,G__13131,G__13132,G__13133,G__13134,G__13135,G__13136,G__13137,G__13138,G__13139,G__13140,G__13141));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__13142 = a;
var G__13143 = b;
var G__13144 = c;
var G__13145 = d;
var G__13146 = e;
var G__13147 = f;
var G__13148 = g;
var G__13149 = h;
var G__13150 = i;
var G__13151 = j;
var G__13152 = k;
var G__13153 = l;
var G__13154 = m;
var G__13155 = n;
var G__13156 = o;
var G__13157 = p;
var G__13158 = q;
var G__13159 = r;
var G__13160 = s;
var G__13161 = t;
return (target_fn.cljs$core$IFn$_invoke$arity$20 ? target_fn.cljs$core$IFn$_invoke$arity$20(G__13142,G__13143,G__13144,G__13145,G__13146,G__13147,G__13148,G__13149,G__13150,G__13151,G__13152,G__13153,G__13154,G__13155,G__13156,G__13157,G__13158,G__13159,G__1