(defproject io.factorhouse/slipway-jetty11 "1.1.21"

  :description "A Clojure Companion for Jetty 11"

  :url "https://github.com/factorhouse/slipway"

  :license {:name "Apache 2.0 License"
            :url  "https://github.com/factorhouse/slipway/blob/main/LICENSE"}

  :profiles {:dev   {:dependencies   [[clj-kondo "2025.02.20"]
                                      [clj-http "3.13.1" :exclusions [commons-codec commons-io]] ;; later version brought in by jetty-jaas and ring-servlet respectively
                                      [ch.qos.logback/logback-classic "1.3.15"] ;; Logback 1.3.x supports the Java EE edition whereas logback 1.4.x supports Jakarta EE, otherwise the two versions are feature identical. The 1.5.x continues the 1.4.x series but with logback-access relocated to its own repository.
                                      [hiccup "1.0.5"]
                                      [ring/ring-anti-forgery "1.4.0"]
                                      [metosin/reitit-ring "0.7.2" :exclusions [ring/ring-core]]]
                     :resource-paths ["dev-resources" "common/dev-resources"]
                     :plugins        [[dev.weavejester/lein-cljfmt "0.13.1"]]}
             :smoke {:pedantic? :abort}}

  :aliases {"check" ["with-profile" "+smoke" "check"]
            "kondo" ["with-profile" "+smoke" "run" "-m" "clj-kondo.main" "--lint" "common/src:common-jetty1x/src:test:common/test" "--parallel"]
            "fmt"   ["with-profile" "+smoke" "cljfmt" "check"]}

  :dependencies [[org.clojure/clojure "1.12.2"]
                 [org.clojure/tools.logging "1.3.0"]
                 [ring/ring-servlet "1.14.2"]
                 [com.taoensso/sente "1.17.0"]
                 [org.eclipse.jetty.websocket/websocket-jetty-api "11.0.26"]
                 [org.eclipse.jetty.websocket/websocket-jetty-server "11.0.26" :exclusions [org.slf4j/slf4j-api]]
                 [org.eclipse.jetty.websocket/websocket-servlet "11.0.26" :exclusions [org.slf4j/slf4j-api]]
                 [org.eclipse.jetty/jetty-server "11.0.26" :exclusions [org.slf4j/slf4j-api]]
                 [org.apache.mina/mina-core "2.2.4"]        ;; exclude mina-core with CVE and manually bump to latest minor version
                 [org.eclipse.jetty/jetty-jaas "11.0.26" :exclusions [org.slf4j/slf4j-api org.apache.mina/mina-core]]
                 [org.slf4j/slf4j-api "2.0.17"]]

  :source-paths ["common/src" "common-jetty1x/src" "common-jakarta/src"]
  :test-paths ["test" "common/test"]

  :javac-options ["--release" "11"])
