/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.ranger.finder;

import com.flipkart.ranger.finder.Service;
import com.flipkart.ranger.finder.ServiceRegistryUpdater;
import com.flipkart.ranger.model.Deserializer;
import com.flipkart.ranger.model.PathBuilder;
import com.flipkart.ranger.model.ServiceRegistry;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractZookeeperServiceRegistry<T>
extends ServiceRegistry<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractZookeeperServiceRegistry.class);
    private final int refreshIntervalMillis;
    private final boolean disableWatchers;
    private ServiceRegistryUpdater<T> updater;
    private ExecutorService executorService = Executors.newFixedThreadPool(1);
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> scheduledFuture;
    private Future<Void> queryThreadFuture;

    protected AbstractZookeeperServiceRegistry(Service service, Deserializer<T> deserializer, int refreshIntervalMillis, boolean disableWatchers) {
        super(service, deserializer);
        this.refreshIntervalMillis = refreshIntervalMillis;
        this.disableWatchers = disableWatchers;
    }

    @Override
    public void start() throws Exception {
        Service service = this.getService();
        service.getCuratorFramework().blockUntilConnected();
        logger.debug("Connected to zookeeper cluster for {}", (Object)service.getServiceName());
        service.getCuratorFramework().newNamespaceAwareEnsurePath(PathBuilder.path(service)).ensure(service.getCuratorFramework().getZookeeperClient());
        this.updater = new ServiceRegistryUpdater(this, this.disableWatchers);
        this.updater.start();
        this.queryThreadFuture = this.executorService.submit(this.updater);
        this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(() -> {
            try {
                this.updater.checkForUpdate();
            }
            catch (Exception e) {
                logger.error("Error checking for updates from zk for service:" + service.getServiceName(), (Throwable)e);
            }
        }, 0L, this.refreshIntervalMillis, TimeUnit.MILLISECONDS);
        logger.debug("Service Registry Started for {}", (Object)service.getServiceName());
    }

    @Override
    public void stop() throws Exception {
        Service service = this.getService();
        try {
            if (null != this.scheduledFuture) {
                this.scheduledFuture.cancel(true);
            }
            this.updater.stop();
            if (null != this.queryThreadFuture) {
                this.executorService.shutdownNow();
            }
        }
        catch (Exception e) {
            logger.error(String.format("Error stopping ZK poller for %s", service.getServiceName()), (Throwable)e);
        }
        service.getCuratorFramework().close();
        logger.debug("Service Registry stopped for {}", (Object)service.getServiceName());
    }
}

