/*
 * Decompiled with CFR 0.152.
 */
package io.durg.tsaheylu.metered;

import io.durg.tsaheylu.metered.DefaultSuccessPredicate;
import io.durg.tsaheylu.metered.SuccessPredicate;
import java.util.concurrent.TimeUnit;

public class Configuration {
    private Double errorPercentageThreshold;
    private Integer window;
    private TimeUnit timeUnit;
    private SuccessPredicate successPredicate;

    public SuccessPredicate getSuccessPredicate() {
        return this.successPredicate;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public double getErrorPercentageThreshold() {
        return this.errorPercentageThreshold;
    }

    public int getWindow() {
        return this.window;
    }

    public static final class ConfigurationBuilder {
        private Double errorPercentageThreshold;
        private Integer window;
        private TimeUnit timeUnit;
        private SuccessPredicate successPredicate;

        private ConfigurationBuilder() {
        }

        public static ConfigurationBuilder newConfiguration() {
            return new ConfigurationBuilder();
        }

        public ConfigurationBuilder withErrorPercentageThreshold(Double errorPercentageThreshold) {
            this.errorPercentageThreshold = errorPercentageThreshold;
            return this;
        }

        public ConfigurationBuilder withWindow(Integer window) {
            this.window = window;
            return this;
        }

        public ConfigurationBuilder withTimeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public ConfigurationBuilder withSuccessPredicate(SuccessPredicate successPredicate) {
            this.successPredicate = successPredicate;
            return this;
        }

        public Configuration build() {
            Configuration configuration = new Configuration();
            configuration.errorPercentageThreshold = this.errorPercentageThreshold;
            configuration.timeUnit = this.timeUnit;
            configuration.window = this.window;
            configuration.successPredicate = this.successPredicate == null ? new DefaultSuccessPredicate() : this.successPredicate;
            return configuration;
        }
    }
}

