/*
 * Decompiled with CFR 0.152.
 */
package io.durg.tsaheylu.registry;

import io.durg.tsaheylu.registry.metrics.MetricMonitor;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SigmoidHealthMetricFunction
implements Function<List<MetricMonitor>, Double> {
    private static final Logger log = LoggerFactory.getLogger(SigmoidHealthMetricFunction.class);

    @Override
    public Double apply(List<MetricMonitor> metricMonitors) {
        double healthMetric = metricMonitors.stream().filter(Objects::nonNull).filter(metricMonitor -> metricMonitor.getMetric() != null && metricMonitor.getMetric() != Double.NaN).map(monitor -> monitor.getWeight() * monitor.getMetric()).map(x -> 1.0 / (1.0 + Math.pow(Math.E, -1.0 * x))).mapToDouble(Double::doubleValue).average().orElse(Double.NaN);
        log.info("HealthMetric value : {}", (Object)healthMetric);
        return healthMetric;
    }
}

