/*
 * Decompiled with CFR 0.152.
 */
package io.durg.tsaheylu.registry.metrics;

import io.durg.tsaheylu.registry.metrics.MetricMonitor;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.List;

public class JVMHeapSizeMetricMonitor
implements MetricMonitor {
    private final MemoryMXBean mxBean;
    private final List<MemoryPoolMXBean> memoryPools;

    public JVMHeapSizeMetricMonitor() {
        this.mxBean = ManagementFactory.getMemoryMXBean();
        this.memoryPools = ManagementFactory.getMemoryPoolMXBeans();
    }

    @Override
    public double getWeight() {
        return -1.0;
    }

    @Override
    public Double getMetric() {
        MemoryUsage heapMemoryUsage = this.mxBean.getHeapMemoryUsage();
        return (double)heapMemoryUsage.getUsed() / (double)heapMemoryUsage.getMax();
    }

    public static JVMHeapSizeMetricMonitorBuilder builder() {
        return new JVMHeapSizeMetricMonitorBuilder();
    }

    public JVMHeapSizeMetricMonitor(MemoryMXBean mxBean, List<MemoryPoolMXBean> memoryPools) {
        this.mxBean = mxBean;
        this.memoryPools = memoryPools;
    }

    public static class JVMHeapSizeMetricMonitorBuilder {
        private MemoryMXBean mxBean;
        private List<MemoryPoolMXBean> memoryPools;

        JVMHeapSizeMetricMonitorBuilder() {
        }

        public JVMHeapSizeMetricMonitorBuilder mxBean(MemoryMXBean mxBean) {
            this.mxBean = mxBean;
            return this;
        }

        public JVMHeapSizeMetricMonitorBuilder memoryPools(List<MemoryPoolMXBean> memoryPools) {
            this.memoryPools = memoryPools;
            return this;
        }

        public JVMHeapSizeMetricMonitor build() {
            return new JVMHeapSizeMetricMonitor(this.mxBean, this.memoryPools);
        }

        public String toString() {
            return "JVMHeapSizeMetricMonitor.JVMHeapSizeMetricMonitorBuilder(mxBean=" + this.mxBean + ", memoryPools=" + this.memoryPools + ")";
        }
    }
}

