/*
 * Decompiled with CFR 0.152.
 */
package io.durg.tsaheylu.model;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class NodeData
implements Iterable<NodeData> {
    private static final String SEPARATOR = ".";
    private String environment;
    private double healthMetric;
    private String version;

    public NodeData(String environment, double healthMetric, String version) {
        this.environment = environment;
        this.healthMetric = healthMetric;
        this.version = version;
    }

    public NodeData(String environment) {
        this.environment = environment;
    }

    @Override
    public Iterator<NodeData> iterator() {
        return new NodeDataIterator(this.environment);
    }

    public static NodeDataBuilder builder() {
        return new NodeDataBuilder();
    }

    public String getEnvironment() {
        return this.environment;
    }

    public double getHealthMetric() {
        return this.healthMetric;
    }

    public String getVersion() {
        return this.version;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setHealthMetric(double healthMetric) {
        this.healthMetric = healthMetric;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public NodeData() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeData)) {
            return false;
        }
        NodeData other = (NodeData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$environment = this.getEnvironment();
        String other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        if (Double.compare(this.getHealthMetric(), other.getHealthMetric()) != 0) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NodeData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        long $healthMetric = Double.doubleToLongBits(this.getHealthMetric());
        result = result * 59 + (int)($healthMetric >>> 32 ^ $healthMetric);
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    public static class NodeDataBuilder {
        private String environment;
        private double healthMetric;
        private String version;

        NodeDataBuilder() {
        }

        public NodeDataBuilder environment(String environment) {
            this.environment = environment;
            return this;
        }

        public NodeDataBuilder healthMetric(double healthMetric) {
            this.healthMetric = healthMetric;
            return this;
        }

        public NodeDataBuilder version(String version) {
            this.version = version;
            return this;
        }

        public NodeData build() {
            return new NodeData(this.environment, this.healthMetric, this.version);
        }

        public String toString() {
            return "NodeData.NodeDataBuilder(environment=" + this.environment + ", healthMetric=" + this.healthMetric + ", version=" + this.version + ")";
        }
    }

    public static final class NodeDataIterator
    implements Iterator<NodeData> {
        private String remainingEnvironment;

        public NodeDataIterator(String remainingEnvironment) {
            this.remainingEnvironment = remainingEnvironment;
        }

        @Override
        public boolean hasNext() {
            return this.remainingEnvironment != null && !this.remainingEnvironment.isEmpty();
        }

        @Override
        public NodeData next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            NodeData shardInfo = new NodeData(this.remainingEnvironment);
            int sepIndex = this.remainingEnvironment.indexOf(NodeData.SEPARATOR);
            this.remainingEnvironment = sepIndex < 0 ? "" : this.remainingEnvironment.substring(0, sepIndex);
            return shardInfo;
        }
    }
}

