/*
 * Decompiled with CFR 0.152.
 */
package io.durg.kirtimukh.throttling.window.impl;

import io.durg.kirtimukh.throttling.config.ThrottlingStrategyConfig;
import io.durg.kirtimukh.throttling.exception.impl.LeakyBucketThrottlingException;
import io.durg.kirtimukh.throttling.tick.Tick;
import io.durg.kirtimukh.throttling.tick.impl.LocationTick;
import io.durg.kirtimukh.throttling.window.Window;
import io.durg.kirtimukh.throttling.window.WindowChecker;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeakyBucketWindowChecker
implements WindowChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LeakyBucketWindowChecker.class);
    private final String commandKey;
    private final Window window;

    public LeakyBucketWindowChecker(String commandKey, ThrottlingStrategyConfig strategyConfig) {
        this.commandKey = commandKey;
        this.window = Window.builder().threshold(strategyConfig.getThreshold()).build();
    }

    @Override
    public Tick acquire() {
        int location = this.window.add();
        if (location < 0) {
            throw LeakyBucketThrottlingException.builder().commandKey(this.commandKey).cardinality(this.window.cardinality()).threshold(this.window.getThreshold()).message("Threshold limits exhausted").build();
        }
        log.debug("[{}] Cardinality {} allowed limit {}", new Object[]{this.commandKey, this.window.cardinality(), this.window.getThreshold()});
        return LocationTick.builder().location(location).build();
    }

    @Override
    public boolean release(Tick location) {
        return this.window.remove(location.getLocation());
    }

    @Generated
    public static LeakyBucketWindowCheckerBuilder builder() {
        return new LeakyBucketWindowCheckerBuilder();
    }

    @Generated
    private LeakyBucketWindowChecker() {
        this.commandKey = null;
        this.window = null;
    }

    @Generated
    public String getCommandKey() {
        return this.commandKey;
    }

    @Generated
    public Window getWindow() {
        return this.window;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LeakyBucketWindowChecker)) {
            return false;
        }
        LeakyBucketWindowChecker other = (LeakyBucketWindowChecker)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$commandKey = this.getCommandKey();
        String other$commandKey = other.getCommandKey();
        if (this$commandKey == null ? other$commandKey != null : !this$commandKey.equals(other$commandKey)) {
            return false;
        }
        Window this$window = this.getWindow();
        Window other$window = other.getWindow();
        return !(this$window == null ? other$window != null : !((Object)this$window).equals(other$window));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LeakyBucketWindowChecker;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $commandKey = this.getCommandKey();
        result = result * 59 + ($commandKey == null ? 43 : $commandKey.hashCode());
        Window $window = this.getWindow();
        result = result * 59 + ($window == null ? 43 : ((Object)$window).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LeakyBucketWindowChecker(commandKey=" + this.getCommandKey() + ", window=" + this.getWindow() + ")";
    }

    @Generated
    public static class LeakyBucketWindowCheckerBuilder {
        @Generated
        private String commandKey;
        @Generated
        private ThrottlingStrategyConfig strategyConfig;

        @Generated
        LeakyBucketWindowCheckerBuilder() {
        }

        @Generated
        public LeakyBucketWindowCheckerBuilder commandKey(String commandKey) {
            this.commandKey = commandKey;
            return this;
        }

        @Generated
        public LeakyBucketWindowCheckerBuilder strategyConfig(ThrottlingStrategyConfig strategyConfig) {
            this.strategyConfig = strategyConfig;
            return this;
        }

        @Generated
        public LeakyBucketWindowChecker build() {
            return new LeakyBucketWindowChecker(this.commandKey, this.strategyConfig);
        }

        @Generated
        public String toString() {
            return "LeakyBucketWindowChecker.LeakyBucketWindowCheckerBuilder(commandKey=" + this.commandKey + ", strategyConfig=" + this.strategyConfig + ")";
        }
    }
}

