/*
 * Decompiled with CFR 0.152.
 */
package io.durg.kirtimukh.throttling.config.impl;

import io.durg.kirtimukh.throttling.config.ThrottlingStrategyConfig;
import io.durg.kirtimukh.throttling.enums.ThrottlingStrategyType;
import io.durg.kirtimukh.throttling.enums.ThrottlingWindowUnit;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import lombok.Generated;
import lombok.NonNull;

public class QuotaThrottlingStrategyConfig
extends ThrottlingStrategyConfig {
    @Valid
    @Min(value=1L)
    private @Valid @Min(value=1L) long windows;
    @NonNull
    private ThrottlingWindowUnit unit;

    public QuotaThrottlingStrategyConfig() {
        super(ThrottlingStrategyType.QUOTA);
        this.unit = ThrottlingWindowUnit.SECOND;
        this.windows = 1L;
    }

    public QuotaThrottlingStrategyConfig(ThrottlingWindowUnit unit, int threshold, long windows) {
        super(ThrottlingStrategyType.QUOTA, threshold);
        this.unit = unit;
        this.windows = windows;
    }

    @Generated
    public static QuotaThrottlingStrategyConfigBuilder builder() {
        return new QuotaThrottlingStrategyConfigBuilder();
    }

    @Generated
    public long getWindows() {
        return this.windows;
    }

    @NonNull
    @Generated
    public ThrottlingWindowUnit getUnit() {
        return this.unit;
    }

    @Generated
    public void setWindows(long windows) {
        this.windows = windows;
    }

    @Generated
    public void setUnit(@NonNull ThrottlingWindowUnit unit) {
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        this.unit = unit;
    }

    @Override
    @Generated
    public String toString() {
        return "QuotaThrottlingStrategyConfig(windows=" + this.getWindows() + ", unit=" + (Object)((Object)this.getUnit()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuotaThrottlingStrategyConfig)) {
            return false;
        }
        QuotaThrottlingStrategyConfig other = (QuotaThrottlingStrategyConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getWindows() != other.getWindows()) {
            return false;
        }
        ThrottlingWindowUnit this$unit = this.getUnit();
        ThrottlingWindowUnit other$unit = other.getUnit();
        return !(this$unit == null ? other$unit != null : !((Object)((Object)this$unit)).equals((Object)other$unit));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QuotaThrottlingStrategyConfig;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $windows = this.getWindows();
        result = result * 59 + (int)($windows >>> 32 ^ $windows);
        ThrottlingWindowUnit $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : ((Object)((Object)$unit)).hashCode());
        return result;
    }

    @Generated
    public static class QuotaThrottlingStrategyConfigBuilder {
        @Generated
        private ThrottlingWindowUnit unit;
        @Generated
        private int threshold;
        @Generated
        private long windows;

        @Generated
        QuotaThrottlingStrategyConfigBuilder() {
        }

        @Generated
        public QuotaThrottlingStrategyConfigBuilder unit(ThrottlingWindowUnit unit) {
            this.unit = unit;
            return this;
        }

        @Generated
        public QuotaThrottlingStrategyConfigBuilder threshold(int threshold) {
            this.threshold = threshold;
            return this;
        }

        @Generated
        public QuotaThrottlingStrategyConfigBuilder windows(long windows) {
            this.windows = windows;
            return this;
        }

        @Generated
        public QuotaThrottlingStrategyConfig build() {
            return new QuotaThrottlingStrategyConfig(this.unit, this.threshold, this.windows);
        }

        @Generated
        public String toString() {
            return "QuotaThrottlingStrategyConfig.QuotaThrottlingStrategyConfigBuilder(unit=" + (Object)((Object)this.unit) + ", threshold=" + this.threshold + ", windows=" + this.windows + ")";
        }
    }
}

