/*
 * Decompiled with CFR 0.152.
 */
package io.durg.kirtimukh.throttling.config.impl;

import io.durg.kirtimukh.throttling.config.PriorityBucketThrottlingConfig;
import io.durg.kirtimukh.throttling.config.ThrottlingStrategyConfig;
import io.durg.kirtimukh.throttling.enums.ThrottlingStrategyType;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class PriorityBucketThrottlingStrategyConfig
extends ThrottlingStrategyConfig {
    private final int sharedBucketThreshold;
    private final Map<String, PriorityBucketThrottlingConfig> bucketConfigs;

    public PriorityBucketThrottlingStrategyConfig() {
        super(ThrottlingStrategyType.PRIORITY_BUCKET);
        this.bucketConfigs = new HashMap<String, PriorityBucketThrottlingConfig>();
        this.sharedBucketThreshold = 0;
    }

    public PriorityBucketThrottlingStrategyConfig(int sharedBucketThreshold, Map<String, PriorityBucketThrottlingConfig> bucketConfigs) {
        super(ThrottlingStrategyType.PRIORITY_BUCKET);
        int bucketThresholds = 0;
        for (PriorityBucketThrottlingConfig config : bucketConfigs.values()) {
            bucketThresholds += config.getThreshold();
        }
        this.setThreshold(bucketThresholds);
        this.bucketConfigs = bucketConfigs;
        this.sharedBucketThreshold = sharedBucketThreshold;
    }

    @Generated
    public static PriorityBucketThrottlingStrategyConfigBuilder builder() {
        return new PriorityBucketThrottlingStrategyConfigBuilder();
    }

    @Generated
    public int getSharedBucketThreshold() {
        return this.sharedBucketThreshold;
    }

    @Generated
    public Map<String, PriorityBucketThrottlingConfig> getBucketConfigs() {
        return this.bucketConfigs;
    }

    @Override
    @Generated
    public String toString() {
        return "PriorityBucketThrottlingStrategyConfig(sharedBucketThreshold=" + this.getSharedBucketThreshold() + ", bucketConfigs=" + this.getBucketConfigs() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PriorityBucketThrottlingStrategyConfig)) {
            return false;
        }
        PriorityBucketThrottlingStrategyConfig other = (PriorityBucketThrottlingStrategyConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getSharedBucketThreshold() != other.getSharedBucketThreshold()) {
            return false;
        }
        Map<String, PriorityBucketThrottlingConfig> this$bucketConfigs = this.getBucketConfigs();
        Map<String, PriorityBucketThrottlingConfig> other$bucketConfigs = other.getBucketConfigs();
        return !(this$bucketConfigs == null ? other$bucketConfigs != null : !((Object)this$bucketConfigs).equals(other$bucketConfigs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PriorityBucketThrottlingStrategyConfig;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getSharedBucketThreshold();
        Map<String, PriorityBucketThrottlingConfig> $bucketConfigs = this.getBucketConfigs();
        result = result * 59 + ($bucketConfigs == null ? 43 : ((Object)$bucketConfigs).hashCode());
        return result;
    }

    @Generated
    public static class PriorityBucketThrottlingStrategyConfigBuilder {
        @Generated
        private int sharedBucketThreshold;
        @Generated
        private Map<String, PriorityBucketThrottlingConfig> bucketConfigs;

        @Generated
        PriorityBucketThrottlingStrategyConfigBuilder() {
        }

        @Generated
        public PriorityBucketThrottlingStrategyConfigBuilder sharedBucketThreshold(int sharedBucketThreshold) {
            this.sharedBucketThreshold = sharedBucketThreshold;
            return this;
        }

        @Generated
        public PriorityBucketThrottlingStrategyConfigBuilder bucketConfigs(Map<String, PriorityBucketThrottlingConfig> bucketConfigs) {
            this.bucketConfigs = bucketConfigs;
            return this;
        }

        @Generated
        public PriorityBucketThrottlingStrategyConfig build() {
            return new PriorityBucketThrottlingStrategyConfig(this.sharedBucketThreshold, this.bucketConfigs);
        }

        @Generated
        public String toString() {
            return "PriorityBucketThrottlingStrategyConfig.PriorityBucketThrottlingStrategyConfigBuilder(sharedBucketThreshold=" + this.sharedBucketThreshold + ", bucketConfigs=" + this.bucketConfigs + ")";
        }
    }
}

