/*
 * Decompiled with CFR 0.152.
 */
package io.durg.kirtimukh.throttling.window;

import io.durg.kirtimukh.throttling.ThrottlingKey;
import io.durg.kirtimukh.throttling.config.ThrottlingStrategyConfig;
import io.durg.kirtimukh.throttling.config.impl.PriorityBucketThrottlingStrategyConfig;
import io.durg.kirtimukh.throttling.config.impl.QuotaThrottlingStrategyConfig;
import io.durg.kirtimukh.throttling.enums.ThrottlingStrategyType;
import io.durg.kirtimukh.throttling.window.WindowChecker;
import io.durg.kirtimukh.throttling.window.impl.LeakyBucketWindowChecker;
import io.durg.kirtimukh.throttling.window.impl.PriorityWindowChecker;
import io.durg.kirtimukh.throttling.window.impl.QuotaWindowChecker;
import lombok.Generated;

public final class WindowCheckerUtils {
    private static QuotaWindowChecker getTimedWindowChecker(ThrottlingKey throttlingKey, QuotaThrottlingStrategyConfig strategyConfig) {
        return QuotaWindowChecker.builder().commandKey(throttlingKey.getConfigName()).strategyConfig(strategyConfig).build();
    }

    private static LeakyBucketWindowChecker getSimpleWindowChecker(ThrottlingKey throttlingKey, ThrottlingStrategyConfig strategyConfig) {
        return LeakyBucketWindowChecker.builder().commandKey(throttlingKey.getConfigName()).strategyConfig(strategyConfig).build();
    }

    private static PriorityWindowChecker getPriorityWindowChecker(ThrottlingKey throttlingKey, PriorityBucketThrottlingStrategyConfig strategyConfig) {
        return PriorityWindowChecker.builder().bucketKey(throttlingKey).strategyConfig(strategyConfig).build();
    }

    public static WindowChecker getWindowChecker(final ThrottlingKey throttlingKey, final ThrottlingStrategyConfig strategyConfig) {
        return strategyConfig.getType().accept(new ThrottlingStrategyType.Visitor<WindowChecker>(){

            @Override
            public WindowChecker visitQuota() {
                return WindowCheckerUtils.getTimedWindowChecker(throttlingKey, (QuotaThrottlingStrategyConfig)strategyConfig);
            }

            @Override
            public WindowChecker visitLeakyBucket() {
                return WindowCheckerUtils.getSimpleWindowChecker(throttlingKey, strategyConfig);
            }

            @Override
            public WindowChecker visitPriorityBucket() {
                return WindowCheckerUtils.getPriorityWindowChecker(throttlingKey, (PriorityBucketThrottlingStrategyConfig)strategyConfig);
            }

            @Override
            public WindowChecker visitCustomStrategy() {
                return null;
            }
        });
    }

    @Generated
    private WindowCheckerUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

