/*
 * Decompiled with CFR 0.152.
 */
package io.durg.kirtimukh.throttling.window.impl;

import io.durg.kirtimukh.throttling.config.impl.QuotaThrottlingStrategyConfig;
import io.durg.kirtimukh.throttling.enums.ThrottlingStrategyType;
import io.durg.kirtimukh.throttling.enums.ThrottlingWindowUnit;
import io.durg.kirtimukh.throttling.exception.TimedThrottlingException;
import io.durg.kirtimukh.throttling.tick.Tick;
import io.durg.kirtimukh.throttling.tick.impl.LocationTick;
import io.durg.kirtimukh.throttling.window.Window;
import io.durg.kirtimukh.throttling.window.WindowChecker;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedWindowChecker
implements WindowChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TimedWindowChecker.class);
    private final String commandKey;
    private final ThrottlingStrategyType strategyType;
    private final ThrottlingWindowUnit unit;
    private final long clearAfterInactiveWindows;
    private long prevWindow;
    private long liveWindow;
    private final Window window;

    public TimedWindowChecker(String commandKey, QuotaThrottlingStrategyConfig strategyConfig) {
        this.commandKey = commandKey;
        this.strategyType = strategyConfig.getType();
        this.unit = strategyConfig.getUnit();
        this.liveWindow = this.getWindow();
        this.clearAfterInactiveWindows = strategyConfig.getWindows();
        this.window = Window.builder().threshold(strategyConfig.getThreshold()).build();
    }

    private long getWindow() {
        return this.unit.accept(new ThrottlingWindowUnit.Visitor<Long>(){

            @Override
            public Long visitMillisecond() {
                return System.currentTimeMillis();
            }

            @Override
            public Long visitSecond() {
                return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
            }

            @Override
            public Long visitMinute() {
                return TimeUnit.MILLISECONDS.toMinutes(System.currentTimeMillis());
            }
        });
    }

    private boolean isChangeInWindow() {
        long currentWindow = this.getWindow();
        if (this.liveWindow != currentWindow) {
            this.prevWindow = this.liveWindow;
            this.liveWindow = currentWindow;
            return true;
        }
        return false;
    }

    private boolean isOkayToClear() {
        return this.liveWindow - this.prevWindow >= this.clearAfterInactiveWindows;
    }

    private void precheck() {
        if (this.isChangeInWindow() && this.isOkayToClear()) {
            log.debug("[{}] Clearing bitset", (Object)this.commandKey);
            this.window.clear();
        }
    }

    @Override
    public synchronized boolean release(Tick location) {
        return this.window.remove(location.getLocation());
    }

    @Override
    public synchronized Tick acquire() {
        this.precheck();
        int location = this.window.add();
        if (location < 0) {
            throw TimedThrottlingException.builder().commandKey(this.commandKey).strategyType(this.strategyType).cardinality(this.window.cardinality()).unit(this.unit).threshold(this.window.getThreshold()).message("Threshold limits exhausted").build();
        }
        log.debug("[{}] Cardinality {} allowed limit {}", new Object[]{this.commandKey, this.window.cardinality(), this.window.getThreshold()});
        return LocationTick.builder().location(location).build();
    }

    @Generated
    public static TimedWindowCheckerBuilder builder() {
        return new TimedWindowCheckerBuilder();
    }

    @Generated
    private TimedWindowChecker() {
        this.commandKey = null;
        this.strategyType = null;
        this.unit = null;
        this.clearAfterInactiveWindows = 0L;
        this.window = null;
    }

    @Generated
    public String getCommandKey() {
        return this.commandKey;
    }

    @Generated
    public ThrottlingStrategyType getStrategyType() {
        return this.strategyType;
    }

    @Generated
    public ThrottlingWindowUnit getUnit() {
        return this.unit;
    }

    @Generated
    public long getClearAfterInactiveWindows() {
        return this.clearAfterInactiveWindows;
    }

    @Generated
    public long getPrevWindow() {
        return this.prevWindow;
    }

    @Generated
    public long getLiveWindow() {
        return this.liveWindow;
    }

    @Generated
    public void setPrevWindow(long prevWindow) {
        this.prevWindow = prevWindow;
    }

    @Generated
    public void setLiveWindow(long liveWindow) {
        this.liveWindow = liveWindow;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimedWindowChecker)) {
            return false;
        }
        TimedWindowChecker other = (TimedWindowChecker)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$commandKey = this.getCommandKey();
        String other$commandKey = other.getCommandKey();
        if (this$commandKey == null ? other$commandKey != null : !this$commandKey.equals(other$commandKey)) {
            return false;
        }
        ThrottlingStrategyType this$strategyType = this.getStrategyType();
        ThrottlingStrategyType other$strategyType = other.getStrategyType();
        if (this$strategyType == null ? other$strategyType != null : !((Object)((Object)this$strategyType)).equals((Object)other$strategyType)) {
            return false;
        }
        ThrottlingWindowUnit this$unit = this.getUnit();
        ThrottlingWindowUnit other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !((Object)((Object)this$unit)).equals((Object)other$unit)) {
            return false;
        }
        if (this.getClearAfterInactiveWindows() != other.getClearAfterInactiveWindows()) {
            return false;
        }
        if (this.getPrevWindow() != other.getPrevWindow()) {
            return false;
        }
        if (this.getLiveWindow() != other.getLiveWindow()) {
            return false;
        }
        return this.getWindow() == other.getWindow();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TimedWindowChecker;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $commandKey = this.getCommandKey();
        result = result * 59 + ($commandKey == null ? 43 : $commandKey.hashCode());
        ThrottlingStrategyType $strategyType = this.getStrategyType();
        result = result * 59 + ($strategyType == null ? 43 : ((Object)((Object)$strategyType)).hashCode());
        ThrottlingWindowUnit $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : ((Object)((Object)$unit)).hashCode());
        long $clearAfterInactiveWindows = this.getClearAfterInactiveWindows();
        result = result * 59 + (int)($clearAfterInactiveWindows >>> 32 ^ $clearAfterInactiveWindows);
        long $prevWindow = this.getPrevWindow();
        result = result * 59 + (int)($prevWindow >>> 32 ^ $prevWindow);
        long $liveWindow = this.getLiveWindow();
        result = result * 59 + (int)($liveWindow >>> 32 ^ $liveWindow);
        long $window = this.getWindow();
        result = result * 59 + (int)($window >>> 32 ^ $window);
        return result;
    }

    @Generated
    public String toString() {
        return "TimedWindowChecker(commandKey=" + this.getCommandKey() + ", strategyType=" + (Object)((Object)this.getStrategyType()) + ", unit=" + (Object)((Object)this.getUnit()) + ", clearAfterInactiveWindows=" + this.getClearAfterInactiveWindows() + ", prevWindow=" + this.getPrevWindow() + ", liveWindow=" + this.getLiveWindow() + ", window=" + this.getWindow() + ")";
    }

    @Generated
    public static class TimedWindowCheckerBuilder {
        @Generated
        private String commandKey;
        @Generated
        private QuotaThrottlingStrategyConfig strategyConfig;

        @Generated
        TimedWindowCheckerBuilder() {
        }

        @Generated
        public TimedWindowCheckerBuilder commandKey(String commandKey) {
            this.commandKey = commandKey;
            return this;
        }

        @Generated
        public TimedWindowCheckerBuilder strategyConfig(QuotaThrottlingStrategyConfig strategyConfig) {
            this.strategyConfig = strategyConfig;
            return this;
        }

        @Generated
        public TimedWindowChecker build() {
            return new TimedWindowChecker(this.commandKey, this.strategyConfig);
        }

        @Generated
        public String toString() {
            return "TimedWindowChecker.TimedWindowCheckerBuilder(commandKey=" + this.commandKey + ", strategyConfig=" + this.strategyConfig + ")";
        }
    }
}

