/*
 * Decompiled with CFR 0.152.
 */
package io.durg.kirtimukh.circuitbreaker.hystrix;

import com.google.common.base.Strings;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import io.durg.kirtimukh.circuitbreaker.CircuitBreakerKey;
import io.durg.kirtimukh.circuitbreaker.hystrix.HystrixCommandExecutor;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.util.GlobalTracer;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.MDC;

public class HystrixCommandController {
    private static final String TRACE_ID = "TRACE-ID";

    private static HystrixCommand.Setter setter(CircuitBreakerKey circuitBreakerKey) {
        return HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)circuitBreakerKey.getGroup())).andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)circuitBreakerKey.getDomain())).andCommandKey(HystrixCommandKey.Factory.asKey((String)circuitBreakerKey.getCommand()));
    }

    private static <R> HystrixCommand<R> createTraceable(HystrixCommand.Setter setter, final String traceId, final HystrixCommandExecutor<R> executor) {
        return new HystrixCommand<R>(setter){
            final Map<String, String> parentMDCContext;
            final Span parentActiveSpan;
            {
                super(x0);
                this.parentMDCContext = MDC.getCopyOfContextMap();
                this.parentActiveSpan = GlobalTracer.get() != null ? GlobalTracer.get().activeSpan() : null;
            }

            protected R run() throws Exception {
                Scope scope = null;
                if (this.parentMDCContext != null) {
                    MDC.setContextMap(this.parentMDCContext);
                }
                if (this.parentActiveSpan != null) {
                    scope = GlobalTracer.get().scopeManager().activate(this.parentActiveSpan);
                }
                if (!Strings.isNullOrEmpty((String)traceId)) {
                    MDC.put((String)HystrixCommandController.TRACE_ID, (String)traceId);
                }
                try {
                    Object r = executor.execute();
                    return r;
                }
                catch (Throwable t) {
                    throw (Exception)t;
                }
                finally {
                    HystrixCommandProperties.ExecutionIsolationStrategy isolationStrategy;
                    if (scope != null) {
                        scope.close();
                    }
                    if ((isolationStrategy = (HystrixCommandProperties.ExecutionIsolationStrategy)this.getProperties().executionIsolationStrategy().get()) == HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE) {
                        if (!Strings.isNullOrEmpty((String)traceId)) {
                            MDC.remove((String)HystrixCommandController.TRACE_ID);
                        }
                    } else {
                        MDC.clear();
                    }
                }
            }
        };
    }

    private static <R> HystrixCommand<R> create(HystrixCommand.Setter setter, final HystrixCommandExecutor<R> executor) {
        return new HystrixCommand<R>(setter){

            protected R run() throws Exception {
                try {
                    return executor.execute();
                }
                catch (Throwable t) {
                    throw (Exception)t;
                }
            }
        };
    }

    private static <R> R execute(CircuitBreakerKey circuitBreakerKey, String traceId, HystrixCommandExecutor<R> executor) {
        HystrixCommand.Setter setter = HystrixCommandController.setter(circuitBreakerKey);
        HystrixCommand<R> hystrixCommand = HystrixCommandController.createTraceable(setter, traceId, executor);
        return (R)hystrixCommand.execute();
    }

    private static <R> R execute(CircuitBreakerKey circuitBreakerKey, String traceId, ProceedingJoinPoint joinPoint) {
        return (R)HystrixCommandController.execute(circuitBreakerKey, traceId, () -> joinPoint.proceed());
    }

    public static <R> R execute(CircuitBreakerKey circuitBreakerKey, ProceedingJoinPoint joinPoint) {
        return HystrixCommandController.execute(circuitBreakerKey, null, joinPoint);
    }
}

