/*
 * Decompiled with CFR 0.152.
 */
package io.durg.kirtimukh.throttling;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import io.durg.kirtimukh.throttling.ThrottlingController;
import io.durg.kirtimukh.throttling.ThrottlingExceptionTranslator;
import io.durg.kirtimukh.throttling.ThrottlingKey;
import io.durg.kirtimukh.throttling.checker.StrategyChecker;
import io.durg.kirtimukh.throttling.config.ThrottlingStrategyConfig;
import io.durg.kirtimukh.throttling.custom.CustomThrottlingController;
import io.durg.kirtimukh.throttling.enums.ThrottlingStage;
import io.durg.kirtimukh.throttling.exception.ThrottlingException;
import io.durg.kirtimukh.throttling.window.impl.TimedWindowChecker;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public final class ThrottlingManager {
    private static ThrottlingController controller;
    private static ThrottlingExceptionTranslator<? extends RuntimeException> translator;
    private static MetricRegistry metrics;
    private static final String PREFIX = "kirtimukh";
    private static final String BUCKETS = "buckets";
    private static final String COMMANDS = "commands";
    private static final String SEPARATOR = ".";

    public static void initialise(ThrottlingStrategyConfig defaultConfig, Map<String, ThrottlingStrategyConfig> commandConfigs, CustomThrottlingController customThrottlingController, ThrottlingExceptionTranslator<? extends RuntimeException> exceptionTranslator, MetricRegistry metricRegistry) {
        controller = ThrottlingController.builder().defaultConfig(defaultConfig).commandConfigs(commandConfigs).customThrottlingController(customThrottlingController).build();
        translator = exceptionTranslator;
        metrics = metricRegistry;
    }

    public static Map<String, TimedWindowChecker> getInfo() {
        return controller.getInfo();
    }

    public static StrategyChecker register(ThrottlingKey bucketKey) {
        return controller.register(bucketKey);
    }

    public static void translate(ThrottlingException t) {
        ThrottlingExceptionTranslator.translate(translator, t);
    }

    private static void timer(String name, ThrottlingStage stage, Stopwatch stopwatch) {
        Timer timer = metrics.timer(String.join((CharSequence)SEPARATOR, PREFIX, name, stage.getName()));
        if (timer != null) {
            timer.update(stopwatch.elapsed(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        }
    }

    public static void ticker(ThrottlingKey bucketKey, ThrottlingStage stage, Stopwatch stopwatch) {
        if (metrics == null) {
            return;
        }
        if (!Strings.isNullOrEmpty((String)bucketKey.getBucketName())) {
            ThrottlingManager.timer("buckets." + bucketKey.getBucketName(), stage, stopwatch);
        }
        ThrottlingManager.timer("commands." + bucketKey.getCommandName(), stage, stopwatch);
    }

    @Generated
    private ThrottlingManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

