/*
 * Decompiled with CFR 0.152.
 */
package io.durg.kirtimukh.throttling.window.impl;

import io.durg.kirtimukh.throttling.config.ThrottlingStrategyConfig;
import io.durg.kirtimukh.throttling.config.impl.QuotaThrottlingStrategyConfig;
import io.durg.kirtimukh.throttling.enums.ThrottlingStrategyType;
import io.durg.kirtimukh.throttling.enums.ThrottlingWindowUnit;
import io.durg.kirtimukh.throttling.exception.TimedThrottlingException;
import io.durg.kirtimukh.throttling.tick.Tick;
import io.durg.kirtimukh.throttling.tick.impl.LocationTick;
import io.durg.kirtimukh.throttling.window.Window;
import io.durg.kirtimukh.throttling.window.WindowChecker;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedWindowChecker
implements WindowChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TimedWindowChecker.class);
    private static final long MIN_INACTIVE_WINDOWS_TO_CLEAR = 5L;
    private final String commandKey;
    private final ThrottlingStrategyType strategyType;
    private final ThrottlingWindowUnit unit;
    private final int threshold;
    private final long clearAfterInactiveWindows;
    private long prevWindow;
    private long liveWindow;
    private final Window window;

    public TimedWindowChecker(String commandKey, final ThrottlingStrategyConfig strategyConfig) {
        this.commandKey = commandKey;
        this.strategyType = strategyConfig.getType();
        this.unit = strategyConfig.getUnit();
        this.threshold = strategyConfig.getThreshold();
        this.liveWindow = this.getWindow();
        this.clearAfterInactiveWindows = strategyConfig.getType().accept(new ThrottlingStrategyType.Visitor<Long>(){

            @Override
            public Long visitQuota() {
                return ((QuotaThrottlingStrategyConfig)strategyConfig).getWindows();
            }

            @Override
            public Long visitLeakyBucket() {
                return 5L;
            }

            @Override
            public Long visitPriorityBucket() {
                return 5L;
            }

            @Override
            public Long visitCustomStrategy() {
                return null;
            }
        });
        this.window = Window.builder().threshold(this.threshold).build();
    }

    private long getWindow() {
        return this.unit.accept(new ThrottlingWindowUnit.Visitor<Long>(){

            @Override
            public Long visitMillisecond() {
                return System.currentTimeMillis();
            }

            @Override
            public Long visitSecond() {
                return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
            }

            @Override
            public Long visitMinute() {
                return TimeUnit.MILLISECONDS.toMinutes(System.currentTimeMillis());
            }
        });
    }

    private boolean isChangeInWindow() {
        long currentWindow = this.getWindow();
        if (this.liveWindow != currentWindow) {
            this.prevWindow = this.liveWindow;
            this.liveWindow = currentWindow;
            return true;
        }
        return false;
    }

    private boolean isOkayToClear() {
        return this.liveWindow - this.prevWindow >= this.clearAfterInactiveWindows;
    }

    private void precheck() {
        if (this.isChangeInWindow() && this.isOkayToClear()) {
            log.debug("[{}] Clearing bitset", (Object)this.commandKey);
            this.window.clear();
        }
    }

    @Override
    public synchronized boolean release(Tick tick) {
        return this.window.remove(tick.getLocation());
    }

    @Override
    public synchronized Tick acquire() {
        this.precheck();
        int location = this.window.add();
        if (location < 0) {
            throw TimedThrottlingException.builder().commandKey(this.commandKey).strategyType(this.strategyType).cardinality(this.window.cardinality()).unit(this.unit).threshold(this.threshold).message("Threshold limits exhausted").build();
        }
        log.debug("[{}] Cardinality {} allowed limit {}", new Object[]{this.commandKey, this.window.cardinality(), this.threshold});
        return LocationTick.builder().location(location).build();
    }

    @Generated
    public static TimedWindowCheckerBuilder builder() {
        return new TimedWindowCheckerBuilder();
    }

    @Generated
    public static class TimedWindowCheckerBuilder {
        @Generated
        private String commandKey;
        @Generated
        private ThrottlingStrategyConfig strategyConfig;

        @Generated
        TimedWindowCheckerBuilder() {
        }

        @Generated
        public TimedWindowCheckerBuilder commandKey(String commandKey) {
            this.commandKey = commandKey;
            return this;
        }

        @Generated
        public TimedWindowCheckerBuilder strategyConfig(ThrottlingStrategyConfig strategyConfig) {
            this.strategyConfig = strategyConfig;
            return this;
        }

        @Generated
        public TimedWindowChecker build() {
            return new TimedWindowChecker(this.commandKey, this.strategyConfig);
        }

        @Generated
        public String toString() {
            return "TimedWindowChecker.TimedWindowCheckerBuilder(commandKey=" + this.commandKey + ", strategyConfig=" + this.strategyConfig + ")";
        }
    }
}

