/*
 * Decompiled with CFR 0.152.
 */
package io.durg.kirtimukh.dw.demo;

import io.dropwizard.Application;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.durg.kirtimukh.dw.ThrottlingBundle;
import io.durg.kirtimukh.dw.ThrottlingBundleConfiguration;
import io.durg.kirtimukh.dw.demo.AppConfig;
import io.durg.kirtimukh.dw.demo.AppException;
import io.durg.kirtimukh.dw.demo.Evaluator;
import io.durg.kirtimukh.dw.demo.ResponseCode;
import io.durg.kirtimukh.throttling.ThrottlingExceptionTranslator;
import io.durg.kirtimukh.throttling.ThrottlingKey;
import io.durg.kirtimukh.throttling.custom.CustomGatePass;
import io.durg.kirtimukh.throttling.custom.CustomThrottlingController;
import io.durg.kirtimukh.throttling.custom.CustomThrottlingKeyResolver;
import io.durg.kirtimukh.throttling.custom.CustomThrottlingStrategyChecker;
import io.durg.kirtimukh.throttling.custom.CustomThrottlingVerdict;
import io.durg.kirtimukh.throttling.custom.ng.NgThrottlingKeyType;
import io.durg.kirtimukh.throttling.enums.ThrottlingStrategyType;
import io.durg.kirtimukh.throttling.window.impl.CustomThrottlingException;
import java.util.Random;

public class App
extends Application<AppConfig> {
    public void initialize(Bootstrap<AppConfig> bootstrap) {
        bootstrap.addBundle((ConfiguredBundle)new ThrottlingBundle<AppConfig>(){

            protected ThrottlingBundleConfiguration getThrottlingConfiguration(AppConfig appConfig) {
                return appConfig.getThrottlingConfig();
            }

            protected CustomThrottlingController getCustomController() {
                return new CustomThrottlingController(new CustomThrottlingKeyResolver(){
                    final Evaluator evaluator = new Evaluator(){
                        final Random random = new Random();

                        @Override
                        public CustomThrottlingVerdict evaluate(String key) {
                            switch (this.random.nextInt(4)) {
                                case 0: {
                                    return CustomThrottlingVerdict.DENY;
                                }
                                case 1: {
                                    return CustomThrottlingVerdict.WAIT;
                                }
                                case 2: {
                                    return CustomThrottlingVerdict.ACK;
                                }
                            }
                            return CustomThrottlingVerdict.ALLOW;
                        }
                    };

                    public CustomGatePass resolve(ThrottlingKey bucketKey) {
                        return new CustomGatePass((Enum)NgThrottlingKeyType.COMMAND, bucketKey.getConfigName()){

                            public CustomThrottlingVerdict enter() {
                                return evaluator.evaluate(this.getKey());
                            }

                            public long retryAfter() {
                                return 0L;
                            }

                            public void exit() {
                            }
                        };
                    }
                }){

                    public CustomThrottlingStrategyChecker checker(CustomGatePass customGatePass) {
                        return new CustomThrottlingStrategyChecker(customGatePass){

                            public void react(CustomThrottlingVerdict verdict, final CustomGatePass customGatePass) {
                                verdict.accept((CustomThrottlingVerdict.Visitor)new CustomThrottlingVerdict.Visitor<Void>(){

                                    public Void visitAllow() {
                                        return null;
                                    }

                                    public Void visitDeny() {
                                        throw CustomThrottlingException.builder().keyType(customGatePass.getKeyType()).key(customGatePass.getKey()).keyType(customGatePass.getKeyType()).verdict(CustomThrottlingVerdict.DENY).message("Threshold limits exhausted").build();
                                    }

                                    public Void visitWait() {
                                        throw CustomThrottlingException.builder().keyType(customGatePass.getKeyType()).key(customGatePass.getKey()).verdict(CustomThrottlingVerdict.WAIT).retryAfterMs(customGatePass.retryAfter()).graceful(true).message(String.format("Limits exhausted so wait for %s", customGatePass.retryAfter())).build();
                                    }

                                    public Void visitAck() {
                                        throw CustomThrottlingException.builder().keyType(customGatePass.getKeyType()).key(customGatePass.getKey()).verdict(CustomThrottlingVerdict.ACK).graceful(true).message("Limits exhausted but request accepted").build();
                                    }
                                });
                            }
                        };
                    }
                };
            }

            protected ThrottlingExceptionTranslator<AppException> getExceptionTranslator() {
                return e -> (AppException)e.getStrategyType().accept((ThrottlingStrategyType.Visitor)new ThrottlingStrategyType.Visitor<AppException>(){

                    public AppException visitQuota() {
                        return AppException.builder().responseCode(ResponseCode.LIMIT_EXCEEDED).message("Limit Exceeded").build();
                    }

                    public AppException visitLeakyBucket() {
                        return AppException.builder().responseCode(ResponseCode.TOO_MANY_REQUESTS).message("Too Many Requests").build();
                    }

                    public AppException visitPriorityBucket() {
                        return AppException.builder().responseCode(ResponseCode.TEMPORARILY_UNAVAILABLE).message("Temporarily Unavailable").build();
                    }

                    public AppException visitCustomStrategy() {
                        return (AppException)((CustomThrottlingException)e).getVerdict().accept((CustomThrottlingVerdict.Visitor)new CustomThrottlingVerdict.Visitor<AppException>(){

                            public AppException visitAllow() {
                                return null;
                            }

                            public AppException visitDeny() {
                                return AppException.builder().responseCode(ResponseCode.TEMPORARILY_UNAVAILABLE).message("Temporarily Unavailable").build();
                            }

                            public AppException visitWait() {
                                return AppException.builder().responseCode(ResponseCode.TOO_MANY_REQUESTS).message("Too Many Requests").build();
                            }

                            public AppException visitAck() {
                                return AppException.builder().responseCode(ResponseCode.ACCEPTED).message("Request Accepted").build();
                            }
                        });
                    }
                });
            }
        });
    }

    public void run(AppConfig appConfig, Environment environment) throws Exception {
    }
}

