/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.discovery.client.selector;

import com.flipkart.ranger.model.ServiceNode;
import io.appform.dropwizard.discovery.client.selector.RandomWeightedNodeSelector;
import io.appform.dropwizard.discovery.common.ShardInfo;
import io.durg.tsaheylu.metered.ErrorRegistry;
import io.durg.tsaheylu.metered.ServiceEndpoint;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class TsaheyluHealthSelector
extends RandomWeightedNodeSelector {
    private final ErrorRegistry errorRegistry;

    public TsaheyluHealthSelector(ErrorRegistry errorRegistry) {
        this.errorRegistry = errorRegistry;
    }

    @Override
    public ServiceNode<ShardInfo> select(List<ServiceNode<ShardInfo>> list) {
        if (Objects.isNull(this.errorRegistry)) {
            return super.select(list);
        }
        Map<ServiceEndpoint, ServiceNode> map = list.stream().collect(Collectors.toMap(shardServiceNode -> new ServiceEndpoint(shardServiceNode.getPort(), shardServiceNode.getHost(), "http"), shardInfoServiceNode -> shardInfoServiceNode));
        ArrayList<ServiceEndpoint> endpoints = new ArrayList<ServiceEndpoint>(map.keySet());
        List filteredEndpoints = this.errorRegistry.filter(endpoints);
        return super.select(filteredEndpoints.stream().map(e -> (ServiceNode)map.get(e.getServiceEndpoint())).collect(Collectors.toList()));
    }
}

