/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.hystrix.path.tracker.filters.impl;

import com.google.common.base.Strings;
import io.dropwizard.hystrix.path.tracker.hystrix.TrackerCommand;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathTrackerFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(PathTrackerFilter.class);
    private String key;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.key = filterConfig.getInitParameter("commandKey");
        log.info("Setting up PathTrackerFilter, with key:{}" + filterConfig.getInitParameterNames());
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        new TrackerCommand.VoidTracker(this.identifyKey(servletRequest), () -> filterChain.doFilter(servletRequest, servletResponse)).execute();
    }

    public void destroy() {
    }

    public String identifyKey(ServletRequest servletRequest) {
        if (!Strings.isNullOrEmpty((String)this.key)) {
            return this.key;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        String uriPath = httpServletRequest.getRequestURI().split("\\?")[0];
        return this.identifyPath(uriPath);
    }

    private String identifyPath(String requestUri) {
        String[] decomposedApi = StringUtils.split((String)requestUri, (String)"/");
        return decomposedApi[decomposedApi.length - 1];
    }
}

