/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.hystrix.path.tracker.trackers;

import io.dropwizard.hystrix.path.tracker.filters.FilterBuilder;
import io.dropwizard.hystrix.path.tracker.filters.impl.PathTrackerFilter;
import io.dropwizard.hystrix.path.tracker.trackers.TrackPath;
import io.dropwizard.setup.Environment;
import java.beans.ConstructorProperties;
import java.util.UUID;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class RuntimeFeature
implements DynamicFeature {
    private static final Logger log = LoggerFactory.getLogger(RuntimeFeature.class);
    private final Environment environment;

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        TrackPath trackPath = resourceInfo.getResourceMethod().getAnnotation(TrackPath.class);
        if (trackPath != null) {
            Class<PathTrackerFilter> filterClass = PathTrackerFilter.class;
            log.info("Registering filter:{} method:{} key:{} resourcePath:{}", new Object[]{filterClass.getSimpleName(), resourceInfo.getResourceMethod().getName(), trackPath.commandKey(), trackPath.pathRegex()});
            FilterBuilder.newBuilder().addUrlMapping(trackPath.pathRegex()).name(filterClass.getSimpleName() + ":" + UUID.randomUUID().toString()).withClass(filterClass).addInitParam("commandKey", trackPath.commandKey()).build().consume(this.environment);
        }
    }

    @ConstructorProperties(value={"environment"})
    public RuntimeFeature(Environment environment) {
        this.environment = environment;
    }
}

