/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.hystrix.path.tracker.hystrix;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import io.dropwizard.hystrix.path.tracker.util.ERunnable;
import io.dropwizard.hystrix.path.tracker.util.ESupplier;

public class TrackerCommand<T>
extends HystrixCommand<T> {
    private ESupplier<T> supplier;

    public TrackerCommand(String key, ESupplier<T> supplier) {
        super(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)key)).andCommandKey(HystrixCommandKey.Factory.asKey((String)key)).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withCircuitBreakerEnabled(false).withExecutionTimeoutEnabled(false).withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE).withExecutionIsolationSemaphoreMaxConcurrentRequests(Integer.MAX_VALUE).withFallbackIsolationSemaphoreMaxConcurrentRequests(Integer.MAX_VALUE)));
        this.supplier = supplier;
    }

    public TrackerCommand(String key, String group, ESupplier<T> supplier) {
        super(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)group)).andCommandKey(HystrixCommandKey.Factory.asKey((String)key)).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withCircuitBreakerEnabled(false).withExecutionTimeoutEnabled(false).withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE).withExecutionIsolationSemaphoreMaxConcurrentRequests(Integer.MAX_VALUE).withFallbackIsolationSemaphoreMaxConcurrentRequests(Integer.MAX_VALUE)));
        this.supplier = supplier;
    }

    protected T run() throws Exception {
        return this.supplier.get();
    }

    public static class VoidTracker
    extends TrackerCommand<Void> {
        public VoidTracker(String key, ERunnable runnable) {
            super(key, () -> {
                runnable.run();
                return null;
            });
        }
    }
}

