/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.hystrix.path.tracker;

import com.google.common.collect.Lists;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.hystrix.path.tracker.filters.impl.OpsTrackerFilter;
import io.dropwizard.hystrix.path.tracker.trackers.EnvironmentConsumer;
import io.dropwizard.hystrix.path.tracker.trackers.RuntimeFeature;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.List;

public class TrackerBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private List<EnvironmentConsumer> filterSetupCallbacks = Lists.newArrayList();

    public List<EnvironmentConsumer> getFilterSetupCallbacks() {
        return this.filterSetupCallbacks;
    }

    public void initialize(Bootstrap<?> bootstrap) {
        this.filterSetupCallbacks.add(new OpsTrackerFilter());
    }

    public void run(T t, Environment environment) throws Exception {
        this.filterSetupCallbacks.forEach(c -> c.accept(environment));
        environment.jersey().register((Object)new RuntimeFeature(environment));
    }
}

