/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.hystrix.path.tracker.trackers;

import com.google.common.base.Strings;
import io.dropwizard.hystrix.path.tracker.filters.FilterBuilder;
import io.dropwizard.hystrix.path.tracker.filters.impl.NamedPathTrackerFilter;
import io.dropwizard.hystrix.path.tracker.filters.impl.PathTrackerFilter;
import io.dropwizard.hystrix.path.tracker.trackers.TrackPath;
import io.dropwizard.setup.Environment;
import java.beans.ConstructorProperties;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class RuntimeFeature
implements DynamicFeature {
    private static final Logger log = LoggerFactory.getLogger(RuntimeFeature.class);
    private final Environment environment;

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        TrackPath trackPath = resourceInfo.getResourceMethod().getAnnotation(TrackPath.class);
        if (trackPath != null) {
            boolean hasCommandKeyBeenConfigured = Strings.isNullOrEmpty((String)trackPath.commandKey());
            String key = hasCommandKeyBeenConfigured ? resourceInfo.getResourceMethod().getName() : trackPath.commandKey();
            Class filterClass = hasCommandKeyBeenConfigured ? PathTrackerFilter.class : NamedPathTrackerFilter.class;
            String message = "Registering filter: " + filterClass.getSimpleName() + " at method: " + resourceInfo.getResourceMethod().getName() + " against key: " + key + " against resource path: " + trackPath.pathRegex();
            log.info(message);
            FilterBuilder.newBuilder().addUrlMapping(trackPath.pathRegex()).withClass(filterClass).addInitParam("key", key).build().consume(this.environment);
        }
    }

    @ConstructorProperties(value={"environment"})
    public RuntimeFeature(Environment environment) {
        this.environment = environment;
    }
}

